--- src/host/scripts.c.orig	2023-09-20 17:46:05 UTC
+++ src/host/scripts.c
@@ -148,13 +148,13 @@ const char* builtin_scripts[] = {
 	"fg.kind == \"ConsoleApp\") then\nreturn \"Exe\"\nelseif (cfg.kind == \"WindowedApp\") then\nreturn \"WinExe\"\nelseif (cfg.kind == \"SharedLib\") then\nreturn \"Library\"\nend\nend\n",
 
 	/* tools/gcc.lua */
-	"premake.gcc = { }\npremake.gcc.cc     = \"gcc\"\npremake.gcc.cxx    = \"g++\"\npremake.gcc.ar     = \"ar\"\npremake.gcc.rc     = \"windres\"\npremake.gcc.llvm   = false\nlocal cflags =\n{\nEnableSSE        = \"-msse\",\nEnableSSE2       = \"-msse2\",\nEnableAVX        = \"-mavx\",\nEnableAVX2       = \"-mavx2\",\nPedanticWarnings = \"-Wall -Wextra -pedantic\",\nExtraWarnings    = \"-Wall -Wextra\",\nFatalWarnings    = \"-Werror\",\nFloatFast        = \"-ffast-math\",\nFloatStrict      = \"-ffloat-store\",\nNoFramePointer   = \"-fomit-frame-pointer\",\nOptimize         = \"-O2\",\nOptimizeSize     = \"-Os\",\nOptimizeSpeed    = \"-O3\",\nSymbols          = \"-g\",\n}\nlocal cxxflags =\n{\nCpp11        = \"-std=c++11\",\nCpp14        = \"-std=c++14\",\nCpp17        = \"-std=c++17\",\nCpp20        = \"-std=c++20\",\nCppLatest    = \"-std=c++2b\",\nNoExceptions = \"-fno-exceptions\",\nNoRTTI       = \"-fno-rtti\",\nUnsignedChar = \"-funsigned-char\",\n}\nlocal objcflags =\n{\nObjcARC = \"-fobjc-arc\",\n}\npremake."
-	"gcc.platforms =\n{\nNative = {\ncppflags = \"-MMD -MP\",\n},\nx32 = {\ncppflags = \"-MMD -MP\",\nflags    = \"-m32\",\n},\nx64 = {\ncppflags = \"-MMD -MP\",\nflags    = \"-m64\",\n},\nUniversal = {\nar       = \"libtool\",\ncppflags = \"-MMD -MP\",\nflags    = \"-arch i386 -arch x86_64 -arch ppc -arch ppc64\",\n},\nUniversal32 = {\nar       = \"libtool\",\ncppflags = \"-MMD -MP\",\nflags    = \"-arch i386 -arch ppc\",\n},\nUniversal64 = {\nar       = \"libtool\",\ncppflags = \"-MMD -MP\",\nflags    = \"-arch x86_64 -arch ppc64\",\n},\nPS3 = {\ncc         = \"ppu-lv2-g++\",\ncxx        = \"ppu-lv2-g++\",\nar         = \"ppu-lv2-ar\",\ncppflags   = \"-MMD -MP\",\n},\nWiiDev = {\ncppflags    = \"-MMD -MP -I$(LIBOGC_INC) $(MACHDEP)\",\nldflags= \"-L$(LIBOGC_LIB) $(MACHDEP)\",\ncfgsettings = [[\n  ifeq ($(strip $(DEVKITPPC)),)\n    $(error \"DEVKITPPC environment variable is not set\")'\n  endif\n  include $(DEVKITPPC)/wii_rules']],\n},\nOrbis = {\ncc         = \"orbis-clang\",\ncxx        = \"orbis-clang++\",\nar "
-	"        = \"orbis-ar\",\ncppflags   = \"-MMD -MP\",\n},\nEmscripten = {\ncc         = \"$(EMSCRIPTEN)/emcc\",\ncxx        = \"$(EMSCRIPTEN)/em++\",\nar         = \"$(EMSCRIPTEN)/emar\",\ncppflags   = \"-MMD -MP\",\n},\nNX32 = {\ncc         = \"clang\",\ncxx        = \"clang++\",\nar         = \"armv7l-nintendo-nx-eabihf-ar\",\ncppflags   = \"-MMD -MP\",\nflags      = \"-march=armv7l\",\n},\nNX64 = {\ncc         = \"clang\",\ncxx        = \"clang++\",\nar         = \"aarch64-nintendo-nx-elf-ar\",\ncppflags   = \"-MMD -MP\",\nflags      = \"-march=aarch64\",\n},\n}\nlocal platforms = premake.gcc.platforms\nfunction premake.gcc.getcppflags(cfg)\nlocal flags = { }\ntable.insert(flags, platforms[cfg.platform].cppflags)\nif flags[1]:startswith(\"-MMD\") then\ntable.insert(flags, \"-MP\")\nend\nreturn flags\nend\nfunction premake.gcc.getcflags(cfg)\nlocal result = table.translate(cfg.flags, cflags)\ntable.insert(result, platforms[cfg.platform].flags)\nif cfg.system ~= \"windows\" and cfg.kind == \"SharedLib\" then\nt"
-	"able.insert(result, \"-fPIC\")\nend\nreturn result\nend\nfunction premake.gcc.getcxxflags(cfg)\nlocal result = table.translate(cfg.flags, cxxflags)\nreturn result\nend\nfunction premake.gcc.getobjcflags(cfg)\nreturn table.translate(cfg.flags, objcflags)\nend\nfunction premake.gcc.getldflags(cfg)\nlocal result = { }\nif not cfg.flags.Symbols then\nif cfg.system == \"macosx\" then\nelse\ntable.insert(result, \"-s\")\nend\nend\nif cfg.kind == \"Bundle\" then\ntable.insert(result, \"-bundle\")\nend\nif cfg.kind == \"SharedLib\" then\nif cfg.system == \"macosx\" then\ntable.insert(result, \"-dynamiclib\")\nelse\ntable.insert(result, \"-shared\")\nend\nif cfg.system == \"windows\" and not cfg.flags.NoImportLib then\ntable.insert(result, '-Wl,--out-implib=\"' .. cfg.linktarget.fullpath .. '\"')\nend\nend\nif cfg.kind == \"WindowedApp\" and cfg.system == \"windows\" then\ntable.insert(result, \"-mwindows\")\nend\nlocal platform = platforms[cfg.platform]\ntable.insert(result, platform.flags)\ntable.insert(result, platf"
-	"orm.ldflags)\nreturn result\nend\nfunction premake.gcc.getlibdirflags(cfg)\nlocal result = { }\nfor _, value in ipairs(premake.getlinks(cfg, \"all\", \"directory\")) do\ntable.insert(result, '-L\\\"' .. value .. '\\\"')\nend\nreturn result\nend\nfunction premake.gcc.islibfile(p)\nif path.getextension(p) == \".a\" then\nreturn true\nend\nreturn false\nend\nfunction premake.gcc.getlibfiles(cfg)\nlocal result = {}\nfor _, value in ipairs(premake.getlinks(cfg, \"system\", \"fullpath\")) do\nif premake.gcc.islibfile(value) then\ntable.insert(result, _MAKE.esc(value))\nend\nend\nreturn result\nend\nfunction premake.gcc.getlinkflags(cfg)\nlocal result = {}\nfor _, value in ipairs(premake.getlinks(cfg, \"system\", \"fullpath\")) do\nif premake.gcc.islibfile(value) then\nvalue = path.rebase(value, cfg.project.location, cfg.location)\ntable.insert(result, _MAKE.esc(value))\nelseif path.getextension(value) == \".framework\" then\ntable.insert(result, '-framework ' .. _MAKE.esc(path.getbasename(value)))\nelse\ntable.inser"
-	"t(result, '-l' .. _MAKE.esc(path.getname(value)))\nend\nend\nreturn result\nend\nfunction premake.gcc.wholearchive(lib)\nif premake.gcc.llvm then\nreturn {\"-force_load\", lib}\nelseif os.get() == \"macosx\" then\nreturn {\"-Wl,-force_load\", lib}\nelse\nreturn {\"-Wl,--whole-archive\", lib, \"-Wl,--no-whole-archive\"}\nend\nend\nfunction premake.gcc.getarchiveflags(prj, cfg, ndx)\nlocal result = {}\nif cfg.platform:startswith(\"Universal\") then\nif prj.options.ArchiveSplit then\nerror(\"gcc tool 'Universal*' platforms do not support split archives\")\nend\ntable.insert(result, '-o')\nelse\nif (not prj.options.ArchiveSplit) then\nif premake.gcc.llvm then\ntable.insert(result, 'rcs')\nelse\ntable.insert(result, '-rcs')\nend\nelse\nif premake.gcc.llvm then\nif (not ndx) then\ntable.insert(result, 'qc')\nelse\ntable.insert(result, 'cs')\nend\nelse\nif (not ndx) then\ntable.insert(result, '-qc')\nelse\ntable.insert(result, '-cs')\nend\nend\nend\nend\nreturn result\nend\nfunction premake.gcc.getdefines(defines)\nl"
-	"ocal result = { }\nfor _,def in ipairs(defines) do\ntable.insert(result, \"-D\" .. def)\nend\nreturn result\nend\nfunction premake.gcc.getincludedirs(includedirs)\nlocal result = { }\nfor _,dir in ipairs(includedirs) do\ntable.insert(result, \"-I\\\"\" .. dir .. \"\\\"\")\nend\nreturn result\nend\nfunction premake.gcc.getquoteincludedirs(includedirs)\nlocal result = { }\nfor _,dir in ipairs(includedirs) do\ntable.insert(result, \"-iquote \\\"\" .. dir .. \"\\\"\")\nend\nreturn result\nend\nfunction premake.gcc.getsystemincludedirs(includedirs)\nlocal result = { }\nfor _,dir in ipairs(includedirs) do\ntable.insert(result, \"-isystem \\\"\" .. dir .. \"\\\"\")\nend\nreturn result\nend\nfunction premake.gcc.getcfgsettings(cfg)\nreturn platforms[cfg.platform].cfgsettings\nend\n",
+	"premake.gcc = { }\npremake.gcc.cc     = _OPTIONS[\"CC\"]\npremake.gcc.cxx    = _OPTIONS[\"CXX\"]\npremake.gcc.ar     = _OPTIONS[\"AR\"]\npremake.gcc.rc     = \"windres\"\npremake.gcc.llvm   = false\nlocal cflags =\n{\nEnableSSE        = \"-msse\",\nEnableSSE2       = \"-msse2\",\nEnableAVX        = \"-mavx\",\nEnableAVX2       = \"-mavx2\",\nPedanticWarnings = \"-Wall -Wextra -pedantic\",\nExtraWarnings    = \"-Wall -Wextra\",\nFatalWarnings    = \"-Werror\",\nFloatFast        = \"-ffast-math\",\nFloatStrict      = \"-ffloat-store\",\nNoFramePointer   = \"-fomit-frame-pointer\",\nOptimize         = \"\",\nOptimizeSize     = \"-Os\",\nOptimizeSpeed    = \"-O3\",\nSymbols          = \"-g\",\n}\nlocal cxxflags =\n{\nCpp11        = \"-std=c++11\",\nCpp14        = \"-std=c++14\",\nCpp17        = \"-std=c++17\",\nCpp20        = \"-std=c++20\",\nCppLatest    = \"-std=c++2b\",\nNoExceptions = \"-fno-exceptions\",\nNoRTTI       = \"-fno-rtti\",\nUnsignedChar = \"-funsigned-char\",\n}\nlocal objcflags =\n{\nObjcARC = \""
+	"-fobjc-arc\",\n}\npremake.gcc.platforms =\n{\nNative = {\ncppflags = \"-MMD -MP\",\n},\nx32 = {\ncppflags = \"-MMD -MP\",\nflags    = \"-m32\",\n},\nx64 = {\ncppflags = \"-MMD -MP\",\nflags    = \"-m64\",\n},\nUniversal = {\nar       = \"libtool\",\ncppflags = \"-MMD -MP\",\nflags    = \"-arch i386 -arch x86_64 -arch ppc -arch ppc64\",\n},\nUniversal32 = {\nar       = \"libtool\",\ncppflags = \"-MMD -MP\",\nflags    = \"-arch i386 -arch ppc\",\n},\nUniversal64 = {\nar       = \"libtool\",\ncppflags = \"-MMD -MP\",\nflags    = \"-arch x86_64 -arch ppc64\",\n},\nPS3 = {\ncc         = \"ppu-lv2-g++\",\ncxx        = \"ppu-lv2-g++\",\nar         = \"ppu-lv2-ar\",\ncppflags   = \"-MMD -MP\",\n},\nWiiDev = {\ncppflags    = \"-MMD -MP -I$(LIBOGC_INC) $(MACHDEP)\",\nldflags= \"-L$(LIBOGC_LIB) $(MACHDEP)\",\ncfgsettings = [[\n  ifeq ($(strip $(DEVKITPPC)),)\n    $(error \"DEVKITPPC environment variable is not set\")'\n  endif\n  include $(DEVKITPPC)/wii_rules']],\n},\nOrbis = {\ncc         = \"orbis-clang\",\ncxx       "
+	" = \"orbis-clang++\",\nar         = \"orbis-ar\",\ncppflags   = \"-MMD -MP\",\n},\nEmscripten = {\ncc         = \"$(EMSCRIPTEN)/emcc\",\ncxx        = \"$(EMSCRIPTEN)/em++\",\nar         = \"$(EMSCRIPTEN)/emar\",\ncppflags   = \"-MMD -MP\",\n},\nNX32 = {\ncc         = \"clang\",\ncxx        = \"clang++\",\nar         = \"armv7l-nintendo-nx-eabihf-ar\",\ncppflags   = \"-MMD -MP\",\nflags      = \"-march=armv7l\",\n},\nNX64 = {\ncc         = \"clang\",\ncxx        = \"clang++\",\nar         = \"aarch64-nintendo-nx-elf-ar\",\ncppflags   = \"-MMD -MP\",\nflags      = \"-march=aarch64\",\n},\n}\nlocal platforms = premake.gcc.platforms\nfunction premake.gcc.getcppflags(cfg)\nlocal flags = { }\ntable.insert(flags, platforms[cfg.platform].cppflags)\nif flags[1]:startswith(\"-MMD\") then\ntable.insert(flags, \"-MP\")\nend\nreturn flags\nend\nfunction premake.gcc.getcflags(cfg)\nlocal result = table.translate(cfg.flags, cflags)\ntable.insert(result, platforms[cfg.platform].flags)\nif cfg.system ~= \"windows\" and cfg.kin"
+	"d == \"SharedLib\" then\ntable.insert(result, \"-fPIC\")\nend\nreturn result\nend\nfunction premake.gcc.getcxxflags(cfg)\nlocal result = table.translate(cfg.flags, cxxflags)\nreturn result\nend\nfunction premake.gcc.getobjcflags(cfg)\nreturn table.translate(cfg.flags, objcflags)\nend\nfunction premake.gcc.getldflags(cfg)\nlocal result = { }\nif not cfg.flags.Symbols then\nif cfg.system == \"macosx\" then\nelse\ntable.insert(result, \"-s\")\nend\nend\nif cfg.kind == \"Bundle\" then\ntable.insert(result, \"-bundle\")\nend\nif cfg.kind == \"SharedLib\" then\nif cfg.system == \"macosx\" then\ntable.insert(result, \"-dynamiclib\")\nelse\ntable.insert(result, \"-shared\")\nend\nif cfg.system == \"windows\" and not cfg.flags.NoImportLib then\ntable.insert(result, '-Wl,--out-implib=\"' .. cfg.linktarget.fullpath .. '\"')\nend\nend\nif cfg.kind == \"WindowedApp\" and cfg.system == \"windows\" then\ntable.insert(result, \"-mwindows\")\nend\nlocal platform = platforms[cfg.platform]\ntable.insert(result, platform.flags)\n"
+	"table.insert(result, platform.ldflags)\nreturn result\nend\nfunction premake.gcc.getlibdirflags(cfg)\nlocal result = { }\nfor _, value in ipairs(premake.getlinks(cfg, \"all\", \"directory\")) do\ntable.insert(result, '-L\\\"' .. value .. '\\\"')\nend\nreturn result\nend\nfunction premake.gcc.islibfile(p)\nif path.getextension(p) == \".a\" then\nreturn true\nend\nreturn false\nend\nfunction premake.gcc.getlibfiles(cfg)\nlocal result = {}\nfor _, value in ipairs(premake.getlinks(cfg, \"system\", \"fullpath\")) do\nif premake.gcc.islibfile(value) then\ntable.insert(result, _MAKE.esc(value))\nend\nend\nreturn result\nend\nfunction premake.gcc.getlinkflags(cfg)\nlocal result = {}\nfor _, value in ipairs(premake.getlinks(cfg, \"system\", \"fullpath\")) do\nif premake.gcc.islibfile(value) then\nvalue = path.rebase(value, cfg.project.location, cfg.location)\ntable.insert(result, _MAKE.esc(value))\nelseif path.getextension(value) == \".framework\" then\ntable.insert(result, '-framework ' .. _MAKE.esc(path.getbasename(v"
+	"alue)))\nelse\ntable.insert(result, '-l' .. _MAKE.esc(path.getname(value)))\nend\nend\nreturn result\nend\nfunction premake.gcc.wholearchive(lib)\nif premake.gcc.llvm then\nreturn {\"-force_load\", lib}\nelseif os.get() == \"macosx\" then\nreturn {\"-Wl,-force_load\", lib}\nelse\nreturn {\"-Wl,--whole-archive\", lib, \"-Wl,--no-whole-archive\"}\nend\nend\nfunction premake.gcc.getarchiveflags(prj, cfg, ndx)\nlocal result = {}\nif cfg.platform:startswith(\"Universal\") then\nif prj.options.ArchiveSplit then\nerror(\"gcc tool 'Universal*' platforms do not support split archives\")\nend\ntable.insert(result, '-o')\nelse\nif (not prj.options.ArchiveSplit) then\nif premake.gcc.llvm then\ntable.insert(result, 'rcs')\nelse\ntable.insert(result, '-rcs')\nend\nelse\nif premake.gcc.llvm then\nif (not ndx) then\ntable.insert(result, 'qc')\nelse\ntable.insert(result, 'cs')\nend\nelse\nif (not ndx) then\ntable.insert(result, '-qc')\nelse\ntable.insert(result, '-cs')\nend\nend\nend\nend\nreturn result\nend\nfunction premake."
+	"gcc.getdefines(defines)\nlocal result = { }\nfor _,def in ipairs(defines) do\ntable.insert(result, \"-D\" .. def)\nend\nreturn result\nend\nfunction premake.gcc.getincludedirs(includedirs)\nlocal result = { }\nfor _,dir in ipairs(includedirs) do\ntable.insert(result, \"-I\\\"\" .. dir .. \"\\\"\")\nend\nreturn result\nend\nfunction premake.gcc.getquoteincludedirs(includedirs)\nlocal result = { }\nfor _,dir in ipairs(includedirs) do\ntable.insert(result, \"-iquote \\\"\" .. dir .. \"\\\"\")\nend\nreturn result\nend\nfunction premake.gcc.getsystemincludedirs(includedirs)\nlocal result = { }\nfor _,dir in ipairs(includedirs) do\ntable.insert(result, \"-isystem \\\"\" .. dir .. \"\\\"\")\nend\nreturn result\nend\nfunction premake.gcc.getcfgsettings(cfg)\nreturn platforms[cfg.platform].cfgsettings\nend\n",
 
 	/* tools/ghs.lua */
 	"premake.ghs = { }\npremake.ghs.namestyle = \"PS3\"\npremake.ghs.cc     = \"ccppc\"\npremake.ghs.cxx    = \"cxppc\"\npremake.ghs.ar     = \"cxppc\"\nlocal cflags =\n{\nFatalWarnings  = \"--quit_after_warnings\",\nOptimize       = \"-Ogeneral\",\nOptimizeSize   = \"-Osize\",\nOptimizeSpeed  = \"-Ospeed\",\nSymbols        = \"-g\",\n}\nlocal cxxflags =\n{\nNoExceptions   = \"--no_exceptions\",\nNoRTTI         = \"--no_rtti\",\nUnsignedChar   = \"--unsigned_chars\",\n}\npremake.ghs.platforms =\n{\nNative = {\ncppflags = \"-MMD\",\n},\nPowerPC = {\ncc         = \"ccppc\",\ncxx       = \"cxppc\",\nar       = \"cxppc\",\ncppflags   = \"-MMD\",\narflags    = \"-archive -o\",\n},\nARM = {\ncc         = \"ccarm\",\ncxx        = \"cxarm\",\nar         = \"cxarm\",\ncppflags   = \"-MMD\",\narflags    = \"-archive -o\",\n}\n}\nlocal platforms = premake.ghs.platforms\nfunction premake.ghs.getcppflags(cfg)\nlocal flags = { }\ntable.insert(flags, platforms[cfg.platform].cppflags)\nreturn flags\nend\nfunction premake.ghs.getcf"
@@ -237,19 +237,18 @@ const char* builtin_scripts[] = {
 	"URCES) $(OBJRESP) $(LDRESP) | $(TARGETDIR) $(OBJDIRS)')\nif prj.kind == \"StaticLib\" then\nif prj.msgarchiving then\n_p('\\t@echo ' .. prj.msgarchiving)\nelse\n_p('\\t@echo Archiving %s', prj.name)\nend\nif (not prj.archivesplit_size) then\nprj.archivesplit_size=200\nend\nif (not prj.options.ArchiveSplit) then\n_p('ifeq (posix,$(SHELLTYPE))')\n_p('\\t$(SILENT) rm -f  $(TARGET)')\n_p('else')\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,$(TARGET)) del $(subst /,\\\\\\\\,$(TARGET))')\n_p('endif')\n_p('\\t$(SILENT) $(LINKCMD) $(LINKOBJS)' .. (os.is(\"MacOSX\") and \" 2>&1 > /dev/null | sed -e '/.o) has no symbols$$/d'\" or \"\"))\nelse\n_p('\\t$(call RM,$(TARGET))')\n_p('\\t@$(call max_args,$(LINKCMD),'.. prj.archivesplit_size ..',$(LINKOBJS))' .. (os.is(\"MacOSX\") and \" 2>&1 > /dev/null | sed -e '/.o) has no symbols$$/d'\" or \"\"))\n_p('\\t$(SILENT) $(LINKCMD_NDX)')\nend\nelse\nif prj.msglinking then\n_p('\\t@echo ' .. prj.msglinking)\nelse\n_p('\\t@echo Linking %s', prj.name)\nend\n_p('\\t$(SILENT) $(LINKCM"
 	"D)')\nend\n_p('\\t$(POSTBUILDCMDS)')\n_p('')\n_p('$(TARGETDIR):')\npremake.make_mkdirrule(\"$(TARGETDIR)\")\n_p('$(OBJDIRS):')\nif (not prj.solution.messageskip) or (not table.contains(prj.solution.messageskip, \"SkipCreatingMessage\")) then\n_p('\\t@echo Creating $(@)')\nend\n_p('\\t-$(call MKDIR,$@)')\n_p('')\nif os.is(\"MacOSX\") and prj.kind == \"WindowedApp\" and not prj.options.SkipBundling then\n_p('$(dir $(TARGETDIR))PkgInfo:')\n_p('$(dir $(TARGETDIR))Info.plist:')\n_p('')\nend\n_p('clean:')\nif (not prj.solution.messageskip) or (not table.contains(prj.solution.messageskip, \"SkipCleaningMessage\")) then\n_p('\\t@echo Cleaning %s', prj.name)\nend\n_p('ifeq (posix,$(SHELLTYPE))')\n_p('\\t$(SILENT) rm -f  $(TARGET)')\n_p('\\t$(SILENT) rm -rf $(OBJDIR)')\n_p('else')\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,$(TARGET)) del $(subst /,\\\\\\\\,$(TARGET))')\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,$(OBJDIR)) rmdir /s /q $(subst /,\\\\\\\\,$(OBJDIR))')\n_p('endif')\n_p('')\n_p('prebuild:')\n_p('\\t$(P"
 	"REBUILDCMDS)')\n_p('')\n_p('prelink:')\n_p('\\t$(PRELINKCMDS)')\n_p('')\ncpp.pchrules(prj)\ncpp.fileRules(prj, cc)\ncpp.dependencyRules(prj)\nfor _, custombuildtask in ipairs(prj.custombuildtask or {}) do\nfor _, buildtask in ipairs(custombuildtask or {}) do\nlocal deps =  string.format(\"%s \",path.getrelative(prj.location,buildtask[1]))\nfor _, depdata in ipairs(buildtask[3] or {}) do\ndeps = deps .. string.format(\"%s \",path.getrelative(prj.location,depdata))\nend\n_p('%s: %s | $(TARGETDIR) $(OBJDIRS)'\n,path.getrelative(prj.location,buildtask[2])\n, deps\n)\nfor _, cmdline in ipairs(buildtask[4] or {}) do\nlocal cmd = cmdline\nlocal num = 1\nfor _, depdata in ipairs(buildtask[3] or {}) do\ncmd = string.gsub(cmd,\"%$%(\" .. num ..\"%)\", string.format(\"%s \",path.getrelative(prj.location,depdata)))\nnum = num + 1\nend\ncmd = string.gsub(cmd, \"%$%(<%)\", \"$<\")\ncmd = string.gsub(cmd, \"%$%(@%)\", \"$@\")\n_p('\\t$(SILENT) %s',cmd)\nend\n_p('')\nend\nend\n_p('-include $(OBJECTS:%%.o=%%.d)')\n_p('ifneq (,"
-	"$(PCH))')\n_p('  -include $(OBJDIR)/$(notdir $(PCH)).d')\n_p('  -include $(OBJDIR)/$(notdir $(PCH))_objc.d')\n_p('endif')\nend\nfunction premake.gmake_cpp_header(prj, cc, platforms)\n_p('# %s project makefile autogenerated by GENie', premake.action.current().shortname)\n_p('')\n_p('.SUFFIXES:') -- Delete the default suffix rules.\n_p('')\n_p('ifndef config')\n_p('  config=%s', _MAKE.esc(premake.getconfigname(prj.solution.configurations[1], platforms[1], true)))\n_p('endif')\n_p('')\n_p('ifndef verbose')\n_p('  SILENT = @')\n_p('endif')\n_p('')\n_p('SHELLTYPE := msdos')\n_p('ifeq (,$(ComSpec)$(COMSPEC))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p('ifeq (/bin,$(findstring /bin,$(SHELL)))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p('ifeq (/bin,$(findstring /bin,$(MAKESHELL)))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p('')\n_p('ifeq (posix,$(SHELLTYPE))')\n_p('  MKDIR = $(SILENT) mkdir -p \"$(1)\"')\n_p('  COPY  = $(SILENT) cp -fR \"$(1)\" \"$(2)\"')\n_p('  RM    = $(SILENT) rm -f \"$(1)\"')\n_p('else')"
-	"\n_p('  MKDIR = $(SILENT) mkdir \"$(subst /,\\\\\\\\,$(1))\" 2> nul || exit 0')\n_p('  COPY  = $(SILENT) copy /Y \"$(subst /,\\\\\\\\,$(1))\" \"$(subst /,\\\\\\\\,$(2))\"')\n_p('  RM    = $(SILENT) del /F \"$(subst /,\\\\\\\\,$(1))\" 2> nul || exit 0')\n_p('endif')\n_p('')\n_p('CC  = %s', cc.cc)\n_p('CXX = %s', cc.cxx)\n_p('AR  = %s', cc.ar)\n_p('')\n_p('ifndef RESCOMP')\n_p('  ifdef WINDRES')\n_p('    RESCOMP = $(WINDRES)')\n_p('  else')\n_p('    RESCOMP = %s', cc.rc or 'windres')\n_p('  endif')\n_p('endif')\n_p('')\nif (not premake.make.makefile_ignore) then\n_p('MAKEFILE = %s', _MAKE.getmakefilename(prj, true))\n_p('')\nend\nend\nlocal function is_excluded(prj, cfg, file)\nif table.icontains(prj.excludes, file) then\nreturn true\nend\nif table.icontains(cfg.excludes, file) then\nreturn true\nend\nreturn false\nend\nfunction premake.gmake_cpp_configs(prj, cc, platforms)\nfor _, platform in ipairs(platforms) do\nfor cfg in premake.eachconfig(prj, platform) do\npremake.gmake_cpp_config(prj, cfg, cc)\nend\nend"
-	"\nend\nfunction premake.gmake_cpp_config(prj, cfg, cc)\n_p('ifeq ($(config),%s)', _MAKE.esc(cfg.shortname))\ncpp.platformtools(cfg, cc)\nlocal targetDir = _MAKE.esc(cfg.buildtarget.directory)\n_p('  ' .. (table.contains(premake.make.override,\"OBJDIR\") and \"override \" or \"\") ..    'OBJDIR              = %s', _MAKE.esc(cfg.objectsdir))\n_p('  ' .. (table.contains(premake.make.override,\"TARGETDIR\") and \"override \" or \"\") .. 'TARGETDIR           = %s', iif(targetDir == \"\", \".\", targetDir))\n_p('  ' .. (table.contains(premake.make.override,\"TARGET\") and \"override \" or \"\") ..    'TARGET              = $(TARGETDIR)/%s', _MAKE.esc(cfg.buildtarget.name))\n_p('  DEFINES            +=%s', make.list(_MAKE.escquote(cc.getdefines(cfg.defines))))\nlocal id  = make.list(cc.getincludedirs(cfg.includedirs));\nlocal uid = make.list(cc.getquoteincludedirs(cfg.userincludedirs))\nlocal sid = make.list(cc.getsystemincludedirs(cfg.systemincludedirs))\nif id ~= \"\" then\n_p('  INCLUDES           +=%s', id)\nend"
-	"\nif uid ~= \"\" then\n_p('  INCLUDES           +=%s', uid)\nend\nif sid ~= \"\" then\n_p('  INCLUDES           +=%s', sid)\nend\ncpp.pchconfig(cfg)\ncpp.flags(cfg, cc)\ncpp.linker(prj, cfg, cc)\ntable.sort(cfg.files)\nif cfg.flags.UseObjectResponseFile then\n_p('  OBJRESP             = $(OBJDIR)/%s_objects', prj.name)\nelse\n_p('  OBJRESP             =')\nend\n_p('  OBJECTS := \\\\')\nfor _, file in ipairs(cfg.files) do\nif path.issourcefile(file) then\nif not is_excluded(prj, cfg, file) then\n_p('\\t$(OBJDIR)/%s.o \\\\'\n, _MAKE.esc(path.trimdots(path.removeext(file)))\n)\nend\nend\nend\n_p('')\n_p('  define PREBUILDCMDS')\nif #cfg.prebuildcommands > 0 then\n_p('\\t@echo Running pre-build commands')\n_p('\\t%s', table.implode(cfg.prebuildcommands, \"\", \"\", \"\\n\\t\"))\nend\n_p('  endef')\n_p('  define PRELINKCMDS')\nif #cfg.prelinkcommands > 0 then\n_p('\\t@echo Running pre-link commands')\n_p('\\t%s', table.implode(cfg.prelinkcommands, \"\", \"\", \"\\n\\t\"))\nend\n_p('  endef')\n_p('  define POSTBUILD"
-	"CMDS')\nif #cfg.postbuildcommands > 0 then\n_p('\\t@echo Running post-build commands')\n_p('\\t%s', table.implode(cfg.postbuildcommands, \"\", \"\", \"\\n\\t\"))\nend\n_p('  endef')\nmake.settings(cfg, cc)\n_p('endif')\n_p('')\nend\nfunction cpp.platformtools(cfg, cc)\nlocal platform = cc.platforms[cfg.platform]\nif platform.cc then\n_p('  CC         = %s', platform.cc)\nend\nif platform.cxx then\n_p('  CXX        = %s', platform.cxx)\nend\nif platform.ar then\n_p('  AR         = %s', platform.ar)\nend\nend\nfunction cpp.flags(cfg, cc)\nif cfg.pchheader and not cfg.flags.NoPCH then\n_p('  FORCE_INCLUDE      += -include $(OBJDIR)/$(notdir $(PCH))')\n_p('  FORCE_INCLUDE_OBJC += -include $(OBJDIR)/$(notdir $(PCH))_objc')\nend\nif #cfg.forcedincludes > 0 then\n_p('  FORCE_INCLUDE      += -include %s'\n,_MAKE.esc(table.concat(cfg.forcedincludes, \";\")))\nend\n_p('  ALL_CPPFLAGS       += $(CPPFLAGS) %s $(DEFINES) $(INCLUDES)', table.concat(cc.getcppflags(cfg), \" \"))\n_p('  ALL_ASMFLAGS       += $(ASMFLAGS) $(CFLA"
-	"GS) $(ALL_CPPFLAGS) $(ARCH)%s', make.list(table.join(cc.getcflags(cfg), cfg.buildoptions, cfg.buildoptions_asm)))\n_p('  ALL_CFLAGS         += $(CFLAGS) $(ALL_CPPFLAGS) $(ARCH)%s', make.list(table.join(cc.getcflags(cfg), cfg.buildoptions, cfg.buildoptions_c)))\n_p('  ALL_CXXFLAGS       += $(CXXFLAGS) $(CFLAGS) $(ALL_CPPFLAGS) $(ARCH)%s', make.list(table.join(cc.getcflags(cfg), cc.getcxxflags(cfg), cfg.buildoptions, cfg.buildoptions_cpp)))\n_p('  ALL_OBJCFLAGS      += $(CFLAGS) $(ALL_CPPFLAGS) $(ARCH)%s', make.list(table.join(cc.getcflags(cfg), cc.getobjcflags(cfg), cfg.buildoptions, cfg.buildoptions_objc)))\n_p('  ALL_OBJCPPFLAGS    += $(CXXFLAGS) $(CFLAGS) $(ALL_CPPFLAGS) $(ARCH)%s', make.list(table.join(cc.getcflags(cfg), cc.getcxxflags(cfg), cc.getobjcflags(cfg), cfg.buildoptions, cfg.buildoptions_objcpp)))\n_p('  ALL_RESFLAGS       += $(RESFLAGS) $(DEFINES) $(INCLUDES)%s',\n        make.list(table.join(cc.getdefines(cfg.resdefines),\n                                cc.getincludedirs(cfg.resincludedirs), cf"
-	"g.resoptions)))\nend\nfunction cpp.linker(prj, cfg, cc)\nlocal libdeps\nlocal lddeps\nif #cfg.wholearchive > 0 then\nlibdeps = {}\nlddeps  = {}\nfor _, linkcfg in ipairs(premake.getlinks(cfg, \"siblings\", \"object\")) do\nlocal linkpath = path.rebase(linkcfg.linktarget.fullpath, linkcfg.location, cfg.location)\nif table.icontains(cfg.wholearchive, linkcfg.project.name) then\nlddeps = table.join(lddeps, cc.wholearchive(linkpath))\nelse\ntable.insert(lddeps, linkpath)\nend\ntable.insert(libdeps, linkpath)\nend\nlibdeps = make.list(_MAKE.esc(libdeps))\nlddeps  = make.list(_MAKE.esc(lddeps))\nelse\nlibdeps = make.list(_MAKE.esc(premake.getlinks(cfg, \"siblings\", \"fullpath\")))\nlddeps  = libdeps\nend\n_p('  ALL_LDFLAGS        += $(LDFLAGS)%s', make.list(table.join(cc.getlibdirflags(cfg), cc.getldflags(cfg), cfg.linkoptions)))\n_p('  LIBDEPS            +=%s', libdeps)\n_p('  LDDEPS             +=%s', lddeps)\nif cfg.flags.UseLDResponseFile then\n_p('  LDRESP              = $(OBJDIR)/%s_libs', prj.name)\n_p('  LI"
-	"BS               += @$(LDRESP)%s', make.list(cc.getlinkflags(cfg)))\nelse\n_p('  LDRESP              =')\n_p('  LIBS               += $(LDDEPS)%s', make.list(cc.getlinkflags(cfg)))\nend\n_p('  EXTERNAL_LIBS      +=%s', make.list(cc.getlibfiles(cfg)))\n_p('  LINKOBJS            = %s', (cfg.flags.UseObjectResponseFile and \"@$(OBJRESP)\" or \"$(OBJECTS)\"))\nif cfg.kind == \"StaticLib\" then\nif (not prj.options.ArchiveSplit) then\n_p('  LINKCMD             = $(AR) %s $(TARGET)', make.list(cc.getarchiveflags(prj, cfg, false)))\nelse\n_p('  LINKCMD             = $(AR) %s $(TARGET)', make.list(cc.getarchiveflags(prj, cfg, false)))\n_p('  LINKCMD_NDX         = $(AR) %s $(TARGET)', make.list(cc.getarchiveflags(prj, cfg, true)))\nend\nelse\nlocal tool = iif(cfg.language == \"C\", \"CC\", \"CXX\")\nlocal startgroup = ''\nlocal endgroup = ''\nif (cfg.flags.LinkSupportCircularDependencies) then\nstartgroup = '-Wl,--start-group '\nendgroup   = ' -Wl,--end-group'\nend\n_p('  LINKCMD             = $(%s) -o $(TARGET) $(LINK"
-	"OBJS) $(RESOURCES) $(ARCH) $(ALL_LDFLAGS) %s$(LIBS)%s', tool, startgroup, endgroup)\nend\nend\nfunction cpp.pchconfig(cfg)\nif not cfg.pchheader or cfg.flags.NoPCH then\nreturn\nend\nlocal pch = cfg.pchheader\nfor _, incdir in ipairs(cfg.includedirs) do\nlocal abspath = path.getabsolute(path.join(cfg.project.location, incdir))\nlocal testname = path.join(abspath, pch)\nif os.isfile(testname) then\npch = path.getrelative(cfg.location, testname)\nbreak\nend\nend\n_p('  PCH                 = %s', _MAKE.esc(pch))\n_p('  GCH                 = $(OBJDIR)/$(notdir $(PCH)).gch')\n_p('  GCH_OBJC            = $(OBJDIR)/$(notdir $(PCH))_objc.gch')\nend\nfunction cpp.pchrules(prj)\n_p('ifneq (,$(PCH))')\n_p('$(GCH): $(PCH) $(MAKEFILE) | $(OBJDIR)')\nif prj.msgprecompile then\n_p('\\t@echo ' .. prj.msgprecompile)\nelse\n_p('\\t@echo $(notdir $<)')\nend\nlocal cmd = iif(prj.language == \"C\", \"$(CC) $(ALL_CFLAGS) -x c-header\", \"$(CXX) $(ALL_CXXFLAGS) -x c++-header\")\n_p('\\t$(SILENT) %s $(DEFINES) $(INCLUDES) -o \"$@\" -"
-	"c \"$<\"', cmd)\n_p('')\n_p('$(GCH_OBJC): $(PCH) $(MAKEFILE) | $(OBJDIR)')\nif prj.msgprecompile then\n_p('\\t@echo ' .. prj.msgprecompile)\nelse\n_p('\\t@echo $(notdir $<)')\nend\nlocal cmd = iif(prj.language == \"C\", \"$(CC) $(ALL_OBJCFLAGS) -x objective-c-header\", \"$(CXX) $(ALL_OBJCPPFLAGS) -x objective-c++-header\")\n_p('\\t$(SILENT) %s $(DEFINES) $(INCLUDES) -o \"$@\" -c \"$<\"', cmd)\n_p('endif')\n_p('')\nend\nfunction cpp.fileRules(prj, cc)\nlocal platforms = premake.filterplatforms(prj.solution, cc.platforms, \"Native\")\n_p('ifneq (,$(OBJRESP))')\n_p('$(OBJRESP): $(OBJECTS) | $(TARGETDIR) $(OBJDIRS)')\n_p('\\t$(SILENT) echo $^')\n_p('\\t$(SILENT) echo $^ > $@')\n_p('endif')\n_p('')\n_p('ifneq (,$(LDRESP))')\n_p('$(LDRESP): $(LDDEPS) | $(TARGETDIR) $(OBJDIRS)')\n_p('\\t$(SILENT) echo $^')\n_p('\\t$(SILENT) echo $^ > $@')\n_p('endif')\n_p('')\ntable.sort(prj.allfiles)\nfor _, file in ipairs(prj.allfiles or {}) do\nif path.issourcefile(file) then\nif (path.isobjcfile(file)) then\n_p('$(OBJDIR)/%s.o: %"
-	"s $(GCH_OBJC) $(MAKEFILE) | $(OBJDIR)/%s'\n, _MAKE.esc(path.trimdots(path.removeext(file)))\n, _MAKE.esc(file)\n, _MAKE.esc(path.getdirectory(path.trimdots(file)))\n)\nelse\n_p('$(OBJDIR)/%s.o: %s $(GCH) $(MAKEFILE) | $(OBJDIR)/%s'\n, _MAKE.esc(path.trimdots(path.removeext(file)))\n, _MAKE.esc(file)\n, _MAKE.esc(path.getdirectory(path.trimdots(file)))\n)\nend\nif (path.isobjcfile(file) and prj.msgcompile_objc) then\n_p('\\t@echo ' .. prj.msgcompile_objc)\nelseif prj.msgcompile then\n_p('\\t@echo ' .. prj.msgcompile)\nelse\n_p('\\t@echo $(notdir $<)')\nend\nif (path.isobjcfile(file)) then\nif (path.iscfile(file)) then\n_p('\\t$(SILENT) $(CXX) $(ALL_OBJCFLAGS) $(FORCE_INCLUDE_OBJC) -o \"$@\" -c \"$<\"')\nelse\n_p('\\t$(SILENT) $(CXX) $(ALL_OBJCPPFLAGS) $(FORCE_INCLUDE_OBJC) -o \"$@\" -c \"$<\"')\nend\nelseif (path.isasmfile(file)) then\n_p('\\t$(SILENT) $(CC) $(ALL_ASMFLAGS) -o \"$@\" -c \"$<\"')\nelse\ncpp.buildcommand(path.iscfile(file) and not prj.options.ForceCPP, \"o\")\nend\nfor _, task in ipairs(prj.postc"
-	"ompiletasks or {}) do\n_p('\\t$(SILENT) %s', task)\n_p('')\nend\n_p('')\nelseif (path.getextension(file) == \".rc\") then\n_p('$(OBJDIR)/%s.res: %s', _MAKE.esc(path.getbasename(file)), _MAKE.esc(file))\nif prj.msgresource then\n_p('\\t@echo ' .. prj.msgresource)\nelse\n_p('\\t@echo $(notdir $<)')\nend\n_p('\\t$(SILENT) $(RESCOMP) $< -O coff -o \"$@\" $(ALL_RESFLAGS)')\n_p('')\nend\nend\nend\nfunction cpp.dependencyRules(prj)\nfor _, dependency in ipairs(prj.dependency or {}) do\nfor _, dep in ipairs(dependency or {}) do\nif (dep[3]==nil or dep[3]==false) then\n_p('$(OBJDIR)/%s.o: %s'\n, _MAKE.esc(path.trimdots(path.removeext(path.getrelative(prj.location, dep[1]))))\n, _MAKE.esc(path.getrelative(prj.location, dep[2]))\n)\nelse\n_p('%s: %s'\n, _MAKE.esc(dep[1])\n, _MAKE.esc(path.getrelative(prj.location, dep[2]))\n)\nend\n_p('')\nend\nend\nend\nfunction cpp.buildcommand(iscfile, objext)\nlocal flags = iif(iscfile, '$(CC) $(ALL_CFLAGS)', '$(CXX) $(ALL_CXXFLAGS)')\n_p('\\t$(SILENT) %s $(FORCE_INCLUDE) -o \"$@\" -"
-	"c \"$<\"', flags, objext)\nend\n",
+	"$(PCH))')\n_p('  -include $(OBJDIR)/$(notdir $(PCH)).d')\n_p('  -include $(OBJDIR)/$(notdir $(PCH))_objc.d')\n_p('endif')\nend\nfunction premake.gmake_cpp_header(prj, cc, platforms)\n_p('# %s project makefile autogenerated by GENie', premake.action.current().shortname)\n_p('')\n_p('.SUFFIXES:') -- Delete the default suffix rules.\n_p('')\n_p('ifndef config')\n_p('  config=%s', _MAKE.esc(premake.getconfigname(prj.solution.configurations[1], platforms[1], true)))\n_p('endif')\n_p('')\n_p('verbose=1')\n_p('SILENT =')\n_p('')\n_p('SHELLTYPE := msdos')\n_p('ifeq (,$(ComSpec)$(COMSPEC))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p('ifeq (/bin,$(findstring /bin,$(SHELL)))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p('ifeq (/bin,$(findstring /bin,$(MAKESHELL)))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p('')\n_p('ifeq (posix,$(SHELLTYPE))')\n_p('  MKDIR = $(SILENT) mkdir -p \"$(1)\"')\n_p('  COPY  = $(SILENT) cp -fR \"$(1)\" \"$(2)\"')\n_p('  RM    = $(SILENT) rm -f \"$(1)\"')\n_p('else')\n_p('  MKDIR = $(SILEN"
+	"T) mkdir \"$(subst /,\\\\\\\\,$(1))\" 2> nul || exit 0')\n_p('  COPY  = $(SILENT) copy /Y \"$(subst /,\\\\\\\\,$(1))\" \"$(subst /,\\\\\\\\,$(2))\"')\n_p('  RM    = $(SILENT) del /F \"$(subst /,\\\\\\\\,$(1))\" 2> nul || exit 0')\n_p('endif')\n_p('')\n_p('ifndef RESCOMP')\n_p('  ifdef WINDRES')\n_p('    RESCOMP = $(WINDRES)')\n_p('  else')\n_p('    RESCOMP = %s', cc.rc or 'windres')\n_p('  endif')\n_p('endif')\n_p('')\nif (not premake.make.makefile_ignore) then\n_p('MAKEFILE = %s', _MAKE.getmakefilename(prj, true))\n_p('')\nend\nend\nlocal function is_excluded(prj, cfg, file)\nif table.icontains(prj.excludes, file) then\nreturn true\nend\nif table.icontains(cfg.excludes, file) then\nreturn true\nend\nreturn false\nend\nfunction premake.gmake_cpp_configs(prj, cc, platforms)\nfor _, platform in ipairs(platforms) do\nfor cfg in premake.eachconfig(prj, platform) do\npremake.gmake_cpp_config(prj, cfg, cc)\nend\nend\nend\nfunction premake.gmake_cpp_config(prj, cfg, cc)\n_p('ifeq ($(config),%s)', _MAKE.esc(cfg.shortn"
+	"ame))\ncpp.platformtools(cfg, cc)\nlocal targetDir = _MAKE.esc(cfg.buildtarget.directory)\n_p('  ' .. (table.contains(premake.make.override,\"OBJDIR\") and \"override \" or \"\") ..    'OBJDIR              = %s', _MAKE.esc(cfg.objectsdir))\n_p('  ' .. (table.contains(premake.make.override,\"TARGETDIR\") and \"override \" or \"\") .. 'TARGETDIR           = %s', iif(targetDir == \"\", \".\", targetDir))\n_p('  ' .. (table.contains(premake.make.override,\"TARGET\") and \"override \" or \"\") ..    'TARGET              = $(TARGETDIR)/%s', _MAKE.esc(cfg.buildtarget.name))\n_p('  DEFINES            +=%s', make.list(_MAKE.escquote(cc.getdefines(cfg.defines))))\nlocal id  = make.list(cc.getincludedirs(cfg.includedirs));\nlocal uid = make.list(cc.getquoteincludedirs(cfg.userincludedirs))\nlocal sid = make.list(cc.getsystemincludedirs(cfg.systemincludedirs))\nif id ~= \"\" then\n_p('  INCLUDES           +=%s', id)\nend\nif uid ~= \"\" then\n_p('  INCLUDES           +=%s', uid)\nend\nif sid ~= \"\" then\n_p('  INCLUDES  "
+	"         +=%s', sid)\nend\ncpp.pchconfig(cfg)\ncpp.flags(cfg, cc)\ncpp.linker(prj, cfg, cc)\ntable.sort(cfg.files)\nif cfg.flags.UseObjectResponseFile then\n_p('  OBJRESP             = $(OBJDIR)/%s_objects', prj.name)\nelse\n_p('  OBJRESP             =')\nend\n_p('  OBJECTS := \\\\')\nfor _, file in ipairs(cfg.files) do\nif path.issourcefile(file) then\nif not is_excluded(prj, cfg, file) then\n_p('\\t$(OBJDIR)/%s.o \\\\'\n, _MAKE.esc(path.trimdots(path.removeext(file)))\n)\nend\nend\nend\n_p('')\n_p('  define PREBUILDCMDS')\nif #cfg.prebuildcommands > 0 then\n_p('\\t@echo Running pre-build commands')\n_p('\\t%s', table.implode(cfg.prebuildcommands, \"\", \"\", \"\\n\\t\"))\nend\n_p('  endef')\n_p('  define PRELINKCMDS')\nif #cfg.prelinkcommands > 0 then\n_p('\\t@echo Running pre-link commands')\n_p('\\t%s', table.implode(cfg.prelinkcommands, \"\", \"\", \"\\n\\t\"))\nend\n_p('  endef')\n_p('  define POSTBUILDCMDS')\nif #cfg.postbuildcommands > 0 then\n_p('\\t@echo Running post-build commands')\n_p('\\t%s', tab"
+	"le.implode(cfg.postbuildcommands, \"\", \"\", \"\\n\\t\"))\nend\n_p('  endef')\nmake.settings(cfg, cc)\n_p('endif')\n_p('')\nend\nfunction cpp.platformtools(cfg, cc)\nlocal platform = cc.platforms[cfg.platform]\nif platform.cc then\n_p('  CC         = %s', platform.cc)\nend\nif platform.cxx then\n_p('  CXX        = %s', platform.cxx)\nend\nif platform.ar then\n_p('  AR         = %s', platform.ar)\nend\nend\nfunction cpp.flags(cfg, cc)\nif cfg.pchheader and not cfg.flags.NoPCH then\n_p('  FORCE_INCLUDE      += -include $(OBJDIR)/$(notdir $(PCH))')\n_p('  FORCE_INCLUDE_OBJC += -include $(OBJDIR)/$(notdir $(PCH))_objc')\nend\nif #cfg.forcedincludes > 0 then\n_p('  FORCE_INCLUDE      += -include %s'\n,_MAKE.esc(table.concat(cfg.forcedincludes, \";\")))\nend\n_p('  ALL_CPPFLAGS       += $(CPPFLAGS) %s $(DEFINES) $(INCLUDES)', table.concat(cc.getcppflags(cfg), \" \"))\n_p('  ALL_ASMFLAGS       += $(ASMFLAGS) $(CFLAGS) $(ALL_CPPFLAGS) %s', make.list(table.join(cc.getcflags(cfg), cfg.buildoptions, cfg.buildoptions_asm"
+	")))\n_p('  ALL_CFLAGS         += $(CFLAGS) $(ALL_CPPFLAGS) %s', make.list(table.join(cc.getcflags(cfg), cfg.buildoptions, cfg.buildoptions_c)))\n_p('  ALL_CXXFLAGS       += $(CXXFLAGS) $(CFLAGS) $(ALL_CPPFLAGS) %s', make.list(table.join(cc.getcflags(cfg), cc.getcxxflags(cfg), cfg.buildoptions, cfg.buildoptions_cpp)))\n_p('  ALL_OBJCFLAGS      += $(CFLAGS) $(ALL_CPPFLAGS) %s', make.list(table.join(cc.getcflags(cfg), cc.getobjcflags(cfg), cfg.buildoptions, cfg.buildoptions_objc)))\n_p('  ALL_OBJCPPFLAGS    += $(CXXFLAGS) $(CFLAGS) $(ALL_CPPFLAGS) %s', make.list(table.join(cc.getcflags(cfg), cc.getcxxflags(cfg), cc.getobjcflags(cfg), cfg.buildoptions, cfg.buildoptions_objcpp)))\n_p('  ALL_RESFLAGS       += $(RESFLAGS) $(DEFINES) $(INCLUDES)%s',\n        make.list(table.join(cc.getdefines(cfg.resdefines),\n                                cc.getincludedirs(cfg.resincludedirs), cfg.resoptions)))\nend\nfunction cpp.linker(prj, cfg, cc)\nlocal libdeps\nlocal lddeps\nif #cfg.wholearchive > 0 then\nlibdeps = {}\nlddeps "
+	" = {}\nfor _, linkcfg in ipairs(premake.getlinks(cfg, \"siblings\", \"object\")) do\nlocal linkpath = path.rebase(linkcfg.linktarget.fullpath, linkcfg.location, cfg.location)\nif table.icontains(cfg.wholearchive, linkcfg.project.name) then\nlddeps = table.join(lddeps, cc.wholearchive(linkpath))\nelse\ntable.insert(lddeps, linkpath)\nend\ntable.insert(libdeps, linkpath)\nend\nlibdeps = make.list(_MAKE.esc(libdeps))\nlddeps  = make.list(_MAKE.esc(lddeps))\nelse\nlibdeps = make.list(_MAKE.esc(premake.getlinks(cfg, \"siblings\", \"fullpath\")))\nlddeps  = libdeps\nend\n_p('  ALL_LDFLAGS        += --verbose $(LDFLAGS)%s', make.list(table.join(cc.getlibdirflags(cfg), cc.getldflags(cfg), cfg.linkoptions)))\n_p('  LIBDEPS            +=%s', libdeps)\n_p('  LDDEPS             +=%s', lddeps)\nif cfg.flags.UseLDResponseFile then\n_p('  LDRESP              = $(OBJDIR)/%s_libs', prj.name)\n_p('  LIBS               += @$(LDRESP)%s', make.list(cc.getlinkflags(cfg)))\nelse\n_p('  LDRESP              =')\n_p('  LIBS            "
+	"   += $(LDDEPS)%s', make.list(cc.getlinkflags(cfg)))\nend\n_p('  EXTERNAL_LIBS      +=%s', make.list(cc.getlibfiles(cfg)))\n_p('  LINKOBJS            = %s', (cfg.flags.UseObjectResponseFile and \"@$(OBJRESP)\" or \"$(OBJECTS)\"))\nif cfg.kind == \"StaticLib\" then\nif (not prj.options.ArchiveSplit) then\n_p('  LINKCMD             = $(AR) %s $(TARGET)', make.list(cc.getarchiveflags(prj, cfg, false)))\nelse\n_p('  LINKCMD             = $(AR) %s $(TARGET)', make.list(cc.getarchiveflags(prj, cfg, false)))\n_p('  LINKCMD_NDX         = $(AR) %s $(TARGET)', make.list(cc.getarchiveflags(prj, cfg, true)))\nend\nelse\nlocal tool = iif(cfg.language == \"C\", \"CC\", \"CXX\")\nlocal startgroup = ''\nlocal endgroup = ''\nif (cfg.flags.LinkSupportCircularDependencies) then\nstartgroup = '-Wl,--start-group '\nendgroup   = ' -Wl,--end-group'\nend\n_p('  LINKCMD             = $(%s) -o $(TARGET) $(LINKOBJS) $(RESOURCES) $(ALL_LDFLAGS) %s$(LIBS)%s', tool, startgroup, endgroup)\nend\nend\nfunction cpp.pchconfig(cfg)\nif not cfg.p"
+	"chheader or cfg.flags.NoPCH then\nreturn\nend\nlocal pch = cfg.pchheader\nfor _, incdir in ipairs(cfg.includedirs) do\nlocal abspath = path.getabsolute(path.join(cfg.project.location, incdir))\nlocal testname = path.join(abspath, pch)\nif os.isfile(testname) then\npch = path.getrelative(cfg.location, testname)\nbreak\nend\nend\n_p('  PCH                 = %s', _MAKE.esc(pch))\n_p('  GCH                 = $(OBJDIR)/$(notdir $(PCH)).gch')\n_p('  GCH_OBJC            = $(OBJDIR)/$(notdir $(PCH))_objc.gch')\nend\nfunction cpp.pchrules(prj)\n_p('ifneq (,$(PCH))')\n_p('$(GCH): $(PCH) $(MAKEFILE) | $(OBJDIR)')\nif prj.msgprecompile then\n_p('\\t@echo ' .. prj.msgprecompile)\nelse\n_p('\\t@echo $(notdir $<)')\nend\nlocal cmd = iif(prj.language == \"C\", \"$(CC) $(ALL_CFLAGS) -x c-header\", \"$(CXX) $(ALL_CXXFLAGS) -x c++-header\")\n_p('\\t$(SILENT) %s $(DEFINES) $(INCLUDES) -o \"$@\" -c \"$<\"', cmd)\n_p('')\n_p('$(GCH_OBJC): $(PCH) $(MAKEFILE) | $(OBJDIR)')\nif prj.msgprecompile then\n_p('\\t@echo ' .. prj.msgprecompi"
+	"le)\nelse\n_p('\\t@echo $(notdir $<)')\nend\nlocal cmd = iif(prj.language == \"C\", \"$(CC) $(ALL_OBJCFLAGS) -x objective-c-header\", \"$(CXX) $(ALL_OBJCPPFLAGS) -x objective-c++-header\")\n_p('\\t$(SILENT) %s $(DEFINES) $(INCLUDES) -o \"$@\" -c \"$<\"', cmd)\n_p('endif')\n_p('')\nend\nfunction cpp.fileRules(prj, cc)\nlocal platforms = premake.filterplatforms(prj.solution, cc.platforms, \"Native\")\n_p('ifneq (,$(OBJRESP))')\n_p('$(OBJRESP): $(OBJECTS) | $(TARGETDIR) $(OBJDIRS)')\n_p('\\t$(SILENT) echo $^')\n_p('\\t$(SILENT) echo $^ > $@')\n_p('endif')\n_p('')\n_p('ifneq (,$(LDRESP))')\n_p('$(LDRESP): $(LDDEPS) | $(TARGETDIR) $(OBJDIRS)')\n_p('\\t$(SILENT) echo $^')\n_p('\\t$(SILENT) echo $^ > $@')\n_p('endif')\n_p('')\ntable.sort(prj.allfiles)\nfor _, file in ipairs(prj.allfiles or {}) do\nif path.issourcefile(file) then\nif (path.isobjcfile(file)) then\n_p('$(OBJDIR)/%s.o: %s $(GCH_OBJC) $(MAKEFILE) | $(OBJDIR)/%s'\n, _MAKE.esc(path.trimdots(path.removeext(file)))\n, _MAKE.esc(file)\n, _MAKE.esc(path.getdire"
+	"ctory(path.trimdots(file)))\n)\nelse\n_p('$(OBJDIR)/%s.o: %s $(GCH) $(MAKEFILE) | $(OBJDIR)/%s'\n, _MAKE.esc(path.trimdots(path.removeext(file)))\n, _MAKE.esc(file)\n, _MAKE.esc(path.getdirectory(path.trimdots(file)))\n)\nend\nif (path.isobjcfile(file) and prj.msgcompile_objc) then\n_p('\\t@echo ' .. prj.msgcompile_objc)\nelseif prj.msgcompile then\n_p('\\t@echo ' .. prj.msgcompile)\nelse\n_p('\\t@echo $(notdir $<)')\nend\nif (path.isobjcfile(file)) then\nif (path.iscfile(file)) then\n_p('\\t$(SILENT) $(CXX) $(ALL_OBJCFLAGS) $(FORCE_INCLUDE_OBJC) -o \"$@\" -c \"$<\"')\nelse\n_p('\\t$(SILENT) $(CXX) $(ALL_OBJCPPFLAGS) $(FORCE_INCLUDE_OBJC) -o \"$@\" -c \"$<\"')\nend\nelseif (path.isasmfile(file)) then\n_p('\\t$(SILENT) $(CC) $(ALL_ASMFLAGS) -o \"$@\" -c \"$<\"')\nelse\ncpp.buildcommand(path.iscfile(file) and not prj.options.ForceCPP, \"o\")\nend\nfor _, task in ipairs(prj.postcompiletasks or {}) do\n_p('\\t$(SILENT) %s', task)\n_p('')\nend\n_p('')\nelseif (path.getextension(file) == \".rc\") then\n_p('$(OBJDIR)"
+	"/%s.res: %s', _MAKE.esc(path.getbasename(file)), _MAKE.esc(file))\nif prj.msgresource then\n_p('\\t@echo ' .. prj.msgresource)\nelse\n_p('\\t@echo $(notdir $<)')\nend\n_p('\\t$(SILENT) $(RESCOMP) $< -O coff -o \"$@\" $(ALL_RESFLAGS)')\n_p('')\nend\nend\nend\nfunction cpp.dependencyRules(prj)\nfor _, dependency in ipairs(prj.dependency or {}) do\nfor _, dep in ipairs(dependency or {}) do\nif (dep[3]==nil or dep[3]==false) then\n_p('$(OBJDIR)/%s.o: %s'\n, _MAKE.esc(path.trimdots(path.removeext(path.getrelative(prj.location, dep[1]))))\n, _MAKE.esc(path.getrelative(prj.location, dep[2]))\n)\nelse\n_p('%s: %s'\n, _MAKE.esc(dep[1])\n, _MAKE.esc(path.getrelative(prj.location, dep[2]))\n)\nend\n_p('')\nend\nend\nend\nfunction cpp.buildcommand(iscfile, objext)\nlocal flags = iif(iscfile, '$(CC) $(ALL_CFLAGS)', '$(CXX) $(ALL_CXXFLAGS)')\n_p('\\t$(SILENT) %s $(FORCE_INCLUDE) -o \"$@\" -c \"$<\"', flags, objext)\nend\n",
 
 	/* actions/make/make_csharp.lua */
 	"local function getresourcefilename(cfg, fname)\nif path.getextension(fname) == \".resx\" then\nlocal name = cfg.buildtarget.basename .. \".\"\nlocal dir = path.getdirectory(fname)\nif dir ~= \".\" then\nname = name .. path.translate(dir, \".\") .. \".\"\nend\nreturn \"$(OBJDIR)/\" .. _MAKE.esc(name .. path.getbasename(fname)) .. \".resources\"\nelse\nreturn fname\nend\nend\nfunction premake.make_csharp(prj)\nlocal csc = premake.dotnet\nlocal cfglibs = { }\nlocal cfgpairs = { }\nlocal anycfg\nfor cfg in premake.eachconfig(prj) do\nanycfg = cfg\ncfglibs[cfg] = premake.getlinks(cfg, \"siblings\", \"fullpath\")\ncfgpairs[cfg] = { }\nfor _, fname in ipairs(cfglibs[cfg]) do\nif path.getdirectory(fname) ~= cfg.buildtarget.directory then\ncfgpairs[cfg][\"$(TARGETDIR)/\" .. _MAKE.esc(path.getname(fname))] = _MAKE.esc(fname)\nend\nend\nend\nlocal sources = {}\nlocal embedded = { }\nlocal copypairs = { }\nfor fcfg in premake.project.eachfile(prj) do\nlocal action = csc.getbuildaction(fcfg)\nif action == \"Compile\" then"
