/* -*- c-file-style: "GNU" -*- */
/*
 * Copyright (C) CNRS, INRIA, Université Bordeaux 1, Télécom SudParis
 * See COPYING in top-level directory.
 *
 *
 * errors.h -- Error reporting inside PPTrace.
 *
 * Methods provided are:
 * 	- pptrace_get_error(): returns the last reported error
 * 	- pptrace_clear_error(): clear the error reported by PPTrace internals
 * 	- pptrace_error(fmt, ...): printf-like function to display an error.
 * 			*PPTrace Internals*
 *	- pptrace_report_error(fmt, ...): printf-like function to report an error
 *			that won't be displayed. *PPTrace Internals*
 *	- pptrace_fubar(fmt, ...): printf-like function for fatal error. This ends
 *			the process. *PPTrace Internals*
 *	- pptrace_bin_error(): method implemented by the binary module to provides
 *			error specific to the binary module. *PPTrace Internals*
 *	- pptrace_debug(level, fmt, ...): printf-like function for printing
 *			debugging information. *PPTrace Internals*
 *	- pptrace_dump_buffer(level, buffer, length): print in hex format the
 *			buffer given in argument for debugging purpose. *PPTrace Internals*
 *
 *  Created on: 2 Aug. 2011
 *      Author: Damien Martin-Guillerez <damien.martin-guillerez@inria.fr>
 */

#ifndef PPTRACE_ERRORS_H_
#define PPTRACE_ERRORS_H_

#include <eztrace-core/eztrace_config.h>
#include <unistd.h>

enum PPTRACE_DEBUG_LEVEL {
  PPTRACE_DEBUG_LEVEL_NONE,
  PPTRACE_DEBUG_LEVEL_INFO,
  PPTRACE_DEBUG_LEVEL_VERBOSE,
  PPTRACE_DEBUG_LEVEL_DEBUG,
  PPTRACE_DEBUG_LEVEL_ALL,
};

void set_pptrace_debug_level(enum PPTRACE_DEBUG_LEVEL debug_level);
enum PPTRACE_DEBUG_LEVEL get_pptrace_debug_level();

const char* pptrace_get_error();
void pptrace_clear_error();
void pptrace_error(char* fmt, ...);

void pptrace_report_error(char* fmt, ...);
void pptrace_fubar(char* fmt, ...);

const char* pptrace_bin_error();

void pptrace_debug(enum PPTRACE_DEBUG_LEVEL level, const char* fmt, ...);
void pptrace_dump_buffer(enum PPTRACE_DEBUG_LEVEL level, char* buffer, size_t length);

#endif // PPTRACE_ERRORS_H_
