/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.MethodDescriptor;
import org.junit.jupiter.engine.descriptor.MethodBasedTestDescriptor;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;

class DefaultMethodDescriptor
implements MethodDescriptor {
    private final MethodBasedTestDescriptor testDescriptor;

    DefaultMethodDescriptor(MethodBasedTestDescriptor testDescriptor) {
        this.testDescriptor = testDescriptor;
    }

    MethodBasedTestDescriptor getTestDescriptor() {
        return this.testDescriptor;
    }

    public final Method getMethod() {
        return this.testDescriptor.getTestMethod();
    }

    public boolean isAnnotated(Class<? extends Annotation> annotationType) {
        Preconditions.notNull(annotationType, (String)"annotationType must not be null");
        return AnnotationUtils.isAnnotated((AnnotatedElement)this.getMethod(), annotationType);
    }

    public <A extends Annotation> Optional<A> findAnnotation(Class<A> annotationType) {
        Preconditions.notNull(annotationType, (String)"annotationType must not be null");
        return AnnotationUtils.findAnnotation((AnnotatedElement)this.getMethod(), annotationType);
    }

    public <A extends Annotation> List<A> findRepeatableAnnotations(Class<A> annotationType) {
        Preconditions.notNull(annotationType, (String)"annotationType must not be null");
        return AnnotationUtils.findRepeatableAnnotations((AnnotatedElement)this.getMethod(), annotationType);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("method", (Object)this.getMethod().toGenericString()).toString();
    }
}

