; This file was initially generated automatically from legacy documentation
; strings.  See source files in this directory for copyright and license
; information.

(in-package "ACL2")

(include-book "xdoc/top" :dir :system)

(defxdoc |#COND|
  :parents (|#COND|)
  :short "A C-preprocessor-like macro for alternate conditional events"
  :long  "<p></p>
 
 
 <p>\\#cond is a C-preprocessor-like macro that selects zero
 or one event among a possible sequence of events based upon
 the result of evaluating the condition associated with the
 event.</p>
 
 <p>(\\#cond
    ((@@ test3) (defun test3 (x) x))
    ((@@ test4) (defun test4 (x) x))
    ((@@ test5) (defun test5 (x) x))
   )</p>
 
 <p>The \\#cond macro accepts a sequence of terms in cond form.
 Each predicate of the cond form is evaluated in sequence.  If a
 predicate evaluates to true, the term associated with that 
 predicate will be submitted to ACL2.  If no predicate evalutes
 to true, the event is a no-op.</p>
 
 <p>See <see topic='@(url |#IF|)'>#if</see>
   See <see topic='@(url |#IF-ELSE|)'>#if-else</see></p>")

(defxdoc |#IF|
  :parents (|#IF|)
  :short "A C-preprocessor-like macro for conditional events"
  :long  "<p></p>
 
 
 <p>\\#if is a C-preprocessor-like macro that allows a sequence of 
 embedded event forms to be made conditional on state.</p>
 
 <p>(\\#if (equal (@@ acl2-version) \"ACL2 Version 3.3\")</p>
 
 <p>(defun test1 (x) x)
     (defthm test-equal
       (equal (test x) x))</p>
 
 <p>)</p>
 
 <p>The first argument to \\#if is a predicate that is evaluated
 in the current state.  If the predicate evaluates to true, the
 remaining forms are submitted to ACL2.  If not, the remaining
 forms are skipped.  \\if events can be nested.</p>
 
 <p>See <see topic='@(url |#IF-ELSE|)'>#if-else</see>
   See <see topic='@(url |#COND|)'>#cond</see></p>")

(defxdoc |#IF-ELSE|
  :parents (|#IF-ELSE|)
  :short "A C-preprocessor-like macro for alternate conditional events"
  :long  "<p></p>
 
 
 <p>\\#if-else is a C-preprocessor-like macro that alternates
 between two different embedded event forms depending on the
 result of evaluating the condition.</p>
 
 <p>(#if-else (equal (@@ acl2-version) \"ACL2 Version 3.3\")</p>
 
 <p>(defun test1 (x) (1- x))</p>
 
 <p>(defun test1 (x) (1+ x))</p>
 
 <p>)</p>
 
 <p>The first argument to \\#if-else is a predicate that is evaluated
 in the current state.  If the predicate evaluates to true, the second
 argument to if-else will be submitted to ACL2.  If the predicate
 evaluates to false, the third argument will be submitted. \\#if-else 
 events can be nested.</p>
 
 <p>See <see topic='@(url |#IF|)'>#if</see>
   See <see topic='@(url |#COND|)'>#cond</see></p>")

(defxdoc defstructure
  :parents (defstructure)
  :short "Define and characterize a general purpose record structure with typed slots.

The on-line documentation only contains examples and a formal syntax
description. The complete documentation for DEFSTRUCTURE is a report entitled
\"DEFSTRUCTURE for ACL2.\"  This report is distributed with the ACL2 release,
and is also available from the ACL2 home page:

http://www.cs.utexas.edu/users/moore/acl2"
  :long  "<p>
 Examples:</p>
 
 <p>(DEFSTRUCTURE SHIP X-POSITION Y-POSITION X-VELOCITY Y-VELOCITY MASS)
  
  (DEFSTRUCTURE MC-STATE
    \"The state of the MC68020.\"
    (STATUS (:ASSERT (SYMBOLP STATUS) :TYPE-PRESCRIPTION))
    (RFILE  (:ASSERT (RFILEP RFILE) :REWRITE))
    (PC     (:ASSERT (LONGWORD-P PC) :REWRITE
                     (:TYPE-PRESCRIPTION (NATURALP PC))))
    (CCR    (:ASSERT (CCR-P CCR) :REWRITE
                     (:TYPE-PRESCRIPTION (NATURALP CCR))))
    (MEM    (:ASSERT (MEMORYP MEM) :REWRITE))
  
    (:OPTIONS :GUARDS (:CONC-NAME MC-)))
  
  (DEFSTRUCTURE S&amp;ADDR 
    \"An MC68020 effective address abstraction.\"
    (S     (:ASSERT (MC-STATE-P S) :REWRITE))
    (LOC   (:ASSERT (SYMBOLP LOC)  :TYPE-PRESCRIPTION))
    (ADDR  (:ASSERT ((LAMBDA (LOC ADDR)
                       (CASE LOC
                         ((D A) (RN-NUMBERP ADDR))
                         ((M I) (LONGWORD-P ADDR))
                         (OTHERWISE (NULL ADDR))))
                     LOC ADDR)
                    (:REWRITE
                     (IMPLIES
                      (OR (EQUAL LOC 'D) (EQUAL LOC 'A))
                      (RN-NUMBERP ADDR)))
                    (:REWRITE
                     (IMPLIES
                      (OR (EQUAL LOC 'M) (EQUAL LOC 'I))
                      (LONGWORD-P ADDR)))))
  
    (:OPTIONS :GUARDS))
  
  (DEFSTRUCTURE V&amp;CVZNX
    \"An MC68020 value abstraction.\"
    (V     (:ASSERT (LONGWORD-P V) :REWRITE
                    (:TYPE-PRESCRIPTION (NATURALP V))))
    (CVZNX (:ASSERT (CCR-P CVZNX) :REWRITE
                    (:TYPE-PRESCRIPTION (NATURALP CVZNX))))
  
    ;;  These options make this nothing more than a typed CONS.
  
    (:OPTIONS :GUARDS (:REPRESENTATION (V . CVZNX)) (:DO-NOT :TAG)))</p>
 
 <p>
 </p>
 
 
 <p>Syntax:</p>
 
 <p>DEFSTRUCTURE name [documentation] {slot-and-options}* [option-list]</p>
 
 <p>option-list ::= (:OPTIONS [[options]])</p>
 
 <p>options ::= guards-option |
               verify-guards-option |
               slot-writers-option |
               inline-option |
               mix-option |
               conc-name-option |
               set-conc-name-option |
               keyword-constructor-option |
               keyword-updater-option |
               predicate-option |
               weak-predicate-option |
               force-option |
               representation-option |
               do-not-option |
               mv-intro-macro-option
               update-method-option |
               assertion-lemma-hints-option |
               predicate-guard-hints-option |
               prefix-option |
               {assert-option}*</p>
 
 <p>slot-and-options ::= slot-name | (slot-name [[slot-options]])</p>
 
 <p>slot-options ::= default-option |
                    read-only-option |
                    {assert-option}* </p>
 
 <p>default-option ::= :DEFAULT | (:DEFAULT) | (:DEFAULT slot-initform)</p>
 
 <p>read-only-option ::= :READ-ONLY</p>
 
 <p>assert-option ::= (:ASSERT assertion {assertion-rule-descriptor}*)</p>
 
 <p>assertion-rule-descriptor ::= rule-token | 
                                 (rule-token corollary [other-rule-forms])</p>
 
 <p>rule-token ::= NIL | :REWRITE | :LINEAR | :LINEAR-ALIAS |
                  :WELL-FOUNDED-RELATION | :BUILT-IN-CLAUSE |
                  :COMPOUND-RECOGNIZER | :ELIM | :GENERALIZE | :META |
                  :FORWARD-CHAINING | :EQUIVALENCE | :REFINEMENT | 
                  :CONGRUENCE | :TYPE-PRESCRIPTION | :DEFINITION | :INDUCTION |
                  :TYPE-SET-INVERTER </p>
 
 <p>guards-option ::= :GUARDS</p>
 
 <p>verify-guards-option ::= :VERIFY-GUARDS | (:VERIFY-GUARDS) |
                            (:VERIFY-GUARDS T) | (:VERIFY-GUARDS NIL)</p>
 
 <p>slot-writers-option ::= :SLOT-WRITERS</p>
 
 <p>inline-option ::= :INLINE</p>
 
 <p>mix-option ::= :MIX</p>
 
 <p>conc-name-option ::= :CONC-NAME | (:CONC-NAME) | (:CONC-NAME conc-name)</p>
 
 <p>set-conc-name-option ::= :SET-CONC-NAME | (:SET-CONC-NAME) |
                            (:SET-CONC-NAME set-conc-name)</p>
 
 <p>keyword-constructor-option ::= :KEYWORD-CONSTRUCTOR |
                                  (:KEYWORD-CONSTRUCTOR) |
                                  (:KEYWORD-CONSTRUCTOR keyword-constructor)</p>
 
 <p>keyword-updater-option ::= :KEYWORD-UPDATER | (:KEYWORD-UPDATER) | 
                           (:KEYWORD-UPDATER keyword-updater)</p>
 
 <p>predicate-option ::=  :PREDICATE | (:PREDICATE) | (:PREDICATE predicate)</p>
 
 <p>weak-predicate-option ::=  :WEAK-PREDICATE | (:WEAK-PREDICATE) |  
                              (:WEAK-PREDICATE weak-predicate)</p>
 
 <p>force-option ::= :FORCE</p>
 
 <p>do-not-option ::= (:DO-NOT [[do-not-options]])</p>
 
 <p>do-not-options ::= :TAG | :READ-WRITE | :WRITE-WRITE</p>
 
 <p>representation-option ::= :REPRESENTATION | (:REPRESENTATION) |
                             (:REPRESENTATION representation)</p>
 
 <p>representation ::= :LIST | :MV | :DOTTED-LIST | :TREE | template</p>
 
 <p>mv-intro-macro-option ::=  :MV-INTRO-MACRO |
                              (:MV-INTRO-MACRO) |  
                              (:MV-INTRO-MACRO mv-intro-macro)</p>
 
 <p>update-method-option ::= :UPDATE-METHOD | (:UPDATE-METHOD) |
                            (:UPDATE-METHOD update-method)</p>
 
 <p>update-method ::= :HEURISTIC | :SET | :COPY</p>
 
 <p>assertion-lemma-hints-option ::= 
     :ASSERTION-LEMMA-HINTS | (:ASSERTION-LEMMA-HINTS) | 
     (:ASSERTION-LEMMA-HINTS hints)</p>
 
 <p>predicate-guard-hints-option ::= 
     :PREDICATE-GUARD-HINTS | (:PREDICATE-GUARD-HINTS) | 
     (:PREDICATE-GUARD-HINTS hints)</p>
 
 <p>prefix-option ::= :PREFIX | (:PREFIX) | (:PREFIX prefix)</p>
 
 <p>Arguments and Values:</p>
 
 <p>assertion -- a slots-assertion.</p>
 
 <p>corollary -- a slots-assertion.</p>
 
 <p>conc-name -- a string-designator.</p>
 
 <p>documentation -- a string; not evaluated.</p>
 
 <p>hints -- an acl2-hints.</p>
 
 <p>keyword-constructor -- a symbol.</p>
 
 <p>keyword-updater -- a symbol.</p>
 
 <p>name -- a symbol.</p>
 
 <p>mv-intro-macro -- a symbol.</p>
 
 <p>other-rule-forms -- Some acl2-rule-forms.</p>
 
 <p>predicate -- a symbol.</p>
 
 <p>prefix -- a string-designator.</p>
 
 <p>read-write-lemma -- a symbol.</p>
 
 <p>set-conc-name -- a string-designator.</p>
 
 <p>slot-initform -- a form; not evaluated.</p>
 
 <p>slot-name -- a valid-slot-name.</p>
 
 <p>tag -- a symbol.</p>
 
 <p>template -- A slots-template.</p>
 
 <p>weak-predicate -- a symbol.</p>
 
 <p>write-write-lemma -- a symbol. </p>
 
 <p>Definitions:</p>
 
 <p>acl2-hints -- any form valid as the hints argument of defthm.  See the
 documentation for HINTS in the ACL2 documentation.</p>
 
 <p>acl2-rule-forms -- Any forms that would be valid in an ACL2 rule-classes
 form, except for the rule class itself, or a corollary and formula.  See the
 documentation for the DEFSTRUCTURE assertion theory in the DEFSTRUCTURE
 document,and the ACL2 documentations for RULE-CLASSES.</p>
 
 <p>slots-assertion -- DEFSTRUCTURE assertions are covered in the DEFSTRUCTURE
 document. </p>
 
 <p>slots-template -- A cons tree whose flattened form (by STRUCTURES::FLATTEN) is
 a permutation of the list of slot names of the structure.</p>
 
 <p>string-designator -- a character, string or symbol, it designates the string
 obtained by (STRING STRING-DESIGNATOR) except that by convention the symbol
 NIL designates the empty string.</p>
 
 <p>valid-slot-name -- Any symbol valid for use as a formal parameter of a
 function. This is any symbol not in the \"keyword\" package, neither T nor NIL,
 neither beginning nor ending with `*', and not beginning with `&amp;'.  In
 addition, no slot-name may be the same as the structure name, and all
 slot-names must have unique print names, i.e., it is illegal to duplicate
 slot names, and it is illegal to use symbols from different packages that
 have the same print name.</p>
 
 <p>
 </p>")

(defxdoc rule-sets
  :parents (rule-sets)
  :short "Machinery for organizing and versioning dynamic
sets of rules"
  :long  "<p></p>
 
 
 <p><br></br>
   ACL2 enables users to define named collections of rules,
 See @(see theories), that can be used in conjunction with
 See @(see in-theory) events to manage the theory state of ACL2.
 Defining a theory, however, requires that all of the rules in the
 theory be known at the point at which the theory is defined.</p>
 
 <p>RULE-SETS enable users to define named collections of rules 
 (RULE-SETS) and to incrementally modify that collection as necessary
 to maintain a desired theory philosophy.</p>
 
 <p>Each rule set is associated with a particular set name as well as a
 collection of versions.  Set names and versions may be any eqlablep
 object.  For example, the rule set:</p>
 
 <p>`(zed . alpha)</p>
 
 <p>Refers to the alpha version of rule set zed.</p>
 
 <p>Rule sets are expected to have applications in both theory
 management and library development.  </p>
 
 <p>Library developers will want to use rule sets to isolate different
 proof styles as well as different classes of rules.  It seems unlikely
 that one would want to version rule classes used in this style unless,
 perhaps, it were to support a proof methodology such as phased
 rewriting.</p>
 
 <p>Libraries themselves should be associated with umbrella rule classes
 that cover all of the crucial functions and theories developed within
 the library.  Here, versioning is the key to robust proof development
 in the face of library extensions.  When a library is released, it
 should be done so under a specific version tag.  Subsequent extensions
 of that library should be performed under different version tags.</p>
 
 <p>Library rule classes should be orthoganal to methodological rule
 classes.</p>
 
 <p>It is possible to classify a given rule under several different rule
 classes.  Every classified rule is classified under a specific library
 (by default).  It may also be classified under one or more
 methodological rule classes.</p>
 
 <p>See @(see def::rule-set)</p>")

(defxdoc adviser::adviser
  :parents (adviser::adviser)
  :short "A extensible hint suggestion daemon"
  :long  "<p>
 Adviser is a a hint computation service.  When the adviser book is loaded,
 this service is installed into the ACL2 world as a default hint.  This
 service is consulted when goals becomes stable under simplification during
 your proof attempts.  In other words, before destructor elimination,
 generalization, and so forth are tried, the theorem prover will now first
 consult the Adviser service and see if any hints is available.  
 </p>
 
 
 <p>When the Adviser is consulted, it examines the goal that ACL2 is stuck on
 and checks to see if it can give any suggestions.  To make these
 suggestions, Adviser consults its own database of rules.  These rules are
 kept in a new ACL2 @(see table) that Adviser manages, and efficiently stored
 using the btree library that comes with ACL2 (see
 books/misc/symbol-btree.lisp).</p>
 
 <p>This database oriented approach has two advantages.  First, users can extend
 Adviser's knowledge by adding new rules, without having to understand the
 tricky details of how computed hints work.  (These rules are added through a
 new event called @(see adviser::defadvice), which intentionally looks a lot like
 defthm).  Second, by using a database of triggers, a single pass over each
 goal is sufficient to determine if advice is necessary.  In contrast, if
 everyone created their own computed hints, we would have multiple passes
 over the same goal.</p>
 
 <p>See @(see adviser::defadvice) for information on adding rules to Adviser.
 </p>")

(defxdoc coi-debug::assert
  :parents (coi-debug::assert)
  :short "A macro to assist in detecting runtime errors"
  :long  "<p></p>
 
 
 <p>The coi-debug::assert macro allows the user to identify runtime errors
 in ACL2 code.  The return value of coi-debug::assert can be set by
 specifying a :value parameter.  The failure message can be configured
 via the :message keyword.  Note that the first argument (~x0) is the
 syntactic form of the test, but that additional parameters can be
 passed in as a list via :parameters.</p>
 
 <p>Example usage pattern:</p>
 
 <p>(let ((y (coi-debug::assert (test y)
                           :value y
                           :message \"Y failed ~x0 in ~x1\"
                           :parameters (z))))
     ..)</p>")

(defxdoc adviser::defadvice
  :parents (adviser::adviser)
  :short "Adds a rule to the Adviser database"
  :long  "<p>
 </p>
 
 @({
  General Form:
  (defadvice rule-name term 
    :rule-classes rule-classes)
 })
 
 <p>             </p>
 
 <p>where @('name') is a new symbolic name See @(see name), @('term') is a term alleged to
 be a useful piece of advice, and @('rule-classes') describe the type of advice
 being added and when to suggest hints of this nature.
 </p>
 
 
 <p>When Adviser is first loaded, no rules are installed in its database, so it
 will never suggest any hints.  To make Adviser useful, rules must be added to
 it using defadvice.  In principle, many types of advice could be added to the
 Adviser service, and in the future other classes of advice might be added. 
 But, for now, the only understood rule class is :pick-a-point.  </p>
 
 <p>See @(see adviser::pick-a-point) for documentation and examples about :pick-a-point
 rules.
 </p>")

(defxdoc def::doc
  :parents (def::doc)
  :short "A simple macro for easing the documentation process"
  :long  "<p></p>
 
 
 <p>The def::doc macro eases the process of constructing documentation
 strings for ACL2 symbols. See @(see doc).  Macro keywords are used to
 identify content for each of the primary documentation elements:</p>
 
 <p></p>
 
 @({
  :section     Either a symbol or string identifying the section
  :one-liner   A simple one-line overview of the symbol
  :notes       Notes related to this symbol
  :details     Documentation details about the symbol
 })
 
 <p><br></br>
 
   The string arguments used by the macro can be computed, allowing the
 user to use functions as abbreviations for common and unwieldly
 documentation constructs.</p>")

(defxdoc coi-debug::fail
  :parents (coi-debug::fail)
  :short "A macro to assist in signalling runtime errors"
  :long  "<p></p>
 
 
 <p>The coi-debug::fail macro allows the user to signal runtime errors
 in ACL2 code.  The return value of coi-debug::fail can be set by
 specifying a :value parameter.  The failure message can be configured
 via the :message keyword.  Additional parameters can be passed in as 
 a list via :parameters.</p>
 
 <p>Typical usage pattern:</p>
 
 <p>(if (consp x) (car x)
     (coi-debug::fail :value nil
                  :message \"~x0 is not a consp\"
                  :parameters (x)))</p>
 
 <p>It is sometimes convenient when debugging to induce a common-lisp
 break on a failure.  The following code will do just that.</p>
 
 <p>FOO !&gt; (acl2::progn
            (acl2::defttag t)
            (acl2::progn!
              (acl2::set-raw-mode t)
              (defun coi-debug::fail-fn (value message parameters)
                (acl2::prog2$
                  (acl2::fmt-to-comment-window message parameters 0 nil)
                  (acl2::break)))))</p>")

(defxdoc adviser::pick-a-point
  :parents (adviser::adviser)
  :short "Make some :pick-a-point rules"
  :long  "<p>
 </p>
 
 @({
  Example:
  (defadvice subbag-by-multiplicity
    (implies (bag-hyps)
             (subbagp (subbag) (superbag))))
 })
 
 <p>
 </p>
 
 
 <p>I described how the pick-a-point method can be useful for proving subsets in
 the 2004 ACL2 Workshop Paper: Finite Set Theory based on Fully Ordered Lists.
 Essentially, the idea is to you should be able to prove (subset x y) by just
 knowing that forall a, (in a x) implies (in a y).  Since writing that paper,
 I have found the pick a point method to be widely useful in other contexts
 that involve extending a predicate to some data structure.</p>
 
 <p>Often we will have some simple predicate, say @('integerp'), which we will
 want to extend over some datastructure, say a list.  The result is a new,
 recursively defined predicate, say @('all-integerp').  Of course, it should be
 obvious that if every member of the list satisfies @('integerp'), then the
 entire list satisfies @('all-integerp').  But, we can't write a :rewrite rule
 such as:</p>
 
 <p></p>
 
 @({
    (equal (all-integerp x)
           (forall a (implies (member a x) (integerp a))))
 })
 
 <p></p>
 
 <p>Because all of the variables in our :rewrite rules must be universally
 quantified.  The :pick-a-point rules in Adviser are designed to make exactly
 this kind of reduction.  As an example, I'll now elaborate on how to set up
 such a reduction for @('all-integerp').  You will find that many other ideas,
 such as subsets, subtree, subbag relations, and so forth, are basically just
 copies of this idea.</p>
 
 <p>We begin with our definition of all-integerp.  (We do not use integer-listp
 because it requires its argument to be a true-listp.)</p>
 
 <p></p>
 
 @({
  (defun all-integerp (x)
    (if (consp x)
        (and (integerp (car x))
             (all-integerp (cdr x)))
      t))
 })
 
 <p></p>
 
 <p>Our first task is to write our ``forall'' statement as a constraint theorem
 about encapsulated functions.  Becuase we are quantifying over all ``a'', it
 will be a variable in this constrained theorem.  However, since ``x'' is not
 being quantified, we will create a constrained function for it.  For reasons
 we will explain later, we will also have one more constrianed function called
 ``hyps''.  In all, we come up with the following encapsulate:</p>
 
 <p></p>
 
 @({
  (encapsulate
   (((intlist-hyps) => *)
    ((intlist-list) => *))
   (local (defun intlist-hyps () nil))
   (local (defun intlist-list () nil))
   (defthm intlist-constraint
     (implies (and (intlist-hyps)
  		   (member intlist-element (intlist-list)))
  	      (integerp intlist-element))
     :rule-classes nil))
 })
 
 <p></p>
 
 <p>Our next goal is to prove that, given this constraint, it must be the case
 that (integer-listp (intlist-list)) is true.  The proof is not entirely 
 straightforward, but follows the same script each time.  Basically, we first
 set up a ``badguy'' function that will go through and find an element that
 violates our constraint if one exists.  We show that the badguy finds such
 an element whenever ``all-integerp'' is not satisifed.  Then, we just use
 the instance of our constraint to show that all-integerp must be true for 
 (intlist-list).</p>
 
 <p></p>
 
 @({
  (local (defun badguy (x)
           (if (endp x)
               nil
             (if (integerp (car x))
                 (badguy (cdr x)) 
               (car x)))))
             
  (local (defthm badguy-works
           (implies (not (all-integerp x))
                    (and (member (badguy x) x)
                         (not (integerp (badguy x)))))))
  
  (defthm intlist-by-membership-driver
    (implies (intlist-hyps)
             (all-integerp (intlist-list)))
    :rule-classes nil
    :hints((\"Goal\" 
            :use (:instance intlist-constraint
                            (intlist-element (badguy (intlist-list)))))))
 })
 
 <p>
 
 At this point, we have essentially shown ACL2 that ``all-integerp`` can
 be shown as long as we can show our constraint is true.  The missing step
 is for ACL2 to actually try this approach for us.  But we can't write a 
 rewrite rule that says ``try to functionally instantiate this theorem 
 whenever you are trying to prove (all-integerp x).''</p>
 
 <p>That's where Adviser comes in.  We just give it the following rule:</p>
 
 <p></p>
 
 @({
  (ADVISER::defadvice intlist-by-membership
    (implies (intlist-hyps)
             (all-integerp (intlist-list)))
    :rule-classes (:pick-a-point :driver intlist-by-membership-driver))
 })
 
 <p></p>
 
 <p>Because we used defadvice, rather than defthm, this rule is for Adviser
 to add to its database.  Adviser will set up a new trigger for 
 all-integerp, and whenever it sees that trigger as the target that we 
 are trying to prove, it will functionally instantiate the driver theorem.
 We can now conduct membership based proofs of all-integerp.  </p>
 
 <p>For example, in the following script we can prove that (all-integerp (rev x))
 exactly when (all-integerp x) without inducting over either function, 
 because we can just consider membership.</p>
 
 <p></p>
 
 @({
  (defthm equal-of-booleans-rewrite
    (implies (and (booleanp x)
                  (booleanp y))
             (equal (equal x y)
                    (iff x y)))
    :rule-classes ((:rewrite :backchain-limit-lst 0)))
  
  (defthm member-of-all-integerp-1
    (implies (and (member a x)
                  (all-integerp x))
             (integerp a)))
  
  (defthm member-of-all-integerp-2
    (implies (and (all-integerp x)
                  (not (integerp a)))
             (not (member a x))))
  
  (in-theory (disable all-integerp))
  
  (defund rev (x)
    (if (endp x)
        x
      (append (rev (cdr x)) 
              (list (car x)))))
  
  (defthm member-of-rev
    (iff (member a (rev x))
         (member a x))
    :hints((\"Goal\" :in-theory (enable rev))))
  
  (encapsulate
   ()
  
   (local (defthm lemma1
            (implies (all-integerp x)
                     (all-integerp (rev x)))))
   
   (local (defthm lemma2
            (implies (all-integerp (rev x))
                     (all-integerp x))
            :hints((\"Subgoal 1\" :use (:instance member-of-all-integerp-1
                                                  (a intlist-element)
                                                  (x (rev x)))))))
  
   (defthm all-integerp-of-rev
     (equal (all-integerp (rev x))
            (all-integerp x)))
   )
 })
 
 <p>
 </p>")

(defxdoc def::rule-set
  :parents (def::rule-set)
  :short "A macro for defining a new rule set"
  :long  "<p></p>
 
 
 <p><br></br>
 New rule sets can be defined using def::rule-set.
 
 </p>")

