/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff;

import cz.startnet.utils.pgdiff.PgDiffUtils;
import cz.startnet.utils.pgdiff.SearchPathHelper;
import cz.startnet.utils.pgdiff.schema.PgPolicy;
import cz.startnet.utils.pgdiff.schema.PgSchema;
import cz.startnet.utils.pgdiff.schema.PgTable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;

public class PgDiffPolicies {
    public static void createPolicies(PrintWriter printWriter, PgSchema pgSchema, PgSchema pgSchema2, SearchPathHelper searchPathHelper) {
        for (PgTable pgTable : pgSchema2.getTables()) {
            String string = pgTable.getName();
            PgTable pgTable2 = pgSchema == null ? null : pgSchema.getTable(string);
            for (PgPolicy pgPolicy : pgTable.getPolicies()) {
                PgPolicy pgPolicy2 = pgTable2 != null ? pgTable2.getPolicy(pgPolicy.getName()) : null;
                if (pgPolicy2 != null) continue;
                searchPathHelper.outputSearchPath(printWriter);
                PgDiffPolicies.createPolicySQL(printWriter, pgPolicy);
            }
        }
    }

    public static void alterPolicies(PrintWriter printWriter, PgSchema pgSchema, PgSchema pgSchema2, SearchPathHelper searchPathHelper) {
        for (PgTable pgTable : pgSchema2.getTables()) {
            PgTable pgTable2;
            String string = pgTable.getName();
            if (pgSchema == null || (pgTable2 = pgSchema.getTable(string)) == null) continue;
            for (PgPolicy pgPolicy : pgTable2.getPolicies()) {
                PgPolicy pgPolicy2 = pgTable.getPolicy(pgPolicy.getName());
                if (pgPolicy2 == null) continue;
                String string2 = pgPolicy2.getCommand();
                String string3 = pgPolicy.getCommand();
                if (string2 != null && string3 != null && !string2.equals(string3)) {
                    searchPathHelper.outputSearchPath(printWriter);
                    PgDiffPolicies.dropPolicySQL(printWriter, pgPolicy2);
                    PgDiffPolicies.createPolicySQL(printWriter, pgPolicy2);
                    continue;
                }
                if (pgPolicy.getUsing() == null && pgPolicy2.getUsing() != null || pgPolicy.getUsing() != null && pgPolicy2.getUsing() == null || pgPolicy.getUsing() != null && pgPolicy2.getUsing() != null && !pgPolicy.getUsing().equals(pgPolicy2.getUsing())) {
                    searchPathHelper.outputSearchPath(printWriter);
                    PgDiffPolicies.alterPolicySQL(printWriter, pgPolicy2);
                    continue;
                }
                if (pgPolicy.getWithCheck() == null && pgPolicy2.getWithCheck() != null || pgPolicy.getWithCheck() != null && pgPolicy2.getWithCheck() == null || pgPolicy.getWithCheck() != null && pgPolicy2.getWithCheck() != null && !pgPolicy.getWithCheck().equals(pgPolicy2.getWithCheck())) {
                    searchPathHelper.outputSearchPath(printWriter);
                    PgDiffPolicies.alterPolicySQL(printWriter, pgPolicy2);
                    continue;
                }
                ArrayList<String> arrayList = new ArrayList<String>(pgPolicy.getRoles());
                boolean bl = pgPolicy2.getRoles().containsAll(pgPolicy.getRoles()) && pgPolicy.getRoles().containsAll(pgPolicy2.getRoles());
                if (bl) continue;
                searchPathHelper.outputSearchPath(printWriter);
                PgDiffPolicies.alterPolicySQL(printWriter, pgPolicy2);
            }
        }
    }

    public static void dropPolicies(PrintWriter printWriter, PgSchema pgSchema, PgSchema pgSchema2, SearchPathHelper searchPathHelper) {
        for (PgTable pgTable : pgSchema2.getTables()) {
            PgTable pgTable2;
            String string = pgTable.getName();
            if (pgSchema == null || (pgTable2 = pgSchema.getTable(string)) == null) continue;
            for (PgPolicy pgPolicy : pgTable2.getPolicies()) {
                if (pgTable.getPolicy(pgPolicy.getName()) != null) continue;
                searchPathHelper.outputSearchPath(printWriter);
                PgDiffPolicies.dropPolicySQL(printWriter, pgPolicy);
            }
        }
    }

    private static void createPolicySQL(PrintWriter printWriter, PgPolicy pgPolicy) {
        printWriter.print("CREATE POLICY " + PgDiffUtils.getQuotedName(pgPolicy.getName()) + " ON " + PgDiffUtils.getQuotedName(pgPolicy.getTableName()));
        printWriter.print(" FOR " + pgPolicy.getCommand());
        String string = "";
        printWriter.print(" TO ");
        Iterator<String> iterator = pgPolicy.getRoles().iterator();
        while (iterator.hasNext()) {
            string = string + iterator.next() + (iterator.hasNext() ? ", " : "");
        }
        printWriter.print(string);
        if (pgPolicy.getUsing() != null) {
            printWriter.println();
            printWriter.println("USING (");
            printWriter.print("  ");
            printWriter.println(pgPolicy.getUsing());
            printWriter.print(")");
        }
        if (pgPolicy.getWithCheck() != null) {
            printWriter.println();
            printWriter.println("WITH CHECK (");
            printWriter.print("  ");
            printWriter.println(pgPolicy.getWithCheck());
            printWriter.print(")");
        }
        printWriter.println(";");
    }

    private static void alterPolicySQL(PrintWriter printWriter, PgPolicy pgPolicy) {
        printWriter.print("ALTER POLICY " + PgDiffUtils.getQuotedName(pgPolicy.getName()) + " ON " + PgDiffUtils.getQuotedName(pgPolicy.getTableName()));
        String string = "";
        printWriter.print(" TO ");
        Iterator<String> iterator = pgPolicy.getRoles().iterator();
        while (iterator.hasNext()) {
            string = string + iterator.next() + (iterator.hasNext() ? ", " : "");
        }
        printWriter.print(string);
        if (pgPolicy.getUsing() != null) {
            printWriter.println();
            printWriter.println("USING (");
            printWriter.print("  ");
            printWriter.println(pgPolicy.getUsing());
            printWriter.print(")");
        }
        if (pgPolicy.getWithCheck() != null) {
            printWriter.println();
            printWriter.println("WITH CHECK (");
            printWriter.print("  ");
            printWriter.println(pgPolicy.getWithCheck());
            printWriter.print(")");
        }
        printWriter.println(";");
    }

    private static void dropPolicySQL(PrintWriter printWriter, PgPolicy pgPolicy) {
        printWriter.println("DROP POLICY " + PgDiffUtils.getQuotedName(pgPolicy.getName()) + " ON " + PgDiffUtils.getQuotedName(pgPolicy.getTableName()) + ";");
    }

    private PgDiffPolicies() {
    }
}

