/*
 * This file was automatically generated by EvoSuite
 * Wed Sep 19 21:02:25 GMT 2018
 */

package uk.ac.sanger.artemis;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.util.NoSuchElementException;
import javax.swing.JLayeredPane;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.ActionController;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntryChangeEvent;
import uk.ac.sanger.artemis.EntryGroupChangeListener;
import uk.ac.sanger.artemis.EntryVector;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureChangeEvent;
import uk.ac.sanger.artemis.FeatureFromVectorPredicate;
import uk.ac.sanger.artemis.FeatureKeyPredicate;
import uk.ac.sanger.artemis.FeatureKeyQualifierPredicate;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.FilteredEntryGroup;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.PartialSequence;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.sequence.Bases;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class SimpleEntryGroup_ESTest extends SimpleEntryGroup_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      Entry entry0 = simpleEntryGroup0.createEntry("Overlaying a GFF with a sequence onto an entry with a sequence.");
      assertNotNull(entry0);
      assertEquals(1, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertFalse(entry0.isReadOnly());
      
      // Undeclared exception!
      try { 
        simpleEntryGroup0.getFeaturesInIndexRange(0, 0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - index out of range: 0
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      simpleEntryGroup0.ref();
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(1, simpleEntryGroup0.refCount());
      
      simpleEntryGroup0.ref();
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(2, simpleEntryGroup0.refCount());
      
      simpleEntryGroup0.unref();
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(1, simpleEntryGroup0.refCount());
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("htsjdk.variant.vcf.VCFFilterHeaderLine", "htsjdk.variant.vcf.VCFFilterHeaderLine");
      assertNotNull(fastaStreamSequence0);
      assertEquals(31, fastaStreamSequence0.getOtherCount());
      assertEquals(1, fastaStreamSequence0.getCCount());
      assertEquals(38, fastaStreamSequence0.length());
      assertEquals(3, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.getACount());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertNotNull(bases0);
      assertEquals(31, fastaStreamSequence0.getOtherCount());
      assertEquals(1, fastaStreamSequence0.getCCount());
      assertEquals(38, fastaStreamSequence0.length());
      assertEquals(3, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(38, bases0.getLength());
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      assertNotNull(simpleEntryGroup0);
      assertEquals(31, fastaStreamSequence0.getOtherCount());
      assertEquals(1, fastaStreamSequence0.getCCount());
      assertEquals(38, fastaStreamSequence0.length());
      assertEquals(3, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(38, bases0.getLength());
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(38, simpleEntryGroup0.getSequenceLength());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      
      simpleEntryGroup0.reverseComplement();
      assertEquals(31, fastaStreamSequence0.getOtherCount());
      assertEquals(38, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getTCount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(38, bases0.getLength());
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(38, simpleEntryGroup0.getSequenceLength());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      Key key0 = Key.CDS;
      assertNotNull(key0);
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, "k.X;yk^oZsCN:", "Dhg[og u!$?K)mnB");
      assertNotNull(featureKeyQualifierPredicate0);
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyQualifierPredicate0, "");
      assertNotNull(filteredEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals(0, filteredEntryGroup0.size());
      assertEquals("", filteredEntryGroup0.getFilterName());
      assertEquals(0, filteredEntryGroup0.refCount());
      
      Entry entry0 = filteredEntryGroup0.createEntry();
      assertNotNull(entry0);
      assertEquals(1, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals(1, filteredEntryGroup0.size());
      assertEquals("", filteredEntryGroup0.getFilterName());
      assertEquals(0, filteredEntryGroup0.refCount());
      assertFalse(entry0.isReadOnly());
      
      boolean boolean0 = simpleEntryGroup0.removeElement(entry0);
      assertTrue(boolean0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals(0, filteredEntryGroup0.size());
      assertEquals("", filteredEntryGroup0.getFilterName());
      assertEquals(0, filteredEntryGroup0.refCount());
      assertFalse(entry0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      simpleEntryGroup0.ref();
      assertEquals(1, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      int int0 = simpleEntryGroup0.refCount();
      assertEquals(1, int0);
      assertEquals(1, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      char[] charArray0 = new char[7];
      Short short0 = new Short((short)0);
      assertNotNull(short0);
      assertEquals((short)0, (short)short0);
      
      Integer integer0 = JLayeredPane.DRAG_LAYER;
      assertNotNull(integer0);
      assertEquals(400, (int)integer0);
      
      PartialSequence partialSequence0 = new PartialSequence(charArray0, (-3325), 244, short0, integer0);
      assertNotNull(partialSequence0);
      assertArrayEquals(new char[] {'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'}, charArray0);
      assertEquals(7, charArray0.length);
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(400, (int)partialSequence0.getPhase());
      assertFalse(partialSequence0.isComplement());
      assertEquals((-3325), partialSequence0.length());
      assertEquals(7, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals((short)0, (short)partialSequence0.getStrand());
      
      Bases bases0 = new Bases(partialSequence0);
      assertNotNull(bases0);
      assertArrayEquals(new char[] {'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'}, charArray0);
      assertEquals(7, charArray0.length);
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(400, (int)partialSequence0.getPhase());
      assertFalse(partialSequence0.isComplement());
      assertEquals((-3325), partialSequence0.length());
      assertEquals(7, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals((short)0, (short)partialSequence0.getStrand());
      assertEquals((-3325), bases0.getLength());
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      assertNotNull(simpleEntryGroup0);
      assertArrayEquals(new char[] {'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'}, charArray0);
      assertEquals(7, charArray0.length);
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(400, (int)partialSequence0.getPhase());
      assertFalse(partialSequence0.isComplement());
      assertEquals((-3325), partialSequence0.length());
      assertEquals(7, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals((short)0, (short)partialSequence0.getStrand());
      assertEquals((-3325), bases0.getLength());
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals((-3325), simpleEntryGroup0.getSequenceLength());
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      
      int int0 = simpleEntryGroup0.getSequenceLength();
      assertArrayEquals(new char[] {'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'}, charArray0);
      assertEquals(7, charArray0.length);
      assertEquals((-3325), int0);
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(400, (int)partialSequence0.getPhase());
      assertFalse(partialSequence0.isComplement());
      assertEquals((-3325), partialSequence0.length());
      assertEquals(7, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals((short)0, (short)partialSequence0.getStrand());
      assertEquals((-3325), bases0.getLength());
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals((-3325), simpleEntryGroup0.getSequenceLength());
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      Entry entry0 = simpleEntryGroup0.createEntry();
      assertNotNull(entry0);
      assertEquals(1, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertFalse(entry0.isReadOnly());
      
      Entry entry1 = simpleEntryGroup0.getDefaultEntry();
      assertNotNull(entry1);
      assertEquals(1, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertFalse(entry1.isReadOnly());
      assertSame(entry1, entry0);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("y:#");
      assertNotNull(emblStreamSequence0);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(3, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getTCount());
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertNotNull(bases0);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(3, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(3, bases0.getLength());
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      assertNotNull(simpleEntryGroup0);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(3, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(3, bases0.getLength());
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(3, simpleEntryGroup0.getSequenceLength());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      
      Bases bases1 = simpleEntryGroup0.getBases();
      assertNotNull(bases1);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(3, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(3, bases0.getLength());
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(3, simpleEntryGroup0.getSequenceLength());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(3, bases1.getLength());
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      Entry entry0 = simpleEntryGroup0.createEntry();
      assertNotNull(entry0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      assertFalse(entry0.isReadOnly());
      
      EntryVector entryVector0 = simpleEntryGroup0.getActiveEntries();
      assertNotNull(entryVector0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      assertEquals(1, entryVector0.size());
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      Range range0 = new Range(1196, 1196);
      assertNotNull(range0);
      assertEquals(1, range0.getCount());
      assertEquals(1196, range0.getStart());
      assertEquals(1196, range0.getEnd());
      
      // Undeclared exception!
      try { 
        simpleEntryGroup0.truncate(range0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      // Undeclared exception!
      try { 
        simpleEntryGroup0.setIsActive((Entry) null, false);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      // Undeclared exception!
      try { 
        simpleEntryGroup0.setIsActive(938, true);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 938 >= 0
         //
         verifyException("java.util.Vector", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      Entry entry0 = simpleEntryGroup0.createEntry("Overlaying a GFF with a sequence onto an entry with a sequence.");
      assertNotNull(entry0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      assertFalse(entry0.isReadOnly());
      
      boolean boolean0 = simpleEntryGroup0.remove(entry0);
      assertTrue(boolean0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      assertFalse(entry0.isReadOnly());
      
      // Undeclared exception!
      try { 
        simpleEntryGroup0.remove(entry0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      Key key0 = Key.CDS;
      assertNotNull(key0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, "", "uk.ac.sanger.artemis.SimpleEntryGroup$FeatureEnumerator");
      assertNotNull(featureKeyQualifierPredicate0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyQualifierPredicate0, "");
      assertNotNull(filteredEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(0, filteredEntryGroup0.refCount());
      assertEquals("", filteredEntryGroup0.getFilterName());
      assertEquals(0, filteredEntryGroup0.size());
      
      // Undeclared exception!
      try { 
        simpleEntryGroup0.entryChanged((EntryChangeEvent) null);
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // uk.ac.sanger.artemis.FilteredEntryGroup$2 cannot be cast to uk.ac.sanger.artemis.FeatureChangeListener
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      Entry entry0 = simpleEntryGroup0.createEntry();
      assertNotNull(entry0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      assertFalse(entry0.isReadOnly());
      
      // Undeclared exception!
      simpleEntryGroup0.createEntry("");
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      // Undeclared exception!
      try { 
        simpleEntryGroup0.add((Entry) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      // Undeclared exception!
      try { 
        simpleEntryGroup0.addElement((Entry) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      Key key0 = new Key("");
      assertNotNull(key0);
      assertEquals("", key0.getKeyString());
      assertEquals(0, key0.length());
      assertEquals("", key0.toString());
      
      FeatureKeyPredicate featureKeyPredicate0 = new FeatureKeyPredicate(key0);
      assertNotNull(featureKeyPredicate0);
      assertEquals("", key0.getKeyString());
      assertEquals(0, key0.length());
      assertEquals("", key0.toString());
      
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyPredicate0, "");
      assertNotNull(filteredEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals("", key0.getKeyString());
      assertEquals(0, key0.length());
      assertEquals("", key0.toString());
      assertEquals(0, filteredEntryGroup0.size());
      assertEquals(0, filteredEntryGroup0.refCount());
      assertEquals("", filteredEntryGroup0.getFilterName());
      
      Entry entry0 = filteredEntryGroup0.createEntry();
      assertNotNull(entry0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      assertEquals("", key0.getKeyString());
      assertEquals(0, key0.length());
      assertEquals("", key0.toString());
      assertEquals(1, filteredEntryGroup0.size());
      assertEquals(0, filteredEntryGroup0.refCount());
      assertEquals("", filteredEntryGroup0.getFilterName());
      assertFalse(entry0.isReadOnly());
      
      simpleEntryGroup0.addElement(entry0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      assertEquals("", key0.getKeyString());
      assertEquals(0, key0.length());
      assertEquals("", key0.toString());
      assertEquals(1, filteredEntryGroup0.size());
      assertEquals(0, filteredEntryGroup0.refCount());
      assertEquals("", filteredEntryGroup0.getFilterName());
      assertFalse(entry0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      Entry entry0 = simpleEntryGroup0.createEntry();
      assertNotNull(entry0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      assertFalse(entry0.isReadOnly());
      
      // Undeclared exception!
      try { 
        simpleEntryGroup0.featureAt(8823);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - index out of range: 8823
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      // Undeclared exception!
      try { 
        simpleEntryGroup0.featureAt((-739));
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - index out of range: -739
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      Entry entry0 = simpleEntryGroup0.createEntry();
      assertNotNull(entry0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      assertFalse(entry0.isReadOnly());
      
      boolean boolean0 = simpleEntryGroup0.isReadOnly();
      assertFalse(boolean0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      Entry entry0 = simpleEntryGroup0.createEntry();
      assertNotNull(entry0);
      assertEquals(1, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertFalse(entry0.isReadOnly());
      
      simpleEntryGroup0.setIsActive(0, true);
      assertEquals(1, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      Entry entry0 = simpleEntryGroup0.createEntry();
      assertNotNull(entry0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      assertFalse(entry0.isReadOnly());
      
      boolean boolean0 = simpleEntryGroup0.isActive(entry0);
      assertTrue(boolean0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      assertFalse(entry0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      boolean boolean0 = simpleEntryGroup0.isActive((Entry) null);
      assertFalse(boolean0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      Entry entry0 = simpleEntryGroup0.createEntry("Overlaying  GFF with a seqNence onto an entry with a sequence.");
      assertNotNull(entry0);
      assertEquals(1, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertFalse(entry0.isReadOnly());
      
      simpleEntryGroup0.setDefaultEntry(entry0);
      assertEquals(1, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertFalse(entry0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      simpleEntryGroup0.setDefaultEntry((Entry) null);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      simpleEntryGroup0.removeEntryGroupChangeListener((EntryGroupChangeListener) null);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      ActionController actionController0 = simpleEntryGroup0.getActionController();
      assertNotNull(actionController0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertFalse(actionController0.canUndo());
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      // Undeclared exception!
      try { 
        simpleEntryGroup0.removeElement((Entry) null);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      simpleEntryGroup0.addEntryGroupChangeListener((EntryGroupChangeListener) null);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      Key key0 = new Key(" does not have suitable constructor");
      assertNotNull(key0);
      assertEquals(" does not have suitable constructor", key0.getKeyString());
      assertEquals(" does not have suitable constructor", key0.toString());
      assertEquals(35, key0.length());
      
      FeatureKeyPredicate featureKeyPredicate0 = new FeatureKeyPredicate(key0);
      assertNotNull(featureKeyPredicate0);
      assertEquals(" does not have suitable constructor", key0.getKeyString());
      assertEquals(" does not have suitable constructor", key0.toString());
      assertEquals(35, key0.length());
      
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyPredicate0, " does not have suitable constructor");
      assertNotNull(filteredEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(" does not have suitable constructor", key0.getKeyString());
      assertEquals(" does not have suitable constructor", key0.toString());
      assertEquals(35, key0.length());
      assertEquals(0, filteredEntryGroup0.refCount());
      assertEquals(0, filteredEntryGroup0.size());
      assertEquals(" does not have suitable constructor", filteredEntryGroup0.getFilterName());
      
      Entry entry0 = filteredEntryGroup0.createEntry();
      assertNotNull(entry0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      assertEquals(" does not have suitable constructor", key0.getKeyString());
      assertEquals(" does not have suitable constructor", key0.toString());
      assertEquals(35, key0.length());
      assertEquals(0, filteredEntryGroup0.refCount());
      assertEquals(1, filteredEntryGroup0.size());
      assertEquals(" does not have suitable constructor", filteredEntryGroup0.getFilterName());
      assertFalse(entry0.isReadOnly());
      
      simpleEntryGroup0.addFeatureChangeListener(entry0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      assertEquals(" does not have suitable constructor", key0.getKeyString());
      assertEquals(" does not have suitable constructor", key0.toString());
      assertEquals(35, key0.length());
      assertEquals(0, filteredEntryGroup0.refCount());
      assertEquals(1, filteredEntryGroup0.size());
      assertEquals(" does not have suitable constructor", filteredEntryGroup0.getFilterName());
      assertFalse(entry0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      Entry entry0 = simpleEntryGroup0.getDefaultEntry();
      assertNull(entry0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      Bases bases0 = simpleEntryGroup0.getBases();
      assertNull(bases0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      simpleEntryGroup0.entryChanged((EntryChangeEvent) null);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      EntryVector entryVector0 = simpleEntryGroup0.getActiveEntries();
      assertNotNull(entryVector0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, entryVector0.size());
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      SimpleEntryGroup.FeatureEnumerator simpleEntryGroup_FeatureEnumerator0 = simpleEntryGroup0.new FeatureEnumerator();
      assertNotNull(simpleEntryGroup_FeatureEnumerator0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      try { 
        simpleEntryGroup_FeatureEnumerator0.nextFeature();
        fail("Expecting exception: NoSuchElementException");
      
      } catch(NoSuchElementException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup$FeatureEnumerator", e);
      }
  }

  @Test(timeout = 4000)
  public void test36()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      Entry entry0 = simpleEntryGroup0.createEntry((String) null);
      assertNotNull(entry0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      assertFalse(entry0.isReadOnly());
      
      SimpleEntryGroup.FeatureEnumerator simpleEntryGroup_FeatureEnumerator0 = simpleEntryGroup0.new FeatureEnumerator();
      assertNotNull(simpleEntryGroup_FeatureEnumerator0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      
      // Undeclared exception!
      try { 
        simpleEntryGroup_FeatureEnumerator0.nextFeature();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Entry", e);
      }
  }

  @Test(timeout = 4000)
  public void test37()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      FeatureVector featureVector0 = new FeatureVector();
      assertNotNull(featureVector0);
      
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "uk.ac.sanger.artemis.SimpleEntryGroup$FeatureEnumerator");
      assertNotNull(filteredEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, filteredEntryGroup0.refCount());
      assertEquals(0, filteredEntryGroup0.size());
      assertEquals("uk.ac.sanger.artemis.SimpleEntryGroup$FeatureEnumerator", filteredEntryGroup0.getFilterName());
      
      Entry entry0 = filteredEntryGroup0.createEntry("uk.ac.sanger.artemis.SimpleEntryGroup$FeatureEnumerator");
      assertNotNull(entry0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      assertEquals(0, filteredEntryGroup0.refCount());
      assertEquals(1, filteredEntryGroup0.size());
      assertEquals("uk.ac.sanger.artemis.SimpleEntryGroup$FeatureEnumerator", filteredEntryGroup0.getFilterName());
      assertFalse(entry0.isReadOnly());
      
      SimpleEntryGroup.FeatureEnumerator simpleEntryGroup_FeatureEnumerator0 = simpleEntryGroup0.new FeatureEnumerator();
      assertNotNull(simpleEntryGroup_FeatureEnumerator0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      
      boolean boolean0 = simpleEntryGroup_FeatureEnumerator0.hasMoreFeatures();
      assertFalse(boolean0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      
      // Undeclared exception!
      try { 
        simpleEntryGroup_FeatureEnumerator0.hasMoreFeatures();
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 2 >= 1
         //
         verifyException("java.util.Vector", e);
      }
  }

  @Test(timeout = 4000)
  public void test38()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      Entry entry0 = simpleEntryGroup0.createEntry();
      assertNotNull(entry0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      assertFalse(entry0.isReadOnly());
      
      // Undeclared exception!
      simpleEntryGroup0.createEntry();
  }

  @Test(timeout = 4000)
  public void test39()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      Entry entry0 = simpleEntryGroup0.createEntry();
      assertNotNull(entry0);
      assertEquals(1, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertFalse(entry0.isReadOnly());
      
      simpleEntryGroup0.add(entry0);
      assertEquals(1, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertFalse(entry0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test40()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      Entry entry0 = simpleEntryGroup0.createEntry("internal error - index out of range: ");
      assertNotNull(entry0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      assertFalse(entry0.isReadOnly());
      
      int int0 = simpleEntryGroup0.getAllFeaturesCount();
      assertEquals(0, int0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
  }

  @Test(timeout = 4000)
  public void test41()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      FeatureVector featureVector0 = new FeatureVector();
      assertNotNull(featureVector0);
      
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "uk.ac.sanger.artemis.SimpleEntryGroup$FeatureEnumerator");
      assertNotNull(filteredEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, filteredEntryGroup0.size());
      assertEquals("uk.ac.sanger.artemis.SimpleEntryGroup$FeatureEnumerator", filteredEntryGroup0.getFilterName());
      assertEquals(0, filteredEntryGroup0.refCount());
      
      Entry entry0 = filteredEntryGroup0.createEntry("uk.ac.sanger.artemis.SimpleEntryGroup$FeatureEnumerator");
      assertNotNull(entry0);
      assertEquals(1, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, filteredEntryGroup0.size());
      assertEquals("uk.ac.sanger.artemis.SimpleEntryGroup$FeatureEnumerator", filteredEntryGroup0.getFilterName());
      assertEquals(0, filteredEntryGroup0.refCount());
      assertFalse(entry0.isReadOnly());
      
      simpleEntryGroup0.setIsActive(entry0, false);
      assertEquals(1, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, filteredEntryGroup0.size());
      assertEquals("uk.ac.sanger.artemis.SimpleEntryGroup$FeatureEnumerator", filteredEntryGroup0.getFilterName());
      assertEquals(0, filteredEntryGroup0.refCount());
      assertFalse(entry0.isReadOnly());
      
      FeatureVector featureVector1 = simpleEntryGroup0.getAllFeatures();
      assertNotNull(featureVector1);
      assertFalse(featureVector1.equals((Object)featureVector0));
      assertEquals(1, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertNotSame(featureVector1, featureVector0);
  }

  @Test(timeout = 4000)
  public void test42()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "uk.ac.sanger.artemis.SimpleEntryGroup$FeatureEnumerator");
      filteredEntryGroup0.createEntry("uk.ac.sanger.artemis.SimpleEntryGroup$FeatureEnumerator");
      simpleEntryGroup0.getAllFeatures();
      assertEquals(0, simpleEntryGroup0.refCount());
  }

  @Test(timeout = 4000)
  public void test43()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FeatureVector featureVector0 = simpleEntryGroup0.getAllFeatures();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "_Ep$9re4G3F,M");
      ActionController actionController0 = filteredEntryGroup0.getActionController();
      simpleEntryGroup0.addEntryChangeListener(actionController0);
      assertEquals(0, filteredEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.refCount());
  }

  @Test(timeout = 4000)
  public void test44()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      simpleEntryGroup0.createEntry("internal error - index out of range: ");
      simpleEntryGroup0.getFeaturesInRange((Range) null);
      assertEquals(0, simpleEntryGroup0.refCount());
  }

  @Test(timeout = 4000)
  public void test45()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      simpleEntryGroup0.getFeaturesInIndexRange(191, 0);
      assertEquals(0, simpleEntryGroup0.refCount());
  }

  @Test(timeout = 4000)
  public void test46()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      // Undeclared exception!
      try { 
        simpleEntryGroup0.getFeaturesInIndexRange((-471), 106);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - index out of range: -471
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test47()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      simpleEntryGroup0.unref();
      int int0 = simpleEntryGroup0.refCount();
      assertEquals((-1), int0);
  }

  @Test(timeout = 4000)
  public void test48()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      // Undeclared exception!
      try { 
        simpleEntryGroup0.reverseComplement();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test49()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      simpleEntryGroup0.getSequenceEntry();
      assertEquals(0, simpleEntryGroup0.refCount());
  }

  @Test(timeout = 4000)
  public void test50()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "uk.ac.sanger.artemis.SimpleEntryGroup$FeatureEnumerator");
      filteredEntryGroup0.createEntry("uk.ac.sanger.artemis.SimpleEntryGroup$FeatureEnumerator");
      Entry entry0 = simpleEntryGroup0.getSequenceEntry();
      assertEquals(0, simpleEntryGroup0.refCount());
      assertNotNull(entry0);
  }

  @Test(timeout = 4000)
  public void test51()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry("Overlaying a GFF with a sequence onto an entry with a sequence.");
      simpleEntryGroup0.setIsActive(entry0, false);
      boolean boolean0 = simpleEntryGroup0.remove(entry0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test52()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      boolean boolean0 = simpleEntryGroup0.contains((Feature) null);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test53()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      simpleEntryGroup0.createEntry("internal error - index out of range: ");
      // Undeclared exception!
      try { 
        simpleEntryGroup0.indexOf((Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Entry", e);
      }
  }

  @Test(timeout = 4000)
  public void test54()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      int int0 = simpleEntryGroup0.indexOf((Feature) null);
      assertEquals((-1), int0);
      assertEquals(0, simpleEntryGroup0.refCount());
  }

  @Test(timeout = 4000)
  public void test55()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry("Overlaying a GFF with a sequence onto an entry with a sequence.");
      simpleEntryGroup0.setIsActive(entry0, false);
      simpleEntryGroup0.setDefaultEntry(entry0);
      assertEquals(0, simpleEntryGroup0.refCount());
  }

  @Test(timeout = 4000)
  public void test56()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      simpleEntryGroup0.createEntry("Overlaying  GFF with a seqNence onto an entry with a sequence.");
      boolean boolean0 = simpleEntryGroup0.hasUnsavedChanges();
      assertFalse(boolean0);
      assertEquals(0, simpleEntryGroup0.refCount());
  }

  @Test(timeout = 4000)
  public void test57()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      simpleEntryGroup0.featureChanged((FeatureChangeEvent) null);
      assertEquals(0, simpleEntryGroup0.refCount());
  }

  @Test(timeout = 4000)
  public void test58()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      simpleEntryGroup0.removeFeatureChangeListener(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
  }

  @Test(timeout = 4000)
  public void test59()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      int int0 = simpleEntryGroup0.refCount();
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test60()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = null;
      try {
        simpleEntryGroup0 = new SimpleEntryGroup((Bases) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test61()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      simpleEntryGroup0.features();
      assertEquals(0, simpleEntryGroup0.refCount());
  }

  @Test(timeout = 4000)
  public void test62()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      // Undeclared exception!
      try { 
        simpleEntryGroup0.createFeature();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test63()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      // Undeclared exception!
      try { 
        simpleEntryGroup0.getSequenceLength();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test64()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      SimpleEntryGroup.FeatureEnumerator simpleEntryGroup_FeatureEnumerator0 = simpleEntryGroup0.new FeatureEnumerator();
      boolean boolean0 = simpleEntryGroup_FeatureEnumerator0.hasMoreFeatures();
      assertEquals(0, simpleEntryGroup0.refCount());
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test65()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Key key0 = new Key(" does not have suitable constructor");
      FeatureKeyPredicate featureKeyPredicate0 = new FeatureKeyPredicate(key0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyPredicate0, " does not have suitable constructor");
      filteredEntryGroup0.createEntry();
      simpleEntryGroup0.ref();
      simpleEntryGroup0.unref();
  }

  @Test(timeout = 4000)
  public void test66()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FeatureFromVectorPredicate featureFromVectorPredicate0 = new FeatureFromVectorPredicate((FeatureVector) null);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureFromVectorPredicate0, "");
      simpleEntryGroup0.removeEntryChangeListener(filteredEntryGroup0);
      assertEquals(0, filteredEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.refCount());
  }
}
