/*
 * This file was automatically generated by EvoSuite
 * Wed Sep 19 21:43:52 GMT 2018
 */

package uk.ac.sanger.artemis.circular;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.File;
import java.util.Vector;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.circular.EmbossCirdnaReader;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class EmbossCirdnaReader_ESTest extends EmbossCirdnaReader_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      EmbossCirdnaReader embossCirdnaReader0 = null;
      try {
        embossCirdnaReader0 = new EmbossCirdnaReader();
        fail("Expecting exception: SecurityException");
      
      } catch(SecurityException e) {
         //
         // Permission Denied
         //
         verifyException("org.evosuite.runtime.System", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      File file0 = mock(File.class, new ViolatedAssumptionAnswer());
      doReturn("").when(file0).getAbsolutePath();
      EmbossCirdnaReader embossCirdnaReader0 = new EmbossCirdnaReader(file0);
      assertTrue(embossCirdnaReader0.isReading());
      assertNotNull(embossCirdnaReader0);
      
      embossCirdnaReader0.start = 1145;
      assertTrue(embossCirdnaReader0.isReading());
      
      int int0 = embossCirdnaReader0.getStart();
      assertTrue(embossCirdnaReader0.isReading());
      assertEquals(1145, int0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.appendStringToFile((EvoSuiteFile) null, "DlrB!l+e/");
      assertFalse(boolean0);
      
      File file0 = mock(File.class, new ViolatedAssumptionAnswer());
      doReturn("#33FFCC", (String) null).when(file0).getAbsolutePath();
      EmbossCirdnaReader embossCirdnaReader0 = new EmbossCirdnaReader(file0);
      assertTrue(embossCirdnaReader0.isReading());
      assertNotNull(embossCirdnaReader0);
      
      // Undeclared exception!
      try { 
        embossCirdnaReader0.readFile();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockFileInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      File file0 = MockFile.createTempFile("htsjdk.samtools.SAMSequenceDictionary", "htsjdk.samtools.SAMSequenceDictionary");
      assertFalse(file0.isDirectory());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.isFile());
      assertTrue(file0.exists());
      assertEquals("htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.getName());
      assertTrue(file0.canRead());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.toString());
      assertEquals(0L, file0.length());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.canExecute());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.canWrite());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertNotNull(file0);
      
      EmbossCirdnaReader embossCirdnaReader0 = new EmbossCirdnaReader(file0);
      assertFalse(file0.isDirectory());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.isFile());
      assertTrue(file0.exists());
      assertEquals("htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.getName());
      assertTrue(file0.canRead());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.toString());
      assertEquals(0L, file0.length());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.canExecute());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.canWrite());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(embossCirdnaReader0.isReading());
      assertNotNull(embossCirdnaReader0);
      
      embossCirdnaReader0.end = 0;
      assertFalse(file0.isDirectory());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.isFile());
      assertTrue(file0.exists());
      assertEquals("htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.getName());
      assertTrue(file0.canRead());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.toString());
      assertEquals(0L, file0.length());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.canExecute());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.canWrite());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(embossCirdnaReader0.isReading());
      
      embossCirdnaReader0.end = 1951;
      assertFalse(file0.isDirectory());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.isFile());
      assertTrue(file0.exists());
      assertEquals("htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.getName());
      assertTrue(file0.canRead());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.toString());
      assertEquals(0L, file0.length());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.canExecute());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.canWrite());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(embossCirdnaReader0.isReading());
      
      int int0 = embossCirdnaReader0.getEnd();
      assertFalse(file0.isDirectory());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.isFile());
      assertTrue(file0.exists());
      assertEquals("htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.getName());
      assertTrue(file0.canRead());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.toString());
      assertEquals(0L, file0.length());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.canExecute());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.canWrite());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(embossCirdnaReader0.isReading());
      assertEquals(1951, int0);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      File file0 = MockFile.createTempFile("htsjdk.samtools.SAMSequenceDictionary", "htsjdk.samtools.SAMSequenceDictionary");
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals("htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.getName());
      assertTrue(file0.canExecute());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.exists());
      assertTrue(file0.canRead());
      assertTrue(file0.isFile());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.length());
      assertTrue(file0.isAbsolute());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.toString());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getFreeSpace());
      assertFalse(file0.isDirectory());
      assertNotNull(file0);
      
      EmbossCirdnaReader embossCirdnaReader0 = new EmbossCirdnaReader(file0);
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals("htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.getName());
      assertTrue(file0.canExecute());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.exists());
      assertTrue(file0.canRead());
      assertTrue(file0.isFile());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.length());
      assertTrue(file0.isAbsolute());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.toString());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getFreeSpace());
      assertFalse(file0.isDirectory());
      assertTrue(embossCirdnaReader0.isReading());
      assertNotNull(embossCirdnaReader0);
      
      embossCirdnaReader0.end = (-109);
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals("htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.getName());
      assertTrue(file0.canExecute());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.exists());
      assertTrue(file0.canRead());
      assertTrue(file0.isFile());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.length());
      assertTrue(file0.isAbsolute());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.toString());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getFreeSpace());
      assertFalse(file0.isDirectory());
      assertTrue(embossCirdnaReader0.isReading());
      
      int int0 = embossCirdnaReader0.getEnd();
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals("htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.getName());
      assertTrue(file0.canExecute());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.exists());
      assertTrue(file0.canRead());
      assertTrue(file0.isFile());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.length());
      assertTrue(file0.isAbsolute());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.toString());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getFreeSpace());
      assertFalse(file0.isDirectory());
      assertTrue(embossCirdnaReader0.isReading());
      assertEquals((-109), int0);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      EmbossCirdnaReader embossCirdnaReader0 = null;
      try {
        embossCirdnaReader0 = new EmbossCirdnaReader((File) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockFileInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      File file0 = MockFile.createTempFile("htsjdk.samtools.SAMSequenceDictionary", "htsjdk.samtools.SAMSequenceDictionary");
      assertEquals("htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.getName());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canExecute());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.toString());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertTrue(file0.canWrite());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.canRead());
      assertTrue(file0.isFile());
      assertTrue(file0.exists());
      assertNotNull(file0);
      
      EmbossCirdnaReader embossCirdnaReader0 = new EmbossCirdnaReader(file0);
      assertEquals("htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.getName());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canExecute());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.toString());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertTrue(file0.canWrite());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.canRead());
      assertTrue(file0.isFile());
      assertTrue(file0.exists());
      assertTrue(embossCirdnaReader0.isReading());
      assertNotNull(embossCirdnaReader0);
      
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary");
      boolean boolean0 = FileSystemHandling.appendStringToFile(evoSuiteFile0, "FGi1^[mQ=f'/|,l{5w");
      assertTrue(boolean0);
      
      Vector vector0 = embossCirdnaReader0.readFile();
      assertEquals("htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.getName());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canExecute());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.toString());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.canWrite());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.canRead());
      assertTrue(file0.isFile());
      assertEquals(18L, file0.length());
      assertTrue(file0.exists());
      assertTrue(embossCirdnaReader0.isReading());
      assertNull(vector0);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      File file0 = MockFile.createTempFile("htsjdk.samtools.SAMSequenceDictionary", "htsjdk.samtools.SAMSequenceDictionary");
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.exists());
      assertTrue(file0.canRead());
      assertTrue(file0.isAbsolute());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertFalse(file0.isDirectory());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.toString());
      assertEquals(0L, file0.length());
      assertTrue(file0.canExecute());
      assertEquals("htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.getName());
      assertTrue(file0.canWrite());
      assertTrue(file0.isFile());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertNotNull(file0);
      
      EmbossCirdnaReader embossCirdnaReader0 = new EmbossCirdnaReader(file0);
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.exists());
      assertTrue(file0.canRead());
      assertTrue(file0.isAbsolute());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertFalse(file0.isDirectory());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.toString());
      assertEquals(0L, file0.length());
      assertTrue(file0.canExecute());
      assertEquals("htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.getName());
      assertTrue(file0.canWrite());
      assertTrue(file0.isFile());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(embossCirdnaReader0.isReading());
      assertNotNull(embossCirdnaReader0);
      
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary");
      boolean boolean0 = FileSystemHandling.appendStringToFile(evoSuiteFile0, "end #9933ffthe current javascript engine (");
      assertTrue(boolean0);
      
      // Undeclared exception!
      try { 
        embossCirdnaReader0.readFile();
        fail("Expecting exception: NumberFormatException");
      
      } catch(NumberFormatException e) {
         //
         // For input string: \"#9933ffthe\"
         //
         verifyException("java.lang.NumberFormatException", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      File file0 = MockFile.createTempFile("htsjdk.samtools.SAMSequenceDictionary", "htsjdk.samtools.SAMSequenceDictionary");
      assertEquals(1392409281320L, file0.lastModified());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.canWrite());
      assertEquals("htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.getName());
      assertEquals(0L, file0.getFreeSpace());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canExecute());
      assertEquals(0L, file0.length());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.toString());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertFalse(file0.isHidden());
      assertTrue(file0.exists());
      assertTrue(file0.canRead());
      assertTrue(file0.isFile());
      assertNotNull(file0);
      
      EmbossCirdnaReader embossCirdnaReader0 = new EmbossCirdnaReader(file0);
      assertEquals(1392409281320L, file0.lastModified());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.canWrite());
      assertEquals("htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.getName());
      assertEquals(0L, file0.getFreeSpace());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canExecute());
      assertEquals(0L, file0.length());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.toString());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertFalse(file0.isHidden());
      assertTrue(file0.exists());
      assertTrue(file0.canRead());
      assertTrue(file0.isFile());
      assertTrue(embossCirdnaReader0.isReading());
      assertNotNull(embossCirdnaReader0);
      
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary");
      boolean boolean0 = FileSystemHandling.appendLineToFile(evoSuiteFile0, "grouphtsjdk.samtools.samsequencedictionary");
      assertTrue(boolean0);
      
      boolean boolean1 = FileSystemHandling.appendLineToFile(evoSuiteFile0, "grouphtsjdk.samtools.samsequencedictionary");
      assertTrue(boolean1 == boolean0);
      assertTrue(boolean1);
      
      Vector vector0 = embossCirdnaReader0.readFile();
      assertEquals(1392409281320L, file0.lastModified());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(86L, file0.length());
      assertTrue(file0.canWrite());
      assertEquals("htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.getName());
      assertEquals(0L, file0.getFreeSpace());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canExecute());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.toString());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertFalse(file0.isHidden());
      assertTrue(file0.exists());
      assertTrue(file0.canRead());
      assertTrue(file0.isFile());
      assertTrue(embossCirdnaReader0.isReading());
      assertNull(vector0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      File file0 = MockFile.createTempFile("htsjdk.samtools.SAMSequenceDictionary", "htsjdk.samtools.SAMSequenceDictionary");
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals("htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.getName());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.toString());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.isAbsolute());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.length());
      assertTrue(file0.canExecute());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.isFile());
      assertTrue(file0.exists());
      assertTrue(file0.canRead());
      assertNotNull(file0);
      
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary");
      boolean boolean0 = FileSystemHandling.appendStringToFile(evoSuiteFile0, "end #9933ffthe current javascript engine (");
      assertTrue(boolean0);
      
      EmbossCirdnaReader embossCirdnaReader0 = null;
      try {
        embossCirdnaReader0 = new EmbossCirdnaReader(file0);
        fail("Expecting exception: NumberFormatException");
      
      } catch(NumberFormatException e) {
         //
         // For input string: \"#9933ffthe\"
         //
         verifyException("java.lang.NumberFormatException", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary");
      boolean boolean0 = FileSystemHandling.appendStringToFile(evoSuiteFile0, "start ");
      assertTrue(boolean0);
      
      File file0 = MockFile.createTempFile("htsjdk.samtools.SAMSequenceDictionary", "htsjdk.samtools.SAMSequenceDictionary");
      assertTrue(file0.exists());
      assertEquals(0L, file0.getFreeSpace());
      assertFalse(file0.isDirectory());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.toString());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.canRead());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(6L, file0.length());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals("htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.getName());
      assertTrue(file0.canWrite());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(file0.isFile());
      assertTrue(file0.canExecute());
      assertTrue(file0.isAbsolute());
      assertNotNull(file0);
      
      EmbossCirdnaReader embossCirdnaReader0 = new EmbossCirdnaReader(file0);
      assertTrue(file0.exists());
      assertEquals(0L, file0.getFreeSpace());
      assertFalse(file0.isDirectory());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.toString());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.canRead());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(6L, file0.length());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals("htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.getName());
      assertTrue(file0.canWrite());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(file0.isFile());
      assertTrue(file0.canExecute());
      assertTrue(file0.isAbsolute());
      assertTrue(embossCirdnaReader0.isReading());
      assertNotNull(embossCirdnaReader0);
      
      boolean boolean1 = FileSystemHandling.appendLineToFile(evoSuiteFile0, "grouphtsjdk.samtools.samsequencedictionary");
      assertTrue(boolean1 == boolean0);
      assertTrue(boolean1);
      
      // Undeclared exception!
      try { 
        embossCirdnaReader0.readFile();
        fail("Expecting exception: NumberFormatException");
      
      } catch(NumberFormatException e) {
         //
         // For input string: \"grouphtsjdk.samtools.samsequencedictionary\"
         //
         verifyException("java.lang.NumberFormatException", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      File file0 = MockFile.createTempFile("htsjdk.samtools.SAMSequenceDictionary", "htsjdk.samtools.SAMSequenceDictionary");
      assertEquals("htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.getName());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.toString());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(file0.isAbsolute());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.length());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.canExecute());
      assertTrue(file0.exists());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertNotNull(file0);
      
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary");
      byte[] byteArray0 = new byte[3];
      boolean boolean0 = FileSystemHandling.appendDataToFile(evoSuiteFile0, byteArray0);
      assertTrue(boolean0);
      assertEquals(3, byteArray0.length);
      assertArrayEquals(new byte[] {(byte)0, (byte)0, (byte)0}, byteArray0);
      
      EmbossCirdnaReader embossCirdnaReader0 = new EmbossCirdnaReader(file0);
      assertEquals("htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.getName());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.toString());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(file0.isAbsolute());
      assertFalse(file0.isHidden());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.isFile());
      assertEquals(3L, file0.length());
      assertTrue(file0.canRead());
      assertTrue(file0.canExecute());
      assertTrue(file0.exists());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertTrue(embossCirdnaReader0.isReading());
      assertNotNull(embossCirdnaReader0);
      
      Vector vector0 = embossCirdnaReader0.readFile();
      assertEquals("htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.getName());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.toString());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(file0.isAbsolute());
      assertFalse(file0.isHidden());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.isFile());
      assertEquals(3L, file0.length());
      assertTrue(file0.canRead());
      assertTrue(file0.canExecute());
      assertTrue(file0.exists());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertTrue(embossCirdnaReader0.isReading());
      assertNull(vector0);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      File file0 = MockFile.createTempFile("htsjdk.samtools.SAMSequenceDictionary", "htsjdk.samtools.SAMSequenceDictionary");
      assertEquals(1392409281320L, file0.lastModified());
      assertTrue(file0.exists());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertTrue(file0.canWrite());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.isFile());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canRead());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.toString());
      assertEquals(0L, file0.length());
      assertEquals("htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.getName());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.canExecute());
      assertNotNull(file0);
      
      EmbossCirdnaReader embossCirdnaReader0 = new EmbossCirdnaReader(file0);
      assertEquals(1392409281320L, file0.lastModified());
      assertTrue(file0.exists());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertTrue(file0.canWrite());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.isFile());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canRead());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.toString());
      assertEquals(0L, file0.length());
      assertEquals("htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.getName());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.canExecute());
      assertTrue(embossCirdnaReader0.isReading());
      assertNotNull(embossCirdnaReader0);
      
      int int0 = embossCirdnaReader0.getStart();
      assertEquals(1392409281320L, file0.lastModified());
      assertTrue(file0.exists());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertTrue(file0.canWrite());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.isFile());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canRead());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.toString());
      assertEquals(0L, file0.length());
      assertEquals("htsjdk.samtools.SAMSequenceDictionary0htsjdk.samtools.SAMSequenceDictionary", file0.getName());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.canExecute());
      assertTrue(embossCirdnaReader0.isReading());
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      File file0 = MockFile.createTempFile("htsjdk.samtools.SAMSequenceDictionary", "htsjdk.samtools.SAMSequenceDictionary");
      EmbossCirdnaReader embossCirdnaReader0 = new EmbossCirdnaReader(file0);
      int int0 = embossCirdnaReader0.getEnd();
      assertEquals(0, int0);
  }
}
