/*
 * This file was automatically generated by EvoSuite
 * Wed Sep 19 22:02:28 GMT 2018
 */

package uk.ac.sanger.artemis.cramtools.ref;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.cramtools.ref.ReferenceRegion;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class ReferenceRegion_ESTest extends ReferenceRegion_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      byte[] byteArray0 = new byte[8];
      ReferenceRegion referenceRegion0 = new ReferenceRegion(byteArray0, (byte)1, "$O3:I0{h", 1L);
      referenceRegion0.md5((-4142), 0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      byte[] byteArray0 = new byte[0];
      ReferenceRegion referenceRegion0 = new ReferenceRegion(byteArray0, 1498, "", 1498);
      referenceRegion0.md5(1498, 1498);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      byte[] byteArray0 = new byte[3];
      ReferenceRegion referenceRegion0 = ReferenceRegion.copyRegion(byteArray0, (byte)89, "", (byte)24, 0L);
      referenceRegion0.md5(2311, 2311);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      byte[] byteArray0 = new byte[7];
      ReferenceRegion referenceRegion0 = ReferenceRegion.wrap(byteArray0, (byte)116, "");
      // Undeclared exception!
      try { 
        referenceRegion0.copy((byte)3, (-2297));
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // The alignment position is out of the region: 1, -2294, 0, -2295
         //
         verifyException("uk.ac.sanger.artemis.cramtools.ref.ReferenceRegion", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      byte[] byteArray0 = new byte[5];
      ReferenceRegion referenceRegion0 = new ReferenceRegion(byteArray0, (byte) (-116), (String) null, 1L);
      referenceRegion0.toString();
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      byte[] byteArray0 = new byte[5];
      ReferenceRegion referenceRegion0 = ReferenceRegion.wrap(byteArray0, (byte)11, (String) null);
      referenceRegion0.copySafe((long) (byte)86, 32);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      byte[] byteArray0 = new byte[19];
      ReferenceRegion referenceRegion0 = new ReferenceRegion(byteArray0, (byte)73, (String) null, (byte)73);
      referenceRegion0.copy((byte)73, 0);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      byte[] byteArray0 = new byte[4];
      ReferenceRegion referenceRegion0 = ReferenceRegion.wrap(byteArray0, (byte)0, (String) null);
      referenceRegion0.base((byte)4);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      byte[] byteArray0 = new byte[4];
      byteArray0[3] = (byte)4;
      ReferenceRegion referenceRegion0 = ReferenceRegion.wrap(byteArray0, (byte)0, (String) null);
      referenceRegion0.base((byte)4);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      byte[] byteArray0 = new byte[2];
      byteArray0[0] = (byte) (-74);
      ReferenceRegion referenceRegion0 = ReferenceRegion.wrap(byteArray0, (byte)0, "[rW>G");
      referenceRegion0.base(1L);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      byte[] byteArray0 = new byte[7];
      ReferenceRegion referenceRegion0 = ReferenceRegion.wrap(byteArray0, (-2798), "Cannot create reference from SAMRecord with no CIGAR, read: ");
      referenceRegion0.arrayPosition((byte)2);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      ReferenceRegion referenceRegion0 = ReferenceRegion.wrap((byte[]) null, 15, "*>KL");
      // Undeclared exception!
      try { 
        referenceRegion0.md5(15, 15);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.cramtools.ref.ReferenceRegion", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      byte[] byteArray0 = new byte[2];
      ReferenceRegion referenceRegion0 = ReferenceRegion.wrap(byteArray0, (byte)0, "[rW>G");
      // Undeclared exception!
      try { 
        referenceRegion0.md5((byte)0, (byte) (-74));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      // Undeclared exception!
      try { 
        ReferenceRegion.copySafe((byte[]) null, 0L, (-576), 0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.cramtools.ref.ReferenceRegion", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      byte[] byteArray0 = new byte[4];
      // Undeclared exception!
      try { 
        ReferenceRegion.copySafe(byteArray0, (long) (byte)2, (-1931), 0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      ReferenceRegion referenceRegion0 = ReferenceRegion.wrap((byte[]) null, 21, "\"\"s'kbbL7)#J[B$u%");
      // Undeclared exception!
      try { 
        referenceRegion0.copySafe(0L, 21);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.cramtools.ref.ReferenceRegion", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      byte[] byteArray0 = new byte[3];
      ReferenceRegion referenceRegion0 = ReferenceRegion.wrap(byteArray0, (byte) (-110), "");
      // Undeclared exception!
      try { 
        referenceRegion0.copySafe(0L, (int) (byte) (-110));
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // -1 > -111
         //
         verifyException("java.util.Arrays", e);
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      byte[] byteArray0 = new byte[2];
      ReferenceRegion referenceRegion0 = ReferenceRegion.wrap(byteArray0, (byte)88, "Illegal MD pattern: ");
      // Undeclared exception!
      try { 
        referenceRegion0.copySafe((-225L), (int) (byte)88);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      // Undeclared exception!
      try { 
        ReferenceRegion.copyRegion((byte[]) null, 1214, "", (-146L), (-146L));
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.cramtools.ref.ReferenceRegion", e);
      }
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      byte[] byteArray0 = new byte[0];
      // Undeclared exception!
      try { 
        ReferenceRegion.copyRegion(byteArray0, 61, "MN>v[@[g}A", 0L, 0L);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      byte[] byteArray0 = new byte[5];
      ReferenceRegion referenceRegion0 = ReferenceRegion.wrap(byteArray0, (-1326), "");
      // Undeclared exception!
      try { 
        referenceRegion0.copy(1L, (byte)64);
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // The alignment position is out of the region: 1, 65, 0, 64
         //
         verifyException("uk.ac.sanger.artemis.cramtools.ref.ReferenceRegion", e);
      }
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      ReferenceRegion referenceRegion0 = new ReferenceRegion((byte[]) null, 344, "OH:!;", 344);
      // Undeclared exception!
      try { 
        referenceRegion0.arrayPosition(344);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.cramtools.ref.ReferenceRegion", e);
      }
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      ReferenceRegion referenceRegion0 = null;
      try {
        referenceRegion0 = new ReferenceRegion((byte[]) null, (-390), "Ov?=n$8F-,-Msn A4", (-390));
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.cramtools.ref.ReferenceRegion", e);
      }
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      byte[] byteArray0 = new byte[4];
      byte[] byteArray1 = ReferenceRegion.copySafe(byteArray0, 0L, (int) (byte)0, 963);
      assertEquals(4, byteArray1.length);
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      byte[] byteArray0 = new byte[2];
      // Undeclared exception!
      try { 
        ReferenceRegion.copySafe(byteArray0, 3091L, 497, (-1514));
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // -2594 > -4108
         //
         verifyException("java.util.Arrays", e);
      }
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      byte[] byteArray0 = new byte[2];
      ReferenceRegion referenceRegion0 = new ReferenceRegion(byteArray0, (byte)106, "2Uhi-RXB", (byte)106);
      int int0 = referenceRegion0.arrayPosition((byte)106);
      assertEquals(0, int0);
      assertEquals(106, referenceRegion0.index);
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      byte[] byteArray0 = new byte[5];
      ReferenceRegion referenceRegion0 = ReferenceRegion.wrap(byteArray0, (byte) (-19), "");
      // Undeclared exception!
      try { 
        referenceRegion0.arrayPosition(0L);
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // The alignment position is out of the region: 1, 0, 0, -1
         //
         verifyException("uk.ac.sanger.artemis.cramtools.ref.ReferenceRegion", e);
      }
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      byte[] byteArray0 = new byte[0];
      ReferenceRegion referenceRegion0 = ReferenceRegion.copyRegion(byteArray0, 899, "uk.ac.sanger.artemis.cramtools.ref.ReferenceRegion", 449L, 449L);
      // Undeclared exception!
      try { 
        referenceRegion0.arrayPosition(449L);
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // The alignment position is out of the region: 449, 449, 0, 0
         //
         verifyException("uk.ac.sanger.artemis.cramtools.ref.ReferenceRegion", e);
      }
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      ReferenceRegion referenceRegion0 = ReferenceRegion.wrap((byte[]) null, 4, "~v*8/PgNsi5");
      // Undeclared exception!
      try { 
        referenceRegion0.toString();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.cramtools.ref.ReferenceRegion", e);
      }
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      byte[] byteArray0 = new byte[1];
      ReferenceRegion referenceRegion0 = ReferenceRegion.wrap(byteArray0, 103, "");
      byte[] byteArray1 = ReferenceRegion.copySafe(referenceRegion0.array, (-2287L), 286, 286);
      assertEquals(0, byteArray1.length);
      assertEquals(103, referenceRegion0.index);
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      byte[] byteArray0 = new byte[1];
      ReferenceRegion referenceRegion0 = ReferenceRegion.wrap(byteArray0, 103, ", name=");
      referenceRegion0.alignmentStart = (-1607L);
      // Undeclared exception!
      try { 
        referenceRegion0.base(0L);
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // The alignment position is out of the region: -1607, 0, 0, 1607
         //
         verifyException("uk.ac.sanger.artemis.cramtools.ref.ReferenceRegion", e);
      }
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      byte[] byteArray0 = new byte[5];
      ReferenceRegion referenceRegion0 = ReferenceRegion.wrap(byteArray0, (byte)1, "G(?:([0-9]+)|([ACTGNactgn])|(^[ACTGNactgn]+))");
      assertEquals(1L, referenceRegion0.alignmentStart);
      
      byte[] byteArray1 = referenceRegion0.copy(1L, 4);
      assertEquals(1, referenceRegion0.index);
      assertEquals(4, byteArray1.length);
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      byte[] byteArray0 = new byte[1];
      ReferenceRegion referenceRegion0 = null;
      try {
        referenceRegion0 = new ReferenceRegion(byteArray0, (byte) (-114), "htsjdk.samtools.util.SequenceUtil$SequenceListsDifferException", (-4934L));
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // Invalid reference region1: htsjdk.samtools.util.SequenceUtil$SequenceListsDifferException, -4934, 1.
         //
         verifyException("uk.ac.sanger.artemis.cramtools.ref.ReferenceRegion", e);
      }
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      byte[] byteArray0 = new byte[8];
      ReferenceRegion referenceRegion0 = ReferenceRegion.copyRegion(byteArray0, (byte)4, ", alignntStart=", (byte)4, (byte)4);
      byte[] byteArray1 = referenceRegion0.copySafe((long) (byte)4, (int) (byte)4);
      assertEquals(1, byteArray1.length);
      assertEquals(4, referenceRegion0.index);
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      byte[] byteArray0 = new byte[5];
      // Undeclared exception!
      try { 
        ReferenceRegion.copyRegion(byteArray0, 8, "G(?:([0-9]+)|([ACTGNactgn])|(^[ACTGNactgn]+))", 1L, (-1L));
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // 0 > -1
         //
         verifyException("java.util.Arrays", e);
      }
  }

  @Test(timeout = 4000)
  public void test36()  throws Throwable  {
      ReferenceRegion referenceRegion0 = ReferenceRegion.wrap((byte[]) null, 0, "Sequence dic*ionaries}are not the same size (");
      // Undeclared exception!
      try { 
        referenceRegion0.copy(0, 0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.cramtools.ref.ReferenceRegion", e);
      }
  }

  @Test(timeout = 4000)
  public void test37()  throws Throwable  {
      ReferenceRegion referenceRegion0 = new ReferenceRegion((byte[]) null, 84, (String) null, 84);
      // Undeclared exception!
      try { 
        referenceRegion0.base(84);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.cramtools.ref.ReferenceRegion", e);
      }
  }
}
