/*
 * This file was automatically generated by EvoSuite
 * Wed Jun 06 18:13:22 GMT 2018
 */

package uk.ac.sanger.artemis.sequence;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.sequence.BasePattern;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Marker;
import uk.ac.sanger.artemis.sequence.MarkerRange;
import uk.ac.sanger.artemis.sequence.MarkerRangeVector;
import uk.ac.sanger.artemis.sequence.Strand;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class BasePattern_ESTest extends BasePattern_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      BasePattern basePattern0 = new BasePattern("RN");
      assertNotNull(basePattern0);
      assertEquals((-1), BasePattern.ILLEGAL_PATTERN);
      assertEquals("rn", basePattern0.toString());
      
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence(")`@uHX<`I|t:P2e<^u)");
      assertNotNull(emblStreamSequence0);
      assertEquals(0, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(19, emblStreamSequence0.length());
      assertEquals(18, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(0, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(19, emblStreamSequence0.length());
      assertEquals(18, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      
      Strand strand0 = bases0.getReverseStrand();
      assertNotNull(strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(19, emblStreamSequence0.length());
      assertEquals(18, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      
      Marker marker0 = new Marker(strand0, 5);
      assertNotNull(marker0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(0, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(19, emblStreamSequence0.length());
      assertEquals(18, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(5, marker0.getPosition());
      
      emblStreamSequence0.setFromChar(bases0.letter_index);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(5, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      
      MarkerRange markerRange0 = basePattern0.findMatch(bases0, marker0, (-5), true, false, true);
      assertNull(markerRange0);
      assertEquals((-1), BasePattern.ILLEGAL_PATTERN);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals("rn", basePattern0.toString());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(5, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(5, marker0.getPosition());
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      BasePattern basePattern0 = new BasePattern("G");
      assertNotNull(basePattern0);
      assertEquals((-1), BasePattern.ILLEGAL_PATTERN);
      assertEquals("g", basePattern0.toString());
      
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("G");
      assertNotNull(emblStreamSequence0);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(1, emblStreamSequence0.getOtherCount());
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(1, emblStreamSequence0.getOtherCount());
      
      MarkerRange markerRange0 = basePattern0.findMatch(bases0, (Marker) null, 55, true, true, true);
      assertNull(markerRange0);
      assertEquals((-1), BasePattern.ILLEGAL_PATTERN);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals("g", basePattern0.toString());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(1, emblStreamSequence0.getOtherCount());
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      BasePattern basePattern0 = new BasePattern("WARD");
      assertNotNull(basePattern0);
      assertEquals((-1), BasePattern.ILLEGAL_PATTERN);
      assertEquals("ward", basePattern0.toString());
      
      boolean boolean0 = basePattern0.matches("");
      assertEquals((-1), BasePattern.ILLEGAL_PATTERN);
      assertEquals("ward", basePattern0.toString());
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      BasePattern basePattern0 = new BasePattern("D");
      assertNotNull(basePattern0);
      assertEquals((-1), BasePattern.ILLEGAL_PATTERN);
      assertEquals("d", basePattern0.toString());
      
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("D");
      assertNotNull(emblStreamSequence0);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertNotNull(bases0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      
      emblStreamSequence0.setFromChar(bases0.letter_index);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(5, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      
      MarkerRange markerRange0 = basePattern0.findMatch(bases0, (Marker) null, 55, false, false, true);
      assertNotNull(markerRange0);
      assertEquals((-1), BasePattern.ILLEGAL_PATTERN);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals("d", basePattern0.toString());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(5, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertFalse(markerRange0.isForwardMarker());
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      // Undeclared exception!
      try { 
        BasePattern.patternType((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.BasePattern", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      BasePattern basePattern0 = new BasePattern("D");
      assertNotNull(basePattern0);
      assertEquals((-1), BasePattern.ILLEGAL_PATTERN);
      assertEquals("d", basePattern0.toString());
      
      // Undeclared exception!
      try { 
        basePattern0.matches((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.BasePattern", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      BasePattern basePattern0 = new BasePattern("RN");
      assertNotNull(basePattern0);
      assertEquals((-1), BasePattern.ILLEGAL_PATTERN);
      assertEquals("rn", basePattern0.toString());
      
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence(")`@uHX<`I|t:P2e<^u)");
      assertNotNull(emblStreamSequence0);
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(19, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(18, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(19, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(18, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      
      Strand strand0 = bases0.getReverseStrand();
      assertNotNull(strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(19, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(18, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      
      Marker marker0 = new Marker(strand0, 5);
      assertNotNull(marker0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(19, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(18, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(5, marker0.getPosition());
      
      char[] charArray0 = new char[1];
      emblStreamSequence0.setFromChar(charArray0);
      assertEquals(1, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(1, charArray0.length);
      assertArrayEquals(new char[] {'\u0000'}, charArray0);
      
      // Undeclared exception!
      try { 
        basePattern0.findMatches(bases0, marker0, 127);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      BasePattern basePattern0 = new BasePattern("n");
      assertNotNull(basePattern0);
      assertEquals((-1), BasePattern.ILLEGAL_PATTERN);
      assertEquals("n", basePattern0.toString());
      
      // Undeclared exception!
      try { 
        basePattern0.findMatches((Bases) null, (Marker) null, 0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.BasePattern", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      BasePattern basePattern0 = new BasePattern("D");
      assertNotNull(basePattern0);
      assertEquals((-1), BasePattern.ILLEGAL_PATTERN);
      assertEquals("d", basePattern0.toString());
      
      // Undeclared exception!
      try { 
        basePattern0.findMatch((Bases) null, (Marker) null, 1, false, true, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.BasePattern", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      BasePattern basePattern0 = null;
      try {
        basePattern0 = new BasePattern((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.BasePattern", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      int int0 = BasePattern.patternType("wz!; ri@.Z:q");
      assertEquals((-1), int0);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      int int0 = BasePattern.patternType("k>");
      assertEquals((-1), int0);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      int int0 = BasePattern.patternType("gl5M");
      assertEquals((-1), int0);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      int int0 = BasePattern.patternType("x7D`QcG{Mn_B{bY*");
      assertEquals((-1), int0);
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      int int0 = BasePattern.patternType("bjZr#1aPQheR");
      assertEquals((-1), int0);
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      int int0 = BasePattern.patternType("d");
      assertEquals(1, int0);
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      int int0 = BasePattern.patternType("s");
      assertEquals(1, int0);
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      int int0 = BasePattern.patternType("org biojava.bio.taxa.Ebi/ormat");
      assertEquals((-1), int0);
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      int int0 = BasePattern.patternType("v5[\"v&hyE~eC~");
      assertEquals((-1), int0);
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      int int0 = BasePattern.patternType("attern too short");
      assertEquals((-1), int0);
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      int int0 = BasePattern.patternType("rh");
      assertEquals(1, int0);
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      int int0 = BasePattern.patternType("gf-_oTYDjeK$ih,I");
      assertEquals((-1), int0);
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      BasePattern basePattern0 = new BasePattern("D");
      assertNotNull(basePattern0);
      assertEquals((-1), BasePattern.ILLEGAL_PATTERN);
      assertEquals("d", basePattern0.toString());
      
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("D");
      assertNotNull(emblStreamSequence0);
      assertEquals(1, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertNull(emblStreamSequence0.getHeader());
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertNotNull(bases0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertNull(emblStreamSequence0.getHeader());
      
      emblStreamSequence0.setFromChar(bases0.letter_index);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertEquals(5, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getGCount());
      
      MarkerRange markerRange0 = basePattern0.findMatch(bases0, (Marker) null, 101, false, true, true);
      assertNotNull(markerRange0);
      assertEquals((-1), BasePattern.ILLEGAL_PATTERN);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals("d", basePattern0.toString());
      assertEquals(1, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertEquals(5, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertTrue(markerRange0.isForwardMarker());
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      BasePattern basePattern0 = new BasePattern("D");
      assertNotNull(basePattern0);
      assertEquals((-1), BasePattern.ILLEGAL_PATTERN);
      assertEquals("d", basePattern0.toString());
      
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("D");
      assertNotNull(emblStreamSequence0);
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(1, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getOtherCount());
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertNotNull(bases0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(1, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getOtherCount());
      
      emblStreamSequence0.setFromChar(bases0.letter_index);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getACount());
      assertEquals(5, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getOtherCount());
      
      MarkerRange markerRange0 = basePattern0.findMatch(bases0, (Marker) null, 2, false, false, true);
      assertNull(markerRange0);
      assertEquals((-1), BasePattern.ILLEGAL_PATTERN);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals("d", basePattern0.toString());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getACount());
      assertEquals(5, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getOtherCount());
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      BasePattern basePattern0 = new BasePattern("RN");
      assertNotNull(basePattern0);
      assertEquals((-1), BasePattern.ILLEGAL_PATTERN);
      assertEquals("rn", basePattern0.toString());
      
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence(")`@uHX<`I|t:P2e<^u)");
      assertNotNull(emblStreamSequence0);
      assertEquals(0, emblStreamSequence0.getGCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(19, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(18, emblStreamSequence0.getOtherCount());
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(0, emblStreamSequence0.getGCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(19, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(18, emblStreamSequence0.getOtherCount());
      
      Strand strand0 = bases0.getForwardStrand();
      assertNotNull(strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, emblStreamSequence0.getGCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(19, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(18, emblStreamSequence0.getOtherCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      
      Marker marker0 = new Marker(strand0, 5);
      assertNotNull(marker0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(0, emblStreamSequence0.getGCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(19, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(18, emblStreamSequence0.getOtherCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(5, marker0.getPosition());
      
      MarkerRange markerRange0 = basePattern0.findMatch(bases0, marker0, (-947), false, false, false);
      assertNull(markerRange0);
      assertEquals((-1), BasePattern.ILLEGAL_PATTERN);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals("rn", basePattern0.toString());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(19, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(18, emblStreamSequence0.getOtherCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(5, marker0.getPosition());
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      BasePattern basePattern0 = new BasePattern("D");
      assertNotNull(basePattern0);
      assertEquals((-1), BasePattern.ILLEGAL_PATTERN);
      assertEquals("d", basePattern0.toString());
      
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("D");
      assertNotNull(emblStreamSequence0);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(1, emblStreamSequence0.getOtherCount());
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertNotNull(bases0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(1, emblStreamSequence0.getOtherCount());
      
      MarkerRange markerRange0 = basePattern0.findMatch(bases0, (Marker) null, 101, false, true, true);
      assertNull(markerRange0);
      assertEquals((-1), BasePattern.ILLEGAL_PATTERN);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals("d", basePattern0.toString());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(1, emblStreamSequence0.getOtherCount());
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      int int0 = BasePattern.patternType("yZFcG{~");
      assertEquals((-1), int0);
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      BasePattern basePattern0 = null;
      try {
        basePattern0 = new BasePattern("X.m$-8'ViW$MJG$z");
        fail("Expecting exception: Exception");
      
      } catch(Throwable e) {
         //
         // illegal characters in pattern
         //
         verifyException("uk.ac.sanger.artemis.sequence.BasePattern", e);
      }
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      int int0 = BasePattern.patternType("uk.ac.sanger.artemis.sequence.BasePattern");
      assertEquals((-1), int0);
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      int int0 = BasePattern.patternType("mqF39D+g%");
      assertEquals((-1), int0);
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      int int0 = BasePattern.patternType("pattern too short");
      assertEquals((-1), int0);
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      int int0 = BasePattern.patternType("illegal characters in pattern");
      assertEquals((-1), int0);
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      BasePattern basePattern0 = null;
      try {
        basePattern0 = new BasePattern("VCFHeaderLine: ID cannot contain an equals sign");
        fail("Expecting exception: Exception");
      
      } catch(Throwable e) {
         //
         // illegal characters in pattern
         //
         verifyException("uk.ac.sanger.artemis.sequence.BasePattern", e);
      }
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      int int0 = BasePattern.patternType("net.sf.cglib.core.DebuggingClassWriter");
      assertEquals((-1), int0);
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      int int0 = BasePattern.patternType("c");
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      BasePattern basePattern0 = new BasePattern("WARN");
      assertNotNull(basePattern0);
      assertEquals((-1), BasePattern.ILLEGAL_PATTERN);
      assertEquals("warn", basePattern0.toString());
      
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("illegal characters in pattern");
      assertNotNull(emblStreamSequence0);
      assertEquals(29, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(19, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(2, emblStreamSequence0.getCCount());
      assertEquals(3, emblStreamSequence0.getTCount());
      assertEquals(4, emblStreamSequence0.getACount());
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertNotNull(bases0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(29, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(19, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(2, emblStreamSequence0.getCCount());
      assertEquals(3, emblStreamSequence0.getTCount());
      assertEquals(4, emblStreamSequence0.getACount());
      
      Strand strand0 = bases0.getReverseStrand();
      assertNotNull(strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(29, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(19, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(2, emblStreamSequence0.getCCount());
      assertEquals(3, emblStreamSequence0.getTCount());
      assertEquals(4, emblStreamSequence0.getACount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      
      Marker marker0 = new Marker(strand0, 5);
      assertNotNull(marker0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(29, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(19, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(2, emblStreamSequence0.getCCount());
      assertEquals(3, emblStreamSequence0.getTCount());
      assertEquals(4, emblStreamSequence0.getACount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(5, marker0.getPosition());
      
      bases0.addBases(2, 0, "org.biojava.bio.symbol.FuzzyLocation");
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, emblStreamSequence0.getGCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(6, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getCCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(48, emblStreamSequence0.getOtherCount());
      assertEquals(65, emblStreamSequence0.length());
      assertEquals(6, emblStreamSequence0.getACount());
      
      MarkerRange markerRange0 = basePattern0.findMatch(bases0, marker0, 1, true, false, true);
      assertNull(markerRange0);
      assertEquals((-1), BasePattern.ILLEGAL_PATTERN);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals("warn", basePattern0.toString());
      assertEquals(2, emblStreamSequence0.getGCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(6, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getCCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(48, emblStreamSequence0.getOtherCount());
      assertEquals(65, emblStreamSequence0.length());
      assertEquals(6, emblStreamSequence0.getACount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(5, marker0.getPosition());
  }

  @Test(timeout = 4000)
  public void test36()  throws Throwable  {
      BasePattern basePattern0 = new BasePattern("WARN");
      assertNotNull(basePattern0);
      assertEquals((-1), BasePattern.ILLEGAL_PATTERN);
      assertEquals("warn", basePattern0.toString());
      
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence(")`@uHX<`I|t:P2e<^u)");
      assertNotNull(emblStreamSequence0);
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertEquals(19, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(18, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertNotNull(bases0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertEquals(19, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(18, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      
      emblStreamSequence0.setFromChar(bases0.letter_index);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertEquals(5, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      
      MarkerRangeVector markerRangeVector0 = basePattern0.findMatches(bases0, (Marker) null, (-1242));
      assertNotNull(markerRangeVector0);
      assertEquals((-1), BasePattern.ILLEGAL_PATTERN);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals("warn", basePattern0.toString());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertEquals(5, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, markerRangeVector0.size());
  }

  @Test(timeout = 4000)
  public void test37()  throws Throwable  {
      BasePattern basePattern0 = new BasePattern("MWRN");
      assertNotNull(basePattern0);
      assertEquals((-1), BasePattern.ILLEGAL_PATTERN);
      assertEquals("mwrn", basePattern0.toString());
      
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence(")`@uHX<`I|t:P2e<^u)");
      assertNotNull(emblStreamSequence0);
      assertEquals(0, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertEquals(19, emblStreamSequence0.length());
      assertEquals(18, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getGCount());
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertNotNull(bases0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(0, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertEquals(19, emblStreamSequence0.length());
      assertEquals(18, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getGCount());
      
      MarkerRange markerRange0 = basePattern0.findMatch(bases0, (Marker) null, (-947), true, true, true);
      assertNull(markerRange0);
      assertEquals((-1), BasePattern.ILLEGAL_PATTERN);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals("mwrn", basePattern0.toString());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertEquals(19, emblStreamSequence0.length());
      assertEquals(18, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getGCount());
  }

  @Test(timeout = 4000)
  public void test38()  throws Throwable  {
      BasePattern basePattern0 = new BasePattern("WARN");
      assertNotNull(basePattern0);
      assertEquals((-1), BasePattern.ILLEGAL_PATTERN);
      assertEquals("warn", basePattern0.toString());
      
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("illegal characters in pattern");
      assertNotNull(emblStreamSequence0);
      assertEquals(3, emblStreamSequence0.getTCount());
      assertEquals(4, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(2, emblStreamSequence0.getCCount());
      assertEquals(19, emblStreamSequence0.getOtherCount());
      assertEquals(29, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(3, emblStreamSequence0.getTCount());
      assertEquals(4, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(2, emblStreamSequence0.getCCount());
      assertEquals(19, emblStreamSequence0.getOtherCount());
      assertEquals(29, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      
      Strand strand0 = bases0.getReverseStrand();
      assertNotNull(strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(3, emblStreamSequence0.getTCount());
      assertEquals(4, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(2, emblStreamSequence0.getCCount());
      assertEquals(19, emblStreamSequence0.getOtherCount());
      assertEquals(29, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      
      bases0.addBases(110, (-4721), "illegal characters in pattern");
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(3, emblStreamSequence0.getCCount());
      assertEquals(7, emblStreamSequence0.getTCount());
      assertEquals(58, emblStreamSequence0.length());
      assertEquals(38, emblStreamSequence0.getOtherCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      
      Marker marker0 = new Marker(strand0, 5);
      assertNotNull(marker0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(3, emblStreamSequence0.getCCount());
      assertEquals(7, emblStreamSequence0.getTCount());
      assertEquals(58, emblStreamSequence0.length());
      assertEquals(38, emblStreamSequence0.getOtherCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(5, marker0.getPosition());
      
      MarkerRange markerRange0 = basePattern0.findMatch(bases0, marker0, (-1401), true, true, true);
      assertNull(markerRange0);
      assertEquals((-1), BasePattern.ILLEGAL_PATTERN);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals("warn", basePattern0.toString());
      assertEquals(3, emblStreamSequence0.getCCount());
      assertEquals(7, emblStreamSequence0.getTCount());
      assertEquals(58, emblStreamSequence0.length());
      assertEquals(38, emblStreamSequence0.getOtherCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(5, marker0.getPosition());
  }

  @Test(timeout = 4000)
  public void test39()  throws Throwable  {
      BasePattern basePattern0 = new BasePattern("WARSN");
      assertNotNull(basePattern0);
      assertEquals((-1), BasePattern.ILLEGAL_PATTERN);
      assertEquals("warsn", basePattern0.toString());
      
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("illegal characters in pattern");
      assertNotNull(emblStreamSequence0);
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(3, emblStreamSequence0.getTCount());
      assertEquals(19, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(2, emblStreamSequence0.getCCount());
      assertEquals(29, emblStreamSequence0.length());
      assertEquals(4, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertNotNull(bases0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(3, emblStreamSequence0.getTCount());
      assertEquals(19, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(2, emblStreamSequence0.getCCount());
      assertEquals(29, emblStreamSequence0.length());
      assertEquals(4, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      
      Strand strand0 = bases0.getReverseStrand();
      assertNotNull(strand0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(3, emblStreamSequence0.getTCount());
      assertEquals(19, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(2, emblStreamSequence0.getCCount());
      assertEquals(29, emblStreamSequence0.length());
      assertEquals(4, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      
      Marker marker0 = new Marker(strand0, 5);
      assertNotNull(marker0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(3, emblStreamSequence0.getTCount());
      assertEquals(19, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(2, emblStreamSequence0.getCCount());
      assertEquals(29, emblStreamSequence0.length());
      assertEquals(4, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(5, marker0.getPosition());
      
      MarkerRange markerRange0 = basePattern0.findMatch(bases0, marker0, (-1401), true, true, true);
      assertNull(markerRange0);
      assertEquals((-1), BasePattern.ILLEGAL_PATTERN);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals("warsn", basePattern0.toString());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(3, emblStreamSequence0.getTCount());
      assertEquals(19, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(2, emblStreamSequence0.getCCount());
      assertEquals(29, emblStreamSequence0.length());
      assertEquals(4, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(5, marker0.getPosition());
  }

  @Test(timeout = 4000)
  public void test40()  throws Throwable  {
      BasePattern basePattern0 = new BasePattern("RN");
      assertNotNull(basePattern0);
      assertEquals((-1), BasePattern.ILLEGAL_PATTERN);
      assertEquals("rn", basePattern0.toString());
      
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence(")`@uHX<`I|t:P2e<^u)");
      assertNotNull(emblStreamSequence0);
      assertEquals(19, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(18, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(19, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(18, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      
      Strand strand0 = bases0.getReverseStrand();
      assertNotNull(strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(19, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(18, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      
      Marker marker0 = new Marker(strand0, 5);
      assertNotNull(marker0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(19, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(18, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(5, marker0.getPosition());
      
      emblStreamSequence0.setFromChar(bases0.letter_index);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getACount());
      assertEquals(5, emblStreamSequence0.length());
      
      MarkerRange markerRange0 = basePattern0.findMatch(bases0, marker0, 118, false, true, false);
      assertNotNull(markerRange0);
      assertEquals((-1), BasePattern.ILLEGAL_PATTERN);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals("rn", basePattern0.toString());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getACount());
      assertEquals(5, emblStreamSequence0.length());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(5, marker0.getPosition());
      assertTrue(markerRange0.isForwardMarker());
  }

  @Test(timeout = 4000)
  public void test41()  throws Throwable  {
      BasePattern basePattern0 = new BasePattern("WAm");
      assertNotNull(basePattern0);
      assertEquals((-1), BasePattern.ILLEGAL_PATTERN);
      assertEquals("wam", basePattern0.toString());
      
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence(")`@uHX<`I|t:P2e<^u)");
      assertNotNull(emblStreamSequence0);
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(18, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(19, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertNotNull(bases0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(18, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(19, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      
      emblStreamSequence0.setFromChar(bases0.letter_index);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getOtherCount());
      assertEquals(5, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      
      MarkerRange markerRange0 = basePattern0.findMatch(bases0, (Marker) null, (-947), true, true, true);
      assertNull(markerRange0);
      assertEquals((-1), BasePattern.ILLEGAL_PATTERN);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals("wam", basePattern0.toString());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getOtherCount());
      assertEquals(5, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
  }

  @Test(timeout = 4000)
  public void test42()  throws Throwable  {
      BasePattern basePattern0 = new BasePattern("WAm");
      assertNotNull(basePattern0);
      assertEquals((-1), BasePattern.ILLEGAL_PATTERN);
      assertEquals("wam", basePattern0.toString());
      
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence(")`@uHX<`I|t:P2e<^u)");
      assertNotNull(emblStreamSequence0);
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(18, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(19, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertNotNull(bases0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(18, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(19, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      
      MarkerRange markerRange0 = basePattern0.findMatch(bases0, (Marker) null, (-947), true, true, true);
      assertNull(markerRange0);
      assertEquals((-1), BasePattern.ILLEGAL_PATTERN);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals("wam", basePattern0.toString());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(18, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(19, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
  }

  @Test(timeout = 4000)
  public void test43()  throws Throwable  {
      BasePattern basePattern0 = new BasePattern("D");
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("D");
      Bases bases0 = new Bases(emblStreamSequence0);
      emblStreamSequence0.setFromChar(bases0.letter_index);
      MarkerRangeVector markerRangeVector0 = basePattern0.findMatches(bases0, (Marker) null, 5);
      assertEquals(6, markerRangeVector0.size());
  }

  @Test(timeout = 4000)
  public void test44()  throws Throwable  {
      BasePattern basePattern0 = new BasePattern("D");
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("D");
      Bases bases0 = new Bases(emblStreamSequence0);
      emblStreamSequence0.setFromChar(bases0.letter_index);
      MarkerRange markerRange0 = basePattern0.findMatch(bases0, (Marker) null, 2, true, true, true);
      assertNull(markerRange0);
  }

  @Test(timeout = 4000)
  public void test45()  throws Throwable  {
      BasePattern basePattern0 = new BasePattern("RN");
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence(")`@uHX<`I|t:P2e<^u)");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      Marker marker0 = new Marker(strand0, 5);
      MarkerRange markerRange0 = basePattern0.findMatch(bases0, marker0, (-5), true, true, true);
      assertNull(markerRange0);
  }

  @Test(timeout = 4000)
  public void test46()  throws Throwable  {
      BasePattern basePattern0 = new BasePattern("RN");
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("illegal characters in pattern");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      Marker marker0 = new Marker(strand0, 5);
      MarkerRange markerRange0 = basePattern0.findMatch(bases0, marker0, (-5), true, true, true);
      assertNull(markerRange0);
  }

  @Test(timeout = 4000)
  public void test47()  throws Throwable  {
      BasePattern basePattern0 = new BasePattern("RN");
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence(")`@uHX<`I|t:P2e<^u)");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      Marker marker0 = new Marker(strand0, 5);
      emblStreamSequence0.setFromChar(bases0.letter_index);
      MarkerRange markerRange0 = basePattern0.findMatch(bases0, marker0, 120, true, true, true);
      assertTrue(markerRange0.isForwardMarker());
      assertNotNull(markerRange0);
  }

  @Test(timeout = 4000)
  public void test48()  throws Throwable  {
      BasePattern basePattern0 = new BasePattern("G");
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("G");
      Bases bases0 = new Bases(emblStreamSequence0);
      MarkerRangeVector markerRangeVector0 = basePattern0.findMatches(bases0, (Marker) null, 2);
      assertEquals(0, markerRangeVector0.size());
  }

  @Test(timeout = 4000)
  public void test49()  throws Throwable  {
      BasePattern basePattern0 = new BasePattern("G");
      boolean boolean0 = basePattern0.matches("g");
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test50()  throws Throwable  {
      BasePattern basePattern0 = new BasePattern("G");
      boolean boolean0 = basePattern0.matches("\"_OOy>'7jI");
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test51()  throws Throwable  {
      BasePattern basePattern0 = null;
      try {
        basePattern0 = new BasePattern("");
        fail("Expecting exception: Exception");
      
      } catch(Throwable e) {
         //
         // pattern too short
         //
         verifyException("uk.ac.sanger.artemis.sequence.BasePattern", e);
      }
  }

  @Test(timeout = 4000)
  public void test52()  throws Throwable  {
      BasePattern basePattern0 = new BasePattern("D");
      String string0 = basePattern0.toString();
      assertEquals("d", string0);
  }

  @Test(timeout = 4000)
  public void test53()  throws Throwable  {
      BasePattern basePattern0 = new BasePattern("D");
      boolean boolean0 = basePattern0.matches("d");
      assertFalse(boolean0);
  }
}
