/*
 * Decompiled with CFR 0.152.
 */
package $installer$.org.aspectj;

import $installer$.org.aspectj.ConfigureLauncherPane;
import $installer$.org.aspectj.InstallContext;
import $installer$.org.aspectj.Installer;
import $installer$.org.aspectj.Options;
import $installer$.org.aspectj.WizardPane;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Main {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Properties properties;
        boolean hasGui;
        block27: {
            Options.loadArgs(args);
            hasGui = true;
            properties = new Properties();
            InputStream istream = null;
            try {
                istream = Main.class.getResourceAsStream("resources/properties.txt");
                if (istream == null) {
                    System.err.println("unable to load properties.txt using Main.class - exiting");
                    Main.exit(-1);
                }
                properties.load(istream);
                if (null != Options.textProperties) {
                    istream.close();
                    istream = new FileInputStream(Options.textProperties);
                    properties.load(istream);
                    hasGui = false;
                    break block27;
                }
                if (null == Options.targetDir) break block27;
                String path = null;
                try {
                    path = Options.targetDir.getCanonicalPath();
                }
                catch (IOException e) {
                    path = Options.targetDir.getAbsolutePath();
                }
                String javaPath = ConfigureLauncherPane.getDefaultJavaHomeLocation();
                if (null == javaPath) {
                    System.err.println("using GUI - unable to find java");
                } else {
                    properties.setProperty("output.dir", path);
                    properties.setProperty("context.javaPath", javaPath);
                    hasGui = false;
                }
            }
            catch (IOException ioe) {
                Main.handleException(ioe);
            }
            finally {
                if (null != istream) {
                    try {
                        istream.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        try {
            String className = (String)properties.get("installer.main.class");
            Installer installer2 = (Installer)Class.forName(className).newInstance();
            InstallContext installerContext = new InstallContext(properties);
            installerContext.setHasGui(hasGui);
            installer2.setContext(installerContext);
            if (installerContext.hasGui()) {
                installer2.runGUI();
            } else {
                String propName = "output.dir";
                String propValue = properties.getProperty(propName);
                if (null == propValue) {
                    throw new Exception("expecting property " + propName);
                }
                String outputDirName = propValue;
                propName = "context.javaPath";
                propValue = properties.getProperty(propName);
                if (null == propValue) {
                    throw new Exception("expecting property " + propName);
                }
                String javaPath = propValue;
                File outputDir = new File(outputDirName);
                if (!outputDir.isDirectory()) {
                    throw new Exception("not a dir outputDirName: " + outputDirName + " dir: " + outputDir);
                }
                if (!outputDir.canWrite()) {
                    throw new Exception("cannot write outputDirName: " + outputDirName + " dir: " + outputDir);
                }
                InstallContext context = installer2.getContext();
                context.setOutputDir(outputDir);
                context.javaPath = new File(javaPath);
                if (!outputDir.isDirectory() || !outputDir.canRead()) {
                    throw new Exception("invalid javaPath: " + javaPath);
                }
                WizardPane.setContext(installerContext);
                installer2.run();
            }
        }
        catch (Exception e) {
            Main.handleException(e);
        }
    }

    public static void handleException(Throwable e) {
        System.out.println("internal error: " + e.toString());
        e.printStackTrace();
        Main.exit(-1);
    }

    public static void exit(int value) {
        System.exit(value);
    }
}

