# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "network route-table show",
)
class Show(AAZCommand):
    """Get the details of a route table.

    :example: Get the details of a route table.
        az network route-table show -g MyResourceGroup -n MyRouteTable
    """

    _aaz_info = {
        "version": "2017-10-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.network/routetables/{}", "2017-10-01"],
        ]
    }

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        _args_schema.name = AAZStrArg(
            options=["-n", "--name"],
            help="Name of the route table.",
            required=True,
            id_part="name",
        )
        _args_schema.expand = AAZStrArg(
            options=["--expand"],
            help="Expands referenced resources. Default value is None.",
        )
        return cls._args_schema

    def _execute_operations(self):
        self.RouteTablesGet(ctx=self.ctx)()

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class RouteTablesGet(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeTables/{routeTableName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "routeTableName", self.ctx.args.name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "$expand", self.ctx.args.expand,
                ),
                **self.serialize_query_param(
                    "api-version", "2017-10-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()
            _build_schema_route_table_read(cls._schema_on_200)

            return cls._schema_on_200


_schema_application_security_group_read = None


def _build_schema_application_security_group_read(_schema):
    global _schema_application_security_group_read
    if _schema_application_security_group_read is not None:
        _schema.etag = _schema_application_security_group_read.etag
        _schema.id = _schema_application_security_group_read.id
        _schema.location = _schema_application_security_group_read.location
        _schema.name = _schema_application_security_group_read.name
        _schema.properties = _schema_application_security_group_read.properties
        _schema.tags = _schema_application_security_group_read.tags
        _schema.type = _schema_application_security_group_read.type
        return

    _schema_application_security_group_read = AAZObjectType(
        flags={"read_only": True}
    )

    application_security_group_read = _schema_application_security_group_read
    application_security_group_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    application_security_group_read.id = AAZStrType(
        flags={"read_only": True},
    )
    application_security_group_read.location = AAZStrType(
        flags={"read_only": True},
    )
    application_security_group_read.name = AAZStrType(
        flags={"read_only": True},
    )
    application_security_group_read.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    application_security_group_read.tags = AAZDictType(
        flags={"read_only": True},
    )
    application_security_group_read.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_application_security_group_read.properties
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.resource_guid = AAZStrType(
        serialized_name="resourceGuid",
        flags={"read_only": True},
    )

    tags = _schema_application_security_group_read.tags
    tags.Element = AAZStrType(
        flags={"read_only": True},
    )

    _schema.etag = _schema_application_security_group_read.etag
    _schema.id = _schema_application_security_group_read.id
    _schema.location = _schema_application_security_group_read.location
    _schema.name = _schema_application_security_group_read.name
    _schema.properties = _schema_application_security_group_read.properties
    _schema.tags = _schema_application_security_group_read.tags
    _schema.type = _schema_application_security_group_read.type


_schema_ip_configuration_read = None


def _build_schema_ip_configuration_read(_schema):
    global _schema_ip_configuration_read
    if _schema_ip_configuration_read is not None:
        _schema.etag = _schema_ip_configuration_read.etag
        _schema.id = _schema_ip_configuration_read.id
        _schema.name = _schema_ip_configuration_read.name
        _schema.properties = _schema_ip_configuration_read.properties
        return

    _schema_ip_configuration_read = AAZObjectType(
        flags={"read_only": True}
    )

    ip_configuration_read = _schema_ip_configuration_read
    ip_configuration_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    ip_configuration_read.id = AAZStrType(
        flags={"read_only": True},
    )
    ip_configuration_read.name = AAZStrType(
        flags={"read_only": True},
    )
    ip_configuration_read.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )

    properties = _schema_ip_configuration_read.properties
    properties.private_ip_address = AAZStrType(
        serialized_name="privateIPAddress",
        flags={"read_only": True},
    )
    properties.private_ip_allocation_method = AAZStrType(
        serialized_name="privateIPAllocationMethod",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.public_ip_address = AAZObjectType(
        serialized_name="publicIPAddress",
        flags={"read_only": True},
    )
    _build_schema_public_ip_address_read(properties.public_ip_address)
    properties.subnet = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_subnet_read(properties.subnet)

    _schema.etag = _schema_ip_configuration_read.etag
    _schema.id = _schema_ip_configuration_read.id
    _schema.name = _schema_ip_configuration_read.name
    _schema.properties = _schema_ip_configuration_read.properties


_schema_network_interface_ip_configuration_read = None


def _build_schema_network_interface_ip_configuration_read(_schema):
    global _schema_network_interface_ip_configuration_read
    if _schema_network_interface_ip_configuration_read is not None:
        _schema.etag = _schema_network_interface_ip_configuration_read.etag
        _schema.id = _schema_network_interface_ip_configuration_read.id
        _schema.name = _schema_network_interface_ip_configuration_read.name
        _schema.properties = _schema_network_interface_ip_configuration_read.properties
        return

    _schema_network_interface_ip_configuration_read = AAZObjectType(
        flags={"read_only": True}
    )

    network_interface_ip_configuration_read = _schema_network_interface_ip_configuration_read
    network_interface_ip_configuration_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    network_interface_ip_configuration_read.id = AAZStrType(
        flags={"read_only": True},
    )
    network_interface_ip_configuration_read.name = AAZStrType(
        flags={"read_only": True},
    )
    network_interface_ip_configuration_read.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )

    properties = _schema_network_interface_ip_configuration_read.properties
    properties.application_gateway_backend_address_pools = AAZListType(
        serialized_name="applicationGatewayBackendAddressPools",
        flags={"read_only": True},
    )
    properties.application_security_groups = AAZListType(
        serialized_name="applicationSecurityGroups",
        flags={"read_only": True},
    )
    properties.load_balancer_backend_address_pools = AAZListType(
        serialized_name="loadBalancerBackendAddressPools",
        flags={"read_only": True},
    )
    properties.load_balancer_inbound_nat_rules = AAZListType(
        serialized_name="loadBalancerInboundNatRules",
        flags={"read_only": True},
    )
    properties.primary = AAZBoolType(
        flags={"read_only": True},
    )
    properties.private_ip_address = AAZStrType(
        serialized_name="privateIPAddress",
        flags={"read_only": True},
    )
    properties.private_ip_address_version = AAZStrType(
        serialized_name="privateIPAddressVersion",
        flags={"read_only": True},
    )
    properties.private_ip_allocation_method = AAZStrType(
        serialized_name="privateIPAllocationMethod",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.public_ip_address = AAZObjectType(
        serialized_name="publicIPAddress",
        flags={"read_only": True},
    )
    _build_schema_public_ip_address_read(properties.public_ip_address)
    properties.subnet = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_subnet_read(properties.subnet)

    application_gateway_backend_address_pools = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools
    application_gateway_backend_address_pools.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools.Element.properties
    properties.backend_addresses = AAZListType(
        serialized_name="backendAddresses",
        flags={"read_only": True},
    )
    properties.backend_ip_configurations = AAZListType(
        serialized_name="backendIPConfigurations",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )

    backend_addresses = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools.Element.properties.backend_addresses
    backend_addresses.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools.Element.properties.backend_addresses.Element
    _element.fqdn = AAZStrType(
        flags={"read_only": True},
    )
    _element.ip_address = AAZStrType(
        serialized_name="ipAddress",
        flags={"read_only": True},
    )

    backend_ip_configurations = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools.Element.properties.backend_ip_configurations
    backend_ip_configurations.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_network_interface_ip_configuration_read(backend_ip_configurations.Element)

    application_security_groups = _schema_network_interface_ip_configuration_read.properties.application_security_groups
    application_security_groups.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_application_security_group_read(application_security_groups.Element)

    load_balancer_backend_address_pools = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools
    load_balancer_backend_address_pools.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )

    properties = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties
    properties.backend_ip_configurations = AAZListType(
        serialized_name="backendIPConfigurations",
        flags={"read_only": True},
    )
    properties.load_balancing_rules = AAZListType(
        serialized_name="loadBalancingRules",
        flags={"read_only": True},
    )
    properties.outbound_nat_rule = AAZObjectType(
        serialized_name="outboundNatRule",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.outbound_nat_rule)
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )

    backend_ip_configurations = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties.backend_ip_configurations
    backend_ip_configurations.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_network_interface_ip_configuration_read(backend_ip_configurations.Element)

    load_balancing_rules = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties.load_balancing_rules
    load_balancing_rules.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(load_balancing_rules.Element)

    load_balancer_inbound_nat_rules = _schema_network_interface_ip_configuration_read.properties.load_balancer_inbound_nat_rules
    load_balancer_inbound_nat_rules.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_network_interface_ip_configuration_read.properties.load_balancer_inbound_nat_rules.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )

    properties = _schema_network_interface_ip_configuration_read.properties.load_balancer_inbound_nat_rules.Element.properties
    properties.backend_ip_configuration = AAZObjectType(
        serialized_name="backendIPConfiguration",
        flags={"read_only": True},
    )
    _build_schema_network_interface_ip_configuration_read(properties.backend_ip_configuration)
    properties.backend_port = AAZIntType(
        serialized_name="backendPort",
        flags={"read_only": True},
    )
    properties.enable_floating_ip = AAZBoolType(
        serialized_name="enableFloatingIP",
        flags={"read_only": True},
    )
    properties.frontend_ip_configuration = AAZObjectType(
        serialized_name="frontendIPConfiguration",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.frontend_ip_configuration)
    properties.frontend_port = AAZIntType(
        serialized_name="frontendPort",
        flags={"read_only": True},
    )
    properties.idle_timeout_in_minutes = AAZIntType(
        serialized_name="idleTimeoutInMinutes",
        flags={"read_only": True},
    )
    properties.protocol = AAZStrType(
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )

    _schema.etag = _schema_network_interface_ip_configuration_read.etag
    _schema.id = _schema_network_interface_ip_configuration_read.id
    _schema.name = _schema_network_interface_ip_configuration_read.name
    _schema.properties = _schema_network_interface_ip_configuration_read.properties


_schema_network_security_group_read = None


def _build_schema_network_security_group_read(_schema):
    global _schema_network_security_group_read
    if _schema_network_security_group_read is not None:
        _schema.etag = _schema_network_security_group_read.etag
        _schema.id = _schema_network_security_group_read.id
        _schema.location = _schema_network_security_group_read.location
        _schema.name = _schema_network_security_group_read.name
        _schema.properties = _schema_network_security_group_read.properties
        _schema.tags = _schema_network_security_group_read.tags
        _schema.type = _schema_network_security_group_read.type
        return

    _schema_network_security_group_read = AAZObjectType(
        flags={"read_only": True}
    )

    network_security_group_read = _schema_network_security_group_read
    network_security_group_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    network_security_group_read.id = AAZStrType(
        flags={"read_only": True},
    )
    network_security_group_read.location = AAZStrType(
        flags={"read_only": True},
    )
    network_security_group_read.name = AAZStrType(
        flags={"read_only": True},
    )
    network_security_group_read.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    network_security_group_read.tags = AAZDictType(
        flags={"read_only": True},
    )
    network_security_group_read.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_network_security_group_read.properties
    properties.default_security_rules = AAZListType(
        serialized_name="defaultSecurityRules",
        flags={"read_only": True},
    )
    properties.network_interfaces = AAZListType(
        serialized_name="networkInterfaces",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.resource_guid = AAZStrType(
        serialized_name="resourceGuid",
        flags={"read_only": True},
    )
    properties.security_rules = AAZListType(
        serialized_name="securityRules",
        flags={"read_only": True},
    )
    properties.subnets = AAZListType(
        flags={"read_only": True},
    )

    default_security_rules = _schema_network_security_group_read.properties.default_security_rules
    default_security_rules.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_security_rule_read(default_security_rules.Element)

    network_interfaces = _schema_network_security_group_read.properties.network_interfaces
    network_interfaces.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_network_security_group_read.properties.network_interfaces.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.location = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    _element.tags = AAZDictType(
        flags={"read_only": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_network_security_group_read.properties.network_interfaces.Element.properties
    properties.dns_settings = AAZObjectType(
        serialized_name="dnsSettings",
        flags={"read_only": True},
    )
    properties.enable_accelerated_networking = AAZBoolType(
        serialized_name="enableAcceleratedNetworking",
        flags={"read_only": True},
    )
    properties.enable_ip_forwarding = AAZBoolType(
        serialized_name="enableIPForwarding",
        flags={"read_only": True},
    )
    properties.ip_configurations = AAZListType(
        serialized_name="ipConfigurations",
        flags={"read_only": True},
    )
    properties.mac_address = AAZStrType(
        serialized_name="macAddress",
        flags={"read_only": True},
    )
    properties.network_security_group = AAZObjectType(
        serialized_name="networkSecurityGroup",
        flags={"read_only": True},
    )
    _build_schema_network_security_group_read(properties.network_security_group)
    properties.primary = AAZBoolType(
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.resource_guid = AAZStrType(
        serialized_name="resourceGuid",
        flags={"read_only": True},
    )
    properties.virtual_machine = AAZObjectType(
        serialized_name="virtualMachine",
        flags={"read_only": True},
    )
    _build_schema_sub_resource_read(properties.virtual_machine)

    dns_settings = _schema_network_security_group_read.properties.network_interfaces.Element.properties.dns_settings
    dns_settings.applied_dns_servers = AAZListType(
        serialized_name="appliedDnsServers",
        flags={"read_only": True},
    )
    dns_settings.dns_servers = AAZListType(
        serialized_name="dnsServers",
        flags={"read_only": True},
    )
    dns_settings.internal_dns_name_label = AAZStrType(
        serialized_name="internalDnsNameLabel",
        flags={"read_only": True},
    )
    dns_settings.internal_domain_name_suffix = AAZStrType(
        serialized_name="internalDomainNameSuffix",
        flags={"read_only": True},
    )
    dns_settings.internal_fqdn = AAZStrType(
        serialized_name="internalFqdn",
        flags={"read_only": True},
    )

    applied_dns_servers = _schema_network_security_group_read.properties.network_interfaces.Element.properties.dns_settings.applied_dns_servers
    applied_dns_servers.Element = AAZStrType(
        flags={"read_only": True},
    )

    dns_servers = _schema_network_security_group_read.properties.network_interfaces.Element.properties.dns_settings.dns_servers
    dns_servers.Element = AAZStrType(
        flags={"read_only": True},
    )

    ip_configurations = _schema_network_security_group_read.properties.network_interfaces.Element.properties.ip_configurations
    ip_configurations.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_network_interface_ip_configuration_read(ip_configurations.Element)

    tags = _schema_network_security_group_read.properties.network_interfaces.Element.tags
    tags.Element = AAZStrType(
        flags={"read_only": True},
    )

    security_rules = _schema_network_security_group_read.properties.security_rules
    security_rules.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_security_rule_read(security_rules.Element)

    subnets = _schema_network_security_group_read.properties.subnets
    subnets.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_subnet_read(subnets.Element)

    tags = _schema_network_security_group_read.tags
    tags.Element = AAZStrType(
        flags={"read_only": True},
    )

    _schema.etag = _schema_network_security_group_read.etag
    _schema.id = _schema_network_security_group_read.id
    _schema.location = _schema_network_security_group_read.location
    _schema.name = _schema_network_security_group_read.name
    _schema.properties = _schema_network_security_group_read.properties
    _schema.tags = _schema_network_security_group_read.tags
    _schema.type = _schema_network_security_group_read.type


_schema_public_ip_address_read = None


def _build_schema_public_ip_address_read(_schema):
    global _schema_public_ip_address_read
    if _schema_public_ip_address_read is not None:
        _schema.etag = _schema_public_ip_address_read.etag
        _schema.id = _schema_public_ip_address_read.id
        _schema.location = _schema_public_ip_address_read.location
        _schema.name = _schema_public_ip_address_read.name
        _schema.properties = _schema_public_ip_address_read.properties
        _schema.sku = _schema_public_ip_address_read.sku
        _schema.tags = _schema_public_ip_address_read.tags
        _schema.type = _schema_public_ip_address_read.type
        _schema.zones = _schema_public_ip_address_read.zones
        return

    _schema_public_ip_address_read = AAZObjectType(
        flags={"read_only": True}
    )

    public_ip_address_read = _schema_public_ip_address_read
    public_ip_address_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    public_ip_address_read.id = AAZStrType(
        flags={"read_only": True},
    )
    public_ip_address_read.location = AAZStrType(
        flags={"read_only": True},
    )
    public_ip_address_read.name = AAZStrType(
        flags={"read_only": True},
    )
    public_ip_address_read.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )
    public_ip_address_read.sku = AAZObjectType(
        flags={"read_only": True},
    )
    public_ip_address_read.tags = AAZDictType(
        flags={"read_only": True},
    )
    public_ip_address_read.type = AAZStrType(
        flags={"read_only": True},
    )
    public_ip_address_read.zones = AAZListType(
        flags={"read_only": True},
    )

    properties = _schema_public_ip_address_read.properties
    properties.dns_settings = AAZObjectType(
        serialized_name="dnsSettings",
        flags={"read_only": True},
    )
    properties.idle_timeout_in_minutes = AAZIntType(
        serialized_name="idleTimeoutInMinutes",
        flags={"read_only": True},
    )
    properties.ip_address = AAZStrType(
        serialized_name="ipAddress",
        flags={"read_only": True},
    )
    properties.ip_configuration = AAZObjectType(
        serialized_name="ipConfiguration",
        flags={"read_only": True},
    )
    _build_schema_ip_configuration_read(properties.ip_configuration)
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.public_ip_address_version = AAZStrType(
        serialized_name="publicIPAddressVersion",
        flags={"read_only": True},
    )
    properties.public_ip_allocation_method = AAZStrType(
        serialized_name="publicIPAllocationMethod",
        flags={"read_only": True},
    )
    properties.resource_guid = AAZStrType(
        serialized_name="resourceGuid",
        flags={"read_only": True},
    )

    dns_settings = _schema_public_ip_address_read.properties.dns_settings
    dns_settings.domain_name_label = AAZStrType(
        serialized_name="domainNameLabel",
        flags={"read_only": True},
    )
    dns_settings.fqdn = AAZStrType(
        flags={"read_only": True},
    )
    dns_settings.reverse_fqdn = AAZStrType(
        serialized_name="reverseFqdn",
        flags={"read_only": True},
    )

    sku = _schema_public_ip_address_read.sku
    sku.name = AAZStrType(
        flags={"read_only": True},
    )

    tags = _schema_public_ip_address_read.tags
    tags.Element = AAZStrType(
        flags={"read_only": True},
    )

    zones = _schema_public_ip_address_read.zones
    zones.Element = AAZStrType(
        flags={"read_only": True},
    )

    _schema.etag = _schema_public_ip_address_read.etag
    _schema.id = _schema_public_ip_address_read.id
    _schema.location = _schema_public_ip_address_read.location
    _schema.name = _schema_public_ip_address_read.name
    _schema.properties = _schema_public_ip_address_read.properties
    _schema.sku = _schema_public_ip_address_read.sku
    _schema.tags = _schema_public_ip_address_read.tags
    _schema.type = _schema_public_ip_address_read.type
    _schema.zones = _schema_public_ip_address_read.zones


_schema_route_table_read = None


def _build_schema_route_table_read(_schema):
    global _schema_route_table_read
    if _schema_route_table_read is not None:
        _schema.etag = _schema_route_table_read.etag
        _schema.id = _schema_route_table_read.id
        _schema.location = _schema_route_table_read.location
        _schema.name = _schema_route_table_read.name
        _schema.properties = _schema_route_table_read.properties
        _schema.tags = _schema_route_table_read.tags
        _schema.type = _schema_route_table_read.type
        return

    _schema_route_table_read = AAZObjectType()

    route_table_read = _schema_route_table_read
    route_table_read.etag = AAZStrType()
    route_table_read.id = AAZStrType()
    route_table_read.location = AAZStrType()
    route_table_read.name = AAZStrType(
        flags={"read_only": True},
    )
    route_table_read.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    route_table_read.tags = AAZDictType()
    route_table_read.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_route_table_read.properties
    properties.disable_bgp_route_propagation = AAZBoolType(
        serialized_name="disableBgpRoutePropagation",
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
    )
    properties.routes = AAZListType()
    properties.subnets = AAZListType(
        flags={"read_only": True},
    )

    routes = _schema_route_table_read.properties.routes
    routes.Element = AAZObjectType()

    _element = _schema_route_table_read.properties.routes.Element
    _element.etag = AAZStrType()
    _element.id = AAZStrType()
    _element.name = AAZStrType()
    _element.properties = AAZObjectType(
        flags={"client_flatten": True},
    )

    properties = _schema_route_table_read.properties.routes.Element.properties
    properties.address_prefix = AAZStrType(
        serialized_name="addressPrefix",
    )
    properties.next_hop_ip_address = AAZStrType(
        serialized_name="nextHopIpAddress",
    )
    properties.next_hop_type = AAZStrType(
        serialized_name="nextHopType",
        flags={"required": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
    )

    subnets = _schema_route_table_read.properties.subnets
    subnets.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_subnet_read(subnets.Element)

    tags = _schema_route_table_read.tags
    tags.Element = AAZStrType()

    _schema.etag = _schema_route_table_read.etag
    _schema.id = _schema_route_table_read.id
    _schema.location = _schema_route_table_read.location
    _schema.name = _schema_route_table_read.name
    _schema.properties = _schema_route_table_read.properties
    _schema.tags = _schema_route_table_read.tags
    _schema.type = _schema_route_table_read.type


_schema_security_rule_read = None


def _build_schema_security_rule_read(_schema):
    global _schema_security_rule_read
    if _schema_security_rule_read is not None:
        _schema.etag = _schema_security_rule_read.etag
        _schema.id = _schema_security_rule_read.id
        _schema.name = _schema_security_rule_read.name
        _schema.properties = _schema_security_rule_read.properties
        return

    _schema_security_rule_read = AAZObjectType(
        flags={"read_only": True}
    )

    security_rule_read = _schema_security_rule_read
    security_rule_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    security_rule_read.id = AAZStrType(
        flags={"read_only": True},
    )
    security_rule_read.name = AAZStrType(
        flags={"read_only": True},
    )
    security_rule_read.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )

    properties = _schema_security_rule_read.properties
    properties.access = AAZStrType(
        flags={"required": True, "read_only": True},
    )
    properties.description = AAZStrType(
        flags={"read_only": True},
    )
    properties.destination_address_prefix = AAZStrType(
        serialized_name="destinationAddressPrefix",
        flags={"read_only": True},
    )
    properties.destination_address_prefixes = AAZListType(
        serialized_name="destinationAddressPrefixes",
        flags={"read_only": True},
    )
    properties.destination_application_security_groups = AAZListType(
        serialized_name="destinationApplicationSecurityGroups",
        flags={"read_only": True},
    )
    properties.destination_port_range = AAZStrType(
        serialized_name="destinationPortRange",
        flags={"read_only": True},
    )
    properties.destination_port_ranges = AAZListType(
        serialized_name="destinationPortRanges",
        flags={"read_only": True},
    )
    properties.direction = AAZStrType(
        flags={"required": True, "read_only": True},
    )
    properties.priority = AAZIntType(
        flags={"read_only": True},
    )
    properties.protocol = AAZStrType(
        flags={"required": True, "read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.source_address_prefix = AAZStrType(
        serialized_name="sourceAddressPrefix",
        flags={"read_only": True},
    )
    properties.source_address_prefixes = AAZListType(
        serialized_name="sourceAddressPrefixes",
        flags={"read_only": True},
    )
    properties.source_application_security_groups = AAZListType(
        serialized_name="sourceApplicationSecurityGroups",
        flags={"read_only": True},
    )
    properties.source_port_range = AAZStrType(
        serialized_name="sourcePortRange",
        flags={"read_only": True},
    )
    properties.source_port_ranges = AAZListType(
        serialized_name="sourcePortRanges",
        flags={"read_only": True},
    )

    destination_address_prefixes = _schema_security_rule_read.properties.destination_address_prefixes
    destination_address_prefixes.Element = AAZStrType(
        flags={"read_only": True},
    )

    destination_application_security_groups = _schema_security_rule_read.properties.destination_application_security_groups
    destination_application_security_groups.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_application_security_group_read(destination_application_security_groups.Element)

    destination_port_ranges = _schema_security_rule_read.properties.destination_port_ranges
    destination_port_ranges.Element = AAZStrType(
        flags={"read_only": True},
    )

    source_address_prefixes = _schema_security_rule_read.properties.source_address_prefixes
    source_address_prefixes.Element = AAZStrType(
        flags={"read_only": True},
    )

    source_application_security_groups = _schema_security_rule_read.properties.source_application_security_groups
    source_application_security_groups.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_application_security_group_read(source_application_security_groups.Element)

    source_port_ranges = _schema_security_rule_read.properties.source_port_ranges
    source_port_ranges.Element = AAZStrType(
        flags={"read_only": True},
    )

    _schema.etag = _schema_security_rule_read.etag
    _schema.id = _schema_security_rule_read.id
    _schema.name = _schema_security_rule_read.name
    _schema.properties = _schema_security_rule_read.properties


_schema_sub_resource_read = None


def _build_schema_sub_resource_read(_schema):
    global _schema_sub_resource_read
    if _schema_sub_resource_read is not None:
        _schema.id = _schema_sub_resource_read.id
        return

    _schema_sub_resource_read = AAZObjectType(
        flags={"read_only": True}
    )

    sub_resource_read = _schema_sub_resource_read
    sub_resource_read.id = AAZStrType(
        flags={"read_only": True},
    )

    _schema.id = _schema_sub_resource_read.id


_schema_subnet_read = None


def _build_schema_subnet_read(_schema):
    global _schema_subnet_read
    if _schema_subnet_read is not None:
        _schema.etag = _schema_subnet_read.etag
        _schema.id = _schema_subnet_read.id
        _schema.name = _schema_subnet_read.name
        _schema.properties = _schema_subnet_read.properties
        return

    _schema_subnet_read = AAZObjectType(
        flags={"read_only": True}
    )

    subnet_read = _schema_subnet_read
    subnet_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    subnet_read.id = AAZStrType(
        flags={"read_only": True},
    )
    subnet_read.name = AAZStrType(
        flags={"read_only": True},
    )
    subnet_read.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )

    properties = _schema_subnet_read.properties
    properties.address_prefix = AAZStrType(
        serialized_name="addressPrefix",
        flags={"read_only": True},
    )
    properties.ip_configurations = AAZListType(
        serialized_name="ipConfigurations",
        flags={"read_only": True},
    )
    properties.network_security_group = AAZObjectType(
        serialized_name="networkSecurityGroup",
        flags={"read_only": True},
    )
    _build_schema_network_security_group_read(properties.network_security_group)
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.resource_navigation_links = AAZListType(
        serialized_name="resourceNavigationLinks",
        flags={"read_only": True},
    )
    properties.route_table = AAZObjectType(
        serialized_name="routeTable",
    )
    _build_schema_route_table_read(properties.route_table)
    properties.service_endpoints = AAZListType(
        serialized_name="serviceEndpoints",
        flags={"read_only": True},
    )

    ip_configurations = _schema_subnet_read.properties.ip_configurations
    ip_configurations.Element = AAZObjectType(
        flags={"read_only": True},
    )
    _build_schema_ip_configuration_read(ip_configurations.Element)

    resource_navigation_links = _schema_subnet_read.properties.resource_navigation_links
    resource_navigation_links.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_subnet_read.properties.resource_navigation_links.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True, "read_only": True},
    )

    properties = _schema_subnet_read.properties.resource_navigation_links.Element.properties
    properties.link = AAZStrType(
        flags={"read_only": True},
    )
    properties.linked_resource_type = AAZStrType(
        serialized_name="linkedResourceType",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )

    service_endpoints = _schema_subnet_read.properties.service_endpoints
    service_endpoints.Element = AAZObjectType(
        flags={"read_only": True},
    )

    _element = _schema_subnet_read.properties.service_endpoints.Element
    _element.locations = AAZListType(
        flags={"read_only": True},
    )
    _element.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    _element.service = AAZStrType(
        flags={"read_only": True},
    )

    locations = _schema_subnet_read.properties.service_endpoints.Element.locations
    locations.Element = AAZStrType(
        flags={"read_only": True},
    )

    _schema.etag = _schema_subnet_read.etag
    _schema.id = _schema_subnet_read.id
    _schema.name = _schema_subnet_read.name
    _schema.properties = _schema_subnet_read.properties


__all__ = ["Show"]
