# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "storage account network-security-perimeter-configuration list",
)
class List(AAZCommand):
    """List list of effective NetworkSecurityPerimeterConfiguration for storage account

    :example: List NetworkSecurityPerimeterConfiguration
        az storage account network-security-perimeter-configuration list --resource-group res4410 --account-name sto8607
    """

    _aaz_info = {
        "version": "2025-01-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.storage/storageaccounts/{}/networksecurityperimeterconfigurations", "2025-01-01"],
        ]
    }

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.account_name = AAZStrArg(
            options=["--account-name"],
            help="The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.",
            required=True,
            fmt=AAZStrArgFormat(
                pattern="^[a-z0-9]+$",
                max_length=24,
                min_length=3,
            ),
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.NetworkSecurityPerimeterConfigurationsList(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance.value, client_flatten=True)
        return result

    class NetworkSecurityPerimeterConfigurationsList(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/networkSecurityPerimeterConfigurations",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "accountName", self.ctx.args.account_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2025-01-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.next_link = AAZStrType(
                serialized_name="nextLink",
            )
            _schema_on_200.value = AAZListType(
                flags={"read_only": True},
            )

            value = cls._schema_on_200.value
            value.Element = AAZObjectType(
                flags={"read_only": True},
            )

            _element = cls._schema_on_200.value.Element
            _element.id = AAZStrType(
                flags={"read_only": True},
            )
            _element.name = AAZStrType(
                flags={"read_only": True},
            )
            _element.properties = AAZObjectType(
                flags={"client_flatten": True, "read_only": True},
            )
            _element.system_data = AAZObjectType(
                serialized_name="systemData",
                flags={"read_only": True},
            )
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200.value.Element.properties
            properties.network_security_perimeter = AAZObjectType(
                serialized_name="networkSecurityPerimeter",
                flags={"read_only": True},
            )
            _ListHelper._build_schema_network_security_perimeter_read(properties.network_security_perimeter)
            properties.profile = AAZObjectType(
                flags={"read_only": True},
            )
            properties.provisioning_issues = AAZListType(
                serialized_name="provisioningIssues",
                flags={"read_only": True},
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.resource_association = AAZObjectType(
                serialized_name="resourceAssociation",
                flags={"read_only": True},
            )

            profile = cls._schema_on_200.value.Element.properties.profile
            profile.access_rules = AAZListType(
                serialized_name="accessRules",
            )
            profile.access_rules_version = AAZFloatType(
                serialized_name="accessRulesVersion",
            )
            profile.diagnostic_settings_version = AAZFloatType(
                serialized_name="diagnosticSettingsVersion",
            )
            profile.enabled_log_categories = AAZListType(
                serialized_name="enabledLogCategories",
            )
            profile.name = AAZStrType()

            access_rules = cls._schema_on_200.value.Element.properties.profile.access_rules
            access_rules.Element = AAZObjectType(
                flags={"read_only": True},
            )

            _element = cls._schema_on_200.value.Element.properties.profile.access_rules.Element
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200.value.Element.properties.profile.access_rules.Element.properties
            properties.address_prefixes = AAZListType(
                serialized_name="addressPrefixes",
            )
            properties.direction = AAZStrType()
            properties.fully_qualified_domain_names = AAZListType(
                serialized_name="fullyQualifiedDomainNames",
                flags={"read_only": True},
            )
            properties.network_security_perimeters = AAZListType(
                serialized_name="networkSecurityPerimeters",
                flags={"read_only": True},
            )
            properties.subscriptions = AAZListType()

            address_prefixes = cls._schema_on_200.value.Element.properties.profile.access_rules.Element.properties.address_prefixes
            address_prefixes.Element = AAZStrType()

            fully_qualified_domain_names = cls._schema_on_200.value.Element.properties.profile.access_rules.Element.properties.fully_qualified_domain_names
            fully_qualified_domain_names.Element = AAZStrType()

            network_security_perimeters = cls._schema_on_200.value.Element.properties.profile.access_rules.Element.properties.network_security_perimeters
            network_security_perimeters.Element = AAZObjectType(
                flags={"read_only": True},
            )
            _ListHelper._build_schema_network_security_perimeter_read(network_security_perimeters.Element)

            subscriptions = cls._schema_on_200.value.Element.properties.profile.access_rules.Element.properties.subscriptions
            subscriptions.Element = AAZObjectType(
                flags={"read_only": True},
            )

            _element = cls._schema_on_200.value.Element.properties.profile.access_rules.Element.properties.subscriptions.Element
            _element.id = AAZStrType()

            enabled_log_categories = cls._schema_on_200.value.Element.properties.profile.enabled_log_categories
            enabled_log_categories.Element = AAZStrType()

            provisioning_issues = cls._schema_on_200.value.Element.properties.provisioning_issues
            provisioning_issues.Element = AAZObjectType(
                flags={"read_only": True},
            )

            _element = cls._schema_on_200.value.Element.properties.provisioning_issues.Element
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200.value.Element.properties.provisioning_issues.Element.properties
            properties.description = AAZStrType()
            properties.issue_type = AAZStrType(
                serialized_name="issueType",
            )
            properties.severity = AAZStrType()

            resource_association = cls._schema_on_200.value.Element.properties.resource_association
            resource_association.access_mode = AAZStrType(
                serialized_name="accessMode",
            )
            resource_association.name = AAZStrType()

            system_data = cls._schema_on_200.value.Element.system_data
            system_data.created_at = AAZStrType(
                serialized_name="createdAt",
            )
            system_data.created_by = AAZStrType(
                serialized_name="createdBy",
            )
            system_data.created_by_type = AAZStrType(
                serialized_name="createdByType",
            )
            system_data.last_modified_at = AAZStrType(
                serialized_name="lastModifiedAt",
            )
            system_data.last_modified_by = AAZStrType(
                serialized_name="lastModifiedBy",
            )
            system_data.last_modified_by_type = AAZStrType(
                serialized_name="lastModifiedByType",
            )

            return cls._schema_on_200


class _ListHelper:
    """Helper class for List"""

    _schema_network_security_perimeter_read = None

    @classmethod
    def _build_schema_network_security_perimeter_read(cls, _schema):
        if cls._schema_network_security_perimeter_read is not None:
            _schema.id = cls._schema_network_security_perimeter_read.id
            _schema.location = cls._schema_network_security_perimeter_read.location
            _schema.perimeter_guid = cls._schema_network_security_perimeter_read.perimeter_guid
            return

        cls._schema_network_security_perimeter_read = _schema_network_security_perimeter_read = AAZObjectType(
            flags={"read_only": True}
        )

        network_security_perimeter_read = _schema_network_security_perimeter_read
        network_security_perimeter_read.id = AAZStrType()
        network_security_perimeter_read.location = AAZStrType()
        network_security_perimeter_read.perimeter_guid = AAZStrType(
            serialized_name="perimeterGuid",
        )

        _schema.id = cls._schema_network_security_perimeter_read.id
        _schema.location = cls._schema_network_security_perimeter_read.location
        _schema.perimeter_guid = cls._schema_network_security_perimeter_read.perimeter_guid


__all__ = ["List"]
