//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _complex_eriroot_4.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Ryan D. Reynolds <RyanDReynolds@u.northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <algorithm>
#include <complex>
#include "comperirootlist.h"

using namespace std;
using namespace bagel;

void ComplexERIRootList::complex_eriroot4(const complex<double>* ta, complex<double>* rr, complex<double>* ww, const int n) {

  static constexpr double ax[4] = {1.453035215033171e-01,1.339097288126363e+00,3.926963501358290e+00,8.588635689012035e+00};
  static constexpr double aw[4] = {6.611470125582407e-01,2.078023258148919e-01,1.707798300741347e-02,1.996040722113680e-04};
  static constexpr double xr[11600] = {   7.581833522650124e-02,  -4.525614169069350e-03,   1.938846036540009e-04,  -6.938261739815909e-06,   2.119344014927638e-07,
  -5.316867931670428e-09,   9.075385618900680e-11,   2.686858179863468e-13,  -1.068419926302947e-13,   5.261210380614004e-15,  -1.595909516746649e-16,   3.278192958816970e-18,
  -2.956398779152151e-20,  -1.576105727593673e-21,   7.583675260398870e-02,  -4.527583081483072e-03,   1.940045151871551e-04,  -6.943239117476167e-06,   2.120585197755613e-07,
  -5.316048835336418e-09,   9.045939832922762e-11,   2.868659213984299e-13,  -1.075192320261223e-13,   5.277546920968047e-15,  -1.597224043169854e-16,   3.264042010173370e-18,
  -2.846639614325484e-20,  -1.623519772616523e-21,   7.586925957882128e-02,  -4.531058395217114e-03,   1.942161569041960e-04,  -6.952021064706247e-06,   2.122771862783775e-07,
  -5.314574220221188e-09,   8.993837520721042e-11,   3.189893997234012e-13,  -1.087146367962743e-13,   5.306310983661981e-15,  -1.599487328677835e-16,   3.238788977312702e-18,
  -2.652058822608461e-20,  -1.707301592909498e-21,   7.590858308804603e-02,  -4.535262719927541e-03,   1.944721715863182e-04,  -6.962639056369729e-06,   2.125410156041674e-07,
  -5.312741081117171e-09,   8.930587966381750e-11,   3.579090385520703e-13,  -1.101608105718077e-13,   5.340986230533948e-15,  -1.602127951616335e-16,   3.207768952213161e-18,
  -2.415222771213551e-20,  -1.808811434558667e-21,   7.594677414378542e-02,  -4.539346235078736e-03,   1.947208058200861e-04,  -6.972945508269153e-06,   2.127965229675116e-07,
  -5.310909060683032e-09,   8.868927793230158e-11,   3.957705489432576e-13,  -1.115654234920471e-13,   5.374535723655105e-15,  -1.604590321751760e-16,   3.177148047094684e-18,
  -2.183690519407376e-20,  -1.907561089476409e-21,   7.597755216746019e-02,  -4.542637315784883e-03,   1.949211735984290e-04,  -6.981247298959729e-06,   2.130019157278477e-07,
  -5.309395591895162e-09,   8.819069825678409e-11,   4.263277825552852e-13,  -1.126974454631654e-13,   5.401481320039022e-15,  -1.606501257455698e-16,   3.152116429685198e-18,
  -1.996016178935644e-20,  -1.987257223040525e-21,   7.599789551866767e-02,  -4.544812715155557e-03,   1.950536079142040e-04,  -6.986732502169821e-06,   2.131374194391764e-07,
  -5.308377082943817e-09,   8.786033805659224e-11,   4.465470744577167e-13,  -1.134456975439588e-13,   5.419246318332558e-15,  -1.607728252699886e-16,   3.135397687603505e-18,
  -1.871439967211157e-20,  -2.039988777048769e-21,   7.600834459108827e-02,  -4.545930106962423e-03,   1.951216300435231e-04,  -6.989549269251236e-06,   2.132069401393893e-07,
  -5.307848324719412e-09,   8.769040155330273e-11,   4.569391794181171e-13,  -1.138300315348378e-13,   5.428357008130752e-15,  -1.608347303691920e-16,   3.126756639939358e-18,
  -1.807289838719344e-20,  -2.067090299036463e-21,   7.601198177113395e-02,  -4.546319060459331e-03,   1.951453074826264e-04,  -6.990529647284281e-06,   2.132311267911181e-07,
  -5.307663376979487e-09,   8.763120890048087e-11,   4.605576040356369e-13,  -1.139638136697098e-13,   5.431526073583776e-15,  -1.608561005605165e-16,   3.123740257424153e-18,
  -1.784934075097321e-20,  -2.076526609659082e-21,   7.601255895503115e-02,  -4.546380783686250e-03,   1.951490648474779e-04,  -6.990685218656228e-06,   2.132349643732001e-07,
  -5.307633985179506e-09,   8.762181371972779e-11,   4.611318626078470e-13,  -1.139850435804182e-13,   5.432028865870972e-15,  -1.608594833348203e-16,   3.123261181864890e-18,
  -1.781385207602742e-20,  -2.078024182129824e-21,   6.016730633595411e-01,  -2.532397167465509e-02,   4.367427082162269e-04,   6.526790070326987e-06,  -5.138302240265630e-07,
   4.032944537014055e-09,   5.234091806178009e-10,  -1.736676269561956e-11,  -2.877975064431495e-13,   2.935452859617398e-14,  -2.621962037107748e-16,  -3.205905516340074e-17,
   1.039917042143522e-18,   1.821834643546765e-20,   6.017134360223166e-01,  -2.532212372286730e-02,   4.364577771242421e-04,   6.530297572089433e-06,  -5.131033620078106e-07,
   4.000254468499627e-09,   5.226352025736500e-10,  -1.727183666947899e-11,  -2.887203592099695e-13,   2.919467487677887e-14,  -2.563980932109673e-16,  -3.191984546817653e-17,
   1.025972448909547e-18,   1.833491766064438e-20,   6.017846529914770e-01,  -2.531886222777969e-02,   4.359553419530258e-04,   6.536462157041399e-06,  -5.118216944526486e-07,
   3.942722233644797e-09,   5.212676461447387e-10,  -1.710477279270189e-11,  -2.903294137433713e-13,   2.891319979775055e-14,  -2.462357851151255e-16,  -3.167358958216699e-17,
   1.001512018786591e-18,   1.853500630995780e-20,   6.018707331304003e-01,  -2.531491710928570e-02,   4.353483547513443e-04,   6.543874814828796e-06,  -5.102734105175688e-07,
   3.873408768595627e-09,   5.196108385545680e-10,  -1.690349726542023e-11,  -2.922422928630936e-13,   2.857384362953630e-14,  -2.340638004778563e-16,  -3.137478243451955e-17,
   9.721807083317662e-19,   1.876748944319854e-20,   6.019542603722127e-01,  -2.531108591688739e-02,   4.347596910558255e-04,   6.551027404577562e-06,  -5.087719590252849e-07,
   3.806387021215241e-09,   5.179991815476258e-10,  -1.670887585762064e-11,  -2.940651297533278e-13,   2.824545861940551e-14,  -2.223686974809290e-16,  -3.108365311976951e-17,
   9.439635248381868e-19,   1.898337825395971e-20,   6.020215217155660e-01,  -2.530799860157398e-02,   4.342858929808499e-04,   6.556758346564052e-06,  -5.075635538052535e-07,
   3.752585741267311e-09,   5.166985428092711e-10,  -1.655264450893301e-11,  -2.955092547547592e-13,   2.798167404633945e-14,  -2.130337059647629e-16,  -3.084838865808604e-17,
   9.214156728079692e-19,   1.915035036834438e-20,   6.020659535422339e-01,  -2.530595809160325e-02,   4.339730220471391e-04,   6.560530055711968e-06,  -5.067656220695327e-07,
   3.717127949983419e-09,   5.158379833907170e-10,  -1.644968003623786e-11,  -2.964516519290519e-13,   2.780774166700411e-14,  -2.069074505252946e-16,  -3.069257835048447e-17,
   9.066060391572660e-19,   1.925731330243585e-20,   6.020887673083967e-01,  -2.530491004795603e-02,   4.338124116596643e-04,   6.562462315506282e-06,  -5.063560195134389e-07,
   3.698947444308670e-09,   5.153957005386070e-10,  -1.639688639590231e-11,  -2.969319638664776e-13,   2.771853416050358e-14,  -2.037743196543591e-16,  -3.061245519176867e-17,
   8.990282284148515e-19,   1.931120854012316e-20,   6.020967071955737e-01,  -2.530454524384459e-02,   4.337565198997401e-04,   6.563134109567812e-06,  -5.062134812345629e-07,
   3.692624129278769e-09,   5.152417052981675e-10,  -1.637852437836848e-11,  -2.970985601748269e-13,   2.768750300443219e-14,  -2.026858701183995e-16,  -3.058455068851368e-17,
   8.963950976991784e-19,   1.932980303083516e-20,   6.020979671153183e-01,  -2.530448735336859e-02,   4.337476511293061e-04,   6.563240678597793e-06,  -5.061908636852089e-07,
   3.691620923463812e-09,   5.152172657840565e-10,  -1.637561120995217e-11,  -2.971249691705037e-13,   2.768257965789664e-14,  -2.025132461484615e-16,  -3.058012182864717e-17,
   8.959774646887088e-19,   1.933274593527237e-20,   1.322138788785429e+00,  -2.585669231961222e-02,  -3.821792304566823e-04,   7.493405196109597e-06,   4.521448577564954e-07,
   1.772361620407803e-09,  -4.646616450608816e-10,  -1.256787919234237e-11,   3.307062224035530e-13,   2.280397244304268e-14,   2.638549626785804e-17,  -2.700563456339681e-17,
  -5.741698696334372e-19,   2.066234575363888e-20,   1.322103462745764e+00,  -2.585457968762774e-02,  -3.819285243145173e-04,   7.494869654809291e-06,   4.515016934931941e-07,
   1.748780192649289e-09,  -4.637935870581305e-10,  -1.249437186926200e-11,   3.307184026458036e-13,   2.267051861017759e-14,   2.323994213384200e-17,  -2.685641289334280e-17,
  -5.652282829016762e-19,   2.063183889450339e-20,   1.322041148070724e+00,  -2.585085161418557e-02,  -3.814864410855319e-04,   7.497436096688313e-06,   4.503678123117941e-07,
   1.707286355423316e-09,  -4.622619181119076e-10,  -1.236502896851473e-11,   3.307294592023355e-13,   2.243566068424672e-14,   1.773336456839949e-17,  -2.659332197642850e-17,
  -5.495577299879609e-19,   2.057562882669069e-20,   1.321965828332072e+00,  -2.584634307725447e-02,  -3.809523663886132e-04,   7.500509484192350e-06,   4.489984029256006e-07,
   1.657308897556512e-09,  -4.604098789165869e-10,  -1.220924209809617e-11,   3.307251364323723e-13,   2.215273036435397e-14,   1.114907452588126e-17,  -2.627556226474929e-17,
  -5.307904120149076e-19,   2.050364814246096e-20,   1.321892742549077e+00,  -2.584196573623969e-02,  -3.804344160449664e-04,   7.503461755298382e-06,   4.476707756005142e-07,
   1.608997791199165e-09,  -4.586120448759549e-10,  -1.205865042379098e-11,   3.307025412626592e-13,   2.187917817770755e-14,   4.834526415621094e-18,  -2.596748866746699e-17,
  -5.127606717454902e-19,   2.042963076825111e-20,   1.321833889449872e+00,  -2.583843902887655e-02,  -3.800175343736762e-04,   7.505817679113297e-06,   4.466025255712543e-07,
   1.570226341437744e-09,  -4.571638134624202e-10,  -1.193779576067911e-11,   3.306712466346453e-13,   2.165960398545078e-14,  -1.972836626635995e-19,  -2.571960487945688e-17,
  -4.983710329365820e-19,   2.036707944460745e-20,   1.321795012046063e+00,  -2.583610845917900e-02,  -3.797422486109012e-04,   7.507363491692378e-06,   4.458972664252383e-07,
   1.544678862085575e-09,  -4.562068926028620e-10,  -1.185816197195498e-11,   3.306441937227936e-13,   2.151490270772613e-14,  -3.495362736278294e-18,  -2.555595605907353e-17,
  -4.889283736512978e-19,   2.032433196580306e-20,   1.321775050248671e+00,  -2.583491154333431e-02,  -3.796009325286861e-04,   7.508153961737161e-06,   4.455352742888214e-07,
   1.531581246663607e-09,  -4.557154828995433e-10,  -1.181733564837951e-11,   3.306283372682858e-13,   2.144071206030543e-14,  -5.180807922159288e-18,  -2.547196114217631e-17,
  -4.840993916436872e-19,   2.030194517808912e-20,   1.321768102936848e+00,  -2.583449493679048e-02,  -3.795517551376369e-04,   7.508428554593001e-06,   4.454093102055093e-07,
   1.527026039240450e-09,  -4.555444457320713e-10,  -1.180313671905526e-11,   3.306225063798567e-13,   2.141490848619556e-14,  -5.766127439026706e-18,  -2.544273341997564e-17,
  -4.824218426882543e-19,   2.029408449069993e-20,   1.321767000521416e+00,  -2.583442882664160e-02,  -3.795439517885383e-04,   7.508472103189676e-06,   4.453893228927169e-07,
   1.526303358443352e-09,  -4.555173046089222e-10,  -1.180088406877226e-11,   3.306215663049068e-13,   2.141081472385240e-14,  -5.858947202303045e-18,  -2.543809573923661e-17,
  -4.821557916438241e-19,   2.029283384999074e-20,   1.859745758186842e+00,  -7.288376602647429e-03,  -2.646064788176360e-04,  -7.634997749542795e-06,  -1.693566692093813e-07,
  -2.131895465218468e-09,   3.746807236016586e-11,   3.648295059520492e-12,   1.509612879450537e-13,   3.729664821613265e-15,   1.913269456067936e-17,  -2.263623793712194e-18,
  -1.049311336698792e-19,  -3.045513467296269e-21,   1.859720760807782e+00,  -7.290530748453847e-03,  -2.647014152384119e-04,  -7.636934183859993e-06,  -1.692992782482814e-07,
  -2.124518675064698e-09,   3.786549842218422e-11,   3.660552629774697e-12,   1.510203473733454e-13,   3.717135030676367e-15,   1.846237786984240e-17,  -2.285707913570234e-18,
  -1.053937464741419e-19,  -3.042604306927256e-21,   1.859676645342699e+00,  -7.294332204558636e-03,  -2.648689046945955e-04,  -7.640345370638736e-06,  -1.691975561952963e-07,
  -2.111482757340578e-09,   3.856687582042086e-11,   3.682146295120518e-12,   1.511222413140145e-13,   3.694933652299070e-15,   1.727732822134827e-17,  -2.324654087275582e-18,
  -1.062044704770876e-19,  -3.037151745975358e-21,   1.859623288181990e+00,  -7.298929701486451e-03,  -2.650713879549098e-04,  -7.644460515725409e-06,  -1.690737772519608e-07,
  -2.095686452089998e-09,   3.941517789408804e-11,   3.708197717381142e-12,   1.512414960502034e-13,   3.667930086909455e-15,   1.584051044854638e-17,  -2.371710079947710e-18,
  -1.071752719790283e-19,  -3.030013822327539e-21,   1.859571477128106e+00,  -7.303393641065446e-03,  -2.652679060298616e-04,  -7.648445258422702e-06,  -1.689528025481297e-07,
  -2.080317024273614e-09,   4.023888846312728e-11,   3.733425072273994e-12,   1.513531166193347e-13,   3.641550732831302e-15,   1.444167311437201e-17,  -2.417349625404570e-18,
  -1.081076633033438e-19,  -3.022513885853304e-21,   1.859529729614300e+00,  -7.306990283012182e-03,  -2.654261830776066e-04,  -7.651648020284246e-06,  -1.688547648575965e-07,
  -2.067910822999585e-09,   4.090259462939740e-11,   3.753702667212023e-12,   1.514400586664600e-13,   3.620181883164120e-15,   1.331193995328058e-17,  -2.454085273617593e-18,
  -1.088515446016994e-19,  -3.016063071988501e-21,   1.859502139095645e+00,  -7.309367149037564e-03,  -2.655307523672451e-04,  -7.653760772777926e-06,  -1.687896982872353e-07,
  -2.059700902538099e-09,   4.134122501490642e-11,   3.767079530032681e-12,   1.514960484219353e-13,   3.606003986220070e-15,   1.256404509905499e-17,  -2.478343895817795e-18,
  -1.093395253645399e-19,  -3.011600190779974e-21,   1.859487968650998e+00,  -7.310587866621410e-03,  -2.655844483199420e-04,  -7.654844665745237e-06,  -1.687561953419739e-07,
  -2.055480969231144e-09,   4.156650259671579e-11,   3.773942306895829e-12,   1.515243499229553e-13,   3.598705106408344e-15,   1.217953779635604e-17,  -2.490796921490887e-18,
  -1.095890213352320e-19,  -3.009246331545600e-21,   1.859483036276188e+00,  -7.311012761786935e-03,  -2.656031368303671e-04,  -7.655221748388383e-06,  -1.687445203012631e-07,
  -2.054011586650102e-09,   4.164491566522910e-11,   3.776329862374078e-12,   1.515341285382734e-13,   3.596161823015316e-15,   1.204563858457964e-17,  -2.495130516075985e-18,
  -1.096756843679135e-19,  -3.008417184730870e-21,   1.859482253565707e+00,  -7.311080187425964e-03,  -2.656061023988540e-04,  -7.655281577842964e-06,  -1.687426669668528e-07,
  -2.053778387575517e-09,   4.165735888801755e-11,   3.776708682451046e-12,   1.515356768519482e-13,   3.595758104086052e-15,   1.202438740195090e-17,  -2.495818159928667e-18,
  -1.096894282203271e-19,  -3.008285142227267e-21,   6.036241027550818e-02,  -3.257249443074651e-03,   1.278397502901711e-04,  -4.282199505647051e-06,   1.265937872562135e-07,
  -3.297457178210020e-09,   7.158343314461176e-11,  -1.101097017245960e-12,  -2.426067954664414e-15,   1.222763333706715e-15,  -5.600937075451690e-17,   1.472361463752100e-18,
  -2.956174358411818e-20,   5.182509869636266e-22,   6.037453932886878e-02,  -3.258464763815231e-03,   1.279115264773090e-04,  -4.285308439591580e-06,   1.266943087310729e-07,
  -3.299555649668870e-09,   7.157204546581521e-11,  -1.096768249230496e-12,  -2.668231968304360e-15,   1.230490112485219e-15,  -5.619213055350624e-17,   1.475873585074254e-18,
  -2.956133807688980e-20,   5.133431151565905e-22,   6.039594677303517e-02,  -3.260609930323856e-03,   1.280382226240039e-04,  -4.290795780427775e-06,   1.268716654553781e-07,
  -3.303251407230400e-09,   7.155143135348117e-11,  -1.089108770251076e-12,  -3.096160801268034e-15,   1.244138568091929e-15,  -5.651458916074659e-17,   1.482040463756873e-18,
  -2.955865038113766e-20,   5.045988690537194e-22,   6.042184232958939e-02,  -3.263205106159288e-03,   1.281915032763503e-04,  -4.297433818466277e-06,   1.270861011162187e-07,
  -3.307708349426610e-09,   7.152561635212876e-11,  -1.079810501874806e-12,  -3.614685271916371e-15,   1.260666946899688e-15,  -5.690446187863778e-17,   1.489445486673500e-18,
  -2.955202537459479e-20,   4.938815142996615e-22,   6.044699118280860e-02,  -3.265725733275905e-03,   1.283403874872055e-04,  -4.303880719796801e-06,   1.272942438090024e-07,
  -3.312022467878256e-09,   7.149962431657611e-11,  -1.070745810159658e-12,  -4.119178500571843e-15,   1.276737974597084e-15,  -5.728288485116439e-17,   1.496579227770847e-18,
  -2.954204398900377e-20,   4.833266627826240e-22,   6.046725786392548e-02,  -3.267757231693859e-03,   1.284603854239123e-04,  -4.309076268884836e-06,   1.274619006142524e-07,
  -3.315488813856253e-09,   7.147801738879100e-11,  -1.063416094427845e-12,  -4.526393099944030e-15,   1.289702821035417e-15,  -5.758768919471094e-17,   1.502286412278120e-18,
  -2.953144857997096e-20,   4.747157973030816e-22,   6.048065319907851e-02,  -3.269100057261069e-03,   1.285397066875972e-04,  -4.312510377574673e-06,   1.275726751846030e-07,
  -3.317774873029104e-09,   7.146341247265630e-11,  -1.058559363605491e-12,  -4.795865607059745e-15,   1.298278656439581e-15,  -5.778907231964438e-17,   1.506038072283831e-18,
  -2.952319211948734e-20,   4.689729684846295e-22,   6.048753341896099e-02,  -3.269789800885472e-03,   1.285804508472199e-04,  -4.314274260231962e-06,   1.276295600839186e-07,
  -3.318947498715293e-09,   7.145581081371608e-11,  -1.056061058383294e-12,  -4.934373963413627e-15,   1.302685502369597e-15,  -5.789248356409222e-17,   1.507958657814039e-18,
  -2.951856290533067e-20,   4.660073768659436e-22,   6.048992831355081e-02,  -3.270029894512519e-03,   1.285946336412104e-04,  -4.314888244040395e-06,   1.276493588908695e-07,
  -3.319355422747040e-09,   7.145314884762304e-11,  -1.055190840848004e-12,  -4.982602380365496e-15,   1.304219781693059e-15,  -5.792847537357392e-17,   1.508626166248550e-18,
  -2.951688963158194e-20,   4.649725680785726e-22,   6.049030835845992e-02,  -3.270067995110950e-03,   1.285968843225145e-04,  -4.314985677107133e-06,   1.276525006649133e-07,
  -3.319420144269283e-09,   7.145272566396259e-11,  -1.055052717996552e-12,  -4.990256482856961e-15,   1.304463271388362e-15,  -5.793418670961525e-17,   1.508732044596927e-18,
  -2.951662115946095e-20,   4.648082343772553e-22,   5.076764086354896e-01,  -2.164679830466521e-02,   4.701373307293177e-04,  -5.393851005908437e-07,  -3.486097778942476e-07,
   1.057165108509251e-08,   4.118964055033919e-11,  -1.353304750176319e-11,   3.788266185467682e-13,   5.599720088215960e-15,  -6.051462981745990e-16,   1.029083993190042e-17,
   3.749671548420761e-19,  -2.278115593305885e-20,   5.077200910853518e-01,  -2.164691592367473e-02,   4.699416335513526e-04,  -5.296951713399566e-07,  -3.485407757934834e-07,
   1.054533033013129e-08,   4.213316929791146e-11,  -1.351294580315326e-11,   3.763511120992786e-13,   5.646763323716691e-15,  -6.027489698130049e-16,   1.013454412264537e-17,
   3.767258912538463e-19,  -2.259478938592413e-20,   5.077971545906004e-01,  -2.164712128690964e-02,   4.695963569340694e-04,  -5.126170995388483e-07,  -3.484179617017331e-07,
   1.049891969956826e-08,   4.379280475299672e-11,  -1.347735134650087e-11,   3.719913294879856e-13,   5.729127205754616e-15,  -5.985106965491774e-16,   9.859866935416301e-18,
   3.797657478595345e-19,  -2.226583331955382e-20,   5.078903152611730e-01,  -2.164736590484777e-02,   4.691789032805729e-04,  -4.920001300691762e-07,  -3.482676523159471e-07,
   1.044285545332677e-08,   4.579073827119439e-11,  -1.343409873542964e-11,   3.667335827338530e-13,   5.827626500788318e-15,  -5.933720504779044e-16,   9.529615931068113e-18,
   3.833339661188436e-19,  -2.186789456360256e-20,   5.079807274911000e-01,  -2.164759949512671e-02,   4.687737081949687e-04,  -4.720211334549360e-07,  -3.481198534749953e-07,
   1.038848804859792e-08,   4.772097697319584e-11,  -1.339188998505448e-11,   3.616442927364724e-13,   5.922104266082613e-15,  -5.883694887938674e-16,   9.210995098727300e-18,
   3.866860059286381e-19,  -2.148144487575651e-20,   5.080535433965290e-01,  -2.164778489477799e-02,   4.684473327976645e-04,  -4.559518054963171e-07,  -3.479994445067252e-07,
   1.034473261940931e-08,   4.926928498707973e-11,  -1.335773070597157e-11,   3.575550752921995e-13,   5.997397773776130e-15,  -5.843296129985739e-16,   8.955737921060149e-18,
   3.893067082748343e-19,  -2.117004949300646e-20,   5.081016495420908e-01,  -2.164790604468161e-02,   4.682316916517344e-04,  -4.453459550017114e-07,  -3.479192237491855e-07,
   1.031584054323177e-08,   5.028911934539368e-11,  -1.333508268883668e-11,   3.548582133325295e-13,   6.046751734261437e-15,  -5.816553760090798e-16,   8.787763654820360e-18,
   3.909996354840085e-19,  -2.096425634142031e-20,   5.081263514713525e-01,  -2.164796784094604e-02,   4.681209564036598e-04,  -4.399032000027343e-07,  -3.478778237882925e-07,
   1.030100950135301e-08,   5.081184584788233e-11,  -1.332342838282147e-11,   3.534748613733317e-13,   6.071974315505485e-15,  -5.802805719585527e-16,   8.701715814069112e-18,
   3.918570856184634e-19,  -2.085856473197562e-20,   5.081349487458352e-01,  -2.164798928285725e-02,   4.680824150710136e-04,  -4.380094131534013e-07,  -3.478633819004487e-07,
   1.029584844464684e-08,   5.099362532466068e-11,  -1.331936826731621e-11,   3.529936303951755e-13,   6.080733699871729e-15,  -5.798018285715809e-16,   8.671800301028519e-18,
   3.921536307855680e-19,  -2.082177685456126e-20,   5.081363129931395e-01,  -2.164799268222036e-02,   4.680762991438537e-04,  -4.377089244021232e-07,  -3.478610886411852e-07,
   1.029502950462148e-08,   5.102246361730619e-11,  -1.331872380610766e-11,   3.529172778857060e-13,   6.082122765115276e-15,  -5.797258476882166e-16,   8.667054745937487e-18,
   3.922005983881831e-19,  -2.081593908356595e-20,   1.213338284988578e+00,  -2.843317595655217e-02,  -2.499001542185973e-04,   1.431653778964385e-05,   3.567916332760574e-07,
  -1.170408460473877e-08,  -5.584518340811410e-10,   8.767324346094081e-12,   8.520794160759191e-13,  -2.096414389403620e-15,  -1.147994122716209e-15,  -9.534977681447421e-18,
   1.398970227990866e-18,   2.802063033503054e-20,   1.213315251095209e+00,  -2.842918754880014e-02,  -2.497037364045913e-04,   1.430570911007039e-05,   3.560315073939504e-07,
  -1.168695599859408e-08,  -5.563090634816711e-10,   8.759171507253147e-12,   8.474936727330208e-13,  -2.138762362045098e-15,  -1.139903305551278e-15,  -9.355850017637698e-18,
   1.386615067462419e-18,   2.754219189198878e-20,   1.213274621894096e+00,  -2.842215239155224e-02,  -2.493574958098792e-04,   1.428661474798268e-05,   3.546926664597968e-07,
  -1.165674587107184e-08,  -5.525377429589054e-10,   8.744674417894596e-12,   8.394293144714338e-13,  -2.212760984305828e-15,  -1.125687906068264e-15,  -9.042515067851885e-18,
   1.364921019987786e-18,   2.670588022127513e-20,   1.213225517279100e+00,  -2.841364958133073e-02,  -2.489393999170431e-04,   1.426354782286216e-05,   3.530778328691933e-07,
  -1.162023871369132e-08,  -5.479938057527822e-10,   8.726955977537491e-12,   8.297241419219880e-13,  -2.301012350699897e-15,  -1.108602095594264e-15,  -8.668265268530749e-18,
   1.338869892118102e-18,   2.570797392687348e-20,   1.213177873159730e+00,  -2.840539957197450e-02,  -2.485341281123225e-04,   1.424117807010897e-05,   3.515144718879789e-07,
  -1.158482269577046e-08,  -5.435997370996778e-10,   8.709559617624103e-12,   8.203508704593721e-13,  -2.385408489208500e-15,  -1.092123514101203e-15,  -8.309767212365033e-18,
   1.313769251158799e-18,   2.475309828660675e-20,   1.213139510140725e+00,  -2.839875660215431e-02,  -2.482080817047963e-04,   1.422317391776793e-05,   3.502581168023282e-07,
  -1.155630967029907e-08,  -5.400721543679728e-10,   8.695406372210196e-12,   8.128343951392402e-13,  -2.452488977976025e-15,  -1.078925658371069e-15,  -8.024389390856599e-18,
   1.293683622129710e-18,   2.399371490726384e-20,   1.213114169575542e+00,  -2.839436857804328e-02,  -2.479928489075449e-04,   1.421128523421148e-05,   3.494294393242522e-07,
  -1.153747745894521e-08,  -5.377471604883937e-10,   8.685986595729754e-12,   8.078844883138175e-13,  -2.496372768485233e-15,  -1.070242357173727e-15,  -7.837481859005600e-18,
   1.280477336109602e-18,   2.349671600021286e-20,   1.213101158775483e+00,  -2.839211559133336e-02,  -2.478823823396701e-04,   1.420518234301547e-05,   3.490043369762231e-07,
  -1.152780891308975e-08,  -5.365550081278059e-10,   8.681128296162360e-12,   8.053476733030519e-13,  -2.518773147587301e-15,  -1.065794668831749e-15,  -7.742008450700299e-18,
   1.273715622195727e-18,   2.324295647254582e-20,   1.213096630691854e+00,  -2.839133149406541e-02,  -2.478439439050194e-04,   1.420305857645082e-05,   3.488564499003007e-07,
  -1.152444411712542e-08,  -5.361403617598432e-10,   8.679434019117531e-12,   8.044655383292609e-13,  -2.526548197642351e-15,  -1.064248454793016e-15,  -7.708859444520370e-18,
   1.271365380683210e-18,   2.315486700730070e-20,   1.213095912168443e+00,  -2.839120707220642e-02,  -2.478378447515724e-04,   1.420272158296300e-05,   3.488329857553313e-07,
  -1.152391019077438e-08,  -5.360745770045782e-10,   8.679165004138110e-12,   8.043255948856248e-13,  -2.527780966296716e-15,  -1.064003179439848e-15,  -7.703603013263480e-18,
   1.270992583212409e-18,   2.314089951100080e-20,   1.825709647039166e+00,  -9.820478527597697e-03,  -3.736114601765309e-04,  -1.059080721396903e-05,  -1.913823619042862e-07,
   6.615465941448260e-10,   2.268117384006556e-10,   1.046493914111586e-11,   2.566524905400960e-13,   3.487881629997496e-16,  -2.592937286074381e-16,  -1.201297019697078e-17,
  -2.952821828098023e-19,  -1.578102177735145e-21,   1.825674408683274e+00,  -9.823454353883744e-03,  -3.737172648717532e-04,  -1.059001389780748e-05,  -1.910557612473861e-07,
   6.821387718534319e-10,   2.274615687022290e-10,   1.046449892757094e-11,   2.555041220360590e-13,   2.867513406069582e-16,  -2.610060757870123e-16,  -1.201664224652146e-17,
  -2.928469810622823e-19,  -1.435554616022201e-21,   1.825612222207073e+00,  -9.828705034754925e-03,  -3.739038077764085e-04,  -1.058859838845423e-05,  -1.904787357666455e-07,
   7.184724922082102e-10,   2.286057210000892e-10,   1.046355190050191e-11,   2.534720367346331e-13,   1.772790603686605e-16,  -2.640149842999132e-16,  -1.202227382230166e-17,
  -2.885223128829607e-19,  -1.183991178110089e-21,   1.825537012291070e+00,  -9.835053851213206e-03,  -3.741291195099683e-04,  -1.058685998701068e-05,  -1.897797417058295e-07,
   7.624048688185781e-10,   2.299849992929138e-10,   1.046211642809951e-11,   2.510050073465892e-13,   4.489394328211724e-17,  -2.676318871663176e-16,  -1.202763795922375e-17,
  -2.832458530731782e-19,  -8.797519675187609e-22,   1.825463985821744e+00,  -9.841216789120354e-03,  -3.743475778407639e-04,  -1.058514436371615e-05,  -1.890998652744578e-07,
   8.050505455138381e-10,   2.313195250653139e-10,   1.046041887656607e-11,   2.485998231618978e-13,  -8.363067156994553e-17,  -2.711204781210303e-16,  -1.203133152101462e-17,
  -2.780746131155778e-19,  -5.843732888324817e-22,   1.825405146635070e+00,  -9.846181294974844e-03,  -3.745233710877974e-04,  -1.058374220966066e-05,  -1.885512323399528e-07,
   8.394029489512313e-10,   2.323914031413345e-10,   1.045883352225718e-11,   2.466549319966002e-13,  -1.871715670097007e-16,  -2.739145392239955e-16,  -1.203322236219535e-17,
  -2.738738735755241e-19,  -3.464134969655912e-22,   1.825366261849211e+00,  -9.849461615595538e-03,  -3.746394370922911e-04,  -1.058280586480302e-05,  -1.881882492080270e-07,
   8.621011627204025e-10,   2.330981119901332e-10,   1.045767929440926e-11,   2.453662162951683e-13,  -2.555901982593857e-16,  -2.757527891718303e-16,  -1.203394074552978e-17,
  -2.710811194742651e-19,  -1.891762857870223e-22,   1.825346291136529e+00,  -9.851146174816302e-03,  -3.746990131292896e-04,  -1.058232196810637e-05,  -1.880016990514046e-07,
   8.737573828719414e-10,   2.334605549045991e-10,   1.045705355976030e-11,   2.447032985643368e-13,  -2.907264523719072e-16,  -2.766943323253598e-16,  -1.203414544326853e-17,
  -2.696416737338910e-19,  -1.084293833171763e-22,   1.825339339906027e+00,  -9.851732494316659e-03,  -3.747197444309098e-04,  -1.058215305965670e-05,  -1.879367461351783e-07,
   8.778143722824163e-10,   2.335866290683241e-10,   1.045683051611414e-11,   2.444723889765022e-13,  -3.029559327255263e-16,  -2.770216486063150e-16,  -1.203419054573680e-17,
  -2.691398300230116e-19,  -8.032509772815458e-23,   1.825338236830038e+00,  -9.851825534825026e-03,  -3.747230339805817e-04,  -1.058212623324589e-05,  -1.879264379375676e-07,
   8.784581575278003e-10,   2.336066316256452e-10,   1.045679487287927e-11,   2.444357385014232e-13,  -3.048965817955299e-16,  -2.770735703592407e-16,  -1.203419646172817e-17,
  -2.690601548997275e-19,  -7.586535642981307e-23,   4.909610662539030e-02,  -2.410100463722560e-03,   8.670425741160385e-05,  -2.701196301794930e-06,   7.540725009884748e-08,
  -1.930251097159847e-09,   4.382761213003134e-11,  -8.014408435225764e-13,   1.372398974488362e-14,  -5.358258838371182e-17,  -1.423365047553404e-17,   5.747074037817745e-19,
  -1.101303180068537e-20,   1.760616764543706e-22,   4.910432099430054e-02,  -2.410866597418324e-03,   8.674702432794980e-05,  -2.703019187981595e-06,   7.546929125916630e-08,
  -1.931830375799591e-09,   4.386234369521389e-11,  -8.015428457270972e-13,   1.366167808255034e-14,  -5.056633834568864e-17,  -1.430374787663727e-17,   5.760578085674139e-19,
  -1.105551079265155e-20,   1.772188531075913e-22,   4.911881867926306e-02,  -2.412218871524094e-03,   8.682251569366262e-05,  -2.706236903472027e-06,   7.557880306026263e-08,
  -1.934617162161566e-09,   4.392349372958286e-11,  -8.017145148309818e-13,   1.355148603900920e-14,  -4.523839292223969e-17,  -1.442764725600738e-17,   5.784473480002417e-19,
  -1.113025944049528e-20,   1.792496414465123e-22,   4.913635506616013e-02,  -2.413854770690598e-03,   8.691384921380782e-05,  -2.710129852621115e-06,   7.571129262945067e-08,
  -1.937987176897945e-09,   4.399720755596717e-11,  -8.019079096774015e-13,   1.341782728877045e-14,  -3.878600408541468e-17,  -1.457782747654336e-17,   5.813482318054293e-19,
  -1.122029503669829e-20,   1.816862647009807e-22,   4.915338498600933e-02,  -2.415443622129258e-03,   8.700256507499348e-05,  -2.713911210411305e-06,   7.583998095241229e-08,
  -1.941258929653908e-09,   4.406852693208106e-11,  -8.020807813344735e-13,   1.328764019885173e-14,  -3.251187058487474e-17,  -1.472399567604739e-17,   5.841762666893393e-19,
  -1.130733257756673e-20,   1.840315725622155e-22,   4.916710829594827e-02,  -2.416724116901266e-03,   8.707406987151280e-05,  -2.716958963679360e-06,   7.594370046649392e-08,
  -1.943894746748149e-09,   4.412580809081258e-11,  -8.022093784667042e-13,   1.318245213643800e-14,  -2.745013754584650e-17,  -1.484201552887361e-17,   5.864629840985944e-19,
  -1.137718585849309e-20,   1.859063641292793e-22,   4.917617848536093e-02,  -2.417570507894209e-03,   8.712133681971011e-05,  -2.718973619081368e-06,   7.601226085497562e-08,
  -1.945636510804313e-09,   4.416357372151063e-11,  -8.022891268370309e-13,   1.311279326887857e-14,  -2.410181780228046e-17,  -1.492013222754289e-17,   5.879781457039187e-19,
  -1.142321496970953e-20,   1.871380089632033e-22,   4.918083710210958e-02,  -2.418005251473543e-03,   8.714561618122194e-05,  -2.720008474316295e-06,   7.604747742683682e-08,
  -1.946531008784481e-09,   4.418294194608088e-11,  -8.023284643084601e-13,   1.307697291667205e-14,  -2.238117543911557e-17,  -1.496028943561219e-17,   5.887575301959699e-19,
  -1.144681334022055e-20,   1.877682838611906e-22,   4.918245867830893e-02,  -2.418156580902939e-03,   8.715406771452797e-05,  -2.720368702297777e-06,   7.605973607552742e-08,
  -1.946842349927352e-09,   4.418967905509269e-11,  -8.023418985507968e-13,   1.306449779885947e-14,  -2.178211167811398e-17,  -1.497427296966635e-17,   5.890290050010139e-19,
  -1.145502063767516e-20,   1.879873001501165e-22,   4.918271600496046e-02,  -2.418180595413824e-03,   8.715540889820676e-05,  -2.720425867280460e-06,   7.606168141112043e-08,
  -1.946891755616649e-09,   4.419074794307113e-11,  -8.023440181529693e-13,   1.306251781258624e-14,  -2.168704003644568e-17,  -1.497649227004219e-17,   5.890720939392403e-19,
  -1.145632272220253e-20,   1.880220380655355e-22,   4.284575221756063e-01,  -1.799052985759178e-02,   4.370590243122284e-04,  -4.475210415057277e-06,  -1.506408673526396e-07,
   8.427732408578945e-09,  -1.649872308302588e-10,  -1.803112721162123e-12,   2.759849627149202e-13,  -7.656675234363267e-15,  -7.201302747560854e-17,   9.288935938002727e-18,
  -2.170283925487067e-19,  -1.060351383913725e-21,   4.284983237254241e-01,  -1.799176080388338e-02,   4.369730317779050e-04,  -4.467342926575802e-06,  -1.508644095863887e-07,
   8.423793893522963e-09,  -1.642699845817656e-10,  -1.827719791542515e-12,   2.756414970973720e-13,  -7.609255547557946e-15,  -7.326128770432834e-17,   9.277292877723006e-18,
  -2.149910090089360e-19,  -1.131990881618339e-21,   4.285703120008833e-01,  -1.799393103502891e-02,   4.368211963587615e-04,  -4.453463739772369e-06,  -1.512580362515082e-07,
   8.416805542782485e-09,  -1.630051490830982e-10,  -1.871009604896666e-12,   2.750312485630056e-13,  -7.525635501493860e-15,  -7.545358173421378e-17,   9.256333346995399e-18,
  -2.113930001264055e-19,  -1.257604175947053e-21,   4.286573495619773e-01,  -1.799655224511006e-02,   4.366374246856092e-04,  -4.436686219239506e-06,  -1.517326211664695e-07,
   8.408289174945382e-09,  -1.614769929250281e-10,  -1.923134979965986e-12,   2.742861956824281e-13,  -7.424612344756297e-15,  -7.808698838728182e-17,   9.230284204946607e-18,
  -2.070373234384623e-19,  -1.408140025685924e-21,   4.287418321432859e-01,  -1.799909367030189e-02,   4.364588439357182e-04,  -4.420404510560658e-06,  -1.521918823921649e-07,
   8.399952720462925e-09,  -1.599948507015824e-10,  -1.973505960595981e-12,   2.735554716457255e-13,  -7.326637702346079e-15,  -8.062507638125067e-17,   9.204262380317913e-18,
  -2.028040195546347e-19,  -1.552856147851651e-21,   4.288098816267418e-01,  -1.800113871693999e-02,   4.363148540185961e-04,  -4.407292220799054e-06,  -1.525608134529664e-07,
   8.393187733500591e-09,  -1.588018398636813e-10,  -2.013918443129205e-12,   2.729615011984347e-13,  -7.247781074739536e-15,  -8.265655197347258e-17,   9.182776711670894e-18,
  -1.993904119480037e-19,  -1.668418884784968e-21,   4.288548433077601e-01,  -1.800248892507586e-02,   4.362196456686684e-04,  -4.398629840074360e-06,  -1.528040856718184e-07,
   8.388693489152054e-09,  -1.580140033618927e-10,  -2.040541187385403e-12,   2.725664256388468e-13,  -7.195708946131614e-15,  -8.399246102956734e-17,   9.168324553290534e-18,
  -1.971332148303683e-19,  -1.744281835206958e-21,   4.288779319813689e-01,  -1.800318197453292e-02,   4.361707323542113e-04,  -4.394181909049189e-06,  -1.529288596577911e-07,
   8.386378049371786e-09,  -1.576095617071331e-10,  -2.054188166491311e-12,   2.723627361837808e-13,  -7.168978307468295e-15,  -8.467651773551532e-17,   9.160824126752459e-18,
  -1.959735741577058e-19,  -1.783086804220241e-21,   4.288859679985147e-01,  -1.800342314149986e-02,   4.361537045609284e-04,  -4.392633864120341e-06,  -1.529722632464768e-07,
   8.385570957419872e-09,  -1.574688160204593e-10,  -2.058934131486633e-12,   2.722917131285999e-13,  -7.159676205711682e-15,  -8.491429203531154e-17,   9.158201051417737e-18,
  -1.955698784950549e-19,  -1.796568665514133e-21,   4.288872431939274e-01,  -1.800346140875360e-02,   4.361510023391155e-04,  -4.392388215374672e-06,  -1.529791496048554e-07,
   8.385442826952101e-09,  -1.574464827554734e-10,  -2.059687061315365e-12,   2.722804367185964e-13,  -7.158200173124574e-15,  -8.495200844913661e-17,   9.157784213321505e-18,
  -1.955058141590330e-19,  -1.798706885095695e-21,   1.096803587220144e+00,  -2.967003064752372e-02,  -5.358005507916387e-05,   1.755921779642156e-05,   2.304252032793115e-08,
  -1.946337026412098e-08,  -4.248110708693868e-12,   2.641893605169386e-11,   4.214808878478083e-14,  -3.551931873427841e-14,  -8.090883885481862e-17,   4.686011162597901e-17,
   6.998201386322938e-20,  -6.460791770036762e-20,   1.096798590066165e+00,  -2.966515482691483e-02,  -5.356711987949590e-05,   1.754139131448339e-05,   2.303776467068632e-08,
  -1.941315968769024e-08,  -4.144214924909442e-12,   2.630486427475281e-11,   4.181971657169800e-14,  -3.529413973513823e-14,  -8.050179523406977e-17,   4.643088910295875e-17,
   6.940397878403987e-20,  -6.380902257863064e-20,   1.096789773492311e+00,  -2.965655536833342e-02,  -5.354429740748923e-05,   1.750997392601009e-05,   2.302948938427140e-08,
  -1.932474208703118e-08,  -3.961582172232047e-12,   2.610418875487649e-11,   4.124167244233815e-14,  -3.489856361658353e-14,  -7.978633487695169e-17,   4.567812361611181e-17,
   6.839618599822320e-20,  -6.241019396955109e-20,   1.096779114072975e+00,  -2.964616363183447e-02,  -5.351670341999683e-05,   1.747204790648187e-05,   2.301968032010578e-08,
  -1.921813241633082e-08,  -3.741920320158036e-12,   2.586255967775635e-11,   4.054503142995252e-14,  -3.442320948473894e-14,  -7.892588248907970e-17,   4.477567926369060e-17,
   6.719811043360540e-20,  -6.073706326560500e-20,   1.096768767848194e+00,  -2.963608264915986e-02,  -5.348991894963139e-05,   1.743529711854036e-05,   2.301036398620474e-08,
  -1.911495702963802e-08,  -3.529909158060277e-12,   2.562906472921205e-11,   3.987118273721687e-14,  -3.396484880851002e-14,  -7.809542963600450e-17,   4.390772325148722e-17,
   6.605634674582405e-20,  -5.913187111346381e-20,   1.096760434321460e+00,  -2.962796664782430e-02,  -5.346834405786718e-05,   1.740573918113057e-05,   2.300300608219954e-08,
  -1.903206856907300e-08,  -3.359997213422898e-12,   2.544173112133122e-11,   3.933008044228279e-14,  -3.359781246163868e-14,  -7.742987311770054e-17,   4.321428966226682e-17,
   6.515166854096448e-20,  -5.785228982051943e-20,   1.096754928291091e+00,  -2.962260623726587e-02,  -5.345408888144530e-05,   1.738623130086773e-05,   2.299821599553294e-08,
  -1.897740889152158e-08,  -3.248153311764022e-12,   2.531831873107635e-11,   3.897338009305192e-14,  -3.335636029392343e-14,  -7.699175769143117e-17,   4.275889594799342e-17,
   6.456121027549146e-20,  -5.701335038351298e-20,   1.096752100871430e+00,  -2.961985418221200e-02,  -5.344676851231131e-05,   1.737622032468964e-05,   2.299577824661198e-08,
  -1.894937297650558e-08,  -3.190849219227296e-12,   2.525505607757539e-11,   3.879045991528296e-14,  -3.323269572664792e-14,  -7.676727859786255e-17,   4.252589672802118e-17,
   6.426023754415804e-20,  -5.658454184628177e-20,   1.096751116792435e+00,  -2.961889642715241e-02,  -5.344422064564585e-05,   1.737273706692906e-05,   2.299493329473715e-08,
  -1.893962029873323e-08,  -3.170925181582565e-12,   2.523305529961223e-11,   3.872683462331448e-14,  -3.318970601577192e-14,  -7.668922817194207e-17,   4.244493699108783e-17,
   6.415583919132327e-20,  -5.643561296780749e-20,   1.096750960634090e+00,  -2.961874445044876e-02,  -5.344381633689487e-05,   1.737218437667444e-05,   2.299479937996844e-08,
  -1.893807294311206e-08,  -3.167764516252416e-12,   2.522956495068971e-11,   3.871674014694517e-14,  -3.318288664905927e-14,  -7.667684651154521e-17,   4.243209633060794e-17,
   6.413928958055809e-20,  -5.641199526862030e-20,   1.779575984820418e+00,  -1.336629770884189e-02,  -5.173683043914447e-04,  -1.313577920108545e-05,  -9.549290313364880e-08,
   1.045923416702828e-08,   6.152527678514516e-10,   1.560654214518176e-11,  -7.956812116808356e-14,  -2.412477516434726e-14,  -1.003506083900669e-15,  -1.537740717172903e-17,
   5.810633689602661e-19,   4.790367019124030e-20,   1.779527383683486e+00,  -1.336995668227100e-02,  -5.174171577294526e-04,  -1.312572781916626e-05,  -9.463130212603111e-08,
   1.048863440564382e-08,   6.149596737823406e-10,   1.552346190966726e-11,  -8.366669861577780e-14,  -2.419049089408147e-14,  -9.993887179780405e-16,  -1.502827212462152e-17,
   5.925419601354473e-19,   4.789460690896271e-20,   1.779441623067093e+00,  -1.337641065796897e-02,  -5.175029670878486e-04,  -1.310796999855303e-05,  -9.311136163013549e-08,
   1.054037781930995e-08,   6.144338409866348e-10,   1.537669518373353e-11,  -9.088412871757248e-14,  -2.430498550140057e-14,  -9.920674231782500e-16,  -1.441238272902965e-17,
   6.126514879251085e-19,   4.787035704331433e-20,   1.779337915070095e+00,  -1.338421088030228e-02,  -5.176060584984237e-04,  -1.308645961208282e-05,  -9.127406760135934e-08,
   1.060271824082273e-08,   6.137832477776975e-10,   1.519893558529627e-11,  -9.958654239918713e-14,  -2.444094170689734e-14,  -9.831192183054229e-16,  -1.366795713467371e-17,
   6.367207814526865e-19,   4.782699742654957e-20,   1.779237231572246e+00,  -1.339177901436475e-02,  -5.177054362119697e-04,  -1.306553858406683e-05,  -8.949112712524239e-08,
   1.066299797786223e-08,   6.131362443652246e-10,   1.502607186349740e-11,  -1.080083715856269e-13,  -2.457031702805123e-14,  -9.743333886704161e-16,  -1.294565332534549e-17,
   6.598268411401051e-19,   4.777026188696430e-20,   1.779156118283423e+00,  -1.339787280196657e-02,  -5.177849909979643e-04,  -1.304865691189933e-05,  -8.805530153314123e-08,
   1.071138695957843e-08,   6.126039990514966e-10,   1.488660420621484e-11,  -1.147739114923268e-13,  -2.467267170680881e-14,  -9.671851116759316e-16,  -1.236407087422766e-17,
   6.782538322938463e-19,   4.771410495780565e-20,   1.779102518129580e+00,  -1.340189799681453e-02,  -5.178373133409543e-04,  -1.303748813726585e-05,  -8.710677496577375e-08,
   1.074327745811747e-08,   6.122469093303807e-10,   1.479434420089252e-11,  -1.192351220513422e-13,  -2.473939132080309e-14,  -9.624273095840848e-16,  -1.197992853228169e-17,
   6.903382592766197e-19,   4.767189643535586e-20,   1.779074991288270e+00,  -1.340396467165427e-02,  -5.178641072869540e-04,  -1.303174821607244e-05,  -8.661973636333350e-08,
   1.075962873954329e-08,   6.120618610102854e-10,   1.474693286046745e-11,  -1.215232694992136e-13,  -2.477337226960224e-14,  -9.599733673733828e-16,  -1.178270415985991e-17,
   6.965157447851824e-19,   4.764864630734329e-20,   1.779065410224064e+00,  -1.340468392424903e-02,  -5.178734210539999e-04,  -1.302974971243056e-05,  -8.645023013169688e-08,
   1.076531580989605e-08,   6.119971882245650e-10,   1.473042592711391e-11,  -1.223192179886521e-13,  -2.478515463912109e-14,  -9.591175689546048e-16,  -1.171406677313781e-17,
   6.986613416208565e-19,   4.764030361312852e-20,   1.779063889836620e+00,  -1.340479805628740e-02,  -5.178748984456174e-04,  -1.302943254555768e-05,  -8.642333239849622e-08,
   1.076621807293694e-08,   6.119869129657203e-10,   1.472780626799140e-11,  -1.224455020928493e-13,  -2.478702220219701e-14,  -9.589816857828892e-16,  -1.170317536672166e-17,
   6.990016029664449e-19,   4.763896786747863e-20,   4.066319578706217e-02,  -1.828210155602518e-03,   6.042135094710835e-05,  -1.753158897238365e-06,   4.574127857165290e-08,
  -1.102688610917569e-09,   2.670763778626390e-11,  -4.617941436733171e-13,   6.413168980574987e-15,  -2.479751649537830e-16,   1.768925383491587e-18,   1.959521494670321e-19,
  -5.188479625105752e-21,   1.199046064192607e-22,   4.066891236122428e-02,  -1.828706900915002e-03,   6.044729360855784e-05,  -1.754200430109244e-06,   4.577903693156856e-08,
  -1.103610581981357e-09,   2.672460236155423e-11,  -4.626037166072300e-13,   6.419615065199409e-15,  -2.469313747729930e-16,   1.737248075295164e-18,   1.968134254636476e-19,
  -5.178455949886705e-21,   1.196345432149138e-22,   4.067900134924127e-02,  -1.829583655356344e-03,   6.049308715834622e-05,  -1.756038937916440e-06,   4.584568159788711e-08,
  -1.105238696719844e-09,   2.675454976319499e-11,  -4.640293322506467e-13,   6.430880983577194e-15,  -2.450859964818692e-16,   1.681397164140688e-18,   1.983314499338939e-19,
  -5.161334683180943e-21,   1.191500917476227e-22,   4.069120447750314e-02,  -1.830644244712779e-03,   6.054849073858493e-05,  -1.758263286796491e-06,   4.592630220781411e-08,
  -1.107209613685732e-09,   2.679078473090699e-11,  -4.657482699937091e-13,   6.444319288013675e-15,  -2.428484221719408e-16,   1.613935083185178e-18,   2.001641139960233e-19,
  -5.141591598878915e-21,   1.185509948130827e-22,   4.070305464171453e-02,  -1.831674274440391e-03,   6.060230650715824e-05,  -1.760423909518447e-06,   4.600460204545115e-08,
  -1.109125227944206e-09,   2.682598410846801e-11,  -4.674118117480343e-13,   6.457171805909731e-15,  -2.406698181666551e-16,   1.548518520425502e-18,   2.019401074525495e-19,
  -5.123425221181806e-21,   1.179557516158233e-22,   4.071260354472742e-02,  -1.832504359711853e-03,   6.064568195860004e-05,  -1.762165384853898e-06,   4.606770427992102e-08,
  -1.110670054183818e-09,   2.685435667701530e-11,  -4.687482266845795e-13,   6.467387313656461e-15,  -2.389101781553692e-16,   1.495871419450938e-18,   2.033685586900311e-19,
  -5.109503096849656e-21,   1.174666407091013e-22,   4.071891454587268e-02,  -1.833053015489840e-03,   6.067435454053951e-05,  -1.763316564460553e-06,   4.610941330929288e-08,
  -1.111691645901760e-09,   2.687311274123418e-11,  -4.696294856060275e-13,   6.474069849458438e-15,  -2.377451963496953e-16,   1.461107742216763e-18,   2.043113336176212e-19,
  -5.100650866708898e-21,   1.171388253295418e-22,   4.072215593547539e-02,  -1.833334822949049e-03,   6.068908264119342e-05,  -1.763907887548614e-06,   4.613083666435042e-08,
  -1.112216528689732e-09,   2.688274733220840e-11,  -4.700814907762981e-13,   6.477480724418249e-15,  -2.371462291751222e-16,   1.443262388178831e-18,   2.047951449595297e-19,
  -5.096211879374040e-21,   1.169690640002841e-22,   4.072328419267344e-02,  -1.833432916014003e-03,   6.069420942612552e-05,  -1.764113724823990e-06,   4.613829385996403e-08,
  -1.112399258181358e-09,   2.688610112950940e-11,  -4.702387255664677e-13,   6.478664579683737e-15,  -2.369376428305736e-16,   1.437052323497336e-18,   2.049634842153442e-19,
  -5.094683862682755e-21,   1.169097535916212e-22,   4.072346323448912e-02,  -1.833448482383677e-03,   6.069502300166816e-05,  -1.764146389402583e-06,   4.613947724272406e-08,
  -1.112428256697042e-09,   2.688663334942928e-11,  -4.702636723005946e-13,   6.478852283088495e-15,  -2.369045378131950e-16,   1.436066927239138e-18,   2.049901946879608e-19,
  -5.094442194557858e-21,   1.169003312690452e-22,   3.631054828405996e-01,  -1.473845355579473e-02,   3.737494366832412e-04,  -5.754704078981774e-06,  -2.171423629801237e-08,
   4.602016489592683e-09,  -1.334963235851848e-10,   2.681409734206727e-12,   1.988914073208037e-14,  -5.277983016227179e-15,   1.280186910152486e-16,   8.056039204591753e-19,
  -1.016142327976664e-19,   3.403567041677158e-21,   3.631404951191427e-01,  -1.474005671049122e-02,   3.737361675110429e-04,  -5.750347951919679e-06,  -2.190120497092759e-08,
   4.607014642824900e-09,  -1.334334399894717e-10,   2.663732666263342e-12,   2.040898842324148e-14,  -5.272902578402731e-15,   1.273895686231564e-16,   8.295654736106608e-19,
  -1.016228153592743e-19,   3.387239411113774e-21,   3.632022736993142e-01,  -1.474288449900285e-02,   3.737126685294160e-04,  -5.742657773961998e-06,  -2.223103807193121e-08,
   4.615805737814230e-09,  -1.333213837415537e-10,   2.632555819368114e-12,   2.132410973467071e-14,  -5.263838590106097e-15,   1.262794309826282e-16,   8.717445602324556e-19,
  -1.016378192032859e-19,   3.358101408956013e-21,   3.632769750769433e-01,  -1.474630218003729e-02,   3.736841078600444e-04,  -5.733352394891090e-06,  -2.262974523618272e-08,
   4.626387914388018e-09,  -1.331840165448615e-10,   2.594881552909546e-12,   2.242700433852488e-14,  -5.252709002094240e-15,   1.249369710810294e-16,   9.225736789468286e-19,
  -1.016556719126011e-19,   3.322313170323019e-21,   3.633494918424207e-01,  -1.474961821312232e-02,   3.736562293757619e-04,  -5.724312280104794e-06,  -2.301666545927304e-08,
   4.636610549801666e-09,  -1.330487111577609e-10,   2.558334558738182e-12,   2.349382169375572e-14,  -5.241727666568738e-15,   1.236336624567955e-16,   9.717335489690861e-19,
  -1.016726344935735e-19,   3.286995767239297e-21,   3.634079089408647e-01,  -1.475228828143022e-02,   3.736336617458126e-04,  -5.717024955598032e-06,  -2.332826386973832e-08,
   4.644809705405294e-09,  -1.329383153561670e-10,   2.528911951899937e-12,   2.435047468350718e-14,  -5.232754751178448e-15,   1.225836833923020e-16,   1.011202996188580e-18,
  -1.016859899354367e-19,   3.258136634406898e-21,   3.634465092000628e-01,  -1.475405198571820e-02,   3.736186960561639e-04,  -5.712207312936338e-06,  -2.353411352802098e-08,
   4.650209908351786e-09,  -1.328646856286577e-10,   2.509479473881750e-12,   2.491518372973013e-14,  -5.226763783645672e-15,   1.218898515346386e-16,   1.037218068486845e-18,
  -1.016946452850603e-19,   3.238868911646783e-21,   3.634663320574817e-01,  -1.475495753760533e-02,   3.736109939454527e-04,  -5.709732510141594e-06,  -2.363981195155033e-08,
   4.652977712908261e-09,  -1.328266625240141e-10,   2.499502905400281e-12,   2.520477072340615e-14,  -5.223668038801926e-15,   1.215335282160375e-16,   1.050557656215377e-18,
  -1.016990338813485e-19,   3.228913082297693e-21,   3.634732315490645e-01,  -1.475527269223930e-02,   3.736083105265738e-04,  -5.708871018992147e-06,  -2.367659882606103e-08,
   4.653940203819474e-09,  -1.328133947096190e-10,   2.496030938509113e-12,   2.530549756233008e-14,  -5.222587498395622e-15,   1.214095054418043e-16,   1.055197365980800e-18,
  -1.017005520603355e-19,   3.225438194475330e-21,   3.634743264016727e-01,  -1.475532270146790e-02,   3.736078845801644e-04,  -5.708734306831234e-06,  -2.368243628094225e-08,
   4.654092896628479e-09,  -1.328112876991178e-10,   2.495480007477132e-12,   2.532147836430692e-14,  -5.222415887330343e-15,   1.213898246797405e-16,   1.055933469276894e-18,
  -1.017007925254359e-19,   3.224886319166610e-21,   9.785719586662710e-01,  -2.927797272369307e-02,   1.471406615446997e-04,   1.504787879277511e-05,  -3.113269295864967e-07,
  -1.164576656588763e-08,   5.793604815924437e-10,   1.032500790325889e-11,  -8.680667860344086e-13,  -6.863904642996403e-15,   1.103319664713462e-15,  -5.172680979370907e-18,
  -1.360084432092537e-18,   2.775762607863588e-20,   9.785854105442915e-01,  -2.927377834644779e-02,   1.469699801621304e-04,   1.503712826615589e-05,  -3.105379462640041e-07,
  -1.162581661432487e-08,   5.771720791801100e-10,   1.030134879364867e-11,  -8.636599489489520e-13,  -6.883838372240149e-15,   1.095518879217134e-15,  -4.995558373830902e-18,
  -1.346617661518367e-18,   2.727865171734434e-20,   9.786091341091950e-01,  -2.926637973092278e-02,   1.466691649725642e-04,   1.501817388149038e-05,  -3.091482395214631e-07,
  -1.159065271008027e-08,   5.733198647218341e-10,   1.025955208888748e-11,  -8.559102367712126e-13,  -6.918295243050321e-15,   1.081820496913421e-15,  -4.685773370783532e-18,
  -1.322993106031837e-18,   2.644073671765450e-20,   9.786377996260232e-01,  -2.925743738548215e-02,   1.463060202279463e-04,   1.499527974448086e-05,  -3.074719901330860e-07,
  -1.154819715416514e-08,   5.686774703482575e-10,   1.020892741162591e-11,  -8.465837579067097e-13,  -6.958746899775104e-15,   1.065368718920135e-15,  -4.315839267053834e-18,
  -1.294660057304000e-18,   2.543977823133803e-20,   9.786656053606942e-01,  -2.924876064319631e-02,   1.459541173380748e-04,   1.497308140761451e-05,  -3.058491041358111e-07,
  -1.150705017996150e-08,   5.641871536500502e-10,   1.015969591864683e-11,  -8.375762370214997e-13,  -6.996755260749307e-15,   1.049514779332218e-15,  -3.961558286669170e-18,
  -1.267398738616554e-18,   2.448078383872675e-20,   9.786879893705266e-01,  -2.924177387412703e-02,   1.456710809068188e-04,   1.495521796830001e-05,  -3.045448657853604e-07,
  -1.147395158234389e-08,   5.605815578757687e-10,   1.011997526902838e-11,  -8.303530490694618e-13,  -7.026477409194292e-15,   1.036826578080108e-15,  -3.679599699062785e-18,
  -1.245611332844703e-18,   2.371726160714980e-20,   9.787027725328148e-01,  -2.923715865941044e-02,   1.454842764926508e-04,   1.494342354493080e-05,  -3.036845819416773e-07,
  -1.145210456425245e-08,   5.582047814533748e-10,   1.009369946887239e-11,  -8.255962729301588e-13,  -7.045680905481645e-15,   1.028483168521798e-15,  -3.494963248370818e-18,
  -1.231299452850318e-18,   2.321712884931964e-20,   9.787103619853950e-01,  -2.923478899504338e-02,   1.453884117809975e-04,   1.493736945558173e-05,  -3.032432587629353e-07,
  -1.144089248424533e-08,   5.569859643712608e-10,   1.008019668793639e-11,  -8.231584321791285e-13,  -7.055408457057664e-15,   1.024210988026388e-15,  -3.400659969317773e-18,
  -1.223975789034146e-18,   2.296163718073265e-20,   9.787130031805344e-01,  -2.923396428634413e-02,   1.453550560573917e-04,   1.493526273770178e-05,  -3.030897275599478e-07,
  -1.143699119699431e-08,   5.565620256658672e-10,   1.007549551330672e-11,  -8.223107129760207e-13,  -7.058772882037776e-15,   1.022726012783666e-15,  -3.367918863149852e-18,
  -1.221430881138772e-18,   2.287292534052916e-20,   9.787134222836323e-01,  -2.923383341997683e-02,   1.453497634792342e-04,   1.493492845258285e-05,  -3.030653678496169e-07,
  -1.143637217245607e-08,   5.564947658019019e-10,   1.007474943497205e-11,  -8.221762292669913e-13,  -7.059305757997039e-15,   1.022490462370590e-15,  -3.362727190071582e-18,
  -1.221027236686617e-18,   2.285885815789264e-20,   1.716826261423892e+00,  -1.813995310135687e-02,  -6.742977942600301e-04,  -1.205766089127720e-05,   2.907847009094844e-07,
   2.908457139191198e-08,   8.274518869273010e-10,  -8.962226905433942e-12,  -1.675580729507758e-12,  -5.792607513231917e-14,   1.301262866297752e-16,   9.669590384149457e-17,
   4.013605709680191e-18,   2.230800660085503e-20,   1.716763387161095e+00,  -1.814324892798638e-02,  -6.741279796032564e-04,  -1.203056947185144e-05,   2.918966709318368e-07,
   2.906405346881736e-08,   8.230817812712836e-10,  -9.144717815030830e-12,  -1.674315183550650e-12,  -5.742699014062852e-14,   1.527565180799033e-16,   9.672867758941979e-17,
   3.966184305984454e-18,   1.989895462151715e-20,   1.716652458209326e+00,  -1.814905830294963e-02,  -6.738278425949696e-04,  -1.198278274818841e-05,   2.938537753162643e-07,
   2.902756358534880e-08,   8.153737906448834e-10,  -9.465356566766055e-12,  -1.672006431617631e-12,  -5.654634076453626e-14,   1.924482894251123e-16,   9.677261887209638e-17,
   3.882405115164664e-18,   1.568019974200060e-20,   1.716518345074751e+00,  -1.815607255567541e-02,  -6.734640689127490e-04,  -1.192502683156279e-05,   2.962118310879424e-07,
   2.898295401157353e-08,   8.060586507946075e-10,  -9.850741697375166e-12,  -1.669086194153008e-12,  -5.548147898575074e-14,   2.400351172833826e-16,   9.680220358254670e-17,
   3.780931583169509e-18,   1.063362936785765e-20,   1.716388174835950e+00,  -1.816287087312150e-02,  -6.731100410321548e-04,  -1.186898820864759e-05,   2.984920976761684e-07,
   2.893914119119905e-08,   7.970215141424662e-10,  -1.022242229137495e-11,  -1.666117466106880e-12,  -5.444780961224231e-14,   2.858030393978794e-16,   9.680643116279745e-17,
   3.682260093968726e-18,   5.792053473311353e-21,   1.716283328938836e+00,  -1.816833963201185e-02,  -6.728242097320872e-04,  -1.182386571997572e-05,   3.003226814167056e-07,
   2.890348451231691e-08,   7.897455956593062e-10,  -1.052009197520381e-11,  -1.663630529651924e-12,  -5.361519126743306e-14,   3.223657867579417e-16,   9.679240661947946e-17,
   3.602663414307012e-18,   1.933089907720961e-21,   1.716214057241486e+00,  -1.817194943459995e-02,  -6.726350290896948e-04,  -1.179406016140475e-05,   3.015291809651513e-07,
   2.887974669007797e-08,   7.849399336060550e-10,  -1.071592937196138e-11,  -1.661940716971548e-12,  -5.306507111108744e-14,   3.463752457645604e-16,   9.677465315873385e-17,
   3.550017733354672e-18,  -5.965551485738009e-22,   1.716178485572968e+00,  -1.817380204871206e-02,  -6.725377805191279e-04,  -1.177875686348838e-05,   3.021478122957377e-07,
   2.886750170696309e-08,   7.824726648476150e-10,  -1.081623609925824e-11,  -1.661058583789729e-12,  -5.278257938314727e-14,   3.586586728501998e-16,   9.676292168824454e-17,
   3.522967029276674e-18,  -1.889364982636197e-21,   1.716166104952036e+00,  -1.817444667823314e-02,  -6.725039171089511e-04,  -1.177343093408553e-05,   3.023629791587744e-07,
   2.886323106620103e-08,   7.816140165487066e-10,  -1.085110656458520e-11,  -1.660749271237411e-12,  -5.268425920524550e-14,   3.629266150671872e-16,   9.675842316794145e-17,
   3.513549518719769e-18,  -2.338338061162467e-21,   1.716164140338138e+00,  -1.817454896305077e-02,  -6.724985427329080e-04,  -1.177258580731537e-05,   3.023971158928668e-07,
   2.886255296331174e-08,   7.814777659925847e-10,  -1.085663802339745e-11,  -1.660700079528964e-12,  -5.266865732596307e-14,   3.636035265727768e-16,   9.675768961873825e-17,
   3.512054983236229e-18,  -2.409536357763389e-21,   3.419947159176791e-02,  -1.418019643077641e-03,   4.314842223498969e-05,  -1.166978915506866e-06,   2.913776166837338e-08,
  -6.010878118947772e-10,   1.548613669019391e-11,  -3.722940552539768e-13,   3.463056036340126e-16,  -5.426465816262487e-17,   7.222671812141051e-18,   9.326199132455178e-20,
  -7.202869133221341e-22,  -8.426719637520157e-23,   3.420354990031223e-02,  -1.418349863311167e-03,   4.316493523865027e-05,  -1.167548622056297e-06,   2.915955808265784e-08,
  -6.018234650656286e-10,   1.548766802048087e-11,  -3.724654777017514e-13,   3.764824329145083e-16,  -5.381086984109115e-17,   7.214157499795571e-18,   9.257585320747314e-20,
  -8.093814250366634e-22,  -8.562924188402333e-23,   3.421074741330096e-02,  -1.418932673461890e-03,   4.319408266650289e-05,  -1.168554439770801e-06,   2.919802019436811e-08,
  -6.031218053328456e-10,   1.549043428954475e-11,  -3.727667303275507e-13,   4.296972006479999e-16,  -5.301309668374115e-17,   7.198697234271969e-18,   9.135793372077521e-20,
  -9.655449676663951e-22,  -8.796694083977658e-23,   3.421945289469065e-02,  -1.419637637780514e-03,   4.322934505341024e-05,  -1.169771642917215e-06,   2.924453244396862e-08,
  -6.046922290424693e-10,   1.549388872825774e-11,  -3.731289251373178e-13,   4.939882631535648e-16,  -5.205345908009497e-17,   7.179261630813799e-18,   8.987316718740580e-20,
  -1.152597468454495e-21,  -9.068248458608718e-23,   3.422790630026723e-02,  -1.420322239681363e-03,   4.326359497739141e-05,  -1.170954285646538e-06,   2.928968941085325e-08,
  -6.062172458498193e-10,   1.549735677213499e-11,  -3.734783633812658e-13,   5.563401470514450e-16,  -5.112715975838489e-17,   7.159622631049141e-18,   8.841950053545691e-20,
  -1.332318543517018e-21,  -9.320312463411251e-23,   3.423471788432247e-02,  -1.420873914342065e-03,   4.329119903162694e-05,  -1.171907726007885e-06,   2.932606995799955e-08,
  -6.074461198916926e-10,   1.550023259938300e-11,  -3.737583135488225e-13,   6.065255740124364e-16,  -5.038475947222647e-17,   7.143252348007953e-18,   8.723987954847669e-20,
  -1.475762388076367e-21,  -9.515156291858692e-23,   3.423921965622691e-02,  -1.421238533552836e-03,   4.330944554725889e-05,  -1.172538094386584e-06,   2.935011090676657e-08,
  -6.082583041253702e-10,   1.550217303273159e-11,  -3.739425414248497e-13,   6.396650889698706e-16,  -4.989606887850625e-17,   7.132167482790802e-18,   8.645630654295240e-20,
  -1.569892883524200e-21,  -9.639909017003737e-23,   3.424153177848718e-02,  -1.421425808460776e-03,   4.331881793851562e-05,  -1.172861927572474e-06,   2.936245749987129e-08,
  -6.086754508752071e-10,   1.550318194696056e-11,  -3.740369172101364e-13,   6.566768974171357e-16,  -4.964568391650070e-17,   7.126392372181412e-18,   8.605265609362115e-20,
  -1.618030957062495e-21,  -9.702745065847872e-23,   3.424233657313765e-02,  -1.421490995267233e-03,   4.332208039277074e-05,  -1.172974658010218e-06,   2.936675491117636e-08,
  -6.088206507770755e-10,   1.550353508393102e-11,  -3.740697283454400e-13,   6.625969049191654e-16,  -4.955862776342075e-17,   7.124369182430121e-18,   8.591196490597116e-20,
  -1.634753627202882e-21,  -9.724420333011136e-23,   3.424246428483177e-02,  -1.421501339708392e-03,   4.332259811393494e-05,  -1.172992547600955e-06,   2.936743685432986e-08,
  -6.088436923887593e-10,   1.550359121566324e-11,  -3.740749332545167e-13,   6.635362758292002e-16,  -4.954481755062196e-17,   7.124047508225381e-18,   8.588962983780401e-20,
  -1.637405754748660e-21,  -9.727850633324566e-23,   3.096939144928789e-01,  -1.202460079096288e-02,   3.051505307170650e-04,  -5.514963842360284e-06,   4.412565801813034e-08,
   2.231240713422643e-09,  -7.093770898944880e-11,   1.274375682862321e-12,  -7.803852259151002e-14,  -2.919441413552407e-16,   1.128309328822037e-16,  -5.007478066852383e-19,
   1.580918878052979e-20,  -3.488941005574767e-22,   3.097225709516974e-01,  -1.202614442522334e-02,   3.051747741032003e-04,  -5.512851123645490e-06,   4.402361145183055e-08,
   2.233732668365148e-09,  -7.113270246603207e-11,   1.273319117893511e-12,  -7.756136896266403e-14,  -2.946571000328867e-16,   1.128749435791741e-16,  -5.040111393412853e-19,
   1.463187193117437e-20,  -3.628269409297149e-22,   3.097731375032124e-01,  -1.202886770547771e-02,   3.052175047386314e-04,  -5.509121304126372e-06,   4.384332962433200e-08,
   2.238128035627032e-09,  -7.147575266191192e-11,   1.271447249592831e-12,  -7.671931972835451e-14,  -2.994585191352456e-16,   1.129468002529481e-16,  -5.098426128600805e-19,
   1.256545522655788e-20,  -3.866979295067082e-22,   3.098342861485731e-01,  -1.203215989492989e-02,   3.052690945312381e-04,  -5.504607937816550e-06,   4.362495820174988e-08,
   2.243440008611621e-09,  -7.188883527605247e-11,   1.269170877584914e-12,  -7.570094066440721e-14,  -3.052891283079333e-16,   1.130238370446569e-16,  -5.170161801900818e-19,
   1.008546038205798e-20,  -4.143539317730866e-22,   3.098936513657684e-01,  -1.203535502578371e-02,   3.053190925740636e-04,  -5.500223060046704e-06,   4.341257772430838e-08,
   2.248593677977074e-09,  -7.228802927041236e-11,   1.266947482318090e-12,  -7.471216113468836e-14,  -3.109754742771926e-16,   1.130883534506727e-16,  -5.241043886158006e-19,
   7.697572580366650e-21,  -4.399459023148892e-22,   3.099414774822778e-01,  -1.203792835826214e-02,   3.053593097898106e-04,  -5.496688238694420e-06,   4.324120857345738e-08,
   2.252743176842494e-09,  -7.260831104805905e-11,   1.265146622579521e-12,  -7.391551434413969e-14,  -3.155751842210841e-16,   1.131330030997034e-16,  -5.299010356109219e-19,
   5.788016445664803e-21,  -4.596696789176110e-22,   3.099730812383855e-01,  -1.203962846518835e-02,   3.053858549348229e-04,  -5.494351306741576e-06,   4.312783496704567e-08,
   2.255483996780064e-09,  -7.281930918018106e-11,   1.263951876420055e-12,  -7.338906077263455e-14,  -3.186238936849558e-16,   1.131589346130683e-16,  -5.337726810357297e-19,
   4.533123861711147e-21,  -4.722685529827154e-22,   3.099893116225065e-01,  -1.204050145699215e-02,   3.053994779545910e-04,  -5.493150813973356e-06,   4.306957022133648e-08,
   2.256891199674188e-09,  -7.292746939234581e-11,   1.263336839700377e-12,  -7.311868923050205e-14,  -3.201924429904600e-16,   1.131711499017116e-16,  -5.357735200864351e-19,
   3.890814245764111e-21,  -4.786049981258164e-22,   3.099949608109496e-01,  -1.204080529474549e-02,   3.054042181090785e-04,  -5.492732913147835e-06,   4.304928396618686e-08,
   2.257380935455293e-09,  -7.296508411396774e-11,   1.263122535137761e-12,  -7.302458204976312e-14,  -3.207388524497938e-16,   1.131752264014776e-16,  -5.364719114462388e-19,
   3.667592957709686e-21,  -4.807892287004016e-22,   3.099958572619461e-01,  -1.204085350889845e-02,   3.054049702368838e-04,  -5.492666595273563e-06,   4.304606450002167e-08,
   2.257458647210806e-09,  -7.297105156012203e-11,   1.263088516775953e-12,  -7.300964844839230e-14,  -3.208255820399777e-16,   1.131758649765239e-16,  -5.365828301942167e-19,
   3.632186978500309e-21,  -4.811348293945479e-22,   8.648215726048746e-01,  -2.747576629594167e-02,   2.927207348358783e-04,   9.000492384625397e-06,  -3.979476125927754e-07,
   2.637126306572937e-09,   4.961249802944713e-10,  -1.419762402349916e-11,  -4.978547047647247e-13,   2.084727466028215e-14,   1.846961171879382e-16,  -1.926838478835558e-17,
   6.345013366194462e-19,   1.455660036707701e-20,   8.648485735697918e-01,  -2.747322704499764e-02,   2.925007337833536e-04,   9.002739765179391e-06,  -3.972651442266953e-07,
   2.610249056345880e-09,   4.948366601983428e-10,  -1.412974009367492e-11,  -4.969715975369715e-13,   2.075173754340889e-14,   1.880204509720653e-16,  -1.916920801781550e-17,
   6.212937425571835e-19,   1.442310384060942e-20,   8.648962008844830e-01,  -2.746874602152491e-02,   2.921128469896023e-04,   9.006685146914765e-06,  -3.960623835306098e-07,
   2.562931167032235e-09,   4.925653452266879e-10,  -1.401021719323663e-11,  -4.954024609760371e-13,   2.058356918647327e-14,   1.938215424840733e-16,  -1.899498620695426e-17,
   5.981421498085194e-19,   1.418875666021107e-20,   8.649537645432859e-01,  -2.746332671281059e-02,   2.916443357380885e-04,   9.011421631408245e-06,  -3.946104896335978e-07,
   2.505896784475528e-09,   4.898221805430200e-10,  -1.386613029965685e-11,  -4.934866427078985e-13,   2.038091234474763e-14,   2.007264089395993e-16,  -1.878563538152192e-17,
   5.704079738168827e-19,   1.390746431706175e-20,   8.650096172557167e-01,  -2.745806490027452e-02,   2.911900629507657e-04,   9.015983866725765e-06,  -3.932036291980857e-07,
   2.450719980311661e-09,   4.871626742170496e-10,  -1.372671457976739e-11,  -4.916077198645214e-13,   2.018490067437860e-14,   2.073151420405947e-16,  -1.858377704728051e-17,
   5.437566294612598e-19,   1.363659702641173e-20,   8.650545906447441e-01,  -2.745382545237783e-02,   2.908245002393113e-04,   9.019633499037011e-06,  -3.920721515345284e-07,
   2.406406996345663e-09,   4.850227393953558e-10,  -1.361473295996640e-11,  -4.900805471962807e-13,   2.002751305426829e-14,   2.125414489446840e-16,  -1.842214374113332e-17,
   5.224813557549249e-19,   1.341998817153943e-20,   8.650842980658437e-01,  -2.745102380799139e-02,   2.905831354333690e-04,   9.022032574575352e-06,  -3.913254066741904e-07,
   2.377192611527839e-09,   4.836099522746073e-10,  -1.354089874070380e-11,  -4.890648444407821e-13,   1.992376638042828e-14,   2.159551889570188e-16,  -1.831581784452086e-17,
   5.085181414670874e-19,   1.327764631682317e-20,   8.650995510968802e-01,  -2.744958493924875e-02,   2.904592425604742e-04,   9.023260741906226e-06,  -3.909422004384301e-07,
   2.362210277961876e-09,   4.828848042722807e-10,  -1.350303114313326e-11,  -4.885412107473734e-13,   1.987056534495158e-14,   2.176960673081841e-16,  -1.826136199073086e-17,
   5.013767277776642e-19,   1.320479252673597e-20,   8.651048595524550e-01,  -2.744908411345179e-02,   2.904161299814445e-04,   9.023687600625956e-06,  -3.908088670387171e-07,
   2.356998825278874e-09,   4.826324713896904e-10,  -1.348985890316610e-11,  -4.883586343978838e-13,   1.985206061549727e-14,   2.183000508466569e-16,  -1.824243159135502e-17,
   4.988957640091396e-19,   1.317947431730540e-20,   8.651057019074369e-01,  -2.744900463861428e-02,   2.904092890584155e-04,   9.023755307982195e-06,  -3.907877110024535e-07,
   2.356171995456206e-09,   4.825924325590615e-10,  -1.348776902617526e-11,  -4.883296468345303e-13,   1.984912475711259e-14,   2.183958024475718e-16,  -1.823942871064594e-17,
   4.985022908726841e-19,   1.317545853054610e-20,   1.632738943662548e+00,  -2.398373646169438e-02,  -7.689282786401091e-04,  -1.889191894302793e-06,   1.012218603032719e-06,
   3.824793518711854e-08,  -4.166978523634596e-10,  -8.354201235601987e-11,  -2.198455848139730e-12,   7.590842110382553e-14,   6.803066681825924e-15,   1.039376213393039e-16,
  -8.968811674472118e-18,  -5.232030851381889e-19,   1.632667992260368e+00,  -2.398414651607044e-02,  -7.683625902870895e-04,  -1.854677316827834e-06,   1.011571735245599e-06,
   3.808771977084831e-08,  -4.219181175389124e-10,  -8.327569218754659e-11,  -2.171531077022181e-12,   7.631612707622907e-14,   6.747789597015404e-15,   1.005711525200363e-16,
  -8.967289799498463e-18,  -5.147943796824181e-19,   1.632542840054737e+00,  -2.398486240339124e-02,  -7.673647341273078e-04,  -1.793896595182994e-06,   1.010424573002549e-06,
   3.780544817377588e-08,  -4.310729727860838e-10,  -8.280473999073733e-11,  -2.124211196794582e-12,   7.702188514090750e-14,   6.650283975104894e-15,   9.468019280230505e-17,
  -8.962406027960575e-18,  -5.000128514417434e-19,   1.632391577390238e+00,  -2.398571501945286e-02,  -7.661586458136707e-04,  -1.720605632358423e-06,   1.009027644774836e-06,
   3.746485832507741e-08,  -4.420472571184000e-10,  -8.223353510577059e-11,  -2.067314159697820e-12,   7.785216864092503e-14,   6.532440441876273e-15,   8.764048180719200e-17,
  -8.952795421827532e-18,  -4.822352373404682e-19,   1.632244810341541e+00,  -2.398652908998105e-02,  -7.649883533670060e-04,  -1.649671187730292e-06,   1.007661358007453e-06,
   3.713499163172548e-08,  -4.526008665604006e-10,  -8.167724531290301e-11,  -2.012417248106830e-12,   7.863415382520792e-14,   6.418113433604879e-15,   8.089379785813951e-17,
  -8.939640726650570e-18,  -4.650795620378527e-19,   1.632126631244128e+00,  -2.398717514226427e-02,  -7.640459817635436e-04,  -1.592681273281429e-06,   1.006553445099310e-06,
   3.686980939512091e-08,  -4.610312901666011e-10,  -8.122785678397072e-11,  -1.968434893553186e-12,   7.924701202935915e-14,   6.326072171408910e-15,   7.552112291998947e-17,
  -8.926341559160666e-18,  -4.513337436629748e-19,   1.632048567293590e+00,  -2.398759727380757e-02,  -7.634234762412200e-04,  -1.555098649051878e-06,   1.005817821826313e-06,
   3.669485335768631e-08,  -4.665670916260148e-10,  -8.093030642703696e-11,  -1.939490522244000e-12,   7.964365626621271e-14,   6.265284460262118e-15,   7.200140269098043e-17,
  -8.916246279699650e-18,  -4.422877040496692e-19,   1.632008485972987e+00,  -2.398781258534322e-02,  -7.631038508770969e-04,  -1.535821441564315e-06,   1.005438954437740e-06,
   3.660508915220786e-08,  -4.693992273387086e-10,  -8.077731568315393e-11,  -1.924662803743774e-12,   7.984478929508346e-14,   6.234077355179662e-15,   7.020325520261998e-17,
  -8.910660828298833e-18,  -4.376536502535013e-19,   1.631994536616093e+00,  -2.398788729208512e-02,  -7.629926120661805e-04,  -1.529115535737338e-06,   1.005306912997724e-06,
   3.657385929273325e-08,  -4.703832664917199e-10,  -8.072403666651300e-11,  -1.919507706510808e-12,   7.991438844765355e-14,   6.223217123598690e-15,   6.957888786437364e-17,
  -8.908653206497854e-18,  -4.360425676110569e-19,   1.631992323107635e+00,  -2.398789913589055e-02,  -7.629749604607653e-04,  -1.528051576588905e-06,   1.005285951624458e-06,
   3.656890418014805e-08,  -4.705393387352111e-10,  -8.071558063814964e-11,  -1.918689940135633e-12,   7.992541357041511e-14,   6.221493835486809e-15,   6.947988027464282e-17,
  -8.908331613336053e-18,  -4.357869986041362e-19,   2.913920560025350e-02,  -1.121721757828488e-03,   3.160095770597120e-05,  -7.802787101717623e-07,   1.999494754074954e-08,
  -3.529015095299586e-10,   5.358707243938716e-12,  -3.306939610183734e-13,   4.218489492826618e-15,   2.662402938280453e-16,   6.097854703436428e-18,  -2.892188363166858e-19,
  -1.719394690111329e-20,  -2.128337760046900e-22,   2.914219085038849e-02,  -1.121942396125405e-03,   3.161224822752487e-05,  -7.806149011849762e-07,   2.000262028055861e-08,
  -3.535389936386381e-10,   5.370239307339225e-12,  -3.298352967523273e-13,   4.241138900701713e-15,   2.647146152633903e-16,   6.000753990224895e-18,  -2.901914855370269e-19,
  -1.699231972724693e-20,  -2.019382528350917e-22,   2.914745923706002e-02,  -1.122331793674556e-03,   3.163217407214595e-05,  -7.812085972635413e-07,   2.001617231186188e-08,
  -3.546624897329993e-10,   5.390634310460102e-12,  -3.283243796476819e-13,   4.280779224103638e-15,   2.620190370142351e-16,   5.830423392069786e-18,  -2.918459160740096e-19,
  -1.663735407569181e-20,  -1.829329063086403e-22,   2.915383130304334e-02,  -1.122802790086815e-03,   3.165627465954561e-05,  -7.819273216272474e-07,   2.003258239005144e-08,
  -3.560187280657006e-10,   5.415374978772983e-12,  -3.265045459620281e-13,   4.328161070168819e-15,   2.587537296014549e-16,   5.626168707243040e-18,  -2.937419365257897e-19,
  -1.620953238767629e-20,  -1.603245436240647e-22,   2.916001874085156e-02,  -1.123260164344770e-03,   3.167967742641519e-05,  -7.826259053632449e-07,   2.004853694847281e-08,
  -3.573329327484103e-10,   5.439474729539783e-12,  -3.247454126417421e-13,   4.373583848427429e-15,   2.555779864954900e-16,   5.429669610305907e-18,  -2.954742124299587e-19,
  -1.579571834106659e-20,  -1.387649287573531e-22,   2.916500436848652e-02,  -1.123628718826204e-03,   3.169853493305519e-05,  -7.831892898706150e-07,   2.006140691651156e-08,
  -3.583899177889090e-10,   5.458947466850346e-12,  -3.233336777503009e-13,   4.409766184769157e-15,   2.530156188324388e-16,   5.272650726178702e-18,  -2.967928662741410e-19,
  -1.546345971874112e-20,  -1.216731419637893e-22,   2.916829932508695e-02,  -1.123872301918018e-03,   3.171099786294159e-05,  -7.835618649574946e-07,   2.006991958809798e-08,
  -3.590875136330758e-10,   5.471843078074252e-12,  -3.224034744575672e-13,   4.433475094969603e-15,   2.513205401165571e-16,   5.169520184688594e-18,  -2.976268997448353e-19,
  -1.524445962156660e-20,  -1.105137866034805e-22,   2.916999161080128e-02,  -1.123997408605611e-03,   3.171739886233427e-05,  -7.837532930140203e-07,   2.007429386076046e-08,
  -3.594455027373772e-10,   5.478474330510071e-12,  -3.219265892625220e-13,   4.445589166210361e-15,   2.504494578941124e-16,   5.116750683174501e-18,  -2.980437446462662e-19,
  -1.513216486742503e-20,  -1.048243941980916e-22,   2.917058065306365e-02,  -1.124040955540747e-03,   3.171962689844169e-05,  -7.838199360907374e-07,   2.007581678193114e-08,
  -3.595700628044574e-10,   5.480783786745277e-12,  -3.217607353782635e-13,   4.449795790732358e-15,   2.501461788576632e-16,   5.098414473857936e-18,  -2.981870110631225e-19,
  -1.509310725587451e-20,  -1.028507375554368e-22,   2.917067412722687e-02,  -1.124047865953884e-03,   3.171998046229295e-05,  -7.838305121311554e-07,   2.007605846827743e-08,
  -3.595898268107296e-10,   5.481150331476968e-12,  -3.217344228410677e-13,   4.450462859722579e-15,   2.500980483598390e-16,   5.095506226911905e-18,  -2.982096591766483e-19,
  -1.508691066499671e-20,  -1.025378579282739e-22,   2.660794906373707e-01,  -9.833282031657883e-03,   2.444012645798052e-04,  -4.537228636177740e-06,   7.322641722168005e-08,
   6.951941686450915e-10,  -6.581933052053142e-11,  -5.621350209505753e-13,  -1.306908353593942e-14,   3.620942516205924e-15,   6.318999249953706e-17,  -3.368659989826139e-18,
  -1.678168862856988e-19,  -2.980497270355422e-21,   2.661024848312935e-01,  -9.834555857189760e-03,   2.444419297938249e-04,  -4.536584452361818e-06,   7.313351734452334e-08,
   6.942733366467493e-10,  -6.584883524616359e-11,  -5.503833015166331e-13,  -1.283227681291258e-14,   3.603030295834030e-15,   6.224886973649892e-17,  -3.383641085236161e-18,
  -1.657079867421320e-19,  -2.853470721862459e-21,   2.661430614856059e-01,  -9.836803396360656e-03,   2.445136416425472e-04,  -4.535448424845319e-06,   7.296956216677598e-08,
   6.926670918618581e-10,  -6.590040922752250e-11,  -5.296967314308441e-13,  -1.241757035242656e-14,   3.571367912714540e-15,   6.059877493406310e-17,  -3.409353213533436e-18,
  -1.619935928250953e-19,  -2.631784572711409e-21,   2.661921323863303e-01,  -9.839520895849682e-03,   2.446002837966829e-04,  -4.534075818373531e-06,   7.277125182065251e-08,
   6.907564255553670e-10,  -6.596194619423066e-11,  -5.047668490142205e-13,  -1.192143686292798e-14,   3.532987977756787e-15,   5.862139361519470e-17,  -3.439222939453590e-18,
  -1.575140435160377e-19,  -2.367883790363214e-21,   2.662397749855705e-01,  -9.842158736785877e-03,   2.446843184838026e-04,  -4.532744445152984e-06,   7.257867949802834e-08,
   6.889346283674220e-10,  -6.602082508611379e-11,  -4.806540010591288e-13,  -1.144535338276580e-14,   3.495634113302240e-15,   5.672052997462552e-17,  -3.466953161721795e-18,
  -1.531783189663551e-19,  -2.116028698727120e-21,   2.662781591240983e-01,  -9.844283560548726e-03,   2.447519612612511e-04,  -4.531672708810181e-06,   7.242350589409073e-08,
   6.874906393905346e-10,  -6.606764490011498e-11,  -4.612926062208112e-13,  -1.106578428030801e-14,   3.465475848120658e-15,   5.520262497978448e-17,  -3.488393402559178e-18,
  -1.496950999784899e-19,  -1.916225436609323e-21,   2.663035245780665e-01,  -9.845687514909050e-03,   2.447966317285214e-04,  -4.530964913064554e-06,   7.232095056425872e-08,
   6.865480258060308e-10,  -6.609828444139027e-11,  -4.485301160038033e-13,  -1.081690059596135e-14,   3.445515974852707e-15,   5.420617450862093e-17,  -3.502124156235955e-18,
  -1.473982670614720e-19,  -1.785703539752235e-21,   2.663165515394878e-01,  -9.846408484411635e-03,   2.448195639006589e-04,  -4.530601545503982e-06,   7.226827753105155e-08,
   6.860675159038258e-10,  -6.611392744792960e-11,  -4.419856146631663e-13,  -1.068968152278805e-14,   3.435255934307218e-15,   5.369647430369580e-17,  -3.509041291003375e-18,
  -1.462202489279282e-19,  -1.719138013909968e-21,   2.663210857861621e-01,  -9.846659419954454e-03,   2.448275443396710e-04,  -4.530475091043414e-06,   7.224994325246462e-08,
   6.859008375697943e-10,  -6.611935754531436e-11,  -4.397092776404654e-13,  -1.064549625289076e-14,   3.431683304040733e-15,   5.351939063784789e-17,  -3.511427554749679e-18,
  -1.458104724948866e-19,  -1.696042956061951e-21,   2.663218053130988e-01,  -9.846699239755776e-03,   2.448288106630760e-04,  -4.530455025360210e-06,   7.224703381004949e-08,
   6.858744149489645e-10,  -6.612021853476318e-11,  -4.393481272651738e-13,  -1.063848914159624e-14,   3.431116304498200e-15,   5.349130518893376e-17,  -3.511805211711555e-18,
  -1.457454582277514e-19,  -1.692381583576852e-21,   7.601429064412502e-01,  -2.480277783701232e-02,   3.659324300328009e-04,   3.543792390524687e-06,  -2.646132113400109e-07,
   8.687076275201261e-09,  -8.367365258591843e-12,  -1.781450074030960e-11,   2.607040596410368e-13,   1.944219730018436e-14,  -1.430434565583576e-16,  -6.157093090457204e-18,
  -5.413015471970815e-19,  -3.140557249469382e-20,   7.601769137085609e-01,  -2.480175352774850e-02,   3.657835678299213e-04,   3.551651259440605e-06,  -2.646170808134182e-07,
   8.653028888846645e-09,  -7.697614151865889e-12,  -1.774992012461371e-11,   2.600103060937675e-13,   1.940345670758064e-14,  -1.459240598829066e-16,  -6.343434752814489e-18,
  -5.311124206245073e-19,  -3.060172189160605e-20,   7.602369087213821e-01,  -2.479994437014737e-02,   3.655208982099006e-04,   3.565492721792281e-06,  -2.646231486999981e-07,
   8.593054583434400e-09,  -6.517361870199736e-12,  -1.763607789914983e-11,   2.587766967713661e-13,   1.933436064757271e-14,  -1.509562331186068e-16,  -6.667634569429713e-18,
  -5.131829707014077e-19,  -2.919640856548127e-20,   7.603094359874948e-01,  -2.479775374124095e-02,   3.652032756687718e-04,   3.582186308719743e-06,  -2.646291916651669e-07,
   8.520708243085362e-09,  -5.092817365301874e-12,  -1.749860975131436e-11,   2.572689738380255e-13,   1.924956409514703e-14,  -1.569549297252861e-16,  -7.051864742202728e-18,
  -4.915885756122763e-19,  -2.751933966310653e-20,   7.603798239451506e-01,  -2.479562400496858e-02,   3.648949338916029e-04,   3.598346504612827e-06,  -2.646337041844869e-07,
   8.450659006243210e-09,  -3.712664491547283e-12,  -1.736535984704787e-11,   2.557886673776012e-13,   1.916595789329973e-14,  -1.626882632196271e-16,  -7.416772294583382e-18,
  -4.707175438103449e-19,  -2.591447451049282e-20,   7.604365130548476e-01,  -2.479390609116037e-02,   3.646465384700016e-04,   3.611332288663897e-06,  -2.646363704772865e-07,
   8.394359498486176e-09,  -2.602828110946396e-12,  -1.725816122206465e-11,   2.545843387365501e-13,   1.909769508144289e-14,  -1.672425755485416e-16,  -7.704983190158269e-18,
  -4.539719244646584e-19,  -2.463817277090705e-20,   7.604739651025304e-01,  -2.479276983584937e-02,   3.644824036305452e-04,   3.619897091778779e-06,  -2.646376583543495e-07,
   8.357222001984366e-09,  -1.870450491147990e-12,  -1.718739812339872e-11,   2.537827985823059e-13,   1.905214693137550e-14,  -1.702205273383538e-16,  -7.892629560495610e-18,
  -4.429405506118977e-19,  -2.380289375694243e-20,   7.604931963234232e-01,  -2.479218597806256e-02,   3.643981126881208e-04,   3.624290592731731e-06,  -2.646381732608704e-07,
   8.338169969793327e-09,  -1.494644400778646e-12,  -1.715108020457124e-11,   2.533694029214922e-13,   1.902862028232537e-14,  -1.717401346096734e-16,  -7.988133604708782e-18,
  -4.372860083257987e-19,  -2.337643028902207e-20,   7.604998895761095e-01,  -2.479198270749789e-02,   3.643687744793856e-04,   3.625819005640153e-06,  -2.646383291676456e-07,
   8.331541894652627e-09,  -1.363890273886228e-12,  -1.713844298229896e-11,   2.532252363650705e-13,   1.902041013288027e-14,  -1.722675027666971e-16,  -8.021237893674243e-18,
  -4.353195917345634e-19,  -2.322839200442738e-20,   7.605009516865208e-01,  -2.479195044871877e-02,   3.643641189109642e-04,   3.626061506444163e-06,  -2.646383528014219e-07,
   8.330490260367792e-09,  -1.343143704904276e-12,  -1.713643779844424e-11,   2.532023458223770e-13,   1.901910627708835e-14,  -1.723511155075666e-16,  -8.026484602832873e-18,
  -4.350076293794600e-19,  -2.320491916686087e-20,   1.524813153357730e+00,  -2.990027254111588e-02,  -6.733505886747436e-04,   1.899554368774086e-05,   1.464325952839299e-06,
  -3.341882698960217e-09,  -2.956577875530929e-09,  -5.981882189488954e-11,   4.773319109704256e-12,   2.364511352509196e-13,  -4.540240750313043e-15,  -6.105530412490434e-16,
  -4.950735122969699e-18,   1.188442218589832e-18,   1.524751634505922e+00,  -2.989494438745652e-02,  -6.725494930147950e-04,   1.899152713680584e-05,   1.460310983224607e-06,
  -3.448279522204229e-09,  -2.944456251578288e-09,  -5.909382523228995e-11,   4.753620396435146e-12,   2.336046257786585e-13,  -4.558965309548754e-15,  -6.026746693249484e-16,
  -4.683009036403570e-18,   1.173596345060181e-18,   1.524643141921870e+00,  -2.988554384415477e-02,  -6.711377498108247e-04,   1.898436221651132e-05,   1.453240203245531e-06,
  -3.634893393907507e-09,  -2.923109794790328e-09,  -5.782214879976139e-11,   4.718807620312098e-12,   2.286141154937474e-13,  -4.590739671578188e-15,  -5.888602275345347e-16,
  -4.218042360293952e-18,   1.147487092721804e-18,   1.524512051014874e+00,  -2.987417843838440e-02,  -6.694337243580631e-04,   1.897556648213330e-05,   1.444713461853994e-06,
  -3.858638808555181e-09,  -2.897369692341475e-09,  -5.629730884232343e-11,   4.676622275417307e-12,   2.226341935923227e-13,  -4.627028783952818e-15,  -5.723037446889800e-16,
  -3.668354587670411e-18,   1.116065832878403e-18,   1.524384894298651e+00,  -2.986314703150637e-02,  -6.677826949247277e-04,   1.896689040116815e-05,   1.436460228187761e-06,
  -4.073857126386479e-09,  -2.872457403447903e-09,  -5.483043772952112e-11,   4.635579506953727e-12,   2.168859087529216e-13,  -4.660055662976826e-15,  -5.563855919387120e-16,
  -3.147708286296332e-18,   1.085723524599703e-18,   1.524282532986195e+00,  -2.985426166807889e-02,  -6.664549425150418e-04,   1.895980317172925e-05,   1.429828968115943e-06,
  -4.245815748096809e-09,  -2.852442725848180e-09,  -5.365830560640219e-11,   4.602454049994624e-12,   2.122957259069668e-13,  -4.685105979407181e-15,  -5.436725570010035e-16,
  -2.737467020346370e-18,   1.061397840710509e-18,   1.524214930892090e+00,  -2.984839106501964e-02,  -6.655787097508663e-04,   1.895507233096012e-05,   1.425455675395611e-06,
  -4.358751352364927e-09,  -2.839244012008567e-09,  -5.288844111172453e-11,   4.580536022096738e-12,   2.092823849232711e-13,  -4.700905872479126e-15,  -5.353259348396894e-16,
  -2.470837354545070e-18,   1.045382428584889e-18,   1.524180225244011e+00,  -2.984537644270772e-02,  -6.651290690795637e-04,   1.895262810167995e-05,   1.423212414426734e-06,
  -4.416535930018217e-09,  -2.832474080858300e-09,  -5.249451531533586e-11,   4.569271213475269e-12,   2.077409851741087e-13,  -4.708788894502084e-15,  -5.310561914981978e-16,
  -2.335276737545463e-18,   1.037176058046293e-18,   1.524168147417675e+00,  -2.984432720983185e-02,  -6.649726227050062e-04,   1.895177502632152e-05,   1.422432046024983e-06,
  -4.436614485563606e-09,  -2.830119056556214e-09,  -5.235763411673862e-11,   4.565349003269589e-12,   2.072054555189910e-13,  -4.711496045668309e-15,  -5.295727156660189e-16,
  -2.288310292786755e-18,   1.034322687972516e-18,   1.524166230918048e+00,  -2.984416071264163e-02,  -6.649477994389116e-04,   1.895163954405015e-05,   1.422308232199461e-06,
  -4.439799067768990e-09,  -2.829745408937827e-09,  -5.233592378483347e-11,   4.564726536902298e-12,   2.071205202886128e-13,  -4.711923898763585e-15,  -5.293374341099107e-16,
  -2.280867633187806e-18,   1.033870036996191e-18,   2.510564351044844e-02,  -9.014339483803252e-04,   2.393917536122550e-05,  -5.125865431941875e-07,   1.359276911571459e-08,
  -3.104961834851113e-10,  -4.488643256054428e-13,  -3.419155614074342e-14,   1.307317797709064e-14,   4.744934725312696e-17,  -1.932169257430010e-17,  -5.135862581953234e-19,
   2.560789603347151e-20,   1.539265436732196e-21,   2.510790315016957e-02,  -9.015791404408668e-04,   2.394682009517712e-05,  -5.128781848885693e-07,   1.359252276087083e-08,
  -3.105619999387800e-10,  -4.161164200050994e-13,  -3.408942777024618e-14,   1.299649507954209e-14,   4.516921321866390e-17,  -1.917034311653006e-17,  -5.038896680041712e-19,
   2.545721112563632e-20,   1.510276538797432e-21,   2.511189090269573e-02,  -9.018354009011978e-04,   2.396030932583252e-05,  -5.133928410064849e-07,   1.359212489278810e-08,
  -3.106779985587105e-10,  -3.584929651321048e-13,  -3.391521196121592e-14,   1.286169968496263e-14,   4.118496632842844e-17,  -1.890406179036637e-17,  -4.869454269360721e-19,
   2.518953922991704e-20,   1.459632747151722e-21,   2.511671392920822e-02,  -9.021453876702320e-04,   2.397662062031003e-05,  -5.140152534722088e-07,   1.359170645892644e-08,
  -3.108180405579393e-10,  -2.890873994906678e-13,  -3.371469244375809e-14,   1.269957614247772e-14,   3.643335173098223e-17,  -1.858340236467427e-17,  -4.667365148418063e-19,
   2.486290677112075e-20,   1.399253251167981e-21,   2.512139708031598e-02,  -9.024464367261149e-04,   2.399245532838077e-05,  -5.146195694404092e-07,   1.359136572280040e-08,
  -3.109537635877376e-10,  -2.219949614225921e-13,  -3.353056350929295e-14,   1.254310070584795e-14,   3.188927907156746e-17,  -1.827351240006515e-17,  -4.474089553356688e-19,
   2.454282375166444e-20,   1.341530407145025e-21,   2.512517051144440e-02,  -9.026890433914984e-04,   2.400521156319330e-05,  -5.151064620457005e-07,   1.359113802985387e-08,
  -3.110629430706490e-10,  -1.681499044279032e-13,  -3.338971405468615e-14,   1.241769739061519e-14,   2.827745224722050e-17,  -1.802487749027508e-17,  -4.320455558463381e-19,
   2.428289805186583e-20,   1.295663821777371e-21,   2.512766429253465e-02,  -9.028493954008933e-04,   2.401364065995422e-05,  -5.154282230879892e-07,   1.359101044405630e-08,
  -3.111350122143163e-10,  -1.326695373624701e-13,  -3.330028126811574e-14,   1.233515131041070e-14,   2.591455860157092e-17,  -1.786107963167879e-17,  -4.219941446612978e-19,
   2.411015932477259e-20,   1.265664380556181e-21,   2.512894508133518e-02,  -9.029317567723854e-04,   2.401796940657718e-05,  -5.155934723874977e-07,   1.359095198578057e-08,
  -3.111720005434084e-10,  -1.144793814493819e-13,  -3.325547291863452e-14,   1.229285820883190e-14,   2.470840538524867e-17,  -1.777711528191063e-17,  -4.168631756427691e-19,
   2.402115150958389e-20,   1.250353148362926e-21,   2.512939088957829e-02,  -9.029604254624297e-04,   2.401947606689536e-05,  -5.156509904488550e-07,   1.359093276245736e-08,
  -3.111848711109410e-10,  -1.081530151346959e-13,  -3.324005473282574e-14,   1.227815333777316e-14,   2.428975266979432e-17,  -1.774791522361792e-17,  -4.150822024371859e-19,
   2.399012460013330e-20,   1.245039004296735e-21,   2.512946163405989e-02,  -9.029649748865254e-04,   2.401971515315902e-05,  -5.156601178456369e-07,   1.359092976530531e-08,
  -3.111869133246506e-10,  -1.071493396870106e-13,  -3.323761650870760e-14,   1.227582061901306e-14,   2.422337325351202e-17,  -1.774328274044131e-17,  -4.147998192200465e-19,
   2.398519884038105e-20,   1.244196437454073e-21,   2.303407331854029e-01,  -8.075466569134632e-03,   1.971519672430384e-04,  -3.344766167090056e-06,   7.035814731543881e-08,
  -9.925817656669218e-10,  -6.672701345460439e-11,   1.161647130302966e-12,   1.062631706516545e-13,   1.067222449065742e-15,  -2.144877102595660e-16,  -5.589798238280859e-18,
   2.784473515285785e-19,   1.707627057467431e-20,   2.303592945565498e-01,  -8.076410486849716e-03,   1.971910329019573e-04,  -3.345677053005121e-06,   7.026737827446856e-08,
  -9.902488728106628e-10,  -6.646551308327923e-11,   1.164619309472275e-12,   1.054110199084146e-13,   1.042463425867612e-15,  -2.128367316908904e-16,  -5.482665008903731e-18,
   2.769294756731546e-19,   1.674642018739816e-20,   2.303920493058050e-01,  -8.078076249376880e-03,   1.972599240751145e-04,  -3.347282533834768e-06,   7.010750704549315e-08,
  -9.861279922308661e-10,  -6.600587837726409e-11,   1.169798755699250e-12,   1.039129848259498e-13,   9.992070721347975e-16,  -2.099314482782834e-16,  -5.295509491018070e-18,
   2.742271041541211e-19,   1.617023642737865e-20,   2.304316616717749e-01,  -8.080090856258097e-03,   1.973431585450042e-04,  -3.349220841247534e-06,   6.991468584685879e-08,
  -9.811374530770825e-10,  -6.545312172883471e-11,   1.175951738082742e-12,   1.021110714888447e-13,   9.476312008547219e-16,  -2.064318855190007e-16,  -5.072386000360347e-18,
   2.709194074295115e-19,   1.548340305488978e-20,   2.304701218763040e-01,  -8.082046966889378e-03,   1.974238884894594e-04,  -3.351099312356680e-06,   6.972801685414521e-08,
  -9.762849299511561e-10,  -6.491968674015689e-11,   1.181810695556638e-12,   1.003717572615080e-13,   8.983201633572312e-16,  -2.030488421722305e-16,  -4.859089370915430e-18,
   2.676678388189491e-19,   1.482691211399961e-20,   2.305011086447317e-01,  -8.083623045544542e-03,   1.974888715174359e-04,  -3.352610286552090e-06,   6.957800900272362e-08,
  -9.723702772203601e-10,  -6.449222361073249e-11,   1.186449436776255e-12,   9.897770180868715e-14,   8.591341855991739e-16,  -2.003337980048942e-16,  -4.689609681874409e-18,
   2.650203157408597e-19,   1.430535306741312e-20,   2.305215859738151e-01,  -8.084664618113047e-03,   1.975317857330809e-04,  -3.353607585597633e-06,   6.947906727953085e-08,
  -9.697808647110577e-10,  -6.421086973909125e-11,   1.189475178658528e-12,   9.806001079851544e-14,   8.335024954351917e-16,  -1.985448102895217e-16,  -4.578762482953966e-18,
   2.632574896287981e-19,   1.396426681452377e-20,   2.305321026261977e-01,  -8.085199554987349e-03,   1.975538163842258e-04,  -3.354119398053638e-06,   6.942831177651087e-08,
  -9.684502539780526e-10,  -6.406672252614326e-11,   1.191016899661019e-12,   9.758980605511268e-14,   8.204199308341847e-16,  -1.976276513953755e-16,  -4.522188538196577e-18,
   2.623481310357692e-19,   1.379019560590868e-20,   2.305357631331588e-01,  -8.085385750955401e-03,   1.975614831046709e-04,  -3.354297483598033e-06,   6.941065473386835e-08,
  -9.679869920862133e-10,  -6.401660507436044e-11,   1.191551582022962e-12,   9.742631775847501e-14,   8.158792101346683e-16,  -1.973086765727441e-16,  -4.502553244541219e-18,
   2.620309805032193e-19,   1.372978205925671e-20,   2.305363440094626e-01,  -8.085415297989770e-03,   1.975626996483151e-04,  -3.354325740687756e-06,   6.940785322551259e-08,
  -9.679134726115291e-10,  -6.400865470194091e-11,   1.191636337340495e-12,   9.740038252174425e-14,   8.151592665583186e-16,  -1.972580715740147e-16,  -4.499440039034827e-18,
   2.619806228401155e-19,   1.372020349025480e-20,   6.669708373802380e-01,  -2.176480365466571e-02,   3.883476072173642e-04,   5.440901156666077e-07,  -1.258832720766457e-07,
   4.026885149718927e-09,  -2.989176369842497e-10,  -4.820376682250852e-13,   7.056929237795101e-13,  -8.500595049640520e-16,  -1.008963795623160e-15,  -1.917257024070274e-17,
   1.164638128076062e-18,   8.405420503802380e-20,   6.670070981974993e-01,  -2.176463736497114e-02,   3.882745538772394e-04,   5.478565602649931e-07,  -1.262828226807256e-07,
   4.025854581299334e-09,  -2.971478835714215e-10,  -4.868967692519930e-13,   7.016569640291963e-13,  -9.293075343636456e-16,  -1.002055413934688e-15,  -1.865395796595010e-17,
   1.158402409749935e-18,   8.226540635143660e-20,   6.670710751503266e-01,  -2.176434308451551e-02,   3.881454722413896e-04,   5.545016988170206e-07,  -1.269858449401382e-07,
   4.024027404492338e-09,  -2.940336060617882e-10,  -4.956740960137134e-13,   6.945588764233553e-13,  -1.067063985927319e-15,  -9.898982873920173e-16,  -1.774904265189914e-17,
   1.147264075572352e-18,   7.914268546956627e-20,   6.671484268167472e-01,  -2.176398577176490e-02,   3.879890826791184e-04,   5.625356814581782e-07,  -1.278325585826198e-07,
   4.021802878619474e-09,  -2.902822139559866e-10,  -5.066307002807867e-13,   6.860156587462272e-13,  -1.230126030982380e-15,  -9.752541533041501e-16,  -1.667204035431592e-17,
   1.133570965023444e-18,   7.542361302189766e-20,   6.672235080468413e-01,  -2.176363736405990e-02,   3.878369462252707e-04,   5.703334707650086e-07,  -1.286509935905015e-07,
   4.019627283972048e-09,  -2.866554904390656e-10,  -5.176215268120227e-13,   6.777636964422661e-13,  -1.384779666982080e-15,  -9.610974724000241e-16,  -1.564437926484034e-17,
   1.120050622178619e-18,   7.187232497160856e-20,   6.672839850297340e-01,  -2.176335559187910e-02,   3.877141610866652e-04,   5.766142163088110e-07,  -1.293077837059018e-07,
   4.017862957030075e-09,  -2.837446112709989e-10,  -5.267261147761600e-13,   6.711457898882141e-13,  -1.506780944035552e-15,  -9.497361003770523e-16,  -1.482919645958239e-17,
   1.109001365156412e-18,   6.905344984719238e-20,   6.673239434773833e-01,  -2.176316886356418e-02,   3.876329164245276e-04,   5.807639040530504e-07,  -1.297405422875033e-07,
   4.016691319698202e-09,  -2.818264113237356e-10,  -5.328635758412599e-13,   6.667873406503942e-13,  -1.586141371774657e-15,  -9.422499402003982e-16,  -1.429670255064393e-17,
   1.101625282419544e-18,   6.721120294383930e-20,   6.673444629180205e-01,  -2.176307280318317e-02,   3.875911592986428e-04,   5.828948069671172e-07,  -1.299624025912663e-07,
   4.016087817867424e-09,  -2.808429470779789e-10,  -5.360526860787883e-13,   6.645535605160178e-13,  -1.626510526432695e-15,  -9.384120355000400e-16,  -1.402513768821968e-17,
   1.097814593247638e-18,   6.627140346148175e-20,   6.673516047166261e-01,  -2.176303934198868e-02,   3.875766199232820e-04,   5.836364616848604e-07,  -1.300395623419900e-07,
   4.015877473971553e-09,  -2.805009015257375e-10,  -5.371685868075692e-13,   6.637767874742245e-13,  -1.640500084857017e-15,  -9.370772705213583e-16,  -1.393091803395948e-17,
   1.096484671521885e-18,   6.594529504270760e-20,   6.673527380131307e-01,  -2.176303403089997e-02,   3.875743124671798e-04,   5.837541508603804e-07,  -1.300518036482089e-07,
   4.015844081517678e-09,  -2.804466358595090e-10,  -5.373459445452338e-13,   6.636535582030570e-13,  -1.642717129077666e-15,  -9.368655117404772e-16,  -1.391598094291083e-17,
   1.096273462283987e-18,   6.589359342151613e-20,   1.396404553427850e+00,  -3.400840389247542e-02,  -3.201554622859458e-04,   3.785418484087547e-05,   6.662366145587112e-07,
  -7.175616924217641e-08,  -1.744024385940629e-09,   1.476380987753713e-10,   4.755132316732129e-12,  -3.036563820184458e-13,  -1.282914178023012e-14,   6.059042711839309e-16,
   3.378022877372132e-17,  -1.147525407516546e-18,   1.396375264811029e+00,  -3.399798576821880e-02,  -3.197937179913163e-04,   3.778921682313256e-05,   6.639185727095197e-07,
  -7.148048834978885e-08,  -1.732525528861142e-09,   1.466861663403429e-10,   4.706700565509512e-12,  -3.008170605305000e-13,  -1.264793059783157e-14,   5.984410031117248e-16,
   3.316162282540063e-17,  -1.130339772752614e-18,   1.396323610637523e+00,  -3.397961728426368e-02,  -3.191564434261715e-04,   3.767478529916022e-05,   6.598411180156399e-07,
  -7.099553333009435e-08,  -1.712335593620755e-09,   1.450140511544039e-10,   4.621839636263555e-12,  -2.958373859895844e-13,  -1.233115170921667e-14,   5.853706985159258e-16,
   3.208295660725653e-17,  -1.100270533441000e-18,   1.396261194230902e+00,  -3.395743054212429e-02,  -3.183875947823131e-04,   3.753676322561657e-05,   6.549323083429613e-07,
  -7.041164998861620e-08,  -1.688091330958420e-09,   1.430049880128784e-10,   4.520237168615491e-12,  -2.898673863744285e-13,  -1.195312225936564e-14,   5.697333015174369e-16,
   3.080034296705465e-17,  -1.064343042966559e-18,   1.396200647868020e+00,  -3.393591778449886e-02,  -3.176430381086881e-04,   3.740313907308724e-05,   6.501895399810722e-07,
  -6.984746460444170e-08,  -1.664731968793517e-09,   1.410680372693520e-10,   4.422654697458946e-12,  -2.841253659562983e-13,  -1.159134338374512e-14,   5.547267423962078e-16,
   2.957765966086076e-17,  -1.029915180255973e-18,   1.396151905710594e+00,  -3.391860580706087e-02,  -3.170445394489316e-04,   3.729575424192023e-05,   6.463849661040232e-07,
  -6.939484736480701e-08,  -1.646039710300087e-09,   1.395172154135771e-10,   4.344790866216722e-12,  -2.795377908770158e-13,  -1.130359076360292e-14,   5.427613815415349e-16,
   2.860856892042617e-17,  -1.002500762753416e-18,   1.396119714001929e+00,  -3.390717536868984e-02,  -3.166497005141210e-04,   3.722492380140306e-05,   6.438788460757853e-07,
  -6.909668507795057e-08,  -1.633749460680706e-09,   1.384971209688441e-10,   4.293703336608489e-12,  -2.765249689074818e-13,  -1.111524130017943e-14,   5.349150988938391e-16,
   2.797590878891606e-17,  -9.845417255166182e-19,   1.396103187038066e+00,  -3.390130807506424e-02,  -3.164471289395378e-04,   3.718858836677355e-05,   6.425942630249476e-07,
  -6.894384810171209e-08,  -1.627456710718575e-09,   1.379746908622556e-10,   4.267579350477822e-12,  -2.749834612030337e-13,  -1.101906591074651e-14,   5.309042015385295e-16,
   2.765337102175193e-17,  -9.753669358572616e-19,   1.396097435475622e+00,  -3.389926635269710e-02,  -3.163766534020064e-04,   3.717594775108740e-05,   6.421475383942370e-07,
  -6.889069689061249e-08,  -1.625269461667398e-09,   1.377930827052692e-10,   4.258504427849171e-12,  -2.744478341690206e-13,  -1.098567863118359e-14,   5.295111173449223e-16,
   2.754148355113597e-17,  -9.721811971177004e-19,   1.396096522819783e+00,  -3.389894238049864e-02,  -3.163654713927578e-04,   3.717394215678726e-05,   6.420766676745495e-07,
  -6.888226466526018e-08,  -1.624922517680025e-09,   1.377642748283889e-10,   4.257065205292689e-12,  -2.743628806431643e-13,  -1.098038467528891e-14,   5.292901937558558e-16,
   2.752374631066076e-17,  -9.716760261818021e-19,   2.184857256334872e-02,  -7.313014908388261e-04,   1.888730539775387e-05,  -3.448792934670279e-07,   7.427179939593579e-09,
  -2.897938454666711e-10,   3.534596006130650e-12,   2.487385943350509e-13,   2.229115331665812e-16,  -6.336807266924621e-16,  -5.420125002949449e-19,   1.237810548754530e-18,
   7.711283865340413e-21,  -2.489147376691163e-21,   2.185035168849997e-02,  -7.313994306181620e-04,   1.889151127639902e-05,  -3.451471513688149e-07,   7.432157127718379e-09,
  -2.893354773358795e-10,   3.535162096927800e-12,   2.467481051620190e-13,   2.218196099883529e-16,  -6.279058301006069e-16,  -5.034749262596059e-19,   1.221854400752974e-18,
   7.505739466351921e-21,  -2.447305347747308e-21,   2.185349130678848e-02,  -7.315723074967144e-04,   1.889893489325033e-05,  -3.456194510233716e-07,   7.440940095787420e-09,
  -2.885297936154292e-10,   3.536159343960992e-12,   2.432512624782271e-13,   2.200172383216351e-16,  -6.177805761630237e-16,  -4.364517591132271e-19,   1.193937637666292e-18,
   7.148272190742776e-21,  -2.374271587006829e-21,   2.185728831928453e-02,  -7.317814553380581e-04,   1.890791549413158e-05,  -3.461899829663468e-07,   7.451561647314048e-09,
  -2.875608454529924e-10,   3.537362621971415e-12,   2.390489939903750e-13,   2.180475928969049e-16,  -6.056465636745003e-16,  -3.570551109235858e-19,   1.160583239474337e-18,
   6.724813674336032e-21,  -2.287304570296095e-21,   2.186097497203156e-02,  -7.319846005239132e-04,   1.891663777362514e-05,  -3.467432424078475e-07,   7.461874008971889e-09,
  -2.866257293192399e-10,   3.538528237042594e-12,   2.349967387063613e-13,   2.163523930228125e-16,  -5.939809505906297e-16,  -2.816825303613628e-19,   1.128621238081560e-18,
   6.322805661248456e-21,  -2.204271724124238e-21,   2.186394530631647e-02,  -7.321483290388908e-04,   1.892366724316827e-05,  -3.471885103266229e-07,   7.470182331961126e-09,
  -2.858763536332677e-10,   3.539465599457988e-12,   2.317517019304055e-13,   2.151402088360267e-16,  -5.846642834950424e-16,  -2.221691618202255e-19,   1.103169678572103e-18,
   6.005366025150384e-21,  -2.138368276868384e-21,   2.186590825342597e-02,  -7.322565558013404e-04,   1.892831361856200e-05,  -3.474825251292017e-07,   7.475672724336074e-09,
  -2.853831035575235e-10,   3.540084249533456e-12,   2.296168992789326e-13,   2.144135659896171e-16,  -5.785474172809505e-16,  -1.834280479444950e-19,   1.086495853180623e-18,
   5.798710813383343e-21,  -2.095298979225105e-21,   2.186691638351894e-02,  -7.323121471320899e-04,   1.893070019602092e-05,  -3.476334508811338e-07,   7.478492427354536e-09,
  -2.851303898035682e-10,   3.540401739433709e-12,   2.285234924823083e-13,   2.140632263555170e-16,  -5.754182547730861e-16,  -1.637120220157367e-19,   1.077977376992229e-18,
   5.693535437714939e-21,  -2.073327848062537e-21,   2.186726728243320e-02,  -7.323314980677137e-04,   1.893153093642972e-05,  -3.476859716471368e-07,   7.479473870521914e-09,
  -2.850425248826326e-10,   3.540512211388410e-12,   2.281433857441758e-13,   2.139449066708620e-16,  -5.743310494873521e-16,  -1.568781227237901e-19,   1.075019479885696e-18,
   5.657079053400592e-21,  -2.065703913114778e-21,   2.186732296573314e-02,  -7.323345688831685e-04,   1.893166276682736e-05,  -3.476943054794735e-07,   7.479629612971523e-09,
  -2.850285864097197e-10,   3.540529740208056e-12,   2.280830900279225e-13,   2.139263024860672e-16,  -5.741586164379260e-16,  -1.557950250389150e-19,   1.074550435975496e-18,
   5.651301075690841e-21,  -2.064495204899048e-21,   2.009635123935445e-01,  -6.641653614788930e-03,   1.628787632881815e-04,  -2.447071829828192e-06,   3.902609001170704e-08,
  -1.849170025863016e-09,   6.196300910197553e-12,   3.375529721371934e-12,  -1.637678776627645e-14,  -6.462683687489156e-15,  -6.001389101115970e-18,   1.360701661338433e-17,
   7.534464878807774e-20,  -2.803305095297043e-20,   2.009788264086707e-01,  -6.642347760986598e-03,   1.629007614376353e-04,  -2.448752527811276e-06,   3.903429182552676e-08,
  -1.842841982571569e-09,   6.153057678979191e-12,   3.355343099558545e-12,  -1.639070845914329e-14,  -6.399335813816938e-15,  -5.632317662545486e-18,   1.342796999028016e-17,
   7.316433011502065e-20,  -2.754919020942775e-20,   2.010058499117257e-01,  -6.643572968114629e-03,   1.629395811490931e-04,  -2.451713419171167e-06,   3.904871452990429e-08,
  -1.831707572919029e-09,   6.076731273138575e-12,   3.319892388114869e-12,  -1.641408865530591e-14,  -6.288282128517809e-15,  -4.991414159058498e-18,   1.311478875456502e-17,
   6.937568440018923e-20,  -2.670494432976921e-20,   2.010385298892415e-01,  -6.645055140770841e-03,   1.629865285340339e-04,  -2.455285717310812e-06,   3.906607015997545e-08,
  -1.818297292837949e-09,   5.984398922809294e-12,   3.277311667430124e-12,  -1.644036634789116e-14,  -6.155222690983695e-15,  -4.233843812110151e-18,   1.274073690260120e-17,
   6.489304385794247e-20,  -2.570016781131926e-20,   2.010702580502123e-01,  -6.646494676686425e-03,   1.630321106893271e-04,  -2.458745240030869e-06,   3.908283024468472e-08,
  -1.805334689654919e-09,   5.894726937429287e-12,   3.236273536472119e-12,  -1.646381786528295e-14,  -6.027326938483796e-15,  -3.516400613068024e-18,   1.238243588175791e-17,
   6.064311761817558e-20,  -2.474139786284449e-20,   2.010958199969461e-01,  -6.647654826336184e-03,   1.630688356858920e-04,  -2.461526180552853e-06,   3.909626855800473e-08,
  -1.794932050160607e-09,   5.822463053960134e-12,   3.203426437542051e-12,  -1.648125591096604e-14,  -5.925203230161540e-15,  -2.951158003348942e-18,   1.209721490441691e-17,
   5.729125775076582e-20,  -2.398081205357716e-20,   2.011127119301425e-01,  -6.648421666457190e-03,   1.630931051584981e-04,  -2.463360841595450e-06,   3.910511731280583e-08,
  -1.788077625235522e-09,   5.774700562229293e-12,   3.181825320050408e-12,  -1.649207491618038e-14,  -5.858163270401050e-15,  -2.583815332717396e-18,   1.191040795773611e-17,
   5.511114749653603e-20,  -2.348394457004483e-20,   2.011213870721114e-01,  -6.648815547832081e-03,   1.631055693882877e-04,  -2.464302121406331e-06,   3.910965197048425e-08,
  -1.784563552546010e-09,   5.750168709747104e-12,   3.170764069428651e-12,  -1.649741510367723e-14,  -5.823871020364322e-15,  -2.397057681644454e-18,   1.181498481192626e-17,
   5.400220935554692e-20,  -2.323053439801453e-20,   2.011244065866227e-01,  -6.648952653353989e-03,   1.631099077880450e-04,  -2.464629598270506e-06,   3.911122877099678e-08,
  -1.783341401740165e-09,   5.741629623141676e-12,   3.166919178437959e-12,  -1.649923959006833e-14,  -5.811956884810434e-15,  -2.332354636989407e-18,   1.178185303880692e-17,
   5.361792120138109e-20,  -2.314261100449899e-20,   2.011248857444543e-01,  -6.648974410658021e-03,   1.631105962375776e-04,  -2.464681557495611e-06,   3.911147891495191e-08,
  -1.783147508521498e-09,   5.740274561776492e-12,   3.166309288106188e-12,  -1.649952748977250e-14,  -5.810067299778545e-15,  -2.322101355104698e-18,   1.177659932900133e-17,
   5.355701993336934e-20,  -2.312867196487388e-20,   5.861232583808647e-01,  -1.866240473765451e-02,   3.842783637941362e-04,  -1.177462187196059e-06,  -1.061828644439831e-07,
  -1.079036704054979e-09,  -5.889720643676407e-11,   1.364920021300410e-11,  -2.225297176467577e-14,  -3.168721691921231e-14,   1.516436024357179e-16,   6.351759191900253e-17,
   2.896622428317727e-20,  -1.395434890839360e-19,   5.861591635504503e-01,  -1.866273867214294e-02,   3.842181653713272e-04,  -1.178262530374592e-06,  -1.062662039996857e-07,
  -1.053729503300636e-09,  -5.894252195938947e-11,   1.354979402334619e-11,  -2.161786593033610e-14,  -3.139308947098858e-14,   1.515411939819077e-16,   6.263821361678381e-17,
   2.257373714591736e-20,  -1.369053850590971e-19,   5.862225141434320e-01,  -1.866332805166341e-02,   3.841119060793855e-04,  -1.179655935337505e-06,  -1.064133046207042e-07,
  -1.009230004694193e-09,  -5.902113003792140e-11,   1.337517323440379e-11,  -2.049780078630809e-14,  -3.087764273912812e-14,   1.513307203002728e-16,   6.110145512409792e-17,
   1.151302236366630e-20,  -1.323078235322679e-19,   5.862991104376050e-01,  -1.866404098327717e-02,   3.839833510139854e-04,  -1.181308856717182e-06,  -1.065912587735928e-07,
  -9.556849611785466e-10,  -5.911387980313860e-11,   1.316534848944307e-11,  -1.914447711126715e-14,  -3.026036323941039e-14,   1.510261723131000e-16,   5.926840158950158e-17,
  -1.493650203352692e-21,  -1.268452203110225e-19,   5.863734604980778e-01,  -1.866473334064953e-02,   3.838584836951705e-04,  -1.182880076226719e-06,  -1.067640944534183e-07,
  -9.039799881966761e-10,  -5.920150843158065e-11,   1.296303728769703e-11,  -1.783189960071308e-14,  -2.966735372705087e-14,   1.506790332476225e-16,   5.751502020823447e-17,
  -1.374146518889158e-20,  -1.216422426377118e-19,   5.864333499940400e-01,  -1.866529127543486e-02,   3.837578432688090e-04,  -1.184121964469019e-06,  -1.069033856226987e-07,
  -8.625238725932939e-10,  -5.927037433376565e-11,   1.280104316981833e-11,  -1.677542665581568e-14,  -2.919406320364429e-14,   1.503631269581126e-16,   5.612103089858952e-17,
  -2.334129499522147e-20,  -1.175215074711951e-19,   5.864729209941002e-01,  -1.866566003625697e-02,   3.836913179020840e-04,  -1.184930925345724e-06,  -1.069954542685605e-07,
  -8.352264371256488e-10,  -5.931503475873268e-11,   1.269448037982060e-11,  -1.607780317577462e-14,  -2.888347560316836e-14,   1.501368840699384e-16,   5.520889165059303e-17,
  -2.955586229236333e-20,  -1.148328439311890e-19,   5.864932416953224e-01,  -1.866584943941390e-02,   3.836571465305664e-04,  -1.185342766581668e-06,  -1.070427443535781e-07,
  -8.212375311973697e-10,  -5.933770881649182e-11,   1.263990325161439e-11,  -1.571969198295750e-14,  -2.872463712044734e-14,   1.500153399084494e-16,   5.474322599114507e-17,
  -3.270788418034634e-20,  -1.134625968394581e-19,   5.865003143580657e-01,  -1.866591536716936e-02,   3.836452516916027e-04,  -1.185485539288706e-06,  -1.070592054355540e-07,
  -8.163732763627482e-10,  -5.934555915414297e-11,   1.262093069456448e-11,  -1.559507271378042e-14,  -2.866945722160177e-14,   1.499721871635174e-16,   5.458158492774400e-17,
  -3.379872697747736e-20,  -1.129873359368612e-19,   5.865014366854283e-01,  -1.866592582919765e-02,   3.836433640884491e-04,  -1.185508168187909e-06,  -1.070618176457791e-07,
  -8.156016096904748e-10,  -5.934680292105134e-11,   1.261792112637455e-11,  -1.557529852922152e-14,  -2.866070592442998e-14,   1.499652992468177e-16,   5.455595548655419e-17,
  -3.397153281447246e-20,  -1.129119975311912e-19,   1.258228186942901e+00,  -3.468756202087549e-02,   1.475842148140562e-04,   3.632227324540526e-05,  -8.142709942356407e-07,
  -5.881017154599680e-08,   2.560276707453011e-09,   9.404408957999035e-11,  -6.945546426185270e-12,  -1.261964498126837e-13,   1.737372002672707e-14,   8.494818642801123e-17,
  -4.097247040719247e-17,   2.666851165796864e-19,   1.258241142234338e+00,  -3.467753501280699e-02,   1.471452904957204e-04,   3.626863406457386e-05,  -8.108682296287901e-07,
  -5.863156391602976e-08,   2.543392303310728e-09,   9.363101091254482e-11,  -6.879280959624663e-12,  -1.257108597409296e-13,   1.715048258620279e-14,   8.626514638431528e-17,
  -4.030145533261269e-17,   2.546189474039032e-19,   1.258263970826093e+00,  -3.465985420646599e-02,   1.463723119545608e-04,   3.617412101324434e-05,  -8.048827801131953e-07,
  -5.831706270590272e-08,   2.513736739576655e-09,   9.290349229826412e-11,  -6.763094094358810e-12,  -1.248491284234626e-13,   1.675981910001745e-14,   8.852271622758860e-17,
  -3.912958231994256e-17,   2.337427710395697e-19,   1.258291522234873e+00,  -3.463849483926199e-02,   1.454401875954952e-04,   3.606006318128159e-05,  -7.976770311006451e-07,
  -5.793787938495201e-08,   2.478109853841525e-09,   9.202610526164664e-11,  -6.623853333852315e-12,  -1.237989405262673e-13,   1.629291260325364e-14,   9.114128386511631e-17,
  -3.773306308292043e-17,   2.091959192069520e-19,   1.258318213078613e+00,  -3.461778092716752e-02,   1.445379809870794e-04,   3.594957651694959e-05,  -7.907151084089868e-07,
  -5.757094034815792e-08,   2.443766480872781e-09,   9.117681023943000e-11,  -6.489984183838755e-12,  -1.227711067837318e-13,   1.584534314930564e-14,   9.356881554332388e-17,
  -3.639860425078161e-17,   1.860829160512401e-19,   1.258339675110906e+00,  -3.460110937780641e-02,   1.438130927749542e-04,   3.586074062431105e-05,  -7.851304353700852e-07,
  -5.727617278032608e-08,   2.416272781657933e-09,   9.049439708848395e-11,  -6.383068192182745e-12,  -1.219372889647736e-13,   1.548883153141558e-14,   9.544376058385084e-17,
  -3.533865012715628e-17,   1.679677728036062e-19,   1.258353837395462e+00,  -3.459010060320392e-02,   1.433350364685192e-04,   3.580212291918244e-05,  -7.814517794897187e-07,
  -5.708180329084893e-08,   2.398189701582748e-09,   9.004433914899309e-11,  -6.312871366679734e-12,  -1.213835368648341e-13,   1.525522081640313e-14,   9.664377120735573e-17,
  -3.464556416062812e-17,   1.562409489220476e-19,   1.258361104398422e+00,  -3.458444938492221e-02,   1.430898209941546e-04,   3.577204571068889e-05,  -7.795661920316189e-07,
  -5.698211121398438e-08,   2.388929154692661e-09,   8.981348207140358e-11,  -6.276960961714877e-12,  -1.210983123565149e-13,   1.513585540949133e-14,   9.724811723251976e-17,
  -3.429187911959315e-17,   1.502931541325777e-19,   1.258363632789387e+00,  -3.458248279493500e-02,   1.430045175230484e-04,   3.576158116597392e-05,  -7.789104650175511e-07,
  -5.694743251548015e-08,   2.385710065462542e-09,   8.973317306388582e-11,  -6.264484099239367e-12,  -1.209989038134291e-13,   1.509440521062564e-14,   9.745657878998089e-17,
  -3.416913242643870e-17,   1.482347610206540e-19,   1.258364033964839e+00,  -3.458217074166938e-02,   1.429909832209588e-04,   3.575992078159040e-05,  -7.788064371676898e-07,
  -5.694193043486611e-08,   2.385199436205253e-09,   8.972043116870957e-11,  -6.262505240335049e-12,  -1.209831227311285e-13,   1.508783218800853e-14,   9.748956941753535e-17,
  -3.414967112218425e-17,   1.479086807929589e-19,   1.920167503944535e-02,  -5.951366735378960e-04,   1.529138067319549e-05,  -2.656710973038988e-07,   2.966040496984791e-09,
  -1.393213315123593e-10,   7.709666056179147e-12,  -1.842929180278525e-14,  -1.205356292544678e-14,   1.266780744655109e-16,   2.396660092466702e-17,  -5.608004269779273e-19,
  -4.165445219835617e-20,   1.618334990756141e-21,   1.920311207264834e-02,  -5.952118543903461e-04,   1.529310811097253e-05,  -2.658019630380741e-07,   2.976533566306270e-09,
  -1.393519709721543e-10,   7.679938041567767e-12,  -1.806573451546765e-14,  -1.195988125680003e-14,   1.241672508883621e-16,   2.373205274667377e-17,  -5.507443480273584e-19,
  -4.114498623934442e-20,   1.585058428860509e-21,   1.920564787900277e-02,  -5.953445421543923e-04,   1.529616091972804e-05,  -2.660328993567486e-07,   2.995015508049131e-09,
  -1.394054837076479e-10,   7.627677975675345e-12,  -1.743084759948474e-14,  -1.179536283521738e-14,   1.197772468896336e-16,   2.332068320661988e-17,  -5.331882528873066e-19,
  -4.025224451794518e-20,   1.527077546818270e-21,   1.920871443980104e-02,  -5.955050407158651e-04,   1.529986044251722e-05,  -2.663121867017454e-07,   3.017307535517383e-09,
  -1.394692592801020e-10,   7.564816735205789e-12,  -1.667434199215047e-14,  -1.159775703316609e-14,   1.145371400884674e-16,   2.282748280847403e-17,  -5.122769166472909e-19,
  -3.918328607640934e-20,   1.458208284441641e-21,   1.921169165206677e-02,  -5.956609034557340e-04,   1.530346027526205e-05,  -2.665833520892625e-07,   3.038889239142665e-09,
  -1.395302038162736e-10,   7.504138564280400e-12,  -1.595158110593723e-14,  -1.140731188661793e-14,   1.095210277820067e-16,   2.235309728432038e-17,  -4.923055573499601e-19,
  -3.815654902609539e-20,   1.392634785098335e-21,   1.921409023354077e-02,  -5.957865027977500e-04,   1.530636626326020e-05,  -2.668018264329763e-07,   3.056233032218742e-09,
  -1.395786128548166e-10,   7.455504230815965e-12,  -1.537760997588346e-14,  -1.125488049532019e-14,   1.055304420949798e-16,   2.197407569154431e-17,  -4.764500566475465e-19,
  -3.733725229761411e-20,   1.340717554428564e-21,   1.921567526068260e-02,  -5.958695153816222e-04,   1.530828942714770e-05,  -2.669462035270011e-07,   3.067672919643970e-09,
  -1.396102667817543e-10,   7.423488166332911e-12,  -1.500236573717323e-14,  -1.115463859371699e-14,   1.029179901688774e-16,   2.172515345044706e-17,  -4.660861624223574e-19,
  -3.679969107932812e-20,   1.306851416818787e-21,   1.921648927495624e-02,  -5.959121521223656e-04,   1.530927797189402e-05,  -2.670203521159888e-07,   3.073541495522156e-09,
  -1.396264198586255e-10,   7.407083607246923e-12,  -1.481089925482584e-14,  -1.110330821862708e-14,   1.015838948161417e-16,   2.159779105132138e-17,  -4.607985784943254e-19,
  -3.652480381256326e-20,   1.289594565587232e-21,   1.921677260437802e-02,  -5.959269931549259e-04,   1.530962218844270e-05,  -2.670461608532477e-07,   3.075583096605236e-09,
  -1.396320257776934e-10,   7.401379768363697e-12,  -1.474445440918041e-14,  -1.108546583580225e-14,   1.011207449902471e-16,   2.155353625557660e-17,  -4.589637029120678e-19,
  -3.642931368452388e-20,   1.283609569460081e-21,   1.921681756505931e-02,  -5.959293482662879e-04,   1.530967681772669e-05,  -2.670502563748397e-07,   3.075907022628907e-09,
  -1.396329145866406e-10,   7.400474928486300e-12,  -1.473391986081383e-14,  -1.108263561611156e-14,   1.010473061170640e-16,   2.154651717963161e-17,  -4.586727949216536e-19,
  -3.641416958230478e-20,   1.282660847578878e-21,   1.768285059457549e-01,  -5.448079892630033e-03,   1.361457442923468e-04,  -2.081921222610070e-06,   1.004988456355299e-08,
  -8.149764533451673e-10,   6.427813983127973e-11,   1.145548964592647e-13,  -1.349459077896929e-13,   1.709961078220996e-15,   2.508504997339193e-16,  -6.516972381328068e-18,
  -4.421731190376340e-19,   1.898763814845415e-20,   1.768412819188140e-01,  -5.448668113113205e-03,   1.361518833274570e-04,  -2.082682631396906e-06,   1.013635345504953e-08,
  -8.146725584843688e-10,   6.394389759658294e-11,   1.195834948180027e-13,  -1.339665426924220e-13,   1.680816671629078e-15,   2.483588997109176e-16,  -6.399192123705430e-18,
  -4.368083802396141e-19,   1.859316692399285e-20,   1.768638258495303e-01,  -5.449706211039876e-03,   1.361627543823592e-04,  -2.084025894055260e-06,   1.028855480860076e-08,
  -8.141286402247892e-10,   6.335616477454381e-11,   1.283797715658277e-13,  -1.322467713836547e-13,   1.629863662958859e-15,   2.439887259104444e-16,  -6.193594084476941e-18,
  -4.274051729000318e-19,   1.790597209644770e-20,   1.768910871089052e-01,  -5.450961786152404e-03,   1.361759655328049e-04,  -2.085649742778049e-06,   1.047196155454437e-08,
  -8.134578961766623e-10,   6.264894324452599e-11,   1.388862974939593e-13,  -1.301813546104895e-13,   1.569050615776798e-15,   2.387488834458758e-16,  -5.948745240836460e-18,
  -4.161416521649029e-19,   1.708994581881343e-20,   1.769175528098173e-01,  -5.452180986654916e-03,   1.361888594012535e-04,  -2.087225682602784e-06,   1.064934483874131e-08,
  -8.127932056965645e-10,   6.196600469104617e-11,   1.489507845334459e-13,  -1.281910232476047e-13,   1.510844111994145e-15,   2.337085861548002e-16,  -5.714946166613715e-18,
  -4.053186779934848e-19,   1.631319763213582e-20,   1.769388739110572e-01,  -5.453163380737414e-03,   1.361992956638149e-04,  -2.088494903076135e-06,   1.079176757454900e-08,
  -8.122481081921606e-10,   6.141842120173780e-11,   1.569625969996403e-13,  -1.265981447168282e-13,   1.464542715536722e-15,   2.296812785025059e-16,  -5.529361288689066e-18,
  -3.966793154522559e-19,   1.569837557305369e-20,   1.769529628469685e-01,  -5.453812637932790e-03,   1.362062157742481e-04,  -2.089333415394343e-06,   1.088564600711744e-08,
  -8.118832307798369e-10,   6.105784815461062e-11,   1.622099600629448e-13,  -1.255507214141264e-13,   1.434233763307593e-15,   2.270362300758531e-16,  -5.408069442197506e-18,
  -3.910093449606553e-19,   1.529739952393330e-20,   1.769601982925176e-01,  -5.454146096177045e-03,   1.362097769998646e-04,  -2.089763979975454e-06,   1.093378545417213e-08,
  -8.116944055547687e-10,   6.087306550780673e-11,   1.648903550237851e-13,  -1.250143989591492e-13,   1.418756703798064e-15,   2.256828414606188e-16,  -5.346191864705818e-18,
  -3.881095002969394e-19,   1.509310216779549e-20,   1.769627166719842e-01,  -5.454262164722886e-03,   1.362110176971958e-04,  -2.089913833677792e-06,   1.095052943824739e-08,
  -8.116284539935144e-10,   6.080881204206336e-11,   1.658210079872636e-13,  -1.248279780682096e-13,   1.413383745724520e-15,   2.252125719815153e-16,  -5.324720101236035e-18,
  -3.871020834066673e-19,   1.502225191460936e-20,   1.769631163048999e-01,  -5.454280583456574e-03,   1.362112146347845e-04,  -2.089937613004685e-06,   1.095318593735057e-08,
  -8.116179775186679e-10,   6.079861883543610e-11,   1.659685815285895e-13,  -1.247984075501411e-13,   1.412531793840731e-15,   2.251379841578435e-16,  -5.321315923138868e-18,
  -3.869423103898824e-19,   1.501102114896219e-20,   5.174897703900870e-01,  -1.567512050327401e-02,   3.593191353373171e-04,  -3.009439516239669e-06,  -1.152805297421255e-07,
   1.122244081049246e-09,   1.777211447415851e-10,   3.845506204833752e-13,  -5.438408745471614e-13,   9.219717612400936e-15,   1.066633896012640e-15,  -3.745816812963490e-17,
  -1.737558845229519e-18,   1.063277600518852e-19,   5.175233289845982e-01,  -1.567596316184071e-02,   3.592556036111188e-04,  -3.008377141357374e-06,  -1.150463496893741e-07,
   1.123418537435334e-09,   1.763790829940062e-10,   4.113791829964764e-13,  -5.396545563358386e-13,   9.051529118062088e-15,   1.056749119772121e-15,  -3.679891401700136e-17,
  -1.718645666722236e-18,   1.041123465071527e-19,   5.175825389639144e-01,  -1.567744980129731e-02,   3.591436043130237e-04,  -3.006501544002317e-06,  -1.146346364019036e-07,
   1.125531758404817e-09,   1.740197401385888e-10,   4.582750492422260e-13,  -5.323008802344934e-13,   8.757403731071373e-15,   1.039400782674146e-15,  -3.564814944337842e-17,
  -1.685420062443670e-18,   1.002535471125416e-19,   5.176541283137934e-01,  -1.567924704394445e-02,   3.590083494688254e-04,  -3.004231791922880e-06,  -1.141393410735995e-07,
   1.128156310221305e-09,   1.711816628817631e-10,   5.142305664230601e-13,  -5.234650397647485e-13,   8.406220726108795e-15,   1.018581908921575e-15,  -3.427774754572628e-17,
  -1.645495389280471e-18,   9.567234016822399e-20,   5.177236176547337e-01,  -1.568099133836914e-02,   3.588772300301089e-04,  -3.002026487417120e-06,  -1.136611816287602e-07,
   1.130776069986554e-09,   1.684420127614699e-10,   5.677704167574282e-13,  -5.149460424111864e-13,   8.069941987938042e-15,   9.985370673982452e-16,  -3.296924575150693e-17,
  -1.607002960440746e-18,   9.131271261770991e-20,   5.177795913779821e-01,  -1.568239620553924e-02,   3.587717330711601e-04,  -3.000248566001965e-06,  -1.132778858198038e-07,
   1.132937603662153e-09,   1.662460537193224e-10,   6.103462790617282e-13,  -5.081251011006863e-13,   7.802336474565392e-15,   9.825075038103882e-16,  -3.193062167252651e-17,
  -1.576185573141029e-18,   8.786269308648496e-20,   5.178165748879219e-01,  -1.568332436305383e-02,   3.587020866124702e-04,  -2.999073075646530e-06,  -1.130255402223127e-07,
   1.134390752613114e-09,   1.648004048686084e-10,   6.382095596987759e-13,  -5.036383582373670e-13,   7.627109076956169e-15,   9.719731874302277e-16,  -3.125183058866709e-17,
  -1.555916278661740e-18,   8.561303094980555e-20,   5.178355667843414e-01,  -1.568380096880451e-02,   3.586663395971830e-04,  -2.998469195882039e-06,  -1.128962356076828e-07,
   1.135144662173629e-09,   1.640596619083473e-10,   6.524355250136794e-13,  -5.013404975484251e-13,   7.537614096540988e-15,   9.665811261635604e-16,  -3.090554757021964e-17,
  -1.545536281632456e-18,   8.446694563956152e-20,   5.178421769436835e-01,  -1.568396684823025e-02,   3.586539006660323e-04,  -2.998258976555038e-06,  -1.128512755852891e-07,
   1.135408281699455e-09,   1.638021045853385e-10,   6.573737953746196e-13,  -5.005417070161173e-13,   7.506542750458759e-15,   9.647072023073077e-16,  -3.078538682398933e-17,
  -1.541928094569906e-18,   8.406950247072667e-20,   5.178432258780928e-01,  -1.568399317065117e-02,   3.586519269282053e-04,  -2.998225616052545e-06,  -1.128441432143508e-07,
   1.135450172074884e-09,   1.637612463614532e-10,   6.581568045382333e-13,  -5.004149974469852e-13,   7.501615863539271e-15,   9.644099707920030e-16,  -3.076633632801773e-17,
  -1.541355746653114e-18,   8.400650301099612e-20,   1.124199744321911e+00,  -3.205004012787904e-02,   4.786134699515408e-04,   1.765732504218435e-05,  -1.293923689030198e-06,
   9.344249302729601e-09,   2.253659042413559e-09,  -8.762452639948454e-11,  -2.104785981288665e-12,   2.467228963574179e-13,  -2.621850135429148e-15,  -4.537947250801755e-16,
   1.845691257102447e-17,   4.618615053871614e-19,   1.124243188647504e+00,  -3.204504814752025e-02,   4.779031107155988e-04,   1.766474942845454e-05,  -1.290821909441065e-06,
   9.183952103422219e-09,   2.247976924744705e-09,  -8.684876152512227e-11,  -2.112823895105933e-12,   2.445185602212684e-13,  -2.525166500288827e-15,  -4.503230595363198e-16,
   1.806897936486752e-17,   4.639448978414577e-19,   1.124319794769461e+00,  -3.203623824958447e-02,   4.766510731641443e-04,   1.767773141274866e-05,  -1.285355324788021e-06,
   8.902319062073170e-09,   2.237935373014860e-09,  -8.548586068729543e-11,  -2.126690405917520e-12,   2.406436066738397e-13,  -2.356443450131804e-15,  -4.441883506107639e-16,
   1.739126815742546e-17,   4.673581296685228e-19,   1.124412338990442e+00,  -3.202558273779865e-02,   4.751394852766475e-04,   1.769322799806528e-05,  -1.278756258568960e-06,
   8.563828723982939e-09,   2.225767269060082e-09,  -8.384794152129435e-11,  -2.142922557817720e-12,   2.359829408854172e-13,  -2.155598730282908e-15,  -4.367560357075770e-16,
   1.658330044290407e-17,   4.710443894385984e-19,   1.124502086500991e+00,  -3.201523596715781e-02,   4.736745613208628e-04,   1.770806173137617e-05,  -1.272361727202922e-06,
   8.237380680428384e-09,   2.213928284416990e-09,  -8.226843515964469e-11,  -2.158125264673049e-12,   2.314846192147219e-13,  -1.963919844038754e-15,  -4.295273266727381e-16,
   1.581091978064407e-17,   4.741702825205815e-19,   1.124574319488322e+00,  -3.200689890734981e-02,   4.724962265752533e-04,   1.771986162399796e-05,  -1.267218788360551e-06,
   7.975934887761140e-09,   2.204372434338051e-09,  -8.100354474678796e-11,  -2.169978405621625e-12,   2.278795977882443e-13,  -1.811848114069097e-15,  -4.236951573421364e-16,
   1.519721949019856e-17,   4.763705445838342e-19,   1.124622017254242e+00,  -3.200138903413605e-02,   4.717184791256328e-04,   1.772758557664556e-05,  -1.263824548730845e-06,
   7.803926157190715e-09,   2.198049191384681e-09,  -8.017140914240399e-11,  -2.177619391748833e-12,   2.255066591254098e-13,  -1.712500436557324e-15,  -4.198374024343503e-16,
   1.479584270890572e-17,   4.776713405259542e-19,   1.124646502292152e+00,  -3.199855917589721e-02,   4.713193390864802e-04,   1.773152960368513e-05,  -1.262082720062730e-06,
   7.715822891423177e-09,   2.194799182684196e-09,  -7.974520407659676e-11,  -2.181484550394920e-12,   2.242908865010697e-13,  -1.661831028620297e-15,  -4.178551105222716e-16,
   1.459099301861155e-17,   4.782925561766937e-19,   1.124655022934788e+00,  -3.199757417420796e-02,   4.711804577886987e-04,   1.773289876592199e-05,  -1.261476663821370e-06,
   7.685194545796401e-09,   2.193667557225421e-09,  -7.959704022377126e-11,  -2.182820513658233e-12,   2.238681787228158e-13,  -1.644250702600146e-15,  -4.171649791809763e-16,
   1.451989593609798e-17,   4.785013724576566e-19,   1.124656374967524e+00,  -3.199741786593745e-02,   4.711584212827890e-04,   1.773311586265043e-05,  -1.261380500689542e-06,
   7.680335995430131e-09,   2.193487963489215e-09,  -7.957353723655755e-11,  -2.183032069784082e-12,   2.238011223282752e-13,  -1.641463584568185e-15,  -4.170554565967028e-16,
   1.450862342251420e-17,   4.785341582230921e-19,   1.704653702750623e-02,  -4.849012334384093e-04,   1.232653904040091e-05,  -2.313057697469227e-07,   1.799656653222419e-09,
   5.122160136791728e-12,   3.407004931453336e-12,  -2.153244703749286e-13,   1.037593291346422e-15,   3.525276147952628e-16,  -1.076390613956836e-17,  -3.913356439900612e-19,
   3.063208068660124e-20,  -6.295543039535060e-23,   1.704769472563458e-02,  -4.849662838361351e-04,   1.232757852018026e-05,  -2.313043631540884e-07,   1.804469131264335e-09,
   4.716217489531291e-12,   3.408917444972082e-12,  -2.141869543686070e-13,   9.975416696236989e-16,   3.505205910545093e-16,  -1.059420707115896e-17,  -3.911541382528012e-19,
   3.019687614627338e-20,  -5.078644606428922e-23,   1.704973758470154e-02,  -4.850810665501287e-04,   1.232941490402535e-05,  -2.313021851100530e-07,   1.812962698721011e-09,
   4.001720273277720e-12,   3.412209828382661e-12,  -2.121852863276462e-13,   9.274347749087529e-16,   3.469805591567690e-16,  -1.029690586780097e-17,  -3.907665156894487e-19,
   2.943382591282358e-20,  -2.968829443836397e-23,   1.705220797250957e-02,  -4.852198635302290e-04,   1.233163923988344e-05,  -2.313000686665544e-07,   1.823236344697824e-09,
   3.140797165043929e-12,   3.416051533005638e-12,  -2.097742171636667e-13,   8.436188978721053e-16,   3.427024757151638e-16,  -9.941030535656072e-18,  -3.901844315600764e-19,
   2.851943370380018e-20,  -4.807739524325268e-24,   1.705460632982073e-02,  -4.853546058139598e-04,   1.233380252558229e-05,  -2.312985545642049e-07,   1.833213024567250e-09,
   2.308218945241933e-12,   3.419635958022037e-12,  -2.074433998240699e-13,   7.632489574729217e-16,   3.385523027503611e-16,  -9.599327143897015e-18,  -3.895025059028969e-19,
   2.764042446488871e-20,   1.869276420593279e-23,   1.705653852113337e-02,  -4.854631529009636e-04,   1.233554806305650e-05,  -2.312977212646232e-07,   1.841252346971507e-09,
   1.639785713333496e-12,   3.422420328035130e-12,  -2.055727469658032e-13,   6.992139592488652e-16,   3.352112305258482e-16,  -9.326744576548172e-18,  -3.888707395554702e-19,
   2.693850078451785e-20,   3.716228812365477e-23,   1.705781533060241e-02,  -4.855348791220424e-04,   1.233670286532687e-05,  -2.312973595134695e-07,   1.846565661887174e-09,
   1.199211575117136e-12,   3.424209952512644e-12,  -2.043400902764707e-13,   6.572466242386007e-16,   3.330046780813115e-16,  -9.147937560879775e-18,  -3.884134494563310e-19,
   2.647770902463247e-20,   4.914264161751840e-23,   1.705847104940825e-02,  -4.855717140462103e-04,   1.233729633904054e-05,  -2.312972320782809e-07,   1.849294630699326e-09,
   9.732999202252137e-13,   3.425113535475137e-12,  -2.037081248272750e-13,   6.358009701599195e-16,   3.318718830324002e-16,  -9.056515660719495e-18,  -3.881664020243573e-19,
   2.624200516450701e-20,   5.522634963684282e-23,   1.705869928089955e-02,  -4.855845347915713e-04,   1.233750297106180e-05,  -2.312971970049981e-07,   1.850244524982445e-09,
   8.947240629185705e-13,   3.425425577657933e-12,  -2.034883326275128e-13,   6.283535481201080e-16,   3.314776642998628e-16,  -9.024759643481492e-18,  -3.880784813369983e-19,
   2.616011497149238e-20,   5.733293411001763e-23,   1.705873549821532e-02,  -4.855865692678982e-04,   1.233753576394889e-05,  -2.312971918798563e-07,   1.850395262568734e-09,
   8.822577554721544e-13,   3.425474977869296e-12,  -2.034534626625587e-13,   6.271725480578669e-16,   3.314151101348353e-16,  -9.019723446957942e-18,  -3.880644379401149e-19,
   2.614712718221495e-20,   5.766670319721611e-23,   1.570591732803497e-01,  -4.456832801978958e-03,   1.118456451009268e-04,  -1.974123350680788e-06,   7.350022343751249e-09,
   3.859083751788426e-10,   2.570499901180519e-11,  -2.053918658028319e-12,   1.051485645067529e-14,   3.704419342851411e-15,  -1.226068757698708e-16,  -3.741697909287536e-18,
   3.351026740061990e-19,  -1.847404916713109e-21,   1.570696675056459e-01,  -4.457386869154183e-03,   1.118499847562176e-04,  -1.973793779409251e-06,   7.386372335696590e-09,
   3.820543833196478e-10,   2.572330796549796e-11,  -2.041923878912545e-12,   1.005640582224386e-14,   3.684964575883540e-15,  -1.207456589295605e-16,  -3.747072767289741e-18,
   3.304519824168623e-19,  -1.693616905260296e-21,   1.570881850868600e-01,  -4.458364459588662e-03,   1.118576588121427e-04,  -1.973215125179381e-06,   7.450529819246380e-09,
   3.752729024446444e-10,   2.575467111885836e-11,  -2.020812374385410e-12,   9.253661762728495e-15,   3.650621833831764e-15,  -1.174843734695531e-16,  -3.755701797996450e-18,
   3.222940886017411e-19,  -1.426697391691713e-21,   1.571105773510995e-01,  -4.459546453785363e-03,   1.118669667833201e-04,  -1.972520310270224e-06,   7.528138603510784e-09,
   3.671049132278634e-10,   2.579099627700683e-11,  -1.995375309367646e-12,   8.293492434985641e-15,   3.609071863039296e-15,  -1.135796058260672e-16,  -3.764695821058333e-18,
   3.125118312560175e-19,  -1.111435276194986e-21,   1.571323160105698e-01,  -4.460693789646296e-03,   1.118760325675728e-04,  -1.971850914748644e-06,   7.603509191139048e-09,
   3.592092676020712e-10,   2.582459641157818e-11,  -1.970776962359363e-12,   7.372323022600960e-15,   3.568715442911742e-15,  -1.098293581742260e-16,  -3.771941015181167e-18,
   3.031015655606607e-19,  -8.131442433765191e-22,   1.571498288491096e-01,  -4.461617980294095e-03,   1.118833571768354e-04,  -1.971315317246898e-06,   7.664247128729468e-09,
   3.528727290995226e-10,   2.585048012817003e-11,  -1.951029302719363e-12,   6.638036649063062e-15,   3.536192283950804e-15,  -1.068370282967734e-16,  -3.776728431451114e-18,
   2.955824777874378e-19,  -5.783392039206955e-22,   1.571614012450003e-01,  -4.462228625981802e-03,   1.118882075939126e-04,  -1.970963191889138e-06,   7.704391394411634e-09,
   3.486974315891054e-10,   2.586700703788475e-11,  -1.938013919689584e-12,   6.156631259587233e-15,   3.514696247854088e-15,  -1.048738012159952e-16,  -3.779384367466511e-18,
   2.906441871889044e-19,  -4.258480498645161e-22,   1.571673442934017e-01,  -4.462542208487246e-03,   1.118907017458967e-04,  -1.970782910852110e-06,   7.725010346765000e-09,
   3.465568532904210e-10,   2.587531675811596e-11,  -1.931340264504038e-12,   5.910577068135250e-15,   3.503655538354074e-15,  -1.038699227969007e-16,  -3.780592685828756e-18,
   2.881174699660373e-19,  -3.483547735075101e-22,   1.571694128368760e-01,  -4.462651351639778e-03,   1.118915703726972e-04,  -1.970720250227645e-06,   7.732187426936043e-09,
   3.458123839825407e-10,   2.587818081214382e-11,  -1.929019088169187e-12,   5.825121640890079e-15,   3.499812500472931e-15,  -1.035212023371623e-16,  -3.780988592175491e-18,
   2.872395080037986e-19,  -3.215122962184434e-22,   1.571697410867617e-01,  -4.462668671054822e-03,   1.118917082362265e-04,  -1.970710311018289e-06,   7.733326352691321e-09,
   3.456942744149090e-10,   2.587863395958268e-11,  -1.928650827806992e-12,   5.811569863668072e-15,   3.499202653262248e-15,  -1.034658978706883e-16,  -3.781050248730775e-18,
   2.871002580255042e-19,  -3.172589152226047e-22,   4.602694300375291e-01,  -1.297327040275470e-02,   3.135681423491927e-04,  -4.468264657128142e-06,  -5.740368216586146e-08,
   4.056517328557015e-09,   3.114422934603686e-11,  -7.338969188619462e-12,   8.209123002037818e-14,   1.380527371757790e-14,  -5.890020414289237e-16,  -1.031888818873814e-17,
   1.499518800997020e-18,  -2.447880405074016e-20,   4.602987627009514e-01,  -1.297451413334092e-02,   3.135361120275116e-04,  -4.464576459690061e-06,  -5.735793802920687e-08,
   4.042782126150790e-09,   3.131471159307148e-11,  -7.293903083965311e-12,   7.987329366961733e-14,   1.374738173742687e-14,  -5.805701915902597e-16,  -1.044698870189195e-17,
   1.481072621215869e-18,  -2.352307314790330e-20,   4.603505182378707e-01,  -1.297670789191845e-02,   3.134796153728904e-04,  -4.458078827533969e-06,  -5.727704424209348e-08,
   4.018617517402950e-09,   3.161095651634822e-11,  -7.214545348068467e-12,   7.598789144360412e-14,   1.364474399866817e-14,  -5.657834942560848e-16,  -1.066765168116286e-17,
   1.448645600163840e-18,  -2.185981462497570e-20,   4.604130974795001e-01,  -1.297935920545296e-02,   3.134113354699359e-04,  -4.450239261983737e-06,  -5.717892736686946e-08,
   3.989518929167090e-09,   3.196142097330322e-11,  -7.118862399007094e-12,   7.133746033033281e-14,   1.351981888979427e-14,  -5.480587345441330e-16,  -1.092541122152061e-17,
   1.409643755497251e-18,  -1.988773024969767e-20,   4.604738440251561e-01,  -1.298193158773001e-02,   3.133450887594719e-04,  -4.442646964192045e-06,  -5.708336825401447e-08,
   3.961397541964144e-09,   3.229357306361830e-11,  -7.026266480318814e-12,   6.687272762676672e-14,   1.339770978705858e-14,  -5.310141010322325e-16,  -1.116625982027906e-17,
   1.372003062543939e-18,  -1.801385532233285e-20,   4.605227775733127e-01,  -1.298400281571769e-02,   3.132917487109581e-04,  -4.436543726989445e-06,  -5.700616881431820e-08,
   3.938834163546817e-09,   3.255540250559265e-11,  -6.951881967825180e-12,   6.331150612003780e-14,   1.329875597279529e-14,  -5.173990293667026e-16,  -1.135364524675782e-17,
   1.341840715521184e-18,  -1.653308622399943e-20,   4.605551104830699e-01,  -1.298537093286027e-02,   3.132565160096152e-04,  -4.432517177766909e-06,  -5.695505117965194e-08,
   3.923969099450498e-09,   3.272561491473170e-11,  -6.902832907523713e-12,   6.097562382680284e-14,   1.323308825970332e-14,  -5.084590028270365e-16,  -1.147424826334421e-17,
   1.321989237852570e-18,  -1.556860794261988e-20,   4.605717145132968e-01,  -1.298607336781565e-02,   3.132384264955964e-04,  -4.430451316497248e-06,  -5.692876742914991e-08,
   3.916348899264824e-09,   3.281216434984752e-11,  -6.877675753543916e-12,   5.978137327231150e-14,   1.319927903068912e-14,  -5.038853321441090e-16,  -1.153519544917851e-17,
   1.311819208822921e-18,  -1.507760379049117e-20,   4.605774936238918e-01,  -1.298631783148634e-02,   3.132321309378108e-04,  -4.429732587049443e-06,  -5.691961399461136e-08,
   3.913698802033345e-09,   3.284215159187843e-11,  -6.868924657437111e-12,   5.936655159930015e-14,   1.318749787226792e-14,  -5.022962008963115e-16,  -1.155625196312191e-17,
   1.308283374578601e-18,  -1.490738796910688e-20,   4.605784106856305e-01,  -1.298635662330567e-02,   3.132311319509862e-04,  -4.429618549414200e-06,  -5.691816122733789e-08,
   3.913278371720031e-09,   3.284690365203606e-11,  -6.867536220364029e-12,   5.930076534884036e-14,   1.318562772358278e-14,  -5.020441594112786e-16,  -1.155958591467775e-17,
   1.307722473556084e-18,  -1.488040942768416e-20,   1.004539937983049e+00,  -2.769660195869178e-02,   5.795666096048046e-04,   5.096440593624405e-07,  -7.742642530414015e-07,
   3.319969592880199e-08,  -9.740930204603844e-11,  -5.589430374012903e-11,   2.511676244253114e-12,   8.450941683152093e-16,  -4.743828809969490e-15,   1.904280145208743e-16,
   1.295112586358402e-18,  -4.137750453513220e-19,   1.004593397317488e+00,  -2.769635243630547e-02,   5.791307620624666e-04,   5.398478083837938e-07,  -7.743286602493951e-07,
   3.309010290313398e-08,  -9.121949711031672e-11,  -5.586916846954548e-11,   2.492082136500832e-12,   1.716559365457449e-15,  -4.731457045486079e-15,   1.875639740989041e-16,
   1.392754412771647e-18,  -4.109372007918370e-19,   1.004687693915016e+00,  -2.769590540380758e-02,   5.783616896201495e-04,   5.930594260084596e-07,  -7.744353892192686e-07,
   3.289677529034301e-08,  -8.033903997655762e-11,  -5.582250628615706e-11,   2.457554178413012e-12,   3.242437285794820e-15,  -4.709162830992167e-15,   1.825280606744628e-16,
   1.562576738624639e-18,  -4.058646504487456e-19,   1.004801661695134e+00,  -2.769535335729667e-02,   5.774316996293063e-04,   6.572613574956887e-07,  -7.745526826517419e-07,
   3.266309090885477e-08,  -6.725305181561139e-11,  -5.576216413615751e-11,   2.415882349283273e-12,   5.067415783341286e-15,  -4.681421571551107e-15,   1.764690618248330e-16,
   1.763741263553737e-18,  -3.996220412202522e-19,   1.004912240298725e+00,  -2.769480542443316e-02,   5.765288638316788e-04,   7.194386911285700e-07,  -7.746542707896882e-07,
   3.243633094334054e-08,  -5.462342622491265e-11,  -5.569951046265939e-11,   2.375512899772928e-12,   6.818061026240568e-15,  -4.653681677934724e-15,   1.706193228833299e-16,
   1.954672531882184e-18,  -3.934506781806765e-19,   1.005001278465742e+00,  -2.769435541935156e-02,   5.758015403181219e-04,   7.694213649865223e-07,  -7.747273405671343e-07,
   3.225372760975668e-08,  -4.450213763798856e-11,  -5.564613780785969e-11,   2.343053514160135e-12,   8.213350366571091e-15,  -4.630762488655371e-15,   1.659301598982022e-16,
   2.105383348154682e-18,  -3.884014424203739e-19,   1.005060092483287e+00,  -2.769405385916768e-02,   5.753209333992513e-04,   8.023968546111344e-07,  -7.747713422965455e-07,
   3.213310249407211e-08,  -3.784008112243813e-11,  -5.560945830373365e-11,   2.321635521308734e-12,   9.128003833119048e-15,  -4.615340689597071e-15,   1.628431439418422e-16,
   2.203460152570912e-18,  -3.850277593757345e-19,   1.005090289857765e+00,  -2.769389769420320e-02,   5.750741175206447e-04,   8.193152146968944e-07,  -7.747926176992841e-07,
   3.207116701993532e-08,  -3.442680374697629e-11,  -5.559018670163793e-11,   2.310645896501393e-12,   9.595459761287727e-15,  -4.607335766841284e-15,   1.612613879144175e-16,
   2.253361961014548e-18,  -3.832838627775677e-19,   1.005100799305621e+00,  -2.769384313278347e-02,   5.749882108124305e-04,   8.252012369157801e-07,  -7.747998126210643e-07,
   3.204961162573581e-08,  -3.324005557965702e-11,  -5.558340995436125e-11,   2.306822382607115e-12,   9.757802270778111e-15,  -4.604536090211112e-15,   1.607114138843482e-16,
   2.270656816082285e-18,  -3.826750916630788e-19,   1.005102466961604e+00,  -2.769383446482318e-02,   5.749745785926427e-04,   8.261351456744550e-07,  -7.748009443827594e-07,
   3.204619116803148e-08,  -3.305179547363612e-11,  -5.558233130102544e-11,   2.306215716179366e-12,   9.783546717455928e-15,  -4.604091180819156e-15,   1.606241677024267e-16,
   2.273397764977705e-18,  -3.825784033016332e-19,   1.528730358401142e-02,  -3.968749228336502e-04,   9.736231848150377e-06,  -1.991140051697042e-07,   2.288361508548000e-09,
   2.665317742644337e-11,  -9.220640087884451e-13,  -7.304945010998990e-14,   5.163780417425853e-15,  -7.982487055007422e-17,  -5.531916045205498e-18,   3.311690922965232e-19,
  -2.759946285893057e-21,  -4.512687105708839e-22,   1.528821892503948e-02,  -3.969308401766855e-04,   9.737512680651086e-06,  -1.990902602294009e-07,   2.287218615211525e-09,
   2.650581420263441e-11,  -9.089978040176736e-13,  -7.327813119522985e-14,   5.140155331428336e-15,  -7.824338175355969e-17,  -5.541929791743029e-18,   3.279193238084750e-19,
  -2.603860216355246e-21,  -4.505009945137674e-22,   1.528983415561036e-02,  -3.970295019976146e-04,   9.739772243069683e-06,  -1.990484752851533e-07,   2.285216707683677e-09,
   2.624544327992968e-11,  -8.859928549139460e-13,  -7.367739566719141e-14,   5.098440246194146e-15,  -7.546638499436708e-17,  -5.558841643814117e-18,   3.221909293539133e-19,
  -2.330949177124566e-21,  -4.490480582274871e-22,   1.529178747492443e-02,  -3.971487960593045e-04,   9.742503704801453e-06,  -1.989981419706626e-07,   2.282821082740418e-09,
   2.593001426299013e-11,  -8.582612940313200e-13,  -7.415297462807693e-14,   5.047951492040916e-15,  -7.213152159600711e-17,  -5.578008490916090e-18,   3.152744933262434e-19,
  -2.005202018148705e-21,  -4.471255396963943e-22,   1.529368389652655e-02,  -3.972645954077271e-04,   9.745154502123576e-06,  -1.989494820933883e-07,   2.280521688493336e-09,
   2.562319370454725e-11,  -8.314303586896531e-13,  -7.460713443813318e-14,   4.998891474517153e-15,  -6.891827059080655e-17,  -5.595282537428865e-18,   3.085715149412583e-19,
  -1.693417737246833e-21,  -4.450882785109930e-22,   1.529521175306182e-02,  -3.973578752372199e-04,   9.747289338975617e-06,  -1.989104278095259e-07,   2.278688089367279e-09,
   2.537559185562547e-11,  -8.098804954398968e-13,  -7.496763157810147e-14,   4.959337659317448e-15,  -6.634702197375188e-17,  -5.608251005988986e-18,   3.031801751776748e-19,
  -1.445422544482682e-21,  -4.433263923083066e-22,   1.529622139412744e-02,  -3.974195096522334e-04,   9.748699703618591e-06,  -1.988846927262458e-07,   2.277485652155440e-09,
   2.521177148781437e-11,  -7.956724638173546e-13,  -7.520322251359219e-14,   4.933186302155897e-15,  -6.465645209599631e-17,  -5.616359613668283e-18,   2.996219680704527e-19,
  -1.283101430236066e-21,  -4.421037825707177e-22,   1.529673991189013e-02,  -3.974511608745136e-04,   9.749423901685801e-06,  -1.988714985901098e-07,   2.276870976694983e-09,
   2.512757745840948e-11,  -7.883857762111146e-13,  -7.532340169643796e-14,   4.919751852810822e-15,  -6.379087997339248e-17,  -5.620381945043940e-18,   2.977960152602439e-19,
  -1.200220068809952e-21,  -4.414580078784007e-22,   1.529692038973331e-02,  -3.974621772133753e-04,   9.749675950893746e-06,  -1.988669097634037e-07,   2.276657484108339e-09,
   2.509826272895268e-11,  -7.858511408633802e-13,  -7.536510269587302e-14,   4.915075168799768e-15,  -6.349002605955772e-17,  -5.621759433721971e-18,   2.971606942160347e-19,
  -1.171448511837197e-21,  -4.412304027768703e-22,   1.529694902922326e-02,  -3.974639253470918e-04,   9.749715946941121e-06,  -1.988661817466102e-07,   2.276623627172253e-09,
   2.509361040026149e-11,  -7.854490033463432e-13,  -7.537171397500742e-14,   4.914333010418786e-15,  -6.344230445132738e-17,  -5.621976954257746e-18,   2.970598879429433e-19,
  -1.166886471068021e-21,  -4.411941505555958e-22,   1.408750991776991e-01,  -3.654111928818793e-03,   8.917597596027725e-05,  -1.778913109302650e-06,   1.716340980787402e-08,
   4.368340561017015e-10,  -1.443342865295844e-11,  -6.096852107516362e-13,   5.124513930582481e-14,  -8.896808203344225e-16,  -5.408728265064310e-17,   3.527582890303871e-18,
  -4.039187292578516e-20,  -4.423903577473690e-21,   1.408834785764947e-01,  -3.654610843844179e-03,   8.918552522724678e-05,  -1.778514043161997e-06,   1.714463893543208e-08,
   4.355938867175122e-10,  -1.430374251286866e-11,  -6.122514890682041e-13,   5.101186452493006e-14,  -8.727491707863029e-16,  -5.425784365483093e-17,   3.495250117238881e-18,
  -3.864144489855214e-20,  -4.425316568894208e-21,   1.408982648733894e-01,  -3.655491097854445e-03,   8.920236683191721e-05,  -1.777810841820357e-06,   1.711166379598690e-08,
   4.334016934085516e-10,  -1.407540999905599e-11,  -6.167341933386767e-13,   5.059973110715474e-14,  -8.430084498465264e-16,  -5.455028088130465e-17,   3.438206029467127e-18,
  -3.557861875950526e-20,  -4.426610238741437e-21,   1.409161458418802e-01,  -3.656555358126202e-03,   8.922271789736373e-05,  -1.776962157171269e-06,   1.707203906762931e-08,
   4.307442778101320e-10,  -1.380016233989900e-11,  -6.220773419723510e-13,   5.010051408135774e-14,  -8.072765440939866e-16,  -5.488945969711656e-17,   3.369245391176702e-18,
  -3.191897962538216e-20,  -4.426150587516012e-21,   1.409335056539942e-01,  -3.657588364302558e-03,   8.924245977414212e-05,  -1.776139982273630e-06,   1.703383248494556e-08,
   4.281576641923117e-10,  -1.353385231454663e-11,  -6.271836655745894e-13,   4.961500621911254e-14,  -7.728303492446831e-16,  -5.520372059448278e-17,   3.302324095125819e-18,
  -2.841219587936483e-20,  -4.423612110123992e-21,   1.409474914078233e-01,  -3.658420426664114e-03,   8.925835316348159e-05,  -1.775478878269601e-06,   1.700323999242180e-08,
   4.260690646399522e-10,  -1.331995873618280e-11,  -6.312396518643378e-13,   4.922327677345864e-14,  -7.452540817615533e-16,  -5.544621125948634e-17,   3.248434900790088e-18,
  -2.562000851771360e-20,  -4.420087173782811e-21,   1.409567333926583e-01,  -3.658970182898013e-03,   8.926885015138835e-05,  -1.775042635153539e-06,   1.698311606000211e-08,
   4.246865947256092e-10,  -1.317893639947123e-11,  -6.338916643734047e-13,   4.896413697273539e-14,  -7.271169254886357e-16,  -5.560125057209018e-17,   3.212838194435904e-18,
  -2.379102456496390e-20,  -4.417041017450200e-21,   1.409614797325582e-01,  -3.659252491799079e-03,   8.927423928917834e-05,  -1.774818789955036e-06,   1.697280958273238e-08,
   4.239759040243570e-10,  -1.310661206426669e-11,  -6.352449257798922e-13,   4.883096748400242e-14,  -7.178288322841025e-16,  -5.567927113352192e-17,   3.194561744747772e-18,
  -2.285670860075785e-20,  -4.415256584843342e-21,   1.409631317616688e-01,  -3.659350749255435e-03,   8.927611477865726e-05,  -1.774740908290133e-06,   1.696922679374069e-08,
   4.237284263320671e-10,  -1.308145442482794e-11,  -6.357145616571802e-13,   4.878460261887985e-14,  -7.146001976611630e-16,  -5.570617286051103e-17,   3.188201153100743e-18,
  -2.253229956947863e-20,  -4.414600604087217e-21,   1.409633939169830e-01,  -3.659366341230385e-03,   8.927641238117993e-05,  -1.774728550953035e-06,   1.696865846684940e-08,
   4.236891495644090e-10,  -1.307746299021728e-11,  -6.357890209656813e-13,   4.877724449113879e-14,  -7.140880558258118e-16,  -5.571042974602998e-17,   3.187191848387478e-18,
  -2.248085772979320e-20,  -4.414494855441493e-21,   4.130398901542967e-01,  -1.068869578262477e-02,   2.570785489067145e-04,  -4.757350373045681e-06,   1.743450730657461e-08,
   2.929179430472608e-09,  -9.533574635480538e-11,  -1.199804887860352e-12,   1.884419635985058e-13,  -4.595672267904747e-15,  -1.588835478569363e-16,   1.434110639683295e-17,
  -2.919640109820170e-19,  -1.324706364583569e-20,   4.130640094427211e-01,  -1.069002419413443e-02,   2.570876339898198e-04,  -4.754626137561197e-06,   1.730609189197989e-08,
   2.926603336310998e-09,  -9.485597837415768e-11,  -1.213509609387369e-12,   1.877272208237564e-13,  -4.525783087599935e-15,  -1.603225203746673e-16,   1.423777384708452e-17,
  -2.839032430282037e-19,  -1.337349456221474e-20,   4.131065689149698e-01,  -1.069236757814450e-02,   2.571036073586551e-04,  -4.749821208981362e-06,   1.708004346647451e-08,
   2.922036723934928e-09,  -9.401097157568694e-11,  -1.237503043580701e-12,   1.864614296400824e-13,  -4.402901884148221e-15,  -1.628220330993653e-16,   1.405477668349234e-17,
  -2.697676288487779e-19,  -1.359012954733802e-20,   4.131580333181337e-01,  -1.069520016802185e-02,   2.571228248171477e-04,  -4.744014506075571e-06,   1.680762723093054e-08,
   2.916479033518796e-09,  -9.299183193461083e-11,  -1.266195137456006e-12,   1.849230417807628e-13,  -4.255063531889400e-15,  -1.657772926615300e-16,   1.383238593534545e-17,
  -2.528245931205449e-19,  -1.384116080797486e-20,   4.132079951497765e-01,  -1.069794889277542e-02,   2.571413786860301e-04,  -4.738381104507888e-06,   1.654413622698215e-08,
   2.911046605824540e-09,  -9.200525367610950e-11,  -1.293713817778851e-12,   1.834215711641244e-13,  -4.112333190929212e-15,  -1.685762479310256e-16,   1.361536451072878e-17,
  -2.365339292217014e-19,  -1.407351700582753e-20,   4.132482445228986e-01,  -1.070016243864772e-02,   2.571562524324595e-04,  -4.733845530543384e-06,   1.633256229708457e-08,
   2.906643900872424e-09,  -9.121248007672384e-11,  -1.315643157046655e-12,   1.822063340463246e-13,  -3.997918030330788e-15,  -1.707811984067976e-16,   1.343974926673771e-17,
  -2.235233654428106e-19,  -1.425264594932522e-20,   4.132748409682866e-01,  -1.070162472313419e-02,   2.571660450525967e-04,  -4.730849791184416e-06,   1.619309589373080e-08,
   2.903721813692290e-09,  -9.068961142319867e-11,  -1.330016784786271e-12,   1.814005827815422e-13,  -3.922592534995317e-15,  -1.722138926523192e-16,   1.332333035644914e-17,
  -2.149816323589379e-19,  -1.436709642770443e-20,   4.132884996318554e-01,  -1.070237555646887e-02,   2.571710630081188e-04,  -4.729311734536519e-06,   1.612157761907575e-08,
   2.902217221295100e-09,  -9.042139752931532e-11,  -1.337362246252527e-12,   1.809859492678551e-13,  -3.883995392222460e-15,  -1.729421590483343e-16,   1.326342949866541e-17,
  -2.106122013341800e-19,  -1.442466769924358e-20,   4.132932536732841e-01,  -1.070263687183018e-02,   2.571728077996876e-04,  -4.728776463404281e-06,   1.609670164018305e-08,
   2.901692904961477e-09,  -9.032809169538430e-11,  -1.339913162519520e-12,   1.808414989000525e-13,  -3.870575022239661e-15,  -1.731944484214673e-16,   1.324256245209387e-17,
  -2.090941140922709e-19,  -1.444451469238521e-20,   4.132940080750624e-01,  -1.070267833807448e-02,   2.571730845908443e-04,  -4.728691526266744e-06,   1.609275495336210e-08,
   2.901609673339724e-09,  -9.031328764636388e-11,  -1.340317685473482e-12,   1.808185702968244e-13,  -3.868446045865202e-15,  -1.732344268000850e-16,   1.323925028794285e-17,
  -2.088533443447228e-19,  -1.444765507030912e-20,   9.028310385909519e-01,  -2.319857533896343e-02,   5.317735538475867e-04,  -7.071718994495453e-06,  -2.168563814509828e-07,
   2.027371545276685e-08,  -7.034304382116659e-10,   3.594059725572994e-12,   9.327969698804910e-13,  -5.043195649067170e-14,   9.098615574210168e-16,   3.734543619622928e-17,
  -3.203536576296183e-18,   9.087472878046015e-20,   9.028806364317762e-01,  -2.320049717977777e-02,   5.316461734001259e-04,  -7.052677392832691e-06,  -2.178157598019100e-07,
   2.027818677918246e-08,  -7.009171569288128e-10,   3.429510323143075e-12,   9.360197618883249e-13,  -5.021806252446199e-14,   8.906188560098288e-16,   3.790936150896280e-17,
  -3.191717118644680e-18,   8.904815191236512e-20,   9.029681422579758e-01,  -2.320388393908325e-02,   5.314209769191211e-04,  -7.019075576286302e-06,  -2.195056999499638e-07,
   2.028581595412005e-08,  -6.964759264919986e-10,   3.139762532347205e-12,   9.416409598951078e-13,  -4.983838215437667e-14,   8.567294047916610e-16,   3.889358981400251e-17,
  -3.170392415174039e-18,   8.582728097915203e-20,   9.030739375790218e-01,  -2.320797181190476e-02,   5.311479317992048e-04,  -6.978439583436060e-06,  -2.215442473830031e-07,
   2.029459764575940e-08,  -6.910945449233440e-10,   2.790427364442875e-12,   9.483267011448418e-13,  -4.937544424755237e-14,   8.158616402758564e-16,   4.006528032555580e-17,
  -3.143813144359573e-18,   8.193663520633112e-20,   9.031766233260033e-01,  -2.321193246438978e-02,   5.308820956746247e-04,  -6.938986515393870e-06,  -2.235180481403402e-07,
   2.030265909974223e-08,  -6.858589968311988e-10,   2.452383668120393e-12,   9.547005761737353e-13,  -4.892206688879525e-14,   7.763069153937865e-16,   4.118343353483369e-17,
  -3.117188256388773e-18,   7.816442236010985e-20,   9.032593323402708e-01,  -2.321511753739284e-02,   5.306673916419519e-04,  -6.907200641049507e-06,  -2.251043964570480e-07,
   2.030882170015641e-08,  -6.816332275490874e-10,   2.180841006402603e-12,   9.597519420036450e-13,  -4.855401877031576e-14,   7.445288012564442e-16,   4.207038405952083e-17,
  -3.095156458507444e-18,   7.512933700774565e-20,   9.033139784695885e-01,  -2.321721944612519e-02,   5.305252501262728e-04,  -6.886195683358456e-06,  -2.261508040787864e-07,
   2.031273172203115e-08,  -6.788369928165282e-10,   2.001794292430587e-12,   9.630490461790931e-13,  -4.830945295140159e-14,   7.235733807166452e-16,   4.264970397272629e-17,
  -3.080315129905888e-18,   7.312578838533595e-20,   9.033420398555918e-01,  -2.321829803230524e-02,   5.304521705632626e-04,  -6.875408204312624e-06,  -2.266876202900445e-07,
   2.031468962253756e-08,  -6.773997870048128e-10,   1.909964255125240e-12,   9.647296779099851e-13,  -4.818343659367617e-14,   7.128251840070459e-16,   4.294512262100666e-17,
  -3.072606357194313e-18,   7.209751296886946e-20,   9.033518065568534e-01,  -2.321867330965183e-02,   5.304267213298566e-04,  -6.871653456190237e-06,  -2.268743742391805e-07,
   2.031536311918021e-08,  -6.768993630983442e-10,   1.878020945049010e-12,   9.653126341288749e-13,  -4.813950877780478e-14,   7.090863218627506e-16,   4.304761318214219e-17,
  -3.069909437059088e-18,   7.173971725060344e-20,   9.033533563825871e-01,  -2.321873285461549e-02,   5.304226822594321e-04,  -6.871057626200444e-06,  -2.269040052528002e-07,
   2.031546961562323e-08,  -6.768199436496803e-10,   1.872952883050810e-12,   9.654050461842451e-13,  -4.813253487774479e-14,   7.084931180306896e-16,   4.306386123491460e-17,
  -3.069480818238345e-18,   7.168294503375985e-20,   1.384142259136162e-02,  -3.278929281565839e-04,   7.579159261472798e-06,  -1.598417842773078e-07,   2.516052835665881e-09,
  -4.899438373517205e-12,  -1.246660123700852e-12,   2.745815970988116e-14,   1.098395774764198e-15,  -9.312127575721032e-17,   1.384250545172386e-02,  -3.279611904510841e-04,
   7.581292846139570e-06,  -1.598481337671947e-07,   2.513447618355920e-09,  -4.824868818476768e-12,  -1.241987992718006e-12,   2.698859997954996e-14,   1.112823071208709e-15,
  -9.284984318045577e-17,   1.384428335942294e-02,  -3.280732558758565e-04,   7.584793881008546e-06,  -1.598584838929349e-07,   2.509178095705181e-09,  -4.703459999770358e-12,
  -1.234277527076444e-12,   2.621881149298054e-14,   1.136308432714232e-15,  -9.239563574992529e-17,   1.384617015196849e-02,  -3.281921684163483e-04,   7.588506591678463e-06,
  -1.598693667290310e-07,   2.504657842828984e-09,  -4.576006094375856e-12,  -1.226041525898659e-12,   2.540347749247226e-14,   1.160957439932677e-15,  -9.190207204701245e-17,
   1.384765528118715e-02,  -3.282857549853310e-04,   7.591426954112847e-06,  -1.598778600207337e-07,   2.501107675915671e-09,  -4.476690244875308e-12,  -1.219520463899655e-12,
   2.476288383133331e-14,   1.180160449280110e-15,  -9.150529081013083e-17,   1.384851246388792e-02,  -3.283397663327957e-04,   7.593111727569805e-06,  -1.598827331280612e-07,
   2.499061738282446e-09,  -4.419770039305580e-12,  -1.215741365065410e-12,   2.439362139414255e-14,   1.191164413960082e-15,  -9.127297737798306e-17,   1.384883436069019e-02,
  -3.283600482644126e-04,   7.593744258739757e-06,  -1.598845576518745e-07,   2.498294023763560e-09,  -4.398470915409574e-12,  -1.214319324423193e-12,   2.425504273603153e-14,
   1.195281687555824e-15,  -9.118511580703275e-17,   1.384888772054594e-02,  -3.283634102919265e-04,   7.593849103611132e-06,  -1.598848598096057e-07,   2.498166793418154e-09,
  -4.394944235231605e-12,  -1.214083445365645e-12,   2.423207573425246e-14,   1.195963402689494e-15,  -9.117051855494541e-17,   1.275580399940292e-01,  -3.020928597609227e-03,
   6.969608446981137e-05,  -1.456166209918587e-06,   2.185099810169531e-08,   3.296434273108855e-11,  -1.483894251795260e-11,   3.490375188804693e-13,   9.132445722098276e-15,
  -9.209470016640083e-16,   1.275679954201185e-01,  -3.021550071110209e-03,   6.971456528049440e-05,  -1.456111187539942e-06,   2.181979729727571e-08,   3.393312293293174e-11,
  -1.479937125173966e-11,   3.443798151398657e-13,   9.287693973969020e-15,  -9.187885891630205e-16,   1.275843407364436e-01,  -3.022570301632664e-03,   6.974488542121652e-05,
  -1.456019893816686e-06,   2.176863884840999e-08,   3.551351315956459e-11,  -1.473397301245815e-11,   3.367421474133626e-13,   9.540553271380140e-15,  -9.151502445559587e-16,
   1.276016869252357e-01,  -3.023652819355460e-03,   6.977703149611829e-05,  -1.455921717444021e-06,   2.171444138452928e-08,   3.717682318860981e-11,  -1.466399157682104e-11,
   3.286500142832154e-13,   9.806131056778367e-15,  -9.111614357738782e-16,   1.276153403087239e-01,  -3.024504747755030e-03,   6.980231186360874e-05,  -1.455843510475433e-06,
   2.167184995796943e-08,   3.847601433252831e-11,  -1.460849196548258e-11,   3.222903157629349e-13,   1.001316939754738e-14,  -9.079300119005252e-16,   1.276232206813198e-01,
  -3.024996404743314e-03,   6.981689414284242e-05,  -1.455797999700465e-06,   2.164729466329313e-08,   3.922186042049566e-11,  -1.457629297215631e-11,   3.186236065376619e-13,
   1.013186468416036e-14,  -9.060283429359486e-16,   1.276261799790493e-01,  -3.025181025399670e-03,   6.982236851393058e-05,  -1.455780839056337e-06,   2.163807865175886e-08,
   3.950118820888307e-11,  -1.456417006916368e-11,   3.172474064187223e-13,   1.017628654000085e-14,  -9.053073261865675e-16,   1.276266705323630e-01,  -3.025211628840435e-03,
   6.982327589441483e-05,  -1.455777990698104e-06,   2.163655121656075e-08,   3.954745150314800e-11,  -1.456215884604714e-11,   3.170193178620451e-13,   1.018364221732102e-14,
  -9.051874428336129e-16,   3.740497298193600e-01,  -8.852132594664405e-03,   2.031903191094852e-04,  -4.135338181580929e-06,   5.320510444173923e-08,   7.481397489314028e-10,
  -7.240560966398552e-11,   1.896854339662095e-12,   1.593413061472784e-14,  -3.231441570311027e-15,   3.740787348856832e-01,  -8.853894131141904e-03,   2.032348781101766e-04,
  -4.134228134805220e-06,   5.305148851347759e-08,   7.535442585833646e-10,  -7.232800811887972e-11,   1.880319890238397e-12,   1.662063874593944e-14,  -3.231078526380728e-15,
   3.741263558415531e-01,  -8.856785625415446e-03,   2.033079344311324e-04,  -4.132400364387572e-06,   5.279943025599746e-08,   7.623809439263438e-10,  -7.219867497295318e-11,
   1.853180420392385e-12,   1.774077865980315e-14,  -3.230062928781797e-15,   3.741768913927438e-01,  -8.859853243759616e-03,   2.033853244601826e-04,  -4.130453573204248e-06,
   5.253215138473367e-08,   7.717088495183269e-10,  -7.205881999701326e-11,   1.824390309770809e-12,   1.891997722300097e-14,  -3.228417513727467e-15,   3.742166675035857e-01,
  -8.862267126883715e-03,   2.034461379099161e-04,  -4.128916106813021e-06,   5.232192905779028e-08,   7.790148510565756e-10,  -7.194686320911317e-11,   1.801738043056781e-12,
   1.984122781629841e-14,  -3.226713431528687e-15,   3.742396248239084e-01,  -8.863660086058543e-03,   2.034811973101256e-04,  -4.128026672968699e-06,   5.220065718494938e-08,
   7.832172161909205e-10,  -7.188149590519746e-11,   1.788667478790121e-12,   2.037017644074419e-14,  -3.225566620416798e-15,   3.742482458563849e-01,  -8.864183129595572e-03,
   2.034943554279605e-04,  -4.127692279378931e-06,   5.215512818218631e-08,   7.847925867623098e-10,  -7.185680749453074e-11,   1.783759850496884e-12,   2.056828681574867e-14,
  -3.225105183641770e-15,   3.742496749333441e-01,  -8.864269830150720e-03,   2.034965362032114e-04,  -4.127636827645043e-06,   5.214758161602751e-08,   7.850535866998359e-10,
  -7.185270753633605e-11,   1.782946367788032e-12,   2.060109926303668e-14,  -3.225027071062637e-15,   8.179609287792465e-01,  -1.931777309267007e-02,   4.367038185320328e-04,
  -8.138197730316796e-06,   3.926996569588576e-08,   6.586797355308052e-09,  -3.995568876731550e-10,   1.259591994286219e-11,  -1.237036747276794e-13,  -1.047423115512087e-14,
   8.180231325050811e-01,  -1.932121320001024e-02,   4.367324882071815e-04,  -8.128515127027369e-06,   3.841243707112247e-08,   6.623510487410853e-09,  -3.999578294186631e-10,
   1.253827077189100e-11,  -1.192718472026411e-13,  -1.062425529013057e-14,   8.181252521577281e-01,  -1.932685763336319e-02,   4.367790235018672e-04,  -8.112582195847048e-06,
   3.700409540273269e-08,   6.683653948916155e-09,  -4.006032758269633e-10,   1.244308633826410e-11,  -1.119960744495048e-13,  -1.086902077923395e-14,   8.182336119206844e-01,
  -1.933284264894673e-02,   4.368276797189409e-04,  -8.095625407371588e-06,   3.550897265717392e-08,   6.747297452258987e-09,  -4.012707970558065e-10,   1.234135211032070e-11,
  -1.042758941966158e-13,  -1.112665618460277e-14,   8.183188937132542e-01,  -1.933754986760772e-02,   4.368654500219006e-04,  -8.082243662763657e-06,   3.433175897994703e-08,
   6.797259209841570e-09,  -4.017835804527811e-10,   1.226075619269389e-11,  -9.820026158571664e-14,  -1.132790363572415e-14,   8.183681123332430e-01,  -1.934026528335272e-02,
   4.368870385564399e-04,  -8.074506118946802e-06,   3.365215059259718e-08,   6.826042440959173e-09,  -4.020744836341712e-10,   1.221403086043681e-11,  -9.469403918190534e-14,
  -1.144343864851603e-14,   8.183865945703974e-01,  -1.934128471965913e-02,   4.368951056731940e-04,  -8.071597822399863e-06,   3.339691051378891e-08,   6.836841232714408e-09,
  -4.021827692004882e-10,   1.219644508872049e-11,  -9.337745309440734e-14,  -1.148670784144164e-14,   8.183896582739594e-01,  -1.934145369371724e-02,   4.368964408244523e-04,
  -8.071115584443637e-06,   3.335459869562724e-08,   6.838630780221934e-09,  -4.022006688896532e-10,   1.219352789045303e-11,  -9.315921216381481e-14,  -1.149387423733939e-14,
   1.263991428347303e-02,  -2.742642312036604e-04,   5.894912788837406e-06,  -1.216945260270685e-07,   2.191029765367219e-09,  -2.403449627694012e-11,  -3.545223900132775e-13,
   2.757888579392751e-14,  -5.873417155169630e-16,  -1.000611921159641e-17,   1.264075692596129e-02,  -2.743163035522973e-04,   5.896779141236085e-06,  -1.217280421705378e-07,
   2.190247378588559e-09,  -2.395305263382688e-11,  -3.566990155849390e-13,   2.751898156908610e-14,  -5.794669893264483e-16,  -1.032999591531104e-17,   1.264214045126816e-02,
  -2.744017989243448e-04,   5.899842569981080e-06,  -1.217829809913916e-07,   2.188959693180631e-09,  -2.381948468697663e-11,  -3.602495356471310e-13,   2.741945566053824e-14,
  -5.665245946492026e-16,  -1.085959968776099e-17,   1.264360873850347e-02,  -2.744925299496331e-04,   5.903092436588918e-06,  -1.218411621221166e-07,   2.187588933363848e-09,
  -2.367794360497069e-11,  -3.639859529252728e-13,   2.731224692497287e-14,  -5.527720733327149e-16,  -1.141869107748009e-17,   1.264476447646663e-02,  -2.745639457441307e-04,
   5.905649614158642e-06,  -1.218868690772546e-07,   2.186506948781879e-09,  -2.356668494447928e-11,  -3.669041008674470e-13,   2.722671511714601e-14,  -5.419348731695685e-16,
  -1.185661666725738e-17,   1.264543155087498e-02,  -2.746051652008599e-04,   5.907125216840350e-06,  -1.219132146457607e-07,   2.185881240856414e-09,  -2.350252983482183e-11,
  -3.685792237120364e-13,   2.717688999325584e-14,  -5.356750511759101e-16,  -1.210851342824689e-17,   1.264568205820484e-02,  -2.746206442733463e-04,   5.907679283525766e-06,
  -1.219231014699260e-07,   2.185646041206210e-09,  -2.347844928532341e-11,  -3.692065477480690e-13,   2.715809277789821e-14,  -5.333234061992940e-16,  -1.220294417926723e-17,
   1.264572358413252e-02,  -2.746232101910786e-04,   5.907771126067773e-06,  -1.219247400255960e-07,   2.185607040845678e-09,  -2.347445813566530e-11,  -3.693104459222185e-13,
   2.715497226368450e-14,  -5.329335339082959e-16,  -1.221858902911792e-17,   1.164871144516329e-01,  -2.527370272476141e-03,   5.428865974863338e-05,  -1.117030108561392e-06,
   1.980751572615894e-08,  -1.963390231565090e-10,  -4.547495988893607e-12,   3.042609805579798e-13,  -6.810970029473459e-15,  -7.342867595624020e-17,   1.164948740218989e-01,
  -2.527848115981286e-03,   5.430551542572744e-05,  -1.117301908046037e-06,   1.979750745885538e-08,  -1.954373747947311e-10,  -4.573040417105378e-12,   3.037952715041521e-13,
  -6.734310045337906e-15,  -7.678144886063148e-17,   1.165076143371978e-01,  -2.528632655544616e-03,   5.433318047740105e-05,  -1.117747186770239e-06,   1.978103870812992e-08,
  -1.939582368850531e-10,  -4.614753843036420e-12,   3.030184647033597e-13,  -6.608266037401362e-15,  -8.226645298292301e-17,   1.165211351403683e-01,  -2.529465224106241e-03,
   5.436252670104428e-05,  -1.118218406589127e-06,   1.976351187286474e-08,  -1.923902174775011e-10,  -4.658713155232041e-12,   3.021775763200184e-13,  -6.474263827144868e-15,
  -8.806031180939664e-17,   1.165317777803332e-01,  -2.530120540510561e-03,   5.438561614421156e-05,  -1.118588350674399e-06,   1.974968050252306e-08,  -1.911572465372626e-10,
  -4.693090584797632e-12,   3.015037788814093e-13,  -6.368618602951685e-15,  -9.260103565867349e-17,   1.165379205360442e-01,  -2.530498768678789e-03,   5.439893902921906e-05,
  -1.118801488678425e-06,   1.974168310154092e-08,  -1.904461069557169e-10,  -4.712842699673846e-12,   3.011101118008202e-13,  -6.307575696420050e-15,  -9.521388573737660e-17,
   1.165402273304271e-01,  -2.530640803209160e-03,   5.440394143510310e-05,  -1.118881455345596e-06,   1.973867715978362e-08,  -1.901791490773126e-10,  -4.720243216667008e-12,
   3.009613788621296e-13,  -6.284639813119389e-15,  -9.619357803028689e-17,   1.165406097213953e-01,  -2.530664347786891e-03,   5.440477063068197e-05,  -1.118894707337718e-06,
   1.973817873232722e-08,  -1.901349013300375e-10,  -4.721469082427841e-12,   3.009366764286646e-13,  -6.280837144436989e-15,  -9.635589895828203e-17,   3.415992259448597e-01,
  -7.410020747604025e-03,   1.589113093505088e-04,  -3.240759475299635e-06,   5.504226661428447e-08,  -3.728398331741951e-10,  -2.392077045621633e-11,   1.321032653279015e-12,
  -3.265076226319086e-14,  -1.200562502019526e-17,   3.416219340963644e-01,  -7.411406049597376e-03,   1.589580084718182e-04,  -3.241256791502735e-06,   5.498972998298420e-08,
  -3.688992878709949e-10,  -2.404559355880086e-11,   1.320620009358980e-12,  -3.239758863561978e-14,  -2.512712848636902e-17,   3.416592179582315e-01,  -7.413680392751068e-03,
   1.590346397518571e-04,  -3.242069166869857e-06,   5.490329283875156e-08,  -3.624313638960558e-10,  -2.424977487343133e-11,   1.319894344287162e-12,  -3.198076102517563e-14,
  -4.662297203118001e-17,   3.416987854793995e-01,  -7.416093844005441e-03,   1.591159067056819e-04,  -3.242925656831767e-06,   5.481131907414470e-08,  -3.555699742663646e-10,
  -2.446542487682377e-11,   1.319058886389081e-12,  -3.153685566404171e-14,  -6.936946182633234e-17,   3.417299300037615e-01,  -7.417993385204424e-03,   1.591798317706211e-04,
  -3.243595735146423e-06,   5.473874945852519e-08,  -3.501712114852535e-10,  -2.463441553147659e-11,   1.318354049414328e-12,  -3.118633916442316e-14,  -8.722536892425090e-17,
   3.417479059921755e-01,  -7.419089704470895e-03,   1.592167111498671e-04,  -3.243980853748544e-06,   5.469679380743647e-08,  -3.470559703823915e-10,  -2.473165143994836e-11,
   1.317928328249879e-12,  -3.098358781159755e-14,  -9.751183955537800e-17,   3.417546565087970e-01,  -7.419501393990069e-03,   1.592305572595615e-04,  -3.244125167845416e-06,
   5.468102501787681e-08,  -3.458862608223004e-10,  -2.476810926178472e-11,   1.317764887744527e-12,  -3.090736590292162e-14,  -1.013709864136518e-16,   3.417557755222377e-01,
  -7.419569637986400e-03,   1.592328523204025e-04,  -3.244149074053654e-06,   5.467841037586891e-08,  -3.456923697451411e-10,  -2.477414975267967e-11,   1.317737606460882e-12,
  -3.089472646468694e-14,  -1.020105086871008e-16,   7.470832844450466e-01,  -1.619691576711607e-02,   3.457765982255962e-04,  -6.868069922533145e-06,   1.004502188706146e-07,
   5.836849654992510e-10,  -1.303472707229606e-10,   6.357651629874037e-12,  -1.903704731932069e-13,   2.710797119611900e-15,   7.471326601619879e-01,  -1.619984435734696e-02,
   3.458607360191524e-04,  -6.867077059950525e-06,   1.001631254525486e-07,   6.028797904665654e-10,  -1.310939994143042e-10,   6.370059689082517e-12,  -1.898109705057175e-13,
   2.655951413560656e-15,   7.472137267839574e-01,  -1.620465176780719e-02,   3.459986818429591e-04,  -6.865427292351220e-06,   9.969066946180533e-08,   6.344170348731039e-10,
  -1.323182023613902e-10,   6.390224382201561e-12,  -1.888817056401956e-13,   2.565639703375560e-15,   7.472997561299217e-01,  -1.620975233046824e-02,   3.461448080280389e-04,
  -6.863649806179148e-06,   9.918780151887562e-08,   6.679153525713308e-10,  -1.336148855181291e-10,   6.411341327288155e-12,  -1.878810860322891e-13,   2.469442910535402e-15,
   7.473674699189382e-01,  -1.621376615612889e-02,   3.462596324170774e-04,  -6.862231387861201e-06,   9.879091664396286e-08,   6.943037543964867e-10,  -1.346337100658196e-10,
   6.427757789737510e-12,  -1.870830345818679e-13,   2.393470479850371e-15,   7.474065521715992e-01,  -1.621608247465594e-02,   3.463258284921048e-04,  -6.861404959772273e-06,
   9.856141598244478e-08,   7.095429947792494e-10,  -1.352210190694652e-10,   6.437150666127842e-12,  -1.866182346455276e-13,   2.349519779839199e-15,   7.474212285696825e-01,
  -1.621695224896672e-02,   3.463506722834537e-04,  -6.861093147211430e-06,   9.847515107189870e-08,   7.152673593975382e-10,  -1.354414314192560e-10,   6.440662385472466e-12,
  -1.864428987812671e-13,   2.332995995632985e-15,   7.474236614256281e-01,  -1.621709642511695e-02,   3.463547897853691e-04,  -6.861041381697803e-06,   9.846084693832386e-08,
   7.162163536751164e-10,  -1.354779611547578e-10,   6.441243690444423e-12,  -1.864137922188155e-13,   2.330255896316159e-15,   1.162871798292568e-02,  -2.323887003483548e-04,
   4.628178486863095e-06,  -9.072318532031379e-08,   1.676359496751098e-09,  -2.548213290444521e-11,   1.480322351627061e-13,   9.185797307749848e-15,  -4.496530283004358e-16,
   9.882689523208496e-18,   1.162937948848911e-02,  -2.324275592971048e-04,   4.629611496179062e-06,  -9.075920936171528e-08,   1.676654297126288e-09,  -2.545391833351471e-11,
   1.462474179907781e-13,   9.233883002088445e-15,  -4.493424109672323e-16,   9.788545202059704e-18,   1.163046560461891e-02,  -2.324913636120343e-04,   4.631964188161889e-06,
  -9.081831932185385e-08,   1.677135509871447e-09,  -2.540749735312786e-11,   1.433183705247011e-13,   9.312470044672523e-15,  -4.488108369820512e-16,   9.633354108843845e-18,
   1.163161825851198e-02,  -2.325590799503773e-04,   4.634460813479356e-06,  -9.088099963403069e-08,   1.677642377545501e-09,  -2.535810263498832e-11,   1.402118435975841e-13,
   9.395375382588244e-15,  -4.482173887326717e-16,   9.467821793223397e-18,   1.163252554852918e-02,  -2.326123839419344e-04,   4.636425841799375e-06,  -9.093030041847968e-08,
   1.678038580681938e-09,  -2.531912880880967e-11,   1.377680447054702e-13,   9.460272636114650e-15,  -4.477290589682150e-16,   9.336925981340801e-18,   1.163304922160414e-02,
  -2.326431510767142e-04,   4.637559966403559e-06,  -9.095874124576533e-08,   1.678266153459621e-09,  -2.529659630708557e-11,   1.363581119625915e-13,   9.497585611906815e-15,
  -4.474387060504351e-16,   9.261135678110851e-18,   1.163324587706404e-02,  -2.326547052654972e-04,   4.637985854357646e-06,  -9.096941886128369e-08,   1.678351404481457e-09,
  -2.528812759177713e-11,   1.358287507858959e-13,   9.511570410776831e-15,  -4.473280640738770e-16,   9.232628972889965e-18,   1.163327847610238e-02,  -2.326566205811236e-04,
   4.638056452061282e-06,  -9.097118871289929e-08,   1.678365525254211e-09,  -2.528672338371244e-11,   1.357410059762867e-13,   9.513887187433401e-15,  -4.473096385740623e-16,
   9.227901118597015e-18,   1.071685370771277e-01,  -2.141615206771489e-03,   4.264385803546987e-05,  -8.350069716623530e-07,   1.535076990419311e-08,  -2.279262052700454e-10,
   9.755908589094624e-13,   1.023187459665803e-13,  -4.786427723010085e-15,   1.088203507836356e-16,   1.071746319905804e-01,  -2.141972825632404e-03,   4.265697560378047e-05,
  -8.353286665099768e-07,   1.535262622034918e-08,  -2.276119556373358e-10,   9.565454282544147e-13,   1.028521483882121e-13,  -4.785352736461675e-15,   1.079296076415717e-16,
   1.071846391285634e-01,  -2.142560013525954e-03,   4.267851128946146e-05,  -8.358564539499365e-07,   1.535564429623394e-08,  -2.270949276795278e-10,   9.252836146378349e-13,
   1.037244646473146e-13,  -4.783370632429425e-15,   1.064604255896067e-16,   1.071952593118111e-01,  -2.143183199291984e-03,   4.270136376668767e-05,  -8.364160325488725e-07,
   1.535880679955837e-08,  -2.265447807030381e-10,   8.921186606596480e-13,   1.046454926711632e-13,  -4.780972109590190e-15,   1.048921968458186e-16,   1.072036187815004e-01,
  -2.143673746761310e-03,   4.271934982859675e-05,  -8.368561013994038e-07,   1.536126681512703e-08,  -2.261107000423860e-10,   8.660224601821784e-13,   1.053670291528530e-13,
  -4.778870636035252e-15,   1.036512824729804e-16,   1.072084437279334e-01,  -2.143956890164867e-03,   4.272973035184812e-05,  -8.371099443222729e-07,   1.536267495844656e-08,
  -2.258597388624873e-10,   8.509638425573064e-13,   1.057821086328014e-13,  -4.777572132161289e-15,   1.029324476097157e-16,   1.072102556440440e-01,  -2.144063220672929e-03,
   4.273362841972649e-05,  -8.372052403836043e-07,   1.536320154171916e-08,  -2.257654165071818e-10,   8.453095723818515e-13,   1.059377226695830e-13,  -4.777068333512007e-15,
   1.026620129210718e-16,   1.072105560003896e-01,  -2.144080846864043e-03,   4.273427458439000e-05,  -8.372210357778931e-07,   1.536328871498212e-08,  -2.257497768016783e-10,
   8.443723170242397e-13,   1.059635045962326e-13,  -4.776983967210873e-15,   1.026171578884786e-16,   3.142756260854753e-01,  -6.280030568075930e-03,   1.249885346691911e-04,
  -2.440405892724747e-06,   4.425665984032106e-08,  -6.141681106353402e-10,  -2.435779065416155e-13,   4.444903695416915e-13,  -1.946442632264821e-14,   4.771784953942851e-16,
   3.142934888455187e-01,  -6.281075475716202e-03,   1.250263143038022e-04,  -2.441268330771082e-06,   4.425521461230783e-08,  -6.128020121429814e-10,  -3.214376654788496e-13,
   4.468625345761221e-13,  -1.947970488257657e-14,   4.745079535165434e-16,   3.143228173421725e-01,  -6.282791124161664e-03,   1.250883345036632e-04,  -2.442682741662045e-06,
   4.425272175858078e-08,  -6.105542642410067e-10,  -4.492965982390844e-13,   4.507467174371861e-13,  -1.950400925105297e-14,   4.700944689898384e-16,   3.143539424240888e-01,
  -6.284611917568598e-03,   1.251541410785230e-04,  -2.444181607187845e-06,   4.424991314930529e-08,  -6.081623432447252e-10,  -5.850173097868789e-13,   4.548543361290485e-13,
  -1.952874012556914e-14,   4.653716319874946e-16,   3.143784418500848e-01,  -6.286045150419443e-03,   1.252059299716309e-04,  -2.445359819916560e-06,   4.424758435775918e-08,
  -6.062749122344766e-10,  -6.918672667599873e-13,   4.580770159596024e-13,  -1.954743689025703e-14,   4.616260139793733e-16,   3.143925824803102e-01,  -6.286872400829112e-03,
   1.252358178521068e-04,  -2.446039226670257e-06,   4.424619289787967e-08,  -6.051836471787381e-10,  -7.535469961773435e-13,   4.599328486622543e-13,  -1.955791969242293e-14,
   4.594528610497709e-16,   3.143978927172115e-01,  -6.287183061177915e-03,   1.252470409522048e-04,  -2.446294244190195e-06,   4.424566141787286e-08,  -6.047734902218070e-10,
  -7.767110561973296e-13,   4.606289670991450e-13,  -1.956179795223511e-14,   4.586346534820302e-16,   3.143987729802671e-01,  -6.287234558610934e-03,   1.252489013365841e-04,
  -2.446336511375385e-06,   4.424557284406743e-08,  -6.047054810047741e-10,  -7.805509726573619e-13,   4.607443182823655e-13,  -1.956243776180432e-14,   4.584989096303817e-16,
   6.873447367921340e-01,  -1.373301041666632e-02,   2.729759396632926e-04,  -5.288044055106073e-06,   9.212330539487550e-08,  -9.970786228681091e-10,  -2.131160907803666e-11,
   2.000141440753939e-12,  -8.461883034768794e-14,   2.439460916868187e-15,   6.873837408795325e-01,  -1.373527281668109e-02,   2.730543157167850e-04,  -5.289410648412903e-06,
   9.207373883035542e-08,  -9.909029186035532e-10,  -2.165399812040620e-11,   2.012565019006483e-12,  -8.487243499017158e-14,   2.436839855011167e-15,   6.874477804181344e-01,
  -1.373898732188640e-02,   2.731829508064995e-04,  -5.291647697809776e-06,   9.199183628087390e-08,  -9.807377163827996e-10,  -2.221680208058508e-11,   2.032949575532929e-12,
  -8.528642760539909e-14,   2.432397640582004e-15,   6.875157422116885e-01,  -1.374292925435053e-02,   2.733193990612991e-04,  -5.294012619708472e-06,   9.190420905518567e-08,
  -9.699152626829571e-10,  -2.281495121245014e-11,   2.054564260134351e-12,  -8.572251237051940e-14,   2.427494520819035e-15,   6.875692363860857e-01,  -1.374603197713303e-02,
   2.734267529047118e-04,  -5.295867471017761e-06,   9.183472254010426e-08,  -9.613715992458384e-10,  -2.328639753788388e-11,   2.071564114901427e-12,  -8.606339143963963e-14,
   2.423498284570248e-15,   6.876001120806562e-01,  -1.374782277966284e-02,   2.734886961731394e-04,  -5.296935390812005e-06,   9.179441054348432e-08,  -9.564303310268554e-10,
  -2.355875797853493e-11,   2.081370574216369e-12,  -8.625918544040249e-14,   2.421136817943161e-15,   6.876117068082938e-01,  -1.374849527412973e-02,   2.735119540739736e-04,
  -5.297335922651682e-06,   9.177923328305721e-08,  -9.545728414826402e-10,  -2.366108475358820e-11,   2.085052139900276e-12,  -8.633253111923943e-14,   2.420239630528559e-15,
   6.876136288318728e-01,  -1.374860675131167e-02,   2.735158092765430e-04,  -5.297402291063286e-06,   9.177671533984352e-08,  -9.542648308110183e-10,  -2.367804965968136e-11,
   2.085662366668581e-12,  -8.634467987291094e-14,   2.420090358296494e-15,   1.076691371571188e-02,  -1.992991645288559e-04,   3.684415404924777e-06,  -6.772322050288304e-08,
   1.216034068833790e-09,  -2.015146785317884e-11,   2.545955082587574e-13,   3.024951036826724e-17,  -1.479383320891866e-16,   5.934987527592578e-18,   1.076744012924457e-02,
  -1.993281783572992e-04,   3.685456742947950e-06,  -6.775189219121498e-08,   1.216570299702641e-09,  -2.015088938011098e-11,   2.539888234630849e-13,   6.077744093624999e-17,
  -1.487712645913755e-16,   5.939816714345117e-18,   1.076830442987500e-02,  -1.993758180995819e-04,   3.687166596514806e-06,  -6.779896061079407e-08,   1.217449664332946e-09,
  -2.014987370834555e-11,   2.529904753222662e-13,   1.109097785872570e-16,  -1.501348325746978e-16,   5.947468853826617e-18,   1.076922166593276e-02,  -1.994263795723612e-04,
   3.688981329676220e-06,  -6.784890272136035e-08,   1.218381451666305e-09,  -2.014870626536506e-11,   2.519279265616226e-13,   1.641249720442915e-16,  -1.515764576670935e-16,
   5.955213011317560e-18,   1.076994364146267e-02,  -1.994661804229232e-04,   3.690409857146300e-06,  -6.788820658430113e-08,   1.219113840160771e-09,  -2.014772249646083e-11,
   2.510893655153922e-13,   2.060203041755352e-16,  -1.527072195136250e-16,   5.961035482423707e-18,   1.077036035012670e-02,  -1.994891537617394e-04,   3.691234417648506e-06,
  -6.791088926559949e-08,   1.219536141360532e-09,  -2.014712869064769e-11,   2.506044833219858e-13,   2.302046641502454e-16,  -1.533582722902604e-16,   5.964286475724648e-18,
   1.077051683640121e-02,  -1.994977811384897e-04,   3.691544072757851e-06,  -6.791940677132703e-08,   1.219694648810462e-09,  -2.014690078576698e-11,   2.504222292289398e-13,
   2.392872001916019e-16,  -1.536024586983781e-16,   5.965486585500391e-18,   1.077054277666462e-02,  -1.994992112844720e-04,   3.691595403813710e-06,  -6.792081866627469e-08,
   1.219720919949982e-09,  -2.014686274744858e-11,   2.503920087237373e-13,   2.407928164831215e-16,  -1.536429207517192e-16,   5.965684429981883e-18,   9.922637036631120e-02,
  -1.836703722547292e-03,   3.395314786117665e-05,  -6.238832368571531e-07,   1.118372736739756e-08,  -1.840076723727271e-10,   2.244112196911637e-12,   5.342250737240259e-15,
  -1.572283154407634e-15,   6.181744069466000e-17,   9.923122140585429e-02,  -1.836970996481138e-03,   3.396272368716882e-05,  -6.241449108199421e-07,   1.118844079713239e-08,
  -1.839866127048692e-10,   2.237662810247163e-12,   5.660829105997135e-15,  -1.581205263324573e-15,   6.189016237257573e-17,   9.923918616181115e-02,  -1.837409850612955e-03,
   3.397844684004513e-05,  -6.245744672060804e-07,   1.119616860674518e-08,  -1.839513505490146e-10,   2.227049602512633e-12,   6.184075993632645e-15,  -1.595817557863013e-15,
   6.200685388219149e-17,   9.924763872840574e-02,  -1.837875618459111e-03,   3.399513423770880e-05,  -6.250302270329244e-07,   1.120435473228761e-08,  -1.839129975739220e-10,
   2.215753573821308e-12,   6.739614200239181e-15,  -1.611274774216459e-15,   6.212700603728790e-17,   9.925429191664419e-02,  -1.838242259620101e-03,   3.400827014086862e-05,
  -6.253888884309098e-07,   1.121078733620038e-08,  -1.838821348750658e-10,   2.206838536233226e-12,   7.177062325812273e-15,  -1.623405037270376e-15,   6.221890650815832e-17,
   9.925813199211073e-02,  -1.838453887237347e-03,   3.401585226236895e-05,  -6.255958692235985e-07,   1.121449573577181e-08,  -1.838640512782652e-10,   2.201683485583869e-12,
   7.429615621626553e-15,  -1.630391690314072e-15,   6.227087613598141e-17,   9.925957405243510e-02,  -1.838533361528812e-03,   3.401869963879433e-05,  -6.256735907214846e-07,
   1.121588752340059e-08,  -1.838572092641124e-10,   2.199745822902736e-12,   7.524469384406268e-15,  -1.633012601220226e-15,   6.229018919527686e-17,   9.925981309846867e-02,
  -1.838546535847609e-03,   3.401917164350183e-05,  -6.256864740744658e-07,   1.121611819236650e-08,  -1.838560723882419e-10,   2.199424527919876e-12,   7.540193671763136e-15,
  -1.633446914883424e-15,   6.229337994718087e-17,   2.909856309620834e-01,  -5.386143027447626e-03,   9.955485561985477e-05,  -1.827727999499281e-06,   3.262175305563371e-08,
  -5.265262700672267e-10,   5.786110363173676e-12,   5.570854821871844e-14,  -6.298586674035222e-15,   2.405305277832558e-16,   2.909998545008205e-01,  -5.386925966012852e-03,
   9.958277758672820e-05,  -1.828475692980281e-06,   3.263379580192354e-08,  -5.263398655760949e-10,   5.760245547263503e-12,   5.695362701201890e-14,  -6.335654966744018e-15,
   2.410166836557956e-16,   2.910232076251460e-01,  -5.388211516752833e-03,   9.962862334908043e-05,  -1.829702952826518e-06,   3.265352560595281e-08,  -5.260311548792928e-10,
   5.717678028402692e-12,   5.899935834609682e-14,  -6.396418226286296e-15,   2.418058962855594e-16,   2.910479910144547e-01,  -5.389575898513087e-03,   9.967727920128064e-05,
  -1.831004897020362e-06,   3.267440557434562e-08,  -5.256999207487811e-10,   5.672366361045063e-12,   6.117237445882833e-14,  -6.460768937188880e-15,   2.426311966500723e-16,
   2.910674985102286e-01,  -5.390649900770648e-03,   9.971557880952615e-05,  -1.832029334824874e-06,   3.269079841514185e-08,  -5.254365802839560e-10,   5.636601522513374e-12,
   6.288422730903561e-14,  -6.511322845482317e-15,   2.432719157791204e-16,   2.910787578052786e-01,  -5.391269819315456e-03,   9.973768514366494e-05,  -1.832620477702432e-06,
   3.270024306550722e-08,  -5.252835355955183e-10,   5.615919157147714e-12,   6.387283885913086e-14,  -6.540461977959234e-15,   2.436381530584767e-16,   2.910829859975964e-01,
  -5.391502622062148e-03,   9.974598683612582e-05,  -1.832842442523260e-06,   3.270378660275372e-08,  -5.252258642930799e-10,   5.608144831438968e-12,   6.424419798341163e-14,
  -6.551397078520975e-15,   2.437750098189682e-16,   2.910836868923405e-01,  -5.391541213355397e-03,   9.974736298917671e-05,  -1.832879235566030e-06,   3.270437383523590e-08,
  -5.252162938176947e-10,   5.606855709454168e-12,   6.430576268898808e-14,  -6.553209361424762e-15,   2.437976604707009e-16,   6.364116610538534e-01,  -1.177959214867916e-02,
   2.176559695339987e-04,  -3.986932436349807e-06,   7.032410061507196e-08,  -1.072868432790361e-09,   7.705195145639151e-12,   3.821226327708206e-13,  -2.536670253524850e-14,
   9.642942865395196e-16,   6.364427560208274e-01,  -1.178129961307524e-02,   2.177161008353923e-04,  -3.988448808808408e-06,   7.033929987467456e-08,  -1.071645663982978e-09,
   7.600540250774330e-12,   3.871666006733892e-13,  -2.553908495435290e-14,   9.681796290001801e-16,   6.364938096413894e-01,  -1.178410315773521e-02,   2.178148250814121e-04,
  -3.990936888175495e-06,   7.036408854412848e-08,  -1.069627328774808e-09,   7.428235429039781e-12,   3.954613319061354e-13,  -2.582215038067796e-14,   9.745388383975958e-16,
   6.365479899054219e-01,  -1.178707856776064e-02,   2.179195912896400e-04,  -3.993575171284695e-06,   7.039016877567847e-08,  -1.067470803573282e-09,   7.244731297395288e-12,
   4.042819985833573e-13,  -2.612259882057934e-14,   9.812601753867397e-16,   6.365906361595520e-01,  -1.178942068882845e-02,   2.180020516010559e-04,  -3.995650233754152e-06,
   7.041053265444004e-08,  -1.065762794446378e-09,   7.099823495232582e-12,   4.112378633378000e-13,  -2.635911879372297e-14,   9.865307458615376e-16,   6.366152505926911e-01,
  -1.179077255612257e-02,   2.180496445541288e-04,  -3.996847278099287e-06,   7.042222024065591e-08,  -1.064772730476064e-09,   7.015998293776472e-12,   4.152578118650664e-13,
  -2.649564445203271e-14,   9.895647723325013e-16,   6.366244940194243e-01,  -1.179128023039696e-02,   2.180675168401038e-04,  -3.997296682662528e-06,   7.042659678341862e-08,
  -1.064400131072041e-09,   6.984484033869293e-12,   4.167683965081812e-13,  -2.654691588118118e-14,   9.907026145429518e-16,   6.366260262741038e-01,  -1.179136438650311e-02,
   2.180704794620382e-04,  -3.997371172753747e-06,   7.042732161082978e-08,  -1.064338324087899e-09,   6.979258138880740e-12,   4.170188531076781e-13,  -2.655541509911777e-14,
   9.908911507690637e-16,   1.002394999417586e-02,  -1.727722978360802e-04,   2.976233913322067e-06,  -5.116606870108728e-08,   8.721229354874850e-10,  -1.440288819572906e-11,
   2.145440060225788e-13,  -2.206394873604982e-15,  -1.614891629948587e-17,   1.854810890267501e-18,   1.002437503686346e-02,  -1.727942143724429e-04,   2.976981159628943e-06,
  -5.118661926524320e-08,   8.725800204947883e-10,  -1.440932442145254e-11,   2.144707667688018e-13,  -2.196579466254780e-15,  -1.657679689125401e-17,   1.866497836336504e-18,
   1.002507289052167e-02,  -1.728302002689595e-04,   2.978208167214652e-06,  -5.122036289742209e-08,   8.733302817885185e-10,  -1.441986912316253e-11,   2.143492965868691e-13,
  -2.180422816214435e-15,  -1.727989404445319e-17,   1.885656788938510e-18,   1.002581347226151e-02,  -1.728683927248173e-04,   2.979510500102300e-06,  -5.125617639616866e-08,
   8.741262059669640e-10,  -1.443102872519337e-11,   2.142187263500664e-13,  -2.163220882065761e-15,  -1.802682736688614e-17,   1.905948782106131e-18,   1.002639639007135e-02,
  -1.728984566436035e-04,   2.980535720204366e-06,  -5.128436824001665e-08,   8.747524850551715e-10,  -1.443979025138482e-11,   2.141147490045869e-13,  -2.149640573284047e-15,
  -1.861530903114751e-17,   1.921891518004937e-18,   1.002673283384252e-02,  -1.729158096267562e-04,   2.981127505908250e-06,  -5.130064087954262e-08,   8.751138756228950e-10,
  -1.444483821265239e-11,   2.140542531946188e-13,  -2.141786171936881e-15,  -1.895518859858024e-17,   1.931081399057269e-18,   1.002685917759033e-02,  -1.729223263185098e-04,
   2.981349748329206e-06,  -5.130675190385548e-08,   8.752495723944677e-10,  -1.444673216663954e-11,   2.140314440629572e-13,  -2.138833566140620e-15,  -1.908286480126885e-17,
   1.934530203713696e-18,   1.002688012117919e-02,  -1.729234065784542e-04,   2.981386589299658e-06,  -5.130776491925551e-08,   8.752720656021514e-10,  -1.444704603187830e-11,
   2.140276582500831e-13,  -2.138343960696731e-15,  -1.910403148893640e-17,   1.935101782079364e-18,   9.237934037253408e-02,  -1.592243723342594e-03,   2.742816376493964e-05,
  -4.714872233403580e-07,   8.032285118363592e-09,  -1.323455990054729e-10,   1.952805370318009e-12,  -1.905496934774506e-14,  -2.056476808995892e-16,   1.924372590331147e-17,
   9.238325744139747e-02,  -1.592445678744936e-03,   2.743504563416914e-05,  -4.716760263324301e-07,   8.036442645250668e-09,  -1.324009094744083e-10,   1.951894542904194e-12,
  -1.895310502102799e-14,  -2.100449760370746e-16,   1.936601048609571e-17,   9.238968865570983e-02,  -1.592777279600549e-03,   2.744634589886844e-05,  -4.719860332155942e-07,
   8.043266444628027e-09,  -1.324914884049319e-10,   1.950386563771150e-12,  -1.878542714215194e-14,  -2.172715672038360e-16,   1.956653555896245e-17,   9.239651363876530e-02,
  -1.593129213088830e-03,   2.745833983541386e-05,  -4.723150507550626e-07,   8.050505036456670e-09,  -1.325872971879465e-10,   1.948769197351096e-12,  -1.860689534068942e-14,
  -2.249499667874851e-16,   1.977899900549288e-17,   9.240188563699518e-02,  -1.593406244054084e-03,   2.746778164741305e-05,  -4.725740444147066e-07,   8.056200399344653e-09,
  -1.326624797925515e-10,   1.947483797968174e-12,  -1.846594670045436e-14,  -2.310004074900172e-16,   1.994598222823042e-17,   9.240498620313448e-02,  -1.593566147076876e-03,
   2.747323171212311e-05,  -4.727235367850918e-07,   8.059486721844238e-09,  -1.327057810549591e-10,   1.946736945722133e-12,  -1.838442496187951e-14,  -2.344952249071074e-16,
   2.004225974923268e-17,   9.240615054965187e-02,  -1.593626196606254e-03,   2.747527845657273e-05,  -4.727796768233074e-07,   8.060720658134790e-09,  -1.327220244434333e-10,
   1.946455545487714e-12,  -1.835377919972232e-14,  -2.358081267240897e-16,   2.007839546225115e-17,   9.240634355955472e-02,  -1.593636150904997e-03,   2.747561774383530e-05,
  -4.727889830579289e-07,   8.060925194900431e-09,  -1.327247161379628e-10,   1.946408849256410e-12,  -1.834869745703683e-14,  -2.360257886519640e-16,   2.008438455049987e-17,
   2.709065641520376e-01,  -4.669312030023997e-03,   8.043139772195764e-05,  -1.382270647711036e-06,   2.351710402285597e-08,  -3.851747393957549e-10,   5.540845643270714e-12,
  -4.601737683853434e-14,  -1.047994299958665e-15,   7.359543761824007e-17,   2.709180506462675e-01,  -4.669904092438335e-03,   8.045154433977904e-05,  -1.382819882145378e-06,
   2.352887735819472e-08,  -3.853060017112992e-10,   5.536324042701616e-12,  -4.562737726558837e-14,  -1.064620365308825e-15,   7.407868797698686e-17,   2.709369096690399e-01,
  -4.670876228475492e-03,   8.048462552283703e-05,  -1.383721671775618e-06,   2.354819803325760e-08,  -3.855206392098945e-10,   5.528853004684555e-12,  -4.498534323801851e-14,
  -1.091952310187774e-15,   7.487165244609999e-17,   2.709569233819415e-01,  -4.671907970695804e-03,   8.051973706499787e-05,  -1.384678719756436e-06,   2.356868899041927e-08,
  -3.857472277060027e-10,   5.520860226446623e-12,  -4.430166815636914e-14,  -1.121004479708063e-15,   7.571253507877267e-17,   2.709726763300724e-01,  -4.672720124332895e-03,
   8.054737716304625e-05,  -1.385432051118323e-06,   2.358480837377631e-08,  -3.859247136075889e-10,   5.514522449067882e-12,  -4.376185544092428e-14,  -1.143905363264533e-15,
   7.637393243536666e-17,   2.709817684866938e-01,  -4.673188901061083e-03,   8.056333166147676e-05,  -1.385866865191417e-06,   2.359410832544010e-08,  -3.860268067559774e-10,
   5.510845770817534e-12,  -4.344961495520096e-14,  -1.157136560955685e-15,   7.675548162518354e-17,   2.709851828373369e-01,  -4.673364944045172e-03,   8.056932327428181e-05,
  -1.386030151977873e-06,   2.359760000799663e-08,  -3.860650799042430e-10,   5.509461544229502e-12,  -4.333223250808202e-14,  -1.162107770222474e-15,   7.689872724844367e-17,
   2.709857488230276e-01,  -4.673394126357576e-03,   8.057031649835210e-05,  -1.386057219615460e-06,   2.359817877574789e-08,  -3.860714208567454e-10,   5.509231899039157e-12,
  -4.331276766947277e-14,  -1.162931964926460e-15,   7.692247067478559e-17,   5.924977332461370e-01,  -1.021214188914909e-02,   1.758950805548250e-04,  -3.021024119894028e-06,
   5.122112765451476e-08,  -8.255623600643952e-10,   1.102271710233405e-11,  -4.064245762812466e-14,  -5.105206947546782e-15,   2.748612281369494e-16,   5.925228526250019e-01,
  -1.021343578450401e-02,   1.759389471232849e-04,  -3.022199761277324e-06,   5.124439773980769e-08,  -8.256603302148518e-10,   1.100106320743205e-11,  -3.917959291538387e-14,
  -5.168205178908824e-15,   2.768967843752196e-16,   5.925640946851066e-01,  -1.021556028614729e-02,   1.760109754745573e-04,  -3.024129857850555e-06,   5.128256524140980e-08,
  -8.258179685454954e-10,   1.096533213280509e-11,  -3.677050275840611e-14,  -5.271847275010484e-15,   2.802416021772360e-16,   5.926078618619584e-01,  -1.021781503997799e-02,
   1.760874225180638e-04,  -3.026177961313914e-06,   5.132301739706913e-08,  -8.259808830003987e-10,   1.092717004542365e-11,  -3.420398964774532e-14,  -5.382118689116482e-15,
   2.837949253052770e-16,   5.926423113233948e-01,  -1.021958990033079e-02,   1.761476007769351e-04,  -3.027789916272906e-06,   5.135481965660345e-08,  -8.261059394927516e-10,
   1.089695597522555e-11,  -3.217668083259116e-14,  -5.469119241696121e-15,   2.865944349460087e-16,   5.926621945705410e-01,  -1.022061435014984e-02,   1.761823364493081e-04,
  -3.028720241309514e-06,   5.137315977355226e-08,  -8.261768438121478e-10,   1.087944647865898e-11,  -3.100369354587320e-14,  -5.519415622293589e-15,   2.882112914148486e-16,
   5.926696612657855e-01,  -1.022099906831123e-02,   1.761953811020246e-04,  -3.029069594040170e-06,   5.138004409658363e-08,  -8.262032291034687e-10,   1.087285779998728e-11,
  -3.056266025505990e-14,  -5.538318784526802e-15,   2.888186638304495e-16,   5.926708989952423e-01,  -1.022106284228119e-02,   1.761975434959644e-04,  -3.029127504593580e-06,
   5.138118513579860e-08,  -8.262075901760912e-10,   1.087176490979284e-11,  -3.048952286862378e-14,  -5.541453117685826e-15,   2.889193564396528e-16,   9.376900116080994e-03,
  -1.512013614469980e-04,   2.437306705984153e-06,  -3.925821855823253e-08,   6.304549907312223e-10,  -1.000713145313541e-11,   1.526160476935608e-13,  -2.049754583496998e-15,
   1.671043874566136e-17,   2.756071986426895e-19,   9.377248049011768e-03,  -1.512181721496150e-04,   2.437846866682774e-06,  -3.927251092549567e-08,   6.307815215683835e-10,
  -1.001323203283985e-11,   1.526799399129504e-13,  -2.048206328177232e-15,   1.658130089852530e-17,   2.806717932570549e-19,   9.377819293102259e-03,  -1.512457740617707e-04,
   2.438733829672331e-06,  -3.929598042449870e-08,   6.313176719349428e-10,  -1.002324368873295e-11,   1.527844537852404e-13,  -2.045645768107868e-15,   1.636866802335149e-17,
   2.889987124067599e-19,   9.378425503185439e-03,  -1.512750678365005e-04,   2.439675240232659e-06,  -3.932089188972424e-08,   6.318867006304449e-10,  -1.003386214123924e-11,
   1.528948396814122e-13,  -2.042903174032193e-15,   1.614218908839742e-17,   2.978512384187290e-19,   9.378902648708123e-03,  -1.512981265453322e-04,   2.440416333901331e-06,
  -3.934050350578782e-08,   6.323346243201913e-10,  -1.004221550715020e-11,   1.529813429081717e-13,  -2.040726152744765e-15,   1.596332717736128e-17,   3.048305002278804e-19,
   9.379178040770061e-03,  -1.513114359227532e-04,   2.440844113170819e-06,  -3.935182422244733e-08,   6.325931678846849e-10,  -1.004703502444853e-11,   1.530311166165745e-13,
  -2.039462294744184e-15,   1.585985327546306e-17,   3.088632746840432e-19,   9.379281457395930e-03,  -1.513164340563023e-04,   2.441004763590652e-06,  -3.935607573083218e-08,
   6.326902607449467e-10,  -1.004884454081802e-11,   1.530497789465707e-13,  -2.038986293376200e-15,   1.582095070215514e-17,   3.103785470428782e-19,   9.379298600401847e-03,
  -1.513172625858890e-04,   2.441031394491251e-06,  -3.935678050382151e-08,   6.327063556548815e-10,  -1.004914448030834e-11,   1.530528710068668e-13,  -2.038907314926998e-15,
   1.581449955951283e-17,   3.106297739023611e-19,   8.641622195250541e-02,  -1.393450570924428e-03,   2.246180381043490e-05,  -3.617876687288402e-07,   5.809122586565130e-09,
  -9.214045862906740e-11,   1.401054730490686e-12,  -1.859388800205541e-14,   1.401649239379360e-16,   3.097885465451876e-18,   8.641942844124913e-02,  -1.393605491039284e-03,
   2.246678087875467e-05,  -3.619192579128471e-07,   5.812119559787277e-09,  -9.219574704801708e-11,   1.401585706697752e-12,  -1.857663214366879e-14,   1.388446752734933e-16,
   3.149347103616841e-18,   8.642469292628575e-02,  -1.393859858202211e-03,   2.247495339368923e-05,  -3.621353396122225e-07,   5.817040380994064e-09,  -9.228647376017208e-11,
   1.402453550372850e-12,  -1.854811227472236e-14,   1.366707623841629e-16,   3.233965997314853e-18,   8.643027965160935e-02,  -1.394129816777108e-03,   2.248362758072779e-05,
  -3.623646961128711e-07,   5.822262842917356e-09,  -9.238268970215223e-11,   1.403369170791819e-12,  -1.851758983403364e-14,   1.343552244733903e-16,   3.323937865154975e-18,
   8.643467694057325e-02,  -1.394342315680941e-03,   2.249045603414814e-05,  -3.625452567019711e-07,   5.826373734728910e-09,  -9.245837424440544e-11,   1.404085974983510e-12,
  -1.849337957522419e-14,   1.325264781636115e-16,   3.394879484341572e-18,   8.643721490519042e-02,  -1.394464969024960e-03,   2.249439759881899e-05,  -3.626494841175930e-07,
   5.828746525332417e-09,  -9.250203801853193e-11,   1.404498133255169e-12,  -1.847933155502217e-14,   1.314685053599128e-16,   3.435874566297300e-18,   8.643816797454600e-02,
  -1.394511029613243e-03,   2.249587783366119e-05,  -3.626886267758641e-07,   5.829637591151381e-09,  -9.251843130947705e-11,   1.404652614520475e-12,  -1.847404204711161e-14,
   1.310707407850516e-16,   3.451278681995375e-18,   8.643832596145980e-02,  -1.394518664975324e-03,   2.249612321106036e-05,  -3.626951154547430e-07,   5.829785301194032e-09,
  -9.252114857944629e-11,   1.404678206786444e-12,  -1.847316447893574e-14,   1.310047800139361e-16,   3.453832664684604e-18,   2.534194807604904e-01,  -4.086354072005571e-03,
   6.586967632852404e-05,  -1.060880536643148e-06,   1.702767257672876e-08,  -2.695831084120068e-10,   4.067962916795303e-12,  -5.228614266627546e-14,   3.051953486433930e-16,
   1.341207513099353e-17,   2.534288838367915e-01,  -4.086808345522459e-03,   6.588426458564896e-05,  -1.061265481321747e-06,   1.703636917552738e-08,  -2.697381731515046e-10,
   4.069076807640318e-12,  -5.221232459234488e-14,   3.002944154229363e-16,   1.360173734930174e-17,   2.534443220172543e-01,  -4.087554228133146e-03,   6.590821894258724e-05,
  -1.061897589324946e-06,   1.705064771418675e-08,  -2.699925742371764e-10,   4.070891182406016e-12,  -5.209043359464707e-14,   2.922239103419468e-16,   1.391367946840541e-17,
   2.534607051710298e-01,  -4.088345829145685e-03,   6.593364366820647e-05,  -1.062568520793013e-06,   1.706580059702083e-08,  -2.702622913774554e-10,   4.072796957968926e-12,
  -5.196013620553982e-14,   2.836267262425853e-16,   1.424546216434466e-17,   2.534736002844668e-01,  -4.088968940555195e-03,   6.595365834783681e-05,  -1.063096703717223e-06,
   1.707772761475428e-08,  -2.704743987343913e-10,   4.074282724498434e-12,  -5.185689431293079e-14,   2.768362516200673e-16,   1.450714624935703e-17,   2.534810429020620e-01,
  -4.089328597342115e-03,   6.596521133025104e-05,  -1.063401591053007e-06,   1.708461157586014e-08,  -2.705967451024542e-10,   4.075134531727063e-12,  -5.179703163706103e-14,
   2.729075348724351e-16,   1.465839709158144e-17,   2.534838377915382e-01,  -4.089463660927828e-03,   6.596954999063992e-05,  -1.063516091116452e-06,   1.708719669342311e-08,
  -2.706426750808240e-10,   4.075453323237332e-12,  -5.177449969319044e-14,   2.714304099213588e-16,   1.471523630458117e-17,   2.534843010904126e-01,  -4.089486050119218e-03,
   6.597026920683642e-05,  -1.063535071765286e-06,   1.708762522007375e-08,  -2.706502879826854e-10,   4.075506110986108e-12,  -5.177076190865627e-14,   2.711854575709919e-16,
   1.472466048596291e-17,   5.542520177147173e-01,  -8.937222657609297e-03,   1.440600620878415e-04,  -2.319826429373394e-06,   3.719848692168277e-08,  -5.861562659278954e-10,
   8.667127078331201e-12,  -1.013845981393438e-13,   3.728269077969493e-17,   5.599840964221742e-17,   5.542725826043955e-01,  -8.938215998964679e-03,   1.440919285990204e-04,
  -2.320663084844647e-06,   3.721698479184267e-08,  -5.864543343779130e-10,   8.666913078659476e-12,  -1.010793792018278e-13,   1.990370814240244e-17,   5.667864964072813e-17,
   5.543063464946354e-01,  -8.939846988368878e-03,   1.441442540506553e-04,  -2.322036894764314e-06,   3.724735151580030e-08,  -5.869429907102940e-10,   8.666511154688737e-12,
  -1.005757729512435e-13,  -8.723661384181991e-18,   5.779816839074427e-17,   5.543421770715217e-01,  -8.941577945981305e-03,   1.441997909146085e-04,  -2.323495026809918e-06,
   3.727957220207407e-08,  -5.874605775034181e-10,   8.666015746434404e-12,  -1.000379500682276e-13,  -3.923141627709618e-17,   5.898986214864769e-17,   5.543703791678617e-01,
  -8.942940473472468e-03,   1.442435099519977e-04,  -2.324642883505823e-06,   3.730492947093070e-08,  -5.878672559108626e-10,   8.665575825000349e-12,  -9.961217267162123e-14,
  -6.333678352852509e-17,   5.993048080488835e-17,   5.543866564496844e-01,  -8.943726916862809e-03,   1.442687455663123e-04,  -2.325305453850455e-06,   3.731956340269328e-08,
  -5.881016905737106e-10,   8.665301842346529e-12,  -9.936544142385979e-14,  -7.728681865343079e-17,   6.047443220760383e-17,   5.543927689767066e-01,  -8.944022253481784e-03,
   1.442782226415232e-04,  -2.325554278234890e-06,   3.732505854214287e-08,  -5.881896724860441e-10,   8.665195156146667e-12,  -9.927260091856568e-14,  -8.253244929508925e-17,
   6.067889964039860e-17,   5.543937822285234e-01,  -8.944071210772255e-03,   1.442797936472911e-04,  -2.325595525631848e-06,   3.732596943762720e-08,  -5.882042540738702e-10,
   8.665177270641356e-12,  -9.925720122358768e-14,  -8.340237042289929e-17,   6.071280403101437e-17,   8.808331509572826e-03,  -1.334298286001170e-04,   2.020721172754631e-06,
  -3.059142069744696e-08,   4.626268358703433e-10,  -6.967674676349340e-12,   1.033955252861105e-13,  -1.462272844508897e-15,   1.778274714169054e-17,  -1.114565230829285e-19,
   8.808619869944729e-03,  -1.334429239204467e-04,   2.021117439588429e-06,  -3.060137318460805e-08,   4.628483804863938e-10,  -6.972053038172700e-12,   1.034659156421885e-13,
  -1.462805075639893e-15,   1.776047837378467e-17,  -1.100200103782162e-19,   8.809093301139421e-03,  -1.334644250885341e-04,   2.021768112739235e-06,  -3.061771631045383e-08,
   4.632121901909150e-10,  -6.979241952125125e-12,   1.035814072860755e-13,  -1.463673441379060e-15,   1.772367927604260e-17,  -1.076539858395050e-19,   8.809595703927061e-03,
  -1.334872436770655e-04,   2.022458713491027e-06,  -3.063506375682347e-08,   4.635983676245625e-10,  -6.986871467234244e-12,   1.037038634191410e-13,  -1.464587519839596e-15,
   1.768430419282004e-17,  -1.051329053971305e-19,   8.809991137895677e-03,  -1.335052050585778e-04,   2.023002354791281e-06,  -3.064872072470282e-08,   4.639023978408774e-10,
  -6.992877032486035e-12,   1.038001719901502e-13,  -1.465301588680300e-15,   1.765307768718888e-17,  -1.031411635827003e-19,   8.810219366741714e-03,  -1.335155721388248e-04,
   2.023316154892347e-06,  -3.065660420642595e-08,   4.640779023184925e-10,  -6.996343399602237e-12,   1.038557273754775e-13,  -1.465711556881045e-15,   1.763496070277971e-17,
  -1.019886276680056e-19,   8.810305071999489e-03,  -1.335194653103608e-04,   2.023434000172792e-06,  -3.065956486838137e-08,   4.641438140630316e-10,  -6.997645137506743e-12,
   1.038765840160631e-13,  -1.465865100013437e-15,   1.762813952033206e-17,  -1.015552599615537e-19,   8.810319279033986e-03,  -1.335201106713932e-04,   2.023453535254126e-06,
  -3.066005565821400e-08,   4.641547403037153e-10,  -6.997860923548984e-12,   1.038800410408769e-13,  -1.465890530660526e-15,   1.762700785786155e-17,  -1.014833925129367e-19,
   8.117637264890078e-02,  -1.229670889537575e-03,   1.862267317161193e-05,  -2.819242226812015e-07,   4.263291276965760e-09,  -6.419587201644469e-11,   9.517317672716962e-13,
  -1.341162341894582e-14,   1.607630542951919e-16,  -8.957341555280992e-19,   8.117903013586270e-02,  -1.229791573217566e-03,   1.862632491467384e-05,  -2.820159171388311e-07,
   4.265330396129409e-09,  -6.423601830487531e-11,   9.523673601460966e-13,  -1.341582007010720e-14,   1.605251701634270e-16,  -8.811999295947737e-19,   8.118339320840449e-02,
  -1.229989723389915e-03,   1.863232110292692e-05,  -2.821664897562807e-07,   4.268678918300773e-09,  -6.430193374422574e-11,   9.534100896632307e-13,  -1.342265513787296e-14,
   1.601322135311191e-16,  -8.572607480442895e-19,   8.118802327887258e-02,  -1.230200014616360e-03,   1.863868523628603e-05,  -2.823263151111504e-07,   4.272233287795719e-09,
  -6.437188702806395e-11,   9.545155523396861e-13,  -1.342983355842747e-14,   1.597119472353497e-16,  -8.317521472457779e-19,   8.119166754035771e-02,  -1.230365542854629e-03,
   1.864369508407121e-05,  -2.824521391781733e-07,   4.275031556791138e-09,  -6.442694920082009e-11,   9.553848635643321e-13,  -1.343542922567250e-14,   1.593787961195213e-16,
  -8.115990321115001e-19,   8.119377086393610e-02,  -1.230461083638549e-03,   1.864658686289024e-05,  -2.825247710126705e-07,   4.276646877818469e-09,  -6.445873007616632e-11,
   9.558862809963447e-13,  -1.343863699236028e-14,   1.591855651508303e-16,  -7.999371115285207e-19,   8.119456071102252e-02,  -1.230496962270250e-03,   1.864767284867275e-05,
  -2.825520480707370e-07,   4.277253519728623e-09,  -6.447066475505318e-11,   9.560745153608294e-13,  -1.343983745263189e-14,   1.591128228542587e-16,  -7.955520525905658e-19,
   8.119469164096881e-02,  -1.230502909778715e-03,   1.864785287132418e-05,  -2.825565697961406e-07,   4.277354083148735e-09,  -6.447264313284270e-11,   9.561057151091904e-13,
  -1.344003623032287e-14,   1.591007551649440e-16,  -7.948248554494648e-19,   2.380533912680289e-01,  -3.606065078622464e-03,   5.461172152559708e-05,  -8.267402876859944e-07,
   1.250073425098040e-08,  -1.881306898977895e-10,   2.782522716016650e-12,  -3.885012934551284e-14,   4.480040284504632e-16,  -1.628980804025530e-18,   2.380611844502079e-01,
  -3.606418981778541e-03,   5.462242898531900e-05,  -8.270089927330619e-07,   1.250669479250325e-08,  -1.882468994386749e-10,   2.784287966293061e-12,  -3.885705074710125e-14,
   4.470549201007498e-16,  -1.576223690105591e-18,   2.380739793271838e-01,  -3.607000054248476e-03,   5.464001069907198e-05,  -8.274502351425334e-07,   1.251648269922146e-08,
  -1.884376902296062e-10,   2.787183126448978e-12,  -3.886821578668221e-14,   4.454880179761860e-16,  -1.489322060749970e-18,   2.380875571855594e-01,  -3.607616730098084e-03,
   5.465867126642595e-05,  -8.279185899807458e-07,   1.252687210979377e-08,  -1.886401528264450e-10,   2.790251317661974e-12,  -3.887979365723647e-14,   4.438134531076222e-16,
  -1.396715182516229e-18,   2.380982441213023e-01,  -3.608102139099648e-03,   5.467336085926545e-05,  -8.282873053887834e-07,   1.253505129672104e-08,  -1.887995053959463e-10,
   2.792663239807295e-12,  -3.888871019800698e-14,   4.424868877374255e-16,  -1.323545032991818e-18,   2.381044121978201e-01,  -3.608382310948250e-03,   5.468183996517344e-05,
  -8.285001454384898e-07,   1.253977273356685e-08,  -1.888914762067964e-10,   2.794054097090925e-12,  -3.889377766606943e-14,   4.417178192728137e-16,  -1.281201570650471e-18,
   2.381067284544772e-01,  -3.608487524467726e-03,   5.468502422872705e-05,  -8.285800779109354e-07,   1.254154588186597e-08,  -1.889260131603686e-10,   2.794576167570122e-12,
  -3.889566570597706e-14,   4.414283677925808e-16,  -1.265279332804107e-18,   2.381071124115296e-01,  -3.608504965441903e-03,   5.468555208049647e-05,  -8.285933283328130e-07,
   1.254183981722179e-08,  -1.889317382073299e-10,   2.794662697122091e-12,  -3.889597789204155e-14,   4.413803523076490e-16,  -1.262638841250933e-18,   5.206449775714861e-01,
  -7.886798087902465e-03,   1.194403553269373e-04,  -1.808078413807080e-06,   2.733201594194678e-08,  -4.107795698196179e-10,   6.039374255376976e-12,  -8.229758589692017e-14,
   8.464929456793895e-16,   2.260483574630465e-18,   5.206620218908019e-01,  -7.887572069397894e-03,   1.194637658897596e-04,  -1.808665057249825e-06,   2.734494671530348e-08,
  -4.110252402031964e-10,   6.042671967955979e-12,  -8.228116995720220e-14,   8.428965183563683e-16,   2.439555100767242e-18,   5.206900053200328e-01,  -7.888842866832264e-03,
   1.195022061111500e-04,  -1.809628380005356e-06,   2.736617972061718e-08,  -4.114285092776170e-10,   6.048075165774395e-12,  -8.225354936799927e-14,   8.369622224407852e-16,
   2.734599875470746e-18,   5.207197011916271e-01,  -7.890191527915471e-03,   1.195430050230677e-04,  -1.810650883190540e-06,   2.738871643219410e-08,  -4.118563556442463e-10,
   6.053794015577029e-12,  -8.222332742601492e-14,   8.306243840500052e-16,   3.049121162172055e-18,   5.207430743813486e-01,  -7.891253109991600e-03,   1.195751218498508e-04,
  -1.811455847103411e-06,   2.740645789649050e-08,  -4.121930337686077e-10,   6.058284345102472e-12,  -8.219887885554712e-14,   8.256066600948009e-16,   3.297706736423290e-18,
   5.207565644614257e-01,  -7.891865841416244e-03,   1.195936602532322e-04,  -1.811920507136598e-06,   2.741669882586776e-08,  -4.123873213703397e-10,   6.060871606629888e-12,
  -8.218450247969156e-14,   8.226988635830915e-16,   3.441593990157445e-18,   5.207616303012037e-01,  -7.892095941703070e-03,   1.196006222043553e-04,  -1.812095010427815e-06,
   2.742054477128888e-08,  -4.124602752614940e-10,   6.061842354593255e-12,  -8.217905354466599e-14,   8.216046922797585e-16,   3.495705219221904e-18,   5.207624700461841e-01,
  -7.892134084833751e-03,   1.196017762788650e-04,  -1.812123937839391e-06,   2.742118231154770e-08,  -4.124723682524680e-10,   6.062003228015294e-12,  -8.217814764189750e-14,
   8.214231981886164e-16,   3.504679158859944e-18,   8.304783495992785e-03,  -1.186163924095315e-04,   1.693839010051692e-06,  -2.418220908999784e-08,   3.450862194119770e-10,
  -4.917487591584247e-12,   6.970863259677523e-14,  -9.706714455082077e-16,   1.278628919668499e-17,  -1.416247015882352e-19,   8.305025135978172e-03,  -1.186267411424856e-04,
   1.694134506693515e-06,  -2.418923163501783e-08,   3.452356263922447e-10,  -4.920399868920976e-12,   6.975965739671425e-14,  -9.713900940274859e-16,   1.279003655905983e-17,
  -1.413700929405261e-19,   8.305421857664008e-03,  -1.186437324357449e-04,   1.694619704668384e-06,  -2.420076327983201e-08,   3.454809809024171e-10,  -4.925182391376171e-12,
   6.984343328515454e-14,  -9.725689090791417e-16,   1.279612348561587e-17,  -1.409494592335676e-19,   8.305842851551616e-03,  -1.186617644653645e-04,   1.695134662847240e-06,
  -2.421300332528197e-08,   3.457414280683260e-10,  -4.930259119902720e-12,   6.993234003813296e-14,  -9.738184090081902e-16,   1.280249367008386e-17,  -1.404995236940167e-19,
   8.306174206017569e-03,  -1.186759579068116e-04,   1.695540028619550e-06,  -2.422263925941533e-08,   3.459464788835807e-10,  -4.934256053344941e-12,   7.000232021873873e-14,
  -9.748008164171695e-16,   1.280744278784517e-17,  -1.401428032697718e-19,   8.306365449211962e-03,  -1.186841500771214e-04,   1.695774009609604e-06,  -2.422820152978572e-08,
   3.460648487976966e-10,  -4.936563371351028e-12,   7.004271117066218e-14,  -9.753673984853060e-16,   1.281027321168496e-17,  -1.399358816938171e-19,   8.306437265211407e-03,
  -1.186872264806665e-04,   1.695861878693268e-06,  -2.423029044150358e-08,   3.461093037520294e-10,  -4.937429907383317e-12,   7.005787913161696e-14,  -9.755800828518386e-16,
   1.281133117943461e-17,  -1.398579817095219e-19,   8.306449169861466e-03,  -1.186877364471426e-04,   1.695876444615397e-06,  -2.423063672033253e-08,   3.461166731069423e-10,
  -4.937573554209314e-12,   7.006039347810587e-14,  -9.756153344834946e-16,   1.281150629489432e-17,  -1.398450581761770e-19,   7.653574350863647e-02,  -1.093152359228916e-03,
   1.561018464362589e-05,  -2.228595126308888e-07,   3.180225512631772e-09,  -4.531546841383403e-11,   6.421930197216420e-13,  -8.932212779561861e-15,   1.171721285266950e-16,
  -1.276285144829610e-18,   7.653797042904446e-02,  -1.093247731539003e-03,   1.561290786148049e-05,  -2.229242262110092e-07,   3.181601897714378e-09,  -4.534226511108539e-11,
   6.426604523426362e-13,  -8.938679186253159e-15,   1.171991523779791e-16,  -1.273625668819944e-18,   7.654162656077285e-02,  -1.093404320647981e-03,   1.561737931565307e-05,
  -2.230304916347402e-07,   3.183862178121969e-09,  -4.538627014775854e-11,   6.434278927413289e-13,  -8.949284791361085e-15,   1.172428640258012e-16,  -1.269233171093548e-18,
   7.654550638172168e-02,  -1.093570501018695e-03,   1.562212503142604e-05,  -2.231432849932917e-07,   3.186261491032742e-09,  -4.543298180116045e-11,   6.442423059925158e-13,
  -8.960524447704987e-15,   1.172883567279222e-16,  -1.264536265017362e-18,   7.654856009825889e-02,  -1.093701305558255e-03,   1.562586077279790e-05,  -2.232320811389456e-07,
   3.188150473010521e-09,  -4.546975779863334e-11,   6.448833248507547e-13,  -8.969360146941408e-15,   1.173235146067504e-16,  -1.260813571696395e-18,   7.655032256885992e-02,
  -1.093776803319667e-03,   1.562801707821874e-05,  -2.232833380280183e-07,   3.189240926110921e-09,  -4.549098742671914e-11,   6.452532976997209e-13,  -8.974455391463078e-15,
   1.173435457684724e-16,  -1.258654613446677e-18,   7.655098441509212e-02,  -1.093805154973874e-03,   1.562882685586626e-05,  -2.233025875594618e-07,   3.189650455899691e-09,
  -4.549896039872831e-11,   6.453922315062358e-13,  -8.976367946785484e-15,   1.173510186244985e-16,  -1.257841913088416e-18,   7.655109412668627e-02,  -1.093809854745199e-03,
   1.562896109145346e-05,  -2.233057785535071e-07,   3.189718344162662e-09,  -4.550028208758336e-11,   6.454152620533477e-13,  -8.976684940089565e-15,   1.173522547684605e-16,
  -1.257707091341403e-18,   2.244445370973636e-01,  -3.205718746762757e-03,   4.577755318230863e-05,  -6.535427233442805e-07,   9.325854565920096e-09,  -1.328648259409591e-10,
   1.881564903234929e-12,  -2.609591500816149e-14,   3.386925473524933e-16,  -3.526952833897536e-18,   2.244510676388714e-01,  -3.205998429012577e-03,   4.578553886314253e-05,
  -6.537324608489633e-07,   9.329887010221987e-09,  -1.329430961602159e-10,   1.882914881427600e-12,  -2.611370782102151e-14,   3.387150984555879e-16,  -3.516763413959356e-18,
   2.244617894050618e-01,  -3.206457631406913e-03,   4.579865114475634e-05,  -6.540440263046708e-07,   9.336509003392501e-09,  -1.330716276472397e-10,   1.885131140740757e-12,
  -2.614287916047863e-14,   3.387497914982661e-16,  -3.499941499395478e-18,   2.244731671496306e-01,  -3.206944960455808e-03,   4.581256767945925e-05,  -6.543747309457637e-07,
   9.343538281310977e-09,  -1.332080614349207e-10,   1.887482829627975e-12,  -2.617377976664333e-14,   3.387834316141976e-16,  -3.481963714352114e-18,   2.244821223068611e-01,
  -3.207328548779706e-03,   4.582352252078151e-05,  -6.546350766158547e-07,   9.349072409993614e-09,  -1.333154731169450e-10,   1.889333666345894e-12,  -2.619806058653218e-14,
   3.388076040557421e-16,  -3.467721935073826e-18,   2.244872908289277e-01,  -3.207549948275675e-03,   4.582984575834952e-05,  -6.547853590179762e-07,   9.352267085634454e-09,
  -1.333774775486507e-10,   1.890401837566523e-12,  -2.621205819225128e-14,   3.388206295177544e-16,  -3.459465320662774e-18,   2.244892317219273e-01,  -3.207633090368436e-03,
   4.583222038302282e-05,  -6.548417975702978e-07,   9.353466873427835e-09,  -1.334007636724342e-10,   1.890802949610134e-12,  -2.621731152885193e-14,   3.388253456530033e-16,
  -3.456357802897530e-18,   2.244895534559716e-01,  -3.207646872591487e-03,   4.583261402086983e-05,  -6.548511533855777e-07,   9.353665763622077e-09,  -1.334046238307156e-10,
   1.890869439835031e-12,  -2.621818219126840e-14,   3.388261181792561e-16,  -3.455842313836111e-18,   4.908811492130716e-01,  -7.011205586374782e-03,   1.001196753590404e-04,
  -1.429344099195712e-06,   2.039495804770381e-08,  -2.904577149605643e-10,   4.106158743281050e-12,  -5.654475585826505e-14,   7.137578351031953e-16,  -6.505746032330765e-18,
   4.908954320988681e-01,  -7.011817270518288e-03,   1.001371393422232e-04,  -1.429758873392192e-06,   2.040375680113906e-08,  -2.906272112209608e-10,   4.108996893553900e-12,
  -5.657709929727720e-14,   7.134811204797662e-16,  -6.469323144939272e-18,   4.909188815725095e-01,  -7.012821577390462e-03,   1.001658147387260e-04,  -1.430439966937468e-06,
   2.041820575499484e-08,  -2.909055359855082e-10,   4.113655335845270e-12,  -5.663005906034984e-14,   7.130192126255537e-16,  -6.409217147455981e-18,   4.909437657300447e-01,
  -7.013887399082797e-03,   1.001962489480718e-04,  -1.431162897133137e-06,   2.043354315858530e-08,  -2.912009539866629e-10,   4.118597148400974e-12,  -5.668606632045905e-14,
   7.125186882320690e-16,  -6.345015217152801e-18,   4.909633514695610e-01,  -7.014726332708437e-03,   1.002202061878773e-04,  -1.431732018842020e-06,   2.044561808090405e-08,
  -2.914335173735634e-10,   4.122485535197024e-12,  -5.673000833005108e-14,   7.121172189858537e-16,  -6.294179688570711e-18,   4.909746554951278e-01,  -7.015210548365145e-03,
   1.002340345272314e-04,  -1.432060539003690e-06,   2.045258848019904e-08,  -2.915677614137806e-10,   4.124729257113612e-12,  -5.675531344245066e-14,   7.118824883949731e-16,
  -6.264717713170458e-18,   4.909789004037773e-01,  -7.015392385734779e-03,   1.002392276121683e-04,  -1.432183914614189e-06,   2.045520626056335e-08,  -2.916181765145980e-10,
   4.125571731960300e-12,  -5.676480540883550e-14,   7.117937702911066e-16,  -6.253631022313661e-18,   4.909796040652499e-01,  -7.015422528386751e-03,   1.002400884617488e-04,
  -1.432204366574653e-06,   2.045564021233257e-08,  -2.916265338096320e-10,   4.125711380784559e-12,  -5.676637829137742e-14,   7.117790336716610e-16,  -6.251792008118576e-18,
   7.855704852862837e-03,  -1.061394896258306e-04,   1.433806311505553e-06,  -1.936519466079117e-08,   2.614848325104290e-10,  -3.528873642739566e-12,   4.753818192180729e-14,
  -6.363447351718249e-16,   8.344550594144791e-18,  -1.028502792100733e-19,   7.855909344189962e-03,  -1.061477748561868e-04,   1.434030156170402e-06,  -1.937023264213013e-08,
   2.615867047894983e-10,  -3.530783760577962e-12,   4.757156859652944e-14,  -6.368722301019525e-16,   8.351160255317804e-18,  -1.028727621833983e-19,   7.856245072925892e-03,
  -1.061613779614987e-04,   1.434397696422767e-06,  -1.937850527232198e-08,   2.617539962118115e-10,  -3.533920668004353e-12,   4.762639719713250e-14,  -6.377382765563187e-16,
   8.361999458750451e-18,  -1.029089944072637e-19,   7.856601338499771e-03,  -1.061758140265248e-04,   1.434787770689318e-06,  -1.938728584834060e-08,   2.619315754714738e-10,
  -3.537250718501683e-12,   4.768460034446899e-14,  -6.386573236156450e-16,   8.373484826595038e-18,  -1.029465168650642e-19,   7.856881744143191e-03,  -1.061871768200066e-04,
   1.435094823215831e-06,  -1.939419814583244e-08,   2.620713820716226e-10,  -3.539872607533044e-12,   4.773042516691663e-14,  -6.393806932935191e-16,   8.382512333609839e-18,
  -1.029753773151958e-19,   7.857043580849378e-03,  -1.061937351254901e-04,   1.435272054102035e-06,  -1.939818814490668e-08,   2.621520875576178e-10,  -3.541386200655829e-12,
   4.775687903490372e-14,  -6.397981937082788e-16,   8.387717642585056e-18,  -1.029917641022693e-19,   7.857104353866905e-03,  -1.061961979506990e-04,   1.435338610763208e-06,
  -1.939968657612135e-08,   2.621823971194967e-10,  -3.541954654923993e-12,   4.776681413612983e-14,  -6.399549748227882e-16,   8.389671408492061e-18,  -1.029978665607912e-19,
   7.857114427955459e-03,  -1.061966062053645e-04,   1.435349643730488e-06,  -1.939993497029279e-08,   2.621874215663055e-10,  -3.542048888839842e-12,   4.776846109577579e-14,
  -6.399809638287658e-16,   8.389995226716771e-18,  -1.029988754414103e-19,   7.239709647088562e-02,  -9.781669492485146e-04,   1.321376140935475e-05,  -1.784668977017003e-07,
   2.409800398820717e-09,  -3.252095699582025e-11,   4.380599669004379e-13,  -5.861802977932371e-15,   7.676688996396368e-17,  -9.418178820419949e-19,   7.239898103476591e-02,
  -9.782433047572721e-04,   1.321582432370200e-05,  -1.785133260375144e-07,   2.410739136007914e-09,  -3.253855189380827e-11,   4.383670807155670e-13,  -5.866631481440813e-15,
   7.682618164003478e-17,  -9.419550470830912e-19,   7.240207506451297e-02,  -9.783686690476362e-04,   1.321921151207186e-05,  -1.785895637969785e-07,   2.412280699562419e-09,
  -3.256744719908683e-11,   4.388714278345159e-13,  -5.874558708428378e-15,   7.692339884780357e-17,  -9.421734668251467e-19,   7.240535835892624e-02,  -9.785017097762186e-04,
   1.322280636999118e-05,  -1.786704826015684e-07,   2.413917062724711e-09,  -3.259812153078292e-11,   4.394068100827221e-13,  -5.882970716257436e-15,   7.702639052221062e-17,
  -9.423960177785081e-19,   7.240794253867779e-02,  -9.786064276696485e-04,   1.322563611364880e-05,  -1.787341839776949e-07,   2.415205356308318e-09,  -3.262227265783326e-11,
   4.398283258076984e-13,  -5.889591439439671e-15,   7.710732676913914e-17,  -9.425644803949394e-19,   7.240943400345000e-02,  -9.786668680828575e-04,   1.322726944320976e-05,
  -1.787709544448969e-07,   2.415949043032272e-09,  -3.263621486110170e-11,   4.400716577003323e-13,  -5.893412556549565e-15,   7.715398889390100e-17,  -9.426590172674921e-19,
   7.240999407920085e-02,  -9.786895651306699e-04,   1.322788281802067e-05,  -1.787847634739803e-07,   2.416228340199355e-09,  -3.264145107497385e-11,   4.401630438893380e-13,
  -5.894847455402547e-15,   7.717150193741975e-17,  -9.426940083622579e-19,   7.241008692061207e-02,  -9.786933275477614e-04,   1.322798449596069e-05,  -1.787870525895918e-07,
   2.416274639570588e-09,  -3.264231909341151e-11,   4.401781931251118e-13,  -5.895085312071295e-15,   7.717440449723100e-17,  -9.426997817969242e-19,   2.123077672579931e-01,
  -2.868518902531389e-03,   3.874995050669960e-05,  -5.233617303661024e-07,   7.066792416031106e-09,  -9.536444912537282e-11,   1.284302537125310e-12,  -1.717064439395154e-14,
   2.241324100126024e-16,  -2.717470873352329e-18,   2.123132938263520e-01,  -2.868742818266987e-03,   3.875600004402221e-05,  -5.234978763073408e-07,   7.069544554646347e-09,
  -9.541598521395087e-11,   1.285198965674677e-12,  -1.718456226585053e-14,   2.242942336238595e-16,  -2.717348062003589e-18,   2.123223672077688e-01,  -2.869110454310208e-03,
   3.876593304077061e-05,  -5.237214350122744e-07,   7.074064020578819e-09,  -9.550062010631855e-11,   1.286671061751008e-12,  -1.720741007102692e-14,   2.245594472816914e-16,
  -2.717122652373709e-18,   2.123319956163251e-01,  -2.869500601827537e-03,   3.877647503193783e-05,  -5.239587202736371e-07,   7.078861405965015e-09,  -9.559046512521659e-11,
   1.288233698739536e-12,  -1.723165244777504e-14,   2.248402510550880e-16,  -2.716851052756304e-18,   2.123395738396822e-01,  -2.869807691440404e-03,   3.878477331010567e-05,
  -5.241455173075674e-07,   7.082638336937924e-09,  -9.566120320811717e-11,   1.289463957314867e-12,  -1.725073062813112e-14,   2.250608027993411e-16,  -2.716613762154278e-18,
   2.123439476272101e-01,  -2.869984935485230e-03,   3.878956308054159e-05,  -5.242533424919805e-07,   7.084818624304919e-09,  -9.570203939628248e-11,   1.290174145818981e-12,
  -1.726174072681374e-14,   2.251879096370996e-16,  -2.716467359442162e-18,   2.123455900745401e-01,  -2.870051495529011e-03,   3.879136181396835e-05,  -5.242938358837681e-07,
   7.085637447225965e-09,  -9.571737603213357e-11,   1.290440863084372e-12,  -1.726587507160249e-14,   2.252356058258128e-16,  -2.716410593601801e-18,   2.123458623361542e-01,
  -2.870062528974778e-03,   3.879165998648063e-05,  -5.243005484521407e-07,   7.085773184297214e-09,  -9.571991841727972e-11,   1.290485077104114e-12,  -1.726656039539864e-14,
   2.252435103726403e-16,  -2.716401089349258e-18,   4.643369018837759e-01,  -6.273718473712938e-03,   8.474973928036953e-05,  -1.144638250461834e-06,   1.545544799418177e-08,
  -2.085466970353209e-10,   2.807187743726392e-12,  -3.745212073245403e-14,   4.849235561826805e-16,  -5.702656192826441e-18,   4.643489890013290e-01,  -6.274208197040131e-03,
   8.476296991617830e-05,  -1.144935977063416e-06,   1.546146327730951e-08,  -2.086590862482536e-10,   2.809125903763157e-12,  -3.748124697840398e-14,   4.852108153915241e-16,
  -5.699420065456256e-18,   4.643688333279519e-01,  -6.275012249257059e-03,   8.478469386642883e-05,  -1.145424859274076e-06,   1.547134133184820e-08,  -2.088436541896676e-10,
   2.812308525761395e-12,  -3.752904986995283e-14,   4.856808709551260e-16,  -5.694031622255913e-18,   4.643898915503599e-01,  -6.275865536022713e-03,   8.480774971399307e-05,
  -1.145943758517804e-06,   1.548182678069346e-08,  -2.090395804570858e-10,   2.815686643835024e-12,  -3.757975521376238e-14,   4.861775537224874e-16,  -5.688210749002861e-18,
   4.644064658275820e-01,  -6.276537167870361e-03,   8.482589844967034e-05,  -1.146352248964205e-06,   1.549008183103898e-08,  -2.091938372913432e-10,   2.818346042376054e-12,
  -3.761964799658128e-14,   4.865669321265377e-16,  -5.683554667410132e-18,   4.644160317064810e-01,  -6.276924816097014e-03,   8.483637390829406e-05,  -1.146588042500757e-06,
   1.549484716350275e-08,  -2.092828867082747e-10,   2.819881154071372e-12,  -3.764266581488518e-14,   4.867910414203197e-16,  -5.680837406512791e-18,   4.644196238910915e-01,
  -6.277070388732773e-03,   8.484030782474465e-05,  -1.146676593959623e-06,   1.549663681656373e-08,  -2.093163303333172e-10,   2.820457664335909e-12,  -3.765130826828555e-14,
   4.868750814316590e-16,  -5.679811341703130e-18,   4.644202193524876e-01,  -6.277094519843384e-03,   8.484095994234940e-05,  -1.146691273087324e-06,   1.549693348895771e-08,
  -2.093218743399358e-10,   2.820553232357152e-12,  -3.765274082755077e-14,   4.868890061806342e-16,  -5.679640955530766e-18,   7.452709851973736e-03,  -9.553243376269909e-05,
   1.224382928341259e-06,  -1.568962353589141e-08,   2.010157358829395e-10,  -2.574738418339612e-12,   3.295728346040979e-14,  -4.209387689862684e-16,   5.336899658143318e-18,
  -6.612673561496351e-20,   7.452884436626496e-03,  -9.553914499334210e-05,   1.224554964599204e-06,  -1.569329824969284e-08,   2.010863408022970e-10,  -2.576001815092343e-12,
   3.297865082779048e-14,  -4.212790295755911e-16,   5.341810960516079e-18,  -6.618230906523966e-20,   7.453171063357402e-03,  -9.555016370135718e-05,   1.224837433622286e-06,
  -1.569933218907285e-08,   2.012022832290490e-10,  -2.578076621329764e-12,   3.301374296787275e-14,  -4.218378272969757e-16,   5.349874134420482e-18,  -6.627342259785901e-20,
   7.453475220624373e-03,  -9.556185694740719e-05,   1.225137214441829e-06,  -1.570573643502320e-08,   2.013253520010224e-10,  -2.580279151644289e-12,   3.305099767050343e-14,
  -4.224310330960531e-16,   5.358430416450955e-18,  -6.636993830597944e-20,   7.453714611481268e-03,  -9.557106071247346e-05,   1.225373186505685e-06,  -1.571077789204484e-08,
   2.014222402870066e-10,  -2.582013279187876e-12,   3.308033124075803e-14,  -4.228980904295378e-16,   5.365164699959077e-18,  -6.644577827442869e-20,   7.453852775637286e-03,
  -9.557637283386950e-05,   1.225509387830960e-06,  -1.571368792939559e-08,   2.014781694485048e-10,  -2.583014368627062e-12,   3.309726579917842e-14,  -4.231677189579847e-16,
   5.369051360742005e-18,  -6.648949936583906e-20,   7.453904658977064e-03,  -9.557836767307449e-05,   1.225560536040531e-06,  -1.571478077450736e-08,   2.014991738693166e-10,
  -2.583390342585819e-12,   3.310362594923088e-14,  -4.232689823797800e-16,   5.370510872926382e-18,  -6.650590804543294e-20,   7.453913259453196e-03,  -9.557869835070002e-05,
   1.225569014760251e-06,  -1.571496193435277e-08,   2.015026557827421e-10,  -2.583452668548529e-12,   3.310468029079476e-14,  -4.232857690445748e-16,   5.370752809659923e-18,
  -6.650862754232391e-20,   6.868314992333641e-02,  -8.804137820521240e-04,   1.128374472858644e-05,  -1.445934008450990e-07,   1.852531942662603e-09,  -2.372831234539629e-11,
   3.037211758424680e-13,  -3.878800060683644e-15,   4.915755020093466e-17,  -6.082053549580332e-19,   6.868475887149009e-02,  -8.804756318249982e-04,   1.128533018974295e-05,
  -1.446272663133778e-07,   1.853182608146177e-09,  -2.373995399457643e-11,   3.039179816585110e-13,  -3.881929258427596e-15,   4.920247833749928e-17,  -6.087027090086978e-19,
   6.868740038402954e-02,  -8.805771787131836e-04,   1.128793338320489e-05,  -1.446828739572892e-07,   1.854251085016398e-09,  -2.375907241414871e-11,   3.042411996696326e-13,
  -3.887068175545019e-15,   4.927623679406475e-17,  -6.095179793521343e-19,   6.869020345557862e-02,  -8.806849420504670e-04,   1.129069611965013e-05,  -1.447418942742311e-07,
   1.855385235070948e-09,  -2.377936773597743e-11,   3.045843348473509e-13,  -3.892523451948899e-15,   4.935450230074891e-17,  -6.103813836953702e-19,   6.869240964879803e-02,
  -8.807697626754815e-04,   1.129287080386848e-05,  -1.447883553850310e-07,   1.856278116607818e-09,  -2.379534692444847e-11,   3.048545113845792e-13,  -3.896818582681070e-15,
   4.941609905007931e-17,  -6.110596799023502e-19,   6.869368295066139e-02,  -8.808187184510254e-04,   1.129412601546683e-05,  -1.448151737361262e-07,   1.856793536079381e-09,
  -2.380457149822485e-11,   3.050104865958615e-13,  -3.899298107308922e-15,   4.945164825249907e-17,  -6.114506521152033e-19,   6.869416110038647e-02,  -8.808371026130316e-04,
   1.129459738992395e-05,  -1.448252451888265e-07,   1.856987103915437e-09,  -2.380803592244266e-11,   3.050690664874701e-13,  -3.900229329603930e-15,   4.946499742374774e-17,
  -6.115973740409770e-19,   6.869424036119187e-02,  -8.808401500922589e-04,   1.129467552857115e-05,  -1.448269147235001e-07,   1.857019191752518e-09,  -2.380861022699034e-11,
   3.050787774520212e-13,  -3.900383700208793e-15,   4.946721024470606e-17,  -6.116216904403498e-19,   2.014164506849725e-01,  -2.581853323493563e-03,   3.309009224268799e-05,
  -4.240266051642415e-07,   5.432623533543329e-09,  -6.958347256522647e-11,   8.906143126452789e-13,  -1.137105593769405e-14,   1.439642654877399e-16,  -1.774782301584019e-18,
   2.014211689982526e-01,  -2.582034700709860e-03,   3.309474166974155e-05,  -4.241259158335798e-07,   5.434531497849573e-09,  -6.961760039430353e-11,   8.911906364643924e-13,
  -1.138018437151197e-14,   1.440935711988403e-16,  -1.776131445195820e-18,   2.014289153533256e-01,  -2.582332491486124e-03,   3.310237563662755e-05,  -4.242889855388215e-07,
   5.437664620761016e-09,  -6.967364649169761e-11,   8.921371376273007e-13,  -1.139517513545052e-14,   1.443058318720598e-16,  -1.778341829914592e-18,   2.014371354875049e-01,
  -2.582648512275887e-03,   3.311047746944677e-05,  -4.244620629090954e-07,   5.440990317214579e-09,  -6.973314257089613e-11,   8.931419545364899e-13,  -1.141108822993219e-14,
   1.445310351294447e-16,  -1.780681143754371e-18,   2.014436052489676e-01,  -2.582897252538901e-03,   3.311685481599406e-05,  -4.245983103335539e-07,   5.443608534771857e-09,
  -6.977998573415188e-11,   8.939331170788575e-13,  -1.142361678828682e-14,   1.447082551160749e-16,  -1.782517779063239e-18,   2.014473392643081e-01,  -2.583040817532297e-03,
   3.312053577307687e-05,  -4.246769552686288e-07,   5.445119910938600e-09,  -6.980702763221981e-11,   8.943898592992245e-13,  -1.143084921381279e-14,   1.448105256151301e-16,
  -1.783575960614272e-18,   2.014487414600165e-01,  -2.583094729906601e-03,   3.312191809709343e-05,  -4.247064898480139e-07,   5.445687514187266e-09,  -6.981718360690466e-11,
   8.945613982994782e-13,  -1.143356542971068e-14,   1.448489279360924e-16,  -1.783972981791141e-18,   2.014489738959154e-01,  -2.583103666775232e-03,   3.312214724172960e-05,
  -4.247113857657466e-07,   5.445781606057060e-09,  -6.981886718279390e-11,   8.945898348083062e-13,  -1.143401570079203e-14,   1.448552936031446e-16,  -1.784038775963620e-18,
   4.405165762178850e-01,  -5.646754172178156e-03,   7.237111672066653e-05,  -9.273852782873059e-07,   1.188160298951534e-08,  -1.521811242464591e-10,   1.947542458860023e-12,
  -2.485054228999814e-14,   3.138623081762191e-16,  -3.835200046091680e-18,   4.405268956088202e-01,  -5.647150860848342e-03,   7.238128540330075e-05,  -9.276024731752548e-07,
   1.188577516386487e-08,  -1.522557040675314e-10,   1.948798669698595e-12,  -2.487025309608599e-14,   3.141319853177446e-16,  -3.837554194325618e-18,   4.405438376093934e-01,
  -5.647802156689377e-03,   7.239798152166529e-05,  -9.279591105883208e-07,   1.189262640464200e-08,  -1.523781815338569e-10,   1.950861718982438e-12,  -2.490262018058069e-14,
   3.145745562631673e-16,  -3.841404132478900e-18,   4.405618158090245e-01,  -5.648493323245130e-03,   7.241570090099422e-05,  -9.283376349237739e-07,   1.189989873978511e-08,
  -1.525081975266544e-10,   1.953051827988854e-12,  -2.493697582525744e-14,   3.150439557565306e-16,  -3.845469058068738e-18,   4.405759657803706e-01,  -5.649037341093786e-03,
   7.242964868558730e-05,  -9.286356112281525e-07,   1.190562401711022e-08,  -1.526105627508966e-10,   1.954776218418838e-12,  -2.496402232108945e-14,   3.154132276719699e-16,
  -3.848653524758750e-18,   4.405841324199543e-01,  -5.649351330946844e-03,   7.243769924312928e-05,  -9.288076095161093e-07,   1.190892895294620e-08,  -1.526696565436800e-10,
   1.955771703695277e-12,  -2.497963475115564e-14,   3.156262819641142e-16,  -3.850485450955082e-18,   4.405871991526617e-01,  -5.649469242270916e-03,   7.244072250003277e-05,
  -9.288722023181372e-07,   1.191017013408280e-08,  -1.526918500299988e-10,   1.956145576115122e-12,  -2.498549800962393e-14,   3.157062746228145e-16,  -3.851172241592075e-18,
   4.405877075116372e-01,  -5.649488788025051e-03,   7.244122365829411e-05,  -9.288829098021826e-07,   1.191037588526503e-08,  -1.526955290857696e-10,   1.956207553869240e-12,
  -2.498646996215504e-14,   3.157195339511134e-16,  -3.851286028048743e-18,   7.089050191687134e-03,  -8.643944895081072e-05,   1.053834669587323e-06,  -1.284603996612915e-08,
   1.565671492840090e-10,  -1.907904102692464e-12,   2.324271600324184e-14,  -2.829307279803426e-16,   3.435308745949883e-18,  -4.136401796427838e-20,   7.089200429509515e-03,
  -8.644494282731823e-05,   1.053968635633599e-06,  -1.284876222451103e-08,   1.566169268888581e-10,  -1.908753034783112e-12,   2.325646927324794e-14,  -2.831437572510389e-16,
   3.438435251225580e-18,  -4.140568282776974e-20,   7.089447083041999e-03,  -8.645396275671630e-05,   1.054188593358654e-06,  -1.285323212696848e-08,   1.566986661398514e-10,
  -1.910147155119581e-12,   2.327905650830300e-14,  -2.834936335846245e-16,   3.443569904493938e-18,  -4.147408491838297e-20,   7.089708820305653e-03,  -8.646353474345031e-05,
   1.054422027344499e-06,  -1.285797622809046e-08,   1.567854267002142e-10,  -1.911627051162810e-12,   2.330303556787835e-14,  -2.838650891411163e-16,   3.449020868771556e-18,
  -4.154666802739444e-20,   7.089914822522600e-03,  -8.647106877609450e-05,   1.054605771416923e-06,  -1.286171072178836e-08,   1.568537286459376e-10,  -1.912792190960225e-12,
   2.332191609101775e-14,  -2.841575784669170e-16,   3.453312759247413e-18,  -4.160379351078712e-20,   7.090033715888350e-03,  -8.647541714591583e-05,   1.054711825861357e-06,
  -1.286386631640190e-08,   1.568931554257296e-10,  -1.913464797888334e-12,   2.333281596938027e-14,  -2.843264406468587e-16,   3.455790475291146e-18,  -4.163676258309636e-20,
   7.090078362561149e-03,  -8.647705006482867e-05,   1.054751652656019e-06,  -1.286467582888301e-08,   1.569079621598817e-10,  -1.913717402877617e-12,   2.333690965492784e-14,
  -2.843898615798864e-16,   3.456721030048431e-18,  -4.164914295122228e-20,   7.090085763440656e-03,  -8.647732074782509e-05,   1.054758254638445e-06,  -1.286481002060735e-08,
   1.569104166716971e-10,  -1.913759277585185e-12,   2.333758827740089e-14,  -2.844003751142887e-16,   3.456875290611319e-18,  -4.165119518243393e-20,   6.533171246529997e-02,
  -7.966140838688160e-04,   9.711995490974771e-06,  -1.183873366963757e-07,   1.442901070065996e-09,  -1.758295950435186e-11,   2.142000794549412e-13,  -2.607354212261655e-15,
   3.165426604586830e-17,  -3.809707250728505e-19,   6.533309703642401e-02,  -7.966647146786235e-04,   9.713230103402776e-06,  -1.184124246208518e-07,   1.443359809964130e-09,
  -1.759078283681492e-11,   2.143268061278325e-13,  -2.609316178977963e-15,   3.168301341364095e-17,  -3.813517089990497e-19,   6.533537016148203e-02,  -7.967478411065919e-04,
   9.715257203165978e-06,  -1.184536185703886e-07,   1.444113101613498e-09,  -1.760363034812073e-11,   2.145349313721849e-13,  -2.612538475683372e-15,   3.173022463106724e-17,
  -3.819771534749495e-19,   6.533778229613350e-02,  -7.968360552189766e-04,   9.717408498268811e-06,  -1.184973394931949e-07,   1.444912668543738e-09,  -1.761726832154621e-11,
   2.147558810411057e-13,  -2.615959498956534e-15,   3.178034349236663e-17,  -3.826407937136428e-19,   6.533968078425414e-02,  -7.969054878269342e-04,   9.719101858047678e-06,
  -1.185317560254324e-07,   1.445542124762687e-09,  -1.762800565797901e-11,   2.149298512112466e-13,  -2.618653250513341e-15,   3.181980473457104e-17,  -3.831630774390272e-19,
   6.534077648917344e-02,  -7.969455618047472e-04,   9.720079241034990e-06,  -1.185516216610553e-07,   1.445905473574888e-09,  -1.763420406065837e-11,   2.150302855228436e-13,
  -2.620208423694117e-15,   3.184258557067611e-17,  -3.834644953268555e-19,   6.534118794677420e-02,  -7.969606105607107e-04,   9.720446279226847e-06,  -1.185590820062563e-07,
   1.446041929283382e-09,  -1.763653193930827e-11,   2.150680057917052e-13,  -2.620792511868689e-15,   3.185114131989503e-17,  -3.835776802647111e-19,   6.534125615226263e-02,
  -7.969631051379518e-04,   9.720507122177244e-06,  -1.185603186969919e-07,   1.446064549541396e-09,  -1.763691783522951e-11,   2.150742587925567e-13,  -2.620889338392875e-15,
   3.185255962734105e-17,  -3.835964422619521e-19,   1.915882084187653e-01,  -2.336106912463608e-03,   2.848086691967938e-05,  -3.471762142185753e-07,   4.231370932272990e-09,
  -5.156266597471980e-11,   6.281400736864578e-13,  -7.645494841930167e-15,   9.279119947454258e-17,  -1.115523543537410e-18,   1.915922687363311e-01,  -2.336255389600272e-03,
   2.848448747485033e-05,  -3.472497854481235e-07,   4.232716181695258e-09,  -5.158560604197864e-11,   6.285115504439766e-13,  -7.651239146805128e-15,   9.287502294694404e-17,
  -1.116618941594769e-18,   1.915989347785746e-01,  -2.336499161604882e-03,   2.849043203392251e-05,  -3.473705881659268e-07,   4.234925200473001e-09,  -5.162327830310937e-11,
   6.291216313682543e-13,  -7.660673407865192e-15,   9.301268064899280e-17,  -1.118417022126785e-18,   1.916060084727502e-01,  -2.336757853473731e-03,   2.849674080125973e-05,
  -3.474988013193740e-07,   4.237269920641780e-09,  -5.166326837963112e-11,   6.297693029598422e-13,  -7.670689398658712e-15,   9.315881111874194e-17,  -1.120324657292818e-18,
   1.916115758751971e-01,  -2.336961467732482e-03,   2.850170665313853e-05,  -3.475997290159513e-07,   4.239115793014928e-09,  -5.169475301690417e-11,   6.302792618665254e-13,
  -7.678576025598555e-15,   9.327386355539709e-17,  -1.121825778437648e-18,   1.916147890795265e-01,  -2.337078986482325e-03,   2.850457287164295e-05,  -3.476579856932848e-07,
   4.240181308702170e-09,  -5.171292832315683e-11,   6.305736645297048e-13,  -7.683129151328235e-15,   9.334028137584147e-17,  -1.122692024128658e-18,   1.916159956975866e-01,
  -2.337123117638845e-03,   2.850564922724743e-05,  -3.476798634186212e-07,   4.240581463282930e-09,  -5.171975425890237e-11,   6.306842336923532e-13,  -7.684839197550192e-15,
   9.336522547994467e-17,  -1.123017292583482e-18,   1.916161957132722e-01,  -2.337130433099268e-03,   2.850582765186941e-05,  -3.476834900577969e-07,   4.240647796892826e-09,
  -5.172088580439128e-11,   6.307025630652145e-13,  -7.685122678132614e-15,   9.336936050955587e-17,  -1.123071209668333e-18,   4.190212931246405e-01,  -5.109283848435187e-03,
   6.229031354154520e-05,  -7.593066983577023e-07,   9.254393981900270e-09,  -1.127715709964853e-10,   1.373744156203277e-12,  -1.671793302152393e-14,   2.027577143641706e-16,
  -2.431045622225338e-18,   4.190301734180136e-01,  -5.109608581750203e-03,   6.229823202504298e-05,  -7.594676042813285e-07,   9.257336037203170e-09,  -1.128217319019915e-10,
   1.374555819748402e-12,  -1.673044860222888e-14,   2.029385380861595e-16,  -2.433325530991020e-18,   4.190447526743885e-01,  -5.110141733809069e-03,   6.231123331639091e-05,
  -7.597318090820961e-07,   9.262167151565630e-09,  -1.129041062226391e-10,   1.375888818106172e-12,  -1.675100338540997e-14,   2.032354717546054e-16,  -2.437066928956506e-18,
   4.190602235035742e-01,  -5.110707516998892e-03,   6.232503116422759e-05,  -7.600122210578980e-07,   9.267295042647501e-09,  -1.129915485526796e-10,   1.377303941000280e-12,
  -1.677282505581321e-14,   2.035506528061272e-16,  -2.441034866075060e-18,   4.190723999322010e-01,  -5.111152840329780e-03,   6.233589193376135e-05,  -7.602329576406770e-07,
   9.271331954955586e-09,  -1.130603927848601e-10,   1.378418163312453e-12,  -1.679000711780136e-14,   2.037987824085084e-16,  -2.444156210283257e-18,   4.190794275098824e-01,
  -5.111409864771046e-03,   6.234216061418269e-05,  -7.603603694399693e-07,   9.273662231185568e-09,  -1.131001348263033e-10,   1.379061408529870e-12,  -1.679992654511240e-14,
   2.039420150213661e-16,  -2.445957016288498e-18,   4.190820664961649e-01,  -5.111506383716822e-03,   6.234451470172910e-05,  -7.604082176940559e-07,   9.274537366693280e-09,
  -1.131150603786706e-10,   1.379302992395101e-12,  -1.680365201676088e-14,   2.039958063616588e-16,  -2.446633126189237e-18,   4.190825039491322e-01,  -5.111522383309480e-03,
   6.234490493259560e-05,  -7.604161494305185e-07,   9.274682437868929e-09,  -1.131175346092205e-10,   1.379343040430445e-12,  -1.680426960014263e-14,   2.040047233662362e-16,
  -2.446745195232613e-18,   6.759233982659729e-03,  -7.858551087202071e-05,   9.135447392878831e-07,  -1.061840813675989e-08,   1.234044458336321e-10,  -1.433974146912804e-12,
   1.666007254196559e-14,  -1.934968258508656e-16,   2.245343731257541e-18,  -2.597715201609790e-20,   6.759364199089938e-03,  -7.859005133221158e-05,   9.136503095941770e-07,
  -1.062045368957675e-08,   1.234401154026707e-10,  -1.434554542701120e-12,   1.666905919349304e-14,  -1.936306118280306e-16,   2.247262253563757e-18,  -2.600333142719937e-20,
   6.759577981332290e-03,  -7.859750586503009e-05,   9.138236423902528e-07,  -1.062381239355748e-08,   1.234986866612909e-10,  -1.435507645786770e-12,   1.668381777085504e-14,
  -1.938503402404754e-16,   2.250413323120416e-18,  -2.604632678055155e-20,   6.759804835627532e-03,  -7.860541656036770e-05,   9.140075918605005e-07,  -1.062737705095213e-08,
   1.235608541738625e-10,  -1.436519355355467e-12,   1.669948528638246e-14,  -1.940836210439587e-16,   2.253758896513487e-18,  -2.609197208492342e-20,   6.759983381876442e-03,
  -7.861164294182741e-05,   9.141523827683729e-07,  -1.063018304373723e-08,   1.236097940065951e-10,  -1.437315861122289e-12,   1.671182115312240e-14,  -1.942673098445598e-16,
   2.256393361054528e-18,  -2.612791247103435e-20,   6.760086428708123e-03,  -7.861523655794185e-05,   9.142359531355803e-07,  -1.063180267306009e-08,   1.236380436233700e-10,
  -1.437775654455820e-12,   1.671894260816649e-14,  -1.943733585668056e-16,   2.257914355601718e-18,  -2.614866129514111e-20,   6.760125124630908e-03,  -7.861658604371163e-05,
   9.142673362845847e-07,  -1.063241090459109e-08,   1.236486526717421e-10,  -1.437948333028464e-12,   1.672161719843662e-14,  -1.944131881611966e-16,   2.258485616365839e-18,
  -2.615645399289640e-20,   6.760131539076873e-03,  -7.861680974278347e-05,   9.142725385775338e-07,  -1.063251173002720e-08,   1.236504113280416e-10,  -1.437976958113345e-12,
   1.672206057185132e-14,  -1.944197908687935e-16,   2.258580316932777e-18,  -2.615774581307393e-20,   6.229217160287091e-02,  -7.242332698060711e-04,   8.419102784751674e-06,
  -9.785778988605724e-08,   1.137278368948216e-09,  -1.321530464895945e-11,   1.535366494384645e-13,  -1.783222447549624e-15,   2.069183752205544e-17,  -2.393576992198954e-19,
   6.229337165959826e-02,  -7.242751140630811e-04,   8.420075706144257e-06,  -9.787664141349603e-08,   1.137607094128295e-09,  -1.322065343996278e-11,   1.536194651662431e-13,
  -1.784455158656999e-15,   2.070950568579399e-17,  -2.395983808016481e-19,   6.229534184736726e-02,  -7.243438140128716e-04,   8.421673117302893e-06,  -9.790759475755546e-08,
   1.138146877698419e-09,  -1.322943701320594e-11,   1.537554715541430e-13,  -1.786479745906306e-15,   2.073852458985968e-17,  -2.399936557775592e-19,   6.229743250537941e-02,
  -7.244167178937334e-04,   8.423368370266859e-06,  -9.794044613926601e-08,   1.138719803774897e-09,  -1.323876068928551e-11,   1.538998541354709e-13,  -1.788629202718790e-15,
   2.076933458242775e-17,  -2.404132864695379e-19,   6.229907796307473e-02,  -7.244740993694128e-04,   8.424702743316800e-06,  -9.796630577447048e-08,   1.139170825615989e-09,
  -1.324610109752988e-11,   1.540135341724403e-13,  -1.790321715216699e-15,   2.079359574221075e-17,  -2.407436923210344e-19,   6.230002762851550e-02,  -7.245072176415587e-04,
   8.425472916302035e-06,  -9.798123205069350e-08,   1.139431169661684e-09,  -1.325033844364394e-11,   1.540791612677480e-13,  -1.791298849581627e-15,   2.080760275685244e-17,
  -2.409344377771428e-19,   6.230038424482254e-02,  -7.245196543169177e-04,   8.425762139077524e-06,  -9.798683742700031e-08,   1.139528940990166e-09,  -1.325192980830255e-11,
   1.541038086987643e-13,  -1.791665839851652e-15,   2.081286355549197e-17,  -2.410060762611201e-19,   6.230044335947514e-02,  -7.245217158968149e-04,   8.425810082692276e-06,
  -9.798776662004894e-08,   1.139545148491203e-09,  -1.325219361027510e-11,   1.541078945639549e-13,  -1.791726677255587e-15,   2.081373566226032e-17,  -2.410179519806170e-19,
   1.826746170524767e-01,  -2.123846894533369e-03,   2.468940054971237e-05,  -2.869724018814729e-07,   3.335120042181936e-09,  -3.875445143144711e-11,   4.502511349955013e-13,
  -5.229254984763402e-15,   6.067304304737762e-17,  -7.016114042482452e-19,   1.826781362732270e-01,  -2.123969604712477e-03,   2.469225368549204e-05,  -2.870276847962346e-07,
   3.336084038956212e-09,  -3.877013660002448e-11,   4.504939672332352e-13,  -5.232868233264846e-15,   6.072476460266719e-17,  -7.023129913975935e-19,   1.826839139381661e-01,
  -2.124171070427136e-03,   2.469693816561901e-05,  -2.871184568081567e-07,   3.337666970954368e-09,  -3.879589416048994e-11,   4.508927648497777e-13,  -5.238802566722466e-15,
   6.080971341721050e-17,  -7.034651838681501e-19,   1.826900448875540e-01,  -2.124384864360068e-03,   2.470190957124023e-05,  -2.872147948965095e-07,   3.339347094317315e-09,
  -3.882323555110641e-11,   4.513161227809608e-13,  -5.245102889415859e-15,   6.089990436935380e-17,  -7.046883239133444e-19,   1.826948702668323e-01,  -2.124553138136675e-03,
   2.470582268026721e-05,  -2.872906293874165e-07,   3.340669729712856e-09,  -3.884476106678852e-11,   4.516494546074917e-13,  -5.250063837504858e-15,   6.097092399524119e-17,
  -7.056513569628864e-19,   1.826976552037846e-01,  -2.124650258969877e-03,   2.470808124720951e-05,  -2.873344013333582e-07,   3.341433196602224e-09,  -3.885718694919316e-11,
   4.518418858278394e-13,  -5.252927924464100e-15,   6.101192639093633e-17,  -7.062073084342941e-19,   1.826987009972700e-01,  -2.124686730083701e-03,   2.470892940601542e-05,
  -2.873508393400353e-07,   3.341719914014845e-09,  -3.886185357505326e-11,   4.519141568002292e-13,  -5.254003611701698e-15,   6.102732614303981e-17,  -7.064161051366684e-19,
   1.826988743536684e-01,  -2.124692775760131e-03,   2.470907000282342e-05,  -2.873535642385421e-07,   3.341767443007419e-09,  -3.886262716586884e-11,   4.519261373358751e-13,
  -5.254181932498990e-15,   6.102987902772712e-17,  -7.064507178343391e-19,   3.995264368885194e-01,  -4.645051380850203e-03,   5.399802321312823e-05,  -6.276354119456171e-07,
   7.294217205164802e-09,  -8.475946291868271e-11,   9.847311656271713e-13,  -1.143624504579612e-14,   1.326640264232747e-16,  -1.532893208338223e-18,   3.995341337527388e-01,
  -4.645319759457667e-03,   5.400426328586799e-05,  -6.277563206244394e-07,   7.296325532825202e-09,  -8.479376584113648e-11,   9.852621188263423e-13,  -1.144413878711967e-14,
   1.327766800884198e-16,  -1.534405791909189e-18,   3.995467700451731e-01,  -4.645760383767212e-03,   5.401450867864143e-05,  -6.279548471306670e-07,   7.299787514436999e-09,
  -8.485009671876160e-11,   9.861340893754068e-13,  -1.145710324782929e-14,   1.329617014086824e-16,  -1.536889670071871e-18,   3.995601790036676e-01,  -4.646227971039931e-03,
   5.402538160407855e-05,  -6.281655471409160e-07,   7.303462059979531e-09,  -8.490989135213900e-11,   9.870597592804510e-13,  -1.147086716429728e-14,   1.331581348757880e-16,
  -1.539526242386708e-18,   3.995707325584874e-01,  -4.646596001484855e-03,   5.403393993664030e-05,  -6.283314039488288e-07,   7.306354754493248e-09,  -8.495696685899609e-11,
   9.877885863097697e-13,  -1.148170495835145e-14,   1.333128097848041e-16,  -1.541601949867483e-18,   3.995768234755118e-01,  -4.646808413805841e-03,   5.403887963212259e-05,
  -6.284271371050865e-07,   7.308024508965940e-09,  -8.498414179703870e-11,   9.882093349258423e-13,  -1.148796187408623e-14,   1.334021080550949e-16,  -1.542800165543001e-18,
   3.995791107234651e-01,  -4.646888179533547e-03,   5.404073463413334e-05,  -6.284630884940667e-07,   7.308651579604150e-09,  -8.499434753110931e-11,   9.883673544664286e-13,
  -1.149031182646192e-14,   1.334356465581575e-16,  -1.543250161085254e-18,   3.995794898700871e-01,  -4.646901401991799e-03,   5.404104213239862e-05,  -6.284690480905031e-07,
   7.308755528768540e-09,  -8.499603934486058e-11,   9.883935497466037e-13,  -1.149070138677314e-14,   1.334412063676511e-16,  -1.543324757115024e-18,   6.458746336913970e-03,
  -7.175531762388063e-05,   7.970899134306645e-07,  -8.853354462151281e-09,   9.832310131772394e-11,  -1.091816740887279e-12,   1.212234309460182e-14,  -1.345698405376156e-16,
   1.493333060079858e-18,  -1.655309187246971e-20,   6.458859937789061e-03,  -7.175910281795282e-05,   7.971740130779316e-07,  -8.854911605752153e-09,   9.834904880391487e-11,
  -1.092220259506419e-12,   1.212831790491405e-14,  -1.346550667750808e-16,   1.494511207890973e-18,  -1.656885908215994e-20,   6.459046440690480e-03,  -7.176531730810559e-05,
   7.973120922999468e-07,  -8.857468324679749e-09,   9.839165503455232e-11,  -1.092882885012018e-12,   1.213812992176324e-14,  -1.347950379257218e-16,   1.496446262357637e-18,
  -1.659475679928444e-20,   6.459244346481530e-03,  -7.177191201694104e-05,   7.974586268302631e-07,  -8.860181766150793e-09,   9.843687608932935e-11,  -1.093586232556470e-12,
   1.214854585072154e-14,  -1.349436376537111e-16,   1.498500774685493e-18,  -1.662225434225038e-20,   6.459400107922207e-03,  -7.177710256137174e-05,   7.975739660649016e-07,
  -8.862317668070109e-09,   9.847247438675914e-11,  -1.094139952317681e-12,   1.215674658826281e-14,  -1.350606440160367e-16,   1.500118606476033e-18,  -1.664390813177867e-20,
   6.459490004320238e-03,  -7.178009831605225e-05,   7.976405369225680e-07,  -8.863550502898603e-09,   9.849302250466845e-11,  -1.094459587611099e-12,   1.216148073617534e-14,
  -1.351281937699263e-16,   1.501052657631513e-18,  -1.665641019980909e-20,   6.459523761958972e-03,  -7.178122328763697e-05,   7.976655361381255e-07,  -8.864013475649093e-09,
   9.850073921618408e-11,  -1.094579627602732e-12,   1.216325870947474e-14,  -1.351535637401052e-16,   1.501403472845619e-18,  -1.666110584160021e-20,   6.459529357804944e-03,
  -7.178140976967434e-05,   7.976696801790620e-07,  -8.864090221645541e-09,   9.850201840791848e-11,  -1.094599526675553e-12,   1.216355344738263e-14,  -1.351577694061429e-16,
   1.501461629167013e-18,  -1.666188426371543e-20,   5.952291874948987e-02,  -6.612871473747264e-04,   7.345871114126411e-06,  -8.159129811485787e-08,   9.061321830237368e-10,
  -1.006203234378859e-11,   1.117177966011898e-13,  -1.240173972719049e-15,   1.376218100850944e-17,  -1.525428934920610e-19,   5.952396567954480e-02,  -6.613220312031388e-04,
   7.346646164911861e-06,  -8.160564853521363e-08,   9.063713113720559e-10,  -1.006575110569321e-11,   1.117728589000063e-13,  -1.240959361380630e-15,   1.377303628931370e-17,
  -1.526880912039061e-19,   5.952568446465691e-02,  -6.613793030903986e-04,   7.347918684035883e-06,  -8.162921090371039e-08,   9.067639643426200e-10,  -1.007185775438934e-11,
   1.118632838903418e-13,  -1.242249242583316e-15,   1.379086557687553e-17,  -1.529265782282269e-19,   5.952750833723298e-02,  -6.614400790207883e-04,   7.349269126118489e-06,
  -8.165421760550630e-08,   9.071807151595745e-10,  -1.007833969063278e-11,   1.119592743683961e-13,  -1.243618638498895e-15,   1.380979550319276e-17,  -1.531797964957416e-19,
   5.952894381326707e-02,  -6.614879143649822e-04,   7.350332076645471e-06,  -8.167390178255719e-08,   9.075087840106719e-10,  -1.008344268153943e-11,   1.120348502150380e-13,
  -1.244696890658859e-15,   1.382470190972967e-17,  -1.533792001401067e-19,   5.952977228611865e-02,  -6.615155228284441e-04,   7.350945584516026e-06,  -8.168526341803778e-08,
   9.076981525452823e-10,  -1.008638838817541e-11,   1.120784788781285e-13,  -1.245319383731437e-15,   1.383330807848017e-17,  -1.534943277983160e-19,   5.953008339187859e-02,
  -6.615258904119762e-04,   7.351175973849130e-06,  -8.168953011095234e-08,   9.077692686619237e-10,  -1.008749465711678e-11,   1.120948642123351e-13,  -1.245553176274063e-15,
   1.383654042128102e-17,  -1.535375684353057e-19,   5.953013496242614e-02,  -6.615276090048064e-04,   7.351214164760582e-06,  -8.169023739145405e-08,   9.077810575111468e-10,
  -1.008767804371886e-11,   1.120975804393333e-13,  -1.245591932855578e-15,   1.383707626217778e-17,  -1.535447366675933e-19,   1.745536575244330e-01,  -1.939254537113385e-03,
   2.154210004140770e-05,  -2.392701798901205e-07,   2.657273646039813e-09,  -2.950736097141204e-11,   3.276171399039327e-13,  -3.636843922383045e-15,   4.035700773788944e-17,
  -4.472812382565268e-19,   1.745567276942779e-01,  -1.939356835521305e-03,   2.154437291291680e-05,  -2.393122631406042e-07,   2.657974899924440e-09,  -2.951826633700702e-11,
   3.277786074085968e-13,  -3.639146793087210e-15,   4.038882445066306e-17,  -4.477062437827988e-19,   1.745617681095341e-01,  -1.939524787926525e-03,   2.154810463284491e-05,
  -2.393813608415627e-07,   2.659126371178128e-09,  -2.953617424179414e-11,   3.280437742341133e-13,  -3.642928904542668e-15,   4.044108175945930e-17,  -4.484043081251906e-19,
   1.745671166985421e-01,  -1.939703016097040e-03,   2.155206486537531e-05,  -2.394546941145100e-07,   2.660348510363168e-09,  -2.955518268608340e-11,   3.283252615143813e-13,
  -3.646944160433274e-15,   4.049656482387169e-17,  -4.491454826105280e-19,   1.745713262970841e-01,  -1.939843295412007e-03,   2.155518201590599e-05,  -2.395124188451983e-07,
   2.661310585969850e-09,  -2.957014733714338e-11,   3.285468838619499e-13,  -3.650105740310151e-15,   4.054025492619291e-17,  -4.497291341748405e-19,   1.745737558312772e-01,
  -1.939924258482450e-03,   2.155698115550423e-05,  -2.395457373500063e-07,   2.661865917102873e-09,  -2.957878569676098e-11,   3.286748226911015e-13,  -3.651930972340651e-15,
   4.056547921742635e-17,  -4.500661085262360e-19,   1.745746681630210e-01,  -1.939954661891064e-03,   2.155765678265111e-05,  -2.395582496180303e-07,   2.662074468083104e-09,
  -2.958202985851301e-11,   3.287228718443803e-13,  -3.652616482791659e-15,   4.057495305709016e-17,  -4.501926717564596e-19,   1.745748193959895e-01,  -1.939959701742433e-03,
   2.155776877922748e-05,  -2.395603237497716e-07,   2.662109039375451e-09,  -2.958256764437603e-11,   3.287308370407374e-13,  -3.652730122169505e-15,   4.057652358014529e-17,
  -4.502136527956015e-19,   3.817651404558802e-01,  -4.241330667182512e-03,   4.711458334162253e-05,  -5.233062124832943e-07,   5.811705197099947e-09,  -6.453532825159563e-11,
   7.165274984755452e-13,  -7.954007144670306e-15,   8.825856781167291e-17,  -9.779589586990071e-19,   3.817718552038732e-01,  -4.241554403347147e-03,   4.711955432348615e-05,
  -5.233982524424022e-07,   5.813238900723842e-09,  -6.455917894994860e-11,   7.168806173950595e-13,  -7.959042159240334e-15,   8.832806909755043e-17,  -9.788844612135300e-19,
   3.817828790624658e-01,  -4.241921730930715e-03,   4.712771594283098e-05,  -5.235493755016291e-07,   5.815757269100797e-09,  -6.459834462443124e-11,   7.174605197429708e-13,
  -7.967311383285274e-15,   8.844222063369099e-17,  -9.804045489353667e-19,   3.817945769258158e-01,  -4.242311532571903e-03,   4.713637734053491e-05,  -5.237097621478243e-07,
   5.818430194373351e-09,  -6.463991724106055e-11,   7.180761135285948e-13,  -7.976090336041816e-15,   8.856341754357965e-17,  -9.820184653208465e-19,   3.818037837107135e-01,
  -4.242618336524602e-03,   4.714319483931357e-05,  -5.238360114690256e-07,   5.820534337819073e-09,  -6.467264583417737e-11,   7.185607864927231e-13,  -7.983002798156831e-15,
   8.865885323728054e-17,  -9.832893395465644e-19,   3.818090973287447e-01,  -4.242795410315131e-03,   4.714712972532234e-05,  -5.239088821183450e-07,   5.821748895532293e-09,
  -6.469153844558371e-11,   7.188405798958623e-13,  -7.986993470534721e-15,   8.871395232685449e-17,  -9.840230718671498e-19,   3.818110926834175e-01,  -4.242861905407014e-03,
   4.714860738487120e-05,  -5.239362476048727e-07,   5.822205014746471e-09,  -6.469863362196761e-11,   7.189456600653335e-13,  -7.988492263911341e-15,   8.873464660636093e-17,
  -9.842986496892855e-19,   3.818114234440342e-01,  -4.242872928032276e-03,   4.714885233182348e-05,  -5.239407839226766e-07,   5.822280625183061e-09,  -6.469980979190104e-11,
   7.189630793970189e-13,  -7.988740723884560e-15,   8.873807719166995e-17,  -9.843443335084822e-19,   6.183841340221520e-03,  -6.577837829682863e-05,   6.996160023258151e-07,
  -7.440258527249614e-09,   7.911666607120625e-11,  -8.412002286384994e-13,   8.942958384880230e-15,  -9.506231524147935e-17,   1.010318838216109e-18,  -1.073234504173985e-20,
   6.183941036786145e-03,  -6.578155894536760e-05,   6.996836640778290e-07,  -7.441458023815188e-09,   7.913580382507195e-11,  -8.414852012501006e-13,   8.946999335304580e-15,
  -9.511755261111094e-17,   1.011052145882420e-18,  -1.074183000601555e-20,   6.184104711813971e-03,  -6.578678086556149e-05,   6.997947536237078e-07,  -7.443427485100558e-09,
   7.916722778904647e-11,  -8.419531494063154e-13,   8.953635324736298e-15,  -9.520826887894386e-17,   1.012256542112815e-18,  -1.075740924530685e-20,   6.184278393159186e-03,
  -6.579232223058118e-05,   6.999126442977414e-07,  -7.445517634770651e-09,   7.920057953124079e-11,  -8.424498410137431e-13,   8.960679498217698e-15,  -9.530457368814950e-17,
   1.013535251476351e-18,  -1.077395108242951e-20,   6.184415088162689e-03,  -6.579668367900000e-05,   7.000054365218515e-07,  -7.447162882509455e-09,   7.922683367440918e-11,
  -8.428408575684933e-13,   8.966225382631192e-15,  -9.538040072811313e-17,   1.014542147062283e-18,  -1.078697760570743e-20,   6.184493980277105e-03,  -6.579920090250397e-05,
   7.000589933970106e-07,  -7.448112503000916e-09,   7.924198791823370e-11,  -8.430665680391381e-13,   8.969426856118586e-15,  -9.542417588901305e-17,   1.015123464567054e-18,
  -1.079449867891787e-20,   6.184523605571294e-03,  -6.580014617262140e-05,   7.000791054185900e-07,  -7.448469116837305e-09,   7.924767895333916e-11,  -8.431513334823878e-13,
   8.970629199126812e-15,  -9.544061652373644e-17,   1.015341796353894e-18,  -1.079732352388470e-20,   6.184528516415326e-03,  -6.580030286613301e-05,   7.000824393205976e-07,
  -7.448528231840495e-09,   7.924862234844551e-11,  -8.431653850383676e-13,   8.970828513019961e-15,  -9.544334193284210e-17,   1.015377990150797e-18,  -1.079779181440656e-20,
   5.698943207446721e-02,  -6.062044958253985e-04,   6.447564943634262e-06,  -6.856840021383085e-08,   7.291283217322527e-10,  -7.752385594198569e-12,   8.241706657870588e-14,
  -8.760806714109732e-16,   9.310929017655739e-18,  -9.890635203571103e-20,   5.699035086430754e-02,  -6.062338082452769e-04,   6.448188505042140e-06,  -6.857945460916503e-08,
   7.293046926212862e-10,  -7.755011860815531e-12,   8.245430729169694e-14,  -8.765897233588331e-16,   9.317686647962550e-18,  -9.899374369299964e-20,   5.699185927087350e-02,
  -6.062819327442334e-04,   6.449212291030032e-06,  -6.859760489343128e-08,   7.295942915208338e-10,  -7.759324403727575e-12,   8.251546344236359e-14,  -8.774257387080034e-16,
   9.328785484210072e-18,  -9.913728602556659e-20,   5.699345989428556e-02,  -6.063330012028090e-04,   6.450298755280307e-06,  -6.861686742524545e-08,   7.299016565571715e-10,
  -7.763901842129190e-12,   8.258038134621468e-14,  -8.783132563682389e-16,   9.340569130897386e-18,  -9.928969720286650e-20,   5.699471965665466e-02,  -6.063731957121249e-04,
   6.451153915665333e-06,  -6.863202980206488e-08,   7.301436111038135e-10,  -7.767505394430524e-12,   8.263149127184211e-14,  -8.790120566749100e-16,   9.349847937640338e-18,
  -9.940971923500455e-20,   5.699544671554060e-02,  -6.063963940980427e-04,   6.451647488466509e-06,  -6.864078137387147e-08,   7.302832705156120e-10,  -7.769585509641484e-12,
   8.266099550542957e-14,  -8.794154760052259e-16,   9.355204929316531e-18,  -9.947901582101947e-20,   5.699571973818104e-02,  -6.064051055775540e-04,   6.451832838093401e-06,
  -6.864406787792684e-08,   7.303357183067606e-10,  -7.770366695764899e-12,   8.267207609342021e-14,  -8.795669881750376e-16,   9.357216913112004e-18,  -9.950504295948495e-20,
   5.699576499584486e-02,  -6.064065496434256e-04,   6.451863562876127e-06,  -6.864461267366355e-08,   7.303444125053707e-10,  -7.770496192882090e-12,   8.267391293624287e-14,
  -8.795921047626539e-16,   9.357550448281780e-18,  -9.950935762469562e-20,   1.671240930020035e-01,  -1.777722164453516e-03,   1.890777647745890e-05,  -2.010799418783561e-07,
   2.138201846440162e-09,  -2.273422131928345e-11,   2.416917205673357e-13,  -2.569142331925891e-15,   2.730450640062629e-17,  -2.900370218185285e-19,   1.671267873948607e-01,
  -1.777808124453556e-03,   1.890960509954551e-05,  -2.011123593924495e-07,   2.138719061921333e-09,  -2.274192295246526e-11,   2.418009297254314e-13,  -2.570635092927461e-15,
   2.732432039436670e-17,  -2.902931562386452e-19,   1.671312108654943e-01,  -1.777949251728253e-03,   1.891260739834995e-05,  -2.011655859216326e-07,   2.139568323580945e-09,
  -2.275456965903312e-11,   2.419802713887179e-13,  -2.573086651857680e-15,   2.735686317639715e-17,  -2.907138602787894e-19,   1.671359047662094e-01,  -1.778099012297985e-03,
   1.891579350399910e-05,  -2.012220741670165e-07,   2.140469685225337e-09,  -2.276799318217741e-11,   2.421706444585885e-13,  -2.575689237160257e-15,   2.739141384728067e-17,
  -2.911605560593653e-19,   1.671395990764641e-01,  -1.778216884518590e-03,   1.891830130058133e-05,  -2.012665385225017e-07,   2.141179227697047e-09,  -2.277856074484650e-11,
   2.423205253437930e-13,  -2.577738421123041e-15,   2.741862008421337e-17,  -2.915123225649499e-19,   1.671417312096061e-01,  -1.778284914836887e-03,   1.891974872518789e-05,
  -2.012922029024611e-07,   2.141588785134526e-09,  -2.278466076666937e-11,   2.424070470990034e-13,  -2.578921420430729e-15,   2.743432722084556e-17,  -2.917154199290929e-19,
   1.671425318608758e-01,  -1.778310461645450e-03,   1.892029227136818e-05,  -2.013018407241771e-07,   2.141742590614965e-09,  -2.278695162650087e-11,   2.424395411443041e-13,
  -2.579365719359649e-15,   2.744022651944638e-17,  -2.917917012729904e-19,   1.671426645810266e-01,  -1.778314696434078e-03,   1.892038237318587e-05,  -2.013034383623036e-07,
   2.141768086739104e-09,  -2.278733138202238e-11,   2.424449277224862e-13,  -2.579439372008674e-15,   2.744120447133104e-17,  -2.918043468556802e-19,   3.655159894290257e-01,
  -3.888044292094832e-03,   4.135307185478762e-05,  -4.397805996659656e-07,   4.676446954059416e-09,  -4.972185971887312e-11,   5.286020464763803e-13,  -5.618934969976261e-15,
   5.971645793845335e-17,  -6.342873831180244e-19,   3.655218823176772e-01,  -3.888232294637539e-03,   4.135707122191608e-05,  -4.398514997884685e-07,   4.677578151886883e-09,
  -4.973870384789011e-11,   5.288408926129691e-13,  -5.622199498441861e-15,   5.975977784669422e-17,  -6.348468471606517e-19,   3.655315568608036e-01,  -3.888540953158662e-03,
   4.136363752953936e-05,  -4.399679111649406e-07,   4.679435565239208e-09,  -4.976636327381902e-11,   5.292331221617786e-13,  -5.627560825592569e-15,   5.983092693765887e-17,
  -6.357657676118068e-19,   3.655418228597579e-01,  -3.888868493501764e-03,   4.137060583988204e-05,  -4.400914562184308e-07,   4.681406926040286e-09,  -4.979572166305178e-11,
   5.296494779132963e-13,  -5.633252429617390e-15,   5.990646574071365e-17,  -6.367414517174674e-19,   3.655499026610819e-01,  -3.889126291049197e-03,   4.137609062500352e-05,
  -4.401887039048463e-07,   4.682958760665153e-09,  -4.981883382272016e-11,   5.299772751205805e-13,  -5.637733795536571e-15,   5.996594713060633e-17,  -6.375097826311269e-19,
   3.655545658352594e-01,  -3.889275079704557e-03,   4.137925627767340e-05,  -4.402448342939181e-07,   4.683854500435146e-09,  -4.983217508979166e-11,   5.301665026339550e-13,
  -5.640320898882209e-15,   6.000028781685775e-17,  -6.379533868140343e-19,   3.655563169343125e-01,  -3.889330952959157e-03,   4.138044506388652e-05,  -4.402659131075678e-07,
   4.684190887161040e-09,  -4.983718539523823e-11,   5.302375687733500e-13,  -5.641292536827444e-15,   6.001318550828388e-17,  -6.381199996406519e-19,   3.655566072056692e-01,
  -3.889340214837118e-03,   4.138064212496895e-05,  -4.402694072909361e-07,   4.684246649528502e-09,  -4.983801595288572e-11,   5.302493494952311e-13,  -5.641453607897756e-15,
   6.001532361304870e-17,  -6.381476199503995e-19,   5.931385008718951e-03,  -6.051827005503575e-05,   6.174083589177000e-07,  -6.298165837834295e-09,   6.424084268073242e-11,
  -6.551848372997517e-13,   6.681463905050685e-15,  -6.812918772258079e-17,   6.946119301168059e-19,  -7.079904230934472e-21,   5.931472980933682e-03,  -6.052096218127823e-05,
   6.174632915921461e-07,  -6.299099938450896e-09,   6.425513800782456e-11,  -6.553890206786978e-13,   6.684241301165824e-15,  -6.816561381874527e-17,   6.950762324588045e-19,
  -7.085683465011411e-21,   5.931617407229389e-03,  -6.052538203098061e-05,   6.175534813031993e-07,  -6.300633626097243e-09,   6.427861039182847e-11,  -6.557242995328823e-13,
   6.688802185598825e-15,  -6.822543458825019e-17,   6.958387862949656e-19,  -7.095175748872666e-21,   5.931770662395635e-03,  -6.053007222564808e-05,   6.176491915674269e-07,
  -6.302261273104995e-09,   6.430352223849944e-11,  -6.560801634230622e-13,   6.693643457131543e-15,  -6.828893819339059e-17,   6.966483586244342e-19,  -7.105254234603205e-21,
   5.931891280595326e-03,  -6.053376371773484e-05,   6.177245247453042e-07,  -6.303542446874767e-09,   6.432313221699703e-11,  -6.563603077478591e-13,   6.697454881881331e-15,
  -6.833893697400996e-17,   6.972858177369687e-19,  -7.113190719762117e-21,   5.931960893953291e-03,  -6.053589426394963e-05,   6.177680044819355e-07,  -6.304281920306380e-09,
   6.433445121264334e-11,  -6.565220156176498e-13,   6.699655058335725e-15,  -6.836780071232638e-17,   6.976538367460749e-19,  -7.117772890722795e-21,   5.931987034884139e-03,
  -6.053669432677751e-05,   6.177843322144463e-07,  -6.304559615621819e-09,   6.433870192820617e-11,  -6.565827444101428e-13,   6.700481346418843e-15,  -6.837864093322812e-17,
   6.977920559102395e-19,  -7.119493895044359e-21,   5.931991368139902e-03,  -6.053682694977942e-05,   6.177870388045903e-07,  -6.304605648422901e-09,   6.433940656204433e-11,
  -6.565928113869399e-13,   6.700618320768922e-15,  -6.838043793942926e-17,   6.978149690007153e-19,  -7.119779194798546e-21,   5.466282921317606e-02,  -5.577280610569173e-04,
   5.689950598149757e-06,  -5.804303093303185e-08,   5.920347786178141e-10,  -6.038093410781280e-12,   6.157545169004557e-14,  -6.278691343711384e-16,   6.401442735499840e-18,
  -6.524716505627626e-20,   5.466363995301882e-02,  -5.577528713224439e-04,   5.690456850128967e-06,  -5.805163947592736e-08,   5.921665223843711e-10,  -6.039975136428740e-12,
   6.160104776799810e-14,  -6.282048308383324e-16,   6.405721604642661e-18,  -6.530042197849199e-20,   5.466497096591454e-02,  -5.577936040499711e-04,   5.691288026112759e-06,
  -5.806577373047866e-08,   5.923828406440590e-10,  -6.043065019756208e-12,   6.164308021423170e-14,  -6.287561284689685e-16,   6.412749068132593e-18,  -6.538789544459142e-20,
   5.466638334446799e-02,  -5.578368282395485e-04,   5.692170078756004e-06,  -5.808077390159002e-08,   5.926124247934767e-10,  -6.046344611910633e-12,   6.168769666681781e-14,
  -6.293413664434677e-16,   6.420209838763210e-18,  -6.548077084460510e-20,   5.466749494522227e-02,  -5.578708485233734e-04,   5.692864338971528e-06,  -5.809258102296086e-08,
   5.927931476556580e-10,  -6.048926383070879e-12,   6.172282220139008e-14,  -6.298021463346985e-16,   6.426084466012987e-18,  -6.555390721945949e-20,   5.466813649236376e-02,
  -5.578904833445313e-04,   5.693265042249619e-06,  -5.809939590846930e-08,   5.928974619612649e-10,  -6.050416660321985e-12,   6.174309870659707e-14,  -6.300681494206766e-16,
   6.429476015808512e-18,  -6.559613287274306e-20,   5.466837740359044e-02,  -5.578978566136166e-04,   5.693415516388788e-06,  -5.810195511032837e-08,   5.929366359706996e-10,
  -6.050976328432262e-12,   6.175071365700271e-14,  -6.301680509702362e-16,   6.430749800985522e-18,  -6.561199228113451e-20,   5.466841733828013e-02,  -5.578990788489786e-04,
   5.693440459951633e-06,  -5.810237934229614e-08,   5.929431297791456e-10,  -6.051069104291096e-12,   6.175197599262549e-14,  -6.301846118600114e-16,   6.430960960956002e-18,
  -6.561462137685315e-20,   1.603012246417652e-01,  -1.635562821964682e-03,   1.668603806568167e-05,  -1.702138194013118e-07,   1.736168824729055e-09,  -1.770698249779368e-11,
   1.805727925306942e-13,  -1.841254014474304e-15,   1.877248346157308e-17,  -1.913384484147402e-19,   1.603036021731065e-01,  -1.635635579193030e-03,   1.668752267255854e-05,
  -1.702390643433657e-07,   1.736555169271519e-09,  -1.771250074134939e-11,   1.806478540285655e-13,  -1.842238449544292e-15,   1.878503089395189e-17,  -1.914946005771929e-19,
   1.603075054287606e-01,  -1.635755029762986e-03,   1.668996013380725e-05,  -1.702805136851921e-07,   1.737189532332613e-09,  -1.772156196063108e-11,   1.807711158165761e-13,
  -1.843855138259963e-15,   1.880563834860783e-17,  -1.917510772573007e-19,   1.603116472928945e-01,  -1.635881786658347e-03,   1.669254679316598e-05,  -1.703245023665581e-07,
   1.737862798213822e-09,  -1.773117950939475e-11,   1.809019553019234e-13,  -1.845571357425236e-15,   1.882751643384162e-17,  -1.920233923694987e-19,   1.603149071124974e-01,
  -1.635981552682860e-03,   1.669458274271799e-05,  -1.703591272848969e-07,   1.738392776164449e-09,  -1.773875066726800e-11,   1.810049622989431e-13,  -1.846922601296672e-15,
   1.884474328152040e-17,  -1.922378314877418e-19,   1.603167884785724e-01,  -1.636039132685985e-03,   1.669575782324439e-05,  -1.703791122453963e-07,   1.738698682573973e-09,
  -1.774312097107139e-11,   1.810644239389015e-13,  -1.847702659258133e-15,   1.885468871255665e-17,  -1.923616388975411e-19,   1.603174949616656e-01,  -1.636060755131820e-03,
   1.669619909547830e-05,  -1.703866172207915e-07,   1.738813562124780e-09,  -1.774476222250078e-11,   1.810867550769534e-13,  -1.847995622014347e-15,   1.885842397877250e-17,
  -1.924081393394766e-19,   1.603176120719535e-01,  -1.636064339392425e-03,   1.669627224360701e-05,  -1.703878613002566e-07,   1.738832605511149e-09,  -1.774503429180057e-11,
   1.810904569252271e-13,  -1.848044187065623e-15,   1.885904318732750e-17,  -1.924158479560410e-19,   3.505937395329423e-01,  -3.577128542060465e-03,   3.649392259125055e-05,
  -3.722735093638353e-07,   3.797163251992743e-09,  -3.872682265170506e-11,   3.949294987523795e-13,  -4.026991106103065e-15,   4.105699290252912e-17,  -4.184662364290346e-19,
   3.505989394158855e-01,  -3.577287668909409e-03,   3.649716956504424e-05,  -3.723287224071834e-07,   3.798008223445705e-09,  -3.873889155482952e-11,   3.950936644789346e-13,
  -4.029144108870584e-15,   4.108443264908372e-17,  -4.188076272023066e-19,   3.506074762002998e-01,  -3.577548918454413e-03,   3.650250052027619e-05,  -3.724193759845158e-07,
   3.799395634468936e-09,  -3.875870926965609e-11,   3.953632482336018e-13,  -4.032679877693976e-15,   4.112949868403229e-17,  -4.193683532944988e-19,   3.506165348437291e-01,
  -3.577826147614988e-03,   3.650815778569884e-05,  -3.725155833342984e-07,   3.800868129576884e-09,  -3.877974372777122e-11,   3.956494050307518e-13,  -4.036433323333697e-15,
   4.117734340250214e-17,  -4.199637048277145e-19,   3.506236643734463e-01,  -3.578044345221918e-03,   3.651261059737804e-05,  -3.725913112607987e-07,   3.802027240651134e-09,
  -3.879630254188243e-11,   3.958746898620693e-13,  -4.039388551746323e-15,   4.121501640441535e-17,  -4.204325232676715e-19,   3.506277790966440e-01,  -3.578170278062784e-03,
   3.651518060815592e-05,  -3.726350202337657e-07,   3.802696286422364e-09,  -3.880586079561185e-11,   3.960047373890324e-13,  -4.041094571846479e-15,   4.123676583190695e-17,
  -4.207031972868579e-19,   3.506293242411064e-01,  -3.578217568369882e-03,   3.651614571171407e-05,  -3.726514343150776e-07,   3.802947538685303e-09,  -3.880945036244007e-11,
   3.960535774352629e-13,  -4.041735293880558e-15,   4.124493439524660e-17,  -4.208048588169743e-19,   3.506295803722360e-01,  -3.578225407482349e-03,   3.651630569349824e-05,
  -3.726541552329251e-07,   3.802989188342574e-09,  -3.881004540285577e-11,   3.960616736836379e-13,  -4.041841507715744e-15,   4.124628852736076e-17,  -4.208217117652124e-19,
   5.698735224716205e-03,  -5.586478395673247e-05,   5.475916206668390e-07,  -5.367035533688440e-09,   5.259822950758048e-11,  -5.154264669788609e-13,   5.050346073025308e-15,
  -4.948049166939682e-17,   4.847340832073291e-19,  -4.747670810120277e-21,   5.698813241465010e-03,  -5.586707785851563e-05,   5.476365925761619e-07,  -5.367770275543179e-09,
   5.260903305419714e-11,  -5.155747275826692e-13,   5.052283758769111e-15,  -4.950491052138510e-17,   4.850332265985728e-19,  -4.751252191910128e-21,   5.698941323223970e-03,
  -5.587084389667124e-05,   5.477104279205846e-07,  -5.368976625906465e-09,   5.262677181787154e-11,  -5.158181741737251e-13,   5.055465646270278e-15,  -4.954501130229198e-17,
   4.855245138785670e-19,  -4.757134355584522e-21,   5.699077234175844e-03,  -5.587484026295832e-05,   5.477887820035492e-07,  -5.370256864442949e-09,   5.264559808629537e-11,
  -5.160765616198457e-13,   5.058843047715631e-15,  -4.958757938923370e-17,   4.860460727581295e-19,  -4.763379519225335e-21,   5.699184201375631e-03,  -5.587798564778355e-05,
   5.478504536507065e-07,  -5.371264569206223e-09,   5.266041740526744e-11,  -5.162799658938864e-13,   5.061501929849957e-15,  -4.962109377709412e-17,   4.864567343555174e-19,
  -4.768297200059208e-21,   5.699245936068900e-03,  -5.587980100049259e-05,   5.478860481989478e-07,  -5.371846195588964e-09,   5.266897110544472e-11,  -5.163973753246856e-13,
   5.063036763304933e-15,  -4.964044083015753e-17,   4.866938121887973e-19,  -4.771136374206097e-21,   5.699269118406120e-03,  -5.588048270042655e-05,   5.478994148037825e-07,
  -5.372064613469811e-09,   5.267218332824138e-11,  -5.164414676742160e-13,   5.063613172912779e-15,  -4.964770683240272e-17,   4.867828518285019e-19,  -4.772202717334863e-21,
   5.699272961228596e-03,  -5.588059570284199e-05,   5.479016305361340e-07,  -5.372100819960869e-09,   5.267271581193081e-11,  -5.164487768201833e-13,   5.063708724452618e-15,
  -4.964891132858566e-17,   4.867976121912332e-19,  -4.772379489787858e-21,   5.251876077203970e-02,  -5.148421726070560e-04,   5.046529131908074e-06,  -4.946186199776701e-08,
   4.847380556177649e-10,  -4.750099491698844e-12,   4.654329517792919e-14,  -4.560053952986440e-16,   4.467241775456873e-18,  -4.375383656712737e-20,   5.251947976367646e-02,
  -5.148633128906861e-04,   5.046943586844799e-06,  -4.946863327773434e-08,   4.848376196182596e-10,  -4.751465840996784e-12,   4.656115261950305e-14,  -4.562304358335580e-16,
   4.469998626209513e-18,  -4.378684143125318e-20,   5.252066014756742e-02,  -5.148980201808394e-04,   5.047624043233275e-06,  -4.947975083690944e-08,   4.850010976257929e-10,
  -4.753709411238318e-12,   4.659047645091084e-14,  -4.565999987078766e-16,   4.474526239754310e-18,  -4.384104955622259e-20,   5.252191268422447e-02,  -5.149348501434031e-04,
   5.048346143695234e-06,  -4.949154933933515e-08,   4.851745979275930e-10,  -4.756090674340880e-12,   4.662160211150615e-14,  -4.569922999070069e-16,   4.479332830642127e-18,
  -4.389860296383134e-20,   5.252289847923942e-02,  -5.149638375777473e-04,   5.048914501121127e-06,  -4.950083620795767e-08,   4.853111707340635e-10,  -4.757965220104663e-12,
   4.664610599832175e-14,  -4.573011635509035e-16,   4.483117412411041e-18,  -4.394392271350136e-20,   5.252346741768966e-02,  -5.149805676188673e-04,   5.049242535586667e-06,
  -4.950619639677562e-08,   4.853900004590383e-10,  -4.759047249241601e-12,   4.666025080930655e-14,  -4.574794631308120e-16,   4.485302278078490e-18,  -4.397008761812655e-20,
   5.252368106292402e-02,  -5.149868500717868e-04,   5.049365720380117e-06,  -4.950820930595115e-08,   4.854196038627545e-10,  -4.759453598259549e-12,   4.666556291983029e-14,
  -4.575464255327991e-16,   4.486122850997063e-18,  -4.397991468879884e-20,   5.252371647784792e-02,  -5.149878914865199e-04,   5.049386140265006e-06,  -4.950854297999735e-08,
   4.854245111592368e-10,  -4.759520958341682e-12,   4.666644350948970e-14,  -4.575575259914563e-16,   4.486258879780661e-18,  -4.398154376607842e-20,   1.540136467432721e-01,
  -1.509798009983743e-03,   1.479917544844682e-05,  -1.450491525099212e-07,   1.421516321952453e-09,  -1.392988206581561e-11,   1.364903211594036e-13,  -1.337256376275785e-15,
   1.310038254951060e-17,  -1.283097932824752e-19,   1.540157552188402e-01,  -1.509860004823818e-03,   1.480039085633656e-05,  -1.450690095953422e-07,   1.421808297893056e-09,
  -1.393388894669317e-11,   1.365426888885672e-13,  -1.337916316102256e-15,   1.310846704380865e-17,  -1.284065769182603e-19,   1.540192167481096e-01,  -1.509961785525540e-03,
   1.480238632554176e-05,  -1.451016123415400e-07,   1.422287704553857e-09,  -1.394046831750762e-11,   1.366286823076168e-13,  -1.339000073104182e-15,   1.312174431803532e-17,
  -1.285655370648788e-19,   1.540228898686363e-01,  -1.510069791060331e-03,   1.480450391788023e-05,  -1.451362119846843e-07,   1.422796502046435e-09,  -1.394745147883552e-11,
   1.367199596692555e-13,  -1.340150511074654e-15,   1.313583969503925e-17,  -1.287343068760164e-19,   1.540257807572057e-01,  -1.510154798025601e-03,   1.480617065179606e-05,
  -1.451634461478576e-07,   1.423197007986529e-09,  -1.395294866873537e-11,   1.367918183892750e-13,  -1.341056265270657e-15,   1.314693801895701e-17,  -1.288672026248373e-19,
   1.540274491950021e-01,  -1.510203859629591e-03,   1.480713262773649e-05,  -1.451791651445227e-07,   1.423428179725047e-09,  -1.395612176792294e-11,   1.368332986661516e-13,
  -1.341579135455621e-15,   1.315334515904220e-17,  -1.289439286407830e-19,   1.540280757193368e-01,  -1.510222283207573e-03,   1.480749387272741e-05,  -1.451850680919172e-07,
   1.423514993047116e-09,  -1.395731340472310e-11,   1.368488766625825e-13,  -1.341775505202022e-15,   1.315575149713959e-17,  -1.289727455582960e-19,   1.540281795752066e-01,
  -1.510225337203487e-03,   1.480755375496550e-05,  -1.451860466061818e-07,   1.423529383916291e-09,  -1.395751094119834e-11,   1.368514590302694e-13,  -1.341808057711824e-15,
   1.315615040287241e-17,  -1.289775226669087e-19,   3.368422198364274e-01,  -3.302069160372675e-03,   3.236717794300997e-05,  -3.172360342617343e-07,   3.108988867826266e-09,
  -3.046595206521923e-11,   2.985170625891298e-13,  -2.924703949908838e-15,   2.865172856666983e-17,  -2.806239823478938e-19,   3.368468312692832e-01,  -3.302204748874018e-03,
   3.236983615350011e-05,  -3.172794635606703e-07,   3.109627446438905e-09,  -3.047471548587895e-11,   2.986315955682145e-13,  -2.926147291554327e-15,   2.866940965018888e-17,
  -2.808356347719866e-19,   3.368544019568669e-01,  -3.302427352768077e-03,   3.237420043089107e-05,  -3.173507688091855e-07,   3.110675953516759e-09,  -3.048910518095942e-11,
   2.988196709832655e-13,  -2.928517555476612e-15,   2.869844752823613e-17,  -2.811832584183796e-19,   3.368624354142788e-01,  -3.302663570953033e-03,   3.237883180297235e-05,
  -3.174264414576762e-07,   3.111788741084493e-09,  -3.050437800337369e-11,   2.990193028587392e-13,  -2.931033655942716e-15,   2.872927462068360e-17,  -2.815523341497693e-19,
   3.368687580573925e-01,  -3.302849489119945e-03,   3.238247710560422e-05,  -3.174860051141015e-07,   3.112664684927259e-09,  -3.051640086824135e-11,   2.991764644010103e-13,
  -2.933014613214422e-15,   2.875354704679867e-17,  -2.818429581707912e-19,   3.368724070865721e-01,  -3.302956791426885e-03,   3.238458103676812e-05,  -3.175203840267463e-07,
   3.113170279078737e-09,  -3.052334073086205e-11,   2.992671855305952e-13,  -2.934158172328651e-15,   2.876755968657306e-17,  -2.820107469264670e-19,   3.368737773537669e-01,
  -3.302997085511440e-03,   3.238537111327863e-05,  -3.175332943235766e-07,   3.113360147910396e-09,  -3.052594695121438e-11,   2.993012560222902e-13,  -2.934587648738947e-15,
   2.877282243194618e-17,  -2.820737653625989e-19,   3.368740044962471e-01,  -3.303003764885540e-03,   3.238550208132221e-05,  -3.175354344255908e-07,   3.113391622083386e-09,
  -3.052637898183139e-11,   2.993069038947325e-13,  -2.934658843692594e-15,   2.877369485268390e-17,  -2.820842122082806e-19,   5.483648876115307e-03,  -5.172810485751780e-05,
   4.879165601417996e-07,  -4.601787868369847e-09,   4.339799376232415e-11,  -4.092368200829174e-13,   3.858705991409002e-15,  -3.638065297079135e-17,   3.429735310220866e-19,
  -3.232744218327036e-21,   5.483718384837955e-03,  -5.173007152309083e-05,   4.879536620306773e-07,  -4.602371162859076e-09,   4.340624688345829e-11,  -4.093458077530405e-13,
   3.860076674677689e-15,  -3.639727520682311e-17,   3.431694987543452e-19,  -3.235002655480007e-21,   5.483832498482786e-03,  -5.173330030322033e-05,   4.880145758863186e-07,
  -4.603328847406601e-09,   4.341979783485971e-11,  -4.095247646015261e-13,   3.862327438235811e-15,  -3.642457167315348e-17,   3.434913299484912e-19,  -3.238711856314712e-21,
   5.483953587081933e-03,  -5.173672653356681e-05,   4.880792171280115e-07,  -4.604345177301230e-09,   4.343417931985224e-11,  -4.097147005180427e-13,   3.864716440600983e-15,
  -3.645354672037761e-17,   3.438329787531682e-19,  -3.242649795066882e-21,   5.484048888212772e-03,  -5.173942317231946e-05,   4.881300951451881e-07,  -4.605145144752661e-09,
   4.344549970842740e-11,  -4.098642164730602e-13,   3.866597154418168e-15,  -3.647635848175624e-17,   3.441019747937702e-19,  -3.245750559834138e-21,   5.484103889869039e-03,
  -5.174097952641743e-05,   4.881594598563693e-07,  -4.605606865904624e-09,   4.345203376166174e-11,  -4.099505192433483e-13,   3.867682774221128e-15,  -3.648952690196579e-17,
   3.442572644364322e-19,  -3.247540707890533e-21,   5.484124543823334e-03,  -5.174156396630481e-05,   4.881704869778395e-07,  -4.605780255160957e-09,   4.345448752158206e-11,
  -4.099829294739502e-13,   3.868090477423283e-15,  -3.649447239979310e-17,   3.443155860826716e-19,  -3.248213046537589e-21,   5.484127967526953e-03,  -5.174166084629111e-05,
   4.881723149011325e-07,  -4.605808997353750e-09,   4.345489427574472e-11,  -4.099883020750895e-13,   3.868158062289657e-15,  -3.649529221982568e-17,   3.443252541967943e-19,
  -3.248324502636444e-21,   5.053655453818813e-02,  -4.767191064466841e-04,   4.496571974016826e-06,  -4.240944466660652e-08,   3.999499472209251e-10,  -3.771470300352992e-12,
   3.556130414992894e-14,  -3.352790958816996e-16,   3.160796775610054e-18,  -2.979251872692186e-20,   5.053719512102492e-02,  -4.767372309663671e-04,   4.496913899926573e-06,
  -4.241482022846825e-08,   4.000260068511379e-10,  -3.772474715735696e-12,   3.557393617790727e-14,  -3.354322840819407e-16,   3.162602784937502e-18,  -2.981333205828356e-20,
   5.053824677669540e-02,  -4.767669869603762e-04,   4.497475273650025e-06,  -4.242364611766196e-08,   4.001508905570551e-10,  -3.774123957445754e-12,   3.559467890445773e-14,
  -3.356838444938633e-16,   3.165568733093463e-18,  -2.984751535338147e-20,   5.053936271258645e-02,  -4.767985626284537e-04,   4.498070998451150e-06,  -4.243301247431607e-08,
   4.002834283464130e-10,  -3.775874380737099e-12,   3.561669562078046e-14,  -3.359508744717209e-16,   3.168717317353959e-18,  -2.988380665252247e-20,   5.054024099471302e-02,
  -4.768234144806549e-04,   4.498539883266331e-06,  -4.244038486442422e-08,   4.003877554918496e-10,  -3.777252299220726e-12,   3.563402801993797e-14,  -3.361611044698579e-16,
   3.171196344590185e-18,  -2.991238271341805e-20,   5.054074788241943e-02,  -4.768377576261643e-04,   4.498810504409589e-06,  -4.244464002311518e-08,   4.004479724285332e-10,
  -3.778047653685399e-12,   3.564403294231438e-14,  -3.362824627861410e-16,   3.172627470678168e-18,  -2.992888037847733e-20,   5.054093822642416e-02,  -4.768431437438589e-04,
   4.498912128845828e-06,  -4.244623795467598e-08,   4.004705859427577e-10,  -3.778346341914334e-12,   3.564779027879489e-14,  -3.363280398014201e-16,   3.173164954232994e-18,
  -2.993507652388679e-20,   5.054096977880627e-02,  -4.768440365765004e-04,   4.498928974735722e-06,  -4.244650283877527e-08,   4.004743345332237e-10,  -3.778395855067721e-12,
   3.564841313160204e-14,  -3.363355951480095e-16,   3.173254054124322e-18,  -2.993610368214320e-20,   1.482007371051747e-01,  -1.398000390274552e-03,   1.318640115229972e-05,
  -1.243676189883837e-07,   1.172871350700528e-09,  -1.106000761981531e-11,   1.042851361731967e-13,  -9.832211277554537e-16,   9.269178730142079e-18,  -8.736785764497526e-20,
   1.482026156433825e-01,  -1.398053541250142e-03,   1.318740386553018e-05,  -1.243833830672216e-07,   1.173094399013341e-09,  -1.106295311339329e-11,   1.043221801631514e-13,
  -9.836703587981481e-16,   9.274474917878482e-18,  -8.742889287828575e-20,   1.482056996713098e-01,  -1.398140802051472e-03,   1.318905011942232e-05,  -1.244092653873665e-07,
   1.173460626140979e-09,  -1.106778958936580e-11,   1.043830091412618e-13,  -9.844080706162137e-16,   9.283172668066847e-18,  -8.752913561212958e-20,   1.482089722038979e-01,
  -1.398233399129496e-03,   1.319079710940692e-05,  -1.244367326528386e-07,   1.173849299215199e-09,  -1.107292278490484e-11,   1.044475741515887e-13,  -9.851911476033525e-16,
   9.292406005020836e-18,  -8.763556007126230e-20,   1.482115478060483e-01,  -1.398306278312660e-03,   1.319217213538285e-05,  -1.244583525210267e-07,   1.174155243297539e-09,
  -1.107696359323228e-11,   1.044984021912099e-13,  -9.858076561845348e-16,   9.299675841686486e-18,  -8.771935953912391e-20,   1.482130342772256e-01,  -1.398348340237069e-03,
   1.319296574415321e-05,  -1.244708309667774e-07,   1.174331832193532e-09,  -1.107929600620297e-11,   1.045277420757817e-13,  -9.861635447057117e-16,   9.303872670426777e-18,
  -8.776773903666282e-20,   1.482135924696481e-01,  -1.398364135271372e-03,   1.319326376241931e-05,  -1.244755169735149e-07,   1.174398147348890e-09,  -1.108017192295489e-11,
   1.045387606338927e-13,  -9.862972012777344e-16,   9.305448860276408e-18,  -8.778590926809857e-20,   1.482136849984390e-01,  -1.398366753543567e-03,   1.319331316375508e-05,
  -1.244762937581434e-07,   1.174409140260326e-09,  -1.108031712251848e-11,   1.045405871777450e-13,  -9.863193576589471e-16,   9.305710148910670e-18,  -8.778892141546150e-20,
   3.241288439271546e-01,  -3.057557331768298e-03,   2.883989003387653e-05,  -2.720035902101054e-07,   2.565179110249550e-09,  -2.418926889827379e-11,   2.280813245054989e-13,
  -2.150396279677340e-15,   2.027255381389389e-17,  -1.910814028335573e-19,   3.241329524655428e-01,  -3.057673577912603e-03,   2.884208306129664e-05,  -2.720380677217874e-07,
   2.565666937723863e-09,  -2.419571096733770e-11,   2.281623431466337e-13,  -2.151378788479060e-15,   2.028413699221987e-17,  -1.912148887302294e-19,   3.241396975224585e-01,
  -3.057864425429338e-03,   2.884568357220664e-05,  -2.720946747715443e-07,   2.566467910627179e-09,  -2.420628879119204e-11,   2.282953817622342e-13,  -2.152992230737657e-15,
   2.030315965389338e-17,  -1.914341225771326e-19,   3.241468548566608e-01,  -3.058066943881250e-03,   2.884950440235277e-05,  -2.721547482446547e-07,   2.567317974910207e-09,
  -2.421751556839729e-11,   2.284365914264201e-13,  -2.154704890692259e-15,   2.032335368479005e-17,  -1.916668759919552e-19,   3.241524879389500e-01,  -3.058226337456791e-03,
   2.885251171249583e-05,  -2.722020329141663e-07,   2.567987103167959e-09,  -2.422635319292587e-11,   2.285477570617324e-13,  -2.156053250515411e-15,   2.033925338606359e-17,
  -1.918501478509857e-19,   3.241557389901501e-01,  -3.058318330811199e-03,   2.885424740894557e-05,  -2.722293244396375e-07,   2.568373319562163e-09,  -2.423145439753774e-11,
   2.286119261095301e-13,  -2.156831610776264e-15,   2.034843217840054e-17,  -1.919559551963689e-19,   3.241569598090754e-01,  -3.058352876025401e-03,   2.885489920270811e-05,
  -2.722395731737177e-07,   2.568518356995232e-09,  -2.423337010913348e-11,   2.286360247176845e-13,  -2.157123929740493e-15,   2.035187942868624e-17,  -1.919956940096737e-19,
   3.241571621781769e-01,  -3.058358602431061e-03,   2.885500724804016e-05,  -2.722412720741977e-07,   2.568542399518363e-09,  -2.423368767411558e-11,   2.286400195384333e-13,
  -2.157172387742235e-15,   2.035245088733037e-17,  -1.920022816615423e-19  };
  static constexpr double xi[11600] = {  -4.532328799177057e-03,   3.879039620607161e-04,  -2.081725288735535e-05,   8.464980322107385e-07,  -2.638773336539869e-08,
   5.278568961070447e-10,   2.808991550100069e-12,  -8.889231833507988e-13,   4.811446049903994e-14,  -1.594919128932976e-15,   3.469353449712022e-17,  -2.576987940794958e-19,
  -2.481603377390001e-20,   1.783013029208705e-21,  -4.312500662569469e-03,   3.691119830496185e-04,  -1.980939843181904e-05,   8.054792863038270e-07,  -2.510281812749461e-08,
   5.016187246145584e-10,   2.712676633812755e-12,  -8.473952389597038e-13,   4.582015272758754e-14,  -1.517722536201926e-15,   3.295515579877708e-17,  -2.409509066017103e-19,
  -2.380415764941120e-20,   1.702082045177114e-21,  -3.894108526483030e-03,   3.333367260823459e-04,  -1.789043318560099e-05,   7.273936799247560e-07,  -2.265931094462336e-08,
   4.519381171533759e-10,   2.513141602475466e-12,  -7.677100730130087e-13,   4.143732835340129e-14,  -1.370721450805118e-15,   2.966870705829678e-17,  -2.107884761242051e-19,
  -2.180037858720650e-20,   1.545771432286115e-21,  -3.317748139870078e-03,   2.840365931521516e-04,  -1.524549695754591e-05,   6.197955297904372e-07,  -1.929719673366828e-08,
   3.840009210167528e-10,   2.206784250762250e-12,  -6.566860767823978e-13,   3.536854670348409e-14,  -1.168082429032666e-15,   2.518487940086938e-17,  -1.725761456894792e-19,
  -1.888883469027261e-20,   1.326046356524333e-21,  -2.639571456971271e-03,   2.260051865428264e-04,  -1.213149556234253e-05,   4.931515569161853e-07,  -1.534620579620379e-08,
   3.046981111303202e-10,   1.806403397278389e-12,  -5.244638310606793e-13,   2.818840720832791e-14,  -9.294889292072039e-16,   1.996473686025354e-17,  -1.318638588757277e-19,
  -1.527130462217613e-20,   1.061966647491146e-21,  -1.925911801969200e-03,   1.649168138036442e-04,  -8.852865952133055e-06,   3.598462259825083e-07,  -1.119323886578998e-08,
   2.218404280225648e-10,   1.347827485493199e-12,  -3.838459606693120e-13,   2.059613692971727e-14,  -6.782787379519527e-16,   1.452416617712360e-17,  -9.300664951913909e-20,
  -1.128561854922698e-20,   7.789312103907531e-22,  -1.246772630271314e-03,   1.067688516385619e-04,  -5.731637311951544e-06,   2.329645765067732e-07,  -7.244499612565740e-09,
   1.434081785879628e-10,   8.853013091728325e-13,  -2.489945361792448e-13,   1.334565554857022e-14,  -4.391343549253951e-16,   9.384100525980997e-18,  -5.883523347507090e-20,
  -7.367226488200964e-21,   5.059995185266003e-22,  -6.688551351378000e-04,   5.728015029680056e-05,  -3.075006675268825e-06,   1.249815755522019e-07,  -3.885998712737124e-09,
   7.687780772117777e-11,   4.784536573852339e-13,  -1.337170553912283e-13,   7.162941727760886e-15,  -2.355924147838860e-16,   5.029202897095593e-18,  -3.118416306991869e-20,
  -3.969178088032735e-21,   2.719332103927933e-22,  -2.489061761606412e-04,   2.131635266819919e-05,  -1.144346429234953e-06,   4.651077006188133e-08,  -1.446067785565345e-09,
   2.860183648582296e-11,   1.785061822195619e-13,  -4.977917300583697e-14,   2.666041501602080e-15,  -8.767412815663601e-17,   1.870896995978654e-18,  -1.155566330069983e-20,
  -1.479268239634558e-21,   1.012587246927421e-22,  -2.811601291275538e-05,   2.407863002169731e-06,  -1.292637721575657e-07,   5.253784006808171e-09,  -1.633442749646041e-10,
   3.230683498152301e-12,   2.017191709381314e-14,  -5.623292685644615e-15,   3.011593632290861e-16,  -9.903542074789184e-18,   2.113214889299490e-19,  -1.304426865763511e-21,
  -1.671348068742810e-22,   1.143912476145047e-23,  -2.513562249175587e-02,   8.621180967639204e-04,   1.955130374775216e-05,  -2.019324660839787e-06,   1.879159775680914e-08,
   3.086248354219268e-09,  -1.159605400194272e-10,  -2.340306680002699e-12,   2.522385896856639e-13,  -2.197095904849052e-15,  -3.394734509247982e-16,   1.122970692317286e-17,
   2.455286114301732e-19,  -2.285603644847455e-20,  -2.391243149178640e-02,   8.200060414207313e-04,   1.860354935206653e-05,  -1.920191033885567e-06,   1.782664923881479e-08,
   2.934660665880199e-09,  -1.101127829115643e-10,  -2.228702616593375e-12,   2.395194384331818e-13,  -2.072360050570915e-15,  -3.224748656669223e-16,   1.063174314976902e-17,
   2.340200726553374e-19,  -2.165172708310395e-20,  -2.158602202372982e-02,   7.399767524200990e-04,   1.679948921450337e-05,  -1.731999370480418e-06,   1.601203093895268e-08,
   2.646920001348833e-09,  -9.907450111732313e-11,  -2.015486932714338e-12,   2.155100589020332e-13,  -1.842476803083648e-15,  -2.903382554037423e-16,   9.515676032550319e-18,
   2.119409383696241e-19,  -1.939901403129799e-20,  -1.838445581782155e-02,   6.299665433954067e-04,   1.431385816768967e-05,  -1.473695871584040e-06,   1.355467240656456e-08,
   2.252036885345748e-09,  -8.404554884816639e-11,  -1.720239085501384e-12,   1.828196318099699e-13,  -1.540261730365984e-15,  -2.464883542249605e-16,   8.020603604500058e-18,
   1.811980115778751e-19,  -1.637175696825937e-20,  -1.462137370267388e-02,   5.008196787941185e-04,   1.138860750816613e-05,  -1.170952569599143e-06,   1.071663466267760e-08,
   1.789292596426891e-09,  -6.658470862493932e-11,  -1.370938441923918e-12,   1.448385801099015e-13,  -1.202777437034639e-15,  -1.954254040670490e-16,   6.314575873380455e-18,
   1.446282985857211e-19,  -1.290525297802603e-20,  -1.066518035219605e-02,   3.651923472597693e-04,   8.309835194715206e-06,  -8.534777188223658e-07,   7.779700550085294e-09,
   1.304106417662508e-09,  -4.841736373679181e-11,  -1.001631638582357e-12,   1.053202020651656e-13,  -8.643546227156183e-16,  -1.421890198577428e-16,   4.568398493987528e-18,
   1.057930544385122e-19,  -9.345832425436173e-21,  -6.902999285725068e-03,   2.363191762264814e-04,   5.379668193568718e-06,  -5.521353968173182e-07,   5.019467409543214e-09,
   8.436301911997687e-10,  -3.127343020896292e-11,  -6.489971690950857e-13,   6.802778410168760e-14,  -5.539215044036830e-16,  -9.187758975698106e-17,   2.940853804987434e-18,
   6.859913741458923e-20,  -6.020234385354353e-21,  -3.702890869234353e-03,   1.267519463508404e-04,   2.886067613005029e-06,  -2.960994618860596e-07,   2.688150732939381e-09,
   4.524146855194002e-10,  -1.675786004935814e-11,  -3.483240932032452e-13,   3.645267621176048e-14,  -2.956139433122844e-16,  -4.924237697680843e-17,   1.573120842087558e-18,
   3.683182592266108e-20,  -3.221433167486609e-21,  -1.377939019844441e-03,   4.716580173934896e-05,   1.074019725310510e-06,  -1.101762653599934e-07,   9.997615296484123e-10,
   1.683389118929300e-10,  -6.233722643461696e-12,  -1.296448029301755e-13,   1.355995786142809e-14,  -1.098088317021855e-16,  -1.831883748626743e-17,   5.848279173759650e-19,
   1.371043606494542e-20,  -1.197750509547165e-21,  -1.556487922708593e-04,   5.327707328238055e-06,   1.213195132740606e-07,  -1.244507933068608e-08,   1.129205769871458e-10,
   1.901488589263275e-11,  -7.041056238906811e-13,  -1.464481711711994e-14,   1.531611709832955e-15,  -1.240022841562871e-17,  -2.069154892312095e-18,   6.605058957182323e-20,
   1.548777506873370e-21,  -1.352767303189113e-22,  -2.566039244666189e-02,  -7.543824374755704e-04,   2.237984586748427e-05,   1.776797784417187e-06,   7.906667613865303e-09,
  -2.731823796944737e-09,  -8.367321642554569e-11,   2.629204023722692e-12,   1.953641210509851e-13,   4.118146665094452e-17,  -2.835370415833812e-16,  -6.097559389429048e-18,
   2.637805108711449e-19,   1.466714826771695e-20,  -2.441159518632732e-02,  -7.175321074543149e-04,   2.129260338679399e-05,   1.689566635821320e-06,   7.485384645072053e-09,
  -2.597305643054524e-09,  -7.944283972045439e-11,   2.501296739609127e-12,   1.854864269059089e-13,   2.952348878541132e-17,  -2.692297772271374e-16,  -5.767885576194503e-18,
   2.508066911644946e-19,   1.388531679390832e-20,  -2.203651282513316e-02,  -6.475024924963242e-04,   1.922399964582108e-05,   1.523971858337839e-06,   6.699071620679587e-09,
  -2.342104088501428e-09,  -7.146184320982637e-11,   2.257997495695324e-12,   1.668513580042719e-13,   1.134685411676698e-17,  -2.422258621654358e-16,  -5.154473870949905e-18,
   2.261821834003766e-19,   1.242639199738011e-20,  -1.876801825166744e-02,  -5.512387550757404e-04,   1.637576162542083e-05,   1.296686917094415e-06,   5.645820752079604e-09,
  -1.992142849598140e-09,  -6.060382794239964e-11,   1.923128733536811e-12,   1.414989222382955e-13,  -5.991925893731594e-18,  -2.054651657914157e-16,  -4.336466742628282e-18,
   1.923976455567987e-19,   1.047265292678992e-20,  -1.492633818434888e-02,  -4.382304642262276e-04,   1.302614222167746e-05,   1.030302454890830e-06,   4.444233847595585e-09,
  -1.582376202843970e-09,  -4.799944061612712e-11,   1.529493090473694e-12,   1.120692927235606e-13,  -1.676541091062539e-17,  -1.627649737024874e-16,  -3.407783765495305e-18,
   1.528262692377591e-19,   8.244028945143245e-21,  -1.088757753979756e-02,  -3.195523229156160e-04,   9.502930273023112e-06,   7.509589381065812e-07,   3.214786935253499e-09,
  -1.153048779415731e-09,  -3.489497580473724e-11,   1.115643815060975e-12,   8.147250662995559e-14,  -1.923488704351598e-17,  -1.183465634034236e-16,  -2.461725878246971e-18,
   1.113604258079972e-19,   5.963694408916821e-21,  -7.046923168861831e-03,  -2.067848421526211e-04,   6.151312803280115e-06,   4.858124867423590e-07,   2.069254426504471e-09,
  -7.458043723420300e-10,  -2.253570360253615e-11,   7.220914700933249e-13,   5.261598586946273e-14,  -1.543162311385771e-17,  -7.643775093717590e-17,  -1.583123736278478e-18,
   7.202757359720328e-20,   3.838802302509303e-21,  -3.780088157089891e-03,  -1.109108614992460e-04,   3.299831247550375e-06,   2.605314975980041e-07,   1.106818488702392e-09,
  -3.999242873942199e-10,  -1.207480544602288e-11,   3.873408138465102e-13,   2.819200037052221e-14,  -9.096859918712029e-18,  -4.095804856377049e-17,  -8.464073541178888e-19,
   3.862291017398613e-20,   2.053380514245620e-21,  -1.406665295736858e-03,  -4.127114903280353e-05,   1.227970862156799e-06,   9.694167157541344e-08,   4.114651524760009e-10,
  -1.488039856869874e-10,  -4.491560047957880e-12,   1.441390168407367e-13,   1.048679224951875e-14,  -3.491116488603714e-18,  -1.523575764157744e-17,  -3.146061993541944e-19,
   1.437074131537591e-20,   7.633614731694633e-22,  -1.588936317053811e-04,  -4.661864885000903e-06,   1.387091045087709e-07,   1.095015082007824e-08,   4.647080179168957e-11,
  -1.680823148087332e-11,  -5.073243032029855e-13,   1.628160381851574e-14,   1.184489116446538e-15,  -3.962467148033449e-19,  -1.720892483627018e-18,  -3.553067575130409e-20,
   1.623252950370276e-21,   8.621404324141496e-23,  -7.281367101358388e-03,  -5.279514500612851e-04,  -2.281467436222759e-05,  -6.713934362568252e-07,  -1.030934476242306e-08,
   2.412807343205157e-10,   2.600973719624229e-11,   1.203498545360239e-12,   3.253785015933615e-14,   1.418275409334389e-16,  -2.647873848590725e-17,  -1.290216555878660e-18,
  -3.903186853394583e-20,  -7.587091004196664e-22,  -6.927879955541981e-03,  -5.023314566764447e-04,  -2.170677142607902e-05,  -6.386625911770547e-07,  -9.796192939425075e-09,
   2.302967754582808e-10,   2.477149368718620e-11,   1.145097129283312e-12,   3.091915014251159e-14,   1.328029952274242e-16,  -2.526722282410511e-17,  -1.229171217542212e-18,
  -3.711892009429836e-20,  -7.182865259502212e-22,  -6.255230749685058e-03,  -4.535750429150385e-04,  -1.959867607281850e-05,  -5.764346095050835e-07,  -8.824859818976848e-09,
   2.090984998814117e-10,   2.240524767466141e-11,   1.033952115228831e-12,   2.785470963220137e-14,   1.164975714723051e-16,  -2.293167936748311e-17,  -1.112349050585456e-18,
  -3.348542993246553e-20,  -6.428039791744123e-22,  -5.328871972353408e-03,  -3.864205083150205e-04,  -1.669570224544455e-05,  -4.908431973889090e-07,  -7.497140606157802e-09,
   1.793290359968851e-10,   1.912716657553067e-11,   8.808629982726256e-13,   2.366514208640798e-14,   9.572688816719697e-17,  -1.965681268378287e-17,  -9.501974797378606e-19,
  -2.849504879952571e-20,  -5.416609115469660e-22,  -4.239192551092448e-03,  -3.074160227520247e-04,  -1.328124663605011e-05,  -3.902984232049055e-07,  -5.947992327836709e-09,
   1.435826556658225e-10,   1.524674834678156e-11,   7.007600681611369e-13,   1.877601584715316e-14,   7.343164858399225e-17,  -1.573074862930231e-17,  -7.578730718066154e-19,
  -2.264310774798502e-20,  -4.262779747065305e-22,  -3.092802241249344e-03,  -2.242902352633267e-04,  -9.689396375399859e-06,  -2.846487892014216e-07,  -4.330034431257107e-09,
   1.052969557079365e-10,   1.114170190083761e-11,   5.112663431948138e-13,   1.366905342398414e-14,   5.197308393637645e-17,  -1.153162627021017e-17,  -5.540785684830000e-19,
  -1.650461172209563e-20,  -3.082709557252946e-22,  -2.002076056072910e-03,  -1.451939744214280e-04,  -6.272168947704786e-06,  -1.842189149046695e-07,  -2.798928656626453e-09,
   6.839446566537321e-11,   7.220125235982815e-12,   3.309639026326273e-13,   8.835829994812279e-15,   3.295868455940454e-17,  -7.488276762080034e-18,  -3.591652569696837e-19,
  -1.067735495243562e-20,  -1.983819642749112e-22,  -1.074023663356572e-03,  -7.789093269666544e-05,  -3.364706722280431e-06,  -9.881304385941384e-08,  -1.500383119874903e-09,
   3.675450486008571e-11,   3.875397918198315e-12,   1.775481766996773e-13,   4.736545982920828e-15,   1.749197065833323e-17,  -4.023584578919760e-18,  -1.928109442851463e-19,
  -5.726067208549408e-21,  -1.060992814800327e-22,  -3.996809462606799e-04,  -2.898599748465624e-05,  -1.252118644325483e-06,  -3.677014487831144e-08,  -5.581993027593354e-10,
   1.368589170712594e-11,   1.442443377520036e-12,   6.607186624297052e-14,   1.762179931677374e-15,   6.484890528368332e-18,  -1.498150194893397e-18,  -7.176900374785197e-20,
  -2.130624101754422e-21,  -3.944119958100332e-23,  -4.514720504010097e-05,  -3.274205641186656e-06,  -1.414368892195230e-07,  -4.153458011345826e-09,  -6.305054754318949e-11,
   1.546080958256679e-12,   1.629406134749194e-13,   7.463355303462584e-15,   1.990444349156176e-16,   7.320823354361056e-19,  -1.692432147662621e-19,  -8.107203911672312e-21,
  -2.406669413664633e-22,  -4.454450843920509e-24,  -3.258538778221858e-03,   2.556151308132477e-04,  -1.284914011280072e-05,   5.064904554196128e-07,  -1.646609714876375e-08,
   4.263130375567822e-10,  -7.435683151321423e-12,  -3.343571971162682e-14,   1.144030734312804e-14,  -5.697527797601183e-16,   1.636861005601708e-17,  -3.522706119546578e-19,
   6.224960037127613e-21,  -8.431557855146697e-25,  -3.100428722978390e-03,   2.432273439487966e-04,  -1.222709893741048e-05,   4.819812616007448e-07,  -1.566845968129919e-08,
   4.055532611440594e-10,  -7.064359643900044e-12,  -3.242314945615086e-14,   1.090584315003663e-14,  -5.426156503105419e-16,   1.558441621638395e-17,  -3.351209336399222e-19,
   5.901406156128000e-21,   4.472362310983847e-25,  -2.799528620614309e-03,   2.196459290821400e-04,  -1.104271003272900e-05,   4.353105095426260e-07,  -1.414992430988537e-08,
   3.660749462031118e-10,  -6.361956822259731e-12,  -3.024852433888057e-14,   9.880313601583132e-15,  -4.907636616012907e-16,   1.408786364370262e-17,  -3.025023820864109e-19,
   5.294224656450987e-21,   2.400110657785433e-24,  -2.385070808997451e-03,   1.871531187937900e-04,  -9.410218261640874e-06,   3.709738950957714e-07,  -1.205724984617474e-08,
   3.117559268874506e-10,  -5.402762286088766e-12,  -2.677254591144503e-14,   8.451479692737363e-15,  -4.189416621293655e-16,   1.201853836759859e-17,  -2.576148001555505e-19,
   4.474699698499351e-21,   4.109333872613833e-24,  -1.897460959490817e-03,   1.489102144688202e-04,  -7.488170557020778e-06,   2.952153017852233e-07,  -9.593894076234758e-09,
   2.479239631717432e-10,  -4.284795764688396e-12,  -2.207372546503365e-14,   6.749833765867585e-15,  -3.339353708768773e-16,   9.573964947247628e-18,  -2.048625682883349e-19,
   3.532067073091224e-21,   4.870327664576404e-24,  -1.384398026470459e-03,   1.086569703313708e-04,  -5.464468910606246e-06,   2.154401893687743e-07,  -7.000728426454413e-09,
   1.808300658136447e-10,  -3.118314865259860e-12,  -1.656073473294660e-14,   4.940119259389307e-15,  -2.440189029701823e-16,   6.992539636532433e-18,  -1.494164315897984e-19,
   2.560556749299802e-21,   4.497948133268080e-24,  -8.961939903015284e-04,   7.034421115435620e-05,  -3.537892011586738e-06,   1.394869656080983e-07,  -4.532354921023097e-09,
   1.170365293903014e-10,  -2.015268438232908e-12,  -1.091563904590567e-14,   3.204591051088463e-15,  -1.581278636929623e-16,   4.529759321037106e-18,  -9.670190258221056e-20,
   1.650508002576232e-21,   3.316883228319959e-24,  -4.807749109434107e-04,   3.773839204058215e-05,  -1.898072803774513e-06,   7.483541911062296e-08,  -2.431554364822170e-09,
   6.277904793462672e-11,  -1.080184662522949e-12,  -5.909576108173229e-15,   1.720960607869019e-15,  -8.487423712483876e-17,   2.430905350436875e-18,  -5.187045108722755e-20,
   8.834812797853233e-22,   1.891177290254324e-24,  -1.789137218756990e-04,   1.404399146309733e-05,  -7.063576419747274e-07,   2.784971858109717e-08,  -9.048839764529480e-10,
   2.336148158684477e-11,  -4.018549630348131e-13,  -2.206128545906627e-15,   6.406668963420171e-16,  -3.159053322472999e-17,   9.047386339138437e-19,  -1.930201438985700e-20,
   3.285217254534054e-22,   7.182660528383575e-25,  -2.020977289496874e-05,   1.586387146801788e-06,  -7.978918082714794e-08,   3.145867742696328e-09,  -1.022143334084416e-10,
   2.638855405949579e-12,  -4.539064992989695e-14,  -2.493251136977451e-16,   7.237279963873627e-17,  -3.568513208149869e-18,   1.021996391688375e-19,  -2.180305526134616e-21,
   3.710467698150014e-23,   8.139384468505798e-26,  -2.151569661401069e-02,   9.303714556190340e-04,  -1.354382776372985e-06,  -1.383595914386152e-06,   5.152283756604978e-08,
   2.876701312774635e-10,  -9.310363527090314e-11,   2.868577278864134e-12,   5.308166429422452e-14,  -5.841400021170136e-15,   1.003538174462055e-16,   4.614089001454329e-18,
  -2.768803466314578e-19,   2.918439966466415e-21,  -2.046919288704944e-02,   8.849946529207337e-04,  -1.279415681297716e-06,  -1.316206411593008e-06,   4.897540263430488e-08,
   2.754395134477641e-10,  -8.853011650991481e-11,   2.722849186946989e-12,   5.062966017025797e-14,  -5.549669140729157e-15,   9.493781584808254e-17,   4.395877037142465e-18,
  -2.626484742847223e-19,   2.735860604082301e-21,  -1.847861323445383e-02,   7.987329431811626e-04,  -1.140524352918063e-06,  -1.188060207711011e-06,   4.414672701568561e-08,
   2.514540999324469e-10,  -7.984888068409527e-11,   2.448189017072834e-12,   4.591188796215879e-14,  -4.997840905652564e-15,   8.485540245478355e-17,   3.978157058564029e-18,
  -2.358883308035103e-19,   2.405387760003540e-21,  -1.573879388266552e-02,   6.801010103086831e-04,  -9.565297505342374e-07,  -1.011753074838111e-06,   3.753323681368083e-08,
   2.170475163250758e-10,  -6.793545100938795e-11,   2.075048306012367e-12,   3.931511765455700e-14,  -4.244293775958889e-15,   7.140157500142888e-17,   3.398191596304716e-18,
  -1.996583654783115e-19,   1.982834945263703e-21,  -1.251791638479895e-02,   5.407637429833674e-04,  -7.492960860273419e-07,  -8.045825528179092e-07,   2.979985398892631e-08,
   1.748441665536298e-10,  -5.397524075849441e-11,   1.642576624851592e-12,   3.143084868281655e-14,  -3.366035616671964e-15,   5.611852483640336e-17,   2.710236594674947e-18,
  -1.578300958986404e-19,   1.526532629420324e-21,  -9.131260988639874e-03,   3.943704803621825e-04,  -5.398361121819768e-07,  -5.868363602998839e-07,   2.170690963496168e-08,
   1.288389753461887e-10,  -3.933864349263242e-11,   1.193597125349010e-12,   2.302163018981483e-14,  -2.449675402692294e-15,   4.054295987270923e-17,   1.981306410536520e-18,
  -1.145605137881314e-19,   1.084037612032790e-21,  -5.910343502514601e-03,   2.552225508724052e-04,  -3.465354195684762e-07,  -3.798081310321999e-07,   1.403697056358996e-08,
   8.394700357653033e-11,  -2.544799702444952e-11,   7.706128707825813e-13,   1.494119697103925e-14,  -1.583149320262351e-15,   2.607436223209777e-17,   1.284247863083181e-18,
  -7.390739936290919e-20,   6.891023457661385e-22,  -3.170459017865116e-03,   1.368969880124274e-04,  -1.850969896423501e-07,  -2.037303811712358e-07,   7.526168255892850e-09,
   4.518377384625398e-11,  -1.364694982527129e-11,   4.128367058655281e-13,   8.025855496740564e-15,  -8.485692962976241e-16,   1.394083344601032e-17,   6.893999608852031e-19,
  -3.957871002318001e-20,   3.662028257008405e-22,  -1.179813700093493e-03,   5.094166673701008e-05,  -6.877685567765425e-08,  -7.581250679044947e-08,   2.800222202129655e-09,
   1.683384291124020e-11,  -5.077880772267069e-12,   1.535578436421239e-13,   2.988063224232024e-15,  -3.156885130002181e-16,   5.181792436599963e-18,   2.566084833299622e-19,
  -1.471961876965928e-20,   1.358278280087598e-22,  -1.332691235700356e-04,   5.754231729635766e-06,  -7.767038532221822e-09,  -8.563592133467467e-09,   3.162984480986916e-10,
   1.901867058332483e-12,  -5.735767794560980e-13,   1.734429898787011e-14,   3.375504875017368e-16,  -3.565790855423375e-17,   5.852167353524404e-19,   2.898706910886876e-20,
  -1.662539503623467e-21,   1.533481415822815e-23,  -2.818792933675343e-02,  -4.925946208092499e-04,   4.240136293583343e-05,   1.394024511341091e-06,  -5.750250137295189e-08,
  -3.234439957691361e-09,   6.056545770665324e-11,   6.510056827165791e-12,  -2.143378693602557e-14,  -1.083529436604048e-14,  -9.048361458085781e-17,   1.564271668805971e-17,
   3.183302221510424e-19,  -2.023397423111748e-20,  -2.681561360221119e-02,  -4.685121500906077e-04,   4.032875528809845e-05,   1.325269436804037e-06,  -5.467862274469796e-08,
  -3.073105048272239e-09,   5.760103071960464e-11,   6.181981099728129e-12,  -2.050739950881605e-14,  -1.028312328947250e-14,  -8.547884400891276e-17,   1.483585263260449e-17,
   3.009478132108122e-19,  -1.918157216422273e-20,  -2.420582062057657e-02,  -4.227544754557040e-04,   3.639057015601877e-05,   1.194876970153097e-06,  -4.931824703808606e-08,
  -2.767867728977401e-09,   5.196974567105119e-11,   5.562624324402369e-12,  -1.869699593739763e-14,  -9.243152316172224e-15,  -7.620961180495898e-17,   1.332001869257997e-17,
   2.686734676602070e-19,  -1.720781414894451e-20,  -2.061473072649235e-02,  -3.598710926993969e-04,   3.097816124623865e-05,   1.016156785145110e-06,  -4.196156329365555e-08,
  -2.350914661339078e-09,   4.423340469615387e-11,   4.719191380146981e-12,  -1.611260351083946e-14,  -7.831664778987065e-15,  -6.393212139433429e-17,   1.127010874061808e-17,
   2.257643412580001e-19,  -1.454521851746282e-20,  -1.639439386076032e-02,  -2.860694249577682e-04,   2.462565830154816e-05,   8.070051364179192e-07,  -3.334013384525040e-08,
  -1.864755187651608e-09,   3.515729019825072e-11,   3.739062728556072e-12,  -1.295892097060643e-14,  -6.197409698790068e-15,  -5.009969531193271e-17,   8.906117585767505e-18,
   1.772105470912658e-19,  -1.148311214228820e-20,  -1.195802704715271e-02,  -2.085835275497926e-04,   1.795571072990996e-05,   5.879703998669059e-07,  -2.430006544736024e-08,
  -1.357291465785325e-09,   2.563152737375304e-11,   2.719060464367066e-12,  -9.536710625828961e-15,  -4.502265533964852e-15,  -3.610851031381941e-17,   6.462897074191381e-18,
   1.278957127866390e-19,  -8.326373100559046e-21,  -7.739602943744412e-03,  -1.349697252767124e-04,   1.161884673295865e-05,   3.802718343539387e-07,  -1.571999340771755e-08,
  -8.772611260327039e-10,   1.658430906323767e-11,   1.756358659520424e-12,  -6.208383840052901e-15,  -2.906279554045637e-15,  -2.318586474756661e-17,   4.168827534883987e-18,
   8.219918565418504e-20,  -5.368024812314851e-21,  -4.151608454922952e-03,  -7.239045207837838e-05,   6.231750105144085e-06,   2.039047331669406e-07,  -8.430241512093064e-09,
  -4.702368632830467e-10,   8.894568557079878e-12,   9.411669032007969e-13,  -3.340108832426852e-15,  -1.556835573698540e-15,  -1.238644158860751e-17,   2.232311722557652e-18,
   4.393363699942469e-20,  -2.873675935441214e-21,  -1.544911485350208e-03,  -2.693705624040520e-05,   2.318887062130221e-06,   7.586775729189622e-08,  -3.136815115969964e-09,
  -1.749427732969896e-10,   3.309692379062784e-12,   3.501057200865258e-13,  -1.244208752560429e-15,  -5.790602351507603e-16,  -4.602728427774084e-18,   8.301920039979143e-19,
   1.632819274272443e-20,  -1.068613041322390e-21,  -1.745094949532814e-04,  -3.042724824719548e-06,   2.619342303551399e-07,   8.569660504518708e-09,  -3.543221500392390e-10,
  -1.976033702088630e-11,   3.738515664988275e-13,   3.954486739454199e-14,  -1.405656864363425e-16,  -6.540432619959919e-17,  -5.197956460370397e-19,   9.376746740674421e-20,
   1.844025288779318e-21,  -1.206945321374188e-22,  -9.812351783670013e-03,  -7.448473729707080e-04,  -3.155564339159936e-05,  -7.502848448840777e-07,   4.078781828674220e-09,
   1.381524857264939e-09,   7.276854071896226e-11,   1.973262849044659e-12,  -9.097658123306207e-16,  -2.698475689242004e-15,  -1.315190944042883e-16,  -3.310110525283754e-18,
  -7.046866258337319e-21,   3.949820431233195e-21,  -9.336012723762135e-03,  -7.086838721042007e-04,  -3.001995954763319e-05,  -7.133762696522699e-07,   3.912832460750354e-09,
   1.315545192181639e-09,   6.922728946439301e-11,   1.874358087381870e-12,  -1.041515484881452e-15,  -2.572542814113773e-15,  -1.251292707874036e-16,  -3.139706588940023e-18,
  -6.119849926643274e-21,   3.775429325314615e-21,  -8.429581119479543e-03,  -6.398698790448242e-04,  -2.709923523893421e-05,  -6.433399513402864e-07,   3.583989680995904e-09,
   1.189546736161381e-09,   6.249194338526065e-11,   1.687410923442543e-12,  -1.220589555037201e-15,  -2.330819558409991e-15,  -1.129705414012408e-16,  -2.819343047333075e-18,
  -4.593993735134343e-21,   3.436394726411127e-21,  -7.181246606320595e-03,  -5.451033849654782e-04,  -2.307983134350571e-05,  -5.472693887573770e-07,   3.105806589042111e-09,
   1.015162284862245e-09,   5.322273127791689e-11,   1.432397565389204e-12,  -1.328365876883251e-15,  -1.993901197777258e-15,  -9.622820199640048e-17,  -2.385754087701462e-18,
  -2.954256129130771e-21,   2.955668833496108e-21,  -5.712806629673999e-03,  -4.336327403005410e-04,  -1.835554612622545e-05,  -4.347453140993698e-07,   2.511301644814653e-09,
   8.089465431945673e-10,   4.232794120794979e-11,   1.135531465108357e-12,  -1.279474170144724e-15,  -1.592526964202947e-15,  -7.653958779772933e-17,  -1.885433805710978e-18,
  -1.609540859834376e-21,   2.372888200228412e-21,  -4.167925941012359e-03,  -3.163641471089066e-04,  -1.338890269312389e-05,  -3.168168837164974e-07,   1.856024462263623e-09,
   5.909895671776327e-10,   3.087446175587272e-11,   8.261215432844381e-13,  -1.064335044638780e-15,  -1.165582575011246e-15,  -5.583360361246667e-17,  -1.368202634332255e-18,
  -7.391645148361921e-22,   1.743818677993394e-21,  -2.698046154055269e-03,  -2.047920700774630e-04,  -8.665886095304582e-06,  -2.049315478195502e-07,   1.211664414305792e-09,
   3.829107951119138e-10,   1.998310617818252e-11,   5.337777592810943e-13,  -7.449418104814170e-16,  -7.561064298853392e-16,  -3.613940135547061e-17,  -8.825257404546554e-19,
  -2.924243459321042e-22,   1.134207017867641e-21,  -1.447381925447240e-03,  -1.098613926638311e-04,  -4.648525282509342e-06,  -1.098938940051371e-07,   6.528120114818694e-10,
   2.055088368839150e-10,   1.071920836857935e-11,   2.860723562302366e-13,  -4.150422936421124e-16,  -4.060529678680898e-16,  -1.938612021728750e-17,  -4.725635232133082e-19,
  -1.056229935067539e-22,   6.099272670951546e-22,  -5.386205398248471e-04,  -4.088313926866304e-05,  -1.729832206252404e-06,  -4.088975190175535e-08,   2.432974341207682e-10,
   7.648909411647758e-11,   3.988876435681051e-12,   1.064216289982843e-13,  -1.564478465328552e-16,  -1.511626135735577e-16,  -7.214100485330660e-18,  -1.757440328664260e-19,
  -3.266843698471136e-23,   2.271657642496365e-22,  -6.084156299305971e-05,  -4.618081444602865e-06,  -1.953978077364955e-07,  -4.618730124327086e-09,   2.748893884260725e-11,
   8.640282761971913e-12,   4.505740182104624e-13,   1.202054662880092e-14,  -1.770783797864548e-17,  -1.707605436752337e-17,  -8.148886788220190e-19,  -1.984968771734938e-20,
  -3.571191761403283e-24,   2.566363746647885e-23,  -2.408718401259664e-03,   1.732404942031734e-04,  -8.101570102826910e-06,   3.017691252517287e-07,  -9.652552056583343e-09,
   2.628984673308076e-10,  -5.580198876375967e-12,   1.054691368436520e-13,  -2.828385595879852e-16,  -1.465108908891383e-16,   6.389722915261201e-18,  -1.349442908681986e-19,
   2.381458671963590e-21,  -6.944020990951275e-23,  -2.291800949880330e-03,   1.648410848413109e-04,  -7.709234969046360e-06,   2.871693352330551e-07,  -9.185537920433390e-09,
   2.501760994442900e-10,  -5.308962386580337e-12,   1.001807456999189e-13,  -2.604940583444366e-16,  -1.396067303463406e-16,   6.083649178110808e-18,  -1.285397988114717e-19,
   2.270277338453787e-21,  -6.593127481031514e-23,  -2.069311882787278e-03,   1.488534679644604e-04,  -6.962267514345644e-06,   2.593670619538504e-07,  -8.296212618700893e-09,
   2.259501196735944e-10,  -4.792954276718434e-12,   9.018565188713901e-14,  -2.214736600619286e-16,  -1.263842928788560e-16,   5.499554612609475e-18,  -1.162925858663613e-19,
   2.056881412093070e-21,  -5.931044412125937e-23,  -1.762890200849002e-03,   1.268270809729194e-04,  -5.932793888151304e-06,   2.210387878690350e-07,  -7.070199778068940e-09,
   1.925544827238164e-10,  -4.082573742688781e-12,   7.655304896014979e-14,  -1.745255017348775e-16,  -1.080104203145710e-16,   4.691906111487639e-18,  -9.930984516087837e-20,
   1.759475567142846e-21,  -5.030131405508953e-23,  -1.402427056242104e-03,   1.009065056322310e-04,  -4.720851042054640e-06,   1.759030164750086e-07,  -5.626451905714423e-09,
   1.532306514714658e-10,  -3.247288531501456e-12,   6.068502596711682e-14,  -1.279041387889029e-16,  -8.618887571966133e-17,   3.737741186992683e-18,  -7.918669592580573e-20,
   1.405218651918161e-21,  -3.984140584964859e-23,  -1.023187131673374e-03,   7.362680643438851e-05,  -3.444930536042793e-06,   1.283715207899343e-07,  -4.106089890866183e-09,
   1.118228000482727e-10,  -2.368861022294767e-12,   4.414824219184319e-14,  -8.688629704701055e-17,  -6.303707130094683e-17,   2.730057110244903e-18,  -5.788053280717020e-20,
   1.028443672902066e-21,  -2.896509543735396e-23,  -6.623496547841740e-04,   4.766460130102257e-05,  -2.230329984387829e-06,   8.311522889884884e-08,  -2.658516243809500e-09,
   7.239941087392618e-11,  -1.533324934898829e-12,   2.852473559221638e-14,  -5.349336763590848e-17,  -4.087280325665841e-17,   1.768587113646419e-18,  -3.751414664664122e-20,
   6.671241500595501e-22,  -1.870644167491703e-23,  -3.553223766734813e-04,   2.557086752866667e-05,  -1.196556836342550e-06,   4.459198019995328e-08,  -1.426313270397995e-09,
   3.884252053170357e-11,  -8.225265820222641e-13,   1.528737222140611e-14,  -2.793870023835183e-17,  -2.194482054064335e-17,   9.491336509641543e-19,  -2.013733753795062e-20,
   3.582606706825161e-22,  -1.002314468337103e-23,  -1.322278199249169e-04,   9.515918255737913e-06,  -4.452907696239195e-07,   1.659477145031574e-08,  -5.307979632205927e-10,
   1.445508319021951e-11,  -3.060859579406477e-13,   5.687028380314064e-15,  -1.029874544832508e-17,  -8.168802443562962e-18,   3.532525648519718e-19,  -7.495434484785995e-21,
   1.333700348289867e-22,  -3.728398613218964e-24,  -1.493620861125394e-05,   1.074902376190265e-06,  -5.029940242575331e-08,   1.874524270328940e-09,  -5.995825839996346e-11,
   1.632827014184307e-12,  -3.457481432248675e-14,   6.423614657070860e-16,  -1.161566549215926e-18,  -9.227752362439808e-19,   3.990359364642533e-20,  -8.466995601995555e-22,
   1.506610504719700e-23,  -4.211249711813914e-25,  -1.790149351572062e-02,   8.669284265598499e-04,  -1.313659986952730e-05,  -6.060129702509166e-07,   4.172593974866004e-08,
  -9.516633160232487e-10,  -1.380225945872593e-11,   2.173947971629383e-12,  -6.541125883178949e-14,  -8.041537475287525e-16,   1.005867173664250e-16,  -2.413957365054927e-18,
  -2.029407593693061e-20,   3.320137172898876e-21,  -1.703113856459889e-02,   8.247061552826573e-04,  -1.249020382360959e-05,  -5.768150651698448e-07,   3.969001583182584e-08,
  -9.040210380437945e-10,  -1.318459543363111e-11,   2.067319212951951e-12,  -6.209542058386334e-14,  -7.689124684505304e-16,   9.565113935825005e-17,  -2.288816547350360e-18,
  -1.959424073035798e-20,   3.160652599855565e-21,  -1.537547047915514e-02,   7.444167757574081e-04,  -1.126370599340607e-05,  -5.211634895617281e-07,   3.582001076150003e-08,
  -8.139507722652160e-10,  -1.198775481557113e-11,   1.864854180744338e-12,  -5.584295524128083e-14,  -7.002878283171469e-16,   8.627982002470672e-17,  -2.053918760951505e-18,
  -1.814454648672360e-20,   2.856371207526111e-21,  -1.309633941848508e-02,   6.339509115584181e-04,  -9.581431538096495e-06,  -4.443454465764433e-07,   3.049838688290798e-08,
  -6.910467539030437e-10,  -1.029799118157674e-11,   1.586878736077514e-12,  -4.734302567732505e-14,  -6.027650564094175e-16,   7.341446253695600e-17,  -1.736692513052851e-18,
  -1.592112760272258e-20,   2.435878990804898e-21,  -1.041668155722771e-02,   5.041449678894100e-04,  -7.611208794721358e-06,  -3.537624803774519e-07,   2.424879818974651e-08,
  -5.479140517279415e-10,  -8.258045654605566e-12,   1.260985850777737e-12,  -3.748463187750006e-14,  -4.842615338853298e-16,   5.833346926945521e-17,  -1.371479621283799e-18,
  -1.302127384290321e-20,   1.939590528605779e-21,  -7.598769934099375e-03,   3.677097559174189e-04,  -5.546500587305210e-06,  -2.582595219704836e-07,   1.768356304945043e-08,
  -3.986727753493107e-10,  -6.063440308044836e-12,   9.191565552677716e-13,  -2.724361339679578e-14,  -3.560859691118508e-16,   4.251766374864587e-17,  -9.946675365944838e-19,
  -9.707893055824588e-21,   1.416072717622860e-21,  -4.918529771174850e-03,   2.379878222430671e-04,  -3.587686890734064e-06,  -1.672501105562665e-07,   1.144386555006592e-08,
  -2.576167133064186e-10,  -3.941542181371575e-12,   5.946472750121277e-13,  -1.759118492839148e-14,  -2.316925346935813e-16,   2.750549302947739e-17,  -6.413463393088605e-19,
  -6.372806990926079e-21,   9.170780548741355e-22,  -2.638456163452190e-03,   1.276578490480141e-04,  -1.923874625624240e-06,  -8.974140050702933e-08,   6.138206858777158e-09,
  -1.380737122477113e-10,  -2.118991740547771e-12,   3.189037884190165e-13,  -9.424615122655806e-15,  -1.246187060062925e-16,   1.475057538867432e-17,  -3.433547964245392e-19,
  -3.443058498903206e-21,   4.920794258724123e-22,  -9.818450820251194e-04,   4.750431102442851e-05,  -7.158414104640319e-07,  -3.339833667138117e-08,   2.284118601139700e-09,
  -5.136562713857794e-11,  -7.891359494136988e-13,   1.186623441179842e-13,  -3.505633547087476e-15,  -4.641708280215946e-17,   5.488559757009515e-18,  -1.276835720690948e-19,
  -1.284428049080963e-21,   1.831334122822997e-22,  -1.109071028510873e-04,   5.365969645529385e-06,  -8.085833482850995e-08,  -3.772657704595055e-09,   2.580076063082637e-10,
  -5.801871655961344e-12,  -8.914982034762215e-14,   1.340364727052876e-14,  -3.959612806040412e-16,  -5.243942245826058e-18,   6.199659758754914e-19,  -1.442127311906021e-20,
  -1.451429784568012e-22,   2.068665115765166e-23,  -2.940150685500822e-02,  -1.062284452009051e-04,   5.188646358608603e-05,   9.145412169660904e-08,  -9.479685001356740e-08,
  -2.070821950943662e-11,   1.779617665142956e-10,   3.161123888333598e-13,  -3.032469744710962e-13,  -7.751985423910731e-16,   4.791027098334427e-16,   7.867805951353683e-19,
  -7.614505090616135e-19,  -9.524286120566107e-22,  -2.796988995639246e-02,  -1.010533125740550e-04,   4.934597088889915e-05,   8.700020137992592e-08,  -9.010748996424884e-08,
  -1.950747044459470e-11,   1.690568056645775e-10,   2.999155871391125e-13,  -2.878678290751693e-13,  -7.362260953809981e-16,   4.543402236839694e-16,   7.464078351070363e-19,
  -7.212245169679980e-19,  -8.982921243548201e-22,  -2.524741040649705e-02,  -9.121293682805143e-05,   4.452048069516703e-05,   7.853068027191856e-08,  -8.121981867143131e-08,
  -1.730286095393805e-11,   1.522204219315122e-10,   2.694429909374437e-13,  -2.588733262040960e-13,  -6.626155189217388e-16,   4.078406331173226e-16,   6.704937189332920e-19,
  -6.460298708940390e-19,  -7.985811399295334e-22,  -2.150143563233160e-02,  -7.767524174108019e-05,   3.789195651133417e-05,   6.687784225821206e-08,  -6.904892674831692e-08,
  -1.442163878672406e-11,   1.292439180955597e-10,   2.281498399474337e-13,  -2.194641476856235e-13,  -5.623017799007955e-16,   3.449971897663383e-16,   5.676878338223199e-19,
  -5.450688126484377e-19,  -6.675795554641450e-22,  -1.709929230472857e-02,  -6.176885332044924e-05,   3.011633177517526e-05,   5.318463440930420e-08,  -5.481936413915288e-08,
  -1.122738366763790e-11,   1.024814544940880e-10,   1.804253182503720e-13,  -1.737626924911084e-13,  -4.456380082311631e-16,   2.725729989590112e-16,   4.489231902299903e-19,
  -4.295559306223099e-19,  -5.213422173422188e-22,  -1.247201579780735e-02,  -4.505146355773618e-05,   2.195607595683026e-05,   3.879178720964929e-08,  -3.993020326462555e-08,
  -8.047566333394323e-12,   7.457202333042715e-11,   1.310054030218727e-13,  -1.262901244952397e-13,  -3.241409232742872e-16,   1.977645040974152e-16,   3.259627634250066e-19,
  -3.110255189450479e-19,  -3.746976441265027e-22,  -8.072202903888831e-03,  -2.915759231698077e-05,   1.420607640653428e-05,   2.510684990565468e-08,  -2.582060568702822e-08,
  -5.148181548872113e-12,   4.818945145567948e-11,   8.453602060603432e-14,  -8.154607931084588e-14,  -2.094072467835872e-16,   1.275520399213377e-16,   2.103445930928298e-19,
  -2.003298012937156e-19,  -2.401515161178265e-22,  -4.329999641770384e-03,  -1.564015110850318e-05,   7.619037432573617e-06,   1.346748706585449e-08,  -1.384400251447050e-08,
  -2.744910853061223e-12,   2.582847935066257e-11,   4.527594580409855e-14,  -4.368919621170720e-14,  -1.122219662712167e-16,   6.829739103030431e-17,   1.126587927108607e-19,
  -1.071911443114564e-19,  -1.281714235109602e-22,  -1.611292582159622e-03,  -5.820030056099916e-06,   2.835060633368614e-06,   5.011556405016203e-09,  -5.150844212711412e-09,
  -1.019293406301965e-12,   9.608684352796211e-12,   1.683917069393040e-14,  -1.625091858469829e-14,  -4.174667038672018e-17,   2.539916475655276e-17,   4.190071595722157e-20,
  -3.985369059470087e-20,  -4.761178301879166e-23,  -1.820077000501902e-04,  -6.574159279973948e-07,   3.202387257792536e-07,   5.660931493341537e-10,  -5.818120238004792e-10,
  -1.150983579567602e-13,   1.085325499470674e-12,   1.901949631720731e-15,  -1.835541794402140e-15,  -4.715356920290879e-18,   2.868743683108477e-18,   4.732605237402368e-21,
  -4.501156167243459e-21,  -5.376611060893580e-24,  -1.334843446513579e-02,  -1.029392565173002e-03,  -3.890046105481175e-05,  -3.519230405901153e-07,   5.309756584619826e-08,
   3.655094934549356e-09,   1.042812065816300e-10,  -8.699352088560781e-13,  -2.199159203647688e-13,  -9.672050863909066e-15,  -1.407065923819085e-16,   7.891625693597211e-18,
   6.169368978541456e-19,   1.883127346126907e-20,  -1.270030460201955e-02,  -9.793518727351628e-04,  -3.699874623573700e-05,  -3.337205580726574e-07,   5.056068138973726e-08,
   3.476718495892654e-09,   9.902485546898930e-11,  -8.378809941705385e-13,  -2.093975093451809e-13,  -9.188290869323040e-15,  -1.326533662700873e-16,   7.550190947191221e-18,
   5.868271630734071e-19,   1.782364300791990e-20,  -1.146702361149805e-02,  -8.841567761456792e-04,  -3.338535377315534e-05,  -2.995385675498670e-07,   4.571651122212371e-08,
   3.137657892968780e-09,   8.910130134055732e-11,  -7.727200705707487e-13,  -1.893155596386931e-13,  -8.273439041209494e-15,  -1.178270856144008e-16,   6.883205326691029e-18,
   5.295781924297202e-19,   1.594388483906778e-20,  -9.768657271726192e-03,  -7.531087464391329e-04,  -2.841948763785934e-05,  -2.533462745468509e-07,   3.901288056449163e-08,
   2.671438644006234e-09,   7.558758057374794e-11,  -6.749289308829614e-13,  -1.615324085664957e-13,  -7.024651224234081e-15,  -9.837381588621668e-17,   5.931464670765807e-18,
   4.508445445534696e-19,   1.342849645037592e-20,  -7.770968323556842e-03,  -5.990233559431790e-04,  -2.259132619304701e-05,  -2.001261716566111e-07,   3.108663372055301e-08,
   2.123957731995996e-09,   5.988495544466492e-11,  -5.497389530446054e-13,  -1.286940785562430e-13,  -5.569919003293925e-15,  -7.671141453765486e-17,   4.770398233133203e-18,
   3.583946018482137e-19,   1.056306081701863e-20,  -5.669411851112486e-03,  -4.369813541025700e-04,  -1.647216804353536e-05,  -1.451759486462431e-07,   2.271007164740971e-08,
   1.548867076843795e-09,   4.354580359032778e-11,  -4.085960697484036e-13,  -9.400362103866229e-14,  -4.052860155604297e-15,  -5.505840673549985e-17,   3.510619782538440e-18,
   2.613118467245606e-19,   7.636085526921075e-21,  -3.669968687824980e-03,  -2.828514066557413e-04,  -1.065877436820641e-05,  -9.362211170558368e-08,   1.471384576817309e-08,
   1.002326353874151e-09,   2.812677597308076e-11,  -2.677102891525454e-13,  -6.089911724025953e-14,  -2.618915077107288e-15,  -3.525290402993681e-17,   2.285425056635254e-18,
   1.690825885419729e-19,   4.912900353247254e-21,  -1.968763477254879e-03,  -1.517311225011068e-04,  -5.716789741628229e-06,  -5.012621234974304e-08,   7.896849879620736e-09,
   5.376178365732812e-10,   1.507169125532839e-11,  -1.444986236953868e-13,  -3.268260988972041e-14,  -1.403649091889346e-15,  -1.880466267541467e-17,   1.229565837817864e-18,
   9.068436489207888e-20,   2.627219798481676e-21,  -7.326430090779814e-04,  -5.646357393813530e-05,  -2.127262403884025e-06,  -1.864100776191868e-08,   2.939145473692760e-09,
   2.000549460998789e-10,   5.606482297937075e-12,  -5.388734560128580e-14,  -1.216399326407576e-14,  -5.221797613805163e-16,  -6.984009863434331e-18,   4.580211654683750e-19,
   3.374402105059369e-20,   9.765987793414557e-22,  -8.275794892815598e-05,  -6.378004946632377e-06,  -2.402888446185864e-07,  -2.105425928664145e-09,   3.320085223012431e-10,
   2.259763096312584e-11,   6.332580465603495e-13,  -6.089064315375335e-15,  -1.374051731272236e-15,  -5.898146196994621e-17,  -7.886523474324555e-19,   5.174540609953588e-20,
   3.811611721448867e-21,   1.102953993781548e-22,  -1.825680585546721e-03,   1.206444280567394e-04,  -5.254449401497476e-06,   1.830539665934149e-07,  -5.515005008217868e-09,
   1.600221050640941e-10,  -3.254153676204960e-12,   5.135561382712359e-14,  -2.149908293698789e-15,   1.531254292008345e-17,   2.209659530582545e-18,  -6.109397804783565e-20,
   1.522828234955512e-21,   1.679256382801522e-23,  -1.737036549493321e-03,   1.147926615108651e-04,  -4.999858580880848e-06,   1.741978346576298e-07,  -5.248211315608840e-09,
   1.522707134548531e-10,  -3.097643139662890e-12,   4.887336390935841e-14,  -2.042355588343172e-15,   1.446815490828428e-17,   2.105155813313503e-18,  -5.808829846932932e-20,
   1.447589702667634e-21,   1.561406323817144e-23,  -1.568361530376157e-03,   1.036552729148094e-04,  -4.515197130021903e-06,   1.573331073559270e-07,  -4.740148059061007e-09,
   1.375136419358926e-10,  -2.799218489763876e-12,   4.414531342993830e-14,  -1.838984067912518e-15,   1.290257884779292e-17,   1.905165532390673e-18,  -5.238614301788221e-20,
   1.304935157763807e-21,   1.352163798764533e-23,  -1.336076067959439e-03,   8.831303953430644e-05,  -3.847340130907454e-06,   1.340832442621536e-07,  -4.039711032695348e-09,
   1.171769622163941e-10,  -2.387071959242892e-12,   3.762519291657041e-14,  -1.561410728388043e-15,   1.082629140475521e-17,   1.627554948274935e-18,  -4.456572576541679e-20,
   1.109492286116838e-21,   1.092881815383404e-23,  -1.062850819629786e-03,   7.026078123754085e-05,  -3.061242031180618e-06,   1.067038261042078e-07,  -3.214843065938205e-09,
   9.323769677813126e-11,  -1.900797298116412e-12,   2.994470891561693e-14,  -1.238078780891577e-15,   8.484791248620892e-18,   1.298237244176121e-18,  -3.540589091780102e-20,
   8.809057535839082e-22,   8.240963409115759e-24,  -7.754180538421724e-04,   5.126423092022733e-05,  -2.233770520873690e-06,   7.787103265684742e-08,  -2.346167495279876e-09,
   6.803654730313423e-11,  -1.387854720445701e-12,   2.185460733914819e-14,  -9.008891418563570e-16,   6.115308300239132e-18,   9.492102871963973e-19,  -2.580443608792741e-20,
   6.416699137954123e-22,   5.747592506706109e-24,  -5.019503459435270e-04,   3.318671941704972e-05,  -1.446153762032911e-06,   5.041830097515530e-08,  -1.519055006806252e-09,
   4.404784700204086e-11,  -8.988681945509098e-13,   1.415051212482316e-14,  -5.821572072336544e-16,   3.926600617305550e-18,   6.153324354628548e-19,  -1.669287163789053e-20,
   4.149372630207972e-22,   3.607817338123669e-24,  -2.692726249671402e-04,   1.780363256504778e-05,  -7.758399546582136e-07,   2.704982998226089e-08,  -8.149875651845389e-10,
   2.363119559143668e-11,  -4.823296342109267e-13,   7.592011665611672e-15,  -3.120202728451214e-16,   2.097619391635254e-18,   3.303394214144025e-19,  -8.951921765124470e-21,
   2.224741219867020e-22,   1.904435168008977e-24,  -1.002054081767487e-04,   6.625399241669154e-06,  -2.887222316277563e-07,   1.006651440057227e-08,  -3.032954977599589e-10,
   8.794171719122675e-12,  -1.795078395259424e-13,   2.825363399877719e-15,  -1.160770312011556e-16,   7.794530816859409e-19,   1.229618411270441e-19,  -3.330923224971982e-21,
   8.277452389250422e-23,   7.046952951356927e-25,  -1.131901107068645e-05,   7.483936377569544e-07,  -3.261361930696051e-08,   1.137100685465733e-09,  -3.425987937451493e-11,
   9.933765361949091e-13,  -2.027716202549649e-14,   3.191497952764512e-16,  -1.311119001384202e-17,   8.802506403957497e-20,   1.389009736449111e-20,  -3.762477640724343e-22,
   9.349772213642704e-24,   7.952919270110635e-26,  -1.467594990413811e-02,   7.426179975126825e-04,  -1.704343455405026e-05,  -9.233278142042075e-08,   2.305913222224295e-08,
  -7.931554283446194e-10,   1.774477555668704e-11,   1.882081023506379e-13,  -4.687007995968414e-14,   1.227172840736929e-15,   1.067744344782469e-17,  -1.212574716258177e-18,
   4.240162231025628e-20,  -1.402013251726903e-23,  -1.396260747059634e-02,   7.064881252585208e-04,  -1.621030400353651e-05,  -8.807710767856302e-08,   2.194529260689820e-08,
  -7.544524663736080e-10,   1.684273367457681e-11,   1.803533728680823e-13,  -4.457534733591417e-14,   1.165499716098546e-15,   1.024050615187566e-17,  -1.153625951389998e-18,
   4.026974580301735e-20,  -1.327089833229423e-23,  -1.260554588724189e-02,   6.377685264874382e-04,  -1.462727319381748e-05,  -7.988659488065050e-08,   1.982346398180101e-08,
  -6.808841851990181e-10,   1.514278886910609e-11,   1.648815544701877e-13,  -4.021643329591085e-14,   1.048996388096781e-15,   9.375710438474494e-18,  -1.041485616061970e-18,
   3.624218840803319e-20,  -1.184724838746794e-23,  -1.073731617613946e-02,   5.431909320630457e-04,  -1.245167294793587e-05,  -6.842773887179057e-08,   1.689687565564030e-08,
  -5.797224865845532e-10,   1.283371256672183e-11,   1.425592840302274e-13,  -3.422854415200473e-14,   8.902060230366600e-16,   8.120283818364083e-18,  -8.871125858735095e-19,
   3.075278326668278e-20,  -9.916218635660748e-24,  -8.540581055227340e-03,   4.320169778346399e-04,  -9.898224560394731e-06,  -5.472219364042651e-08,   1.344872610432658e-08,
  -4.609234437886550e-10,   1.015806368662267e-11,   1.150220570845049e-13,  -2.720432546759353e-14,   7.055151294409083e-16,   6.562274913101415e-18,  -7.056050552161716e-19,
   2.436910568888289e-20,  -7.721293278404588e-24,  -6.230331662655999e-03,   3.151298948241150e-04,  -7.217217140051572e-06,  -4.009242114018311e-08,   9.815944620567789e-09,
  -3.361275924839125e-10,   7.380904405465140e-12,   8.486351132291436e-14,  -1.983279096875583e-14,   5.131644311125373e-16,   4.847742809390844e-18,  -5.147283690058789e-19,
   1.772269755887380e-20,  -5.518958778063133e-24,  -4.032827798470101e-03,   2.039693956170039e-04,  -4.670126035374666e-06,  -2.602525887933407e-08,   6.355948032784795e-09,
  -2.175224920875638e-10,   4.765021415966669e-12,   5.533918689444348e-14,  -1.283209687493249e-14,   3.315213843662285e-16,   3.163761705361108e-18,  -3.331743985776956e-19,
   1.144826637581144e-20,  -3.518672540827813e-24,  -2.163354027831028e-03,   1.094135371903081e-04,  -2.504809855902468e-06,  -1.398122986161050e-08,   3.410162094023919e-09,
  -1.166732670336557e-10,   2.552669782493207e-12,   2.979820743421124e-14,  -6.882089977869470e-15,   1.776624581378607e-16,   1.704275212123491e-18,  -1.787256669944211e-19,
   6.134779947768422e-21,  -1.871915631696056e-24,  -8.050481293639327e-04,   4.071563154167055e-05,  -9.320603493098276e-07,  -5.205464705424073e-09,   1.269100369855279e-09,
  -4.341581201151046e-11,   9.494760504134918e-13,   1.110333187795471e-14,  -2.560833868335367e-15,   6.609046833736714e-17,   6.351330269790184e-19,  -6.650897535418288e-20,
   2.282092431204737e-21,  -6.945217938397423e-25,  -9.093653901771176e-05,   4.599144935191659e-06,  -1.052826105742998e-07,  -5.880455440883074e-10,   1.433562997296415e-10,
  -4.904126877733952e-12,   1.072427822301454e-13,   1.254469477533619e-15,  -2.892628838021634e-16,   7.465027733597845e-18,   7.175980694990056e-20,  -7.512711075789330e-21,
   2.577652675379871e-22,  -7.841428575788946e-26,  -2.902390503536989e-02,   2.888820301068989e-04,   4.458397946685655e-05,  -1.212359100147399e-06,  -5.710549150630018e-08,
   3.357047020061895e-09,   7.060780143317555e-11,  -6.647493163066591e-12,  -6.262217267007681e-14,   1.041265046208251e-14,  -4.295287339734703e-17,  -1.508793624464975e-17,
   3.147926093607756e-19,   2.207135048232237e-20,  -2.761086215929206e-02,   2.747244792912091e-04,   4.240529008834179e-05,  -1.152404110955304e-06,  -5.429657500044314e-08,
   3.189660560637981e-09,   6.712098859319434e-11,  -6.313178286256974e-12,  -5.962883741478749e-14,   9.881981835439777e-15,  -4.026705197280978e-17,  -1.430406376252021e-17,
   2.975749520963046e-19,   2.090976612009400e-20,  -2.492362796829656e-02,   2.478385147628458e-04,   3.826529344160860e-05,  -1.038765143763623e-06,  -4.896644720892128e-08,
   2.872947854567051e-09,   6.050992782470603e-11,  -5.681771310428933e-12,  -5.391270061070072e-14,   8.882535630084973e-15,  -3.540589112741038e-17,  -1.283364805439543e-17,
   2.656155219212534e-19,   1.873653221295423e-20,  -2.122600062002495e-02,   2.109169930706958e-04,   3.257505160556539e-05,  -8.831327208282914e-07,  -4.165484302817743e-08,
   2.440269180417894e-09,   5.145184526956949e-11,  -4.821399977267389e-12,  -4.600260745333981e-14,   7.526089245901509e-15,  -2.919007417291380e-17,  -1.084945745675619e-17,
   2.231442433714148e-19,   1.581513648040453e-20,  -1.688048632140383e-02,   1.676190881953215e-04,   2.589585488721499e-05,  -7.011584480148914e-07,  -3.309073980989012e-08,
   1.935710957988778e-09,   4.085575123689725e-11,  -3.820914727701354e-12,  -3.665156558652971e-14,   5.955593488007810e-15,  -2.247654607782896e-17,  -8.566688501340239e-18,
   1.751129159360649e-19,   1.246851190702769e-20,  -1.231256064636070e-02,   1.221916007277945e-04,   1.888232365801784e-05,  -5.107332897417784e-07,  -2.411495836104528e-08,
   1.408984051476414e-09,   2.976322155479783e-11,  -2.779095971651894e-12,  -2.677214289345101e-14,   4.326596373800044e-15,  -1.596401728734772e-17,  -6.212480516960064e-18,
   1.263566276428556e-19,   9.030795015062948e-21,  -7.969059033930203e-03,   7.905653772069971e-05,   1.221863703831728e-05,  -3.302675712315965e-07,  -1.559882191912147e-08,
   9.106914063520459e-10,   1.924789772206385e-11,  -1.795357574933445e-12,  -1.734404708736899e-14,   2.792886847093069e-15,  -1.014934435423864e-17,  -4.005548711639594e-18,
   8.119887818766017e-20,   5.817850041755977e-21,  -4.274688765355725e-03,   4.239864181967827e-05,   6.553500234031539e-06,  -1.770780307148946e-07,  -8.364868567432556e-09,
   4.881618522251327e-10,   1.032043712683223e-11,  -9.621254473897640e-13,  -9.307991605288259e-15,   1.496094991726047e-15,  -5.393954423925778e-18,  -2.144398187475295e-18,
   4.339586736941023e-20,   3.113291979875367e-21,  -1.590712253730197e-03,   1.577647883635651e-05,   2.438619951314625e-06,  -6.588440781858789e-08,  -3.112439740493862e-09,
   1.816121277528153e-10,   3.839914976669396e-12,  -3.579099499609850e-13,  -3.464298078668942e-15,   5.564681947271985e-16,  -2.000716813287646e-18,  -7.974348132456206e-19,
   1.612791861605860e-20,   1.157563136818040e-21,  -1.796830341340457e-04,   1.782054264772639e-06,   2.754590074293053e-07,  -7.441956330542279e-09,  -3.515678958860568e-10,
   2.051367414200429e-11,   4.337374866158541e-13,  -4.042650517986025e-14,  -3.913290905746697e-16,   6.285258012534935e-17,  -2.258796946170570e-19,  -9.006653274922709e-20,
   1.821399968597804e-21,   1.307382389045480e-22,  -1.808646778608098e-02,  -1.336720962803211e-03,  -3.523976968344409e-05,   1.191553847096007e-06,   1.437247459590578e-07,
   4.738076168821393e-09,  -7.165050651509036e-11,  -1.324216423492379e-11,  -4.857143661662827e-13,   2.891287548717920e-15,   1.058078697623809e-15,   4.380485043435780e-17,
   6.720789221245593e-20,  -7.724506964860095e-20,  -1.720774601498789e-02,  -1.271593477147311e-03,  -3.350013997421520e-05,   1.134979515577727e-06,   1.367004597429543e-07,
   4.499364252013945e-09,  -6.856162172496658e-11,  -1.259448795721661e-11,  -4.606734842328690e-13,   2.820553388764508e-15,   1.006638725026855e-15,   4.149415262044820e-17,
   5.432067823882516e-20,  -7.355765043580364e-20,  -1.553590633473217e-02,  -1.147757749363018e-03,  -3.020156339619308e-05,   1.026803132147012e-06,   1.233528349772718e-07,
   4.048663926777631e-09,  -6.252353603316811e-11,  -1.136388450949212e-11,  -4.136183241007844e-13,   2.657189145843201e-15,   9.087580167779497e-16,   3.717192198686020e-17,
   3.378855731561426e-20,  -6.651061207066268e-20,  -1.323401948369817e-02,  -9.773981847382069e-04,  -2.568161041258873e-05,   8.768177669818166e-07,   1.050075501555574e-07,
   3.434833342220484e-09,  -5.389900790595938e-11,  -9.672822593609148e-12,  -3.499681352264019e-13,   2.376859430928750e-15,   7.739922944308072e-16,   3.136457813008047e-17,
   1.317703493190563e-20,  -5.675164138911056e-20,  -1.052698190609268e-02,  -7.772372355947356e-04,  -2.039357982195590e-05,   6.991204391738903e-07,   8.347483585957394e-08,
   2.721462134802066e-09,  -4.336547320644113e-11,  -7.688455924800041e-12,  -2.765551084022104e-13,   1.977700508503399e-15,   6.155483369920056e-16,   2.471729766634878e-17,
  -1.478999169587140e-21,  -4.521111504418963e-20,  -7.679696363865880e-03,  -5.668771712135634e-04,  -1.485717359211526e-05,   5.109973261700969e-07,   6.086553306652780e-08,
   1.979048291028256e-09,  -3.192400394752954e-11,  -5.605462918516606e-12,  -2.006807620432019e-13,   1.493659242733787e-15,   4.489697523748495e-16,   1.789569866845660e-17,
  -8.061177238732618e-21,  -3.301968479003524e-20,  -4.971110293637161e-03,  -3.668842273215834e-04,  -9.608386831836456e-06,   3.311862217530324e-07,   3.938510488639788e-08,
   1.278344259910120e-09,  -2.078734244464846e-11,  -3.626948613118237e-12,  -1.294428980507962e-13,   9.885298687343069e-16,   2.905778708517654e-16,   1.152571345973005e-17,
  -8.189613888776301e-21,  -2.138873319777837e-20,  -2.666716684676352e-03,  -1.967963036582282e-04,  -5.151942212676613e-06,   1.777766399169720e-07,   2.112413401256174e-08,
   6.850137435978923e-10,  -1.118498229163169e-11,  -1.945234551661280e-12,  -6.931232385975438e-14,   5.362470543972609e-16,   1.558658135012546e-16,   6.166830224914777e-18,
  -5.209418018419945e-21,  -1.147778500382903e-20,  -9.923687083374607e-04,  -7.323197283451176e-05,  -1.916886967449782e-06,   6.617102773533732e-08,   7.860468270022562e-09,
   2.548185719474644e-10,  -4.166651232063630e-12,  -7.238285355323658e-13,  -2.577691408426492e-14,   2.003250684317226e-16,   5.800086229622231e-17,   2.292790560151546e-18,
  -2.044152438334727e-21,  -4.271745530565315e-21,  -1.120959558319657e-04,  -8.272097628374380e-06,  -2.165220717954565e-07,   7.474809893693830e-09,   8.878938894775403e-10,
   2.878205966985906e-11,  -4.707347718021046e-13,  -8.176123200714880e-14,  -2.911414489383214e-15,   2.264212458607418e-17,   6.551629287071437e-18,   2.589516867881181e-19,
  -2.327947642417566e-22,  -4.825366685990088e-22,  -1.415091439764932e-03,   8.611290410870154e-05,  -3.494349408078592e-06,   1.165346911422433e-07,  -3.015227601462179e-09,
   9.241757778901373e-11,  -2.598757710582650e-12,   4.506888762137200e-15,  -4.561842224388563e-16,   7.112556116109901e-17,   9.648524207494962e-19,  -1.606585452097420e-20,
  -1.207244586710603e-21,  -1.461143340718320e-22,  -1.346365609081084e-03,   8.193479061844527e-05,  -3.324923794207659e-06,   1.108938908308396e-07,  -2.869726273998597e-09,
   8.792552773071367e-11,  -2.472725762770418e-12,   4.363589944615502e-15,  -4.327243296064748e-16,   6.763657549332302e-17,   9.154978190908896e-19,  -1.561419199312348e-20,
  -1.153592557389460e-21,  -1.383425525516957e-22,  -1.215598785396365e-03,   7.398330394438489e-05,  -3.002437651346098e-06,   1.001532811482723e-07,  -2.592494915618986e-09,
   7.937991744244174e-11,  -2.232845904891605e-12,   4.060116237473470e-15,  -3.886220935909038e-16,   6.101134857124590e-17,   8.225920123610775e-19,  -1.461889765769049e-20,
  -1.049336602237841e-21,  -1.238298210640054e-22,  -1.035531216940300e-03,   6.303079205524260e-05,  -2.558147724438382e-06,   8.534844101626490e-08,  -2.210004472384689e-09,
   6.761545749675961e-11,  -1.902384673686178e-12,   3.582546236522484e-15,  -3.289265547659295e-16,   5.191498478992758e-17,   6.966162219017422e-19,  -1.298704705586385e-20,
  -9.017095514676849e-22,  -1.043785699735243e-22,  -8.237446511923280e-04,   5.014491918911982e-05,  -2.035314086601431e-06,   6.791688657205942e-08,  -1.759202320454874e-09,
   5.378232172702728e-11,  -1.513533032698143e-12,   2.945403399796534e-15,  -2.600168362494030e-16,   4.125113908565059e-17,   5.509451890192662e-19,  -1.074032593068050e-20,
  -7.231510048163825e-22,  -8.217550962155090e-23,  -6.009616595820950e-04,   3.658618722257609e-05,  -1.485070816009332e-06,   4.956269516832786e-08,  -1.284121124252738e-09,
   3.923424263777590e-11,  -1.104326138766282e-12,   2.204928591982913e-15,  -1.887355451587479e-16,   3.006709594247798e-17,   4.000537616654816e-19,  -8.074767218905785e-21,
  -5.309267154005411e-22,  -5.944833443133570e-23,  -3.890141311902454e-04,   2.368424757361475e-05,  -9.614051974104820e-07,   3.208889466288658e-08,  -8.315349162055240e-10,
   2.539600019446041e-11,  -7.149071891071852e-13,   1.451280008765273e-15,  -1.217628418568166e-16,   1.945106107752992e-17,   2.581529729165097e-19,  -5.328807962479371e-21,
  -3.450848676476711e-22,  -3.826709861035812e-23,  -2.086861468352703e-04,   1.270574314947086e-05,  -5.157694409532696e-07,   1.721570073366182e-08,  -4.461580794453328e-10,
   1.362335581859194e-11,  -3.835263037240462e-13,   7.851430723362840e-16,  -6.520692457463124e-17,   1.043118089826728e-17,   1.382624404507678e-19,  -2.886617748777988e-21,
  -1.855029010291477e-22,  -2.046912755601525e-23,  -7.765894078044206e-05,   4.728268965813995e-06,  -1.919378932316859e-07,   6.406739424082283e-09,  -1.660406615738793e-10,
   5.069657954953581e-12,  -1.427246514863068e-13,   2.930328680981243e-16,  -2.425105484561197e-17,   3.881352603098384e-18,   5.142301884813147e-20,  -1.077825226291915e-21,
  -6.908096812760911e-23,  -7.609563358196279e-24,  -8.772201703455277e-06,   5.340968239956076e-07,  -2.168098576084498e-08,   7.236965629075278e-10,  -1.875581847150507e-11,
   5.726579374172771e-13,  -1.612193211825307e-14,   3.311575136279011e-17,  -2.739090418926623e-18,   4.384222479694799e-19,   5.808124222360396e-21,  -1.218138951089791e-22,
  -7.804132420813870e-24,  -8.594239052318989e-25,  -1.197773728033791e-02,   6.070537402397053e-04,  -1.638755620854553e-05,   1.721257342031739e-07,   1.118322330022907e-08,
  -4.317009033863860e-10,   8.810735891432381e-12,  -5.926865692202838e-13,  -2.788892670834247e-15,   1.123911660919379e-15,  -5.738928694958969e-18,   8.939945273840632e-20,
  -5.714306098341027e-21,  -1.928568161216418e-21,  -1.139562043558369e-02,   5.775415490946316e-04,  -1.558845562121262e-05,   1.636240169576278e-07,   1.064318768947411e-08,
  -4.110671881431455e-10,   8.379812585734574e-12,  -5.626545371489922e-13,  -2.661014841972120e-15,   1.069348615649839e-15,  -5.471556138511180e-18,   8.067381211448064e-20,
  -5.487882403641447e-21,  -1.827788457490387e-21,  -1.028817149469132e-02,   5.213998708735147e-04,  -1.406928971084994e-05,   1.475052621412510e-07,   9.614384136476679e-09,
  -3.716703935666940e-10,   7.561100416175717e-12,  -5.060192849187233e-13,  -2.414639189769068e-15,   9.655112893933987e-16,  -4.958330069069874e-18,   6.587829764542706e-20,
  -5.034697741324178e-21,  -1.638917308517743e-21,  -8.763517092448108e-03,   4.441155621315326e-04,  -1.197991594235469e-05,   1.254215856785703e-07,   8.195266804671472e-09,
  -3.171572168441788e-10,   6.436095827386831e-12,  -4.290159429572565e-13,  -2.069426763849480e-15,   8.224998430323886e-16,  -4.242780887193866e-18,   4.898519336777637e-20,
  -4.368856124961645e-21,  -1.384444026406633e-21,  -6.970695268510388e-03,   3.532473458275050e-04,  -9.525709777239928e-06,   9.958987109647495e-08,   6.523083958494189e-09,
  -2.527099477227580e-10,   5.115936932130305e-12,  -3.396938557581881e-13,  -1.655842207334606e-15,   6.542786556753792e-16,  -3.389816066829903e-18,   3.348632357189389e-20,
  -3.535193034522472e-21,  -1.092253824985286e-21,  -5.085160522809498e-03,   2.576888267842260e-04,  -6.947070921824889e-06,   7.254947769842802e-08,   4.761202769860375e-09,
  -1.846088758476115e-10,   3.730055943454611e-12,  -2.468948363376524e-13,  -1.213703783623661e-15,   4.773196421686377e-16,  -2.481789720692025e-18,   2.122418555410008e-20,
  -2.613291158308797e-21,  -7.915321090757712e-22,  -3.291594787053342e-03,   1.667974573699652e-04,  -4.495948706458969e-06,   4.691725374595332e-08,   3.083000709040743e-09,
  -1.196053452779311e-10,   2.413565725443331e-12,  -1.594228121884845e-13,  -7.880904363611087e-16,   3.089727357911685e-16,  -1.610278704406458e-18,   1.237245012298827e-20,
  -1.705951851117998e-21,  -5.100971070351203e-22,  -1.765736609796658e-03,   8.947566665845097e-05,  -2.411563718467389e-06,   2.515618361363340e-08,   1.654142300983543e-09,
  -6.419087286196952e-11,   1.294486337425854e-12,  -8.541280998393748e-14,  -4.234420357661358e-16,   1.657461967288219e-16,  -8.648739351975471e-19,   6.261560123576969e-21,
  -9.190490712474691e-22,  -2.730134470631495e-22,  -6.570837697994923e-04,   3.329648243408329e-05,  -8.973851607644259e-07,   9.359817025154106e-09,   6.155954711961210e-10,
  -2.389124277391294e-11,   4.816859772578233e-13,  -3.177073620898511e-14,  -1.576636988733402e-16,   6.167932311215787e-17,  -3.219830596146151e-19,   2.281526183060609e-21,
  -3.425094754800437e-22,  -1.015159422297445e-22,  -7.422281244285908e-05,   3.761099291405529e-06,  -1.013662128803703e-07,   1.057237512030273e-09,   6.953708525274759e-11,
  -2.698774604879936e-12,   5.440968108441501e-14,  -3.588506192519566e-15,  -1.781094322726451e-17,   6.967170696042360e-18,  -3.637299948626184e-20,   2.568457376805270e-22,
  -3.869816764370696e-23,  -1.146558461681935e-23,  -2.726200585754583e-02,   5.772125651027365e-04,   2.689376018504990e-05,  -1.560097065597708e-06,   1.207677144233351e-08,
   2.900684830919286e-09,  -9.529343688814855e-11,  -3.906020073077868e-12,   1.803042839204223e-13,   2.067268260287653e-15,  -2.029467140639108e-16,   6.458687960005227e-18,
   1.757472002340307e-19,  -2.166024761052821e-20,  -2.593517031491798e-02,   5.489992557311773e-04,   2.558769049633834e-05,  -1.483358527869165e-06,   1.144742575128397e-08,
   2.757166716947388e-09,  -9.050977735401823e-11,  -3.713748577873568e-12,   1.712654698168649e-13,   1.976810171270934e-15,  -1.927364382886854e-16,   6.095633775965749e-18,
   1.666614214948971e-19,  -2.050883698101264e-20,  -2.341170527462642e-02,   4.953903426687680e-04,   2.310255422082609e-05,  -1.337741623857266e-06,   1.026747154237128e-08,
   2.485167852351125e-09,  -8.147140430598519e-11,  -3.348939167038786e-12,   1.541824804572021e-13,   1.800536422546473e-15,  -1.734545237039129e-16,   5.425252244894990e-18,
   1.496004026829839e-19,  -1.835879764530454e-20,  -1.993908604596228e-02,   4.217124634979850e-04,   1.968043095733457e-05,  -1.137991829349504e-06,   8.676533007353932e-09,
   2.112708799078564e-09,  -6.914851825363979e-11,  -2.848606177670101e-12,   1.308821549370199e-13,   1.549857027512063e-15,  -1.471836878459537e-16,   4.541387873373079e-18,
   1.265440714675440e-19,  -1.547692726845237e-20,  -1.585757802190313e-02,   3.352360659698777e-04,   1.565544003164189e-05,  -9.040244475268211e-07,   6.848073692818912e-09,
   1.677278445766594e-09,  -5.481020854210129e-11,  -2.262709997745083e-12,   1.037589103930976e-13,   1.245128487955728e-15,  -1.166381078424043e-16,   3.551034341583876e-18,
   9.997504648442605e-20,  -1.218661520549591e-20,  -1.156677322773553e-02,   2.444371344871884e-04,   1.142142254901921e-05,  -6.588101837383780e-07,   4.964368641314507e-09,
   1.221694975832820e-09,  -3.987169594041414e-11,  -1.648808683974582e-12,   7.548881271611636e-14,   9.155093651295058e-16,  -8.483341738139134e-17,   2.554684857185751e-18,
   7.253402882912015e-20,  -8.817493059954639e-21,  -7.486498900889016e-03,   1.581716831858864e-04,   7.393314657781527e-06,  -4.261531149635662e-07,   3.200022444272589e-09,
   7.899886427580588e-10,  -2.576060001480273e-11,  -1.066469932417823e-12,   4.877639793938475e-14,   5.956535228883647e-16,  -5.480352598061780e-17,   1.638378163316394e-18,
   4.678107160172986e-20,  -5.676478220027243e-21,  -4.015875752537768e-03,   8.483524642572189e-05,   3.966135877986360e-06,  -2.285246414275913e-07,   1.712929760477422e-09,
   4.235576051510006e-10,  -1.380572110986780e-11,  -5.718757463312981e-13,   2.614154997837214e-14,   3.203677049355145e-16,  -2.936881299647633e-17,   8.746965526445347e-19,
   2.504847034692289e-20,  -3.036540348278662e-21,  -1.494406688909976e-03,   3.156792940624490e-05,   1.475929045253113e-06,  -8.503052960856309e-08,   6.369557859215049e-10,
   1.575897472670174e-10,  -5.135809814560467e-12,  -2.127837594309013e-13,   9.724955365742888e-15,   1.193266033354549e-16,  -1.092515227438030e-17,   3.249586225310542e-19,
   9.315250424805174e-21,  -1.128882837198908e-21,  -1.688046757869127e-04,   3.565814843801804e-06,   1.667180542788832e-07,  -9.604685413382280e-09,   7.194064886491416e-11,
   1.780049314120056e-11,  -5.800996333528026e-13,  -2.403510003418244e-14,   1.098455071187947e-15,   1.348082138671597e-17,  -1.234013110049859e-18,   3.669693095762412e-20,
   1.052123032476531e-21,  -1.274964428392421e-22,  -2.384360762127278e-02,  -1.516495764291189e-03,  -4.729809763547503e-06,   4.002929060559562e-06,   1.839259835469995e-07,
  -2.715785291780464e-09,  -5.674015520172677e-10,  -1.592821147946116e-11,   7.041667552670074e-13,   6.365060135206733e-14,   8.775304328314057e-16,  -1.065579268223816e-16,
  -5.980719036045390e-18,   7.093002102264582e-22,  -2.268393975771300e-02,  -1.442377496525157e-03,  -4.467555081826560e-06,   3.807388283080046e-06,   1.747290016457154e-07,
  -2.593318388451235e-09,  -5.392106657793693e-10,  -1.508653067979257e-11,   6.709977463634718e-13,   6.038061301381268e-14,   8.234899090837587e-16,  -1.013542694205081e-16,
  -5.655806284930219e-18,   2.091910206998452e-21,  -2.047808132797194e-02,  -1.301540739928192e-03,  -3.981863999318336e-06,   3.435783968229277e-06,   1.573375932834978e-07,
  -2.356401286024765e-09,  -4.858279693096157e-10,  -1.351301928831411e-11,   6.074461428147715e-13,   5.423151822957133e-14,   7.254066759281056e-16,  -9.146031853624676e-17,
  -5.051735727512249e-18,   4.123846824864531e-21,  -1.744190312805156e-02,  -1.107975772054555e-03,  -3.338798415281169e-06,   2.924970452453557e-06,   1.335983461903918e-07,
  -2.022669273200893e-09,  -4.128186477141653e-10,  -1.140025750216931e-11,   5.191025930809270e-13,   4.590521640819768e-14,   5.994446602222646e-16,  -7.785457601654012e-17,
  -4.247229017121691e-18,   5.782896076368432e-21,  -1.387256910973077e-02,  -8.807810475694865e-04,  -2.614930200645008e-06,   2.325309337572616e-06,   1.059412469714079e-07,
  -1.620754066926104e-09,  -3.275823080425362e-10,  -8.983248903626002e-12,   4.141755390146837e-13,   3.629064126315517e-14,   4.626698922646316e-16,  -6.188204719523608e-17,
  -3.335366816662841e-18,   6.326227964252185e-21,  -1.011946471004701e-02,  -6.422248118085702e-04,  -1.883657099347055e-06,   1.695573308911222e-06,   7.709350318729587e-08,
  -1.189292569675871e-09,  -2.385124331463294e-10,  -6.503684117044864e-12,   3.028766154242103e-13,   2.634302121836497e-14,   3.292684673223123e-16,  -4.511403234926459e-17,
  -2.408001156298988e-18,   5.615752350009899e-21,  -6.549992053837509e-03,  -4.155759100554795e-04,  -1.209050317386522e-06,   1.097212092602040e-06,   4.982047162119464e-08,
  -7.727803528341766e-10,  -1.541904733750149e-10,  -4.188616720819690e-12,   1.963598112051303e-13,   1.699559206042389e-14,   2.096227704365674e-16,  -2.918868772178283e-17,
  -1.547948393442010e-18,   4.058717005084254e-21,  -3.513588051348534e-03,  -2.228942337855847e-04,  -6.457645835312979e-07,   5.884972891822202e-07,   2.670310109748721e-08,
  -4.153617722900576e-10,  -8.265926440718708e-11,  -2.241107433522302e-12,   1.054194665255126e-13,   9.101633527232482e-15,   1.114855397855397e-16,  -1.565410112175795e-17,
  -8.274251962140310e-19,   2.293245315240743e-21,  -1.307501986388626e-03,  -8.294093159332515e-05,  -2.399438464566399e-07,   2.189860300544751e-07,   9.934115401212046e-09,
  -1.546738129416610e-10,  -3.075295770083556e-11,  -8.332295186185662e-13,   3.924067553520807e-14,   3.384991282588443e-15,   4.136243828409612e-17,  -5.824859327337247e-18,
  -3.075276039905633e-19,   8.683670818874396e-22,  -1.476925196495499e-04,  -9.368749976633160e-06,  -2.709702179741948e-08,   2.473599851812407e-08,   1.122084754910764e-09,
  -1.747351624577281e-11,  -3.473663701200594e-12,  -9.410635551021664e-14,   4.432740355943958e-15,   3.823256965194749e-16,   4.669980731259854e-18,  -6.579549003248698e-19,
  -3.473082692158033e-20,   9.835724654227126e-23,  -1.118692906844314e-03,   6.305029467293575e-05,  -2.335260221248001e-06,   7.973473409757030e-08,  -1.778080534969336e-09,
   3.247509891287759e-11,  -2.256681437730946e-12,   3.483128553905138e-14,   2.282007883742576e-15,   5.374362160947336e-17,  -3.231118392216995e-18,  -1.879441423908829e-19,
  -1.760255104612296e-21,   3.294169145715976e-22,  -1.064349213000246e-03,   5.999063776328883e-05,  -2.221992011683317e-06,   7.586613292013363e-08,  -1.692593304419997e-09,
   3.091750567871360e-11,  -2.145040992626974e-12,   3.319254619214545e-14,   2.166663979884846e-15,   5.082944311576545e-17,  -3.076935852789749e-18,  -1.780455921328845e-19,
  -1.631711604045810e-21,   3.128917144132699e-22,  -9.609529684793000e-04,   5.416792765547351e-05,  -2.006413412127329e-06,   6.850367369485376e-08,  -1.529579664086803e-09,
   2.794588966280045e-11,  -1.933455258651928e-12,   3.005249590113665e-14,   1.949028363460811e-15,   4.541001805432715e-17,  -2.782337935894630e-18,  -1.595267875466891e-19,
  -1.405135939474754e-21,   2.816488324372392e-22,  -8.185851750812671e-04,   4.614803677489486e-05,  -1.709443277848584e-06,   5.836246464046645e-08,  -1.304422103673138e-09,
   2.383851300869888e-11,  -1.643714723749476e-12,   2.568645793292729e-14,   1.652899195574601e-15,   3.818893072984372e-17,  -2.374401935947259e-18,  -1.346360051005316e-19,
  -1.127567748961783e-21,   2.390291517199708e-22,  -6.511520591501763e-04,   3.671297584770028e-05,  -1.360015009822253e-06,   4.643105601127992e-08,  -1.038737028290797e-09,
   1.898803342974474e-11,  -1.304973082465302e-12,   2.049867151082257e-14,   1.309116210335893e-15,   2.999887999978201e-17,  -1.891906744954255e-18,  -1.061297592710997e-19,
  -8.439416741642824e-22,   1.894323691537873e-22,  -4.750374185368140e-04,   2.678573089684556e-05,  -9.923066586280373e-07,   3.387657097330405e-08,  -7.584516319659264e-10,
   1.386738876551198e-11,  -9.505345789467075e-13,   1.499304318853286e-14,   9.516927066353534e-16,   2.166364527464805e-17,  -1.381998335425910e-18,  -7.685771583888176e-20,
  -5.848479138340817e-22,   1.377739807588868e-22,  -3.074968323813404e-04,   1.733970763644473e-05,  -6.423863202390474e-07,   2.193018765565356e-08,  -4.912350178546460e-10,
   8.982924076811277e-12,  -6.146561938807572e-13,   9.721565932620986e-15,   6.146066161948104e-16,   1.392870407573427e-17,  -8.953249865641745e-19,  -4.950848634048327e-20,
  -3.654862022617543e-22,   8.899884987453045e-23,  -1.649551646724727e-04,   9.302080784739788e-06,  -3.446202918186758e-07,   1.176476003306938e-08,  -2.635980089031844e-10,
   4.820613817825059e-12,  -3.295545263719783e-13,   5.219591573800994e-15,   3.293074543839958e-16,   7.446036027309910e-18,  -4.804935682658296e-19,  -2.649189029147835e-20,
  -1.924726322472773e-22,   4.769194279735426e-23,  -6.138506581725957e-05,   3.461636505716325e-06,  -1.282461597121444e-07,   4.378095811405331e-09,  -9.810322911480085e-11,
   1.794132918323087e-12,  -1.226151003843248e-13,   1.942958781478909e-15,   1.224945828854833e-16,   2.767549462497802e-18,  -1.788327465928613e-19,  -9.849840990078589e-21,
  -7.116106994086938e-23,   1.774105120269284e-23,  -6.933934071574766e-06,   3.910201751920062e-07,  -1.448646485150013e-08,   4.945419051518480e-10,  -1.108172387484360e-11,
   2.026657679077402e-13,  -1.384995062098786e-14,   2.194831713955016e-16,   1.383582492549187e-17,   3.125566798080867e-19,  -2.020105011908652e-20,  -1.112463559115341e-21,
  -8.029897706184529e-24,   2.003874477126827e-24,  -9.795151550294069e-03,   4.866484882091356e-04,  -1.351100453341279e-05,   2.881134773365479e-07,   3.420109827581527e-09,
  -3.937802206330278e-10,  -3.308954643715776e-12,  -9.038869535577849e-14,   3.121939881729119e-14,   5.616091987271089e-16,  -3.792087480915822e-17,  -1.822207557106658e-18,
  -2.695629945408059e-20,   3.444107627196683e-21,  -9.319112934837519e-03,   4.630032165801175e-04,  -1.285321810895939e-05,   2.739823073238540e-07,   3.252377246720585e-09,
  -3.746803263551259e-10,  -3.122310856689926e-12,  -8.541095680867542e-14,   2.964976714953239e-14,   5.313886806522804e-16,  -3.612374804202178e-17,  -1.725647070926119e-18,
  -2.514384785603121e-20,   3.272419097122692e-21,  -8.413470757968401e-03,   4.180168699926734e-04,  -1.160228088203456e-05,   2.471508534618741e-07,   2.933906473858600e-09,
  -3.383278493885064e-10,  -2.777796322569493e-12,  -7.618320468590186e-14,   2.668484191213677e-14,   4.751039404920209e-16,  -3.268482841447505e-17,  -1.545215072374847e-18,
  -2.190549273357794e-20,   2.947360136553028e-21,  -7.166645367026380e-03,   3.560783886838589e-04,  -9.880991923146158e-06,   2.103128955313892e-07,   2.496669536897220e-09,
  -2.882501663222679e-10,  -2.323919302508160e-12,  -6.394436488631524e-14,   2.264417426543499e-14,   3.999400704047942e-16,  -2.791297527355501e-17,  -1.303133925825728e-18,
  -1.784846109400315e-20,   2.503067581073730e-21,  -5.700514379785212e-03,   2.832399300892538e-04,  -7.858100573297329e-06,   1.671242440827932e-07,   1.984035992539245e-09,
  -2.293268909644356e-10,  -1.815971660953902e-12,  -5.013527981311416e-14,   1.794510059944457e-14,   3.144710439506555e-16,  -2.225649373267263e-17,  -1.026455574306859e-18,
  -1.357759078470269e-20,   1.984984737579415e-21,  -4.158560246632812e-03,   2.066293723118124e-04,  -5.731670601785562e-06,   1.218220999632637e-07,   1.446276214024506e-09,
  -1.673221492723221e-10,  -1.305687614433844e-12,  -3.614915529543036e-14,   1.305188141339490e-14,   2.272748766484810e-16,  -1.626707696893858e-17,  -7.428885909455779e-19,
  -9.544299218997557e-21,   1.444415638221014e-21,  -2.691813401923061e-03,   1.337518199456611e-04,  -3.709710574395128e-06,   7.881369495249651e-08,   9.357036012707292e-10,
  -1.083180700552687e-10,  -8.370186765517982e-13,  -2.321829804122687e-14,   8.431640566990871e-15,   1.462048527756413e-16,  -1.054251424258592e-17,  -4.783404145401621e-19,
  -6.024801976631682e-21,   9.333699946283548e-22,  -1.443991503301367e-03,   7.175006621254720e-05,  -1.989928893544787e-06,   4.226735693925090e-08,   5.018200915615092e-10,
  -5.810906090251879e-11,  -4.467668631383124e-13,  -1.240550124523591e-14,   4.518431577374746e-15,   7.818007652848419e-17,  -5.658924325305698e-18,  -2.559044114036349e-19,
  -3.189916153156405e-21,   5.002509981176289e-22,  -5.373527824541015e-04,   2.670042572741230e-05,  -7.404993996154594e-07,   1.572749207053634e-08,   1.867259637182208e-10,
  -2.162453594076340e-11,  -1.659651683662673e-13,  -4.610034738839302e-15,   1.680845807709680e-15,   2.906084657129833e-17,  -2.106309375649031e-18,  -9.513968019801764e-20,
  -1.181632302560330e-21,   1.861006011445484e-22,  -6.069825079679785e-05,   3.016025582171853e-06,  -8.364503375748860e-08,   1.776518459561857e-09,   2.109188159452453e-11,
  -2.442669729869631e-12,  -1.874187757036302e-14,  -5.206247729815950e-16,   1.898541058443585e-16,   3.282073591716476e-18,  -2.379324248682397e-19,  -1.074516579253277e-20,
  -1.333774174804647e-22,   2.102049691066879e-23,  -2.463215575239486e-02,   7.242293001867750e-04,   1.077155947203547e-05,  -1.052032874472946e-06,   4.186448955588319e-08,
  -1.991039484121038e-11,  -1.206152193834596e-10,   2.031630421310516e-12,   1.713176763830463e-13,  -1.622930031395520e-15,  -8.141841590489639e-17,  -5.591958707610975e-18,
  -3.323288693761652e-19,   1.665281962856116e-20,  -2.343370850132256e-02,   6.889087132768167e-04,   1.025496477758793e-05,  -1.000863692051173e-06,   3.977494223216135e-08,
  -1.768204601767732e-11,  -1.146065008888845e-10,   1.931014350517337e-12,   1.628708249422437e-13,  -1.552768464421753e-15,  -7.807498669009385e-17,  -5.281775739918948e-18,
  -3.129731467302824e-19,   1.581217844109018e-20,  -2.115426064413092e-02,   6.217631039922942e-04,   9.269347963303074e-06,  -9.035327762492781e-07,   3.582211566698304e-08,
  -1.395715269013585e-11,  -1.032350714798830e-10,   1.740348858098907e-12,   1.468491481921962e-13,  -1.415659197145858e-15,  -7.145619460150895e-17,  -4.707399796011757e-18,
  -2.774822316487429e-19,   1.422470673815064e-20,  -1.801713046126964e-02,   5.294190507013293e-04,   7.906967862054305e-06,  -7.695661589720553e-07,   3.042356113639550e-08,
  -9.824707587048718e-12,  -8.769564284496793e-11,   1.479324350312196e-12,   1.248859189154284e-13,  -1.219944263548561e-15,  -6.185203528253089e-17,  -3.947037649242845e-18,
  -2.311755315300410e-19,   1.206301368286017e-20,  -1.432954312580121e-02,   4.209557187606347e-04,   6.298077723931063e-06,  -6.120770718959971e-07,   2.413027244705919e-08,
  -6.223186278908744e-12,  -6.956952890809665e-11,   1.174268222890068e-12,   9.918057522718231e-14,  -9.811360588609065e-16,  -4.994896393259203e-17,  -3.091247512585727e-18,
  -1.799135730107420e-19,   9.552662726087268e-21,  -1.045249279185101e-02,   3.069979099166729e-04,   4.599586559671006e-06,  -4.464822040546469e-07,   1.756250161583342e-08,
  -3.605665274081406e-12,  -5.064242974666482e-11,   8.552058375907545e-13,   7.226016857144953e-14,  -7.220156071538225e-16,  -3.687372321965488e-17,  -2.226763754302825e-18,
  -1.289341435531353e-19,   6.943170269347685e-21,  -6.765415269386234e-03,   1.986787849567752e-04,   2.979465935076912e-06,  -2.889918059521108e-07,   1.135073143584677e-08,
  -1.934728752898446e-12,  -3.273399413016224e-11,   5.529560130228107e-13,   4.673376714382192e-14,  -4.700214755903105e-16,  -2.405280272053251e-17,  -1.429282816097622e-18,
  -8.247449175425413e-20,   4.483170941882055e-21,  -3.629109641933884e-03,   1.065680642559716e-04,   1.598899010036812e-06,  -1.550224515916765e-07,   6.084181031014515e-09,
  -9.279503687269604e-13,  -1.754693928241865e-11,   2.964571556366741e-13,   2.505876560949192e-14,  -2.528686666353857e-16,  -1.295342856643635e-17,  -7.633954639919624e-19,
  -4.397238740138494e-20,   2.401856026947338e-21,  -1.350485920447769e-03,   3.965578851400343e-05,   5.950761845345723e-07,  -5.768803722693794e-08,   2.263487685325785e-09,
  -3.310858188496078e-13,  -6.528084406681328e-12,   1.102986611012717e-13,   9.323694019184538e-15,  -9.419459213381884e-17,  -4.826896987649111e-18,  -2.836518619784936e-19,
  -1.632852690911099e-20,   8.934013890365201e-22,  -1.525478032846880e-04,   4.479410125841729e-06,   6.721995770760013e-08,  -6.516311678959887e-09,   2.556677489687233e-10,
  -3.714366844095249e-14,  -7.373690456387340e-13,   1.245871273688048e-14,   1.053159438241885e-15,  -1.064171851030736e-17,  -5.453532886037276e-19,  -3.203300601722906e-20,
  -1.843810671447484e-21,   1.009095507333980e-22,  -2.962250063468378e-02,  -1.321572473071041e-03,   5.652861443113860e-05,   5.692632429358709e-06,  -2.064001261244871e-08,
  -1.708847153946222e-08,  -3.793561332662321e-10,   3.680066044250243e-11,   1.933123784120249e-12,  -4.633459546491789e-14,  -6.065956915251243e-15,  -3.711309592093335e-17,
   1.397761598862717e-17,   4.426169340204743e-19,  -2.817997781169027e-02,  -1.256792670459278e-03,   5.377496294892881e-05,   5.410730462943116e-06,  -1.979927377043271e-08,
  -1.623454244835540e-08,  -3.593399573686539e-10,   3.496072987878006e-11,   1.831198065766845e-12,  -4.413245015081948e-14,  -5.744149002326788e-15,  -3.434581925956797e-17,
   1.323760545801290e-17,   4.162980484243948e-19,  -2.543681721584912e-02,  -1.133777211541024e-03,   4.853882674811223e-05,   4.876566820417816e-06,  -1.813281760891483e-08,
  -1.461955894830214e-08,  -3.219116327990319e-10,   3.148120148416809e-11,   1.640582858321746e-12,  -3.992064941042775e-14,  -5.143072179671810e-15,  -2.948810090948559e-17,
   1.185466358176487e-17,   3.682501257309102e-19,  -2.166250050550792e-02,  -9.648540607811118e-04,   4.133508296165698e-05,   4.145311116630272e-06,  -1.570962505205519e-08,
  -1.241468748026642e-08,  -2.716371740191037e-10,   2.673133052414880e-11,   1.384494321711475e-12,  -3.408096029361395e-14,  -4.337003260205564e-15,  -2.357434175920113e-17,
   9.998793310773020e-18,   3.059558297301012e-19,  -1.722719571208451e-02,  -7.667697112692758e-04,   3.287065742034417e-05,   3.290664303585845e-06,  -1.269846665850070e-08,
  -9.845379165952804e-09,  -2.140937427465295e-10,   2.119736208732366e-11,   1.091308533710891e-12,  -2.716519362452184e-14,  -3.416057739931583e-15,  -1.757744105399275e-17,
   7.877024091030479e-18,   2.374821867138747e-19,  -1.256519768992541e-02,  -5.589538275160155e-04,   2.397449408054367e-05,   2.396680911113409e-06,  -9.382104479739808e-09,
  -7.164929864554709e-09,  -1.550291633859799e-10,   1.542516613044467e-11,   7.903003638485052e-13,  -1.984903098607350e-14,  -2.472338961629122e-15,  -1.214214082702360e-17,
   5.701668374913718e-18,   1.698296666108009e-19,  -8.132465733451390e-03,  -3.616328082210231e-04,   1.551647666378088e-05,   1.549701466772202e-06,  -6.123475164670131e-09,
  -4.630415305525654e-09,  -9.985796888285375e-11,   9.968174327737151e-12,   5.090794992423561e-13,  -1.286138685174500e-14,  -1.591940421088970e-15,  -7.571314291749270e-18,
   3.671597553030800e-18,   1.084822715923920e-19,  -4.362312227526622e-03,  -1.939454725810438e-04,   8.323055624059098e-06,   8.308628955399199e-07,  -3.298743338615191e-09,
  -2.481893275485273e-09,  -5.343251085732796e-11,   5.342775478807372e-12,   2.724087811789084e-13,  -6.902912917718513e-15,  -8.516715113232339e-16,  -3.982622305601969e-18,
   1.964341435390663e-18,   5.779742244821095e-20,  -1.623315165277575e-03,  -7.216672035890687e-05,   3.097185434730862e-06,   3.091300763636605e-07,  -1.229357431908299e-09,
  -9.233234149218019e-10,  -1.986636565723644e-11,   1.987620526495275e-12,   1.012834268461460e-13,  -2.569240981140388e-15,  -3.166342818637885e-16,  -1.471860431959699e-18,
   7.303119444153853e-19,   2.145692161254364e-20,  -1.833657118505326e-04,  -8.151690564664592e-06,   3.498502774553072e-07,   3.491763082014444e-08,  -1.388978293577644e-10,
  -1.042919591796402e-10,  -2.243749992584290e-12,   2.245069451519024e-13,   1.143918631291832e-14,  -2.902243134120212e-16,  -3.576100232056994e-17,  -1.660757249719488e-19,
   8.248235179480546e-20,   2.422811339639860e-21,  -8.984350612181968e-04,   4.774437905929125e-05,  -1.535947984239021e-06,   5.402984490003117e-08,  -1.545447392964656e-09,
  -1.215700671260471e-12,  -2.330389298420680e-13,   9.952150491152947e-14,   2.799986443049289e-16,  -1.812531565609355e-16,  -4.872038101853132e-18,   2.923159458994798e-19,
   1.724370349466883e-20,  -2.442303365350774e-22,  -8.547809539740644e-04,   4.542689527548997e-05,  -1.461514896456266e-06,   5.140164231256156e-08,  -1.470379501567590e-09,
  -1.095331369685581e-12,  -2.215063396315418e-13,   9.448999678747065e-14,   2.601251977505405e-16,  -1.719645736154459e-16,  -4.602494697971421e-18,   2.775158322552938e-19,
   1.629014640942979e-20,  -2.335241015563785e-22,  -7.717271939676999e-04,   4.101682070656518e-05,  -1.319822625496678e-06,   4.640259918432120e-08,  -1.327549846645763e-09,
  -8.914281647720005e-13,  -1.996573416069929e-13,   8.499772535911678e-14,   2.249247227567684e-16,  -1.544899706886525e-16,  -4.103335074818263e-18,   2.495973487474476e-19,
   1.452414888067517e-20,  -2.126395000809316e-22,  -6.573772043646046e-04,   3.494307644927893e-05,  -1.124582517860691e-06,   3.952216682470350e-08,  -1.130880283072029e-09,
  -6.591946872228965e-13,  -1.697470897483170e-13,   7.208372431644205e-14,   1.814603344404147e-16,  -1.308117927440539e-16,  -3.442255919593944e-18,   2.116261273252781e-19,
   1.218500013063316e-20,  -1.829290089626497e-22,  -5.229047642334047e-04,   2.779815465440566e-05,  -8.947887207167233e-07,   3.143389865768309e-08,  -8.995784439923261e-10,
  -4.472310829521034e-13,  -1.347803455494763e-13,   5.709249404982426e-14,   1.365861030192462e-16,  -1.034472855622094e-16,  -2.697505160628826e-18,   1.675698385672235e-19,
   9.549370305341983e-21,  -1.468456561584069e-22,  -3.814691979250818e-04,   2.028105686658111e-05,  -6.529125030995706e-07,   2.292950984882865e-08,  -6.562774875206551e-10,
  -2.810530113893812e-13,  -9.818620194902165e-14,   4.150606523862611e-14,   9.512236392143927e-17,  -7.511172407451171e-17,  -1.944213477336508e-18,   1.217931941164111e-19,
   6.883071571171847e-21,  -1.078857038627372e-22,  -2.469259143731433e-04,   1.312872963441152e-05,  -4.226945576494666e-07,   1.484141956678195e-08,  -4.248174371322136e-10,
  -1.626237751356715e-13,  -6.349822648819029e-14,   2.680552078973534e-14,   5.965153516274298e-17,  -4.846841233517711e-17,  -1.248431589424342e-18,   7.864297654402220e-20,
   4.419987396583458e-21,  -7.015099980134660e-23,  -1.324613113455491e-04,   7.043003155138737e-06,  -2.267681938754091e-07,   7.961304698085405e-09,  -2.278917622215298e-10,
  -8.192637814210926e-14,  -3.404735322067981e-14,   1.436268889802524e-14,   3.147219866844556e-17,  -2.595875758838797e-17,  -6.669486175642937e-19,   4.213380169985652e-20,
   2.361337914079615e-21,  -3.771768908383322e-23,  -4.929295477188135e-05,   2.620946396557971e-06,  -8.438970416172375e-08,   2.962615761522663e-09,  -8.480584563148431e-11,
  -2.979968893278344e-14,  -1.266805011040677e-14,   5.342613006201294e-15,   1.164358970610286e-17,  -9.654657695345387e-18,  -2.478350959551114e-19,   1.567234952255776e-20,
   8.774692652637328e-22,  -1.404694994102714e-23,  -5.568031382525616e-06,   2.960572277719435e-07,  -9.532528561419000e-09,   3.346504421096747e-10,  -9.579499682678277e-12,
  -3.353787700718823e-15,  -1.430920829348745e-15,   6.034514261078676e-16,   1.314014414422483e-18,  -1.090473620027467e-18,  -2.798854735917833e-20,   1.770192082930431e-21,
   9.909460202798428e-23,  -1.586912027078769e-24,  -8.042343056215510e-03,   3.926979964446535e-04,  -9.996389954548836e-06,   2.767917627790499e-07,  -4.842469080452174e-09,
  -3.862627633302326e-10,   8.229892023557932e-12,   7.957448253600792e-13,   7.978352800809276e-15,  -2.014082372074975e-15,  -5.291041137662194e-17,   3.188218746535685e-18,
   1.905543259416701e-19,  -2.455134417725104e-21,  -7.651459291008426e-03,   3.736215052666514e-04,  -9.511017011339019e-06,   2.632151811647207e-07,  -4.603235850655999e-09,
  -3.669879785848329e-10,   7.835842733443419e-12,   7.549192998473288e-13,   7.522408438658273e-15,  -1.910960536588447e-15,  -4.997736589470661e-17,   3.027241767962930e-18,
   1.799797722333208e-19,  -2.351482006228824e-21,  -6.907832915968059e-03,   3.373259038125241e-04,  -8.587434474359679e-06,   2.374372512592055e-07,  -4.149684920246358e-09,
  -3.305248465009748e-10,   7.083697835934113e-12,   6.781339028537948e-13,   6.683389583950272e-15,  -1.716920511588125e-15,  -4.454796623656290e-17,   2.723397083821144e-18,
   1.604093284374039e-19,  -2.147374223389207e-21,  -5.884083847388664e-03,   2.873499978214938e-04,  -7.315557670916225e-06,   2.020464818256903e-07,  -3.528333230910508e-09,
  -2.807230458760501e-10,   6.043457169249779e-12,   5.741260381185006e-13,   5.582688319623958e-15,  -1.453923936412856e-15,  -3.736163073279001e-17,   2.309797722078775e-18,
   1.345142209503224e-19,  -1.853510016188686e-21,  -4.680296878883564e-03,   2.285753897852367e-04,  -5.819524346957763e-06,   1.605551490069872e-07,  -2.801576876825639e-09,
  -2.226626555111328e-10,   4.814363840496787e-12,   4.539703915517031e-13,   4.356249491862263e-15,  -1.149892960623145e-15,  -2.927112773550305e-17,   1.829485146131058e-18,
   1.053716038710158e-19,  -1.492496366599959e-21,  -3.414282667349760e-03,   1.667533706867960e-04,  -4.245708227175408e-06,   1.170336846129681e-07,  -2.040862341447508e-09,
  -1.620642039102683e-10,   3.516326084271012e-12,   3.295909355221775e-13,   3.128753069620857e-15,  -8.349896186633358e-16,  -2.109287728386367e-17,   1.330021007373358e-18,
   7.592286921146210e-20,  -1.099134079312339e-21,  -2.210036903153531e-03,   1.079412064195318e-04,  -2.748364543079432e-06,   7.571583950282786e-08,  -1.319795904315123e-09,
  -1.047455831716141e-10,   2.277887770022660e-12,   2.126668231754519e-13,   2.004329153727400e-15,  -5.388343446241138e-16,  -1.354253963140749e-17,   8.589396466482094e-19,
   4.874223132885248e-20,  -7.157863915877455e-22,  -1.185545528096814e-03,   5.790451683526627e-05,  -1.474366430976139e-06,   4.060601333289907e-08,  -7.076463519055604e-10,
  -5.614615124105580e-11,   1.222436345262120e-12,   1.138967523307528e-13,   1.069463723996346e-15,  -2.885972920194985e-16,  -7.234335995004011e-18,   4.602223809410299e-19,
   2.603680732732881e-20,  -3.851490183923795e-22,  -4.411768967132504e-04,   2.154811158612907e-05,  -5.486612242866841e-07,   1.510931658291075e-08,  -2.632921704109131e-10,
  -2.088806103948416e-11,   4.549687920334438e-13,   4.236035951058560e-14,   3.972381601993303e-16,  -1.073369773472106e-16,  -2.688183934045498e-18,   1.711918719390515e-19,
   9.674808409537648e-21,  -1.434766021473359e-22,  -4.983441693375135e-05,   2.434031489957825e-06,  -6.197571871424662e-08,   1.706691732283205e-09,  -2.974013956089660e-11,
  -2.359371230112456e-12,   5.139346189236954e-14,   4.784506829742830e-15,   4.485790975776485e-17,  -1.212350791152469e-17,  -3.035812368063435e-19,   1.933620850887131e-20,
   1.092590498187087e-21,  -1.620952002338561e-23,  -2.162793224618172e-02,   7.703771169508593e-04,   1.721042972207378e-06,  -5.132088969069202e-07,   1.997042116185691e-08,
  -1.703502986848564e-09,  -3.618403989732154e-12,   5.377854533845167e-12,  -1.255552704763317e-14,  -9.535463734753479e-15,  -1.700333709877427e-16,   1.334049956434012e-17,
   9.231677470423492e-19,  -1.005472812045388e-20,  -2.057588607576085e-02,   7.328589914862559e-04,   1.640889131360546e-06,  -4.887425175114055e-07,   1.899739458364823e-08,
  -1.617333795728040e-09,  -3.454065173221521e-12,   5.106216425625576e-12,  -1.215827600105172e-14,  -9.050079044416529e-15,  -1.600295449846175e-16,   1.266712890319006e-17,
   8.711976104510636e-19,  -9.654466727789757e-21,  -1.857479812673603e-02,   6.615142094606775e-04,   1.486980802262766e-06,  -4.420016447366893e-07,   1.714725437041935e-08,
  -1.454784309171857e-09,  -3.136969974444852e-12,   4.593649695076611e-12,  -1.131277008862942e-14,  -8.135649188039433e-15,  -1.417244600789753e-16,   1.139599130223452e-17,
   7.752903099453972e-19,  -8.853851041635207e-21,  -1.582058117011691e-02,   5.633533102169611e-04,   1.272339585760003e-06,  -3.772759683770498e-07,   1.460205438783649e-08,
  -1.233671081467645e-09,  -2.691558602625579e-12,   3.896118562475941e-12,  -9.977841068928207e-15,  -6.894103376560528e-15,  -1.179135368089137e-16,   9.665472583632064e-18,
   6.489242831411970e-19,  -7.678927866861095e-21,  -1.258286127676065e-02,   4.480048884430172e-04,   1.016463966849409e-06,  -3.006916798314572e-07,   1.161164937689770e-08,
  -9.770367153843409e-10,  -2.156238108849249e-12,   3.086145668934672e-12,  -8.196559327243042e-15,  -5.456087859261129e-15,  -9.164554664227733e-17,   7.655640280297519e-18,
   5.073996876002272e-19,  -6.210153168091958e-21,  -9.178573837191615e-03,   3.267639471177489e-04,   7.441111162414926e-07,  -2.197067845716497e-07,   8.468907567384804e-09,
  -7.102603447823185e-10,  -1.582130143515960e-12,   2.243792664945408e-12,  -6.130245460358158e-15,  -3.964045168387169e-15,  -6.560693861750369e-17,   5.565586294941435e-18,
   3.650439111710505e-19,  -4.588446725756731e-21,  -5.940941160687519e-03,   2.114875489988281e-04,   4.827685387526221e-07,  -1.423645746601050e-07,   5.481079819649527e-09,
  -4.586827863794716e-10,  -1.028059208519233e-12,   1.449163844439003e-12,  -4.031957675770395e-15,  -2.558986380524006e-15,  -4.193651049997687e-17,   3.594292953350917e-18,
   2.341210904728861e-19,  -2.994322757501461e-21,  -3.186865149309599e-03,   1.134431159810887e-04,   2.592810868411124e-07,  -7.641095146875893e-08,   2.940040450785976e-09,
  -2.457619113053574e-10,  -5.525872033261250e-13,   7.764978632557646e-13,  -2.180392710750639e-15,  -1.370834149879036e-15,  -2.235081725891750e-17,   1.925827080665141e-18,
   1.249961504028722e-19,  -1.612849059013046e-21,  -1.185917929711473e-03,   4.221471296995134e-05,   9.652589218497044e-08,  -2.844014723101953e-08,   1.094049189653118e-09,
  -9.141747931934833e-11,  -2.057768862299772e-13,   2.888431950037951e-13,  -8.136500530708586e-16,  -5.098822534397407e-16,  -8.298600320951859e-18,   7.163614111583025e-19,
   4.643786916031599e-20,  -6.010361659669915e-22,  -1.339586269475687e-04,   4.768470049122186e-06,   1.090407315491529e-08,  -3.212635268100167e-09,   1.235810058450477e-10,
  -1.032564805363927e-11,  -2.324668544106657e-14,   3.262506317914715e-14,  -9.194869578414449e-17,  -5.759081976055589e-17,  -9.370555824119045e-19,   8.091336789753221e-20,
   5.244146083575960e-21,  -6.790693324794355e-23,  -3.361531916880701e-02,  -6.287662372046499e-04,   1.111634213669595e-04,   2.574467145478184e-06,  -3.460503131950848e-07,
  -9.889414955614100e-09,   9.786160906167999e-10,   3.503779845385506e-11,  -2.534537250212768e-12,  -1.148127721018479e-13,   6.049043366091009e-15,   3.516542499016039e-16,
  -1.325262770566051e-17,  -1.019246468455169e-18,  -3.197704367045109e-02,  -5.979587588567252e-04,   1.056957159455338e-04,   2.446369612986640e-06,  -3.287897920968534e-07,
  -9.387074413877404e-09,   9.289510272227211e-10,   3.321444796045247e-11,  -2.403368729972550e-12,  -1.086746180499824e-13,   5.729569396503793e-15,   3.322973964406880e-16,
  -1.253959324888303e-17,  -9.613804265148517e-19,  -2.886216769324867e-02,  -5.394508710740753e-04,   9.532028894898842e-05,   2.203890563342806e-06,  -2.961337546323242e-07,
  -8.440330546857450e-09,   8.353306673614418e-10,   2.979543950659183e-11,  -2.157123381166320e-12,  -9.722914940803637e-14,   5.132338177416612e-15,   2.964197106368014e-16,
  -1.121169001534367e-17,  -8.547990864591598e-19,  -2.457744485098261e-02,  -4.590985906193692e-04,   8.108765804035607e-05,   1.872420350930425e-06,  -2.515254770542002e-07,
  -7.154144045356244e-09,   7.081090850709010e-10,   2.518420069423551e-11,  -1.824455721020390e-12,  -8.191682969735653e-14,   4.330390127910881e-15,   2.488377013380725e-16,
  -9.438441749694564e-18,  -7.147458748118707e-19,  -1.954365804772404e-02,  -3.648622689013265e-04,   6.441670234940886e-05,   1.485618957864461e-06,  -1.995124289440288e-07,
  -5.663376111359428e-09,   5.606083929104105e-10,   1.988193629454260e-11,  -1.441236488433214e-12,  -6.446688847578493e-14,   3.412774271495044e-15,   1.951405687192158e-16,
  -7.421952619822465e-18,  -5.583364233921670e-19,  -1.425380842643773e-02,  -2.659842167865086e-04,   4.694409644473949e-05,   1.081571719353186e-06,  -1.452192120312738e-07,
  -4.115551532889109e-09,   4.074229079910866e-10,   1.441626443132097e-11,  -1.045556953530912e-12,  -4.662567427551441e-14,   2.471117024059718e-15,   1.407323940116218e-16,
  -5.364410765299252e-18,  -4.013948114135910e-19,  -9.224954650146831e-03,  -1.720910635044098e-04,   3.036602928081697e-05,   6.991578350090206e-07,  -9.386029267051239e-08,
  -2.657187133432524e-09,   2.630639248255769e-10,   9.294207351752146e-12,  -6.742974038604086e-13,  -3.000902930806589e-14,   1.591654944135699e-15,   9.040584304804101e-17,
  -3.451102129334045e-18,  -2.573135428066952e-19,  -4.948216426329514e-03,  -9.229444795483796e-05,   1.628381861907837e-05,   3.747969520813776e-07,  -5.031191057933730e-08,
  -1.423550357058679e-09,   1.409363767398590e-10,   4.975501757274522e-12,  -3.610355898913919e-13,  -1.605090273957299e-14,   8.516582091273240e-16,   4.830804618463863e-17,
  -1.845467023245007e-18,  -1.373458962199621e-19,  -1.841328546589765e-03,  -3.434272825775035e-05,   6.058964603740771e-06,   1.394398474544469e-07,  -1.871761646346870e-08,
  -5.295044895947110e-10,   5.242322964786825e-11,   1.850206139797628e-12,  -1.342638201835216e-13,  -5.966935800698935e-15,   3.166474784534413e-16,   1.795243738826329e-17,
  -6.859991402382411e-19,  -5.102180067928021e-20,  -2.079917043647917e-04,  -3.879232509020590e-06,   6.843948387120544e-07,   1.575023605725457e-08,  -2.114214019200713e-09,
  -5.980739575215193e-11,   5.921198632040268e-12,   2.089716333028463e-13,  -1.516457716006442e-14,  -6.739035416803393e-16,   3.576281844126764e-17,   2.027432047499002e-18,
  -7.747551008258113e-20,  -5.761726683640420e-21,  -7.285193363193163e-04,   3.763053027022242e-05,  -1.035290045723281e-06,   2.968594271857079e-08,  -1.422587006946460e-09,
   2.110235927824930e-11,   1.629028799421783e-12,   1.719044691058909e-15,  -5.299038731965099e-15,  -2.724001740079031e-18,   1.230609184828611e-17,   7.506618619914956e-20,
  -2.835243917805556e-20,  -3.394411297721274e-22,  -6.931150664381889e-04,   3.580282862250278e-05,  -9.851852200650355e-07,   2.824828566429440e-08,  -1.352681955601276e-09,
   2.007699725386641e-11,   1.545472580713342e-12,   1.633301478824798e-15,  -5.025264433045745e-15,  -2.475789560341292e-18,   1.165371235650814e-17,   7.067291360132939e-20,
  -2.680812760285956e-20,  -3.195650647965797e-22,  -6.257594923119254e-04,   3.232525323149033e-05,  -8.897775736903435e-07,   2.551114862677714e-08,  -1.220005828882355e-09,
   1.812620911758594e-11,   1.388313117218109e-12,   1.471238558792557e-15,  -4.511126901459207e-15,  -2.052323434817723e-18,   1.043512228039015e-17,   6.262844336061592e-20,
  -2.393956355041946e-20,  -2.831796554292316e-22,  -5.330279584006892e-04,   2.753668600131153e-05,  -7.582614383307874e-07,   2.173885638774495e-08,  -1.037954805548798e-09,
   1.544034015879439e-11,   1.175423247574527e-12,   1.250011840720445e-15,  -3.816201110854331e-15,  -1.562207190665229e-18,   8.800698420253448e-18,   5.215081816263085e-20,
  -2.012318411431353e-20,  -2.358019133808010e-22,  -4.239844218380175e-04,   2.190473389370309e-05,  -6.034035715303673e-07,   1.729799858631051e-08,  -8.246484692573602e-10,
   1.228185118158326e-11,   9.294601684197938e-13,   9.920157252052599e-16,  -3.015226222755349e-15,  -1.100973381456222e-18,   6.932861851652619e-18,   4.057062209567788e-20,
  -1.580107058642743e-20,  -1.834467490263141e-22,  -3.093002678002056e-04,   1.598047351377742e-05,  -4.403422170869383e-07,   1.262276456765708e-08,  -6.010209691115249e-10,
   8.959832028287396e-12,   6.748274328235122e-13,   7.224481697224067e-16,  -2.187777944624173e-15,  -7.209437400476923e-19,   5.018225458101430e-18,   2.906743877721604e-20,
  -1.140737238086687e-20,  -1.314398360979210e-22,  -2.002088212480090e-04,   1.034443102802658e-05,  -2.850976338957150e-07,   8.172258487842528e-09,  -3.887964232024620e-10,
   5.799712799504645e-12,   4.354388445897857e-13,   4.671413154088364e-16,  -1.411088920835263e-15,  -4.318143910571192e-19,   3.231531531044963e-18,   1.859093805047026e-20,
  -7.333114569595984e-21,  -8.407020810090830e-23,  -1.073997794717899e-04,   5.549246355711755e-06,  -1.529555751490995e-07,   4.384355526548723e-09,  -2.084988987879939e-10,
   3.111204560478250e-12,   2.332083265274843e-13,   2.504612472573696e-16,  -7.555746569599745e-16,  -2.220942175632540e-19,   1.728920229762963e-18,   9.911446040727811e-21,
  -3.919820236669694e-21,  -4.482190783657065e-23,  -3.996671247251659e-05,   2.065054670506286e-06,  -5.692175402467386e-08,   1.631608409765989e-09,  -7.758013913555637e-11,
   1.157775254168909e-12,   8.673496684170532e-14,   9.318750310195154e-17,  -2.809926175175196e-16,  -8.141444951557627e-20,   6.427888349064768e-19,   3.680409525126672e-21,
  -1.456880780714904e-21,  -1.664386271325322e-23,  -4.514556859387346e-06,   2.332645020550430e-07,  -6.429805262151730e-09,   1.843041175016475e-10,  -8.763136969875483e-12,
   1.307799203698965e-13,   9.796525111753973e-15,   1.052596889884594e-17,  -3.173712424242703e-17,  -9.174312873342080e-21,   7.259743555413637e-20,   4.155892034464867e-22,
  -1.645339254847021e-22,  -1.879416303602129e-24,  -6.612958289228506e-03,   3.242148218491745e-04,  -7.340018018400562e-06,   1.554053218422454e-07,  -8.947278954840151e-09,
   3.500545044638368e-11,   2.245558315810493e-11,  -1.309203301309091e-13,  -5.376000986844899e-14,  -3.424372319345608e-17,   1.350073683656778e-16,   7.197028566474433e-19,
  -3.182011385528373e-19,  -3.603306285949371e-21,  -6.291522355929751e-03,   3.084587861152393e-04,  -6.984569043170060e-06,   1.478565108741864e-07,  -8.502233532590781e-09,
   3.322090353868885e-11,   2.131958635716908e-11,  -1.245814817919334e-13,  -5.096937759487994e-14,  -3.147557232024820e-17,   1.278372730669491e-16,   6.768466198241214e-19,
  -3.008153285128181e-19,  -3.390253609602963e-21,  -5.680025302619142e-03,   2.784833848905223e-04,  -6.307823628078711e-06,   1.334936577942665e-07,  -7.659735591721264e-09,
   2.985974896795269e-11,   1.917677318378986e-11,  -1.125108556387420e-13,  -4.573380032932859e-14,  -2.667555381692235e-17,   1.144492219658119e-16,   5.986366484944060e-19,
  -2.685418903498914e-19,  -3.000985460465846e-21,  -4.838198072306970e-03,   2.372148471861191e-04,  -5.375122405242213e-06,   1.137168510882300e-07,  -6.507922009365932e-09,
   2.529801772351129e-11,   1.626211172760990e-11,  -9.587260142969659e-14,  -3.866717594673584e-14,  -2.095403690043315e-17,   9.650240590555652e-17,   4.972864712650764e-19,
  -2.256448567547368e-19,  -2.495570612901487e-21,  -3.848350773420190e-03,   1.886869237549570e-04,  -4.277098866682260e-06,   9.045769941647744e-08,  -5.163699446572448e-09,
   2.001706546684941e-11,   1.287930737488494e-11,  -7.628456338147839e-14,  -3.053483607627649e-14,  -1.532251140756484e-17,   7.600495309851414e-17,   3.859364068091567e-19,
  -1.771138041606571e-19,  -1.938918882278826e-21,  -2.807358475742833e-03,   1.376487316814894e-04,  -3.121110306298036e-06,   6.599218971489618e-08,  -3.759415912270544e-09,
   1.454053574577837e-11,   9.362782988105987e-12,  -5.566395645492994e-14,  -2.214563401379454e-14,  -1.039825506989863e-17,   5.500543519810945e-17,   2.759641019434534e-19,
  -1.278261956783462e-19,  -1.387737315115756e-21,  -1.817172025848662e-03,   8.909947246337202e-05,  -2.020679421787246e-06,   4.271755121375547e-08,  -2.430232420762345e-09,
   9.385475021185672e-12,   6.046511249661004e-12,  -3.603661739422670e-14,  -1.427948804134914e-14,  -6.400644702194400e-18,   3.541725951508442e-17,   1.762666837760212e-19,
  -8.215528132336605e-20,  -8.869686787011843e-22,  -9.747961110634010e-04,   4.779641415970852e-05,  -1.084080188746205e-06,   2.291564589209130e-08,  -1.302784164019348e-09,
   5.027417249991686e-12,   3.239738550839021e-12,  -1.933292185384090e-14,  -7.644875960779311e-15,  -3.343170503280779e-18,   1.894769552474635e-17,   9.390886510415395e-20,
  -4.391049153374419e-20,  -4.727090854810812e-22,  -3.627504640286973e-04,   1.778649410425788e-05,  -4.034332468454943e-07,   8.527644262963573e-09,  -4.846906602589874e-10,
   1.869906750049918e-12,   1.205107314620301e-12,  -7.194555077473167e-15,  -2.842924016528701e-15,  -1.232421079327879e-18,   7.044351570418816e-18,   3.486270033847274e-20,
  -1.631963845907846e-20,  -1.755096330317108e-22,  -4.097552655752401e-05,   2.009125444903351e-06,  -4.557123567667938e-08,   9.632656713104885e-10,  -5.474759306157701e-11,
   2.112037992721860e-13,   1.361175033456455e-13,  -8.126853758953706e-16,  -3.210955657680519e-16,  -1.390026476474706e-19,   7.955959990258177e-19,   3.936520306593283e-21,
  -1.843060102568192e-21,  -1.981804470766304e-23,  -1.855338595756176e-02,   7.625595682011140e-04,  -3.531201378785137e-06,  -4.247990358101387e-07,  -4.397010609463746e-09,
  -3.531596961623295e-10,   8.989207759786852e-11,  -1.400181974071340e-13,  -2.646599085692591e-13,   1.496672305598319e-15,   6.270286549884111e-16,  -1.731199210339539e-19,
  -1.563807763837222e-18,  -1.060392757972867e-20,  -1.765104915459790e-02,   7.254303292092167e-04,  -3.360130859898761e-06,  -4.042419094265927e-07,  -4.143875715638255e-09,
  -3.360617809803296e-10,   8.530403020090605e-11,  -1.316094964799800e-13,  -2.509718292362955e-13,   1.423376597199687e-15,   5.935756239320426e-16,  -1.873970067069412e-19,
  -1.477380383716165e-18,  -9.946582958825973e-21,  -1.593465949026831e-02,   6.548217883009945e-04,  -3.034446182668571e-06,  -3.650971873721490e-07,  -3.678473829531448e-09,
  -3.035057605523829e-10,   7.666562530922968e-11,  -1.162657054999412e-13,  -2.252721409951906e-13,   1.284112687659284e-15,   5.311723668746493e-16,  -2.048925579462483e-19,
  -1.317322036393692e-18,  -8.756457001172603e-21,  -1.357216825944980e-02,   5.576674744070532e-04,  -2.585628226922242e-06,  -3.111361919132836e-07,  -3.068970155684601e-09,
  -2.586319612068848e-10,   6.494672142252386e-11,  -9.640721665229800e-14,  -1.905468755768180e-13,   1.092777696535131e-15,   4.476358039054262e-16,  -2.106748738183427e-19,
  -1.105305116929669e-18,  -7.232473564962812e-21,  -1.079478748766833e-02,   4.434937327601667e-04,  -2.057327287569858e-06,  -2.475962372683349e-07,  -2.391585986180700e-09,
  -2.058003614123929e-10,   5.138519941005188e-11,  -7.465634638642245e-14,  -1.505362346124883e-13,   8.683614912694034e-16,   3.523713088586791e-16,  -1.949667584511437e-19,
  -8.663640824711636e-19,  -5.581296973956151e-21,  -7.874377885753129e-03,   3.234798109193772e-04,  -1.501214279359624e-06,  -1.806884290886912e-07,  -1.715647895255757e-09,
  -1.501779143225166e-10,   3.732485898920014e-11,  -5.327121307444458e-14,  -1.092157379808492e-13,   6.329402778686832e-16,   2.549067285441531e-16,  -1.580580551004145e-19,
  -6.245608889036810e-19,  -3.972400468688273e-21,  -5.096834142387039e-03,   2.093646540960868e-04,  -9.718890567634366e-07,  -1.169866346094484e-07,  -1.098140818917444e-09,
  -9.722843760623870e-11,   2.409152258279048e-11,  -3.397301074010530e-14,  -7.043861561913629e-14,   4.094606745300034e-16,   1.640854713492856e-16,  -1.089960686118676e-19,
  -4.011097432754442e-19,  -2.529402431980198e-21,  -2.734079235793617e-03,   1.123051168194012e-04,  -5.214025060629468e-07,  -6.276381188113725e-08,  -5.856762956340597e-10,
  -5.216226011089239e-11,   1.290473057336751e-11,  -1.808420227899735e-14,  -3.771557982072102e-14,   2.195831964607192e-16,   8.777074731343416e-17,  -6.029766095034483e-20,
  -2.143026625950648e-19,  -1.345406926079596e-21,  -1.017425917835860e-03,   4.179133322412602e-05,  -1.940352891505017e-07,  -2.335730618314477e-08,  -2.175066162993959e-10,
  -1.941182245731743e-11,   4.799795579171818e-12,  -6.711518339449779e-15,  -1.402599884675503e-14,   8.170474081055362e-17,   3.262968927553542e-17,  -2.267452826778359e-20,
  -7.963630493598555e-20,  -4.991870016800257e-22,  -1.149261791216303e-04,   4.720647820800809e-06,  -2.191792397005783e-08,  -2.638410553512668e-09,  -2.456118731935248e-11,
  -2.192731062377483e-12,   5.421311137849704e-13,  -7.577936526666705e-16,  -1.584184445902165e-15,   9.229039284204891e-18,   3.685200298541509e-18,  -2.565492465694320e-21,
  -8.993541587782078e-21,  -5.636063085738992e-23,  -3.429727257496466e-02,   2.841272278565821e-04,   1.068915973435638e-04,  -3.128298568728639e-06,  -2.854084466645790e-07,
   1.451719118759511e-08,   6.330766872587756e-10,  -5.142716825419746e-11,  -1.096788768812634e-12,   1.569929273403908e-13,   1.024573186139005e-15,  -4.328658005072978e-16,
   2.372333393089366e-18,   1.104077966281705e-18,  -3.262593818576904e-02,   2.700362982779574e-04,   1.016421259627920e-04,  -2.971917475878719e-06,  -2.712472290363731e-07,
   1.377972969182450e-08,   6.013786888341557e-10,  -4.876238631353774e-11,  -1.042036833447508e-12,   1.486722828737319e-13,   9.788860926003835e-16,  -4.093557730156951e-16,
   2.210711917944815e-18,   1.042570490959588e-18,  -2.944813474200161e-02,   2.433443596933568e-04,   9.167752128913656e-05,  -2.676190625021525e-06,  -2.444248884516081e-07,
   1.238987132850335e-08,   5.414549696054209e-10,  -4.376105669717060e-11,  -9.384558751277411e-13,   1.331291158273716e-13,   8.901773342987461e-16,  -3.656594126364689e-16,
   1.922969316638393e-18,   9.288420464712396e-19,  -2.507671140050552e-02,   2.068200158292590e-04,   7.800206852253437e-05,  -2.272494940623193e-06,  -2.077273946967249e-07,
   1.050172602967887e-08,   4.596917879580576e-10,  -3.700699337900051e-11,  -7.969885137202109e-13,   1.122803552047573e-13,   7.646972146967723e-16,  -3.074746442530369e-16,
   1.564196648864087e-18,   7.785475285893309e-19,  -1.994089087861613e-02,   1.641531711665709e-04,   6.197569942524591e-05,  -1.802128027478443e-06,  -1.648649344526055e-07,
   8.313302347109159e-09,   3.644757207148329e-10,  -2.922977198704439e-11,  -6.320864586417972e-13,   8.845232466972505e-14,   6.130861795338053e-16,  -2.415162423498158e-16,
   1.188271851801618e-18,   6.096227892060551e-19,  -1.454365352506177e-02,   1.195417514092103e-04,   4.517118929412622e-05,  -1.311459248379771e-06,  -1.200551541757240e-07,
   6.041181369408972e-09,   2.651986845819862e-10,  -2.120261647293753e-11,  -4.600158203234624e-13,   6.402571657361466e-14,   4.500136764403449e-16,  -1.744069367987783e-16,
   8.345324744398304e-19,   4.391099391833225e-19,  -9.412595948678503e-03,   7.728944373520064e-05,   2.922177321446547e-05,  -8.475325880905906e-07,  -7.761928316428785e-08,
   3.900433547600634e-09,   1.713675084362060e-10,  -1.367292196204417e-11,  -2.972960491532979e-13,   4.123038751328421e-14,   2.924502055933427e-16,  -1.121358903183510e-16,
   5.265364532776650e-19,   2.818508246966283e-19,  -5.048881573930302e-03,   4.143643172955957e-05,   1.567091405133442e-05,  -4.542724652542652e-07,  -4.161268796392884e-08,
   2.089594050129601e-09,   9.184710094509290e-11,  -7.320546382176163e-12,  -1.593513525058282e-13,   2.205902572520442e-14,   1.571968685918644e-16,  -5.994629453448781e-17,
   2.787216259114097e-19,   1.505421976972994e-19,  -1.878790014036116e-03,   1.541656351424261e-05,   5.831003171616875e-06,  -1.689997591771461e-07,  -1.548206552249404e-08,
   7.772453789539841e-10,   3.416859146289364e-11,  -2.722367730660239e-12,  -5.928264486783969e-14,   8.201258511720133e-15,   5.853832244299387e-17,  -2.228097191990920e-17,
   1.032389268984253e-19,   5.593684719789162e-20,  -2.122232903548319e-04,   1.741365860215594e-06,   6.586469200656888e-07,  -1.908898747714352e-08,  -1.748763249311151e-09,
   8.778964649416005e-11,   3.859424992129731e-12,  -3.074802251125515e-13,  -6.696142875943673e-15,   9.262614382230122e-16,   6.613093976739680e-18,  -2.516331103794040e-18,
   1.165302691491046e-20,   6.316997032324217e-21,  -5.927937818286999e-04,   3.043084370410511e-05,  -7.955417339836163e-07,   1.212736150951953e-08,  -6.934688278242497e-10,
   4.465008864720921e-11,  -1.099602915643433e-13,  -9.044797330415561e-14,   9.738039913935909e-16,   2.216271917082034e-16,  -5.362492317990589e-18,  -4.540548622549351e-19,
   1.789466773918276e-20,   8.357928039517948e-22,  -5.639839307216835e-04,   2.895178428642308e-05,  -7.569701351567339e-07,   1.155058683300075e-08,  -6.597843713026367e-10,
   4.242291575289583e-11,  -1.038404376126179e-13,  -8.581631189382315e-14,   9.195362283860378e-16,   2.101226925805344e-16,  -5.067987041565882e-18,  -4.300851225506556e-19,
   1.689363975223545e-20,   7.911624039151849e-22,  -5.091746553933969e-04,   2.613799780048020e-05,  -6.835522814191145e-07,   1.044814766106268e-08,  -5.956935351449450e-10,
   3.820928731710371e-11,  -9.252105595895657e-14,  -7.710182164148295e-14,   8.191788745486980e-16,   1.885385075931636e-16,  -4.521836807583430e-18,  -3.852704768209821e-19,
   1.504425742316192e-20,   7.079117357967758e-22,  -4.337173817906038e-04,   2.226428218593890e-05,  -5.824037108599930e-07,   8.920421872750555e-09,  -5.074433060865051e-10,
   3.245355605965159e-11,  -7.755652137075107e-14,  -6.529138826851356e-14,   6.865456653611990e-16,   1.594053787342422e-16,  -3.796989723063190e-18,  -3.250854432106735e-19,
   1.260325193191919e-20,   5.964851538524015e-22,  -3.449882573456098e-04,   1.770935164421141e-05,  -4.633729101324327e-07,   7.111406022956570e-09,  -4.036530940090071e-10,
   2.574247510599191e-11,  -6.073179264926859e-14,  -5.163876178257954e-14,   5.374924400685310e-16,   1.258788120554677e-16,  -2.978365436390183e-18,  -2.562097482042288e-19,
   9.863495396875223e-21,   4.694556601935769e-22,  -2.516707551231148e-04,   1.291898197429309e-05,  -3.381013266404915e-07,   5.197141472661796e-09,  -2.944794852320844e-10,
   1.873721219616322e-11,  -4.374587416947889e-14,  -3.749782000164014e-14,   3.870875712163267e-16,   9.129383328690695e-17,  -2.148361019192235e-18,  -1.855214906212173e-19,
   7.101613462197152e-21,   3.395472199718115e-22,  -1.629049835372480e-04,   8.362344757582961e-06,  -2.188802072687015e-07,   3.368065850588831e-09,  -1.906200419793337e-10,
   1.211053772959129e-11,  -2.807920341155043e-14,  -2.419836845535696e-14,   2.484262039797719e-16,   5.886580046740816e-17,  -1.380265418879913e-18,  -1.194971785792580e-19,
   4.557000375070202e-21,   2.185417312295156e-22,  -8.738841973314937e-05,   4.485869574291862e-06,  -1.174237071280497e-07,   1.807855996384306e-09,  -1.022572531067402e-10,
   6.491614670168438e-12,  -1.499765082359357e-14,  -1.296064343739261e-14,   1.326795710730931e-16,   3.151513905620537e-17,  -7.375852123058187e-19,  -6.394077195044100e-20,
   2.433626652030700e-21,   1.168919086069480e-22,  -3.251986176595724e-05,   1.669325856214467e-06,  -4.369793925038062e-08,   6.728997528195854e-10,  -3.805318576858206e-11,
   2.415086105176054e-12,  -5.572660535202903e-15,  -4.820420950552395e-15,   4.929832243266503e-17,   1.171961773703521e-17,  -2.741102816305229e-19,  -2.377332160357053e-20,
   9.042142184095432e-22,   4.345472887070307e-23,  -3.673375754287927e-06,   1.885635442731602e-07,  -4.936046764160114e-09,   7.601189960481692e-11,  -4.298411776252795e-12,
   2.727916346556550e-13,  -6.293253211121364e-16,  -5.444576610266333e-16,   5.567278677979768e-18,   1.323678172561769e-18,  -3.095634400853247e-20,  -2.685009169002764e-21,
   1.021128670986136e-22,   4.907762283352716e-24,  -5.424877712583659e-03,   2.707445554654210e-04,  -6.227290602954754e-06,   4.271903835336417e-08,  -4.037735166672741e-09,
   3.684085501953401e-10,   1.050449437042373e-12,  -1.016616865808618e-12,   1.344643498699917e-14,   2.317088895853067e-15,  -6.224918794059426e-17,  -4.823240061844972e-18,
   2.096060018192074e-19,   8.798856076218353e-21,  -5.161196068744047e-03,   2.575794682496708e-04,  -5.925112137860763e-06,   4.074878144784810e-08,  -3.840828981629882e-09,
   3.498657397998717e-10,   1.010092731114049e-12,  -9.647410625381256e-13,   1.271230701530890e-14,   2.196687619491515e-15,  -5.882714652316961e-17,  -4.568776659429970e-18,
   1.978632136315043e-19,   8.330653558488137e-21,  -4.659568128031633e-03,   2.325363643875612e-04,  -5.350042166553253e-06,   3.695713947263529e-08,  -3.466491801690807e-09,
   3.148506242772120e-10,   9.288754666598301e-13,  -8.670652132961183e-13,   1.134917761168634e-14,   1.970843729032013e-15,  -5.248236692438124e-17,  -4.092958235997665e-18,
   1.761752384467825e-19,   7.456633789489531e-21,  -3.968989790962578e-03,   1.980643354424291e-04,  -4.557959493824532e-06,   3.165334537748919e-08,  -2.951656236116718e-09,
   2.671496299280947e-10,   8.085419637206441e-13,  -7.345494988768118e-13,   9.536784028236877e-15,   1.666104622294698e-15,  -4.406408877995284e-17,  -3.453823032669263e-18,
   1.475619685045404e-19,   6.285545952194771e-21,  -3.156980500095005e-03,   1.575360233121799e-04,  -3.626093199721845e-06,   2.531108069205217e-08,  -2.346940916435735e-09,
   2.116949446307846e-10,   6.563970423713320e-13,  -5.811859926410944e-13,   7.485866645316108e-15,   1.315527873139588e-15,  -3.455982146743532e-17,  -2.722248085389890e-18,
   1.154628707173805e-19,   4.948917825770540e-21,  -2.303010148935955e-03,   1.149182756607895e-04,  -2.645602383206156e-06,   1.854274514446698e-08,  -1.711590119313585e-09,
   1.539628107536939e-10,   4.865835224458578e-13,  -4.221692400500110e-13,   5.402722092623761e-15,   9.539961854624541e-16,  -2.492635620750114e-17,  -1.971285933454156e-18,
   8.311961356424582e-20,   3.580577984515162e-21,  -1.490714598141562e-03,   7.438374398261535e-05,  -1.712631590554141e-06,   1.203599287584658e-08,  -1.107680305705748e-09,
   9.945871533778842e-11,   3.182544427691188e-13,  -2.724962029028299e-13,   3.472374455352815e-15,   6.150920832128579e-16,  -1.601350165480357e-17,  -1.269779392432955e-18,
   5.333133168631299e-20,   2.305033960085318e-21,  -7.996731179708602e-04,   3.990166696760094e-05,  -9.187616345767217e-07,   6.465751577606279e-09,  -5.941404731180817e-10,
   5.329826957410002e-11,   1.716276363347829e-13,  -1.459651744580719e-13,   1.855911749578731e-15,   3.292924765479372e-16,  -8.557000941402476e-18,  -6.794480475474055e-19,
   2.847968113115237e-20,   1.233029277638679e-21,  -2.975820776570643e-04,   1.484853404776578e-05,  -3.419041742122148e-07,   2.407290327295607e-09,  -2.210896033084881e-10,
   1.982675005112492e-11,   6.398470552407452e-14,  -5.429058157786260e-14,   6.897610353119981e-16,   1.224534340097566e-16,  -3.180018997548959e-18,  -2.526218639524518e-19,
   1.058143987430249e-20,   4.583971987673684e-22,  -3.361424427553387e-05,   1.677258046411335e-06,  -3.862087756466671e-08,   2.719438132654141e-10,  -2.497367781315489e-11,
   2.239460359533513e-12,   7.229673261182892e-15,  -6.132058865746973e-15,   7.789820860178515e-17,   1.383053966657953e-17,  -3.591313026046851e-19,  -2.853167505333122e-20,
   1.194958105849185e-21,   5.177152548107352e-23,  -1.559345163154208e-02,   7.128788593222196e-04,  -8.944836819317651e-06,  -4.508082426404614e-07,   5.623849673931983e-09,
   1.000024800963571e-09,   4.025298442716266e-12,  -4.083063951189152e-12,   7.179161170753580e-14,   9.901433918026320e-15,  -3.591523570360127e-16,  -1.912602878173136e-17,
   1.173258209026627e-18,   3.095706998352774e-20,  -1.483524544522699e-02,   6.781645467704294e-04,  -8.508748903338241e-06,  -4.285911615033927e-07,   5.352316743591760e-09,
   9.488829143191373e-10,   3.886635091283226e-12,  -3.874074712181450e-12,   6.783701185338615e-14,   9.389224810043028e-15,  -3.394766949019816e-16,  -1.812521737410801e-17,
   1.107504256670409e-18,   2.935846848653816e-20,  -1.339294405253349e-02,   6.121501500583087e-04,  -7.679669567711995e-06,  -3.864504882714465e-07,   4.835046240024464e-09,
   8.526303886290074e-10,   3.599141537986044e-12,  -3.480820404927275e-12,   6.050694201149305e-14,   8.427540943284977e-15,  -3.029711427325186e-16,  -1.625052609977251e-17,
   9.860722466193412e-19,   2.635471972022458e-20,  -1.140757805035305e-02,   5.213204074164437e-04,  -6.539333669808918e-06,  -3.286780348263014e-07,   4.121530404514071e-09,
   7.221290715638144e-10,   3.157924204682748e-12,  -2.947781264914223e-12,   5.078634388726769e-14,   7.128162968229597e-15,  -2.544861535467747e-16,  -1.372609929076020e-17,
   8.258839308692696e-19,   2.229288410544727e-20,  -9.073376530389286e-03,   4.145831868555291e-04,  -5.199794309877795e-06,  -2.610510719830672e-07,   3.280723523158191e-09,
   5.712073282222096e-10,   2.582408786842678e-12,  -2.331505662447194e-12,   3.981939963823731e-14,   5.631132253560073e-15,  -1.996826225825896e-16,  -1.082871698753577e-17,
   6.462028832759482e-19,   1.761080233780275e-20,  -6.618805884373536e-03,   3.023898582872606e-04,  -3.792257991999574e-06,  -1.902116073575527e-07,   2.394717882599529e-09,
   4.148299905160881e-10,   1.924997630758807e-12,  -1.693103610882404e-12,   2.871180293035261e-14,   4.085262867540603e-15,  -1.440730435921883e-16,  -7.847316961047921e-18,
   4.651746543190625e-19,   1.277538460625341e-20,  -4.284198107071109e-03,   1.957134521999131e-04,  -2.454269948353876e-06,  -1.230261635999279e-07,   1.550697494160199e-09,
   2.677195257247408e-10,   1.263521733240090e-12,  -1.092633710116458e-12,   1.844178033878591e-14,   2.634699133738840e-15,  -9.257933126930317e-17,  -5.057221038973991e-18,
   2.984598792550893e-19,   8.238596951398357e-21,  -2.298174716079937e-03,   1.049821501047694e-04,  -1.316443450564804e-06,  -6.596930755876659e-08,   8.320223941560177e-10,
   1.433955374238350e-10,   6.825999124372994e-13,  -5.852220394123728e-13,   9.853553650551334e-15,   1.410694868897957e-15,  -4.947696067436868e-17,  -2.706752651696811e-18,
   1.593801075369684e-19,   4.410981327271406e-21,  -8.552158720109943e-04,   3.906624425453729e-05,  -4.898726752087504e-07,  -2.454572223870424e-08,   3.096425819456649e-10,
   5.333339922937491e-11,   2.546365224835469e-13,  -2.176611992591969e-13,   3.661719181466465e-15,   5.246181005396305e-16,  -1.838780561481190e-17,  -1.006470447615359e-18,
   5.921642647549874e-20,   1.640354847405040e-21,  -9.660332712538579e-05,   4.412827587984788e-06,  -5.533471662237368e-08,  -2.772571880417482e-09,   3.497697491409852e-11,
   6.023920615883208e-12,   2.877432818675661e-14,  -2.458444867265235e-14,   4.135290589637850e-16,   5.925360321385491e-17,  -2.076617117633236e-18,  -1.136745789010559e-19,
   6.687285404468536e-21,   1.852712648653929e-22,  -3.176504506116402e-02,   9.364024005205539e-04,   5.283793883188344e-05,  -5.044321299571066e-06,   4.033297703999995e-08,
   1.318259296746595e-08,  -5.700647335980979e-10,  -1.717618738877932e-11,   2.065062568640234e-12,  -1.931780689232161e-14,  -4.687358036387795e-15,   1.878487644980230e-16,
   6.126856171046793e-18,  -6.380709096194557e-19,  -3.021840213834252e-02,   8.904130536011800e-04,   5.027447243948606e-05,  -4.795077951163456e-06,   3.812338474300626e-08,
   1.253057693034596e-08,  -5.406528203058362e-10,  -1.635940463612911e-11,   1.958445091849987e-12,  -1.808453270416399e-14,  -4.447274728311002e-15,   1.772909228347666e-16,
   5.835350199453909e-18,  -6.026766407063190e-19,  -2.727715473953448e-02,   8.031164129281490e-04,   4.539573244638139e-05,  -4.322572832562006e-06,   3.402222456105611e-08,
   1.129474767392341e-08,  -4.853994545457726e-10,  -1.479777856638720e-11,   1.758177767093543e-12,  -1.586121113842967e-14,  -3.995508175740650e-15,   1.577999588511312e-16,
   5.277666602185792e-18,  -5.371603631689259e-19,  -2.323012048827051e-02,   6.833120114317226e-04,   3.867547417090185e-05,  -3.675292009671314e-06,   2.857370988386824e-08,
   9.602280009342761e-09,  -4.106833939546081e-10,  -1.263326724609196e-11,   1.487419130458725e-12,  -1.303548399369662e-14,  -3.383219006625333e-15,   1.321057409275682e-16,
   4.504425199373948e-18,  -4.504541921867634e-19,  -1.847412337584877e-02,   5.429147296092085e-04,   3.076878195441675e-05,  -2.918243150963836e-06,   2.241548399217280e-08,
   7.623454603926578e-09,  -3.245270606036195e-10,  -1.007023433066721e-11,   1.175274118729999e-12,  -1.000562470410651e-14,  -2.675495763646404e-15,   1.033136030903652e-16,
   3.589114769940669e-18,  -3.528620233854304e-19,  -1.347484276678890e-02,   3.957030628963305e-04,   2.244916367030506e-05,  -2.125842185746979e-06,   1.616913663193946e-08,
   5.552875251077526e-09,  -2.354915112971948e-10,  -7.358635084908532e-12,   8.527695021574770e-13,  -7.087770893453997e-15,  -1.942620165609468e-15,   7.433859838248351e-17,
   2.621578344164103e-18,  -2.542415613476273e-19,  -8.721275534812349e-03,   2.559840402339714e-04,   1.453255607344197e-05,  -1.374749377788522e-06,   1.038809235018345e-08,
   3.590715736141660e-09,  -1.518979159136446e-10,  -4.768397994773583e-12,   5.500302178562401e-13,  -4.498086121641019e-15,  -1.253523349288548e-15,   4.768146811499888e-17,
   1.698236676823588e-18,  -1.632191955170191e-19,  -4.678172689199227e-03,   1.372776499428070e-04,   7.796183758189002e-06,  -7.371110193887842e-07,   5.551088636914175e-09,
   1.925196587378284e-09,  -8.133684970798479e-11,  -2.559367769969673e-12,   2.945172671586860e-13,  -2.388313213694735e-15,  -6.713564860949909e-16,   2.545809006305280e-17,
   9.113404518828195e-19,  -8.718632808642911e-20,  -1.740856418814666e-03,   5.107971890375501e-05,   2.901242324799922e-06,  -2.742550028651872e-07,   2.062947295725729e-09,
   7.162940999148657e-10,  -3.024886986190611e-11,  -9.526006452396915e-13,   1.095288675334056e-13,  -8.855790934421625e-16,  -2.496919235264253e-16,   9.458198054851228e-18,
   3.391804518440510e-19,  -3.239672221414490e-20,  -1.966429278746352e-04,   5.769761225917087e-06,   3.277191349780465e-07,  -3.097844504117845e-08,   2.329764054177071e-10,
   8.090876593537329e-11,  -3.416508382380066e-12,  -1.076070551186147e-13,   1.237090018903608e-14,  -9.997612460693154e-17,  -2.820216866267724e-17,   1.068100208914627e-18,
   3.831388578467974e-20,  -3.658607323223615e-21,  -4.830599744002234e-04,   2.452318639099938e-05,  -6.896159458466713e-07,   7.309163905061514e-09,   9.939884838229727e-12,
   2.039705180818067e-11,  -1.439794753043580e-12,   5.965660541090615e-15,   3.023015895597412e-15,  -9.502731912636215e-17,  -4.256235831103192e-18,   3.287747671192896e-19,
   2.746338614239282e-22,  -7.135816471478183e-22,  -4.595842796531868e-04,   2.333103410080393e-05,  -6.560725733000556e-07,   6.959717769182223e-09,   8.823833036201207e-12,
   1.940819674759148e-11,  -1.367278737685989e-12,   5.577355651882440e-15,   2.870290672517972e-15,  -8.988294660744094e-17,  -4.048156933845344e-18,   3.111704785643244e-19,
   3.082279253786635e-22,  -6.757651750098357e-22,  -4.149225221014430e-04,   2.106315673659433e-05,  -5.922695325525405e-07,   6.292564123787717e-09,   6.959603272336215e-12,
   1.752587317787793e-11,  -1.230361221571170e-12,   4.879403007289257e-15,   2.582103102763574e-15,  -8.031362787746986e-17,  -3.652672779714934e-18,   2.783505028842216e-19,
   3.522330025380440e-22,  -6.051048682718955e-22,  -3.534347298301739e-04,   1.794116910504412e-05,  -5.044525053782513e-07,   5.369520231458446e-09,   4.893677208796627e-12,
   1.493242585442258e-11,  -1.043874220943101e-12,   3.996814640383473e-15,   2.189929520534001e-15,  -6.755756976579213e-17,  -3.109050161107642e-18,   2.344580122450239e-19,
   3.750309914190110e-22,  -5.103060591406850e-22,  -2.811310414439263e-04,   1.427039028593284e-05,  -4.012175769804219e-07,   4.278357003392876e-09,   3.095655633007442e-12,
   1.188041453235091e-11,  -8.271216954403895e-13,   3.056938111481883e-15,   1.734572594635939e-15,  -5.308180092581735e-17,  -2.471074085853827e-18,   1.844650569540950e-19,
   3.552439774099887e-22,  -4.019616175959290e-22,  -2.050873726854657e-04,   1.041008648120169e-05,  -2.926699038131279e-07,   3.125387925129478e-09,   1.791016317439496e-12,
   8.668440784340774e-12,  -6.015143190657138e-13,   2.158715576495949e-15,   1.261065833252366e-15,  -3.834086162033793e-17,  -1.801450925878468e-18,   1.333828878526061e-19,
   2.921073912004880e-22,  -2.909192382563661e-22,  -1.327521756860994e-04,   6.738285166071906e-06,  -1.894347779207283e-07,   2.024885877816899e-09,   9.597748630845090e-13,
   5.611704844449791e-12,  -3.885559325041546e-13,   1.366965144246169e-15,   8.144360376125076e-16,  -2.465490067885046e-17,  -1.165527051173600e-18,   8.583299291484774e-20,
   2.030159982792546e-22,  -1.873224211101250e-22,  -7.121340165845125e-05,   3.614644001463807e-06,  -1.016176142836407e-07,   1.086732811478122e-09,   4.599433306377968e-13,
   3.010514740697710e-12,  -2.082158062569620e-13,   7.249540475161948e-16,   4.363864571258417e-16,  -1.318106627566830e-17,  -6.250799293841926e-19,   4.590530591411437e-20,
   1.127186148526249e-22,  -1.002150209367471e-22,  -2.650066265739279e-05,   1.345114216929099e-06,  -3.781466355449074e-08,   4.044716794802181e-10,   1.640490133446125e-13,
   1.120326726744557e-12,  -7.745484282608201e-14,   2.686987682390581e-16,   1.623267531620680e-16,  -4.899281431905167e-18,  -2.325910072018483e-19,   1.706479219649776e-20,
   4.243832887172392e-23,  -3.725783489092564e-23,  -2.993459794077417e-06,   1.519412311544177e-07,  -4.271459967572700e-09,   4.568945464659455e-11,   1.840321028334938e-14,
   1.265501917275032e-13,  -8.748626221191917e-15,   3.033232926066548e-17,   1.833491231412409e-17,  -5.533088624333508e-19,  -2.627263436656356e-20,   1.927281614914519e-21,
   4.802561921546671e-24,  -4.207936614266148e-24,  -4.439141616986411e-03,   2.224056148157886e-04,  -5.877332245009837e-06,   3.038884733037534e-08,   1.770477804541312e-09,
   1.540451247392988e-10,  -1.367491987670693e-11,   5.743531455015507e-14,   3.186983920328723e-14,  -1.087408421462260e-15,  -4.122968111720324e-17,   3.605457345369044e-18,
  -1.007982037958396e-20,  -7.622354220597705e-21,  -4.223394591663680e-03,   2.115905309866530e-04,  -5.591155723129961e-06,   2.895661461816505e-08,   1.678363153760464e-09,
   1.465829018144647e-10,  -1.298355415437415e-11,   5.351702186140284e-14,   3.026442344832800e-14,  -1.028785753139863e-15,  -3.923749081210991e-17,   3.412829075798092e-18,
  -8.993948449960413e-21,  -7.220846971912233e-21,  -3.812948514528390e-03,   1.910178873008838e-04,  -5.046939483388815e-06,   2.621370441813062e-08,   1.505604608769903e-09,
   1.323755309421527e-10,  -1.167921653799357e-11,   4.652944194731747e-14,   2.723318260383063e-14,  -9.196467120350606e-16,  -3.544117570661071e-17,   3.053541507414809e-18,
  -7.180207705334179e-21,  -6.469651964751680e-21,  -3.247880593966187e-03,   1.626998724175857e-04,  -4.298128802009174e-06,   2.240225679044046e-08,   1.272565100883145e-09,
   1.127957577086157e-10,  -9.904668888003349e-12,   3.780610588688093e-14,   2.310456908777596e-14,  -7.739828104870404e-16,  -3.020408766407829e-17,   2.572719487129779e-18,
  -5.162302110515270e-21,  -5.459977161905019e-21,  -2.583429540939900e-03,   1.294072556437507e-04,  -3.418149044462222e-06,   1.787584532416030e-08,   1.004589749525245e-09,
   8.974813459546075e-11,  -7.844695112786441e-12,   2.867061541686780e-14,   1.830622655654854e-14,  -6.084500616947764e-16,  -2.403481125097075e-17,   2.024666483925512e-18,
  -3.381281182484795e-21,  -4.303713333690863e-21,  -1.884622248412127e-03,   9.439871389944746e-05,  -2.493161287866452e-06,   1.307378818182227e-08,   7.283766552087647e-10,
   6.548755699614638e-11,  -5.702988481644373e-12,   2.009726641169973e-14,   1.331237970539309e-14,  -4.396653517034023e-16,  -1.753833265390715e-17,   1.464298625246680e-18,
  -2.046651521266187e-21,  -3.116522620544100e-21,  -1.219903380912614e-03,   6.110177587416991e-05,  -1.613639192907735e-06,   8.476813522528493e-09,   4.695624504207800e-10,
   4.239628447917845e-11,  -3.683073411093514e-12,   1.266061267976567e-14,   8.599013164449166e-15,  -2.828032588573239e-16,  -1.135421431842590e-17,   9.424174654573608e-19,
  -1.147030442391105e-21,  -2.007450613892370e-21,  -6.544021150687856e-04,   3.277677586444000e-05,  -8.655707569773291e-07,   4.551204388066332e-09,   2.513651249456455e-10,
   2.274475817015891e-11,  -1.973418418741477e-12,   6.695980726123579e-15,   4.607875429123530e-15,  -1.512147214041058e-16,  -6.091265697197509e-18,   5.040603257249186e-19,
  -5.666539773623253e-22,  -1.074158753183320e-21,  -2.435226773474456e-04,   1.219715546370624e-05,  -3.220989051312353e-07,   1.694147857716530e-09,   9.347243377715515e-11,
   8.464238091055944e-12,  -7.340677809050903e-13,   2.479403288308329e-15,   1.714086499173434e-15,  -5.620794209664363e-17,  -2.266796607545487e-18,   1.873834664196871e-19,
  -2.045852815746215e-22,  -3.993753561286831e-22,  -2.750781278840157e-05,   1.377763993166249e-06,  -3.638351239020936e-08,   1.913765086498674e-10,   1.055723071277497e-11,
   9.561067722046512e-13,  -8.291337752004950e-14,   2.798465331436113e-16,   1.936081159762912e-16,  -6.347992146801272e-18,  -2.560535557163857e-19,   2.116299506439203e-20,
  -2.299699065166762e-23,  -4.510630784573077e-23,  -1.291530814222425e-02,   6.226022896650453e-04,  -1.322573140876380e-05,  -2.267234431301022e-07,   1.963336972393218e-08,
   1.930916640219570e-10,  -4.874685450384046e-11,   5.259511964597737e-13,   1.196778133136223e-13,  -5.258529382291257e-15,  -1.222553369049197e-16,   1.632383249874612e-17,
  -2.299774555364548e-19,  -3.017486272646053e-20,  -1.228749140204689e-02,   5.922985996429543e-04,  -1.257897753765180e-05,  -2.156372060524861e-07,   1.865703510600254e-08,
   1.840024150750763e-10,  -4.627712556323890e-11,   4.949188937899885e-13,   1.136898053441716e-13,  -4.976719825405248e-15,  -1.167189062284126e-16,   1.546091499296021e-17,
  -2.150556023579600e-19,  -2.863072006874300e-20,  -1.109315511887063e-02,   5.346657366811355e-04,  -1.135018595151926e-05,  -1.945735252605650e-07,   1.680867898129014e-08,
   1.665859599960954e-10,  -4.161971965630236e-11,   4.381450741255922e-13,   1.023670328631310e-13,  -4.451422302910071e-15,  -1.060114279629813e-16,   1.384781482022382e-17,
  -1.882413163180500e-19,  -2.572361284368451e-20,  -9.448986265772107e-03,   4.553567607984716e-04,  -9.661623166789854e-06,  -1.656277191970394e-07,   1.428152699096671e-08,
   1.423712563616267e-10,  -3.528729394060984e-11,   3.643337665936244e-13,   8.691338373973554e-14,  -3.749076240033131e-15,  -9.094130151139933e-17,   1.168213307784390e-17,
  -1.543264521634889e-19,  -2.178159128518680e-20,  -7.515762706739819e-03,   3.621435276656290e-04,  -7.680038791082055e-06,  -1.316581157955360e-07,   1.133197400845731e-08,
   1.136044984946081e-10,  -2.794145625425316e-11,   2.829887460469695e-13,   6.891320722893553e-14,  -2.949343374394447e-15,  -7.281925285276302e-17,   9.204906603250710e-18,
  -1.181683547726415e-19,  -1.722406289446819e-20,  -5.482690357534956e-03,   2.641520282659798e-04,  -5.599678325900254e-06,  -9.599481500948918e-08,   8.250400511786566e-09,
   8.308332390342857e-11,  -2.030904247887655e-11,   2.024639508041674e-13,   5.014308613629680e-14,  -2.132413355974852e-15,  -5.339948594170672e-17,   6.663885747745614e-18,
  -8.354084880488206e-20,  -1.250480057417538e-20,  -3.548870818411791e-03,   1.709696736353204e-04,  -3.623377645448446e-06,  -6.211526369067821e-08,   5.333461527639508e-09,
   5.386749241696536e-11,  -1.311414432981066e-11,   1.293600274202222e-13,   3.240181901631877e-14,  -1.372140163281522e-15,  -3.468191381319064e-17,   4.291673874340436e-18,
  -5.294620029273912e-20,  -8.068329046426912e-21,  -1.903737488098704e-03,   9.171066908384229e-05,  -1.943370218164663e-06,  -3.331502999693959e-08,   2.859152288916706e-09,
   2.892070098439401e-11,  -7.026177768414465e-12,   6.892832130389645e-14,   1.736625486815991e-14,  -7.338258439821229e-16,  -1.863653856937334e-17,   2.296214928312470e-18,
  -2.809289551054504e-20,  -4.320977678319094e-21,  -7.084365284011156e-04,   3.412778840596424e-05,  -7.231416091171499e-07,  -1.239675391149757e-08,   1.063728208390648e-09,
   1.076538018845842e-11,  -2.613519715482304e-12,   2.559011049065776e-14,   6.460521814199649e-15,  -2.727885759244383e-16,  -6.939322626577518e-18,   8.537138545352328e-19,
  -1.041422768142822e-20,  -1.607034053783822e-21,  -8.002348564772064e-05,   3.854994607976678e-06,  -8.168376209814608e-08,  -1.400297631027300e-09,   1.201520672408430e-10,
   1.216090709777077e-12,  -2.951974371557491e-13,   2.889526959568817e-15,   7.297314913948580e-16,  -3.080842999604586e-17,  -7.839249008935035e-19,   9.641981434580013e-20,
  -1.175653242533196e-21,  -1.815105023981796e-22,  -2.752198281318712e-02,   1.142832795156198e-03,   2.310150635967295e-06,  -3.079802734006718e-06,   1.607669128510276e-07,
  -3.054199582763831e-10,  -3.873896429706557e-10,   1.883327039332620e-11,   6.303953523407229e-14,  -4.621051371745705e-14,   1.858916924973344e-15,   2.347243523509303e-17,
  -5.071704393320396e-18,   1.611915967926212e-19,  -2.618319410133826e-02,   1.086970234149241e-03,   2.226039687304310e-06,  -2.930055478407114e-06,   1.527746595619908e-07,
  -2.790375896801962e-10,  -3.684806936299901e-10,   1.786804699455323e-11,   6.238030386081750e-14,  -4.392110050287507e-14,   1.758683770665299e-15,   2.268317609859330e-17,
  -4.812887067492891e-18,   1.517717726599097e-19,  -2.363671040578598e-02,   9.808250198551395e-04,   2.054524184641069e-06,  -2.645192108213385e-06,   1.376426495600275e-07,
  -2.335827183046218e-10,  -3.325379190256690e-10,   1.605213182548291e-11,   6.012996932810292e-14,  -3.958256053409708e-14,   1.572052045588571e-15,   2.103366316190501e-17,
  -4.325378702262217e-18,   1.345072003334928e-19,  -2.013186222427401e-02,   8.349452273507927e-04,   1.796145116839652e-06,  -2.253063234454146e-06,   1.169512127034968e-07,
  -1.801438630443635e-10,  -2.831165092736845e-10,   1.359154937573151e-11,   5.511847560540096e-14,  -3.364321773278402e-14,   1.322943018011009e-15,   1.848078690037013e-17,
  -3.663809617340341e-18,   1.119998744321632e-19,  -1.601177654348976e-02,   6.637273948685053e-04,   1.464226230992451e-06,  -1.792034276186023e-06,   9.279904755665749e-08,
  -1.288093877017271e-10,  -2.250850255889129e-10,   1.074799365065134e-11,   4.683123938074515e-14,  -2.670296431060484e-14,   1.039879639233558e-15,   1.512961877020723e-17,
  -2.898232855093091e-18,   8.711335044366475e-20,  -1.167976662015368e-02,   4.839539355658188e-04,   1.089012702360855e-06,  -1.307235987396782e-06,   6.756434068134584e-08,
  -8.548505000065844e-11,  -1.641331987844573e-10,   7.803730198004979e-12,   3.590846516901191e-14,  -1.944564117696699e-14,   7.513228011381975e-16,   1.128644192849838e-17,
  -2.104767756517383e-18,   6.239692594318316e-20,  -7.559854514016822e-03,   3.131584174818862e-04,   7.138206620417186e-07,  -8.461384316525435e-07,   4.367710275365834e-08,
  -5.171490319551092e-11,  -1.062130337227261e-10,   5.035503070101133e-12,   2.398595627024756e-14,  -1.257222373891741e-14,   4.832224782421694e-16,   7.411281808503526e-18,
  -1.358311334431458e-18,   3.989841373099015e-20,  -4.055285862594901e-03,   1.679619457349066e-04,   3.853732908514114e-07,  -4.538930169175199e-07,   2.341438609625944e-08,
  -2.674631017330091e-11,  -5.696851479328965e-11,   2.696883553651280e-12,   1.307095034702288e-14,  -6.740109960992885e-15,   2.583649114719991e-16,   4.004628969689916e-18,
  -7.275182396638771e-19,   2.126821228862933e-20,  -1.509080065233445e-03,   6.250005405612462e-05,   1.437266008786427e-07,  -1.689062401587399e-07,   8.711168413534837e-09,
  -9.824250507277767e-12,  -2.119863334754440e-11,   1.003028087356426e-12,   4.890477233258406e-15,  -2.507664259962033e-15,   9.603482383078416e-17,   1.493981111712257e-18,
  -2.705846320134234e-19,   7.897103396247281e-21,  -1.704622875635070e-04,   7.059810453652430e-06,   1.624074944095717e-08,  -1.907927832500984e-08,   9.839590358352437e-10,
  -1.107417575120703e-12,  -2.394534270192911e-12,   1.132898612774642e-13,   5.528908279785789e-16,  -2.832509524592760e-16,   1.084591240274184e-17,   1.688239430674422e-19,
  -3.056204284085981e-20,   8.917278633478419e-22,  -3.954151546141015e-04,   1.937952712598433e-05,  -5.930444731683326e-07,   9.060897746043602e-09,   1.267642139309835e-10,
  -4.914616206664697e-12,  -5.196707023573437e-13,   3.967869693454290e-14,  -6.125741505831834e-16,  -5.561770628061483e-17,   3.365871879764183e-18,  -1.990338598533392e-20,
  -5.745254855122719e-21,   2.565215276969492e-22,  -3.761996296958121e-04,   1.843770600243522e-05,  -5.641765537234532e-07,   8.618786903776056e-09,   1.203647664051057e-10,
  -4.651076569681066e-12,  -4.948784958625401e-13,   3.768900623568450e-14,  -5.783669222856793e-16,  -5.293953350355111e-17,   3.190927391122121e-18,  -1.836209363079415e-20,
  -5.461896225154730e-21,   2.424455866022543e-22,  -3.396423756181009e-04,   1.664592823580810e-05,  -5.092755246960977e-07,   7.778415347370589e-09,   1.082869504847154e-10,
  -4.159800553209439e-12,  -4.475188679722718e-13,   3.392862172905744e-14,  -5.151147105803998e-16,  -4.783306099078797e-17,   2.862738439957911e-18,  -1.566845261175851e-20,
  -4.924292060082283e-21,   2.163272378415366e-22,  -2.893117622716563e-04,   1.417912279855105e-05,  -4.337281665949752e-07,   6.622844782591275e-09,   9.184708011628778e-11,
  -3.502967567824380e-12,  -3.819471224798828e-13,   2.879991685360193e-14,  -4.315519286395303e-16,  -4.078204376073840e-17,   2.419884938302643e-18,  -1.241755625637914e-20,
  -4.187222269388033e-21,   1.816440167866971e-22,  -2.301270209111443e-04,   1.127841556690240e-05,  -3.449388919387572e-07,   5.265769612263115e-09,   7.275398551285325e-11,
  -2.755231852837664e-12,  -3.043808381255825e-13,   2.283033987344650e-14,  -3.377127372808362e-16,  -3.246644204732069e-17,   1.910477262056657e-18,  -9.166182148703955e-21,
  -3.324709994226949e-21,   1.424646497658075e-22,  -1.678801316666885e-04,   8.227682473018502e-06,  -2.516007295009388e-07,   3.840128828949132e-09,   5.289609130155431e-11,
  -1.991712146756424e-12,  -2.223802426744473e-13,   1.660915324679314e-14,  -2.431134308531010e-16,  -2.369981603633843e-17,   1.385278388398765e-18,  -6.272199522313691e-21,
  -2.421797723573222e-21,   1.027462614875068e-22,  -1.086683469836041e-04,   5.325737912999912e-06,  -1.628451206027527e-07,   2.485148014741919e-09,   3.416300477091047e-11,
  -1.281431394999909e-12,  -1.440867472254780e-13,   1.073145529613283e-14,  -1.559801931086401e-16,  -1.534707549192415e-17,   8.930820468003858e-19,  -3.883667473102583e-21,
  -1.566036536600400e-21,   6.600257913468287e-23,  -5.829397563553413e-05,   2.856930252753345e-06,  -8.735230463364443e-08,   1.332978095520758e-09,   1.830530002762642e-11,
  -6.852637395577438e-13,  -7.733237213972678e-14,   5.751373535346946e-15,  -8.329267738916379e-17,  -8.234455242201025e-18,   4.780917744500915e-19,  -2.034952435429843e-21,
  -8.396398332690261e-22,   3.526753252352699e-23,  -2.169296233562651e-05,   1.063150035603995e-06,  -3.250590397498071e-08,   4.960219113450174e-10,   6.809228471057869e-12,
  -2.547295863192976e-13,  -2.878271528538427e-14,   2.139561504094371e-15,  -3.094640394453721e-17,  -3.064506572591607e-18,   1.777839695969879e-19,  -7.510090112790015e-22,
  -3.123976598974315e-22,   1.310615106735714e-23,  -2.450392119839649e-06,   1.200912155291271e-07,  -3.671789821973787e-09,   5.602925345318139e-11,   7.691074021363547e-13,
  -2.876874595616255e-14,  -3.251325261216432e-15,   2.416678978272744e-16,  -3.494757614568033e-18,  -3.461641627965024e-19,   2.007980548680826e-20,  -8.472029104943845e-23,
  -3.528675347679330e-23,   1.480121634756388e-24,  -3.640393056400917e-03,   1.774548256724935e-04,  -5.293437805354015e-06,   6.763282773281068e-08,   2.122863760025864e-09,
  -8.027389753492495e-11,  -4.370420935711461e-12,   3.938187273806527e-13,  -6.871026833228856e-15,  -5.488863919686533e-16,   3.602599852792781e-17,  -3.355117057163174e-19,
  -5.712649738435913e-20,   2.874924150986898e-21,  -3.463479959321385e-03,   1.688293520530599e-04,  -5.035589387953064e-06,   6.432002694470973e-08,   2.017637204290258e-09,
  -7.612626210872123e-11,  -4.163291954813834e-12,   3.740725202855006e-13,  -6.489535192633838e-15,  -5.226756366165626e-16,   3.416165653273781e-17,  -3.127490171835768e-19,
  -5.434432174427204e-20,   2.718621302713314e-21,  -3.126907497492209e-03,   1.524202899312289e-04,  -4.545284999555933e-06,   5.802820066449033e-08,   1.818281771585949e-09,
  -6.833630635416341e-11,  -3.767040285826598e-12,   3.367524382751681e-13,  -5.783320775802982e-15,  -4.726074240536993e-16,   3.066102488137935e-17,  -2.721233700389948e-19,
  -4.905114322810462e-20,   2.428048093607134e-21,  -2.663531645065225e-03,   1.298304322403729e-04,  -3.870734004110807e-06,   4.938655798184241e-08,   1.545441805902311e-09,
  -5.780641474526519e-11,  -3.217300425287994e-12,   2.858506726205970e-13,  -4.848761273492444e-15,  -4.032967977349368e-16,   2.593113256264799e-17,  -2.213351126904922e-19,
  -4.176602594202067e-20,   2.041124046576712e-21,  -2.118644213116695e-03,   1.032684891590022e-04,  -3.078124577231735e-06,   3.925073099027858e-08,   1.226665304621042e-09,
  -4.567014409192505e-11,  -2.565621979337126e-12,   2.266016182691272e-13,  -3.797229317202715e-15,  -3.213355757317493e-16,   2.048257087747386e-17,  -1.680420820623170e-19,
  -3.320618721755324e-20,   1.602683707171990e-21,  -1.545569805487366e-03,   7.533404399183471e-05,  -2.245072658169377e-06,   2.861463181537307e-08,   8.933215596410786e-10,
  -3.313458589523656e-11,  -1.875426788482499e-12,   1.648540971266933e-13,  -2.735221135839032e-15,  -2.347270105011008e-16,   1.485777971061252e-17,  -1.179125962165295e-19,
  -2.421342798337287e-20,   1.156929861252303e-21,  -1.000441415718811e-03,   4.876290841780636e-05,  -1.453036035793551e-06,   1.851398195334642e-08,   5.775836600546865e-10,
  -2.137007675309514e-11,  -1.215563642636922e-12,   1.065152267323272e-13,  -1.755617847569117e-15,  -1.520675886460932e-16,   9.581280754819131e-18,  -7.433526324211432e-20,
  -1.566814534278735e-20,   7.436494261280893e-22,  -5.366756677701817e-04,   2.615817375479792e-05,  -7.794124480991985e-07,   9.929375238480635e-09,   3.096564269342498e-10,
  -1.144232201037531e-11,  -6.525165155273822e-13,   5.708539296316701e-14,  -9.376895449454435e-16,  -8.161022626972746e-17,   5.129827730285120e-18,  -3.933013214420404e-20,
  -8.403510545111412e-21,   3.974841109513594e-22,  -1.997132886807166e-04,   9.734230691776422e-06,  -2.900361971291152e-07,   3.694731098057868e-09,   1.152089797420307e-10,
  -4.255261956001100e-12,  -2.428781835896184e-13,   2.123627317320728e-14,  -3.484131141079459e-16,  -3.037417899582209e-17,   1.907676628148325e-18,  -1.456529540713127e-20,
  -3.127002969363806e-21,   1.477296838538523e-22,  -2.255919860729415e-05,   1.099558157645466e-06,  -3.276176487205050e-08,   4.173439507729172e-10,   1.301334480425639e-11,
  -4.806158593651859e-13,  -2.743603675174153e-14,   2.398681075844939e-15,  -3.934653160472672e-17,  -3.431085438513270e-18,   2.154641095902461e-19,  -1.643999905681599e-21,
  -3.532161883627290e-22,   1.668390127831227e-23,  -1.064627728621873e-02,   5.111828543681300e-04,  -1.411275359985013e-05,   6.519905433496245e-08,   1.445567596690904e-08,
  -5.470418083133230e-10,  -9.039214339531355e-12,   1.456276054865305e-12,  -3.660919272507697e-14,  -1.678126035652749e-15,   1.485888913398469e-16,  -2.804809914988533e-18,
  -1.821046436098412e-19,   1.321382253703673e-20,  -1.012885463101205e-02,   4.863242591120105e-04,  -1.342373614810346e-05,   6.186788571478562e-08,   1.374840405069300e-08,
  -5.195329386821388e-10,  -8.628900032991280e-12,   1.383617025225402e-12,  -3.463268791060753e-14,  -1.600802625095133e-15,   1.409990875479728e-16,  -2.638500371944945e-18,
  -1.737147489230999e-19,   1.251542389929398e-20,  -9.144489157485974e-03,   4.390381434841677e-04,  -1.211419207465501e-05,   5.559697102951849e-08,   1.240475927282621e-08,
  -4.675755955227958e-10,  -7.836280265496486e-12,   1.246147097001363e-12,  -3.095342193664561e-14,  -1.451909670663421e-15,   1.267085257272868e-16,  -2.334486955938975e-18,
  -1.575520245772001e-19,   1.120946002489667e-20,  -7.789298549263266e-03,   3.739500303144742e-04,  -1.031378444223753e-05,   4.709213471561578e-08,   1.055863920453404e-08,
  -3.967737040689548e-10,  -6.721984218366123e-12,   1.058368644736653e-12,  -2.604431997994837e-14,  -1.243522717517141e-15,   1.073237355635590e-16,  -1.939771243152434e-18,
  -1.349239514972614e-19,   9.455685637528077e-21,  -6.195761671523204e-03,   2.974288756963903e-04,  -8.199840421322382e-06,   3.725347690404727e-08,   8.392533600894516e-09,
  -3.144390642457856e-10,  -5.382831759751298e-12,   8.394447383893909e-13,  -2.046848251624529e-14,  -9.942785661860862e-16,   8.489747662822977e-17,  -1.505513563013783e-18,
  -1.078607815098146e-19,   7.449600314669986e-21,  -4.519831239869115e-03,   2.169646810064439e-04,  -5.979495644606066e-06,   2.705659978594062e-08,   6.118838610909728e-09,
  -2.287023816062887e-10,  -3.947827784039217e-12,   6.109626066485892e-13,  -1.478673016535475e-14,  -7.283177688864420e-16,   6.165618695032277e-17,  -1.076405537915709e-18,
  -7.899316542729863e-20,   5.392328444204738e-21,  -2.925655740408017e-03,   1.404351303437072e-04,  -3.869495171431187e-06,   1.746232552540332e-08,   3.959162309864507e-09,
  -1.477460967421881e-10,  -2.564352108810652e-12,   3.948653732938244e-13,  -9.509429100242255e-15,  -4.726997047816910e-16,   3.979101022278480e-17,  -6.874321618083355e-19,
  -5.126083780742825e-20,   3.472349764070614e-21,  -1.569431695790747e-03,   7.533340923987223e-05,  -2.075469603229520e-06,   9.353348854761603e-09,   2.123424204524783e-09,
  -7.917634580531934e-11,  -1.378072990987278e-12,   2.116533535663802e-13,  -5.084181013312617e-15,  -2.539200612101463e-16,   2.131268227389680e-17,  -3.662037460226891e-19,
  -2.753334823016114e-20,   1.857717555851663e-21,  -5.840326316554259e-04,   2.803365741515603e-05,  -7.723091618393872e-07,   3.478836446785766e-09,   7.901355335951501e-10,
  -2.945350833323444e-11,  -5.131402554289891e-13,   7.874088789903411e-14,  -1.889771426678187e-15,  -9.453598159468712e-17,   7.926849813208508e-18,  -1.359441012010044e-19,
  -1.025050538813427e-20,   6.906670145705510e-22,  -6.597110520310722e-05,   3.166620384319015e-06,  -8.723779465388055e-08,   3.929293778524441e-10,   8.925108403863310e-11,
  -3.326820583066619e-12,  -5.796894722516800e-14,   8.894017489290782e-15,  -2.134251150017928e-16,  -1.067938752522815e-17,   8.953243932153803e-19,  -1.535002491951415e-20,
  -1.157956540692458e-21,   7.800473156865366e-23,  -2.308972294543953e-02,   1.054319712119551e-03,  -2.058481089250320e-05,  -8.928319144906518e-07,   1.009033816567933e-07,
  -4.081327170868237e-09,   1.657101981049297e-11,   7.598526751787285e-12,  -4.369901783809492e-13,   7.669205257177770e-15,   4.513114877910179e-16,  -3.713743326309319e-17,
   1.003514926119271e-18,   1.890299682598653e-20,  -2.196721663380501e-02,   1.002955315418868e-03,  -1.956554509015652e-05,  -8.506029349697801e-07,   9.600141932838850e-08,
  -3.878029620538613e-09,   1.540479232996802e-11,   7.236726225834054e-12,  -4.151157873543735e-13,   7.235914936516887e-15,   4.312453999652681e-16,  -3.528316632812694e-17,
   9.472385219380958e-19,   1.828474747793998e-20,  -1.983184405981078e-02,   9.052875853592478e-04,  -1.763410690631980e-05,  -7.697894644762769e-07,   8.667466846017852e-08,
  -3.493271211190096e-09,   1.333362832525332e-11,   6.545283675005133e-12,  -3.737564227477578e-13,   6.436352994725005e-15,   3.922906337757018e-16,  -3.177466098514307e-17,
   8.432345553883454e-19,   1.698302208008383e-20,  -1.689229378277117e-02,   7.709239220054602e-04,  -1.498990553826118e-05,  -6.576127281360848e-07,   7.383254836834404e-08,
  -2.967457887705959e-09,   1.076748517640281e-11,   5.587366987619952e-12,  -3.173147586664758e-13,   5.383448359753749e-15,   3.371683835514948e-16,  -2.698246210002300e-17,
   7.059746530075083e-19,   1.495079687594238e-20,  -1.343606135790524e-02,   6.130517510969992e-04,  -1.189943207765228e-05,  -5.245458283826169e-07,   5.872980026587048e-08,
  -2.354098442187250e-09,   8.109946136741047e-12,   4.453519335383416e-12,  -2.515822450673209e-13,   4.205768082506631e-15,   2.704929967020970e-16,  -2.139696489248036e-17,
   5.520623184205583e-19,   1.226227670220765e-20,  -9.801420180116758e-03,   4.471315901510464e-04,  -8.666674776058054e-06,  -3.835192847295660e-07,   4.284460679651617e-08,
  -1.713631852585866e-09,   5.649509865641929e-12,   3.254218958381723e-12,  -1.830485038539978e-13,   3.023345517744418e-15,   1.986658307462819e-16,  -1.557014236036810e-17,
   3.971634723068197e-19,   9.160746269839200e-21,  -6.344290688667081e-03,   2.893858590947436e-04,  -5.603889295740240e-06,  -2.486172908214316e-07,   2.773340307833124e-08,
  -1.107642032042382e-09,   3.542965508292549e-12,   2.108708163156502e-12,  -1.182793743331540e-13,   1.937864336510568e-15,   1.291641283229220e-16,  -1.006157297108211e-17,
   2.547014091009779e-19,   6.021127235904523e-21,  -3.403288038054275e-03,   1.552266067651227e-04,  -3.004486812466631e-06,  -1.334689344630091e-07,   1.487733800397425e-08,
  -5.937453403035143e-10,   1.869222176242862e-12,   1.131813938084604e-12,  -6.339246224488032e-14,   1.034278511980583e-15,   6.944458852986883e-17,  -5.392727417142457e-18,
   1.359761151479268e-19,   3.255036503312876e-21,  -1.266461991175261e-03,   5.776307383187105e-05,  -1.117845995015547e-06,  -4.968090907262849e-08,   5.536316228070322e-09,
  -2.208940444442161e-10,   6.915336990041082e-13,   4.212625287416947e-13,  -2.358284336865194e-14,   3.842044221490029e-16,   2.586259291392820e-17,  -2.006187953803457e-18,
   5.051593554717941e-20,   1.214538216418820e-21,  -1.430568342336138e-04,   6.524770889451634e-06,  -1.262657161326239e-07,  -5.612086665169094e-09,   6.253709260576770e-10,
  -2.495071822061155e-11,   7.804143517749430e-14,   4.758637838349200e-14,  -2.663736115511416e-15,   4.338671127489857e-17,   2.921745894589520e-18,  -2.266038941273975e-19,
   5.704653520433366e-21,   1.372497648312296e-22,  -3.255284372521206e-04,   1.504200476466647e-05,  -4.750264421865595e-07,   9.912965562292588e-09,  -2.241428651367621e-11,
  -7.270135500548814e-12,   1.746197798769429e-13,   9.242872394203129e-15,  -8.178785872836370e-16,   2.250540395758503e-17,  -3.010102771692645e-04,   1.390940573698483e-05,
  -4.392235963646711e-07,   9.162544220867945e-09,  -2.061365643326058e-11,  -6.713419452192574e-12,   1.604567690114100e-13,   8.580651143846307e-15,  -7.554424581052545e-16,
   2.067728683963695e-17,  -2.556940347188340e-04,   1.181585093738016e-05,  -3.730651327444203e-07,   7.777860781584752e-09,  -1.735435499717562e-11,  -5.689947192111901e-12,
   1.348920631227342e-13,   7.335923017430897e-15,  -6.405364860704199e-16,   1.737898212875896e-17,  -1.964644953054879e-04,   9.079180649620428e-06,  -2.866192529589390e-07,
   5.971873942949827e-09,  -1.320803636695652e-11,  -4.361454517334109e-12,   1.024986407066542e-13,   5.674716880781504e-15,  -4.911900850678176e-16,   1.320228224283445e-17,
  -1.323340830129197e-04,   6.115733798695205e-06,  -1.930453261959050e-07,   4.020240863873038e-09,  -8.830088115713224e-12,  -2.932215229450662e-12,   6.843364835185568e-14,
   3.842430813117667e-15,  -3.303339834384854e-16,   8.812798152592897e-18,  -7.307208294257597e-05,   3.377042928221095e-06,  -1.065907705208206e-07,   2.219166183743328e-09,
  -4.854671709184190e-12,  -1.617330654990591e-12,   3.759430112211632e-14,   2.128075564226198e-15,  -1.822362307122232e-16,   4.840776624202075e-18,  -2.770993447382341e-05,
   1.280630033753154e-06,  -4.041999928418583e-08,   8.414348938614044e-10,  -1.837957598734290e-12,  -6.130606684325608e-13,   1.422875831862758e-14,   8.078999097196535e-16,
  -6.908257116660217e-17,   1.832064025984031e-18,  -3.159314134596304e-06,   1.460096320875186e-07,  -4.608423695781285e-09,   9.593321338401463e-11,  -2.094958111520607e-13,
  -6.989257071548804e-14,   1.621754444126522e-15,   9.212879799601057e-17,  -7.875912169400603e-18,   2.088120311568088e-19,  -2.999059241722611e-03,   1.383069189388149e-04,
  -4.325576690360828e-06,   8.591048065506189e-08,   1.873090652465151e-10,  -8.700724645032424e-11,   2.263591153380908e-12,   7.817501257156268e-14,  -8.111087115573404e-15,
   2.420361081077506e-16,  -2.773173630195268e-03,   1.278922896218773e-04,  -3.999452947621224e-06,   7.939644077325617e-08,   1.746399532641101e-10,  -8.037467869477897e-11,
   2.083033356424651e-12,   7.265403109469631e-14,  -7.493317885750539e-15,   2.224678409015429e-16,  -2.355676887809732e-03,   1.086417741412978e-04,  -3.396886344485003e-06,
   6.738301634948105e-08,   1.503464616819850e-10,  -6.816345799111415e-11,   1.755410175389835e-12,   6.222537980414221e-14,  -6.355526929183895e-15,   1.871099103734779e-16,
  -1.809999894575750e-03,   8.347843810211698e-05,  -2.609648310165718e-06,   5.172497866979176e-08,   1.171403642324046e-10,  -5.228299481925975e-11,   1.337358836685802e-12,
   4.822380089297012e-14,  -4.875281147800996e-15,   1.422467218894251e-16,  -1.219173939529821e-03,   5.623062750854851e-05,  -1.757601316820992e-06,   3.481468654666733e-08,
   7.975802429281780e-11,  -3.516826039976171e-11,   8.947652842025726e-13,   3.269979716746641e-14,  -3.279554289765751e-15,   9.500848010895163e-17,  -6.732016140919887e-04,
   3.104981601627634e-05,  -9.704467295260981e-07,   1.921562213355156e-08,   4.431221271092429e-11,  -1.940370567266573e-11,   4.921440321683465e-13,   1.812510100534988e-14,
  -1.809507625920918e-15,   5.220499810614504e-17,  -2.552872050135745e-04,   1.177457976984224e-05,  -3.679976350771103e-07,   7.285643875068571e-09,   1.684239600669833e-11,
  -7.355945781541103e-12,   1.863535365482367e-13,   6.883086037532492e-15,  -6.859906932523016e-16,   1.976030630279909e-17,  -2.910625579317111e-05,   1.342465462096554e-06,
  -4.195662711449377e-08,   8.306413765372445e-10,   1.920994176185271e-12,  -8.386374271195727e-13,   2.124168754295845e-14,   7.849516779724895e-16,  -7.820861179733469e-17,
   2.252256427321448e-18,  -8.787369743879055e-03,   4.030886251082697e-04,  -1.226775337749829e-05,   2.075538643846685e-07,   3.839489002238754e-09,  -4.279339797104552e-10,
   1.259507486635975e-11,   1.520469758450072e-13,  -2.877035037724425e-14,   1.068318571209053e-15,  -8.125496282867458e-03,   3.727299231391207e-04,  -1.134195436856785e-05,
   1.917207976253940e-07,   3.558209375393488e-09,  -3.955274874952334e-10,   1.161031815825173e-11,   1.422374408746958e-13,  -2.659877546861255e-14,   9.832634887198137e-16,
  -6.902189441121052e-03,   3.166180494662849e-04,  -9.631920838235087e-06,   1.625782821956197e-07,   3.033522297167833e-09,  -3.357356741452875e-10,   9.812062611203166e-12,
   1.231052734431293e-13,  -2.258734152322996e-14,   8.288255826146773e-16,  -5.303321028154073e-03,   2.432771735594080e-04,  -7.398692612633500e-06,   1.246905558957648e-07,
   2.339760333639544e-09,  -2.577625081776822e-10,   7.498137176864187e-12,   9.643938553274099e-14,  -1.734879549005341e-14,   6.316005690918654e-16,  -3.572182429502111e-03,
   1.638666959509226e-04,  -4.982496039556934e-06,   8.386811236241748e-08,   1.580728844733042e-09,  -1.735147667648789e-10,   5.028831378308847e-12,   6.593578556909593e-14,
  -1.168209288807817e-14,   4.226537541201613e-16,  -1.972478571230233e-03,   9.048392624219563e-05,  -2.750878982965245e-06,   4.627176485557696e-08,   8.743454208647673e-10,
  -9.577648353924189e-11,   2.769886448303144e-12,   3.671847564954659e-14,  -6.449371299163415e-15,   2.324943274060810e-16,  -7.479901655587783e-04,   3.431277227557914e-05,
  -1.043121124757579e-06,   1.754141504284298e-08,   3.317771670531319e-10,  -3.631479857302088e-11,   1.049392483238031e-12,   1.396823781030201e-14,  -2.445509638849118e-15,
   8.803879186257063e-17,  -8.528116615289632e-05,   3.912129109441915e-06,  -1.189292311292423e-07,   1.999859477086301e-09,   3.783119796931407e-11,  -4.140293402820237e-12,
   1.196265533786053e-13,   1.593404291278200e-15,  -2.788183420056989e-16,   1.003524848000450e-17,  -1.917183536993914e-02,   8.654099809695669e-04,  -2.401377197096727e-05,
   1.375640198882775e-07,   3.353533064606910e-08,  -2.385706362574587e-09,   8.537002617820757e-11,  -8.119127038962641e-13,  -9.982314944751645e-14,   6.853228008680341e-15,
  -1.772766300114637e-02,   8.001896687478743e-04,  -2.219460176629081e-05,   1.261456286611216e-07,   3.106304661808330e-08,  -2.206562832865117e-09,   7.880970634958256e-11,
  -7.398862940291030e-13,  -9.270383250895784e-14,   6.336943501800297e-15,  -1.505855170633951e-02,   6.796683719487653e-04,  -1.883861010144908e-05,   1.056802185819134e-07,
   2.646112933131887e-08,  -1.875116469304633e-09,   6.676270520227960e-11,  -6.133364643563861e-13,  -7.930192172856289e-14,   5.382615929684947e-15,  -1.157014096782598e-02,
   5.221834510509845e-04,  -1.446282696516931e-05,   7.999797266162253e-08,   2.039226360939169e-08,  -1.441355423345598e-09,   5.114833820649487e-11,  -4.589036578123338e-13,
  -6.138187144135731e-14,   4.135346647990304e-15,  -7.793274059921009e-03,   3.517071325141303e-04,  -9.735485928754812e-06,   5.324749169187476e-08,   1.376786481408154e-08,
  -9.711740786011845e-10,   3.437294712739909e-11,  -3.025577222481567e-13,  -4.158264914810829e-14,   2.785168037007512e-15,  -4.303244887986266e-03,   1.941975956163428e-04,
  -5.373704185719126e-06,   2.919902620304185e-08,   7.612538144845372e-09,  -5.363590198450593e-10,   1.895464142856881e-11,  -1.649792156401096e-13,  -2.303639148507126e-14,
   1.537794385954756e-15,  -1.631844217334614e-03,   7.364129728047101e-05,  -2.037493691793444e-06,   1.104374714483833e-08,   2.888232280194019e-09,  -2.034084325170562e-10,
   7.184242047573795e-12,  -6.226525453283583e-14,  -8.746423843574487e-15,   5.831347997534440e-16,  -1.860526157992899e-04,   8.396101421092972e-06,  -2.322968864194934e-07,
   1.258592623811313e-09,   3.293257210528738e-10,  -2.319162176032294e-11,   8.190341345372899e-13,  -7.093481216195167e-15,  -9.974150469339799e-16,   6.648505185848774e-17,
  -2.722284532368793e-04,   1.170220268430028e-05,  -3.621494761423920e-07,   8.663444941377729e-09,  -1.169787735137152e-10,  -2.169839519235802e-12,   1.891467753979495e-13,
  -4.354169029983660e-15,  -1.031874977476735e-16,   1.216347537126999e-17,  -2.517232415304261e-04,   1.082120465084971e-05,  -3.348803818453081e-07,   8.009412754107593e-09,
  -1.080367478732485e-10,  -2.010190506142441e-12,   1.747566476748420e-13,  -4.006661342052666e-15,  -9.628971400823286e-17,   1.125659479333302e-17,  -2.138249304230388e-04,
   9.192644944676553e-06,  -2.844752167544362e-07,   6.801499082221620e-09,  -9.158900267100992e-11,  -1.712809687771332e-12,   1.482455234001965e-13,  -3.376180088656030e-15,
  -8.300932349957933e-17,   9.574586263134462e-18,  -1.642923404754481e-04,   7.063681611463627e-06,  -2.185869522785947e-07,   5.224255040279820e-09,  -7.022397308684345e-11,
  -1.320305721897144e-12,   1.137396068058723e-13,  -2.571852197489164e-15,  -6.476870736460561e-17,   7.366744440917933e-18,  -1.106627379312987e-04,   4.758171634590444e-06,
  -1.472396071727190e-07,   3.518023497827005e-09,  -4.722230277587188e-11,  -8.915726976104501e-13,   7.652382667229640e-14,  -1.720534580254250e-15,  -4.414878512578636e-17,
   4.967263928299868e-18,  -6.110533700688752e-05,   2.627436302615811e-06,  -8.130397438341980e-08,   1.942285583414519e-09,  -2.605000051713359e-11,  -4.930202969068065e-13,
   4.222645760312172e-14,  -9.462787643675861e-16,  -2.454402172047537e-17,   2.744443104361013e-18,  -2.317193964401863e-05,   9.963704344009981e-07,  -3.083177606063177e-08,
   7.364996090288281e-10,  -9.874935783308553e-12,  -1.870613557222543e-13,   1.600879946854629e-14,  -3.583057745995166e-16,  -9.331040674115251e-18,   1.040959730351958e-18,
  -2.641919456502544e-06,   1.136001514340842e-07,  -3.515250762893334e-09,   8.397031023292718e-11,  -1.125810996616269e-12,  -2.132948422730150e-14,   1.825146972254770e-15,
  -4.084166030685074e-17,  -1.064313225932476e-18,   1.186880663677862e-19,  -2.508587497739742e-03,   1.077657960711462e-04,  -3.323542596863101e-06,   7.825818830512536e-08,
  -9.496788276194885e-10,  -2.776508652065920e-11,   2.093323223466458e-12,  -5.104753151036717e-14,  -7.995180279131002e-16,   1.183615460476040e-16,  -2.319631148377333e-03,
   9.965246211216045e-05,  -3.073253646257770e-06,   7.234660374828302e-08,  -8.767169307564361e-10,  -2.571821357712812e-11,   1.934489136844436e-12,  -4.701158083655114e-14,
  -7.483767163169421e-16,   1.095702867252301e-16,  -1.970397080658048e-03,   8.465476816099482e-05,  -2.610630625751199e-06,   6.143083879551407e-08,  -7.427312236324165e-10,
  -2.190802152840425e-11,   1.641613950223082e-12,  -3.966737153996203e-14,  -6.483390146771240e-16,   9.324440463050578e-17,  -1.513953441530069e-03,   6.504897769341473e-05,
  -2.005935817877150e-06,   4.718112032841644e-08,  -5.690552516609227e-10,  -1.688320109907950e-11,   1.259993471423771e-12,  -3.026106398301224e-14,  -5.084211092388397e-16,
   7.178062378392992e-17,  -1.019756414994755e-03,   4.381756293175938e-05,  -1.351173098438866e-06,   3.176967095313958e-08,  -3.824404524230488e-10,  -1.139854144339664e-11,
   8.479793645971223e-13,  -2.026769484034917e-14,  -3.478874069722872e-16,   4.842035647607677e-17,  -5.630851597897553e-04,   2.419577806807237e-05,  -7.460954371954017e-07,
   1.753920046125459e-08,  -2.109008419814987e-10,  -6.302420411545772e-12,   4.680040978966882e-13,  -1.115457218990047e-14,  -1.938219399405775e-16,   2.675888176351418e-17,
  -2.135292084104773e-04,   9.175462361684500e-06,  -2.829304883610602e-07,   6.650629197741322e-09,  -7.993738171577439e-11,  -2.391156621105328e-12,   1.774403962384328e-13,
  -4.224721924350269e-15,  -7.374545352789075e-17,   1.015047241714006e-17,  -2.434526289288865e-05,   1.046130806610722e-06,  -3.225798866651177e-08,   7.582543238888150e-10,
  -9.113223353057155e-12,  -2.726473112441000e-13,   2.023002132216213e-14,  -4.815773513749700e-16,  -8.412636007269785e-18,   1.157352822184251e-18,  -7.354772516020085e-03,
   3.154108708758123e-04,  -9.637352768173525e-06,   2.169480820642560e-07,  -1.747506984218219e-09,  -1.457822182415056e-10,   9.142967922147880e-12,  -2.490429495135341e-13,
  -6.757540727355884e-16,   3.903527047862319e-16,  -6.800777991748190e-03,   2.916629717513945e-04,  -8.911314322355734e-06,   2.005294441846341e-07,  -1.609765266430576e-09,
  -1.350192502057630e-10,   8.452713216870940e-12,  -2.296471039224203e-13,  -6.606655733718305e-16,   3.617302926878370e-16,  -5.776873882710543e-03,   2.477653978905554e-04,
  -7.569499497372252e-06,   1.702306889264535e-07,  -1.358883672435519e-09,  -1.149944351772110e-10,   7.177864039039390e-12,  -1.941827870802110e-13,  -6.110648125008320e-16,
   3.083488124288809e-16,  -4.438651845322324e-03,   1.903817942202245e-04,  -5.815884628270487e-06,   1.307086000537642e-07,  -1.037152173130208e-09,  -8.860226306833200e-11,
   5.513224133436621e-12,  -1.484735863567519e-13,  -5.100890394342621e-16,   2.377898265995318e-16,  -2.989747829184278e-03,   1.282418504868969e-04,  -3.917343149914261e-06,
   8.799490661539569e-08,  -6.949159994195335e-10,  -5.981020634137184e-11,   3.712527672708142e-12,  -9.962176594908242e-14,  -3.650541258972699e-16,   1.606251434673518e-16,
  -1.650866426165326e-03,   7.081401104302010e-05,  -2.163039937831044e-06,   4.857378615815915e-08,  -3.825434354436167e-10,  -3.306718130899623e-11,   2.049636748526544e-12,
  -5.488565283304610e-14,  -2.084084040024427e-16,   8.883784290527638e-17,  -6.260298569337979e-04,   2.685386649105650e-05,  -8.202494889565483e-07,   1.841768803386837e-08,
  -1.448984847630751e-10,  -1.254539583523009e-11,   7.772011262093877e-13,  -2.079581168912593e-14,  -8.000374793594789e-17,   3.370896232064527e-17,  -7.137600046347743e-05,
   3.061714824429121e-06,  -9.351964549368352e-08,   2.099829305722586e-09,  -1.651726240187628e-11,  -1.430458755901847e-12,   8.861069925088789e-14,  -2.370676616926203e-15,
  -9.139903628413455e-18,   3.843671700110910e-18,  -1.607502149269690e-02,   6.860652016573479e-04,  -2.038904817694238e-05,   3.918963279413557e-07,   3.372256299631904e-09,
  -7.963987583442508e-10,   4.448623371442563e-11,  -1.486694937164475e-12,   2.176624020206808e-14,   8.549091858761096e-16,  -1.486414616550643e-02,   6.343990777947857e-04,
  -1.885111981184267e-05,   3.620008305251806e-07,   3.147416390227535e-09,  -7.377271547966084e-10,   4.115861288361965e-11,  -1.373220500705901e-12,   1.997360536208356e-14,
   7.975630411104497e-16,  -1.262620091487465e-02,   5.389017371569465e-04,  -1.600996933196276e-05,   3.069740021602555e-07,   2.714246648522426e-09,  -6.284915217627843e-10,
   3.499413672804190e-11,  -1.164381996959976e-12,   1.675259603002256e-14,   6.873053747470804e-16,  -9.701284274457961e-03,   4.140771274694298e-04,  -1.229879227810209e-05,
   2.354342291596490e-07,   2.118678708210247e-09,  -4.843939275053191e-10,   2.691373145822602e-11,  -8.929329940576697e-13,   1.269713252909129e-14,   5.360867264673751e-16,
  -6.534485497417779e-03,   2.789171802873066e-04,  -8.282812561208705e-06,   1.583541012645245e-07,   1.444682382526683e-09,  -3.270644965251010e-10,   1.814200091724003e-11,
  -6.005365371316547e-13,   8.459642149893325e-15,   3.653266679578277e-16,  -3.608178523029005e-03,   1.540134711642639e-04,  -4.573153742978118e-06,   8.736670302367196e-08,
   8.033291996700438e-10,  -1.808488674704467e-10,   1.002190998870263e-11,  -3.313079462434063e-13,   4.641605567596959e-15,   2.030727218545621e-16,  -1.368266970683331e-03,
   5.840420202846016e-05,  -1.734139761757207e-06,   3.312023817090435e-08,   3.054318338171432e-10,  -6.861606011520724e-11,   3.801053192535931e-12,  -1.255943077851845e-13,
   1.755938456821007e-15,   7.719969394546512e-17,  -1.560012070308587e-04,   6.658886827817519e-06,  -1.977146278088077e-07,   3.775966453410046e-09,   3.483852516414242e-11,
  -7.823850276009670e-12,   4.333838835009309e-13,  -1.431868247114592e-14,   2.001213576811855e-16,   8.805451478672187e-18,  -2.306031282575737e-04,   9.187119789642395e-06,
  -2.701716172274564e-07,   6.647158247334424e-09,  -1.254768647895885e-10,   8.274037995092742e-13,   6.528690284248907e-14,  -3.550066085329984e-15,   8.396892881223556e-17,
   4.594960063886262e-19,  -2.132316885841177e-04,   8.495451121908832e-06,  -2.498384384966036e-07,   6.146434509143212e-09,  -1.159748137926909e-10,   7.617666377581540e-13,
   6.046703356822507e-14,  -3.281619694663960e-15,   7.737779442577590e-17,   4.391395813888200e-19,  -1.811262679746134e-04,   7.216885391643413e-06,  -2.122477281423699e-07,
   5.221002913299523e-09,  -9.844341764379901e-11,   6.424586544120779e-13,   5.149932340656394e-14,  -2.786072968145385e-15,   6.535597064918261e-17,   3.928930616627344e-19,
  -1.391665181731957e-04,   5.545476220691631e-06,  -1.630999080767357e-07,   4.011512076674057e-09,  -7.558122500697686e-11,   4.898683762849338e-13,   3.967988843462949e-14,
  -2.139443349562470e-15,   4.991196661541816e-17,   3.180673909093964e-19,  -9.373772477940132e-05,   3.735481538909479e-06,  -1.098698285614748e-07,   2.702018211053258e-09,
  -5.087875485507298e-11,   3.279669635096837e-13,   2.678557704016896e-14,  -1.440400982885872e-15,   3.345759352430167e-17,   2.228176287193799e-19,  -5.175944064039584e-05,
   2.062709054765723e-06,  -6.067078498781047e-08,   1.491982335420450e-09,  -2.808426579115909e-11,   1.804601193292586e-13,   1.480889545367128e-14,  -7.951392323907551e-16,
   1.842286347841495e-17,   1.257664842629422e-19,  -1.962781047018792e-05,   7.822153685219268e-07,  -2.300761787350467e-08,   5.657779830297461e-10,  -1.064852689470953e-11,
   6.834235502264478e-14,   5.618362143655803e-15,  -3.014961799385135e-16,   6.978831859614571e-18,   4.808122035284132e-20,  -2.237839218288326e-06,   8.918347255171125e-08,
  -2.623193323669765e-09,   6.450644091892655e-11,  -1.214052035798607e-12,   7.790257573472804e-15,   6.406202706123292e-16,  -3.437411981292867e-17,   7.955436079417039e-19,
   5.489269733756656e-21,  -2.125154379951628e-03,   8.464858327524838e-05,  -2.486462474183106e-06,   6.085163335424495e-08,  -1.120777460392947e-09,   5.239511701212419e-12,
   7.271622049718243e-13,  -3.787461652160819e-14,   9.309501470569629e-16,   1.452954195073248e-18,  -1.965065362811013e-03,   7.827561008145041e-05,  -2.299321570412432e-06,
   5.626670146012210e-08,  -1.035808164974991e-09,   4.809678595302080e-12,   6.734760135705190e-13,  -3.501615579274951e-14,   8.582964775460823e-16,   1.486767417149505e-18,
  -1.669193307906495e-03,   6.649505232381388e-05,  -1.953352675948834e-06,   4.779351123860404e-08,  -8.790961266173977e-10,   4.036517035496768e-12,   5.735913541417394e-13,
  -2.973618892375510e-14,   7.255365168188213e-16,   1.462650341465017e-18,  -1.282507447250461e-03,   5.109493458607304e-05,  -1.501026301039362e-06,   3.672054135406296e-08,
  -6.748284799849011e-10,   3.061490773308293e-12,   4.419464431506982e-13,  -2.284091528240970e-14,   5.545714553926453e-16,   1.286608073540602e-18,  -8.638522980797912e-04,
   3.441796444612994e-05,  -1.011138499115365e-06,   2.473307864942228e-08,  -4.542140248792322e-10,   2.040955164796160e-12,   2.983315709769993e-13,  -1.538121965110234e-14,
   3.720050126957361e-16,   9.528887906280280e-19,  -4.769958832465437e-04,   1.900536976273347e-05,  -5.583550322931193e-07,   1.365674479544856e-08,  -2.507004412305407e-10,
   1.120219140088951e-12,   1.649379128084420e-13,  -8.491908265959452e-15,   2.049209501498936e-16,   5.536470567764291e-19,  -1.808826456737286e-04,   7.207167296662070e-06,
  -2.117395364916317e-07,   5.178776312264589e-09,  -9.505380621690234e-11,   4.238409130003494e-13,   6.257594971413971e-14,  -3.220064021941743e-15,   7.763864908458210e-17,
   2.138634854029852e-19,  -2.062309891181359e-05,   8.217176632283831e-07,  -2.414129231664367e-08,   5.904509044227273e-10,  -1.083715498169959e-11,   4.830552939837533e-14,
   7.135072349240649e-15,  -3.671281550601127e-16,   8.850548376223375e-18,   2.445733202944164e-20,  -6.231718283186190e-03,   2.480945994941164e-04,  -7.265641643041687e-06,
   1.752935632617719e-07,  -3.006971564128417e-09,  -3.729323599304664e-12,   3.160909059548358e-12,  -1.547701837625073e-13,   4.135985535673528e-15,  -2.437718663878930e-17,
  -5.762278376565254e-03,   2.294157794884522e-04,  -6.718728762946190e-06,   1.620774934383806e-07,  -2.778200730836931e-09,  -3.590915758622239e-12,   2.927668852599706e-12,
  -1.431378447069893e-13,   3.816743250932468e-15,  -2.202717203295480e-17,  -4.894673379359241e-03,   1.948878900380708e-04,  -5.707690003871818e-06,   1.376585624579189e-07,
  -2.356751395209168e-09,  -3.248999097566704e-12,   2.493644293556597e-12,  -1.216222422570770e-13,   3.231327678352967e-15,  -1.799395314443874e-17,  -3.760770355609338e-03,
   1.497517763903240e-04,  -4.385911358137477e-06,   1.057557652718901e-07,  -1.808216541229131e-09,  -2.658377329452205e-12,   1.921483008566839e-12,  -9.347559974380623e-14,
   2.473957261165447e-15,  -1.324080408895650e-17,  -2.533123032655034e-03,   1.008737632649740e-04,  -2.954443930931635e-06,   7.122658894416417e-08,  -1.216587983886095e-09,
  -1.876491106392518e-12,   1.297162390094541e-12,  -6.297646517438347e-14,   1.661686549271161e-15,  -8.608432430891930e-18,  -1.398721812231303e-03,   5.570173628640520e-05,
  -1.631442670447968e-06,   3.932721915373248e-08,  -6.713320533826274e-10,  -1.063522095032569e-12,   7.171866404286949e-13,  -3.477843130777014e-14,   9.160410809370480e-16,
  -4.654481125360270e-18,  -5.304123045813798e-04,   2.112305719295883e-05,  -6.186741085645854e-07,   1.491304958435431e-08,  -2.545153247633650e-10,  -4.071986179531009e-13,
   2.720980423155721e-13,  -1.318904169034014e-14,   3.471604012520848e-16,  -1.750955303591047e-18,  -6.047426641836892e-05,   2.408323118869790e-06,  -7.053753291572470e-08,
   1.700286021394059e-09,  -2.901706155470356e-11,  -4.649989108038686e-14,   3.102540010848905e-14,  -1.503743379659418e-15,   3.957700288182734e-17,  -1.993667535156747e-19,
  -1.362710555522960e-02,   5.417836975731912e-04,  -1.573506818426126e-05,   3.639039125963728e-07,  -4.782051805948713e-09,  -1.366906723326746e-10,   1.428351485751198e-11,
  -6.799845376694155e-13,   2.162441609911004e-14,  -3.944402048801419e-16,  -1.260055828134444e-02,   5.009906910642933e-04,  -1.455016136286815e-05,   3.364101732062475e-07,
  -4.412070690978914e-09,  -1.270158783431332e-10,   1.323330446283361e-11,  -6.293368981167808e-13,   1.998652059450395e-14,  -3.631719187807065e-16,  -1.070332832956140e-02,
   4.255861822015196e-04,  -1.235999002772447e-05,   2.856454346366814e-07,  -3.734152496393550e-09,  -1.087597689314435e-10,   1.127674303850373e-11,  -5.353802613666588e-13,
   1.696460186521967e-14,  -3.063149385018306e-16,  -8.223780266163576e-03,   3.270172822869143e-04,  -9.497147103998146e-06,   2.193804268965748e-07,  -2.857981811408642e-09,
  -8.427278881781143e-11,   8.693638656465917e-12,  -4.120030021829255e-13,   1.302407889009859e-14,  -2.335725251649846e-16,  -5.539245491770056e-03,   2.202793740587322e-04,
  -6.397198012333204e-06,   1.477179193958042e-07,  -1.919134879414553e-09,  -5.713897445948340e-11,   5.871238528871308e-12,  -2.778533824901837e-13,   8.766901650295682e-15,
  -1.563782566324658e-16,  -3.058619633869186e-03,   1.216361160186658e-04,  -3.532439362453862e-06,   8.155016297447128e-08,  -1.057811478051562e-09,  -3.167040055292987e-11,
   3.246878648334036e-12,  -1.535319312657855e-13,   4.839019293697147e-15,  -8.604490409444289e-17,  -1.159865519623545e-03,   4.612643709029329e-05,  -1.339555314448695e-06,
   3.092257943123672e-08,  -4.008667146329560e-10,  -1.202686549571699e-11,   1.231959133815533e-12,  -5.823664617515519e-14,   1.834753326121947e-15,  -3.258607776732650e-17,
  -1.322405490553849e-04,   5.259055786236437e-06,  -1.527278654399846e-07,   3.525555301928549e-09,  -4.569922444296578e-11,  -1.371549908442611e-12,   1.404735033684067e-13,
  -6.640067453875971e-15,   2.091820519281823e-16,  -3.714442393537945e-18,  -1.977182175615377e-04,   7.312345744830380e-06,  -2.017089508622760e-07,   4.828643372187283e-09,
  -9.977336451997681e-11,   1.495060028756632e-12,   1.235846811451626e-15,  -1.203606027986309e-15,   5.310022265557570e-17,  -1.291802974714723e-18,  -1.828226974584067e-04,
   6.761762699098799e-06,  -1.865299690248360e-07,   4.465302550523482e-09,  -9.225117611763011e-11,   1.381241057815350e-12,   1.207966701576720e-15,  -1.114896145065668e-15,
   4.910949385758916e-17,  -1.191920322522409e-18,  -1.552939991179535e-04,   5.744033441523433e-06,  -1.584670088251010e-07,   3.793541674921332e-09,  -7.835257744933711e-11,
   1.171604301895533e-12,   1.117034764379305e-15,  -9.497564251578098e-16,   4.172790725430357e-17,  -1.008857348985387e-18,  -1.193170625758888e-04,   4.413664237069530e-06,
  -1.217745133238609e-07,   2.915185961756578e-09,  -6.019424248429053e-11,   8.988274956284867e-13,   9.324108286321104e-16,  -7.319522958898978e-16,   3.207109972591883e-17,
  -7.721934085145032e-19,  -8.036702934245267e-05,   2.973046943708059e-06,  -8.203261746772806e-08,   1.963809710693465e-09,  -4.054092597441587e-11,   6.046955588955208e-13,
   6.673467370546221e-16,  -4.941899700612903e-16,   2.160702000742351e-17,  -5.185498011626593e-19,  -4.437625103455988e-05,   1.641686046896088e-06,  -4.529923660640992e-08,
   1.084439695040895e-09,  -2.238438116797748e-11,   3.336658228000956e-13,   3.810170996171460e-16,  -2.732513634760692e-16,   1.193237608386960e-17,  -2.858262115392677e-19,
  -1.682797905437240e-05,   6.225544406669503e-07,  -1.717845526948097e-08,   4.112437024305222e-10,  -8.488255407688347e-12,   1.264972726059389e-13,   1.462700524710659e-16,
  -1.036733186333811e-16,   4.525121798432855e-18,  -1.083170297664685e-19,  -1.918619410302749e-06,   7.097986683060948e-08,  -1.958587359550629e-09,   4.688762159068520e-11,
  -9.677740695570980e-13,   1.442180023364829e-14,   1.671050075606740e-17,  -1.182118102979196e-17,   5.159299894462482e-19,  -1.234826808233726e-20,  -1.822132737042653e-03,
   6.738548522305853e-05,  -1.858151021426867e-06,   4.440388279868415e-08,  -9.106559351810514e-10,   1.314568906448034e-11,   4.774756946972327e-14,  -1.279474684348383e-14,
   5.540620646823027e-16,  -1.383145252315541e-17,  -1.684858476570634e-03,   6.231168251109351e-05,  -1.718319339946551e-06,   4.106235542104273e-08,  -8.419747537389954e-10,
   1.214285147046594e-11,   4.482977816274659e-14,  -1.185191646700715e-14,   5.124838705113885e-16,  -1.276605892209783e-17,  -1.431159287102748e-03,   5.293298250732435e-05,
  -1.459799363248591e-06,   3.488455127067455e-08,  -7.150885179420211e-10,   1.029700672809350e-11,   3.902699592480406e-14,  -1.009666330557518e-14,   4.355399532434059e-16,
  -1.081104315287317e-17,  -1.099602796278363e-03,   4.067321854103533e-05,  -1.121785186603434e-06,   2.680708312517489e-08,  -5.493378350921617e-10,   7.897273619373387e-12,
   3.075822061557688e-14,  -7.781457154199899e-15,   3.348169606026016e-16,  -8.279576799935065e-18,  -7.406468581626286e-04,   2.739749720735453e-05,  -7.556819857536501e-07,
   1.805837922479938e-08,  -3.699652198014846e-10,   5.311723593648922e-12,   2.112708318956327e-14,  -5.253904651959379e-15,   2.256114942845325e-16,  -5.562451319471575e-18,
  -4.089628620106932e-04,   1.512861462485370e-05,  -4.172947514670068e-07,   9.972005275177723e-09,  -2.042689290280477e-10,   2.930564433456267e-12,   1.179628611917699e-14,
  -2.905069534914885e-15,   1.246049634684864e-16,  -3.066833548933706e-18,  -1.550833671223534e-04,   5.737019968137439e-06,  -1.582471780586849e-07,   3.781599221370478e-09,
  -7.745900150399767e-11,   1.110960120102287e-12,   4.491876565358793e-15,  -1.102207704639019e-15,   4.725573160253244e-17,  -1.162324037208435e-18,  -1.768162160711210e-05,
   6.541000795437547e-07,  -1.804241983676746e-08,   4.311558680273530e-10,  -8.831344226464832e-12,   1.266581365686116e-13,   5.124866277934497e-16,  -1.256775435353129e-16,
   5.387876249261424e-18,  -1.325084422012772e-19,  -5.343403944634446e-03,   1.975804913367024e-04,  -5.443313010687955e-06,   1.294854587826082e-07,  -2.602605091324545e-09,
   3.362254197343834e-11,   4.280994045068247e-13,  -5.130809168887804e-14,   2.164748259968453e-15,  -5.741296211900029e-17,  -4.940846921211472e-03,   1.827035335076893e-04,
  -5.033669061255737e-06,   1.197391767425594e-07,  -2.406123348792824e-09,   3.104031551753863e-11,   3.984944070669279e-13,  -4.753058047063095e-14,   2.002862219908466e-15,
  -5.302619862530929e-17,  -4.196873744381773e-03,   1.552041934372864e-04,  -4.276332367407888e-06,   1.017215525615187e-07,  -2.043246719407458e-09,   2.629769130169228e-11,
   3.421829640850927e-13,  -4.049605180481219e-14,   1.702939775535734e-15,  -4.495544415584606e-17,  -3.224584217886880e-03,   1.192573677522349e-04,  -3.286134420876430e-06,
   7.816566507148282e-08,  -1.569419312918590e-09,   2.014920702528573e-11,   2.659210357103377e-13,  -3.121401552120189e-14,   1.309760310284558e-15,  -3.446963795298628e-17,
  -2.171946081147745e-03,   8.033175391926529e-05,  -2.213668552395838e-06,   5.265440215185562e-08,  -1.056846290748925e-09,   1.354188557219601e-11,   1.807104855648314e-13,
  -2.107723907143892e-14,   8.829042610925771e-16,  -2.317937839477615e-17,  -1.199283080398055e-03,   4.435834478387192e-05,  -1.222405332279648e-06,   2.907584322977020e-08,
  -5.834789169898475e-10,   7.467919208006638e-12,   1.002919778684953e-13,  -1.165501779842171e-14,   4.877360136387528e-16,  -1.278679415993977e-17,  -4.547817720740817e-04,
   1.682141261266695e-05,  -4.635620040235048e-07,   1.102612793102511e-08,  -2.212504684658811e-10,   2.830566130108982e-12,   3.810436334617604e-14,  -4.422106750900985e-15,
   1.849866792120139e-16,  -4.847161268209053e-18,  -5.185133218539513e-05,   1.917874976164990e-06,  -5.285262551983961e-08,   1.257133641401015e-09,  -2.522535970808335e-11,
   3.226976025960643e-13,   4.345788125525974e-15,  -5.042257472812512e-16,   2.109160483653102e-17,  -5.526097275597705e-19,  -1.168606603799952e-02,   4.319560466732897e-04,
  -1.187185200434410e-05,   2.789101794254769e-07,  -5.281902147145999e-09,   4.270767259336186e-11,   2.819079531332923e-12,  -2.075292255103389e-13,   8.763436120019499e-15,
  -2.665224343234392e-16,  -1.080566909425593e-02,   3.994310456405734e-04,  -1.097831268453257e-05,   2.579034857425118e-07,  -4.881844709827588e-09,   3.929511368833384e-11,
   2.617395457552718e-12,  -1.923064463418716e-13,   8.113420961290672e-15,  -2.464811679388695e-16,  -9.178591968282442e-03,   3.393104936861715e-04,  -9.326429906664558e-06,
   2.190771238130749e-07,  -4.143772151733462e-09,   3.310574488600841e-11,   2.238209159507624e-12,  -1.639240769354024e-13,   6.905925037062074e-15,  -2.094176053677947e-16,
  -7.052186205937014e-03,   2.607221699553435e-04,  -7.166744089842548e-06,   1.683297250559521e-07,  -3.181343609313305e-09,   2.521356034899211e-11,   1.731869850500943e-12,
  -1.264160641369470e-13,   5.317568422749976e-15,  -1.609408993235541e-16,  -4.750058929303270e-03,   1.756220837819639e-04,  -4.827733890296435e-06,   1.133831418461317e-07,
  -2.141522826689588e-09,   1.686460164974614e-11,   1.172982485509999e-12,  -8.539684252729147e-14,   3.587794990938937e-15,  -1.084227450605379e-16,  -2.622838881511367e-03,
   9.697654513308249e-05,  -2.665892199970748e-06,   6.260776540266453e-08,  -1.182069663793506e-09,   9.274407234844475e-12,   6.497478198421221e-13,  -4.723266220675704e-14,
   1.983013189683394e-15,  -5.987378792145441e-17,  -9.946102640744697e-04,   3.677508212218879e-05,  -1.010959853853684e-06,   2.374171992958581e-08,  -4.481951424536409e-10,
   3.511586355111654e-12,   2.466855303003385e-13,  -1.792242630586067e-14,   7.522573002821140e-16,  -2.270566098586316e-17,  -1.133991509413545e-04,   4.192870498001561e-06,
  -1.152636674124771e-07,   2.706882985149947e-09,  -5.109924899077468e-11,   4.002672050800801e-13,   2.813107180836528e-14,  -2.043614218624982e-15,   8.577282242229045e-17,
  -2.588771181882406e-18,  -1.713645593766662e-04,   5.905548949650005e-06,  -1.523756449237871e-07,   3.464567736063047e-09,  -7.148348512855650e-11,   1.272717606788481e-12,
  -1.496522641287728e-14,  -1.442146486494051e-16,   1.704004118293779e-17,  -6.610892301692909e-19,  -1.584534574990060e-04,   5.460833471474403e-06,  -1.409080911359345e-07,
   3.203959278227387e-09,  -6.610467644493171e-11,   1.176639682542746e-12,  -1.381600371007422e-14,  -1.343906531162982e-16,   1.578751698793930e-17,  -6.116961760042511e-19,
  -1.345927991767484e-04,   4.638830485509742e-06,  -1.197074400609147e-07,   2.722080635596770e-09,  -5.616001963877795e-11,   9.991929418173167e-13,  -1.170522357219814e-14,
  -1.156065303961605e-16,   1.345379244784929e-17,  -5.201591204294606e-19,  -1.034105804684606e-04,   3.564371128553569e-06,  -9.198846400636726e-08,   2.091913426130881e-09,
  -4.315684976967178e-11,   7.674862245916793e-13,  -8.968629220363211e-15,  -9.000828444633704e-17,   1.037236795597555e-17,  -4.001140129907833e-19,  -6.965248523552623e-05,
   2.400928148206157e-06,  -6.196684171332158e-08,   1.409268256008494e-09,  -2.907258602519123e-11,   5.168276855338717e-13,  -6.027703893937617e-15,  -6.125395546979488e-17,
   7.005146895408772e-18,  -2.697419765026930e-19,  -3.845981255354592e-05,   1.325756941565946e-06,  -3.421852410956315e-08,   7.782325652494102e-10,  -1.605425282765518e-11,
   2.853385454097780e-13,  -3.324107331062608e-15,  -3.402281361576311e-17,   3.874000774862417e-18,  -1.490199568682065e-19,  -1.458437121403981e-05,   5.027473482927733e-07,
  -1.297638128971109e-08,   2.951256186747111e-10,  -6.088132693561618e-12,   1.081981835776505e-13,  -1.259939596171263e-15,  -1.293035445124074e-17,   1.469914873037015e-18,
  -5.652093168625156e-20,  -1.662816966550455e-06,   5.732016209655270e-08,  -1.479490864065662e-09,   3.364855818005277e-11,  -6.941336176177478e-13,   1.233596762528408e-14,
  -1.436389831653287e-16,  -1.474775956909293e-18,   1.676064253095083e-19,  -6.444363266262690e-21,  -1.579269941472881e-03,   5.442387333553433e-05,  -1.404107686348656e-06,
   3.190769688985758e-08,  -6.567525138730047e-10,   1.157723556650774e-11,  -1.286664542387637e-13,  -1.796559044397020e-15,   1.768382255829869e-16,  -6.793090700303436e-18,
  -1.460283165287175e-03,   5.032549806422094e-05,  -1.298436199165932e-06,   2.950750152465386e-08,  -6.073289554031711e-10,   1.070281335990477e-11,  -1.187481863670289e-13,
  -1.671895986016319e-15,   1.638427620509827e-16,  -6.286149030478167e-18,  -1.240386925869170e-03,   4.275014683350247e-05,  -1.103076253812999e-06,   2.506945386237120e-08,
  -5.159553364565623e-10,   9.088110654575914e-12,  -1.005534888937503e-13,  -1.435055471930101e-15,   1.396276191407793e-16,  -5.346302101224307e-18,  -9.530162948307245e-04,
   3.284823068824090e-05,  -8.476517235371725e-07,   1.926575044650450e-08,  -3.964854041863956e-10,   6.980116574895927e-12,  -7.700175229574563e-14,  -1.114757132403671e-15,
   1.076511677151501e-16,  -4.113142397018215e-18,  -6.419067817117805e-04,   2.212626929758081e-05,  -5.710093236018586e-07,   1.297880119413988e-08,  -2.670885702354018e-10,
   4.700158127507746e-12,  -5.172897772746121e-14,  -7.573043614006674e-16,   7.270586392130675e-17,  -2.773293632967639e-18,  -3.544398209214491e-04,   1.221779743724203e-05,
  -3.153152461260006e-07,   7.167200464227997e-09,  -1.474885708045086e-10,   2.594851209025485e-12,  -2.851972507266331e-14,  -4.202169356091088e-16,   4.020856011237386e-17,
  -1.532233273351523e-18,  -1.344073610777004e-04,   4.633175935801975e-06,  -1.195741331945054e-07,   2.717983256638376e-09,  -5.593081041890221e-11,   9.839351329391908e-13,
  -1.080881225893791e-14,  -1.596439123967008e-16,   1.525645044521133e-17,  -5.811687044983424e-19,  -1.532426987001316e-05,   5.282462370212051e-07,  -1.363314086579954e-08,
   3.098890845049977e-10,  -6.376903880761315e-12,   1.121808700181387e-13,  -1.232235155996332e-15,  -1.820712152072008e-17,   1.739612009878976e-18,  -6.626359374260312e-20,
  -4.631263912826314e-03,   1.595941821556871e-04,  -4.116383192455641e-06,   9.341164296941334e-08,  -1.910643672869073e-09,   3.279190667742588e-11,  -3.058665504132252e-13,
  -8.935837612826947e-15,   6.769960043039738e-16,  -2.567654759389314e-17,  -4.282331002914560e-03,   1.475759633645681e-04,  -3.806585055421310e-06,   8.638443744754363e-08,
  -1.766813386553777e-09,   3.031155945225952e-11,  -2.819705564349192e-13,  -8.302968688072862e-15,   6.272886323793504e-16,  -2.376590752062557e-17,  -3.637477575276902e-03,
   1.253617517163984e-04,  -3.233848787293328e-06,   7.339117838183538e-08,  -1.500929427091024e-09,   2.573352001382679e-11,  -2.383214553656122e-13,  -7.109021251140723e-15,
   5.346398886298418e-16,  -2.022033939570592e-17,  -2.794753189470576e-03,   9.632506542939396e-05,  -2.485025353423139e-06,   5.640019084552296e-08,  -1.153335477680898e-09,
   1.976050431566977e-11,  -1.821366181840844e-13,  -5.507998706578945e-15,   4.122513405528460e-16,  -1.556267608567795e-17,  -1.882413764497826e-03,   6.488367454009423e-05,
  -1.674001889506555e-06,   3.799494278735701e-08,  -7.769054962003662e-10,   1.330382608413064e-11,  -1.221630153003274e-13,  -3.734323163297506e-15,   2.784549905478870e-16,
  -1.049650658466781e-17,  -1.039406981212343e-03,   3.582779770300959e-05,  -9.243944941384921e-07,   2.098160875521670e-08,  -4.290049110936797e-10,   7.344045000683217e-12,
  -6.728988851811636e-14,  -2.069748907563041e-15,   1.540027851225048e-16,  -5.800344261563417e-18,  -3.941542135011459e-04,   1.358644909163243e-05,  -3.505496066480114e-07,
   7.956741793104829e-09,  -1.626865421395688e-10,   2.784670669273672e-12,  -2.549360281329393e-14,  -7.859788127188646e-16,   5.843496297790717e-17,  -2.200194833023942e-18,
  -4.493894891985894e-05,   1.549043389361728e-06,  -3.996760662390123e-08,   9.071824569144496e-10,  -1.854854408930382e-11,   3.174852889263380e-13,  -2.906174855167208e-15,
  -8.963323160498233e-17,   6.663051908544766e-18,  -2.508643141389935e-19,  -1.012891650431157e-02,   3.490131961569767e-04,  -8.996142893809312e-06,   2.034039304883608e-07,
  -4.090540285308524e-09,   6.486158346198701e-11,  -2.323723227129590e-13,  -4.284855925964921e-14,   2.538639381341442e-15,  -9.721765163323948e-17,  -9.365774109652827e-03,
   3.227306823461115e-04,  -8.319071954524685e-06,   1.880992467450670e-07,  -3.782327559721826e-09,   5.993197582643716e-11,  -2.117052290043613e-13,  -3.977316521288666e-14,
   2.352877064030075e-15,  -9.003465597007338e-17,  -7.955431587798420e-03,   2.741507338691504e-04,  -7.067357582188433e-06,   1.598027488124533e-07,  -3.212737265403703e-09,
   5.084736513727583e-11,  -1.754121598424346e-13,  -3.399745488246022e-14,   2.006251353827948e-15,  -7.667417515438196e-17,  -6.112330859760018e-03,   2.106509332457744e-04,
  -5.430828232503374e-06,   1.228030285020709e-07,  -2.468389098693335e-09,   3.901823482899982e-11,  -1.311667785271965e-13,  -2.629531594852974e-14,   1.547712489525494e-15,
  -5.907113745380094e-17,  -4.116977208445894e-03,   1.418924495814026e-04,  -3.658385932105172e-06,   8.272655165214522e-08,  -1.662574797556034e-09,   2.625483357340188e-11,
  -8.643218816895427e-14,  -1.780382114873975e-14,   1.045789256553083e-15,  -3.987261726935890e-17,  -2.273259371730685e-03,   7.835087156788627e-05,  -2.020179499220239e-06,
   4.568277623580540e-08,  -9.180138992679095e-10,   1.448874966434577e-11,  -4.711371328205120e-14,  -9.860201450716821e-15,   5.785098146709623e-16,  -2.204344153842467e-17,
  -8.620441910356760e-04,   2.971184599031261e-05,  -7.660934176896553e-07,   1.732395038471715e-08,  -3.481198963923316e-10,   5.493104307243610e-12,  -1.777891255341952e-14,
  -3.743298691068614e-15,   2.195279714563427e-16,  -8.362964628186639e-18,  -9.828477908580407e-05,   3.387561933511282e-06,  -8.734545848562032e-08,   1.975176781190592e-09,
  -3.969039516498306e-11,   6.262663230762581e-13,  -2.025391485426469e-15,  -4.268665229438377e-16,   2.503203051941510e-17,  -9.535647512958269e-19,  -1.499421295422596e-04,
   4.835204111782547e-06,  -1.168880812836920e-07,   2.504446652140621e-09,  -4.970784055853589e-11,   9.087602745436895e-13,  -1.415780767024861e-14,   1.274741959701132e-16,
   2.677412705030401e-18,  -1.991098203450935e-19,  -1.386443295258284e-04,   4.471046788642896e-06,  -1.080899214086898e-07,   2.316055255908819e-09,  -4.597006259235419e-11,
   8.403719428660332e-13,  -1.308719333546304e-14,   1.175473423217451e-16,   2.489551514363286e-18,  -1.845175558419636e-19,  -1.177656093490401e-04,   3.797972335723076e-06,
  -9.182512918297929e-08,   1.967712425365158e-09,  -3.905792835521470e-11,   7.139364299579274e-13,  -1.111097087165331e-14,   9.939595929215015e-17,   2.134009626635104e-18,
  -1.573025390967507e-19,  -9.048105839008509e-05,   2.918225164133157e-06,  -7.056094249264178e-08,   1.512178360133559e-09,  -3.001741065516064e-11,   5.486235124871820e-13,
  -8.532302721513680e-15,   7.599999565441087e-17,   1.655394106309886e-18,  -1.213238736570738e-19,  -6.094333193621947e-05,   1.965663665945866e-06,  -4.753165943294580e-08,
   1.018713260597994e-09,  -2.022273659526965e-11,   3.695747341264241e-13,  -5.744561600851912e-15,   5.099451593009300e-17,   1.123372118053701e-18,  -8.196438102665689e-20,
  -3.365076495572456e-05,   1.085401930715597e-06,  -2.624705767314760e-08,   5.625577479259850e-10,  -1.116774022827373e-11,   2.040822202702933e-13,  -3.171192686833917e-15,
   2.809511514291121e-17,   6.229602643844646e-19,  -4.533651808175195e-20,  -1.276070920287989e-05,   4.115998467870402e-07,  -9.953397518573430e-09,   2.133361264599250e-10,
  -4.235126964759246e-12,   7.739231677943101e-14,  -1.202440947343140e-15,   1.064507867227469e-17,   2.366136594609800e-19,  -1.720326533126553e-20,  -1.454894282556217e-06,
   4.692806164461027e-08,  -1.134827296723987e-09,   2.432337967179900e-11,  -4.828659525285094e-13,   8.823819080428876e-15,  -1.370925821392917e-16,   1.213515934209885e-18,
   2.698437160318444e-20,  -1.961617739784628e-21,  -1.381845609641944e-03,   4.456040500606096e-05,  -1.077190575140942e-06,   2.307616174539134e-08,  -4.576616526442017e-10,
   8.341015383826784e-12,  -1.283208180716778e-13,   1.060193946569179e-15,   2.985681049899026e-17,  -2.035568501964661e-18,  -1.277726669581153e-03,   4.120439347844705e-05,
  -9.961103805905163e-07,   2.134029457502454e-08,  -4.232464521563489e-10,   7.713213404533863e-12,  -1.186102349668399e-13,   9.770273101764300e-16,   2.774810632974934e-17,
  -1.886417425809489e-18,  -1.085311314352821e-03,   3.500145494944784e-05,  -8.462208665088718e-07,   1.813061913722804e-08,  -3.596045167060717e-10,   6.552602569135324e-12,
  -1.006898572632035e-13,   8.253086647982056e-16,   2.376616603828445e-17,  -1.608227819463430e-18,  -8.338607232291342e-04,   2.689385676106927e-05,  -6.502591427990692e-07,
   1.393328459360197e-08,  -2.763673378874118e-10,   5.035221411456381e-12,  -7.731349424757488e-14,   6.303499956726187e-16,   1.842043291897101e-17,  -1.240425635597565e-18,
  -5.616451847246246e-04,   1.811521490707334e-05,  -4.380311554732866e-07,   9.386464451250102e-09,  -1.861879132906319e-10,   3.391864051478540e-12,  -5.204879188645917e-14,
   4.225809015224579e-16,   1.249222915440371e-17,  -8.380302505507465e-19,  -3.101207216556220e-04,   1.000287553991522e-05,  -2.418814759091378e-07,   5.183426616212366e-09,
  -1.028195615220201e-10,   1.872995412291755e-12,  -2.873134646130254e-14,   2.326992928287967e-16,   6.924933955936887e-18,  -4.635414300083295e-19,  -1.176009029959503e-04,
   3.793232631074622e-06,  -9.172618235181099e-08,   1.965686072214261e-09,  -3.899208508680359e-11,   7.102768404435821e-13,  -1.089405163241889e-14,   8.815142986691708e-17,
   2.629874224236626e-18,  -1.758949990718909e-19,  -1.340810127877714e-05,   4.324808573234648e-07,  -1.045807471893280e-08,   2.241164111389497e-10,  -4.445663010800810e-12,
   8.098155530364038e-14,  -1.242047931139724e-15,   1.004875056660624e-17,   2.999145436853356e-19,  -2.005660178048985e-20,  -4.052321607467264e-03,   1.306741563995564e-04,
  -3.158661546821956e-06,   6.763887503744616e-08,  -1.338850221403306e-09,   2.420552417976894e-11,  -3.599837940459954e-13,   2.231165821679477e-15,   1.278214596479410e-16,
  -7.555683935562987e-18,  -3.746988331209720e-03,   1.208325902199762e-04,  -2.920908058440330e-06,   6.255074028569803e-08,  -1.238161148013526e-09,   2.238285914760432e-11,
  -3.326874413120175e-13,   2.050920185660317e-15,   1.187095630736838e-16,  -7.002489422159407e-18,  -3.182722021699912e-03,   1.026423603855340e-04,  -2.481383791801447e-06,
   5.314267754790673e-08,  -1.051969190205329e-09,   1.901379356482839e-11,  -2.823462547941112e-13,   1.725121014256833e-15,   1.015575361204307e-16,  -5.970437105709584e-18,
  -2.445332354621591e-03,   7.886668603932578e-05,  -1.906761852356417e-06,   4.083974090506427e-08,  -8.084594687696690e-10,   1.460987925556091e-11,  -2.167334342751481e-13,
   1.311589440695524e-15,   7.861971336448558e-17,  -4.605493470573695e-18,  -1.647048598912615e-03,   5.312316883318762e-05,  -1.284442929079193e-06,   2.751252579706924e-08,
  -5.446506343176909e-10,   9.841136782255745e-12,  -1.458753581405682e-13,   8.760636334031708e-16,   5.326809805792852e-17,  -3.111732439858670e-18,  -9.094423181526868e-04,
   2.933359792177174e-05,  -7.092711888562474e-07,   1.519304317211738e-08,  -3.007733696549043e-10,   5.434145626118560e-12,  -8.051369776466527e-14,   4.813845315591825e-16,
   2.951289868894985e-17,  -1.721284326829513e-18,  -3.448696919138115e-04,   1.112371728889103e-05,  -2.689694711606854e-07,   5.761582041416092e-09,  -1.140614807295141e-10,
   2.060713424780643e-12,  -3.052682273801642e-14,   1.822114229322465e-16,   1.120585248575873e-17,  -6.531691171837548e-19,  -3.931983206433784e-05,   1.268257248820004e-06,
  -3.066630173834128e-08,   6.569029488656528e-10,  -1.300465707405240e-11,   2.349499163821619e-13,  -3.480382258662180e-15,   2.076825650179767e-17,   1.277889098496085e-18,
  -7.447848680945833e-20,  -8.862788387261945e-03,   2.857899581162378e-04,  -6.906954247387992e-06,   1.477526485400012e-07,  -2.910083353644709e-09,   5.149550103533924e-11,
  -6.925374553918850e-13,  -3.678389218448990e-16,   5.288434351405785e-16,  -2.678454200636005e-17,  -8.194997244012269e-03,   2.642660083046599e-04,  -6.387060767641209e-06,
   1.366373342169525e-07,  -2.691168333343123e-09,   4.761312005706443e-11,  -6.396721031593420e-13,  -3.828925465744823e-16,   4.908589568845077e-16,  -2.482931542519569e-17,
  -6.960896471867293e-03,   2.244831686312943e-04,  -5.425959753576670e-06,   1.160852691092103e-07,  -2.286391931197736e-09,   4.043969666235337e-11,  -5.423858401827004e-13,
  -3.849865042524813e-16,   4.195405964889575e-16,  -2.117804095307112e-17,  -5.348159533383585e-03,   1.724847386618863e-04,  -4.169447528478563e-06,   8.920993084969238e-08,
  -1.757069109538910e-09,   3.106770071045051e-11,  -4.159402353569232e-13,  -3.446253314468805e-16,   3.244635387136772e-16,  -1.634307102752588e-17,  -3.602241859906382e-03,
   1.161825756634744e-04,  -2.808642227965848e-06,   6.009771493733571e-08,  -1.183682249016791e-09,   2.092412239898902e-11,  -2.797393621646082e-13,  -2.580668081169146e-16,
   2.196696729937312e-16,  -1.104586891825195e-17,  -1.989031270180505e-03,   6.415379168951723e-05,  -1.550935253925328e-06,   3.318720598105153e-08,  -6.536551880166831e-10,
   1.155309277504887e-11,  -1.543292649997904e-13,  -1.507762080768544e-16,   1.216537094793185e-16,  -6.111266197477442e-18,  -7.542607002322020e-04,   2.432802903227146e-05,
  -5.881447714079395e-07,   1.258540153603485e-08,  -2.478822378117321e-10,   4.380981635415750e-12,  -5.850425567818217e-14,  -5.835594975712218e-17,   4.618358238281674e-17,
  -2.319180978135598e-18,  -8.599597108547571e-05,   2.773730959325902e-06,  -6.705677144458893e-08,   1.434915870364423e-09,  -2.826212559095767e-11,   4.994901697879854e-13,
  -6.669921885315935e-15,  -6.675680016163407e-18,   5.266525225875490e-18,  -2.644507993000911e-19,  -1.322985942951221e-04,   4.008060227353333e-06,  -9.106311157598901e-08,
   1.837380347814414e-09,  -3.461347930130571e-11,   6.164732410766868e-13,  -1.015527705282444e-14,   1.400409879747945e-16,  -9.306749845794260e-19,  -3.420849387666406e-20,
  -1.223296616874959e-04,   3.706166690790203e-06,  -8.420771233767392e-08,   1.699145624631055e-09,  -3.201092954628530e-11,   5.701309409234493e-13,  -9.390871056531160e-15,
   1.294291762840876e-16,  -8.565388935467052e-19,  -3.178861760348017e-20,  -1.039070558477137e-04,   3.148193862328321e-06,  -7.153507619023990e-08,   1.443557661541322e-09,
  -2.719800715269883e-11,   4.844237206963857e-13,  -7.977750731538309e-15,   1.098541679654872e-16,  -7.219464363696998e-19,  -2.722159361175097e-20,  -7.983272083294356e-05,
   2.418922952578289e-06,  -5.496827893575944e-08,   1.109342890309708e-09,  -2.090288047548676e-11,   3.723120355993039e-13,  -6.130289218023836e-15,   8.433378101144903e-17,
  -5.501022413179182e-19,  -2.109442993929802e-20,  -5.377084465039202e-05,   1.629323734826745e-06,  -3.702738888260346e-08,   7.473208587211115e-10,  -1.408240519445985e-11,
   2.508347096948652e-13,  -4.129499433079760e-15,   5.676622623191560e-17,  -3.680872546458616e-19,  -1.430347817192540e-20,  -2.969026729141863e-05,   8.996753914062499e-07,
  -2.044637484995839e-08,   4.126842077250039e-10,  -7.776864631132142e-12,   1.385227149938836e-13,  -2.280308902523198e-15,   3.133261152583916e-17,  -2.024683675209769e-19,
  -7.928295490731947e-21,  -1.125883399427976e-05,   3.411688399643279e-07,  -7.753635548891343e-09,   1.564996935441439e-10,  -2.949215765699119e-12,   5.253214348022864e-14,
  -8.647366470684246e-16,   1.187997327450049e-17,  -7.666739467898044e-20,  -3.010822916569686e-21,  -1.283659820915475e-06,   3.889793879223621e-08,  -8.840229361638301e-10,
   1.784319948939130e-11,  -3.362535216888527e-13,   5.989433777435892e-15,  -9.859211829567944e-17,   1.354446863137586e-18,  -8.739033262763589e-21,  -3.433566429127818e-22,
  -1.219245579087094e-03,   3.693769890932318e-05,  -8.392184106229789e-07,   1.693214171972324e-08,  -3.189024443294656e-10,   5.674128894381116e-12,  -9.311864498795169e-14,
   1.264628638261860e-15,  -7.348781792860167e-18,  -3.655701792425644e-19,  -1.127373272217682e-03,   3.415549195210729e-05,  -7.760404746298152e-07,   1.565825434719000e-08,
  -2.949242190566781e-10,   5.247563353976300e-12,  -8.610795946195777e-14,   1.168708816720284e-15,  -6.754546221624108e-18,  -3.396129150271782e-19,  -9.575930799241106e-04,
   2.901329553194613e-05,  -6.592521055039140e-07,   1.330291255252750e-08,  -2.505812165321040e-10,   4.458670470010774e-12,  -7.314853298948493e-14,   9.918251579831632e-16,
  -5.680756032182689e-18,  -2.906863514036372e-19,  -7.357273320702670e-04,   2.229244103692299e-05,  -5.065759847250065e-07,   1.022299748101250e-08,  -1.925824899708643e-10,
   3.426760454972795e-12,  -5.620734497316029e-14,   7.613089337191754e-16,  -4.318348380325809e-18,  -2.251482024756356e-19,  -4.955446795384933e-04,   1.501560976497730e-05,
  -3.412365376319304e-07,   6.886831140701227e-09,  -1.297438823677016e-10,   2.308669131352848e-12,  -3.786162215744029e-14,   5.123922602750061e-16,  -2.884039200557820e-18,
  -1.526086477474414e-19,  -2.736214036168934e-04,   8.291277089236180e-06,  -1.884294355896425e-07,   3.803033154323460e-09,  -7.164967775577693e-11,   1.274951167920065e-12,
  -2.090689473487696e-14,   2.828017092954733e-16,  -1.584621825704601e-18,  -8.457150648588618e-20,  -1.037598594211591e-04,   3.144162228185974e-06,  -7.145585304944165e-08,
   1.442200783536776e-09,  -2.717165658125033e-11,   4.835007046420805e-13,  -7.928252541085802e-15,   1.072236796385048e-16,  -5.997868660793596e-19,  -3.211401545822051e-20,
  -1.183003165589913e-05,   3.584777258545040e-07,  -8.146966996737197e-09,   1.644314787296652e-10,  -3.097964164401398e-12,   5.512615007726345e-14,  -9.039313262159997e-16,
   1.222462440935643e-17,  -6.836272560926132e-20,  -3.662259272702784e-21,  -3.575492306590490e-03,   1.083212353179035e-04,  -2.460997321652596e-06,   4.964768344960184e-08,
  -9.345304751104462e-10,   1.658637557929073e-11,  -2.695643197193773e-13,   3.513247466665591e-15,  -1.221340899701798e-17,  -1.459429579858213e-18,  -3.306072646645274e-03,
   1.001623045611940e-04,  -2.275728651379550e-06,   4.591242379549358e-08,  -8.642610469538073e-10,   1.533928510066433e-11,  -2.492581511367618e-13,   3.246062841401704e-15,
  -1.114653988180490e-17,  -1.355196844345150e-18,  -2.808184620313427e-03,   8.508261290850341e-05,  -1.933248023737737e-06,   3.900616521485639e-08,  -7.343129260881380e-10,
   1.303301191971661e-11,  -2.117284842241296e-13,   2.753777852420267e-15,  -9.263122968838399e-18,  -1.159118283945470e-18,  -2.157553369343377e-03,   6.537344575681115e-05,
  -1.485527130451364e-06,   2.997535898153843e-08,  -5.643486589120497e-10,   1.001646864988272e-11,  -1.626792804164687e-13,   2.112941219441599e-15,  -6.949594899577728e-18,
  -8.971029497068237e-19,  -1.453206976722701e-03,   4.403385598963484e-05,  -1.000671361373183e-06,   2.019320588195906e-08,  -3.802034401742131e-10,   6.748167541317120e-12,
  -1.095749188023885e-13,   1.421663251792352e-15,  -4.591950733316192e-18,  -6.077113177794389e-19,  -8.024070258551834e-04,   2.431449034752752e-05,  -5.525666432556445e-07,
   1.115105033995259e-08,  -2.099628696305511e-10,   3.726608932700517e-12,  -6.050422806631775e-14,   7.845119865485155e-16,  -2.507129353801808e-18,  -3.366635717803040e-19,
  -3.042804367006251e-04,   9.220377164924155e-06,  -2.095432691689110e-07,   4.228743338791538e-09,  -7.962400878917770e-11,   1.413239991199331e-12,  -2.294392673850081e-14,
   2.974263475656701e-16,  -9.466837101658846e-19,  -1.278239002533169e-19,  -3.469209787282536e-05,   1.051249775374437e-06,  -2.389086434297595e-08,   4.821370997437391e-10,
  -9.078294267745192e-12,   1.611299334230418e-13,  -2.615921621951202e-15,   3.390935080227389e-17,  -1.078583424095822e-19,  -1.457664248038619e-20,  -7.819932180734436e-03,
   2.369074040019106e-04,  -5.382175959462187e-06,   1.085491797580728e-07,  -2.040324551307425e-09,   3.598442671494592e-11,  -5.699752265836866e-13,   6.569253196387361e-15,
   2.798125552916431e-17,  -5.533198760649858e-18,  -7.230686467687828e-03,   2.190631501344647e-04,  -4.976994324103099e-06,   1.003823208273814e-07,  -1.886895531118169e-09,
   3.327785459217306e-11,  -5.269720548173969e-13,   6.065160148396587e-15,   2.636853976827132e-17,  -5.135942466435605e-18,  -6.141759315415005e-03,   1.860826247763349e-04,
  -4.227991511109153e-06,   8.528239149580052e-08,  -1.603169215621730e-09,   2.827312241887256e-11,  -4.475343310868234e-13,   5.139049482260171e-15,   2.309018066365708e-17,
  -4.389966480260340e-18,  -4.718768619613085e-03,   1.429770607191811e-04,  -3.248829906591251e-06,   6.553745187653376e-08,  -1.232084968143140e-09,   2.172806384485522e-11,
  -3.437812814462715e-13,   3.937978194835892e-15,   1.830660550073393e-17,  -3.395305153247507e-18,  -3.178297955703943e-03,   9.630563355669301e-05,  -2.188455612946402e-06,
   4.414989527489169e-08,  -8.300518716757062e-10,   1.463775313924552e-11,  -2.315178423347747e-13,   2.646870027175710e-15,   1.263117831760512e-17,  -2.298812618030145e-18,
  -1.754938317271476e-03,   5.317777205710635e-05,  -1.208456076458835e-06,   2.438033925563368e-08,  -4.583839412742624e-10,   8.083362792539500e-12,  -1.278246684545700e-13,
   1.459736753868599e-15,   7.070509520323981e-18,  -1.273124335245064e-18,  -6.654894337622762e-04,   2.016571620164084e-05,  -4.582683834657762e-07,   9.245600651044499e-09,
  -1.738321374947872e-10,   3.065422159485146e-12,  -4.847078132115611e-14,   5.532942926167869e-16,   2.694892632439465e-18,  -4.833231638352779e-19,  -7.587482395435165e-05,
   2.299168919552473e-06,  -5.224900671439283e-08,   1.054130375610788e-09,  -1.981938364110405e-11,   3.495022363756989e-13,  -5.526297172214704e-15,   6.307829361284294e-17,
   3.075130791488847e-19,  -5.511564739720432e-20,  -1.175958790707734e-04,   3.359192065055868e-06,  -7.196999074120435e-08,   1.370220413456630e-09,  -2.442427615483620e-11,
   4.157285148522796e-13,  -6.753533970121104e-15,   1.014473683017535e-16,  -1.251193077529238e-18,   5.857650825997623e-21,  -1.087344259788819e-04,   3.106149905577837e-06,
  -6.655118330485350e-08,   1.267113010502361e-09,  -2.258757309398067e-11,   3.844835260889100e-13,  -6.245971092317462e-15,   9.380897773094474e-17,  -1.156164646416299e-18,
   5.373386347562495e-21,  -9.235868355406654e-05,   2.638479871186881e-06,  -5.653464500125759e-08,   1.076485104080477e-09,  -1.919110209648636e-11,   3.266938571140884e-13,
  -5.307190484016693e-15,   7.968960260006798e-17,  -9.810007068429684e-19,   4.504249680454153e-21,  -7.095955278085306e-05,   2.027257392629160e-06,  -4.344091573323886e-08,
   8.272336167993951e-10,  -1.474891335799138e-11,   2.510937639918128e-13,  -4.079069089089803e-15,   6.123272928268534e-17,  -7.528535941946230e-19,   3.411682969371861e-21,
  -4.779413745133911e-05,   1.365494464678768e-06,  -2.926193218675706e-08,   5.572632630047386e-10,  -9.936277253079110e-12,   1.691714211993544e-13,  -2.748230508620007e-15,
   4.124633380710001e-17,  -5.066232866505444e-19,   2.271896836759029e-21,  -2.639007504364078e-05,   7.539905819723425e-07,  -1.615817238763082e-08,   3.077272328837929e-10,
  -5.487156651171670e-12,   9.342571965556310e-14,  -1.517725259570794e-15,   2.277577098145139e-17,  -2.795926599128682e-19,   1.246151341749414e-21,  -1.000735862270995e-05,
   2.859226149618139e-07,  -6.127450374132901e-09,   1.166969781885633e-10,  -2.080883892902691e-12,   3.543014018579132e-14,  -5.755721617867551e-16,   8.636943018388928e-18,
  -1.060034061423680e-19,   4.713688172994633e-22,  -1.140974445395393e-06,   3.259909792314263e-08,  -6.986146738918892e-10,   1.330511168804418e-11,  -2.372509126368926e-13,
   4.039558450694580e-15,  -6.562371904224955e-17,   9.847315537833916e-19,  -1.208543292880769e-20,   5.372006263249264e-23,  -1.083747446498284e-03,   3.095784616523186e-05,
  -6.632642564530770e-07,   1.262758680286069e-08,  -2.250727576239339e-10,   3.829834524367428e-12,  -6.214170860099250e-14,   9.293725433565518e-16,  -1.125944406570527e-17,
   4.241776862831437e-20,  -1.002081513610718e-03,   2.862584484593929e-05,  -6.133253639687203e-07,   1.167737577336328e-08,  -2.081472468778307e-10,   3.541990032585032e-12,
  -5.747112285572644e-14,   8.593782093442146e-16,  -1.040326321472203e-17,   3.879148332758012e-20,  -8.511649237868414e-04,   2.431586292126414e-05,  -5.210144967330179e-07,
   9.920598910175047e-09,  -1.768482641436299e-10,   3.009605579043449e-12,  -4.883266846626438e-14,   7.300062634100626e-16,  -8.825692517477511e-18,   3.234868476996632e-20,
  -6.539534779381065e-04,   1.868292168181456e-05,  -4.003447185003037e-07,   7.623563117601223e-09,  -1.359129007155412e-10,   2.313148396060409e-12,  -3.753208225055409e-14,
   5.609092006272824e-16,  -6.771967238350956e-18,   2.436264400497948e-20,  -4.404641966268330e-04,   1.258420672358517e-05,  -2.696734099570591e-07,   5.135588367155245e-09,
  -9.156387799309110e-11,   1.558453109420836e-12,  -2.528665908237087e-14,   3.778171646403282e-16,  -4.556485744572887e-18,   1.614834004386131e-20,  -2.432073016123519e-04,
   6.948672140534540e-06,  -1.489111994172477e-07,   2.835931297955189e-09,  -5.056473453136781e-11,   8.606621740063292e-13,  -1.396463375928596e-14,   2.086229700966519e-16,
  -2.514410598649161e-18,   8.833214070156154e-21,  -9.222644053967944e-05,   2.635022977650767e-06,  -5.646962791008332e-08,   1.075447903365811e-09,  -1.917556556698297e-11,
   3.263915866320291e-13,  -5.295847263780664e-15,   7.911272589762897e-17,  -9.532730145064940e-19,   3.337767744763302e-21,  -1.051506354598134e-05,   3.004287439313710e-07,
  -6.438323978658199e-09,   1.226163235097515e-10,  -2.186292266733831e-12,   3.721345144879469e-14,  -6.038045631865280e-16,   9.019940939269906e-18,  -1.086819801616086e-19,
   3.803263776565465e-22,  -3.178138399233400e-03,   9.078524197424302e-05,  -1.945043227964029e-06,   3.702969692449137e-08,  -6.599051728060859e-10,   1.122047610967691e-11,
  -1.815129487292125e-13,   2.684277543678732e-15,  -3.099054364991716e-17,   3.710225108737174e-20,  -2.938649357250362e-03,   8.394654562801555e-05,  -1.798595825163900e-06,
   3.424325122010117e-08,  -6.102797283565529e-10,   1.037712614236582e-11,  -1.678680219801387e-13,   2.481978001291105e-15,  -2.862601265643290e-17,   3.277535335522964e-20,
  -2.496079631833857e-03,   7.130733434084696e-05,  -1.527891269239252e-06,   2.909159485667328e-08,  -5.185116705507644e-10,   8.817325072589889e-12,  -1.426325537997635e-13,
   2.108145997167991e-15,  -2.427395150554101e-17,   2.569987487224396e-20,  -1.917748147728541e-03,   5.478848693487843e-05,  -1.174023339381791e-06,   2.235566208554204e-08,
  -3.984903807594064e-10,   6.776853724055474e-12,  -1.096226059686765e-13,   1.619662799595528e-15,  -1.861630184676044e-17,   1.799653347651154e-20,  -1.291681175400196e-03,
   3.690373783167966e-05,  -7.908256414610598e-07,   1.505981584347516e-08,  -2.684608037001835e-10,   4.565793471411165e-12,  -7.385509154459131e-14,   1.090888900049969e-15,
  -1.252102452310166e-17,   1.119211784752072e-20,  -7.132164102763586e-04,   2.037728560551480e-05,  -4.366867055689637e-07,   8.316203598713084e-09,  -1.482532345992007e-10,
   2.521471295476407e-12,  -4.078623684892912e-14,   6.023400702105333e-16,  -6.907935662834774e-18,   5.883223037511911e-21,  -2.704582075255301e-04,   7.727320367559699e-06,
  -1.655989323133009e-07,   3.153688301979766e-09,  -5.622177200102694e-11,   9.562243807961467e-13,  -1.546741349396791e-14,   2.284119172932355e-16,  -2.618741300351550e-18,
   2.188696512324700e-21,  -3.083589935814053e-05,   8.810204584287218e-07,  -1.888058439874625e-08,   3.595652204630490e-10,  -6.410096239299322e-12,   1.090236539283176e-13,
  -1.763511637446268e-15,   2.604203432772856e-17,  -2.985566431695776e-19,   2.487418496593781e-22,  -6.950884717233504e-03,   1.985555675918021e-04,  -4.253943567296196e-06,
   8.098080299627557e-08,  -1.442587504821745e-09,   2.448337467395283e-11,  -3.930927572768555e-13,   5.644415464352731e-15,  -5.639215297556918e-17,  -4.206611245770789e-19,
  -6.427099872081551e-03,   1.835987168163112e-04,  -3.933652823147310e-06,   7.488705811694367e-08,  -1.334101174339016e-09,   2.264296299126760e-11,  -3.635292774139721e-13,
   5.218225034276098e-15,  -5.203978723028691e-17,  -3.939679251659489e-19,  -5.459158655063009e-03,   1.559556129472949e-04,  -3.341603077460498e-06,   6.362079221773854e-08,
  -1.133488250193115e-09,   1.923918652046137e-11,  -3.088614648377256e-13,   4.431142772557497e-15,  -4.405848134578414e-17,  -3.416308917480153e-19,  -4.194293827281056e-03,
   1.198273931766113e-04,  -2.567669416577480e-06,   4.888986376314709e-08,  -8.711138265655675e-10,   1.478669955195942e-11,  -2.373652483390234e-13,   3.403475753740528e-15,
  -3.373250927805432e-17,  -2.681958599511879e-19,  -2.825027042510075e-03,   8.071182323154814e-05,  -1.729589706173494e-06,   3.293447563886846e-08,  -5.868631332487297e-10,
   9.962173436991068e-12,  -1.599098838228645e-13,   2.291849749506187e-15,  -2.265755085408725e-17,  -1.836805179744449e-19,  -1.559870720403486e-03,   4.456697244942283e-05,
  -9.550636234134216e-07,   1.818679160856837e-08,  -3.240854026918419e-10,   5.501597297997185e-12,  -8.830711469359565e-14,   1.265301109423680e-15,  -1.249060701177445e-17,
  -1.023916928316487e-19,  -5.915172910870028e-04,   1.690035071812896e-05,  -3.621761599222230e-07,   6.896832859371380e-09,  -1.229021776552180e-10,   2.086380090027608e-12,
  -3.348844167992037e-14,   4.797895467184212e-16,  -4.733699017198822e-18,  -3.896617947747190e-20,  -6.744098403633823e-05,   1.926871674187075e-06,  -4.129312576603067e-08,
   7.863368060629447e-10,  -1.401262687593178e-11,   2.378779346854828e-13,  -3.818165724480145e-15,   5.470204900923817e-17,  -5.396518563703421e-19,  -4.445287039865257e-21,
  -1.052151063212448e-04,   2.843138482365244e-06,  -5.762377260594575e-08,   1.038029528826808e-09,  -1.752277317064299e-11,   2.834673471786940e-13,  -4.429342552047151e-15,
   6.636548088502763e-17,  -9.177089233017535e-19,   1.023330026532509e-20,  -9.728630942650763e-05,   2.628953681173401e-06,  -5.328459261758056e-08,   9.599052476214649e-10,
  -1.620478893967414e-11,   2.621601992983642e-13,  -4.096576960980909e-15,   6.137881374812630e-17,  -8.485889752296408e-19,   9.454272378163762e-21,  -8.263427255470134e-05,
   2.233109144229215e-06,  -4.526404458873990e-08,   8.154752153403235e-10,  -1.376770963655594e-11,   2.227527714059237e-13,  -3.481025428196123e-15,   5.215491503616381e-17,
  -7.208354706212114e-19,   8.019379973877038e-21,  -6.348790873031974e-05,   1.715775382187773e-06,  -3.478003717049426e-08,   6.266427450199429e-10,  -1.058056977352316e-11,
   1.712027812717720e-13,  -2.675631933438917e-15,   4.008707339970924e-17,  -5.538578404905230e-19,   6.152273567994646e-21,  -4.276150211700053e-05,   1.155680653845752e-06,
  -2.342761475862895e-08,   4.221275306119233e-10,  -7.127918145699780e-12,   1.153443163970164e-13,  -1.802754058717435e-15,   2.700887018219605e-17,  -3.730648533939045e-19,
   4.138989375489200e-21,  -2.361119101705477e-05,   6.381337573256460e-07,  -1.293641237687520e-08,   2.331010583623342e-10,  -3.936230993049986e-12,   6.369896586835042e-14,
  -9.956046530784800e-16,   1.491599264448727e-17,  -2.059979769529026e-19,   2.283850688656661e-21,  -8.953572132980393e-06,   2.419878251702142e-07,  -4.905690184952630e-09,
   8.839670266386363e-11,  -1.492721865348164e-12,   2.415669822338499e-14,  -3.775699816534279e-16,   5.656671129176465e-18,  -7.811716792940335e-20,   8.658376399635678e-22,
  -1.020828356341016e-06,   2.758992126045371e-08,  -5.593167206130436e-10,   1.007847148827109e-11,  -1.701917788516483e-13,   2.754218534649584e-15,  -4.304861346051477e-17,
   6.449445025270140e-19,  -8.906431258669647e-21,   9.871306953602475e-23,  -9.696479593518077e-04,   2.620197241110704e-05,  -5.310525291029063e-07,   9.566304065059387e-09,
  -1.614839989889649e-10,   2.612109502777524e-12,  -4.080064169003302e-14,   6.104807875231696e-16,  -8.400608426087375e-18,   9.181205080100246e-20,  -8.965772568723040e-04,
   2.422807479775673e-05,  -4.910632598094601e-07,   8.846323816046618e-09,  -1.493378859006858e-10,   2.415766297492253e-12,  -3.773532402208827e-14,   5.646058537512188e-16,
  -7.767700890044091e-18,   8.481260314579935e-20,  -7.615460987866998e-04,   2.058002609498255e-05,  -4.171470236879575e-07,   7.515280980995473e-09,  -1.268785649414144e-10,
   2.052631451524278e-12,  -3.206512306314915e-14,   4.797526766983019e-16,  -6.598020771417172e-18,   7.192631170120316e-20,  -5.850958412028035e-04,   1.581234944026718e-05,
  -3.205278952252811e-07,   5.775032886632153e-09,  -9.750694534102706e-11,   1.577605323512079e-12,  -2.464624466772982e-14,   3.687410519077907e-16,  -5.069406496896064e-18,
   5.516854833700768e-20,  -3.940841264445821e-04,   1.065059361783301e-05,  -2.159055780272011e-07,   3.890255401987701e-09,  -6.568847036769188e-11,   1.062878195240846e-12,
  -1.660580053284785e-14,   2.484388958801416e-16,  -3.414509797667432e-18,   3.710890319876253e-20,  -2.175974913302641e-04,   5.880952752342423e-06,  -1.192201432531536e-07,
   2.148219614870173e-09,  -3.627496419504138e-11,   5.869749072170640e-13,  -9.170851168085354e-15,   1.372028208040520e-16,  -1.885377987507633e-18,   2.047433120695266e-20,
  -8.251489021312062e-05,   2.230126443006129e-06,  -4.521014553606542e-08,   8.146489384401120e-10,  -1.375641595787801e-11,   2.225997508187446e-13,  -3.477922965687818e-15,
   5.203205132616453e-17,  -7.149550734936114e-19,   7.761805452182600e-21,  -9.407813831039561e-06,   2.542649115488850e-07,  -5.154583633277351e-09,   9.288147460030366e-11,
  -1.568429422122573e-12,   2.537964175249943e-14,  -3.965350944845140e-16,   5.932424503287470e-18,  -8.151460899498079e-20,   8.849084448159366e-22,  -2.843536575758965e-03,
   7.683846356986126e-05,  -1.557333893525540e-06,   2.805338065721167e-08,  -4.735341571077156e-10,   7.658055500989237e-12,  -1.195073311895056e-13,   1.781957890076379e-15,
  -2.421593353119113e-17,   2.506946448773062e-19,  -2.629253429803359e-03,   7.104991993133433e-05,  -1.440063671504530e-06,   2.594202307192728e-08,  -4.379169179669646e-10,
   7.082418703254074e-12,  -1.105283591981796e-13,   1.648023824956430e-15,  -2.239004641188797e-17,   2.315042476811351e-19,  -2.233268440320025e-03,   6.035185285345772e-05,
  -1.223301189621001e-06,   2.203871183713111e-08,  -3.720573025067668e-10,   6.017788468513750e-12,  -9.391941935069823e-14,   1.400307639238793e-15,  -1.901647937412487e-17,
   1.962203238711785e-19,  -1.715820064902622e-03,   4.637042642733857e-05,  -9.399615245508619e-07,   1.693539844645394e-08,  -2.859281847876896e-10,   4.625125403706178e-12,
  -7.218881100774220e-14,   1.076253823311934e-15,  -1.460913469619148e-17,   1.504141467177716e-19,  -1.155669556619755e-03,   3.123334513390705e-05,  -6.331521780201129e-07,
   1.140825055036365e-08,  -1.926240186516664e-10,   3.116075875352915e-12,  -4.863806653613078e-14,   7.251079676695250e-16,  -9.839136629588310e-18,   1.011276636847273e-19,
  -6.381145025795733e-04,   1.724615862295735e-05,  -3.496180773736349e-07,   6.299696134597073e-09,  -1.063722167814310e-10,   1.720852717122215e-12,  -2.686114986490142e-14,
   4.004425967790304e-16,  -5.432561399087678e-18,   5.578051949576762e-20,  -2.419786542636321e-04,   6.539946161723232e-06,  -1.325806504397076e-07,   2.388973957354701e-09,
  -4.033912646888241e-11,   6.526024568394571e-13,  -1.018671925709282e-14,   1.518609018621172e-16,  -2.060044184925627e-18,   2.114417681503345e-20,  -2.758884032341682e-05,
   7.456432963796298e-07,  -1.511603297410939e-08,   2.723767417888675e-10,  -4.599240990530456e-12,   7.440626345656494e-14,  -1.161437684308727e-15,   1.731437748288804e-17,
  -2.348723186498001e-19,   2.410565498572680e-21,  -6.219079779711648e-03,   1.680528498341780e-04,  -3.406025909145776e-06,   6.135414402137273e-08,  -1.035535079889889e-09,
   1.673810768305367e-11,  -2.606242687203504e-13,   3.852963238818597e-15,  -5.068691419645026e-17,   4.457181914131872e-19,  -5.750422547472561e-03,   1.553927675976422e-04,
  -3.149545606699989e-06,   5.673649486639259e-08,  -9.576460223897601e-10,   1.547990684465789e-11,  -2.410400687450690e-13,   3.563215008049124e-15,  -4.685681230975126e-17,
   4.111172070026160e-19,  -4.884366431408224e-03,   1.319951019923198e-04,  -2.675466991176227e-06,   4.819975244927994e-08,  -8.136221404113881e-10,   1.315290993952092e-11,
  -2.048156040606612e-13,   3.027407721790742e-15,  -3.978516822658616e-17,   3.477836257835672e-19,  -3.752658558613859e-03,   1.014164249269811e-04,  -2.055778254095347e-06,
   3.703854834774857e-08,  -6.252727590743230e-10,   1.010896068289353e-11,  -1.574233476883161e-13,   2.326639326788865e-15,  -3.055487978638226e-17,   2.660429948379962e-19,
  -2.527557137744416e-03,   6.831022359083434e-05,  -1.384759296473461e-06,   2.495040151069597e-08,  -4.212332814387263e-10,   6.810664581426706e-12,  -1.060642283296937e-13,
   1.567439920199772e-15,  -2.057341572151853e-17,   1.785733298282525e-19,  -1.395615949522923e-03,   3.771894894852829e-05,  -7.646453655764152e-07,   1.377774241567715e-08,
  -2.326163691807937e-10,   3.761181462900713e-12,  -5.857514938930639e-14,   8.655922934221080e-16,  -1.135775026298279e-17,   9.840404860359093e-20,  -5.292298920673703e-04,
   1.430346900506381e-05,  -2.899654970712424e-07,   5.224802323101280e-09,  -8.821419722691565e-11,   1.426359363962857e-12,  -2.221374094710516e-14,   3.282565533581562e-16,
  -4.306664004994848e-18,   3.728759649752217e-20,  -6.033936766448771e-05,   1.630791066820315e-06,  -3.306008831724623e-08,   5.957011891958505e-10,  -1.005768783645511e-11,
   1.626258927684110e-13,  -2.532695857715687e-15,   3.742599626751262e-17,  -4.910123774939907e-19,   4.250759413225733e-21,  -9.469184690230476e-05,   2.427603778564263e-06,
  -4.667963373881967e-08,   7.978204000751070e-10,  -1.278170541620096e-11,   1.964702324638243e-13,  -2.929700837040648e-15,   4.247143160490896e-17,  -5.918347596910192e-19,
   7.595138775992279e-21,  -8.755583308715086e-05,   2.244711157268992e-06,  -4.316419534633721e-08,   7.377653514357194e-10,  -1.182012445499885e-11,   1.816990785169020e-13,
  -2.709581670555870e-15,   3.928184261027053e-17,  -5.473731940447397e-19,   7.022926684580512e-21,  -7.436895933578870e-05,   1.906706159967890e-06,  -3.666647812588989e-08,
   6.267459859082604e-10,  -1.004218911038173e-11,   1.543818938317715e-13,  -2.302415138341196e-15,   3.338100573617178e-17,  -4.651268554379589e-19,   5.965410537623620e-21,
  -5.713740920403728e-05,   1.464975339100128e-06,  -2.817340538338056e-08,   4.816051934431234e-10,  -7.717258573001590e-12,   1.186507759753899e-13,  -1.769692771108164e-15,
   2.565909690383954e-17,  -3.575133665549457e-19,   4.583368193562732e-21,  -3.848406340880686e-05,   9.867442978938956e-07,  -1.897720423794789e-08,   3.244197077240792e-10,
  -5.198843050016725e-12,   7.993654384553105e-14,  -1.192351062076399e-15,   1.728898043891816e-17,  -2.408815632890401e-19,   3.087142507418252e-21,  -2.124931659173938e-05,
   5.448496958076655e-07,  -1.047888416512602e-08,   1.791444731872555e-10,  -2.870904940602274e-12,   4.414438148481092e-14,  -6.584948354422908e-16,   9.548389884169638e-18,
  -1.330315351318200e-19,   1.704618157080827e-21,  -8.057922247569860e-06,   2.066130924472558e-07,  -3.973746794679894e-09,   6.793500138247422e-11,  -1.088716901968590e-12,
   1.674088193703303e-14,  -2.497250385134350e-16,   3.621133706717160e-18,  -5.045048652565802e-20,   6.464092473352545e-22,  -9.187120340662767e-07,   2.355671193948077e-08,
  -4.530620557039345e-10,   7.745543937447316e-12,  -1.241292952044711e-13,   1.908704844919816e-15,  -2.847237278605624e-17,   4.128639017548412e-19,  -5.752108943202867e-21,
   7.369945551235138e-23,  -8.726670489813702e-04,   2.237246263630602e-05,  -4.301930461746443e-07,   7.352596986469636e-09,  -1.177937895934691e-10,   1.810588108873335e-12,
  -2.699593490186130e-14,   3.911874812545510e-16,  -5.442837725443553e-18,   6.948220055858014e-20,  -8.069025262533198e-04,   2.068694938468485e-05,  -3.977952521536528e-07,
   6.799138352565434e-09,  -1.089320381277149e-10,   1.674463086663572e-12,  -2.496761798654740e-14,   3.618086827259275e-16,  -5.033906494324564e-18,   6.424568677406954e-20,
  -6.853741098309177e-04,   1.757194180298561e-05,  -3.379131890240824e-07,   5.775999966836984e-09,  -9.254691782247835e-11,   1.422719003570281e-12,  -2.121573662188193e-14,
   3.074574682031400e-16,  -4.277476236677170e-18,   5.456905134619715e-20,  -5.265705116869960e-04,   1.350101129376267e-05,  -2.596422055795441e-07,   4.438403478825483e-09,
  -7.112079437859368e-11,   1.093435729037814e-12,  -1.630692048837951e-14,   2.363335588211969e-16,  -3.287779591362318e-18,   4.192467945674714e-20,  -3.546638400864383e-04,
   9.093699773364631e-06,  -1.748912882212516e-07,   2.989804869112605e-09,  -4.791155208355471e-11,   7.366615010647462e-13,  -1.098696899004683e-14,   1.592399919839181e-16,
  -2.215181990643651e-18,   2.823742218058416e-20,  -1.958307817333476e-04,   5.021259880290470e-06,  -9.657194638032316e-08,   1.650969420006789e-09,  -2.645771526271292e-11,
   4.068159776826819e-13,  -6.067725752847747e-15,   8.794520737638882e-17,  -1.223369971741327e-18,   1.559142664423888e-20,  -7.426070415367088e-05,   1.904117850882440e-06,
  -3.662150056121365e-08,   6.260790953593759e-10,  -1.003340834859866e-11,   1.542768927789174e-13,  -2.301100513454147e-15,   3.335234078276283e-17,  -4.639461563114276e-19,
   5.912384749333138e-21,  -8.466723861077097e-06,   2.170954182074344e-07,  -4.175357209240332e-09,   7.138180675480220e-11,  -1.143952025692553e-12,   1.758981707588750e-14,
  -2.623597148380144e-16,   3.802669887187733e-18,  -5.289677084559441e-20,   6.740914313850204e-22,  -2.559135677093865e-03,   6.560825937260713e-05,  -1.261560296379766e-06,
   2.156177990419927e-08,  -3.454309757389997e-10,   5.309240283239754e-12,  -7.913951559305268e-14,   1.145556304140318e-15,  -1.587806927547047e-17,   1.999930479236475e-19,
  -2.366278233226357e-03,   6.066541546123677e-05,  -1.166552319084320e-06,   1.993874051629578e-08,  -3.194438201698196e-10,   4.910075471104447e-12,  -7.319333718472011e-14,
   1.059517617456694e-15,  -1.468483487436591e-17,   1.849072702048004e-19,  -2.009890643449449e-03,   5.153051471920675e-05,  -9.909454964007128e-07,   1.693834673694614e-08,
  -2.713943371669327e-10,   4.171877158748845e-12,  -6.219444589622682e-14,   9.003481341977905e-16,  -1.247779171798877e-17,   1.570380265488492e-19,  -1.544191893687074e-03,
   3.959232672606186e-05,  -7.614123454461079e-07,   1.301579230940304e-08,  -2.085620940448741e-10,   3.206309315264576e-12,  -4.780402110524535e-14,   6.920648605336565e-16,
  -9.590431218956028e-18,   1.206349688363755e-19,  -1.040067787096232e-03,   2.666768619711567e-05,  -5.128765004444687e-07,   8.767719956844654e-09,  -1.405008613019318e-10,
   2.160130321570157e-12,  -3.220843150073505e-14,   4.663053293271920e-16,  -6.461498661058403e-18,   8.124284011074974e-20,  -5.742826439594622e-04,   1.472507187703752e-05,
  -2.832015382923298e-07,   4.841532496511004e-09,  -7.758737624310228e-11,   1.192916041912173e-12,  -1.778759197216566e-14,   2.575304430528200e-16,  -3.568411732944740e-18,
   4.485602497119996e-20,  -2.177728809848023e-04,   5.583911783933618e-06,  -1.073941830821260e-07,   1.836001467362670e-09,  -2.942301736392312e-11,   4.523897145678183e-13,
  -6.745693909350801e-15,   9.766569116051719e-17,  -1.353262985771463e-18,   1.700936778049946e-20,  -2.482905149826510e-05,   6.366421402953695e-07,  -1.224442116425385e-08,
   2.093299438678655e-10,  -3.354644708269481e-12,   5.157902824133907e-14,  -7.691094772935311e-16,   1.113535890746860e-17,  -1.542919845303430e-19,   1.939289847666518e-21,
  -5.597068556761908e-03,   1.434913792418185e-04,  -2.759148561250037e-06,   4.715740492043318e-08,  -7.554663330566265e-10,   1.160981119912538e-11,  -1.729450535697362e-13,
   2.497005204541093e-15,  -3.428694792644156e-17,   4.172107771259138e-19,  -5.175271328554251e-03,   1.326809188059624e-04,  -2.551357358123952e-06,   4.360768199296818e-08,
  -6.986316716055129e-10,   1.073694279962634e-11,  -1.599502441646348e-13,   2.309433832539873e-15,  -3.170873070140741e-17,   3.856643445984939e-19,  -4.395818409796951e-03,
   1.127020392908746e-04,  -2.167289055201126e-06,   3.704557030474205e-08,  -5.935461160875786e-10,   9.122701878177598e-12,  -1.359135194091758e-13,   1.962449470620848e-15,
  -2.694091763915794e-17,   3.274312194966014e-19,  -3.377291782751718e-03,   8.659210925445986e-05,  -1.665278909517311e-06,   2.846661717250899e-08,  -4.561303448423134e-10,
   7.011272611052828e-12,  -1.044655350130551e-13,   1.508429034433786e-15,  -2.070500653072777e-17,   2.514426597628056e-19,  -2.274725314355341e-03,   5.832471559421652e-05,
  -1.121708127750461e-06,   1.917573011413896e-08,  -3.072787269679494e-10,   4.723576664256501e-12,  -7.038437252338357e-14,   1.016343759067026e-15,  -1.394893190389767e-17,
   1.692905312690265e-19,  -1.256009737058626e-03,   3.220510481586665e-05,  -6.193878377933181e-07,   1.058883261043050e-08,  -1.696854203662133e-10,   2.608558917949131e-12,
  -3.887073083889143e-14,   5.612990240710438e-16,  -7.703100552292553e-18,   9.345444219346897e-20,  -4.762896142866873e-04,   1.221253558375738e-05,  -2.348809656982117e-07,
   4.015487267059695e-09,  -6.434882986931924e-11,   9.892439482487274e-13,  -1.474116330786397e-14,   2.128658707774471e-16,  -2.921234276844525e-18,   3.543574848574249e-20,
  -5.430345278863924e-05,   1.392395706314398e-06,  -2.677967637149742e-08,   4.578219235194197e-10,  -7.336686701074486e-12,   1.127882401284206e-13,  -1.680711686073835e-15,
   2.426989764460199e-17,  -3.330630728133968e-19,   4.040097966522687e-21,  -8.567221501787410e-05,   2.089261139918771e-06,  -3.821451863359225e-08,   6.212968766730447e-10,
  -9.469167783103036e-12,   1.385196267091600e-13,  -1.968649626450983e-15,   2.733717458664086e-17,  -3.705116510879376e-19,   4.833412592135879e-21,  -7.921574703327586e-05,
   1.931850206341599e-06,  -3.533632473572599e-08,   5.745230736281539e-10,  -8.756659387881720e-12,   1.281029481836007e-13,  -1.820704454916377e-15,   2.528408397911110e-17,
  -3.426961932327722e-19,   4.470373441417113e-21,  -6.728473525447930e-05,   1.640943284423679e-06,  -3.001660911614419e-08,   4.880596221327715e-10,  -7.439332483927499e-12,
   1.088402128954251e-13,  -1.547062335374204e-15,   2.148585364167974e-17,  -2.912307852561427e-19,   3.798769513823780e-21,  -5.169442350259090e-05,   1.260772532023281e-06,
  -2.306355008849984e-08,   3.750283463904991e-10,  -5.716854379652671e-12,   8.364681468338604e-14,  -1.189072275066150e-15,   1.651552229817903e-17,  -2.238725708465004e-19,
   2.919951857948709e-21,  -3.481791354927361e-05,   8.491968844150112e-07,  -1.553512035073473e-08,   2.526233925589754e-10,  -3.851161562614755e-12,   5.635247885960412e-14,
  -8.011312422547674e-16,   1.112803804427318e-17,  -1.508502124307958e-19,   1.967416346942461e-21,  -1.922498545358433e-05,   4.688986102753126e-07,  -8.578174520488331e-09,
   1.394973444374788e-10,  -2.126662749236939e-12,   3.111978950354532e-14,  -4.424310948376620e-16,   6.145799442354426e-18,  -8.331371568754718e-20,   1.086557394456568e-21,
  -7.290273756144798e-06,   1.778113563515356e-07,  -3.252962599324795e-09,   5.289987969895160e-11,  -8.064785414067051e-13,   1.180149777715393e-14,  -1.677849526446838e-16,
   2.330732522939952e-18,  -3.159618191943893e-20,   4.120647222662168e-22,  -8.311896402177714e-07,   2.027291654475531e-08,  -3.708825597939315e-10,   6.031325686242355e-12,
  -9.195001736371192e-14,   1.345541726567997e-15,  -1.912996576844921e-17,   2.657386519996679e-19,  -3.602446733206130e-21,   4.698156851579241e-23,  -7.895433613553651e-04,
   1.925434354400953e-05,  -3.521797447717217e-07,   5.725785520228374e-09,  -8.726642969729256e-11,   1.276567715877212e-12,  -1.814209201158005e-14,   2.518929664247350e-16,
  -3.412364060059469e-18,   4.444241840279778e-20,  -7.300414395944629e-04,   1.780366601256408e-05,  -3.256547058643973e-07,   5.294724658624860e-09,  -8.070005875632845e-11,
   1.180569761459581e-12,  -1.677870056898367e-14,   2.329750193010560e-16,  -3.156179668327714e-18,   4.110398886589903e-20,  -6.200868744851297e-04,   1.512270779852269e-05,
  -2.766289387558961e-07,   4.497889521274080e-09,  -6.855977106040428e-11,   1.003048400859977e-12,  -1.425694816542021e-14,   1.979767910833573e-16,  -2.682180416581774e-18,
   3.492827218653384e-20,  -4.764087036497313e-04,   1.161910639013727e-05,  -2.125505035940276e-07,   3.456209017142872e-09,  -5.268567097328125e-11,   7.708713232619889e-13,
  -1.095788888378216e-14,   1.521785654138994e-16,  -2.061815259381884e-18,   2.684747560033997e-20,  -3.208771069272893e-04,   7.826081783553373e-06,  -1.431695311788841e-07,
   2.328142004965997e-09,  -3.549172602013557e-11,   5.193324834096901e-13,  -7.382818881451496e-15,   1.025367113724383e-16,  -1.389291358545794e-18,   1.808918474312325e-20,
  -1.771748242275530e-04,   4.321305152587040e-06,  -7.905527582950177e-08,   1.285588098778294e-09,  -1.959900410792002e-11,   2.867933669240217e-13,  -4.077219888126815e-15,
   5.662900624872593e-17,  -7.672962417317980e-19,   9.990160646462152e-21,  -6.718616117728554e-05,   1.638685023905721e-06,  -2.997885563307333e-08,   4.875179239056427e-10,
  -7.432384953521509e-12,   1.087600945645806e-13,  -1.546220692455885e-15,   2.147597591639003e-17,  -2.909918707761975e-19,   3.788646964107731e-21,  -7.660129510155873e-06,
   1.868324128133207e-07,  -3.418002629092626e-09,   5.558385753550455e-11,  -8.473975316715279e-13,   1.240022647537701e-14,  -1.762920227426762e-16,   2.448585004621284e-18,
  -3.317750829476218e-20,   4.319624873331364e-22,  -2.315371698074601e-03,   5.646423501552917e-05,  -1.032783010678362e-06,   1.679111765756029e-08,  -2.559119136523596e-10,
   3.743520557210952e-12,  -5.319741305758645e-14,   7.383810178012983e-16,  -9.990886842112483e-18,   1.295918310122061e-19,  -2.140879615218081e-03,   5.221005741133350e-05,
  -9.549971356302137e-07,   1.552701270618901e-08,  -2.366557936502543e-10,   3.462007354061193e-12,  -4.919956982039090e-14,   6.829252010636725e-16,  -9.240761688773982e-18,
   1.198545929484080e-19,  -1.818432868665798e-03,   4.434802595101252e-05,  -8.112268586424405e-07,   1.319025860935374e-08,  -2.010539633892076e-10,   2.941427605247008e-12,
  -4.180510112892843e-14,   5.803325256027420e-16,  -7.852893614047681e-18,   1.018433373302430e-19,  -1.397090119594099e-03,   3.407355604323098e-05,  -6.233139527510227e-07,
   1.013548473452883e-08,  -1.545025973542595e-10,   2.260570748809525e-12,  -3.213137481081510e-14,   4.460821969352960e-16,  -6.036523164586526e-18,   7.827855540854009e-20,
  -9.409866617819939e-04,   2.295033949163190e-05,  -4.198511170481588e-07,   6.827378658872507e-09,  -1.040807423921091e-10,   1.522936002923380e-12,  -2.164833001271868e-14,
   3.005659793439581e-16,  -4.067493072533628e-18,   5.274066150955640e-20,  -5.195732035794669e-04,   1.267242319209543e-05,  -2.318331671963204e-07,   3.770043543983901e-09,
  -5.747477239194846e-11,   8.410179029023799e-13,  -1.195545712371538e-14,   1.659964568654328e-16,  -2.246438102797873e-18,   2.912672574324153e-20,  -1.970264632758490e-04,
   4.805518094207829e-06,  -8.791434824445652e-08,   1.429667715662409e-09,  -2.179573152688104e-11,   3.189375871688514e-13,  -4.533916140732745e-15,   6.295244114133780e-17,
  -8.519447918389349e-19,   1.104588601601567e-20,  -2.246367703072647e-05,   5.478945174088741e-07,  -1.002344709580647e-08,   1.630021025396001e-10,  -2.485023205798723e-12,
   3.636350549853731e-14,  -5.169334726965804e-16,   7.177526721023414e-18,  -9.713466151569096e-20,   1.259395078701748e-21,  -5.063933998873538e-03,   1.234925506161826e-04,
  -2.258792563079834e-06,   3.672370237625670e-08,  -5.596990360541456e-10,   8.187067893788375e-12,  -1.163219785058145e-13,   1.613344089420686e-15,  -2.176829868401581e-17,
   2.795751256706041e-19,  -4.682303528190284e-03,   1.141882672361416e-04,  -2.088667613866771e-06,   3.395898964990347e-08,  -5.175844039640236e-10,   7.571397983420696e-12,
  -1.075801582604162e-13,   1.492168748884813e-15,  -2.013361669254687e-17,   2.585546516158178e-19,  -3.977082399293601e-03,   9.699327082515733e-05,  -1.774228636314746e-06,
   2.884829558748399e-08,  -4.397204423056323e-10,   6.432889926984357e-12,  -9.141121966561210e-14,   1.267999115684062e-15,  -1.710933656983628e-17,   2.196807771667041e-19,
  -3.055566482865587e-03,   7.452204643005140e-05,  -1.363245621803831e-06,   2.216722702715995e-08,  -3.379090142889511e-10,   4.943857207751022e-12,  -7.025849511310259e-14,
   9.746618978401436e-16,  -1.315161460640732e-17,   1.688346238650315e-19,  -2.058025652195147e-03,   5.019453393413063e-05,  -9.182534646774041e-07,   1.493209804096784e-08,
  -2.276325452952513e-10,   3.330652758382370e-12,  -4.733619985911068e-14,   6.567144880499484e-16,  -8.861559143973162e-18,   1.137449517961636e-19,  -1.136355088320042e-03,
   2.771577196716580e-05,  -5.070407110246995e-07,   8.245428065245808e-09,  -1.257017205063332e-10,   1.839301307674052e-12,  -2.614176228313043e-14,   3.626888888716026e-16,
  -4.894097726259452e-18,   6.281445927547646e-20,  -4.309152637868340e-04,   1.051011646804274e-05,  -1.922768608777519e-07,   3.126813298709063e-09,  -4.766893041701318e-11,
   6.975146264188377e-13,  -9.913843058573982e-15,   1.375458537966124e-16,  -1.856041579866771e-18,   2.382108420042324e-20,  -4.913015821516232e-05,   1.198296432823012e-06,
  -2.192221157511869e-08,   3.565004205069953e-10,  -5.434935640681561e-12,   7.952677181490929e-14,  -1.130324630860375e-15,   1.568229655247910e-17,  -2.116168082621533e-19,
   2.715950180274290e-21,  -7.788276230349653e-05,   1.810986699592589e-06,  -3.158423157939495e-08,   4.896242704002561e-10,  -7.115546835304738e-12,   9.926348746053045e-14,
  -1.345962721095083e-15,   1.786304766518874e-17,  -2.326874827318957e-19,   2.965664741090403e-21,  -7.201318756296080e-05,   1.674535306784903e-06,  -2.920522196338730e-08,
   4.527589742358198e-10,  -6.580048902700656e-12,   9.179727705605339e-14,  -1.244787462172577e-15,   1.652118467404788e-17,  -2.152190179668978e-19,   2.743099058440066e-21,
  -6.116678927671097e-05,   1.422367049156096e-06,  -2.480825324233263e-08,   3.846144683358635e-10,  -5.590042407675823e-12,   7.799157233905806e-14,  -1.057667200502902e-15,
   1.403891389209273e-17,  -1.828980393462185e-19,   2.331251967756010e-21,  -4.699388746912467e-05,   1.092828302373838e-06,  -1.906144662037212e-08,   2.955354346089891e-10,
  -4.295642703356999e-12,   5.993693981104034e-14,  -8.128942843781809e-16,   1.079094234618154e-17,  -1.405960618246581e-19,   1.792147384330481e-21,  -3.165186242768486e-05,
   7.360736859157453e-07,  -1.283927494680790e-08,   1.990734322620943e-10,  -2.893708640152078e-12,   4.037828290658918e-14,  -5.476679995958568e-16,   7.270675949502720e-18,
  -9.473678501503258e-20,   1.207633613492060e-21,  -1.747679867295679e-05,   4.064344581483475e-07,  -7.089548019143084e-09,   1.099264942617976e-10,  -1.597927583790551e-12,
   2.229797929258016e-14,  -3.024491352608603e-16,   4.015395270943699e-18,  -5.232262199504849e-20,   6.669837377243792e-22,  -6.627343044579986e-06,   1.541241068042655e-07,
  -2.688449681613661e-09,   4.168596710918768e-11,  -6.059678196762032e-13,   8.455976089897686e-15,  -1.146983285520531e-16,   1.522789956009296e-18,  -1.984301724485548e-20,
   2.529512927498349e-22,  -7.556065164817440e-07,   1.757224412212672e-08,  -3.065202116674545e-10,   4.752780659750316e-12,  -6.908889945769880e-14,   9.641029601699020e-16,
  -1.307729248523592e-17,   1.736208608099025e-19,  -2.262406762801233e-21,   2.884034524552482e-23,  -7.177568355604890e-04,   1.668980457051980e-05,  -2.910759368706121e-07,
   4.512309797039223e-09,  -6.557588041145067e-11,   9.147968195457468e-13,  -1.240407649810043e-14,   1.646154456391798e-16,  -2.143996584408993e-18,   2.731166510018570e-20,
  -6.636636412867544e-04,   1.543228728455741e-05,  -2.691513112470405e-07,   4.172564307471004e-09,  -6.064080657798256e-11,   8.459893817051939e-13,  -1.147166856428157e-14,
   1.522495884143488e-16,  -1.983039592654245e-18,   2.526192553426324e-20,  -5.637047250783514e-04,   1.310833927338609e-05,  -2.286294518855807e-07,   3.544553931611866e-09,
  -5.151704563775161e-11,   7.187581511914789e-13,  -9.747211535694937e-15,   1.293743897751799e-16,  -1.685230264922643e-18,   2.146902185183674e-20,  -4.330892095104172e-04,
   1.007135546589676e-05,  -1.756676719730094e-07,   2.723613832958940e-09,  -3.958803967940027e-11,   5.523694690940803e-13,  -7.491441486370975e-15,   9.944295702250641e-17,
  -1.295456342121690e-18,   1.650420936690652e-20,  -2.916992148679511e-04,   6.783553943312779e-06,  -1.183249930909930e-07,   1.834633313783644e-09,  -2.666801225192110e-11,
   3.721199397349517e-13,  -5.047178465739842e-15,   6.700224136785923e-17,  -8.729066747209145e-19,   1.112127509801755e-20,  -1.610637750923398e-04,   3.745644116915261e-06,
  -6.533630005154222e-08,   1.013067419981460e-09,  -1.472627608139747e-11,   2.054946881580923e-13,  -2.787299441767242e-15,   3.700349783307745e-17,  -4.821014180035294e-19,
   6.142337909412308e-21,  -6.107668283915688e-05,   1.420386589650804e-06,  -2.477638272509713e-08,   3.841721272915251e-10,  -5.584514276942649e-12,   7.792895232483352e-14,
  -1.057032557564175e-15,   1.403312694678856e-17,  -1.828338147922697e-19,   2.329458687374470e-21,  -6.963565828405098e-06,   1.619433871745619e-07,  -2.824848138010942e-09,
   4.380097148294466e-11,  -6.367135891452564e-13,   8.885021999681052e-15,  -1.205172217094137e-16,   1.599986621514171e-18,  -2.084584407592665e-20,   2.655941508276310e-22,
  -2.104854457503073e-03,   4.894360843875768e-05,  -8.535933701104563e-07,   1.323255162530260e-08,  -1.923040905211381e-10,   2.682670117151626e-12,  -3.637458659784977e-14,
   4.826856145345317e-16,  -6.284366199343096e-18,   7.995253238762826e-20,  -1.946223713152041e-03,   4.525588199520914e-05,  -7.892984122808195e-07,   1.223623267595013e-08,
  -1.778317735794464e-10,   2.480890115158063e-12,  -3.364032441764725e-14,   4.464262219880932e-16,  -5.812566982489648e-18,   7.395160404300284e-20,  -1.653089660050933e-03,
   3.844079910947133e-05,  -6.704662240820939e-07,   1.039456396835064e-08,  -1.510759513398202e-10,   2.107780511873324e-12,  -2.858340086406703e-14,   3.793512731182134e-16,
  -4.939630947221517e-18,   6.284759121068340e-20,  -1.270053739608935e-03,   2.953470642980091e-05,  -5.151534053857803e-07,   7.987120166496526e-09,  -1.160936277760061e-10,
   1.619840496170941e-12,  -2.196841984754184e-14,   2.915861572032910e-16,  -3.797140052525716e-18,   4.831322481354200e-20,  -8.554211708546188e-04,   1.989307943143139e-05,
  -3.469934020533175e-07,   5.380144773744873e-09,  -7.820509169716775e-11,   1.091253163586677e-12,  -1.480069216996608e-14,   1.964635195318595e-16,  -2.558589002569162e-18,
   3.255531329899214e-20,  -4.723268217711752e-04,   1.098427115964275e-05,  -1.916016594574003e-07,   2.970865808474426e-09,  -4.318543719225812e-11,   6.026194807269330e-13,
  -8.173667289465297e-15,   1.085013654105878e-16,  -1.413092123736466e-18,   1.798037242480298e-20,  -1.791101411425621e-04,   4.165348059033805e-06,  -7.265786464279753e-08,
   1.126602055170465e-09,  -1.637682798928015e-11,   2.285290433201203e-13,  -3.099714381282955e-15,   4.114781865816139e-17,  -5.359056604269886e-19,   6.818975341427282e-21,
  -2.042097246285815e-05,   4.749063236415177e-07,  -8.283995122484999e-09,   1.284483203867142e-10,  -1.867189948665707e-12,   2.605559955319167e-14,  -3.534129206138172e-16,
   4.691467415449664e-18,  -6.110141502515386e-20,   7.774679039511286e-22,  -4.603513148386738e-03,   1.070442394412820e-04,  -1.866888320686473e-06,   2.894081859263907e-08,
  -4.205862531220942e-10,   5.867185726927966e-12,  -7.954999478041836e-14,   1.055394562075131e-15,  -1.372930701088129e-17,   1.741467466186025e-19,  -4.256572905197851e-03,
   9.897883754192138e-05,  -1.726269250500561e-06,   2.676177654801540e-08,  -3.889339979821789e-10,   5.425878602375587e-12,  -7.357023753133780e-14,   9.761121356549273e-16,
  -1.269852212699848e-17,   1.610733657873734e-19,  -3.615461372337818e-03,   8.407361523482842e-05,  -1.466372170402379e-06,   2.273387611334408e-08,  -3.304166168898893e-10,
   4.609861685534812e-12,  -6.251089366714420e-14,   8.294510694706738e-16,  -1.079136908780859e-17,   1.368841741809968e-19,  -2.777726064902818e-03,   6.459515936023207e-05,
  -1.126688548742866e-06,   1.746857305245072e-08,  -2.539071431887261e-10,   3.542702847314786e-12,  -4.804414189639612e-14,   6.375515207189429e-16,  -8.295360969541702e-18,
   1.052248589888724e-19,  -1.870885938639389e-03,   4.350802128594789e-05,  -7.589069361333855e-07,   1.176687590965768e-08,  -1.710415255527039e-10,   2.386645750468408e-12,
  -3.236856899061932e-14,   4.295657417532946e-16,  -5.589546081037230e-18,   7.090298386924711e-20,  -1.033022842316012e-03,   2.402362615943669e-05,  -4.190507008574977e-07,
   6.497559220599903e-09,  -9.445041048719092e-11,   1.317970216560853e-12,  -1.787550599540453e-14,   2.372370624024335e-16,  -3.087059133870207e-18,   3.915937127829274e-20,
  -3.917305953467918e-04,   9.110004946120490e-06,  -1.589095271227471e-07,   2.463983242964359e-09,  -3.581758627461297e-11,   4.998087152130001e-13,  -6.778959425957650e-15,
   8.996923067441597e-17,  -1.170744802879506e-18,   1.485094330400340e-20,  -4.466257270194687e-05,   1.038664451565568e-06,  -1.811787002088970e-08,   2.809283966334446e-10,
  -4.083711271511733e-12,   5.698538582590077e-14,  -7.729008306669361e-16,   1.025783880085113e-17,  -1.334827257264170e-19,   1.693234231557474e-21,  -7.110949861485517e-05,
   1.580019647606585e-06,  -2.633157349192205e-08,   3.900586335321591e-10,  -5.416758493429328e-12,   7.221039652153581e-14,  -9.358040625185457e-16,   1.187663927832029e-17,
  -1.482328042429750e-19,   1.821179944299621e-21,  -6.575027537773720e-05,   1.460965902351286e-06,  -2.434807232469534e-08,   3.606869171477596e-10,  -5.009048472406232e-12,
   6.677798123006758e-14,  -8.654435226390397e-16,   1.098423407978116e-17,  -1.371020837498337e-19,   1.684511414099345e-21,  -5.584702324565887e-05,   1.240952231233661e-06,
  -2.068217828415267e-08,   3.063959160204528e-10,  -4.255326409686288e-12,   5.673357373559872e-14,  -7.353241462980975e-16,   9.333545613825705e-18,  -1.165090132501301e-19,
   1.431609174068953e-21,  -4.290663422034208e-05,   9.534387081209888e-07,  -1.589101816069903e-08,   2.354293386125100e-10,  -3.269919650211843e-12,   4.359888041632863e-14,
  -5.651312058586679e-16,   7.173913451231188e-18,  -8.955914406909444e-20,   1.100555692265603e-21,  -2.889890222190426e-05,   6.421849777683417e-07,  -1.070367813688908e-08,
   1.585839908571615e-10,  -2.202707188452056e-12,   2.937104614635998e-14,  -3.807335245094638e-16,   4.833465944236511e-18,  -6.034546855352077e-20,   7.416106390694240e-22,
  -1.595671112585474e-05,   3.545914168788460e-07,  -5.910295182352688e-09,   8.756802205162894e-11,  -1.216340153763384e-12,   1.621928727705943e-14,  -2.102565259697542e-16,
   2.669345217206736e-18,  -3.332800526493590e-20,   4.095976407235092e-22,  -6.050910566769042e-06,   1.344645609655036e-07,  -2.241257806000345e-09,   3.320717751531322e-11,
  -4.612602209558569e-13,   6.150749081067458e-15,  -7.973550370397317e-17,   1.012310292867774e-18,  -1.263936354206115e-20,   1.553386944817319e-22,  -6.898853803448384e-07,
   1.533078601365370e-08,  -2.555341217125290e-10,   3.786079031844654e-12,  -5.259015684127191e-14,   7.012733739617927e-16,  -9.091008804080364e-18,   1.154184111451017e-19,
  -1.441079036420741e-21,   1.771100857726547e-23,  -6.553353681286686e-04,   1.456124396188494e-05,  -2.426681628563469e-07,   3.594726733900108e-09,  -4.992009816549939e-11,
   6.654807634888443e-13,  -8.624218047579612e-15,   1.094520279135022e-16,  -1.366015860763353e-18,   1.678010334764873e-20,  -6.059455031824461e-04,   1.346406100477918e-05,
  -2.243884886679059e-07,   3.324041034142180e-09,  -4.616269890521506e-11,   6.154163940264877e-13,  -7.975786662862050e-15,   1.012278475014879e-16,  -1.263442188261378e-18,
   1.552084508811045e-20,  -5.146784923320579e-04,   1.143644524382572e-05,  -1.906041129506270e-07,   2.823702632538019e-09,  -3.921650045261857e-11,   5.228485588049027e-13,
  -6.776627537162868e-15,   8.601552375436572e-17,  -1.073669661280811e-18,   1.319062204407588e-20,  -3.954216452044208e-04,   8.786760122041778e-06,  -1.464494396462522e-07,
   2.169684412899901e-09,  -3.013512784242075e-11,   4.018010889315367e-13,  -5.208157019492972e-15,   6.611291030697077e-17,  -8.253172442062439e-19,   1.014033229135209e-20,
  -2.663283118993539e-04,   5.918288512480107e-06,  -9.864362682361651e-08,   1.461488254204684e-09,  -2.029984519291591e-11,   2.706793884869377e-13,  -3.508778007560264e-15,
   4.454395478075173e-17,  -5.561033519251430e-19,   6.833065875166546e-21,  -1.470548571354843e-04,   3.267865773550590e-06,  -5.446846821505090e-08,   8.070148504660238e-10,
  -1.120962284325965e-11,   1.494746469862930e-13,  -1.937689801259762e-15,   2.459998453291352e-17,  -3.071284808710696e-19,   3.773955802551964e-21,  -5.576436033200074e-05,
   1.239206917083283e-06,  -2.065512394917322e-08,   3.060327819299735e-10,  -4.250910481737487e-12,   5.668442954971346e-14,  -7.348293760452416e-16,   9.329185666432505e-18,
  -1.164758655283830e-19,   1.431261219674696e-21,  -6.357888868595687e-06,   1.412864172985836e-07,  -2.354967350513438e-09,   3.489198376421225e-11,  -4.846636210808803e-13,
   6.462835767361904e-15,  -8.378125192599644e-17,   1.063665747112040e-18,  -1.328001410897194e-20,   1.631858614322991e-22,  -1.921800674665703e-03,   4.270150800027668e-05,
  -7.116353865059141e-07,   1.054169885797457e-08,  -1.463929242172029e-10,   1.951550196130364e-12,  -2.529074383150687e-14,   3.209627842407709e-16,  -4.005354212489549e-18,
   4.918244139149572e-20,  -1.776962656772066e-03,   3.948396924165475e-05,  -6.580294134152472e-07,   9.747900790161121e-09,  -1.353741824512479e-10,   1.804734327683724e-12,
  -2.338920126828686e-14,   2.968457331746069e-16,  -3.704591458713989e-18,   4.549146425242687e-20,  -1.509318010141868e-03,   3.353789410788904e-05,  -5.589552003391836e-07,
   8.280635778986497e-09,  -1.150041441731635e-10,   1.533275264381148e-12,  -1.987263511149479e-14,   2.522362795968589e-16,  -3.148148660794899e-18,   3.866146853291200e-20,
  -1.159591899794908e-03,   2.576757237421388e-05,  -4.294696195599158e-07,   6.362697745940873e-09,  -8.837261209338917e-11,   1.178298486093102e-12,  -1.527305409667242e-14,
   1.938728025887691e-16,  -2.419942511509949e-18,   2.972101790165061e-20,  -7.810198478256431e-04,   1.735564934725804e-05,  -2.892769066623774e-07,   4.285880455289077e-09,
  -5.953020515338164e-11,   7.937786137995961e-13,  -1.028958114035115e-14,   1.306228954061488e-16,  -1.630569482079977e-18,   2.002745917014351e-20,  -4.312450348327083e-04,
   9.583164517919668e-06,  -1.597312518113674e-07,   2.366607575872092e-09,  -3.287272098765601e-11,   4.383406444665014e-13,  -5.682324713747686e-15,   7.213820329981575e-17,
  -9.005414270684037e-19,   1.106130422279175e-20,  -1.635315145805830e-04,   3.634030459349953e-06,  -6.057208716946879e-08,   8.974549845513995e-10,  -1.246598535290353e-11,
   1.662294565830239e-13,  -2.154905850224812e-15,   2.735736132214483e-17,  -3.415226240064481e-19,   4.194963251691315e-21,  -1.864479732263390e-05,   4.143288234413174e-07,
  -6.906048493704859e-09,   1.023223216559835e-10,  -1.421297773075214e-12,   1.895253574661410e-14,  -2.456906535684573e-16,   3.119145552219499e-18,  -3.893875456103386e-20,
   4.782904837638958e-22,  -4.203157440991839e-03,   9.339218337807281e-05,  -1.556413000567106e-06,   2.305567810288485e-08,  -3.201748597449749e-10,   4.268211184483934e-12,
  -5.531240142950563e-14,   7.019249766967289e-16,  -8.757350010294863e-18,   1.074361546260838e-19,  -3.886383177836358e-03,   8.635512581616391e-05,  -1.439171734838646e-06,
   2.131956772548927e-08,  -2.960758522504394e-10,   3.947111977001441e-12,  -5.115360844047609e-14,   6.491823385705070e-16,  -8.099748633881743e-18,   9.937294693983701e-20,
  -3.301019355845816e-03,   7.335050454429757e-05,  -1.222487185127642e-06,   1.811052236092237e-08,  -2.515246945941665e-10,   3.353407175414327e-12,  -4.346265940031351e-14,
   5.516240842625800e-16,  -6.883123035821693e-18,   8.445261689414220e-20,  -2.536135711879907e-03,   5.635608569947178e-05,  -9.392901362627447e-07,   1.391581308874934e-08,
  -1.932790714329480e-10,   2.577041845784284e-12,  -3.340309275475207e-14,   4.239867882231200e-16,  -5.290958678692616e-18,   6.492242453164665e-20,  -1.708163301337020e-03,
   3.795842494500121e-05,  -6.326755902917845e-07,   9.373620074164999e-09,  -1.301980610604400e-10,   1.736063226099714e-12,  -2.250393409715316e-14,   2.856633719989530e-16,
  -3.565068321822295e-18,   4.374757392951440e-20,  -9.431731401394857e-04,   2.095927520833257e-05,  -3.493471538804465e-07,   5.175991376364259e-09,  -7.189567912852500e-11,
   9.586893033340345e-13,  -1.242758598158544e-14,   1.577612968305665e-16,  -1.968936891201614e-18,   2.416199331585053e-20,  -3.576586851105729e-04,   7.947963782789125e-06,
  -1.324768072442531e-07,   1.962817709088819e-09,  -2.726426214613455e-11,   3.635583498313611e-13,  -4.712908636862186e-15,   5.982866507051568e-17,  -7.467021649009020e-19,
   9.163343057434825e-21,  -4.077791190076901e-05,   9.061758066458157e-07,  -1.510417253014924e-08,   2.237884556176253e-10,  -3.108509594093793e-12,   4.145085208595365e-14,
  -5.373402273633309e-16,   6.821356398845130e-18,  -8.513535683519628e-20,   1.044762124009578e-21,  -6.518302541590066e-05,   1.386718872137654e-06,  -2.212688537780413e-08,
   3.138280152654107e-10,  -4.172740811430413e-12,   5.326067525805900e-14,  -6.609000484797103e-16,   8.032751589254397e-18,  -9.607595476343203e-20,   1.133573928865526e-21,
  -6.027036701474779e-05,   1.282226490355515e-06,  -2.046001442507971e-08,   2.901943972661800e-10,  -3.858626292903669e-12,   4.925318326153815e-14,  -6.111981848841440e-16,
   7.429018919429383e-18,  -8.885964397722807e-20,   1.048487278186582e-21,  -5.119237077872537e-05,   1.089124777853461e-06,  -1.737937469697378e-08,   2.465110447017722e-10,
  -3.277955516074191e-12,   4.184383125200979e-14,  -5.192897913494732e-16,   6.312384240702438e-18,  -7.550989074510248e-20,   8.910476501078307e-22,  -3.933041696971726e-05,
   8.367835523810005e-07,  -1.335321669930899e-08,   1.894124186863570e-10,  -2.518833748392779e-12,   3.215557844835293e-14,  -3.990865820464128e-16,   4.851623452323508e-18,
  -5.804129314753523e-20,   6.849754182937700e-22,  -2.649015956011407e-05,   5.636100798275022e-07,  -8.994236543289288e-09,   1.275859488688325e-10,  -1.696731367168204e-12,
   2.166168770283881e-14,  -2.688615088294620e-16,   3.268715861501402e-18,  -3.910734239572258e-20,   4.615601634945892e-22,  -1.462669168259060e-05,   3.112044659059475e-07,
  -4.966366395293414e-09,   7.045089707175817e-11,  -9.369315021192274e-13,   1.196189422329626e-14,  -1.484742152339500e-16,   1.805161526994251e-18,  -2.159808124841691e-20,
   2.549198822016693e-22,  -5.546554296457144e-06,   1.180116985991826e-07,  -1.883305477756856e-09,   2.671603511918994e-11,  -3.553018571640370e-13,   4.536223493030043e-15,
  -5.630553104799709e-17,   6.845769651090224e-19,  -8.190834108098059e-21,   9.667710194724343e-23,  -6.323819202918343e-07,   1.345493432625239e-08,  -2.147225964266895e-10,
   3.045997626046037e-12,  -4.050939168977763e-14,   5.171940160265874e-16,  -6.419645171704688e-18,   7.805186300508612e-20,  -9.338782058712523e-22,   1.102267204650554e-23,
  -6.007178054816939e-04,   1.277981057742331e-05,  -2.039183351613060e-07,   2.892195859753543e-09,  -3.845540528384729e-11,   4.908430070156510e-13,  -6.090759853698640e-15,
   7.402847611194619e-17,  -8.854088395337958e-19,   1.044619675024216e-20,  -5.554434207014195e-04,   1.181682314515295e-05,  -1.885566815074561e-07,   2.674391684181147e-09,
  -3.556056909036340e-11,   4.539105155447226e-13,  -5.632714605867397e-15,   6.846457722080863e-17,  -8.189053060253772e-19,   9.662097301193465e-21,  -4.717818547909738e-04,
   1.003722429672190e-05,  -1.601659290872244e-07,   2.271811910255877e-09,  -3.020918708920519e-11,   3.856269532647914e-13,  -4.785700040423575e-15,   5.817386016341340e-17,
  -6.958776875384972e-19,   8.211244573529956e-21,  -3.624637184294414e-04,   7.711682236821586e-06,  -1.230614102195928e-07,   1.745598819863811e-09,  -2.321322530715993e-11,
   2.963413570219465e-13,  -3.677924530189887e-15,   4.471173588265280e-17,  -5.348919969613576e-19,   6.312230514814847e-21,  -2.441296705128000e-04,   5.194153050369637e-06,
  -8.288964807420497e-08,   1.175814570756671e-09,  -1.563684285741800e-11,   1.996311133055520e-13,  -2.477788978541342e-15,   3.012392835453195e-17,  -3.604020767246526e-19,
   4.253398064166265e-21,  -1.347975807038803e-04,   2.868017595371369e-06,  -4.576935026467147e-08,   6.492657854069637e-10,  -8.634631827633183e-12,   1.102391601617120e-13,
  -1.368317000190809e-15,   1.663606081628249e-17,  -1.990417260000973e-19,   2.349153149402721e-21,  -5.111628224822974e-05,   1.087579598373761e-06,  -1.735628449574162e-08,
   2.462113080959507e-10,  -3.274413035824910e-12,   4.180520733290841e-14,  -5.189036705624314e-16,   6.308944548136404e-18,  -7.548437787494413e-20,   8.909046210582539e-22,
  -5.827944882278081e-06,   1.239988259163335e-07,  -1.978853943378646e-09,   2.807149551270449e-11,  -3.733289808293691e-13,   4.766388407447642e-15,  -5.916252596875040e-17,
   7.193126562994519e-19,  -8.606353665806157e-21,   1.015767864328431e-22,  -1.761632196297620e-03,   3.747737385102886e-05,  -5.979997615917426e-07,   8.481495425499008e-09,
  -1.127722146408245e-10,   1.439418965562140e-12,  -1.786140005286256e-14,   2.170900410029964e-16,  -2.596403012630037e-18,   3.062923546148516e-20,  -1.628863010552321e-03,
   3.465336955186729e-05,  -5.529510158983008e-07,   7.842774810136753e-09,  -1.042829766027951e-10,   1.331112788795802e-12,  -1.651816368662780e-14,   2.007737849724286e-16,
  -2.401385408676222e-18,   2.833016417392432e-20,  -1.383521675976183e-03,   2.943461525628904e-05,  -4.696938474558612e-07,   6.662191379012013e-09,  -8.858980691360140e-11,
   1.130868201029217e-12,  -1.403425900706270e-14,   1.705960348841334e-16,  -2.040614560035036e-18,   2.407610491160505e-20,  -1.062941285489318e-03,   2.261485774445314e-05,
  -3.608831639073350e-07,   5.119047644720740e-09,  -6.807383267424239e-11,   8.690342148970189e-13,  -1.078566236524474e-14,   1.311180718393668e-16,  -1.568534405515133e-18,
   1.850800530957419e-20,  -7.159213256580615e-04,   1.523208928087433e-05,  -2.430776504081400e-07,   3.448129513137005e-09,  -4.585574860326971e-11,   5.854271211565615e-13,
  -7.266216272407436e-15,   8.833902617502305e-17,  -1.056854349700189e-18,   1.247131990966076e-20,  -3.953000160542183e-04,   8.410591611023169e-06,  -1.342206943991788e-07,
   1.904001338450900e-09,  -2.532144819266468e-11,   3.232812412809338e-13,  -4.012644854617675e-15,   4.878558176402371e-17,  -5.836761242090727e-19,   6.887910652508360e-21,
  -1.499008148947843e-04,   3.189376474246282e-06,  -5.089809105297060e-08,   7.220258185318758e-10,  -9.602364258086050e-12,   1.225956302069738e-13,  -1.521705963562485e-15,
   1.850110613211699e-17,  -2.213527178829418e-19,   2.612205288156085e-21,  -1.709071255951183e-05,   3.636321780981029e-07,  -5.803078891413457e-09,   8.232093270489592e-11,
  -1.094804113827173e-12,   1.397764603659493e-14,  -1.734964959031645e-16,   2.109398754587291e-18,  -2.523753674076487e-20,   2.978314447527734e-22,  -3.852854030026043e-03,
   8.196651444587236e-05,  -1.307881289770953e-06,   1.854982189039066e-08,  -2.466433366335488e-10,   3.148141682603241e-12,  -3.906440712001367e-14,   4.747873136133206e-16,
  -5.678092358288552e-18,   6.696571330121058e-20,  -3.562475429182313e-03,   7.579015347395431e-05,  -1.209355478545134e-06,   1.715288030572894e-08,  -2.280765822927334e-10,
   2.911266103396119e-12,  -3.612663390654495e-14,   4.391027697908372e-16,  -5.251605069408292e-18,   6.193908850484266e-20,  -3.025891032257443e-03,   6.437625075335224e-05,
  -1.027264280783129e-06,   1.457083418242424e-08,  -1.937541584583012e-10,   2.473312760368418e-12,  -3.069412154453804e-14,   3.731024021036351e-16,  -4.462630350552909e-18,
   5.263818651492799e-20,  -2.324751797841427e-03,   4.946080457417575e-05,  -7.892851605845923e-07,   1.119583484670750e-08,  -1.488838119515603e-10,   1.900657742854366e-12,
  -2.358916292503250e-14,   2.867620027200256e-16,  -3.430233693584532e-18,   4.046441005873345e-20,  -1.565786757610402e-03,   3.331400089669482e-05,  -5.316335078043801e-07,
   7.541380982507981e-09,  -1.002907928034641e-10,   1.280382943902559e-12,  -1.589183398098226e-14,   1.932019962559783e-16,  -2.311237533071569e-18,   2.726623376098946e-20,
  -8.645580292665989e-04,   1.839474882957053e-05,  -2.935531854256504e-07,   4.164228585144111e-09,  -5.538036539999880e-11,   7.070457987672188e-13,  -8.775996012552549e-15,
   1.066965709510104e-16,  -1.276442469354633e-18,   1.505912504044718e-20,  -3.278470727234068e-04,   6.975464019653902e-06,  -1.113188754353028e-07,   1.579137835660949e-09,
  -2.100126490415442e-11,   2.681279150903869e-13,  -3.328100514170156e-15,   4.046286758474931e-17,  -4.840766435690920e-19,   5.711094559561068e-21,  -3.737898347868201e-05,
   7.952975119724867e-07,  -1.269187513500327e-08,   1.800435609978591e-10,  -2.394438556401327e-12,   3.057039702651705e-14,  -3.794516093020882e-16,   4.613363197619618e-18,
  -5.519201198126071e-20,   6.511522771701483e-22,  -5.996783138088944e-05,   1.223708261278310e-06,  -1.872897702061050e-08,   2.547947277223211e-10,  -3.249572776057807e-12,
   3.978503429455826e-14,  -4.735470097973771e-16,   5.521142821209967e-18,  -6.335849846050282e-20,   7.177584944514177e-22,  -5.544815563987155e-05,   1.131496175543037e-06,
  -1.731800414234664e-08,   2.356052427120782e-10,  -3.004925146591535e-12,   3.679104733220050e-14,  -4.379279643992749e-16,   5.106082683435232e-18,  -5.859830173611658e-20,
   6.638675028452170e-22,  -4.709638690332766e-05,   9.610901893587753e-07,  -1.471034929393136e-08,   2.001371504764895e-10,  -2.552686961133128e-12,   3.125580698413074e-14,
  -3.720655172144105e-16,   4.338466386961422e-18,  -4.979300907250101e-20,   5.641600929109312e-22,  -3.618344567253889e-05,   7.384102024448467e-07,  -1.130242106814965e-08,
   1.537782455440367e-10,  -1.961494887505078e-12,   2.401853449295489e-14,  -2.859335439895045e-16,   3.334383142663229e-18,  -3.827231322941681e-20,   4.336692169461576e-22,
  -2.437054132067056e-05,   4.973495948665962e-07,  -7.612851022311386e-09,   1.035822786814411e-10,  -1.321281615928400e-12,   1.617988053428211e-14,  -1.926271235945351e-16,
   2.246437074185580e-18,  -2.578651438988430e-20,   2.922119092759877e-22,  -1.345631871003961e-05,   2.746173366068482e-07,  -4.203589564292518e-09,   5.719616689075408e-11,
  -7.296037272789760e-13,   8.934676796424802e-15,  -1.063737703921511e-16,   1.240585268292323e-18,  -1.424104430940392e-20,   1.613857622720016e-22,  -5.102737880216511e-06,
   1.041374307229437e-07,  -1.594049353085300e-09,   2.168960140273582e-11,  -2.766785657609867e-13,   3.388221402212825e-15,  -4.033969271296859e-17,   4.704683129211440e-19,
  -5.400723172946415e-21,   6.120432279443269e-23,  -5.817808321478361e-07,   1.187307809162951e-08,  -1.817434014236497e-10,   2.472913855196757e-12,  -3.154522045123327e-14,
   3.863052160732061e-16,  -4.599305117247597e-18,   5.364027096872252e-20,  -6.157629438262512e-22,   6.978223208537312e-24,  -5.526552938713402e-04,   1.127752718707125e-05,
  -1.726036786801404e-07,   2.348153198502094e-09,  -2.994761606923502e-11,   3.666533992532061e-13,  -4.364143443964686e-15,   5.088204809847066e-17,  -5.839007401748812e-19,
   6.614644602606416e-21,  -5.110025832873881e-04,   1.042771327573103e-05,  -1.596003465152913e-07,   2.171305541533903e-09,  -2.769297714098979e-11,   3.390612275186430e-13,
  -4.035883267783890e-15,   4.705691413888119e-17,  -5.400315975419910e-19,   6.118001112333323e-21,  -4.340338302217056e-04,   8.857275122420356e-06,  -1.355685577491460e-07,
   1.844436477273118e-09,  -2.352521218071828e-11,   2.880492143998094e-13,  -3.428904102249473e-15,   3.998267392432551e-17,  -4.588835622037514e-19,   5.199127292586608e-21,
  -3.334616633778629e-04,   6.805086961317908e-06,  -1.041615595024797e-07,   1.417199179743417e-09,  -1.807686728578032e-11,   2.213515073776642e-13,  -2.635123802995950e-15,
   3.072918887327341e-17,  -3.527108564403256e-19,   3.996562670201615e-21,  -2.245955600734116e-04,   4.583505525841037e-06,  -7.015898894249984e-08,   9.546000467331300e-10,
  -1.217674976868494e-11,   1.491115515768006e-13,  -1.775224798338286e-15,   2.070283642288751e-17,  -2.376439410405092e-19,   2.692935173509336e-21,  -1.240115842090173e-04,
   2.530835639198311e-06,  -3.873970381078316e-08,   5.271120145434950e-10,  -6.723927670037012e-12,   8.234075134228242e-14,  -9.803258827583832e-16,   1.143305285219073e-17,
  -1.312429355241559e-19,   1.487281510467444e-21,  -4.702613114067282e-05,   9.597162520933045e-07,  -1.469053980028250e-08,   1.998883860848827e-10,  -2.549831633885508e-12,
   3.122538199406707e-14,  -3.717650010378120e-16,   4.335767333451973e-18,  -4.977210546727319e-20,   5.640401875001301e-22,  -5.361612207004655e-06,   1.094206562213492e-07,
  -1.674922214224536e-09,   2.279003427789250e-11,  -2.907164159361080e-13,   3.560135689549264e-15,  -4.238655667979129e-17,   4.943409113667929e-19,  -5.674761911322307e-21,
   6.430915550762717e-23,  -1.620686702234333e-03,   3.307185970846553e-05,  -5.061681121465432e-07,   6.886065693867437e-09,  -8.782274091876410e-11,   1.075227644975600e-12,
  -1.279804339795083e-14,   1.492135942182768e-16,  -1.712298010393103e-18,   1.939690678428621e-20,  -1.498538240247206e-03,   3.057974188973154e-05,  -4.680352511098433e-07,
   6.367451923463145e-09,  -8.121091011048324e-11,   9.943123554924092e-13,  -1.183540591229497e-14,   1.379962381330555e-16,  -1.583650998051327e-18,   1.794053694847137e-20,
  -1.272823882736407e-03,   2.597436081411169e-05,  -3.975609411511764e-07,   5.408893575856515e-09,  -6.898875053706232e-11,   8.447173238463328e-13,  -1.005541267513395e-14,
   1.172507506794581e-16,  -1.345683035432154e-18,   1.524601024150021e-20,  -9.778914443317628e-04,   1.995622600197237e-05,  -3.054584950602803e-07,   4.156000834623960e-09,
  -5.301123228983927e-11,   6.491232869181696e-13,  -7.727616876064530e-15,   9.011454339241304e-17,  -1.034329880036131e-18,   1.171958536853950e-20,  -6.586366612758568e-04,
   1.344133773380235e-05,  -2.057444154991082e-07,   2.799407907960062e-09,  -3.570887036349326e-11,   4.372763555325076e-13,  -5.205925073126793e-15,   6.071187348272993e-17,
  -6.968943818513359e-19,   7.896804926563383e-21,  -3.636695923831230e-04,   7.421790239680176e-06,  -1.136059375611525e-07,   1.545779876020254e-09,  -1.971822251881769e-11,
   2.414679699162236e-13,  -2.874848915147629e-15,   3.352787216796986e-17,  -3.848718416611766e-19,   4.361326770679796e-21,  -1.379062613574790e-04,   2.814411415078990e-06,
  -4.308067391123790e-08,   5.861817528999422e-10,  -7.477496785977612e-12,   9.156984210597723e-14,  -1.090217271777007e-15,   1.271480630565697e-17,  -1.459574305306919e-19,
   1.653999877422425e-21,  -1.572317084951792e-05,   3.208810346215321e-07,  -4.911785320258045e-09,   6.683280856541907e-11,  -8.525390605795150e-13,   1.044025860196198e-14,
  -1.243004479990712e-16,   1.449673944810218e-18,  -1.664132264208027e-20,   1.885811272440023e-22,  -3.544593079791123e-03,   7.233124384571766e-05,  -1.107036902740774e-06,
   1.506046832934443e-08,  -1.920765273324894e-10,   2.351622882382768e-12,  -2.799049104915039e-14,   3.263425249081524e-16,  -3.744871403711964e-18,   4.241875799589054e-20,
  -3.277442993059483e-03,   6.688074958176430e-05,  -1.023636776651829e-06,   1.392621161258024e-08,  -1.776158365240615e-10,   2.174653615755077e-12,  -2.588511475166952e-14,
   3.018092291137850e-16,  -3.463514366097752e-18,   3.923383210382869e-20,  -2.783784626800721e-03,   5.680835133988258e-05,  -8.695028832913383e-07,   1.182975504666625e-08,
  -1.508848333172813e-10,   1.847475363750205e-12,  -2.199210666874179e-14,   2.564371170058950e-16,  -2.943067496026558e-18,   3.334119849870539e-20,  -2.138739857362069e-03,
   4.364612882108291e-05,  -6.680662376218933e-07,   9.089561692595268e-09,  -1.159405103652263e-10,   1.419693009019281e-12,  -1.690100436006038e-14,   1.970879736920302e-16,
  -2.262124177493457e-18,   2.562931126778010e-20,  -1.440499850116946e-03,   2.939746013094761e-05,  -4.499822391480420e-07,   6.122566355083843e-09,  -7.809863070818055e-11,
   9.563640635228796e-13,  -1.138583385952585e-14,   1.327818943388562e-16,  -1.524137944684680e-18,   1.726934448465600e-20,  -7.953793405687257e-04,   1.623214794481036e-05,
  -2.484667884677581e-07,   3.380764851844521e-09,  -4.312559212686370e-11,   5.281129104707612e-13,  -6.287557265306543e-15,   7.332823136629180e-17,  -8.417311821829641e-19,
   9.537683969173781e-21,  -3.016138646622253e-04,   6.155380439462933e-06,  -9.422145463116250e-08,   1.282034200168644e-09,  -1.635398303297653e-11,   2.002717620614990e-13,
  -2.384404788613758e-15,   2.780833355739553e-17,  -3.192151351221522e-19,   3.617093376339733e-21,  -3.438804212358813e-05,   7.017967711904569e-07,  -1.074253292007943e-08,
   1.461695896371090e-10,  -1.864582457293717e-12,   2.283381666319114e-14,  -2.718564372903524e-16,   3.170556876428569e-18,  -3.639528327276741e-20,   4.124036172227449e-22,
  -5.535447042980729e-05,   1.085279414821222e-06,  -1.595900709478362e-08,   2.085983883393530e-10,  -2.556091650094537e-12,   3.006774004574879e-14,  -3.438566240456117e-16,
   3.851977615960531e-18,  -4.247439080616126e-20,   4.624563088636096e-22,  -5.118243756418309e-05,   1.003496293456432e-06,  -1.475665753882993e-08,   1.928870115978035e-10,
  -2.363634630949028e-12,   2.780472337134917e-14,  -3.179882239953646e-16,   3.562338807540514e-18,  -3.928243452237902e-20,   4.277239153421495e-22,  -4.347310264171629e-05,
   8.523641967470013e-07,  -1.253459866232013e-08,   1.638482019848858e-10,  -2.007883698200038e-12,   2.362106938592239e-14,  -2.701581247829932e-16,   3.026714645709090e-18,
  -3.337852195761849e-20,   3.634692495515296e-22,  -3.339966440473695e-05,   6.548728969077542e-07,  -9.630660062852971e-09,   1.258938614522786e-10,  -1.542844418790067e-12,
   1.815128150670777e-14,  -2.076124418185664e-16,   2.326150796546704e-18,  -2.565475756143996e-20,   2.793869243358289e-22,  -2.249555318593114e-05,   4.410824087159552e-07,
  -6.486786998252356e-09,   8.479919265274495e-11,  -1.039263301530182e-12,   1.222727728418162e-14,  -1.398613029913868e-16,   1.567135279369304e-18,  -1.728477086687623e-20,
   1.882484308055614e-22,  -1.242102321863887e-05,   2.435483184966069e-07,  -3.581799774932003e-09,   4.682429222543427e-11,  -5.738712922326343e-13,   6.751956572280435e-15,
  -7.723425938891734e-17,   8.654321032004604e-19,  -9.545655849357119e-21,   1.039658184656725e-22,  -4.710144396832309e-06,   9.235570942883449e-08,  -1.358258001891561e-09,
   1.775640866195811e-11,  -2.176215711000874e-13,   2.560478901325080e-15,  -2.928911541206625e-17,   3.281969673816486e-19,  -3.620038628335345e-21,   3.942796996622896e-23,
  -5.370198581349231e-07,   1.052980104621791e-08,  -1.548599374027629e-10,   2.024475039820114e-12,  -2.481188854266807e-14,   2.919306973662077e-16,  -3.339378132312280e-18,
   3.741922468058623e-20,  -4.127379461861981e-22,   4.495382734425331e-24,  -5.101391932647117e-04,   1.000178595955427e-05,  -1.470760164691097e-07,   1.922414083412578e-09,
  -2.355658939736213e-11,   2.771001589727202e-13,  -3.168935272844388e-15,   3.549928853262550e-17,  -3.914377171027301e-19,   4.261912835706402e-21,  -4.716903116510356e-04,
   9.248083950814289e-06,  -1.359953281754780e-07,   1.777620194263359e-09,  -2.178293195566005e-11,   2.562445083818557e-13,  -2.930535661441043e-15,   3.283001763341603e-17,
  -3.620211173389078e-19,   3.941825361433829e-21,  -4.006421403395288e-04,   7.855271314489274e-06,  -1.155171389011707e-07,   1.510002515095146e-09,  -1.850438024549308e-11,
   2.176885283529020e-13,  -2.489740056171537e-15,   2.789378001292542e-17,  -3.076115283004784e-19,   3.349666000162446e-21,  -3.078067177311431e-04,   6.035218632303548e-06,
  -8.875483979672520e-08,   1.160220528055437e-09,  -1.421864215060394e-11,   1.672797151628525e-13,  -1.913327658787706e-15,   2.143748125572718e-17,  -2.364304544487025e-19,
   2.574778604217468e-21,  -2.073159270643983e-04,   4.064954869920088e-06,  -5.978133763084799e-08,   7.814977072212395e-10,  -9.577707774464572e-12,   1.126849065989825e-13,
  -1.288942497845138e-15,   1.444250010822895e-17,  -1.592938929224755e-19,   1.734862929030197e-21,  -1.144704432194627e-04,   2.244507837471183e-06,  -3.300937455307032e-08,
   4.315262430182715e-10,  -5.288718969532598e-12,   6.222510359480461e-14,  -7.117802928509782e-16,   7.975701522915944e-18,  -8.797135273635138e-20,   9.581298529307981e-22,
  -4.340804354378680e-05,   8.511375275667036e-07,  -1.251751910811209e-08,   1.636406223184471e-10,  -2.005570494348118e-12,   2.359702157149664e-14,  -2.699244520394358e-16,
   3.024617462312654e-18,  -3.336174063447631e-20,   3.633609140465236e-22,  -4.949101221074279e-06,   9.704119954980358e-08,  -1.427167903903785e-09,   1.865728378363344e-11,
  -2.286629552331164e-13,   2.690393175885089e-15,  -3.077524875119594e-17,   3.448503540190396e-19,  -3.803731871696063e-21,   4.142861981135737e-23,  -1.496006309866953e-03,
   2.933069072708835e-05,  -4.313070855341013e-07,   5.637566445234504e-09,  -6.908076614121038e-11,   8.126087658743546e-13,  -9.293045470996386e-15,   1.041032179839968e-16,
  -1.147905831262448e-18,   1.249810578459881e-20,  -1.383253221571030e-03,   2.712042541965874e-05,  -3.988124648040977e-07,   5.212951801596578e-09,  -6.387943529948324e-11,
   7.514486259274281e-13,  -8.593927865284266e-15,   9.627546396993677e-17,  -1.061640533603942e-18,   1.155944520105398e-20,  -1.174901238445966e-03,   2.303593922468999e-05,
  -3.387592464414773e-07,   4.428150825958333e-09,  -5.426493380402434e-11,   6.383814682543182e-13,  -7.301274887252117e-15,   8.179973072863494e-17,  -9.020823516258616e-19,
   9.822930702589600e-21,  -9.026571532336306e-04,   1.769855222760040e-05,  -2.602775911312254e-07,   3.402399292871149e-09,  -4.169681258367707e-11,   4.905553405605240e-13,
  -5.610919558107353e-15,   6.286635178801890e-17,  -6.933411671001323e-19,   7.550564615606652e-21,  -6.079633541571883e-04,   1.192066442846642e-05,  -1.753114826052757e-07,
   2.291777452759561e-09,  -2.808706216937306e-11,   3.304535918999304e-13,  -3.779881941787848e-15,   4.235326336685370e-17,  -4.671353025549244e-19,   5.087502945600991e-21,
  -3.356897639125750e-04,   6.582120981353644e-06,  -9.680148725519763e-08,   1.265470269310135e-09,  -1.550940809538675e-11,   1.824779343459043e-13,  -2.087327773774755e-15,
   2.338909357573882e-17,  -2.579792818426186e-19,   2.809725293700899e-21,  -1.272960554645869e-04,   2.495999383333044e-06,  -3.670819222770964e-08,   4.798835429959516e-10,
  -5.881426379434910e-12,   6.919933442031192e-14,  -7.915656153303881e-16,   8.869822999702758e-18,  -9.783455173052385e-20,   1.065559467082636e-21,  -1.451346368334311e-05,
   2.845777167488671e-07,  -4.185234574458633e-09,   5.471333045499651e-11,  -6.705644806287979e-13,   7.889699830781034e-15,  -9.024980334352696e-17,   1.011288746192578e-18,
  -1.115458592026082e-20,   1.214898362229975e-22,  -3.271905425009592e-03,   6.414895811336883e-05,  -9.433088507981130e-07,   1.232988397572020e-08,  -1.510860823748397e-10,
   1.777251157754130e-12,  -2.032475366087859e-14,   2.276831925895162e-16,  -2.510562736830080e-18,   2.733381672474429e-20,  -3.025303897429920e-03,   5.931490159744742e-05,
  -8.722400824748301e-07,   1.140121212032896e-08,  -1.397102864174811e-10,   1.643488227438196e-12,  -1.879571849980516e-14,   2.105631825385414e-16,  -2.321893506435825e-18,
   2.528092868829698e-20,  -2.569618664418414e-03,   5.038174907561718e-05,  -7.408980890310796e-07,   9.684779140278497e-09,  -1.186824743894277e-10,   1.396199808262142e-12,
  -1.596856634258183e-14,   1.789034378635792e-16,  -1.972926805498860e-18,   2.148310410735887e-20,  -1.974195440961398e-03,   3.870838556376023e-05,  -5.692513840208512e-07,
   7.441364802934306e-09,  -9.119482038410494e-11,   1.072890280054960e-12,  -1.227160221246062e-14,   1.374944178720201e-16,  -1.516392943796908e-18,   1.651335417757897e-20,
  -1.329672598005843e-03,   2.607160568499408e-05,  -3.834225746213352e-07,   5.012331183116590e-09,  -6.142902612624309e-11,   7.227328241536783e-13,  -8.266952869213765e-15,
   9.263043081358756e-17,  -1.021662473212391e-18,   1.112654870554124e-20,  -7.341848442894739e-04,   1.439571290900381e-05,  -2.117138872992424e-07,   2.767701586609730e-09,
  -3.392052288466176e-11,   3.990962605727853e-13,  -4.565179701709911e-15,   5.115407014789722e-17,  -5.642214242726885e-19,   6.144967943995297e-21,  -2.784083541024259e-04,
   5.458983608065403e-06,  -8.028424244936894e-08,   1.049550096551038e-09,  -1.286322836241829e-11,   1.513453980014124e-13,  -1.731227516859049e-15,   1.939910778279104e-17,
  -2.139720263651430e-19,   2.330415916724033e-21,  -3.174229964673949e-05,   6.223980267488145e-07,  -9.153498630468514e-09,   1.196631601558143e-10,  -1.466587098022123e-12,
   1.725550933394560e-14,  -1.973847017937252e-16,   2.211780255647649e-18,  -2.439597573006163e-20,   2.657025301840900e-22,  -5.125376815022207e-05,   9.669677850687809e-07,
  -1.368272502491744e-08,   1.720974632871591e-10,  -2.029259297822154e-12,   2.296997262279702e-14,  -2.527766385381300e-16,   2.724869933622423e-18,  -2.891346004301719e-20,
   3.029623596548214e-22,  -4.739075461306115e-05,   8.940984288543801e-07,  -1.265182750347529e-08,   1.591344850248567e-10,  -1.876455998515591e-12,   2.124096091104360e-14,
  -2.337573599592531e-16,   2.519942598582357e-18,  -2.674011530730575e-20,   2.802025015681891e-22,  -4.025247337929585e-05,   7.594397267663562e-07,  -1.074665449430505e-08,
   1.351759354735032e-10,  -1.594011807507732e-12,   1.804464697005465e-14,  -1.985928542591846e-16,   2.140997088035727e-18,  -2.272054818303144e-20,   2.381006438744709e-22,
  -3.092525361092774e-05,   5.834768026826849e-07,  -8.256887164421428e-09,   1.038624165093970e-10,  -1.224812880247944e-12,   1.386592887718867e-14,  -1.526123780672715e-16,
   1.645398039371165e-18,  -1.746246864601851e-20,   1.830132130500533e-22,  -2.082894338545752e-05,   3.929932646806296e-07,  -5.561448512524416e-09,   6.995883475171284e-11,
  -8.250285490770107e-13,   9.340407056483823e-15,  -1.028079530349322e-16,   1.108486880599342e-18,  -1.176495717907300e-20,   1.233089870596973e-22,  -1.150078770769962e-05,
   2.169950405045780e-07,  -3.070848750862491e-09,   3.862961048545803e-11,  -4.555703450735589e-13,   5.157775456572608e-15,  -5.677209878200034e-17,   6.121415431916669e-19,
  -6.497198700228464e-21,   6.809989447349621e-23,  -4.361182930306325e-06,   8.228641836313092e-08,  -1.164498565317391e-09,   1.464885179029722e-11,  -1.727595133725076e-13,
   1.955927584424686e-15,  -2.152928711390260e-17,   2.321407896728894e-19,  -2.463946066484944e-21,   2.582601873478239e-23,  -4.972335291854192e-07,   9.381764624475471e-09,
  -1.327686968568061e-10,   1.670170357696730e-12,  -1.969698256707135e-14,   2.230032191796558e-16,  -2.454645233255425e-18,   2.646740443835077e-20,  -2.809260392484512e-22,
   2.944552153589293e-24,  -4.723476845304986e-04,   8.911442236872885e-06,  -1.260981136964303e-07,   1.586026573841641e-09,  -1.870137484649295e-11,   2.116881111174305e-13,
  -2.329554745641204e-15,   2.511202553902368e-17,  -2.664624003763909e-19,   2.792055841274007e-21,  -4.367466825858245e-04,   8.239888262924766e-06,  -1.165975037936907e-07,
   1.466561547411474e-09,  -1.729316063690014e-11,   1.957537767845214e-13,  -2.154275689193797e-15,   2.322344347387839e-17,  -2.464331592172294e-19,   2.582304375049829e-21,
  -3.709612636013289e-04,   6.998892167833194e-06,  -9.903969112960243e-08,   1.245762846876465e-09,  -1.469019378344922e-11,   1.662969867459372e-13,  -1.830204439437614e-15,
   1.973113389958886e-17,  -2.093893908880124e-19,   2.194299926674124e-21,  -2.850028878623407e-04,   5.377242038412027e-06,  -7.609433753449683e-08,   9.571817588756977e-10,
  -1.128770720175098e-11,   1.277864950481422e-13,  -1.406454692809730e-15,   1.516376140844871e-17,  -1.609316657234725e-19,   1.686622385608972e-21,  -1.919566801508442e-04,
   3.621771926385748e-06,  -5.125354529686221e-08,   6.447310080684686e-10,  -7.603349740387279e-12,   8.607990785414544e-14,  -9.474639595223565e-16,   1.021566221300761e-17,
  -1.084241976964329e-19,   1.136397164028276e-21,  -1.059896791995224e-04,   1.999796476163769e-06,  -2.830052012487304e-08,   3.560051821613583e-10,  -4.198473699869012e-12,
   4.753334981516590e-14,  -5.232038564400044e-16,   5.641412036558586e-18,  -5.987727323818857e-20,   6.275984293142346e-22,  -4.019206261881843e-05,   7.583403247193345e-07,
  -1.073185876507087e-08,   1.350018052090522e-10,  -1.592127936201265e-12,   1.802555983024400e-14,  -1.984109498489567e-16,   2.139377501015545e-18,  -2.270738184547103e-20,
   2.380087207335312e-22,  -4.582435880485466e-06,   8.646105363789698e-08,  -1.223578066583017e-09,   1.539206051938157e-11,  -1.815246847580717e-13,   2.055167022372659e-15,
  -2.262167296551595e-17,   2.439199489447307e-19,  -2.588975030713932e-21,   2.713655163839552e-23,  -1.385180997340137e-03,   2.613320833291983e-05,  -3.697884346902413e-07,
   4.651094825310766e-09,  -5.484262948534396e-11,   6.207849801064234e-13,  -6.831524747633693e-15,   7.364214392748322e-17,  -7.814125510473091e-19,   8.187804984949146e-21,
  -1.280779445273573e-03,   2.416384586144797e-05,  -3.419274654691222e-07,   4.300758219732649e-09,  -5.071297748015980e-11,   5.740568224811983e-13,  -6.317510979309427e-15,
   6.810379207176701e-17,  -7.226759301352082e-19,   7.572701102838837e-21,  -1.087860721918428e-03,   2.052456855578608e-05,  -2.904383839015010e-07,   3.653256021198860e-09,
  -4.307965918776215e-11,   4.876734506241580e-13,  -5.367157368313652e-15,   5.786243718228496e-17,  -6.140434694963551e-19,   6.434863862191397e-21,  -8.357838884007192e-04,
   1.576900603865292e-05,  -2.231500943258507e-07,   2.806978898721204e-09,  -3.310171304948313e-11,   3.747396883195811e-13,  -4.124492053311744e-15,   4.446841197886237e-17,
  -4.719390865109330e-19,   4.946081002240872e-21,  -5.629216663181920e-04,   1.062101035620600e-05,  -1.503033450070288e-07,   1.890702908008449e-09,  -2.229716777924995e-11,
   2.524332311252349e-13,  -2.778480950213794e-15,   2.995788863501841e-17,  -3.179586588948156e-19,   3.332525624298591e-21,  -3.108195389743168e-04,   5.864493821077076e-06,
  -8.299255818440930e-08,   1.044001335060597e-09,  -1.231221444481846e-11,   1.393937026539982e-13,  -1.534318992791924e-15,   1.654369437178662e-17,  -1.755926984612628e-19,
   1.840454984369231e-21,  -1.178650456153499e-04,   2.223867379305212e-06,  -3.147166232482795e-08,   3.958989136566861e-10,  -4.668987345257491e-12,   5.286077116188975e-14,
  -5.818490918499520e-16,   6.273820683043234e-18,  -6.659038119230481e-20,   6.979691378266357e-22,  -1.343820095040233e-05,   2.535509592435828e-07,  -3.588198147454117e-09,
   4.513791522361416e-11,  -5.323293667023951e-13,   6.026870437984701e-15,  -6.633907998054879e-17,   7.153062140392692e-19,  -7.592281458971107e-21,   7.957891408116439e-23,
  -3.029520122960541e-03,   5.715576568989143e-05,  -8.087618197728089e-07,   1.017237847822649e-08,  -1.199459491555925e-10,   1.357714681347001e-12,  -1.494118153209658e-14,
   1.610621978850949e-16,  -1.709019728309982e-18,   1.790737295497191e-20,  -2.801184184580422e-03,   5.284858616015406e-05,  -7.478272797653802e-07,   9.406159624260443e-09,
  -1.109140147987322e-10,   1.255515840043962e-12,  -1.381698549584200e-14,   1.489493085973066e-16,  -1.580557430417815e-18,   1.656209193087552e-20,  -2.379252931103405e-03,
   4.488914703147535e-05,  -6.352158527964560e-07,   7.990011883485572e-09,  -9.421923527390201e-11,   1.066587344696252e-12,  -1.173847354257860e-14,   1.265505155007781e-16,
  -1.342968428160513e-18,   1.407355184847165e-20,  -1.827937369353353e-03,   3.448828796012664e-05,  -4.880500833418350e-07,   6.139124832017207e-09,  -7.239653582593321e-11,
   8.195906678595879e-13,  -9.020648642034478e-15,   9.725654018514507e-17,  -1.032173319127053e-18,   1.081746642561103e-20,  -1.231162222869187e-03,   2.322914092964669e-05,
  -3.287274436465938e-07,   4.135143722598954e-09,  -4.876598693019188e-11,   5.520950327049014e-13,  -6.076796870744165e-15,   6.552068007752613e-17,  -6.954042390880249e-19,
   7.288494172303465e-21,  -6.797913411605861e-04,   1.282619533190098e-05,  -1.815124706131817e-07,   2.283328358344037e-09,  -2.692796209097463e-11,   3.048670354555759e-13,
  -3.355698678369984e-15,   3.618259345137476e-17,  -3.840370526568716e-19,   4.025218893673779e-21,  -2.577818553467228e-04,   4.863805516632408e-06,  -6.883146281851059e-08,
   8.658678741414818e-10,  -1.021151108110275e-11,   1.156114393192186e-13,  -1.272558208284822e-15,   1.372142751032280e-17,  -1.456391632599261e-19,   1.526513041249751e-21,
  -2.939059969332979e-05,   5.545396122954347e-07,  -7.847724242296961e-09,   9.872083339875135e-11,  -1.164254007327366e-12,   1.318132805499210e-14,  -1.450897525507704e-16,
   1.564441009532624e-18,  -1.660500358703606e-20,   1.740453028484696e-22  };
  static constexpr double wr[11600] = {   7.969822299145733e-01,  -3.851906924206359e-02,   2.057680660173197e-03,  -1.062144138908925e-04,   5.170023616654569e-06,
  -2.378863398829936e-07,   1.040218720181749e-08,  -4.344646924520072e-10,   1.741054404774456e-11,  -6.732514295508254e-13,   2.520483386480303e-14,  -9.132507168208965e-16,
   3.206576501118817e-17,  -1.092100446531278e-18,   7.971811501132283e-01,  -3.854975583535903e-02,   2.060674909256607e-03,  -1.064449864616028e-04,   5.185223791870406e-06,
  -2.387802515668362e-07,   1.045025128437496e-08,  -4.368699642690889e-10,   1.752384637275155e-11,  -6.783027913728143e-13,   2.541910059323473e-14,  -9.219399447333575e-16,
   3.240335211319998e-17,  -1.104660762778182e-18,   7.975323865800490e-01,  -3.860395686397877e-02,   2.065965396425196e-03,  -1.068525287286514e-04,   5.212100629955896e-06,
  -2.403614889120077e-07,   1.053530718821950e-08,  -4.411282190686764e-10,   1.772451910952790e-11,  -6.872531540603509e-13,   2.579891124773922e-14,  -9.373486057110062e-16,
   3.300221763789344e-17,  -1.126949759390420e-18,   7.979575127763447e-01,  -3.866958960213738e-02,   2.072374812799707e-03,  -1.073465174727020e-04,   5.244695882092429e-06,
  -2.422802309972578e-07,   1.063857838188088e-08,  -4.463014839628126e-10,   1.796845596099361e-11,  -6.981396031280277e-13,   2.626114947037631e-14,  -9.561116807487136e-16,
   3.373183050194442e-17,  -1.154117840259201e-18,   7.983706449621408e-01,  -3.873340150120921e-02,   2.078609660033918e-03,  -1.078273160207720e-04,   5.276439037456416e-06,
  -2.441499415040435e-07,   1.073927422641225e-08,  -4.513489672225552e-10,   1.820661260736244e-11,  -7.087748386405082e-13,   2.671300371073647e-14,  -9.744641437456880e-16,
   3.444587116004816e-17,  -1.180719528790340e-18,   7.987037652026535e-01,  -3.878487697590782e-02,   2.083641485224544e-03,  -1.082155334380392e-04,   5.302082915295523e-06,
  -2.456612063415727e-07,   1.082071115338726e-08,  -4.554333936287172e-10,   1.839943733893665e-11,  -7.173905514899058e-13,   2.707925813596813e-14,  -9.893477068867950e-16,
   3.502523009851441e-17,  -1.202313277330372e-18,   7.989240352517357e-01,  -3.881892509248249e-02,   2.086970894335667e-03,  -1.084724982742306e-04,   5.319063259844609e-06,
  -2.466623017564443e-07,   1.087467916675324e-08,  -4.581412662947083e-10,   1.852732836461519e-11,  -7.231072961547870e-13,   2.732237657245469e-14,  -9.992311925197249e-16,
   3.541009417308069e-17,  -1.216662575406617e-18,   7.990372009208044e-01,  -3.883642096536169e-02,   2.088682088589705e-03,  -1.086045975325090e-04,   5.327794419683169e-06,
  -2.471771798868055e-07,   1.090244263732507e-08,  -4.595346638744525e-10,   1.859315401813712e-11,  -7.260504448393484e-13,   2.744757182739468e-14,  -1.004321934644210e-15,
   3.560837111934580e-17,  -1.224056606194065e-18,   7.990765966673867e-01,  -3.884251224224219e-02,   2.089277905778824e-03,  -1.086505974784274e-04,   5.330835122914044e-06,
  -2.473565102686729e-07,   1.091211366679753e-08,  -4.600200910026665e-10,   1.861608874943077e-11,  -7.270760026723927e-13,   2.749120175548779e-14,  -1.006096221535347e-15,
   3.567748381492475e-17,  -1.226634149697728e-18,   7.990828485811179e-01,  -3.884347892367338e-02,   2.089372464224648e-03,  -1.086578980615318e-04,   5.331317723417279e-06,
  -2.473849733402749e-07,   1.091364869164993e-08,  -4.600971426118118e-10,   1.861972929209257e-11,  -7.272388000555175e-13,   2.749812781653066e-14,  -1.006377890793439e-15,
   3.568845582638493e-17,  -1.227043359590335e-18,   8.689332837003677e-01,  -1.401771526064641e-01,   1.605140231893184e-02,  -1.446678898049880e-03,   1.099122376320359e-04,
  -7.294665175116470e-06,   4.322775584619610e-07,  -2.321366188591688e-08,   1.141761870029900e-09,  -5.185281025199822e-11,   2.188599067783625e-12,  -8.632983044520000e-14,
   3.197952623379905e-15,  -1.116298313842947e-16,   8.705696735086603e-01,  -1.406096653384796e-01,   1.611689616381970e-02,  -1.453930259859692e-03,   1.105583484442656e-04,
  -7.343380652214441e-06,   4.354818910680389e-07,  -2.340131847786141e-08,   1.151691147411517e-09,  -5.233285132469524e-11,   2.209996585402518e-12,  -8.721586157838009e-14,
   3.232256373298711e-15,  -1.128770353269651e-16,   8.734625485382911e-01,  -1.413745718955798e-01,   1.623276569030790e-02,  -1.466763472465526e-03,   1.117021670735922e-04,
  -7.429646543900943e-06,   4.411576034593095e-07,  -2.373378459487362e-08,   1.169286334277417e-09,  -5.318367790937166e-11,   2.247928776877299e-12,  -8.878684648899708e-14,
   3.293089428235857e-15,  -1.150891371357331e-16,   8.769699362611131e-01,  -1.423024628765927e-01,   1.637339694691255e-02,  -1.482346607326927e-03,   1.130916891342050e-04,
  -7.534484567127876e-06,   4.480577053031709e-07,  -2.413810349163033e-08,   1.190690615930641e-09,  -5.421898488292242e-11,   2.294097829199224e-12,  -9.069945099539075e-14,
   3.367168916104662e-15,  -1.177835305339224e-16,   8.803846008606866e-01,  -1.432063487330193e-01,   1.651046603405310e-02,  -1.497542802081032e-03,   1.144473416997991e-04,
  -7.636810548130018e-06,   4.547950609174063e-07,  -2.453302422275878e-08,   1.211604090883788e-09,  -5.523085518961821e-11,   2.339234546457172e-12,  -9.256979842001913e-14,
   3.439630497500882e-15,  -1.204197119344365e-16,   8.831424143474409e-01,  -1.439367380342206e-01,   1.662127990588696e-02,  -1.509833784414414e-03,   1.155442743645802e-04,
  -7.719639199257638e-06,   4.602505275462361e-07,  -2.485290404506047e-08,   1.228548510783870e-09,  -5.605090556889698e-11,   2.375823898969875e-12,  -9.408633006722193e-14,
   3.498397917563959e-15,  -1.225581483336220e-16,   8.849681641811454e-01,  -1.444204607178587e-01,   1.669469650379218e-02,  -1.517979559499963e-03,   1.162714823488467e-04,
  -7.774565419281351e-06,   4.638691237163523e-07,  -2.506512796271401e-08,   1.239792628852086e-09,  -5.659518787288299e-11,   2.400113415656884e-12,  -9.509324470237048e-14,
   3.537423666262306e-15,  -1.239784444405898e-16,   8.859068380061986e-01,  -1.446692144148075e-01,   1.673245914837351e-02,  -1.522170274673313e-03,   1.166456741007517e-04,
  -7.802832936146902e-06,   4.657316980042685e-07,  -2.517437946956421e-08,   1.245581758625967e-09,  -5.687544917788708e-11,   2.412621941079420e-12,  -9.561183708878094e-14,
   3.557525181815111e-15,  -1.247100840475767e-16,   8.862337215277520e-01,  -1.447558494222617e-01,   1.674561229673887e-02,  -1.523630081823253e-03,   1.167760322040753e-04,
  -7.812681310486124e-06,   4.663806617400517e-07,  -2.521244759538032e-08,   1.247599067345903e-09,  -5.697311565672205e-11,   2.416981178990915e-12,  -9.579257601940136e-14,
   3.564531252218230e-15,  -1.249650965678935e-16,   8.862856014899259e-01,  -1.447695997694681e-01,   1.674769997207143e-02,  -1.523861789646269e-03,   1.167967238078147e-04,
  -7.814244568109239e-06,   4.664836755353988e-07,  -2.521849048412596e-08,   1.247919298034734e-09,  -5.698861963259011e-11,   2.417673192739144e-12,  -9.582126810859102e-14,
   3.565643472926453e-15,  -1.250055805797410e-16,   8.565521916157747e-01,  -2.549411896718679e-01,   4.341878381046457e-02,  -5.315707258307266e-03,   5.144981612451585e-04,
  -4.144496794029610e-05,   2.869471605401309e-06,  -1.745591505548555e-07,   9.481214618991016e-09,  -4.654584902681095e-10,   2.085431527096543e-11,  -8.594807762441845e-13,
   3.280016573337524e-14,  -1.164500295986132e-15,   8.612540606160544e-01,  -2.565848867732093e-01,   4.373295644532586e-02,  -5.357708250332375e-03,   5.188543116234803e-04,
  -4.181591728664375e-05,   2.896346519774295e-06,  -1.762565412298034e-07,   9.576345593582452e-09,  -4.702540962863315e-10,   2.107410269171010e-11,  -8.687194670675923e-13,
   3.315897651270234e-14,  -1.177443320434971e-15,   8.695775665175970e-01,  -2.594953779940913e-01,   4.428938794950539e-02,  -5.432110917792890e-03,   5.265723244900325e-04,
  -4.247324310812980e-05,   2.943975135534882e-06,  -1.792650427099000e-07,   9.744974485508412e-09,  -4.787554968033557e-10,   2.146376034790674e-11,  -8.850997584367253e-13,
   3.379519381241495e-14,  -1.200394370455380e-15,   8.796885710642424e-01,  -2.630321499444736e-01,   4.496576879386269e-02,  -5.522577519672802e-03,   5.359589326178210e-04,
  -4.327284336430557e-05,   3.001922951059363e-06,  -1.829259273947860e-07,   9.950197565490266e-09,  -4.891030225920789e-10,   2.193808545517592e-11,  -9.050412546798692e-13,
   3.456980183691017e-14,  -1.228340176816985e-15,   8.895526247942739e-01,  -2.664838432623002e-01,   4.562610553308528e-02,  -5.610924437812497e-03,   5.451279491968267e-04,
  -4.405407981123647e-05,   3.058550671452674e-06,  -1.865040036069839e-07,   1.015080745869399e-08,  -4.992192416782994e-10,   2.240186123149975e-11,  -9.245413179512476e-13,
   3.532733835027767e-14,  -1.255672621051383e-15,   8.975338140301615e-01,  -2.692776066016194e-01,   4.616073732202967e-02,  -5.682472000206382e-03,   5.525551359235620e-04,
  -4.468702856218310e-05,   3.104437498736455e-06,  -1.894038285616282e-07,   1.031341096176547e-08,  -5.074198279680689e-10,   2.277785370825284e-11,  -9.403519079007086e-13,
   3.594160069988639e-14,  -1.277837448377076e-15,   9.028247429251536e-01,  -2.711301191476422e-01,   4.651532503498408e-02,  -5.729934210454545e-03,   5.574828995647392e-04,
  -4.510703541705914e-05,   3.134890466897260e-06,  -1.913285151544602e-07,   1.042134513170468e-08,  -5.128637285753844e-10,   2.302747245260141e-11,  -9.508491766910804e-13,
   3.634945998537164e-14,  -1.292555387853607e-15,   9.055471863264173e-01,  -2.720834694488034e-01,   4.669782950705217e-02,  -5.754365610750990e-03,   5.600197434813648e-04,
  -4.532327622900703e-05,   3.150570363345682e-06,  -1.923195788791438e-07,   1.047692596042723e-08,  -5.156672120123775e-10,   2.315602617678824e-11,  -9.562554987747038e-13,
   3.655952459203018e-14,  -1.300136017256222e-15,   9.064956020225173e-01,  -2.724156099270599e-01,   4.676141668045292e-02,  -5.762878313448106e-03,   5.609037036777846e-04,
  -4.539862804226405e-05,   3.156034404643842e-06,  -1.926649493059154e-07,   1.049629552122484e-08,  -5.166442302691673e-10,   2.320082827200102e-11,  -9.581396851337418e-13,
   3.663273664015198e-14,  -1.302778073837048e-15,   9.066461426324139e-01,  -2.724683311582450e-01,   4.677151016781501e-02,  -5.764229595771596e-03,   5.610440229346167e-04,
  -4.541058947991433e-05,   3.156901781945366e-06,  -1.927197748624636e-07,   1.049937035058963e-08,  -5.167993285179862e-10,   2.320794049268564e-11,  -9.584387967153848e-13,
   3.664435899796721e-14,  -1.303197500412828e-15,   5.016769849187354e-01,  -1.929815509624347e-01,   4.003269537812992e-02,  -5.713961452817359e-03,   6.238123652866839e-04,
  -5.526145651783120e-05,   4.124681292776717e-06,  -2.662428387642780e-07,   1.514905288574290e-08,  -7.710081899419919e-10,   3.550616140493978e-11,  -1.493345950392629e-12,
   5.780249679712405e-14,  -2.069992799330621e-15,   5.062075931381035e-01,  -1.947892148892107e-01,   4.041952937268906e-02,  -5.770603555652382e-03,   6.301284557089424e-04,
  -5.583101454780314e-05,   4.167840552879710e-06,  -2.690651685186607e-07,   1.531146026109607e-08,  -7.793551240178468e-10,   3.589381664540918e-11,  -1.509768339901103e-12,
   5.844197878857512e-14,  -2.093003757696164e-15,   5.142358281991614e-01,  -1.979926766801873e-01,   4.110511603674287e-02,  -5.870997734555464e-03,   6.413239918668806e-04,
  -5.684063581256103e-05,   4.244350079964876e-06,  -2.740685973355955e-07,   1.559938687201902e-08,  -7.941535953299851e-10,   3.658111780702379e-11,  -1.538885368779000e-12,
   5.957580421866941e-14,  -2.133803555699783e-15,   5.240016477177020e-01,  -2.018899590719395e-01,   4.193928689249066e-02,  -5.993162307509198e-03,   6.549484761708428e-04,
  -5.806939636754996e-05,   4.337472395592881e-06,  -2.801588013481623e-07,   1.594987109799829e-08,  -8.121681235115082e-10,   3.741781690240907e-11,  -1.574332598325342e-12,
   6.095616139548196e-14,  -2.183475472267915e-15,   5.335430951811004e-01,  -2.056982053970534e-01,   4.275450181279319e-02,  -6.112563774100589e-03,   6.682660662767312e-04,
  -5.927057844234938e-05,   4.428511282680245e-06,  -2.861131290487660e-07,   1.629255486686907e-08,  -8.297825575430172e-10,   3.823596595594525e-11,  -1.608995057383715e-12,
   6.230599210730723e-14,  -2.232049812975144e-15,   5.412734008754483e-01,  -2.087839384387158e-01,   4.341512397035258e-02,  -6.209331930741580e-03,   6.790601271429377e-04,
  -6.024422176870432e-05,   4.502309506763820e-06,  -2.909401168219111e-07,   1.657037156987411e-08,  -8.440633344760055e-10,   3.889929785118781e-11,  -1.637099186064314e-12,
   6.340045126471862e-14,  -2.271435134234146e-15,   5.464029801468552e-01,  -2.108317074795141e-01,   4.385356473743561e-02,  -6.273559439219188e-03,   6.862248651874713e-04,
  -6.089052869843523e-05,   4.551299278561630e-06,  -2.941445687477755e-07,   1.675481009976226e-08,  -8.535444325010007e-10,   3.933969952168197e-11,  -1.655758568634364e-12,
   6.412711535832557e-14,  -2.297585264753279e-15,   5.490439372699430e-01,  -2.118860533796831e-01,   4.407931807543092e-02,  -6.306631619132337e-03,   6.899142858572902e-04,
  -6.122334972592868e-05,   4.576527678939081e-06,  -2.957948155289462e-07,   1.684979536253787e-08,  -8.584272592410956e-10,   3.956651276008916e-11,  -1.665368541224371e-12,
   6.450136619414382e-14,  -2.311053358673624e-15,   5.499642101427896e-01,  -2.122534614349429e-01,   4.415798811704168e-02,  -6.318156765934116e-03,   6.912000140818794e-04,
  -6.133933642501200e-05,   4.585319782333336e-06,  -2.963699334666211e-07,   1.688289845433075e-08,  -8.601289762587799e-10,   3.964556014640985e-11,  -1.668717761766947e-12,
   6.463179883649074e-14,  -2.315747229241980e-15,   5.501102952895899e-01,  -2.123117846143725e-01,   4.417047645890722e-02,  -6.319986316383828e-03,   6.914041170408439e-04,
  -6.135774881794580e-05,   4.586715496602392e-06,  -2.964612316474308e-07,   1.688815348261257e-08,  -8.603991200227983e-10,   3.965810876855765e-11,  -1.669249445062683e-12,
   6.465250483292691e-14,  -2.316492375266807e-15,   6.693555978565388e-01,  -2.603988643690498e-02,   1.157276848181095e-03,  -5.122601785778783e-05,   2.174049330136139e-06,
  -8.823914135743185e-08,   3.430291264922732e-09,  -1.284856282343274e-10,   4.637715065440119e-12,  -1.612757769563905e-13,   5.473990766652175e-15,  -1.815871022797603e-16,
   5.840744354628198e-18,  -1.827742179388324e-19,   6.694666045068953e-01,  -2.605459339611383e-02,   1.158527911643717e-03,  -5.131095462359122e-05,   2.179023925830718e-06,
  -8.850122924317264e-08,   3.442971902488723e-09,  -1.290560406449630e-10,   4.662060715447042e-12,  -1.622686148891224e-13,   5.512557115867479e-15,  -1.830241224370130e-16,
   5.892488973829154e-18,  -1.845718816708961e-19,   6.696625762448897e-01,  -2.608056386724737e-02,   1.160737743618065e-03,  -5.146102948374481e-05,   2.187816376935740e-06,
  -8.896461342221199e-08,   3.465399810341338e-09,  -1.300653085102461e-10,   4.705153429454339e-12,  -1.640266212175649e-13,   5.580873090242101e-15,  -1.855706711972355e-16,
   5.984220363977843e-18,  -1.877598897233403e-19,   6.698997158806221e-01,  -2.611200144909585e-02,   1.163413840867608e-03,  -5.164284754955916e-05,   2.198473407144041e-06,
  -8.952652446604903e-08,   3.492609972596441e-09,  -1.312904542297811e-10,   4.757491446123245e-12,  -1.661629019568995e-13,   5.663934907467871e-15,  -1.886686435087209e-16,
   6.095874112328255e-18,  -1.916422574645354e-19,   6.701301035651690e-01,  -2.614255595717024e-02,   1.166015886714660e-03,  -5.181971627386842e-05,   2.208845410116215e-06,
  -9.007367849925109e-08,   3.519119729345228e-09,  -1.324847707413083e-10,   4.808541785053421e-12,  -1.682477821141465e-13,   5.745046594299285e-15,  -1.916957246840645e-16,
   6.205034857005312e-18,  -1.954400200448982e-19,   6.703158275580093e-01,  -2.616719569912210e-02,   1.168115029357045e-03,  -5.196245987251979e-05,   2.217219872905063e-06,
  -9.051565120009223e-08,   3.540543606384703e-09,  -1.334504654230241e-10,   4.849840876261564e-12,  -1.699352558750393e-13,   5.810732024384409e-15,  -1.941484216615234e-16,
   6.293526982381294e-18,  -1.985202018993877e-19,   6.704386127313926e-01,  -2.618348966355650e-02,   1.169503560510675e-03,  -5.205691000399636e-05,   2.222762843852056e-06,
  -9.080828390120553e-08,   3.554733471199758e-09,  -1.340903309197968e-10,   4.877215810600390e-12,  -1.710541986050258e-13,   5.854304229676489e-15,  -1.957760577223870e-16,
   6.352273098803585e-18,  -2.005657329170478e-19,   6.705016879977996e-01,  -2.619186125041818e-02,   1.170217088061609e-03,  -5.210545419772397e-05,   2.225612296329787e-06,
  -9.095874595536954e-08,   3.562030974587815e-09,  -1.344194750936014e-10,   4.891300556775542e-12,  -1.716300347709940e-13,   5.876732851077826e-15,  -1.966140774008232e-16,
   6.382526405708397e-18,  -2.016193745262452e-19,   6.705236449802116e-01,  -2.619477567207341e-02,   1.170465509591151e-03,  -5.212235674584481e-05,   2.226604531823925e-06,
  -9.101114451347121e-08,   3.564572583218429e-09,  -1.345341232051475e-10,   4.896207090168634e-12,  -1.718306519653413e-13,   5.884547660300581e-15,  -1.969061006763286e-16,
   6.393069796622205e-18,  -2.019866085447952e-19,   6.705271293961296e-01,  -2.619523817981386e-02,   1.170504934072540e-03,  -5.212503924645090e-05,   2.226762007654767e-06,
  -9.101946081361393e-08,   3.564975979661473e-09,  -1.345523203880310e-10,   4.896985889324307e-12,  -1.718624962772802e-13,   5.885788158186627e-15,  -1.969524570339696e-16,
   6.394743526479699e-18,  -2.020449074872631e-19,   4.862492575506351e-01,  -5.959342779582339e-02,   5.790762413711027e-03,  -4.555986945551049e-04,   3.086046828150148e-05,
  -1.855982301540982e-06,   1.009863148516432e-07,  -5.034257801504618e-09,   2.320363767952097e-10,  -9.955249192706299e-12,   3.996017958080678e-13,  -1.507137816749167e-14,
   5.361204290394875e-16,  -1.802832842402910e-17,   4.868287152594235e-01,  -5.972802604572353e-02,   5.808970780124624e-03,  -4.574274122807020e-04,   3.101018670116228e-05,
  -1.866467793463406e-06,   1.016329776270327e-07,  -5.070050919630815e-09,   2.338381341096108e-10,  -1.003856108459743e-11,   4.031684651505513e-13,  -1.521365868645669e-14,
   5.414386035781003e-16,  -1.821533478504593e-17,   4.878526686748142e-01,  -5.996596058748218e-02,   5.841170036248563e-03,  -4.606623844014094e-04,   3.127512146762079e-05,
  -1.885027991520170e-06,   1.027779404751407e-07,  -5.133441195873438e-09,   2.370298178305407e-10,  -1.018617349707427e-11,   4.094891513902445e-13,  -1.546584843522535e-14,
   5.508666612559652e-16,  -1.854691745357684e-17,   4.890933906654999e-01,  -6.025441459560435e-02,   5.880225842679841e-03,  -4.645881104279074e-04,   3.159677260848841e-05,
  -1.907570987187062e-06,   1.041691376756236e-07,  -5.210491418367748e-09,   2.409105367065892e-10,  -1.036570673597453e-11,   4.171787960889190e-13,  -1.577273836263766e-14,
   5.623425530308015e-16,  -1.895062085596117e-17,   4.903005339735632e-01,  -6.053521844304467e-02,   5.918266643875944e-03,  -4.684137991269705e-04,   3.191037998002703e-05,
  -1.929560183750172e-06,   1.055267232849588e-07,  -5.285708723504267e-09,   2.447002602039728e-10,  -1.054108645576074e-11,   4.246927688931323e-13,  -1.607270116994942e-14,
   5.735624318782030e-16,  -1.934542183536861e-17,   4.912749109321928e-01,  -6.076198878536392e-02,   5.949002388025239e-03,  -4.715062574096201e-04,   3.216399096024847e-05,
  -1.947349750586931e-06,   1.066254341360719e-07,  -5.346603548587908e-09,   2.477693121789827e-10,  -1.068315543782822e-11,   4.307811739338387e-13,  -1.631581450298306e-14,
   5.826580664160994e-16,  -1.966555005709140e-17,   4.919197024389448e-01,  -6.091210848873933e-02,   5.969356453951963e-03,  -4.735548674496924e-04,   3.233205010400668e-05,
  -1.959141770364862e-06,   1.073539257417866e-07,  -5.386989438047256e-09,   2.498051937258384e-10,  -1.077741782799979e-11,   4.348215972000839e-13,  -1.647718026522518e-14,
   5.886963284874554e-16,  -1.987810800610089e-17,   4.922511249220084e-01,  -6.098928694957407e-02,   5.979823001151460e-03,  -4.746085276185507e-04,   3.241850443809912e-05,
  -1.965208996729926e-06,   1.077288103836264e-07,  -5.407775284389983e-09,   2.508531665832742e-10,  -1.082594562578638e-11,   4.369019142854094e-13,  -1.656027273793121e-14,
   5.918059539828788e-16,  -1.998758381660887e-17,   4.923665259383093e-01,  -6.101616313078909e-02,   5.983468171118240e-03,  -4.749755187693739e-04,   3.244861923191993e-05,
  -1.967322576672551e-06,   1.078594150254066e-07,  -5.415017281607674e-09,   2.512183136703335e-10,  -1.084285522567735e-11,   4.376268431070375e-13,  -1.658922945094252e-14,
   5.928896727716478e-16,  -2.002573843298897e-17,   4.923848406929240e-01,  -6.102042865220808e-02,   5.984046713502603e-03,  -4.750337673245689e-04,   3.245339915438756e-05,
  -1.967658059434933e-06,   1.078801460065901e-07,  -5.416166833215104e-09,   2.512762760333467e-10,  -1.084553945138626e-11,   4.377419199578448e-13,  -1.659382617428579e-14,
   5.930617098137586e-16,  -2.003179544670261e-17,   2.649072405761160e-01,  -6.778152322967608e-02,   1.039217388885182e-02,  -1.171631859215852e-03,   1.061255867645048e-04,
  -8.096115855738553e-06,   5.357508214909942e-07,  -3.137755520301940e-08,   1.650476951574172e-09,  -7.884737166362672e-11,   3.451303584688080e-12,  -1.394151169611636e-13,
   5.228272295290872e-15,  -1.827676300753855e-16,   2.660106955317518e-01,  -6.813988885370084e-02,   1.045646708837215e-02,  -1.179784699028230e-03,   1.069346140159119e-04,
  -8.162494908869690e-06,   5.404110067818848e-07,  -3.166411717530989e-08,   1.666173970763350e-09,  -7.962319706619321e-11,   3.486252575096150e-12,  -1.408618224833645e-13,
   5.283679989225584e-15,  -1.847405397372961e-16,   2.679632224790546e-01,  -6.877419453362478e-02,   1.057029673443949e-02,  -1.194222543976991e-03,   1.083676137105194e-04,
  -8.280090651602915e-06,   5.486681733017320e-07,  -3.217193136768258e-08,   1.693993785627358e-09,  -8.099833199592301e-11,   3.548204508693229e-12,  -1.434265137499683e-13,
   5.381912834726477e-15,  -1.882385694772246e-16,   2.703335767976442e-01,  -6.954456091845264e-02,   1.070859605312682e-02,  -1.211769907527038e-03,   1.101097465016088e-04,
  -8.423090539953436e-06,   5.587113156957547e-07,  -3.278969934502951e-08,   1.727842800230045e-09,  -8.267172990680716e-11,   3.623603123705601e-12,  -1.465482219958007e-13,
   5.501492797523821e-15,  -1.924971688477371e-16,   2.726444829900325e-01,  -7.029594583473266e-02,   1.084354311099598e-02,  -1.228898070004153e-03,   1.118107884582247e-04,
  -8.562755146540200e-06,   5.685225044769479e-07,  -3.339332171582905e-08,   1.760922560311934e-09,  -8.430734888387023e-11,   3.697309459151416e-12,  -1.496002322953108e-13,
   5.618415751990288e-15,  -1.966615718903819e-16,   2.745131661234357e-01,  -7.090378626830177e-02,   1.095274958850690e-02,  -1.242763503388454e-03,   1.131881789247296e-04,
  -8.675873178325083e-06,   5.764704844178136e-07,  -3.388239981602684e-08,   1.787729225312837e-09,  -8.563297624926013e-11,   3.757053678563223e-12,  -1.520743664799765e-13,
   5.713209391759210e-15,  -2.000381096589155e-16,   2.757514173339519e-01,  -7.130668049827511e-02,   1.102515423594707e-02,  -1.251958533349904e-03,   1.141017974072605e-04,
  -8.750917176405739e-06,   5.817440824733227e-07,  -3.420695297122629e-08,   1.805520219667517e-09,  -8.651285396674879e-11,   3.796712053416920e-12,  -1.537168322603479e-13,
   5.776143107512269e-15,  -2.022799509926433e-16,   2.763883899617482e-01,  -7.151397138139771e-02,   1.106241275984385e-02,  -1.256690845865542e-03,   1.145720574306015e-04,
  -8.789548089970799e-06,   5.844590569582353e-07,  -3.437405395107150e-08,   1.814680806326809e-09,  -8.696593037748608e-11,   3.817134461662967e-12,  -1.545626734198522e-13,
   5.808554263797881e-15,  -2.034345561219910e-16,   2.766102648398630e-01,  -7.158618229028953e-02,   1.107539292612138e-02,  -1.258339600096069e-03,   1.147359067856567e-04,
  -8.803008633144052e-06,   5.854051013045845e-07,  -3.443228310274215e-08,   1.817873067453105e-09,  -8.712382177744642e-11,   3.824251584111852e-12,  -1.548574518041849e-13,
   5.819849878453690e-15,  -2.038369550344521e-16,   2.766454814351886e-01,  -7.159764408397806e-02,   1.107745326947336e-02,  -1.258601312079419e-03,   1.147619155457519e-04,
  -8.805145334158311e-06,   5.855552764591959e-07,  -3.444152650295734e-08,   1.818379817486686e-09,  -8.714888618309618e-11,   3.825381396936959e-12,  -1.549042469158162e-13,
   5.821643031135260e-15,  -2.039008352810043e-16,   9.719256163486904e-02,  -3.585077251359778e-02,   7.186702588448318e-03,  -9.978516607727843e-04,   1.065060579836116e-04,
  -9.259413869449837e-06,   6.802465353886805e-07,  -4.331825324321847e-08,   2.436113799914562e-09,  -1.227281626082571e-10,   5.601578673722334e-12,  -2.337591820260793e-13,
   8.986742082146154e-15,  -3.199747952762866e-16,   9.799861359726919e-02,  -3.616493793412923e-02,   7.252525330663159e-03,  -1.007317326469036e-03,   1.075454447937079e-04,
  -9.351910854974918e-06,   6.871758928375494e-07,  -4.376688546731818e-08,   2.461704949717978e-09,  -1.240333956956499e-10,   5.661797074989273e-12,  -2.362959609954231e-13,
   9.085071788743169e-15,  -3.235005316772262e-16,   9.942664883554690e-02,  -3.672159152286676e-02,   7.369165748863930e-03,  -1.024092396845603e-03,   1.093875943568276e-04,
  -9.515858477386285e-06,   6.994586692281388e-07,  -4.456215971007053e-08,   2.507071572417659e-09,  -1.263473382844778e-10,   5.768557280342750e-12,  -2.407935142201904e-13,
   9.259408824890648e-15,  -3.297517343837439e-16,   1.011632675896798e-01,  -3.739864314965821e-02,   7.511055503237200e-03,  -1.044501436476832e-03,   1.116290569874630e-04,
  -9.715363403382708e-06,   7.144066169446736e-07,  -4.553006758445712e-08,   2.562289726673116e-09,  -1.291639245337863e-10,   5.898514931508651e-12,  -2.462685592317035e-13,
   9.471643715149799e-15,  -3.373620570573011e-16,   1.028594716158885e-01,  -3.806005466695130e-02,   7.649689873031433e-03,  -1.064444999683963e-03,   1.138196594616581e-04,
  -9.910361600566987e-06,   7.290182142714465e-07,  -4.647627105340994e-08,   2.616273440890716e-09,  -1.319177141843329e-10,   6.025582028653852e-12,  -2.516220766941987e-13,
   9.679175758933135e-15,  -3.448039717622388e-16,   1.042333357462105e-01,  -3.859585746780349e-02,   7.762012164737923e-03,  -1.080605363025092e-03,   1.155949024819043e-04,
  -1.006840069464852e-05,   7.408613373067826e-07,  -4.724325006313953e-08,   2.660034572255489e-09,  -1.341501565501347e-10,   6.128597725585333e-12,  -2.559624534391602e-13,
   9.847438611382229e-15,  -3.508378904518602e-16,   1.051448065845924e-01,  -3.895136907155285e-02,   7.836547180272189e-03,  -1.091330055176071e-03,   1.167731196700178e-04,
  -1.017329727770228e-05,   7.487225323258200e-07,  -4.775237951304301e-08,   2.689085035806920e-09,  -1.356322045196072e-10,   6.196989007308542e-12,  -2.588440817407112e-13,
   9.959153161322950e-15,  -3.548440620610128e-16,   1.056140203049025e-01,  -3.913439457307008e-02,   7.874921928455242e-03,  -1.096852019945850e-03,   1.173797923736623e-04,
  -1.022731148549543e-05,   7.527706260254850e-07,  -4.801456198621689e-08,   2.704045338394434e-09,  -1.363954426539550e-10,   6.232210498887470e-12,  -2.603281465865921e-13,
   1.001668804391506e-14,  -3.569073327012241e-16,   1.057775145135153e-01,  -3.919817052207740e-02,   7.888294143725414e-03,  -1.098776273202964e-03,   1.175912056831224e-04,
  -1.024613470480595e-05,   7.541813545290413e-07,  -4.810593178786694e-08,   2.709259023835934e-09,  -1.366614350967147e-10,   6.244485489831346e-12,  -2.608453601768623e-13,
   1.003673974776795e-14,  -3.576264150082871e-16,   1.058034673457113e-01,  -3.920829431835244e-02,   7.890416867884865e-03,  -1.099081734123374e-03,   1.176247661908146e-04,
  -1.024912278671254e-05,   7.544053009507786e-07,  -4.812043636942714e-08,   2.710086678121724e-09,  -1.367036606036894e-10,   6.246434113667509e-12,  -2.609274667333333e-13,
   1.003992291964471e-14,  -3.577405682145376e-16,   5.805077350968738e-01,  -1.875928896147444e-02,   7.047843335175984e-04,  -2.706429151521173e-05,   1.009511949905722e-06,
  -3.647954042130183e-08,   1.267772804651876e-09,  -4.250350607172052e-11,   1.407159660164218e-12,  -4.449825356342352e-14,   1.347747096003866e-15,  -4.104068411167606e-17,
   1.227566578477318e-18,  -3.522768066861507e-20,   5.805749694509981e-01,  -1.876702396334523e-02,   7.053625270725452e-04,  -2.709921804155836e-05,   1.011340090290265e-06,
  -3.656571396226767e-08,   1.271590185637046e-09,  -4.265952708396101e-11,   1.413105371589026e-12,  -4.472062201604335e-14,   1.355764501571645e-15,  -4.131448477664383e-17,
   1.236574473552571e-18,  -3.551795063139805e-20,   5.806936508436926e-01,  -1.878068060967217e-02,   7.063836055036854e-04,  -2.716091290240785e-05,   1.014570286141605e-06,
  -3.671802115856549e-08,   1.278338862283075e-09,  -4.293544673974945e-11,   1.423624545641913e-12,  -4.511415919770926e-14,   1.369957379369306e-15,  -4.179936654175007e-17,
   1.252534413718809e-18,  -3.603238839921043e-20,   5.808372389674504e-01,  -1.879720821773394e-02,   7.076197497320403e-04,  -2.723562843319894e-05,   1.018483808832621e-06,
  -3.690262408310408e-08,   1.286521381955978e-09,  -4.327014789950446e-11,   1.436392077780563e-12,  -4.559201930579753e-14,   1.387198287435636e-15,  -4.238869446878177e-17,
   1.271945159205647e-18,  -3.665830598650042e-20,   5.809767128556563e-01,  -1.881326744590716e-02,   7.088212924257701e-04,  -2.730827994708910e-05,   1.022290892864393e-06,
  -3.708228607655064e-08,   1.294487866476647e-09,  -4.359617882094536e-11,   1.448836599005957e-12,  -4.605800882613543e-14,   1.404018197197187e-15,  -4.296396115227063e-17,
   1.290906325278967e-18,  -3.726999011570757e-20,   5.810891293006677e-01,  -1.882621495892615e-02,   7.097903265482012e-04,  -2.736689242381243e-05,   1.025363502579532e-06,
  -3.722734439624779e-08,   1.300922105203646e-09,  -4.385962155945791e-11,   1.458897682789221e-12,  -4.643490686385866e-14,   1.417627582454605e-15,  -4.342965912509116e-17,
   1.306265742805907e-18,  -3.776567267671179e-20,   5.811634405463204e-01,  -1.883477554461183e-02,   7.104311797462264e-04,  -2.740566434841718e-05,   1.027396609375853e-06,
  -3.732335570581068e-08,   1.305181850148605e-09,  -4.403409060716732e-11,   1.465563504501004e-12,  -4.668469211498788e-14,   1.426649630273062e-15,  -4.373849920085968e-17,
   1.316456500901893e-18,  -3.809464476091684e-20,   5.812016117321670e-01,  -1.883917339293657e-02,   7.107604533824351e-04,  -2.742558853793381e-05,   1.028441567848191e-06,
  -3.737271144287718e-08,   1.307371945724407e-09,  -4.412380983557842e-11,   1.468992185760732e-12,  -4.681319734446639e-14,   1.431291934276491e-15,  -4.389744895407739e-17,
   1.321702813955149e-18,  -3.826403222935816e-20,   5.812148989651353e-01,  -1.884070435560817e-02,   7.108750863418121e-04,  -2.743252539730653e-05,   1.028805412333217e-06,
  -3.738989801819757e-08,   1.308134628860654e-09,  -4.415505671724654e-11,   1.470186440126951e-12,  -4.685796118750888e-14,   1.432909173174256e-15,  -4.395282795549828e-17,
   1.323530892864735e-18,  -3.832305996393722e-20,   5.812170075325848e-01,  -1.884094731023033e-02,   7.108932782603157e-04,  -2.743362627929719e-05,   1.028863155952967e-06,
  -3.739262566419420e-08,   1.308255675180557e-09,  -4.416001608274643e-11,   1.470375993186030e-12,  -4.686506632264783e-14,   1.433165875225450e-15,  -4.396161845666760e-17,
   1.323821081258066e-18,  -3.833243021916272e-20,   3.148797793523611e-01,  -2.889618847606795e-02,   2.385719992647550e-03,  -1.632995295373560e-04,   9.809075110775764e-06,
  -5.310080443734345e-07,   2.633800081789631e-08,  -1.209585972293585e-09,   5.181221251790497e-11,  -2.083780768920210e-12,   7.900562988799570e-14,  -2.831500354186328e-15,
   9.623194784501968e-17,  -3.106790112189317e-18,   3.151149631031838e-01,  -2.894394909659691e-02,   2.391457234488666e-03,  -1.638184936070480e-04,   9.847820093914928e-06,
  -5.335087179195410e-07,   2.648138193612401e-08,  -1.217028146789539e-09,   5.216619298280916e-11,  -2.099339616892088e-12,   7.964221569189199e-14,  -2.855883450126301e-15,
   9.711007082474579e-17,  -3.136609254647313e-18,   3.155304124725119e-01,  -2.902834585354528e-02,   2.401598813430438e-03,  -1.647361570055723e-04,   9.916353081750760e-06,
  -5.379333113147395e-07,   2.673514827298764e-08,  -1.230203384016159e-09,   5.279301699130209e-11,  -2.126897387121935e-12,   8.076997403384666e-14,  -2.899088327880767e-15,
   9.866631631565583e-17,  -3.189465160272502e-18,   3.160335703676817e-01,  -2.913060831519557e-02,   2.413893077918432e-03,  -1.658491250304625e-04,   9.999509015603788e-06,
  -5.433042831818361e-07,   2.704331819220081e-08,  -1.246209225227023e-09,   5.355477507209317e-11,  -2.160398284079716e-12,   8.214135545699548e-14,  -2.951640917498308e-15,
   1.005597501597617e-16,  -3.253788959763701e-18,   3.165228581042254e-01,  -2.923010220982162e-02,   2.425860625241984e-03,  -1.669330596432830e-04,   1.008053470413921e-05,
  -5.485400747070803e-07,   2.734386332495865e-08,  -1.261825376620250e-09,   5.429826518689862e-11,  -2.193107179282874e-12,   8.348074559422792e-14,  -3.002982684947489e-15,
   1.024100649606971e-16,  -3.316664404099736e-18,   3.169176181006317e-01,  -2.931041058597654e-02,   2.435524851667818e-03,  -1.678087657290354e-04,   1.014602297764745e-05,
  -5.527735840315131e-07,   2.758696966916219e-08,  -1.274461580082367e-09,   5.490007858181441e-11,  -2.219591357943945e-12,   8.456554920942923e-14,  -3.044576428369671e-15,
   1.039094319687709e-16,  -3.367626135042120e-18,   3.171787607413437e-01,  -2.936355410689669e-02,   2.441922240843357e-03,  -1.683886443302743e-04,   1.018940197070681e-05,
  -5.555786789952046e-07,   2.774809647650065e-08,  -1.282838866651029e-09,   5.529915402162241e-11,  -2.237157588653181e-12,   8.528522066920827e-14,  -3.072175513634402e-15,
   1.049044987347306e-16,  -3.401453082196770e-18,   3.173129604484103e-01,  -2.939086973982744e-02,   2.445211148539077e-03,  -1.686868198925616e-04,   1.021171183632924e-05,
  -5.570216044576283e-07,   2.783099350197008e-08,  -1.287149526795285e-09,   5.550453458455264e-11,  -2.246199127430365e-12,   8.565569042298022e-14,  -3.086384507607564e-15,
   1.054168495884907e-16,  -3.418872061575644e-18,   3.173596842947773e-01,  -2.940038100186050e-02,   2.446356447283540e-03,  -1.687906631933997e-04,   1.021948219584086e-05,
  -5.575242063136742e-07,   2.785987058534724e-08,  -1.288651249726013e-09,   5.557608869285342e-11,  -2.249349375330844e-12,   8.578477671569876e-14,  -3.091335743466003e-15,
   1.055953910288716e-16,  -3.424942424701425e-18,   3.173670994099065e-01,  -2.940189048887384e-02,   2.446538217217736e-03,  -1.688071445712480e-04,   1.022071549213428e-05,
  -5.576039802785999e-07,   2.786445412128670e-08,  -1.288889616978640e-09,   5.558744664634572e-11,  -2.249849431006025e-12,   8.580526762496452e-14,  -3.092121705500500e-15,
   1.056237332153772e-16,  -3.425906065296206e-18,   9.985829061508519e-02,  -2.092386618656792e-02,   2.824427874491859e-03,  -2.878677458164659e-04,   2.403890654804050e-05,
  -1.714878793702419e-06,   1.072956326571551e-07,  -5.994229730688576e-09,   3.029128145766175e-10,  -1.398482832203018e-11,   5.945088437711588e-13,  -2.342022444358524e-14,
   8.595444403034680e-16,  -2.949307485364261e-17,   1.001520854806397e-01,  -2.101089233975712e-02,   2.838864406828348e-03,  -2.895823176573022e-04,   2.419994775702576e-05,
  -1.727492900246159e-06,   1.081469981480399e-07,  -6.044852104089866e-09,   3.056072102452001e-10,  -1.411475513029505e-11,   6.002388062564987e-13,  -2.365309497510283e-14,
   8.683206178719438e-16,  -2.980110060029793e-17,   1.006717032434604e-01,  -2.116486231526759e-02,   2.864413968795209e-03,  -2.926175746167601e-04,   2.448510322927628e-05,
  -1.749833420640258e-06,   1.096551102980262e-07,  -6.134539388453071e-09,   3.103815320250418e-10,  -1.434500704255563e-11,   6.103943585655093e-13,  -2.406586452251137e-14,
   8.838779422958025e-16,  -3.034717151250847e-17,   1.013021017441438e-01,  -2.135174679378694e-02,   2.895438804895400e-03,  -2.963047095862366e-04,   2.483161873806858e-05,
  -1.776989283788672e-06,   1.114887644579041e-07,  -6.243611574726643e-09,   3.161889324093359e-10,  -1.462513040537214e-11,   6.227514422758077e-13,  -2.456818177829396e-14,
   9.028125544315410e-16,  -3.101185696402270e-17,   1.019162562330523e-01,  -2.153390856416699e-02,   2.925693758407918e-03,  -2.999018387208952e-04,   2.516979877414639e-05,
  -1.803500385555971e-06,   1.132793841829504e-07,  -6.350150068836707e-09,   3.218626479592662e-10,  -1.489885676879223e-11,   6.348283134646566e-13,  -2.505917866074320e-14,
   9.213227833812405e-16,  -3.166171795883119e-17,   1.024125731412466e-01,  -2.168118563539201e-02,   2.950164904514217e-03,  -3.028123770306188e-04,   2.544351808871766e-05,
  -1.824964263972572e-06,   1.147294628222840e-07,  -6.436445749774020e-09,   3.264592039313069e-10,  -1.512065276556942e-11,   6.446154223849149e-13,  -2.545713342531740e-14,
   9.363270634884716e-16,  -3.218854383845507e-17,   1.027412969423287e-01,  -2.177876375421308e-02,   2.966383175659049e-03,  -3.047418618194887e-04,   2.562501824254515e-05,
  -1.839199691362239e-06,   1.156913705184483e-07,  -6.493699045848362e-09,   3.295092390362543e-10,  -1.526784305308874e-11,   6.511111270065221e-13,  -2.572128068154077e-14,
   9.462871531731007e-16,  -3.253828527414388e-17,   1.029103497130277e-01,  -2.182895533756063e-02,   2.974726957137574e-03,  -3.057346817988904e-04,   2.571842285819160e-05,
  -1.846526525610488e-06,   1.161865093891950e-07,  -6.523172830372077e-09,   3.310795178944220e-10,  -1.534362801146921e-11,   6.544558332582093e-13,  -2.585730048958916e-14,
   9.514162479792228e-16,  -3.271839771703968e-17,   1.029692278983246e-01,  -2.184643781277399e-02,   2.977633464722200e-03,  -3.060805505992357e-04,   2.575096436267259e-05,
  -1.849079288976060e-06,   1.163590308116986e-07,  -6.533442843466491e-09,   3.316266958108137e-10,  -1.537003685412659e-11,   6.556213997455420e-13,  -2.590470201759780e-14,
   9.532037259288256e-16,  -3.278116776027312e-17,   1.029785728515222e-01,  -2.184921265036428e-02,   2.978094800384860e-03,  -3.061354498763620e-04,   2.575612973178884e-05,
  -1.849484500453950e-06,   1.163864163154055e-07,  -6.535073094208036e-09,   3.317135552375704e-10,  -1.537422905538571e-11,   6.558064261072575e-13,  -2.591222677012282e-14,
   9.534874809122162e-16,  -3.279113231385118e-17,   2.064276680036998e-02,  -7.143458475487679e-03,   1.364375782403716e-03,  -1.824119571164720e-04,   1.889030067788105e-05,
  -1.602247368588333e-06,   1.153207563391423e-07,  -7.217864378098147e-09,   3.999779719275427e-10,  -1.989601181855788e-11,   8.981083784872309e-13,  -3.711653782946424e-14,
   1.414723675666908e-15,  -4.999109744341325e-17,   2.079404159204428e-02,  -7.200541920338699e-03,   1.376001077691625e-03,  -1.840445301044647e-04,   1.906603391645534e-05,
  -1.617624822481776e-06,   1.164562598696592e-07,  -7.290471198534093e-09,   4.040749281811253e-10,  -2.010298567397373e-11,   9.075772128340333e-13,  -3.751247026262103e-14,
   1.429971496638115e-15,  -5.053483256870891e-17,   2.106197717284628e-02,  -7.301663008039739e-03,   1.396597706602067e-03,  -1.869373159873697e-04,   1.937745026317040e-05,
  -1.644877515707811e-06,   1.184688059904832e-07,  -7.419166568321099e-09,   4.113371836817619e-10,  -2.046988551686788e-11,   9.243632428583457e-13,  -3.821439394817023e-14,
   1.457004354793382e-15,  -5.149884996053831e-17,   2.138769284486189e-02,  -7.424617689448893e-03,   1.421646367887162e-03,  -1.904559733490381e-04,   1.975629701330476e-05,
  -1.678035200815209e-06,   1.209176775876259e-07,  -7.575777684790130e-09,   4.201754244569501e-10,  -2.091643795408640e-11,   9.447947404892170e-13,  -3.906880414821264e-14,
   1.489911486821208e-15,  -5.267239990543363e-17,   2.170570484407610e-02,  -7.544692499341353e-03,   1.446113472042741e-03,  -1.938935514924464e-04,   2.012647030646530e-05,
  -1.710437970365114e-06,   1.233110628570765e-07,  -7.728855241266783e-09,   4.288149898973330e-10,  -2.135298531887349e-11,   9.647698116364839e-13,  -3.990417750770691e-14,
   1.522087135345636e-15,  -5.381991608086228e-17,   2.196319457319215e-02,  -7.641935540318086e-03,   1.465931930517322e-03,  -1.966784441679525e-04,   2.042639985436897e-05,
  -1.736695035500603e-06,   1.252506964329094e-07,  -7.852922169100595e-09,   4.358177497512063e-10,  -2.170685041913651e-11,   9.809625586064737e-13,  -4.058140698015460e-14,
   1.548172861374361e-15,  -5.475027830247011e-17,   2.213397919348714e-02,  -7.706443594119455e-03,   1.479080690276309e-03,  -1.985263250296964e-04,   2.062543407115998e-05,
  -1.754120784573642e-06,   1.265380466137006e-07,  -7.935271605511010e-09,   4.404660914064615e-10,  -2.194175308343573e-11,   9.917120962528799e-13,  -4.103100261415283e-14,
   1.565491118847563e-15,  -5.536796225857043e-17,   2.222188357964343e-02,  -7.739649527413657e-03,   1.485849655329293e-03,  -1.994776783041475e-04,   2.072790989038835e-05,
  -1.763093154904790e-06,   1.272009213679826e-07,  -7.977676108482887e-09,   4.428597594155184e-10,  -2.206272001433108e-11,   9.972478904357842e-13,  -4.126254069273592e-14,
   1.574410065151095e-15,  -5.568607676302004e-17,   2.225251111232194e-02,  -7.751219582014074e-03,   1.488208277114737e-03,  -1.998091845523832e-04,   2.076361933397795e-05,
  -1.766219802660733e-06,   1.274319213478547e-07,  -7.992453575669214e-09,   4.436939371152279e-10,  -2.210487677061689e-11,   9.991771278636905e-13,  -4.134323312772262e-14,
   1.577518401891916e-15,  -5.579694357031951e-17,   2.225737278109123e-02,  -7.753056180490931e-03,   1.488582682421031e-03,  -1.998618080310902e-04,   2.076928791608592e-05,
  -1.766716135864378e-06,   1.274685911793775e-07,  -7.994799420261055e-09,   4.438263590084114e-10,  -2.211156898981453e-11,   9.994833878151684e-13,  -4.135604282133850e-14,
   1.578011842871064e-15,  -5.581454345233234e-17,   5.150162467781203e-01,  -1.419191476512655e-02,   4.572842135407428e-04,  -1.542462915532252e-05,   5.089244782678495e-07,
  -1.642562746756059e-08,   5.251329332976293e-10,  -1.541092107317962e-11,   4.605742783079081e-13,  -1.428101450076397e-14,   3.807815326325822e-16,  -1.009604870734215e-17,
   2.903895505631904e-19,  -7.585745966194303e-21,   5.150597004168636e-01,  -1.419630815711753e-02,   4.575747428319813e-04,  -1.544029069943430e-05,   5.096777064632598e-07,
  -1.645676021988539e-08,   5.263765648599950e-10,  -1.546054535874963e-11,   4.622417951645066e-13,  -1.433536465294328e-14,   3.826677527374739e-16,  -1.015449747509260e-17,
   2.923068668594910e-19,  -7.639049631250367e-21,   5.151363977031588e-01,  -1.420406399362058e-02,   4.580877343058046e-04,  -1.546794971543016e-05,   5.110082250163403e-07,
  -1.651177458763662e-08,   5.285745683554723e-10,  -1.554825902017159e-11,   4.651907034569892e-13,  -1.443151445671191e-14,   3.860057597805668e-16,  -1.025795432644991e-17,
   2.956987279270350e-19,  -7.733562896310624e-21,   5.152291795323296e-01,  -1.421344862252539e-02,   4.587086428482790e-04,  -1.550143621473065e-05,   5.126195528449720e-07,
  -1.657843535511260e-08,   5.312385588656017e-10,  -1.565458096252975e-11,   4.687677437468025e-13,  -1.454820380417841e-14,   3.900587549173110e-16,  -1.038360820657754e-17,
   2.998151455057509e-19,  -7.848631073346502e-21,   5.153192910251160e-01,  -1.422256554328227e-02,   4.593120324864249e-04,  -1.553398723526563e-05,   5.141863718612826e-07,
  -1.664329194953724e-08,   5.338311580809578e-10,  -1.575806686878031e-11,   4.722520188483935e-13,  -1.466192898722356e-14,   3.940107980838337e-16,  -1.050617204062721e-17,
   3.038270222903534e-19,  -7.961156676216496e-21,   5.153919127062627e-01,  -1.422991466634626e-02,   4.597985616708140e-04,  -1.556024069464275e-05,   5.154504247388579e-07,
  -1.669564252862224e-08,   5.359243476397107e-10,  -1.584162793778962e-11,   4.750673425256111e-13,  -1.475386433681256e-14,   3.972070543192089e-16,  -1.060532599979791e-17,
   3.070702662738608e-19,  -8.052393507668632e-21,   5.154399140423293e-01,  -1.423477311423377e-02,   4.601202701938234e-04,  -1.557760359926473e-05,   5.162865921979346e-07,
  -1.673028532661495e-08,   5.373097582271123e-10,  -1.589693884539779e-11,   4.769317976211329e-13,  -1.481477051413221e-14,   3.993252353977755e-16,  -1.067105057686321e-17,
   3.092189141349658e-19,  -8.112969150274573e-21,   5.154645694251937e-01,  -1.423726886457063e-02,   4.602855505855429e-04,  -1.558652495044727e-05,   5.167162839379142e-07,
  -1.674809168163539e-08,   5.380219350717295e-10,  -1.592537313401644e-11,   4.778905664519865e-13,  -1.484609735766181e-14,   4.004149276507046e-16,  -1.070486696117207e-17,
   3.103240752012897e-19,  -8.144166748255314e-21,   5.154731516576050e-01,  -1.423813764557482e-02,   4.603430887160908e-04,  -1.558963085200886e-05,   5.168658866377761e-07,
  -1.675429183455145e-08,   5.382699266055251e-10,  -1.593527464683854e-11,   4.782244789680714e-13,  -1.485700869730203e-14,   4.007945084967144e-16,  -1.071664721255076e-17,
   3.107090121102993e-19,  -8.155039548354458e-21,   5.154745135729555e-01,  -1.423827551448426e-02,   4.603522197366452e-04,  -1.559012375111773e-05,   5.168896286414397e-07,
  -1.675527583156549e-08,   5.383092847583090e-10,  -1.593684610366596e-11,   4.782774759850306e-13,  -1.485874054443577e-14,   4.008547571607135e-16,  -1.071851705827828e-17,
   3.107701093832369e-19,  -8.156765585743724e-21,   2.279830146146522e-01,  -1.561075337267259e-02,   1.103653022146635e-03,  -6.582851437454131e-05,   3.504410791480061e-06,
  -1.702861103318411e-07,   7.658899259024057e-09,  -3.229097346389622e-10,   1.278253379677644e-11,  -4.778904420101714e-13,   1.701334466796483e-14,  -5.761879041172578e-16,
   1.858444114716449e-17,  -5.729722142607211e-19,   2.280905678913093e-01,  -1.562985090394598e-02,   1.105687634194583e-03,  -6.599375793534230e-05,   3.515599031498017e-06,
  -1.709489958779954e-07,   7.694029811523067e-09,  -3.246053427915502e-10,   1.285827506443463e-11,  -4.810371323064907e-13,   1.713556761729108e-14,  -5.806597556651160e-16,
   1.873887958950058e-17,  -5.780274665766364e-19,   2.282805100896940e-01,  -1.566358756772685e-02,   1.109282955175474e-03,  -6.628584649026432e-05,   3.535381647129717e-06,
  -1.721214229613218e-07,   7.756182292418534e-09,  -3.276060345246670e-10,   1.299234734306556e-11,  -4.866085547646716e-13,   1.735202117087117e-14,  -5.885809744536357e-16,
   1.901250039276464e-17,  -5.869853895756819e-19,   2.285104680177012e-01,  -1.570444849001260e-02,   1.113639362490743e-03,  -6.663992044027888e-05,   3.559372677980802e-06,
  -1.735438417250986e-07,   7.831618115240683e-09,  -3.312494833186284e-10,   1.315519656466449e-11,  -4.933781281523438e-13,   1.761510869993606e-14,  -5.982116707458638e-16,
   1.934526708284666e-17,  -5.978821541828472e-19,   2.287339984660994e-01,  -1.574418498341794e-02,   1.117877831042638e-03,  -6.698456991957603e-05,   3.582735890715966e-06,
  -1.749296432157437e-07,   7.905144320149357e-09,  -3.348022137631714e-10,   1.331405208899527e-11,  -4.999841119698393e-13,   1.787192772987736e-14,  -6.076159238826969e-16,
   1.967030996967712e-17,  -6.085286168744838e-19,   2.289142806461418e-01,  -1.577624599785092e-02,   1.121298992708092e-03,  -6.726287599590957e-05,   3.601609509747566e-06,
  -1.760495765622021e-07,   7.964587589193902e-09,  -3.376755528049927e-10,   1.344257335728431e-11,  -5.053303902762797e-13,   1.807983743860335e-14,  -6.152313729442436e-16,
   1.993359770291777e-17,  -6.171542320045915e-19,   2.290335103162435e-01,  -1.579745576460629e-02,   1.123562923835866e-03,  -6.744709983910089e-05,   3.614106623041983e-06,
  -1.767913501378969e-07,   8.003970435315871e-09,  -3.395797527870543e-10,   1.352776756980554e-11,  -5.088751849475360e-13,   1.821772112636862e-14,  -6.202829257102093e-16,
   2.010827949310280e-17,  -6.228779353091703e-19,   2.290947721528036e-01,  -1.580835555311160e-02,   1.124726578791648e-03,  -6.754180795620225e-05,   3.620532465979772e-06,
  -1.771728257162890e-07,   8.024227559147038e-09,  -3.405593694063143e-10,   1.357160241158279e-11,  -5.106993460545665e-13,   1.828868613198593e-14,  -6.228831514640934e-16,
   2.019820573056963e-17,  -6.258247850588367e-19,   2.291160999440998e-01,  -1.581215052820429e-02,   1.125131761712227e-03,  -6.757478797106516e-05,   3.622770310360109e-06,
  -1.773056877182993e-07,   8.031283358971551e-09,  -3.409006078307621e-10,   1.358687284195558e-11,  -5.113348579719292e-13,   1.831341087659278e-14,  -6.237891420050619e-16,
   2.022954025206586e-17,  -6.268516512862095e-19,   2.291194846105359e-01,  -1.581275279565026e-02,   1.125196066361391e-03,  -6.758002220439440e-05,   3.623125485795201e-06,
  -1.773267751691221e-07,   8.032403260493445e-09,  -3.409547706765995e-10,   1.358929668118802e-11,  -5.114357332644366e-13,   1.831733552734540e-14,  -6.239329557351005e-16,
   2.023451426535134e-17,  -6.270146572508793e-19,   4.614537831397936e-02,  -7.525062611943041e-03,   8.802972911248019e-04,  -7.973957098398189e-05,   6.052864703734170e-06,
  -3.987560473276350e-07,   2.332377098698174e-08,  -1.230777851541319e-09,   5.923185413419084e-11,  -2.622191654652952e-12,   1.075242938783668e-13,  -4.105886162260561e-15,
   1.466848246597925e-16,  -4.917647120377996e-18,   4.623514234013665e-02,  -7.548887801757876e-03,   8.838994016263508e-04,  -8.013520442317923e-05,   6.087638086899108e-06,
  -4.013307690256381e-07,   2.348937455223764e-08,  -1.240225427808582e-09,   5.971714868367049e-11,  -2.644885913248225e-12,   1.084989581405105e-13,  -4.144601887115641e-15,
   1.481152984574964e-16,  -4.967002754287335e-18,   4.639383098791587e-02,  -7.591022040232798e-03,   8.902717559789995e-04,  -8.083531554831254e-05,   6.149189625524327e-06,
  -4.058893252391615e-07,   2.378263973173027e-08,  -1.256959225870171e-09,   6.057686101064465e-11,  -2.685095439836097e-12,   1.102260899441883e-13,  -4.213215199647463e-15,
   1.506506914248070e-16,  -5.054489154535088e-18,   4.658622909501029e-02,  -7.642132357142635e-03,   8.980052556904622e-04,  -8.168533231280084e-05,   6.223948932865262e-06,
  -4.114279417193447e-07,   2.413906315920741e-08,  -1.277302331293301e-09,   6.162225319832308e-11,  -2.733999690420942e-12,   1.123270790393180e-13,  -4.296694276604758e-15,
   1.537358450962845e-16,  -5.160958845912800e-18,   4.677354122066778e-02,  -7.691918538191223e-03,   9.055421840564653e-04,  -8.251412137902729e-05,   6.296871174889908e-06,
  -4.168324304557458e-07,   2.448696846433416e-08,  -1.297165001662528e-09,   6.264321752079523e-11,  -2.781771989690959e-12,   1.143798469901206e-13,  -4.378271658702491e-15,
   1.567511809321984e-16,  -5.265032954912857e-18,   4.692482187660152e-02,  -7.732147144745203e-03,   9.116349429192422e-04,  -8.318437525635715e-05,   6.355865911412558e-06,
  -4.212061238842812e-07,   2.476859920400966e-08,  -1.313248028960895e-09,   6.347009068272858e-11,  -2.820470243667924e-12,   1.160429977390919e-13,  -4.444375817975042e-15,
   1.591949138565133e-16,  -5.349388157382131e-18,   4.702497401650396e-02,  -7.758789104153840e-03,   9.156712869072666e-04,  -8.362853928121594e-05,   6.394971064156454e-06,
  -4.241059556372344e-07,   2.495536485983869e-08,  -1.323915631115059e-09,   6.401863326965013e-11,  -2.846146218235064e-12,   1.171466280915694e-13,  -4.488246098976390e-15,
   1.608168692290130e-16,  -5.405381285380912e-18,   4.707646532511521e-02,  -7.772489486518631e-03,   9.177473506729648e-04,  -8.385703284154775e-05,   6.415091375355498e-06,
  -4.255981859015360e-07,   2.505148527288991e-08,  -1.329406419477323e-09,   6.430100534788367e-11,  -2.859364555657704e-12,   1.177148362010762e-13,  -4.510834421976671e-15,
   1.616520463788032e-16,  -5.434214765301830e-18,   4.709439664934682e-02,  -7.777260971432785e-03,   9.184704548282483e-04,  -8.393662491302312e-05,   6.422100480523168e-06,
  -4.261180528475973e-07,   2.508497390234156e-08,  -1.331319525156983e-09,   6.439939419623035e-11,  -2.863970498478165e-12,   1.179128359385825e-13,  -4.518705872595791e-15,
   1.619430921684078e-16,  -5.444263007862721e-18,   4.709724254531106e-02,  -7.778018280057176e-03,   9.185852257736239e-04,  -8.394925806085978e-05,   6.423213016152182e-06,
  -4.262005714897427e-07,   2.509028965582169e-08,  -1.331623203030800e-09,   6.441501221740628e-11,  -2.864701644176260e-12,   1.179442666802469e-13,  -4.519955408833695e-15,
   1.619892939761340e-16,  -5.445858118630220e-18,   4.991677624656850e-03,  -1.563360428798194e-03,   2.788670171336577e-04,  -3.538991475768306e-05,   3.518711250604279e-06,
  -2.888523398057722e-07,   2.024073315722810e-08,  -1.238957010924502e-09,   6.738001556058929e-11,  -3.298481295128030e-12,   1.468584923864505e-13,  -5.997153742061918e-15,
   2.262018445491566e-16,  -7.919405369532080e-18,   5.022150352065043e-03,  -1.574351385842922e-03,   2.810210891147520e-04,  -3.568303971571557e-05,   3.549453609174791e-06,
  -2.914846084126220e-07,   2.043156820949461e-08,  -1.250969640321596e-09,   6.804875154042514e-11,  -3.331870479740418e-12,   1.483703389665760e-13,  -6.059795657224015e-15,
   2.285946901931421e-16,  -8.004117736736287e-18,   5.076105585411148e-03,  -1.593816086805015e-03,   2.848365872588826e-04,  -3.620232989441711e-05,   3.603922723159598e-06,
  -2.961489537102531e-07,   2.076975697110909e-08,  -1.272259561541361e-09,   6.923403173562865e-11,  -3.391053717910326e-12,   1.510502728222382e-13,  -6.170841487910907e-15,
   2.328366901727289e-16,  -8.154300355569577e-18,   5.141666201523187e-03,  -1.617474386686869e-03,   2.894753021980820e-04,  -3.683379531893965e-05,   3.670170012545813e-06,
  -3.018227659176582e-07,   2.118119109623614e-08,  -1.298163406484833e-09,   7.067632575041966e-11,  -3.463076314491699e-12,   1.543118451435627e-13,  -6.305997223523541e-15,
   2.380000118485004e-16,  -8.337111161997802e-18,   5.205644764838738e-03,  -1.640568994482838e-03,   2.940047312664158e-04,  -3.745052542992083e-05,   3.734883932916133e-06,
  -3.073661609616427e-07,   2.158322452692486e-08,  -1.323478449411515e-09,   7.208598421985565e-11,  -3.533475695684352e-12,   1.575001683105072e-13,  -6.438127150760979e-15,
   2.430480669315216e-16,  -8.515851319191954e-18,   5.257424760730798e-03,  -1.659265400551259e-03,   2.976724502270386e-04,  -3.795002604428819e-05,   3.787305850037515e-06,
  -3.118572746763521e-07,   2.190898194774468e-08,  -1.343992777969486e-09,   7.322842295308516e-11,  -3.590534568274619e-12,   1.600844975795180e-13,  -6.545233313244933e-15,
   2.471403179429430e-16,  -8.660756107197939e-18,   5.291757737347457e-03,  -1.671664671488907e-03,   3.001052792087262e-04,  -3.828139871749021e-05,   3.822087356086770e-06,
  -3.148374102833755e-07,   2.212516222251990e-08,  -1.357607642883502e-09,   7.398668395719775e-11,  -3.628408033347132e-12,   1.617999658191364e-13,  -6.616333338886082e-15,
   2.498569819778268e-16,  -8.756955633364265e-18,   5.309425823927073e-03,  -1.678046239554453e-03,   3.013575244315740e-04,  -3.845198087507965e-05,   3.839993340729615e-06,
  -3.163717225655648e-07,   2.223646799154904e-08,  -1.364617925486361e-09,   7.437712798295754e-11,  -3.647910553641320e-12,   1.626833551978762e-13,  -6.652947705908773e-15,
   2.512560174699879e-16,  -8.806497874770141e-18,   5.315581173795938e-03,  -1.680269625859831e-03,   3.017938374412246e-04,  -3.851141833518450e-05,   3.846232698326185e-06,
  -3.169063708481508e-07,   2.227525470583810e-08,  -1.367060851077778e-09,   7.451319148830146e-11,  -3.654706982131587e-12,   1.629912118092747e-13,  -6.665707787454386e-15,
   2.517435860215689e-16,  -8.823763691761924e-18,   5.316558219013810e-03,  -1.680622552231361e-03,   3.018630960404374e-04,  -3.852085331822012e-05,   3.847223131667040e-06,
  -3.169912414654543e-07,   2.228141179489533e-08,  -1.367448649013233e-09,   7.453479077198356e-11,  -3.655785880607271e-12,   1.630400826933423e-13,  -6.667733402140255e-15,
   2.518209859533360e-16,  -8.826504592951718e-18,   4.645602127658599e-01,  -1.115673889630510e-02,   3.120824513129821e-04,  -9.347109723493470e-06,   2.784079941223497e-07,
  -7.722691439151155e-09,   2.396052868787257e-10,  -6.628243709720831e-12,   1.428723659310046e-13,  -4.878343917907459e-15,   1.460926544747756e-16,  -2.091084980554133e-18,
   8.878907856530200e-20,  -2.238709396956305e-21,   4.645897887355216e-01,  -1.115939368768214e-02,   3.122409860068471e-04,  -9.354461962685345e-06,   2.787495496420775e-07,
  -7.736008148920015e-09,   2.399934717082200e-10,  -6.645010354272859e-12,   1.435062776517249e-13,  -4.889830747365809e-15,   1.466398495772686e-16,  -2.108964337069563e-18,
   8.873460313573215e-20,  -2.266529863668148e-21,   4.646419883149775e-01,  -1.116407980967050e-02,   3.125208802651022e-04,  -9.367445337143603e-06,   2.793526787411824e-07,
  -7.759532680145718e-09,   2.406797934718503e-10,  -6.674627404982510e-12,   1.446266999811069e-13,  -4.910175913560203e-15,   1.476051649846398e-16,  -2.140673707813977e-18,
   8.864342410028308e-20,  -2.315289377855275e-21,   4.647051296119077e-01,  -1.116974922014726e-02,   3.128595997398408e-04,  -9.383162434105588e-06,   2.800827555685708e-07,
  -7.788024845893446e-09,   2.415120287446609e-10,  -6.710495440042383e-12,   1.459847234442966e-13,  -4.934908357181499e-15,   1.487720787033740e-16,  -2.179290151808091e-18,
   8.854165409031009e-20,  -2.373689632496560e-21,   4.647664480998204e-01,  -1.117525602640955e-02,   3.131887039355945e-04,  -9.398438623743889e-06,   2.807923057443549e-07,
  -7.815732817104958e-09,   2.423223893434444e-10,  -6.745373059857919e-12,   1.473064162544086e-13,  -4.959055790311688e-15,   1.499045478161097e-16,  -2.217062666484183e-18,
   8.845181241389466e-20,  -2.429800270360172e-21,   4.648158612538242e-01,  -1.117969441804550e-02,   3.134540275984441e-04,  -9.410758050958598e-06,   2.813644873353588e-07,
  -7.838088615754357e-09,   2.429769567374576e-10,  -6.773511384480452e-12,   1.483735526530880e-13,  -4.978607648313909e-15,   1.508166148290200e-16,  -2.247694258853232e-18,
   8.838590203804246e-20,  -2.474586733108525e-21,   4.648485203139046e-01,  -1.118262829621088e-02,   3.136294475103396e-04,  -9.418904941731202e-06,   2.817428577401037e-07,
  -7.852877891837726e-09,   2.434103417541651e-10,  -6.792124996123952e-12,   1.490798712938909e-13,  -4.991575804208874e-15,   1.514191836136193e-16,  -2.268033765702064e-18,
   8.834553453875466e-20,  -2.503978350049809e-21,   4.648652946945980e-01,  -1.118413531345706e-02,   3.137195645828125e-04,  -9.423090750438774e-06,   2.819372566519340e-07,
  -7.860478141361061e-09,   2.436331714214585e-10,  -6.801690268148171e-12,   1.494429627293248e-13,  -4.998250648767207e-15,   1.517285992219927e-16,  -2.278509497370245e-18,
   8.832579298688979e-20,  -2.519009942484327e-21,   4.648711335520684e-01,  -1.118465989722616e-02,   3.137509355204091e-04,  -9.424547976477157e-06,   2.820049329276600e-07,
  -7.863124313642345e-09,   2.437107716503417e-10,  -6.805020551352243e-12,   1.495693978189330e-13,  -5.000576292748175e-15,   1.518362891387987e-16,  -2.282160505909010e-18,
   8.831907958944743e-20,  -2.524231908966788e-21,   4.648720601164069e-01,  -1.118474314394369e-02,   3.137559138871475e-04,  -9.424779233230497e-06,   2.820156728831668e-07,
  -7.863544264424450e-09,   2.437230877475096e-10,  -6.805549069052312e-12,   1.495894640698122e-13,  -5.000945454569030e-15,   1.518533778096569e-16,  -2.282740099995486e-18,
   8.831802176584058e-20,  -2.525060092719657e-21,   1.792663791037953e-01,  -9.194520277356023e-03,   5.633322188893624e-04,  -2.942462305712351e-05,   1.389737243268726e-06,
  -6.093938226097228e-08,   2.468826255123199e-09,  -9.513761856471305e-11,   3.503091096436523e-12,  -1.206249743849375e-13,   3.985332309301151e-15,  -1.281402431472717e-16,
   3.877606983575597e-18,  -1.132842965585577e-19,   1.793208019394858e-01,  -9.203003307987314e-03,   5.641342458548243e-04,  -2.948339246355854e-05,   1.393322683992002e-06,
  -6.113349145129282e-08,   2.478388607576982e-09,  -9.556298790343033e-11,   3.520726875022810e-12,  -1.213201922267393e-13,   4.010702821653870e-15,  -1.290188916966979e-16,
   3.907063870191452e-18,  -1.141853509534859e-19,   1.794168954720348e-01,  -9.217985474980438e-03,   5.655511017484482e-04,  -2.958724206957408e-05,   1.399660328551604e-06,
  -6.147669008651732e-08,   2.495299669023047e-09,  -9.631549195680960e-11,   3.551933721928606e-12,  -1.225506503709510e-13,   4.055619777254705e-15,  -1.305747281892148e-16,
   3.959230753836564e-18,  -1.157819608222209e-19,   1.795332013042206e-01,  -9.236125499460970e-03,   5.672672244178862e-04,  -2.971307435909358e-05,   1.407342795185609e-06,
  -6.189286804682637e-08,   2.515813867492319e-09,  -9.722873118595843e-11,   3.589820184090577e-12,  -1.240449183296145e-13,   4.110190751684432e-15,  -1.324653778517130e-16,
   4.022635963960017e-18,  -1.177240277018910e-19,   1.796462227366234e-01,  -9.253760085686829e-03,   5.689361907679120e-04,  -2.983549896232854e-05,   1.414820651338557e-06,
  -6.229812326084805e-08,   2.535797100065292e-09,  -9.811875624890188e-11,   3.626758087245848e-12,  -1.255022341116969e-13,   4.163437187732281e-15,  -1.343105780698710e-16,
   4.084529600526028e-18,  -1.196213599135349e-19,   1.797373529127047e-01,  -9.267983901127990e-03,   5.702828296860173e-04,  -2.993431555055239e-05,   1.420858965113873e-06,
  -6.262547972578214e-08,   2.551944461055746e-09,  -9.883824023680958e-11,   3.656628583164765e-12,  -1.266810480728109e-13,   4.206525787191098e-15,  -1.358040868511775e-16,
   4.134635443260302e-18,  -1.211584566781895e-19,   1.797976100868352e-01,  -9.277391382026373e-03,   5.711737144329311e-04,  -2.999970638359523e-05,   1.424855963542831e-06,
  -6.284222668206089e-08,   2.562638451826395e-09,  -9.931488486845033e-11,   3.676422325098712e-12,  -1.274623527777824e-13,   4.235093176636013e-15,  -1.367944275963690e-16,
   4.167864855789524e-18,  -1.221783797080092e-19,   1.798285673994141e-01,  -9.282225246559537e-03,   5.716315512938662e-04,  -3.003331698703108e-05,   1.426910777020404e-06,
  -6.295367150628368e-08,   2.568137791781346e-09,  -9.956004329341666e-11,   3.686604658690439e-12,  -1.278643228943144e-13,   4.249793394215286e-15,  -1.373040861278482e-16,
   4.184967045505925e-18,  -1.227034716456480e-19,   1.798393443455861e-01,  -9.283908143083382e-03,   5.717909573575940e-04,  -3.004502012959145e-05,   1.427626318315928e-06,
  -6.299248238765602e-08,   2.570053076598275e-09,  -9.964543325116421e-11,   3.690151469804058e-12,  -1.280043490417444e-13,   4.254914639985208e-15,  -1.374816481699853e-16,
   4.190925563369659e-18,  -1.228864438916035e-19,   1.798410545920577e-01,  -9.284175215797504e-03,   5.718162553618395e-04,  -3.004687747861520e-05,   1.427739881230698e-06,
  -6.299864216050523e-08,   2.570357062393734e-09,  -9.965898632616675e-11,   3.690714430798013e-12,  -1.280265748084137e-13,   4.255727534395048e-15,  -1.375098329292831e-16,
   4.191871380410211e-18,  -1.229154890022301e-19,   2.578778906818435e-02,  -3.117983644550574e-03,   3.151409757508010e-04,  -2.502653561355826e-05,   1.706192725704537e-06,
  -1.027950836845555e-07,   5.558370859297094e-09,  -2.743465288925167e-10,   1.247011765355145e-11,  -5.248335085476365e-13,   2.060515966540948e-14,  -7.579452221458140e-16,
   2.618775506656193e-17,  -8.533347121398489e-19,   2.581935502895867e-02,  -3.125379875247985e-03,   3.161473885246350e-04,  -2.512773102446099e-05,   1.714422133506759e-06,
  -1.033653727891170e-07,   5.593033783017472e-09,  -2.762276333749556e-10,   1.256267635196286e-11,  -5.290049305419571e-13,   2.077850865482313e-14,  -7.646398539198420e-16,
   2.642920022124758e-17,  -8.614810669527168e-19,   2.587513604826797e-02,  -3.138454630998096e-03,   3.179270816036827e-04,  -2.530673598563814e-05,   1.728983449303629e-06,
  -1.043747223993293e-07,   5.654398036838413e-09,  -2.795585130700762e-10,   1.272660222881975e-11,  -5.363940049280570e-13,   2.108562057804383e-14,  -7.765019272937970e-16,
   2.685706494700795e-17,  -8.759189242337496e-19,   2.594272774562362e-02,  -3.154305743140536e-03,   3.200857033297172e-04,  -2.552394949763385e-05,   1.746660186673683e-06,
  -1.056004786147271e-07,   5.728943929140578e-09,  -2.836061518725387e-10,   1.292585696959909e-11,  -5.453777494646332e-13,   2.145909557821319e-14,  -7.909299782908134e-16,
   2.737757534369378e-17,  -8.934859335351157e-19,   2.600849220828445e-02,  -3.169736732373233e-03,   3.221881817069925e-04,  -2.573561330730815e-05,   1.763892958269780e-06,
  -1.067959252160745e-07,   5.801672728994827e-09,  -2.875564416186964e-10,   1.312037637618068e-11,  -5.541502955087329e-13,   2.182387843458814e-14,  -8.050250979856842e-16,
   2.788617004812857e-17,  -9.106538513905407e-19,   2.606157716655672e-02,  -3.182198614073021e-03,   3.238868849480768e-04,  -2.590669921922131e-05,   1.777827545959348e-06,
  -1.077629165051065e-07,   5.860521523206775e-09,  -2.907537760810091e-10,   1.327785969805860e-11,  -5.612542173475263e-13,   2.211933898986084e-14,  -8.164436733936387e-16,
   2.829825512355037e-17,  -9.245662203415671e-19,   2.609670672346938e-02,  -3.190448348308630e-03,   3.250117979278843e-04,  -2.602003055046409e-05,   1.787060836780316e-06,
  -1.084038283472043e-07,   5.899535103322309e-09,  -2.928738978272363e-10,   1.338230535052002e-11,  -5.659664685409919e-13,   2.231535794770135e-14,  -8.240201642002064e-16,
   2.857171655001239e-17,  -9.337996006064409e-19,   2.611476351871430e-02,  -3.194689670877754e-03,   3.255902502145239e-04,  -2.607831858145747e-05,   1.791810491626801e-06,
  -1.087335685950743e-07,   5.919609895928088e-09,  -2.939649683818592e-10,   1.343606201383372e-11,  -5.683920456723076e-13,   2.241626598329107e-14,  -8.279207548434145e-16,
   2.871251250185531e-17,  -9.385538843336986e-19,   2.612105091423545e-02,  -3.196166649083988e-03,   3.257917062201660e-04,  -2.609862012144619e-05,   1.793464914192620e-06,
  -1.088484335337034e-07,   5.926603398441387e-09,  -2.943450898860683e-10,   1.345479145000224e-11,  -5.692371842267037e-13,   2.245142666694207e-14,  -8.292799372234984e-16,
   2.876157527114596e-17,  -9.402106489562674e-19,   2.612204875899792e-02,  -3.196401060658858e-03,   3.258236802308897e-04,  -2.610184235431180e-05,   1.793727508188233e-06,
  -1.088666655684945e-07,   5.927713469569470e-09,  -2.944054272408368e-10,   1.345776445300012e-11,  -5.693713385475671e-13,   2.245700802215280e-14,  -8.294956941828009e-16,
   2.876936358560645e-17,  -9.404736493305134e-19,   1.444032812291715e-03,  -3.862748857787165e-04,   6.274284941843501e-05,  -7.413569217160175e-06,   6.978918678545877e-07,
  -5.486347039122920e-08,   3.711860512690618e-09,  -2.207491901877574e-10,   1.171984409445482e-11,  -5.621747083675505e-13,   2.459988110322705e-14,  -9.897035822012194e-16,
   3.685036277733019e-17,  -1.275709601475558e-18,   1.450767932011079e-03,  -3.885559764867916e-04,   6.316732710011221e-05,  -7.468966635437624e-06,   7.035067605162190e-07,
  -5.533088413227800e-08,   3.744958187651917e-09,  -2.227914836845980e-10,   1.183162083622516e-11,  -5.676744749397913e-13,   2.484576295922034e-14,  -9.997790577101946e-16,
   3.723147434811863e-17,  -1.289084235900363e-18,   1.462688419944986e-03,  -3.925943661556620e-04,   6.391898691263444e-05,  -7.567082752280898e-06,   7.134530957728665e-07,
  -5.615898412103276e-08,   3.803603001669711e-09,  -2.264105278985831e-10,   1.202971185640803e-11,  -5.774219096299494e-13,   2.528157692888435e-14,  -1.017638393167497e-15,
   3.790705038444703e-17,  -1.312793818893072e-18,   1.477164789533388e-03,  -3.975004861316689e-04,   6.483245389739015e-05,  -7.686352506582869e-06,   7.255466086859110e-07,
  -5.716604542551983e-08,   3.874933304914090e-09,  -2.308130296646557e-10,   1.227071527742473e-11,  -5.892821824435908e-13,   2.581190620004246e-14,  -1.039372656690754e-15,
   3.872926508020478e-17,  -1.341651592633074e-18,   1.491283311999507e-03,  -4.022872743441882e-04,   6.572401456766379e-05,  -7.802796071907060e-06,   7.373564564937647e-07,
  -5.814968859482702e-08,   3.944617171991482e-09,  -2.351145634240894e-10,   1.250622215100369e-11,  -6.008732730064074e-13,   2.633025036840982e-14,  -1.060617584736808e-15,
   3.953303027180106e-17,  -1.369863776505643e-18,   1.502703804992173e-03,  -4.061607076836079e-04,   6.644568238312764e-05,  -7.897074956465645e-06,   7.469204134567159e-07,
  -5.894641712678326e-08,   4.001068309449444e-09,  -2.385997162238232e-10,   1.269705454951862e-11,  -6.102665333071557e-13,   2.675034612143192e-14,  -1.077837011279953e-15,
   4.018454215075244e-17,  -1.392733257285167e-18,   1.510273232512694e-03,  -4.087286759829370e-04,   6.692423560178668e-05,  -7.959605236009399e-06,   7.532647057044420e-07,
  -5.947500180639192e-08,   4.038524776376228e-09,  -2.409124132445463e-10,   1.282369893061381e-11,  -6.165007555465324e-13,   2.702917788580530e-14,  -1.089266774358090e-15,
   4.061701893617399e-17,  -1.407914812884751e-18,   1.514167611371284e-03,  -4.100500755069889e-04,   6.717051857958364e-05,  -7.991789559945311e-06,   7.565304262244820e-07,
  -5.974711250171159e-08,   4.057808363164964e-09,  -2.421031217183547e-10,   1.288890601475596e-11,  -6.197107952671102e-13,   2.717275565459030e-14,  -1.095152458344062e-15,
   4.083972685922880e-17,  -1.415732906235437e-18,   1.515524219504201e-03,  -4.105104190247931e-04,   6.725632297518138e-05,  -8.003003088855265e-06,   7.576683050823589e-07,
  -5.984192786271985e-08,   4.064527826551482e-09,  -2.425180413213233e-10,   1.291162889629442e-11,  -6.208294287903785e-13,   2.722279047060710e-14,  -1.097203567561465e-15,
   4.091733968942372e-17,  -1.418457514385134e-18,   1.515739548383675e-03,  -4.105834890682703e-04,   6.726994290969464e-05,  -8.004783066713045e-06,   7.578489284897222e-07,
  -5.985697872952926e-08,   4.065594475458586e-09,  -2.425839062707551e-10,   1.291523598512302e-11,  -6.210070046370589e-13,   2.723073321649020e-14,  -1.097529171134446e-15,
   4.092966039818994e-17,  -1.418890036005458e-18,   4.243098413451333e-01,  -9.043003746124328e-03,   2.224055901624094e-04,  -5.871283244681900e-06,   1.685437898674003e-07,
  -3.807916695718736e-09,   9.890689262904026e-11,  -3.862292121869148e-12,   5.819707834022329e-14,  -1.095321501761549e-16,   9.711068651167198e-17,  -1.531690719296391e-18,
  -8.295443078425150e-20,  -3.576947811009663e-21,   4.243308837649802e-01,  -9.044667855332885e-03,   2.225011928292883e-04,  -5.874917186766199e-06,   1.686847923993592e-07,
  -3.815530651408352e-09,   9.906776390436143e-11,  -3.862892897536938e-12,   5.859167747592588e-14,  -1.182727215410786e-16,   9.663550633284934e-17,  -1.553948344287286e-18,
  -8.214282385066557e-20,  -3.504791441226557e-21,   4.243680208287376e-01,  -9.047605044323758e-03,   2.226699501800247e-04,  -5.881335141438864e-06,   1.689337806809574e-07,
  -3.828966673225026e-09,   9.935245688343726e-11,  -3.863977564710672e-12,   5.928635790091090e-14,  -1.337849789388811e-16,   9.580120676721509e-17,  -1.592807237094059e-18,
  -8.070326607383925e-20,  -3.378505084023238e-21,   4.244129399549706e-01,  -9.051158161417765e-03,   2.228741241613998e-04,  -5.889105702329518e-06,   1.692351796314692e-07,
  -3.845215518570122e-09,   9.969812885362022e-11,  -3.865331245491181e-12,   6.012366154208020e-14,  -1.526938000429924e-16,   9.479948570923506e-17,  -1.639092350527389e-18,
  -7.895009035300262e-20,  -3.227560448910845e-21,   4.244565598557700e-01,  -9.054608971736470e-03,   2.230724488227899e-04,  -5.896659597924573e-06,   1.695281080840959e-07,
  -3.860991603678502e-09,   1.000351833968336e-10,  -3.866689658348533e-12,   6.093367477450194e-14,  -1.712070409701092e-16,   9.383452143176938e-17,  -1.683293816303846e-18,
  -7.723545852578084e-20,  -3.082868588682574e-21,   4.244917089347607e-01,  -9.057389979336836e-03,   2.232322998263182e-04,  -5.902752348335165e-06,   1.697643284499911e-07,
  -3.873702061435424e-09,   1.003077700742706e-10,  -3.867815851761179e-12,   6.158419455914709e-14,  -1.862324323160228e-16,   9.306254558571469e-17,  -1.718381721205848e-18,
  -7.584533706335160e-20,  -2.967624868181921e-21,   4.245149394502773e-01,  -9.059228148590316e-03,   2.233379672979589e-04,  -5.906781967602634e-06,   1.699205369003171e-07,
  -3.882101624900265e-09,   1.004884086329790e-10,  -3.868575684720882e-12,   6.201306280809823e-14,  -1.962150518778012e-16,   9.255508349799160e-17,  -1.741313988997691e-18,
  -7.492254243427362e-20,  -2.892118417628798e-21,   4.245268708637605e-01,  -9.060172300115476e-03,   2.233922452157157e-04,  -5.908852495145807e-06,   1.700007940306703e-07,
  -3.886415427275688e-09,   1.005813352392424e-10,  -3.868970752017752e-12,   6.223300374851939e-14,  -2.013582493381446e-16,   9.229529740936649e-17,  -1.753012826537930e-18,
  -7.444735700708264e-20,  -2.853541385521827e-21,   4.245310239295242e-01,  -9.060500946761309e-03,   2.234111391508040e-04,  -5.909573340362633e-06,   1.700287340937373e-07,
  -3.887916921650235e-09,   1.006137046621815e-10,  -3.869109033099936e-12,   6.230950797000172e-14,  -2.031510282707601e-16,   9.220500717637707e-17,  -1.757072328460470e-18,
  -7.428176146340787e-20,  -2.840145982912606e-21,   4.245316829746901e-01,  -9.060553099695142e-03,   2.234141374534613e-04,  -5.909687737075545e-06,   1.700331680739916e-07,
  -3.888155189839234e-09,   1.006188424524713e-10,  -3.869131013183516e-12,   6.232164584774179e-14,  -2.034356428596901e-16,   9.219068556746193e-17,  -1.757715928103022e-18,
  -7.425547413635456e-20,  -2.838021820923707e-21,   1.496986685095555e-01,  -5.797669426975462e-03,   3.118399097102146e-04,  -1.444000134158270e-05,   5.994091092104650e-07,
  -2.412201988393921e-08,   8.900996549864528e-10,  -3.019037278420653e-11,   1.049831992286198e-12,  -3.482771312878644e-14,   9.930712603499623e-16,  -3.007978797579927e-17,
   9.661160448299746e-19,  -2.237792027643697e-20,   1.497285950758264e-01,  -5.801812264960502e-03,   3.121843515771223e-04,  -1.446313374170279e-05,   6.006946226097188e-07,
  -2.418340398669227e-08,   8.929467572963128e-10,  -3.031216811835614e-11,   1.054222764040864e-12,  -3.498975861106681e-14,   9.992925190521638e-16,  -3.025631312877147e-17,
   9.713205243553742e-19,  -2.261112119385013e-20,   1.497814281033982e-01,  -5.809127748128647e-03,   3.127927205850297e-04,  -1.450399861639860e-05,   6.029662225025390e-07,
  -2.429191425745993e-08,   8.979800074215591e-10,  -3.052752769489765e-11,   1.061991903633136e-12,  -3.527644364261587e-14,   1.010296578087207e-15,  -3.056918408376084e-17,
   9.805370559168356e-19,  -2.302283418758996e-20,   1.498453606573218e-01,  -5.817982890113812e-03,   3.135293840200896e-04,  -1.455349376871905e-05,   6.057186847817632e-07,
  -2.442346253021144e-08,   9.040824858586128e-10,  -3.078871116261629e-11,   1.071423244090725e-12,  -3.562439455832620e-14,   1.023648190430220e-15,  -3.094988127495492e-17,
   9.917386579125347e-19,  -2.352107817295560e-20,   1.499074737926407e-01,  -5.826588933232946e-03,   3.142455905963758e-04,  -1.460162766605936e-05,   6.083966217252717e-07,
  -2.455152032525974e-08,   9.100236908002672e-10,  -3.104307000950424e-11,   1.080617657697316e-12,  -3.596353349238051e-14,   1.036657382101465e-15,  -3.132193896164535e-17,
   1.002672991157405e-18,  -2.400519305143840e-20,   1.499575461195106e-01,  -5.833528752470210e-03,   3.148233223620325e-04,  -1.464046460367336e-05,   6.105581628670636e-07,
  -2.465493539828077e-08,   9.148220748646414e-10,  -3.124855730725516e-11,   1.088052293935103e-12,  -3.623771328959721e-14,   1.047171684195563e-15,  -3.162344410939756e-17,
   1.011524865116950e-18,  -2.439550598246755e-20,   1.499906500684490e-01,  -5.838117843965757e-03,   3.152054521965208e-04,  -1.466615721434639e-05,   6.119885445939351e-07,
  -2.472339447868193e-08,   9.179987596253657e-10,  -3.138462372858408e-11,   1.092978572489813e-12,  -3.641936470638981e-14,   1.054136168341983e-15,  -3.182354541344416e-17,
   1.017395363256174e-18,  -2.465357651002140e-20,   1.500076558047744e-01,  -5.840475608710802e-03,   3.154018101967438e-04,  -1.467936084003322e-05,   6.127237559935907e-07,
  -2.475858995395659e-08,   9.196319966699812e-10,  -3.145458831131723e-11,   1.095512664117154e-12,  -3.651279962622654e-14,   1.057717975291096e-15,  -3.192657678749996e-17,
   1.020416771008483e-18,  -2.478615797380159e-20,   1.500135756469818e-01,  -5.841296417007856e-03,   3.154701728788275e-04,  -1.468395795473037e-05,   6.129797553042212e-07,
  -2.477084618806284e-08,   9.202007557039128e-10,  -3.147895413914149e-11,   1.096395348888084e-12,  -3.654534413101170e-14,   1.058965486433147e-15,  -3.196248075757065e-17,
   1.021469456943850e-18,  -2.483231218384319e-20,   1.500145150842901e-01,  -5.841426675894419e-03,   3.154810219725107e-04,  -1.468468752340893e-05,   6.130203837243387e-07,
  -2.477279137454057e-08,   9.202910239824350e-10,  -3.148282132594158e-11,   1.096535450666844e-12,  -3.655050961783761e-14,   1.059163488710267e-15,  -3.196818026259459e-17,
   1.021636553946212e-18,  -2.483963660342879e-20,   1.695195535238234e-02,  -1.453510312361247e-03,   1.286720790304274e-04,  -8.905353200183216e-06,   5.375300839771034e-07,
  -2.953725946354570e-08,   1.465470629802093e-09,  -6.674427042714182e-11,   2.851175615532922e-12,  -1.134467512820367e-13,   4.208680229304820e-15,  -1.485763979070761e-16,
   4.956203059052080e-18,  -1.543141726139995e-19,   1.696465014482361e-02,  -1.456116843684867e-03,   1.289866528592495e-04,  -8.934210112502781e-06,   5.396846586054378e-07,
  -2.967514107440946e-08,   1.473346799362296e-09,  -6.714855018477314e-11,   2.869990876918986e-12,  -1.142603064110520e-13,   4.241333287607407e-15,  -1.497837077805026e-16,
   4.998631812052873e-18,  -1.557288453132516e-19,   1.698707576412307e-02,  -1.460722912925564e-03,   1.295427309813473e-04,  -8.985235696734000e-06,   5.434955997857365e-07,
  -2.991909307389542e-08,   1.487285227235088e-09,  -6.786417568259399e-11,   2.903304458420786e-12,  -1.157009799178939e-13,   4.299166913924014e-15,  -1.519225744588793e-16,
   5.073800225849750e-18,  -1.582353310453132e-19,   1.701423652783648e-02,  -1.466304239326581e-03,   1.302168676520336e-04,  -9.047119356320436e-06,   5.481194821371614e-07,
  -3.021520643461535e-08,   1.504209463350559e-09,  -6.873339373021344e-11,   2.943782075993674e-12,  -1.174518511846700e-13,   4.369470651080546e-15,  -1.545235345847503e-16,
   5.165211651965731e-18,  -1.612837705281436e-19,   1.704064931592000e-02,  -1.471734683103506e-03,   1.308731138930698e-04,  -9.107387000845122e-06,   5.526246986609863e-07,
  -3.050384841406882e-08,   1.520712465011814e-09,  -6.958128701393985e-11,   2.983281360372788e-12,  -1.191608068162252e-13,   4.438109838645022e-15,  -1.570638652565701e-16,
   5.254495805137570e-18,  -1.642616099577543e-19,   1.706195982989885e-02,  -1.476118126835554e-03,   1.314030739930709e-04,  -9.156075756370463e-06,   5.562658449317375e-07,
  -3.073722255989493e-08,   1.534059701054200e-09,  -7.026726482121171e-11,   3.015248325070651e-12,  -1.205441621455373e-13,   4.493684727793618e-15,  -1.591213687549775e-16,
   5.326812909196660e-18,  -1.666737983418026e-19,   1.707605747690026e-02,  -1.479018918367858e-03,   1.317538981371895e-04,  -9.188316077806007e-06,   5.586776401381297e-07,
  -3.089184812174556e-08,   1.542905148568354e-09,  -7.072198295563281e-11,   3.036443617901268e-12,  -1.214615202995697e-13,   4.530545130279345e-15,  -1.604863543461030e-16,
   5.374790797891228e-18,  -1.682742509810177e-19,   1.708330225780215e-02,  -1.480509941692058e-03,   1.319342600236681e-04,  -9.204893976925638e-06,   5.599180057037526e-07,
  -3.097138462023621e-08,   1.547455710914406e-09,  -7.095594740150596e-11,   3.047350750186447e-12,  -1.219336382180763e-13,   4.549517317748844e-15,  -1.611890204586365e-16,
   5.399489259040315e-18,  -1.690981809888847e-19,   1.708582466090766e-02,  -1.481029117566091e-03,   1.319970679974003e-04,  -9.210667404447851e-06,   5.603500120228821e-07,
  -3.099908856129049e-08,   1.549040850878838e-09,  -7.103745177026976e-11,   3.051150636842281e-12,  -1.220981242463111e-13,   4.556127551767421e-15,  -1.614338576974279e-16,
   5.408095271920085e-18,  -1.693852794897710e-19,   1.708622496908962e-02,  -1.481111513672574e-03,   1.320070362473521e-04,  -9.211583726393543e-06,   5.604185790448931e-07,
  -3.100348577037856e-08,   1.549292451315520e-09,  -7.105038875836217e-11,   3.051753795569374e-12,  -1.221242335633339e-13,   4.557176827380449e-15,  -1.614727227175714e-16,
   5.409461378269456e-18,  -1.694308533672898e-19,   5.272277821935607e-04,  -1.103052343315153e-04,   1.592587451109297e-05,  -1.710664393390628e-06,   1.497738024541300e-07,
  -1.113038651767186e-08,   7.193046629074484e-10,  -4.120689799475204e-11,   2.121626249848210e-12,  -9.916008660167585e-14,   4.244554723007104e-15,  -1.676347210691379e-16,
   6.141124702147952e-18,  -2.096080025574955e-19,   5.289024682489306e-04,  -1.108258731547018e-04,   1.601627358844755e-05,  -1.721835513951281e-06,   1.508565651710697e-07,
  -1.121728083930586e-08,   7.252752986087483e-10,  -4.156605082164795e-11,   2.140862463319807e-12,  -1.000894863126591e-13,   4.285449515423324e-15,  -1.692872618500093e-16,
   6.202914263847499e-18,  -2.117535128345057e-19,   5.318651206532560e-04,  -1.117472332632115e-04,   1.617629637324283e-05,  -1.741615161605971e-06,   1.527741028754142e-07,
  -1.137119428939619e-08,   7.358524463138909e-10,  -4.220238007897747e-11,   2.174947898408130e-12,  -1.017364782390846e-13,   4.357925310979369e-15,  -1.722161857390915e-16,
   6.312434858275645e-18,  -2.155566156076297e-19,   5.354606525874745e-04,  -1.128659405921625e-04,   1.637067321570554e-05,  -1.765649232200225e-06,   1.551047547628154e-07,
  -1.155831194052122e-08,   7.487140445925318e-10,  -4.297628018241484e-11,   2.216408665067556e-12,  -1.037400995610481e-13,   4.446104830830689e-15,  -1.757800915128871e-16,
   6.445709859228779e-18,  -2.201849899245669e-19,   5.389648482912396e-04,  -1.139567819898660e-04,   1.656029067219340e-05,  -1.789103290275050e-06,   1.573798624035631e-07,
  -1.174101744846268e-08,   7.612751090020992e-10,  -4.373223983132135e-11,   2.256914842905957e-12,  -1.056978588998802e-13,   4.532276715456351e-15,  -1.792632289339667e-16,
   6.575975653519745e-18,  -2.247092785516991e-19,   5.417976369055956e-04,  -1.148390130263519e-04,   1.671370508703491e-05,  -1.808085412125685e-06,   1.592216825155612e-07,
  -1.188896109649519e-08,   7.714482448160526e-10,  -4.434458984320358e-11,   2.289730756329163e-12,  -1.072841224885088e-13,   4.602104707928100e-15,  -1.820860004794896e-16,
   6.681552457195311e-18,  -2.283763876181690e-19,   5.436743289157453e-04,  -1.154236754345558e-04,   1.681540309481054e-05,  -1.820671582227596e-06,   1.604431545216955e-07,
  -1.198709204605010e-08,   7.781970406549625e-10,  -4.475086925970206e-11,   2.311505618156673e-12,  -1.083367754708803e-13,   4.648446705901310e-15,  -1.839594900790833e-16,
   6.751628312452770e-18,  -2.308105513557885e-19,   5.446395978924453e-04,  -1.157244541247291e-04,   1.686773041699193e-05,  -1.827148543161389e-06,   1.610718114911120e-07,
  -1.203760238480029e-08,   7.816711034353933e-10,  -4.496002433074367e-11,   2.322716157243463e-12,  -1.088787510322599e-13,   4.672307804544920e-15,  -1.849241743442128e-16,
   6.787712499938277e-18,  -2.320640213403358e-19,   5.449758072641131e-04,  -1.158292268104397e-04,   1.688595944072168e-05,  -1.829405037893869e-06,   1.612908400659639e-07,
  -1.205520136282903e-08,   7.828815950087393e-10,  -4.503290413784067e-11,   2.326622567721601e-12,  -1.090676118055309e-13,   4.680622803079248e-15,  -1.852603492243967e-16,
   6.800287374720949e-18,  -2.325008466646415e-19,   5.450291703954355e-04,  -1.158458567776750e-04,   1.688885289657429e-05,  -1.829763213653444e-06,   1.613256072742072e-07,
  -1.205799495180342e-08,   7.830737456748443e-10,  -4.504447302900854e-11,   2.327242674035620e-12,  -1.090975919163631e-13,   4.681942750226716e-15,  -1.853137149122948e-16,
   6.802283567673399e-18,  -2.325701906484228e-19,   3.913080399087842e-01,  -7.504853426582214e-03,   1.659439627753973e-04,  -3.687677338023603e-06,   1.085180995580181e-07,
  -2.503123567783466e-09,   2.039908550155187e-11,  -1.532541612583345e-12,   9.453369448664848e-14,   9.605027768844751e-16,  -7.472611163752371e-17,  -5.139767271843072e-18,
   6.752396088281792e-20,   1.048158244586008e-20,   3.913237200272508e-01,  -7.505898943041802e-03,   1.660051836538258e-04,  -3.690049001458518e-06,   1.085496379272165e-07,
  -2.506100293818211e-09,   2.064107273296633e-11,  -1.529913163812003e-12,   9.423309074803644e-14,   9.365912987152332e-16,  -7.427537657160015e-17,  -5.071852211857646e-18,
   6.828925125628710e-20,   1.032039418016832e-20,   3.913513925317250e-01,  -7.507744319940391e-03,   1.661132239500975e-04,  -3.694236095853566e-06,   1.086055621310307e-07,
  -2.511348864169197e-09,   2.106743045313027e-11,  -1.525338961191890e-12,   9.370424392866462e-14,   8.946750154974333e-16,  -7.347661156639395e-17,  -4.952945856236993e-18,
   6.960167905345209e-20,   1.003801513201379e-20,   3.913848624154482e-01,  -7.509976701850877e-03,   1.662438932507761e-04,  -3.699303021543733e-06,   1.086736534146576e-07,
  -2.517688893697992e-09,   2.158191052785887e-11,  -1.519915954830816e-12,   9.306744664494459e-14,   8.444571946879118e-16,  -7.250500378769549e-17,  -4.810741936288481e-18,
   7.112480808137767e-20,   9.700028813622370e-21,   3.914173627733279e-01,  -7.512144836464341e-03,   1.663707718928306e-04,  -3.704225930834562e-06,   1.087402438142421e-07,
  -2.523836862325796e-09,   2.208023482873870e-11,  -1.514764021567463e-12,   9.245208114398488e-14,   7.961931335891003e-16,  -7.155593973642417e-17,  -4.674335767332892e-18,
   7.253758142644223e-20,   9.375538720131182e-21,   3.914435506398450e-01,  -7.513892157772551e-03,   1.664730032038169e-04,  -3.708194645159700e-06,   1.087942377873368e-07,
  -2.528784758761314e-09,   2.248087512802061e-11,  -1.510693935466417e-12,   9.195838221939398e-14,   7.576584849629430e-16,  -7.078730979599497e-17,  -4.565618510998093e-18,
   7.362923016140160e-20,   9.116719668395792e-21,   3.914608580540359e-01,  -7.515047099558476e-03,   1.665405654246282e-04,  -3.710818511626970e-06,   1.088300870460961e-07,
  -2.532051901626633e-09,   2.274521864453810e-11,  -1.508043602825614e-12,   9.163315202994035e-14,   7.323640663564827e-16,  -7.027746131563878e-17,  -4.494349868218742e-18,
   7.432811107193917e-20,   8.946959266302595e-21,   3.914697471481867e-01,  -7.515640323528305e-03,   1.665752648306252e-04,  -3.712166428748931e-06,   1.088485502025032e-07,
  -2.533729017687293e-09,   2.288085049932575e-11,  -1.506694585969127e-12,   9.146643972145945e-14,   7.194261099620460e-16,  -7.001503558372780e-17,  -4.457925588599802e-18,
   7.468013459690411e-20,   8.860168890979740e-21,   3.914728412235037e-01,  -7.515846817457390e-03,   1.665873427505192e-04,  -3.712635653069219e-06,   1.088549848830940e-07,
  -2.534312639427272e-09,   2.292803913111701e-11,  -1.506226964159077e-12,   9.140846320973515e-14,   7.149311865338271e-16,  -6.992360214702954e-17,  -4.445275680641590e-18,
   7.480156887410655e-20,   8.830022680681980e-21,   3.914733322175133e-01,  -7.515879586002107e-03,   1.665892593725743e-04,  -3.712710115802027e-06,   1.088560063774629e-07,
  -2.534405246763518e-09,   2.293552640225751e-11,  -1.506152849900864e-12,   9.139926547404913e-14,   7.142182954228585e-16,  -6.990908848564190e-17,  -4.443269637650855e-18,
   7.482078714981991e-20,   8.825241833039938e-21,   1.305898591478099e-01,  -3.863349499129766e-03,   1.832937643499977e-04,  -7.779969090116137e-06,   2.776538745376325e-07,
  -1.004296837748472e-08,   3.696595959364866e-10,  -1.090556449701664e-11,   2.909724200844251e-13,  -1.129367177597423e-14,   3.669321979550756e-16,  -4.673200487387256e-18,
   1.506495023925875e-19,  -1.362988291268169e-20,   1.306073625100103e-01,  -3.865571472699756e-03,   1.834529373154695e-04,  -7.789570699741114e-06,   2.781831782534384e-07,
  -1.006505838139647e-08,   3.704561264470435e-10,  -1.094441850166231e-11,   2.925524016102993e-13,  -1.132142732065907e-14,   3.679184298084902e-16,  -4.767987939435247e-18,
   1.517752269349334e-19,  -1.353838811188287e-20,   1.306382599600322e-01,  -3.869494408210218e-03,   1.837340448306714e-04,  -7.806529919675355e-06,   2.791180665848019e-07,
  -1.010409910157745e-08,   3.718650085309608e-10,  -1.101305583712930e-11,   2.953437354096228e-13,  -1.137079491365316e-14,   3.696646293887845e-16,  -4.934726200657962e-18,
   1.537903877860235e-19,  -1.337904828064827e-20,   1.306756427998965e-01,  -3.874241865717627e-03,   1.840743799110969e-04,  -7.827066257835910e-06,   2.802501210243836e-07,
  -1.015141431752025e-08,   3.735744316007639e-10,  -1.109618798521355e-11,   2.987249116116918e-13,  -1.143115853966564e-14,   3.717864417479654e-16,  -5.135477048018687e-18,
   1.562757476471098e-19,  -1.318994532414759e-20,   1.307119557495006e-01,  -3.878854600154497e-03,   1.844052082341240e-04,  -7.847033061355877e-06,   2.813507552092203e-07,
  -1.019745902173088e-08,   3.752399773341753e-10,  -1.117703369438870e-11,   3.020134598965277e-13,  -1.149045600264178e-14,   3.738571570505886e-16,  -5.329461313327623e-18,
   1.587387547541159e-19,  -1.301008891187724e-20,   1.307412250048342e-01,  -3.882573416629190e-03,   1.846720325450811e-04,  -7.863139928414651e-06,   2.822386002391931e-07,
  -1.023463230138269e-08,   3.765860711717062e-10,  -1.124226467384488e-11,   3.046670991510123e-13,  -1.153872375190440e-14,   3.755331909246499e-16,  -5.485094373524900e-18,
   1.607584906705038e-19,  -1.286785152014701e-20,   1.307605734536884e-01,  -3.885032144455612e-03,   1.848484988118470e-04,  -7.873793779231922e-06,   2.828258552838811e-07,
  -1.025923507471041e-08,   3.774776786348958e-10,  -1.128541870562741e-11,   3.064227499014737e-13,  -1.157086178232510e-14,   3.766445827728535e-16,  -5.587624514963914e-18,
   1.621103347274541e-19,  -1.277515678403220e-20,   1.307705122355401e-01,  -3.886295252060577e-03,   1.849391701824053e-04,  -7.879268359203774e-06,   2.831276193120909e-07,
  -1.027188194687745e-08,   3.779362216614394e-10,  -1.130759605904825e-11,   3.073250338006839e-13,  -1.158744141439188e-14,   3.772165485463352e-16,  -5.640183605868350e-18,
   1.628098650608205e-19,  -1.272795234501291e-20,   1.307739719061444e-01,  -3.886734957217761e-03,   1.849707367472134e-04,  -7.881174365324452e-06,   2.832326797940814e-07,
  -1.027628574479136e-08,   3.780959268583711e-10,  -1.131531759339527e-11,   3.076391892571898e-13,  -1.159322407203255e-14,   3.774158202047700e-16,  -5.658462205265536e-18,
   1.630541824526096e-19,  -1.271158578222341e-20,   1.307745209265753e-01,  -3.886804735645955e-03,   1.849757462854328e-04,  -7.881476847336585e-06,   2.832493528108144e-07,
  -1.027698465889733e-08,   3.781212748636538e-10,  -1.131654301349891e-11,   3.076890464966487e-13,  -1.159414226797837e-14,   3.774474510826167e-16,  -5.661362052823027e-18,
   1.630929920426540e-19,  -1.270899164056513e-20,   1.267960641145227e-02,  -7.404036835886212e-04,   5.873022558886867e-05,  -3.608780096775702e-06,   1.877887165567813e-07,
  -9.347554309133276e-09,   4.340676615472141e-10,  -1.788908743129074e-11,   6.968811079215489e-13,  -2.695560941420381e-14,   9.472372498119065e-16,  -2.980700835619636e-17,
   9.934155154929753e-19,  -3.251248316387465e-20,   1.268533170051500e-02,  -7.414506814727685e-04,   5.883944341431763e-05,  -3.617853878912813e-06,   1.884219291203494e-07,
  -9.384298618831090e-09,   4.359844954372741e-10,  -1.798436343680808e-11,   7.010877036947330e-13,  -2.711910005657406e-14,   9.537281970990991e-16,  -3.005691693603274e-17,
   1.000743225585181e-18,  -3.273000630607444e-20,   1.269544282162582e-02,  -7.433002551213348e-04,   5.903245499155196e-05,  -3.633893190504086e-06,   1.895414688733689e-07,
  -9.449289169049595e-09,   4.393758850647152e-10,  -1.815293530037113e-11,   7.085328770874604e-13,  -2.740864210037250e-14,   9.652191968728054e-16,  -3.049920438007701e-17,
   1.013741737131349e-18,  -3.311579376889175e-20,   1.270768424765313e-02,  -7.455404147599573e-04,   5.926635037434154e-05,  -3.653336740552158e-06,   1.908990314183105e-07,
  -9.528140612764285e-09,   4.434923495519465e-10,  -1.835755347400730e-11,   7.175742317426725e-13,  -2.776057105121341e-14,   9.791786202961493e-16,  -3.103628159947206e-17,
   1.029576727697527e-18,  -3.358565640030117e-20,   1.271958368894147e-02,  -7.477189358131556e-04,   5.949394036468030e-05,  -3.672263245600334e-06,   1.922209214484537e-07,
  -9.604965518771095e-09,   4.475048787868468e-10,  -1.855701187096883e-11,   7.263919284641560e-13,  -2.810411959702856e-14,   9.927979107463427e-16,  -3.156004234441505e-17,
   1.045071633944761e-18,  -3.404533266381749e-20,   1.272918097125496e-02,  -7.494766600880281e-04,   5.967766314120050e-05,  -3.687546838136984e-06,   1.932886855021412e-07,
  -9.667053797878223e-09,   4.507490554702747e-10,  -1.871828130994761e-11,   7.335244537382472e-13,  -2.838224409064216e-14,   1.003818170704140e-15,  -3.198368655479915e-17,
   1.057641950957669e-18,  -3.441819260347898e-20,   1.273552819732085e-02,  -7.506394742935012e-04,   5.979924982462068e-05,  -3.697663936648119e-06,   1.939956511836108e-07,
  -9.708178312753028e-09,   4.528985077134650e-10,  -1.882513408621310e-11,   7.382517819820909e-13,  -2.856669415873019e-14,   1.011124110844716e-15,  -3.226446302705653e-17,
   1.065991193456356e-18,  -3.466582594497487e-20,   1.273878950779359e-02,  -7.512370501991777e-04,   5.986174796505381e-05,  -3.702865115457727e-06,   1.943591473358554e-07,
  -9.729327968665691e-09,   4.540041376243125e-10,  -1.888009757123459e-11,   7.406839152571919e-13,  -2.866162570830206e-14,   1.014883485343694e-15,  -3.240891557025035e-17,
   1.070292227773575e-18,  -3.479338647728677e-20,   1.273992490851014e-02,  -7.514451080934770e-04,   5.988351018386134e-05,  -3.704676319839205e-06,   1.944857348744051e-07,
  -9.736694119411585e-09,   4.543892463806680e-10,  -1.889924237348456e-11,   7.415311464514975e-13,  -2.869470058263796e-14,   1.016193153711113e-15,  -3.245923511186082e-17,
   1.071791359382764e-18,  -3.483784711049949e-20,   1.274010509386955e-02,  -7.514781271558326e-04,   5.988696398363924e-05,  -3.704963775125138e-06,   1.945058258678023e-07,
  -9.737863254946760e-09,   4.544503713302674e-10,  -1.890228106708825e-11,   7.416656238519693e-13,  -2.869995068059641e-14,   1.016401036268452e-15,  -3.246722210191584e-17,
   1.072029351435395e-18,  -3.484490534703041e-20,   2.518487266544281e-04,  -3.660092071919949e-05,   4.655480478793889e-06,  -4.444822775558040e-07,   3.533766930626835e-08,
  -2.447951787933377e-09,   1.494318804589608e-10,  -8.145184789922526e-12,   4.032330782578419e-13,  -1.827201152030963e-14,   7.596185004590122e-16,  -2.925726608057515e-17,
   1.054452969379889e-18,  -3.535821581732575e-20,   2.523276629434583e-04,  -3.673455746000242e-05,   4.676627603499557e-06,  -4.469220179456904e-07,   3.556128463958507e-08,
  -2.465045957719770e-09,   1.505619496939905e-10,  -8.211114348276419e-12,   4.066652421550327e-13,  -1.843381165626248e-14,   7.666199679642228e-16,  -2.953541040577371e-17,
   1.064629904567525e-18,  -3.570921629422749e-20,   2.531745203590772e-04,  -3.697094505732933e-05,   4.714047518950090e-06,  -4.512403372603251e-07,   3.595717787787769e-08,
  -2.495316537273078e-09,   1.525634386642477e-10,  -8.327900173399135e-12,   4.127457866998873e-13,  -1.872049680340616e-14,   7.790262558009308e-16,  -3.002832405923180e-17,
   1.082667780474712e-18,  -3.633128583902544e-20,   2.542015680315157e-04,  -3.725778451200293e-05,   4.759476360061993e-06,  -4.564849306878039e-07,   3.643815365379676e-08,
  -2.532104096819003e-09,   1.549964234513927e-10,  -8.469891932786047e-12,   4.201402374990544e-13,  -1.906918837730832e-14,   7.941171663403733e-16,  -3.062799267035785e-17,
   1.104617075688819e-18,  -3.708815965109605e-20,   2.552017770173544e-04,  -3.753729018495068e-05,   4.803767223442318e-06,  -4.616002777248436e-07,   3.690744817994817e-08,
  -2.568010202255692e-09,   1.573717344361151e-10,  -8.608547532511625e-12,   4.273625640280706e-13,  -1.940982456795874e-14,   8.088608182315962e-16,  -3.121395848383724e-17,
   1.126069810680378e-18,  -3.782782142969322e-20,   2.560098083708497e-04,  -3.776320839437938e-05,   4.839583406124946e-06,  -4.657383728539114e-07,   3.728721033672732e-08,
  -2.597074703740261e-09,   1.592948960288210e-10,  -8.720830841512353e-12,   4.332123579073893e-13,  -1.968577010998897e-14,   8.208054705538113e-16,  -3.168875058555472e-17,
   1.143455940444478e-18,  -3.842721039931280e-20,   2.565448577129675e-04,  -3.791286015771984e-05,   4.863316865400205e-06,  -4.684812135809847e-07,   3.753898718896004e-08,
  -2.616348255249383e-09,   1.605704211289684e-10,  -8.795312497186041e-12,   4.370933059026465e-13,  -1.986886308170376e-14,   8.287313667271748e-16,  -3.200383320442185e-17,
   1.154995502200039e-18,  -3.882500893753164e-20,   2.568199769512296e-04,  -3.798982779698273e-05,   4.875525812843961e-06,  -4.698924147085084e-07,   3.766854589662081e-08,
  -2.626267291308765e-09,   1.612269312115601e-10,  -8.833651276828005e-12,   4.390911641749030e-13,  -1.996312345914942e-14,   8.328119466478427e-16,  -3.216606110502846e-17,
   1.160937460567096e-18,  -3.902983475170141e-20,   2.569157898157381e-04,  -3.801663530031374e-05,   4.879778544127917e-06,  -4.703840138775079e-07,   3.771368130506876e-08,
  -2.629723072478071e-09,   1.614556693438987e-10,  -8.847009606581296e-12,   4.397873029900322e-13,  -1.999596884332672e-14,   8.342338640970613e-16,  -3.222259261984278e-17,
   1.163008138471146e-18,  -3.910121189476856e-20,   2.569309966141356e-04,  -3.802089014676684e-05,   4.880453550512502e-06,  -4.704620437325380e-07,   3.772084563491047e-08,
  -2.630271617403545e-09,   1.614919780389399e-10,  -8.849130062382033e-12,   4.398978070120662e-13,  -2.000118272015256e-14,   8.344595804353629e-16,  -3.223156655637767e-17,
   1.163336846460236e-18,  -3.911254253241278e-20,   3.637002806299057e-01,  -6.328472102644770e-03,   1.305189606393743e-04,  -2.333593430460602e-06,   6.167357648662608e-08,
  -2.184076775215505e-09,   1.897827121367335e-11,   1.160495420700331e-12,   4.296507262403365e-14,  -3.849439318842223e-15,  -7.169272429188764e-17,   6.679896822413544e-18,
   2.022276194619558e-19,  -1.272464659303870e-20,   3.637125867215187e-01,  -6.329135571734756e-03,   1.305538104001684e-04,  -2.335623591846320e-06,   6.170152583865287e-08,
  -2.181984152978109e-09,   1.908561752534689e-11,   1.148307188608732e-12,   4.269689049106884e-14,  -3.818142379439837e-15,  -7.060245000640405e-17,   6.597423705359235e-18,
   1.986482017861430e-19,  -1.252815319579875e-20,   3.637343036895347e-01,  -6.330306734655848e-03,   1.306153164280238e-04,  -2.339204307137975e-06,   6.175096354196288e-08,
  -2.178310806321730e-09,   1.927447982087202e-11,   1.126884460151806e-12,   4.222728006331779e-14,  -3.763253560806660e-15,  -6.869585636862421e-17,   6.453021793001714e-18,
   1.924048101877128e-19,  -1.218480101668377e-20,   3.637605686424419e-01,  -6.331723703660581e-03,   1.306897125078739e-04,  -2.343531536392130e-06,   6.181094940996790e-08,
  -2.173901464666475e-09,   1.950191811389252e-11,   1.101121793888294e-12,   4.166552308533930e-14,  -3.697449673079016e-15,  -6.641948916370142e-17,   6.280311265834792e-18,
   1.849776812723563e-19,  -1.177530329382687e-20,   3.637860709835017e-01,  -6.333100095750018e-03,   1.307619583692378e-04,  -2.347729614997601e-06,   6.186939707589936e-08,
  -2.169654880390778e-09,   1.972173759771053e-11,   1.076259682651584e-12,   4.112651814988339e-14,  -3.634159467517083e-15,  -6.423980387416376e-17,   6.114621512137449e-18,
   1.778941952996263e-19,  -1.138366539001725e-20,   3.638066187629240e-01,  -6.334209488871635e-03,   1.308201755197789e-04,  -2.351109591948233e-06,   6.191663501594961e-08,
  -2.166258116619958e-09,   1.989812824548165e-11,   1.056336465170107e-12,   4.069680975823183e-14,  -3.583594393391285e-15,  -6.250528162310767e-17,   5.982546977502582e-18,
   1.722774653014195e-19,  -1.107234878072454e-20,   3.638201980468164e-01,  -6.334942844663970e-03,   1.308586526266741e-04,  -2.353342073872984e-06,   6.194792389553991e-08,
  -2.164025426672619e-09,   2.001434653140027e-11,   1.043222931676177e-12,   4.041505884063057e-14,  -3.550386748355146e-15,  -6.136953413474319e-17,   5.895956661691132e-18,
   1.686094757755552e-19,  -1.086866690118333e-20,   3.638271721776166e-01,  -6.335319547182235e-03,   1.308784150166447e-04,  -2.354488268157510e-06,   6.196401536096566e-08,
  -2.162882485553582e-09,   2.007392619271822e-11,   1.036504345567080e-12,   4.027104141624817e-14,  -3.533396147834727e-15,  -6.078946965330411e-17,   5.851698355465863e-18,
   1.667391301473948e-19,  -1.076469090145761e-20,   3.638295996703038e-01,  -6.335450676147328e-03,   1.308852939043881e-04,  -2.354887165154041e-06,   6.196961982214677e-08,
  -2.162485255224054e-09,   2.009464691877547e-11,   1.034168397848010e-12,   4.022102205462989e-14,  -3.527492440349481e-15,  -6.058808012237088e-17,   5.836327183868700e-18,
   1.660902550893426e-19,  -1.072860018836978e-20,   3.638299848838824e-01,  -6.335471485182423e-03,   1.308863855084590e-04,  -2.354950462411293e-06,   6.197050934756047e-08,
  -2.162422247801374e-09,   2.009793422903725e-11,   1.033797834555544e-12,   4.021308975567240e-14,  -3.526556078846684e-15,  -6.055614642439364e-17,   5.833889571453247e-18,
   1.659873878342476e-19,  -1.072287778676114e-20,   1.175677684874374e-01,  -2.707502029175745e-03,   1.112752552650148e-04,  -4.551125381402399e-06,   1.449624538259882e-07,
  -4.066610597916750e-09,   1.516345813052588e-10,  -5.631902591776044e-12,   1.027044126897516e-13,  -6.266901342920172e-16,   1.377105556237483e-16,  -7.589339163573918e-18,
  -6.268326916603483e-20,   8.586952142994610e-21,   1.175783666998542e-01,  -2.708795810075276e-03,   1.113580208636923e-04,  -4.555031528034621e-06,   1.451790357087472e-07,
  -4.077749414711471e-09,   1.519159822322789e-10,  -5.634976793848400e-12,   1.032770270825642e-13,  -6.637857708340610e-16,   1.374339011069832e-16,  -7.535608745337664e-18,
  -6.022347882834525e-20,   8.418656502358650e-21,   1.175970738679556e-01,  -2.711079616349778e-03,   1.115041619082703e-04,  -4.561932491783359e-06,   1.455615242101550e-07,
  -4.097409421979409e-09,   1.524137358610187e-10,  -5.640501592427475e-12,   1.042865612259711e-13,  -7.290254573139984e-16,   1.369576587473573e-16,  -7.441763179616366e-18,
  -5.592474744816793e-20,   8.124535947087711e-21,   1.176197057881349e-01,  -2.713842771449854e-03,   1.116810475667014e-04,  -4.570291718348389e-06,   1.460245908173956e-07,
  -4.121191811651559e-09,   1.530176992566553e-10,  -5.647352897690739e-12,   1.055058736878531e-13,  -8.075481381904533e-16,   1.364019651306349e-16,  -7.329914205169304e-18,
  -5.079687824366049e-20,   7.773679524246497e-21,   1.176416880036519e-01,  -2.716526821696082e-03,   1.118529436196005e-04,  -4.578421906819065e-06,   1.464747128057687e-07,
  -4.144289220081834e-09,   1.536061873010469e-10,  -5.654182237892633e-12,   1.066881015022300e-13,  -8.833969221815636e-16,   1.358834676691069e-16,  -7.223025935309601e-18,
  -4.589140975986432e-20,   7.438041270834453e-21,   1.176594048632084e-01,  -2.718690224689513e-03,   1.119915488455920e-04,  -4.584982371623666e-06,   1.468377451890198e-07,
  -4.162903365723568e-09,   1.540818200100769e-10,  -5.659811202140994e-12,   1.076394673926408e-13,  -9.442300871840809e-16,   1.354806678925753e-16,  -7.138121049463797e-18,
  -4.199097592987282e-20,   7.171174827899178e-21,   1.176711159008271e-01,  -2.720120334738221e-03,   1.120831994205366e-04,  -4.589322743415142e-06,   1.470778364904834e-07,
  -4.175206813333567e-09,   1.543968703053221e-10,  -5.663592927758936e-12,   1.082676226676129e-13,  -9.842965079968700e-16,   1.352217487546594e-16,  -7.082602401919433e-18,
  -3.943851831177813e-20,   6.996541587957673e-21,   1.176771313326667e-01,  -2.720854941642474e-03,   1.121302857780764e-04,  -4.591553381694062e-06,   1.472011986332449e-07,
  -4.181526329160901e-09,   1.545588988682295e-10,  -5.665554232757918e-12,   1.085900608855004e-13,  -1.004832208672601e-15,   1.350910111674259e-16,  -7.054270987218281e-18,
  -3.813534805818423e-20,   6.907383726454220e-21,   1.176792252584291e-01,  -2.721110656485274e-03,   1.121466777055658e-04,  -4.592330038428533e-06,   1.472441461157964e-07,
  -4.183726071461829e-09,   1.546153318240206e-10,  -5.666239938198157e-12,   1.087022648322397e-13,  -1.011973446008811e-15,   1.350458608125072e-16,  -7.044438570823437e-18,
  -3.768297892919364e-20,   6.876434746342947e-21,   1.176795575450870e-01,  -2.721151236247162e-03,   1.121492790253903e-04,  -4.592453295625481e-06,   1.472509617722099e-07,
  -4.184075148684804e-09,   1.546242887337038e-10,  -5.666348895198077e-12,   1.087200689353193e-13,  -1.013106358498225e-15,   1.350387128627264e-16,  -7.042879657595530e-18,
  -3.761125157982297e-20,   6.871527514648967e-21,   1.044056803386229e-02,  -4.039302400441522e-04,   2.873982412740616e-05,  -1.668047391473001e-06,   7.444419921541865e-08,
  -3.107021467060758e-09,   1.400036668439855e-10,  -5.732086753726882e-12,   1.844775971091242e-13,  -5.926796006747393e-15,   2.506933552313615e-16,  -8.543564242426961e-18,
   1.383461782999870e-19,  -3.470152643931764e-21,   1.044334878358970e-02,  -4.044100047284547e-04,   2.878284759434266e-05,  -1.671058297637768e-06,   7.464710860207262e-08,
  -3.118646171625118e-09,   1.405105328281237e-10,  -5.753274052941050e-12,   1.855676371237165e-13,  -5.972045174778461e-15,   2.516815398462247e-16,  -8.573591247661364e-18,
   1.412238443457366e-19,  -3.554745811271724e-21,   1.044825887812859e-02,  -4.052572627324217e-04,   2.885885740730714e-05,  -1.676380054979114e-06,   7.500573384674779e-08,
  -3.139192644358567e-09,   1.414072521559279e-10,  -5.790784431658986e-12,   1.874945346781063e-13,  -6.052018672164720e-15,   2.534394908879322e-16,  -8.627074528895428e-18,
   1.462838140091835e-19,  -3.703803664628863e-21,   1.045420204989041e-02,  -4.062829808261991e-04,   2.895093014104600e-05,  -1.682830486997193e-06,   7.544039251426528e-08,
  -3.164096619646897e-09,   1.424955806670454e-10,  -5.836355864427476e-12,   1.898305690519514e-13,  -6.148947643986531e-15,   2.555895211132706e-16,  -8.692599092442486e-18,
   1.523727000150405e-19,  -3.883697138842828e-21,   1.045997769302209e-02,  -4.072799935407647e-04,   2.904048144399309e-05,  -1.689108506653869e-06,   7.586340661462341e-08,
  -3.188334887176038e-09,   1.435563128205382e-10,  -5.880819701024152e-12,   1.921046860343683e-13,  -6.243281180655984e-15,   2.577021039476800e-16,  -8.757100408901449e-18,
   1.582532668349343e-19,  -4.057976929163967e-21,   1.046463486196881e-02,  -4.080840804937174e-04,   2.911274384223027e-05,  -1.694177515335476e-06,   7.620493883854180e-08,
  -3.207905409611099e-09,   1.444138400893594e-10,  -5.916799826079634e-12,   1.939412541264762e-13,  -6.319445838039008e-15,   2.594221006025954e-16,  -8.809699673977394e-18,
   1.629692454121287e-19,  -4.198123593807584e-21,   1.046771438560946e-02,  -4.086158511853930e-04,   2.916055287730153e-05,  -1.697532672030633e-06,   7.643098884676208e-08,
  -3.220859095569017e-09,   1.449819571016087e-10,  -5.940653596280915e-12,   1.951570747458876e-13,  -6.369858227598994e-15,   2.605674992534519e-16,  -8.844768357180935e-18,
   1.660752226480544e-19,  -4.290609368519559e-21,   1.046929653346231e-02,  -4.088890784130124e-04,   2.918512346725403e-05,  -1.699257453056404e-06,   7.654719140632200e-08,
  -3.227518196000857e-09,   1.452741699513533e-10,  -5.952928020924445e-12,   1.957821549362858e-13,  -6.395773533643543e-15,   2.611584506629530e-16,  -8.862874242014883e-18,
   1.676671577911058e-19,  -4.338068395333632e-21,   1.046984732043419e-02,  -4.089841995571165e-04,   2.919367841079369e-05,  -1.699858057222994e-06,   7.658765510252271e-08,
  -3.229837034501927e-09,   1.453759501939096e-10,  -5.957204128695545e-12,   1.959998311913321e-13,  -6.404797763301156e-15,   2.613645716570268e-16,  -8.869191508906167e-18,
   1.682207501455969e-19,  -4.354581120223149e-21,   1.046993472777029e-02,  -4.089992950127767e-04,   2.919503610138402e-05,  -1.699953378048643e-06,   7.659407700433527e-08,
  -3.230205053413594e-09,   1.453921047774576e-10,  -5.957882872428037e-12,   1.960343787068405e-13,  -6.406229982429415e-15,   2.613973008607053e-16,  -8.870194700667710e-18,
   1.683085741873346e-19,  -4.357201186601948e-21,   1.560425484384721e-04,  -1.383558270297508e-05,   1.567333698034105e-06,  -1.333310470702820e-07,   9.327402255767211e-09,
  -5.875019324579929e-10,   3.380287670742982e-11,  -1.740210636388743e-12,   8.089834280406798e-14,  -3.520109835073552e-15,   1.440264833898947e-16,  -5.350358789948312e-18,
   1.816906250287408e-19,  -6.120117216835811e-21,   1.562005977755661e-04,  -1.387513715238453e-05,   1.572865362067279e-06,  -1.339125461702023e-07,   9.377629493472912e-09,
  -5.911310395622112e-10,   3.402871668487464e-11,  -1.752866883158152e-12,   8.154528104019567e-14,  -3.549584448530542e-15,   1.452362110123873e-16,  -5.398342871575909e-18,
   1.835197827521384e-19,  -6.177950325190401e-21,   1.564799346400363e-04,  -1.394506998785462e-05,   1.582649682395846e-06,  -1.349414398358781e-07,   9.466519802419924e-09,
  -5.975552997395903e-10,   3.442861962194113e-11,  -1.775281304523517e-12,   8.269103866629636e-14,  -3.601797365090975e-15,   1.473801199266468e-16,  -5.483362011562947e-18,
   1.867585009459282e-19,  -6.280489973700182e-21,   1.568184911799247e-04,  -1.402986994300611e-05,   1.594521332452129e-06,  -1.361904243216613e-07,   9.574457418266225e-09,
  -6.053588742167893e-10,   3.491458798441144e-11,  -1.802525736159557e-12,   8.408372697400866e-14,  -3.665283483554894e-15,   1.499884972433683e-16,  -5.586767662117260e-18,
   1.906938950562993e-19,  -6.405322379060196e-21,   1.571479739345113e-04,  -1.411244044184408e-05,   1.606088482470922e-06,  -1.374079943371195e-07,   9.679714578947299e-09,
  -6.129715218957786e-10,   3.538888044075966e-11,  -1.829121967837444e-12,   8.544331985338189e-14,  -3.727282213750179e-15,   1.525374067348090e-16,  -5.687782541916312e-18,
   1.945344451729514e-19,  -6.527388969182617e-21,   1.574139882173709e-04,  -1.417913639188570e-05,   1.615437253761074e-06,  -1.383925008413044e-07,   9.764848427674646e-09,
  -6.191308168773794e-10,   3.577277749386920e-11,  -1.850653801967362e-12,   8.654405206483638e-14,  -3.777491820564949e-15,   1.546028060230469e-16,  -5.769612355508037e-18,
   1.976428657729693e-19,  -6.626356816524023e-21,   1.575900537479927e-04,  -1.422329532221637e-05,   1.621629683461718e-06,  -1.390448353405869e-07,   9.821270263308477e-09,
  -6.232138487886294e-10,   3.602733991502908e-11,  -1.864933822072118e-12,   8.727407864604317e-14,  -3.810799183500835e-15,   1.559734901024333e-16,  -5.823906837199878e-18,
   1.997040039699148e-19,  -6.692063165996953e-21,   1.576805610039690e-04,  -1.424600012182788e-05,   1.624814415694640e-06,  -1.393803947931839e-07,   9.850297279603466e-09,
  -6.253147331323751e-10,   3.615834565482626e-11,  -1.872283459335865e-12,   8.764981348811903e-14,  -3.827944313697764e-15,   1.566792312135287e-16,  -5.851858710411894e-18,
   2.007647161573018e-19,  -6.725902532310950e-21,   1.577120770904514e-04,  -1.425390704899103e-05,   1.625923627535185e-06,  -1.394972776830043e-07,   9.860408637554946e-09,
  -6.260466109014114e-10,   3.620398734655645e-11,  -1.874844143871271e-12,   8.778072393227413e-14,  -3.833918241148167e-15,   1.569251623632164e-16,  -5.861598624071757e-18,
   2.011342607550559e-19,  -6.737695927189148e-21,   1.577170789339811e-04,  -1.425516197428769e-05,   1.626099679159722e-06,  -1.395158295836592e-07,   9.862013562100302e-09,
  -6.261627804917219e-10,   3.621123214150535e-11,  -1.875250611585557e-12,   8.780150390974111e-14,  -3.834866525506352e-15,   1.569642020933163e-16,  -5.863144737106869e-18,
   2.011929192137628e-19,  -6.739568102738423e-21,   3.403169242247114e-01,  -5.382656451543644e-03,   1.071083563336551e-04,  -1.659387377086440e-06,   2.541704368101379e-08,
  -1.315380928537487e-09,   4.962694510992361e-11,   3.972720905440665e-13,  -7.080861236987726e-14,  -7.465809954116820e-16,   1.675944232658277e-16,  -5.824501155485419e-19,
  -3.309460627815160e-19,   4.598518923812900e-21,   3.403269950884135e-01,  -5.383127473813460e-03,   1.071230348335094e-04,  -1.660614353401261e-06,   2.548481008812683e-08,
  -1.314639745707426e-09,   4.945430667279779e-11,   3.947041284518666e-13,  -7.015946015904752e-14,  -7.485794268287760e-16,   1.657613740445699e-16,  -5.556054796118943e-19,
  -3.262062868863569e-19,   4.470674700746639e-21,   3.403447664499128e-01,  -5.383958879527123e-03,   1.071489657996276e-04,  -1.662778820178571e-06,   2.560419274080104e-08,
  -1.313336049179995e-09,   4.915103425180621e-11,   3.901681506242665e-13,  -6.902012251420947e-14,  -7.519998717986737e-16,   1.625499637293733e-16,  -5.089517850940724e-19,
  -3.179166542601774e-19,   4.248544085693901e-21,   3.403662577564588e-01,  -5.384964700701982e-03,   1.071803737856641e-04,  -1.665395177097388e-06,   2.574822477145554e-08,
  -1.311766655861118e-09,   4.878660852374426e-11,   3.846752582809986e-13,  -6.765277410818057e-14,  -7.559574602309516e-16,   1.587057181524090e-16,  -4.537417016381995e-19,
  -3.080175926022227e-19,   3.985755152032085e-21,   3.403871232268476e-01,  -5.385941633371402e-03,   1.072109184787108e-04,  -1.667934110106052e-06,   2.588770772230191e-08,
  -1.310250504971228e-09,   4.843522203728165e-11,   3.793347808822301e-13,  -6.633614798592144e-14,  -7.596150520995728e-16,   1.550143434082538e-16,  -4.013885044864469e-19,
  -2.985372997636820e-19,   3.736640096480617e-21,   3.404039336715631e-01,  -5.386728994999842e-03,   1.072355637856845e-04,  -1.669978740590437e-06,   2.599983008002136e-08,
  -1.309034411719373e-09,   4.815385550718449e-11,   3.750269464729849e-13,  -6.528316206525931e-14,  -7.624312119423903e-16,   1.520694545503080e-16,  -3.600927057286237e-19,
  -2.909920792617972e-19,   3.540188028325242e-21,   3.404150424455832e-01,  -5.387249444487850e-03,   1.072518679907468e-04,  -1.671329453585411e-06,   2.607379978602477e-08,
  -1.308233434683360e-09,   4.796876561439380e-11,   3.721777243822947e-13,  -6.459110468496258e-14,  -7.642289581860094e-16,   1.501375539726850e-16,  -3.332309190566455e-19,
  -2.860510316425445e-19,   3.412422337810902e-21,   3.404207475589547e-01,  -5.387516774301173e-03,   1.072602468594495e-04,  -1.672023003613642e-06,   2.611175012385685e-08,
  -1.307822897733717e-09,   4.787396976635622e-11,   3.707136974186139e-13,  -6.423685177165450e-14,  -7.651328140690284e-16,   1.491497505289024e-16,  -3.195667626034431e-19,
  -2.835273197494685e-19,   3.347435968769118e-21,   3.404227333119594e-01,  -5.387609829502843e-03,   1.072631641370250e-04,  -1.672264383235875e-06,   2.612495325949997e-08,
  -1.307680134470159e-09,   4.784101600610049e-11,   3.702040009305050e-13,  -6.411373379044790e-14,  -7.654443383416668e-16,   1.488066225647392e-16,  -3.148315391763576e-19,
  -2.826511018009245e-19,   3.324916275103829e-21,   3.404230484253246e-01,  -5.387624596490599e-03,   1.072636271132064e-04,  -1.672302686059559e-06,   2.612704813880634e-08,
  -1.307657485977937e-09,   4.783578863404129e-11,   3.701231130429209e-13,  -6.409420534233431e-14,  -7.654936274257503e-16,   1.487522054187692e-16,  -3.140811058685195e-19,
  -2.825121615906039e-19,   3.321347419377779e-21,   1.082211208242325e-01,  -2.001460007084329e-03,   6.840420171678289e-05,  -2.731608810335885e-06,   8.916661989140081e-08,
  -1.947229439777215e-09,   4.041804624106557e-11,  -2.274650789493211e-12,   1.041640547058494e-13,  -8.806420230637740e-16,  -8.981081910688281e-17,   5.719250239549205e-20,
   2.474527266019909e-19,  -4.593825394090776e-21,   1.082276350832157e-01,  -2.002234843277034e-03,   6.845469811480624e-05,  -2.733472434776234e-06,   8.922660072678055e-08,
  -1.951755373087046e-09,   4.068469440835302e-11,  -2.277647011277512e-12,   1.038292739781539e-13,  -8.814081568192747e-16,  -8.841791180617093e-17,   2.909514445739784e-20,
   2.444042396053435e-19,  -4.490449448703678e-21,   1.082391334860328e-01,  -2.003602486726353e-03,   6.854382797179341e-05,  -2.736764293826558e-06,   8.933274009831619e-08,
  -1.959746263269817e-09,   4.115451123140605e-11,  -2.282936755033434e-12,   1.032432061130557e-13,  -8.828723467808024e-16,  -8.597494107332153e-17,  -1.990381183685520e-20,
   2.390705922679439e-19,  -4.310690722646601e-21,   1.082530441125665e-01,  -2.005256994301149e-03,   6.865165287008039e-05,  -2.740750754584818e-06,   8.946159979042505e-08,
  -1.969417137687393e-09,   4.172145223717913e-11,  -2.289338256461508e-12,   1.025424347159073e-13,  -8.848327925535138e-16,  -8.304601799464709e-17,  -7.817656692739372e-20,
   2.326980834404173e-19,  -4.097790562467507e-21,   1.082665552581597e-01,  -2.006863935666882e-03,   6.875637792814827e-05,  -2.744626933399736e-06,   8.958723301191665e-08,
  -1.978814051905037e-09,   4.227061569486026e-11,  -2.295558309519586e-12,   1.018703759160698e-13,  -8.869328174281153e-16,  -8.022880491744164e-17,  -1.337364832389629e-19,
   2.265917405121258e-19,  -3.895721786471356e-21,   1.082774446425491e-01,  -2.008159021831752e-03,   6.884077934975162e-05,  -2.747753971258963e-06,   8.968882684380471e-08,
  -1.986390246899576e-09,   4.271215145998873e-11,  -2.300573287570084e-12,   1.013348461235330e-13,  -8.887641953174216e-16,  -7.797788344607302e-17,  -1.777801651711225e-19,
   2.217293989071966e-19,  -3.736195742716998e-21,   1.082846425932827e-01,  -2.009015063688171e-03,   6.889656810158125e-05,  -2.749822436350366e-06,   8.975614672536287e-08,
  -1.991399480682770e-09,   4.300349019921613e-11,  -2.303889217275424e-12,   1.009838404593326e-13,  -8.900421316421682e-16,  -7.649956127507549e-17,  -2.065372029926956e-19,
   2.185441020392603e-19,  -3.632360627940640e-21,   1.082883398399614e-01,  -2.009454766299303e-03,   6.892522380584332e-05,  -2.750885364727979e-06,   8.979077695746858e-08,
  -1.993972895917120e-09,   4.315297713346210e-11,  -2.305592777399715e-12,   1.008044650329366e-13,  -8.907192584786034e-16,  -7.574315820519954e-17,  -2.211990172611941e-19,
   2.169168124572532e-19,  -3.579520110869999e-21,   1.082896268206656e-01,  -2.009607822221585e-03,   6.893519856410327e-05,  -2.751255433776975e-06,   8.980283959712973e-08,
  -1.994868745379543e-09,   4.320498686695223e-11,  -2.306185825385578e-12,   1.007421720819409e-13,  -8.909582465926103e-16,  -7.548032770586851e-17,  -2.262853417255778e-19,
   2.163517712146152e-19,  -3.561205160852388e-21,   1.082898310524824e-01,  -2.009632110724833e-03,   6.893678146255757e-05,  -2.751314163722788e-06,   8.980475421193215e-08,
  -1.995010911412360e-09,   4.321323912009468e-11,  -2.306279939101592e-12,   1.007322937047969e-13,  -8.909963275368287e-16,  -7.543864111218269e-17,  -2.270916726314903e-19,
   2.162621710560304e-19,  -3.558302463660608e-21,   9.181486281139600e-03,  -2.375948956757550e-04,   1.428603904491008e-05,  -8.360434443862117e-07,   3.571434433202656e-08,
  -1.150013494525914e-09,   4.014451466768546e-11,  -1.934777600022019e-12,   7.746430407936648e-14,  -1.594589873582518e-15,   1.400547816594859e-17,  -1.916321362667478e-18,
   1.457621766491526e-19,  -1.820626746131129e-21,   9.182866601334131e-03,  -2.378339531007959e-04,   1.430646202708757e-05,  -8.371544579976798e-07,   3.577322722957447e-08,
  -1.153913129546214e-09,   4.034971761832267e-11,  -1.940431553469234e-12,   7.755039868748838e-14,  -1.604958974384303e-15,   1.485360532528345e-17,  -1.928961135319949e-18,
   1.445602421911194e-19,  -1.807200135585119e-21,   9.185303795127955e-03,  -2.382560334899656e-04,   1.434252620271146e-05,  -8.391178594344449e-07,   3.587736240216533e-08,
  -1.160803281765488e-09,   4.071200144175570e-11,  -1.950436851789869e-12,   7.770517694337845e-14,  -1.623307770425804e-15,   1.634440652003181e-17,  -1.951195751150283e-18,
   1.424680231334058e-19,  -1.784363177438669e-21,   9.188253600624257e-03,  -2.387668610682766e-04,   1.438618235693920e-05,  -8.414971462994487e-07,   3.600368526453221e-08,
  -1.169150620307235e-09,   4.115042404829610e-11,  -1.962584584007392e-12,   7.789720503583567e-14,  -1.645584420368630e-15,   1.813742111233728e-17,  -1.977968685964488e-18,
   1.399864895915730e-19,  -1.758185695353601e-21,   9.191120076006415e-03,  -2.392632286385934e-04,   1.442861227446993e-05,  -8.438122855492970e-07,   3.612673797422430e-08,
  -1.177270546226643e-09,   4.157640382065439e-11,  -1.974429057862621e-12,   7.808870441157070e-14,  -1.667303277071279e-15,   1.986803592028569e-17,  -2.003844845385192e-18,
   1.376276529198420e-19,  -1.734253141894011e-21,   9.193431318475423e-03,  -2.396634294998810e-04,   1.446282863895392e-05,  -8.456811827048686e-07,   3.622616919297232e-08,
  -1.183823685401545e-09,   4.191983402973338e-11,  -1.984007917884694e-12,   7.824660340029050e-14,  -1.684866236927179e-15,   2.125510815345384e-17,  -2.024611207441285e-18,
   1.357630248741743e-19,  -1.716016532010911e-21,   9.194959549239901e-03,  -2.399280386140431e-04,   1.448545555038676e-05,  -8.469180040215450e-07,   3.629201928336993e-08,
  -1.188159688143272e-09,   4.214689854607608e-11,  -1.990355661312452e-12,   7.835271276034172e-14,  -1.696504043005039e-15,   2.216822434921374e-17,  -2.038295674610177e-18,
   1.345482150302356e-19,  -1.704469946830872e-21,   9.195744679140829e-03,  -2.400639786606909e-04,   1.449708092262668e-05,  -8.475537550129631e-07,   3.632588215041280e-08,
  -1.190388230788861e-09,   4.226354816523303e-11,  -1.993621168371139e-12,   7.840775218388073e-14,  -1.702490656225026e-15,   2.263609773992866e-17,  -2.045311930633236e-18,
   1.339296741054095e-19,  -1.698694582591324e-21,   9.196018000200539e-03,  -2.401113018985882e-04,   1.450112809540837e-05,  -8.477751269853577e-07,   3.633767570726766e-08,
  -1.191164181893158e-09,   4.230415570891223e-11,  -1.994758656107270e-12,   7.842699618591235e-14,  -1.704575949520505e-15,   2.279877797242133e-17,  -2.047752214188832e-18,
   1.337152299708808e-19,  -1.696708859532952e-21,   9.196061374834233e-03,  -2.401188118273859e-04,   1.450177036661449e-05,  -8.478102600851330e-07,   3.633954752775074e-08,
  -1.191287328248984e-09,   4.231059987956870e-11,  -1.994939202394503e-12,   7.843005407369092e-14,  -1.704906932675023e-15,   2.282458515153291e-17,  -2.048139369112131e-18,
   1.336812406886821e-19,  -1.696394910535210e-21,   1.183297112355254e-04,  -5.831473264332749e-06,   5.825990318937090e-07,  -4.650184855109245e-08,   2.873024766939587e-09,
  -1.548661414059805e-10,   8.125331317146005e-12,  -4.099475320576833e-13,   1.826938184528603e-14,  -7.068176681328314e-16,   2.647914300728275e-17,  -1.059081382171599e-18,
   3.905411189630486e-20,  -1.036446504601525e-21,   1.183877127159398e-04,  -5.845090143173782e-06,   5.842833253531682e-07,  -4.665420425501561e-08,   2.885051648582394e-09,
  -1.557139309836210e-10,   8.175788842412059e-12,  -4.124850557747266e-13,   1.838924396363660e-14,  -7.125999011925025e-16,   2.673108543920919e-17,  -1.067247707113101e-18,
   3.927026503343071e-20,  -1.046958377763756e-21,   1.184901939118210e-04,  -5.869153440567065e-06,   5.872609307932585e-07,  -4.692369715201213e-08,   2.906331952731732e-09,
  -1.572140061336970e-10,   8.265082716621591e-12,  -4.169786606397222e-13,   1.860161592980774e-14,  -7.228375843261388e-16,   2.717677482932308e-17,  -1.081721034284757e-18,
   3.965581331430788e-20,  -1.065597820477429e-21,   1.186143486253962e-04,  -5.898312698053323e-06,   5.908711239072307e-07,  -4.725069645502172e-08,   2.932164589651801e-09,
  -1.590349849936049e-10,   8.373503756130685e-12,  -4.224399011262894e-13,   1.885991028001398e-14,  -7.352766934112457e-16,   2.771765320064071e-17,  -1.099331348142397e-18,
   4.012906190962188e-20,  -1.088291593861956e-21,   1.187351206508676e-04,  -5.926684708065648e-06,   5.943859566596523e-07,  -4.756932326214695e-08,   2.957347729264226e-09,
  -1.608101882681264e-10,   8.479225644648717e-12,  -4.277704879755158e-13,   1.911222376528226e-14,  -7.474150071825322e-16,   2.824478437986301e-17,  -1.116541759473226e-18,
   4.059582485728044e-20,  -1.110483721383680e-21,   1.188325886965811e-04,  -5.949587289611225e-06,   5.972247279585933e-07,  -4.782685343454948e-08,   2.977710547156186e-09,
  -1.622456075763885e-10,   8.564730748525019e-12,  -4.320855125829217e-13,   1.931660859990511e-14,  -7.572385248830946e-16,   2.867092003681777e-17,  -1.130488698870367e-18,
   4.097708211923975e-20,  -1.128476610833451e-21,   1.188970799758683e-04,  -5.964743694187559e-06,   5.991041028000522e-07,  -4.799744106636777e-08,   2.991203030125003e-09,
  -1.631967275448764e-10,   8.621396434749580e-12,  -4.349469992963958e-13,   1.945221398696269e-14,  -7.637518557151648e-16,   2.895323538617052e-17,  -1.139745092856864e-18,
   4.123156698943068e-20,  -1.140422223089147e-21,   1.189302259953622e-04,  -5.972534288460807e-06,   6.000703557831602e-07,  -4.808517488818408e-08,   2.998143554102867e-09,
  -1.636859849519720e-10,   8.650548238952704e-12,  -4.364196678121460e-13,   1.952202462271294e-14,  -7.671036196637666e-16,   2.909844544168505e-17,  -1.144511248735665e-18,
   4.136304612473997e-20,  -1.146574220708701e-21,   1.189417670178060e-04,  -5.975247000098901e-06,   6.004068448835632e-07,  -4.811573198633467e-08,   3.000561097442821e-09,
  -1.638564048357046e-10,   8.660702961421672e-12,  -4.369327468215214e-13,   1.954635006159117e-14,  -7.682713247185497e-16,   2.914902346427727e-17,  -1.146172154159090e-18,
   4.140893409315148e-20,  -1.148718239484512e-21,   1.189435986207775e-04,  -5.975677523448691e-06,   6.004602494228220e-07,  -4.812058195228829e-08,   3.000944815200674e-09,
  -1.638834542679707e-10,   8.662314764063758e-12,  -4.370141892941363e-13,   1.955021146575815e-14,  -7.684566753392843e-16,   2.915705122668148e-17,  -1.146435812030578e-18,
   4.141622183422318e-20,  -1.149058596683909e-21,   3.203815732486117e-01,  -4.600105446392172e-03,   8.897661184228216e-05,  -1.399189816250406e-06,   1.064395460577051e-08,
  -2.310060156503187e-10,   3.281255122667047e-11,  -1.270777900566369e-12,  -1.378888218482772e-14,   2.471543138867225e-15,  -3.083150257700995e-17,  -4.039270156423907e-18,
   1.632987439588902e-19,   3.530046093145365e-21,   3.203899273319201e-01,  -4.600499804861352e-03,   8.898285669260425e-05,  -1.399426260679854e-06,   1.068964201536032e-08,
  -2.333844483513482e-10,   3.277431774927584e-11,  -1.262948085212428e-12,  -1.389149672210912e-14,   2.451757380937695e-15,  -2.995688680516859e-17,  -4.012610439019974e-18,
   1.603008008859656e-19,   3.547875775235401e-21,   3.204046687501697e-01,  -4.601195714069846e-03,   8.899389661452855e-05,  -1.399845245831743e-06,   1.077021369035016e-08,
  -2.375689480921092e-10,   3.270665148496341e-11,  -1.249185773897414e-12,  -1.406967918628873e-14,   2.416957607173194e-15,  -2.842818438153926e-17,  -3.965486152313982e-18,
   1.550572817404161e-19,   3.577589561147641e-21,   3.204224950958739e-01,  -4.602037313205599e-03,   8.900728163250234e-05,  -1.400354907801725e-06,   1.086756583411324e-08,
  -2.426080057749270e-10,   3.262448720386609e-11,  -1.232635285637393e-12,  -1.428025792400050e-14,   2.375069385590154e-15,  -2.660434830627463e-17,  -3.908368582838666e-18,
   1.487954475823731e-19,   3.610583957440482e-21,   3.204398015111532e-01,  -4.602854426342801e-03,   8.902031265629350e-05,  -1.400852834017320e-06,   1.096199385084023e-08,
  -2.474780400214312e-10,   3.254437111400031e-11,  -1.216663429188490e-12,  -1.447961491001194e-14,   2.334606371454129e-15,  -2.485945211852811e-17,  -3.852787690915325e-18,
   1.427984198423914e-19,   3.639594210555206e-21,   3.204537439853835e-01,  -4.603512756288500e-03,   8.903083683449202e-05,  -1.401256211966088e-06,   1.103800655546204e-08,
  -2.513857117207974e-10,   3.247958176473222e-11,  -1.203864636223766e-12,  -1.463661207186096e-14,   2.302154323534493e-15,  -2.347202593444977e-17,  -3.807923737695187e-18,
   1.380255548814028e-19,   3.660838424266835e-21,   3.204629572431839e-01,  -4.603947805429895e-03,   8.903780402076337e-05,  -1.401523858803240e-06,   1.108820629974445e-08,
  -2.539602317013770e-10,   3.243664972736379e-11,  -1.195440603409682e-12,  -1.473860123557773e-14,   2.280781369237099e-15,  -2.256411357427975e-17,  -3.778237385388296e-18,
   1.349001026537990e-19,   3.673850378055621e-21,   3.204676887907023e-01,  -4.604171235270637e-03,   8.904138602255564e-05,  -1.401661648543428e-06,   1.111397757016957e-08,
  -2.552800250290133e-10,   3.241456515100647e-11,  -1.191124704724052e-12,  -1.479043834677618e-14,   2.269827237340089e-15,  -2.210058956650587e-17,  -3.762979831068192e-18,
   1.333037746563596e-19,   3.680218589716368e-21,   3.204693356648826e-01,  -4.604249003872077e-03,   8.904263341069861e-05,  -1.401709661654980e-06,   1.112294611078083e-08,
  -2.557390181141392e-10,   3.240687256167110e-11,  -1.189624146252443e-12,  -1.480839511191782e-14,   2.266018039515463e-15,  -2.193968973346353e-17,  -3.757667403141089e-18,
   1.327495467638547e-19,   3.682385390737775e-21,   3.204695970018811e-01,  -4.604261344763531e-03,   8.904283138438026e-05,  -1.401717283243428e-06,   1.112436922883819e-08,
  -2.558118362926028e-10,   3.240565157651195e-11,  -1.189386105621352e-12,  -1.481124054332514e-14,   2.265413737896033e-15,  -2.191417772510344e-17,  -3.756824304861685e-18,
   1.326616642963909e-19,   3.682726877882498e-21,   1.011328141769421e-01,  -1.563789641418737e-03,   4.302632167766659e-05,  -1.579268617392115e-06,   5.650520854675990e-08,
  -1.415648154605501e-09,   1.452079921599073e-11,   1.977918278343300e-14,   3.055983531596279e-14,  -2.279706668862331e-15,   3.644311859853506e-17,   2.508266773690263e-18,
  -1.134775153722323e-19,  -2.199820528749119e-21,   1.011369119383031e-01,  -1.564238487537504e-03,   4.305822716069350e-05,  -1.580596552762576e-06,   5.652661340391321e-08,
  -1.415725850955817e-09,   1.460374372335920e-11,   1.240218428309669e-14,   3.069452309898931e-14,  -2.267443545201013e-15,   3.583593578143367e-17,   2.491185769533720e-18,
  -1.113849462797606e-19,  -2.219649337545588e-21,   1.011441449493395e-01,  -1.565030787407440e-03,   4.311453491070680e-05,  -1.582939810541102e-06,   5.656447848943197e-08,
  -1.415874600070605e-09,   1.475037674274849e-11,  -5.814932372972935e-16,   3.093018141229173e-14,  -2.245877608728726e-15,   3.477475110565573e-17,   2.460944933887345e-18,
  -1.077223518701459e-19,  -2.253378385814296e-21,   1.011528953558749e-01,  -1.565989362959939e-03,   4.318263996462954e-05,  -1.585773470742092e-06,   5.661042904465671e-08,
  -1.416074301961762e-09,   1.492815494207838e-11,  -1.622510461271302e-14,   3.121175460785038e-14,  -2.219923796180784e-15,   3.350884418594741e-17,   2.424209868088951e-18,
  -1.033440323240748e-19,  -2.292044887628967e-21,   1.011613944689950e-01,  -1.566920474078878e-03,   4.324877313990092e-05,  -1.588524522442077e-06,   5.665520872717444e-08,
  -1.416288892135133e-09,   1.510122540373967e-11,  -3.135277604413071e-14,   3.148158363369733e-14,  -2.194858411600870e-15,   3.229789985653432e-17,   2.388378887354882e-18,
  -9.914623854180406e-20,  -2.327398085185512e-21,   1.011682443755471e-01,  -1.567670953857537e-03,   4.330206206721241e-05,  -1.590740870724622e-06,   5.669140585040655e-08,
  -1.416476578981249e-09,   1.524099473815877e-11,  -4.349737115901107e-14,   3.169645515094877e-14,  -2.174759526203043e-15,   3.133516844157045e-17,   2.359397006232571e-18,
  -9.580202163861288e-20,  -2.354338397507887e-21,   1.011727722052674e-01,  -1.568167047887700e-03,   4.333728076900760e-05,  -1.592205463342690e-06,   5.671538465807441e-08,
  -1.416607840342448e-09,   1.533352023059525e-11,  -5.150175955685484e-14,   3.183722314320078e-14,  -2.161524391780462e-15,   3.070523848287652e-17,   2.340190784920479e-18,
  -9.361048125896129e-20,  -2.371396076238234e-21,   1.011750979367697e-01,  -1.568421874782615e-03,   4.335536921687053e-05,  -1.592957623579379e-06,   5.672771761626374e-08,
  -1.416677485991249e-09,   1.538108836385305e-11,  -5.560605335735037e-14,   3.190914019377333e-14,  -2.154741715495156e-15,   3.038365698006090e-17,   2.330310670196343e-18,
  -9.249064822136175e-20,  -2.379928019822649e-21,   1.011759075044294e-01,  -1.568510578989903e-03,   4.336166537893808e-05,  -1.593219423357341e-06,   5.673201319268075e-08,
  -1.416702082630843e-09,   1.539765312621571e-11,  -5.703358159650340e-14,   3.193411219142959e-14,  -2.152383204964826e-15,   3.027203220345752e-17,   2.326869163441814e-18,
  -9.210177435669651e-20,  -2.382861530446143e-21,   1.011760359752523e-01,  -1.568524655570909e-03,   4.336266450796855e-05,  -1.593260967544449e-06,   5.673269498287276e-08,
  -1.416706002666429e-09,   1.540028211656609e-11,  -5.726006279583411e-14,   3.193807208728565e-14,  -2.152009049246188e-15,   3.025433333574070e-17,   2.326322918929723e-18,
  -9.204010785052220e-20,  -2.383325327648945e-21,   8.407892294727605e-03,  -1.552035602449847e-04,   7.053017465161071e-06,  -4.103075027200927e-07,   1.918999423026718e-08,
  -6.078110496817443e-10,   1.237312666990403e-11,  -3.302657302692855e-13,   2.441186102901464e-14,  -1.251195802173087e-15,   2.245395463825613e-17,   7.571287502528198e-19,
  -3.035344013385474e-20,  -1.675939454111882e-21,   8.408575392444852e-03,  -1.553209889234817e-04,   7.063914878761623e-06,  -4.108834074741554e-07,   1.920817648227189e-08,
  -6.085268460735483e-10,   1.243905957671372e-11,  -3.344010875153036e-13,   2.450215135605271e-14,  -1.247769573920665e-15,   2.230936559598628e-17,   7.448498865607129e-19,
  -2.939865776117512e-20,  -1.677007663396783e-21,   8.409781572220353e-03,  -1.555283264452939e-04,   7.083152037285007e-06,  -4.119001662000265e-07,   1.924033545596922e-08,
  -6.097964569553200e-10,   1.255558934202774e-11,  -3.416889406174972e-13,   2.466101146189583e-14,  -1.241775407606081e-15,   2.205887237718214e-17,   7.231832584852432e-19,
  -2.772910052567433e-20,  -1.678441168827897e-21,   8.411241535737746e-03,  -1.557792676723907e-04,   7.106428333595554e-06,  -4.131306097383720e-07,   1.927935234140620e-08,
  -6.113428885150564e-10,   1.269682190667418e-11,  -3.504861564504577e-13,   2.485233550893990e-14,  -1.234614945801227e-15,   2.176382754705155e-17,   6.969848269694497e-19,
  -2.573594863031153e-20,  -1.679418934046418e-21,   8.412660349565804e-03,  -1.560231143607001e-04,   7.129039793784892e-06,  -4.143261210818183e-07,   1.931736548735742e-08,
  -6.128558585422365e-10,   1.283426603143918e-11,  -3.590104070504058e-13,   2.503727542519841e-14,  -1.227755569573562e-15,   2.148556297248547e-17,   6.715551631920701e-19,
  -2.382771720912747e-20,  -1.679594470657720e-21,   8.413804407380328e-03,  -1.562197241837488e-04,   7.147266229384596e-06,  -4.152899419716085e-07,   1.934808612302739e-08,
  -6.140830770346602e-10,   1.294523084722302e-11,  -3.658661026053005e-13,   2.518570109323620e-14,  -1.222295563085514e-15,   2.126719754816996e-17,   6.510732498151211e-19,
  -2.230943573054801e-20,  -1.679193847929126e-21,   8.414560909298905e-03,  -1.563497237733997e-04,   7.159315297328856e-06,  -4.159271775331513e-07,   1.936843368096981e-08,
  -6.148981054395163e-10,   1.301867250028186e-11,  -3.703907117887289e-13,   2.528350798368185e-14,  -1.218719908952336e-15,   2.112572752897244e-17,   6.375416749367499e-19,
  -2.131540553830973e-20,  -1.678668638958614e-21,   8.414949572834332e-03,  -1.564165105581233e-04,   7.165504730983179e-06,  -4.162545400465509e-07,   1.937889795325295e-08,
  -6.153179300810416e-10,   1.305642477342040e-11,  -3.727126178461132e-13,   2.533365376545522e-14,  -1.216893602829225e-15,   2.105394473629356e-17,   6.305934665492641e-19,
  -2.080776251114750e-20,  -1.678319399320824e-21,   8.415084876786228e-03,  -1.564397604142631e-04,   7.167659284606313e-06,  -4.163684993514867e-07,   1.938254250064561e-08,
  -6.154642557834258e-10,   1.306957059976658e-11,  -3.735205089734749e-13,   2.535109436411207e-14,  -1.216259526321256e-15,   2.102909805200925e-17,   6.281752339302640e-19,
  -2.063152350267658e-20,  -1.678185275467462e-21,   8.415106348896660e-03,  -1.564434500410785e-04,   7.168001195156129e-06,  -4.163865839684564e-07,   1.938312095225632e-08,
  -6.154874852402920e-10,   1.307165693671440e-11,  -3.736486973864673e-13,   2.535386132647744e-14,  -1.216158982405233e-15,   2.102516176852328e-17,   6.277915012994654e-19,
  -2.060357817610309e-20,  -1.678163397075831e-21,   1.016519696397306e-04,  -2.803281267384282e-06,   2.241546232716475e-07,  -1.767454684197468e-08,   1.058514718469760e-09,
  -4.949046804905613e-11,   2.068145119203618e-12,  -9.300813021517541e-14,   4.473010135467538e-15,  -1.878916184375930e-16,   5.917947418831311e-18,  -1.452883708730270e-19,
   5.091990055651373e-21,  -2.991144038347296e-22,   1.016742145827255e-04,  -2.808421790096748e-06,   2.247673588211183e-07,  -1.772258229792378e-08,   1.061569182932320e-09,
  -4.968406761326312e-11,   2.080430489848060e-12,  -9.366444280781043e-14,   4.499159874370156e-15,  -1.887289769759754e-16,   5.954044915962510e-18,  -1.475448993977561e-19,
   5.191921751960980e-21,  -3.003828215572742e-22,   1.017135149417352e-04,  -2.817503596115201e-06,   2.258499719631605e-07,  -1.780749242931525e-08,   1.066973094834144e-09,
  -5.002673868465783e-11,   2.102164756963792e-12,  -9.482487946016739e-14,   4.545429320463783e-15,  -1.902160391485019e-16,   6.018235723304954e-18,  -1.515339952996832e-19,
   5.367655614927547e-21,  -3.026110474774594e-22,   1.017611206570772e-04,  -2.828504658651178e-06,   2.271615249375311e-07,  -1.791042437751049e-08,   1.073531924330802e-09,
  -5.044291295778161e-11,   2.128542656742132e-12,  -9.623213855098435e-14,   4.601597930052567e-15,  -1.920304809410216e-16,   6.096700038571377e-18,  -1.563702645349058e-19,
   5.579151878216207e-21,  -3.052895658506472e-22,   1.018074227974302e-04,  -2.839204485002321e-06,   2.284373246875082e-07,  -1.801061951832072e-08,   1.079924690813652e-09,
  -5.084882942168939e-11,   2.154251259769708e-12,  -9.760254195961325e-14,   4.656356357896366e-15,  -1.938089746644454e-16,   6.173753295790921e-18,  -1.610783985278665e-19,
   5.783437865492453e-21,  -3.078745028006252e-22,   1.018447858486512e-04,  -2.847838610819167e-06,   2.294669356072049e-07,  -1.809152980086683e-08,   1.085092980401937e-09,
  -5.117719539267567e-11,   2.175034598038414e-12,  -9.870959008318642e-14,   4.700635521179613e-15,  -1.952539520633859e-16,   6.236456233749116e-18,  -1.648806184887998e-19,
   5.947282985787138e-21,  -3.099468227172570e-22,   1.018695053915426e-04,  -2.853550988485004e-06,   2.301481883183444e-07,  -1.814508925206950e-08,   1.088517099998411e-09,
  -5.139484306145754e-11,   2.188803583488137e-12,  -9.944261696111058e-14,   4.729976337262475e-15,  -1.962147709815056e-16,   6.278196914367781e-18,  -1.673976544608563e-19,
   6.055199425551788e-21,  -3.113116050912893e-22,   1.018822095614866e-04,  -2.856486765749671e-06,   2.304983241557989e-07,  -1.817262413303226e-08,   1.090278337895916e-09,
  -5.150682274337065e-11,   2.195885679863109e-12,  -9.981952946901403e-14,   4.745069677954907e-15,  -1.967100557619555e-16,   6.299727763690033e-18,  -1.686916924604059e-19,
   6.110512763102789e-21,  -3.120111492827899e-22,   1.018866328774517e-04,  -2.857508940007669e-06,   2.306202367442172e-07,  -1.818221260720252e-08,   1.090891797141979e-09,
  -5.154583130055112e-11,   2.198352431028311e-12,  -9.995079197081789e-14,   4.750327109442184e-15,  -1.968827401527313e-16,   6.307236886254165e-18,  -1.691423200659623e-19,
   6.129748159045736e-21,  -3.122544259704680e-22,   1.018873348686279e-04,  -2.857671161608442e-06,   2.306395847111152e-07,  -1.818373438951929e-08,   1.090989165772712e-09,
  -5.155202298849497e-11,   2.198743954172161e-12,  -9.997162506855818e-14,   4.751161584125921e-15,  -1.969101568417040e-16,   6.308429197805851e-18,  -1.692138391782725e-19,
   6.132799750422626e-21,  -3.122930209834358e-22,   3.033023395904125e-01,  -3.952692094584771e-03,   7.316110698623057e-05,  -1.235135892740919e-06,   1.105697873544368e-08,
   1.474196885338572e-10,   1.427097776459885e-12,  -7.310483511492899e-13,   3.158913029536411e-14,  -3.458899713127590e-17,  -4.985185816882248e-17,   1.807714628479783e-18,
   1.983934172701285e-20,  -3.769950907629283e-21,   3.033092109509617e-01,  -3.953039034278532e-03,   7.316734356493826e-05,  -1.235009768337459e-06,   1.105990973373402e-08,
   1.459824388749791e-10,   1.505797128247744e-12,  -7.309520803198054e-13,   3.138392877483883e-14,  -2.626712840389083e-17,  -4.969764405023993e-17,   1.781777741296928e-18,
   2.054462895506522e-20,  -3.740845470156030e-21,   3.033213360525437e-01,  -3.953651188096620e-03,   7.317834966206906e-05,  -1.234788314500343e-06,   1.106516984762611e-08,
   1.434466464147019e-10,   1.644228627530192e-12,  -7.307601033834226e-13,   3.102240322967045e-14,  -1.169009625076801e-17,  -4.942218259153215e-17,   1.736188917894666e-18,
   2.177095341749898e-20,  -3.689169830470210e-21,   3.033359986697283e-01,  -3.954391365629199e-03,   7.319166103223109e-05,  -1.234522396447265e-06,   1.107168069053623e-08,
   1.403808012036794e-10,   1.810881037966164e-12,  -7.304904700893660e-13,   3.058619788661792e-14,   5.754616295502532e-18,  -4.908344422373000e-17,   1.681365804777263e-18,
   2.322303513420967e-20,  -3.626152822599271e-21,   3.033502337380863e-01,  -3.955109869836280e-03,   7.320458632073992e-05,  -1.234266201921094e-06,   1.107815822058894e-08,
   1.374050457028917e-10,   1.971890010913077e-12,  -7.301897062189239e-13,   3.016374717040190e-14,   2.249972175919849e-17,  -4.874876718179844e-17,   1.628463674321261e-18,
   2.460065342537006e-20,  -3.564438212592952e-21,   3.033617019356093e-01,  -3.955688653724689e-03,   7.321500082468454e-05,  -1.234061214881073e-06,   1.108348856098558e-08,
   1.350082050935094e-10,   2.101042724412393e-12,  -7.299196435461054e-13,   2.982415664424424e-14,   3.585375038453672e-17,  -4.847502934462596e-17,   1.586076147667208e-18,
   2.568764452959192e-20,  -3.514347225334730e-21,   3.033692802157223e-01,  -3.956071087341356e-03,   7.322188356155612e-05,  -1.233926448469588e-06,   1.108706553256522e-08,
   1.334246146120262e-10,   2.186113583180937e-12,  -7.297276652245022e-13,   2.960012151941192e-14,   4.461164472910777e-17,  -4.829214994332265e-17,   1.558180123013735e-18,
   2.639480765418715e-20,  -3.481069251639951e-21,   3.033731721177967e-01,  -3.956267480223233e-03,   7.322541849322788e-05,  -1.233857451410694e-06,   1.108891939301684e-08,
   1.326114284996875e-10,   2.229717811115903e-12,  -7.296249074951008e-13,   2.948518074020081e-14,   4.908880680356450e-17,  -4.819761930949562e-17,   1.543889180348203e-18,
   2.675454989753830e-20,  -3.463925121982238e-21,   3.033745267447022e-01,  -3.956335835756867e-03,   7.322664890921341e-05,  -1.233833470092447e-06,   1.108956733659778e-08,
   1.323284018751266e-10,   2.244881338190116e-12,  -7.295884795850901e-13,   2.944519242663012e-14,   5.064387426101753e-17,  -4.816461983300882e-17,   1.538920666631981e-18,
   2.687921821789565e-20,  -3.457949393214903e-21,   3.033747417060360e-01,  -3.956346682800339e-03,   7.322684416169277e-05,  -1.233829666189234e-06,   1.108967028399913e-08,
   1.322834899374885e-10,   2.247286948697891e-12,  -7.295826675708943e-13,   2.943884768170048e-14,   5.089048784362246e-17,  -4.815937866344377e-17,   1.538132496974195e-18,
   2.689897559689625e-20,  -3.457000722861258e-21,   9.546507560390467e-02,  -1.282037286421340e-03,   2.863004487534777e-05,  -8.814197254260211e-07,   3.201990681529638e-08,
  -1.012259081930886e-09,   1.919859056889784e-11,   8.397463127128284e-14,  -1.329808622574125e-14,  -1.661478228543275e-16,   3.952590690530535e-17,  -1.392187297268835e-18,
  -1.019714559457944e-20,   2.550607334037175e-21,   9.546779612663467e-02,  -1.282288523121207e-03,   2.864820616260177e-05,  -8.823674392888376e-07,   3.204653713255934e-08,
  -1.012105696579399e-09,   1.916705897008231e-11,   8.324710904773673e-14,  -1.313419352133903e-14,  -1.726478121573895e-16,   3.944042709716114e-17,  -1.374584033681020e-18,
  -1.069803839805577e-20,   2.531946623017554e-21,   9.547259793392344e-02,  -1.282732050721498e-03,   2.868026413390672e-05,  -8.840395822479504e-07,   3.209349202202662e-08,
  -1.011836291111427e-09,   1.911176894583388e-11,   8.194604443238552e-14,  -1.284531457360646e-14,  -1.840444415824041e-16,   3.928721163447744e-17,  -1.343636830843699e-18,
  -1.156962117231291e-20,   2.498784843176296e-21,   9.547840672197351e-02,  -1.283268738153348e-03,   2.871904958667913e-05,  -8.860613632946778e-07,   3.215021143947794e-08,
  -1.011512665243162e-09,   1.904550451363390e-11,   8.034335198454699e-14,  -1.249653698480627e-14,  -1.977017333771409e-16,   3.909791680625590e-17,  -1.306410470100402e-18,
  -1.260276821247809e-20,   2.458293665370848e-21,   9.548404829787092e-02,  -1.283790131538667e-03,   2.875672340371193e-05,  -8.880238730772837e-07,   3.220521229620982e-08,
  -1.011200761688904e-09,   1.898179637169346e-11,   7.875683810859219e-14,  -1.215851989574184e-14,  -2.108309523586503e-16,   3.890999049899019e-17,  -1.270477428096684e-18,
  -1.358410650320376e-20,   2.418586247117129e-21,   9.548859487343429e-02,  -1.284210436192580e-03,   2.878708838700884e-05,  -8.896047025823126e-07,   3.224947654205689e-08,
  -1.010951137029679e-09,   1.893091787368662e-11,   7.745692530747682e-14,  -1.188663102729474e-14,  -2.213155219787460e-16,   3.875565441465436e-17,  -1.241678369068460e-18,
  -1.435926432903879e-20,   2.386319933617864e-21,   9.549160004886571e-02,  -1.284488301603504e-03,   2.880716058621314e-05,  -8.906492168689851e-07,   3.227870425456311e-08,
  -1.010786999555368e-09,   1.889751546311523e-11,   7.658732250645593e-14,  -1.170717598755729e-14,  -2.281985373737570e-16,   3.865224479101303e-17,  -1.222721300539771e-18,
  -1.486397603312649e-20,   2.364865577741970e-21,   9.549314362221950e-02,  -1.284631040716449e-03,   2.881747095787991e-05,  -8.911856034363535e-07,   3.229370751324995e-08,
  -1.010702959045090e-09,   1.888042885864587e-11,   7.613745862132618e-14,  -1.161508081986177e-14,  -2.317194040317431e-16,   3.859870082854201e-17,  -1.213008528754272e-18,
  -1.512085895477583e-20,   2.353807141065618e-21,   9.549368092036432e-02,  -1.284680729046926e-03,   2.882105994913450e-05,  -8.913722942757509e-07,   3.229892849071337e-08,
  -1.010673748210649e-09,   1.887449239355112e-11,   7.598035792242517e-14,  -1.158303641166559e-14,  -2.329426647549594e-16,   3.857999488571654e-17,  -1.209631511635168e-18,
  -1.520990228948075e-20,   2.349951744488934e-21,   9.549376618423595e-02,  -1.284688614217538e-03,   2.882162949027571e-05,  -8.914019193786750e-07,   3.229975693840225e-08,
  -1.010669114766146e-09,   1.887355086543811e-11,   7.595540346867043e-14,  -1.157795188838176e-14,  -2.331366745555691e-16,   3.857702321762461e-17,  -1.209095796642989e-18,
  -1.522401482713364e-20,   2.349339643163806e-21,   7.875012636976582e-03,  -1.140843492343084e-04,   3.616884943774918e-06,  -1.864019283873015e-07,   9.559991576596542e-09,
  -3.679312735088735e-10,   8.751389024810807e-12,  -6.243641978067094e-14,  -1.172658855357327e-15,  -1.999467689759521e-16,   1.928698817804910e-17,  -6.209539646477558e-19,
  -4.014492448526923e-21,   1.046522164715678e-21,   7.875362655224065e-03,  -1.141379939524449e-04,   3.622331810042596e-06,  -1.867480107764957e-07,   9.572283931553596e-09,
  -3.680662932266293e-10,   8.749965568935646e-12,  -6.318656553549302e-14,  -1.092371196078279e-15,  -2.028771787530644e-16,   1.925455506234446e-17,  -6.138869873095428e-19,
  -4.186661352586678e-21,   1.036023008479651e-21,   7.875980691369532e-03,  -1.142327302415506e-04,   3.631948510479156e-06,  -1.873587853100138e-07,   9.593973007923746e-09,
  -3.683057749499733e-10,   8.747624529456067e-12,  -6.451805284233294e-14,  -9.508200153473046e-16,  -2.080189134742404e-16,   1.919652301436836e-17,  -6.014806884029315e-19,
  -4.484741250693994e-21,   1.017414708626206e-21,   7.876728749576215e-03,  -1.143474216737531e-04,   3.643586708590914e-06,  -1.880975230221319e-07,   9.620198137541541e-09,
  -3.685974769541566e-10,   8.745084549175059e-12,  -6.614142124562703e-14,  -7.798572284093200e-16,  -2.141870573550844e-16,   1.912499967403111e-17,  -5.865874254961659e-19,
  -4.835498057357885e-21,   9.947771273952071e-22,   7.877455708290241e-03,  -1.144589038376726e-04,   3.654894903163622e-06,  -1.888148688951879e-07,   9.645655603660101e-09,
  -3.688828850421005e-10,   8.742923105366224e-12,  -6.773123902800193e-14,  -6.141037485418676e-16,  -2.201235967729673e-16,   1.905417651876249e-17,  -5.722433717570618e-19,
  -5.165941248886377e-21,   9.726636507132951e-22,   7.878041879253624e-03,  -1.145488139678013e-04,   3.664011826480825e-06,  -1.893928916356692e-07,   9.666162898281217e-09,
  -3.691144105756767e-10,   8.741399759752431e-12,  -6.902187231233460e-14,  -4.807299789503999e-16,  -2.248693425796330e-16,   1.899614393131558e-17,  -5.607699775047436e-19,
  -5.424983811853315e-21,   9.547546801137080e-22,   7.878429476301822e-03,  -1.146082747075670e-04,   3.670039646844329e-06,  -1.897749066922854e-07,   9.679713356454924e-09,
  -3.692681871585786e-10,   8.740499776617210e-12,  -6.987952614775529e-14,  -3.926755290376500e-16,  -2.279873676882621e-16,   1.895732491191989e-17,  -5.532288089861382e-19,
  -5.592671354121338e-21,   9.428759081872546e-22,   7.878628608130333e-03,  -1.146388260226052e-04,   3.673136309569402e-06,  -1.899711107616733e-07,   9.686672052671481e-09,
  -3.693474033295648e-10,   8.740070550226907e-12,  -7.032146090652669e-14,  -3.474791662016361e-16,  -2.295831078110474e-16,   1.893724494989955e-17,  -5.493685258835570e-19,
  -5.677714344865045e-21,   9.367620389450860e-22,   7.878697930874963e-03,  -1.146494621362382e-04,   3.674214304687795e-06,  -1.900394047420789e-07,   9.689094073633388e-09,
  -3.693750142313843e-10,   8.739926399749889e-12,  -7.047551694808215e-14,  -3.317519606652612e-16,  -2.301376430620243e-16,   1.893023305500847e-17,  -5.480269057544342e-19,
  -5.707143990299084e-21,   9.346319214175312e-22,   7.878708932061183e-03,  -1.146511500572369e-04,   3.674385375893740e-06,  -1.900502422156833e-07,   9.689478414215719e-09,
  -3.693793975532886e-10,   8.739903774059422e-12,  -7.049997474504489e-14,  -3.292564504974510e-16,  -2.302255985746085e-16,   1.892911928029322e-17,  -5.478141034724198e-19,
  -5.711805991125431e-21,   9.342938005812740e-22,   9.300718652158596e-05,  -1.631659558760647e-06,   8.788452302325751e-08,  -6.620443032806064e-09,   4.163029525816211e-10,
  -1.980263800029517e-11,   7.183375924780528e-13,  -2.219385463352830e-14,   8.142866599926717e-16,  -4.097105089224040e-17,   1.937070220821081e-18,  -6.314148257272577e-20,
   9.587020357316201e-22,   1.278430253072748e-23,   9.301590770163367e-05,  -1.633588406260211e-06,   8.812456617044593e-08,  -6.639397486432092e-09,   4.173407130105227e-10,
  -1.984868481518556e-11,   7.206485012502593e-13,  -2.234057737510606e-14,   8.226541636008875e-16,  -4.129521136580196e-17,   1.943127714430120e-18,  -6.309739946346197e-20,
   9.608646119581168e-22,   1.189863275344428e-23,   9.303131536508054e-05,  -1.636996290812666e-06,   8.854860727484984e-08,  -6.672878747458233e-09,   4.191745681651709e-10,
  -1.993017415002617e-11,   7.247441125606309e-13,  -2.260036056773287e-14,   8.374396594094501e-16,  -4.186706390934335e-17,   1.953831272496885e-18,  -6.302496912531880e-20,
   9.650565780885246e-22,   1.032904677471603e-23,   9.304997890617731e-05,  -1.641124654182901e-06,   8.906218366324338e-08,  -6.713425865151329e-09,   4.213967212857707e-10,
  -2.002912042230178e-11,   7.297272515209388e-13,  -2.291600814000432e-14,   8.553541232172753e-16,  -4.255834163350892e-17,   1.966801007978030e-18,  -6.294654208332055e-20,
   9.707635327222510e-22,   8.419741789282639e-24,   9.306813114265903e-05,  -1.645140272822979e-06,   8.956161596697092e-08,  -6.752852575571137e-09,   4.235588217927253e-10,
  -2.012560476806780e-11,   7.345969656806234e-13,  -2.322401956675678e-14,   8.727825970315459e-16,  -4.322921940538577e-17,   1.979421572363460e-18,  -6.288002736109892e-20,
   9.769676999278224e-22,   6.554673826939583e-24,   9.308277872853286e-05,  -1.648380850606977e-06,   8.996457000142505e-08,  -6.784660385000948e-09,   4.253040858916432e-10,
  -2.020363956761855e-11,   7.385430208222527e-13,  -2.347328594830871e-14,   8.868496014584323e-16,  -4.376953860855526e-17,   1.989611003757029e-18,  -6.283335961661736e-20,
   9.824385001982445e-22,   5.044157485819877e-24,   9.309246953914263e-05,  -1.650524934033668e-06,   9.023113769318542e-08,  -6.805701068459392e-09,   4.264590461465393e-10,
  -2.025535486146731e-11,   7.411618139368406e-13,  -2.363855308174922e-14,   8.961579915514785e-16,  -4.412651333820034e-17,   1.996355457809944e-18,  -6.280591732977068e-20,
   9.862838270134300e-22,   4.042190516558700e-24,   9.309744993078411e-05,  -1.651626879748044e-06,   9.036812668354648e-08,  -6.816513480679459e-09,   4.270527067817428e-10,
  -2.028196000204470e-11,   7.425101896677013e-13,  -2.372359770794311e-14,   9.009423699736524e-16,  -4.430982003754358e-17,   1.999822698882241e-18,  -6.279287617200693e-20,
   9.883295636596692e-22,   3.526463174934791e-24,   9.309918399040663e-05,  -1.652010558407261e-06,   9.041582188353331e-08,  -6.820277957370191e-09,   4.272594207994134e-10,
  -2.029122763217695e-11,   7.429800616318883e-13,  -2.375322565786848e-14,   9.026082657215703e-16,  -4.437361902940906e-17,   2.001030092218132e-18,  -6.278850468445732e-20,
   9.890528783718086e-22,   3.346775127071386e-24,   9.309945918973818e-05,  -1.652071449400736e-06,   9.042339116367710e-08,  -6.820875381049752e-09,   4.272922275041695e-10,
  -2.029269863207630e-11,   7.430546503093610e-13,  -2.375792850570466e-14,   9.028726512515433e-16,  -4.438374293029572e-17,   2.001221717016478e-18,  -6.278781894972584e-20,
   9.891681933752962e-22,   3.318252388471322e-24,   2.885732109994936e-01,  -3.423493994542346e-03,   5.949049586187656e-05,  -1.037797166777022e-06,   1.323692846324806e-08,
   3.918581157623335e-11,  -6.931310357899397e-12,   2.564390245213266e-14,   1.247236879013054e-14,  -6.262100841877992e-16,   2.885816995002256e-01,  -3.423936855357987e-03,
   5.950171802994811e-05,  -1.037741215944897e-06,   1.322273650202462e-08,   3.921319574095789e-11,  -6.880607023138007e-12,   2.254759419311074e-14,   1.252216981252199e-14,
  -6.220788579186296e-16,   2.885956358900216e-01,  -3.424663865799933e-03,   5.952013246996811e-05,  -1.037649355815414e-06,   1.319951684657486e-08,   3.925153680981099e-11,
  -6.797233897131364e-12,   1.748006267090535e-14,   1.260252530875723e-14,  -6.152617867445074e-16,   2.886104250284843e-01,  -3.425435256618408e-03,   5.953966000035020e-05,
  -1.037551878235460e-06,   1.317498612885157e-08,   3.928324867366858e-11,  -6.708586749700121e-12,   1.212423513176160e-14,   1.268588992255799e-14,  -6.079814229535059e-16,
   2.886220652813629e-01,  -3.426042328272726e-03,   5.955501988189132e-05,  -1.037475160782285e-06,   1.315575797612119e-08,   3.930172552666298e-11,  -6.638691061111548e-12,
   7.924584090874630e-15,   1.275012766612968e-14,  -6.022182624909215e-16,   2.886287835490374e-01,  -3.426392674393139e-03,   5.956388101472690e-05,  -1.037430885756375e-06,
   1.314469218730044e-08,   3.930979599700614e-11,  -6.598301380978830e-12,   5.507079105125963e-15,   1.278665246527933e-14,  -5.988789748875500e-16,   2.886313064104189e-01,
  -3.426524231559657e-03,   5.956720782489084e-05,  -1.037414260179171e-06,   1.314054276529597e-08,   3.931233703438647e-11,  -6.583124985537838e-12,   4.600455051079811e-15,
   1.280026446471511e-14,  -5.976225533228737e-16,   2.886317246152917e-01,  -3.426546038975276e-03,   5.956775925790399e-05,  -1.037411504261674e-06,   1.313985525009994e-08,
   3.931273243825912e-11,  -6.580608772323739e-12,   4.450231073276149e-15,   1.280251539627168e-14,  -5.974141527986204e-16,   9.073863394515640e-02,  -1.087981704118230e-03,
   2.054072266196788e-05,  -5.061195545657137e-07,   1.633284459243559e-08,  -5.689178125948155e-10,   1.619585724617515e-11,  -2.459971112678093e-13,  -4.415956678841381e-15,
   3.591369011873765e-16,   9.074158548000676e-02,  -1.088200660168014e-03,   2.055486291265174e-05,  -5.069351129741586e-07,   1.636720094098672e-08,  -5.696251112932009e-10,
   1.617777195442655e-11,  -2.442431982889545e-13,  -4.440509325173565e-15,   3.559594361530195e-16,   9.074643238790628e-02,  -1.088560365009913e-03,   2.057809755728783e-05,
  -5.082747001441523e-07,   1.642357429819138e-08,  -5.707825247035199e-10,   1.614801715003157e-11,  -2.413758261173240e-13,  -4.479797924292870e-15,   3.507172262251351e-16,
   9.075157735228269e-02,  -1.088942383685128e-03,   2.060278002535065e-05,  -5.096970767729675e-07,   1.648335247939219e-08,  -5.720055721953613e-10,   1.611635843690300e-11,
  -2.383496277285438e-13,  -4.520105358608722e-15,   3.451200891142292e-16,   9.075562793010740e-02,  -1.089243283575786e-03,   2.062222603989221e-05,  -5.108171961386795e-07,
   1.653037044690330e-08,  -5.729644664478200e-10,   1.609138144088498e-11,  -2.359798384658117e-13,  -4.550830528994052e-15,   3.406902959249864e-16,   9.075796618485719e-02,
  -1.089417038703268e-03,   2.063345704330738e-05,  -5.114639195838539e-07,   1.655749428889863e-08,  -5.735164034717985e-10,   1.607694251886627e-11,  -2.346169475784338e-13,
  -4.568163891551628e-15,   3.381239398648295e-16,   9.075884433376800e-02,  -1.089482304370379e-03,   2.063767597058536e-05,  -5.117068236519162e-07,   1.656767745298006e-08,
  -5.737233858768705e-10,   1.607151603325639e-11,  -2.341060698670643e-13,  -4.574597485391111e-15,   3.371584018972808e-16,   9.075898990537627e-02,  -1.089493124085465e-03,
   2.063837540118906e-05,  -5.117470912716385e-07,   1.656936534692706e-08,  -5.737576816535781e-10,   1.607061627797772e-11,  -2.340214321620547e-13,  -4.575659978220031e-15,
   3.369982531119692e-16,   7.465416448178152e-03,  -9.198650519310145e-05,   2.090217426398224e-06,  -8.162606512200283e-08,   4.125780511088189e-09,  -1.857543656920824e-10,
   6.157744746634217e-12,  -1.170170839096189e-13,  -5.507874460021509e-16,   9.931968024724714e-17,   7.465721136449796e-03,  -9.202229781223168e-05,   2.093814510548345e-06,
  -8.189329074877858e-08,   4.138898500120770e-09,  -1.860966759190660e-10,   6.155524241284565e-12,  -1.165493883772718e-13,  -5.524505554862985e-16,   9.779833895881359e-17,
   7.466221713491514e-03,  -9.208114032198319e-05,   2.099727793827790e-06,  -8.233233394009122e-08,   4.160430368720060e-09,  -1.866576503754347e-10,   6.151876659463728e-12,
  -1.157873062763974e-13,  -5.547402416505960e-16,   9.528981240512872e-17,   7.466753383959644e-03,  -9.214368981595792e-05,   2.106013234893359e-06,  -8.279866658727471e-08,
   4.183272679140375e-09,  -1.872515582526692e-10,   6.148003909700539e-12,  -1.149864680598967e-13,  -5.565724874792331e-16,   9.261330992884383e-17,   7.467172187931103e-03,
  -9.219299848888069e-05,   2.110967866564242e-06,  -8.316601551825804e-08,   4.201246319112920e-09,  -1.877180097543716e-10,   6.144954851966300e-12,  -1.143618609493985e-13,
  -5.575832008908217e-16,   9.049634619158803e-17,   7.467414038938142e-03,  -9.222148832990357e-05,   2.113830470461564e-06,  -8.337815699739365e-08,   4.211617904122082e-09,
  -1.879868261530367e-10,   6.143194885019418e-12,  -1.140036609519378e-13,  -5.579940177035221e-16,   8.927042705888021e-17,   7.467504884959492e-03,  -9.223219275772655e-05,
   2.114906009424043e-06,  -8.345784415339488e-08,   4.215512281513477e-09,  -1.880876974154971e-10,   6.142533965154400e-12,  -1.138695835542022e-13,  -5.581157285407648e-16,
   8.880929824564749e-17,   7.467519945495062e-03,  -9.223396749746692e-05,   2.115084327198137e-06,  -8.347105480717882e-08,   4.216157816809406e-09,  -1.881044144796198e-10,
   6.142424406908659e-12,  -1.138473810203885e-13,  -5.581341875749445e-16,   8.873281832416816e-17,   8.751058300664380e-05,  -1.158076046784392e-06,   3.789618236710051e-08,
  -2.363342921182533e-09,   1.533429681514551e-10,  -8.023358988986598e-12,   3.194274202996218e-13,  -9.344566472232865e-15,   1.978349672602199e-16,  -4.383466494079637e-18,
   8.751624717532618e-05,  -1.159126243283098e-06,   3.803103752725115e-08,  -2.375000502811675e-09,   1.540346886153108e-10,  -8.051708148985989e-12,   3.202534205640966e-13,
  -9.370601080224975e-15,   1.996230763519099e-16,  -4.515783877598647e-18,   8.752556033002450e-05,  -1.160853964525724e-06,   3.825285416856194e-08,  -2.394167650401460e-09,
   1.551715546235697e-10,  -8.098306472075878e-12,   3.216147580708136e-13,  -9.413838507953161e-15,   2.025889486786328e-16,  -4.733993171245703e-18,   8.753546204566272e-05,
  -1.162692181073820e-06,   3.848880372246310e-08,  -2.414545386526828e-09,   1.563796218796472e-10,  -8.147831118541740e-12,   3.230665267712856e-13,  -9.460394760478004e-15,
   2.057772729778678e-16,  -4.966867642531948e-18,   8.754326905890836e-05,  -1.164142470102918e-06,   3.867492113791167e-08,  -2.430611696017773e-09,   1.573316584109553e-10,
  -8.186865829607221e-12,   3.242143882165037e-13,  -9.497527218986603e-15,   2.083163951897180e-16,  -5.151104452472313e-18,   8.754778038193883e-05,  -1.164980905806223e-06,
   3.878250316521909e-08,  -2.439895480623916e-09,   1.578816121107846e-10,  -8.209417150861970e-12,   3.248789831758807e-13,  -9.519154991773433e-15,   2.097937515357076e-16,
  -5.257815633943921e-18,   8.754947551485863e-05,  -1.165296020128795e-06,   3.882293343713085e-08,  -2.443383828271458e-09,   1.580882226412657e-10,  -8.217889880300767e-12,
   3.251289514690840e-13,  -9.527313902095670e-15,   2.103507772792297e-16,  -5.297959224927507e-18,   8.754975656472779e-05,  -1.165348269263980e-06,   3.882963702985206e-08,
  -2.443962187606282e-09,   1.581224764384000e-10,  -8.219294593487067e-12,   3.251704087606925e-13,  -9.528668336269570e-15,   2.104432316806637e-16,  -5.304617418666015e-18,
   2.757573023323094e-01,  -2.993779332777918e-03,   4.830635968067876e-05,  -8.279554490814178e-07,   1.257150299533615e-08,  -9.107995318411373e-11,  -3.367958767242501e-12,
   1.561039181776214e-13,  -1.401946673186155e-15,  -1.539699361620711e-16,   2.757641981848413e-01,  -2.994133248898273e-03,   4.831705274267341e-05,  -8.280812493146251e-07,
   1.256426337319647e-08,  -9.062684167957727e-11,  -3.372342202540712e-12,   1.552710016247210e-13,  -1.343915273718179e-15,  -1.556323251180274e-16,   2.757755199364059e-01,
  -2.994714297437512e-03,   4.833460265211499e-05,  -8.282873103384569e-07,   1.255237223816348e-08,  -8.988481320300440e-11,  -3.379371615818364e-12,   1.538976309799239e-13,
  -1.248720508236848e-15,  -1.583412563494789e-16,   2.757875346759488e-01,  -2.995330886348832e-03,   4.835321836873360e-05,  -8.285053323108804e-07,   1.253974664325663e-08,
  -8.909995422102599e-11,  -3.386603924690526e-12,   1.524322607693006e-13,  -1.147813618177686e-15,  -1.611882048726678e-16,   2.757969914148934e-01,  -2.995816182292630e-03,
   4.836786462214429e-05,  -8.286764652731843e-07,   1.252980442067548e-08,  -8.848407480830360e-11,  -3.392131939195231e-12,   1.512731616064192e-13,  -1.068475391269859e-15,
  -1.634088627979451e-16,   2.758024495150252e-01,  -2.996096270975759e-03,   4.837631549182791e-05,  -8.287750487501303e-07,   1.252406427586317e-08,  -8.812936558240533e-11,
  -3.395256618366227e-12,   1.506018904876282e-13,  -1.022718911260707e-15,  -1.646824556637495e-16,   2.758044991673869e-01,  -2.996201449876185e-03,   4.837948854291019e-05,
  -8.288120337038644e-07,   1.252190836519829e-08,  -8.799630633211964e-11,  -3.396417562684922e-12,   1.503493819463449e-13,  -1.005542869668712e-15,  -1.651591902854590e-16,
   2.758048389309027e-01,  -2.996218884932871e-03,   4.838001450389678e-05,  -8.288181626900350e-07,   1.252155096960942e-08,  -8.797425712055736e-11,  -3.396609351567058e-12,
   1.503075018835416e-13,  -1.002696011942972e-15,  -1.652381360620076e-16,   8.668218314252224e-02,  -9.442469873431494e-04,   1.572137438081730e-05,  -3.171955205974674e-07,
   8.245037644562752e-09,  -2.687662351198912e-10,   8.891919811480799e-12,  -2.352533624839226e-13,   3.282282684592613e-15,   6.903466749638397e-17,   8.668443478684658e-02,
  -9.443837782815569e-04,   1.572852279358592e-05,  -3.175838727661889e-07,   8.264163709650329e-09,  -2.694631178365700e-10,   8.904241594128668e-12,  -2.348713310924495e-13,
   3.245750750284865e-15,   7.010483505739553e-17,   8.668813197826780e-02,  -9.446084639623434e-04,   1.574026991960063e-05,  -3.182221299188887e-07,   8.295580850345879e-09,
  -2.706063202817099e-10,   8.924364951726905e-12,  -2.342403116585902e-13,   3.185841236845561e-15,   7.184718630553169e-17,   8.669205600800534e-02,  -9.448470377011385e-04,
   1.575275063899159e-05,  -3.189003402869964e-07,   8.328942068254012e-09,  -2.718181958096833e-10,   8.945575006129499e-12,  -2.335655442741503e-13,   3.122360898393335e-15,
   7.367620930632539e-17,   8.669514498189282e-02,  -9.450349159497155e-04,   1.576258470023268e-05,  -3.194347974808644e-07,   8.355215700596057e-09,  -2.727711116294089e-10,
   8.962164426146739e-12,  -2.330307521153635e-13,   3.072466940340012e-15,   7.510133457421327e-17,   8.669692798667877e-02,  -9.451433920784976e-04,   1.576826480857575e-05,
  -3.197435244771448e-07,   8.370385991588760e-09,  -2.733207214865348e-10,   8.971697244051901e-12,  -2.327206189347501e-13,   3.043698864073035e-15,   7.591805061908800e-17,
   8.669759757896746e-02,  -9.451841350041861e-04,   1.577039863036675e-05,  -3.198595076875802e-07,   8.376083956960504e-09,  -2.735270417153682e-10,   8.975269116667657e-12,
  -2.326038793441401e-13,   3.032901270226623e-15,   7.622364740843349e-17,   8.669770857644225e-02,  -9.451908892053847e-04,   1.577075238854422e-05,  -3.198787363685792e-07,
   8.377028548500832e-09,  -2.735612388807413e-10,   8.975860794527649e-12,  -2.325845132581339e-13,   3.031111685205165e-15,   7.627424701627203e-17,   7.125981329278572e-03,
  -7.829632463599845e-05,   1.407145829215766e-06,  -3.841635446239155e-08,   1.625258027289590e-09,  -7.643852876442746e-11,   3.074635115534249e-12,  -9.196041783583193e-14,
   1.572152251221883e-15,   1.372456562434270e-17,   7.126184443487896e-03,  -7.831311833977744e-05,   1.408571170262401e-06,  -3.852744032505946e-08,   1.631892354880377e-09,
  -7.671205970378806e-11,   3.080656593298830e-12,  -9.188091602885437e-14,   1.560412569274874e-15,   1.407271037686618e-17,   7.126518041021588e-03,  -7.834072274197237e-05,
   1.410915215141635e-06,  -3.871008655245438e-08,   1.642792839025967e-09,  -7.716092744545999e-11,   3.090508212685752e-12,  -9.174915834807821e-14,   1.541174380857396e-15,
   1.463809047675156e-17,   7.126872221541412e-03,  -7.837006051658942e-05,   1.413408026181822e-06,  -3.890426985295145e-08,   1.654371518447690e-09,  -7.763696805214840e-11,
   3.100915919395347e-12,  -9.160767706597747e-14,   1.520808728583890e-15,   1.522961982641761e-17,   7.127151114077812e-03,  -7.839318383421877e-05,   1.415373937267159e-06,
  -3.905736929325205e-08,   1.663492972580980e-09,  -7.801143762482527e-11,   3.109073852449165e-12,  -9.149512684456286e-14,   1.504815909939258e-15,   1.568907465301750e-17,
   7.127312128846013e-03,  -7.840654252837954e-05,   1.416510129510887e-06,  -3.914583664684385e-08,   1.668760731478253e-09,  -7.822748006557349e-11,   3.113768747493275e-12,
  -9.142969266932811e-14,   1.495600400069882e-15,   1.595179300166379e-17,   7.127372602922160e-03,  -7.841156145603073e-05,   1.416937088518673e-06,  -3.917907793295470e-08,
   1.670739504882301e-09,  -7.830859263562463e-11,   3.115529232697927e-12,  -9.140503129322170e-14,   1.492142603969676e-15,   1.604998430472655e-17,   7.127382627969033e-03,
  -7.841239355259806e-05,   1.417007879311064e-06,  -3.918458925522425e-08,   1.671067550620654e-09,  -7.832203749111349e-11,   3.115820926764526e-12,  -9.140093856856860e-14,
   1.491569568834350e-15,   1.606623653182711e-17,   8.335073525416889e-05,  -9.365215242802134e-07,   2.009560360841673e-08,  -8.545654643301973e-10,   5.158524554650117e-11,
  -2.884984159817305e-12,   1.305261312594250e-13,  -4.559377661196578e-15,   1.147976529741715e-16,  -1.686786251098573e-18,   8.335368685363423e-05,  -9.369012959897620e-07,
   2.014126156565585e-08,  -8.587873593164476e-10,   5.186931256924453e-11,  -2.898749617478823e-12,   1.309843649127690e-13,  -4.568121615603075e-15,   1.148329337457995e-16,
  -1.690265714817145e-18,   8.335853733918475e-05,  -9.375260828559019e-07,   2.021639353814539e-08,  -8.657325007265492e-10,   5.233636205054336e-11,  -2.921366806229373e-12,
   1.317367539348206e-13,  -4.582491780546620e-15,   1.148947862977435e-16,  -1.696330026744904e-18,   8.336369082706497e-05,  -9.381908402225675e-07,   2.029635522996888e-08,
  -8.731211661986789e-10,   5.283289931330856e-11,  -2.945391183589243e-12,   1.325352721844992e-13,  -4.597761491045019e-15,   1.149658072645449e-16,  -1.703244718782271e-18,
   8.336775154286496e-05,  -9.387153203198267e-07,   2.035946008166103e-08,  -8.789500913570957e-10,   5.322437312147376e-11,  -2.964317185628850e-12,   1.331638422408040e-13,
  -4.609795225668278e-15,   1.150256391892447e-16,  -1.709035161000328e-18,   8.337009702569994e-05,  -9.390185348069719e-07,   2.039594916812189e-08,  -8.823196953868094e-10,
   5.345057948576230e-11,  -2.975247249283798e-12,   1.335266568913204e-13,  -4.616746887562573e-15,   1.150617594654251e-16,  -1.712516984723670e-18,   8.337097814942826e-05,
  -9.391324945014840e-07,   2.040966442912096e-08,  -8.835860772761766e-10,   5.353557499591222e-11,  -2.979353014709785e-12,   1.336629079159811e-13,  -4.619358605481124e-15,
   1.150756249067902e-16,  -1.713850953794981e-18,   8.337112422790983e-05,  -9.391513902102991e-07,   2.041193862892527e-08,  -8.837960542380795e-10,   5.354966700233210e-11,
  -2.980033678911965e-12,   1.336854940332095e-13,  -4.619791604223279e-15,   1.150779392631890e-16,  -1.714073477723798e-18,   2.644967794960950e-01,  -2.643810998179524e-03,
   3.950715996798628e-05,  -6.444258380004500e-07,   1.025531679990279e-08,  -1.276119682097447e-10,  -6.686555179008644e-14,   7.422958980098215e-14,  -2.622862220324391e-15,
   3.413842990583329e-17,   2.645024192609495e-01,  -2.644086752277100e-03,   3.951591485194626e-05,  -6.446055437781888e-07,   1.025505256910456e-08,  -1.273877246468392e-10,
  -7.711823656268876e-14,   7.438321500182121e-14,  -2.613428986229617e-15,   3.334840491459273e-17,   2.645116787482029e-01,  -2.644539502277157e-03,   3.953028720974603e-05,
  -6.449003282741066e-07,   1.025460308034184e-08,  -1.270192746068517e-10,  -9.392174413409855e-14,   7.463247355031848e-14,  -2.597809219488122e-15,   3.204922116190479e-17,
   2.645215050037080e-01,  -2.645019979759671e-03,   3.954553711362746e-05,  -6.452128024423743e-07,   1.025410480942325e-08,  -1.266278920332049e-10,  -1.117133897584368e-13,
   7.489295322813605e-14,  -2.581054229046653e-15,   3.066769433641747e-17,   2.645292392045471e-01,  -2.645398172146810e-03,   3.955753866230744e-05,  -6.454584930769995e-07,
   1.025369724416273e-08,  -1.263195643232808e-10,  -1.256877039851373e-13,   7.509505049039359e-14,  -2.567737034374600e-15,   2.957828883238295e-17,   2.645337031182878e-01,
  -2.645616456038015e-03,   3.956446490687444e-05,  -6.456001944376261e-07,   1.025345585410624e-08,  -1.261414999913738e-10,  -1.337413544117930e-13,   7.521052055388659e-14,
  -2.559999028286243e-15,   2.894872502664060e-17,   2.645353794294220e-01,  -2.645698427904266e-03,   3.956706576457098e-05,  -6.456533874062418e-07,   1.025336404313011e-08,
  -1.260746120407903e-10,  -1.367634569482729e-13,   7.525366053044984e-14,  -2.557083438097142e-15,   2.871215872106131e-17,   2.645356573055285e-01,  -2.645712016130398e-03,
   3.956749689311361e-05,  -6.456622039893309e-07,   1.025334876262117e-08,  -1.260635231936177e-10,  -1.372643015314768e-13,   7.526079998037108e-14,  -2.556599615709520e-15,
   2.867293611918386e-17,   8.313534025209419e-02,  -8.318021097684366e-04,   1.256115760761689e-05,  -2.186922076136586e-07,   4.536532280051872e-09,  -1.215164510432754e-10,
   3.904358710839902e-12,  -1.226151834667382e-13,   3.096990698784423e-15,  -4.492657839205657e-17,   8.313713568424820e-02,  -8.318960968955496e-04,   1.256507921519692e-05,
  -2.188682602442693e-07,   4.545011860348766e-09,  -1.218863073150085e-10,   3.916602281282233e-12,  -1.228313711072956e-13,   3.092415771735105e-15,  -4.440746729335525e-17,
   8.314008358794273e-02,  -8.320504470403582e-04,   1.257152244820581e-05,  -2.191576609754717e-07,   4.558951301693611e-09,  -1.224939440948283e-10,   3.936688390332842e-12,
  -1.231843451637767e-13,   3.084814978909478e-15,  -4.355382803544386e-17,   8.314321210083141e-02,  -8.322142993770781e-04,   1.257836639810150e-05,  -2.194652567352528e-07,
   4.573767716826521e-09,  -1.231393136424518e-10,   3.957982552046403e-12,  -1.235562480867296e-13,   3.076627465727510e-15,  -4.264612842810580e-17,   8.314567466205895e-02,
  -8.323433063109110e-04,   1.258375782739067e-05,  -2.197077123416598e-07,   4.585446832234092e-09,  -1.236476699288456e-10,   3.974727480573006e-12,  -1.238470313964885e-13,
   3.070095368418496e-15,  -4.193039348983227e-17,   8.314709601677957e-02,  -8.324177805116494e-04,   1.258687141463353e-05,  -2.198477890490953e-07,   4.592194498270102e-09,
  -1.239412308909587e-10,   3.984385782568053e-12,  -1.240140833048153e-13,   3.066290166098142e-15,  -4.151678647732084e-17,   8.314762978033136e-02,  -8.324457504326046e-04,
   1.258804099244960e-05,  -2.199004177629941e-07,   4.594729716079811e-09,  -1.240514996393187e-10,   3.988011522618206e-12,  -1.240766683137540e-13,   3.064854591539597e-15,
  -4.136137125052170e-17,   8.314771826090110e-02,  -8.324503870646510e-04,   1.258823488754832e-05,  -2.199091432302457e-07,   4.595150038679050e-09,  -1.240697800381793e-10,
   3.988612485516104e-12,  -1.240870350421740e-13,   3.064616272131420e-15,  -4.133560360838543e-17,   6.832889653182146e-03,  -6.853513490678380e-05,   1.062570499644912e-06,
  -2.140460364254492e-08,   6.556222779141096e-10,  -2.781282539731770e-11,   1.200354554116613e-12,  -4.394797160480739e-14,   1.228051757434460e-15,  -2.098712711457671e-17,
   6.833042020706248e-03,  -6.854441703220693e-05,   1.063145173168977e-06,  -2.144530748635232e-08,   6.582424418452188e-10,  -2.794579564725893e-11,   1.205229047615279e-12,
  -4.405080167310480e-14,   1.227176286230437e-15,  -2.081299585399122e-17,   6.833292218183556e-03,  -6.855966796838435e-05,   1.064090228216655e-06,  -2.151226688085426e-08,
   6.625513753768147e-10,  -2.816430688807134e-11,   1.213228609770647e-12,  -4.421896523381872e-14,   1.225706511600800e-15,  -2.052661595054254e-17,   6.833557780762259e-03,
  -6.857586784436842e-05,   1.065095229934806e-06,  -2.158350289905992e-08,   6.671336917557055e-10,  -2.839646114676508e-11,   1.221713032220540e-12,  -4.439651721624422e-14,
   1.224102837129699e-15,  -2.022205562307036e-17,   6.833766840597190e-03,  -6.858862988758338e-05,   1.065887784727002e-06,  -2.163970145501029e-08,   6.707473855317820e-10,
  -2.857938215719608e-11,   1.228387575641103e-12,  -4.453561179270198e-14,   1.222808867870210e-15,  -1.998187488453962e-17,   6.833887517468467e-03,  -6.859600019139877e-05,
   1.066345830887817e-06,  -2.167218906130047e-08,   6.728358791983892e-10,  -2.868503518704479e-11,   1.232238473008717e-12,  -4.461562929057892e-14,   1.222049345492255e-15,
  -1.984306829645448e-17,   6.833932837439476e-03,  -6.859876877450400e-05,   1.066517954199344e-06,  -2.168439875145109e-08,   6.736206887944115e-10,  -2.872472513188861e-11,
   1.233684311487143e-12,  -4.464562810760652e-14,   1.221761731154076e-15,  -1.979090879713508e-17,   6.833940350116422e-03,  -6.859922775748325e-05,   1.066546492562256e-06,
  -2.168642322428952e-08,   6.737508117305098e-10,  -2.873130516142639e-11,   1.233923968700015e-12,  -4.465059827902101e-14,   1.221713928106255e-15,  -1.978226070984523e-17,
   7.987642248553136e-05,  -8.062116519137407e-07,   1.333807756913432e-08,  -3.572424020826291e-10,   1.678086206236874e-11,  -9.245488225709357e-13,   4.534249962155361e-14,
  -1.826146815593719e-15,   5.803936958111221e-17,  -1.346905469897654e-18,   7.987835055379191e-05,  -8.063689907007260e-07,   1.335297131516248e-08,  -3.586052039281807e-10,
   1.688042619283282e-11,  -9.301156587688336e-13,   4.557589961758119e-14,  -1.833003257101452e-15,   5.814282711076501e-17,  -1.345271058201276e-18,   7.988151741374055e-05,
  -8.066277194194480e-07,   1.337748414095298e-08,  -3.608482352727145e-10,   1.704423806738092e-11,  -9.392693030853648e-13,   4.595935827276275e-14,  -1.844253175370007e-15,
   5.831211293160753e-17,  -1.342589219914119e-18,   7.988487990758302e-05,  -8.069028382121829e-07,   1.340357898049407e-08,  -3.632361172966073e-10,   1.721854633370575e-11,
  -9.490021097770530e-13,   4.636663732713207e-14,  -1.856182004282216e-15,   5.849098776124314e-17,  -1.339745894834663e-18,   7.988752781140895e-05,  -8.071197843863982e-07,
   1.342417727734957e-08,  -3.651210849209572e-10,   1.735608369777624e-11,  -9.566764145808858e-13,   4.668745686740551e-14,  -1.865564119985988e-15,   5.863122435550440e-17,
  -1.337510273029380e-18,   7.988905661220698e-05,  -8.072451593806946e-07,   1.343608964978809e-08,  -3.662112203604787e-10,   1.743560190348392e-11,  -9.611112303811569e-13,
   4.687272363695379e-14,  -1.870976344858058e-15,   5.871194315138378e-17,  -1.336221026789109e-18,   7.988963081389326e-05,  -8.072922713109297e-07,   1.344056753503648e-08,
  -3.666210089705169e-10,   1.746548876051759e-11,  -9.627776484737303e-13,   4.694231496330944e-14,  -1.873008239936683e-15,   5.874221350227682e-17,  -1.335737102598845e-18,
   7.988972600246921e-05,  -8.073000824962930e-07,   1.344131005511754e-08,  -3.666889600898287e-10,   1.747044435836996e-11,  -9.630539391847321e-13,   4.695385187182029e-14,
  -1.873345031939011e-15,   5.874722912148059e-17,  -1.335656896218838e-18,   2.545083588131350e-01,  -2.356088376231423e-03,   3.267561036481013e-05,  -5.002931187561241e-07,
   7.811956268100207e-09,  -1.124278373625971e-10,   1.056094538804119e-12,   1.395355974370067e-14,  -1.148814973855791e-15,   3.588767067806009e-17,   2.545130222313115e-01,
  -2.356302526213300e-03,   3.268229298901694e-05,  -5.004527325772548e-07,   7.814155319046096e-09,  -1.123832325028527e-10,   1.051447536979497e-12,   1.413560193697490e-14,
  -1.152196588209875e-15,   3.582202360064098e-17,   2.545206786765533e-01,  -2.356654137239659e-03,   3.269326493799746e-05,  -5.007147174168557e-07,   7.817758210976526e-09,
  -1.123096144146323e-10,   1.043809209214811e-12,   1.443419578614475e-14,  -1.157710298297727e-15,   3.571229409960636e-17,   2.545288036940035e-01,  -2.357027290537455e-03,
   3.270490884239359e-05,  -5.009926393746194e-07,   7.821571356156674e-09,  -1.122309674991960e-10,   1.035691471817474e-12,   1.475067247768302e-14,  -1.163509313846345e-15,
   3.559319930823086e-17,   2.545351988041281e-01,  -2.357321012519655e-03,   3.271407397108664e-05,  -5.012113187561831e-07,   7.824565218600444e-09,  -1.121686867173256e-10,
   1.029293490795317e-12,   1.499948152455633e-14,  -1.168035802194928e-15,   3.549754233273651e-17,   2.545388898193088e-01,  -2.357490544608559e-03,   3.271936387245607e-05,
  -5.013375041429145e-07,   7.826290185948673e-09,  -1.121325889176998e-10,   1.025597386966350e-12,   1.514296892964892e-14,  -1.170633111977651e-15,   3.544156354715240e-17,
   2.545402758836398e-01,  -2.357554209258305e-03,   3.272135038243873e-05,  -5.013848844576851e-07,   7.826937389568170e-09,  -1.121190046725932e-10,   1.024208765017066e-12,
   1.519682987769917e-14,  -1.171605585273499e-15,   3.542039678402147e-17,   2.545405056463555e-01,  -2.357564762778598e-03,   3.272167968014563e-05,  -5.013927382354619e-07,
   7.827044644403469e-09,  -1.121167513513221e-10,   1.023978544264458e-12,   1.520575704273768e-14,  -1.171766636589497e-15,   3.541688037843509e-17,   7.999402373068465e-02,
  -7.407328113755743e-04,   1.030590155387797e-05,  -1.614447426762104e-07,   2.816441251195888e-09,  -5.936555088053388e-11,   1.606421513661432e-12,  -5.008407135484198e-14,
   1.495589023957407e-15,  -3.662157064686117e-17,   7.999549521251138e-02,  -7.408020389830610e-04,   1.030832622672629e-05,  -1.615305158391612e-07,   2.819942086002810e-09,
  -5.951820890156150e-11,   1.612453100040299e-12,  -5.027090932987627e-14,   1.499095025425511e-15,  -3.659393028623787e-17,   7.999791114076425e-02,  -7.409157140798970e-04,
   1.031230890315679e-05,  -1.616714846351359e-07,   2.825698617191801e-09,  -5.976922479400952e-11,   1.622364877120033e-12,  -5.057752154822650e-14,   1.504825349225797e-15,
  -3.654720159916607e-17,   8.000047497092724e-02,  -7.410363685610789e-04,   1.031653780148865e-05,  -1.618212787503919e-07,   2.831819449749185e-09,  -6.003611968891482e-11,
   1.632895523744922e-12,  -5.090270508420819e-14,   1.510871122677554e-15,  -3.649578034717566e-17,   8.000249296759175e-02,  -7.411313506607976e-04,   1.031986812017022e-05,
  -1.619393235884706e-07,   2.836645784675842e-09,  -6.024656376317054e-11,   1.641192929753932e-12,  -5.115851132423839e-14,   1.515604092154037e-15,  -3.645398024080739e-17,
   8.000365769271418e-02,  -7.411861772729719e-04,   1.032179097624855e-05,  -1.620075121972354e-07,   2.839434849928654e-09,  -6.036817400886069e-11,   1.645985415505068e-12,
  -5.130609533345386e-14,   1.518325500754634e-15,  -3.642932287195122e-17,   8.000409507744427e-02,  -7.412067672125732e-04,   1.032251319123856e-05,  -1.620331295415698e-07,
   2.840482869934919e-09,  -6.041386988624589e-11,   1.647785775654052e-12,  -5.136150567093974e-14,   1.519345508438807e-15,  -3.641996290195134e-17,   8.000416758121921e-02,
  -7.412101803953926e-04,   1.032263291733389e-05,  -1.620373766080524e-07,   2.840656631095163e-09,  -6.042144621562738e-11,   1.648084249814872e-12,  -5.137069025457916e-14,
   1.519514488568732e-15,  -3.641840603078904e-17,   6.574330141080350e-03,  -6.091755244284448e-05,   8.543984951580111e-07,  -1.414684026779028e-08,   3.077832478538204e-10,
  -1.001994495480070e-11,   4.089560341401741e-13,  -1.620035083038281e-14,   5.477213759914792e-16,  -1.458980012369651e-17,   6.574452267116488e-03,  -6.092364398517276e-05,
   8.546664027536095e-07,  -1.416151932059102e-08,   3.086825753433372e-10,  -1.006955308678018e-11,   4.111716120452119e-13,  -1.627507968983527e-14,   5.493256341221228e-16,
  -1.458968951053833e-17,   6.574652785162326e-03,  -6.093364886675248e-05,   8.551067798765296e-07,  -1.418566888552928e-08,   3.101624028894547e-10,  -1.015115426086209e-11,
   4.148134136751791e-13,  -1.639775505987537e-14,   5.519508569899481e-16,  -1.458901264366602e-17,   6.574865588928938e-03,  -6.094427111950511e-05,   8.555748209881559e-07,
  -1.421136355753083e-08,   3.117372878616698e-10,  -1.023795875830214e-11,   4.186838468760636e-13,  -1.652791646484989e-14,   5.547249315372124e-16,  -1.458762116199043e-17,
   6.575033094601749e-03,  -6.095263545672430e-05,   8.559437280176596e-07,  -1.423163623793195e-08,   3.129801174278445e-10,  -1.030643315944815e-11,   4.217343766777883e-13,
  -1.663034857220362e-14,   5.568997944708441e-16,  -1.458603847996167e-17,   6.575129776629605e-03,  -6.095746451287547e-05,   8.561568547407346e-07,  -1.424335640042389e-08,
   3.136987372700036e-10,  -1.034601473019975e-11,   4.234966888036599e-13,  -1.668946163795514e-14,   5.581515943397923e-16,  -1.458492960366166e-17,   6.575166083815823e-03,
  -6.095927821832095e-05,   8.562369281797302e-07,  -1.424776129702681e-08,   3.139688430736397e-10,  -1.036089003476736e-11,   4.241587927696288e-13,  -1.671165867718022e-14,
   5.586210221627315e-16,  -1.458447625807707e-17,   6.575172102363674e-03,  -6.095957888426364e-05,   8.562502037273747e-07,  -1.424849167533983e-08,   3.140136305326986e-10,
  -1.036335646411136e-11,   4.242685638126128e-13,  -1.671533812676834e-14,   5.586988029915696e-16,  -1.458439916010975e-17,   7.684282049519691e-05,  -7.131842686275614e-07,
   1.020388753312936e-08,  -1.916850346863771e-10,   5.942609798745939e-12,  -2.799744553269601e-13,   1.389626951362723e-14,  -6.080171807248922e-16,   2.224653371031108e-17,
  -6.584191111337449e-19,   7.684428314194201e-05,  -7.132675699980214e-07,   1.020913631752209e-08,  -1.920993110435697e-10,   5.973351751245107e-12,  -2.818460688478086e-13,
   1.398685461481377e-14,  -6.114280302631274e-16,   2.234017925683118e-17,  -6.598350979457349e-19,   7.684668488169104e-05,  -7.134044542647354e-07,   1.021777236397640e-08,
  -1.927813606403628e-10,   6.023960436882340e-12,  -2.849260172473388e-13,   1.413583388449843e-14,  -6.170326487360320e-16,   2.249381998502936e-17,  -6.621482202078467e-19,
   7.684923408686737e-05,  -7.135498782256217e-07,   1.022696217903160e-08,  -1.935077195537312e-10,   6.077851745129655e-12,  -2.882041328558651e-13,   1.429427807315255e-14,
  -6.229865675951063e-16,   2.265671650043867e-17,  -6.645870655346643e-19,   7.685124088581550e-05,  -7.136644576399201e-07,   1.023421369330395e-08,  -1.940812909492136e-10,
   6.120403377339893e-12,  -2.907913099799142e-13,   1.441923911803884e-14,  -6.276773724567045e-16,   2.278482335380451e-17,  -6.664951902418110e-19,   7.685239927393954e-05,
  -7.137306358555538e-07,   1.023840634530795e-08,  -1.944130821826811e-10,   6.145016489089812e-12,  -2.922873414044894e-13,   1.449146262039421e-14,  -6.303865417143649e-16,
   2.285871857116579e-17,  -6.675918943262929e-19,   7.685283430280181e-05,  -7.137554963094423e-07,   1.023998217738451e-08,  -1.945378191289954e-10,   6.154269498389526e-12,
  -2.928496683501185e-13,   1.451860330164400e-14,  -6.314042416708912e-16,   2.288645979485407e-17,  -6.680028649672194e-19,   7.685290641731100e-05,  -7.137596178067710e-07,
   1.024024347061429e-08,  -1.945585037706625e-10,   6.155803873387181e-12,  -2.929429112295812e-13,   1.452310331502231e-14,  -6.315729600329829e-16,   2.289105792104366e-17,
  -6.680709442566689e-19,   2.455715790528618e-01,  -2.116734249776511e-03,   2.735251251375337e-05,  -3.918413266760473e-07,   5.831515911556742e-09,  -8.551524566844289e-11,
   1.094194492617096e-12,  -6.614744867500047e-15,  -2.668576455282973e-16,   1.431005689848605e-17,   2.455754815560532e-01,  -2.116901965990538e-03,   2.735750487010838e-05,
  -3.919631768384042e-07,   5.833838226626461e-09,  -8.553381554804262e-11,   1.093076155622239e-12,  -6.539963141546477e-15,  -2.695092324318378e-16,   1.436516464212040e-17,
   2.455818886624344e-01,  -2.117177336943240e-03,   2.736570206019626e-05,  -3.921632322060156e-07,   5.837648928030669e-09,  -8.556413853217644e-11,   1.091232590673196e-12,
  -6.416995500634826e-15,  -2.738617583907988e-16,   1.445527292813452e-17,   2.455886877986343e-01,  -2.117469577972733e-03,   2.737440185421278e-05,  -3.923755316083235e-07,
   5.841689985593790e-09,  -8.559609250254753e-11,   1.089266051740074e-12,  -6.286244440259218e-15,  -2.784794142328399e-16,   1.455039323197094e-17,   2.455940392622651e-01,
  -2.117699610246806e-03,   2.738125004326232e-05,  -3.925426305233527e-07,   5.844868582793039e-09,  -8.562108020613581e-11,   1.087710864940445e-12,  -6.183145674102549e-15,
  -2.821129766401186e-16,   1.462489571633203e-17,   2.455971279001099e-01,  -2.117832381221911e-03,   2.738520283029089e-05,  -3.926390738342339e-07,   5.846702315709313e-09,
  -8.563543680569562e-11,   1.086810325980303e-12,  -6.123566588095751e-15,  -2.842097392715225e-16,   1.466774858380202e-17,   2.455982877528073e-01,  -2.117882240850529e-03,
   2.738668724756136e-05,  -3.926752906257694e-07,   5.847390768585285e-09,  -8.564081569231864e-11,   1.086471595710021e-12,  -6.101179183167916e-15,  -2.849970479704139e-16,
   1.468381297884804e-17,   2.455984800170234e-01,  -2.117890505945747e-03,   2.738693331658603e-05,  -3.926812941495315e-07,   5.847504882531772e-09,  -8.564170667813559e-11,
   1.086415416306105e-12,  -6.097467366684858e-15,  -2.851275531617543e-16,   1.468647444126132e-17,   7.718469432433100e-02,  -6.653475220528523e-04,   8.605447790660463e-06,
  -1.241789472270488e-07,   1.924436045835570e-09,  -3.329251975605406e-11,   7.070498301919108e-13,  -1.900362820386794e-14,   5.695139540113215e-16,  -1.619172718824296e-17,
   7.718592226483859e-02,  -6.654007060012075e-04,   8.607099680817526e-06,  -1.242268170518679e-07,   1.925972963296979e-09,  -3.335066058008331e-11,   7.093705685544755e-13,
  -1.908790034181478e-14,   5.719929437468459e-16,  -1.624115624778367e-17,   7.718793829929546e-02,  -6.654880309499354e-04,   8.609812483277634e-06,  -1.243054634852192e-07,
   1.928499670125759e-09,  -3.344629103930198e-11,   7.131875778469847e-13,  -1.922642787812293e-14,   5.760629745226858e-16,  -1.632205764408610e-17,   7.719007770065854e-02,
  -6.655807097175607e-04,   8.612692278826530e-06,  -1.243889955799446e-07,   1.931185611123118e-09,  -3.354801112123528e-11,   7.172474263582524e-13,  -1.937366204051354e-14,
   5.803820539897220e-16,  -1.640756651658292e-17,   7.719176158951037e-02,  -6.656536630630094e-04,   8.614959637058107e-06,  -1.244547953385237e-07,   1.933303020377384e-09,
  -3.362824564719030e-11,   7.204495766982017e-13,  -1.948971362531476e-14,   5.837814971852188e-16,  -1.647461954376421e-17,   7.719273346234724e-02,  -6.656957717477370e-04,
   8.616268552554164e-06,  -1.244927935678445e-07,   1.934526447085425e-09,  -3.367462288418578e-11,   7.223004176438902e-13,  -1.955676029399689e-14,   5.857434947747891e-16,
  -1.651321937670497e-17,   7.719309842305058e-02,  -6.657115850897564e-04,   8.616760134959649e-06,  -1.245070668017353e-07,   1.934986126153511e-09,  -3.369205167423866e-11,
   7.229959593476126e-13,  -1.958195039450744e-14,   5.864802644660191e-16,  -1.652769546729184e-17,   7.719315892118585e-02,  -6.657142064362252e-04,   8.616841625559020e-06,
  -1.245094330331341e-07,   1.935062338796211e-09,  -3.369494146731251e-11,   7.231112834341381e-13,  -1.958612672127238e-14,   5.866023956194471e-16,  -1.653009410775044e-17,
   6.343356836341758e-03,  -5.469010188387794e-05,   7.089500604590055e-07,  -1.041634881614519e-08,   1.772196787335767e-10,  -4.084379826854408e-12,   1.353139527178309e-13,
  -5.211806348695403e-15,   1.903893801236585e-16,  -6.001240425868060e-18,   6.343458032878865e-03,  -5.469456989607990e-05,   7.091030722594892e-07,  -1.042229738882701e-08,
   1.775178066903485e-10,  -4.100456893990479e-12,   1.360931381726875e-13,  -5.243135264311105e-15,   1.913794750448528e-16,  -6.023071436107159e-18,   6.343624179391215e-03,
  -5.470190672922231e-05,   7.093544528612079e-07,  -1.043207968022605e-08,   1.780084451352640e-10,  -4.126918052184406e-12,   1.373751524704906e-13,  -5.294647005143847e-15,
   1.930055325491254e-16,  -6.058833553119905e-18,   6.343800495465009e-03,  -5.470969421795863e-05,   7.096214416312881e-07,  -1.044248224631988e-08,   1.785307016560848e-10,
  -4.155087967801397e-12,   1.387393502859465e-13,  -5.349413858450698e-15,   1.947317837448062e-16,  -6.096674633598680e-18,   6.343939272922107e-03,  -5.471582485508982e-05,
   7.098317478058725e-07,  -1.045068565795725e-08,   1.789429177111675e-10,  -4.177324945631142e-12,   1.398157922705324e-13,  -5.392594391710557e-15,   1.960909778197053e-16,
  -6.126379048355574e-18,   6.344019370434849e-03,  -5.471936370500932e-05,   7.099531937202723e-07,  -1.045542664628496e-08,   1.791812962736150e-10,  -4.190185264364426e-12,
   1.404381550840721e-13,  -5.417546239968078e-15,   1.968756424107883e-16,  -6.143491137485739e-18,   6.344049449043873e-03,  -5.472069271817891e-05,   7.099988118889468e-07,
  -1.045720819059183e-08,   1.792709007104872e-10,  -4.195019533762390e-12,   1.406720715718593e-13,  -5.426921859409340e-15,   1.971703380517590e-16,  -6.149911036029948e-18,
   6.344054435066987e-03,  -5.472091302851408e-05,   7.100063744933136e-07,  -1.045750357335251e-08,   1.792857587265395e-10,  -4.195821151799745e-12,   1.407108578186668e-13,
  -5.428476316421611e-15,   1.972191905038522e-16,  -6.150974916447797e-18,   7.414061769978614e-05,  -6.394692132630882e-07,   8.335202548635070e-09,  -1.278634878764488e-10,
   2.635473027638942e-12,  -8.857633824761346e-14,   3.986516244014847e-15,  -1.786604526155410e-16,   7.073833625021943e-18,  -2.382807705129470e-19,   7.414180848785600e-05,
  -6.395242638712145e-07,   8.337503186147577e-09,  -1.279942342148605e-10,   2.644329493020572e-12,  -8.913031596726133e-14,   4.015602382575052e-15,  -1.799118160344156e-16,
   7.117107702342257e-18,  -2.394222318359635e-19,   7.414376360410115e-05,  -6.396146798134742e-07,   8.341285631901163e-09,  -1.282094537006325e-10,   2.658914171145247e-12,
  -9.004248298775395e-14,   4.063477111435104e-15,  -1.819703548535274e-16,   7.188235165808443e-18,  -2.412956678942825e-19,   7.414583846674466e-05,  -6.397106745645868e-07,
   8.345306694347807e-09,  -1.284386056006766e-10,   2.674451392363782e-12,  -9.101406842342101e-14,   4.114446090270700e-15,  -1.841603624002237e-16,   7.263823544982775e-18,
  -2.432828887361925e-19,   7.414747163606207e-05,  -6.397862638876340e-07,   8.348476803009033e-09,  -1.286195206639858e-10,   2.686724059944918e-12,  -9.178139825713027e-14,
   4.154682273923023e-15,  -1.858880640687602e-16,   7.323396195505243e-18,  -2.448463648205514e-19,   7.414841426690939e-05,  -6.398299044047866e-07,   8.350308547988089e-09,
  -1.287241596975920e-10,   2.693824839158945e-12,  -9.222531768449707e-14,   4.177952833747900e-15,  -1.868868194352255e-16,   7.357810404364340e-18,  -2.457484815439181e-19,
   7.414876825249130e-05,  -6.398462949635161e-07,   8.350996805257637e-09,  -1.287634961045594e-10,   2.696494654579440e-12,  -9.239221782241830e-14,   4.186700515129271e-15,
  -1.872621766673242e-16,   7.370739635493887e-18,  -2.460871977665049e-19,   7.414882693163536e-05,  -6.398490120974094e-07,   8.351110915857767e-09,  -1.287700189682720e-10,
   2.696937394262819e-12,  -9.241989467380281e-14,   4.188151062137467e-15,  -1.873244141002741e-16,   7.372883175550905e-18,  -2.461433428328807e-19,   2.375145814760271e-01,
  -1.915257439239016e-03,   2.315822135486620e-05,  -3.108679181215622e-07,   4.365481645738319e-09,  -6.206513437182961e-11,   8.476075703875929e-13,  -9.509215123706000e-15,
   2.232505673626776e-17,   3.496889743106028e-18,   2.375178845776409e-01,  -1.915390468527370e-03,   2.316195905153570e-05,  -3.109564784706961e-07,   4.367291739074556e-09,
  -6.209325017229939e-11,   8.476758779768099e-13,  -9.490424466571071e-15,   2.133312310818114e-17,   3.529482586103931e-18,   2.375233075397830e-01,  -1.915608885023294e-03,
   2.316809620304415e-05,  -3.111018934133164e-07,   4.370263394671857e-09,  -6.213936565115171e-11,   8.477851403053679e-13,  -9.459455646614234e-15,   1.970141842167005e-17,
   3.583019282774755e-18,   2.375290622468027e-01,  -1.915840679037035e-03,   2.317460971397693e-05,  -3.112562290207682e-07,   4.373416676845978e-09,  -6.218824165764514e-11,
   8.478971626630937e-13,  -9.426430941561381e-15,   1.796559539251967e-17,   3.639866438055130e-18,   2.375335916116791e-01,  -1.916023129103959e-03,   2.317973698103091e-05,
  -3.113777202564819e-07,   4.375898415726972e-09,  -6.222666661465315e-11,   8.479824873572563e-13,  -9.400321253484063e-15,   1.659627077929339e-17,   3.684634392049147e-18,
   2.375362057491436e-01,  -1.916128435413524e-03,   2.318269646794038e-05,  -3.114478465629285e-07,   4.377330710901637e-09,  -6.224882605016866e-11,   8.480305911627956e-13,
  -9.385205097072692e-15,   1.580471661954760e-17,   3.710482311206247e-18,   2.375371874125683e-01,  -1.916167981022946e-03,   2.318380786802656e-05,  -3.114741818307225e-07,
   4.377868558548093e-09,  -6.225714404219039e-11,   8.480484392264979e-13,  -9.379519803970998e-15,   1.550723651244063e-17,   3.720190610206503e-18,   2.375373501388522e-01,
  -1.916174536381537e-03,   2.318399210289485e-05,  -3.114785473913197e-07,   4.377957714838653e-09,  -6.225852270497468e-11,   8.480513864316729e-13,  -9.378576909053417e-15,
   1.545791207800796e-17,   3.721800012640532e-18,   7.465223267090999e-02,  -6.019864658654439e-04,   7.280641521270346e-06,  -9.794260383722877e-08,   1.393879622860421e-09,
  -2.109455661399341e-11,   3.606276677633680e-13,  -7.649088430097597e-15,   2.015146287068799e-16,  -5.770697412358406e-18,   7.465327116202923e-02,  -6.020283865141142e-04,
   7.281836099282523e-06,  -9.797282049345177e-08,   1.394659243866455e-09,  -2.111790190356546e-11,   3.614518904510445e-13,  -7.679424154213093e-15,   2.025368297526762e-16,
  -5.799426472555238e-18,   7.465497613690980e-02,  -6.020972154161406e-04,   7.283797676764325e-06,  -9.802245024248819e-08,   1.395940400991366e-09,  -2.115629300494894e-11,
   3.628079451173017e-13,  -7.729331746860497e-15,   2.042176795306609e-16,  -5.846617867551325e-18,   7.465678541510273e-02,  -6.021702609437247e-04,   7.285879720793164e-06,
  -9.807514419363866e-08,   1.397301554049988e-09,  -2.119711879862270e-11,   3.642508507915319e-13,  -7.782432483167953e-15,   2.060049123336617e-16,  -5.896729236404840e-18,
   7.465820944825979e-02,  -6.022277573873484e-04,   7.287518777661151e-06,  -9.811663849766570e-08,   1.398374055037234e-09,  -2.122931407936255e-11,   3.653893441026285e-13,
  -7.824328013381790e-15,   2.074141647565344e-16,  -5.936194097763283e-18,   7.465903133443658e-02,  -6.022609434100406e-04,   7.288464900861199e-06,  -9.814059525700678e-08,
   1.398993524609659e-09,  -2.124792076025350e-11,   3.660475620380936e-13,  -7.848548835093057e-15,   2.082285493426371e-16,  -5.958980741915952e-18,   7.465933997009253e-02,
  -6.022734057911744e-04,   7.288820215727039e-06,  -9.814959307120882e-08,   1.399226237742259e-09,  -2.125491270139294e-11,   3.662949509169792e-13,  -7.857651951991769e-15,
   2.085345623650639e-16,  -5.967539363781976e-18,   7.465939113135686e-02,  -6.022754716461421e-04,   7.288879116161787e-06,  -9.815108468336963e-08,   1.399264818349139e-09,
  -2.125607197681294e-11,   3.663359708530236e-13,  -7.859161343751891e-15,   2.085852991365299e-16,  -5.968958183622157e-18,   6.135209049049616e-03,  -4.947554803091698e-05,
   5.987322590611344e-07,  -8.097302185640009e-09,   1.190337444920035e-10,  -2.062503489568122e-12,   4.933631177675452e-14,  -1.613395139991599e-15,   5.820374156230352e-17,
  -1.970203457762141e-18,   6.135294458683441e-03,  -4.947901547500094e-05,   5.988345096648339e-07,  -8.100279550327349e-09,   1.191419192010978e-10,  -2.067491872279385e-12,
   4.957618572125465e-14,  -1.623795612995662e-15,   5.858596415061068e-17,  -1.981621680289668e-18,   6.135434683041428e-03,  -4.948470877455198e-05,   5.990024382607811e-07,
  -8.105172577296567e-09,   1.193198798449490e-10,  -2.075703775591648e-12,   4.997108521131692e-14,  -1.640912077955835e-15,   5.921462354001209e-17,  -2.000383079741359e-18,
   6.135583486362812e-03,  -4.949075106880349e-05,   5.991807155948690e-07,  -8.110371538618741e-09,   1.195092195643490e-10,  -2.084448094947316e-12,   5.039161126623893e-14,
  -1.659131635824360e-15,   5.988328109155114e-17,  -2.020312714687604e-18,   6.135700605816883e-03,  -4.949550730158889e-05,   5.993210875889942e-07,  -8.114468285907155e-09,
   1.196586007143707e-10,  -2.091352299977241e-12,   5.072366018203503e-14,  -1.673512301056667e-15,   6.041067655736611e-17,  -2.036013508160068e-18,   6.135768201937264e-03,
  -4.949825258373149e-05,   5.994021258200539e-07,  -8.116834661558046e-09,   1.197449599743557e-10,  -2.095345835684104e-12,   5.091573059460817e-14,  -1.681828419130791e-15,
   6.071551084175014e-17,  -2.045081147254161e-18,   6.135793585745329e-03,  -4.949928353390697e-05,   5.994325615526998e-07,  -8.117723649413872e-09,   1.197774168281353e-10,
  -2.096847147674787e-12,   5.098793788101968e-14,  -1.684954372033173e-15,   6.083006681846945e-17,  -2.048487342072365e-18,   6.135797793516675e-03,  -4.949945443231888e-05,
   5.994376069786539e-07,  -8.117871032473882e-09,   1.197827984989675e-10,  -2.097096101327290e-12,   5.099991164897406e-14,  -1.685472710614825e-15,   6.084906073547625e-17,
  -2.049052031145263e-18,   7.170725509361291e-05,  -5.783159329284375e-07,   7.008495755362418e-09,  -9.599613662243217e-11,   1.519836828691307e-12,  -3.372216369728441e-14,
   1.165141023538327e-15,  -4.904627849279246e-17,   1.998146943389175e-18,  -7.234034550575285e-20,   7.170825509354446e-05,  -5.783570901748759e-07,   7.009808159973188e-09,
  -9.604542089794542e-11,   1.522422671815329e-12,  -3.387489146239104e-14,   1.173413845461924e-15,  -4.942981042721738e-17,   2.013079329221427e-18,  -7.282066232896649e-20,
   7.170989689271105e-05,  -5.784246719727645e-07,   7.011964312120277e-09,  -9.612648868776456e-11,   1.526680682189663e-12,  -3.412645569703351e-14,   1.187038354377604e-15,
  -5.006122803844761e-17,   2.037650175052735e-18,  -7.361041210616928e-20,   7.171163915541419e-05,  -5.784964026006570e-07,   7.014254372683227e-09,  -9.621272536956249e-11,
   1.531216370835085e-12,  -3.439452433236449e-14,   1.201553994720845e-15,  -5.073364329418160e-17,   2.063799111956830e-18,  -7.445006905123635e-20,   7.171301046071401e-05,
  -5.785528702931200e-07,   7.016058270692594e-09,  -9.628075193722434e-11,   1.534798761260509e-12,  -3.460632249111989e-14,   1.213020656447404e-15,  -5.126460069661486e-17,
   2.084434491983806e-18,  -7.511209127161003e-20,   7.171380192211732e-05,  -5.785854650474434e-07,   7.017099981356507e-09,  -9.632007479608994e-11,   1.536871361122861e-12,
  -3.472888729806132e-14,   1.219655461430859e-15,  -5.157173396321953e-17,   2.096366036146150e-18,  -7.549464060928801e-20,   7.171409913401076e-05,  -5.785977058641083e-07,
   7.017491276279521e-09,  -9.633485291798319e-11,   1.537650614181065e-12,  -3.477497440921991e-14,   1.222150144818646e-15,  -5.168719933533691e-17,   2.100850695750027e-18,
  -7.563838295894668e-20,   7.171414840167799e-05,  -5.785997350160203e-07,   7.017556145464413e-09,  -9.633730323649320e-11,   1.537779837792559e-12,  -3.478261732255000e-14,
   1.222563845720262e-15,  -5.170634643268301e-17,   2.101594316283864e-18,  -7.566221512350395e-20,   2.302020177748858e-01,  -1.743813514980370e-03,   1.980926856967358e-05,
  -2.499332846869632e-07,   3.306822262608866e-09,  -4.475454316029288e-11,   6.037337688820655e-13,  -7.650395078039285e-15,   7.431113815207506e-17,   1.307428711045062e-19,
   2.302048424721881e-01,  -1.743920442735367e-03,   1.981209940328244e-05,  -2.499971665694730e-07,   3.308114446925998e-09,  -4.477738987326895e-11,   6.040246729346523e-13,
  -7.649423310136885e-15,   7.406224936587418e-17,   1.419479205578711e-19,   2.302094799624551e-01,  -1.744096001713343e-03,   1.981674747349890e-05,  -2.501020625140636e-07,
   3.310236222713330e-09,  -4.481489415459890e-11,   6.045015130068312e-13,  -7.647786175457555e-15,   7.365205312384331e-17,   1.603864514216043e-19,   2.302144010956414e-01,
  -1.744282310221825e-03,   1.982168052091738e-05,  -2.502133971503343e-07,   3.312488196491510e-09,  -4.485468592611750e-11,   6.050064879212266e-13,  -7.645992122779569e-15,
   7.321462020573754e-17,   1.800104194698708e-19,   2.302182743412265e-01,  -1.744428955450833e-03,   1.982556364134399e-05,  -2.503010412127213e-07,   3.314260949731500e-09,
  -4.488599992531747e-11,   6.054031875819619e-13,  -7.644538908047665e-15,   7.286877636158806e-17,   1.954974659446628e-19,   2.302205097824131e-01,  -1.744513595079179e-03,
   1.982780498125671e-05,  -2.503516315816950e-07,   3.315284215719986e-09,  -4.490407089804220e-11,   6.056318421438292e-13,  -7.643683657077137e-15,   7.266854861557733e-17,
   2.044525230731430e-19,   2.302213492346248e-01,  -1.744545379575515e-03,   1.982864668625911e-05,  -2.503706305197803e-07,   3.315668495412576e-09,  -4.491085654717211e-11,
   6.057176495843445e-13,  -7.643359366761198e-15,   7.259324112859317e-17,   2.078184821654953e-19,   2.302214883869956e-01,  -1.744550648388514e-03,   1.982878621405433e-05,
  -2.503737799581113e-07,   3.315732197019861e-09,  -4.491198135606678e-11,   6.057318705124103e-13,  -7.643305445543897e-15,   7.258075150413261e-17,   2.083766092844545e-19,
   7.235382987268921e-02,  -5.480927675935167e-04,   6.226571576605088e-06,  -7.860720072948445e-08,   1.044276990302465e-09,  -1.443658507795981e-11,   2.125326941834349e-13,
  -3.581366177790320e-15,   7.519857996146166e-17,  -1.921931894760870e-18,   7.235471775791158e-02,  -5.481263996642772e-04,   6.227465819322111e-06,  -7.862783693708000e-08,
   1.044734320138750e-09,  -1.444745045338540e-11,   2.128395386982670e-13,  -3.591505560959637e-15,   7.554462257062320e-17,  -1.932818878281385e-18,   7.235617545764275e-02,
  -5.481816185425914e-04,   6.228934146920848e-06,  -7.866172585667539e-08,   1.045485578380058e-09,  -1.446530981913365e-11,   2.133442780766952e-13,  -3.608191576957965e-15,
   7.611406926696589e-17,  -1.950726570101416e-18,   7.235772231538055e-02,  -5.482402187285065e-04,   6.230492541396019e-06,  -7.869769991533561e-08,   1.046283370991545e-09,
  -1.448429006202839e-11,   2.138812128625144e-13,  -3.625951949140051e-15,   7.672014826764353e-17,  -1.969775487859225e-18,   7.235893979154472e-02,  -5.482863436748890e-04,
   6.231719285214482e-06,  -7.872602277306120e-08,   1.046911708940207e-09,  -1.449924942653393e-11,   2.143047750196867e-13,  -3.639969491732449e-15,   7.719847758160762e-17,
  -1.984801439870391e-18,   7.235964245732632e-02,  -5.483129658061041e-04,   6.232427375011315e-06,  -7.874237289459502e-08,   1.047274524068300e-09,  -1.450789152483445e-11,
   2.145496190888774e-13,  -3.648075356596591e-15,   7.747506904031141e-17,  -1.993486975277288e-18,   7.235990632221022e-02,  -5.483229631579829e-04,   6.232693290936194e-06,
  -7.874851336864104e-08,   1.047410800508296e-09,  -1.451113837525164e-11,   2.146416357768093e-13,  -3.651122228461592e-15,   7.757903365976654e-17,  -1.996751081142878e-18,
   7.235995006195542e-02,  -5.483246203873156e-04,   6.232737371423675e-06,  -7.874953128447441e-08,   1.047433392165560e-09,  -1.451167667461090e-11,   2.146568928342555e-13,
  -3.651627451459895e-15,   7.759627265369508e-17,  -1.997292290606082e-18,   5.946313202725099e-03,  -4.504476368397133e-05,   5.118046090654084e-07,  -6.470704703869934e-09,
   8.682455830332396e-11,  -1.262216645435520e-12,   2.216452726980010e-14,  -5.391002227477984e-16,   1.707036459765891e-17,  -5.753083357181043e-19,   5.946386185918169e-03,
  -4.504753256885070e-05,   5.118790169582102e-07,  -6.472514992889163e-09,   8.687271229389414e-11,  -1.263876800330404e-12,   2.223505092302667e-14,  -5.421574326445215e-16,
   1.719056515599573e-17,  -5.793863743299562e-19,   5.946506007342574e-03,  -4.505207870356979e-05,   5.120011995480827e-07,  -6.475488603566667e-09,   8.695187501505205e-11,
  -1.266608888865349e-12,   2.235117618867648e-14,  -5.471915489847849e-16,   1.738843199370657e-17,  -5.860958164297425e-19,   5.946633157603674e-03,  -4.505690326809213e-05,
   5.121308855189151e-07,  -6.478646187025047e-09,   8.703602278608692e-11,  -1.269516936842066e-12,   2.247486962119052e-14,  -5.525538391768155e-16,   1.759911606327264e-17,
  -5.932350037958442e-19,   5.946733233108709e-03,  -4.506070077928409e-05,   5.122329786296097e-07,  -6.481132928230107e-09,   8.710235636721518e-11,  -1.271812182216273e-12,
   2.257256198634403e-14,  -5.567890032600056e-16,   1.776545607187129e-17,  -5.988680242210736e-19,   5.946790991679060e-03,  -4.506289261922435e-05,   5.122919104232297e-07,
  -6.482568760218836e-09,   8.714068248113673e-11,  -1.273139462047279e-12,   2.262908066846691e-14,  -5.592392251616274e-16,   1.786166697572696e-17,  -6.021247388826723e-19,
   5.946812681171120e-03,  -4.506371571888199e-05,   5.123140421411664e-07,  -6.483108059000947e-09,   8.715508258835666e-11,  -1.273638370041888e-12,   2.265033020141496e-14,
  -5.601604477273446e-16,   1.789783537408130e-17,  -6.033487615945437e-19,   5.946816276545200e-03,  -4.506385216164595e-05,   5.123177109085820e-07,  -6.483197462332954e-09,
   8.715747004877045e-11,  -1.273721097638520e-12,   2.265385399877834e-14,  -5.603132137098387e-16,   1.790383292751799e-17,  -6.035517185888494e-19,   6.949935775554664e-05,
  -5.264856534338373e-07,   5.984091908785444e-09,  -7.591746626977487e-11,   1.042833152600714e-12,  -1.690517576662717e-14,   3.948401546492730e-16,  -1.351854413315702e-17,
   5.283540173087063e-19,  -1.969547043135403e-20,   6.950021113641396e-05,  -5.265181505990860e-07,   5.984987262904647e-09,  -7.594188048366780e-11,   1.043702206911988e-12,
  -1.694726353392998e-14,   3.970366920288382e-16,  -1.362365201877018e-17,   5.327306206568068e-19,  -1.985151718696467e-20,   6.950161219215924e-05,  -5.265715075750368e-07,
   5.986457676394737e-09,  -7.598200436733941e-11,   1.045132338114454e-12,  -1.701658720706939e-14,   4.006553945242845e-16,  -1.379678646115363e-17,   5.399374655666423e-19,
  -2.010835631114455e-20,   6.950309894694172e-05,  -5.266281338143117e-07,   5.988018640376442e-09,  -7.602463884103990e-11,   1.046654501158337e-12,  -1.709045798556240e-14,
   4.045124548479126e-16,  -1.398128896589577e-17,   5.476143441042292e-19,  -2.038178421309589e-20,   6.950426912227764e-05,  -5.266727064720751e-07,   5.989247665125303e-09,
  -7.605823589188374e-11,   1.047855850886346e-12,  -1.714882184734075e-14,   4.075605617043821e-16,  -1.412706897170350e-17,   5.536777362714257e-19,  -2.059762668672547e-20,
   6.950494449003633e-05,  -5.266984332368061e-07,   5.989957175263303e-09,  -7.607764287637779e-11,   1.048550538783961e-12,  -1.718259601510015e-14,   4.093247355441334e-16,
  -1.421143252879512e-17,   5.571857259544566e-19,  -2.072245559368707e-20,   6.950519810428136e-05,  -5.267080944623901e-07,   5.990223644223818e-09,  -7.608493369801884e-11,
   1.048811659423643e-12,  -1.719529581811387e-14,   4.099881562774153e-16,  -1.424315559880102e-17,   5.585046541503276e-19,  -2.076937962453538e-20,   6.950524014483858e-05,
  -5.267096959788742e-07,   5.990267817424034e-09,  -7.608614243056971e-11,   1.048854957548650e-12,  -1.719740190369122e-14,   4.100981782150125e-16,  -1.424841645893262e-17,
   5.587233720913582e-19,  -2.077716056787239e-20,   2.235259032395560e-01,  -1.596499962515531e-03,   1.710034885760124e-05,  -2.034656080411954e-07,   2.540654584432356e-09,
  -3.257013143306483e-11,   4.220510187088225e-13,  -5.388821212378522e-15,   6.330222940848137e-17,  -5.265966261061346e-19,   2.235283411176657e-01,  -1.596586990726119e-03,
   1.710252330332483e-05,  -2.035120940902345e-07,   2.541558487969703e-09,  -3.258627744753515e-11,   4.223027200223665e-13,  -5.391444476694700e-15,   6.327702988319597e-17,
  -5.238383871722214e-19,   2.235323435137371e-01,  -1.596729875999269e-03,   1.710609356679576e-05,  -2.035884250901664e-07,   2.543042780011365e-09,  -3.261278936152392e-11,
   4.227158529406205e-13,  -5.395740638335830e-15,   6.323514564059500e-17,  -5.192920318458562e-19,   2.235365906706148e-01,  -1.596881507865569e-03,   1.710988265202087e-05,
  -2.036694407817413e-07,   2.544618255983565e-09,  -3.264092817460071e-11,   4.231541154361631e-13,  -5.400285092301193e-15,   6.319000185380794e-17,  -5.144431538396432e-19,
   2.235399334264773e-01,  -1.597000857096964e-03,   1.711286523218796e-05,  -2.037332169231998e-07,   2.545858545653521e-09,  -3.266307907810886e-11,   4.234989547703454e-13,
  -5.403851359303773e-15,   6.315396466946302e-17,  -5.106090526595051e-19,   2.235418626848807e-01,  -1.597069741547322e-03,   1.711458675810094e-05,  -2.037700299428673e-07,
   2.546574494103180e-09,  -3.267586500304460e-11,   4.236979377955577e-13,  -5.405905406508626e-15,   6.313296263715002e-17,  -5.083890921349789e-19,   2.235425871573485e-01,
  -1.597095609416159e-03,   1.711523324989526e-05,  -2.037838548380760e-07,   2.546843368787229e-09,  -3.268066666145595e-11,   4.237726521105037e-13,  -5.406675942689394e-15,
   6.312503751800038e-17,  -5.075541083091404e-19,   2.235427072499138e-01,  -1.597099897442280e-03,   1.711534041736363e-05,  -2.037861465777749e-07,   2.546887940140431e-09,
  -3.268146262702806e-11,   4.237850367716000e-13,  -5.406803628968410e-15,   6.312372177631753e-17,  -5.074156256751288e-19,   7.025548395424951e-02,  -5.017895921740102e-04,
   5.374822430066064e-06,  -6.396137937214964e-08,   7.996091584201908e-10,  -1.031916758922371e-11,   1.378602677043799e-13,  -1.971991303569088e-15,   3.265564723088191e-17,
  -6.728856072190983e-19,   7.025625020734376e-02,  -5.018169507648207e-04,   5.375506848660686e-06,  -6.397611459390364e-08,   7.999050124891165e-10,  -1.032511757588472e-11,
   1.379926735756030e-13,  -1.975532506970629e-15,   3.276534980824487e-17,  -6.763709935133383e-19,   7.025750820651552e-02,  -5.018618688794758e-04,   5.376630615673943e-06,
  -6.400031098971589e-08,   8.003909103480030e-10,  -1.033489315283317e-11,   1.382103579543135e-13,  -1.981358985781413e-15,   3.294592464297457e-17,  -6.821079277652852e-19,
   7.025884313697739e-02,  -5.019095366695866e-04,   5.377823268284704e-06,  -6.402599359124219e-08,   8.009067651293616e-10,  -1.034527629089061e-11,   1.384417718274812e-13,
  -1.987559056746018e-15,   3.313818224158993e-17,  -6.882158129107373e-19,   7.025989380386341e-02,  -5.019470559598964e-04,   5.378762072464384e-06,  -6.404621198669275e-08,
   8.013129482054888e-10,  -1.035345548630348e-11,   1.386242105351791e-13,  -1.992451404018463e-15,   3.328996407456473e-17,  -6.930376488367166e-19,   7.026050019216969e-02,
  -5.019687108757002e-04,   5.379303947009053e-06,  -6.405788284559185e-08,   8.015474457053174e-10,  -1.035817891489786e-11,   1.387296258557222e-13,  -1.995280035750902e-15,
   3.337775062986482e-17,  -6.958264019011441e-19,   7.026072790228251e-02,  -5.019768428521141e-04,   5.379507439955597e-06,  -6.406226582812659e-08,   8.016355172240467e-10,
  -1.035995318720889e-11,   1.387692342665900e-13,  -1.996343191804094e-15,   3.341075135136838e-17,  -6.968747368056513e-19,   7.026076564877133e-02,  -5.019781908615516e-04,
   5.379541172545270e-06,  -6.406299239443452e-08,   8.016501171502561e-10,  -1.036024732873977e-11,   1.387758011895603e-13,  -1.996519476686750e-15,   3.341622359305899e-17,
  -6.970485729706602e-19,   5.773862269318832e-03,  -4.123905684068108e-05,   4.417400703581937e-07,  -5.258789078394223e-09,   6.593004146100693e-11,  -8.647313881271987e-13,
   1.239194932961661e-14,  -2.192058197175491e-16,   5.324533632793281e-18,  -1.612770569615676e-19,   5.773925245689050e-03,  -4.124130630229090e-05,   4.417965158194006e-07,
  -5.260025314817702e-09,   6.595675488681242e-11,  -8.654002710473676e-13,   1.241387236145848e-14,  -2.200649602225975e-16,   5.358425469066202e-18,  -1.624970508147248e-19,
   5.774028637426379e-03,  -4.124499954049622e-05,   4.418891967518751e-07,  -5.262055490829745e-09,   6.600064350312092e-11,  -8.665002279700196e-13,   1.244996121054679e-14,
  -2.214799407323454e-16,   5.414244317270447e-18,  -1.645057951960213e-19,   5.774138351980233e-03,  -4.124891887223037e-05,   4.419875609203284e-07,  -5.264210608572120e-09,
   6.604725928865647e-11,  -8.676699242297795e-13,   1.248838862129521e-14,  -2.229875571313912e-16,   5.473717349510731e-18,  -1.666452929629112e-19,   5.774224703652773e-03,
  -4.125200378389561e-05,   4.420649903638444e-07,  -5.265907381952202e-09,   6.608397994243512e-11,  -8.685923369295344e-13,   1.251872869575083e-14,  -2.241785668645278e-16,
   5.520700582856848e-18,  -1.683349353944496e-19,   5.774274541193549e-03,  -4.125378429789138e-05,   4.421096829571535e-07,  -5.266886897666676e-09,   6.610518571463629e-11,
  -8.691254245656259e-13,   1.253627770314993e-14,  -2.248677319198218e-16,   5.547886838092802e-18,  -1.693124070468175e-19,   5.774293256120821e-03,  -4.125445292717477e-05,
   4.421264667082473e-07,  -5.267254767496500e-09,   6.611315125947668e-11,  -8.693257452987777e-13,   1.254287493988724e-14,  -2.251268627429799e-16,   5.558109038453297e-18,
  -1.696799010719825e-19,   5.774296358410855e-03,  -4.125456376355653e-05,   4.421292489205429e-07,  -5.267315749927217e-09,   6.611447179800967e-11,  -8.693589587714505e-13,
   1.254396891743187e-14,  -2.251698354631616e-16,   5.559804226503277e-18,  -1.697408418810511e-19,   6.748376102699209e-05,  -4.819961805408429e-07,   5.163420525326717e-09,
  -6.152330959861336e-11,   7.764718417977706e-13,  -1.056909051008391e-14,   1.747158793718085e-16,  -4.195620222980546e-18,   1.391418523498681e-19,  -5.039389245817689e-21,
   6.748449715728677e-05,  -4.820224997453316e-07,   5.164085666925664e-09,  -6.153846011740848e-11,   7.768517003616012e-13,  -1.058206282124304e-14,   1.752944879530454e-16,
  -4.222620949337883e-18,   1.403007757889142e-19,  -5.083248859603325e-21,   6.748570570310237e-05,  -4.820657116814110e-07,   5.165177841187496e-09,  -6.156334567201840e-11,
   7.774762053751957e-13,  -1.060341806826104e-14,   1.762477442044296e-16,  -4.267111193775739e-18,   1.422100987213294e-19,  -5.155486216214750e-21,   6.748698815714458e-05,
  -4.821115692788600e-07,   5.166337044478151e-09,  -6.158976958585830e-11,   7.781400872880889e-13,  -1.062615815280346e-14,   1.772638226597231e-16,  -4.314542399997254e-18,
   1.442452460568792e-19,  -5.232455091168885e-21,   6.748799752294237e-05,  -4.821476640800047e-07,   5.167249576934517e-09,  -6.161057870604172e-11,   7.786634614439135e-13,
  -1.064411316992171e-14,   1.780668206688585e-16,  -4.352033292004185e-18,   1.458535982059144e-19,  -5.293261669127032e-21,   6.748858007483418e-05,  -4.821684969525031e-07,
   5.167776310888953e-09,  -6.162259342081000e-11,   7.789658706556282e-13,  -1.065449884244225e-14,   1.785315877208101e-16,  -4.373735194552285e-18,   1.467844920215520e-19,
  -5.328447321599559e-21,   6.748879883399494e-05,  -4.821763202543421e-07,   5.167974122433359e-09,  -6.162710608069239e-11,   7.790794964081305e-13,  -1.065840320998295e-14,
   1.787063662037266e-16,  -4.381896808464426e-18,   1.471345594280834e-19,  -5.341677474189983e-21,   6.748883509672787e-05,  -4.821776170971244e-07,   5.168006913462621e-09,
  -6.162785417223322e-11,   7.790983350970668e-13,  -1.065905064939061e-14,   1.787353516379759e-16,  -4.383250363813758e-18,   1.471926148985378e-19,  -5.343871489674257e-21,
   2.173989601383762e-01,  -1.468818632542684e-03,   1.488282009878074e-05,  -1.675234132498728e-07,   1.979429535216602e-09,  -2.404052025477105e-11,   2.966180145041618e-13,
  -3.671156674297855e-15,   4.435390333543443e-17,  -4.835413835920432e-19,   2.174010814791087e-01,  -1.468890273192944e-03,   1.488451382334337e-05,  -1.675577176743458e-07,
   1.980064804188663e-09,  -2.405153075500994e-11,   2.967951797933917e-13,  -3.673624445809586e-15,   4.437486214359451e-17,  -4.831949437243667e-19,   2.174045641781398e-01,
  -1.469007893525610e-03,   1.488729473913661e-05,  -1.676140452822763e-07,   1.981107974622052e-09,  -2.406961159780432e-11,   2.970860849448537e-13,  -3.677674367932551e-15,
   4.440914525692489e-17,  -4.826207179641188e-19,   2.174082598287239e-01,  -1.469132712212782e-03,   1.489024603969321e-05,  -1.676738286475449e-07,   1.982215230982213e-09,
  -2.408880400465934e-11,   2.973948386758073e-13,  -3.681969837390914e-15,   4.444535307912930e-17,  -4.820039457756960e-19,   2.174111684973062e-01,  -1.469230955620216e-03,
   1.489256911542462e-05,  -1.677208896369750e-07,   1.983086916867161e-09,  -2.410391376697004e-11,   2.976378878897144e-13,  -3.685349074431340e-15,   4.447372594775462e-17,
  -4.815131196676905e-19,   2.174128472158362e-01,  -1.469287657999029e-03,   1.489390996288278e-05,  -1.677480539312313e-07,   1.983590091803156e-09,  -2.411263600520489e-11,
   2.977781797041290e-13,  -3.687298766174037e-15,   4.449005110949701e-17,  -4.812276766437651e-19,   2.174134776043823e-01,  -1.469308951097619e-03,   1.489441349374127e-05,
  -1.677582552401390e-07,   1.983779059403513e-09,  -2.411591168906805e-11,   2.978308650847273e-13,  -3.688030793904118e-15,   4.449617202326366e-17,  -4.811200778919613e-19,
   2.174135821009953e-01,  -1.469312480775252e-03,   1.489449696273452e-05,  -1.677599462977578e-07,   1.983810384564783e-09,  -2.411645470148084e-11,   2.978395986731458e-13,
  -3.688152132646696e-15,   4.449718615889894e-17,  -4.811022201097342e-19,   6.832974941675092e-02,  -4.616582678871205e-04,   4.677773299455593e-06,  -5.265582692528944e-08,
   6.223691722362393e-10,  -7.573617698707687e-12,   9.436662942630074e-14,  -1.216322872726403e-15,   1.689524595659294e-17,  -2.738582755422544e-19,   6.833041616922506e-02,
  -4.616807860125519e-04,   4.678305851982988e-06,  -5.266663564415370e-08,   6.225714179761081e-10,  -7.577275556921790e-12,   9.443470652666449e-14,  -1.217754318776883e-15,
   1.693154727717328e-17,  -2.749132328469232e-19,   6.833151080631447e-02,  -4.617177565034802e-04,   4.679180248245922e-06,  -5.268438367798964e-08,   6.229035425385438e-10,
  -7.583283633943022e-12,   9.454657149895306e-14,  -1.220108213238493e-15,   1.699128833362142e-17,  -2.766500965743776e-19,   6.833267237562411e-02,  -4.617569895968933e-04,
   4.680108220323645e-06,  -5.270322084264705e-08,   6.232560957742676e-10,  -7.589662900568915e-12,   9.466541235446612e-14,  -1.222611247774487e-15,   1.705487778203347e-17,
  -2.784998236337196e-19,   6.833358659090652e-02,  -4.617878695389475e-04,   4.680838662384483e-06,  -5.271804950520862e-08,   6.235336609244473e-10,  -7.594686485131282e-12,
   9.475904479526811e-14,  -1.224585045580895e-15,   1.710506780316771e-17,  -2.799604866833161e-19,   6.833411422412375e-02,  -4.618056922768668e-04,   4.681260264159054e-06,
  -5.272660890595450e-08,   6.236938908723747e-10,  -7.597586925129044e-12,   9.481312368195257e-14,  -1.225725727433868e-15,   1.713409158296433e-17,  -2.808054382640839e-19,
   6.833431235974546e-02,  -4.618123851416070e-04,   4.681418589151842e-06,  -5.272982332765655e-08,   6.237540666903934e-10,  -7.598676302029156e-12,   9.483343874462880e-14,
  -1.226154360842280e-15,   1.714500130106184e-17,  -2.811230995120282e-19,   6.833434520377724e-02,  -4.618134945928965e-04,   4.681444834278067e-06,  -5.273035617892161e-08,
   6.237640421093076e-10,  -7.598856894130322e-12,   9.483680667414590e-14,  -1.226225428589671e-15,   1.714681032358834e-17,  -2.811757761245866e-19,   5.615597920377221e-03,
  -3.794084374584119e-05,   3.844405117870102e-07,  -4.327903922029552e-09,   5.119328700912574e-11,  -6.259550474247787e-13,   7.985294369527120e-15,  -1.126519376962115e-16,
   1.992666651930455e-18,  -4.761120718138680e-20,   5.615652717185241e-03,  -3.794269458120955e-05,   3.844843200463651e-07,  -4.328797582450999e-09,   5.121042936575339e-11,
  -6.262957615572222e-13,   7.993425528589617e-15,  -1.129047948683225e-16,   2.001829750720879e-18,  -4.794247160135798e-20,   5.615742679538402e-03,  -3.794573330353844e-05,
   3.845562490066017e-07,  -4.330265022861898e-09,   5.123858396714968e-11,  -6.268556510052126e-13,   8.006800828874651e-15,  -1.133211415544914e-16,   2.016924022762742e-18,
  -4.848815687988592e-20,   5.615838142698230e-03,  -3.794895799868990e-05,   3.846325856206926e-07,  -4.331822569544065e-09,   5.126847538886013e-11,  -6.274504887650207e-13,
   8.021029408040800e-15,  -1.137646076200693e-16,   2.033010436802226e-18,  -4.906970517455901e-20,   5.615913277160088e-03,  -3.795149612293517e-05,   3.846926733869212e-07,
  -4.333048714020493e-09,   5.129201257598201e-11,  -6.279191746886785e-13,   8.032253758994518e-15,  -1.141148443872871e-16,   2.045721489443299e-18,  -4.952922507876702e-20,
   5.615956640512567e-03,  -3.795296103320253e-05,   3.847273554017337e-07,  -4.333756485172642e-09,   5.130560135593093e-11,  -6.281898815412495e-13,   8.038742148892880e-15,
  -1.143174655616517e-16,   2.053077751946329e-18,  -4.979516109290895e-20,   5.615972924220091e-03,  -3.795351114220423e-05,   3.847403796352487e-07,  -4.334022286598005e-09,
   5.131070502538913e-11,  -6.282915761032731e-13,   8.041180609393533e-15,  -1.143936450682595e-16,   2.055843974389160e-18,  -4.989516235992350e-20,   5.615975623495497e-03,
  -3.795360233173373e-05,   3.847425386301688e-07,  -4.334066348377604e-09,   5.131155108165474e-11,  -6.283084356201980e-13,   8.041584924990100e-15,  -1.144062778336391e-16,
   2.056302719768329e-18,  -4.991174637192054e-20,   6.563399390565164e-05,  -4.434454874634831e-07,   4.493353272367718e-09,  -5.059563173312374e-11,   5.995376554556541e-13,
  -7.411915204951206e-15,   9.965439389199605e-17,  -1.670362297553208e-18,   4.038324320983645e-20,  -1.279040246259011e-21,   6.563463437474296e-05,  -4.434671252790857e-07,
   4.493866401591000e-09,  -5.060622261105778e-11,   5.997523706245940e-13,  -7.417017194345483e-15,   9.982134004054349e-17,  -1.677218748002858e-18,   4.067231081327782e-20,
  -1.290291347063980e-21,   6.563568586141849e-05,  -4.435026505346210e-07,   4.494708919431722e-09,  -5.062361454583537e-11,   6.001051211489206e-13,  -7.425407945377268e-15,
   1.000962522278521e-16,  -1.688516902582454e-18,   4.114869481717094e-20,  -1.308830582353771e-21,   6.563680164210339e-05,  -4.435403500344038e-07,   4.495603077068065e-09,
  -5.064207593734581e-11,   6.004797719267533e-13,  -7.434331630817212e-15,   1.003891040288957e-16,  -1.700562587018945e-18,   4.165667160976285e-20,  -1.328595747263853e-21,
   6.563767981954260e-05,  -4.435700229673027e-07,   4.496306915013152e-09,  -5.065661037254599e-11,   6.007748818075503e-13,  -7.441369464351895e-15,   1.006204139418320e-16,
  -1.710084324071209e-18,   4.205826404894334e-20,  -1.344218956771112e-21,   6.563818665383231e-05,  -4.435871490914887e-07,   4.496713166264038e-09,  -5.066500057521477e-11,
   6.009452989970603e-13,  -7.445437099908010e-15,   1.007542424848419e-16,  -1.715596264716329e-18,   4.229075872300838e-20,  -1.353262691736313e-21,   6.563837697910185e-05,
  -4.435935803661001e-07,   4.496865727595040e-09,  -5.066815157616233e-11,   6.010093119325341e-13,  -7.446965666366910e-15,   1.008045598554340e-16,  -1.717669225406178e-18,
   4.237820052681163e-20,  -1.356663865316822e-21,   6.563840852844814e-05,  -4.435946464548313e-07,   4.496891017344178e-09,  -5.066867392059124e-11,   6.010199240266617e-13,
  -7.447219107727575e-15,   1.008129040278369e-16,  -1.718013015764694e-18,   4.239270252819047e-20,  -1.357227930939385e-21,   2.117497938412057e-01,  -1.357292981878294e-03,
   1.304786156830288e-05,  -1.393444942635698e-07,   1.562245502549137e-09,  -1.800990537249971e-11,   2.112778537684840e-13,  -2.502367555401083e-15,   2.956674166996371e-17,
  -3.383329963661091e-19,   2.117516533354277e-01,  -1.357352561897049e-03,   1.304919804630427e-05,  -1.393701870806671e-07,   1.562697903912073e-09,  -1.801741135458122e-11,
   2.113961188090566e-13,  -2.504104877141191e-15,   2.958859916049498e-17,  -3.384839443685803e-19,   2.117547061341087e-01,  -1.357450380086328e-03,   1.305139237095338e-05,
  -1.394123737314404e-07,   1.563440776697602e-09,  -1.802973739455021e-11,   2.115903328690428e-13,  -2.506957521262096e-15,   2.962446438015634e-17,  -3.387304656856385e-19,
   2.117579455770015e-01,  -1.357554183546405e-03,   1.305372109922769e-05,  -1.394571475410659e-07,   1.564229270542670e-09,  -1.804282138051455e-11,   2.117964943965468e-13,
  -2.509985141093169e-15,   2.966249638599580e-17,  -3.389902934522094e-19,   2.117604951713866e-01,  -1.357635885236389e-03,   1.305555409596294e-05,  -1.394923923776879e-07,
   1.564849999236841e-09,  -1.805312224283940e-11,   2.119588064118891e-13,  -2.512368430375273e-15,   2.969241046482835e-17,  -3.391935080078950e-19,   2.117619666466045e-01,
  -1.357683040014887e-03,   1.305661206461108e-05,  -1.395127359143914e-07,   1.565208306028951e-09,  -1.805906855387204e-11,   2.120525046191022e-13,  -2.513744087622511e-15,
   2.970966749193694e-17,  -3.393102762249257e-19,   2.117625192104717e-01,  -1.357700747695816e-03,   1.305700936322545e-05,  -1.395203756917004e-07,   1.565342867426345e-09,
  -1.806130173292003e-11,   2.120876939084208e-13,  -2.514260701040363e-15,   2.971614635522308e-17,  -3.393540271365373e-19,   2.117626108063848e-01,  -1.357703683028662e-03,
   1.305707522225848e-05,  -1.395216421245835e-07,   1.565365173623340e-09,  -1.806167192909083e-11,   2.120935272837282e-13,  -2.514346339240573e-15,   2.971722024970909e-17,
  -3.393612743704695e-19,   6.655418362925046e-02,  -4.266050425832215e-04,   4.101021612548184e-06,  -4.379722887358387e-08,   4.910680218084754e-10,  -5.664238077225190e-12,
   6.664532473159293e-14,  -7.999452338813143e-16,   9.944718524014065e-18,  -1.340081714376855e-19,   6.655476807958657e-02,  -4.266237691386955e-04,   4.101441717027533e-06,
  -4.380530978860920e-08,   4.912107581548804e-10,  -5.666639810005529e-12,   6.668523937180124e-14,  -8.006407585488439e-16,   9.958597721115096e-18,  -1.343416971790716e-19,
   6.655572759277192e-02,  -4.266545143094927e-04,   4.102131474782169e-06,  -4.381857839387249e-08,   4.914451447126752e-10,  -5.670584151416581e-12,   6.675080593292964e-14,
  -8.017838208814936e-16,   9.981425297648877e-18,  -1.348906866013601e-19,   6.655674576937430e-02,  -4.266871407092205e-04,   4.102863481049380e-06,  -4.383266077480013e-08,
   4.916939309174633e-10,  -5.674771453995851e-12,   6.682043185170411e-14,  -8.029983948024318e-16,   1.000570517369673e-17,  -1.354751854956600e-19,   6.655754712239999e-02,
  -4.267128203173452e-04,   4.103439660714182e-06,  -4.384374611980934e-08,   4.918897877786490e-10,  -5.678068369643962e-12,   6.687526749516563e-14,  -8.039555014748170e-16,
   1.002485568814268e-17,  -1.359366249779237e-19,   6.655800961601455e-02,  -4.267276415075865e-04,   4.103772220099395e-06,  -4.385014466636505e-08,   4.920028449880027e-10,
  -5.679971680389829e-12,   6.690693014043635e-14,  -8.045083605145951e-16,   1.003592474050142e-17,  -1.362035072984689e-19,   6.655818329020061e-02,  -4.267332071983264e-04,
   4.103897106040098e-06,  -4.385254756894794e-08,   4.920453037044120e-10,  -5.680686505246016e-12,   6.691882279032919e-14,  -8.047160580568177e-16,   1.004008448065969e-17,
  -1.363038333657661e-19,   6.655821207935353e-02,  -4.267341298010676e-04,   4.103917808019744e-06,  -4.385294589419137e-08,   4.920523420876290e-10,  -5.680805003646690e-12,
   6.692079432621190e-14,  -8.047504918308599e-16,   1.004077418608436e-17,  -1.363204696061132e-19,   5.469675155975175e-03,  -3.506002312462965e-05,   3.370381636918222e-07,
  -3.599511285137413e-09,   4.036682138017170e-11,  -4.662309663622419e-13,   5.525152607349977e-15,  -6.844798458552072e-17,   9.492209930979848e-19,  -1.664777768003568e-20,
   5.469723188430154e-03,  -3.506156218584311e-05,   3.370726977677659e-07,  -3.600176506263333e-09,   4.037866107314495e-11,  -4.664369250925336e-13,   5.528988668661371e-15,
  -6.853561039681685e-17,   9.518001679853679e-19,  -1.673437432259002e-20,   5.469802045043939e-03,  -3.506408900966410e-05,   3.371293983655916e-07,  -3.601268786867973e-09,
   4.039810379326375e-11,  -4.667752304986028e-13,   5.535293690318206e-15,  -6.867978687943559e-17,   9.560478526264180e-19,  -1.687704857399642e-20,   5.469885722852191e-03,
  -3.506677044471949e-05,   3.371895720372364e-07,  -3.602428069884044e-09,   4.041874211230712e-11,  -4.671344584095576e-13,   5.541994028795712e-15,  -6.883321138772755e-17,
   9.605734359535107e-19,  -1.702913417954028e-20,   5.469951581236310e-03,  -3.506888095073208e-05,   3.372369362424448e-07,  -3.603340640949688e-09,   4.043499044053678e-11,
  -4.674173610198823e-13,   5.547274649280402e-15,  -6.895427821283530e-17,   9.641484949591352e-19,  -1.714933236126948e-20,   5.469989590804436e-03,  -3.507009904621705e-05,
   3.372642739418831e-07,  -3.603867387458791e-09,   4.044437002021420e-11,  -4.675807052519276e-13,   5.550325178090145e-15,  -6.902427716217790e-17,   9.662171146048282e-19,
  -1.721890431874260e-20,   5.470003864041150e-03,  -3.507055646853222e-05,   3.372745400662518e-07,  -3.604065201872683e-09,   4.044789259035340e-11,  -4.676420569372461e-13,
   5.551471245811606e-15,  -6.905058686285793e-17,   9.669949206820122e-19,  -1.724506774231009e-20,   5.470006230048468e-03,  -3.507063229363810e-05,   3.372762418521388e-07,
  -3.604097993280121e-09,   4.044847653024006e-11,  -4.676522276120452e-13,   5.551661252701306e-15,  -6.905494936029272e-17,   9.671239069534942e-19,  -1.724940673446128e-20,
   6.392847668720944e-05,  -4.097746690745706e-07,   3.939252265475326e-09,  -4.207270924884026e-11,   4.720374355717993e-13,  -5.468517864869277e-15,   6.587193986496776e-17,
  -8.738308158514690e-19,   1.473898466695838e-20,  -3.524196781397297e-22,   6.392903808388658e-05,  -4.097926584182475e-07,   3.939656112947748e-09,  -4.208051368235869e-11,
   4.721787639303641e-13,  -5.471159450780652e-15,   6.593215511482939e-17,  -8.757101130741820e-19,   1.481016785261624e-20,  -3.551522583937257e-22,   6.392995974908522e-05,
  -4.098221932517060e-07,   3.940319181402979e-09,  -4.209332865319285e-11,   4.724108710124734e-13,  -5.475500149501407e-15,   6.603121583430573e-17,  -8.788055380881981e-19,
   1.492748387362024e-20,  -3.596562095536873e-22,   6.393093776377250e-05,  -4.098535352746774e-07,   3.941022867196069e-09,  -4.210693004059680e-11,   4.726572821032855e-13,
  -5.480111561673819e-15,   6.613660984691842e-17,  -8.821039968809575e-19,   1.505258834246747e-20,  -3.644597427258360e-22,   6.393170750751200e-05,  -4.098782039881029e-07,
   3.941576757736780e-09,  -4.211763709407111e-11,   4.728513014078403e-13,  -5.483744828150060e-15,   6.621976091439907e-17,  -8.847100475875187e-19,   1.515149861254936e-20,
  -3.682579282229294e-22,   6.393215175812882e-05,  -4.098924417378095e-07,   3.941896453330008e-09,  -4.212381742294585e-11,   4.729633108597702e-13,  -5.485843288266175e-15,
   6.626783155557671e-17,  -8.862181271180104e-19,   1.520876341867168e-20,  -3.704570775064493e-22,   6.393231858176295e-05,  -4.098977883345086e-07,   3.942016508732050e-09,
  -4.212613840189976e-11,   4.730053785438617e-13,  -5.486631589560495e-15,   6.628589818174254e-17,  -8.867851976587335e-19,   1.523030132559431e-20,  -3.712842316849858e-22,
   6.393234623533226e-05,  -4.098986746189431e-07,   3.942036409977778e-09,  -4.212652314814730e-11,   4.730123522351755e-13,  -5.486762278075756e-15,   6.628889380833357e-17,
  -8.868792384552412e-19,   1.523387335805700e-20,  -3.714214156850900e-22,   2.065193634469365e-01,  -1.259199390323126e-03,   1.151464834779831e-05,  -1.169766790155378e-07,
   1.247586791571427e-09,  -1.368347398688904e-11,   1.528040700209609e-13,  -1.726565630155997e-15,   1.961566146878883e-17,  -2.213567010409412e-19,   2.065210042119261e-01,
  -1.259249399203654e-03,   1.151571544620637e-05,  -1.169961953387103e-07,   1.247913901419676e-09,  -1.368865195693330e-11,   1.528825509137087e-13,  -1.727704403882650e-15,
   1.963108812705305e-17,  -2.215337575783062e-19,   2.065236979033397e-01,  -1.259331502909530e-03,   1.151746746316903e-05,  -1.170282398762597e-07,   1.248451026448026e-09,
  -1.369715489588557e-11,   1.530114344593451e-13,  -1.729574539515410e-15,   1.965641798236133e-17,  -2.218242375967163e-19,   2.065265562678336e-01,  -1.259418629490479e-03,
   1.151932676346788e-05,  -1.170622488588835e-07,   1.249021122476876e-09,  -1.370618051969719e-11,   1.531482502934207e-13,  -1.731559786780195e-15,   1.968330100132523e-17,
  -2.221322039290423e-19,   2.065288059241197e-01,  -1.259487204507808e-03,   1.152079024163716e-05,  -1.170890193584383e-07,   1.249469910441334e-09,  -1.371328615802869e-11,
   1.532559688332318e-13,  -1.733122830038268e-15,   1.970446246049561e-17,  -2.223743890612990e-19,   2.065301042882124e-01,  -1.259526782872667e-03,   1.152163492331182e-05,
  -1.171044712426512e-07,   1.249728962620366e-09,  -1.371738793310553e-11,   1.533181528517407e-13,  -1.734025150604890e-15,   1.971667690111770e-17,  -2.225140839335745e-19,
   2.065305918450547e-01,  -1.259541645392376e-03,   1.152195212476551e-05,  -1.171102739768189e-07,   1.249826248338496e-09,  -1.371892837422397e-11,   1.533415068850370e-13,
  -1.734364029653487e-15,   1.972126387463189e-17,  -2.225665265480504e-19,   2.065306726650134e-01,  -1.259544109091505e-03,   1.152200470624267e-05,  -1.171112358840633e-07,
   1.249842375316201e-09,  -1.371918373408519e-11,   1.533453783252792e-13,  -1.734420206275454e-15,   1.972202424851408e-17,  -2.225752189119643e-19,   6.491022910236383e-02,
  -3.957736465530541e-04,   3.619121143931384e-06,  -3.676653359953399e-08,   3.921326724883144e-10,  -4.301520982295311e-12,   4.807602274481653e-14,  -5.454596320149312e-16,
   6.303459910047641e-18,  -7.557638653645753e-20,   6.491074480438760e-02,  -3.957893646744401e-04,   3.619456547389648e-06,  -3.677266880119193e-08,   3.922355961921515e-10,
  -4.303157309818522e-12,   4.810127295292621e-14,  -5.458500922651164e-16,   6.309876273005536e-18,  -7.569806923430388e-20,   6.491159144734003e-02,  -3.958151704117277e-04,
   3.620007230079945e-06,  -3.678274241364649e-08,   3.924046011433947e-10,  -4.305844451898585e-12,   4.814274381103643e-14,  -5.464915496375139e-16,   6.320422726462763e-18,
  -7.589823882515232e-20,   6.491248984800518e-02,  -3.958425548723253e-04,   3.620591633472161e-06,  -3.679343358698651e-08,   3.925839815261008e-10,  -4.308696867163116e-12,
   4.818677283536094e-14,  -5.471728029150803e-16,   6.331630968971523e-18,  -7.611118958481667e-20,   6.491319692812417e-02,  -3.958641084541396e-04,   3.621051624649886e-06,
  -3.680184925641616e-08,   3.927251932648305e-10,  -4.310942565906836e-12,   4.822144219866612e-14,  -5.477094005183810e-16,   6.340464712704931e-18,  -7.627918597574620e-20,
   6.491360501154725e-02,  -3.958765481963078e-04,   3.621317119665035e-06,  -3.680670676927676e-08,   3.928067047313291e-10,  -4.312238936590604e-12,   4.824145790298957e-14,
  -5.480192611630096e-16,   6.345567977563262e-18,  -7.637630183751270e-20,   6.491375825351255e-02,  -3.958812195847008e-04,   3.621416820430061e-06,  -3.680853093945425e-08,
   3.928373160108296e-10,  -4.312725799824454e-12,   4.824897538637220e-14,  -5.481356509025881e-16,   6.347485276533732e-18,  -7.641280043909851e-20,   6.491378365569798e-02,
  -3.958819939416576e-04,   3.621433347509383e-06,  -3.680883332840859e-08,   3.928423904222709e-10,  -4.312806507706230e-12,   4.825022159005229e-14,  -5.481549459614605e-16,
   6.347803147598327e-18,  -7.641885222149687e-20,   5.334568733063353e-03,  -3.252617944952760e-05,   2.974332234590562e-07,  -3.021630368885163e-09,   3.222871486890992e-11,
  -3.536592149112270e-13,   3.960783198904891e-15,  -4.538535212510902e-17,   5.457669862840575e-19,  -7.421939958151459e-21,   5.334611115432162e-03,  -3.252747123247716e-05,
   2.974607898201636e-07,  -3.022134802870218e-09,   3.223719566434208e-11,  -3.537954660085016e-13,   3.962975480216717e-15,  -4.542400930665768e-17,   5.466125609405893e-19,
  -7.445432654348558e-21,   5.334680695795049e-03,  -3.252959205924252e-05,   2.975060497068808e-07,  -3.022963053323767e-09,   3.225112165483701e-11,  -3.540192281585289e-13,
   3.966576919958701e-15,  -4.548755930540847e-17,   5.480041497775723e-19,  -7.484130134553931e-21,   5.334754529805402e-03,  -3.253184263239304e-05,   2.975540810725999e-07,
  -3.023842081975667e-09,   3.226590281959552e-11,  -3.542567712586768e-13,   3.970401668166875e-15,  -4.555511060462057e-17,   5.494854215736937e-19,  -7.525368840430962e-21,
   5.334812640360101e-03,  -3.253361399883160e-05,   2.975918871715560e-07,  -3.024534020404370e-09,   3.227753901520395e-11,  -3.544438016684586e-13,   3.973414189344396e-15,
  -4.560836080940225e-17,   5.506545939885582e-19,  -7.557952916199681e-21,   5.334846178220231e-03,  -3.253463635059550e-05,   2.976137078799301e-07,  -3.024933407036268e-09,
   3.228425583112336e-11,  -3.545517737695811e-13,   3.975153747404804e-15,  -4.563912747812242e-17,   5.513307136448368e-19,  -7.576809646174647e-21,   5.334858772232418e-03,
  -3.253502026548417e-05,   2.976219021640807e-07,  -3.025083391167154e-09,   3.228677831561181e-11,  -3.545923246445626e-13,   3.975807152865752e-15,  -4.565068727938664e-17,
   5.515848621095118e-19,  -7.583900344416576e-21,   5.334860859881402e-03,  -3.253508390548606e-05,   2.976232605046069e-07,  -3.025108253736545e-09,   3.228719646688737e-11,
  -3.545990468637648e-13,   3.975915473890446e-15,  -4.565260383088411e-17,   5.516270045175288e-19,  -7.585076246925777e-21,   6.234937948145969e-05,  -3.801595387459845e-07,
   3.476343668792895e-09,  -3.531666238608229e-11,   3.767289119242826e-13,  -4.137286441220637e-15,   4.655070422729644e-17,  -5.453922928626255e-19,   7.129549934849026e-21,
  -1.199133626891826e-22,   6.234987483871384e-05,  -3.801746370598237e-07,   3.476665901656488e-09,  -3.532256390467372e-11,   3.768286222011834e-13,  -4.138926457396618e-15,
   4.657950353431298e-17,  -5.460243256106909e-19,   7.148281777302443e-21,  -1.205687601701759e-22,   6.235068808107568e-05,  -3.801994252105839e-07,   3.477194960714018e-09,
  -3.533225389397592e-11,   3.769923574060467e-13,  -4.141620186285381e-15,   4.662683683122689e-17,  -5.470643695731865e-19,   7.179141641450812e-21,  -1.216490677970927e-22,
   6.235155103928599e-05,  -3.802257298351952e-07,   3.477756417084983e-09,  -3.534253802117320e-11,   3.771661538413974e-13,  -4.144480315137015e-15,   4.667713546119611e-17,
  -5.481712888105678e-19,   7.212034224636241e-21,  -1.228013080271061e-22,   6.235223022466956e-05,  -3.802464335094351e-07,   3.478198346900687e-09,  -3.535063334894419e-11,
   3.773029765552366e-13,  -4.146732610948328e-15,   4.671677471057006e-17,  -5.490448742157345e-19,   7.238028248635722e-21,  -1.237124477582358e-22,   6.235262220895930e-05,
  -3.802583827248709e-07,   3.478453417575208e-09,  -3.535530598877159e-11,   3.773819572708227e-13,  -4.148033000574539e-15,   4.673967297263570e-17,  -5.495500154891441e-19,
   7.253073059316676e-21,  -1.242400203187411e-22,   6.235276940543861e-05,  -3.802628699102206e-07,   3.478549203750168e-09,  -3.535706073775026e-11,   3.774116186527542e-13,
  -4.148521413039012e-15,   4.674827560011655e-17,  -5.497398862000859e-19,   7.258730703819645e-21,  -1.244384576717285e-22,   6.235279380549286e-05,  -3.802636137326026e-07,
   3.478565081922427e-09,  -3.535735161917189e-11,   3.774165356274977e-13,  -4.148602379844041e-15,   4.674970182530728e-17,  -5.497713697619113e-19,   7.259668970607131e-21,
  -1.244713688509409e-22,   2.016583632202820e-01,  -1.172377321580844e-03,   1.022226885033320e-05,  -9.902063863415569e-08,   1.007012032126032e-09,  -1.053211911493851e-11,
   1.121714402651541e-13,  -1.209670413173645e-15,   1.315233074838990e-17,  -1.433478426841226e-19,   2.016598196560934e-01,  -1.172419648739364e-03,   1.022313004208746e-05,
  -9.903565724573167e-08,   1.007252099710292e-09,  -1.053574595590762e-11,   1.122240537307777e-13,  -1.210408158858088e-15,   1.316228144840888e-17,  -1.434731557053157e-19,
   2.016622107200613e-01,  -1.172489140264012e-03,   1.022454397612764e-05,  -9.906031646342469e-08,   1.007646290800428e-09,  -1.054170159824625e-11,   1.123104559455602e-13,
  -1.211619752106660e-15,   1.317862324806630e-17,  -1.436789110564290e-19,   2.016647479445367e-01,  -1.172562882454627e-03,   1.022604447114639e-05,  -9.908648687805176e-08,
   1.008064668530357e-09,  -1.054802316463731e-11,   1.124021743836877e-13,  -1.212905977296335e-15,   1.319597146717582e-17,  -1.438972789538082e-19,   2.016667448410069e-01,
  -1.172620922516864e-03,   1.022722551468681e-05,  -9.910708680981514e-08,   1.008394014039454e-09,  -1.055299984187762e-11,   1.124743855288040e-13,  -1.213918700276526e-15,
   1.320963061754405e-17,  -1.440691683948812e-19,   2.016678973240750e-01,  -1.172654420404069e-03,   1.022790717657051e-05,  -9.911897690779263e-08,   1.008584117862186e-09,
  -1.055587260961730e-11,   1.125160713201685e-13,  -1.214503345716427e-15,   1.321751598858023e-17,  -1.441683822065613e-19,   2.016683300995556e-01,  -1.172666999540169e-03,
   1.022816315845591e-05,  -9.912344203654862e-08,   1.008655509803968e-09,  -1.055695148156165e-11,   1.125317268906567e-13,  -1.214722920522499e-15,   1.322047747886487e-17,
  -1.442056404375712e-19,   2.016684018386359e-01,  -1.172669084730304e-03,   1.022820559170148e-05,  -9.912418221025780e-08,   1.008667344360232e-09,  -1.055713032631219e-11,
   1.125343221385266e-13,  -1.214759320016474e-15,   1.322096841227218e-17,  -1.442118166521208e-19,   6.338238864009238e-02,  -3.684849661587209e-04,   3.212918279930490e-06,
  -3.112277551645792e-08,   3.165114248224809e-10,  -3.310447881938901e-12,   3.526581615140006e-14,  -3.807685734208129e-16,   4.162174122948467e-18,  -4.630957475305686e-20,
   6.338284640630291e-02,  -3.684982698370904e-04,   3.213188959073349e-06,  -3.112749617012846e-08,   3.165869015577394e-10,  -3.311589608816083e-12,   3.528247273574484e-14,
  -3.810072704411158e-16,   4.165637567516686e-18,  -4.636346837887840e-20,   6.338359793155618e-02,  -3.685201114378162e-04,   3.213633369350237e-06,  -3.113524706330905e-08,
   3.167108345749789e-10,  -3.313464454856712e-12,   3.530982721634799e-14,  -3.813993307112227e-16,   4.171327907436102e-18,  -4.645206340867733e-20,   6.338439539590368e-02,
  -3.685432890483069e-04,   3.214104986423222e-06,  -3.114347295889219e-08,   3.168423720782793e-10,  -3.315454513752543e-12,   3.533886603494829e-14,  -3.818156096771914e-16,
   4.177371970515225e-18,  -4.654623288675929e-20,   6.338502303202989e-02,  -3.685615313862310e-04,   3.214476197464380e-06,  -3.114994793980677e-08,   3.169459181276947e-10,
  -3.317021209267973e-12,   3.536172959064389e-14,  -3.821434210601061e-16,   4.182133156134183e-18,  -4.662046325019842e-20,   6.338538526413325e-02,  -3.685720599721114e-04,
   3.214690449027012e-06,  -3.115368524211446e-08,   3.170056867386071e-10,  -3.317925583863182e-12,   3.537492854711411e-14,  -3.823326867107973e-16,   4.184882726072173e-18,
  -4.666335062413113e-20,   6.338552128797341e-02,  -3.685760136696712e-04,   3.214770906099611e-06,  -3.115508872404365e-08,   3.170281323671415e-10,  -3.318265224077998e-12,
   3.537988563359654e-14,  -3.824037728391926e-16,   4.185915556781644e-18,  -4.667946426248840e-20,   6.338554383598183e-02,  -3.685766690573773e-04,   3.214784243194649e-06,
  -3.115532137589194e-08,   3.170318531526902e-10,  -3.318321526339601e-12,   3.538070738105283e-14,  -3.824155571736988e-16,   4.186086781191157e-18,  -4.668213580388280e-20,
   5.209005009839838e-03,  -3.028349172630149e-05,   2.640498295524943e-07,  -2.557790964593004e-09,   2.601244784338916e-11,  -2.720931397860904e-13,   2.900193214770042e-15,
  -3.140455483234220e-17,   3.477049035039080e-19,  -4.056882129456407e-21,   5.209042630806621e-03,  -3.028458507457907e-05,   2.640720753050238e-07,  -2.558178968649947e-09,
   2.601865518073953e-11,  -2.721873265690731e-13,   2.901586008400758e-15,  -3.142553702193020e-17,   3.480571080488577e-19,  -4.064245223145782e-21,   5.209104394007913e-03,
  -3.028638010269484e-05,   2.641085991453076e-07,  -2.558816037142487e-09,   2.602884768272389e-11,  -2.723419948732081e-13,   2.903873524182845e-15,  -3.146001019160361e-17,
   3.486362133371226e-19,  -4.076365191106555e-21,   5.209169932658600e-03,  -3.028828492933367e-05,   2.641473589787392e-07,  -2.559492147962863e-09,   2.603966564228570e-11,
  -2.725061717109877e-13,   2.906302142439565e-15,  -3.149662634341782e-17,   3.492519210159448e-19,  -4.089269368177773e-21,   5.209221514180698e-03,  -3.028978415599307e-05,
   2.641778669485023e-07,  -2.560024346260450e-09,   2.604818155337808e-11,  -2.726354245255317e-13,   2.908214483290016e-15,  -3.152547061750766e-17,   3.497373806138682e-19,
  -4.099456936301497e-21,   5.209251283791579e-03,  -3.029064943635370e-05,   2.641954752086954e-07,  -2.560331526604453e-09,   2.605309710225055e-11,  -2.727100368110799e-13,
   2.909318536026912e-15,  -3.154212812047052e-17,   3.500179081149560e-19,  -4.105349202647626e-21,   5.209262462747711e-03,  -3.029097436668149e-05,   2.642020875717304e-07,
  -2.560446883118041e-09,   2.605494310042876e-11,  -2.727380578616647e-13,   2.909733195106784e-15,  -3.154838524231562e-17,   3.501233169767593e-19,  -4.107564234153338e-21,
   5.209264315828735e-03,  -3.029102822900637e-05,   2.642031836806522e-07,  -2.560466005493310e-09,   2.605524910952814e-11,  -2.727427029310349e-13,   2.909801934810793e-15,
  -3.154942255875143e-17,   3.501407935936483e-19,  -4.107931535445955e-21,   6.088181559903161e-05,  -3.539474372751018e-07,   3.086162548242766e-09,  -2.989503647438336e-11,
   3.040370649045188e-13,  -3.180897348155245e-15,   3.394698734550275e-17,  -3.699930760455983e-19,   4.214073831448038e-21,  -5.416239220507110e-23,   6.088225530551882e-05,
  -3.539602161522986e-07,   3.086422560296469e-09,  -2.989957250278588e-11,   3.041097296059704e-13,  -3.182007570950784e-15,   3.396390285646231e-17,  -3.702750606358363e-19,
   4.220029286835420e-21,  -5.432929364361762e-23,   6.088297718171278e-05,  -3.539811961499065e-07,   3.086849457085206e-09,  -2.990702027158998e-11,   3.042290466419976e-13,
  -3.183830793454041e-15,   3.399168970429876e-17,  -3.707386096738688e-19,   4.229831570628411e-21,  -5.460430283737604e-23,   6.088374318462073e-05,  -3.540034594553403e-07,
   3.087302488635834e-09,  -2.991492448518285e-11,   3.043556868195796e-13,  -3.185766206105255e-15,   3.402119724900640e-17,  -3.712313234895540e-19,   4.240267222079273e-21,
  -5.489749012205482e-23,   6.088434605934534e-05,  -3.540209821742213e-07,   3.087659071066193e-09,  -2.992114626915689e-11,   3.044553790779380e-13,  -3.187289989494980e-15,
   3.404443692574615e-17,  -3.716197106948980e-19,   4.248505312456997e-21,  -5.512923319019575e-23,   6.088469400072534e-05,  -3.540310954313675e-07,   3.087864879487249e-09,
  -2.992473743393703e-11,   3.045129237646744e-13,  -3.188169636778758e-15,   3.405785585629509e-17,  -3.718441051492115e-19,   4.253269792851442e-21,  -5.526337975897820e-23,
   6.088482465817468e-05,  -3.540348931646022e-07,   3.087942165946906e-09,  -2.992608603738746e-11,   3.045345343206486e-13,  -3.188499998862269e-15,   3.406289609576992e-17,
  -3.719284145512384e-19,   4.255060817860233e-21,  -5.531382944198723e-23,   6.088484631662269e-05,  -3.540355226987647e-07,   3.087954977460643e-09,  -2.992630959221665e-11,
   3.045381166827175e-13,  -3.188554763522077e-15,   3.406373165609356e-17,  -3.719423925252439e-19,   4.255357807001673e-21,  -5.532219622782713e-23,   1.971252513845650e-01,
  -1.095093366563303e-03,   9.124187423859435e-06,  -8.445803118068860e-08,   8.207742688740328e-10,  -8.203268707786065e-12,   8.349478730859366e-14,  -8.606896030143530e-16,
   8.953055167375231e-18,  -9.365702585635380e-20,   1.971265512348355e-01,  -1.095129464882234e-03,   9.124889249545731e-06,  -8.446972682341910e-08,   8.209529232132021e-10,
  -8.205848545390001e-12,   8.353059269070217e-14,  -8.611715538438901e-16,   8.959363193478429e-18,  -9.373667433558086e-20,   1.971286852218403e-01,  -1.095188729730844e-03,
   9.126041520420747e-06,  -8.448892977116215e-08,   8.212462685463075e-10,  -8.210084808885621e-12,   8.358939121421580e-14,  -8.619630494759629e-16,   8.969723188191149e-18,
  -9.386748226082076e-20,   1.971309496454204e-01,  -1.095251619230724e-03,   9.127264318979662e-06,  -8.450930919514864e-08,   8.215576058207601e-10,  -8.214581229148378e-12,
   8.365180572650030e-14,  -8.628032890254036e-16,   8.980721854553034e-18,  -9.400635028514293e-20,   1.971327318299552e-01,  -1.095301117156656e-03,   9.128226776566655e-06,
  -8.452535052479224e-08,   8.218026843540898e-10,  -8.218120961956674e-12,   8.370094418955965e-14,  -8.634648527555047e-16,   8.989382143179315e-18,  -9.411569130865937e-20,
   1.971337603920736e-01,  -1.095329684804388e-03,   9.128782273236082e-06,  -8.453460933853868e-08,   8.219441458033169e-10,  -8.220164222515389e-12,   8.372931014005247e-14,
  -8.638467707110819e-16,   8.994381881045747e-18,  -9.417881464700270e-20,   1.971341466327779e-01,  -1.095340412509875e-03,   9.128990875996120e-06,  -8.453808631340889e-08,
   8.219972701117607e-10,  -8.220931564969048e-12,   8.373996319432933e-14,  -8.639902067412573e-16,   8.996259656683022e-18,  -9.420252196076513e-20,   1.971342106579881e-01,
  -1.095342190794841e-03,   9.129025455324035e-06,  -8.453866268222075e-08,   8.220060764440548e-10,  -8.221058767068659e-12,   8.374172916219633e-14,  -8.640139844791643e-16,
   8.996570941984402e-18,  -9.420645199162219e-20,   6.195760539889376e-02,  -3.441941721066138e-04,   2.867784844669607e-06,  -2.654565028220460e-08,   2.579744210667003e-10,
  -2.578361917048588e-12,   2.624476995361398e-14,  -2.706300864384939e-16,   2.819639885183292e-18,  -2.969100424195793e-20,   6.195801394934748e-02,  -3.442055180182942e-04,
   2.868005432840705e-06,  -2.654932633194190e-08,   2.580305774484749e-10,  -2.579173127045344e-12,   2.625604772925076e-14,  -2.707829507623478e-16,   2.821691983659926e-18,
  -2.971909997876487e-20,   6.195868467379846e-02,  -3.442241453050618e-04,   2.868367598734291e-06,  -2.655536199811845e-08,   2.581227846632255e-10,  -2.580505190264872e-12,
   2.627456794491228e-14,  -2.710340066396964e-16,   2.825062767347985e-18,  -2.976526431909188e-20,   6.195939639521909e-02,  -3.442439118408332e-04,   2.868751931920697e-06,
  -2.656176744228160e-08,   2.582206473330543e-10,  -2.581919061905086e-12,   2.629422737644985e-14,  -2.713005382343475e-16,   2.828642057595057e-18,  -2.981430357235190e-20,
   6.195995654612024e-02,  -3.442594693269992e-04,   2.869054438324352e-06,  -2.656680938305071e-08,   2.582976829236547e-10,  -2.583032111946656e-12,   2.630970528420610e-14,
  -2.715104028090298e-16,   2.831460882763000e-18,  -2.985293784262878e-20,   6.196027982913963e-02,  -3.442684483049317e-04,   2.869229034382417e-06,  -2.656971951543084e-08,
   2.583421485473561e-10,  -2.583674605452326e-12,   2.631864022592096e-14,  -2.716315609914887e-16,   2.833088446145846e-18,  -2.987525053971087e-20,   6.196040122682566e-02,
  -3.442718200851976e-04,   2.869294599527487e-06,  -2.657081236141357e-08,   2.583588471313858e-10,  -2.583915892833986e-12,   2.632199582747698e-14,  -2.716770648897633e-16,
   2.833699756912501e-18,  -2.988363222583668e-20,   6.196042135031933e-02,  -3.442723790105115e-04,   2.869305468025359e-06,  -2.657099351956661e-08,   2.583616152293020e-10,
  -2.583955890973378e-12,   2.632255208979098e-14,  -2.716846082235706e-16,   2.833801098048889e-18,  -2.988502177106608e-20,   5.091910920843330e-03,  -2.828718207953399e-05,
   2.356854359692246e-07,  -2.181622796462095e-09,   2.120137982189711e-11,  -2.119048839585145e-13,   2.157263527075517e-15,  -2.226317577465047e-17,   2.328455062784253e-19,
  -2.490588778962969e-21,   5.091944497069356e-03,  -2.828811452986264e-05,   2.357035648007620e-07,  -2.181924916336986e-09,   2.120599581029315e-11,  -2.119716217591498e-13,
   2.158195117376576e-15,  -2.227601391069408e-17,   2.330280166018700e-19,  -2.493511656742210e-21,   5.091999619748980e-03,  -2.828964539139124e-05,   2.357333290649002e-07,
  -2.182420963752889e-09,   2.121357514187747e-11,  -2.120812104451539e-13,   2.159725000872381e-15,  -2.229710067493715e-17,   2.333279094876488e-19,  -2.498318295191603e-21,
   5.092058111715092e-03,  -2.829126988075518e-05,   2.357649151279214e-07,  -2.182947401849413e-09,   2.122161935547382e-11,  -2.121975302871181e-13,   2.161349042519549e-15,
  -2.231949017388588e-17,   2.336464902724573e-19,  -2.503429765511806e-21,   5.092104147040968e-03,  -2.829254845435806e-05,   2.357897763339531e-07,  -2.183361779070955e-09,
   2.122795161112636e-11,  -2.122891019753927e-13,   2.162627691313799e-15,  -2.233712156512321e-17,   2.338974843707630e-19,  -2.507460690221983e-21,   5.092130715665814e-03,
  -2.829328638104231e-05,   2.358041253480014e-07,  -2.183600951399397e-09,   2.123160664792178e-11,  -2.123419607585322e-13,   2.163365832884169e-15,  -2.234730129446944e-17,
   2.340424461209461e-19,  -2.509790297996200e-21,   5.092140692588152e-03,  -2.829356348681672e-05,   2.358095137582846e-07,  -2.183690768115571e-09,   2.123297925800016e-11,
  -2.123618118313005e-13,   2.163643051777269e-15,  -2.235112469897794e-17,   2.340969011622550e-19,  -2.510665710113847e-21,   5.092142346413197e-03,  -2.829360942143279e-05,
   2.358104069756452e-07,  -2.183705656792458e-09,   2.123320679343492e-11,  -2.123651025401823e-13,   2.163689006855358e-15,  -2.235175852600569e-17,   2.341059289448301e-19,
  -2.510810854996225e-21,   5.951324314584476e-05,  -3.306149643708124e-07,   2.754644658299222e-09,  -2.549838925650000e-11,   2.477991428848375e-13,  -2.476838902680054e-15,
   2.522319787467315e-17,  -2.607740891123017e-19,   2.750740530825023e-21,  -3.044424132879654e-23,   5.951363557812215e-05,  -3.306258626723380e-07,   2.754856545994761e-09,
  -2.550192058352930e-11,   2.478531154733807e-13,  -2.477620731194334e-15,   2.523421057024142e-17,  -2.609314252426340e-19,   2.753244174463845e-21,  -3.049498191530330e-23,
   5.951427984108038e-05,  -3.306437550898568e-07,   2.755204427300475e-09,  -2.550771863376121e-11,   2.479417372341150e-13,  -2.478904570016440e-15,   2.525229693963768e-17,
  -2.611899076195473e-19,   2.757360610038681e-21,  -3.057851364041484e-23,   5.951496348359179e-05,  -3.306627418117468e-07,   2.755573601601308e-09,  -2.551387190800617e-11,
   2.480357949121751e-13,  -2.480267285620120e-15,   2.527149783529879e-17,  -2.614644356369121e-19,   2.761737049476064e-21,  -3.066746460649685e-23,   5.951550153536023e-05,
  -3.306776855362562e-07,   2.755864176554506e-09,  -2.551871536001765e-11,   2.481098355584265e-13,  -2.481340085647168e-15,   2.528661618784147e-17,  -2.616806779773923e-19,
   2.765187561875326e-21,  -3.073769996187864e-23,   5.951581206418378e-05,  -3.306863102826823e-07,   2.756031886206891e-09,  -2.552151092874792e-11,   2.481525725828064e-13,
  -2.481959354139563e-15,   2.529534415211409e-17,  -2.618055508832466e-19,   2.767181423622750e-21,  -3.077832677908921e-23,   5.951592867247550e-05,  -3.306895490421585e-07,
   2.756094865337535e-09,  -2.552256075269064e-11,   2.481686220307029e-13,  -2.482191921067811e-15,   2.529862213176670e-17,  -2.618524561338008e-19,   2.767930612409983e-21,
  -3.079360008695098e-23,   5.951594800205498e-05,  -3.306900859171964e-07,   2.756105305161192e-09,  -2.552273477920603e-11,   2.481712825234370e-13,  -2.482230473707928e-15,
   2.529916553242960e-17,  -2.618602321016708e-19,   2.768054826190627e-21,  -3.079613278202470e-23,   1.928847456888106e-01,  -1.025942402113567e-03,   8.184402835972142e-06,
  -7.253693739140666e-08,   6.749506128077594e-10,  -6.459076566241024e-12,   6.294881433587317e-14,  -6.213698743584944e-16,   6.191165014423145e-18,  -6.210173753258398e-20,
   1.928859115499370e-01,  -1.025973402263111e-03,   8.184979901693521e-06,  -7.254614485784634e-08,   6.750852781449937e-10,  -6.460938609815329e-12,   6.297356726416378e-14,
  -6.216893554922903e-16,   6.195189910608078e-18,  -6.215123512173524e-20,   1.928878255591974e-01,  -1.026024296872115e-03,   8.185927331699066e-06,  -7.256126232200326e-08,
   6.753063913322445e-10,  -6.463996146742013e-12,   6.301421481067889e-14,  -6.222140190576341e-16,   6.201800157374268e-18,  -6.223253041591232e-20,   1.928898565518823e-01,
  -1.026078303854919e-03,   8.186932741295514e-06,  -7.257730572686095e-08,   6.755410614981775e-10,  -6.467241369154850e-12,   6.305736078084056e-14,  -6.227709772285750e-16,
   6.208817849132902e-18,  -6.231884128529858e-20,   1.928914550123991e-01,  -1.026120810435842e-03,   8.187724085855858e-06,  -7.258993385864864e-08,   6.757257857984592e-10,
  -6.469796056591055e-12,   6.309132831596467e-14,  -6.232094869972607e-16,   6.214343495702297e-18,  -6.238680480052321e-20,   1.928923775387121e-01,  -1.026145342938021e-03,
   8.188180819118955e-06,  -7.259722255729160e-08,   6.758324088975385e-10,  -6.471270689438998e-12,   6.311093622749597e-14,  -6.234626320373988e-16,   6.217533531452273e-18,
  -6.242604246935550e-20,   1.928927239609564e-01,  -1.026154555348834e-03,   8.188352333209060e-06,  -7.259995967917562e-08,   6.758724497845773e-10,  -6.471824480300797e-12,
   6.311830005958619e-14,  -6.235577042186296e-16,   6.218731625206311e-18,  -6.244077936297751e-20,   1.928927813856363e-01,  -1.026156082448990e-03,   8.188380764452024e-06,
  -7.260041340385409e-08,   6.758790872852608e-10,  -6.471916281783365e-12,   6.311952076586551e-14,  -6.235734645163782e-16,   6.218930237137333e-18,  -6.244322235957871e-20,
   6.062478995902725e-02,  -3.224596243722137e-04,   2.572405100724725e-06,  -2.279877907887473e-08,   2.121409377543409e-10,  -2.030130180216223e-12,   1.978553188871078e-14,
  -1.953213258922548e-16,   1.947015943330355e-18,  -1.956901782092616e-20,   6.062515639591574e-02,  -3.224693678985919e-04,   2.572586475871362e-06,  -2.280167304660367e-08,
   2.121832646632878e-10,  -2.030715498983302e-12,   1.979331653972716e-14,  -1.954220141485227e-16,   1.948294926051491e-18,  -1.958520015581227e-20,   6.062575798008559e-02,
  -3.224853643686962e-04,   2.572884258689008e-06,  -2.280642456585639e-08,   2.122527631615254e-10,  -2.031676612269181e-12,   1.980609999373269e-14,  -1.955873702698819e-16,
   1.950395558351260e-18,  -1.961178287072234e-20,   6.062639633282172e-02,  -3.225023390758989e-04,   2.573200264833452e-06,  -2.281146711450806e-08,   2.123265227887238e-10,
  -2.032696723834837e-12,   1.981966924238373e-14,  -1.957629075473557e-16,   1.952625817772399e-18,  -1.964001203307712e-20,   6.062689873819819e-02,  -3.225156991402463e-04,
   2.573448989079606e-06,  -2.281543622023064e-08,   2.123845838427346e-10,  -2.033499771430167e-12,   1.983035194529515e-14,  -1.959011154531954e-16,   1.954382004527980e-18,
  -1.966224509298344e-20,   6.062718869354880e-02,  -3.225234098476390e-04,   2.573592543028685e-06,  -2.281772710666832e-08,   2.124180967591675e-10,  -2.033963311874569e-12,
   1.983651859869816e-14,  -1.959809016558436e-16,   1.955395919630398e-18,  -1.967508287115787e-20,   6.062729757606188e-02,  -3.225263053616655e-04,   2.573646450915331e-06,
  -2.281858740227772e-08,   2.124306820898331e-10,  -2.034137392173063e-12,   1.983883451374351e-14,  -1.960108666522661e-16,   1.955776727701507e-18,  -1.967990484114331e-20,
   6.062731562497058e-02,  -3.225267853380814e-04,   2.573655387022111e-06,  -2.281873001096161e-08,   2.124327683358734e-10,  -2.034166249331716e-12,   1.983921842434004e-14,
  -1.960158340159094e-16,   1.955839855934840e-18,  -1.968070421799942e-20,   4.982375094649115e-03,  -2.650095452397850e-05,   2.114100051157395e-07,  -1.873690216892307e-09,
   1.743455838762692e-11,  -1.668447901079779e-13,   1.626119643169024e-15,  -1.605640311357402e-17,   1.602290183190439e-19,  -1.618143436235807e-21,   4.982405209822073e-03,
  -2.650175528397149e-05,   2.114249112239511e-07,  -1.873928055661240e-09,   1.743803713307707e-11,  -1.668929071136143e-13,   1.626760333231804e-15,  -1.606473207560025e-17,
   1.603368921936956e-19,  -1.619597730354604e-21,   4.982454650290250e-03,  -2.650306993462221e-05,   2.114493841630717e-07,  -1.874318556052113e-09,   1.744374904660662e-11,
  -1.669719169842932e-13,   1.627812440966358e-15,  -1.607841081851005e-17,   1.605140882792644e-19,  -1.621987607394396e-21,   4.982507112538627e-03,  -2.650446498051265e-05,
   2.114753547655284e-07,  -1.874732974515692e-09,   1.744981117393451e-11,  -1.670557770592919e-13,   1.628929231850719e-15,  -1.609293237116345e-17,   1.607022480817572e-19,
  -1.624526744216058e-21,   4.982548402117498e-03,  -2.650556296132903e-05,   2.114957958824598e-07,  -1.875059172808962e-09,   1.745458307447232e-11,  -1.671217931197229e-13,
   1.629808458730432e-15,  -1.610436623437109e-17,   1.608504331041696e-19,  -1.626527447235239e-21,   4.982572231747672e-03,  -2.650619665654040e-05,   2.115075936991762e-07,
  -1.875247447780701e-09,   1.745733742227245e-11,  -1.671598993921591e-13,   1.630316000693052e-15,  -1.611096707620829e-17,   1.609359946180461e-19,  -1.627683051374620e-21,
   4.982581180125460e-03,  -2.650643462087751e-05,   2.115120240570410e-07,  -1.875318150601783e-09,   1.745837178111280e-11,  -1.671742100210267e-13,   1.630506610988574e-15,
  -1.611344616179796e-17,   1.609681315796612e-19,  -1.628117173738526e-21,   4.982582663453215e-03,  -2.650647406716185e-05,   2.115127584607328e-07,  -1.875329870801442e-09,
   1.745854324479241e-11,  -1.671765822835415e-13,   1.630538208599634e-15,  -1.611385712702773e-17,   1.609734591506799e-19,  -1.628189145315058e-21,   5.823301017156608e-05,
  -3.097378911666338e-07,   2.470918155194834e-09,  -2.189932178668924e-11,   2.037719525969749e-13,  -1.950074027710012e-15,   1.900754212539270e-17,  -1.877709078236638e-19,
   1.878312843996431e-21,  -1.917035810787812e-23,   5.823336215172750e-05,  -3.097472502916686e-07,   2.471092375103836e-09,  -2.190210163783639e-11,   2.038126155644840e-13,
  -1.950636751771524e-15,   1.901505417014291e-17,  -1.878696652757683e-19,   1.879646344719800e-21,  -1.919065750540687e-23,   5.823394000210196e-05,  -3.097626156694784e-07,
   2.471378410412608e-09,  -2.190666579299258e-11,   2.038793820135013e-13,  -1.951560768093306e-15,   1.902739025883160e-17,  -1.880318672141413e-19,   1.881837344305732e-21,
  -1.922403864596895e-23,   5.823455317044339e-05,  -3.097789206910288e-07,   2.471681950144469e-09,  -2.191150950224296e-11,   2.039502421545577e-13,  -1.952541511361678e-15,
   1.904048503984617e-17,  -1.882040788674800e-19,   1.884164673016885e-21,  -1.925953546169713e-23,   5.823503575484226e-05,  -3.097917536745263e-07,   2.471920862246292e-09,
  -2.191532209742050e-11,   2.040060208845964e-13,  -1.953313571895603e-15,   1.905079449572755e-17,  -1.883396849087933e-19,   1.885998113260790e-21,  -1.928752743867402e-23,
   5.823531427082784e-05,  -3.097991601793342e-07,   2.472058753009260e-09,  -2.191752264938555e-11,   2.040382164616637e-13,  -1.953759227500556e-15,   1.905674580606551e-17,
  -1.884179757264517e-19,   1.887056958426700e-21,  -1.930370457407967e-23,   5.823541885769054e-05,  -3.098019414596340e-07,   2.472110534236513e-09,  -2.191834902176765e-11,
   2.040503070870075e-13,  -1.953926591562081e-15,   1.905898086999511e-17,  -1.884473803656882e-19,   1.887454703624686e-21,  -1.930978349276514e-23,   5.823543619453079e-05,
  -3.098024025000357e-07,   2.472119117815011e-09,  -2.191848600709954e-11,   2.040523113269090e-13,  -1.953954335392409e-15,   1.905935137901431e-17,  -1.884522549041418e-19,
   1.887520642884628e-21,  -1.931079138456374e-23,   1.889066605933621e-01,  -9.637746781675255e-04,   7.374742503364610e-06,  -6.269463211502710e-08,   5.595750518881662e-10,
  -5.136603850157885e-12,   4.801950564553750e-14,  -4.546905880754091e-16,   4.346225384258181e-18,  -4.183774660294805e-20,   1.889077110354014e-01,  -9.638014697554205e-04,
   7.375220875245682e-06,  -6.270195338443902e-08,   5.596777612524765e-10,  -5.137966112332195e-12,   4.803687772355566e-14,  -4.549057559792382e-16,   4.348830037145994e-18,
  -4.186865395517046e-20,   1.889094355553642e-01,  -9.638454547461263e-04,   7.376006263585225e-06,  -6.271397383605622e-08,   5.598464021333838e-10,  -5.140202951536829e-12,
   4.806540431302026e-14,  -4.552591035462972e-16,   4.353107661344475e-18,  -4.191941626598488e-20,   1.889112654714130e-01,  -9.638921292971023e-04,   7.376839707597541e-06,
  -6.272673037137241e-08,   5.600253796226820e-10,  -5.142577043446875e-12,   4.809568344128782e-14,  -4.556341884649450e-16,   4.357648814787511e-18,  -4.197331012013586e-20,
   1.889127056735344e-01,  -9.639288646415698e-04,   7.377495694894219e-06,  -6.273677121272542e-08,   5.601662622655674e-10,  -5.144445924409822e-12,   4.811952067029587e-14,
  -4.559294951370038e-16,   4.361224365874842e-18,  -4.201574740494582e-20,   1.889135368618135e-01,  -9.639500662201959e-04,   7.377874303037938e-06,  -6.274256653226762e-08,
   5.602475789851184e-10,  -5.145524675845288e-12,   4.813328056663498e-14,  -4.560999676481162e-16,   4.363288543695559e-18,  -4.204024782875090e-20,   1.889138489849582e-01,
  -9.639580277925902e-04,   7.378016478895259e-06,  -6.274474283703874e-08,   5.602781162240141e-10,  -5.145929792459313e-12,   4.813844810510290e-14,  -4.561639903265316e-16,
   4.364063787265914e-18,  -4.204944968987468e-20,   1.889139007240312e-01,  -9.639593475460795e-04,   7.378040046828457e-06,  -6.274510359622692e-08,   5.602831783140888e-10,
  -5.145996948168734e-12,   4.813930472814530e-14,  -4.561746034532526e-16,   4.364192301540860e-18,  -4.205097512019967e-20,   5.937445483015448e-02,  -3.029199495466149e-04,
   2.317924177019770e-06,  -1.970528519548575e-08,   1.758776828292766e-10,  -1.614465207081592e-12,   1.509287432278717e-14,  -1.429158646353299e-16,   1.366252467878075e-18,
  -1.315949016336926e-20,   5.937478499015646e-02,  -3.029283702975280e-04,   2.318074532076108e-06,  -1.970758631420713e-08,   1.759099651279735e-10,  -1.614893386715012e-12,
   1.509833535594993e-14,  -1.429835459174000e-16,   1.367073849971442e-18,  -1.316932851837300e-20,   5.937532701674438e-02,  -3.029421950343116e-04,   2.318321384185854e-06,
  -1.971136441398685e-08,   1.759629701822489e-10,  -1.615596459266727e-12,   1.510730289471762e-14,  -1.430946921915501e-16,   1.368422828651432e-18,  -1.318548802626229e-20,
   5.937590216993106e-02,  -3.029568651154326e-04,   2.318583340472368e-06,  -1.971537386929015e-08,   1.760192241095089e-10,  -1.616342672581878e-12,   1.511682136703825e-14,
  -1.432126765973717e-16,   1.369854943112816e-18,  -1.320264574129239e-20,   5.937635483377873e-02,  -3.029684112465062e-04,   2.318789521084116e-06,  -1.971852976576059e-08,
   1.760635045506850e-10,  -1.616930090497845e-12,   1.512431478727571e-14,  -1.433055668834655e-16,   1.370982563536701e-18,  -1.321615708877614e-20,   5.937661608105713e-02,
  -3.029750750252005e-04,   2.318908519819466e-06,  -1.972035126934762e-08,   1.760890629886831e-10,  -1.617269158643925e-12,   1.512864032183451e-14,  -1.433591900944081e-16,
   1.371633551406448e-18,  -1.322395801475499e-20,   5.937671418316483e-02,  -3.029775773934171e-04,   2.318953206515993e-06,  -1.972103529495206e-08,   1.760986610656790e-10,
  -1.617396493026852e-12,   1.513026477986561e-14,  -1.433793288675853e-16,   1.371878044675523e-18,  -1.322688795703627e-20,   5.937673044505443e-02,  -3.029779921995661e-04,
   2.318960614054084e-06,  -1.972114868372239e-08,   1.761002521175298e-10,  -1.617417601099698e-12,   1.513053406636360e-14,  -1.433826673012301e-16,   1.371918575089805e-18,
  -1.322737366946347e-20,   4.879617813168405e-03,  -2.489510995999581e-05,   1.904957973016042e-07,  -1.619455069139794e-09,   1.445429695493277e-11,  -1.326830545790325e-13,
   1.240402541204801e-15,  -1.174614581659545e-17,   1.123246685991631e-19,  -1.083390377810434e-21,   4.879644946969177e-03,  -2.489580200924232e-05,   1.905081540522013e-07,
  -1.619644184082085e-09,   1.445695006626842e-11,  -1.327182464973391e-13,   1.240851523663285e-15,  -1.175171848555989e-17,   1.123927097624502e-19,  -1.084223446687633e-21,
   4.879689492769279e-03,  -2.489693817854286e-05,   1.905284412978157e-07,  -1.619954683110714e-09,   1.446130627151511e-11,  -1.327760317801517e-13,   1.241588797300349e-15,
  -1.176087001531236e-17,   1.125044600133645e-19,  -1.085591954102936e-21,   4.879736761038867e-03,  -2.489814382144722e-05,   1.905499698621715e-07,  -1.620284195845393e-09,
   1.446592948482407e-11,  -1.328373628169250e-13,   1.242371368439002e-15,  -1.177058469952060e-17,   1.126231032220070e-19,  -1.087045257459391e-21,   4.879773962670155e-03,
  -2.489909272628886e-05,   1.905669145693701e-07,  -1.620543559775885e-09,   1.446956866078605e-11,  -1.328856425317539e-13,   1.242987449290904e-15,  -1.177823325218245e-17,
   1.127165250019829e-19,  -1.088189893045196e-21,   4.879795432962019e-03,  -2.489964038089514e-05,   1.905766943382433e-07,  -1.620693258074738e-09,   1.447166917413751e-11,
  -1.329135104569550e-13,   1.243343079083870e-15,  -1.178264860260468e-17,   1.127704601730612e-19,  -1.088850837065650e-21,   4.879803495365187e-03,  -2.489984603500571e-05,
   1.905803668610027e-07,  -1.620749473978150e-09,   1.447245798953360e-11,  -1.329239760393527e-13,   1.243476636255642e-15,  -1.178430684145464e-17,   1.127907170788968e-19,
  -1.089099094781898e-21,   4.879804831828931e-03,  -2.489988012534825e-05,   1.905809756406697e-07,  -1.620758792711435e-09,   1.447258874970636e-11,  -1.329257109068856e-13,
   1.243498776041386e-15,  -1.178458173045999e-17,   1.127940751468946e-19,  -1.089140250569906e-21,   5.703200348199514e-05,  -2.909690988856459e-07,   2.226477033293679e-09,
  -1.892786958619900e-11,   1.689390047380246e-13,  -1.550777777317525e-15,   1.449790491852317e-17,  -1.373064141645050e-19,   1.313874027581789e-21,  -1.271121935919713e-23,
   5.703232061646803e-05,  -2.909771874199776e-07,   2.226621456589756e-09,  -1.893007993115265e-11,   1.689700145264421e-13,  -1.551189156930524e-15,   1.450315699436906e-17,
  -1.373718136169574e-19,   1.314683217409630e-21,  -1.272159743866137e-23,   5.703284125892993e-05,  -2.909904667414162e-07,   2.226858569968615e-09,  -1.893370899380184e-11,
   1.690209302265610e-13,  -1.551864644609899e-15,   1.451178146166694e-17,  -1.374792159557888e-19,   1.316012338331911e-21,  -1.273865077138123e-23,   5.703339372107433e-05,
  -2.910045580565601e-07,   2.227110191640010e-09,  -1.893756028567538e-11,   1.690749667491149e-13,  -1.552581581559318e-15,   1.452093586239091e-17,  -1.375932305689055e-19,
   1.317423597494837e-21,  -1.275676751398101e-23,   5.703382852635018e-05,  -2.910156486681496e-07,   2.227308238081298e-09,  -1.894059168966723e-11,   1.691175017636499e-13,
  -1.553145953983993e-15,   1.452814272307954e-17,  -1.376829986558667e-19,   1.318534961236064e-21,  -1.277104133246854e-23,   5.703407946685610e-05,  -2.910220495465704e-07,
   2.227422542117506e-09,  -1.894234133938396e-11,   1.691420527545310e-13,  -1.553471720187890e-15,   1.453230286524086e-17,  -1.377348208099696e-19,   1.319176630022895e-21,
  -1.277928539602504e-23,   5.703417369862261e-05,  -2.910244531910272e-07,   2.227465465849167e-09,  -1.894299838185523e-11,   1.691512725010600e-13,  -1.553594059192930e-15,
   1.453386521428014e-17,  -1.377542834248863e-19,   1.319417635810622e-21,  -1.278238232807298e-23,   5.703418931894534e-05,  -2.910248516321896e-07,   2.227472581147501e-09,
  -1.894310729771693e-11,   1.691528008379514e-13,  -1.553614339191065e-15,   1.453412420519193e-17,  -1.377575097838889e-19,   1.319457588754777e-21,  -1.278289575244962e-23,
   1.851649980393298e-01,  -9.076412972854938e-04,   6.672927615253690e-06,  -5.450473316176534e-08,   4.674121157218551e-10,  -4.122483678369452e-12,   3.702930621478960e-14,
  -3.368947504423398e-16,   3.094240680645313e-18,  -2.862352585117309e-20,   1.851659484494353e-01,  -9.076645873153116e-04,   6.673327161071482e-06,  -5.451060828131565e-08,
   4.674913057881391e-10,  -4.123492825753727e-12,   3.704167110252751e-14,  -3.370419162352241e-16,   3.095953250669607e-18,  -2.864308951020782e-20,   1.851675087426553e-01,
  -9.077028234846183e-04,   6.673983129133083e-06,  -5.452025428015635e-08,   4.676213281984616e-10,  -4.125149822780058e-12,   3.706197500560266e-14,  -3.372835852546965e-16,
   3.098765730632547e-18,  -2.867522015252596e-20,   1.851691643903802e-01,  -9.077433974840119e-04,   6.674679228466529e-06,  -5.453049084312150e-08,   4.677593179887924e-10,
  -4.126908457346770e-12,   3.708352572986152e-14,  -3.375401133974889e-16,   3.101751374758044e-18,  -2.870933191398272e-20,   1.851704674344086e-01,  -9.077753312222337e-04,
   6.675227110469221e-06,  -5.453854809493634e-08,   4.678679354808823e-10,  -4.128292825317053e-12,   3.710049112541149e-14,  -3.377420738307546e-16,   3.104102095881796e-18,
  -2.873619156981391e-20,   1.851712194628607e-01,  -9.077937615235745e-04,   6.675543323196981e-06,  -5.454319850261942e-08,   4.679306282974059e-10,  -4.129091896762174e-12,
   3.711028413641217e-14,  -3.378586577887765e-16,   3.105459145382162e-18,  -2.875169822371814e-20,   1.851715018600965e-01,  -9.078006824204420e-04,   6.675662067870743e-06,
  -5.454494485446770e-08,   4.679541714982940e-10,  -4.129391979781711e-12,   3.711396187794632e-14,  -3.379024416389669e-16,   3.105968807030537e-18,  -2.875752215133888e-20,
   1.851715486716426e-01,  -9.078018296653074e-04,   6.675681751692669e-06,  -5.454523434137312e-08,   4.679580741960050e-10,  -4.129441724090294e-12,   3.711457153569041e-14,
  -3.379096997245167e-16,   3.106053294757133e-18,  -2.875848760477648e-20,   5.819842867201053e-02,  -2.852769036226523e-04,   2.097339702353494e-06,  -1.713115255175457e-08,
   1.469103304352993e-10,  -1.295720608468574e-12,   1.163853701701251e-14,  -1.058887032380735e-16,   9.725766860142637e-19,  -8.998359162293491e-21,   5.819872739139769e-02,
  -2.852842238135908e-04,   2.097465281914261e-06,  -1.713299913603576e-08,   1.469352203585501e-10,  -1.296037791684274e-12,   1.164242353882159e-14,  -1.059349682690352e-16,
   9.731154775909937e-19,  -9.004532140591942e-21,   5.819921780057133e-02,  -2.852962416625275e-04,   2.097671456468946e-06,  -1.713603092963544e-08,   1.469760871993788e-10,
  -1.296558599323302e-12,   1.164880544716118e-14,  -1.060109426992610e-16,   9.740003161357578e-19,  -9.014670610542123e-21,   5.819973818021681e-02,  -2.853089943049684e-04,
   2.097890244514443e-06,  -1.713924834098136e-08,   1.470194582369465e-10,  -1.297111352496669e-12,   1.165557925743858e-14,  -1.060915885666284e-16,   9.749396400532734e-19,
  -9.025434466442107e-21,   5.820014773448329e-02,  -2.853190312634007e-04,   2.098062446995877e-06,  -1.714178078214536e-08,   1.470535973812529e-10,  -1.297546470650359e-12,
   1.166091181148911e-14,  -1.061550798307598e-16,   9.756792129422344e-19,  -9.033910136887438e-21,   5.820038410137061e-02,  -2.853248240136001e-04,   2.098161834484639e-06,
  -1.714324243236117e-08,   1.470733021183091e-10,  -1.297797625336859e-12,   1.166398994604841e-14,  -1.061917309194848e-16,   9.761061632447648e-19,  -9.038803400328484e-21,
   5.820047286045339e-02,  -2.853269992914737e-04,   2.098199156622217e-06,  -1.714379132091691e-08,   1.470807018908811e-10,  -1.297891943884264e-12,   1.166514593212820e-14,
  -1.062054954764445e-16,   9.762665115890130e-19,  -9.040641207507882e-21,   5.820048757359280e-02,  -2.853273598771635e-04,   2.098205343361266e-06,  -1.714388230833710e-08,
   1.470819285327315e-10,  -1.297907578927392e-12,   1.166533755948441e-14,  -1.062077772389314e-16,   9.762930929022147e-19,  -9.040945868192355e-21,   4.782967524647386e-03,
  -2.344513755269453e-05,   1.723673287214105e-07,  -1.407903072194107e-09,   1.207364834391860e-11,  -1.064872653134749e-13,   9.565014531299346e-16,  -8.702478330179212e-18,
   7.993763219328916e-20,  -7.398747701483798e-22,   4.782992074539206e-03,  -2.344573915374170e-05,   1.723776493262031e-07,  -1.408054831542508e-09,   1.207569389759329e-11,
  -1.065133330921585e-13,   9.568208946184235e-16,  -8.706282514857958e-18,   7.998201422635778e-20,  -7.403868083159488e-22,   4.783032378224464e-03,  -2.344672682613522e-05,
   1.723945935334023e-07,  -1.408303995919536e-09,   1.207905249845470e-11,  -1.065561357970777e-13,   9.573454375163165e-16,  -8.712529599016007e-18,   8.005490214369217e-20,
  -7.412278157848460e-22,   4.783075144996730e-03,  -2.344777488664503e-05,   1.724125743651408e-07,  -1.408568415072511e-09,   1.208261690431428e-11,  -1.066015639593152e-13,
   9.579021920756726e-16,  -8.719160820369557e-18,   8.013227942329671e-20,  -7.421207527492365e-22,   4.783108803719160e-03,  -2.344859976194602e-05,   1.724267266184658e-07,
  -1.408776540760236e-09,   1.208542259619930e-11,  -1.066373242612081e-13,   9.583404868583660e-16,  -8.724381496706480e-18,   8.019320296185592e-20,  -7.428239068402406e-22,
   4.783128229246137e-03,  -2.344907583212172e-05,   1.724348946594070e-07,  -1.408896664758054e-09,   1.208704201058876e-11,  -1.066579654779779e-13,   9.585934858741543e-16,
  -8.727395201031928e-18,   8.022837404020060e-20,  -7.432298744812532e-22,   4.783135523804086e-03,  -2.344925460470535e-05,   1.724379619342882e-07,  -1.408941774516197e-09,
   1.208765015360643e-11,  -1.066657170739691e-13,   9.586884990717092e-16,  -8.728527018743908e-18,   8.024158319306457e-20,  -7.433823503155872e-22,   4.783136732985667e-03,
  -2.344928423900457e-05,   1.724384703839781e-07,  -1.408949252209942e-09,   1.208775096395847e-11,  -1.066670020443438e-13,   9.587042493731102e-16,  -8.728714641209886e-18,
   8.024377290808155e-20,  -7.434076270006270e-22,   5.590237411291701e-05,  -2.740221094664450e-07,   2.014595091508985e-09,  -1.645529146428439e-11,   1.411144125452218e-13,
  -1.244602824045661e-15,   1.117945795773444e-17,  -1.017164461868497e-19,   9.344874748900449e-22,  -8.656564827309819e-24,   5.590266104717496e-05,  -2.740291408599963e-07,
   2.014715716696183e-09,  -1.645706519866804e-11,   1.411383207059609e-13,  -1.244907510648384e-15,   1.118319234749900e-17,  -1.017609584340776e-19,   9.350088225116249e-22,
  -8.662671307038249e-24,   5.590313210864060e-05,  -2.740406845787640e-07,   2.014913757238119e-09,  -1.645997738450174e-11,   1.411775755897759e-13,  -1.245407799286969e-15,
   1.118932445634564e-17,  -1.018340551504794e-19,   9.358650458402371e-22,  -8.672702018783780e-24,   5.590363195817781e-05,  -2.740529341018414e-07,   2.015123913642727e-09,
  -1.646306786527079e-11,   1.412192358969843e-13,  -1.245938775066711e-15,   1.119583314197012e-17,  -1.019116472236852e-19,   9.367740366713200e-22,  -8.683353458578285e-24,
   5.590402535463817e-05,  -2.740625750805265e-07,   2.015289322380248e-09,  -1.646550039873661e-11,   1.412520284562308e-13,  -1.246356750569438e-15,   1.120095699225796e-17,
  -1.019727349082539e-19,   9.374897590148462e-22,  -8.691742055596137e-24,   5.590425239633795e-05,  -2.740681392941855e-07,   2.015384788827149e-09,  -1.646690438518793e-11,
   1.412709559599983e-13,  -1.246598010402514e-15,   1.120391466005490e-17,  -1.020079987537693e-19,   9.379029534626784e-22,  -8.696585629830318e-24,   5.590433765368196e-05,
  -2.740702287526361e-07,   2.015420638529266e-09,  -1.646743161946680e-11,   1.412780638562154e-13,  -1.246688613051610e-15,   1.120502540593755e-17,  -1.020212423701044e-19,
   9.380581380076911e-22,  -8.698404884780060e-24,   5.590435178635604e-05,  -2.740705751124396e-07,   2.015426581188674e-09,  -1.646751901733001e-11,   1.412792421144576e-13,
  -1.246703632116504e-15,   1.120520953388679e-17,  -1.020234377783312e-19,   9.380838634350024e-22,  -8.698706475794132e-24,   1.816372289337946e-01,  -8.567529350683622e-04,
   6.061169649027544e-06,  -4.764046793528945e-08,   3.931394344112602e-10,  -3.336671860964017e-12,   2.884105729533872e-14,  -2.525075971788239e-16,   2.231796564870847e-18,
  -1.986836391534807e-20,   1.816380921585155e-01,  -8.567732906333570e-04,   6.061505678272172e-06,  -4.764522265093030e-08,   3.932011047789916e-10,  -3.337428101050014e-12,
   2.884997387252636e-14,  -2.526097220976456e-16,   2.232940351313082e-18,  -1.988094512585978e-20,   1.816395093162628e-01,  -8.568067090573644e-04,   6.062057362770867e-06,
  -4.765302906493475e-08,   3.933023604412722e-10,  -3.338669812391484e-12,   2.886461517525139e-14,  -2.527774233340571e-16,   2.234818693844051e-18,  -1.990160746895412e-20,
   1.816410130772806e-01,  -8.568421705858197e-04,   6.062642794465065e-06,  -4.766131333211620e-08,   3.934098192465891e-10,  -3.339987664309491e-12,   2.888015521265855e-14,
  -2.529554307318987e-16,   2.236812619625284e-18,  -1.992354302824065e-20,   1.816421965792220e-01,  -8.568700804416194e-04,   6.063103569795514e-06,  -4.766783386047014e-08,
   3.934944034484812e-10,  -3.341025038103605e-12,   2.889238855083185e-14,  -2.530955694241350e-16,   2.238382471976125e-18,  -1.994081455268798e-20,   1.816428796150122e-01,
  -8.568861883450564e-04,   6.063369507286409e-06,  -4.767159729219356e-08,   3.935432240806277e-10,  -3.341623813968646e-12,   2.889944995135915e-14,  -2.531764646210813e-16,
   2.239288713976524e-18,  -1.995078554470812e-20,   1.816431361043287e-01,  -8.568922371325831e-04,   6.063469372301096e-06,  -4.767301055631684e-08,   3.935615577408725e-10,
  -3.341848676736643e-12,   2.890210182356996e-14,  -2.532068450535400e-16,   2.239629064027713e-18,  -1.995453036718992e-20,   1.816431786212407e-01,  -8.568932398114792e-04,
   6.063485926506679e-06,  -4.767324482813892e-08,   3.935645968616844e-10,  -3.341885951828325e-12,   2.890254142233058e-14,  -2.532118812287611e-16,   2.239685484408940e-18,
  -1.995515115760945e-20,   5.708963046050170e-02,  -2.692823973704774e-04,   1.905060639037239e-06,  -1.497367431750977e-08,   1.235659959481925e-10,  -1.048735274057101e-12,
   9.064913127013728e-15,  -7.936473070094414e-17,   7.014737059068237e-19,  -6.245078688582574e-21,   5.708990177701874e-02,  -2.692887952421609e-04,   1.905166254970562e-06,
  -1.497516875215317e-08,   1.235853793061113e-10,  -1.048972965115715e-12,   9.067715689278769e-15,  -7.939683100326575e-17,   7.018333022427705e-19,  -6.249037585725706e-21,
   5.709034719788635e-02,  -2.692992988459035e-04,   1.905339652596400e-06,  -1.497762235325413e-08,   1.236172045540934e-10,  -1.049363242874989e-12,   9.072317585737190e-15,
  -7.944954352550543e-17,   7.024238373536691e-19,  -6.255539390237755e-21,   5.709081983866221e-02,  -2.693104446091782e-04,   1.905523657160796e-06,  -1.498022614637479e-08,
   1.236509794863445e-10,  -1.049777452106339e-12,   9.077201963168917e-15,  -7.950549554380790e-17,   7.030507120140782e-19,  -6.262441888816830e-21,   5.709119182016006e-02,
  -2.693192168381071e-04,   1.905668481509743e-06,  -1.498227558617469e-08,   1.236775647967341e-10,  -1.050103505285134e-12,   9.081047014732224e-15,  -7.954954453079665e-17,
   7.035442621402228e-19,  -6.267876785690736e-21,   5.709140650225517e-02,  -2.693242796452218e-04,   1.905752067199851e-06,  -1.498345845454681e-08,   1.236929094075667e-10,
  -1.050291704347925e-12,   9.083266478470861e-15,  -7.957497185805398e-17,   7.038291783486187e-19,  -6.271014411215908e-21,   5.709148711832920e-02,  -2.693261808140887e-04,
   1.905783455351037e-06,  -1.498390265164028e-08,   1.236986717844429e-10,  -1.050362380146405e-12,   9.084099986545537e-15,  -7.958452116786610e-17,   7.039361821109254e-19,
  -6.272192817465578e-21,   5.709150048164026e-02,  -2.693264959618588e-04,   1.905788658433510e-06,  -1.498397628462985e-08,   1.236996269979279e-10,  -1.050374095944868e-12,
   9.084238156521453e-15,  -7.958610416045497e-17,   7.039539203018879e-19,  -6.272388165544926e-21,   4.691842283673339e-03,  -2.213064838643554e-05,   1.565651062609805e-07,
  -1.230593327970606e-09,   1.015512210955580e-11,  -8.618904694629016e-14,   7.449893531812408e-16,  -6.522520432850049e-18,   5.765115653243203e-20,  -5.133098164452040e-22,
   4.691864581493392e-03,  -2.213117418778800e-05,   1.565737861788823e-07,  -1.230716146284776e-09,   1.015671510837505e-11,  -8.620858138205320e-14,   7.452196843024512e-16,
  -6.525158917431436e-18,   5.768072857042855e-20,  -5.136360635211389e-22,   4.691901187869084e-03,  -2.213203741376794e-05,   1.565880366533075e-07,  -1.230917792540988e-09,
   1.015933062952714e-11,  -8.624065602569175e-14,   7.455978953897156e-16,  -6.529491626769828e-18,   5.772929243026127e-20,  -5.141718754779490e-22,   4.691940031280040e-03,
  -2.213295341485299e-05,   1.566031588461664e-07,  -1.231131782147862e-09,   1.016210638323564e-11,  -8.627469745793112e-14,   7.459993225084414e-16,  -6.534090611060051e-18,
   5.778084497206753e-20,  -5.147407187604534e-22,   4.691970602129883e-03,  -2.213367434988625e-05,   1.566150610603465e-07,  -1.231300212893699e-09,   1.016429126620337e-11,
  -8.630149386097625e-14,   7.463153317136874e-16,  -6.537711227122439e-18,   5.782143341438928e-20,  -5.151886226434110e-22,   4.691988245518416e-03,  -2.213409043057056e-05,
   1.566219304493223e-07,  -1.231397425508690e-09,   1.016555234529029e-11,  -8.631696084111098e-14,   7.464977404649996e-16,  -6.539801233086753e-18,   5.784486434251432e-20,
  -5.154472054535168e-22,   4.691994870853032e-03,  -2.213424667583632e-05,   1.566245100466129e-07,  -1.231433931312761e-09,   1.016602591956724e-11,  -8.632276927164095e-14,
   7.465662431278084e-16,  -6.540586141401580e-18,   5.785366412622642e-20,  -5.155443226440219e-22,   4.691995969100601e-03,  -2.213427257587495e-05,   1.566249376556610e-07,
  -1.231439982751481e-09,   1.016610442268243e-11,  -8.632373212459987e-14,   7.465775987603888e-16,  -6.540716255953442e-18,   5.785512288160912e-20,  -5.155604220934829e-22,
   5.483732040183946e-05,  -2.586586212611618e-07,   1.829901854579497e-09,  -1.438293032954868e-11,   1.186910512078492e-13,  -1.007360602076837e-15,   8.707298064563952e-18,
  -7.623457120723704e-20,   6.738500916612998e-22,  -6.001117134506993e-24,   5.483758101432997e-05,  -2.586647667229067e-07,   1.830003303736921e-09,  -1.438436580582782e-11,
   1.187096698857892e-13,  -1.007588918764800e-15,   8.709990277845939e-18,  -7.626541837971189e-20,   6.741962072647430e-22,  -6.004952967180665e-24,   5.483800886237586e-05,
  -2.586748559366605e-07,   1.830169860453219e-09,  -1.438672260757835e-11,   1.187402396173882e-13,  -1.007963804268100e-15,   8.714410979751931e-18,  -7.631607323226148e-20,
   6.747646102625059e-22,  -6.011252941736799e-24,   5.483846285644544e-05,  -2.586855619753579e-07,   1.830346605641551e-09,  -1.438922367598473e-11,   1.187726821180370e-13,
  -1.008361677443309e-15,   8.719103042972622e-18,  -7.636984128704365e-20,   6.753679992901941e-22,  -6.017941556768816e-24,   5.483882016246440e-05,  -2.586939881207964e-07,
   1.830485716358276e-09,  -1.439119226139264e-11,   1.187982186299810e-13,  -1.008674871393101e-15,   8.722796704020392e-18,  -7.641217103690289e-20,   6.758430648556395e-22,
  -6.023208325410850e-24,   5.483902637488406e-05,  -2.586988511891706e-07,   1.830566004413045e-09,  -1.439232846330476e-11,   1.188129578914615e-13,  -1.008855648074181e-15,
   8.724928782010784e-18,  -7.643660597997700e-20,   6.761173127713430e-22,  -6.026249001083386e-24,   5.483910381047869e-05,  -2.587006773527952e-07,   1.830596154234126e-09,
  -1.439275513595840e-11,   1.188184929409225e-13,  -1.008923536492414e-15,   8.725729472972075e-18,  -7.644578260587465e-20,   6.762203103917050e-22,  -6.027391016909325e-24,
   5.483911664657807e-05,  -2.587009800673010e-07,   1.830601152043800e-09,  -1.439282586398325e-11,   1.188194104709637e-13,  -1.008934790232040e-15,   8.725862202888935e-18,
  -7.644730381898817e-20,   6.762373845024681e-22,  -6.027580333558531e-24  };
  static constexpr double wi[11600] = {  -3.881948813191813e-02,   4.153025990179849e-03,  -3.227491660435502e-04,   2.104380285961762e-05,  -1.216666249193287e-06,
   6.420285105265822e-08,  -3.147471122778644e-09,   1.450843098243102e-10,  -6.353563642814586e-12,   2.660507434145066e-13,  -1.067541566596528e-14,   4.116573721443946e-16,
  -1.530265678333532e-17,   5.481524802317451e-19,  -3.694121544608312e-02,   3.952935555517677e-03,  -3.072710529066675e-04,   2.003959598883161e-05,  -1.158911422427811e-06,
   6.117195066047732e-08,  -2.999749517791199e-09,   1.383168418686285e-10,  -6.059057309743261e-12,   2.537955824284071e-13,  -1.018677467544371e-14,   3.929329543482210e-16,
  -1.461078632300038e-17,   5.235085219384123e-19,  -3.336450614931704e-02,   3.571565411140380e-03,  -2.777406652459716e-04,   1.812164644821434e-05,  -1.048479717971276e-06,
   5.536971805325714e-08,  -2.716599733405459e-09,   1.253277259923849e-10,  -5.493023618504924e-12,   2.302091919817866e-13,  -9.245025698704224e-15,   3.567957176292331e-16,
  -1.327373277919077e-17,   4.758240195662171e-19,  -2.843377965171008e-02,   3.045148337783245e-03,  -2.369221383603289e-04,   1.546658689429681e-05,  -8.953643643637658e-07,
   4.731141277829895e-08,  -2.322659959958939e-09,   1.072226007999270e-10,  -4.702547262031477e-12,   1.972078495490451e-13,  -7.924831888418607e-15,   3.060399180488518e-16,
  -1.139236944031283e-17,   4.086123309297332e-19,  -2.262746353655324e-02,   2.424397616155280e-03,  -1.887169826861356e-04,   1.232604080203761e-05,  -7.139446093483381e-07,
   3.774650092092772e-08,  -1.854191194386596e-09,   8.564964698426217e-11,  -3.758770765828207e-12,   1.577275471640450e-13,  -6.342265839950371e-15,   2.450752894657729e-16,
  -9.128278963191193e-18,   3.275832895253822e-19,  -1.651309755260908e-02,   1.769917001237554e-03,  -1.378253556657784e-04,   9.005791828712519e-06,  -5.218581173111949e-07,
   2.760340162969766e-08,  -1.356588055338722e-09,   6.269549902011113e-11,  -2.752810408106562e-12,   1.155727300306488e-13,  -4.649537646563394e-15,   1.797541906479120e-16,
  -6.698406308253864e-18,   2.404877043109608e-19,  -1.069150186864778e-02,   1.146215838493634e-03,  -8.928003110924666e-05,   5.835339302626797e-06,  -3.382375864226607e-07,
   1.789627847006711e-08,  -8.798023128749973e-10,   4.067399515656667e-11,  -1.786494308057764e-12,   7.502810839595660e-14,  -3.019407364217892e-15,   1.167701977448310e-16,
  -4.352694267306249e-18,   1.563160635592570e-19,  -5.736063985423485e-03,   6.150277960861097e-04,  -4.791152912014873e-05,   3.131936212261994e-06,  -1.815653362383726e-07,
   9.608174548794236e-09,  -4.724257384048581e-10,   2.184433520148528e-11,  -9.596170204134877e-13,   4.030823523989575e-14,  -1.622426278364142e-15,   6.275488941881865e-17,
  -2.339603234554179e-18,   8.403325846751814e-20,  -2.134657480876807e-03,   2.288903205608945e-04,  -1.783169711548990e-05,   1.165700056646832e-06,  -6.758171610282284e-08,
   3.576518737357871e-09,  -1.758642765115446e-10,   8.132208388202112e-12,  -3.572674561074929e-13,   1.500772486433078e-14,  -6.041038456604605e-16,   2.336788117441085e-17,
  -8.712399794302308e-19,   3.129456204386456e-20,  -2.411281664608897e-04,   2.585533103326075e-05,  -2.014273883294926e-06,   1.316788528920107e-07,  -7.634172728104012e-09,
   4.040145211785965e-10,  -1.986634535048345e-11,   9.186559872919396e-13,  -4.035914616094815e-14,   1.695381447752565e-15,  -6.824458886233981e-17,   2.639854222018283e-18,
  -9.842426573228470e-20,   3.535385447234636e-21,  -1.468564313748293e-01,   3.328392095355614e-02,  -4.504531732484098e-03,   4.578663263716211e-04,  -3.813674161925564e-05,
   2.722954560246209e-06,  -1.712607296504942e-07,   9.662061086864855e-09,  -4.953394687505943e-10,   2.330483676193191e-11,  -1.014267580722475e-12,   4.110746230381932e-14,
  -1.560533369545181e-15,   5.571536699893819e-17,  -1.398574941755497e-01,   3.170740860456336e-02,  -4.292423433152140e-03,   4.364240422954336e-04,  -3.635974426113199e-05,
   2.596661522922801e-06,  -1.633508336869326e-07,   9.217510645902255e-09,  -4.726285105476223e-10,   2.223976849514849e-11,  -9.680535953813271e-13,   3.923981030658449e-14,
  -1.489828248358255e-15,   5.319764783940029e-17,  -1.264864281619912e-01,   2.869156601262839e-02,  -3.886146793064340e-03,   3.953042517372322e-04,  -3.294826182483161e-05,
   2.353959640294485e-06,  -1.481361146500824e-07,   8.361698513763399e-09,  -4.288736473736188e-10,   2.018635484990890e-11,  -8.788954526509755e-13,   3.563437056547782e-14,
  -1.353251206191871e-15,   4.833147236792099e-17,  -1.079693918441463e-01,   2.450728071741450e-02,  -3.321462549029998e-03,   3.380572976527486e-04,  -2.819155431817756e-05,
   2.015082115108445e-06,  -1.268651929313163e-07,   7.163843991023429e-09,  -3.675663567649111e-10,   1.730639189027373e-11,  -7.537345230816550e-13,   3.056862041574529e-14,
  -1.161195781605857e-15,   4.148314524152243e-17,  -8.605734831772982e-02,   1.954599814719473e-02,  -2.650653413333150e-03,   2.699321685966906e-04,  -2.252182857971360e-05,
   1.610563221203209e-06,  -1.014399550381969e-07,   5.730295654641126e-09,  -2.941143264902477e-10,   1.385237789925297e-11,  -6.034818359936616e-13,   2.448177159360852e-14,
  -9.302260994987535e-16,   3.324032735111810e-17,  -6.288298841149104e-02,   1.428975036626338e-02,  -1.938784221262556e-03,   1.975261694566911e-04,  -1.648734007703463e-05,
   1.179466523382366e-06,  -7.431262104304477e-08,   4.199159911325144e-09,  -2.155864622872046e-10,   1.015639998771682e-11,  -4.425703284362561e-13,   1.795800518066851e-14,
  -6.824907664213627e-16,   2.439282420154979e-17,  -4.074819684745573e-02,   9.262881991625449e-03,  -1.257156555531594e-03,   1.281185863679324e-04,  -1.069682186744490e-05,
   7.654130037717737e-07,  -4.823572351152186e-08,   2.726186060879668e-09,  -1.399888843587181e-10,   6.596057134304918e-12,  -2.874712928998488e-13,   1.166632975163880e-14,
  -4.434392734686377e-16,   1.585103809731318e-17,  -2.187112494823043e-02,   4.972604592587909e-03,  -6.749912978013222e-04,   6.879967861152059e-05,  -5.744984654727005e-06,
   4.111348819979700e-07,  -2.591233227916347e-08,   1.464663052085239e-09,  -7.521704555152143e-11,   3.544412891828218e-12,  -1.544859583753251e-13,   6.269913578727679e-15,
  -2.383377450578999e-16,   8.520129947745768e-18,  -8.140490558455980e-03,   1.850927906397979e-03,  -2.512629519900882e-04,   2.561176255334821e-05,  -2.138763407417479e-06,
   1.530654285041667e-07,  -9.647536005121590e-09,   5.453346772683238e-10,  -2.800630011178094e-11,   1.319765295759156e-12,  -5.752457912324684e-14,   2.334733906196810e-15,
  -8.875228985885332e-17,   3.172804640692607e-18,  -9.195612755407611e-04,   2.090854178973079e-04,  -2.838354393184830e-05,   2.893218558590871e-06,  -2.416060598549353e-07,
   1.729120223526627e-08,  -1.089851189155335e-09,   6.160505730111280e-11,  -3.163816034877590e-12,   1.490919653218953e-13,  -6.498496595334340e-15,   2.637537507660448e-16,
  -1.002634284043852e-17,   3.584329786795547e-19,  -2.819124372557975e-01,   9.292002938746645e-02,  -1.695820359905192e-02,   2.186634547718702e-03,  -2.203476352162608e-04,
   1.833073369470817e-05,  -1.302815982650255e-06,   8.098425938229956e-08,  -4.478549689151696e-09,   2.232205058643379e-10,  -1.013098802658506e-11,   4.222155419000659e-13,
  -1.627202706451424e-14,   5.828352197282988e-16,  -2.687642164229060e-01,   8.860616616167512e-02,  -1.617411365776562e-02,   2.085884961895251e-03,  -2.102254567579034e-04,
   1.749083337372701e-05,  -1.243254111736708e-06,   7.728892375068404e-08,  -4.274531982296178e-09,   2.130666473861624e-10,  -9.670746250055066e-12,   4.030571492519535e-13,
  -1.553446904124470e-14,   5.564439103448223e-16,  -2.435274359742695e-01,   8.031779671683834e-02,  -1.466627044420810e-02,   1.891989936188320e-03,  -1.907322500841233e-04,
   1.587244427945616e-05,  -1.128429342113390e-06,   7.016195909680398e-08,  -3.880911129253757e-09,   1.934700249432002e-10,  -8.782239998159778e-12,   3.660618882568996e-13,
  -1.410988782823268e-14,   5.054581148670859e-16,  -2.083492611450473e-01,   6.874835403110931e-02,  -1.255892464874503e-02,   1.620716982831453e-03,  -1.634350812420937e-04,
   1.360437570564008e-05,  -9.674015574977823e-07,   6.016144637677363e-08,  -3.328305756786430e-09,   1.659460930908053e-10,  -7.533820506143116e-12,   3.140621988662983e-13,
  -1.210687086213188e-14,   4.337480647985477e-16,  -1.664315128840206e-01,   5.494212973723529e-02,  -1.004087951221793e-02,   1.296214231147019e-03,  -1.307504265321526e-04,
   1.088644712503420e-05,  -7.742987113441637e-07,   4.816163534080487e-08,  -2.664873295216516e-09,   1.328868355983184e-10,  -6.033715459858685e-12,   2.515559562866935e-13,
  -9.698317097383597e-15,   3.474917386610705e-16,  -1.218286907214464e-01,   4.023274847128541e-02,  -7.355077787630238e-03,   9.497577566429525e-04,  -9.582569844227132e-05,
   7.980185720377140e-06,  -5.676895063681549e-07,   3.531576541553968e-08,  -1.954341091066852e-09,   9.746643802136450e-11,  -4.425901339192752e-12,   1.845402356436944e-13,
  -7.115236212679814e-15,   2.549596408410841e-16,  -7.903729051025354e-02,   2.610764724840176e-02,  -4.773845891284195e-03,   6.165571979865744e-04,  -6.221716522557871e-05,
   5.182020538904094e-06,  -3.686775530791910e-07,   2.293756333704903e-08,  -1.269451579346183e-09,   6.331452320010947e-11,  -2.875270964605253e-12,   1.198930912688498e-13,
  -4.622920385718192e-15,   1.656612406831378e-16,  -4.244778442945973e-02,   1.402312627354092e-02,  -2.564444026198194e-03,   3.312370412518080e-04,  -3.342800361061111e-05,
   2.784383313919726e-06,  -1.981080180797523e-07,   1.232606858093751e-08,  -6.822011638831240e-10,   3.402642251724810e-11,  -1.545277513749967e-12,   6.443698372148944e-14,
  -2.484675951037814e-15,   8.904011562283797e-17,  -1.580247200258683e-02,   5.220759313530303e-03,  -9.547697423431754e-04,   1.233270864196852e-04,  -1.244635202358472e-05,
   1.036742683962400e-06,  -7.376542753835038e-08,   4.589686473241397e-09,  -2.540256125840132e-10,   1.267030662386883e-11,  -5.754166839851068e-13,   2.399472658019301e-14,
  -9.252404994675614e-16,   3.315695031049739e-17,  -1.785128540283458e-03,   5.897678882825696e-04,  -1.078570979161007e-04,   1.393191448052891e-05,  -1.406035618153188e-06,
   1.171188659375745e-07,  -8.333168193615914e-09,   5.184913474138657e-10,  -2.869703649712430e-11,   1.431355743985521e-12,  -6.500454517130216e-14,   2.710677276864741e-15,
  -1.045243131158162e-16,   3.745742326626809e-18,  -2.230932339602762e-01,   8.772246900194719e-02,  -1.853363966060302e-02,   2.684970657663337e-03,  -2.967320169339685e-04,
   2.655612077268447e-05,  -1.999331033974049e-06,   1.300128757764003e-07,  -7.445133408689716e-09,   3.810312101676840e-10,  -1.763201064497050e-11,   7.446666898943112e-13,
  -2.892461689474562e-14,   1.038786764056051e-15,  -2.128739876220694e-01,   8.371074337471544e-02,  -1.768732907485225e-02,   2.562524081923157e-03,  -2.832147935728515e-04,
   2.534756067027559e-05,  -1.908418802214072e-06,   1.241053850723540e-07,  -7.107062697728252e-09,   3.637390219922361e-10,  -1.683221282113433e-11,   7.109019157468507e-13,
  -2.761354190047521e-14,   9.917132144817946e-16,  -1.931815235150877e-01,   7.597736257305170e-02,  -1.605536116177244e-02,   2.326338970084041e-03,  -2.571352343014764e-04,
   2.301531829482747e-05,  -1.732946471346372e-06,   1.127013028451153e-07,  -6.454342353882599e-09,   3.303484434840839e-10,  -1.528766640171979e-11,   6.456904856211748e-13,
  -2.508121996803631e-14,   9.007862716050441e-16,  -1.655815476879185e-01,   6.513324767313035e-02,  -1.376589628585692e-02,   1.994868042542992e-03,  -2.205218318174817e-04,
   1.974009542633029e-05,  -1.486463490072945e-06,   9.667858892378823e-08,  -5.537090892498428e-09,   2.834174411762106e-10,  -1.311646069201103e-11,   5.540099023236401e-13,
  -2.152068108979526e-14,   7.729298184157912e-16,  -1.325044690211085e-01,   5.213038768963935e-02,  -1.101935789314287e-02,   1.597058149414033e-03,  -1.765652548877730e-04,
   1.580678940699939e-05,  -1.190376091715941e-06,   7.742681095531597e-08,  -4.434758756770075e-09,   2.270067066089924e-10,  -1.050628481269600e-11,   4.437793269646850e-13,
  -1.723928486961232e-14,   6.191756181340619e-16,  -9.713284940982646e-02,   3.821926664621865e-02,  -8.079762924085807e-03,   1.171134916211352e-03,  -1.294878963166903e-04,
   1.159311786730149e-05,  -8.731105550189816e-07,   5.679385382983664e-08,  -3.253132948940417e-09,   1.665288684259852e-10,  -7.707549755359230e-12,   3.255726130789365e-13,
  -1.264768388461012e-14,   4.542699883786526e-16,  -6.307510732349988e-02,   2.482052352394814e-02,  -5.247600040118928e-03,   7.606728375074292e-04,  -8.410948672869248e-05,
   7.530738137379624e-06,  -5.671856821541798e-07,   3.689553050968095e-08,  -2.113433582231403e-09,   1.081904285600728e-10,  -5.007562557462146e-12,   2.115275188165067e-13,
  -8.217452782885699e-15,   2.951520561709519e-16,  -3.389150223707344e-02,   1.333713571139225e-02,  -2.819872889507070e-03,   4.087723426898351e-04,  -4.520029788937518e-05,
   4.047108688273331e-06,  -3.048190974386127e-07,   1.982892057188311e-08,  -1.135850775871068e-09,   5.814708228861055e-11,  -2.691354885012974e-12,   1.136883725575118e-13,
  -4.416620468397242e-15,   1.586359156272526e-16,  -1.261925721829379e-02,   4.966061390962962e-03,  -1.049989645800040e-03,   1.522096299842231e-04,  -1.683086145598228e-05,
   1.507001701747764e-06,  -1.135048404256228e-07,   7.383702722120751e-09,  -4.229596792180483e-10,   2.165248993159274e-11,  -1.002196304820958e-12,   4.233499122239503e-14,
  -1.644654916026233e-15,   5.907275348830102e-17,  -1.425574219830557e-03,   5.610081388641574e-04,  -1.186159363054694e-04,   1.719495211927725e-05,  -1.901366715938246e-06,
   1.702448142193765e-07,  -1.282256946779200e-08,   8.341330794292528e-10,  -4.778158096937287e-11,   2.446074871731928e-12,  -1.132178754876437e-13,   4.782576561983951e-15,
  -1.857964655385892e-16,   6.673444175079807e-18,  -2.613742953026954e-02,   2.326624490732721e-03,  -1.549658415784535e-04,   8.803222010404716e-06,  -4.486002360142063e-07,
   2.102783523236693e-08,  -9.234497349849986e-10,   3.830157889780181e-11,  -1.507610356852944e-12,   5.719753049945165e-14,  -2.099318938324632e-15,   7.413096236356087e-17,
  -2.531863137597773e-18,   8.406591011005334e-20,  -2.487082282654836e-02,   2.214254025030261e-03,  -1.475092924712579e-04,   8.381356486904888e-06,  -4.271968598595068e-07,
   2.002924018829268e-08,  -8.798041907398340e-10,   3.650064414937970e-11,  -1.437129659807600e-12,   5.453855179254336e-14,  -2.002259294536010e-15,   7.072385011065208e-17,
  -2.416203894720966e-18,   8.024752099753900e-20,  -2.245967614012361e-02,   2.000189432501806e-03,  -1.332932594694500e-04,   7.576359480946791e-06,  -3.863166546654722e-07,
   1.812001558509307e-08,  -7.962720238067538e-10,   3.305002083709704e-11,  -1.301918533093362e-12,   4.943128466749651e-14,  -1.815608180205464e-15,   6.416328218137154e-17,
  -2.193197928878753e-18,   7.287591346234119e-20,  -1.913729596401159e-02,   1.704927221520722e-03,  -1.136628033325881e-04,   6.463400436995902e-06,  -3.297222634692488e-07,
   1.547316962899733e-08,  -6.803011344495217e-10,   2.825190978225689e-11,  -1.113579510367938e-12,   4.230513865269113e-14,  -1.554743509097033e-15,   5.497773853587860e-17,
  -1.880387235763915e-18,   6.251784342867437e-20,  -1.522688744460970e-02,   1.357030000728591e-03,  -9.050493755164899e-05,   5.148724427464618e-06,  -2.627756255772834e-07,
   1.233745075642771e-08,  -5.426998343658125e-10,   2.254941692955778e-11,  -8.893276603974531e-13,   3.380487932488434e-14,  -1.243032602111504e-15,   4.398105069363895e-17,
  -1.505171909858727e-18,   5.007082766204508e-20,  -1.111083805235796e-02,   9.904861913265514e-04,  -6.607975539965930e-05,   3.760490671788291e-06,  -1.919948227498552e-07,
   9.017753231230417e-09,  -3.968290663438604e-10,   1.649541678717520e-11,  -6.508683860934502e-13,   2.475188094921994e-14,  -9.105465355974971e-16,   3.223219640936073e-17,
  -1.103618711994477e-18,   3.672922668111153e-20,  -7.193153285689364e-03,   6.413607810279270e-04,  -4.279697135605551e-05,   2.436056543770422e-06,  -1.244049764360015e-07,
   5.844640816584756e-09,  -2.572620758228994e-10,   1.069688068666648e-11,  -4.222029014194919e-13,   1.606077392836607e-14,  -5.909983102184521e-16,   2.092709220100674e-17,
  -7.167628579849590e-19,   2.386140624745555e-20,  -3.859004065304291e-03,   3.441122742094646e-04,  -2.296451845492734e-05,   1.307320627087500e-06,  -6.677080409186726e-08,
   3.137355873667391e-09,  -1.381146137997666e-10,   5.743589586558420e-12,  -2.267338163703548e-13,   8.626375462432738e-15,  -3.174772938102836e-16,   1.124357665005920e-17,
  -3.851603271821697e-19,   1.282412073162075e-20,  -1.436093488280902e-03,   1.280625675874970e-04,  -8.546643390262578e-06,   4.865616877703541e-07,  -2.485199345798871e-08,
   1.167772597429136e-09,  -5.141079025722384e-11,   2.138059326970307e-12,  -8.440663732454960e-14,   3.211529364064691e-15,  -1.182003227607075e-16,   4.186340359261549e-18,
  -1.434155026182710e-19,   4.775346952509299e-21,  -1.622188761138040e-04,   1.446582448042107e-05,  -9.654263325654960e-07,   5.496221820039174e-08,  -2.807311217340170e-09,
   1.319139617376156e-10,  -5.807509923334486e-12,   2.415232126662557e-13,  -9.534974227861436e-15,   3.627926745750676e-16,  -1.335269216330418e-17,   4.729209198293687e-19,
  -1.620145345934350e-20,   5.394689123783579e-22,  -6.157734981268295e-02,   1.189346669472337e-02,  -1.406569095912218e-03,   1.275261353533209e-04,  -9.628758881628148e-06,
   6.314740137642729e-07,  -3.688377810651430e-08,   1.950776419184780e-09,  -9.451421915781084e-11,   4.230156348690973e-12,  -1.760736499448754e-13,   6.853632093081629e-15,
  -2.506463490452866e-16,   8.639926123483874e-18,  -5.862661235533888e-02,   1.132670661771960e-02,  -1.339911677177366e-03,   1.215147773314545e-04,  -9.177168303144400e-06,
   6.019985911889773e-07,  -3.516979282415552e-08,   1.860496148020604e-09,  -9.015667858560137e-11,   4.035803471513180e-12,  -1.680099094800265e-13,   6.540686026003077e-15,
  -2.392336820246569e-16,   8.247591597859939e-18,  -5.299600643345673e-02,   1.024391698355289e-02,  -1.212411221135720e-03,   1.100031592358992e-04,  -8.311432133222693e-06,
   5.454331890844063e-07,  -3.187734194749887e-08,   1.686917864072591e-09,  -8.177167421175267e-11,   3.661534347452636e-12,  -1.524704654667880e-13,   5.937219795001466e-15,
  -2.172125338842606e-16,   7.490114722234184e-18,  -4.521122309638052e-02,   8.744354917687302e-03,  -1.035540100223763e-03,   9.400831704089110e-05,  -7.106692347162410e-06,
   4.666045191182028e-07,  -2.728285316606028e-08,   1.444394347695190e-09,  -7.004273768381409e-11,   3.137455461034649e-12,  -1.306898543909266e-13,   5.090617191645717e-15,
  -1.862926872614448e-16,   6.425666971169005e-18,  -3.601533768505519e-02,   6.969792308963508e-03,  -8.258599484164741e-04,   7.501399439894175e-05,  -5.673704971649623e-06,
   3.726979040594111e-07,  -2.180175967487954e-08,   1.154690513370956e-09,  -5.601517108299609e-11,   2.509973514560706e-12,  -1.045852180285070e-13,   4.074980612492858e-15,
  -1.491661497039280e-16,   5.146445768984172e-18,  -2.630477367141783e-02,   5.092942935226399e-03,  -6.037462365854903e-04,   5.486312290845955e-05,  -4.151302627741746e-06,
   2.727987148110959e-07,  -1.596366126458462e-08,   8.457645512095535e-10,  -4.104120764612800e-11,   1.839514189090673e-12,  -7.666798958414701e-14,   2.987933288562098e-15,
  -1.093984926714050e-16,   3.775203998713577e-18,  -1.704036589669963e-02,   3.300247292926313e-03,  -3.913483583022382e-04,   3.557255977700778e-05,  -2.692386096563108e-06,
   1.769725335915610e-07,  -1.035854168774181e-08,   5.489209227852006e-10,  -2.664197859867472e-11,   1.194340690013582e-12,  -4.978648382164620e-14,   1.940596183352163e-15,
  -7.106219824077278e-17,   2.452608762756765e-18,  -9.144804918758576e-03,   1.771374781885851e-03,  -2.100849463857916e-04,   1.909901372998198e-05,  -1.445752259480597e-06,
   9.504278190270857e-08,  -5.563710027160238e-09,   2.948654909265444e-10,  -1.431280472826310e-11,   6.416923503547293e-13,  -2.675143860392177e-14,   1.042809896673937e-15,
  -3.818923048198921e-17,   1.318140106755035e-18,  -3.403537299964318e-03,   6.593110362074935e-04,  -7.819847617930780e-05,   7.109461480441812e-06,  -5.381963743225817e-07,
   3.538227570024085e-08,  -2.071330522702542e-09,   1.097806160842941e-10,  -5.328951908374948e-12,   2.389229967347584e-13,  -9.960728856759849e-15,   3.882943242521915e-16,
  -1.422027636216507e-17,   4.908394866031280e-19,  -3.844650805113343e-04,   7.447671473982654e-05,  -8.833487110495201e-06,   8.031083669484450e-07,  -6.079691803356148e-08,
   3.996958967116442e-09,  -2.339894276529505e-10,   1.240152687718545e-11,  -6.019961720342205e-13,   2.699057326970229e-14,  -1.125245585842983e-15,   4.386510098335167e-17,
  -1.606452576641627e-18,   5.544993961801297e-20,  -7.359529360368856e-02,   2.201030987193990e-02,  -3.708465663962654e-03,   4.481183114466429e-04,  -4.280644893488704e-05,
   3.406138857076635e-06,  -2.332118946359466e-07,   1.404640480865540e-08,  -7.562324456934229e-10,   3.683768540803793e-11,  -1.639166227782715e-12,   6.714417611173960e-14,
  -2.548285096434323e-15,   9.001074627779244e-17,  -7.013745789488247e-02,   2.098168669567565e-02,  -3.535980937520479e-03,   4.273619341195997e-04,  -4.083079497369248e-05,
   3.249422636382687e-06,  -2.225107472115139e-07,   1.340338157267096e-08,  -7.216837473126550e-10,   3.515772791557929e-11,  -1.564528884831885e-12,   6.409101709333256e-14,
  -2.432551310185247e-15,   8.592732582472435e-17,  -6.351109642561319e-02,   1.900820765119051e-02,  -3.204713263092188e-03,   3.874619356772489e-04,  -3.703001004775927e-05,
   2.947724494453661e-06,  -2.018974898577526e-07,   1.216410840772553e-08,  -6.550695017841211e-10,   3.191729036816301e-11,  -1.420513116610025e-12,   5.819804933662492e-14,
  -2.209110936789762e-15,   7.804177242407578e-17,  -5.429500424036492e-02,   1.625900471878804e-02,  -2.742565692385423e-03,   3.317281416864782e-04,  -3.171516443493748e-05,
   2.525445874419642e-06,  -1.730220666627309e-07,   1.042687751078153e-08,  -5.616309476632881e-10,   2.736954210263076e-11,  -1.218301092181046e-12,   4.992033011193935e-14,
  -1.895133243695759e-15,   6.695728238913894e-17,  -4.333915409603284e-02,   1.298521622527629e-02,  -2.191392954165773e-03,   2.651702273009306e-04,  -2.536085425934479e-05,
   2.020078761557639e-06,  -1.384353562495778e-07,   8.344486685191983e-09,  -4.495550867783540e-10,   2.191162328303008e-11,  -9.754996901055313e-13,   3.997675021468073e-14,
  -1.517822971027927e-15,   5.363224279492726e-17,  -3.170552411826734e-02,   9.503688390045749e-03,  -1.604465023169271e-03,   1.942131290757149e-04,  -1.857982505052553e-05,
   1.480311010623978e-06,  -1.014668372997859e-07,   6.117257254054327e-09,  -3.296168321482607e-10,   1.606797779194334e-11,  -7.154285549050955e-13,   2.932194118339251e-14,
  -1.113390425530096e-15,   3.934502214214685e-17,  -2.056109681132852e-02,   6.164925252810803e-03,  -1.041060455169865e-03,   1.260430941417755e-04,  -1.206045578846682e-05,
   9.610489089433064e-07,  -6.588362830885344e-08,   3.972489960905673e-09,  -2.140726040942772e-10,   1.043644429060988e-11,  -4.647208255026234e-13,   1.904797974584092e-14,
  -7.233204662210953e-16,   2.556217063642322e-17,  -1.104031561950539e-02,   3.310752918263727e-03,  -5.591538838781351e-04,   6.770535826995373e-05,  -6.479023409657623e-06,
   5.163300603613417e-07,  -3.539896946635749e-08,   2.134533190597984e-09,  -1.150335662415694e-10,   5.608366058718131e-12,  -2.497431684707923e-13,   1.023684069871997e-14,
  -3.887421620732349e-16,   1.373856136670380e-17,  -4.109802566638958e-03,   1.232504217175079e-03,  -2.081673532642472e-04,   2.520700304681750e-05,  -2.412249772463395e-06,
   1.922439519995198e-07,  -1.318034385212083e-08,   7.947827255514263e-10,  -4.283297332556040e-11,   2.088320008825490e-12,  -9.299518541336947e-14,   3.811871009011954e-15,
  -1.447567147433858e-16,   5.115907975027861e-18,  -4.642592640972922e-04,   1.392295923534972e-04,  -2.351575206467177e-05,   2.847542056363463e-06,  -2.725043980070796e-07,
   2.171730439570377e-08,  -1.488955415842289e-09,   8.978522214985712e-11,  -4.838780870520329e-12,   2.359151881944911e-13,  -1.050558624152251e-14,   4.306246445946441e-16,
  -1.635310283955496e-17,   5.779428169361871e-19,  -4.107302412026853e-02,   1.567160281029052e-02,  -3.225289726001939e-03,   4.571423025178667e-04,  -4.960448250556368e-05,
   4.371032449357584e-06,  -3.247399826872429e-07,   2.087610905020893e-08,  -1.183554650711479e-09,   6.004405428819897e-11,  -2.757290697257013e-12,   1.156805864480985e-13,
  -4.468122057783962e-15,   1.597325982678070e-16,  -3.918464542828466e-02,   1.495267767966895e-02,  -3.077622751841075e-03,   4.362473681856489e-04,  -4.734038623140706e-05,
   4.171767499591749e-06,  -3.099513763296766e-07,   1.992628291644573e-08,  -1.129748218367185e-09,   5.731628347329537e-11,  -2.632106922303355e-12,   1.104314636838416e-13,
  -4.265472781739892e-15,   1.524908703182495e-16,  -3.554869302504327e-02,   1.356775826416574e-02,  -2.793037313068360e-03,   3.959635949284682e-04,  -4.297402331040966e-05,
   3.787377397488658e-06,  -2.814169530301960e-07,   1.809323566862101e-08,  -1.025890014485390e-09,   5.205026232942836e-11,  -2.390403372357209e-12,   1.002952749762489e-13,
  -3.874110724841263e-15,   1.385042143992677e-16,  -3.045841394803730e-02,   1.162758846010650e-02,  -2.394115786106400e-03,   3.394666542569689e-04,  -3.684767845661952e-05,
   3.247849663063920e-06,  -2.413534514810309e-07,   1.551884795974827e-08,  -8.799928153056823e-10,   4.465110494147255e-11,  -2.050726941350764e-12,   8.604806758261688e-14,
  -3.323941307233895e-15,   1.188396774510369e-16,  -2.436513522129195e-02,   9.303485603190121e-03,  -1.915953693576763e-03,   2.717113938191447e-04,  -2.949720899298065e-05,
   2.600267667129646e-06,  -1.932501996266515e-07,   1.242694803012154e-08,  -7.047222311754266e-10,   3.576028073994651e-11,  -1.642490726248755e-12,   6.892223508638068e-14,
  -2.662511536907297e-15,   9.519544019401241e-17,  -1.785576883881495e-02,   6.819164269500562e-03,  -1.404551414105160e-03,   1.992128144408915e-04,  -2.162910105422741e-05,
   1.906850888935899e-06,  -1.417274971416669e-07,   9.114430602461764e-09,  -5.169042941468882e-10,   2.623113041339834e-11,  -1.204869855893266e-12,   5.056093478520912e-14,
  -1.953274072436167e-15,   6.983949015571002e-17,  -1.159277909564060e-02,   4.427820544879685e-03,  -9.120963393623379e-04,   1.293771912853064e-04,  -1.404787352554386e-05,
   1.238556782691431e-06,  -9.206120601126031e-08,   5.920691249010567e-09,  -3.357923893687983e-10,   1.704093630738068e-11,  -7.827633522095727e-13,   3.284865776206719e-14,
  -1.269042613169007e-15,   4.537564139225420e-17,  -6.228420462648920e-03,   2.379062859200744e-03,  -4.900938707707255e-04,   6.952090640855471e-05,  -7.548914756061882e-06,
   6.655853007417585e-07,  -4.947393153109967e-08,   3.181871173124958e-09,  -1.804638273158841e-10,   9.158425767903277e-12,  -4.206927036952400e-13,   1.765461967410532e-14,
  -6.820595799839278e-16,   2.438784001262957e-17,  -2.319028752611922e-03,   8.858149565060864e-04,  -1.824837676144116e-04,   2.588612543075686e-05,  -2.810876650274084e-06,
   2.478368097489366e-07,  -1.842224997246883e-08,   1.184820227415251e-09,  -6.719906156748843e-11,   3.410332129936023e-12,  -1.566546540172623e-13,   6.574138632886438e-15,
  -2.539830135182569e-16,   9.081492812289245e-18,  -2.619749895097277e-04,   1.000686673310222e-04,  -2.061486977054851e-05,   2.924317101305286e-06,  -3.175412101564551e-07,
   2.799786289945125e-08,  -2.081145303495086e-09,   1.338482713229178e-10,  -7.591437463173702e-12,   3.852635586182797e-13,  -1.769721591280861e-14,   7.426784973045273e-16,
  -2.869240549344623e-17,   1.025934836895521e-18,  -1.877950253391214e-02,   1.413054069393840e-03,  -8.161121255134439e-05,   4.072156433813732e-06,  -1.845998421052086e-07,
   7.732055326672410e-09,  -3.037755753304172e-10,   1.153636878154131e-11,  -4.125715403791413e-13,   1.397449989282740e-14,  -4.703815354661331e-16,   1.541772317874381e-17,
  -4.826134138668785e-19,   1.464126158131224e-20,  -1.786853663697536e-02,   1.344690310113102e-03,  -7.767487977468549e-05,   3.876406532639397e-06,  -1.757576441706162e-07,
   7.363239514376312e-09,  -2.893469283974900e-10,   1.099036872308899e-11,  -3.931410900930400e-13,   1.332031811608778e-14,  -4.484625148645295e-16,   1.470231810401782e-17,
  -4.603459615429249e-19,   1.397053977092362e-20,  -1.613477187892367e-02,   1.214505572835808e-03,  -7.017404440889106e-05,   3.503127714834582e-06,  -1.588833997268680e-07,
   6.658766941678412e-09,  -2.617616778736352e-10,   9.945702555240363e-12,  -3.559250043077832e-13,   1.206568789517780e-14,  -4.063829917446482e-16,   1.332764186250840e-17,
  -4.175052013399832e-19,   1.267808983126630e-20,  -1.374650005754792e-02,   1.035032194428570e-03,  -5.982384905516899e-05,   2.987527187931596e-06,  -1.355503950654443e-07,
   5.683423961974880e-09,  -2.235210129563867e-10,   8.495953994654825e-12,  -3.042010522846649e-13,   1.031878416784759e-14,  -3.477117482004073e-16,   1.140848910452407e-17,
  -3.575935771371843e-19,   1.086670465371838e-20,  -1.093644826337955e-02,   8.236817078368224e-04,  -4.762326940945085e-05,   2.379085857852041e-06,  -1.079842619018942e-07,
   4.529578839205097e-09,  -1.782199161453522e-10,   6.776563961451917e-12,  -2.427597039538409e-13,   8.239670006833991e-15,  -2.777803564960812e-16,   9.117913246588975e-18,
  -2.859575762774071e-19,   8.695904576970522e-21,  -7.979479980094809e-03,   6.011121613321667e-04,  -3.476382082581023e-05,   1.737168539720069e-06,  -7.887189779953774e-08,
   3.309565806567387e-09,  -1.302634056949778e-10,   4.954549581554761e-12,  -1.775607374794668e-13,   6.029667800155829e-15,  -2.033511300842013e-16,   6.677124949935383e-18,
  -2.095038197763629e-19,   6.374548200406570e-21,  -5.165619003976761e-03,   3.891956070015357e-04,  -2.251199870125426e-05,   1.125149237296710e-06,  -5.109475606172057e-08,
   2.144494852740828e-09,  -8.442623796750586e-11,   3.211767012373216e-12,  -1.151337745642764e-13,   3.911017884672608e-15,  -1.319318209002928e-16,   4.333021400113864e-18,
  -1.359949007858671e-19,   4.139432836179843e-21,  -2.771185494003646e-03,   2.088066612751102e-04,  -1.207893227401987e-05,   6.037630543829835e-07,  -2.742059163253648e-08,
   1.151003923295678e-09,  -4.531908050174308e-11,   1.724214324440722e-12,  -6.181721796849811e-14,   2.100238618692881e-15,  -7.085704934091648e-17,   2.327420361101590e-18,
  -7.305886762712088e-20,   2.224198262246773e-21,  -1.031261144608291e-03,   7.770678853574555e-05,  -4.495276487162259e-06,   2.247030585973835e-07,  -1.020550769256523e-08,
   4.284029481011816e-10,  -1.686843460964710e-11,   6.418005757111484e-13,  -2.301118642119088e-14,   7.818497190748591e-16,  -2.637890281736087e-17,   8.664950036138698e-19,
  -2.720114808231585e-20,   8.281641428082175e-22,  -1.164894591497423e-04,   8.777660275653110e-06,  -5.077831890553899e-07,   2.538243068457556e-08,  -1.152819394000386e-09,
   4.839293286001775e-11,  -1.905492035596521e-12,   7.249947540582570e-14,  -2.599423597875269e-15,   8.832127128542092e-17,  -2.979900567477579e-18,   9.788449296915779e-20,
  -3.072831362139493e-21,   9.355617466673372e-23,  -2.955355866772716e-02,   4.862800185358915e-03,  -5.005484595750329e-04,   4.024727968258523e-05,  -2.735424803736946e-06,
   1.635424209050042e-07,  -8.801535966713696e-09,   4.327349254308720e-10,  -1.965894578507932e-11,   8.313334371846680e-13,  -3.289122853181511e-14,   1.223531146445425e-15,
  -4.296301241866038e-17,   1.426972139067518e-18,  -2.813167774792637e-02,   4.629956680302377e-03,  -4.766993198672647e-04,   3.833910500564256e-05,  -2.606361636905792e-06,
   1.558621003538507e-07,  -8.390047937382477e-09,   4.125903405336638e-10,  -1.874743378304121e-11,   7.929301829646696e-13,  -3.137707912293381e-14,   1.167385975228279e-15,
  -4.099733786459419e-17,   1.361863107857781e-18,  -2.542077526521625e-02,   4.185570706100373e-03,  -4.311342802068991e-04,   3.468955086324810e-05,  -2.359258109094938e-06,
   1.411425119552156e-07,  -7.600647678012601e-09,   3.739087771883723e-10,  -1.699562533131271e-11,   7.190642389676220e-13,  -2.846250844890692e-14,   1.059236682312351e-15,
  -3.720851466491598e-17,   1.236290177106539e-18,  -2.167725425171612e-02,   3.571028138239638e-03,  -3.680281256257431e-04,   2.962749799313011e-05,  -2.016015833325456e-06,
   1.206672218882538e-07,  -6.501082594654312e-09,   3.199588573465844e-10,  -1.454939104633261e-11,   6.158016942098141e-13,  -2.438374341888584e-14,   9.077413346042182e-16,
  -3.189639317818314e-17,   1.060084170157442e-18,  -1.726089774502100e-02,   2.844912134538352e-03,  -2.933455635507566e-04,   2.362731417522615e-05,  -1.608527854542791e-06,
   9.632305036305700e-08,  -5.191868460824578e-09,   2.556343661914819e-10,  -1.162902244324895e-11,   4.923787260640326e-13,  -1.950327800960451e-14,   7.262838955368868e-16,
  -2.552769370971182e-17,   8.486466773084845e-19,  -1.260270456798767e-02,   2.077990431709751e-03,  -2.143550118590937e-04,   1.727214068795937e-05,  -1.176341754840621e-06,
   7.046946305698371e-08,  -3.799730302206958e-09,   1.871537789646448e-10,  -8.516510776687377e-12,   3.607000416739251e-13,  -1.429137223319114e-14,   5.323321260849555e-16,
  -1.871494920871316e-17,   6.222966482236190e-19,  -8.162274043127549e-03,   1.346189195934768e-03,  -1.389039795247801e-04,   1.119552632578404e-05,  -7.626865832053425e-07,
   4.570070975775447e-08,  -2.464785856544024e-09,   1.214294689893220e-10,  -5.526865540632819e-12,   2.341251212911166e-13,  -9.278001074365146e-15,   3.456492181535993e-16,
  -1.215368422557803e-17,   4.041832545171699e-19,  -4.379826687313047e-03,   7.224552852242208e-04,  -7.455561997141506e-05,   6.009943908998558e-06,  -4.094780578060961e-07,
   2.453938055764756e-08,  -1.323650768744447e-09,   6.521824825282337e-11,  -2.968731742259791e-12,   1.257718528441522e-13,  -4.984598550454822e-15,   1.857156334514806e-16,
  -6.530626734337888e-18,   2.171984791203568e-19,  -1.630030272678552e-03,   2.688873009789372e-04,  -2.774986485929247e-05,   2.237030239184257e-06,  -1.524236890386203e-07,
   9.134924344885361e-09,  -4.927576913704166e-10,   2.427989473033336e-11,  -1.105261345299259e-12,   4.682659444534145e-14,  -1.855894675516038e-15,   6.914877811159342e-17,
  -2.431659386860888e-18,   8.087524894408367e-20,  -1.841277758310492e-04,   3.037366464890147e-05,  -3.134664987306409e-06,   2.527001149444870e-07,  -1.721826111724868e-08,
   1.031917254158614e-09,  -5.566424051975953e-11,   2.742789509404901e-12,  -1.248571037784077e-13,   5.289848609815289e-15,  -2.096554805866387e-16,   7.811590201453380e-18,
  -2.747005697744224e-19,   9.136380745188312e-21,  -2.231045933123845e-02,   5.918037746870704e-03,  -9.035197075034478e-04,   1.007812731662491e-04,  -9.010631484639817e-06,
   6.784114945366681e-07,  -4.433569993786692e-08,   2.566886850070850e-09,  -1.336214165942010e-10,   6.324285195685638e-12,  -2.745472880798969e-13,   1.100965515226062e-14,
  -4.102255724027131e-16,   1.425859675604284e-17,  -2.125456962725963e-02,   5.639568201189489e-03,  -8.612289590272683e-04,   9.608596730980815e-05,  -8.592557942565032e-06,
   6.470484903879730e-07,  -4.229257707089707e-08,   2.448927854129343e-09,  -1.274960445112827e-10,   6.034996668659650e-12,  -2.620125175293466e-13,   1.050782673565590e-14,
  -3.915542150007223e-16,   1.361044437967875e-17,  -1.923431542443738e-02,   5.106099615056632e-03,  -7.801189440150403e-04,   8.707163000402754e-05,  -7.789193332255173e-06,
   5.867339733311005e-07,  -3.836068140499931e-08,   2.221781531533041e-09,  -1.156944152956056e-10,   5.477365626181609e-12,  -2.378404945011468e-13,   9.539749035493519e-15,
  -3.555237723217616e-16,   1.235934176679731e-17,  -1.643065733848185e-02,   4.364472134072566e-03,  -6.671798899396443e-04,   7.450220375260080e-05,  -6.667601143309976e-06,
   5.024353660383472e-07,  -3.285996008689650e-08,   1.903733973668999e-09,  -9.915759149049138e-11,   4.695483752873663e-12,  -2.039282814679028e-13,   8.180900250728265e-15,
  -3.049271862680961e-16,   1.060177299705381e-17,  -1.310550788748747e-02,   3.483265184329367e-03,  -5.327577041856493e-04,   5.951951207506328e-05,  -5.328910437355924e-06,
   4.017033181115344e-07,  -2.628023209278638e-08,   1.522959535640509e-09,  -7.934379890455624e-11,   3.758020085801458e-12,  -1.632436740958555e-13,   6.549828675938735e-15,
  -2.441665191880195e-16,   8.490282985788561e-18,  -9.581858688744014e-03,   2.547933848805813e-03,  -3.898681220113043e-04,   4.357232471011840e-05,  -3.902412068007614e-06,
   2.942562034477159e-07,  -1.925569753617066e-08,   1.116129543353795e-09,  -5.815985853192145e-11,   2.755135576638998e-12,  -1.196973306210685e-13,   4.803237766215275e-15,
  -1.790767597894667e-16,   6.227565510032981e-18,  -6.211413942901117e-03,   1.652207420865732e-03,  -2.528814991937904e-04,   2.826947681395539e-05,  -2.532413551227734e-06,
   1.909896436420834e-07,  -1.250016669602111e-08,   7.246603383269335e-10,  -3.776579327989202e-11,   1.789231966531980e-12,  -7.774105226604085e-14,   3.119873016920972e-15,
  -1.163253288032481e-16,   4.045588260198667e-18,  -3.334556909547130e-03,   8.871189491820498e-04,  -1.357992560466436e-04,   1.518285134841102e-05,  -1.360249678559189e-06,
   1.025973660328208e-07,  -6.715514422430945e-09,   3.893412651991022e-10,  -2.029191035804759e-11,   9.614258040518294e-13,  -4.177545609814194e-14,   1.676588949771548e-15,
  -6.251445954088049e-17,   2.174214451884277e-18,  -1.241215365514749e-03,   3.302289084731338e-04,  -5.055365442962316e-05,   5.652332710797771e-06,  -5.064188413742451e-07,
   3.819813655880640e-08,  -2.500334708544203e-09,   1.449641413383769e-10,  -7.555495565277997e-12,   3.579846605221836e-13,  -1.555526358580791e-14,   6.242942626374941e-16,
  -2.327817696793870e-17,   8.096100787137479e-19,  -1.402109493332079e-04,   3.730385540233256e-05,  -5.710769943155904e-06,   6.385176043429237e-07,  -5.720812129147289e-08,
   4.315114721708044e-09,  -2.824557142169613e-10,   1.637625505706684e-11,  -8.535294820512687e-13,   4.044095079307794e-14,  -1.757257919384906e-15,   7.052588106963029e-17,
  -2.629717235745013e-18,   9.146117856011592e-20,  -8.089194504943765e-03,   2.956840802898595e-03,  -5.870021758696706e-04,   8.079905935534884e-05,  -8.558985383929399e-06,
   7.392176649234299e-07,  -5.399677411772347e-08,   3.421361430366519e-09,  -1.915648052689981e-10,   9.613311405191200e-12,  -4.372552830744458e-13,   1.819064155751350e-14,
  -6.973964364622496e-16,   2.477044231744645e-17,  -7.715517901876648e-03,   2.820660513200862e-03,  -5.600373860951446e-04,   7.709546947024917e-05,  -8.167378530287498e-06,
   7.054475326440695e-07,  -5.153324595376262e-08,   3.265443408790460e-09,  -1.828434364162852e-10,   9.176025019327300e-12,  -4.173808232712093e-13,   1.736439060204256e-14,
  -6.657387474724718e-16,   2.364661602357108e-17,  -6.996775777024904e-03,   2.558553998880049e-03,  -5.081085249311609e-04,   6.995968537440603e-05,  -7.412559527155576e-06,
   6.403338152853024e-07,  -4.678182867088578e-08,   2.964648387821469e-09,  -1.660146189592687e-10,   8.332072585400273e-12,  -3.790170889760186e-13,   1.576923507036965e-14,
  -6.046123527899255e-16,   2.147641187786448e-17,  -5.991991897280142e-03,   2.191801781780569e-03,  -4.353898331265282e-04,   5.996050771848806e-05,  -6.354269663590390e-06,
   5.489988948208423e-07,  -4.011436395364219e-08,   2.542410087295543e-09,  -1.423842436308491e-10,   7.146715719351431e-12,  -3.251215256050530e-13,   1.352780528812790e-14,
  -5.187048294641829e-16,   1.842589026400221e-17,  -4.791037795681432e-03,   1.753026536348167e-03,  -3.483185682146370e-04,   4.797952757482734e-05,  -5.085498199028964e-06,
   4.394450212871793e-07,  -3.211357408340616e-08,   2.035552358399177e-09,  -1.140092980532995e-10,   5.722968699316134e-12,  -2.603711566759515e-13,   1.083435891443564e-14,
  -4.154528844864036e-16,   1.475885291190216e-17,  -3.509751970795678e-03,   1.284513327489675e-03,  -2.552794366259933e-04,   3.516974087056900e-05,  -3.728280415569041e-06,
   3.222046981243702e-07,  -2.354835389896849e-08,   1.492768966201192e-09,  -8.361495678716373e-11,   4.197535011439183e-12,  -1.909816716405345e-13,   7.947399519247952e-15,
  -3.047643174816261e-16,   1.082712293832578e-17,  -2.278128215828967e-03,   8.338892336659784e-04,  -1.657464494004645e-04,   2.283738006888613e-05,  -2.421176226805927e-06,
   2.092589747473940e-07,  -1.529474092876486e-08,   9.696152684212274e-10,  -5.431412439112723e-11,   2.726731617025519e-12,  -1.240671409864925e-13,   5.163037383175885e-15,
  -1.979966472222420e-16,   7.034264739357511e-18,  -1.223808745423455e-03,   4.480006163194193e-04,  -8.905217509005691e-05,   1.227076208405454e-05,  -1.300985691684851e-06,
   1.124469895589095e-07,  -8.219036313812524e-09,   5.210641199836515e-10,  -2.918876756953757e-11,   1.465396779414721e-12,  -6.667734992986985e-14,   2.774818497866054e-15,
  -1.064128463209088e-16,   3.780602689868700e-18,  -4.556408433905756e-04,   1.668014517545252e-04,  -3.315707380484383e-05,   4.568902371722369e-06,  -4.844178262545387e-07,
   4.186986451897144e-08,  -3.060411667863281e-09,   1.940236279057227e-10,  -1.086883816224119e-11,   5.456649088583290e-13,  -2.482859556050477e-14,   1.033263529771764e-15,
  -3.962533825790253e-17,   1.407803641991708e-18,  -5.147226895590901e-05,   1.884310268126040e-05,  -3.745678017681833e-06,   5.161399804803558e-07,  -5.472388103968269e-08,
   4.729979964120778e-09,  -3.457310807106107e-10,   2.191865544534962e-11,  -1.227843545432294e-12,   6.164338501346696e-14,  -2.804872266683866e-15,   1.167273060565230e-16,
  -4.476460179705189e-18,   1.590391932849756e-19,  -1.418165949084753e-02,   9.150494937907628e-04,  -4.640060341565536e-05,   2.047447076967405e-06,  -8.282324403670057e-08,
   3.187478994495828e-09,  -1.097797735740579e-10,   3.759513849226940e-12,  -1.312913082349171e-13,   3.920710842961094e-15,  -1.150019819818261e-16,   3.628074699415970e-18,
  -1.030584916696235e-19,   3.120360190814271e-21,  -1.349326032947751e-02,   8.707256318402784e-04,  -4.415855754112306e-05,   1.948813499092658e-06,  -7.884407268464997e-08,
   3.034806132831439e-09,  -1.045502334961940e-10,   3.580887486266736e-12,  -1.250607867458164e-13,   3.736008897275814e-15,  -1.096129540420823e-16,   3.458915421876154e-18,
  -9.826768463195187e-20,   2.974109367728900e-21,  -1.218327833896175e-02,   7.863417885707340e-04,  -3.988789131556556e-05,   1.760814146737725e-06,  -7.125523802390297e-08,
   2.743446669915723e-09,  -9.455845439589965e-11,   3.239406577382567e-12,  -1.131467989010708e-13,   3.382261837814656e-15,  -9.927982282359052e-17,   3.134201673390784e-18,
  -8.906581897102520e-20,   2.693710349363920e-21,  -1.037913898558093e-02,   6.700521494538429e-04,  -3.399809722236022e-05,   1.501303633357131e-06,  -6.077125519775124e-08,
   2.340562823050637e-09,  -8.071929084704023e-11,   2.766067494719570e-12,  -9.662639944634260e-14,   2.890656219874415e-15,  -8.489675155808640e-17,   2.681526916184140e-18,
  -7.622656770275879e-20,   2.303451253132637e-21,  -8.256847659877723e-03,   5.331614318628788e-04,  -2.705936568137880e-05,   1.195277763970875e-06,  -4.839731167259393e-08,
   1.864581770769529e-09,  -6.434040013571624e-11,   2.205393726482415e-12,  -7.705022724338221e-14,   2.306745628270757e-15,  -6.778403323836183e-17,   2.142076294085337e-18,
  -6.091135006053522e-20,   1.839153249933957e-21,  -6.024033788773362e-03,   3.890542347678682e-04,  -1.974967536674751e-05,   8.726131798189183e-07,  -3.534052951002789e-08,
   1.361897493297550e-09,  -4.701581652961586e-11,   1.611909485841979e-12,  -5.632130354435330e-14,   1.687173967649810e-15,  -4.959921400427072e-17,   1.568032926640893e-18,
  -4.459977801972343e-20,   1.345769049110668e-21,  -3.899586441340647e-03,   2.518796258006497e-04,  -1.278800904899832e-05,   5.651162480477363e-07,  -2.289045519925148e-08,
   8.822653437873301e-10,  -3.046694704407141e-11,   1.044691238041116e-12,  -3.650474439394552e-14,   1.093978873940363e-15,  -3.216972313732651e-17,   1.017281612646398e-18,
  -2.893978143654805e-20,   8.728669741166634e-22,  -2.091959326425201e-03,   1.351307840264905e-04,  -6.861120481582338e-06,   3.032266834943654e-07,  -1.228337227772324e-08,
   4.734783217530469e-10,  -1.635296862746947e-11,   5.607737146091356e-13,  -1.959584892873027e-14,   5.873705785676907e-16,  -1.727483468337041e-17,   5.463435593445983e-19,
  -1.554388252830745e-20,   4.687245270962163e-22,  -7.784905072430204e-04,   5.028791509529254e-05,  -2.553378035744865e-06,   1.128497350577833e-07,  -4.571538955078716e-09,
   1.762211487362870e-10,  -6.086642145827141e-12,   2.087276407726327e-13,  -7.293930966394291e-15,   2.186454978138260e-16,  -6.430789260451219e-18,   2.033931755017863e-19,
  -5.786872284791067e-21,   1.744894570761508e-22,  -8.793683355600984e-05,   5.680448153483504e-06,  -2.884269199264294e-07,   1.274744918516557e-08,  -5.164009402387266e-10,
   1.990603250983403e-11,  -6.875560958835007e-13,   2.357827897420217e-14,  -8.239381640306595e-16,   2.469894450602172e-17,  -7.264498324734561e-19,   2.297634407230592e-20,
  -6.537183052541679e-22,   1.971109381597233e-23,  -1.584899998500598e-02,   2.236527760039248e-03,  -2.006185820082437e-04,   1.429275294096029e-05,  -8.718072853780636e-07,
   4.725847987655831e-08,  -2.334443275955311e-09,   1.060747887321161e-10,  -4.480711744253313e-12,   1.779372220133260e-13,  -6.653898734262165e-15,   2.349711594746448e-16,
  -7.881050162750937e-18,   2.510278307628731e-19,  -1.508429656290389e-02,   2.129044478635937e-03,  -1.910185230010882e-04,   1.361180539098930e-05,  -8.304578387861269e-07,
   4.502694918392843e-08,  -2.224676946487524e-09,   1.011084076945842e-10,  -4.271798956571590e-12,   1.696722050701057e-13,  -6.345950216992135e-15,   2.241338269245365e-16,
  -7.518723519303884e-18,   2.395225296396232e-19,  -1.362723230618394e-02,   1.924071681804199e-03,  -1.726941348153598e-04,   1.231079973074463e-05,  -7.513798651677599e-07,
   4.075520714335969e-08,  -2.014362444695158e-09,   9.158387715647203e-11,  -3.870782247887978e-12,   1.537940880815385e-13,  -5.753874175851514e-15,   2.032817763844281e-16,
  -6.821082399245328e-18,   2.173546407541324e-19,  -1.161687820474635e-02,   1.640926367235188e-03,  -1.473484431938572e-04,   1.050891074009059e-05,  -6.417087985094750e-07,
   3.482291197009991e-08,  -1.721919186573108e-09,   7.832284550444277e-11,  -3.311741672977212e-12,   1.316337612588390e-13,  -4.926634705863947e-15,   1.741172571022972e-16,
  -5.844385498918165e-18,   1.862905771873161e-19,  -9.247380619965287e-03,   1.306769452591403e-03,  -1.173949944978762e-04,   8.376431800694321e-06,  -5.117289661744695e-07,
   2.778205153113741e-08,  -1.374355550642895e-09,   6.254071835357104e-11,  -2.645532136164042e-12,   1.051933448508488e-13,  -3.938477016249012e-15,   1.392412843937549e-16,
  -4.675223745317045e-18,   1.490685967484393e-19,  -6.750167124834103e-03,   9.542017423025728e-04,  -8.575256634345743e-05,   6.120901928836938e-06,  -3.740742312176444e-07,
   2.031611755401406e-08,  -1.005370040682101e-09,   4.576577616838722e-11,  -1.936588478058387e-12,   7.702728242802385e-14,  -2.884766328135702e-15,   1.020162418455909e-16,
  -3.426208980720178e-18,   1.092705770992339e-19,  -4.371121010588356e-03,   6.180371707024175e-04,  -5.555520616977956e-05,   3.966412989909726e-06,  -2.424637764198957e-07,
   1.317147674281537e-08,  -6.519569968001938e-10,   2.968475853757054e-11,  -1.256395927125736e-12,   4.998282263166722e-14,  -1.872276093477016e-15,   6.622271294218034e-17,
  -2.224457141552433e-18,   7.095499672732035e-20,  -2.345325305969288e-03,   3.316455658534960e-04,  -2.981517562904137e-05,   2.128944674769380e-06,  -1.301571412138433e-07,
   7.071463811788137e-09,  -3.500618097867190e-10,   1.594081184375790e-11,  -6.747655814064269e-13,   2.684675560108917e-14,  -1.005734865989124e-15,   3.557629969312713e-17,
  -1.195129678250686e-18,   3.812497944678536e-20,  -8.728296283760800e-04,   1.234291555475592e-04,  -1.109684149478563e-05,   7.924011929705020e-07,  -4.844709906354409e-08,
   2.632253973712041e-09,  -1.303109526599573e-10,   5.934230474691956e-12,  -2.512025883434489e-13,   9.994901556907521e-15,  -3.744424072540221e-16,   1.324574152010434e-17,
  -4.449830434951152e-19,   1.419549182758416e-20,  -9.859415213139941e-05,   1.394254835093196e-05,  -1.253506849974638e-06,   8.951079663346869e-08,  -5.472693154457902e-09,
   2.973473531261915e-10,  -1.472041379099630e-11,   6.703572800794465e-13,  -2.837714908309340e-14,   1.129082394794440e-15,  -4.229942785608870e-17,   1.496331980661490e-18,
  -5.026864692444524e-20,   1.603637279971408e-21,  -7.894236132965263e-03,   1.825583834495154e-03,  -2.481769483813415e-04,   2.518820786550137e-05,  -2.081248631645330e-06,
   1.465842533384755e-07,  -9.053738217774904e-09,   4.994688687091155e-10,  -2.494405302500035e-11,   1.139315876625052e-12,  -4.796286931559685e-14,   1.872985053102284e-15,
  -6.820915315398801e-17,   2.324364430962697e-18,  -7.518197197038518e-03,   1.739118966606322e-03,  -2.364868681980272e-04,   2.400760313313739e-05,  -1.984134627622821e-06,
   1.397720408721183e-07,  -8.634500764689554e-09,   4.764154213588282e-10,  -2.379604875711055e-11,   1.087014624254368e-12,  -4.576607836738806e-14,   1.787370319769655e-15,
  -6.509678649183939e-17,   2.218468402688467e-18,  -6.799718938938244e-03,   1.573710874264482e-03,  -2.140970716362473e-04,   2.174398275376499e-05,  -1.797752116945233e-06,
   1.266864077611221e-07,  -7.828548119692805e-09,   4.320654892445088e-10,  -2.158613658961143e-11,   9.862780565011390e-13,  -4.153276558196259e-14,   1.622314198398032e-15,
  -5.909413920550749e-17,   2.014162833945372e-18,  -5.804578205632347e-03,   1.344213790650469e-03,  -1.829806506163978e-04,   1.859338998760369e-05,  -1.537985597561117e-06,
   1.084262601403886e-07,  -6.702663480525833e-09,   3.700496360017245e-10,  -1.849325145716584e-11,   8.451829589641059e-13,  -3.559936591457012e-14,   1.390831481775580e-15,
  -5.067122842557709e-17,   1.727346613120377e-18,  -4.626794418797707e-03,   1.072095452954970e-03,  -1.460203645620046e-04,   1.484515354259424e-05,  -1.228498900353786e-06,
   8.664290180159041e-08,  -5.357994607593197e-09,   2.959062868747520e-10,  -1.479214263005190e-11,   6.762039040686683e-13,  -2.848825158559051e-14,   1.113225409311815e-15,
  -4.056437559997755e-17,   1.383019676578511e-18,  -3.380985206251402e-03,   7.837943094459379e-04,  -1.068015530683284e-04,   1.086235260635215e-05,  -8.992319185917074e-07,
   6.344117843936741e-08,  -3.924334369781151e-09,   2.167852490461745e-10,  -1.083941279365384e-11,   4.956097600441458e-13,  -2.088360188277215e-14,   8.161893010268239e-16,
  -2.974489852986380e-17,   1.014258222502966e-18,  -2.190938892848385e-03,   5.080714604815344e-04,  -6.925150959988976e-05,   7.045162880656731e-06,  -5.833683438029087e-07,
   4.116570226929827e-08,  -2.546906350925450e-09,   1.407182270996581e-10,  -7.037066858542880e-12,   3.217980413523852e-13,  -1.356125658191233e-14,   5.300664368515721e-16,
  -1.931929757968768e-17,   6.588126311540769e-19,  -1.175977542436368e-03,   2.727490248578134e-04,  -3.718209281493811e-05,   3.783161268834174e-06,  -3.132997261725534e-07,
   2.211059586292975e-08,  -1.368107697748464e-09,   7.559540908067440e-11,  -3.780682530237184e-12,   1.728985939885802e-13,  -7.286754248210663e-15,   2.848311558869346e-16,
  -1.038170587397456e-17,   3.540438058104202e-19,  -4.377040683717394e-04,   1.015240640502312e-04,  -1.384084622055231e-05,   1.408329488749658e-06,  -1.166347567064883e-07,
   8.231614650499800e-09,  -5.093538757082306e-10,   2.814542952325410e-11,  -1.407648778219013e-12,   6.437627269487129e-14,  -2.713173540687350e-15,   1.060569023603387e-16,
  -3.865691485668861e-18,   1.318322373865696e-19,  -4.944370579467998e-05,   1.146841155776966e-05,  -1.563509671482654e-06,   1.590909484194634e-07,  -1.317565242148959e-08,
   9.298904954311527e-10,  -5.753985080480876e-11,   3.179501837236909e-12,  -1.590183905308081e-13,   7.272445962127228e-15,  -3.065022656141918e-16,   1.198108978711768e-17,
  -4.367025113723564e-19,   1.489296254806375e-20,  -1.744476016983278e-03,   5.996713652716274e-04,  -1.132584531002791e-04,   1.498551350527172e-05,  -1.537539718719563e-06,
   1.293580949559343e-07,  -9.244979671399742e-09,   5.750879909638815e-10,  -3.169752306297683e-11,   1.569293751785464e-12,  -7.054327533796804e-14,   2.904584166108419e-15,
  -1.103428730433085e-16,   3.887442387784422e-18,  -1.663409683984222e-03,   5.719157375818711e-04,  -1.080341297114579e-04,   1.429620238525049e-05,  -1.466979459855902e-06,
   1.234332119690940e-07,  -8.822239663259511e-09,   5.488284948086047e-10,  -3.025192837946653e-11,   1.497800674613358e-12,  -6.733249042140394e-14,   2.772490265640765e-15,
  -1.053284017998529e-16,   3.710895679315219e-18,  -1.507686987175400e-03,   5.185524222932179e-04,  -9.798228010949311e-05,   1.296911891092616e-05,  -1.331065143219123e-06,
   1.120157010654560e-07,  -8.007303870631154e-09,   4.981910113062100e-10,  -2.746356475839213e-11,   1.359867499309690e-12,  -6.113657874009320e-14,   2.517539924735156e-15,
  -9.564856033212750e-17,   3.370043732030265e-18,  -1.290382519417541e-03,   4.439958610672089e-04,  -8.392384445339278e-05,   1.111149499073557e-05,  -1.140680914482412e-06,
   9.601296299903641e-08,  -6.864519455244382e-09,   4.271515389792651e-10,  -2.355031000200648e-11,   1.166226416156472e-12,  -5.243582942418963e-14,   2.159430842555527e-15,
  -8.204901164049685e-17,   2.891073399676366e-18,  -1.031145246606790e-03,   3.549385849996249e-04,  -6.711290869472278e-05,   8.888185427081227e-06,  -9.126495970655306e-07,
   7.683389899980603e-08,  -5.494187191745658e-09,   3.419285471514539e-10,  -1.885392433598949e-11,   9.337549658104868e-13,  -4.198725521246597e-14,   1.729271948993741e-15,
  -6.570950604977171e-17,   2.315483099542574e-18,  -7.550235277620697e-04,   2.599755893751970e-04,  -4.917029645399198e-05,   6.513374041608659e-06,  -6.689236667502826e-07,
   5.632380378161931e-08,  -4.028087556627509e-09,   2.507142082074288e-10,  -1.382568967730061e-11,   6.847845544509730e-13,  -3.079427578585031e-14,   1.268363009633767e-15,
  -4.819846288078996e-17,   1.698512504214475e-18,  -4.899213783353924e-04,   1.687290472389847e-04,  -3.191812947205120e-05,   4.228671357280642e-06,  -4.343370439867608e-07,
   3.657515155290506e-08,  -2.615954267970400e-09,   1.628327934320686e-10,  -8.980014071425947e-12,   4.448031471439629e-13,  -2.000343619629392e-14,   8.239416309542638e-16,
  -3.131138876649694e-17,   1.103449504467602e-18,  -2.631432003989050e-04,   9.063635975591785e-05,  -1.714705977634175e-05,   2.271896841979072e-06,  -2.333664356367498e-07,
   1.965260489148479e-08,  -1.405669229144108e-09,   8.750061293922225e-11,  -4.825698868617513e-12,   2.390359293987772e-13,  -1.075005164008226e-14,   4.428042194449728e-16,
  -1.682774667198091e-17,   5.930394224305448e-19,  -9.796637373427011e-05,   3.374454865920807e-05,  -6.384172480547502e-06,   8.458918474687230e-07,  -8.689083280406510e-08,
   7.317512977777346e-09,  -5.233992828265976e-10,   3.258117359306552e-11,  -1.796886750209319e-12,   8.900776402479982e-14,  -4.002938766237876e-15,   1.648858549399759e-16,
  -6.266146030389836e-18,   2.208313390072169e-19,  -1.106684575666908e-05,   3.812001230550292e-06,  -7.212008110339294e-07,   9.555825791468550e-08,  -9.815870610275431e-09,
   8.266460708864509e-10,  -5.912760334177486e-11,   3.680652119487565e-12,  -2.029922816474745e-13,   1.005512280597114e-14,  -4.522088108017804e-16,   1.862704611508582e-17,
  -7.078831267897793e-19,   2.494722053761049e-20,  -1.113467195709726e-02,   6.236571122876619e-04,  -2.806189644827813e-05,   1.117779135286300e-06,  -3.888896696155090e-08,
   1.446300596697077e-09,  -4.697815985909294e-11,   1.172994257843195e-12,  -4.438812152225960e-14,   1.491163890911492e-15,  -2.428342258010515e-17,   1.054891928042960e-18,
  -3.148231406981578e-20,  -9.257469967508822e-23,  -1.059392241710303e-02,   5.934227502747819e-04,  -2.670394514916618e-05,   1.063842251899877e-06,  -3.701848697489272e-08,
   1.376691976745863e-09,  -4.473026656298558e-11,   1.117547241920069e-12,  -4.226207279405244e-14,   1.420356530614336e-15,  -2.316527802382868e-17,   1.003409774452044e-18,
  -3.006241141040635e-20,  -8.495077324387069e-23,  -9.565012691434862e-03,   5.358727721371572e-04,  -2.411813307149366e-05,   9.610728206732409e-07,  -3.345207289122156e-08,
   1.243989179030860e-09,  -4.043946266067560e-11,   1.011429822450298e-12,  -3.820479187464893e-14,   1.284972147502581e-15,  -2.101313008921830e-17,   9.055650142252689e-19,
  -2.731559022788593e-20,  -7.168962835818952e-23,  -8.148174643366320e-03,   4.565828530160410e-04,  -2.055356560548882e-05,   8.192824754215042e-07,  -2.852672498573517e-08,
   1.060757682274024e-09,  -3.450444585351588e-11,   8.641071033338546e-13,  -3.259452795965879e-14,   1.097273107842702e-15,  -1.800158177622154e-17,   7.710385896337644e-19,
  -2.344642765315340e-20,  -5.587026010753347e-23,  -6.481738952390581e-03,   3.632716581921981e-04,  -1.635619154640992e-05,   6.521665932056076e-07,  -2.271558193292160e-08,
   8.446175486795519e-10,  -2.749035145299260e-11,   6.893140739808119e-13,  -2.596630590946172e-14,   8.749004991960488e-16,  -1.439834237670485e-17,   6.130617560025338e-19,
  -1.878703145033893e-20,  -4.039601605540909e-23,  -4.728758628146795e-03,   2.650648594149949e-04,  -1.193630147759021e-05,   4.760479368957264e-07,  -1.658572541043433e-08,
   6.166637330702043e-10,  -2.008068313092065e-11,   5.040259064369389e-13,  -1.896608197496127e-14,   6.394815381548925e-16,  -1.055056197811037e-17,   4.470978535616637e-19,
  -1.378542138290240e-20,  -2.707538127656102e-23,  -3.061023908925817e-03,   1.715989810381428e-04,  -7.728168360925364e-06,   3.082666408014105e-07,  -1.074208507506200e-08,
   3.993814895943926e-10,  -1.300937362461291e-11,   3.267528525741003e-13,  -1.228671683992695e-14,   4.144615693151182e-16,  -6.849430710879745e-18,   2.893485978843163e-19,
  -8.957370032208225e-21,  -1.649657491650166e-23,  -1.642084342298537e-03,   9.205884321833987e-05,  -4.146198668774631e-06,   1.654000021754757e-07,  -5.764183053149931e-09,
   2.143036950717749e-10,  -6.981826982272259e-12,   1.754204242496302e-13,  -6.593843506305019e-15,   2.224786304241206e-16,  -3.679845443251868e-18,   1.552027233995253e-19,
  -4.814456633593104e-21,  -8.564993743614182e-24,  -6.110735346642362e-04,   3.425872614928753e-05,  -1.542992143010254e-06,   6.155473329008076e-08,  -2.145248946690928e-09,
   7.975666879197508e-11,  -2.598550226732973e-12,   6.529707163852658e-14,  -2.454128228993937e-15,   8.280986699607279e-17,  -1.370100767612490e-18,   5.775370261834507e-20,
  -1.792818150426703e-21,  -3.150404436309895e-24,  -6.902567284645466e-05,   3.869809649537983e-06,  -1.742943714684647e-07,   6.953173388351901e-09,  -2.423268421429007e-10,
   9.009286996930091e-12,  -2.935340236053139e-13,   7.376141011529270e-15,  -2.772196699811069e-16,   9.354368102984654e-18,  -1.547766247984930e-19,   6.523703782856475e-21,
  -2.025347500478278e-22,  -3.552016319787674e-25,  -9.286559508683012e-03,   1.136602115088164e-03,  -8.927632020618160e-05,   5.640468880248423e-06,  -3.103169241138015e-07,
   1.515360270480946e-08,  -6.839178297651384e-10,   2.888605185148174e-11,  -1.124448279862512e-12,   4.144382292326157e-14,  -1.470522569904645e-15,   4.878462694770062e-17,
  -1.548867366167405e-18,   4.789683557303558e-20,  -8.837595007898855e-03,   1.081829252651589e-03,  -8.498999979386193e-05,   5.370675954382384e-06,  -2.955316324196203e-07,
   1.443477286835210e-08,  -6.515993113518167e-10,   2.752593873615947e-11,  -1.071747312227114e-12,   3.950883626199100e-14,  -1.402076950854590e-15,   4.652443891196053e-17,
  -1.477274322778491e-18,   4.568743537278296e-20,  -7.982503837801120e-03,   9.774376202193193e-04,  -7.681420614878812e-05,   4.855653001087077e-06,  -2.672834897590527e-07,
   1.306010041622361e-08,  -5.897430651307677e-10,   2.492071599841357e-11,  -9.707000170981079e-13,   3.579566796666933e-14,  -1.270643647321210e-15,   4.217988535761908e-17,
  -1.339589303722559e-18,   4.143646891720480e-20,  -6.803417325104841e-03,   8.333520521611016e-04,  -6.551704786917090e-05,   4.143197363995987e-06,  -2.281606062082893e-07,
   1.115368434578661e-08,  -5.038608010504292e-10,   2.129965542429848e-11,  -8.300556009724566e-13,   3.062145874322702e-14,  -1.087322994136060e-15,   3.611167043596509e-17,
  -1.147145626136821e-18,   3.549114359964254e-20,  -5.414586915611370e-03,   6.634585042486979e-04,  -5.218044181786581e-05,   3.301102682487620e-06,  -1.818608241896256e-07,
   8.894342811202722e-09,  -4.019542192276098e-10,   1.699799943460219e-11,  -6.627285950625277e-13,   2.445807069726698e-14,  -8.687397798699441e-16,   2.886549379497562e-17,
  -9.171745486906875e-19,   2.838182356048037e-20,  -3.951734288642640e-03,   4.843447644139292e-04,  -3.810518042465173e-05,   2.411416132103199e-06,  -1.328902711604028e-07,
   6.501691674159674e-09,  -2.939180603051638e-10,   1.243298834114810e-11,  -4.849274053940030e-13,   1.790185777953587e-14,  -6.360245204651718e-16,   2.114091301299396e-17,
  -6.718606516862586e-19,   2.079394404425840e-20,  -2.558689226419701e-03,   3.136625508768460e-04,  -2.468206794479452e-05,   1.562284340298140e-06,  -8.611407566115466e-08,
   4.214168766288404e-09,  -1.905471164183219e-10,   8.061876248520442e-12,  -3.145176411536729e-13,   1.161329279023579e-14,  -4.126696048645584e-16,   1.372012664341457e-17,
  -4.360820484620279e-19,   1.349806180669650e-20,  -1.372786158891885e-03,   1.683015854185090e-04,  -1.324503208571522e-05,   8.384515313281853e-07,  -4.622104775235610e-08,
   2.262201282567931e-09,  -1.022982437774335e-10,   4.328578336456155e-12,  -1.688921221906696e-13,   6.236851690711349e-15,  -2.216404948591847e-16,   7.369855103669954e-18,
  -2.342594551581393e-19,   7.251429494284009e-21,  -5.108820127160662e-04,   6.263540850607527e-05,  -4.929475453067086e-06,   3.120626613823064e-07,  -1.720363624994167e-08,
   8.420354718720966e-10,  -3.807882098701120e-11,   1.611297310451084e-12,  -6.287225035598908e-14,   2.321832650841722e-15,  -8.251394181753974e-17,   2.743822543586629e-18,
  -8.721757008380952e-20,   2.699843416516411e-21,  -5.770864974748144e-05,   7.075260498396976e-06,  -5.568340257817778e-07,   3.525083656359391e-08,  -1.943347690324485e-09,
   9.511819664712006e-11,  -4.301493589094887e-12,   1.820178007444081e-13,  -7.102319964626122e-15,   2.622857301697155e-16,  -9.321227387489165e-18,   3.099593760330723e-19,
  -9.852678090967180e-21,   3.049932104903551e-22,  -3.227959396015552e-03,   6.475840862213595e-04,  -7.728373342108770e-05,   7.048980911552862e-06,  -5.328861171847621e-07,
   3.471418358574118e-08,  -2.006360039842384e-09,   1.045847132874793e-10,  -4.968054196084484e-12,   2.173489534331703e-13,  -8.817715552341748e-15,   3.331713244643836e-16,
  -1.179611056564819e-17,   3.923798654117037e-19,  -3.073391196979179e-03,   6.167343021680811e-04,  -7.362191155903316e-05,   6.716641212086049e-06,  -5.078772250055175e-07,
   3.309208613180871e-08,  -1.912974478906422e-09,   9.973412234165204e-11,  -4.738395926312623e-12,   2.073307253013413e-13,  -8.412344467023568e-15,   3.178915163844668e-16,
  -1.125622068150175e-17,   3.744550082393804e-19,  -2.778397292717898e-03,   5.577921261198369e-04,  -6.661740251489362e-05,   6.080243572317204e-06,  -4.599399096763991e-07,
   2.997988817375756e-08,  -1.733649722236188e-09,   9.041248011550656e-11,  -4.296730992966714e-12,   1.880519977515797e-13,  -7.631814173708408e-15,   2.884551003423978e-16,
  -1.021566194707786e-17,   3.398931215850871e-19,  -2.370453641974373e-03,   4.761550810090363e-04,  -5.690007728102049e-05,   5.196049635245244e-06,  -3.932445639911889e-07,
   2.564417708696748e-08,  -1.483530415912716e-09,   7.739680398790379e-11,  -3.679425149492596e-12,   1.610827912734126e-13,  -6.539056090745614e-15,   2.472134143054434e-16,
  -8.756894697415092e-18,   2.914128625707001e-19,  -1.888450776210303e-03,   3.795371887403395e-04,  -4.537955288556800e-05,   4.146108817395844e-06,  -3.139299840777582e-07,
   2.048092628501353e-08,  -1.185298849964869e-09,   6.185982657867932e-11,  -2.941764301375699e-12,   1.288255692482944e-13,  -5.230944354479789e-15,   1.978062172611876e-16,
  -7.008172080159196e-18,   2.332615461826808e-19,  -1.379365224955122e-03,   2.773412295463239e-04,  -3.317527510126706e-05,   3.032298504786226e-06,  -2.296819856096846e-07,
   1.498983896329811e-08,  -8.677851625010201e-10,   4.530194890100365e-11,  -2.154915224856613e-12,   9.438971782483075e-14,  -3.833474924350486e-15,   1.449889615575364e-16,
  -5.137706603235285e-18,   1.710297346579433e-19,  -8.935958241987228e-04,   1.797212565681430e-04,  -2.150442039383404e-05,   1.966083295667107e-06,  -1.489581729626969e-07,
   9.723786491736053e-09,  -5.630422345409236e-10,   2.939864058649703e-11,  -1.398671569806213e-12,   6.127401252887009e-14,  -2.488877214593992e-15,   9.414561371755737e-17,
  -3.336416385680164e-18,   1.110771266598236e-19,  -4.795629776180421e-04,   9.646442570700620e-05,  -1.154413167503282e-05,   1.055590204587554e-06,  -7.998580011902367e-08,
   5.221987125130770e-09,  -3.024040941955581e-10,   1.579122373881644e-11,  -7.513509398330395e-13,   3.291829088208907e-14,  -1.337195099380145e-15,   5.058470544414506e-17,
  -1.792762871259034e-18,   5.968824253039415e-20,  -1.784862827379036e-04,   3.590445838490231e-05,  -4.297000079642329e-06,   3.929346113355628e-07,  -2.977535871666794e-08,
   1.944007488610769e-09,  -1.125812100483233e-10,   5.879069391805425e-12,  -2.797364375584343e-13,   1.225618375297543e-14,  -4.978784331890469e-16,   1.883464506621109e-17,
  -6.675275973229157e-19,   2.222504557346449e-20,  -2.016191257155550e-05,   4.055820753398744e-06,  -4.853995479898039e-07,   4.438718446232428e-08,  -3.363545893872971e-09,
   2.196044566004641e-10,  -1.271779100309021e-11,   6.641354565872370e-13,  -3.160088513276678e-14,   1.384545842027168e-15,  -5.624411200719115e-17,   2.127711426654780e-18,
  -7.540945558167955e-20,   2.510732410805067e-21,  -4.235294672199417e-04,   1.336527143176887e-04,  -2.356641526366113e-05,   2.956454973198180e-06,  -2.907632061638335e-07,
   2.363566574633066e-08,  -1.642066417651886e-09,   9.975944539704267e-11,  -5.389704631090878e-12,   2.623292890464404e-13,  -1.162064570500312e-14,   4.724241607815135e-16,
  -1.774881123579317e-17,   6.191977605464398e-19,  -4.037084398886139e-04,   1.274293602898657e-04,  -2.247383777906033e-05,   2.819874941777979e-06,  -2.773702333553920e-07,
   2.254965397051648e-08,  -1.566773347917578e-09,   9.519330711773086e-11,  -5.143384836310357e-12,   2.503560745659181e-13,  -1.109086358287320e-14,   4.509080007069021e-16,
  -1.694116612592756e-17,   5.910437033468420e-19,  -3.656922299603568e-04,   1.154799651387710e-04,  -2.037399693985495e-05,   2.557175414417953e-06,  -2.515933982026186e-07,
   2.045832451779773e-08,  -1.421715425656997e-09,   8.639285649505108e-11,  -4.668486357155364e-12,   2.272653254429963e-13,  -1.006890280329818e-14,   4.093937121235080e-16,
  -1.538255549295331e-17,   5.367020172783254e-19,  -3.127554207275181e-04,   9.881520041443950e-05,  -1.744167778528936e-05,   2.189934146037333e-06,  -2.155264663893452e-07,
   1.752994950566664e-08,  -1.218470673420752e-09,   7.405567008885448e-11,  -4.002427770330093e-12,   1.948669867755475e-13,  -8.634504524443579e-15,   3.511076175032420e-16,
  -1.319368158448184e-17,   4.603677875876394e-19,  -2.497459867349166e-04,   7.894741285331963e-05,  -1.394089914915179e-05,   1.751002321177579e-06,  -1.723783152077244e-07,
   1.402387905046981e-08,  -9.749698691544684e-10,   5.926656899171086e-11,  -3.203609402467220e-12,   1.559947504496899e-13,  -6.912856658459067e-15,   2.811270589427669e-16,
  -1.056490179539783e-17,   3.686696426471543e-19,  -1.827646152783276e-04,   5.779742598242817e-05,  -1.020968966136559e-05,   1.282718382372591e-06,  -1.263073301757018e-07,
   1.027776394019601e-08,  -7.146488714600565e-10,   4.344819101297563e-11,  -2.348838890720758e-12,   1.143847823129061e-13,  -5.069377220343568e-15,   2.061738444916020e-16,
  -7.748650652978597e-18,   2.704110398286610e-19,  -1.185482613067761e-04,   3.749973737466147e-05,  -6.625701474613273e-06,   8.325907021593456e-07,  -8.199653919017082e-08,
   6.673002413645102e-09,  -4.640471640928504e-10,   2.821505274348557e-11,  -1.525444683070430e-12,   7.429179243325322e-14,  -3.292704254572570e-15,   1.339226302178923e-16,
  -5.033453084937603e-18,   1.756635884657985e-19,  -6.366158588075427e-05,   2.014050273702160e-05,  -3.558975535277574e-06,   4.472662924079079e-07,  -4.405186853577140e-08,
   3.585243236903741e-09,  -2.493351057840478e-10,   1.516081486248604e-11,  -8.197012468228108e-13,   3.992224970736263e-14,  -1.769456838899060e-15,   7.197018774431761e-17,
  -2.705046294096268e-18,   9.440594304439496e-20,  -2.369917847725957e-05,   7.498026144336231e-06,  -1.325010753152427e-06,   1.665232938535560e-07,  -1.640155596037228e-08,
   1.334901625065958e-09,  -9.283727822974607e-11,   5.645060439727529e-12,  -3.052162949384842e-13,   1.486525472755046e-14,  -6.588732407529225e-16,   2.679899457384010e-17,
  -1.007265705859706e-18,   3.515375953102210e-20,  -2.677167278928108e-06,   8.470176649471406e-07,  -1.496813658038071e-07,   1.881159479429061e-08,  -1.852838470288666e-09,
   1.508006956337251e-10,  -1.048764080170935e-11,   6.377127862026487e-13,  -3.447983726269925e-14,   1.679309234908934e-15,  -7.443220959510862e-17,   3.027458317705537e-18,
  -1.137900456662817e-19,   3.971298143076106e-21,  -9.016562930306313e-03,   4.440836766351446e-04,  -1.760092352881570e-05,   6.745672262627995e-07,  -1.921508993824447e-08,
   5.970646756822644e-10,  -2.690236674544539e-11,   4.855433444769791e-13,  -1.555763672785508e-15,   9.314838496932053e-16,  -1.844541395280820e-17,  -9.190935891895300e-19,
  -3.960390024442902e-20,   1.317424443512600e-21,  -8.578522703467012e-03,   4.225438077771096e-04,  -1.674826574734850e-05,   6.419345087112633e-07,  -1.829246428106086e-08,
   5.683310358711932e-10,  -2.559526718259493e-11,   4.629132108025787e-13,  -1.505371218225131e-15,   8.847033625009387e-16,  -1.762274906215312e-17,  -8.712691052271348e-19,
  -3.739002414293821e-20,   1.258214512974738e-21,  -7.745106073413646e-03,   3.815479717691198e-04,  -1.512501218476048e-05,   5.797909882417526e-07,  -1.653264854090469e-08,
   5.135521570270911e-10,  -2.310846031706230e-11,   4.194648764082294e-13,  -1.399378816861003e-15,   7.963273638797167e-16,  -1.602688707147997e-17,  -7.815548203841793e-19,
  -3.329813658631005e-20,   1.143468312350627e-21,  -6.597590240203093e-03,   3.250743812500617e-04,  -1.288807385500942e-05,   4.941172586536341e-07,  -1.410101195346847e-08,
   4.379137546801156e-10,  -1.968455770451516e-11,   3.588836016638583e-13,  -1.233698036251945e-15,   6.758557956054791e-16,  -1.377090737306302e-17,  -6.605184295363579e-19,
  -2.789492026878144e-20,   9.815605882638941e-22,  -5.248077308193766e-03,   2.586253224063502e-04,  -1.025494545498779e-05,   3.932236770258324e-07,  -1.123047709509043e-08,
   3.486881668358760e-10,  -1.565807299106762e-11,   2.866821734405565e-13,  -1.013666066906662e-15,   5.357001863602810e-16,  -1.104473058392988e-17,  -5.213485320224854e-19,
  -2.182921890518198e-20,   7.864128615374744e-22,  -3.828623688890957e-03,   1.887003237805965e-04,  -7.483089693643390e-06,   2.869716677229760e-07,  -8.201051223425454e-09,
   2.545831099648491e-10,  -1.142298701913482e-11,   2.098506817418982e-13,  -7.585702106058919e-16,   3.896899895289013e-16,  -8.110210018165561e-18,  -3.779426219707079e-19,
  -1.571502445587243e-20,   5.769290276591880e-22,  -2.478298219043714e-03,   1.221581951953952e-04,  -4.844637974972887e-06,   1.858033714496333e-07,  -5.312066718272323e-09,
   1.648815029461020e-10,  -7.394183012036358e-12,   1.361402502864406e-13,  -4.992109086190895e-16,   2.517724041633541e-16,  -5.272214813095295e-18,  -2.436177758428926e-19,
  -1.008309921422580e-20,   3.747992957146021e-22,  -1.329467847380411e-03,   6.553404132239008e-05,  -2.599089885441135e-06,   9.968529849744611e-08,  -2.850579150095964e-09,
   8.847389695924215e-11,  -3.966563279254301e-12,   7.311478867307653e-14,  -2.700569263815746e-16,   1.349306066606674e-16,  -2.834395864138111e-18,  -1.304037882462461e-19,
  -5.384477185846432e-21,   2.014256986903008e-22,  -4.947368956070456e-04,   2.438767489546027e-05,  -9.672309518859562e-07,   3.709762519266809e-08,  -1.060913872782805e-09,
   3.292706568331411e-11,  -1.476083197717741e-12,   2.721908783722036e-14,  -1.007894431221677e-16,   5.019495996261757e-17,  -1.055562927470286e-18,  -4.849061972746765e-20,
  -2.000559894496137e-21,   7.500410503121813e-23,  -5.588448161078463e-05,   2.754789585897824e-06,  -1.092569530195780e-07,   4.190501277632311e-09,  -1.198409045949841e-10,
   3.719431195342812e-12,  -1.667353796784689e-13,   3.074806276398760e-15,  -1.139022092649093e-17,   5.669617265344388e-18,  -1.192484986416147e-19,  -5.476743872844097e-21,
  -2.259223444027882e-22,   8.473157931256445e-24,  -5.834618261402851e-03,   6.270864139683044e-04,  -4.366151889592899e-05,   2.424348026229883e-06,  -1.222369686138229e-07,
   5.436180498281179e-09,  -2.163387870558071e-10,   8.604313020116808e-12,  -3.221156841437709e-13,   1.031866503034698e-14,  -3.428691750679146e-16,   1.197072798421168e-17,
  -3.109760682043473e-19,   8.463095039392892e-21,  -5.552151030917231e-03,   5.968040898448235e-04,  -4.155985136179599e-05,   2.308059813702004e-06,  -1.163888364619216e-07,
   5.177187576212002e-09,  -2.060867997986572e-10,   8.196976441256594e-12,  -3.069116660748319e-13,   9.836527253722131e-15,  -3.268127810675932e-16,   1.140838024389724e-17,
  -2.968073798251718e-19,   8.072380052247435e-21,  -5.014326588447796e-03,   5.391147322648856e-04,  -3.755330730827966e-05,   2.086205076511133e-06,  -1.052255629672419e-07,
   4.682358707038062e-09,  -1.864768349785188e-10,   7.417661710427228e-12,  -2.778045634644674e-13,   8.911458691733303e-15,  -2.960219642779044e-16,   1.033070674184839e-17,
  -2.694683799376254e-19,   7.320868962032562e-21,  -4.273027103228608e-03,   4.595394647775752e-04,  -3.202142439264132e-05,   1.779563572276981e-06,  -8.978394900814650e-08,
   3.997019536176643e-09,  -1.592731401267149e-10,   6.336244677409493e-12,  -2.373776894211800e-13,   7.622678170879167e-15,  -2.531552474349148e-16,   8.831790283683253e-18,
  -2.310855852931720e-19,   6.270178437975101e-21,  -3.400249624570999e-03,   3.657742176303263e-04,  -2.549630756443895e-05,   1.417455167683728e-06,  -7.153390846297008e-08,
   3.185940221080462e-09,  -1.270229543834378e-10,   5.053800245218736e-12,  -1.893900030444834e-13,   6.087893428917178e-15,  -2.021422070089266e-16,   7.049822796465991e-18,
  -1.850087302955590e-19,   5.014078742550449e-21,  -2.481317803468343e-03,   2.669791977506278e-04,  -1.861484766481281e-05,   1.035189138194281e-06,  -5.225368757973910e-08,
   2.328058441898152e-09,  -9.286029312003781e-11,   3.694909106149457e-12,  -1.384993846446674e-13,   4.455662827334985e-15,  -1.479220169930091e-16,   5.157513478009468e-18,
  -1.356692604840296e-19,   3.673564359466205e-21,  -1.606492169167324e-03,   1.728760892030763e-04,  -1.205576713789955e-05,   6.705632380015313e-07,  -3.385318282043539e-08,
   1.508607508502211e-09,  -6.019200888298386e-11,   2.395177796853760e-12,  -8.979477752947279e-14,   2.890339781364988e-15,  -9.594552822667553e-17,   3.344698879299016e-18,
  -8.811927800692841e-20,   2.384655262983663e-21,  -8.618798262260849e-04,   9.275439664119004e-05,  -6.468959065861114e-06,   3.598510433678677e-07,  -1.816831478877767e-08,
   8.097344728592424e-10,  -3.231246238465709e-11,   1.285825347380252e-12,  -4.820929660471672e-14,   1.552201777539838e-15,  -5.152303731465765e-17,   1.795953305588234e-18,
  -4.735356463943867e-20,   1.281092900761292e-21,  -3.207439194874623e-04,   3.451891811916108e-05,  -2.407526006910792e-06,   1.339289550535538e-07,  -6.762036925667978e-09,
   3.013861868182677e-10,  -1.202744370463155e-11,   4.786188493422925e-13,  -1.794530949985984e-14,   5.778430640062711e-16,  -1.918029993325880e-17,   6.685524727618098e-19,
  -1.763244304451617e-20,   4.769762062544987e-22,  -3.623078801261290e-05,   3.899224692099726e-06,  -2.719532675627943e-07,   1.512864998886135e-08,  -7.638445894528370e-10,
   3.404502366888816e-11,  -1.358648799861854e-12,   5.406601935383755e-14,  -2.027157573229274e-15,   6.527592797094576e-17,  -2.166692652243947e-18,   7.552231196618960e-20,
  -1.991916793834440e-21,   5.388259442217574e-23,  -1.490141839420312e-03,   2.623798260386496e-04,  -2.731145075190387e-05,   2.206531045968234e-06,  -1.521100400849836e-07,
   9.094963642173428e-09,  -4.853260033720531e-10,   2.377363033071591e-11,  -1.068061454572030e-12,   4.419300619428404e-14,  -1.720115993956035e-15,   6.277025178323257e-17,
  -2.127529170018405e-18,   6.896727991635627e-20,  -1.418513550873235e-03,   2.498196698470237e-04,  -2.601068406760412e-05,   2.101954984921768e-06,  -1.449312501021853e-07,
   8.667650905190644e-09,  -4.626220944275664e-10,   2.266529070666566e-11,  -1.018446586961479e-12,   4.214764693615738e-14,  -1.640689383520446e-15,   5.987963311924508e-17,
  -2.029922472017446e-18,   6.580423620133579e-20,  -1.281923092728074e-03,   2.258470477986638e-04,  -2.352528752492632e-05,   1.901927952588299e-06,  -1.311875719682119e-07,
   7.848771045723703e-09,  -4.190726017391568e-10,   2.053774332525389e-11,  -9.231320001373127e-13,   3.821516195865880e-14,  -1.487903654464818e-15,   5.431590637204855e-17,
  -1.841897767957977e-18,   5.971075924615680e-20,  -1.093251634502775e-03,   1.926926435076612e-04,  -2.008267901254850e-05,   1.624452959990656e-06,  -1.120982740203319e-07,
   6.709844343475549e-09,  -3.584232454725046e-10,   1.757173440452640e-11,  -7.901094323148657e-13,   3.272079878849545e-14,  -1.274285912113472e-15,   4.653059340325515e-17,
  -1.578494498530284e-18,   5.117366423842560e-20,  -8.706039796812900e-04,   1.535155908877049e-04,  -1.600802745556382e-05,   1.295515817736667e-06,  -8.943791655038495e-08,
   5.355909469284685e-09,  -2.862244632612882e-10,   1.403703113570550e-11,  -6.313991869036313e-13,   2.615771991605987e-14,  -1.018928017704544e-15,   3.721606127707111e-17,
  -1.262975433638923e-18,   4.094636159929819e-20,  -6.357031384594619e-04,   1.121338288233723e-04,  -1.169785195815380e-05,   9.470818640276292e-07,  -6.540591264616445e-08,
   3.918210016151634e-09,  -2.094660848265663e-10,   1.027549619455681e-11,  -4.623350961778874e-13,   1.915933705070022e-14,  -7.464573813546801e-16,   2.726993806031975e-17,
  -9.257138252252569e-19,   3.001315116044397e-20,  -4.117406873920452e-04,   7.264495671886185e-05,  -7.580476702194142e-06,   6.138954606586505e-07,  -4.240560503471793e-08,
   2.540966486581685e-09,  -1.358706009509048e-10,   6.666442044105616e-12,  -3.000065476030014e-13,   1.243479162607141e-14,  -4.845252886155333e-16,   1.770338248299015e-17,
  -6.010811509680973e-19,   1.948847504944772e-20,  -2.209433020600984e-04,   3.898643783652018e-05,  -4.068806254930843e-06,   3.295525742556799e-07,  -2.276693332376623e-08,
   1.364375960949133e-09,  -7.296459813661024e-11,   3.580317983756846e-12,  -1.611389595279971e-13,   6.679615729801655e-15,  -2.602895995283576e-16,   9.511033043226714e-18,
  -3.229592279747960e-19,   1.047122866914468e-20,  -8.222871774047069e-05,   1.451021989125212e-05,  -1.514429863499487e-06,   1.226669786531236e-07,  -8.474717610213713e-09,
   5.078944801368886e-10,  -2.716248944734428e-11,   1.332886492846416e-12,  -5.999110257838526e-14,   2.486868219126890e-15,  -9.690978763086933e-17,   3.541190728922912e-18,
  -1.202497899006476e-19,   3.898846153971986e-21,  -9.288546917248428e-06,   1.639083480398150e-06,  -1.710722983965758e-07,   1.385675361913854e-08,  -9.573304595011247e-10,
   5.737373281139737e-11,  -3.068400401760014e-12,   1.505698018569834e-13,  -6.776943914749134e-15,   2.809326399614307e-16,  -1.094759146866034e-17,   4.000386680038001e-19,
  -1.358436554684246e-20,   4.404447347866356e-22,  -1.186844207263747e-04,   3.355918093431624e-05,  -5.395201197038175e-06,   6.304987919726532e-07,  -5.867890914427665e-08,
   4.560013245462842e-09,  -3.053644784110962e-10,   1.800011773892587e-11,  -9.479783901818912e-13,   4.515130573509883e-14,  -1.963960398768755e-15,   7.857938597240918e-17,
  -2.911283656384682e-18,   1.003983552385922e-19,  -1.130878647771346e-04,   3.198575722198282e-05,  -5.143584661586997e-06,   6.012221482509653e-07,  -5.596401186273991e-08,
   4.349683238680635e-09,  -2.913159503276995e-10,   1.717381301291635e-11,  -9.045435258606725e-13,   4.308590301267108e-14,  -1.874245174042094e-15,   7.499433505500326e-17,
  -2.778604713500016e-18,   9.582675278056726e-20,  -1.023714247307595e-04,   2.896916587002075e-05,  -4.660624275969316e-06,   5.449741218737012e-07,  -5.074387361280584e-08,
   3.944992927726308e-09,  -2.642702074810265e-10,   1.558227654521913e-11,  -8.208491286789992e-13,   3.910466575876408e-14,  -1.701258787484064e-15,   6.807981882894469e-17,
  -2.522644803760672e-18,   8.700568350001435e-20,  -8.748305421773335e-05,   2.477093519072812e-05,  -3.987403068604642e-06,   4.664637700616767e-07,  -4.344970594829145e-08,
   3.378986460562062e-09,  -2.264139389480798e-10,   1.335310898743637e-11,  -7.035559723392203e-13,   3.352242763029235e-14,  -1.458606411454191e-15,   5.837694511430257e-17,
  -2.163348404647695e-18,   7.462011127295865e-20,  -6.980470046832811e-05,   1.977679859472494e-05,  -3.185191222926476e-06,   3.727801402717239e-07,  -3.473581194321181e-08,
   2.702149660168156e-09,  -1.811076968043440e-10,   1.068339639806105e-11,  -5.629975633038713e-13,   2.682948917683264e-14,  -1.167545430096455e-15,   4.673371604874210e-17,
  -1.732052916470396e-18,   5.974852261552604e-20,  -5.105176006561415e-05,   1.447055592968124e-05,  -2.331582857816814e-06,   2.729733130839161e-07,  -2.544308986371953e-08,
   1.979738974719557e-09,  -1.327163070568364e-10,   7.830174566341634e-12,  -4.126990491457751e-13,   1.966956359610036e-14,  -8.560579664282930e-16,   3.426907489037752e-17,
  -1.270193473101291e-18,   4.381927831685133e-20,  -3.310071130945463e-05,   9.385249470210324e-06,  -1.512635008623767e-06,   1.771347233584885e-07,  -1.651336945717023e-08,
   1.285120004027197e-09,  -8.616255080206866e-11,   5.084109569276500e-12,  -2.679906350532455e-13,   1.277371794216151e-14,  -5.559769038548791e-16,   2.225789262516422e-17,
  -8.250412603599936e-19,   2.846363229945234e-20,  -1.777170387021644e-05,   5.039718719988181e-06,  -8.123768523749071e-07,   9.514335879809527e-08,  -8.870593524650090e-09,
   6.903931832493215e-10,  -4.629150958048154e-11,   2.731636512644698e-12,  -1.439956924382200e-13,   6.863819915896797e-15,  -2.987591270716713e-16,   1.196087249935474e-17,
  -4.433705566578520e-19,   1.529647619405449e-20,  -6.615358965305239e-06,   1.876093835710971e-06,  -3.024319590959501e-07,   3.542146281450572e-08,  -3.302595391983463e-09,
   2.570464709112795e-10,  -1.723562043063040e-11,   1.017085009649010e-12,  -5.361563463475708e-14,   2.555726195729003e-15,  -1.112436281185917e-16,   4.453708877279400e-18,
  -1.650935522400046e-19,   5.695844159097285e-21,  -7.472925199748986e-07,   2.119315285584955e-07,  -3.416427183452022e-08,   4.001417007364338e-09,  -3.730826221616205e-10,
   2.903777074584189e-11,  -1.947063887644193e-12,   1.148978560101980e-13,  -6.056857121070809e-15,   2.887162528248617e-16,  -1.256703799522154e-17,   5.031302186118962e-19,
  -1.865045240744614e-20,   6.434545895766757e-22,  -7.477016202019563e-03,   3.311323451096768e-04,  -1.105722155257261e-05,   4.324250668599979e-07,  -1.255279651257130e-08,
   1.324703971385166e-10,  -1.053096560561786e-11,   7.342512124203997e-13,   7.064304895118796e-15,  -7.099760014463446e-16,  -5.096193258035964e-17,   8.659089942232727e-19,
   1.206177532083745e-19,   1.278855648399783e-21,  -7.113663715469904e-03,   3.150646048388891e-04,  -1.052164525045167e-05,   4.114325516765204e-07,  -1.194689968183848e-08,
   1.264818795593364e-10,  -1.001323350774869e-11,   6.977870587939426e-13,   6.654377933492978e-15,  -6.740019934345278e-16,  -4.825359665074062e-17,   8.264285807699660e-19,
   1.141064125292788e-19,   1.192162206118707e-21,  -6.422391350749230e-03,   2.844862444583693e-04,  -9.502004991408494e-06,   3.714860253347376e-07,  -1.079251194979722e-08,
   1.149055122935766e-10,  -9.030760155090569e-12,   6.287350873881516e-13,   5.902023019187626e-15,  -6.061552791310638e-16,  -4.319705604081812e-17,   7.501845747343590e-19,
   1.019875417280496e-19,   1.037631259078605e-21,  -5.470674978920440e-03,   2.423682912153899e-04,  -8.096818038778869e-06,   3.164723871759005e-07,  -9.199946009934334e-09,
   9.861291159285039e-11,  -7.682909543255795e-12,   5.342862815173871e-13,   4.919155924936131e-15,  -5.139023186360602e-16,  -3.641985779181684e-17,   6.430935125365988e-19,
   8.581951914422675e-20,   8.446305573713286e-22,  -4.351533991247152e-03,   1.928171110652606e-04,  -6.442676067191615e-06,   2.517592342361442e-07,  -7.323109168864244e-09,
   7.900619257280960e-11,  -6.103882603274196e-12,   4.240025727609540e-13,   3.829758280419672e-15,  -4.068914348725919e-16,  -2.868124260847895e-17,   5.145928984362869e-19,
   6.745443601600015e-20,   6.420453063333168e-22,  -3.174490479955735e-03,   1.406799580098398e-04,  -4.701312768524869e-06,   1.836775512098377e-07,  -5.345342293841557e-09,
   5.796838715273414e-11,  -4.448589115160615e-12,   3.087374299727834e-13,   2.745293202216265e-15,  -2.957228101344040e-16,  -2.075502676760963e-17,   3.771512125015949e-19,
   4.873625721293054e-20,   4.511255019721234e-22,  -2.054838853199004e-03,   9.106936573980894e-05,  -3.043707900605414e-06,   1.189010618096176e-07,  -3.461331494200212e-09,
   3.766485800640443e-11,  -2.877752999439907e-12,   1.995985628312053e-13,   1.756337023991226e-15,  -1.909452965912703e-16,  -1.336305843027989e-17,   2.448628642426325e-19,
   3.134567551760714e-20,   2.847138976615014e-22,  -1.102296362824504e-03,   4.885528809090454e-05,  -1.632919237901788e-06,   6.378516523747387e-08,  -1.857154056688068e-09,
   2.024402846658893e-11,  -1.543244732988845e-12,   1.070047384249703e-13,   9.364842312699278e-16,  -1.022994777549934e-16,  -7.148799532471075e-18,   1.315538409264829e-19,
   1.675978598695140e-20,   1.507345243066807e-22,  -4.101980190237042e-04,   1.818081123385986e-05,  -6.076789673343040e-07,   2.373665517323863e-08,  -6.911501228593236e-10,
   7.538484207055740e-12,  -5.742243409364509e-13,   3.981094485119475e-14,   3.477588984675410e-16,  -3.805176018573685e-17,  -2.657741477543803e-18,   4.898091975522071e-20,
   6.229677009396295e-21,   5.583500994635283e-23,  -4.633511905065399e-05,   2.053671673207944e-06,  -6.864251719280854e-08,   2.681247988473531e-09,  -7.807172208613434e-11,
   8.516223553812829e-13,  -6.486204668810298e-14,   4.496804659337948e-15,   3.926894810588559e-17,  -4.297943491305462e-18,  -3.001673863081446e-19,   5.533243782953418e-21,
   7.035633156907713e-22,   6.302388670811466e-24,  -3.878550418267135e-03,   3.676791630799559e-04,  -2.344860777520996e-05,   1.120837830780404e-06,  -5.075794127080039e-08,
   2.240288064616184e-09,  -7.787635826965599e-11,   2.405694679844367e-12,  -1.028570274137009e-13,   3.718118867444996e-15,  -5.847544787309387e-17,   1.896413894229628e-18,
  -1.678234179882882e-19,   1.812843283815569e-21,  -3.690607038042105e-03,   3.498963841124382e-04,  -2.231719970991096e-05,   1.066990628254608e-06,  -4.832411707263450e-08,
   2.132840527151197e-09,  -7.417451436153619e-11,   2.292682000935840e-12,  -9.793490923790327e-14,   3.540412462082820e-15,  -5.595653169203933e-17,   1.808624563032014e-18,
  -1.593019994844229e-19,   1.743208505846331e-21,  -3.332829058123627e-03,   3.160304572641612e-04,  -2.016142758264560e-05,   9.642951876457860e-07,  -4.368051241940982e-08,
   1.927848521701079e-09,  -6.709829443853719e-11,   2.076097596658937e-12,  -8.854021015311276e-14,   3.201127296479827e-15,  -5.103208314291489e-17,   1.639887253850283e-18,
  -1.432436052928238e-19,   1.602961178688636e-21,  -2.839830290843391e-03,   2.693382907611736e-04,  -1.718706728462449e-05,   8.224190743941788e-07,  -3.726156138135129e-08,
   1.644506059181580e-09,  -5.729096189937068e-11,   1.774846105535883e-12,  -7.554634882630142e-14,   2.731673606121554e-15,  -4.399686385230231e-17,   1.404185788229617e-18,
  -1.214279991768496e-19,   1.395071503074236e-21,  -2.259566450133875e-03,   2.143473139978124e-04,  -1.368137604021968e-05,   6.549643743667352e-07,  -2.968063978059206e-08,
   1.309898752396934e-09,  -4.567583829445817e-11,   1.416710675920480e-12,  -6.019027644307983e-14,   2.176657987740318e-15,  -3.540218265277622e-17,   1.122641654447718e-18,
  -9.613839027230131e-20,   1.132265571814858e-21,  -1.648779276858625e-03,   1.564320467069556e-04,  -9.986757202902819e-06,   4.782670986109439e-07,  -2.167688505500337e-08,
   9.566513007516772e-10,  -3.338273339629775e-11,   1.036414986051177e-12,  -4.396771008782996e-14,   1.590137885115421e-15,  -2.606412321857423e-17,   8.223705971294583e-19,
  -6.987306479946189e-20,   8.391130347778985e-22,  -1.067421988768231e-03,   1.012851559539836e-04,  -6.466988123815816e-06,   3.097793530579871e-07,  -1.404189364764173e-08,
   6.196943904047272e-10,  -2.163496616535140e-11,   6.721137501598234e-13,  -2.848521191011459e-14,   1.030253075512720e-15,  -1.697277201427306e-17,   5.337798435910856e-19,
  -4.511796823700384e-20,   5.487142397738909e-22,  -5.726544517392467e-04,   5.434081580452789e-05,  -3.469859912711070e-06,   1.662324971221254e-07,  -7.535519803179583e-09,
   3.325543501070152e-10,  -1.161312643785917e-11,   3.608914159589482e-13,  -1.528750396433115e-14,   5.529334090314118e-16,  -9.132802013234720e-18,   2.867449793410136e-19,
  -2.417271713209320e-20,   2.958749924418757e-22,  -2.131082770131598e-04,   2.022283948270141e-05,  -1.291332847320499e-06,   6.186725268680656e-08,  -2.804571397449079e-09,
   1.237699078294047e-10,  -4.322540796382147e-12,   1.343431340595449e-13,  -5.689842361612332e-15,   2.057977096817495e-16,  -3.402210452267344e-18,   1.067590294984909e-19,
  -8.991483579730719e-21,   1.103008775680711e-22,  -2.407237968158371e-05,   2.284347441584140e-06,  -1.458679412637712e-07,   6.988523739340223e-09,  -3.168053045943383e-10,
   1.398108503577611e-11,  -4.882821651584574e-13,   1.517591922736995e-14,  -6.427288979474041e-16,   2.324709930295325e-17,  -3.843714719571385e-19,   1.206022054258539e-20,
  -1.015589153964956e-21,   1.246288360681010e-23,  -7.541757364272827e-04,   1.190354633654548e-04,  -1.099849715575434e-05,   7.669816418520012e-07,  -4.787018379076832e-08,
   2.675027560627939e-09,  -1.293942084838149e-10,   5.787455374186973e-12,  -2.518258137694952e-13,   9.883670254078952e-15,  -3.456441296603523e-16,   1.248210466580827e-17,
  -4.406864314370216e-19,   1.189785330011020e-20,  -7.178321484556452e-04,   1.133154962216723e-04,  -1.047220885146880e-05,   7.304819689670752e-07,  -4.560027976186621e-08,
   2.548577223841321e-09,  -1.233127573156490e-10,   5.516672522324310e-12,  -2.400465040845068e-13,   9.423606908685466e-15,  -3.297067522346174e-16,   1.190315546711120e-17,
  -4.201580107863941e-19,   1.136281664293918e-20,  -6.485648177353485e-04,   1.024071409295181e-04,  -9.467634916393811e-06,   6.607291741554436e-07,  -4.125901450357444e-08,
   2.306574610825062e-09,  -1.116593995792261e-10,   4.997286478204989e-12,  -2.174517036042318e-13,   8.540173214340374e-15,  -2.990389704751423e-16,   1.079061381618711e-17,
  -3.807465085916179e-19,   1.032735871770760e-20,  -5.529591171536995e-04,   8.733804496826088e-05,  -8.078129448006999e-06,   5.640885270805759e-07,  -3.523778701904643e-08,
   1.970608193744062e-09,  -9.545312733383975e-11,   4.273993841379844e-12,  -1.859841359419271e-13,   7.307994662074672e-15,  -2.561413318920577e-16,   9.237254826756001e-18,
  -3.257909101773606e-19,   8.867748391545903e-21,  -4.402287955468390e-04,   6.955343768939370e-05,  -6.436001670556171e-06,   4.496755124582722e-07,  -2.810099061927338e-08,
   1.571997952109944e-09,  -7.618952415689067e-11,   3.413007556696478e-12,  -1.485228321379641e-13,   5.838829950566126e-15,  -2.048385931503085e-16,   7.383011660067786e-18,
  -2.602808600175517e-19,   7.108301380474087e-21,  -3.213804257011991e-04,   5.078834794913633e-05,  -4.701265278406523e-06,   3.286216995325055e-07,  -2.054226252702208e-08,
   1.149450437429756e-09,  -5.573614699312589e-11,   2.497688457672584e-12,  -1.086941411022506e-13,   4.274712167763153e-15,  -1.500777115162325e-16,   5.406892904618243e-18,
  -1.905487274550506e-19,   5.217684690358589e-21,  -2.081265890750887e-04,   3.289586414018123e-05,  -3.045741922403691e-06,   2.129636733968831e-07,  -1.331506209030067e-08,
   7.451760459558536e-10,  -3.614428428357658e-11,   1.620115787693065e-12,  -7.050535397919314e-14,   2.773532940011000e-15,  -9.742156560598552e-17,   3.508836159768232e-18,
  -1.236295453943480e-19,   3.391122299559818e-21,  -1.116742762735080e-04,   1.765234276055984e-05,  -1.634579593792635e-06,   1.143103896610327e-07,  -7.147716755867127e-09,
   4.000560714224589e-10,  -1.940753332534589e-11,   8.700228969277051e-13,  -3.786265117945913e-14,   1.489631350857276e-15,  -5.233705866063926e-17,   1.884753133203056e-18,
  -6.639920034278816e-20,   1.822913412223204e-21,  -4.156089281731741e-05,   6.569713346203250e-06,  -6.083705888133772e-07,   4.254722368759903e-08,  -2.660529968820954e-09,
   1.489137689666166e-10,  -7.224507319033799e-12,   3.238823892742148e-13,  -1.409513314456995e-14,   5.545703162119611e-16,  -1.948609938149772e-17,   7.016948856909073e-19,
  -2.471946211381185e-20,   6.788514031523429e-22,  -4.694695090689704e-06,   7.421144746887159e-07,  -6.872196345828127e-08,   4.806204944563863e-09,  -3.005395573217128e-10,
   1.682172126030931e-11,  -8.161079427717047e-13,   3.658724257109774e-14,  -1.592251872717027e-15,   6.264729490676736e-17,  -2.201286699287289e-18,   7.926775504124822e-20,
  -2.792443923427664e-21,   7.669042962542915e-23,  -3.870428280174962e-05,   9.698856387211042e-06,  -1.389585288446484e-06,   1.477230599419023e-07,  -1.282688832436777e-08,
   9.422890889685289e-10,  -6.009473498498614e-11,   3.407818899614702e-12,  -1.740568474017203e-13,   8.057183945221779e-15,  -3.419459491934215e-16,   1.345491358449293e-17,
  -4.900477932844957e-19,   1.653627201380559e-20,  -3.686647023477347e-05,   9.240827186473809e-06,  -1.324350406151585e-06,   1.408245851828452e-07,  -1.223034965226890e-08,
   8.986248989219814e-10,  -5.731927258069098e-11,   3.250839299027533e-12,  -1.660561503791628e-13,   7.687656566979326e-15,  -3.262914941334548e-16,   1.283950573544979e-17,
  -4.676712664086167e-19,   1.578298519558653e-20,  -3.335265070971874e-05,   8.364061917255201e-06,  -1.199316067820166e-06,   1.275872415295987e-07,  -1.108463596025723e-08,
   8.146967825503186e-10,  -5.198059673867235e-11,   2.948712267836991e-12,  -1.506505614414682e-13,   6.975768355257041e-15,  -2.961214985028169e-16,   1.165322732306224e-17,
  -4.245214456349331e-19,   1.432961313572980e-20,  -2.848110852475409e-05,   7.146516255181347e-06,  -1.025371835373527e-06,   1.091424401751628e-07,  -9.486219577089281e-09,
   6.974776712110040e-10,  -4.451677078042813e-11,   2.525984812476892e-12,  -1.290815144262208e-13,   5.978389851715454e-15,  -2.538292552109254e-16,   9.989845426039179e-18,
  -3.639864311666862e-19,   1.228919515146526e-20,  -2.270956459854682e-05,   5.701500499537352e-06,  -8.185366131648156e-07,   8.717285814133942e-08,  -7.579840072654512e-09,
   5.575121121568646e-10,  -3.559513871472219e-11,   2.020271806413883e-12,  -1.032606485487788e-13,   4.783550704110477e-15,  -2.031349524313469e-16,   7.995422152848613e-18,
  -2.913653385038677e-19,   9.839555195430118e-21,  -1.659917355496991e-05,   4.169290575969720e-06,  -5.988548940876749e-07,   6.380433905988038e-08,  -5.549743244016185e-09,
   4.083130354997664e-10,  -2.607620254606031e-11,   1.480312260274647e-12,  -7.567491680591032e-14,   3.506257811289839e-15,  -1.489154408387158e-16,   5.861765414521036e-18,
  -2.136391231870579e-19,   7.216018499953834e-21,  -1.075843561691040e-05,   2.703047952298811e-06,  -3.883756788009501e-07,   4.139071123608417e-08,  -3.600977715057709e-09,
   2.649865714835303e-10,  -1.692585131046438e-11,   9.609896684017729e-13,  -4.913215252791212e-14,   2.276711086725794e-15,  -9.670398710135769e-17,   3.806748722105990e-18,
  -1.387532618943496e-19,   4.687184714653242e-21,  -5.775063039104074e-06,   1.451200829409199e-06,  -2.085436704954107e-07,   2.222852130084557e-08,  -1.934090382497676e-09,
   1.423386324131775e-10,  -9.092601722963775e-12,   5.162816805782210e-13,  -2.639724627708401e-14,   1.223281721611732e-15,  -5.196174626579015e-17,   2.045523252403301e-18,
  -7.456107180227064e-20,   2.518880765990729e-21,  -2.149571031040576e-06,   5.401888439616355e-07,  -7.763184045033995e-08,   8.275138109164705e-09,  -7.200428855851073e-10,
   5.299308462073002e-11,  -3.385306892193415e-12,   1.922237947748314e-13,  -9.828510197279721e-15,   4.554749534112398e-16,  -1.934768384112105e-17,   7.616464857067765e-19,
  -2.776308163635876e-20,   9.379342150513959e-22,  -2.428199557403485e-07,   6.102135381942470e-08,  -8.769605178075955e-09,   9.348003571211537e-10,  -8.134009347380643e-11,
   5.986429234949285e-12,  -3.824272541051158e-13,   2.171498885524907e-14,  -1.110303035052636e-15,   5.145407242250795e-17,  -2.185673981626311e-18,   8.604198924392743e-20,
  -3.136358522626072e-21,   1.059575422687514e-22,  -6.301162349685594e-03,   2.601639190559756e-04,  -7.010924875548868e-06,   2.460791836792421e-07,  -1.077368190725370e-08,
   1.179560571523807e-10,   7.451647982673955e-12,   3.262957308466947e-13,  -3.243059772661803e-14,  -6.361012699879184e-16,   6.667739426133839e-17,   2.115220336663101e-18,
  -1.464720688346454e-19,  -5.895994745550027e-21,  -5.994882992098799e-03,   2.475314765548987e-04,  -6.671825100436724e-06,   2.341454962398672e-07,  -1.024642474141997e-08,
   1.124192643119327e-10,   7.062696809470192e-12,   3.097665760342231e-13,  -3.076622090572400e-14,  -6.018262853710079e-16,   6.315539279387876e-17,   1.999290071552066e-18,
  -1.385687215287338e-19,  -5.562516251187831e-21,  -5.412219247836391e-03,   2.234941991634499e-04,  -6.026040327516107e-06,   2.114318512871293e-07,  -9.244847617238119e-09,
   1.018055583354074e-10,   6.333737436420395e-12,   2.785985439582248e-13,  -2.763623339184805e-14,  -5.380156542112102e-16,   5.657153933733475e-17,   1.784225339324336e-18,
  -1.238595633455428e-19,  -4.947820049552034e-21,  -4.610084993131862e-03,   1.903923790552464e-04,  -5.135684800729401e-06,   1.801411564000798e-07,  -7.868849340030320e-09,
   8.703840654560098e-11,   5.351389355249619e-12,   2.362225985519896e-13,  -2.339717536832410e-14,  -4.528432993747686e-16,   4.773132480985716e-17,   1.498632569871159e-18,
  -1.042349197477897e-19,  -4.139165854429657e-21,  -3.666908840470902e-03,   1.514568899551470e-04,  -4.087099931024825e-06,   1.433211127483203e-07,  -6.254475575691110e-09,
   6.947859362075324e-11,   4.222977816006877e-12,   1.870616667758750e-13,  -1.850044451517850e-14,  -3.560351762023798e-16,   3.761652085096358e-17,   1.175867065932542e-18,
  -8.193955344544545e-20,  -3.234919543202694e-21,  -2.674998096808690e-03,   1.104972060581140e-04,  -2.982773427438587e-06,   1.045728965645139e-07,  -4.559992665318957e-09,
   5.082940471943533e-11,   3.060983461526087e-12,   1.359748851793641e-13,  -1.343174917652559e-14,  -2.572993699440803e-16,   2.723707728398276e-17,   8.483850213953267e-19,
  -5.920922244511402e-20,  -2.326517850134965e-21,  -1.731496999292899e-03,   7.152786520290155e-05,  -1.931249870993437e-06,   6.769772177018039e-08,  -2.950513050846665e-09,
   3.296321910869428e-11,   1.972950291429368e-12,   8.780815709921542e-14,  -8.666839683906955e-15,  -1.655146692837346e-16,   1.754340095727363e-17,   5.451557810695823e-19,
  -3.808509592206456e-20,  -1.491791536012141e-21,  -9.288370657621566e-04,   3.837127725201075e-05,  -1.036138538289844e-06,   3.631791995506232e-08,  -1.582452894948455e-09,
   1.769968631867705e-11,   1.056053083266116e-12,   4.704660629378652e-14,  -4.641676446086417e-15,  -8.850453851886112e-17,   9.387048942961978e-18,   2.913453869000342e-19,
  -2.036422790071325e-20,  -7.963761584128794e-22,  -3.456477576317153e-04,   1.427923874709206e-05,  -3.855968317482734e-07,   1.351528824047989e-08,  -5.888376773348195e-10,
   6.588782177496634e-12,   3.926898379026979e-13,   1.750008212604324e-14,  -1.726331233534074e-15,  -3.289849857219630e-17,   3.490112292338540e-18,   1.082765980516179e-19,
  -7.569599670626354e-21,  -2.958545336938071e-22,  -3.904364119634161e-05,   1.612955379003207e-06,  -4.355654523137229e-08,   1.526664091642912e-09,  -6.651314674141508e-11,
   7.442944496343270e-13,   4.435206105638576e-14,   1.976640605059352e-15,  -1.949852805488175e-16,  -3.715488154088560e-18,   3.941804170827294e-19,   1.222815858053996e-20,
  -8.548931414369952e-22,  -3.341013699993521e-23,  -2.713548200967612e-03,   2.229214188568132e-04,  -1.367203777345042e-05,   5.832586792577811e-07,  -2.063630184726161e-08,
   9.169203838080851e-10,  -3.934629088582223e-11,   8.498342741607720e-13,  -7.994416604664280e-15,   1.350029316940750e-15,  -7.885903382286669e-17,  -5.427258171720760e-19,
   9.558016183792910e-20,   4.045170977257941e-21,  -2.581972275981539e-03,   2.121309955389419e-04,  -1.301074943723351e-05,   5.551630392530106e-07,  -1.965011974015699e-08,
   8.728584302952360e-10,  -3.743972377901916e-11,   8.099375558416363e-13,  -7.709607942403747e-15,   1.283561824532981e-15,  -7.484314116889661e-17,  -5.073066521831021e-19,
   9.026364926158513e-20,   3.821621846834287e-21,  -2.331532717116217e-03,   1.915850671624994e-04,  -1.175139499776133e-05,   5.016107114446264e-07,  -1.776715166540911e-08,
   7.888304527844288e-10,  -3.381039023406463e-11,   7.334632998674864e-13,  -7.125255746699664e-15,   1.157478994922361e-15,  -6.727946738095109e-17,  -4.436852819787157e-19,
   8.042849711082745e-20,   3.407672980472769e-21,  -1.986507739303284e-03,   1.632646440633585e-04,  -1.001511164075486e-05,   4.276863387317617e-07,  -1.516162318971409e-08,
   6.727535789100648e-10,  -2.880944182431067e-11,   6.270700453235208e-13,  -6.238660977361129e-15,   9.845916489524633e-16,  -5.701263835317177e-17,  -3.633059937298525e-19,
   6.742342747328504e-20,   2.859391376340246e-21,  -1.580495521852249e-03,   1.299195556896138e-04,  -7.970271528467262e-06,   3.405093522839866e-07,  -1.208110643788688e-08,
   5.357605671948799e-10,  -2.292320596111345e-11,   5.005615291671535e-13,  -5.092710353048176e-15,   7.821439301740021e-16,  -4.512244531628729e-17,  -2.777878555140739e-19,
   5.279901535618601e-20,   2.241456039037997e-21,  -1.153205532479154e-03,   9.480951578287089e-05,  -5.816727860993256e-06,   2.485905492324894e-07,  -8.825703088682896e-09,
   3.912156529247627e-10,  -1.672710960075591e-11,   3.662053655477107e-13,  -3.791544553819389e-15,   5.699902251013502e-16,  -3.278499268165662e-17,  -1.961218545624128e-19,
   3.803265886194621e-20,   1.616015439520685e-21,  -7.465596397413093e-04,   6.138354767081686e-05,  -3.766148947136019e-06,   1.609912797166882e-07,  -5.718160070985353e-09,
   2.533923997527278e-10,  -1.082931093998501e-11,   2.374884431546467e-13,  -2.486848149003872e-15,   3.687037828375128e-16,  -2.116539782463090e-17,  -1.241737625734300e-19,
   2.441230705370880e-20,   1.037925060826880e-21,  -4.005095446862448e-04,   3.293229942036300e-05,  -2.020585221881414e-06,   8.638390725270016e-08,  -3.068907976896446e-09,
   1.359736515548624e-10,  -5.809795368683944e-12,   1.275206126438349e-13,  -1.343010531276637e-15,   1.977191820487901e-16,  -1.133851810487368e-17,  -6.584983801995724e-20,
   1.303913863788484e-20,   5.545598136967222e-22,  -1.490451044728887e-04,   1.225559657591249e-05,  -7.519568506846848e-07,   3.214891147360798e-08,  -1.142223417501528e-09,
   5.060563516262035e-11,  -2.162070152570685e-12,   4.747016088103487e-14,  -5.009359075066418e-16,   7.356855195221276e-17,  -4.217412088767267e-18,  -2.440621208085275e-20,
   4.844943433751563e-21,   2.060812411500312e-22,  -1.683588588467582e-05,   1.384375527045063e-06,  -8.494012741288406e-08,   3.631525232784654e-09,  -1.290265871609773e-10,
   5.716410001742908e-12,  -2.442241977819817e-13,   5.362415385704552e-15,  -5.660548709658812e-17,   8.309994296174101e-18,  -4.763543879585113e-19,  -2.755110160667964e-21,
   5.471436913701485e-22,   2.327336369136124e-23,  -4.098528420225776e-04,   5.803097189631490e-05,  -5.052565802255853e-06,   3.024922986608312e-07,  -1.588803078985322e-08,
   8.577607461237129e-10,  -4.097819266126563e-11,   1.530473105051138e-12,  -5.596402428022416e-14,   2.563889864921823e-15,  -9.581749856600027e-17,   1.893480189320076e-18,
  -5.272213402024599e-20,   4.707855429827463e-21,  -3.900719168372804e-04,   5.523580140272027e-05,  -4.809686586913413e-06,   2.880369678978140e-07,  -1.513368746596980e-08,
   8.170075485698560e-10,  -3.903232658098836e-11,   1.458796599783410e-12,  -5.337098757848665e-14,   2.442380487752910e-15,  -9.126419826104302e-17,   1.812144849984267e-18,
  -5.050270034062225e-20,   4.467364759730734e-21,  -3.523837101656082e-04,   4.990793667874923e-05,  -4.346537237655374e-06,   2.604368396266061e-07,  -1.369136965710952e-08,
   7.390991034976580e-10,  -3.531198354449504e-11,   1.321340324787105e-12,  -4.838648171071314e-14,   2.209979925157521e-15,  -8.256063441098431e-17,   1.653025788817005e-18,
  -4.614042368443208e-20,   4.014866018801631e-21,  -3.003887444774730e-04,   4.255313890051479e-05,  -3.706802226955564e-06,   2.222455927153898e-07,  -1.169167356074165e-08,
   6.311063403082407e-10,  -3.015421749897206e-11,   1.129972692838455e-12,  -4.142437633005932e-14,   1.887610058481599e-15,  -7.049754731427907e-17,   1.425501374544454e-18,
  -3.986397209217366e-20,   3.401370489801137e-21,  -2.391108712425388e-04,   3.387963553612623e-05,  -2.951874778179564e-06,   1.770915830194558e-07,  -9.322468804174492e-09,
   5.031862309338974e-10,  -2.404364007832366e-11,   9.022454432060159e-13,  -3.311110380244821e-14,   1.505442683016948e-15,  -5.620921449101067e-17,   1.147302914487736e-18,
  -3.214152960031868e-20,   2.691550970415010e-21,  -1.745356170286993e-04,   2.473416178433009e-05,  -2.155410999394451e-06,   1.293731774942902e-07,  -6.814121890215031e-09,
   3.677780569655390e-10,  -1.757432431129984e-11,   6.602175310453896e-13,  -2.424960516623608e-14,   1.100591914375917e-15,  -4.108420441988707e-17,   8.448324987963126e-19,
  -2.370148808773743e-20,   1.955454957254893e-21,  -1.130199306726643e-04,   1.601831774108868e-05,  -1.396042170482468e-06,   8.382123235617992e-08,  -4.416448118422587e-09,
   2.383608497998819e-10,  -1.139048129974022e-11,   4.282217803405752e-13,  -1.573724419418092e-14,   7.134222339927341e-16,  -2.662765648855639e-17,   5.502137483406007e-19,
  -1.545040749833677e-20,   1.262365287485872e-21,  -6.064032500915100e-05,   8.595050299694722e-06,  -7.491263881262775e-07,   4.498659705984985e-08,  -2.370723720343258e-09,
   1.279486150931020e-10,  -6.114348167537000e-12,   2.299533912447644e-13,  -8.453251524921772e-15,   3.829873513452841e-16,  -1.429350930413695e-17,   2.960796700779705e-19,
  -8.318080400090182e-21,   6.762556500980183e-22,  -2.256766335560088e-05,   3.198764088472496e-06,  -2.788031021382809e-07,   1.674367904763132e-08,  -8.824214876417195e-10,
   4.762426085462710e-11,  -2.275859350814835e-12,   8.560353989581768e-14,  -3.147159891338099e-15,   1.425575097653396e-16,  -5.320267424777454e-18,   1.102997855631028e-19,
  -3.099279295796176e-21,   2.515357816085865e-22,  -2.549224374989751e-06,   3.613308662881225e-07,  -3.149356580422188e-08,   1.891381469029832e-09,  -9.968014442553666e-11,
   5.379729516047569e-12,  -2.570857610811098e-13,   9.670152320103245e-15,  -3.555226191874199e-16,   1.610365142664834e-17,  -6.009882306020489e-19,   1.246137764444789e-20,
  -3.501575098180170e-22,   2.841082144531046e-23,  -1.444086110208836e-05,   3.231808498854970e-06,  -4.128589601255617e-07,   3.870544589913292e-08,  -3.059959154723442e-09,
   2.117988660935195e-10,  -1.276448941281725e-11,   6.812108437336062e-13,  -3.341966322093762e-14,   1.519164151144162e-15,  -6.230190320878022e-17,   2.324499628285701e-18,
  -8.455118369540755e-20,   2.974784274038657e-21,  -1.375155113455759e-05,   3.078187936527305e-06,  -3.933373902653494e-07,   3.688710198226129e-08,  -2.916922647551464e-09,
   2.019300036811548e-10,  -1.217192687013815e-11,   6.497291464036725e-13,  -3.187885170934542e-14,   1.449139699106181e-15,  -5.944012077816697e-17,   2.218430006498460e-18,
  -8.067940609687107e-20,   2.837131993960909e-21,  -1.243510709665703e-05,   2.784539219716641e-06,  -3.559790098805086e-07,   3.340245331470178e-08,  -2.642511081050111e-09,
   1.829837293318129e-10,  -1.103339998834323e-11,   5.891815132204182e-13,  -2.891393148266991e-14,   1.314389072792817e-15,  -5.392882213701169e-17,   2.013853670092438e-18,
  -7.321806294532607e-20,   2.572492894829716e-21,  -1.061287908175717e-05,   2.377556486221864e-06,  -3.041196823765569e-07,   2.855574632727567e-08,  -2.260261505343835e-09,
   1.565664952687577e-10,  -9.444139798311085e-12,   5.045480449068529e-13,  -2.476659783145944e-14,   1.125887696864927e-15,  -4.621093613232894e-17,   1.726788315768196e-18,
  -6.275967221922840e-20,   2.202749618838688e-21,  -8.457646716499570e-06,   1.895549898766080e-06,  -2.425962446822473e-07,   2.279389649194045e-08,  -1.805107674155615e-09,
   1.250786615441503e-10,  -7.547583394189799e-12,   4.034049916453993e-13,  -1.980648903789940e-14,   9.004272238774709e-16,  -3.696961621241991e-17,   1.382337691100969e-18,
  -5.022451830568304e-20,   1.761048566425855e-21,  -6.179274934058799e-06,   1.385398202296914e-06,  -1.773832679667431e-07,   1.667541014956116e-08,  -1.321104781896651e-09,
   9.156509026668425e-11,  -5.526929423174533e-12,   2.955098843630966e-13,  -1.451177479584129e-14,   6.597390822574526e-16,  -2.709477376211296e-17,   1.013615607099215e-18,
  -3.681843530354593e-20,   1.289976969252237e-21,  -4.003823241377090e-06,   8.978670147240123e-07,  -1.149939319799281e-07,   1.081409192779181e-08,  -8.569726711321528e-10,
   5.940649168315617e-11,  -3.586518621731707e-12,   1.918063547590276e-13,  -9.420322742682029e-15,   4.282769696689462e-16,  -1.759198300160795e-17,   6.583329322223966e-19,
  -2.390929181875524e-20,   8.372643016330704e-22,  -2.148909763438575e-06,   4.819551813780915e-07,  -6.173531228748950e-08,   5.806659595638270e-09,  -4.602172213503192e-10,
   3.190567289241280e-11,  -1.926419072719197e-12,   1.030369080466814e-13,  -5.060849797810959e-15,   2.300838833540503e-16,  -9.451821811927213e-18,   3.537686407997691e-19,
  -1.284708246348681e-20,   4.497674023844634e-22,  -7.998174325000699e-07,   1.793895797794818e-07,  -2.297981396405448e-08,   2.161554625466950e-09,  -1.713260650237563e-10,
   1.187795681501791e-11,  -7.171991944011870e-13,   3.836188772750457e-14,  -1.884257640592823e-15,   8.566518872293905e-17,  -3.519227461859152e-18,   1.317275135666868e-19,
  -4.783538041975978e-21,   1.674533074696801e-22,  -9.034827987949044e-08,   2.026418172583350e-08,  -2.595863822305797e-09,   2.441776415494672e-10,  -1.935380709681141e-11,
   1.341796990964729e-12,  -8.101907389915103e-14,   4.333615014009719e-15,  -2.128590790738375e-16,   9.677350773782256e-18,  -3.975590165094994e-19,   1.488109137114178e-20,
  -5.403878182226968e-22,   1.891663447376875e-23,  -5.357792430162099e-03,   2.132068233799980e-04,  -4.979703109315499e-06,   1.032146422950377e-07,  -6.508137470666547e-09,
   2.882580026958757e-10,   2.631162448300709e-12,  -5.257089543123238e-13,  -6.797778405314235e-15,   1.536546643103435e-15,  -4.340592802912784e-18,  -3.551426597937161e-18,
   4.791609810994419e-20,   7.788869729629678e-21,  -5.097337393493172e-03,   2.028457418894533e-04,  -4.738646809488852e-06,   9.827896126996799e-08,  -6.190427946925521e-09,
   2.739163676314818e-10,   2.497494581870803e-12,  -4.985323588206984e-13,  -6.472225174792471e-15,   1.456167262393391e-15,  -4.040912381169706e-18,  -3.361260093596225e-18,
   4.508839658937150e-20,   7.362676414391786e-21,  -4.601861654390927e-03,   1.831339961563873e-04,  -4.279659496557216e-06,   8.885617753127126e-08,  -5.586580108175392e-09,
   2.467686587225763e-10,   2.245549427706905e-12,  -4.475003543534360e-13,  -5.850757735357614e-15,   1.305608223346338e-15,  -3.508187588036501e-18,  -3.006772611704581e-18,
   3.991925534240590e-20,   6.571729222356069e-21,  -3.919779833359179e-03,   1.559957323072523e-04,  -3.647004723296805e-06,   7.581994486301440e-08,  -4.756365769919489e-09,
   2.096570583010551e-10,   1.903253682861969e-12,  -3.785342549936538e-13,  -4.991217726303841e-15,   1.102864063156514e-15,  -2.845979319354615e-18,  -2.532735120237154e-18,
   3.320328327149492e-20,   5.520846216866020e-21,  -3.117795147863569e-03,   1.240834400784649e-04,  -2.902119147329599e-06,   6.041046018121584e-08,  -3.781538077568588e-09,
   1.663492531027311e-10,   1.506536503532412e-12,  -2.990593719934790e-13,  -3.975736643714109e-15,   8.701400027064298e-16,  -2.155439068667218e-18,  -1.992807396870692e-18,
   2.580170744902676e-20,   4.332538650244257e-21,  -2.274399161358083e-03,   9.052013812837639e-05,  -2.117823259315448e-06,   4.412938078734211e-08,  -2.757608931290200e-09,
   1.211087594197100e-10,   1.094702654093090e-12,  -2.169747698912447e-13,  -2.903521686984172e-15,   6.306227427428770e-16,  -1.509565124876208e-18,  -1.441055089055127e-18,
   1.846925910171518e-20,   3.126319741682502e-21,  -1.472184159603575e-03,   5.859341129312168e-05,  -1.371158850251106e-06,   2.859016247435404e-08,  -1.784538478726392e-09,
   7.828894171322771e-11,   7.067444212853659e-13,  -1.399389062044136e-13,  -1.880770568193542e-15,   4.064315661305855e-16,  -9.505113498370039e-19,  -9.273804825108964e-19,
   1.180541220562080e-20,   2.009076870784715e-21,  -7.897297356224150e-04,   3.143180400729476e-05,  -7.356255332523313e-07,   1.534386261029159e-08,  -9.571716367782208e-10,
   4.196854708891504e-11,   3.786147439040227e-13,  -7.492899238670436e-14,  -1.009280342498772e-15,   2.175398941211308e-16,  -5.025989018051855e-19,  -4.959977702171621e-19,
   6.291889795754272e-21,   1.073746667183092e-21,  -2.938814635191788e-04,   1.169672998282474e-05,  -2.737592666360039e-07,   5.710821351977348e-09,  -3.561765124262759e-10,
   1.561405635022037e-11,   1.408279053964850e-13,  -2.786527507388456e-14,  -3.756303917693037e-16,   8.089034514156796e-17,  -1.860902628072825e-19,  -1.843837361816966e-19,
   2.336107655239608e-21,   3.990564953309337e-22,  -3.319622377027643e-05,   1.321238391406418e-06,  -3.092347040515956e-08,   6.450987451892305e-10,  -4.023267151510097e-11,
   1.763664867859575e-12,   1.590644267464890e-14,  -3.147279738758365e-15,  -4.243126269520102e-17,   9.136079421070550e-18,  -2.100349753997074e-20,  -2.082416284129359e-20,
   2.637870302793824e-22,   4.506732782044273e-23,  -2.002746161426856e-03,   1.370282371069227e-04,  -8.193369127674710e-06,   3.564114964519571e-07,  -9.850416851605809e-09,
   2.529491571600600e-10,  -1.597910897036132e-11,   8.090866495663530e-13,  -7.937267957601855e-15,  -7.942144558851154e-16,  -1.515476816166771e-18,   2.696548181864159e-18,
  -5.003706060255609e-20,  -5.007869141009870e-21,  -1.905578130347113e-03,   1.303950741751531e-04,  -7.796615559566511e-06,   3.391522674188944e-07,  -9.378440574143015e-09,
   2.411469137876503e-10,  -1.520850376974649e-11,   7.689118367277947e-13,  -7.553982304243568e-15,  -7.512811861525014e-16,  -1.535509036078320e-18,   2.554167350291948e-18,
  -4.720024323229727e-20,  -4.735148129950965e-21,  -1.720653559850066e-03,   1.177650782418098e-04,  -7.041225924921574e-06,   3.062922761675211e-07,  -8.477785865810175e-09,
   2.184932750296613e-10,  -1.374003713097948e-11,   6.928346112851795e-13,  -6.823966626961392e-15,  -6.713909382607465e-16,  -1.534446597726631e-18,   2.287995032466485e-18,
  -4.197381811607472e-20,  -4.228503667109417e-21,  -1.465932771338680e-03,   1.003562219754038e-04,  -6.000124473306720e-06,   2.610040951151917e-07,  -7.232509246199753e-09,
   1.869175071354132e-10,  -1.171364986731813e-11,   5.887759603152300e-13,  -5.817151451868217e-15,  -5.648458294298243e-16,  -1.458099328757571e-18,   1.930569645657305e-18,
  -3.510326629947820e-20,  -3.554375613544846e-21,  -1.166244881017451e-03,   7.985902073786999e-05,  -4.774465360582221e-06,   2.076880208017356e-07,  -5.761463177885239e-09,
   1.492980740310805e-10,  -9.324879502903776e-12,   4.672643933601958e-13,  -4.630737567797352e-15,  -4.438791200033297e-16,  -1.275156745066263e-18,   1.521555942096310e-18,
  -2.742669398823796e-20,  -2.790878428346094e-21,  -8.509052330169357e-04,   5.827726383632526e-05,  -3.484077341252014e-06,   1.515564515671362e-07,  -4.208054629271475e-09,
   1.092774960311324e-10,  -6.807009471528417e-12,   3.402524398879740e-13,  -3.380396061328023e-15,  -3.206479551346206e-16,  -9.973582858902747e-19,   1.101778022542160e-18,
  -1.972045725539923e-20,  -2.014763317854781e-21,  -5.508386996965441e-04,   3.773094752219111e-05,  -2.255684627703786e-06,   9.812170695565424e-08,  -2.726003650949204e-09,
   7.089010744749330e-11,  -4.408045271969141e-12,   2.199797238753130e-13,  -2.189104906335181e-15,  -2.062051871936878e-16,  -6.740852859448640e-19,   7.096833174947457e-19,
  -1.264310191786106e-20,  -1.295129735328395e-21,  -2.955053444057189e-04,   2.024263317170669e-05,  -1.210162241673629e-06,   5.264175817527993e-08,  -1.462925622764174e-09,
   3.807094014452599e-11,  -2.365168757359367e-12,   1.179330546100622e-13,  -1.174598445809502e-15,  -1.102456853499369e-16,  -3.694220857209634e-19,   3.797423938213670e-19,
  -6.748861447234916e-21,  -6.922819601642550e-22,  -1.099683189131136e-04,   7.533193702749335e-06,  -4.503542983305397e-07,   1.959030197027282e-08,  -5.444755735078306e-10,
   1.417288428349674e-11,  -8.802186155044537e-13,   4.387707189679981e-14,  -4.371399572911524e-16,  -4.097778561181505e-17,  -1.384835395955580e-19,   1.411895843379897e-19,
  -2.507142123876022e-21,  -2.572989195225903e-22,  -1.242182570432746e-05,   8.509392342878808e-07,  -5.087137789824393e-08,   2.212892538574216e-09,  -6.150420370838725e-11,
   1.601038766310237e-12,  -9.942887987560923e-14,   4.956094667535560e-15,  -4.937907402219239e-17,  -4.627905908383123e-18,  -1.566091321088669e-20,   1.594625936917672e-20,
  -2.831243042324937e-22,  -2.905821533774612e-23,  -2.403257517631992e-04,   2.882578954195695e-05,  -2.521918188102602e-06,   1.438807522482945e-07,  -5.865023062137739e-09,
   2.486131039426952e-10,  -1.375343886842989e-11,   6.211495938742519e-13,  -1.494133940724131e-14,   1.994347355621005e-16,  -2.193500912298695e-17,   1.639336261768993e-18,
  -2.238130333536831e-20,  -1.983049495470956e-21,  -2.287127674060118e-04,   2.743667066237964e-05,  -2.400312579320495e-06,   1.369574545130170e-07,  -5.585928094914777e-09,
   2.369093844017298e-10,  -1.309707524559221e-11,   5.911682260987628e-13,  -1.424428697665239e-14,   1.923734766529182e-16,  -2.091147842820405e-17,   1.555247254044342e-18,
  -2.124427214564683e-20,  -1.868223067200141e-21,  -2.065924953665347e-04,   2.478914465707638e-05,  -2.168575142712451e-06,   1.237581927869138e-07,  -5.052553301146123e-09,
   2.144897314777011e-10,  -1.184350752313021e-11,   5.340500453920546e-13,  -1.290642339727975e-14,   1.778598549729609e-16,  -1.894684869599838e-17,   1.397126628426293e-18,
  -1.910301852753200e-20,  -1.657474058930203e-21,  -1.760862782678773e-04,   2.113492007022583e-05,  -1.848781007280477e-06,   1.055319301137461e-07,  -4.313561839616990e-09,
   1.833254483344786e-10,  -1.010821662923402e-11,   4.552548412133763e-13,  -1.104168348910354e-14,   1.557945314777359e-16,  -1.620845720602966e-17,   1.182976021456681e-18,
  -1.619570958591020e-20,  -1.382066839874148e-21,  -1.401476966417776e-04,   1.682617216507091e-05,  -1.471781172716860e-06,   8.403069281791860e-08,  -3.438655822534543e-09,
   1.463015894192926e-10,  -8.055671113814178e-12,   3.623933386886117e-13,  -8.819896881214836e-15,   1.272250953408132e-16,  -1.294603277402558e-17,   9.355498894481216e-19,
  -1.282566296722711e-20,  -1.076571333571680e-21,  -1.022883595191122e-04,   1.228359889374097e-05,  -1.074390234404366e-06,   6.135281664467667e-08,  -2.512961626418639e-09,
   1.070102735978259e-10,  -5.885710861557812e-12,   2.645311222319364e-13,  -6.456011824745124e-15,   9.474611368138230e-17,  -9.475548141801954e-18,   6.793425306964377e-19,
  -9.324162039208600e-21,  -7.721156597853920e-22,  -6.623198582010800e-05,   7.954873379444340e-06,  -6.957538270432239e-07,   3.973557692155327e-08,  -1.628527290983194e-09,
   6.938797094215989e-11,  -3.813665693233683e-12,   1.713000183115107e-13,  -4.188298793135827e-15,   6.215416615676169e-17,  -6.146850966914698e-18,   4.384001712776412e-19,
  -6.022044687743424e-21,  -4.941580000640016e-22,  -3.553523206689812e-05,   4.268335785626286e-06,  -3.733135089654329e-07,   2.132181065266303e-08,  -8.741281329428866e-10,
   3.725564216772842e-11,  -2.046865087172009e-12,   9.191140964004973e-14,  -2.249343739386341e-15,   3.356896573176740e-17,  -3.301087826777834e-18,   2.348088310634836e-19,
  -3.226812036723513e-21,  -2.635411352417719e-22,  -1.322449123094209e-05,   1.588510909262648e-06,  -1.389321727613534e-07,   7.935282951875309e-09,  -3.253573091923030e-10,
   1.386825936002808e-11,  -7.618387700064028e-13,   3.420554529493007e-14,  -8.373829929894510e-16,   1.252141976250344e-17,  -1.228911034724935e-18,   8.733218364796436e-20,
  -1.200325693786697e-21,  -9.787198786683245e-23,  -1.493824597523985e-06,   1.794372929224499e-07,  -1.569368523412285e-08,   8.963672682817301e-10,  -3.675290045985856e-11,
   1.566606968278938e-12,  -8.605820404448654e-14,   3.863832669503900e-15,  -9.459503240179985e-17,   1.414920294619295e-18,  -1.388237739305787e-19,   9.864014931524549e-21,
  -1.355779125940872e-22,  -1.105183979238967e-23,  -6.033675222648269e-06,   1.193470778957568e-06,  -1.426608036576827e-07,   1.181041164064569e-08,  -8.023589739240494e-10,
   5.073422434748565e-11,  -2.983865127012037e-12,   1.523048390461855e-13,  -6.701045118700920e-15,   2.