/*
 * Copyright (C) 2019 Rerrah
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef EFFECTDESCRIPTION_HPP
#define EFFECTDESCRIPTION_HPP

#include <unordered_map>
#include <QObject>
#include <QString>
#include "effect.hpp"
#include "enum_hash.hpp"

class EffectDescription : public QObject
{
	Q_OBJECT

public:
	static QString getEffectFormat(const EffectType type);
	static QString getEffectDescription(const EffectType type);
	static QString getEffectFormatAndDetailString(const EffectType type);

private:
	EffectDescription();

	struct EffectDetail
	{
		const QString format;
		const char* desc;

		QString mergedString() const { return format + " - " + tr(desc); }
	};

	static const std::unordered_map<EffectType, EffectDetail> details_;
};

#endif // EFFECTDESCRIPTION_HPP
