/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.rsrc;

import com.kreative.rsrc.MacResource;
import com.kreative.rsrc.MacResourceAlreadyExistsException;

public abstract class MacResourceProvider {
    public static final short RESOURCE_MAP_ATTRIBUTES_CHANGED = 32;
    public static final short RESOURCE_MAP_ATTRIBUTES_NEEDS_COMPRESSION = 64;
    public static final short RESOURCE_MAP_ATTRIBUTES_READ_ONLY = 128;

    public abstract boolean isReadOnly();

    public abstract void flush();

    public abstract void close();

    public abstract short getResourceMapAttributes();

    public abstract void setResourceMapAttributes(short var1);

    public abstract boolean add(MacResource var1) throws MacResourceAlreadyExistsException;

    public abstract boolean contains(int var1, short var2);

    public abstract boolean contains(int var1, String var2);

    public abstract MacResource get(int var1, short var2);

    public abstract MacResource get(int var1, String var2);

    public abstract MacResource getAttributes(int var1, short var2);

    public abstract MacResource getAttributes(int var1, String var2);

    public abstract byte[] getData(int var1, short var2);

    public abstract byte[] getData(int var1, String var2);

    public abstract boolean remove(int var1, short var2);

    public abstract boolean remove(int var1, String var2);

    public abstract boolean set(int var1, short var2, MacResource var3) throws MacResourceAlreadyExistsException;

    public abstract boolean set(int var1, String var2, MacResource var3) throws MacResourceAlreadyExistsException;

    public abstract boolean setAttributes(int var1, short var2, MacResource var3) throws MacResourceAlreadyExistsException;

    public abstract boolean setAttributes(int var1, String var2, MacResource var3) throws MacResourceAlreadyExistsException;

    public abstract boolean setData(int var1, short var2, byte[] var3);

    public abstract boolean setData(int var1, String var2, byte[] var3);

    public abstract int getTypeCount();

    public abstract int getType(int var1);

    public abstract int[] getTypes();

    public abstract int getResourceCount(int var1);

    public abstract short getID(int var1, int var2);

    public abstract short[] getIDs(int var1);

    public abstract String getName(int var1, int var2);

    public abstract String[] getNames(int var1);

    public final short getNextAvailableID(int type) {
        return this.getNextAvailableID(type, (short)128);
    }

    public abstract short getNextAvailableID(int var1, short var2);

    public abstract String getNameFromID(int var1, short var2);

    public abstract short getIDFromName(int var1, String var2);

    public final MacResourceProvider copyTo(MacResourceProvider rp) throws MacResourceAlreadyExistsException {
        int[] nArray = this.getTypes();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int type = nArray[n2];
            short[] sArray = this.getIDs(type);
            int n3 = sArray.length;
            int n4 = 0;
            while (n4 < n3) {
                short id = sArray[n4];
                rp.add(this.get(type, id));
                ++n4;
            }
            ++n2;
        }
        rp.setResourceMapAttributes(this.getResourceMapAttributes());
        return rp;
    }

    public final MacResourceProvider copyFrom(MacResourceProvider rp) throws MacResourceAlreadyExistsException {
        int[] nArray = rp.getTypes();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int type = nArray[n2];
            short[] sArray = rp.getIDs(type);
            int n3 = sArray.length;
            int n4 = 0;
            while (n4 < n3) {
                short id = sArray[n4];
                this.add(rp.get(type, id));
                ++n4;
            }
            ++n2;
        }
        this.setResourceMapAttributes(rp.getResourceMapAttributes());
        return this;
    }
}

