/*
 * Copyright 2021 Bloomberg Finance LP
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef INCLUDED_BUILDBOXCASD_ACINSTANCE_H
#define INCLUDED_BUILDBOXCASD_ACINSTANCE_H

#include <buildboxcasd_actionstorage.h>
#include <buildboxcasd_casinstance.h>
#include <buildboxcommon_protos.h>
#include <grpc/grpc.h>

using namespace build::bazel::remote::execution::v2;
using namespace build::buildgrid;

namespace buildboxcasd {

class AcInstance {
    /* Defines a common interface which provides the necessary methods to
     * service the calls of the ActionCache portion of the Remote
     * Execution API.
     */
  public:
    virtual ~AcInstance() = default;

    virtual std::shared_ptr<AcInstance> clone(std::shared_ptr<CasInstance> cas,
                                              bool readOnly) = 0;

    virtual grpc::Status GetActionResult(const GetActionResultRequest &request,
                                         ActionResult *result) = 0;
    virtual grpc::Status
    UpdateActionResult(const UpdateActionResultRequest &request,
                       ActionResult *result) = 0;

  protected:
    AcInstance(std::shared_ptr<ActionStorage> storage,
               std::shared_ptr<CasInstance> cas, bool readOnly)
        : d_storage(storage), d_cas(cas), d_readOnly(readOnly) {};
    /*
     * Checks if any of the ActionResult's files or directories
     * are missing from d_cas.
     */
    bool hasAllDigests(ActionResult *result);

    bool isReadOnly() const { return d_readOnly; }

    // NOLINTBEGIN (cppcoreguidelines-non-private-member-variables-in-classes)
    std::shared_ptr<ActionStorage> d_storage;
    std::shared_ptr<CasInstance> d_cas;
    // NOLINTEND (cppcoreguidelines-non-private-member-variables-in-classes)

  private:
    bool d_readOnly;
};

} // namespace buildboxcasd

#endif // INCLUDED_BUILDBOXCASD_ACINSTANCE_H
