/**
 *    Copyright 2011 Peter Murray-Rust et. al.
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

// /*======AUTOGENERATED FROM SCHEMA; DO NOT EDIT BELOW THIS LINE ======*/
package org.xmlcml.cml.element;

import java.io.IOException;
import java.io.Writer;

import nu.xom.Element;
import nu.xom.Node;

import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLElements;

/**
 * Header for a table.
 *
 *
 * \n Used when the content is tableRows or tableContent. Contains the metadata
 * as \narrays.\n
 *
 * user-modifiable class autogenerated from schema if no class exists use as a
 * shell which can be edited the autogeneration software will not overwrite an
 * existing class file
 *
 */
public class CMLTableHeader extends AbstractTableHeader {

	/** namespaced element name.*/
	public final static String NS = C_E+TAG;

    /**
     * must give simple documentation.
     */

    public CMLTableHeader() {
    }

    /**
     * must give simple documentation.
     *
     * @param old
     *            CMLTableHeader to copy
     *
     */

    public CMLTableHeader(CMLTableHeader old) {
        super((AbstractTableHeader) old);
    }

    /**
     * copy node .
     *
     * @return Node
     */
    public Node copy() {
        return new CMLTableHeader(this);
    }

    /**
     * create new instance in context of parent, overridable by subclasses.
     *
     * @param parent
     *            parent of element to be constructed (ignored by default)
     * @return CMLTableHeader
     */
    public CMLElement makeElementInContext(Element parent) {
        return new CMLTableHeader();
    }

    /** write header to HTML table.
     *
     * @param w
     *            writer
     * @throws IOException
     */
    public void writeHTML(Writer w) throws IOException {
        w.write("\n<tr>");
        CMLElements<CMLTableHeaderCell> tableHeaderCells =
            this.getTableHeaderCellElements();
        for (CMLTableHeaderCell tableHeaderCell : tableHeaderCells) {
            tableHeaderCell.writeHTML(w);
        }
        w.write("</tr>");
    }

//    /**
//     * get titles. searches for row with dictRef='title'
//     *
//     * @return list of strings in that row or empty list
//     */
//    public List<String> getTitles() {
//        List<String> titleList = new ArrayList<String>();
//        CMLElements<CMLTableHeaderCell> cells = this.getTableHeaderCellElements();
//        for (CMLTableHeaderCell cell : cells) {
//            titleList.add(cell.getTitle());
//        }
//        return titleList;
//    }
//
    /**
     * gets count of columns.
     *
     * @return count (or -1)
     * @throws RuntimeException
     *             inconsistent count
     */
    public int getColumnCount() throws RuntimeException {
        int ncols = this.getTableHeaderCellElements().size();
        return ncols;
    }

}
