#!/usr/bin/perl -w

# couriergraph -- a postfix statistics rrdtool frontend
# copyright (c) 2002-2006 Ralf Hildebrandt <ralf.hildebrandt@charite.de>
# based upon mailgraph, which is
# mailgraph -- a postfix statistics rrdtool frontend
# copyright (c) 2000-2006 David Schweikert <dws@ee.ethz.ch>
# released under the GNU General Public License

use RRDs;
use POSIX qw(uname);

my $VERSION = "1.10stack";

my $host = (POSIX::uname())[1];
my $scriptname = 'couriergraph.cgi';
my $xpoints = 800;
my $points_per_sample = 3;
my $ypoints = 160;
my $ypoints_err = 96;
my $rrd = '/etc/postfix/couriergraph.rrd'; # path to where the RRD database is
my $tmp_dir = '/tmp/couriergraph'; # temporary directory where to store the images

my @graphs = (
	{ title => 'Day Graphs',   seconds => 3600*24,        },
	{ title => 'Week Graphs',  seconds => 3600*24*7,      },
	{ title => 'Month Graphs', seconds => 3600*24*31,     },
	{ title => 'Year Graphs',  seconds => 3600*24*365, },
);

sub graph($$$)
{
	my $range = shift;
	my $file = shift;
	my $title = shift;
	my $step = $range*$points_per_sample/$xpoints;
	my $date = localtime(time);
	$date =~ s|:|\\:|g unless $rrdtool_1_0;

	my ($graphret,$xs,$ys) = RRDs::graph($file,
		'--imgformat', 'PNG',
		'--width', $xpoints,
		'--height', $ypoints,
		'--start', "-$range",
		'--vertical-label', 'logins/min',
		'--lower-limit', 0,
		'--units-exponent', 0, # don't show milli-messages/s
		'--lazy',
		'--color', 'SHADEA#ffffff',
		'--color', 'SHADEB#ffffff',
		'--color', 'BACK#ffffff',
	    
                $RRDs::VERSION < 1.2002 ? () : (
		    '--slope-mode'
		),

		"DEF:pop3d_login=$rrd:pop3d_login:AVERAGE",
		"DEF:mpop3d_login=$rrd:pop3d_login:MAX",
		"DEF:pop3d_ssl_login=$rrd:pop3d_ssl_login:AVERAGE",
		"DEF:mpop3d_ssl_login=$rrd:pop3d_ssl_login:MAX",
	    
		"CDEF:rpop3d_login=pop3d_login,60,*",
		"CDEF:vpop3d_login=pop3d_login,UN,0,pop3d_login,IF,$range,*",
		"CDEF:rmpop3d_login=mpop3d_login,60,*",

    		"CDEF:rpop3d_ssl_login=pop3d_ssl_login,60,*",
		"CDEF:vpop3d_ssl_login=pop3d_ssl_login,UN,0,pop3d_ssl_login,IF,$range,*",
		"CDEF:rmpop3d_ssl_login=mpop3d_ssl_login,60,*",

		"DEF:imapd_login=$rrd:imapd_login:AVERAGE",
		"DEF:mimapd_login=$rrd:imapd_login:MAX",
		"DEF:imapd_ssl_login=$rrd:imapd_ssl_login:AVERAGE",
		"DEF:mimapd_ssl_login=$rrd:imapd_ssl_login:MAX",
	    
	    	"CDEF:rimapd_login=imapd_login,60,*",
		"CDEF:vimapd_login=imapd_login,UN,0,imapd_login,IF,$range,*",
		"CDEF:rmimapd_login=mimapd_login,60,*",
	    
	        "CDEF:rimapd_ssl_login=imapd_ssl_login,60,*",
		"CDEF:rmimapd_ssl_login=mimapd_ssl_login,60,*",
	        "CDEF:vimapd_ssl_login=imapd_ssl_login,UN,0,imapd_ssl_login,IF,$range,*",
  	 	    
		'LINE:rpop3d_login#DD0000:pop3',
		'GPRINT:vpop3d_login:AVERAGE:total\: %.0lf logins',
		'GPRINT:rmpop3d_login:MAX:max\: %.0lf logins/min\l',
		'HRULE:0#000000',
	    
		'AREA:rpop3d_ssl_login#770000:pop3/ssl:STACK',
		'GPRINT:vpop3d_ssl_login:AVERAGE:total\: %.0lf logins',
		'GPRINT:rmpop3d_ssl_login:MAX:max\: %.0lf logins/min\l',
		'HRULE:0#000000',

	        'LINE:rimapd_login#00DD00:imap',
	        'GPRINT:vimapd_login:AVERAGE:total\: %.0lf logins',
		'GPRINT:rmimapd_login:MAX:max\: %.0lf logins/min\l',
		'HRULE:0#000000',
	    
		'AREA:rimapd_ssl_login#007700:imap/ssl:STACK',
		'GPRINT:vimapd_ssl_login:AVERAGE:total\: %.0lf logins',
		'GPRINT:rmimapd_ssl_login:MAX:max\: %.0lf logins/min\l',

		'COMMENT:\s',
		'COMMENT:['.$date.']\r',
	);
	my $ERR=RRDs::error;
	die "ERROR: $ERR\n" if $ERR;
}

sub print_html()
{
	print "Content-Type: text/html\n\n";

	print <<HEADER;
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" "http://www.w3.org/TR/REC-html40/loose.dtd">
<HTML>
<HEAD>
<TITLE>Courier Login Statistics for $host</TITLE>
<META HTTP-EQUIV="Refresh" CONTENT="300">
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
</HEAD>
<BODY BGCOLOR="#FFFFFF">
HEADER

	print "<H1>Courier Login Statistics for $host</H1>\n";
	for my $n (0..$#graphs) {
		print '<div style="background: #dddddd; width: 632px">';
		print "<H2>$graphs[$n]{title}</H2>\n";
		print "</div>\n";
		print "<P><IMG BORDER=\"0\" SRC=\"$scriptname?${n}-n\" ALT=\"couriergraph\">\n";
	}

	print <<FOOTER;
<hr width="630" align="left" size="1" noshade>
<table border="0" width="630" cellpadding="0" cellspacing="0" background="#dddddd"><tr><td align="left">
<A href="http://www.stahl.bau.tu-bs.de/~hildeb/postfix/couriergraph">Couriergraph</A> $VERSION
by <A href="http://www.stahl.bau.tu-bs.de/~hildeb/">Ralf Hildebrandt</A>, based upon
<A href="http://people.ee.ethz.ch/~dws/software/mailgraph">Mailgraph</A> $VERSION
by <A href="http://people.ee.ethz.ch/~dws/">David Schweikert</A></td>
<td ALIGN="right">
<a HREF="http://people.ee.ethz.ch/~oetiker/webtools/rrdtool/"><img border="0" src="http://people.ethz.ch/~oetiker/webtools/rrdtool/.pics/rrdtool.gif" alt="" width="120" height="34"></a>
</td></tr></table>
</BODY></HTML>
FOOTER
}

sub send_image($)
{
	my $file = shift;
	-r $file or do {
		print "Content-type: text/plain\n\nERROR: can't find $file\n";
		exit 1;
	};

	print "Content-type: image/png\n";
	print "Content-length: ".((stat($file))[7])."\n";
	print "\n";
	open(IMG, $file) or die;
	my $data;
	print $data while read IMG, $data, 1;
}

sub main()
{
	my $uri = $ENV{REQUEST_URI} || '';
	$uri =~ s/\/[^\/]+$//;
	$uri =~ s/\//,/g;
	$uri =~ s/(\~|\%7E)/tilde,/g;
	mkdir $tmp_dir, 0777 unless -d $tmp_dir;
	mkdir "$tmp_dir/$uri", 0777 unless -d "$tmp_dir/$uri";

	my $img = $ENV{QUERY_STRING};
	if(defined $img and $img =~ /\S/) {
		if($img =~ /^(\d+)-n$/) {
			my $file = "$tmp_dir/$uri/couriergraph_$1.png";
			graph($graphs[$1]{seconds}, $file, $graphs[$1]{title});
			send_image($file);
		}
		else {
			die "ERROR: invalid argument\n";
		}
	}
	else {
		print_html;
	}
}

main;
