#!/bin/bash

. ../MasterTest.sh

CleanFiles ptraj.in cpptraj.nc mop.trr temp.crd total?.out

TESTNAME='GROMACS TRR tests'
Requires maxthreads 10

INPUT="-i ptraj.in"

GmxTrrRead() {
  UNITNAME='TRR force/velocity read -> NetCDF write test'
  CheckFor maxthreads 2 netcdf pnetcdf
  if [ $? -eq 0 ] ; then
    cat > ptraj.in <<EOF
parm nvt.protein.mol2
trajin nvt.2frame.trr
trajout cpptraj.nc
EOF
    RunCpptraj "$UNITNAME"
    NcTest cpptraj.nc.save cpptraj.nc
  fi
  UNITNAME='TRR force/velocity read -> TRR write test'
  CheckFor maxthreads 2
  if [ $? -eq 0 ] ; then
    cat > ptraj.in <<EOF
parm nvt.protein.mol2
trajin nvt.2frame.trr
trajout cpptraj.trr
EOF
    RunCpptraj "$UNITNAME"
    DoTest nvt.2frame.trr cpptraj.trr
  fi
}

GmxTrrWrite() {
  cat > ptraj.in <<EOF
parm ../tz2.truncoct.parm7
trajin ../tz2.truncoct.crd
trajout mop.trr trr
EOF
  RunCpptraj "CRD => TRR"

  cat > ptraj.in <<EOF
parm ../tz2.truncoct.parm7
#trajin temp.trr
trajin mop.trr
trajout temp.crd title "trajectory generated by ptraj"
EOF
  RunCpptraj "TRR => CRD"
  DoTest ../tz2.truncoct.crd temp.crd
}

# Gromacs TRR append
GmxTrrAppend() {
  UNITNAME='GMX TRR append test'
  CheckFor notparallel
  if [ $? -eq 0 ] ; then
    cat > ptraj.in <<EOF
parm ../tz2.truncoct.parm7
trajin ../tz2.truncoct.crd 1 5
trajout mop.trr trr
EOF
    RunCpptraj "CRD(1-5) => TRR"
    cat > ptraj.in <<EOF
parm ../tz2.truncoct.parm7
trajin ../tz2.truncoct.crd 6 10
trajout mop.trr trr append
EOF
    RunCpptraj "CRD(6-10) => TRR"
    cat > ptraj.in <<EOF
parm ../tz2.truncoct.parm7
trajin mop.trr
trajout temp.crd title "trajectory generated by ptraj"
EOF
    RunCpptraj "TRR (appended) => CRD"
    DoTest ../tz2.truncoct.crd temp.crd
  fi
}

# Gromacs TRR with offsets
GmxOffset() {
  UNITNAME='GMX offset test'
  CheckFor maxthreads 5
  if [ $? -eq 0 ] ; then
    cat > ptraj.in <<EOF
parm ../tz2.truncoct.parm7
trajin ../tz2.truncoct.crd 2 10 2
trajout total1.out title "offset test"
EOF
    RunCpptraj "GMX: CRD with offset"
    cat > ptraj.in <<EOF
parm ../tz2.truncoct.parm7
trajin mop.trr 2 10 2
trajout total2.out title "offset test"
EOF
    RunCpptraj "GMX: TRR with offset"
    DoTest total1.out total2.out
  fi
}

GmxTrrRead
GmxTrrWrite
GmxTrrAppend
GmxOffset

EndTest
exit 0
