;;;;TypesetOnlyClef

(let (  (tag "TypesetOnlyClef")
		(text (_"t.o."))
		(start (and (= (d-GetMeasure) 1) (or (not (d-GetStartTick)) (zero? (d-GetStartTick)))))
		(choice #f))	
		(if (d-Directive-standalone? tag)
			(begin
				(if (Appending?)
					(d-MoveCursorLeft))
				(d-DirectiveDelete-standalone tag)
				(d-WarningDialog (_ "Typeset Only Clef deleted")))
			(if (and start (d-Directive-clef? tag))
				(begin
					(d-DirectiveDelete-clef tag)
					(d-WarningDialog (_ "Typeset Only Clef deleted")))
					(let ()		
							
					 (set! choice (RadioBoxMenu (cons (_ "Treble") "treble")
												  (cons (_ "Bass") "bass")
												  (cons (_ "Alto") "alto")                     
												  (cons (_ "Tenor") "tenor")                   
												  (cons (_ "Treble Octava Bassa") "treble_8")
												  (cons (_ "Bass Octava Bassa") "bass_8")
												  (cons (_ "Soprano") "soprano")
												  (cons (_ "French") "french")
												  (cons (_ "LilyPond") 'lilypond)))

						(if (eq? choice 'lilypond)
									(set! choice (d-GetUserInput (_ "Custom Clef") (_ "Give LilyPond syntax for clef name") "treble^8")))
						
						(if choice
							(let ((glyph "\nD\nDenemo\n24")(y 40)(ty 70)(tx -5))
								(cond 
									((equal? choice "treble") 
										(set! glyph "\nÉ\nfeta26\n36")
										(set! y 30))
										((equal? choice "bass") 
											(set! glyph "\nÇ\nfeta26\n36")
											(set! y 10))	
										((equal? choice "bass_8") 
											(set! ty 95)
											(set! text "8 t.o.")
											(set! glyph "\nÇ\nfeta26\n36")
											(set! y 10))	
										((equal? choice "alto") 
											(set! glyph "\nÅ\nfeta26\n36")
											(set! y 20))	
										((equal? choice "tenor") 
											(set! glyph "\nÅ\nfeta26\n36")
											(set! y 10))
										((equal? choice "soprano")
											(set! ty 115) 
											(set! glyph "\nÅ\nfeta26\n36")
											(set! y 40))
										((equal? choice "treble_8") 
											(set! text "8 t.o.")
											(set! glyph "\nÉ\nfeta26\n36")
											(set! y 30))
										((equal? choice "french")
											(set! ty 118) 
											(set! glyph "\nÉ\nfeta26\n36")
											(set! y 40))					
										
										)		
								(if start
									(begin
										(d-DirectivePut-clef-postfix tag (string-append "\\clef \"" choice "\" "))
										(d-DirectivePut-clef-graphic tag glyph)
										(d-DirectivePut-clef-gy tag y)
										(d-DirectivePut-clef-override tag (logior DENEMO_OVERRIDE_GRAPHIC DENEMO_OVERRIDE_LILYPOND))
										(d-DirectivePut-clef-display tag (string-append text "("(d-GetPrevailingClef)")"))
										(d-DirectivePut-clef-ty tag ty)
										(d-DirectivePut-clef-tx tag tx)
										(SetDirectiveConditional "clef" tag)
									
									)
									(begin
										(d-Directive-standalone tag)
										(d-DirectivePut-standalone-postfix tag (string-append "\\clef \"" choice "\" "))
										(d-DirectivePut-standalone-graphic tag glyph)
										(d-DirectivePut-standalone-gy tag (- y 21)) 
										(d-DirectivePut-standalone-ty tag (- ty 30))
										(d-DirectivePut-standalone-tx tag tx)
										(d-DirectivePut-standalone-display tag text)
										(d-DirectivePut-standalone-minpixels tag 30)
										(SetDirectiveConditional "standalone" tag)
										(d-SetSaved #f)         
										(d-RefreshDisplay))))
							(d-InfoDialog (_ "Cancelled")))))))


