/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/unittest/test_system/mutexed_test_data.cpp
 *
 * @brief [LEVEL: beta] implementation of @ref
 * diagnostics::unittest::Mutexed_Test_Data class
 *
 * $Id: mutexed_test_data.cpp,v 1.6 2005/06/23 09:54:26 esdentem Exp $
 * 
 * @author Christian Schallhart
 */
#include <diagnostics/unittest/test_system/mutexed_test_data.hpp>

#include <diagnostics/unittest/test_system_exception.hpp>

#include <diagnostics/frame/logging_mutex.hpp>

DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;

Mutexed_Test_Data::~Mutexed_Test_Data()
{
}


Mutexed_Test_Data::Mutexed_Test_Data() :
    m_backend(NULL)
{
}


void Mutexed_Test_Data::attach(Test_Data * const backend) 
{
    if(backend==NULL) throw Test_System_Exception("backend==NULL");
    m_backend=backend;
}


::std::string const & Mutexed_Test_Data::get(::std::string const & id) const 
{
    DIAGNOSTICS_LOGGING_FACILITY_LOCK_GUARD(lock_guard);
	if(m_backend==NULL) throw Test_System_Exception("backend==NULL");
    return m_backend->get(id);
}

bool Mutexed_Test_Data::compare(::std::string const & id,::std::string const & data) const
{
    DIAGNOSTICS_LOGGING_FACILITY_LOCK_GUARD(lock_guard);
    if(m_backend==NULL) throw Test_System_Exception("backend==NULL");
    return m_backend->compare(id,data);
}



UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;

// vim:ts=4:sw=4
