/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/util/compilation_mode.ts.hpp
 *
 * $Id$
 *
 * @author Christian Schallhart
 *
 * @brief [LEVEL: beta] @ref DIAGNOSTICS_COMPILATION_MODE_ID is a
 * string which uniquley identifies the current compilation mode
 * (which switches are on and off). This is used to test diagnostics
 * with different compilation switches.
 *
 * @test none
 */

#ifndef DIAGNOSTICS_UTIL_COMPILATION_MODE_TS__INCLUDE_GUARD
#define DIAGNOSTICS_UTIL_COMPILATION_MODE_TS__INCLUDE_GUARD

// for @ref DIAGNOSTICS_SWITCH_SYSTEM_CALLS_ENABLED
#include <diagnostics/frame/platform_config.hpp>

// for @ref ::diagnostics::testing::Dummy_Values_For_Tid_Pid and 
//     @ref ::diagnostics::testing::Dummy_Values_For_Tid_Tid
#include <diagnostics/util/dummy_values_for_tid_pid.ts.hpp>

#include <string>

/**
 * @brief used to generate different test data ids for different buid styles
 */
#if DIAGNOSTICS_SWITCH_SYSTEM_CALLS_ENABLED == 1
#  define DIAGNOSTICS_COMPILATION_MODE_ID  (::std::string("sys")+ \
                                           (::diagnostics::testing::Dummy_Values_For_Pid::is_pointer ? "p" : "i")+ \
                                           (::diagnostics::testing::Dummy_Values_For_Tid::is_pointer ? "p" : "i") )
#else
#  define DIAGNOSTICS_COMPILATION_MODE_ID (::std::string("nosys"))
#endif

#endif
// vim:ts=4:sw=4
