Version 0.14.0 has been released on 2020-07-05, 6 months after 0.13, bringing
many new features and bugfixes.

As usual, [prebuilt binaries](https://elv.sh/get) are offered for most common
platforms.

# Breaking changes

-   The `type` field of the value written by `src` have been removed.

-   The `all` command no longer preserves byte inputs as is; instead it turns
    them into values, one each line. It also accepts an optional list argument,
    consistent with other value-taking commands.

-   Output captures now strip trailing carriage returns from each line,
    effectively making `\r\n` accepted as a line separator
    ([#970](https://b.elv.sh/970)).

-   Map-like values written by the `dir-history` and `re:find` functions can no
    longer be assoc'ed.

# Deprecated features

Elvish now has a deprecation mechanism to give advance notice for breaking
changes. Deprecated features trigger warnings, and will be removed in the next
release.

The following deprecated features trigger a warning whenever the code is parsed
or compiled, even if it is not executed:

-   The `explode` command is now deprecated. Use `all` instead.

-   The `joins`, `replaces` and `splits` commands are now deprecated. Use
    `str:join`, `str:replace` and `str:split` instead.

-   The `^` command is now deprecated. Use `math:pow` instead.

-   The `-time` command has been promoted to `time`. The `-time` command is now
    a deprecated alias for `time`.

-   Using `\` for line continuation is now deprecated. Use `^` instead.

The following deprecated features trigger a warning when the code is evaluated:

-   The `&display-suffix` option of the `edit:complex-candidate` is now
    deprecated. Use the `&display` option instead.

The following deprecated features, unfortunately, do not trigger any warnings:

-   The `path` field of the value returned by `src` is now deprecated. Use the
    `name` field instead.

# Notable new features

New features in the language:

-   Exceptions can now be introspected by accessing their fields
    ([#208](https://b.elv.sh/208)).

-   Two new wildcard modifiers, `type:dir` and `type:regular` are added, which
    restricts the wildcard pattern to only match directories or regular files,
    respectively.

-   The printing of floating-point numbers has been tweaked to feel much more
    natural ([#811](https://b.elv.sh/811)).

-   Scripts may now use relative `use` to import modules outside
    `~/.elvish/lib`.

-   Dynamic strings may now be used as command as long as they contain slashes
    ([#764](https://b.elv.sh/764)).

-   Elvish now supports CRLF line endings in source files
    ([#918](https://b.elv.sh/918)).

-   Comments are now allowed anywhere newlines serve as separators, notably
    inside list and map literals ([#924](https://b.elv.sh/924)).

-   The `^` character can now be used for line continuation.

New features in the standard library:

-   A new `order` command for sorting values has been introduced
    [#651](https://b.elv.sh/651).

-   A new `platform:` module has been introduced.

-   A new `unix:` module has been introduced.

-   A new `math:` module has been introduced.

-   The `fail` command now takes an argument of any type. In particular, if the
    argument is an exception, it rethrows the exception
    ([#941](https://b.elv.sh/941)).

-   A new `show` command has been added, which is currently useful for printing
    the stack trace of an exception to the terminal.

-   A new `make-map` command creates a map from a sequence of pairs
    ([#943](https://b.elv.sh/943)).

-   A new `read-line` command can be used to read a single line from the byte
    input ([#975](https://b.elv.sh/975)).

-   The `-time` command has been promoted to `time`, and it now accepts an
    `&on-end` callback to specify how to save the duration of the execution
    ([#295](https://b.elv.sh/295)).

-   A new `one` command has been added.

-   A new `read-upto` command can now be added to read byte inputs up to a
    delimiter ([#831](https://b.elv.sh/831)).

New features in the interactive editor:

-   When a callback of the interactive editor throws an exception, the exception
    is now saved in a `$edit:exceptions` variable for closer examination
    ([#945](https://b.elv.sh/945)).

-   A new alternative abbreviation mechanism, "small word abbreviation", is now
    available and configurable via `$edit:small-word-abbr`.

-   The ratios of the column widths in navigation mode can now be configured
    with `$edit:navigation:width-ratio` ([#464](https://b.elv.sh/464))

-   A new `$edit:add-cmd-filters` variable is now available for controlling
    whether a command is added to the history.

    The default value of this variable filters out commands that start with a
    space.

-   The `edit:complex-candidate` now supports a `&display` option to specify the
    full display text.

Other improvements:

-   Elvish now uses `$XDG_RUNTIME_DIR` to keep runtime files if possible.

-   Elvish now increments the `$SHLVL` environment variable
    ([#834](https://b.elv.sh/834)).

# Notable bugfixes

-   Invalid option names or values passed to builtin functions now correctly
    trigger an exception, instead of being silently ignored
    ([#958](https://b.elv.sh/958)).

-   Elvish no longer crashes when redirecting to a high FD
    ([#788](https://b.elv.sh/788)).

-   Indexing access to nonexistent variables now correctly triggers a
    compilation error ([#889](https://b.elv.sh/889)).

-   The interactive REPL no longer highlights complex commands as red
    ([#881](https://b.elv.sh/881)).

-   Glob patterns after `~username` now evaluate correctly
    ([#793](https://b.elv.sh/793)).

-   On Windows, tab completions for directories no longer add superfluous quotes
    backslashes ([#897](https://b.elv.sh/897)).

-   The `edit:move-dot-left-small-word` command has been fixed to actually move
    by a small word instead of a word.

-   A lot of race conditions have been fixed ([#73](https://b.elv.sh),
    [#754](https://b.elv.sh/754)).
