// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file Benchmark_big.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifndef FAST_DDS_GENERATED__BENCHMARK_BIG_HPP
#define FAST_DDS_GENERATED__BENCHMARK_BIG_HPP

#include  <array>
#include <cstdint>
#include <utility>

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(BENCHMARK_BIG_SOURCE)
#define BENCHMARK_BIG_DllAPI __declspec( dllexport )
#else
#define BENCHMARK_BIG_DllAPI __declspec( dllimport )
#endif // BENCHMARK_BIG_SOURCE
#else
#define BENCHMARK_BIG_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define BENCHMARK_BIG_DllAPI
#endif // _WIN32

/*!
 * @brief This class represents the structure BenchMarkBig defined by the user in the IDL file.
 * @ingroup Benchmark_big
 */
class BenchMarkBig
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport BenchMarkBig()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~BenchMarkBig()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object BenchMarkBig that will be copied.
     */
    eProsima_user_DllExport BenchMarkBig(
            const BenchMarkBig& x)
    {
        m_data = x.m_data;

        m_index = x.m_index;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object BenchMarkBig that will be copied.
     */
    eProsima_user_DllExport BenchMarkBig(
            BenchMarkBig&& x) noexcept
    {
        m_data = std::move(x.m_data);
        m_index = x.m_index;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object BenchMarkBig that will be copied.
     */
    eProsima_user_DllExport BenchMarkBig& operator =(
            const BenchMarkBig& x)
    {

        m_data = x.m_data;

        m_index = x.m_index;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object BenchMarkBig that will be copied.
     */
    eProsima_user_DllExport BenchMarkBig& operator =(
            BenchMarkBig&& x) noexcept
    {

        m_data = std::move(x.m_data);
        m_index = x.m_index;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x BenchMarkBig object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const BenchMarkBig& x) const
    {
        return (m_data == x.m_data &&
               m_index == x.m_index);
    }

    /*!
     * @brief Comparison operator.
     * @param x BenchMarkBig object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const BenchMarkBig& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member data
     * @param _data New value to be copied in member data
     */
    eProsima_user_DllExport void data(
            const std::array<char, 8388608>& _data)
    {
        m_data = _data;
    }

    /*!
     * @brief This function moves the value in member data
     * @param _data New value to be moved in member data
     */
    eProsima_user_DllExport void data(
            std::array<char, 8388608>&& _data)
    {
        m_data = std::move(_data);
    }

    /*!
     * @brief This function returns a constant reference to member data
     * @return Constant reference to member data
     */
    eProsima_user_DllExport const std::array<char, 8388608>& data() const
    {
        return m_data;
    }

    /*!
     * @brief This function returns a reference to member data
     * @return Reference to member data
     */
    eProsima_user_DllExport std::array<char, 8388608>& data()
    {
        return m_data;
    }

    /*!
     * @brief This function sets a value in member index
     * @param _index New value for member index
     */
    eProsima_user_DllExport void index(
            uint32_t _index)
    {
        m_index = _index;
    }

    /*!
     * @brief This function returns the value of member index
     * @return Value of member index
     */
    eProsima_user_DllExport uint32_t index() const
    {
        return m_index;
    }

    /*!
     * @brief This function returns a reference to member index
     * @return Reference to member index
     */
    eProsima_user_DllExport uint32_t& index()
    {
        return m_index;
    }

private:

    std::array<char, 8388608> m_data{0};
    uint32_t m_index{0};

};

#endif // _FAST_DDS_GENERATED_BENCHMARK_BIG_HPP_


