MODULE XRD_UNIX_ENV

!**** *XRD_UNIX_ENV*  - 

!     Author. 
!     ------- 
!      Philippe Marguinaud *METEO FRANCE*
!      Original : 11-09-2012

USE EC_PARKIND, ONLY : JPIM
IMPLICIT NONE

CONTAINS

SUBROUTINE XRD_GETENV( KEY, VAL )
  IMPLICIT NONE
  CHARACTER(LEN=*), INTENT(IN) :: KEY
  CHARACTER(LEN=*), INTENT(OUT) :: VAL

  CALL GET_ENVIRONMENT_VARIABLE( KEY, VAL )
END SUBROUTINE XRD_GETENV


FUNCTION XRD_IARGC()
  IMPLICIT NONE
  INTEGER(KIND=JPIM) :: XRD_IARGC
  XRD_IARGC = COMMAND_ARGUMENT_COUNT()
END FUNCTION XRD_IARGC

SUBROUTINE XRD_GETARG( KEY, VAL )
  IMPLICIT NONE
  INTEGER(KIND=JPIM), INTENT(IN) :: KEY
  CHARACTER(LEN=*), INTENT(OUT) :: VAL
  CALL GETARG( INT(KEY,SELECTED_INT_KIND(9)), VAL )
END SUBROUTINE XRD_GETARG

SUBROUTINE XRD_EXIT( STATUS )
  IMPLICIT NONE
  INTEGER(KIND=JPIM), INTENT(IN) :: STATUS
  CALL EXIT( INT(STATUS,SELECTED_INT_KIND(9)) )
END SUBROUTINE XRD_EXIT

SUBROUTINE XRD_MKDIR( PATH )
  IMPLICIT NONE
  CHARACTER(LEN=*), INTENT(IN) :: PATH
  CALL SYSTEM( "mkdir -p "//TRIM(PATH))
END SUBROUTINE XRD_MKDIR

CHARACTER*256 FUNCTION XRD_DIRNAME( PATH )
  IMPLICIT NONE
  CHARACTER(LEN=*), INTENT(IN) :: PATH

  INTEGER(KIND=JPIM) :: I
  XRD_DIRNAME = ""
  I = LEN( TRIM( PATH ) ) - 1
  DO
    IF( I .LE. 0 ) RETURN
    IF( PATH(I:I) .EQ. '/' ) EXIT
    I = I - 1
  ENDDO
  XRD_DIRNAME = PATH(1:I)
END FUNCTION XRD_DIRNAME

FUNCTION XRD_BASENAME( PATH )
  IMPLICIT NONE
  CHARACTER*256 :: XRD_BASENAME
  CHARACTER(LEN=*), INTENT(IN) :: PATH

  INTEGER(KIND=JPIM) :: I
  XRD_BASENAME = ""
  I = LEN( TRIM( PATH ) ) - 1
  DO
    IF( I .LE. 0 ) THEN
      I = 0
      EXIT
    ENDIF
    IF( PATH(I:I) .EQ. '/' ) EXIT
    I = I - 1
  ENDDO
  XRD_BASENAME = PATH(I+1:)
END FUNCTION XRD_BASENAME

ELEMENTAL SUBROUTINE XRD_LOWER_CASE(OUS,INS)
IMPLICIT NONE
! CONVERT A WORD TO LOWER CASE
CHARACTER (LEN=*) , INTENT(OUT) :: OUS
CHARACTER (LEN=*) , INTENT(IN) :: INS
INTEGER :: I,IC,NLEN
NLEN = LEN(INS)
OUS = ''
DO I=1,NLEN
   IC = ICHAR(INS(I:I))
   IF (IC >= 65 .AND. IC < 90) THEN
     OUS(I:I) = CHAR(IC+32)
   ELSE
     OUS(I:I) = INS(I:I)
   ENDIF
END DO
END SUBROUTINE XRD_LOWER_CASE

ELEMENTAL SUBROUTINE XRD_UPPER_CASE(OUS,INS)
IMPLICIT NONE
! CONVERT A WORD TO UPPER CASE
CHARACTER (LEN=*) , INTENT(OUT) :: OUS
CHARACTER (LEN=*) , INTENT(IN) :: INS
INTEGER :: I,IC,NLEN
NLEN = LEN(INS)
OUS = ''
DO I=1,NLEN
   IC = ICHAR(INS(I:I))
   IF (IC >= 97 .AND. IC < 122) THEN
     OUS(I:I) = CHAR(IC-32)
   ELSE
     OUS(I:I) = INS(I:I)
   ENDIF
END DO
END SUBROUTINE XRD_UPPER_CASE

FUNCTION XRD_ISALPHA(C)
IMPLICIT NONE
LOGICAL(KIND=JPIM) :: XRD_ISALPHA
CHARACTER, INTENT(IN) :: C

XRD_ISALPHA = ((C.GE.'A').AND.(C.LE.'Z'))&
            .OR.((C.GE.'a').AND.(C.LE.'z'))

END FUNCTION XRD_ISALPHA

FUNCTION XRD_ISDIGIT(C)
IMPLICIT NONE
LOGICAL(KIND=JPIM) :: XRD_ISDIGIT
CHARACTER, INTENT(IN) :: C

XRD_ISDIGIT = (C.GE.'0').AND.(C.LE.'9')

END FUNCTION XRD_ISDIGIT

SUBROUTINE XRD_DATE_AND_TIME( VL )
IMPLICIT NONE
INTEGER(KIND=JPIM), INTENT(OUT) :: VL(8)
!
INTEGER :: VLX(8)

  CALL DATE_AND_TIME( VALUES = VLX )

  VL = VLX
END SUBROUTINE XRD_DATE_AND_TIME

SUBROUTINE XRD_CPU_TIME( T )
  IMPLICIT NONE
  REAL,INTENT(OUT) :: T
  CALL CPU_TIME( T )
END SUBROUTINE XRD_CPU_TIME

SUBROUTINE XRD_COUNTLINES( NLINES, F, ERR )
IMPLICIT NONE
INTEGER(KIND=JPIM), INTENT(OUT) :: NLINES
CHARACTER*(*), INTENT(IN) :: F
INTEGER(KIND=JPIM), INTENT(OUT) :: ERR
CHARACTER*32 :: STR


ERR = 0

NLINES = 0
OPEN( 77, FILE = F, ERR = 888 )

DO
  READ( 77, *, ERR = 888, END = 777 ) STR
  NLINES = NLINES + 1
ENDDO

777 CONTINUE

CLOSE( 77 )

RETURN
888 CONTINUE
  ERR = 1
END SUBROUTINE XRD_COUNTLINES

FUNCTION XRD_COUNTWORDS( S )
  IMPLICIT NONE
  INTEGER(KIND=JPIM) :: XRD_COUNTWORDS
  CHARACTER(LEN=*), INTENT(IN) :: S
  INTEGER(KIND=JPIM) :: N, I, L
  LOGICAL(KIND=JPIM) :: IN
  N = 0_JPIM
  IN = .FALSE.
  L = LEN( TRIM( S ) )
  DO I = 1, L
    IF( S(I:I) .EQ. ' ' ) THEN
      IN = .FALSE.
    ELSE IF( .NOT. IN ) THEN
      N = N + 1
      IN = .TRUE.
    ENDIF
  ENDDO
  XRD_COUNTWORDS = N
END FUNCTION XRD_COUNTWORDS

END MODULE XRD_UNIX_ENV
