// generated by diplomat-tool
import { BidiDirection } from "./BidiDirection.mjs"
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";


/**
 * Bidi information for a single processed paragraph
 */
const BidiParagraph_box_destroy_registry = new FinalizationRegistry((ptr) => {
    wasm.icu4x_BidiParagraph_destroy_mv1(ptr);
});

export class BidiParagraph {
    // Internal ptr reference:
    #ptr = null;

    // Lifetimes are only to keep dependencies alive.
    // Since JS won't garbage collect until there are no incoming edges.
    #selfEdge = [];
    #infoEdge = [];

    #internalConstructor(symbol, ptr, selfEdge, infoEdge) {
        if (symbol !== diplomatRuntime.internalConstructor) {
            console.error("BidiParagraph is an Opaque type. You cannot call its constructor.");
            return;
        }
        this.#infoEdge = infoEdge;
        this.#ptr = ptr;
        this.#selfEdge = selfEdge;

        // Are we being borrowed? If not, we can register.
        if (this.#selfEdge.length === 0) {
            BidiParagraph_box_destroy_registry.register(this, this.#ptr);
        }

        return this;
    }
    get ffiValue() {
        return this.#ptr;
    }


    /**
     * Given a paragraph index `n` within the surrounding text, this sets this
     * object to the paragraph at that index. Returns nothing when out of bounds.
     *
     * This is equivalent to calling `paragraph_at()` on `BidiInfo` but doesn't
     * create a new object
     */
    setParagraphInText(n) {

        const result = wasm.icu4x_BidiParagraph_set_paragraph_in_text_mv1(this.ffiValue, n);

        try {
            return result;
        }

        finally {
        }
    }

    /**
     * The primary direction of this paragraph
     *
     * See the [Rust documentation for `level_at`](https://docs.rs/unicode_bidi/latest/unicode_bidi/struct.Paragraph.html#method.level_at) for more information.
     */
    get direction() {

        const result = wasm.icu4x_BidiParagraph_direction_mv1(this.ffiValue);

        try {
            return new BidiDirection(diplomatRuntime.internalConstructor, result);
        }

        finally {
        }
    }

    /**
     * The number of bytes in this paragraph
     *
     * See the [Rust documentation for `len`](https://docs.rs/unicode_bidi/latest/unicode_bidi/struct.ParagraphInfo.html#method.len) for more information.
     */
    get size() {

        const result = wasm.icu4x_BidiParagraph_size_mv1(this.ffiValue);

        try {
            return result;
        }

        finally {
        }
    }

    /**
     * The start index of this paragraph within the source text
     */
    get rangeStart() {

        const result = wasm.icu4x_BidiParagraph_range_start_mv1(this.ffiValue);

        try {
            return result;
        }

        finally {
        }
    }

    /**
     * The end index of this paragraph within the source text
     */
    get rangeEnd() {

        const result = wasm.icu4x_BidiParagraph_range_end_mv1(this.ffiValue);

        try {
            return result;
        }

        finally {
        }
    }

    /**
     * Reorder a line based on display order. The ranges are specified relative to the source text and must be contained
     * within this paragraph's range.
     *
     * See the [Rust documentation for `level_at`](https://docs.rs/unicode_bidi/latest/unicode_bidi/struct.Paragraph.html#method.level_at) for more information.
     */
    reorderLine(rangeStart, rangeEnd) {
        const write = new diplomatRuntime.DiplomatWriteBuf(wasm);


        const result = wasm.icu4x_BidiParagraph_reorder_line_mv1(this.ffiValue, rangeStart, rangeEnd, write.buffer);

        try {
            return result === 0 ? null : write.readString8();
        }

        finally {
            write.free();
        }
    }

    /**
     * Get the BIDI level at a particular byte index in this paragraph.
     * This integer is conceptually a `unicode_bidi::Level`,
     * and can be further inspected using the static methods on Bidi.
     *
     * Returns 0 (equivalent to `Level::ltr()`) on error
     *
     * See the [Rust documentation for `level_at`](https://docs.rs/unicode_bidi/latest/unicode_bidi/struct.Paragraph.html#method.level_at) for more information.
     */
    levelAt(pos) {

        const result = wasm.icu4x_BidiParagraph_level_at_mv1(this.ffiValue, pos);

        try {
            return result;
        }

        finally {
        }
    }

    constructor(symbol, ptr, selfEdge, infoEdge) {
        return this.#internalConstructor(...arguments)
    }
}