// generated by diplomat-tool
import { Locale } from "./Locale.mjs"
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";


/**
 * The various calendar types currently supported by [`Calendar`]
 *
 * See the [Rust documentation for `AnyCalendarKind`](https://docs.rs/icu/latest/icu/calendar/enum.AnyCalendarKind.html) for more information.
 */


export class CalendarKind {
    #value = undefined;

    static #values = new Map([
        ["Iso", 0],
        ["Gregorian", 1],
        ["Buddhist", 2],
        ["Japanese", 3],
        ["JapaneseExtended", 4],
        ["Ethiopian", 5],
        ["EthiopianAmeteAlem", 6],
        ["Indian", 7],
        ["Coptic", 8],
        ["Dangi", 9],
        ["Chinese", 10],
        ["Hebrew", 11],
        ["HijriTabularTypeIiFriday", 12],
        ["HijriSimulatedMecca", 18],
        ["HijriTabularTypeIiThursday", 14],
        ["HijriUmmAlQura", 15],
        ["Persian", 16],
        ["Roc", 17]
    ]);

    static getAllEntries() {
        return CalendarKind.#values.entries();
    }

    #internalConstructor(value) {
        if (arguments.length > 1 && arguments[0] === diplomatRuntime.internalConstructor) {
            // We pass in two internalConstructor arguments to create *new*
            // instances of this type, otherwise the enums are treated as singletons.
            if (arguments[1] === diplomatRuntime.internalConstructor ) {
                this.#value = arguments[2];
                return this;
            }
            return CalendarKind.#objectValues[arguments[1]];
        }

        if (value instanceof CalendarKind) {
            return value;
        }

        let intVal = CalendarKind.#values.get(value);

        // Nullish check, checks for null or undefined
        if (intVal != null) {
            return CalendarKind.#objectValues[intVal];
        }

        throw TypeError(value + " is not a CalendarKind and does not correspond to any of its enumerator values.");
    }

    static fromValue(value) {
        return new CalendarKind(value);
    }

    get value(){
        for (let entry of CalendarKind.#values) {
            if (entry[1] == this.#value) {
                return entry[0];
            }
        }
    }

    get ffiValue(){
        return this.#value;
    }
    static #objectValues = {
        [0]: new CalendarKind(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 0),
        [1]: new CalendarKind(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 1),
        [2]: new CalendarKind(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 2),
        [3]: new CalendarKind(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 3),
        [4]: new CalendarKind(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 4),
        [5]: new CalendarKind(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 5),
        [6]: new CalendarKind(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 6),
        [7]: new CalendarKind(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 7),
        [8]: new CalendarKind(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 8),
        [9]: new CalendarKind(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 9),
        [10]: new CalendarKind(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 10),
        [11]: new CalendarKind(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 11),
        [12]: new CalendarKind(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 12),
        [18]: new CalendarKind(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 18),
        [14]: new CalendarKind(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 14),
        [15]: new CalendarKind(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 15),
        [16]: new CalendarKind(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 16),
        [17]: new CalendarKind(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 17),
    };

    static Iso = CalendarKind.#objectValues[0];
    static Gregorian = CalendarKind.#objectValues[1];
    static Buddhist = CalendarKind.#objectValues[2];
    static Japanese = CalendarKind.#objectValues[3];
    static JapaneseExtended = CalendarKind.#objectValues[4];
    static Ethiopian = CalendarKind.#objectValues[5];
    static EthiopianAmeteAlem = CalendarKind.#objectValues[6];
    static Indian = CalendarKind.#objectValues[7];
    static Coptic = CalendarKind.#objectValues[8];
    static Dangi = CalendarKind.#objectValues[9];
    static Chinese = CalendarKind.#objectValues[10];
    static Hebrew = CalendarKind.#objectValues[11];
    static HijriTabularTypeIiFriday = CalendarKind.#objectValues[12];
    static HijriSimulatedMecca = CalendarKind.#objectValues[18];
    static HijriTabularTypeIiThursday = CalendarKind.#objectValues[14];
    static HijriUmmAlQura = CalendarKind.#objectValues[15];
    static Persian = CalendarKind.#objectValues[16];
    static Roc = CalendarKind.#objectValues[17];


    /**
     * Creates a new [`CalendarKind`] for the specified locale, using compiled data.
     *
     * See the [Rust documentation for `new`](https://docs.rs/icu/latest/icu/calendar/enum.AnyCalendarKind.html#method.new) for more information.
     */
    static create(locale) {

        const result = wasm.icu4x_CalendarKind_create_mv1(locale.ffiValue);

        try {
            return new CalendarKind(diplomatRuntime.internalConstructor, result);
        }

        finally {
        }
    }

    constructor(value) {
        return this.#internalConstructor(...arguments)
    }
}