// generated by diplomat-tool
import type { DataError } from "./DataError"
import type { DataProvider } from "./DataProvider"
import type { Locale } from "./Locale"
import type { SentenceBreakIteratorUtf16 } from "./SentenceBreakIteratorUtf16"
import type { pointer, codepoint } from "./diplomat-runtime.d.ts";


/**
 * An ICU4X sentence-break segmenter, capable of finding sentence breakpoints in strings.
 *
 * See the [Rust documentation for `SentenceSegmenter`](https://docs.rs/icu/latest/icu/segmenter/struct.SentenceSegmenter.html) for more information.
 */


export class SentenceSegmenter {
    get ffiValue(): pointer;


    /**
     * Construct a [`SentenceSegmenter`] for content known to be of a given locale, using compiled data.
     */
    static createWithContentLocale(locale: Locale): SentenceSegmenter;

    /**
     * Construct a [`SentenceSegmenter`]  for content known to be of a given locale, using a particular data source.
     */
    static createWithContentLocaleAndProvider(provider: DataProvider, locale: Locale): SentenceSegmenter;

    /**
     * Segments a string.
     *
     * Ill-formed input is treated as if errors had been replaced with REPLACEMENT CHARACTERs according
     * to the WHATWG Encoding Standard.
     *
     * See the [Rust documentation for `segment_utf16`](https://docs.rs/icu/latest/icu/segmenter/struct.SentenceSegmenterBorrowed.html#method.segment_utf16) for more information.
     */
    segment(input: string): SentenceBreakIteratorUtf16;

    constructor();
}