import * as Ot from "@ot-builder/ot";
import { Data } from "@ot-builder/prelude";
import { Tag } from "@ot-builder/primitive";
export interface FeatureConsolidationSource<L> {
    readonly variationDimensions: Data.Order<Ot.Var.Dim>;
    readonly featureVariationCollection: Map<string, Ot.GsubGpos.FeatureVariationT<L>>;
    getFeatureHash(feature: Ot.GsubGpos.FeatureT<L>): string;
    getFeatureVariations(): Iterable<Ot.GsubGpos.FeatureVariationT<L>>;
}
export declare class FeatureConsolidator<L> {
    private readonly env;
    private readonly tag;
    private readonly featureList;
    hash: string;
    result: Ot.GsubGpos.FeatureT<L>;
    resultFeatureVariation: Ot.GsubGpos.FeatureVariationT<L>[];
    constructor(env: FeatureConsolidationSource<L>, tag: Tag, featureList: Ot.GsubGpos.FeatureT<L>[]);
    resolve(): void;
    private resolveFeatureVariations;
    private conditionToZone;
    private zoneToConditions;
}
//# sourceMappingURL=feature.d.ts.map