"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HeadIo = void 0;
const bin_composite_types_1 = require("@ot-builder/bin-composite-types");
const bin_util_1 = require("@ot-builder/bin-util");
const ot_metadata_1 = require("@ot-builder/ot-metadata");
const primitive_1 = require("@ot-builder/primitive");
exports.HeadIo = {
    ...(0, bin_util_1.Read)(view => {
        const majorVersion = view.uint16();
        const minorVersion = view.uint16();
        const head = new ot_metadata_1.Head.Table(majorVersion, minorVersion);
        head.fontRevision = view.next(primitive_1.F16D16);
        const _checkSumAdjust = view.uint32(); // pass, Head.Table::checkSumAdjust is read-only
        const _magicNumber = view.uint32(); // pass, Head.Table::magicNumber is read-only
        head.flags = view.uint16();
        head.unitsPerEm = view.uint16();
        head.created = view.next(bin_composite_types_1.LongDateTime);
        head.modified = view.next(bin_composite_types_1.LongDateTime);
        head.xMin = view.int16();
        head.yMin = view.int16();
        head.xMax = view.int16();
        head.yMax = view.int16();
        head.macStyle = view.uint16();
        head.lowestRecPPEM = view.uint16();
        head.fontDirectionHint = view.int16();
        head.indexToLocFormat = view.int16();
        head.glyphDataFormat = view.int16();
        return head;
    }),
    ...(0, bin_util_1.Write)((fr, head) => {
        fr.uint16(head.majorVersion);
        fr.uint16(head.minorVersion);
        fr.push(primitive_1.F16D16, head.fontRevision);
        fr.uint32(head.checkSumAdjust);
        fr.uint32(head.magicNumber);
        fr.uint16(head.flags);
        fr.uint16(head.unitsPerEm);
        fr.push(bin_composite_types_1.LongDateTime, head.created);
        fr.push(bin_composite_types_1.LongDateTime, head.modified);
        fr.int16(head.xMin);
        fr.int16(head.yMin);
        fr.int16(head.xMax);
        fr.int16(head.yMax);
        fr.uint16(head.macStyle);
        fr.uint16(head.lowestRecPPEM);
        fr.int16(head.fontDirectionHint);
        fr.int16(head.indexToLocFormat);
        fr.int16(head.glyphDataFormat);
    })
};
//# sourceMappingURL=index.js.map