/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.IRuleViolation;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.renderers.OnTheFlyRenderer;
import net.sourceforge.pmd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLRenderer
extends OnTheFlyRenderer {
    private final String linkPrefix;
    private final String linePrefix;
    private int violationCount = 1;
    boolean colorize = true;

    public HTMLRenderer(String linkPrefix, String linePrefix) {
        this.linkPrefix = linkPrefix;
        this.linePrefix = linePrefix;
    }

    public HTMLRenderer() {
        this(null, null);
    }

    public void renderBody(Writer writer, Report report) throws IOException {
        writer.write("<center><h3>PMD report</h3></center>");
        writer.write("<center><h3>Problems found</h3></center>");
        writer.write("<table align=\"center\" cellspacing=\"0\" cellpadding=\"3\"><tr>" + PMD.EOL + "<th>#</th><th>File</th><th>Line</th><th>Problem</th></tr>" + PMD.EOL);
        this.setWriter(writer);
        this.renderFileReport(report);
        writer.write("</table>");
        this.glomProcessingErrors(writer, this.errors);
        if (this.showSuppressedViolations) {
            this.glomSuppressions(writer, this.suppressed);
        }
    }

    @Override
    public void start() throws IOException {
        Writer writer = this.getWriter();
        writer.write("<html><head><title>PMD</title></head><body>" + PMD.EOL);
        writer.write("<center><h3>PMD report</h3></center>");
        writer.write("<center><h3>Problems found</h3></center>");
        writer.write("<table align=\"center\" cellspacing=\"0\" cellpadding=\"3\"><tr>" + PMD.EOL + "<th>#</th><th>File</th><th>Line</th><th>Problem</th></tr>" + PMD.EOL);
    }

    @Override
    public void renderFileViolations(Iterator<IRuleViolation> violations) throws IOException {
        Writer writer = this.getWriter();
        this.glomIRuleViolations(writer, violations);
    }

    @Override
    public void end() throws IOException {
        Writer writer = this.getWriter();
        writer.write("</table>");
        this.glomProcessingErrors(writer, this.errors);
        if (this.showSuppressedViolations) {
            this.glomSuppressions(writer, this.suppressed);
        }
        writer.write("</body></html>");
    }

    private void glomIRuleViolations(Writer writer, Iterator<IRuleViolation> violations) throws IOException {
        StringBuffer buf = new StringBuffer(500);
        while (violations.hasNext()) {
            IRuleViolation rv = violations.next();
            buf.setLength(0);
            buf.append("<tr");
            if (this.colorize) {
                buf.append(" bgcolor=\"lightgrey\"");
            }
            this.colorize = !this.colorize;
            buf.append("> " + PMD.EOL);
            buf.append("<td align=\"center\">" + this.violationCount + "</td>" + PMD.EOL);
            buf.append("<td width=\"*%\">" + this.maybeWrap(rv.getFilename(), this.linePrefix == null ? "" : this.linePrefix + Integer.toString(rv.getBeginLine())) + "</td>" + PMD.EOL);
            buf.append("<td align=\"center\" width=\"5%\">" + Integer.toString(rv.getBeginLine()) + "</td>" + PMD.EOL);
            String d = StringUtil.htmlEncode(rv.getDescription());
            if (rv.getRule().getExternalInfoUrl() != null && rv.getRule().getExternalInfoUrl().length() != 0) {
                d = "<a href=\"" + rv.getRule().getExternalInfoUrl() + "\">" + d + "</a>";
            }
            buf.append("<td width=\"*\">" + d + "</td>" + PMD.EOL);
            buf.append("</tr>" + PMD.EOL);
            writer.write(buf.toString());
            ++this.violationCount;
        }
    }

    private void glomProcessingErrors(Writer writer, List<Report.ProcessingError> errors) throws IOException {
        if (!errors.isEmpty()) {
            writer.write("<hr/>");
            writer.write("<center><h3>Processing errors</h3></center>");
            writer.write("<table align=\"center\" cellspacing=\"0\" cellpadding=\"3\"><tr>" + PMD.EOL + "<th>File</th><th>Problem</th></tr>" + PMD.EOL);
            StringBuffer buf = new StringBuffer(500);
            boolean colorize = true;
            for (Report.ProcessingError pe : errors) {
                buf.setLength(0);
                buf.append("<tr");
                if (colorize) {
                    buf.append(" bgcolor=\"lightgrey\"");
                }
                colorize = !colorize;
                buf.append("> " + PMD.EOL);
                buf.append("<td>" + pe.getFile() + "</td>" + PMD.EOL);
                buf.append("<td>" + pe.getMsg() + "</td>" + PMD.EOL);
                buf.append("</tr>" + PMD.EOL);
                writer.write(buf.toString());
            }
            writer.write("</table>");
        }
    }

    private void glomSuppressions(Writer writer, List<Report.SuppressedViolation> suppressed) throws IOException {
        if (!suppressed.isEmpty()) {
            writer.write("<hr/>");
            writer.write("<center><h3>Suppressed warnings</h3></center>");
            writer.write("<table align=\"center\" cellspacing=\"0\" cellpadding=\"3\"><tr>" + PMD.EOL + "<th>File</th><th>Line</th><th>Rule</th><th>NOPMD or Annotation</th><th>Reason</th></tr>" + PMD.EOL);
            StringBuffer buf = new StringBuffer(500);
            boolean colorize = true;
            for (Report.SuppressedViolation sv : suppressed) {
                buf.setLength(0);
                buf.append("<tr");
                if (colorize) {
                    buf.append(" bgcolor=\"lightgrey\"");
                }
                colorize = !colorize;
                buf.append("> " + PMD.EOL);
                buf.append("<td align=\"left\">" + sv.getRuleViolation().getFilename() + "</td>" + PMD.EOL);
                buf.append("<td align=\"center\">" + sv.getRuleViolation().getBeginLine() + "</td>" + PMD.EOL);
                buf.append("<td align=\"center\">" + sv.getRuleViolation().getRule().getName() + "</td>" + PMD.EOL);
                buf.append("<td align=\"center\">" + (sv.suppressedByNOPMD() ? "NOPMD" : "Annotation") + "</td>" + PMD.EOL);
                buf.append("<td align=\"center\">" + (sv.getUserMessage() == null ? "" : sv.getUserMessage()) + "</td>" + PMD.EOL);
                buf.append("</tr>" + PMD.EOL);
                writer.write(buf.toString());
            }
            writer.write("</table>");
        }
    }

    private String maybeWrap(String filename, String line) {
        if (this.linkPrefix == null) {
            return filename;
        }
        String newFileName = filename.substring(0, filename.lastIndexOf(46)).replace('\\', '/');
        return "<a href=\"" + this.linkPrefix + newFileName + ".html#" + line + "\">" + newFileName + "</a>";
    }
}

