/* Freebirth
 * Copyright (C) 1999 topher lafata <topher@topher.com>,
 *		      Jake Donham <jake@bitmechanic.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#define __SEQ_H


typedef struct seq seq;

#ifndef __OSC_H
  #include "oscillator.h"
#endif

#ifndef __ENV_H
  #include "envelope.h"
#endif

#ifndef __SAMPLE_PRODUCER_H
  #include "sample_producer.h"
#endif

#ifndef __RAW_WAVE_H
  #include "raw_wave.h"
#endif

#ifndef __EVENT_H
  #include "event.h"
#endif

/* these are the currently available time divisions for the sequencer*/
#define QUARTER_NOTE    1
#define EIGHTH_NOTE     2
#define SIXTEENTH_NOTE  4



struct seq{
  int length;
  int current_step;
  int current_sample_offset;  /* offset in samples from current step */
  int bpm;                    /* beats per minute */
  int spb;                    /* samples per beat */
  int time_division;
  
  void (*callback)(int step);
  
  sample_producer **victims;
  event_list **event_map;        /* step maps for each sample producer */
  int current_victim_id;
};



seq *seq_new(int length, int bpm,int time_division,void(*callback)(int step));

int  seq_register_victim(seq *this, sample_producer *sp);
void seq_register_event(seq *this, int step, event *e);
void seq_delete_event(seq *this, int step, event *e);

void seq_delete(seq *this);
void seq_set_bpm(seq *this,int bpm);
void seq_step(seq *this);

char **seq_get_header(seq *this);
char **seq_get_code(seq *this);
char **seq_get_footer(seq *this);

void seq_reset(seq *this);

/*
  Local Variables:
  mode: font-lock
  End:
*/

