// Code generated by smithy-go-codegen DO NOT EDIT.

package datazone

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datazone/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Lists time series data points.
func (c *Client) ListTimeSeriesDataPoints(ctx context.Context, params *ListTimeSeriesDataPointsInput, optFns ...func(*Options)) (*ListTimeSeriesDataPointsOutput, error) {
	if params == nil {
		params = &ListTimeSeriesDataPointsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListTimeSeriesDataPoints", params, optFns, c.addOperationListTimeSeriesDataPointsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListTimeSeriesDataPointsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListTimeSeriesDataPointsInput struct {

	// The ID of the Amazon DataZone domain that houses the assets for which you want
	// to list time series data points.
	//
	// This member is required.
	DomainIdentifier *string

	// The ID of the asset for which you want to list data points.
	//
	// This member is required.
	EntityIdentifier *string

	// The type of the asset for which you want to list data points.
	//
	// This member is required.
	EntityType types.TimeSeriesEntityType

	// The name of the time series data points form.
	//
	// This member is required.
	FormName *string

	// The timestamp at which the data points that you wanted to list ended.
	EndedAt *time.Time

	// The maximum number of data points to return in a single call to
	// ListTimeSeriesDataPoints. When the number of data points to be listed is greater
	// than the value of MaxResults, the response contains a NextToken value that you
	// can use in a subsequent call to ListTimeSeriesDataPoints to list the next set of
	// data points.
	MaxResults *int32

	// When the number of data points is greater than the default value for the
	// MaxResults parameter, or if you explicitly specify a value for MaxResults that
	// is less than the number of data points, the response includes a pagination token
	// named NextToken. You can specify this NextToken value in a subsequent call to
	// ListTimeSeriesDataPoints to list the next set of data points.
	NextToken *string

	// The timestamp at which the data points that you want to list started.
	StartedAt *time.Time

	noSmithyDocumentSerde
}

type ListTimeSeriesDataPointsOutput struct {

	// The results of the ListTimeSeriesDataPoints action.
	Items []types.TimeSeriesDataPointSummaryFormOutput

	// When the number of data points is greater than the default value for the
	// MaxResults parameter, or if you explicitly specify a value for MaxResults that
	// is less than the number of data points, the response includes a pagination token
	// named NextToken. You can specify this NextToken value in a subsequent call to
	// ListTimeSeriesDataPoints to list the next set of data points.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListTimeSeriesDataPointsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListTimeSeriesDataPoints{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListTimeSeriesDataPoints{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListTimeSeriesDataPoints"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListTimeSeriesDataPointsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListTimeSeriesDataPoints(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListTimeSeriesDataPointsAPIClient is a client that implements the
// ListTimeSeriesDataPoints operation.
type ListTimeSeriesDataPointsAPIClient interface {
	ListTimeSeriesDataPoints(context.Context, *ListTimeSeriesDataPointsInput, ...func(*Options)) (*ListTimeSeriesDataPointsOutput, error)
}

var _ ListTimeSeriesDataPointsAPIClient = (*Client)(nil)

// ListTimeSeriesDataPointsPaginatorOptions is the paginator options for
// ListTimeSeriesDataPoints
type ListTimeSeriesDataPointsPaginatorOptions struct {
	// The maximum number of data points to return in a single call to
	// ListTimeSeriesDataPoints. When the number of data points to be listed is greater
	// than the value of MaxResults, the response contains a NextToken value that you
	// can use in a subsequent call to ListTimeSeriesDataPoints to list the next set of
	// data points.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListTimeSeriesDataPointsPaginator is a paginator for ListTimeSeriesDataPoints
type ListTimeSeriesDataPointsPaginator struct {
	options   ListTimeSeriesDataPointsPaginatorOptions
	client    ListTimeSeriesDataPointsAPIClient
	params    *ListTimeSeriesDataPointsInput
	nextToken *string
	firstPage bool
}

// NewListTimeSeriesDataPointsPaginator returns a new
// ListTimeSeriesDataPointsPaginator
func NewListTimeSeriesDataPointsPaginator(client ListTimeSeriesDataPointsAPIClient, params *ListTimeSeriesDataPointsInput, optFns ...func(*ListTimeSeriesDataPointsPaginatorOptions)) *ListTimeSeriesDataPointsPaginator {
	if params == nil {
		params = &ListTimeSeriesDataPointsInput{}
	}

	options := ListTimeSeriesDataPointsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListTimeSeriesDataPointsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListTimeSeriesDataPointsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListTimeSeriesDataPoints page.
func (p *ListTimeSeriesDataPointsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListTimeSeriesDataPointsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListTimeSeriesDataPoints(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListTimeSeriesDataPoints(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListTimeSeriesDataPoints",
	}
}
