// Code generated by smithy-go-codegen DO NOT EDIT.

package entityresolution

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/entityresolution/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Deletes multiple unique IDs in a matching workflow.
func (c *Client) BatchDeleteUniqueId(ctx context.Context, params *BatchDeleteUniqueIdInput, optFns ...func(*Options)) (*BatchDeleteUniqueIdOutput, error) {
	if params == nil {
		params = &BatchDeleteUniqueIdInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "BatchDeleteUniqueId", params, optFns, c.addOperationBatchDeleteUniqueIdMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*BatchDeleteUniqueIdOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type BatchDeleteUniqueIdInput struct {

	// The unique IDs to delete.
	//
	// This member is required.
	UniqueIds []string

	// The name of the workflow.
	//
	// This member is required.
	WorkflowName *string

	// The input source for the batch delete unique ID operation.
	InputSource *string

	noSmithyDocumentSerde
}

type BatchDeleteUniqueIdOutput struct {

	// The unique IDs that were deleted.
	//
	// This member is required.
	Deleted []types.DeletedUniqueId

	// The unique IDs that were disconnected.
	//
	// This member is required.
	DisconnectedUniqueIds []string

	//  The errors from deleting multiple unique IDs.
	//
	// This member is required.
	Errors []types.DeleteUniqueIdError

	// The status of the batch delete unique ID operation.
	//
	// This member is required.
	Status types.DeleteUniqueIdStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationBatchDeleteUniqueIdMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpBatchDeleteUniqueId{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpBatchDeleteUniqueId{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "BatchDeleteUniqueId"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpBatchDeleteUniqueIdValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opBatchDeleteUniqueId(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opBatchDeleteUniqueId(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "BatchDeleteUniqueId",
	}
}
