/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "shell-dbus-interface.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.Shell.Extensions
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:ShellExtensions
 * @title: ShellExtensions
 * @short_description: Generated C code for the org.gnome.Shell.Extensions D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-Shell-Extensions.top_of_page">org.gnome.Shell.Extensions</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.Shell.Extensions ---- */

static const _ExtendedGDBusArgInfo _shell_extensions_method_info_list_extensions_OUT_ARG_extensions =
{
  {
    -1,
    (gchar *) "extensions",
    (gchar *) "a{sa{sv}}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _shell_extensions_method_info_list_extensions_OUT_ARG_pointers[] =
{
  &_shell_extensions_method_info_list_extensions_OUT_ARG_extensions.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _shell_extensions_method_info_list_extensions =
{
  {
    -1,
    (gchar *) "ListExtensions",
    NULL,
    (GDBusArgInfo **) &_shell_extensions_method_info_list_extensions_OUT_ARG_pointers,
    NULL
  },
  "handle-list-extensions",
  FALSE
};

static const _ExtendedGDBusArgInfo _shell_extensions_method_info_get_extension_info_IN_ARG_uuid =
{
  {
    -1,
    (gchar *) "uuid",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _shell_extensions_method_info_get_extension_info_IN_ARG_pointers[] =
{
  &_shell_extensions_method_info_get_extension_info_IN_ARG_uuid.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _shell_extensions_method_info_get_extension_info_OUT_ARG_info =
{
  {
    -1,
    (gchar *) "info",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _shell_extensions_method_info_get_extension_info_OUT_ARG_pointers[] =
{
  &_shell_extensions_method_info_get_extension_info_OUT_ARG_info.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _shell_extensions_method_info_get_extension_info =
{
  {
    -1,
    (gchar *) "GetExtensionInfo",
    (GDBusArgInfo **) &_shell_extensions_method_info_get_extension_info_IN_ARG_pointers,
    (GDBusArgInfo **) &_shell_extensions_method_info_get_extension_info_OUT_ARG_pointers,
    NULL
  },
  "handle-get-extension-info",
  FALSE
};

static const _ExtendedGDBusArgInfo _shell_extensions_method_info_get_extension_errors_IN_ARG_uuid =
{
  {
    -1,
    (gchar *) "uuid",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _shell_extensions_method_info_get_extension_errors_IN_ARG_pointers[] =
{
  &_shell_extensions_method_info_get_extension_errors_IN_ARG_uuid.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _shell_extensions_method_info_get_extension_errors_OUT_ARG_errors =
{
  {
    -1,
    (gchar *) "errors",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _shell_extensions_method_info_get_extension_errors_OUT_ARG_pointers[] =
{
  &_shell_extensions_method_info_get_extension_errors_OUT_ARG_errors.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _shell_extensions_method_info_get_extension_errors =
{
  {
    -1,
    (gchar *) "GetExtensionErrors",
    (GDBusArgInfo **) &_shell_extensions_method_info_get_extension_errors_IN_ARG_pointers,
    (GDBusArgInfo **) &_shell_extensions_method_info_get_extension_errors_OUT_ARG_pointers,
    NULL
  },
  "handle-get-extension-errors",
  FALSE
};

static const _ExtendedGDBusArgInfo _shell_extensions_method_info_install_remote_extension_IN_ARG_uuid =
{
  {
    -1,
    (gchar *) "uuid",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _shell_extensions_method_info_install_remote_extension_IN_ARG_pointers[] =
{
  &_shell_extensions_method_info_install_remote_extension_IN_ARG_uuid.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _shell_extensions_method_info_install_remote_extension_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _shell_extensions_method_info_install_remote_extension_OUT_ARG_pointers[] =
{
  &_shell_extensions_method_info_install_remote_extension_OUT_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _shell_extensions_method_info_install_remote_extension =
{
  {
    -1,
    (gchar *) "InstallRemoteExtension",
    (GDBusArgInfo **) &_shell_extensions_method_info_install_remote_extension_IN_ARG_pointers,
    (GDBusArgInfo **) &_shell_extensions_method_info_install_remote_extension_OUT_ARG_pointers,
    NULL
  },
  "handle-install-remote-extension",
  FALSE
};

static const _ExtendedGDBusArgInfo _shell_extensions_method_info_uninstall_extension_IN_ARG_uuid =
{
  {
    -1,
    (gchar *) "uuid",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _shell_extensions_method_info_uninstall_extension_IN_ARG_pointers[] =
{
  &_shell_extensions_method_info_uninstall_extension_IN_ARG_uuid.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _shell_extensions_method_info_uninstall_extension_OUT_ARG_success =
{
  {
    -1,
    (gchar *) "success",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _shell_extensions_method_info_uninstall_extension_OUT_ARG_pointers[] =
{
  &_shell_extensions_method_info_uninstall_extension_OUT_ARG_success.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _shell_extensions_method_info_uninstall_extension =
{
  {
    -1,
    (gchar *) "UninstallExtension",
    (GDBusArgInfo **) &_shell_extensions_method_info_uninstall_extension_IN_ARG_pointers,
    (GDBusArgInfo **) &_shell_extensions_method_info_uninstall_extension_OUT_ARG_pointers,
    NULL
  },
  "handle-uninstall-extension",
  FALSE
};

static const _ExtendedGDBusArgInfo _shell_extensions_method_info_reload_extension_IN_ARG_uuid =
{
  {
    -1,
    (gchar *) "uuid",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _shell_extensions_method_info_reload_extension_IN_ARG_pointers[] =
{
  &_shell_extensions_method_info_reload_extension_IN_ARG_uuid.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _shell_extensions_method_info_reload_extension =
{
  {
    -1,
    (gchar *) "ReloadExtension",
    (GDBusArgInfo **) &_shell_extensions_method_info_reload_extension_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-reload-extension",
  FALSE
};

static const _ExtendedGDBusArgInfo _shell_extensions_method_info_enable_extension_IN_ARG_uuid =
{
  {
    -1,
    (gchar *) "uuid",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _shell_extensions_method_info_enable_extension_IN_ARG_pointers[] =
{
  &_shell_extensions_method_info_enable_extension_IN_ARG_uuid.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _shell_extensions_method_info_enable_extension_OUT_ARG_success =
{
  {
    -1,
    (gchar *) "success",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _shell_extensions_method_info_enable_extension_OUT_ARG_pointers[] =
{
  &_shell_extensions_method_info_enable_extension_OUT_ARG_success.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _shell_extensions_method_info_enable_extension =
{
  {
    -1,
    (gchar *) "EnableExtension",
    (GDBusArgInfo **) &_shell_extensions_method_info_enable_extension_IN_ARG_pointers,
    (GDBusArgInfo **) &_shell_extensions_method_info_enable_extension_OUT_ARG_pointers,
    NULL
  },
  "handle-enable-extension",
  FALSE
};

static const _ExtendedGDBusArgInfo _shell_extensions_method_info_disable_extension_IN_ARG_uuid =
{
  {
    -1,
    (gchar *) "uuid",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _shell_extensions_method_info_disable_extension_IN_ARG_pointers[] =
{
  &_shell_extensions_method_info_disable_extension_IN_ARG_uuid.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _shell_extensions_method_info_disable_extension_OUT_ARG_success =
{
  {
    -1,
    (gchar *) "success",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _shell_extensions_method_info_disable_extension_OUT_ARG_pointers[] =
{
  &_shell_extensions_method_info_disable_extension_OUT_ARG_success.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _shell_extensions_method_info_disable_extension =
{
  {
    -1,
    (gchar *) "DisableExtension",
    (GDBusArgInfo **) &_shell_extensions_method_info_disable_extension_IN_ARG_pointers,
    (GDBusArgInfo **) &_shell_extensions_method_info_disable_extension_OUT_ARG_pointers,
    NULL
  },
  "handle-disable-extension",
  FALSE
};

static const _ExtendedGDBusArgInfo _shell_extensions_method_info_launch_extension_prefs_IN_ARG_uuid =
{
  {
    -1,
    (gchar *) "uuid",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _shell_extensions_method_info_launch_extension_prefs_IN_ARG_pointers[] =
{
  &_shell_extensions_method_info_launch_extension_prefs_IN_ARG_uuid.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _shell_extensions_method_info_launch_extension_prefs =
{
  {
    -1,
    (gchar *) "LaunchExtensionPrefs",
    (GDBusArgInfo **) &_shell_extensions_method_info_launch_extension_prefs_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-launch-extension-prefs",
  FALSE
};

static const _ExtendedGDBusArgInfo _shell_extensions_method_info_open_extension_prefs_IN_ARG_uuid =
{
  {
    -1,
    (gchar *) "uuid",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _shell_extensions_method_info_open_extension_prefs_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _shell_extensions_method_info_open_extension_prefs_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _shell_extensions_method_info_open_extension_prefs_IN_ARG_pointers[] =
{
  &_shell_extensions_method_info_open_extension_prefs_IN_ARG_uuid.parent_struct,
  &_shell_extensions_method_info_open_extension_prefs_IN_ARG_parent_window.parent_struct,
  &_shell_extensions_method_info_open_extension_prefs_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _shell_extensions_method_info_open_extension_prefs =
{
  {
    -1,
    (gchar *) "OpenExtensionPrefs",
    (GDBusArgInfo **) &_shell_extensions_method_info_open_extension_prefs_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-open-extension-prefs",
  FALSE
};

static const _ExtendedGDBusMethodInfo _shell_extensions_method_info_check_for_updates =
{
  {
    -1,
    (gchar *) "CheckForUpdates",
    NULL,
    NULL,
    NULL
  },
  "handle-check-for-updates",
  FALSE
};

static const GDBusMethodInfo * const _shell_extensions_method_info_pointers[] =
{
  &_shell_extensions_method_info_list_extensions.parent_struct,
  &_shell_extensions_method_info_get_extension_info.parent_struct,
  &_shell_extensions_method_info_get_extension_errors.parent_struct,
  &_shell_extensions_method_info_install_remote_extension.parent_struct,
  &_shell_extensions_method_info_uninstall_extension.parent_struct,
  &_shell_extensions_method_info_reload_extension.parent_struct,
  &_shell_extensions_method_info_enable_extension.parent_struct,
  &_shell_extensions_method_info_disable_extension.parent_struct,
  &_shell_extensions_method_info_launch_extension_prefs.parent_struct,
  &_shell_extensions_method_info_open_extension_prefs.parent_struct,
  &_shell_extensions_method_info_check_for_updates.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _shell_extensions_signal_info_extension_state_changed_ARG_uuid =
{
  {
    -1,
    (gchar *) "uuid",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _shell_extensions_signal_info_extension_state_changed_ARG_state =
{
  {
    -1,
    (gchar *) "state",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _shell_extensions_signal_info_extension_state_changed_ARG_pointers[] =
{
  &_shell_extensions_signal_info_extension_state_changed_ARG_uuid.parent_struct,
  &_shell_extensions_signal_info_extension_state_changed_ARG_state.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _shell_extensions_signal_info_extension_state_changed =
{
  {
    -1,
    (gchar *) "ExtensionStateChanged",
    (GDBusArgInfo **) &_shell_extensions_signal_info_extension_state_changed_ARG_pointers,
    NULL
  },
  "extension-state-changed"
};

static const _ExtendedGDBusArgInfo _shell_extensions_signal_info_extension_status_changed_ARG_uuid =
{
  {
    -1,
    (gchar *) "uuid",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _shell_extensions_signal_info_extension_status_changed_ARG_state =
{
  {
    -1,
    (gchar *) "state",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _shell_extensions_signal_info_extension_status_changed_ARG_error =
{
  {
    -1,
    (gchar *) "error",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _shell_extensions_signal_info_extension_status_changed_ARG_pointers[] =
{
  &_shell_extensions_signal_info_extension_status_changed_ARG_uuid.parent_struct,
  &_shell_extensions_signal_info_extension_status_changed_ARG_state.parent_struct,
  &_shell_extensions_signal_info_extension_status_changed_ARG_error.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _shell_extensions_signal_info_extension_status_changed =
{
  {
    -1,
    (gchar *) "ExtensionStatusChanged",
    (GDBusArgInfo **) &_shell_extensions_signal_info_extension_status_changed_ARG_pointers,
    NULL
  },
  "extension-status-changed"
};

static const GDBusSignalInfo * const _shell_extensions_signal_info_pointers[] =
{
  &_shell_extensions_signal_info_extension_state_changed.parent_struct,
  &_shell_extensions_signal_info_extension_status_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _shell_extensions_property_info_shell_version =
{
  {
    -1,
    (gchar *) "ShellVersion",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "shell-version",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _shell_extensions_property_info_user_extensions_enabled =
{
  {
    -1,
    (gchar *) "UserExtensionsEnabled",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "user-extensions-enabled",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _shell_extensions_property_info_pointers[] =
{
  &_shell_extensions_property_info_shell_version.parent_struct,
  &_shell_extensions_property_info_user_extensions_enabled.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _shell_extensions_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.Shell.Extensions",
    (GDBusMethodInfo **) &_shell_extensions_method_info_pointers,
    (GDBusSignalInfo **) &_shell_extensions_signal_info_pointers,
    (GDBusPropertyInfo **) &_shell_extensions_property_info_pointers,
    NULL
  },
  "extensions",
};


/**
 * shell_extensions_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-Shell-Extensions.top_of_page">org.gnome.Shell.Extensions</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
shell_extensions_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_shell_extensions_interface_info.parent_struct;
}

/**
 * shell_extensions_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #ShellExtensions interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
shell_extensions_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "shell-version");
  g_object_class_override_property (klass, property_id_begin++, "user-extensions-enabled");
  return property_id_begin - 1;
}



/**
 * ShellExtensions:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Shell-Extensions.top_of_page">org.gnome.Shell.Extensions</link>.
 */

/**
 * ShellExtensionsIface:
 * @parent_iface: The parent interface.
 * @handle_check_for_updates: Handler for the #ShellExtensions::handle-check-for-updates signal.
 * @handle_disable_extension: Handler for the #ShellExtensions::handle-disable-extension signal.
 * @handle_enable_extension: Handler for the #ShellExtensions::handle-enable-extension signal.
 * @handle_get_extension_errors: Handler for the #ShellExtensions::handle-get-extension-errors signal.
 * @handle_get_extension_info: Handler for the #ShellExtensions::handle-get-extension-info signal.
 * @handle_install_remote_extension: Handler for the #ShellExtensions::handle-install-remote-extension signal.
 * @handle_launch_extension_prefs: Handler for the #ShellExtensions::handle-launch-extension-prefs signal.
 * @handle_list_extensions: Handler for the #ShellExtensions::handle-list-extensions signal.
 * @handle_open_extension_prefs: Handler for the #ShellExtensions::handle-open-extension-prefs signal.
 * @handle_reload_extension: Handler for the #ShellExtensions::handle-reload-extension signal.
 * @handle_uninstall_extension: Handler for the #ShellExtensions::handle-uninstall-extension signal.
 * @get_shell_version: Getter for the #ShellExtensions:shell-version property.
 * @get_user_extensions_enabled: Getter for the #ShellExtensions:user-extensions-enabled property.
 * @extension_state_changed: Handler for the #ShellExtensions::extension-state-changed signal.
 * @extension_status_changed: Handler for the #ShellExtensions::extension-status-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Shell-Extensions.top_of_page">org.gnome.Shell.Extensions</link>.
 */

typedef ShellExtensionsIface ShellExtensionsInterface;
G_DEFINE_INTERFACE (ShellExtensions, shell_extensions, G_TYPE_OBJECT)

static void
shell_extensions_default_init (ShellExtensionsIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * ShellExtensions::handle-list-extensions:
   * @object: A #ShellExtensions.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell-Extensions.ListExtensions">ListExtensions()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call shell_extensions_complete_list_extensions() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-list-extensions",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ShellExtensionsIface, handle_list_extensions),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ShellExtensions::handle-get-extension-info:
   * @object: A #ShellExtensions.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_uuid: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell-Extensions.GetExtensionInfo">GetExtensionInfo()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call shell_extensions_complete_get_extension_info() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-extension-info",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ShellExtensionsIface, handle_get_extension_info),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * ShellExtensions::handle-get-extension-errors:
   * @object: A #ShellExtensions.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_uuid: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell-Extensions.GetExtensionErrors">GetExtensionErrors()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call shell_extensions_complete_get_extension_errors() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-extension-errors",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ShellExtensionsIface, handle_get_extension_errors),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * ShellExtensions::handle-install-remote-extension:
   * @object: A #ShellExtensions.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_uuid: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell-Extensions.InstallRemoteExtension">InstallRemoteExtension()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call shell_extensions_complete_install_remote_extension() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-install-remote-extension",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ShellExtensionsIface, handle_install_remote_extension),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * ShellExtensions::handle-uninstall-extension:
   * @object: A #ShellExtensions.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_uuid: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell-Extensions.UninstallExtension">UninstallExtension()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call shell_extensions_complete_uninstall_extension() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-uninstall-extension",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ShellExtensionsIface, handle_uninstall_extension),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * ShellExtensions::handle-reload-extension:
   * @object: A #ShellExtensions.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_uuid: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell-Extensions.ReloadExtension">ReloadExtension()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call shell_extensions_complete_reload_extension() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-reload-extension",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ShellExtensionsIface, handle_reload_extension),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * ShellExtensions::handle-enable-extension:
   * @object: A #ShellExtensions.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_uuid: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell-Extensions.EnableExtension">EnableExtension()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call shell_extensions_complete_enable_extension() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-enable-extension",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ShellExtensionsIface, handle_enable_extension),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * ShellExtensions::handle-disable-extension:
   * @object: A #ShellExtensions.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_uuid: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell-Extensions.DisableExtension">DisableExtension()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call shell_extensions_complete_disable_extension() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-disable-extension",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ShellExtensionsIface, handle_disable_extension),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * ShellExtensions::handle-launch-extension-prefs:
   * @object: A #ShellExtensions.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_uuid: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell-Extensions.LaunchExtensionPrefs">LaunchExtensionPrefs()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call shell_extensions_complete_launch_extension_prefs() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-launch-extension-prefs",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ShellExtensionsIface, handle_launch_extension_prefs),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * ShellExtensions::handle-open-extension-prefs:
   * @object: A #ShellExtensions.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_uuid: Argument passed by remote caller.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell-Extensions.OpenExtensionPrefs">OpenExtensionPrefs()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call shell_extensions_complete_open_extension_prefs() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-open-extension-prefs",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ShellExtensionsIface, handle_open_extension_prefs),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * ShellExtensions::handle-check-for-updates:
   * @object: A #ShellExtensions.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell-Extensions.CheckForUpdates">CheckForUpdates()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call shell_extensions_complete_check_for_updates() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-check-for-updates",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ShellExtensionsIface, handle_check_for_updates),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * ShellExtensions::extension-state-changed:
   * @object: A #ShellExtensions.
   * @arg_uuid: Argument.
   * @arg_state: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-Shell-Extensions.ExtensionStateChanged">"ExtensionStateChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("extension-state-changed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ShellExtensionsIface, extension_state_changed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    2, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * ShellExtensions::extension-status-changed:
   * @object: A #ShellExtensions.
   * @arg_uuid: Argument.
   * @arg_state: Argument.
   * @arg_error: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-Shell-Extensions.ExtensionStatusChanged">"ExtensionStatusChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("extension-status-changed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ShellExtensionsIface, extension_status_changed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    3, G_TYPE_STRING, G_TYPE_INT, G_TYPE_STRING);

  /* GObject properties for D-Bus properties: */
  /**
   * ShellExtensions:shell-version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Shell-Extensions.ShellVersion">"ShellVersion"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("shell-version", "ShellVersion", "ShellVersion", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ShellExtensions:user-extensions-enabled:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Shell-Extensions.UserExtensionsEnabled">"UserExtensionsEnabled"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("user-extensions-enabled", "UserExtensionsEnabled", "UserExtensionsEnabled", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * shell_extensions_get_shell_version: (skip)
 * @object: A #ShellExtensions.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Shell-Extensions.ShellVersion">"ShellVersion"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use shell_extensions_dup_shell_version() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
shell_extensions_get_shell_version (ShellExtensions *object)
{
  return SHELL_EXTENSIONS_GET_IFACE (object)->get_shell_version (object);
}

/**
 * shell_extensions_dup_shell_version: (skip)
 * @object: A #ShellExtensions.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-Shell-Extensions.ShellVersion">"ShellVersion"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
shell_extensions_dup_shell_version (ShellExtensions *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "shell-version", &value, NULL);
  return value;
}

/**
 * shell_extensions_set_shell_version: (skip)
 * @object: A #ShellExtensions.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Shell-Extensions.ShellVersion">"ShellVersion"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
shell_extensions_set_shell_version (ShellExtensions *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "shell-version", value, NULL);
}

/**
 * shell_extensions_get_user_extensions_enabled: (skip)
 * @object: A #ShellExtensions.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Shell-Extensions.UserExtensionsEnabled">"UserExtensionsEnabled"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
shell_extensions_get_user_extensions_enabled (ShellExtensions *object)
{
  return SHELL_EXTENSIONS_GET_IFACE (object)->get_user_extensions_enabled (object);
}

/**
 * shell_extensions_set_user_extensions_enabled: (skip)
 * @object: A #ShellExtensions.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Shell-Extensions.UserExtensionsEnabled">"UserExtensionsEnabled"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
shell_extensions_set_user_extensions_enabled (ShellExtensions *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "user-extensions-enabled", value, NULL);
}

/**
 * shell_extensions_emit_extension_state_changed:
 * @object: A #ShellExtensions.
 * @arg_uuid: Argument to pass with the signal.
 * @arg_state: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-Shell-Extensions.ExtensionStateChanged">"ExtensionStateChanged"</link> D-Bus signal.
 */
void
shell_extensions_emit_extension_state_changed (
    ShellExtensions *object,
    const gchar *arg_uuid,
    GVariant *arg_state)
{
  g_signal_emit_by_name (object, "extension-state-changed", arg_uuid, arg_state);
}

/**
 * shell_extensions_emit_extension_status_changed:
 * @object: A #ShellExtensions.
 * @arg_uuid: Argument to pass with the signal.
 * @arg_state: Argument to pass with the signal.
 * @arg_error: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-Shell-Extensions.ExtensionStatusChanged">"ExtensionStatusChanged"</link> D-Bus signal.
 */
void
shell_extensions_emit_extension_status_changed (
    ShellExtensions *object,
    const gchar *arg_uuid,
    gint arg_state,
    const gchar *arg_error)
{
  g_signal_emit_by_name (object, "extension-status-changed", arg_uuid, arg_state, arg_error);
}

/**
 * shell_extensions_call_list_extensions:
 * @proxy: A #ShellExtensionsProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Extensions.ListExtensions">ListExtensions()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shell_extensions_call_list_extensions_finish() to get the result of the operation.
 *
 * See shell_extensions_call_list_extensions_sync() for the synchronous, blocking version of this method.
 */
void
shell_extensions_call_list_extensions (
    ShellExtensions *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ListExtensions",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * shell_extensions_call_list_extensions_finish:
 * @proxy: A #ShellExtensionsProxy.
 * @out_extensions: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shell_extensions_call_list_extensions().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with shell_extensions_call_list_extensions().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shell_extensions_call_list_extensions_finish (
    ShellExtensions *proxy,
    GVariant **out_extensions,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sa{sv}})",
                 out_extensions);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shell_extensions_call_list_extensions_sync:
 * @proxy: A #ShellExtensionsProxy.
 * @out_extensions: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Extensions.ListExtensions">ListExtensions()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See shell_extensions_call_list_extensions() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shell_extensions_call_list_extensions_sync (
    ShellExtensions *proxy,
    GVariant **out_extensions,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ListExtensions",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sa{sv}})",
                 out_extensions);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shell_extensions_call_get_extension_info:
 * @proxy: A #ShellExtensionsProxy.
 * @arg_uuid: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Extensions.GetExtensionInfo">GetExtensionInfo()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shell_extensions_call_get_extension_info_finish() to get the result of the operation.
 *
 * See shell_extensions_call_get_extension_info_sync() for the synchronous, blocking version of this method.
 */
void
shell_extensions_call_get_extension_info (
    ShellExtensions *proxy,
    const gchar *arg_uuid,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetExtensionInfo",
    g_variant_new ("(s)",
                   arg_uuid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * shell_extensions_call_get_extension_info_finish:
 * @proxy: A #ShellExtensionsProxy.
 * @out_info: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shell_extensions_call_get_extension_info().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with shell_extensions_call_get_extension_info().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shell_extensions_call_get_extension_info_finish (
    ShellExtensions *proxy,
    GVariant **out_info,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_info);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shell_extensions_call_get_extension_info_sync:
 * @proxy: A #ShellExtensionsProxy.
 * @arg_uuid: Argument to pass with the method invocation.
 * @out_info: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Extensions.GetExtensionInfo">GetExtensionInfo()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See shell_extensions_call_get_extension_info() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shell_extensions_call_get_extension_info_sync (
    ShellExtensions *proxy,
    const gchar *arg_uuid,
    GVariant **out_info,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetExtensionInfo",
    g_variant_new ("(s)",
                   arg_uuid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_info);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shell_extensions_call_get_extension_errors:
 * @proxy: A #ShellExtensionsProxy.
 * @arg_uuid: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Extensions.GetExtensionErrors">GetExtensionErrors()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shell_extensions_call_get_extension_errors_finish() to get the result of the operation.
 *
 * See shell_extensions_call_get_extension_errors_sync() for the synchronous, blocking version of this method.
 */
void
shell_extensions_call_get_extension_errors (
    ShellExtensions *proxy,
    const gchar *arg_uuid,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetExtensionErrors",
    g_variant_new ("(s)",
                   arg_uuid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * shell_extensions_call_get_extension_errors_finish:
 * @proxy: A #ShellExtensionsProxy.
 * @out_errors: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shell_extensions_call_get_extension_errors().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with shell_extensions_call_get_extension_errors().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shell_extensions_call_get_extension_errors_finish (
    ShellExtensions *proxy,
    gchar ***out_errors,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_errors);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shell_extensions_call_get_extension_errors_sync:
 * @proxy: A #ShellExtensionsProxy.
 * @arg_uuid: Argument to pass with the method invocation.
 * @out_errors: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Extensions.GetExtensionErrors">GetExtensionErrors()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See shell_extensions_call_get_extension_errors() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shell_extensions_call_get_extension_errors_sync (
    ShellExtensions *proxy,
    const gchar *arg_uuid,
    gchar ***out_errors,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetExtensionErrors",
    g_variant_new ("(s)",
                   arg_uuid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_errors);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shell_extensions_call_install_remote_extension:
 * @proxy: A #ShellExtensionsProxy.
 * @arg_uuid: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Extensions.InstallRemoteExtension">InstallRemoteExtension()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shell_extensions_call_install_remote_extension_finish() to get the result of the operation.
 *
 * See shell_extensions_call_install_remote_extension_sync() for the synchronous, blocking version of this method.
 */
void
shell_extensions_call_install_remote_extension (
    ShellExtensions *proxy,
    const gchar *arg_uuid,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "InstallRemoteExtension",
    g_variant_new ("(s)",
                   arg_uuid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * shell_extensions_call_install_remote_extension_finish:
 * @proxy: A #ShellExtensionsProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shell_extensions_call_install_remote_extension().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with shell_extensions_call_install_remote_extension().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shell_extensions_call_install_remote_extension_finish (
    ShellExtensions *proxy,
    gchar **out_result,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shell_extensions_call_install_remote_extension_sync:
 * @proxy: A #ShellExtensionsProxy.
 * @arg_uuid: Argument to pass with the method invocation.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Extensions.InstallRemoteExtension">InstallRemoteExtension()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See shell_extensions_call_install_remote_extension() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shell_extensions_call_install_remote_extension_sync (
    ShellExtensions *proxy,
    const gchar *arg_uuid,
    gchar **out_result,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "InstallRemoteExtension",
    g_variant_new ("(s)",
                   arg_uuid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shell_extensions_call_uninstall_extension:
 * @proxy: A #ShellExtensionsProxy.
 * @arg_uuid: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Extensions.UninstallExtension">UninstallExtension()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shell_extensions_call_uninstall_extension_finish() to get the result of the operation.
 *
 * See shell_extensions_call_uninstall_extension_sync() for the synchronous, blocking version of this method.
 */
void
shell_extensions_call_uninstall_extension (
    ShellExtensions *proxy,
    const gchar *arg_uuid,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "UninstallExtension",
    g_variant_new ("(s)",
                   arg_uuid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * shell_extensions_call_uninstall_extension_finish:
 * @proxy: A #ShellExtensionsProxy.
 * @out_success: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shell_extensions_call_uninstall_extension().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with shell_extensions_call_uninstall_extension().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shell_extensions_call_uninstall_extension_finish (
    ShellExtensions *proxy,
    gboolean *out_success,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_success);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shell_extensions_call_uninstall_extension_sync:
 * @proxy: A #ShellExtensionsProxy.
 * @arg_uuid: Argument to pass with the method invocation.
 * @out_success: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Extensions.UninstallExtension">UninstallExtension()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See shell_extensions_call_uninstall_extension() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shell_extensions_call_uninstall_extension_sync (
    ShellExtensions *proxy,
    const gchar *arg_uuid,
    gboolean *out_success,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "UninstallExtension",
    g_variant_new ("(s)",
                   arg_uuid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_success);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shell_extensions_call_reload_extension:
 * @proxy: A #ShellExtensionsProxy.
 * @arg_uuid: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Extensions.ReloadExtension">ReloadExtension()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shell_extensions_call_reload_extension_finish() to get the result of the operation.
 *
 * See shell_extensions_call_reload_extension_sync() for the synchronous, blocking version of this method.
 */
void
shell_extensions_call_reload_extension (
    ShellExtensions *proxy,
    const gchar *arg_uuid,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ReloadExtension",
    g_variant_new ("(s)",
                   arg_uuid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * shell_extensions_call_reload_extension_finish:
 * @proxy: A #ShellExtensionsProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shell_extensions_call_reload_extension().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with shell_extensions_call_reload_extension().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shell_extensions_call_reload_extension_finish (
    ShellExtensions *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shell_extensions_call_reload_extension_sync:
 * @proxy: A #ShellExtensionsProxy.
 * @arg_uuid: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Extensions.ReloadExtension">ReloadExtension()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See shell_extensions_call_reload_extension() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shell_extensions_call_reload_extension_sync (
    ShellExtensions *proxy,
    const gchar *arg_uuid,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ReloadExtension",
    g_variant_new ("(s)",
                   arg_uuid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shell_extensions_call_enable_extension:
 * @proxy: A #ShellExtensionsProxy.
 * @arg_uuid: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Extensions.EnableExtension">EnableExtension()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shell_extensions_call_enable_extension_finish() to get the result of the operation.
 *
 * See shell_extensions_call_enable_extension_sync() for the synchronous, blocking version of this method.
 */
void
shell_extensions_call_enable_extension (
    ShellExtensions *proxy,
    const gchar *arg_uuid,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "EnableExtension",
    g_variant_new ("(s)",
                   arg_uuid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * shell_extensions_call_enable_extension_finish:
 * @proxy: A #ShellExtensionsProxy.
 * @out_success: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shell_extensions_call_enable_extension().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with shell_extensions_call_enable_extension().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shell_extensions_call_enable_extension_finish (
    ShellExtensions *proxy,
    gboolean *out_success,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_success);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shell_extensions_call_enable_extension_sync:
 * @proxy: A #ShellExtensionsProxy.
 * @arg_uuid: Argument to pass with the method invocation.
 * @out_success: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Extensions.EnableExtension">EnableExtension()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See shell_extensions_call_enable_extension() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shell_extensions_call_enable_extension_sync (
    ShellExtensions *proxy,
    const gchar *arg_uuid,
    gboolean *out_success,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "EnableExtension",
    g_variant_new ("(s)",
                   arg_uuid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_success);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shell_extensions_call_disable_extension:
 * @proxy: A #ShellExtensionsProxy.
 * @arg_uuid: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Extensions.DisableExtension">DisableExtension()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shell_extensions_call_disable_extension_finish() to get the result of the operation.
 *
 * See shell_extensions_call_disable_extension_sync() for the synchronous, blocking version of this method.
 */
void
shell_extensions_call_disable_extension (
    ShellExtensions *proxy,
    const gchar *arg_uuid,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "DisableExtension",
    g_variant_new ("(s)",
                   arg_uuid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * shell_extensions_call_disable_extension_finish:
 * @proxy: A #ShellExtensionsProxy.
 * @out_success: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shell_extensions_call_disable_extension().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with shell_extensions_call_disable_extension().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shell_extensions_call_disable_extension_finish (
    ShellExtensions *proxy,
    gboolean *out_success,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_success);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shell_extensions_call_disable_extension_sync:
 * @proxy: A #ShellExtensionsProxy.
 * @arg_uuid: Argument to pass with the method invocation.
 * @out_success: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Extensions.DisableExtension">DisableExtension()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See shell_extensions_call_disable_extension() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shell_extensions_call_disable_extension_sync (
    ShellExtensions *proxy,
    const gchar *arg_uuid,
    gboolean *out_success,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "DisableExtension",
    g_variant_new ("(s)",
                   arg_uuid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_success);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shell_extensions_call_launch_extension_prefs:
 * @proxy: A #ShellExtensionsProxy.
 * @arg_uuid: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Extensions.LaunchExtensionPrefs">LaunchExtensionPrefs()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shell_extensions_call_launch_extension_prefs_finish() to get the result of the operation.
 *
 * See shell_extensions_call_launch_extension_prefs_sync() for the synchronous, blocking version of this method.
 */
void
shell_extensions_call_launch_extension_prefs (
    ShellExtensions *proxy,
    const gchar *arg_uuid,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "LaunchExtensionPrefs",
    g_variant_new ("(s)",
                   arg_uuid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * shell_extensions_call_launch_extension_prefs_finish:
 * @proxy: A #ShellExtensionsProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shell_extensions_call_launch_extension_prefs().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with shell_extensions_call_launch_extension_prefs().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shell_extensions_call_launch_extension_prefs_finish (
    ShellExtensions *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shell_extensions_call_launch_extension_prefs_sync:
 * @proxy: A #ShellExtensionsProxy.
 * @arg_uuid: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Extensions.LaunchExtensionPrefs">LaunchExtensionPrefs()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See shell_extensions_call_launch_extension_prefs() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shell_extensions_call_launch_extension_prefs_sync (
    ShellExtensions *proxy,
    const gchar *arg_uuid,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "LaunchExtensionPrefs",
    g_variant_new ("(s)",
                   arg_uuid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shell_extensions_call_open_extension_prefs:
 * @proxy: A #ShellExtensionsProxy.
 * @arg_uuid: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Extensions.OpenExtensionPrefs">OpenExtensionPrefs()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shell_extensions_call_open_extension_prefs_finish() to get the result of the operation.
 *
 * See shell_extensions_call_open_extension_prefs_sync() for the synchronous, blocking version of this method.
 */
void
shell_extensions_call_open_extension_prefs (
    ShellExtensions *proxy,
    const gchar *arg_uuid,
    const gchar *arg_parent_window,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "OpenExtensionPrefs",
    g_variant_new ("(ss@a{sv})",
                   arg_uuid,
                   arg_parent_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * shell_extensions_call_open_extension_prefs_finish:
 * @proxy: A #ShellExtensionsProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shell_extensions_call_open_extension_prefs().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with shell_extensions_call_open_extension_prefs().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shell_extensions_call_open_extension_prefs_finish (
    ShellExtensions *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shell_extensions_call_open_extension_prefs_sync:
 * @proxy: A #ShellExtensionsProxy.
 * @arg_uuid: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Extensions.OpenExtensionPrefs">OpenExtensionPrefs()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See shell_extensions_call_open_extension_prefs() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shell_extensions_call_open_extension_prefs_sync (
    ShellExtensions *proxy,
    const gchar *arg_uuid,
    const gchar *arg_parent_window,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "OpenExtensionPrefs",
    g_variant_new ("(ss@a{sv})",
                   arg_uuid,
                   arg_parent_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shell_extensions_call_check_for_updates:
 * @proxy: A #ShellExtensionsProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Extensions.CheckForUpdates">CheckForUpdates()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shell_extensions_call_check_for_updates_finish() to get the result of the operation.
 *
 * See shell_extensions_call_check_for_updates_sync() for the synchronous, blocking version of this method.
 */
void
shell_extensions_call_check_for_updates (
    ShellExtensions *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CheckForUpdates",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * shell_extensions_call_check_for_updates_finish:
 * @proxy: A #ShellExtensionsProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shell_extensions_call_check_for_updates().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with shell_extensions_call_check_for_updates().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shell_extensions_call_check_for_updates_finish (
    ShellExtensions *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shell_extensions_call_check_for_updates_sync:
 * @proxy: A #ShellExtensionsProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Extensions.CheckForUpdates">CheckForUpdates()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See shell_extensions_call_check_for_updates() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
shell_extensions_call_check_for_updates_sync (
    ShellExtensions *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CheckForUpdates",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * shell_extensions_complete_list_extensions:
 * @object: A #ShellExtensions.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @extensions: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell-Extensions.ListExtensions">ListExtensions()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
shell_extensions_complete_list_extensions (
    ShellExtensions *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *extensions)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sa{sv}})",
                   extensions));
}

/**
 * shell_extensions_complete_get_extension_info:
 * @object: A #ShellExtensions.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @info: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell-Extensions.GetExtensionInfo">GetExtensionInfo()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
shell_extensions_complete_get_extension_info (
    ShellExtensions *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *info)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sv})",
                   info));
}

/**
 * shell_extensions_complete_get_extension_errors:
 * @object: A #ShellExtensions.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @errors: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell-Extensions.GetExtensionErrors">GetExtensionErrors()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
shell_extensions_complete_get_extension_errors (
    ShellExtensions *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *errors)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^as)",
                   errors));
}

/**
 * shell_extensions_complete_install_remote_extension:
 * @object: A #ShellExtensions.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @result: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell-Extensions.InstallRemoteExtension">InstallRemoteExtension()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
shell_extensions_complete_install_remote_extension (
    ShellExtensions *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *result)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   result));
}

/**
 * shell_extensions_complete_uninstall_extension:
 * @object: A #ShellExtensions.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @success: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell-Extensions.UninstallExtension">UninstallExtension()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
shell_extensions_complete_uninstall_extension (
    ShellExtensions *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean success)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   success));
}

/**
 * shell_extensions_complete_reload_extension:
 * @object: A #ShellExtensions.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell-Extensions.ReloadExtension">ReloadExtension()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
shell_extensions_complete_reload_extension (
    ShellExtensions *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * shell_extensions_complete_enable_extension:
 * @object: A #ShellExtensions.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @success: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell-Extensions.EnableExtension">EnableExtension()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
shell_extensions_complete_enable_extension (
    ShellExtensions *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean success)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   success));
}

/**
 * shell_extensions_complete_disable_extension:
 * @object: A #ShellExtensions.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @success: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell-Extensions.DisableExtension">DisableExtension()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
shell_extensions_complete_disable_extension (
    ShellExtensions *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean success)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   success));
}

/**
 * shell_extensions_complete_launch_extension_prefs:
 * @object: A #ShellExtensions.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell-Extensions.LaunchExtensionPrefs">LaunchExtensionPrefs()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
shell_extensions_complete_launch_extension_prefs (
    ShellExtensions *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * shell_extensions_complete_open_extension_prefs:
 * @object: A #ShellExtensions.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell-Extensions.OpenExtensionPrefs">OpenExtensionPrefs()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
shell_extensions_complete_open_extension_prefs (
    ShellExtensions *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * shell_extensions_complete_check_for_updates:
 * @object: A #ShellExtensions.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell-Extensions.CheckForUpdates">CheckForUpdates()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
shell_extensions_complete_check_for_updates (
    ShellExtensions *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * ShellExtensionsProxy:
 *
 * The #ShellExtensionsProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * ShellExtensionsProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #ShellExtensionsProxy.
 */

struct _ShellExtensionsProxyPrivate
{
  GData *qdata;
};

static void shell_extensions_proxy_iface_init (ShellExtensionsIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (ShellExtensionsProxy, shell_extensions_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (ShellExtensionsProxy)
                         G_IMPLEMENT_INTERFACE (SHELL_TYPE_EXTENSIONS, shell_extensions_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (ShellExtensionsProxy, shell_extensions_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (SHELL_TYPE_EXTENSIONS, shell_extensions_proxy_iface_init))

#endif
static void
shell_extensions_proxy_finalize (GObject *object)
{
  ShellExtensionsProxy *proxy = SHELL_EXTENSIONS_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (shell_extensions_proxy_parent_class)->finalize (object);
}

static void
shell_extensions_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _shell_extensions_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
shell_extensions_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.gnome.Shell.Extensions: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
shell_extensions_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _shell_extensions_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.gnome.Shell.Extensions", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) shell_extensions_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
shell_extensions_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_shell_extensions_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], SHELL_TYPE_EXTENSIONS);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, SHELL_TYPE_EXTENSIONS);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
shell_extensions_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  ShellExtensionsProxy *proxy = SHELL_EXTENSIONS_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_shell_extensions_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_shell_extensions_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
shell_extensions_proxy_get_shell_version (ShellExtensions *object)
{
  ShellExtensionsProxy *proxy = SHELL_EXTENSIONS_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ShellVersion");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
shell_extensions_proxy_get_user_extensions_enabled (ShellExtensions *object)
{
  ShellExtensionsProxy *proxy = SHELL_EXTENSIONS_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "UserExtensionsEnabled");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
shell_extensions_proxy_init (ShellExtensionsProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = shell_extensions_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, SHELL_TYPE_EXTENSIONS_PROXY, ShellExtensionsProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), shell_extensions_interface_info ());
}

static void
shell_extensions_proxy_class_init (ShellExtensionsProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = shell_extensions_proxy_finalize;
  gobject_class->get_property = shell_extensions_proxy_get_property;
  gobject_class->set_property = shell_extensions_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = shell_extensions_proxy_g_signal;
  proxy_class->g_properties_changed = shell_extensions_proxy_g_properties_changed;

  shell_extensions_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (ShellExtensionsProxyPrivate));
#endif
}

static void
shell_extensions_proxy_iface_init (ShellExtensionsIface *iface)
{
  iface->get_shell_version = shell_extensions_proxy_get_shell_version;
  iface->get_user_extensions_enabled = shell_extensions_proxy_get_user_extensions_enabled;
}

/**
 * shell_extensions_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Shell-Extensions.top_of_page">org.gnome.Shell.Extensions</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shell_extensions_proxy_new_finish() to get the result of the operation.
 *
 * See shell_extensions_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
shell_extensions_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (SHELL_TYPE_EXTENSIONS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Shell.Extensions", NULL);
}

/**
 * shell_extensions_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shell_extensions_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with shell_extensions_proxy_new().
 *
 * Returns: (transfer full) (type ShellExtensionsProxy): The constructed proxy object or %NULL if @error is set.
 */
ShellExtensions *
shell_extensions_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return SHELL_EXTENSIONS (ret);
  else
    return NULL;
}

/**
 * shell_extensions_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Shell-Extensions.top_of_page">org.gnome.Shell.Extensions</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See shell_extensions_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type ShellExtensionsProxy): The constructed proxy object or %NULL if @error is set.
 */
ShellExtensions *
shell_extensions_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (SHELL_TYPE_EXTENSIONS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Shell.Extensions", NULL);
  if (ret != NULL)
    return SHELL_EXTENSIONS (ret);
  else
    return NULL;
}


/**
 * shell_extensions_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like shell_extensions_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shell_extensions_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See shell_extensions_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
shell_extensions_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (SHELL_TYPE_EXTENSIONS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Shell.Extensions", NULL);
}

/**
 * shell_extensions_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shell_extensions_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with shell_extensions_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type ShellExtensionsProxy): The constructed proxy object or %NULL if @error is set.
 */
ShellExtensions *
shell_extensions_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return SHELL_EXTENSIONS (ret);
  else
    return NULL;
}

/**
 * shell_extensions_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like shell_extensions_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See shell_extensions_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type ShellExtensionsProxy): The constructed proxy object or %NULL if @error is set.
 */
ShellExtensions *
shell_extensions_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (SHELL_TYPE_EXTENSIONS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Shell.Extensions", NULL);
  if (ret != NULL)
    return SHELL_EXTENSIONS (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * ShellExtensionsSkeleton:
 *
 * The #ShellExtensionsSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * ShellExtensionsSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #ShellExtensionsSkeleton.
 */

struct _ShellExtensionsSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_shell_extensions_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  ShellExtensionsSkeleton *skeleton = SHELL_EXTENSIONS_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], SHELL_TYPE_EXTENSIONS);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, SHELL_TYPE_EXTENSIONS);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_shell_extensions_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  ShellExtensionsSkeleton *skeleton = SHELL_EXTENSIONS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_shell_extensions_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_shell_extensions_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  ShellExtensionsSkeleton *skeleton = SHELL_EXTENSIONS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_shell_extensions_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _shell_extensions_skeleton_vtable =
{
  _shell_extensions_skeleton_handle_method_call,
  _shell_extensions_skeleton_handle_get_property,
  _shell_extensions_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
shell_extensions_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return shell_extensions_interface_info ();
}

static GDBusInterfaceVTable *
shell_extensions_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_shell_extensions_skeleton_vtable;
}

static GVariant *
shell_extensions_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  ShellExtensionsSkeleton *skeleton = SHELL_EXTENSIONS_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_shell_extensions_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _shell_extensions_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _shell_extensions_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _shell_extensions_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Shell.Extensions", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _shell_extensions_emit_changed (gpointer user_data);

static void
shell_extensions_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  ShellExtensionsSkeleton *skeleton = SHELL_EXTENSIONS_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _shell_extensions_emit_changed (skeleton);
}

static void
_shell_extensions_on_signal_extension_state_changed (
    ShellExtensions *object,
    const gchar *arg_uuid,
    GVariant *arg_state)
{
  ShellExtensionsSkeleton *skeleton = SHELL_EXTENSIONS_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s@a{sv})",
                   arg_uuid,
                   arg_state));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Shell.Extensions", "ExtensionStateChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_shell_extensions_on_signal_extension_status_changed (
    ShellExtensions *object,
    const gchar *arg_uuid,
    gint arg_state,
    const gchar *arg_error)
{
  ShellExtensionsSkeleton *skeleton = SHELL_EXTENSIONS_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(sis)",
                   arg_uuid,
                   arg_state,
                   arg_error));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Shell.Extensions", "ExtensionStatusChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void shell_extensions_skeleton_iface_init (ShellExtensionsIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (ShellExtensionsSkeleton, shell_extensions_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (ShellExtensionsSkeleton)
                         G_IMPLEMENT_INTERFACE (SHELL_TYPE_EXTENSIONS, shell_extensions_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (ShellExtensionsSkeleton, shell_extensions_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (SHELL_TYPE_EXTENSIONS, shell_extensions_skeleton_iface_init))

#endif
static void
shell_extensions_skeleton_finalize (GObject *object)
{
  ShellExtensionsSkeleton *skeleton = SHELL_EXTENSIONS_SKELETON (object);
  guint n;
  for (n = 0; n < 2; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (shell_extensions_skeleton_parent_class)->finalize (object);
}

static void
shell_extensions_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  ShellExtensionsSkeleton *skeleton = SHELL_EXTENSIONS_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_shell_extensions_emit_changed (gpointer user_data)
{
  ShellExtensionsSkeleton *skeleton = SHELL_EXTENSIONS_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.gnome.Shell.Extensions",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_shell_extensions_schedule_emit_changed (ShellExtensionsSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
shell_extensions_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  ShellExtensionsSkeleton *skeleton = SHELL_EXTENSIONS_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _shell_extensions_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _shell_extensions_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
shell_extensions_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  ShellExtensionsSkeleton *skeleton = SHELL_EXTENSIONS_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _shell_extensions_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _shell_extensions_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
shell_extensions_skeleton_init (ShellExtensionsSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = shell_extensions_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, SHELL_TYPE_EXTENSIONS_SKELETON, ShellExtensionsSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 2);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_BOOLEAN);
}

static const gchar *
shell_extensions_skeleton_get_shell_version (ShellExtensions *object)
{
  ShellExtensionsSkeleton *skeleton = SHELL_EXTENSIONS_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
shell_extensions_skeleton_get_user_extensions_enabled (ShellExtensions *object)
{
  ShellExtensionsSkeleton *skeleton = SHELL_EXTENSIONS_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
shell_extensions_skeleton_class_init (ShellExtensionsSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = shell_extensions_skeleton_finalize;
  gobject_class->get_property = shell_extensions_skeleton_get_property;
  gobject_class->set_property = shell_extensions_skeleton_set_property;
  gobject_class->notify       = shell_extensions_skeleton_notify;


  shell_extensions_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = shell_extensions_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = shell_extensions_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = shell_extensions_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = shell_extensions_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (ShellExtensionsSkeletonPrivate));
#endif
}

static void
shell_extensions_skeleton_iface_init (ShellExtensionsIface *iface)
{
  iface->extension_state_changed = _shell_extensions_on_signal_extension_state_changed;
  iface->extension_status_changed = _shell_extensions_on_signal_extension_status_changed;
  iface->get_shell_version = shell_extensions_skeleton_get_shell_version;
  iface->get_user_extensions_enabled = shell_extensions_skeleton_get_user_extensions_enabled;
}

/**
 * shell_extensions_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Shell-Extensions.top_of_page">org.gnome.Shell.Extensions</link>.
 *
 * Returns: (transfer full) (type ShellExtensionsSkeleton): The skeleton object.
 */
ShellExtensions *
shell_extensions_skeleton_new (void)
{
  return SHELL_EXTENSIONS (g_object_new (SHELL_TYPE_EXTENSIONS_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for Object, ObjectProxy and ObjectSkeleton
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:ShellObject
 * @title: ShellObject
 * @short_description: Specialized GDBusObject types
 *
 * This section contains the #ShellObject, #ShellObjectProxy, and #ShellObjectSkeleton types which make it easier to work with objects implementing generated types for D-Bus interfaces.
 */

/**
 * ShellObject:
 *
 * The #ShellObject type is a specialized container of interfaces.
 */

/**
 * ShellObjectIface:
 * @parent_iface: The parent interface.
 *
 * Virtual table for the #ShellObject interface.
 */

typedef ShellObjectIface ShellObjectInterface;
G_DEFINE_INTERFACE_WITH_CODE (ShellObject, shell_object, G_TYPE_OBJECT, g_type_interface_add_prerequisite (g_define_type_id, G_TYPE_DBUS_OBJECT);)

static void
shell_object_default_init (ShellObjectIface *iface)
{
  /**
   * ShellObject:extensions:
   *
   * The #ShellExtensions instance corresponding to the D-Bus interface <link linkend="gdbus-interface-org-gnome-Shell-Extensions.top_of_page">org.gnome.Shell.Extensions</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("extensions", "extensions", "extensions", SHELL_TYPE_EXTENSIONS, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

}

/**
 * shell_object_get_extensions:
 * @object: A #ShellObject.
 *
 * Gets the #ShellExtensions instance for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Shell-Extensions.top_of_page">org.gnome.Shell.Extensions</link> on @object, if any.
 *
 * Returns: (transfer full) (nullable): A #ShellExtensions that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
ShellExtensions *shell_object_get_extensions (ShellObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.gnome.Shell.Extensions");
  if (ret == NULL)
    return NULL;
  return SHELL_EXTENSIONS (ret);
}


/**
 * shell_object_peek_extensions: (skip)
 * @object: A #ShellObject.
 *
 * Like shell_object_get_extensions() but doesn't increase the reference count on the returned object.
 *
 * It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.
 *
 * Returns: (transfer none) (nullable): A #ShellExtensions or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
ShellExtensions *shell_object_peek_extensions (ShellObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.gnome.Shell.Extensions");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return SHELL_EXTENSIONS (ret);
}


static void
shell_object_notify (GDBusObject *object, GDBusInterface *interface)
{
  _ExtendedGDBusInterfaceInfo *info = (_ExtendedGDBusInterfaceInfo *) g_dbus_interface_get_info (interface);
  /* info can be NULL if the other end is using a D-Bus interface we don't know
   * anything about, for example old generated code in this process talking to
   * newer generated code in the other process. */
  if (info != NULL)
    g_object_notify (G_OBJECT (object), info->hyphen_name);
}

/**
 * ShellObjectProxy:
 *
 * The #ShellObjectProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * ShellObjectProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #ShellObjectProxy.
 */

static void
shell_object_proxy__shell_object_iface_init (ShellObjectIface *iface G_GNUC_UNUSED)
{
}

static void
shell_object_proxy__g_dbus_object_iface_init (GDBusObjectIface *iface)
{
  iface->interface_added = shell_object_notify;
  iface->interface_removed = shell_object_notify;
}


G_DEFINE_TYPE_WITH_CODE (ShellObjectProxy, shell_object_proxy, G_TYPE_DBUS_OBJECT_PROXY,
                         G_IMPLEMENT_INTERFACE (SHELL_TYPE_OBJECT, shell_object_proxy__shell_object_iface_init)
                         G_IMPLEMENT_INTERFACE (G_TYPE_DBUS_OBJECT, shell_object_proxy__g_dbus_object_iface_init))

static void
shell_object_proxy_init (ShellObjectProxy *object G_GNUC_UNUSED)
{
}

static void
shell_object_proxy_set_property (GObject      *gobject,
  guint         prop_id,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec)
{
  G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
}

static void
shell_object_proxy_get_property (GObject      *gobject,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec)
{
  ShellObjectProxy *object = SHELL_OBJECT_PROXY (gobject);
  GDBusInterface *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.gnome.Shell.Extensions");
      g_value_take_object (value, interface);
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
shell_object_proxy_class_init (ShellObjectProxyClass *klass)
{
  GObjectClass *gobject_class = G_OBJECT_CLASS (klass);

  gobject_class->set_property = shell_object_proxy_set_property;
  gobject_class->get_property = shell_object_proxy_get_property;

  g_object_class_override_property (gobject_class, 1, "extensions");
}

/**
 * shell_object_proxy_new:
 * @connection: A #GDBusConnection.
 * @object_path: An object path.
 *
 * Creates a new proxy object.
 *
 * Returns: (transfer full): The proxy object.
 */
ShellObjectProxy *
shell_object_proxy_new (GDBusConnection *connection,
  const gchar *object_path)
{
  g_return_val_if_fail (G_IS_DBUS_CONNECTION (connection), NULL);
  g_return_val_if_fail (g_variant_is_object_path (object_path), NULL);
  return SHELL_OBJECT_PROXY (g_object_new (SHELL_TYPE_OBJECT_PROXY, "g-connection", connection, "g-object-path", object_path, NULL));
}

/**
 * ShellObjectSkeleton:
 *
 * The #ShellObjectSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * ShellObjectSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #ShellObjectSkeleton.
 */

static void
shell_object_skeleton__shell_object_iface_init (ShellObjectIface *iface G_GNUC_UNUSED)
{
}


static void
shell_object_skeleton__g_dbus_object_iface_init (GDBusObjectIface *iface)
{
  iface->interface_added = shell_object_notify;
  iface->interface_removed = shell_object_notify;
}

G_DEFINE_TYPE_WITH_CODE (ShellObjectSkeleton, shell_object_skeleton, G_TYPE_DBUS_OBJECT_SKELETON,
                         G_IMPLEMENT_INTERFACE (SHELL_TYPE_OBJECT, shell_object_skeleton__shell_object_iface_init)
                         G_IMPLEMENT_INTERFACE (G_TYPE_DBUS_OBJECT, shell_object_skeleton__g_dbus_object_iface_init))

static void
shell_object_skeleton_init (ShellObjectSkeleton *object G_GNUC_UNUSED)
{
}

static void
shell_object_skeleton_set_property (GObject      *gobject,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  ShellObjectSkeleton *object = SHELL_OBJECT_SKELETON (gobject);
  GDBusInterfaceSkeleton *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (SHELL_IS_EXTENSIONS (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "org.gnome.Shell.Extensions");
        }
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
shell_object_skeleton_get_property (GObject      *gobject,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec)
{
  ShellObjectSkeleton *object = SHELL_OBJECT_SKELETON (gobject);
  GDBusInterface *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.gnome.Shell.Extensions");
      g_value_take_object (value, interface);
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
shell_object_skeleton_class_init (ShellObjectSkeletonClass *klass)
{
  GObjectClass *gobject_class = G_OBJECT_CLASS (klass);

  gobject_class->set_property = shell_object_skeleton_set_property;
  gobject_class->get_property = shell_object_skeleton_get_property;

  g_object_class_override_property (gobject_class, 1, "extensions");
}

/**
 * shell_object_skeleton_new:
 * @object_path: An object path.
 *
 * Creates a new skeleton object.
 *
 * Returns: (transfer full): The skeleton object.
 */
ShellObjectSkeleton *
shell_object_skeleton_new (const gchar *object_path)
{
  g_return_val_if_fail (g_variant_is_object_path (object_path), NULL);
  return SHELL_OBJECT_SKELETON (g_object_new (SHELL_TYPE_OBJECT_SKELETON, "g-object-path", object_path, NULL));
}

/**
 * shell_object_skeleton_set_extensions:
 * @object: A #ShellObjectSkeleton.
 * @interface_: (nullable): A #ShellExtensions or %NULL to clear the interface.
 *
 * Sets the #ShellExtensions instance for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Shell-Extensions.top_of_page">org.gnome.Shell.Extensions</link> on @object.
 */
void shell_object_skeleton_set_extensions (ShellObjectSkeleton *object, ShellExtensions *interface_)
{
  g_object_set (G_OBJECT (object), "extensions", interface_, NULL);
}


/* ------------------------------------------------------------------------
 * Code for ObjectManager client
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:ShellObjectManagerClient
 * @title: ShellObjectManagerClient
 * @short_description: Generated GDBusObjectManagerClient type
 *
 * This section contains a #GDBusObjectManagerClient that uses shell_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc.
 */

/**
 * ShellObjectManagerClient:
 *
 * The #ShellObjectManagerClient structure contains only private data and should only be accessed using the provided API.
 */

/**
 * ShellObjectManagerClientClass:
 * @parent_class: The parent class.
 *
 * Class structure for #ShellObjectManagerClient.
 */

G_DEFINE_TYPE (ShellObjectManagerClient, shell_object_manager_client, G_TYPE_DBUS_OBJECT_MANAGER_CLIENT)

static void
shell_object_manager_client_init (ShellObjectManagerClient *manager G_GNUC_UNUSED)
{
}

static void
shell_object_manager_client_class_init (ShellObjectManagerClientClass *klass G_GNUC_UNUSED)
{
}

/**
 * shell_object_manager_client_get_proxy_type:
 * @manager: A #GDBusObjectManagerClient.
 * @object_path: The object path of the remote object (unused).
 * @interface_name: (nullable): Interface name of the remote object or %NULL to get the object proxy #GType.
 * @user_data: User data (unused).
 *
 * A #GDBusProxyTypeFunc that maps @interface_name to the generated #GDBusObjectProxy derived and #GDBusProxy derived types.
 *
 * Returns: A #GDBusProxy derived #GType if @interface_name is not %NULL, otherwise the #GType for #ShellObjectProxy.
 */
GType
shell_object_manager_client_get_proxy_type (GDBusObjectManagerClient *manager G_GNUC_UNUSED, const gchar *object_path G_GNUC_UNUSED, const gchar *interface_name, gpointer user_data G_GNUC_UNUSED)
{
  static gsize once_init_value = 0;
  static GHashTable *lookup_hash;
  GType ret;

  if (interface_name == NULL)
    return SHELL_TYPE_OBJECT_PROXY;
  if (g_once_init_enter (&once_init_value))
    {
      lookup_hash = g_hash_table_new (g_str_hash, g_str_equal);
      g_hash_table_insert (lookup_hash, (gpointer) "org.gnome.Shell.Extensions", GSIZE_TO_POINTER (SHELL_TYPE_EXTENSIONS_PROXY));
      g_once_init_leave (&once_init_value, 1);
    }
  ret = (GType) GPOINTER_TO_SIZE (g_hash_table_lookup (lookup_hash, interface_name));
  if (ret == (GType) 0)
    ret = G_TYPE_DBUS_PROXY;
  return ret;
}

/**
 * shell_object_manager_client_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates #GDBusObjectManagerClient using shell_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc. See g_dbus_object_manager_client_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shell_object_manager_client_new_finish() to get the result of the operation.
 *
 * See shell_object_manager_client_new_sync() for the synchronous, blocking version of this constructor.
 */
void
shell_object_manager_client_new (
    GDBusConnection        *connection,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GAsyncReadyCallback     callback,
    gpointer                user_data)
{
  g_async_initable_new_async (SHELL_TYPE_OBJECT_MANAGER_CLIENT, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "flags", flags, "name", name, "connection", connection, "object-path", object_path, "get-proxy-type-func", shell_object_manager_client_get_proxy_type, NULL);
}

/**
 * shell_object_manager_client_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shell_object_manager_client_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with shell_object_manager_client_new().
 *
 * Returns: (transfer full) (type ShellObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
shell_object_manager_client_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}

/**
 * shell_object_manager_client_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates #GDBusObjectManagerClient using shell_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc. See g_dbus_object_manager_client_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See shell_object_manager_client_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type ShellObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
shell_object_manager_client_new_sync (
    GDBusConnection        *connection,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GError                **error)
{
  GInitable *ret;
  ret = g_initable_new (SHELL_TYPE_OBJECT_MANAGER_CLIENT, cancellable, error, "flags", flags, "name", name, "connection", connection, "object-path", object_path, "get-proxy-type-func", shell_object_manager_client_get_proxy_type, NULL);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}


/**
 * shell_object_manager_client_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like shell_object_manager_client_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call shell_object_manager_client_new_for_bus_finish() to get the result of the operation.
 *
 * See shell_object_manager_client_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
shell_object_manager_client_new_for_bus (
    GBusType                bus_type,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GAsyncReadyCallback     callback,
    gpointer                user_data)
{
  g_async_initable_new_async (SHELL_TYPE_OBJECT_MANAGER_CLIENT, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "flags", flags, "name", name, "bus-type", bus_type, "object-path", object_path, "get-proxy-type-func", shell_object_manager_client_get_proxy_type, NULL);
}

/**
 * shell_object_manager_client_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to shell_object_manager_client_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with shell_object_manager_client_new_for_bus().
 *
 * Returns: (transfer full) (type ShellObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
shell_object_manager_client_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}

/**
 * shell_object_manager_client_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like shell_object_manager_client_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See shell_object_manager_client_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type ShellObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
shell_object_manager_client_new_for_bus_sync (
    GBusType                bus_type,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GError                **error)
{
  GInitable *ret;
  ret = g_initable_new (SHELL_TYPE_OBJECT_MANAGER_CLIENT, cancellable, error, "flags", flags, "name", name, "bus-type", bus_type, "object-path", object_path, "get-proxy-type-func", shell_object_manager_client_get_proxy_type, NULL);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}


