// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package f3

import (
	"context"
)

const (
	RepositoryNameDefault = "vcs"
	RepositoryNameWiki    = "vcs.wiki"
)

var nameToID = map[string]int64{
	RepositoryNameDefault: 1,
	RepositoryNameWiki:    2,
}

// var RepositoryNames = []string{RepositoryNameDefault, RepositoryNameWiki}

var RepositoryNames = []string{RepositoryNameDefault}

type Repository struct {
	Common

	Name      string
	FetchFunc func(ctx context.Context, destination, internalRef string) `json:"-"`
}

func (o Repository) Equal(other Repository) bool {
	return o.Common.Equal(other.Common) &&
		o.Name == other.Name
}

func (o *Repository) Clone() Interface {
	clone := &Repository{}
	*clone = *o
	return clone
}

func RepositoryDirname(name string) string {
	return "git" + name
}
