// Code generated by smithy-go-codegen DO NOT EDIT.

package lexmodelsv2

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/lexmodelsv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns metadata about an intent.
func (c *Client) DescribeIntent(ctx context.Context, params *DescribeIntentInput, optFns ...func(*Options)) (*DescribeIntentOutput, error) {
	if params == nil {
		params = &DescribeIntentInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeIntent", params, optFns, c.addOperationDescribeIntentMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeIntentOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeIntentInput struct {

	// The identifier of the bot associated with the intent.
	//
	// This member is required.
	BotId *string

	// The version of the bot associated with the intent.
	//
	// This member is required.
	BotVersion *string

	// The identifier of the intent to describe.
	//
	// This member is required.
	IntentId *string

	// The identifier of the language and locale of the intent to describe. The string
	// must match one of the supported locales. For more information, see Supported
	// languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// This member is required.
	LocaleId *string

	noSmithyDocumentSerde
}

type DescribeIntentOutput struct {

	// The identifier of the bot associated with the intent.
	BotId *string

	// The version of the bot associated with the intent.
	BotVersion *string

	// A timestamp of the date and time that the intent was created.
	CreationDateTime *time.Time

	// The description of the intent.
	Description *string

	// The Lambda function called during each turn of a conversation with the intent.
	DialogCodeHook *types.DialogCodeHookSettings

	// The Lambda function called when the intent is complete and ready for
	// fulfillment.
	FulfillmentCodeHook *types.FulfillmentCodeHookSettings

	//
	InitialResponseSetting *types.InitialResponseSetting

	// A list of contexts that must be active for the intent to be considered for
	// sending to the user.
	InputContexts []types.InputContext

	// The response that Amazon Lex sends to when the intent is closed.
	IntentClosingSetting *types.IntentClosingSetting

	// Prompts that Amazon Lex sends to the user to confirm completion of an intent.
	IntentConfirmationSetting *types.IntentConfirmationSetting

	// The unique identifier assigned to the intent when it was created.
	IntentId *string

	// The name specified for the intent.
	IntentName *string

	// Configuration information required to use the AMAZON.KendraSearchIntent intent.
	KendraConfiguration *types.KendraConfiguration

	// A timestamp of the date and time that the intent was last updated.
	LastUpdatedDateTime *time.Time

	// The language and locale specified for the intent.
	LocaleId *string

	// A list of contexts that are activated when the intent is fulfilled.
	OutputContexts []types.OutputContext

	// The identifier of the built-in intent that this intent is derived from, if any.
	ParentIntentSignature *string

	// User utterances that trigger this intent.
	SampleUtterances []types.SampleUtterance

	// The list that determines the priority that slots should be elicited from the
	// user.
	SlotPriorities []types.SlotPriority

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeIntentMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribeIntent{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribeIntent{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDescribeIntentValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeIntent(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeIntent(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "lex",
		OperationName: "DescribeIntent",
	}
}
