// Code generated by smithy-go-codegen DO NOT EDIT.

package neptunegraph

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/neptunegraph/types"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/ptr"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Restores a graph from a snapshot.
func (c *Client) RestoreGraphFromSnapshot(ctx context.Context, params *RestoreGraphFromSnapshotInput, optFns ...func(*Options)) (*RestoreGraphFromSnapshotOutput, error) {
	if params == nil {
		params = &RestoreGraphFromSnapshotInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "RestoreGraphFromSnapshot", params, optFns, c.addOperationRestoreGraphFromSnapshotMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*RestoreGraphFromSnapshotOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type RestoreGraphFromSnapshotInput struct {

	// A name for the new Neptune Analytics graph to be created from the snapshot. The
	// name must contain from 1 to 63 letters, numbers, or hyphens, and its first
	// character must be a letter. It cannot end with a hyphen or contain two
	// consecutive hyphens.
	//
	// This member is required.
	GraphName *string

	// The ID of the snapshot in question.
	//
	// This member is required.
	SnapshotIdentifier *string

	// A value that indicates whether the graph has deletion protection enabled. The
	// graph can't be deleted when deletion protection is enabled.
	DeletionProtection *bool

	// The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the
	// graph. Min = 128
	ProvisionedMemory *int32

	// Specifies whether or not the graph can be reachable over the internet. All
	// access to graphs IAM authenticated. ( true to enable, or false to disable).
	PublicConnectivity *bool

	// The number of replicas in other AZs. Min =0, Max = 2, Default =1
	ReplicaCount *int32

	// Adds metadata tags to the snapshot. These tags can also be used with cost
	// allocation reporting, or used in a Condition statement in an IAM policy.
	Tags map[string]string

	noSmithyDocumentSerde
}

func (in *RestoreGraphFromSnapshotInput) bindEndpointParams(p *EndpointParameters) {

	p.ApiType = ptr.String("ControlPlane")
}

type RestoreGraphFromSnapshotOutput struct {

	// The ARN associated with the graph.
	//
	// This member is required.
	Arn *string

	// The unique identifier of the graph.
	//
	// This member is required.
	Id *string

	// The name of the graph.
	//
	// This member is required.
	Name *string

	// The build number of the graph.
	BuildNumber *string

	// The time at which the graph was created.
	CreateTime *time.Time

	// If true , deletion protection is enabled for the graph.
	DeletionProtection *bool

	// The graph endpoint.
	Endpoint *string

	// The ID of the KMS key used to encrypt and decrypt graph data.
	KmsKeyIdentifier *string

	// The number of memory-optimized Neptune Capacity Units (m-NCUs) allocated to the
	// graph.
	ProvisionedMemory *int32

	// If true , the graph has a public endpoint, otherwise not.
	PublicConnectivity *bool

	// The number of replicas for the graph.
	ReplicaCount *int32

	// The ID of the snapshot from which the graph was created, if any.
	SourceSnapshotId *string

	// The status of the graph.
	Status types.GraphStatus

	// The reason that the graph has this status.
	StatusReason *string

	// Specifies the number of dimensions for vector embeddings loaded into the graph.
	// Max = 65535
	VectorSearchConfiguration *types.VectorSearchConfiguration

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationRestoreGraphFromSnapshotMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpRestoreGraphFromSnapshot{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpRestoreGraphFromSnapshot{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "RestoreGraphFromSnapshot"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpRestoreGraphFromSnapshotValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opRestoreGraphFromSnapshot(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opRestoreGraphFromSnapshot(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "RestoreGraphFromSnapshot",
	}
}
