// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package trustedadvisoriface provides an interface to enable mocking the TrustedAdvisor Public API service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package trustedadvisoriface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/trustedadvisor"
)

// TrustedAdvisorAPI provides an interface to enable mocking the
// trustedadvisor.TrustedAdvisor service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// TrustedAdvisor Public API.
//	func myFunc(svc trustedadvisoriface.TrustedAdvisorAPI) bool {
//	    // Make svc.GetOrganizationRecommendation request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := trustedadvisor.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockTrustedAdvisorClient struct {
//	    trustedadvisoriface.TrustedAdvisorAPI
//	}
//	func (m *mockTrustedAdvisorClient) GetOrganizationRecommendation(input *trustedadvisor.GetOrganizationRecommendationInput) (*trustedadvisor.GetOrganizationRecommendationOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockTrustedAdvisorClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type TrustedAdvisorAPI interface {
	GetOrganizationRecommendation(*trustedadvisor.GetOrganizationRecommendationInput) (*trustedadvisor.GetOrganizationRecommendationOutput, error)
	GetOrganizationRecommendationWithContext(aws.Context, *trustedadvisor.GetOrganizationRecommendationInput, ...request.Option) (*trustedadvisor.GetOrganizationRecommendationOutput, error)
	GetOrganizationRecommendationRequest(*trustedadvisor.GetOrganizationRecommendationInput) (*request.Request, *trustedadvisor.GetOrganizationRecommendationOutput)

	GetRecommendation(*trustedadvisor.GetRecommendationInput) (*trustedadvisor.GetRecommendationOutput, error)
	GetRecommendationWithContext(aws.Context, *trustedadvisor.GetRecommendationInput, ...request.Option) (*trustedadvisor.GetRecommendationOutput, error)
	GetRecommendationRequest(*trustedadvisor.GetRecommendationInput) (*request.Request, *trustedadvisor.GetRecommendationOutput)

	ListChecks(*trustedadvisor.ListChecksInput) (*trustedadvisor.ListChecksOutput, error)
	ListChecksWithContext(aws.Context, *trustedadvisor.ListChecksInput, ...request.Option) (*trustedadvisor.ListChecksOutput, error)
	ListChecksRequest(*trustedadvisor.ListChecksInput) (*request.Request, *trustedadvisor.ListChecksOutput)

	ListChecksPages(*trustedadvisor.ListChecksInput, func(*trustedadvisor.ListChecksOutput, bool) bool) error
	ListChecksPagesWithContext(aws.Context, *trustedadvisor.ListChecksInput, func(*trustedadvisor.ListChecksOutput, bool) bool, ...request.Option) error

	ListOrganizationRecommendationAccounts(*trustedadvisor.ListOrganizationRecommendationAccountsInput) (*trustedadvisor.ListOrganizationRecommendationAccountsOutput, error)
	ListOrganizationRecommendationAccountsWithContext(aws.Context, *trustedadvisor.ListOrganizationRecommendationAccountsInput, ...request.Option) (*trustedadvisor.ListOrganizationRecommendationAccountsOutput, error)
	ListOrganizationRecommendationAccountsRequest(*trustedadvisor.ListOrganizationRecommendationAccountsInput) (*request.Request, *trustedadvisor.ListOrganizationRecommendationAccountsOutput)

	ListOrganizationRecommendationAccountsPages(*trustedadvisor.ListOrganizationRecommendationAccountsInput, func(*trustedadvisor.ListOrganizationRecommendationAccountsOutput, bool) bool) error
	ListOrganizationRecommendationAccountsPagesWithContext(aws.Context, *trustedadvisor.ListOrganizationRecommendationAccountsInput, func(*trustedadvisor.ListOrganizationRecommendationAccountsOutput, bool) bool, ...request.Option) error

	ListOrganizationRecommendationResources(*trustedadvisor.ListOrganizationRecommendationResourcesInput) (*trustedadvisor.ListOrganizationRecommendationResourcesOutput, error)
	ListOrganizationRecommendationResourcesWithContext(aws.Context, *trustedadvisor.ListOrganizationRecommendationResourcesInput, ...request.Option) (*trustedadvisor.ListOrganizationRecommendationResourcesOutput, error)
	ListOrganizationRecommendationResourcesRequest(*trustedadvisor.ListOrganizationRecommendationResourcesInput) (*request.Request, *trustedadvisor.ListOrganizationRecommendationResourcesOutput)

	ListOrganizationRecommendationResourcesPages(*trustedadvisor.ListOrganizationRecommendationResourcesInput, func(*trustedadvisor.ListOrganizationRecommendationResourcesOutput, bool) bool) error
	ListOrganizationRecommendationResourcesPagesWithContext(aws.Context, *trustedadvisor.ListOrganizationRecommendationResourcesInput, func(*trustedadvisor.ListOrganizationRecommendationResourcesOutput, bool) bool, ...request.Option) error

	ListOrganizationRecommendations(*trustedadvisor.ListOrganizationRecommendationsInput) (*trustedadvisor.ListOrganizationRecommendationsOutput, error)
	ListOrganizationRecommendationsWithContext(aws.Context, *trustedadvisor.ListOrganizationRecommendationsInput, ...request.Option) (*trustedadvisor.ListOrganizationRecommendationsOutput, error)
	ListOrganizationRecommendationsRequest(*trustedadvisor.ListOrganizationRecommendationsInput) (*request.Request, *trustedadvisor.ListOrganizationRecommendationsOutput)

	ListOrganizationRecommendationsPages(*trustedadvisor.ListOrganizationRecommendationsInput, func(*trustedadvisor.ListOrganizationRecommendationsOutput, bool) bool) error
	ListOrganizationRecommendationsPagesWithContext(aws.Context, *trustedadvisor.ListOrganizationRecommendationsInput, func(*trustedadvisor.ListOrganizationRecommendationsOutput, bool) bool, ...request.Option) error

	ListRecommendationResources(*trustedadvisor.ListRecommendationResourcesInput) (*trustedadvisor.ListRecommendationResourcesOutput, error)
	ListRecommendationResourcesWithContext(aws.Context, *trustedadvisor.ListRecommendationResourcesInput, ...request.Option) (*trustedadvisor.ListRecommendationResourcesOutput, error)
	ListRecommendationResourcesRequest(*trustedadvisor.ListRecommendationResourcesInput) (*request.Request, *trustedadvisor.ListRecommendationResourcesOutput)

	ListRecommendationResourcesPages(*trustedadvisor.ListRecommendationResourcesInput, func(*trustedadvisor.ListRecommendationResourcesOutput, bool) bool) error
	ListRecommendationResourcesPagesWithContext(aws.Context, *trustedadvisor.ListRecommendationResourcesInput, func(*trustedadvisor.ListRecommendationResourcesOutput, bool) bool, ...request.Option) error

	ListRecommendations(*trustedadvisor.ListRecommendationsInput) (*trustedadvisor.ListRecommendationsOutput, error)
	ListRecommendationsWithContext(aws.Context, *trustedadvisor.ListRecommendationsInput, ...request.Option) (*trustedadvisor.ListRecommendationsOutput, error)
	ListRecommendationsRequest(*trustedadvisor.ListRecommendationsInput) (*request.Request, *trustedadvisor.ListRecommendationsOutput)

	ListRecommendationsPages(*trustedadvisor.ListRecommendationsInput, func(*trustedadvisor.ListRecommendationsOutput, bool) bool) error
	ListRecommendationsPagesWithContext(aws.Context, *trustedadvisor.ListRecommendationsInput, func(*trustedadvisor.ListRecommendationsOutput, bool) bool, ...request.Option) error

	UpdateOrganizationRecommendationLifecycle(*trustedadvisor.UpdateOrganizationRecommendationLifecycleInput) (*trustedadvisor.UpdateOrganizationRecommendationLifecycleOutput, error)
	UpdateOrganizationRecommendationLifecycleWithContext(aws.Context, *trustedadvisor.UpdateOrganizationRecommendationLifecycleInput, ...request.Option) (*trustedadvisor.UpdateOrganizationRecommendationLifecycleOutput, error)
	UpdateOrganizationRecommendationLifecycleRequest(*trustedadvisor.UpdateOrganizationRecommendationLifecycleInput) (*request.Request, *trustedadvisor.UpdateOrganizationRecommendationLifecycleOutput)

	UpdateRecommendationLifecycle(*trustedadvisor.UpdateRecommendationLifecycleInput) (*trustedadvisor.UpdateRecommendationLifecycleOutput, error)
	UpdateRecommendationLifecycleWithContext(aws.Context, *trustedadvisor.UpdateRecommendationLifecycleInput, ...request.Option) (*trustedadvisor.UpdateRecommendationLifecycleOutput, error)
	UpdateRecommendationLifecycleRequest(*trustedadvisor.UpdateRecommendationLifecycleInput) (*request.Request, *trustedadvisor.UpdateRecommendationLifecycleOutput)
}

var _ TrustedAdvisorAPI = (*trustedadvisor.TrustedAdvisor)(nil)
