//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armbotservice

import "encoding/json"

func unmarshalChannelClassification(rawMsg json.RawMessage) (ChannelClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b ChannelClassification
	switch m["channelName"] {
	case "AcsChatChannel":
		b = &AcsChatChannel{}
	case "AlexaChannel":
		b = &AlexaChannel{}
	case "DirectLineChannel":
		b = &DirectLineChannel{}
	case "DirectLineSpeechChannel":
		b = &DirectLineSpeechChannel{}
	case "EmailChannel":
		b = &EmailChannel{}
	case "FacebookChannel":
		b = &FacebookChannel{}
	case "KikChannel":
		b = &KikChannel{}
	case "LineChannel":
		b = &LineChannel{}
	case "M365Extensions":
		b = &M365Extensions{}
	case "MsTeamsChannel":
		b = &MsTeamsChannel{}
	case "Omnichannel":
		b = &Omnichannel{}
	case "OutlookChannel":
		b = &OutlookChannel{}
	case "SearchAssistant":
		b = &SearchAssistant{}
	case "SkypeChannel":
		b = &SkypeChannel{}
	case "SlackChannel":
		b = &SlackChannel{}
	case "SmsChannel":
		b = &SmsChannel{}
	case "TelegramChannel":
		b = &TelegramChannel{}
	case "TelephonyChannel":
		b = &TelephonyChannel{}
	case "WebChatChannel":
		b = &WebChatChannel{}
	default:
		b = &Channel{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}
