//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armcosmos_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/cosmos/armcosmos/v3"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1b33e81bbdc28fcd6644a1315b8d7b1b6d030590/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2023-03-15-preview/examples/data-transfer-service/CosmosDBDataTransferJobCreate.json
func ExampleDataTransferJobsClient_Create() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDataTransferJobsClient().Create(ctx, "rg1", "ddb1", "j1", armcosmos.CreateJobRequest{
		Properties: &armcosmos.DataTransferJobProperties{
			Destination: &armcosmos.AzureBlobDataTransferDataSourceSink{
				Component:     to.Ptr(armcosmos.DataTransferComponentAzureBlobStorage),
				ContainerName: to.Ptr("blob_container"),
				EndpointURL:   to.Ptr("https://blob.windows.net"),
			},
			Source: &armcosmos.CassandraDataTransferDataSourceSink{
				Component:    to.Ptr(armcosmos.DataTransferComponentCosmosDBCassandra),
				KeyspaceName: to.Ptr("keyspace"),
				TableName:    to.Ptr("table"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DataTransferJobGetResults = armcosmos.DataTransferJobGetResults{
	// 	Type: to.Ptr("Microsoft.DocumentDB/databaseAccounts/dataTransferJobs"),
	// 	ID: to.Ptr("ab1b6f34-b33c-46b1-98c7-3a0a63fd0d16"),
	// 	Properties: &armcosmos.DataTransferJobProperties{
	// 		Destination: &armcosmos.AzureBlobDataTransferDataSourceSink{
	// 			Component: to.Ptr(armcosmos.DataTransferComponentAzureBlobStorage),
	// 			ContainerName: to.Ptr("blob_container"),
	// 			EndpointURL: to.Ptr("https://blob.windows.net"),
	// 		},
	// 		JobName: to.Ptr("j1"),
	// 		LastUpdatedUTCTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-12T11:10:55.278Z"); return t}()),
	// 		ProcessedCount: to.Ptr[int64](0),
	// 		Source: &armcosmos.CassandraDataTransferDataSourceSink{
	// 			Component: to.Ptr(armcosmos.DataTransferComponentCosmosDBCassandra),
	// 			KeyspaceName: to.Ptr("keyspace"),
	// 			TableName: to.Ptr("table"),
	// 		},
	// 		Status: to.Ptr("Running"),
	// 		TotalCount: to.Ptr[int64](0),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1b33e81bbdc28fcd6644a1315b8d7b1b6d030590/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2023-03-15-preview/examples/data-transfer-service/CosmosDBDataTransferJobGet.json
func ExampleDataTransferJobsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDataTransferJobsClient().Get(ctx, "rg1", "ddb1", "j1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DataTransferJobGetResults = armcosmos.DataTransferJobGetResults{
	// 	Type: to.Ptr("Microsoft.DocumentDB/databaseAccounts/dataTransferJobs"),
	// 	ID: to.Ptr("ab1b6f34-b33c-46b1-98c7-3a0a63fd0d16"),
	// 	Properties: &armcosmos.DataTransferJobProperties{
	// 		Destination: &armcosmos.AzureBlobDataTransferDataSourceSink{
	// 			Component: to.Ptr(armcosmos.DataTransferComponentAzureBlobStorage),
	// 			ContainerName: to.Ptr("blob_container"),
	// 			EndpointURL: to.Ptr("https://blob.windows.net"),
	// 		},
	// 		JobName: to.Ptr("j1"),
	// 		LastUpdatedUTCTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-12T12:04:23.153Z"); return t}()),
	// 		ProcessedCount: to.Ptr[int64](50),
	// 		Source: &armcosmos.CassandraDataTransferDataSourceSink{
	// 			Component: to.Ptr(armcosmos.DataTransferComponentCosmosDBCassandra),
	// 			KeyspaceName: to.Ptr("keyspace"),
	// 			TableName: to.Ptr("table"),
	// 		},
	// 		Status: to.Ptr("Completed"),
	// 		TotalCount: to.Ptr[int64](50),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1b33e81bbdc28fcd6644a1315b8d7b1b6d030590/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2023-03-15-preview/examples/data-transfer-service/CosmosDBDataTransferJobPause.json
func ExampleDataTransferJobsClient_Pause() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDataTransferJobsClient().Pause(ctx, "rg1", "ddb1", "j1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DataTransferJobGetResults = armcosmos.DataTransferJobGetResults{
	// 	Type: to.Ptr("Microsoft.DocumentDB/databaseAccounts/dataTransferJobs"),
	// 	ID: to.Ptr("ab1b6f34-b33c-46b1-98c7-3a0a63fd0d16"),
	// 	Properties: &armcosmos.DataTransferJobProperties{
	// 		Destination: &armcosmos.AzureBlobDataTransferDataSourceSink{
	// 			Component: to.Ptr(armcosmos.DataTransferComponentAzureBlobStorage),
	// 			ContainerName: to.Ptr("blob_container"),
	// 			EndpointURL: to.Ptr("https://blob.windows.net"),
	// 		},
	// 		JobName: to.Ptr("j1"),
	// 		LastUpdatedUTCTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-12T11:10:55.278Z"); return t}()),
	// 		ProcessedCount: to.Ptr[int64](20),
	// 		Source: &armcosmos.CassandraDataTransferDataSourceSink{
	// 			Component: to.Ptr(armcosmos.DataTransferComponentCosmosDBCassandra),
	// 			KeyspaceName: to.Ptr("keyspace"),
	// 			TableName: to.Ptr("table"),
	// 		},
	// 		Status: to.Ptr("Paused"),
	// 		TotalCount: to.Ptr[int64](100),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1b33e81bbdc28fcd6644a1315b8d7b1b6d030590/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2023-03-15-preview/examples/data-transfer-service/CosmosDBDataTransferJobResume.json
func ExampleDataTransferJobsClient_Resume() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDataTransferJobsClient().Resume(ctx, "rg1", "ddb1", "j1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DataTransferJobGetResults = armcosmos.DataTransferJobGetResults{
	// 	Type: to.Ptr("Microsoft.DocumentDB/databaseAccounts/dataTransferJobs"),
	// 	ID: to.Ptr("ab1b6f34-b33c-46b1-98c7-3a0a63fd0d16"),
	// 	Properties: &armcosmos.DataTransferJobProperties{
	// 		Destination: &armcosmos.AzureBlobDataTransferDataSourceSink{
	// 			Component: to.Ptr(armcosmos.DataTransferComponentAzureBlobStorage),
	// 			ContainerName: to.Ptr("blob_container"),
	// 			EndpointURL: to.Ptr("https://blob.windows.net"),
	// 		},
	// 		JobName: to.Ptr("j1"),
	// 		LastUpdatedUTCTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-12T11:10:55.278Z"); return t}()),
	// 		ProcessedCount: to.Ptr[int64](20),
	// 		Source: &armcosmos.CassandraDataTransferDataSourceSink{
	// 			Component: to.Ptr(armcosmos.DataTransferComponentCosmosDBCassandra),
	// 			KeyspaceName: to.Ptr("keyspace"),
	// 			TableName: to.Ptr("table"),
	// 		},
	// 		Status: to.Ptr("Pending"),
	// 		TotalCount: to.Ptr[int64](100),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1b33e81bbdc28fcd6644a1315b8d7b1b6d030590/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2023-03-15-preview/examples/data-transfer-service/CosmosDBDataTransferJobCancel.json
func ExampleDataTransferJobsClient_Cancel() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDataTransferJobsClient().Cancel(ctx, "rg1", "ddb1", "j1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DataTransferJobGetResults = armcosmos.DataTransferJobGetResults{
	// 	Type: to.Ptr("Microsoft.DocumentDB/databaseAccounts/dataTransferJobs"),
	// 	ID: to.Ptr("ab1b6f34-b33c-46b1-98c7-3a0a63fd0d16"),
	// 	Properties: &armcosmos.DataTransferJobProperties{
	// 		Destination: &armcosmos.AzureBlobDataTransferDataSourceSink{
	// 			Component: to.Ptr(armcosmos.DataTransferComponentAzureBlobStorage),
	// 			ContainerName: to.Ptr("blob_container"),
	// 			EndpointURL: to.Ptr("https://blob.windows.net"),
	// 		},
	// 		JobName: to.Ptr("j1"),
	// 		LastUpdatedUTCTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-12T11:10:55.278Z"); return t}()),
	// 		ProcessedCount: to.Ptr[int64](20),
	// 		Source: &armcosmos.CassandraDataTransferDataSourceSink{
	// 			Component: to.Ptr(armcosmos.DataTransferComponentCosmosDBCassandra),
	// 			KeyspaceName: to.Ptr("keyspace"),
	// 			TableName: to.Ptr("table"),
	// 		},
	// 		Status: to.Ptr("Cancelled"),
	// 		TotalCount: to.Ptr[int64](100),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1b33e81bbdc28fcd6644a1315b8d7b1b6d030590/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2023-03-15-preview/examples/data-transfer-service/CosmosDBDataTransferJobFeed.json
func ExampleDataTransferJobsClient_NewListByDatabaseAccountPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDataTransferJobsClient().NewListByDatabaseAccountPager("rg1", "ddb1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DataTransferJobFeedResults = armcosmos.DataTransferJobFeedResults{
		// 	Value: []*armcosmos.DataTransferJobGetResults{
		// 		{
		// 			Type: to.Ptr("Microsoft.DocumentDB/databaseAccounts/dataTransferJobs"),
		// 			ID: to.Ptr("ab1b6f34-b33c-46b1-98c7-3a0a63fd0d16"),
		// 			Properties: &armcosmos.DataTransferJobProperties{
		// 				Destination: &armcosmos.AzureBlobDataTransferDataSourceSink{
		// 					Component: to.Ptr(armcosmos.DataTransferComponentAzureBlobStorage),
		// 					ContainerName: to.Ptr("blob_container"),
		// 					EndpointURL: to.Ptr("https://blob.windows.net"),
		// 				},
		// 				JobName: to.Ptr("j1"),
		// 				LastUpdatedUTCTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-12T12:04:23.153Z"); return t}()),
		// 				ProcessedCount: to.Ptr[int64](100),
		// 				Source: &armcosmos.CassandraDataTransferDataSourceSink{
		// 					Component: to.Ptr(armcosmos.DataTransferComponentCosmosDBCassandra),
		// 					KeyspaceName: to.Ptr("keyspace"),
		// 					TableName: to.Ptr("table"),
		// 				},
		// 				Status: to.Ptr("Completed"),
		// 				TotalCount: to.Ptr[int64](100),
		// 			},
		// 	}},
		// }
	}
}
