//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armiotfirmwaredefense

const (
	moduleName    = "github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/iotfirmwaredefense/armiotfirmwaredefense"
	moduleVersion = "v0.2.0"
)

// ActionType - Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
type ActionType string

const (
	ActionTypeInternal ActionType = "Internal"
)

// PossibleActionTypeValues returns the possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{
		ActionTypeInternal,
	}
}

// CanaryFlag - Canary flag.
type CanaryFlag string

const (
	CanaryFlagFalse CanaryFlag = "False"
	CanaryFlagTrue  CanaryFlag = "True"
)

// PossibleCanaryFlagValues returns the possible values for the CanaryFlag const type.
func PossibleCanaryFlagValues() []CanaryFlag {
	return []CanaryFlag{
		CanaryFlagFalse,
		CanaryFlagTrue,
	}
}

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// IsExpired - Indicates if the certificate is expired.
type IsExpired string

const (
	IsExpiredFalse IsExpired = "False"
	IsExpiredTrue  IsExpired = "True"
)

// PossibleIsExpiredValues returns the possible values for the IsExpired const type.
func PossibleIsExpiredValues() []IsExpired {
	return []IsExpired{
		IsExpiredFalse,
		IsExpiredTrue,
	}
}

// IsSelfSigned - Indicates if the certificate was self-signed.
type IsSelfSigned string

const (
	IsSelfSignedFalse IsSelfSigned = "False"
	IsSelfSignedTrue  IsSelfSigned = "True"
)

// PossibleIsSelfSignedValues returns the possible values for the IsSelfSigned const type.
func PossibleIsSelfSignedValues() []IsSelfSigned {
	return []IsSelfSigned{
		IsSelfSignedFalse,
		IsSelfSignedTrue,
	}
}

// IsShortKeySize - Indicates the key size is considered too small to be secure for the algorithm.
type IsShortKeySize string

const (
	IsShortKeySizeFalse IsShortKeySize = "False"
	IsShortKeySizeTrue  IsShortKeySize = "True"
)

// PossibleIsShortKeySizeValues returns the possible values for the IsShortKeySize const type.
func PossibleIsShortKeySizeValues() []IsShortKeySize {
	return []IsShortKeySize{
		IsShortKeySizeFalse,
		IsShortKeySizeTrue,
	}
}

// IsUpdateAvailable - Flag if new update is available for the component.
type IsUpdateAvailable string

const (
	IsUpdateAvailableFalse IsUpdateAvailable = "False"
	IsUpdateAvailableTrue  IsUpdateAvailable = "True"
)

// PossibleIsUpdateAvailableValues returns the possible values for the IsUpdateAvailable const type.
func PossibleIsUpdateAvailableValues() []IsUpdateAvailable {
	return []IsUpdateAvailable{
		IsUpdateAvailableFalse,
		IsUpdateAvailableTrue,
	}
}

// IsWeakSignature - Indicates the signature algorithm used is insecure.
type IsWeakSignature string

const (
	IsWeakSignatureFalse IsWeakSignature = "False"
	IsWeakSignatureTrue  IsWeakSignature = "True"
)

// PossibleIsWeakSignatureValues returns the possible values for the IsWeakSignature const type.
func PossibleIsWeakSignatureValues() []IsWeakSignature {
	return []IsWeakSignature{
		IsWeakSignatureFalse,
		IsWeakSignatureTrue,
	}
}

// NxFlag - NX flag.
type NxFlag string

const (
	NxFlagFalse NxFlag = "False"
	NxFlagTrue  NxFlag = "True"
)

// PossibleNxFlagValues returns the possible values for the NxFlag const type.
func PossibleNxFlagValues() []NxFlag {
	return []NxFlag{
		NxFlagFalse,
		NxFlagTrue,
	}
}

// Origin - The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
// value is "user,system"
type Origin string

const (
	OriginSystem     Origin = "system"
	OriginUser       Origin = "user"
	OriginUserSystem Origin = "user,system"
)

// PossibleOriginValues returns the possible values for the Origin const type.
func PossibleOriginValues() []Origin {
	return []Origin{
		OriginSystem,
		OriginUser,
		OriginUserSystem,
	}
}

// PieFlag - PIE flag.
type PieFlag string

const (
	PieFlagFalse PieFlag = "False"
	PieFlagTrue  PieFlag = "True"
)

// PossiblePieFlagValues returns the possible values for the PieFlag const type.
func PossiblePieFlagValues() []PieFlag {
	return []PieFlag{
		PieFlagFalse,
		PieFlagTrue,
	}
}

// ProvisioningState - Provisioning state of the resource.
type ProvisioningState string

const (
	ProvisioningStateAccepted  ProvisioningState = "Accepted"
	ProvisioningStateCanceled  ProvisioningState = "Canceled"
	ProvisioningStateFailed    ProvisioningState = "Failed"
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns the possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{
		ProvisioningStateAccepted,
		ProvisioningStateCanceled,
		ProvisioningStateFailed,
		ProvisioningStateSucceeded,
	}
}

// RelroFlag - RELRO flag.
type RelroFlag string

const (
	RelroFlagFalse RelroFlag = "False"
	RelroFlagTrue  RelroFlag = "True"
)

// PossibleRelroFlagValues returns the possible values for the RelroFlag const type.
func PossibleRelroFlagValues() []RelroFlag {
	return []RelroFlag{
		RelroFlagFalse,
		RelroFlagTrue,
	}
}

// Status - The status of firmware scan.
type Status string

const (
	StatusAnalyzing  Status = "Analyzing"
	StatusError      Status = "Error"
	StatusExtracting Status = "Extracting"
	StatusPending    Status = "Pending"
	StatusReady      Status = "Ready"
)

// PossibleStatusValues returns the possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{
		StatusAnalyzing,
		StatusError,
		StatusExtracting,
		StatusPending,
		StatusReady,
	}
}

// StrippedFlag - Stripped flag.
type StrippedFlag string

const (
	StrippedFlagFalse StrippedFlag = "False"
	StrippedFlagTrue  StrippedFlag = "True"
)

// PossibleStrippedFlagValues returns the possible values for the StrippedFlag const type.
func PossibleStrippedFlagValues() []StrippedFlag {
	return []StrippedFlag{
		StrippedFlagFalse,
		StrippedFlagTrue,
	}
}
