//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"encoding/json"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/kusto/armkusto/v2"
)

func unmarshalDataConnectionClassification(rawMsg json.RawMessage) (armkusto.DataConnectionClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b armkusto.DataConnectionClassification
	switch m["kind"] {
	case string(armkusto.DataConnectionKindCosmosDb):
		b = &armkusto.CosmosDbDataConnection{}
	case string(armkusto.DataConnectionKindEventGrid):
		b = &armkusto.EventGridDataConnection{}
	case string(armkusto.DataConnectionKindEventHub):
		b = &armkusto.EventHubDataConnection{}
	case string(armkusto.DataConnectionKindIotHub):
		b = &armkusto.IotHubDataConnection{}
	default:
		b = &armkusto.DataConnection{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalDatabaseClassification(rawMsg json.RawMessage) (armkusto.DatabaseClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b armkusto.DatabaseClassification
	switch m["kind"] {
	case string(armkusto.KindReadOnlyFollowing):
		b = &armkusto.ReadOnlyFollowingDatabase{}
	case string(armkusto.KindReadWrite):
		b = &armkusto.ReadWriteDatabase{}
	default:
		b = &armkusto.Database{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}
