//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/saas/armsaas"
	"net/http"
	"net/url"
	"regexp"
)

// SubscriptionLevelServer is a fake server for instances of the armsaas.SubscriptionLevelClient type.
type SubscriptionLevelServer struct {
	// BeginCreateOrUpdate is the fake for method SubscriptionLevelClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, resourceName string, parameters armsaas.ResourceCreation, options *armsaas.SubscriptionLevelClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armsaas.SubscriptionLevelClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method SubscriptionLevelClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, resourceName string, options *armsaas.SubscriptionLevelClientBeginDeleteOptions) (resp azfake.PollerResponder[armsaas.SubscriptionLevelClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method SubscriptionLevelClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, resourceName string, options *armsaas.SubscriptionLevelClientGetOptions) (resp azfake.Responder[armsaas.SubscriptionLevelClientGetResponse], errResp azfake.ErrorResponder)

	// ListAccessToken is the fake for method SubscriptionLevelClient.ListAccessToken
	// HTTP status codes to indicate success: http.StatusOK
	ListAccessToken func(ctx context.Context, resourceGroupName string, resourceName string, options *armsaas.SubscriptionLevelClientListAccessTokenOptions) (resp azfake.Responder[armsaas.SubscriptionLevelClientListAccessTokenResponse], errResp azfake.ErrorResponder)

	// NewListByAzureSubscriptionPager is the fake for method SubscriptionLevelClient.NewListByAzureSubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByAzureSubscriptionPager func(options *armsaas.SubscriptionLevelClientListByAzureSubscriptionOptions) (resp azfake.PagerResponder[armsaas.SubscriptionLevelClientListByAzureSubscriptionResponse])

	// NewListByResourceGroupPager is the fake for method SubscriptionLevelClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armsaas.SubscriptionLevelClientListByResourceGroupOptions) (resp azfake.PagerResponder[armsaas.SubscriptionLevelClientListByResourceGroupResponse])

	// BeginMoveResources is the fake for method SubscriptionLevelClient.BeginMoveResources
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginMoveResources func(ctx context.Context, resourceGroupName string, moveResourceParameter armsaas.MoveResource, options *armsaas.SubscriptionLevelClientBeginMoveResourcesOptions) (resp azfake.PollerResponder[armsaas.SubscriptionLevelClientMoveResourcesResponse], errResp azfake.ErrorResponder)

	// BeginUpdate is the fake for method SubscriptionLevelClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginUpdate func(ctx context.Context, resourceGroupName string, resourceName string, parameters armsaas.ResourceCreation, options *armsaas.SubscriptionLevelClientBeginUpdateOptions) (resp azfake.PollerResponder[armsaas.SubscriptionLevelClientUpdateResponse], errResp azfake.ErrorResponder)

	// BeginUpdateToUnsubscribed is the fake for method SubscriptionLevelClient.BeginUpdateToUnsubscribed
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginUpdateToUnsubscribed func(ctx context.Context, resourceGroupName string, resourceName string, parameters armsaas.DeleteOptions, options *armsaas.SubscriptionLevelClientBeginUpdateToUnsubscribedOptions) (resp azfake.PollerResponder[armsaas.SubscriptionLevelClientUpdateToUnsubscribedResponse], errResp azfake.ErrorResponder)

	// ValidateMoveResources is the fake for method SubscriptionLevelClient.ValidateMoveResources
	// HTTP status codes to indicate success: http.StatusOK
	ValidateMoveResources func(ctx context.Context, resourceGroupName string, moveResourceParameter armsaas.MoveResource, options *armsaas.SubscriptionLevelClientValidateMoveResourcesOptions) (resp azfake.Responder[armsaas.SubscriptionLevelClientValidateMoveResourcesResponse], errResp azfake.ErrorResponder)
}

// NewSubscriptionLevelServerTransport creates a new instance of SubscriptionLevelServerTransport with the provided implementation.
// The returned SubscriptionLevelServerTransport instance is connected to an instance of armsaas.SubscriptionLevelClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSubscriptionLevelServerTransport(srv *SubscriptionLevelServer) *SubscriptionLevelServerTransport {
	return &SubscriptionLevelServerTransport{
		srv:                             srv,
		beginCreateOrUpdate:             newTracker[azfake.PollerResponder[armsaas.SubscriptionLevelClientCreateOrUpdateResponse]](),
		beginDelete:                     newTracker[azfake.PollerResponder[armsaas.SubscriptionLevelClientDeleteResponse]](),
		newListByAzureSubscriptionPager: newTracker[azfake.PagerResponder[armsaas.SubscriptionLevelClientListByAzureSubscriptionResponse]](),
		newListByResourceGroupPager:     newTracker[azfake.PagerResponder[armsaas.SubscriptionLevelClientListByResourceGroupResponse]](),
		beginMoveResources:              newTracker[azfake.PollerResponder[armsaas.SubscriptionLevelClientMoveResourcesResponse]](),
		beginUpdate:                     newTracker[azfake.PollerResponder[armsaas.SubscriptionLevelClientUpdateResponse]](),
		beginUpdateToUnsubscribed:       newTracker[azfake.PollerResponder[armsaas.SubscriptionLevelClientUpdateToUnsubscribedResponse]](),
	}
}

// SubscriptionLevelServerTransport connects instances of armsaas.SubscriptionLevelClient to instances of SubscriptionLevelServer.
// Don't use this type directly, use NewSubscriptionLevelServerTransport instead.
type SubscriptionLevelServerTransport struct {
	srv                             *SubscriptionLevelServer
	beginCreateOrUpdate             *tracker[azfake.PollerResponder[armsaas.SubscriptionLevelClientCreateOrUpdateResponse]]
	beginDelete                     *tracker[azfake.PollerResponder[armsaas.SubscriptionLevelClientDeleteResponse]]
	newListByAzureSubscriptionPager *tracker[azfake.PagerResponder[armsaas.SubscriptionLevelClientListByAzureSubscriptionResponse]]
	newListByResourceGroupPager     *tracker[azfake.PagerResponder[armsaas.SubscriptionLevelClientListByResourceGroupResponse]]
	beginMoveResources              *tracker[azfake.PollerResponder[armsaas.SubscriptionLevelClientMoveResourcesResponse]]
	beginUpdate                     *tracker[azfake.PollerResponder[armsaas.SubscriptionLevelClientUpdateResponse]]
	beginUpdateToUnsubscribed       *tracker[azfake.PollerResponder[armsaas.SubscriptionLevelClientUpdateToUnsubscribedResponse]]
}

// Do implements the policy.Transporter interface for SubscriptionLevelServerTransport.
func (s *SubscriptionLevelServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SubscriptionLevelClient.BeginCreateOrUpdate":
		resp, err = s.dispatchBeginCreateOrUpdate(req)
	case "SubscriptionLevelClient.BeginDelete":
		resp, err = s.dispatchBeginDelete(req)
	case "SubscriptionLevelClient.Get":
		resp, err = s.dispatchGet(req)
	case "SubscriptionLevelClient.ListAccessToken":
		resp, err = s.dispatchListAccessToken(req)
	case "SubscriptionLevelClient.NewListByAzureSubscriptionPager":
		resp, err = s.dispatchNewListByAzureSubscriptionPager(req)
	case "SubscriptionLevelClient.NewListByResourceGroupPager":
		resp, err = s.dispatchNewListByResourceGroupPager(req)
	case "SubscriptionLevelClient.BeginMoveResources":
		resp, err = s.dispatchBeginMoveResources(req)
	case "SubscriptionLevelClient.BeginUpdate":
		resp, err = s.dispatchBeginUpdate(req)
	case "SubscriptionLevelClient.BeginUpdateToUnsubscribed":
		resp, err = s.dispatchBeginUpdateToUnsubscribed(req)
	case "SubscriptionLevelClient.ValidateMoveResources":
		resp, err = s.dispatchValidateMoveResources(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SubscriptionLevelServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := s.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SaaS/resources/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsaas.ResourceCreation](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, resourceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		s.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		s.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (s *SubscriptionLevelServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if s.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := s.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SaaS/resources/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginDelete(req.Context(), resourceGroupNameParam, resourceNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		s.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		s.beginDelete.remove(req)
	}

	return resp, nil
}

func (s *SubscriptionLevelServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SaaS/resources/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, resourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Resource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SubscriptionLevelServerTransport) dispatchListAccessToken(req *http.Request) (*http.Response, error) {
	if s.srv.ListAccessToken == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListAccessToken not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SaaS/resources/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listAccessToken`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.ListAccessToken(req.Context(), resourceGroupNameParam, resourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AccessTokenResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SubscriptionLevelServerTransport) dispatchNewListByAzureSubscriptionPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListByAzureSubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByAzureSubscriptionPager not implemented")}
	}
	newListByAzureSubscriptionPager := s.newListByAzureSubscriptionPager.get(req)
	if newListByAzureSubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SaaS/resources`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := s.srv.NewListByAzureSubscriptionPager(nil)
		newListByAzureSubscriptionPager = &resp
		s.newListByAzureSubscriptionPager.add(req, newListByAzureSubscriptionPager)
		server.PagerResponderInjectNextLinks(newListByAzureSubscriptionPager, req, func(page *armsaas.SubscriptionLevelClientListByAzureSubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByAzureSubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListByAzureSubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByAzureSubscriptionPager) {
		s.newListByAzureSubscriptionPager.remove(req)
	}
	return resp, nil
}

func (s *SubscriptionLevelServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := s.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SaaS/resources`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		s.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armsaas.SubscriptionLevelClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		s.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (s *SubscriptionLevelServerTransport) dispatchBeginMoveResources(req *http.Request) (*http.Response, error) {
	if s.srv.BeginMoveResources == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginMoveResources not implemented")}
	}
	beginMoveResources := s.beginMoveResources.get(req)
	if beginMoveResources == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/moveResources`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsaas.MoveResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginMoveResources(req.Context(), resourceGroupNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginMoveResources = &respr
		s.beginMoveResources.add(req, beginMoveResources)
	}

	resp, err := server.PollerResponderNext(beginMoveResources, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginMoveResources.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginMoveResources) {
		s.beginMoveResources.remove(req)
	}

	return resp, nil
}

func (s *SubscriptionLevelServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := s.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SaaS/resources/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsaas.ResourceCreation](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginUpdate(req.Context(), resourceGroupNameParam, resourceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		s.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		s.beginUpdate.remove(req)
	}

	return resp, nil
}

func (s *SubscriptionLevelServerTransport) dispatchBeginUpdateToUnsubscribed(req *http.Request) (*http.Response, error) {
	if s.srv.BeginUpdateToUnsubscribed == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdateToUnsubscribed not implemented")}
	}
	beginUpdateToUnsubscribed := s.beginUpdateToUnsubscribed.get(req)
	if beginUpdateToUnsubscribed == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SaaS/resources/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/unsubscribe`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsaas.DeleteOptions](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginUpdateToUnsubscribed(req.Context(), resourceGroupNameParam, resourceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdateToUnsubscribed = &respr
		s.beginUpdateToUnsubscribed.add(req, beginUpdateToUnsubscribed)
	}

	resp, err := server.PollerResponderNext(beginUpdateToUnsubscribed, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginUpdateToUnsubscribed.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdateToUnsubscribed) {
		s.beginUpdateToUnsubscribed.remove(req)
	}

	return resp, nil
}

func (s *SubscriptionLevelServerTransport) dispatchValidateMoveResources(req *http.Request) (*http.Response, error) {
	if s.srv.ValidateMoveResources == nil {
		return nil, &nonRetriableError{errors.New("fake for method ValidateMoveResources not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/validateMoveResources`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armsaas.MoveResource](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.ValidateMoveResources(req.Context(), resourceGroupNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
