//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsecurity_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e716082ac474f182e2220e4f38f1d6191e7636cf/specification/security/resource-manager/Microsoft.Security/stable/2019-08-01/examples/IoTSecuritySolutions/GetIoTSecuritySolutionsListByIotHub.json
func ExampleIotSecuritySolutionClient_NewListBySubscriptionPager_listIoTSecuritySolutionsByIoTHub() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewIotSecuritySolutionClient().NewListBySubscriptionPager(&armsecurity.IotSecuritySolutionClientListBySubscriptionOptions{Filter: to.Ptr("properties.iotHubs/any(i eq \"/subscriptions/075423e9-7d33-4166-8bdf-3920b04e3735/resourceGroups/myRg/providers/Microsoft.Devices/IotHubs/FirstIotHub\")")})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.IoTSecuritySolutionsList = armsecurity.IoTSecuritySolutionsList{
		// 	Value: []*armsecurity.IoTSecuritySolutionModel{
		// 		{
		// 			Name: to.Ptr("default"),
		// 			Type: to.Ptr("Microsoft.Security/IoTSecuritySolutions"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/MyGroup/providers/Microsoft.Security/IoTSecuritySolutions/Locations/eastus/default"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Location: to.Ptr("East Us"),
		// 			Properties: &armsecurity.IoTSecuritySolutionProperties{
		// 				AutoDiscoveredResources: []*string{
		// 					to.Ptr("/subscriptions/075423e9-7d33-4166-8bdf-3920b04e3735"),
		// 					to.Ptr("/subscriptions/075423e9-7d33-4166-8bdf-3920b04e3735/resourceGroups/myRg/providers/Microsoft.Devices/IotHubs/FirstIotHub")},
		// 					DisabledDataSources: []*armsecurity.DataSource{
		// 					},
		// 					DisplayName: to.Ptr("Solution Default"),
		// 					Export: []*armsecurity.ExportData{
		// 						to.Ptr(armsecurity.ExportDataRawEvents)},
		// 						IotHubs: []*string{
		// 							to.Ptr("/subscriptions/075423e9-7d33-4166-8bdf-3920b04e3735/resourceGroups/myRg/providers/Microsoft.Devices/IotHubs/FirstIotHub")},
		// 							RecommendationsConfiguration: []*armsecurity.RecommendationConfigurationProperties{
		// 								{
		// 									Name: to.Ptr("Service Principal Not Used with ACR"),
		// 									RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTAcrauthentication),
		// 									Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 								},
		// 								{
		// 									Name: to.Ptr("Agent sending underutilized messages"),
		// 									RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTAgentSendsUnutilizedMessages),
		// 									Status: to.Ptr(armsecurity.RecommendationConfigStatus("TurnedOn")),
		// 								},
		// 								{
		// 									Name: to.Ptr("Operating system (OS) baseline validation failure"),
		// 									RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTBaseline),
		// 									Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 								},
		// 								{
		// 									Name: to.Ptr("Edge Hub memory can be optimized"),
		// 									RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTEdgeHubMemOptimize),
		// 									Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 								},
		// 								{
		// 									Name: to.Ptr("No Logging Configured for Edge Module"),
		// 									RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTEdgeLoggingOptions),
		// 									Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 								},
		// 								{
		// 									Name: to.Ptr("Module Settings Inconsistent in SecurityGroup"),
		// 									RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTInconsistentModuleSettings),
		// 									Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 								},
		// 								{
		// 									Name: to.Ptr("Install the Azure Security of Things Agent"),
		// 									RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTInstallAgent),
		// 									Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 								},
		// 								{
		// 									Name: to.Ptr("Default IP Filter Policy should be Deny"),
		// 									RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTIpfilterDenyAll),
		// 									Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 								},
		// 								{
		// 									Name: to.Ptr("IP Filter rule includes large IP range"),
		// 									RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTIpfilterPermissiveRule),
		// 									Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 								},
		// 								{
		// 									Name: to.Ptr("Open Ports On Device"),
		// 									RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTOpenPorts),
		// 									Status: to.Ptr(armsecurity.RecommendationConfigStatusDisabled),
		// 								},
		// 								{
		// 									Name: to.Ptr("Permissive firewall policy in one of the chains was found"),
		// 									RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTPermissiveFirewallPolicy),
		// 									Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 								},
		// 								{
		// 									Name: to.Ptr("Permissive firewall rule in the input chain was found"),
		// 									RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTPermissiveInputFirewallRules),
		// 									Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 								},
		// 								{
		// 									Name: to.Ptr("Permissive firewall rule in the output chain was found"),
		// 									RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTPermissiveOutputFirewallRules),
		// 									Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 								},
		// 								{
		// 									Name: to.Ptr("High level permissions configured in Edge model twin for Edge module"),
		// 									RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTPrivilegedDockerOptions),
		// 									Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 								},
		// 								{
		// 									Name: to.Ptr("Same Authentication Credentials used by multiple devices"),
		// 									RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTSharedCredentials),
		// 									Status: to.Ptr(armsecurity.RecommendationConfigStatusDisabled),
		// 								},
		// 								{
		// 									Name: to.Ptr("TLS cipher suite upgrade"),
		// 									RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTVulnerableTLSCipherSuite),
		// 									Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 							}},
		// 							Status: to.Ptr(armsecurity.SecuritySolutionStatusEnabled),
		// 							UnmaskedIPLoggingStatus: to.Ptr(armsecurity.UnmaskedIPLoggingStatusEnabled),
		// 							UserDefinedResources: &armsecurity.UserDefinedResourcesProperties{
		// 								Query: to.Ptr("where type != \"microsoft.devices/iothubs\" | where name contains \"iot\""),
		// 								QuerySubscriptions: []*string{
		// 									to.Ptr("075423e9-7d33-4166-8bdf-3920b04e3735")},
		// 								},
		// 								Workspace: to.Ptr("/subscriptions/c4930e90-cd72-4aa5-93e9-2d081d129569/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace1"),
		// 							},
		// 							SystemData: &armsecurity.SystemData{
		// 								CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-04-27T21:53:29.092Z"); return t}()),
		// 								CreatedBy: to.Ptr("string"),
		// 								CreatedByType: to.Ptr(armsecurity.CreatedByTypeUser),
		// 								LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-04-27T21:53:29.092Z"); return t}()),
		// 								LastModifiedBy: to.Ptr("string"),
		// 								LastModifiedByType: to.Ptr(armsecurity.CreatedByTypeUser),
		// 							},
		// 					}},
		// 				}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e716082ac474f182e2220e4f38f1d6191e7636cf/specification/security/resource-manager/Microsoft.Security/stable/2019-08-01/examples/IoTSecuritySolutions/GetIoTSecuritySolutionsList.json
func ExampleIotSecuritySolutionClient_NewListBySubscriptionPager_listIoTSecuritySolutionsBySubscription() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewIotSecuritySolutionClient().NewListBySubscriptionPager(&armsecurity.IotSecuritySolutionClientListBySubscriptionOptions{Filter: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.IoTSecuritySolutionsList = armsecurity.IoTSecuritySolutionsList{
		// 	Value: []*armsecurity.IoTSecuritySolutionModel{
		// 		{
		// 			Name: to.Ptr("default"),
		// 			Type: to.Ptr("Microsoft.Security/IoTSecuritySolutions"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/MyGroup/providers/Microsoft.Security/IoTSecuritySolutions/Locations/eastus/default"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Location: to.Ptr("East Us"),
		// 			Properties: &armsecurity.IoTSecuritySolutionProperties{
		// 				AutoDiscoveredResources: []*string{
		// 					to.Ptr("/subscriptions/075423e9-7d33-4166-8bdf-3920b04e3735"),
		// 					to.Ptr("/subscriptions/075423e9-7d33-4166-8bdf-3920b04e3735/resourceGroups/myRg/providers/Microsoft.Devices/IotHubs/FirstIotHub")},
		// 					DisabledDataSources: []*armsecurity.DataSource{
		// 					},
		// 					DisplayName: to.Ptr("Solution Default"),
		// 					Export: []*armsecurity.ExportData{
		// 					},
		// 					IotHubs: []*string{
		// 						to.Ptr("/subscriptions/075423e9-7d33-4166-8bdf-3920b04e3735/resourceGroups/myRg/providers/Microsoft.Devices/IotHubs/FirstIotHub")},
		// 						RecommendationsConfiguration: []*armsecurity.RecommendationConfigurationProperties{
		// 							{
		// 								Name: to.Ptr("Service Principal Not Used with ACR"),
		// 								RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTAcrauthentication),
		// 								Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 							},
		// 							{
		// 								Name: to.Ptr("Agent sending underutilized messages"),
		// 								RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTAgentSendsUnutilizedMessages),
		// 								Status: to.Ptr(armsecurity.RecommendationConfigStatus("TurnedOn")),
		// 							},
		// 							{
		// 								Name: to.Ptr("Operating system (OS) baseline validation failure"),
		// 								RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTBaseline),
		// 								Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 							},
		// 							{
		// 								Name: to.Ptr("Edge Hub memory can be optimized"),
		// 								RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTEdgeHubMemOptimize),
		// 								Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 							},
		// 							{
		// 								Name: to.Ptr("No Logging Configured for Edge Module"),
		// 								RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTEdgeLoggingOptions),
		// 								Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 							},
		// 							{
		// 								Name: to.Ptr("Module Settings Inconsistent in SecurityGroup"),
		// 								RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTInconsistentModuleSettings),
		// 								Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 							},
		// 							{
		// 								Name: to.Ptr("Install the Azure Security of Things Agent"),
		// 								RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTInstallAgent),
		// 								Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 							},
		// 							{
		// 								Name: to.Ptr("Default IP Filter Policy should be Deny"),
		// 								RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTIpfilterDenyAll),
		// 								Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 							},
		// 							{
		// 								Name: to.Ptr("IP Filter rule includes large IP range"),
		// 								RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTIpfilterPermissiveRule),
		// 								Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 							},
		// 							{
		// 								Name: to.Ptr("Open Ports On Device"),
		// 								RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTOpenPorts),
		// 								Status: to.Ptr(armsecurity.RecommendationConfigStatusDisabled),
		// 							},
		// 							{
		// 								Name: to.Ptr("Permissive firewall policy in one of the chains was found"),
		// 								RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTPermissiveFirewallPolicy),
		// 								Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 							},
		// 							{
		// 								Name: to.Ptr("Permissive firewall rule in the input chain was found"),
		// 								RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTPermissiveInputFirewallRules),
		// 								Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 							},
		// 							{
		// 								Name: to.Ptr("Permissive firewall rule in the output chain was found"),
		// 								RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTPermissiveOutputFirewallRules),
		// 								Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 							},
		// 							{
		// 								Name: to.Ptr("High level permissions configured in Edge model twin for Edge module"),
		// 								RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTPrivilegedDockerOptions),
		// 								Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 							},
		// 							{
		// 								Name: to.Ptr("Same Authentication Credentials used by multiple devices"),
		// 								RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTSharedCredentials),
		// 								Status: to.Ptr(armsecurity.RecommendationConfigStatusDisabled),
		// 							},
		// 							{
		// 								Name: to.Ptr("TLS cipher suite upgrade"),
		// 								RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTVulnerableTLSCipherSuite),
		// 								Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 						}},
		// 						Status: to.Ptr(armsecurity.SecuritySolutionStatusEnabled),
		// 						UnmaskedIPLoggingStatus: to.Ptr(armsecurity.UnmaskedIPLoggingStatusEnabled),
		// 						UserDefinedResources: &armsecurity.UserDefinedResourcesProperties{
		// 							Query: to.Ptr("where type != \"microsoft.devices/iothubs\" | where name contains \"iot\""),
		// 							QuerySubscriptions: []*string{
		// 								to.Ptr("075423e9-7d33-4166-8bdf-3920b04e3735")},
		// 							},
		// 							Workspace: to.Ptr("/subscriptions/c4930e90-cd72-4aa5-93e9-2d081d129569/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace1"),
		// 						},
		// 						SystemData: &armsecurity.SystemData{
		// 							CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-04-27T21:53:29.092Z"); return t}()),
		// 							CreatedBy: to.Ptr("string"),
		// 							CreatedByType: to.Ptr(armsecurity.CreatedByTypeUser),
		// 							LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-04-27T21:53:29.092Z"); return t}()),
		// 							LastModifiedBy: to.Ptr("string"),
		// 							LastModifiedByType: to.Ptr(armsecurity.CreatedByTypeUser),
		// 						},
		// 					},
		// 					{
		// 						Name: to.Ptr("sec-solution"),
		// 						Type: to.Ptr("Microsoft.Security/IoTSecuritySolutions"),
		// 						ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/SecondGroup/providers/Microsoft.Security/IoTSecuritySolutions/Locations/eastus/sec-solution"),
		// 						Tags: map[string]*string{
		// 						},
		// 						Location: to.Ptr("East Us"),
		// 						Properties: &armsecurity.IoTSecuritySolutionProperties{
		// 							AutoDiscoveredResources: []*string{
		// 								to.Ptr("/subscriptions/075423e9-7d33-4166-8bdf-3920b04e3735"),
		// 								to.Ptr("/subscriptions/075423e9-7d33-4166-8bdf-3920b04e3735/resourceGroups/myRg/providers/Microsoft.Devices/IotHubs/IotHubSecond")},
		// 								DisabledDataSources: []*armsecurity.DataSource{
		// 								},
		// 								DisplayName: to.Ptr("Second Solution"),
		// 								Export: []*armsecurity.ExportData{
		// 									to.Ptr(armsecurity.ExportDataRawEvents)},
		// 									IotHubs: []*string{
		// 										to.Ptr("/subscriptions/075423e9-7d33-4166-8bdf-3920b04e3735/resourceGroups/myRg/providers/Microsoft.Devices/IotHubs/IotHubSecond")},
		// 										RecommendationsConfiguration: []*armsecurity.RecommendationConfigurationProperties{
		// 											{
		// 												Name: to.Ptr("Service Principal Not Used with ACR"),
		// 												RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTAcrauthentication),
		// 												Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 											},
		// 											{
		// 												Name: to.Ptr("Agent sending underutilized messages"),
		// 												RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTAgentSendsUnutilizedMessages),
		// 												Status: to.Ptr(armsecurity.RecommendationConfigStatus("TurnedOn")),
		// 											},
		// 											{
		// 												Name: to.Ptr("Operating system (OS) baseline validation failure"),
		// 												RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTBaseline),
		// 												Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 											},
		// 											{
		// 												Name: to.Ptr("Edge Hub memory can be optimized"),
		// 												RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTEdgeHubMemOptimize),
		// 												Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 											},
		// 											{
		// 												Name: to.Ptr("No Logging Configured for Edge Module"),
		// 												RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTEdgeLoggingOptions),
		// 												Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 											},
		// 											{
		// 												Name: to.Ptr("Module Settings Inconsistent in SecurityGroup"),
		// 												RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTInconsistentModuleSettings),
		// 												Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 											},
		// 											{
		// 												Name: to.Ptr("Install the Azure Security of Things Agent"),
		// 												RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTInstallAgent),
		// 												Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 											},
		// 											{
		// 												Name: to.Ptr("Default IP Filter Policy should be Deny"),
		// 												RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTIpfilterDenyAll),
		// 												Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 											},
		// 											{
		// 												Name: to.Ptr("IP Filter rule includes large IP range"),
		// 												RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTIpfilterPermissiveRule),
		// 												Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 											},
		// 											{
		// 												Name: to.Ptr("Open Ports On Device"),
		// 												RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTOpenPorts),
		// 												Status: to.Ptr(armsecurity.RecommendationConfigStatusDisabled),
		// 											},
		// 											{
		// 												Name: to.Ptr("Permissive firewall policy in one of the chains was found"),
		// 												RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTPermissiveFirewallPolicy),
		// 												Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 											},
		// 											{
		// 												Name: to.Ptr("Permissive firewall rule in the input chain was found"),
		// 												RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTPermissiveInputFirewallRules),
		// 												Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 											},
		// 											{
		// 												Name: to.Ptr("Permissive firewall rule in the output chain was found"),
		// 												RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTPermissiveOutputFirewallRules),
		// 												Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 											},
		// 											{
		// 												Name: to.Ptr("High level permissions configured in Edge model twin for Edge module"),
		// 												RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTPrivilegedDockerOptions),
		// 												Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 											},
		// 											{
		// 												Name: to.Ptr("Same Authentication Credentials used by multiple devices"),
		// 												RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTSharedCredentials),
		// 												Status: to.Ptr(armsecurity.RecommendationConfigStatusDisabled),
		// 											},
		// 											{
		// 												Name: to.Ptr("TLS cipher suite upgrade"),
		// 												RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTVulnerableTLSCipherSuite),
		// 												Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 										}},
		// 										Status: to.Ptr(armsecurity.SecuritySolutionStatusEnabled),
		// 										UnmaskedIPLoggingStatus: to.Ptr(armsecurity.UnmaskedIPLoggingStatusEnabled),
		// 										UserDefinedResources: &armsecurity.UserDefinedResourcesProperties{
		// 											Query: to.Ptr("where type != \"microsoft.devices/iothubs\" | where name contains \"iot\""),
		// 											QuerySubscriptions: []*string{
		// 												to.Ptr("075423e9-7d33-4166-8bdf-3920b04e3735")},
		// 											},
		// 											Workspace: to.Ptr("/subscriptions/c4930e90-cd72-4aa5-93e9-2d081d129569/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace1"),
		// 										},
		// 										SystemData: &armsecurity.SystemData{
		// 											CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-04-27T21:53:29.092Z"); return t}()),
		// 											CreatedBy: to.Ptr("string"),
		// 											CreatedByType: to.Ptr(armsecurity.CreatedByTypeUser),
		// 											LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-04-27T21:53:29.092Z"); return t}()),
		// 											LastModifiedBy: to.Ptr("string"),
		// 											LastModifiedByType: to.Ptr(armsecurity.CreatedByTypeUser),
		// 										},
		// 								}},
		// 							}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e716082ac474f182e2220e4f38f1d6191e7636cf/specification/security/resource-manager/Microsoft.Security/stable/2019-08-01/examples/IoTSecuritySolutions/GetIoTSecuritySolutionsListByRg.json
func ExampleIotSecuritySolutionClient_NewListByResourceGroupPager_listIoTSecuritySolutionsByResourceGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewIotSecuritySolutionClient().NewListByResourceGroupPager("MyGroup", &armsecurity.IotSecuritySolutionClientListByResourceGroupOptions{Filter: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.IoTSecuritySolutionsList = armsecurity.IoTSecuritySolutionsList{
		// 	Value: []*armsecurity.IoTSecuritySolutionModel{
		// 		{
		// 			Name: to.Ptr("default"),
		// 			Type: to.Ptr("Microsoft.Security/IoTSecuritySolutions"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/MyGroup/providers/Microsoft.Security/IoTSecuritySolutions/Locations/eastus/default"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Location: to.Ptr("East Us"),
		// 			Properties: &armsecurity.IoTSecuritySolutionProperties{
		// 				AutoDiscoveredResources: []*string{
		// 					to.Ptr("/subscriptions/075423e9-7d33-4166-8bdf-3920b04e3735"),
		// 					to.Ptr("/subscriptions/075423e9-7d33-4166-8bdf-3920b04e3735/resourceGroups/myRg/providers/Microsoft.Devices/IotHubs/FirstIotHub")},
		// 					DisabledDataSources: []*armsecurity.DataSource{
		// 					},
		// 					DisplayName: to.Ptr("Solution Default"),
		// 					Export: []*armsecurity.ExportData{
		// 					},
		// 					IotHubs: []*string{
		// 						to.Ptr("/subscriptions/075423e9-7d33-4166-8bdf-3920b04e3735/resourceGroups/myRg/providers/Microsoft.Devices/IotHubs/FirstIotHub")},
		// 						RecommendationsConfiguration: []*armsecurity.RecommendationConfigurationProperties{
		// 							{
		// 								Name: to.Ptr("Service Principal Not Used with ACR"),
		// 								RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTAcrauthentication),
		// 								Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 							},
		// 							{
		// 								Name: to.Ptr("Agent sending underutilized messages"),
		// 								RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTAgentSendsUnutilizedMessages),
		// 								Status: to.Ptr(armsecurity.RecommendationConfigStatus("TurnedOn")),
		// 							},
		// 							{
		// 								Name: to.Ptr("Operating system (OS) baseline validation failure"),
		// 								RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTBaseline),
		// 								Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 							},
		// 							{
		// 								Name: to.Ptr("Edge Hub memory can be optimized"),
		// 								RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTEdgeHubMemOptimize),
		// 								Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 							},
		// 							{
		// 								Name: to.Ptr("No Logging Configured for Edge Module"),
		// 								RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTEdgeLoggingOptions),
		// 								Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 							},
		// 							{
		// 								Name: to.Ptr("Module Settings Inconsistent in SecurityGroup"),
		// 								RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTInconsistentModuleSettings),
		// 								Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 							},
		// 							{
		// 								Name: to.Ptr("Install the Azure Security of Things Agent"),
		// 								RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTInstallAgent),
		// 								Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 							},
		// 							{
		// 								Name: to.Ptr("Default IP Filter Policy should be Deny"),
		// 								RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTIpfilterDenyAll),
		// 								Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 							},
		// 							{
		// 								Name: to.Ptr("IP Filter rule includes large IP range"),
		// 								RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTIpfilterPermissiveRule),
		// 								Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 							},
		// 							{
		// 								Name: to.Ptr("Open Ports On Device"),
		// 								RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTOpenPorts),
		// 								Status: to.Ptr(armsecurity.RecommendationConfigStatusDisabled),
		// 							},
		// 							{
		// 								Name: to.Ptr("Permissive firewall policy in one of the chains was found"),
		// 								RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTPermissiveFirewallPolicy),
		// 								Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 							},
		// 							{
		// 								Name: to.Ptr("Permissive firewall rule in the input chain was found"),
		// 								RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTPermissiveInputFirewallRules),
		// 								Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 							},
		// 							{
		// 								Name: to.Ptr("Permissive firewall rule in the output chain was found"),
		// 								RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTPermissiveOutputFirewallRules),
		// 								Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 							},
		// 							{
		// 								Name: to.Ptr("High level permissions configured in Edge model twin for Edge module"),
		// 								RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTPrivilegedDockerOptions),
		// 								Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 							},
		// 							{
		// 								Name: to.Ptr("Same Authentication Credentials used by multiple devices"),
		// 								RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTSharedCredentials),
		// 								Status: to.Ptr(armsecurity.RecommendationConfigStatusDisabled),
		// 							},
		// 							{
		// 								Name: to.Ptr("TLS cipher suite upgrade"),
		// 								RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTVulnerableTLSCipherSuite),
		// 								Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 						}},
		// 						Status: to.Ptr(armsecurity.SecuritySolutionStatusEnabled),
		// 						UnmaskedIPLoggingStatus: to.Ptr(armsecurity.UnmaskedIPLoggingStatusEnabled),
		// 						UserDefinedResources: &armsecurity.UserDefinedResourcesProperties{
		// 							Query: to.Ptr("where type != \"microsoft.devices/iothubs\" | where name contains \"iot\""),
		// 							QuerySubscriptions: []*string{
		// 								to.Ptr("075423e9-7d33-4166-8bdf-3920b04e3735")},
		// 							},
		// 							Workspace: to.Ptr("/subscriptions/c4930e90-cd72-4aa5-93e9-2d081d129569/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace1"),
		// 						},
		// 						SystemData: &armsecurity.SystemData{
		// 							CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-04-27T21:53:29.092Z"); return t}()),
		// 							CreatedBy: to.Ptr("string"),
		// 							CreatedByType: to.Ptr(armsecurity.CreatedByTypeUser),
		// 							LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-04-27T21:53:29.092Z"); return t}()),
		// 							LastModifiedBy: to.Ptr("string"),
		// 							LastModifiedByType: to.Ptr(armsecurity.CreatedByTypeUser),
		// 						},
		// 				}},
		// 			}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e716082ac474f182e2220e4f38f1d6191e7636cf/specification/security/resource-manager/Microsoft.Security/stable/2019-08-01/examples/IoTSecuritySolutions/GetIoTSecuritySolutionsListByIotHubAndRg.json
func ExampleIotSecuritySolutionClient_NewListByResourceGroupPager_listIoTSecuritySolutionsByResourceGroupAndIoTHub() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewIotSecuritySolutionClient().NewListByResourceGroupPager("MyRg", &armsecurity.IotSecuritySolutionClientListByResourceGroupOptions{Filter: to.Ptr("properties.iotHubs/any(i eq \"/subscriptions/075423e9-7d33-4166-8bdf-3920b04e3735/resourceGroups/myRg/providers/Microsoft.Devices/IotHubs/FirstIotHub\")")})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.IoTSecuritySolutionsList = armsecurity.IoTSecuritySolutionsList{
		// 	Value: []*armsecurity.IoTSecuritySolutionModel{
		// 		{
		// 			Name: to.Ptr("default"),
		// 			Type: to.Ptr("Microsoft.Security/IoTSecuritySolutions"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/MyRg/providers/Microsoft.Security/IoTSecuritySolutions/Locations/eastus/default"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Location: to.Ptr("East Us"),
		// 			Properties: &armsecurity.IoTSecuritySolutionProperties{
		// 				AutoDiscoveredResources: []*string{
		// 					to.Ptr("/subscriptions/075423e9-7d33-4166-8bdf-3920b04e3735"),
		// 					to.Ptr("/subscriptions/075423e9-7d33-4166-8bdf-3920b04e3735/resourceGroups/myRg/providers/Microsoft.Devices/IotHubs/FirstIotHub")},
		// 					DisabledDataSources: []*armsecurity.DataSource{
		// 					},
		// 					DisplayName: to.Ptr("Solution Default"),
		// 					Export: []*armsecurity.ExportData{
		// 						to.Ptr(armsecurity.ExportDataRawEvents)},
		// 						IotHubs: []*string{
		// 							to.Ptr("/subscriptions/075423e9-7d33-4166-8bdf-3920b04e3735/resourceGroups/myRg/providers/Microsoft.Devices/IotHubs/FirstIotHub")},
		// 							RecommendationsConfiguration: []*armsecurity.RecommendationConfigurationProperties{
		// 								{
		// 									Name: to.Ptr("Service Principal Not Used with ACR"),
		// 									RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTAcrauthentication),
		// 									Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 								},
		// 								{
		// 									Name: to.Ptr("Agent sending underutilized messages"),
		// 									RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTAgentSendsUnutilizedMessages),
		// 									Status: to.Ptr(armsecurity.RecommendationConfigStatus("TurnedOn")),
		// 								},
		// 								{
		// 									Name: to.Ptr("Operating system (OS) baseline validation failure"),
		// 									RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTBaseline),
		// 									Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 								},
		// 								{
		// 									Name: to.Ptr("Edge Hub memory can be optimized"),
		// 									RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTEdgeHubMemOptimize),
		// 									Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 								},
		// 								{
		// 									Name: to.Ptr("No Logging Configured for Edge Module"),
		// 									RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTEdgeLoggingOptions),
		// 									Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 								},
		// 								{
		// 									Name: to.Ptr("Module Settings Inconsistent in SecurityGroup"),
		// 									RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTInconsistentModuleSettings),
		// 									Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 								},
		// 								{
		// 									Name: to.Ptr("Install the Azure Security of Things Agent"),
		// 									RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTInstallAgent),
		// 									Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 								},
		// 								{
		// 									Name: to.Ptr("Default IP Filter Policy should be Deny"),
		// 									RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTIpfilterDenyAll),
		// 									Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 								},
		// 								{
		// 									Name: to.Ptr("IP Filter rule includes large IP range"),
		// 									RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTIpfilterPermissiveRule),
		// 									Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 								},
		// 								{
		// 									Name: to.Ptr("Open Ports On Device"),
		// 									RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTOpenPorts),
		// 									Status: to.Ptr(armsecurity.RecommendationConfigStatusDisabled),
		// 								},
		// 								{
		// 									Name: to.Ptr("Permissive firewall policy in one of the chains was found"),
		// 									RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTPermissiveFirewallPolicy),
		// 									Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 								},
		// 								{
		// 									Name: to.Ptr("Permissive firewall rule in the input chain was found"),
		// 									RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTPermissiveInputFirewallRules),
		// 									Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 								},
		// 								{
		// 									Name: to.Ptr("Permissive firewall rule in the output chain was found"),
		// 									RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTPermissiveOutputFirewallRules),
		// 									Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 								},
		// 								{
		// 									Name: to.Ptr("High level permissions configured in Edge model twin for Edge module"),
		// 									RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTPrivilegedDockerOptions),
		// 									Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 								},
		// 								{
		// 									Name: to.Ptr("Same Authentication Credentials used by multiple devices"),
		// 									RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTSharedCredentials),
		// 									Status: to.Ptr(armsecurity.RecommendationConfigStatusDisabled),
		// 								},
		// 								{
		// 									Name: to.Ptr("TLS cipher suite upgrade"),
		// 									RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTVulnerableTLSCipherSuite),
		// 									Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
		// 							}},
		// 							Status: to.Ptr(armsecurity.SecuritySolutionStatusEnabled),
		// 							UnmaskedIPLoggingStatus: to.Ptr(armsecurity.UnmaskedIPLoggingStatusEnabled),
		// 							UserDefinedResources: &armsecurity.UserDefinedResourcesProperties{
		// 								Query: to.Ptr("where type != \"microsoft.devices/iothubs\" | where name contains \"iot\""),
		// 								QuerySubscriptions: []*string{
		// 									to.Ptr("075423e9-7d33-4166-8bdf-3920b04e3735")},
		// 								},
		// 								Workspace: to.Ptr("/subscriptions/c4930e90-cd72-4aa5-93e9-2d081d129569/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace1"),
		// 							},
		// 							SystemData: &armsecurity.SystemData{
		// 								CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-04-27T21:53:29.092Z"); return t}()),
		// 								CreatedBy: to.Ptr("string"),
		// 								CreatedByType: to.Ptr(armsecurity.CreatedByTypeUser),
		// 								LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-04-27T21:53:29.092Z"); return t}()),
		// 								LastModifiedBy: to.Ptr("string"),
		// 								LastModifiedByType: to.Ptr(armsecurity.CreatedByTypeUser),
		// 							},
		// 					}},
		// 				}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e716082ac474f182e2220e4f38f1d6191e7636cf/specification/security/resource-manager/Microsoft.Security/stable/2019-08-01/examples/IoTSecuritySolutions/GetIoTSecuritySolution.json
func ExampleIotSecuritySolutionClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewIotSecuritySolutionClient().Get(ctx, "MyGroup", "default", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.IoTSecuritySolutionModel = armsecurity.IoTSecuritySolutionModel{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.Security/IoTSecuritySolutions"),
	// 	ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/MyGroup/providers/Microsoft.Security/IoTSecuritySolutions/Locations/eastus/default"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Location: to.Ptr("East Us"),
	// 	Properties: &armsecurity.IoTSecuritySolutionProperties{
	// 		AutoDiscoveredResources: []*string{
	// 			to.Ptr("/subscriptions/075423e9-7d33-4166-8bdf-3920b04e3735"),
	// 			to.Ptr("/subscriptions/075423e9-7d33-4166-8bdf-3920b04e3735/resourceGroups/myRg/providers/Microsoft.Devices/IotHubs/FirstIotHub")},
	// 			DisabledDataSources: []*armsecurity.DataSource{
	// 			},
	// 			DisplayName: to.Ptr("Solution Default"),
	// 			Export: []*armsecurity.ExportData{
	// 			},
	// 			IotHubs: []*string{
	// 				to.Ptr("/subscriptions/075423e9-7d33-4166-8bdf-3920b04e3735/resourceGroups/myRg/providers/Microsoft.Devices/IotHubs/FirstIotHub")},
	// 				RecommendationsConfiguration: []*armsecurity.RecommendationConfigurationProperties{
	// 					{
	// 						Name: to.Ptr("Service Principal Not Used with ACR"),
	// 						RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTAcrauthentication),
	// 						Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 					},
	// 					{
	// 						Name: to.Ptr("Agent sending underutilized messages"),
	// 						RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTAgentSendsUnutilizedMessages),
	// 						Status: to.Ptr(armsecurity.RecommendationConfigStatus("TurnedOn")),
	// 					},
	// 					{
	// 						Name: to.Ptr("Operating system (OS) baseline validation failure"),
	// 						RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTBaseline),
	// 						Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 					},
	// 					{
	// 						Name: to.Ptr("Edge Hub memory can be optimized"),
	// 						RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTEdgeHubMemOptimize),
	// 						Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 					},
	// 					{
	// 						Name: to.Ptr("No Logging Configured for Edge Module"),
	// 						RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTEdgeLoggingOptions),
	// 						Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 					},
	// 					{
	// 						Name: to.Ptr("Module Settings Inconsistent in SecurityGroup"),
	// 						RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTInconsistentModuleSettings),
	// 						Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 					},
	// 					{
	// 						Name: to.Ptr("Install the Azure Security of Things Agent"),
	// 						RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTInstallAgent),
	// 						Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 					},
	// 					{
	// 						Name: to.Ptr("Default IP Filter Policy should be Deny"),
	// 						RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTIpfilterDenyAll),
	// 						Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 					},
	// 					{
	// 						Name: to.Ptr("IP Filter rule includes large IP range"),
	// 						RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTIpfilterPermissiveRule),
	// 						Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 					},
	// 					{
	// 						Name: to.Ptr("Open Ports On Device"),
	// 						RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTOpenPorts),
	// 						Status: to.Ptr(armsecurity.RecommendationConfigStatusDisabled),
	// 					},
	// 					{
	// 						Name: to.Ptr("Permissive firewall policy in one of the chains was found"),
	// 						RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTPermissiveFirewallPolicy),
	// 						Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 					},
	// 					{
	// 						Name: to.Ptr("Permissive firewall rule in the input chain was found"),
	// 						RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTPermissiveInputFirewallRules),
	// 						Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 					},
	// 					{
	// 						Name: to.Ptr("Permissive firewall rule in the output chain was found"),
	// 						RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTPermissiveOutputFirewallRules),
	// 						Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 					},
	// 					{
	// 						Name: to.Ptr("High level permissions configured in Edge model twin for Edge module"),
	// 						RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTPrivilegedDockerOptions),
	// 						Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 					},
	// 					{
	// 						Name: to.Ptr("Same Authentication Credentials used by multiple devices"),
	// 						RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTSharedCredentials),
	// 						Status: to.Ptr(armsecurity.RecommendationConfigStatusDisabled),
	// 					},
	// 					{
	// 						Name: to.Ptr("TLS cipher suite upgrade"),
	// 						RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTVulnerableTLSCipherSuite),
	// 						Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 				}},
	// 				Status: to.Ptr(armsecurity.SecuritySolutionStatusEnabled),
	// 				UnmaskedIPLoggingStatus: to.Ptr(armsecurity.UnmaskedIPLoggingStatusEnabled),
	// 				UserDefinedResources: &armsecurity.UserDefinedResourcesProperties{
	// 					Query: to.Ptr("where type != \"microsoft.devices/iothubs\" | where name contains \"iot\""),
	// 					QuerySubscriptions: []*string{
	// 						to.Ptr("075423e9-7d33-4166-8bdf-3920b04e3735")},
	// 					},
	// 					Workspace: to.Ptr("/subscriptions/c4930e90-cd72-4aa5-93e9-2d081d129569/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace1"),
	// 				},
	// 				SystemData: &armsecurity.SystemData{
	// 					CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-04-27T21:53:29.092Z"); return t}()),
	// 					CreatedBy: to.Ptr("string"),
	// 					CreatedByType: to.Ptr(armsecurity.CreatedByTypeUser),
	// 					LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-04-27T21:53:29.092Z"); return t}()),
	// 					LastModifiedBy: to.Ptr("string"),
	// 					LastModifiedByType: to.Ptr(armsecurity.CreatedByTypeUser),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e716082ac474f182e2220e4f38f1d6191e7636cf/specification/security/resource-manager/Microsoft.Security/stable/2019-08-01/examples/IoTSecuritySolutions/CreateIoTSecuritySolution.json
func ExampleIotSecuritySolutionClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewIotSecuritySolutionClient().CreateOrUpdate(ctx, "MyGroup", "default", armsecurity.IoTSecuritySolutionModel{
		Tags:     map[string]*string{},
		Location: to.Ptr("East Us"),
		Properties: &armsecurity.IoTSecuritySolutionProperties{
			DisabledDataSources: []*armsecurity.DataSource{},
			DisplayName:         to.Ptr("Solution Default"),
			Export:              []*armsecurity.ExportData{},
			IotHubs: []*string{
				to.Ptr("/subscriptions/075423e9-7d33-4166-8bdf-3920b04e3735/resourceGroups/myRg/providers/Microsoft.Devices/IotHubs/FirstIotHub")},
			RecommendationsConfiguration: []*armsecurity.RecommendationConfigurationProperties{
				{
					RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTOpenPorts),
					Status:             to.Ptr(armsecurity.RecommendationConfigStatusDisabled),
				},
				{
					RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTSharedCredentials),
					Status:             to.Ptr(armsecurity.RecommendationConfigStatusDisabled),
				}},
			Status:                  to.Ptr(armsecurity.SecuritySolutionStatusEnabled),
			UnmaskedIPLoggingStatus: to.Ptr(armsecurity.UnmaskedIPLoggingStatusEnabled),
			UserDefinedResources: &armsecurity.UserDefinedResourcesProperties{
				Query: to.Ptr("where type != \"microsoft.devices/iothubs\" | where name contains \"iot\""),
				QuerySubscriptions: []*string{
					to.Ptr("075423e9-7d33-4166-8bdf-3920b04e3735")},
			},
			Workspace: to.Ptr("/subscriptions/c4930e90-cd72-4aa5-93e9-2d081d129569/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace1"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.IoTSecuritySolutionModel = armsecurity.IoTSecuritySolutionModel{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.Security/IoTSecuritySolutions"),
	// 	ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/MyGroup/providers/Microsoft.Security/Locations/eastus/IoTSecuritySolutions/default"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Location: to.Ptr("East Us"),
	// 	Properties: &armsecurity.IoTSecuritySolutionProperties{
	// 		AutoDiscoveredResources: []*string{
	// 			to.Ptr("/subscriptions/075423e9-7d33-4166-8bdf-3920b04e3735"),
	// 			to.Ptr("/subscriptions/075423e9-7d33-4166-8bdf-3920b04e3735/resourceGroups/myRg/providers/Microsoft.Devices/IotHubs/FirstIotHub")},
	// 			DisabledDataSources: []*armsecurity.DataSource{
	// 			},
	// 			DisplayName: to.Ptr("Solution Default"),
	// 			Export: []*armsecurity.ExportData{
	// 			},
	// 			IotHubs: []*string{
	// 				to.Ptr("/subscriptions/075423e9-7d33-4166-8bdf-3920b04e3735/resourceGroups/myRg/providers/Microsoft.Devices/IotHubs/FirstIotHub")},
	// 				RecommendationsConfiguration: []*armsecurity.RecommendationConfigurationProperties{
	// 					{
	// 						Name: to.Ptr("Service Principal Not Used with ACR"),
	// 						RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTAcrauthentication),
	// 						Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 					},
	// 					{
	// 						Name: to.Ptr("Agent sending underutilized messages"),
	// 						RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTAgentSendsUnutilizedMessages),
	// 						Status: to.Ptr(armsecurity.RecommendationConfigStatus("TurnedOn")),
	// 					},
	// 					{
	// 						Name: to.Ptr("Operating system (OS) baseline validation failure"),
	// 						RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTBaseline),
	// 						Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 					},
	// 					{
	// 						Name: to.Ptr("Edge Hub memory can be optimized"),
	// 						RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTEdgeHubMemOptimize),
	// 						Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 					},
	// 					{
	// 						Name: to.Ptr("No Logging Configured for Edge Module"),
	// 						RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTEdgeLoggingOptions),
	// 						Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 					},
	// 					{
	// 						Name: to.Ptr("Module Settings Inconsistent in SecurityGroup"),
	// 						RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTInconsistentModuleSettings),
	// 						Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 					},
	// 					{
	// 						Name: to.Ptr("Install the Azure Security of Things Agent"),
	// 						RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTInstallAgent),
	// 						Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 					},
	// 					{
	// 						Name: to.Ptr("Default IP Filter Policy should be Deny"),
	// 						RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTIpfilterDenyAll),
	// 						Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 					},
	// 					{
	// 						Name: to.Ptr("IP Filter rule includes large IP range"),
	// 						RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTIpfilterPermissiveRule),
	// 						Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 					},
	// 					{
	// 						Name: to.Ptr("Open Ports On Device"),
	// 						RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTOpenPorts),
	// 						Status: to.Ptr(armsecurity.RecommendationConfigStatusDisabled),
	// 					},
	// 					{
	// 						Name: to.Ptr("Permissive firewall policy in one of the chains was found"),
	// 						RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTPermissiveFirewallPolicy),
	// 						Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 					},
	// 					{
	// 						Name: to.Ptr("Permissive firewall rule in the input chain was found"),
	// 						RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTPermissiveInputFirewallRules),
	// 						Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 					},
	// 					{
	// 						Name: to.Ptr("Permissive firewall rule in the output chain was found"),
	// 						RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTPermissiveOutputFirewallRules),
	// 						Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 					},
	// 					{
	// 						Name: to.Ptr("High level permissions configured in Edge model twin for Edge module"),
	// 						RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTPrivilegedDockerOptions),
	// 						Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 					},
	// 					{
	// 						Name: to.Ptr("Same Authentication Credentials used by multiple devices"),
	// 						RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTSharedCredentials),
	// 						Status: to.Ptr(armsecurity.RecommendationConfigStatusDisabled),
	// 					},
	// 					{
	// 						Name: to.Ptr("TLS cipher suite upgrade"),
	// 						RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTVulnerableTLSCipherSuite),
	// 						Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 				}},
	// 				Status: to.Ptr(armsecurity.SecuritySolutionStatusEnabled),
	// 				UnmaskedIPLoggingStatus: to.Ptr(armsecurity.UnmaskedIPLoggingStatusEnabled),
	// 				UserDefinedResources: &armsecurity.UserDefinedResourcesProperties{
	// 					Query: to.Ptr("where type != \"microsoft.devices/iothubs\" | where name contains \"iot\""),
	// 					QuerySubscriptions: []*string{
	// 						to.Ptr("075423e9-7d33-4166-8bdf-3920b04e3735")},
	// 					},
	// 					Workspace: to.Ptr("/subscriptions/c4930e90-cd72-4aa5-93e9-2d081d129569/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace1"),
	// 				},
	// 				SystemData: &armsecurity.SystemData{
	// 					CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-04-27T21:53:29.092Z"); return t}()),
	// 					CreatedBy: to.Ptr("string"),
	// 					CreatedByType: to.Ptr(armsecurity.CreatedByTypeUser),
	// 					LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-04-27T21:53:29.092Z"); return t}()),
	// 					LastModifiedBy: to.Ptr("string"),
	// 					LastModifiedByType: to.Ptr(armsecurity.CreatedByTypeUser),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e716082ac474f182e2220e4f38f1d6191e7636cf/specification/security/resource-manager/Microsoft.Security/stable/2019-08-01/examples/IoTSecuritySolutions/UpdateIoTSecuritySolution.json
func ExampleIotSecuritySolutionClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewIotSecuritySolutionClient().Update(ctx, "myRg", "default", armsecurity.UpdateIotSecuritySolutionData{
		Tags: map[string]*string{
			"foo": to.Ptr("bar"),
		},
		Properties: &armsecurity.UpdateIoTSecuritySolutionProperties{
			RecommendationsConfiguration: []*armsecurity.RecommendationConfigurationProperties{
				{
					RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTOpenPorts),
					Status:             to.Ptr(armsecurity.RecommendationConfigStatusDisabled),
				},
				{
					RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTSharedCredentials),
					Status:             to.Ptr(armsecurity.RecommendationConfigStatusDisabled),
				}},
			UserDefinedResources: &armsecurity.UserDefinedResourcesProperties{
				Query: to.Ptr("where type != \"microsoft.devices/iothubs\" | where name contains \"v2\""),
				QuerySubscriptions: []*string{
					to.Ptr("075423e9-7d33-4166-8bdf-3920b04e3735")},
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.IoTSecuritySolutionModel = armsecurity.IoTSecuritySolutionModel{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.Security/IoTSecuritySolutions"),
	// 	ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/MyGroup/providers/Microsoft.Security/Locations/eastus/IoTSecuritySolutions/default"),
	// 	Tags: map[string]*string{
	// 		"foo": to.Ptr("bar"),
	// 	},
	// 	Location: to.Ptr("East Us"),
	// 	Properties: &armsecurity.IoTSecuritySolutionProperties{
	// 		AutoDiscoveredResources: []*string{
	// 			to.Ptr("/subscriptions/075423e9-7d33-4166-8bdf-3920b04e3735"),
	// 			to.Ptr("/subscriptions/075423e9-7d33-4166-8bdf-3920b04e3735/resourceGroups/myRg/providers/Microsoft.Devices/IotHubs/FirstIotHub")},
	// 			DisabledDataSources: []*armsecurity.DataSource{
	// 			},
	// 			DisplayName: to.Ptr("Solution Default"),
	// 			Export: []*armsecurity.ExportData{
	// 				to.Ptr(armsecurity.ExportDataRawEvents)},
	// 				IotHubs: []*string{
	// 					to.Ptr("/subscriptions/075423e9-7d33-4166-8bdf-3920b04e3735/resourceGroups/myRg/providers/Microsoft.Devices/IotHubs/FirstIotHub")},
	// 					RecommendationsConfiguration: []*armsecurity.RecommendationConfigurationProperties{
	// 						{
	// 							Name: to.Ptr("Service Principal Not Used with ACR"),
	// 							RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTAcrauthentication),
	// 							Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 						},
	// 						{
	// 							Name: to.Ptr("Agent sending underutilized messages"),
	// 							RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTAgentSendsUnutilizedMessages),
	// 							Status: to.Ptr(armsecurity.RecommendationConfigStatus("TurnedOn")),
	// 						},
	// 						{
	// 							Name: to.Ptr("Operating system (OS) baseline validation failure"),
	// 							RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTBaseline),
	// 							Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 						},
	// 						{
	// 							Name: to.Ptr("Edge Hub memory can be optimized"),
	// 							RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTEdgeHubMemOptimize),
	// 							Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 						},
	// 						{
	// 							Name: to.Ptr("No Logging Configured for Edge Module"),
	// 							RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTEdgeLoggingOptions),
	// 							Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 						},
	// 						{
	// 							Name: to.Ptr("Module Settings Inconsistent in SecurityGroup"),
	// 							RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTInconsistentModuleSettings),
	// 							Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 						},
	// 						{
	// 							Name: to.Ptr("Install the Azure Security of Things Agent"),
	// 							RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTInstallAgent),
	// 							Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 						},
	// 						{
	// 							Name: to.Ptr("Default IP Filter Policy should be Deny"),
	// 							RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTIpfilterDenyAll),
	// 							Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 						},
	// 						{
	// 							Name: to.Ptr("IP Filter rule includes large IP range"),
	// 							RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTIpfilterPermissiveRule),
	// 							Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 						},
	// 						{
	// 							Name: to.Ptr("Open Ports On Device"),
	// 							RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTOpenPorts),
	// 							Status: to.Ptr(armsecurity.RecommendationConfigStatusDisabled),
	// 						},
	// 						{
	// 							Name: to.Ptr("Permissive firewall policy in one of the chains was found"),
	// 							RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTPermissiveFirewallPolicy),
	// 							Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 						},
	// 						{
	// 							Name: to.Ptr("Permissive firewall rule in the input chain was found"),
	// 							RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTPermissiveInputFirewallRules),
	// 							Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 						},
	// 						{
	// 							Name: to.Ptr("Permissive firewall rule in the output chain was found"),
	// 							RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTPermissiveOutputFirewallRules),
	// 							Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 						},
	// 						{
	// 							Name: to.Ptr("High level permissions configured in Edge model twin for Edge module"),
	// 							RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTPrivilegedDockerOptions),
	// 							Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 						},
	// 						{
	// 							Name: to.Ptr("Same Authentication Credentials used by multiple devices"),
	// 							RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTSharedCredentials),
	// 							Status: to.Ptr(armsecurity.RecommendationConfigStatusDisabled),
	// 						},
	// 						{
	// 							Name: to.Ptr("TLS cipher suite upgrade"),
	// 							RecommendationType: to.Ptr(armsecurity.RecommendationTypeIoTVulnerableTLSCipherSuite),
	// 							Status: to.Ptr(armsecurity.RecommendationConfigStatusEnabled),
	// 					}},
	// 					Status: to.Ptr(armsecurity.SecuritySolutionStatusEnabled),
	// 					UnmaskedIPLoggingStatus: to.Ptr(armsecurity.UnmaskedIPLoggingStatusEnabled),
	// 					UserDefinedResources: &armsecurity.UserDefinedResourcesProperties{
	// 						Query: to.Ptr("where type != \"microsoft.devices/iothubs\" | where name contains \"v2\""),
	// 						QuerySubscriptions: []*string{
	// 							to.Ptr("075423e9-7d33-4166-8bdf-3920b04e3735")},
	// 						},
	// 						Workspace: to.Ptr("/subscriptions/c4930e90-cd72-4aa5-93e9-2d081d129569/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace1"),
	// 					},
	// 					SystemData: &armsecurity.SystemData{
	// 						CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-04-27T21:53:29.092Z"); return t}()),
	// 						CreatedBy: to.Ptr("string"),
	// 						CreatedByType: to.Ptr(armsecurity.CreatedByTypeUser),
	// 						LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-04-27T21:53:29.092Z"); return t}()),
	// 						LastModifiedBy: to.Ptr("string"),
	// 						LastModifiedByType: to.Ptr(armsecurity.CreatedByTypeUser),
	// 					},
	// 				}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e716082ac474f182e2220e4f38f1d6191e7636cf/specification/security/resource-manager/Microsoft.Security/stable/2019-08-01/examples/IoTSecuritySolutions/DeleteIoTSecuritySolution.json
func ExampleIotSecuritySolutionClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewIotSecuritySolutionClient().Delete(ctx, "MyGroup", "default", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}
