//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armtrafficmanager

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewEndpointsClient creates a new instance of EndpointsClient.
func (c *ClientFactory) NewEndpointsClient() *EndpointsClient {
	subClient, _ := NewEndpointsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewGeographicHierarchiesClient creates a new instance of GeographicHierarchiesClient.
func (c *ClientFactory) NewGeographicHierarchiesClient() *GeographicHierarchiesClient {
	subClient, _ := NewGeographicHierarchiesClient(c.credential, c.options)
	return subClient
}

// NewHeatMapClient creates a new instance of HeatMapClient.
func (c *ClientFactory) NewHeatMapClient() *HeatMapClient {
	subClient, _ := NewHeatMapClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewProfilesClient creates a new instance of ProfilesClient.
func (c *ClientFactory) NewProfilesClient() *ProfilesClient {
	subClient, _ := NewProfilesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewUserMetricsKeysClient creates a new instance of UserMetricsKeysClient.
func (c *ClientFactory) NewUserMetricsKeysClient() *UserMetricsKeysClient {
	subClient, _ := NewUserMetricsKeysClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
