/*
 * CLOUD API
 *
 *  IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	"encoding/json"
)

// DatacenterPost struct for DatacenterPost
type DatacenterPost struct {
	Properties *DatacenterPropertiesPost `json:"properties"`
	Entities   *DataCenterEntities       `json:"entities,omitempty"`
}

// NewDatacenterPost instantiates a new DatacenterPost object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDatacenterPost(properties DatacenterPropertiesPost) *DatacenterPost {
	this := DatacenterPost{}

	this.Properties = &properties

	return &this
}

// NewDatacenterPostWithDefaults instantiates a new DatacenterPost object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDatacenterPostWithDefaults() *DatacenterPost {
	this := DatacenterPost{}
	return &this
}

// GetProperties returns the Properties field value
// If the value is explicit nil, nil is returned
func (o *DatacenterPost) GetProperties() *DatacenterPropertiesPost {
	if o == nil {
		return nil
	}

	return o.Properties

}

// GetPropertiesOk returns a tuple with the Properties field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *DatacenterPost) GetPropertiesOk() (*DatacenterPropertiesPost, bool) {
	if o == nil {
		return nil, false
	}

	return o.Properties, true
}

// SetProperties sets field value
func (o *DatacenterPost) SetProperties(v DatacenterPropertiesPost) {

	o.Properties = &v

}

// HasProperties returns a boolean if a field has been set.
func (o *DatacenterPost) HasProperties() bool {
	if o != nil && o.Properties != nil {
		return true
	}

	return false
}

// GetEntities returns the Entities field value
// If the value is explicit nil, nil is returned
func (o *DatacenterPost) GetEntities() *DataCenterEntities {
	if o == nil {
		return nil
	}

	return o.Entities

}

// GetEntitiesOk returns a tuple with the Entities field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *DatacenterPost) GetEntitiesOk() (*DataCenterEntities, bool) {
	if o == nil {
		return nil, false
	}

	return o.Entities, true
}

// SetEntities sets field value
func (o *DatacenterPost) SetEntities(v DataCenterEntities) {

	o.Entities = &v

}

// HasEntities returns a boolean if a field has been set.
func (o *DatacenterPost) HasEntities() bool {
	if o != nil && o.Entities != nil {
		return true
	}

	return false
}

func (o DatacenterPost) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Properties != nil {
		toSerialize["properties"] = o.Properties
	}

	if o.Entities != nil {
		toSerialize["entities"] = o.Entities
	}

	return json.Marshal(toSerialize)
}

type NullableDatacenterPost struct {
	value *DatacenterPost
	isSet bool
}

func (v NullableDatacenterPost) Get() *DatacenterPost {
	return v.value
}

func (v *NullableDatacenterPost) Set(val *DatacenterPost) {
	v.value = val
	v.isSet = true
}

func (v NullableDatacenterPost) IsSet() bool {
	return v.isSet
}

func (v *NullableDatacenterPost) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDatacenterPost(val *DatacenterPost) *NullableDatacenterPost {
	return &NullableDatacenterPost{value: val, isSet: true}
}

func (v NullableDatacenterPost) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDatacenterPost) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
