## Highlights


- Added optional support for running GSS-Proxy as an unprivileged user
- Uses new /etc/gss/mech.d  configuration directory for gss mechanisms
- Kernel related fixes
- General bug fixing, many minor errors or incorrect behaviours have been corrected


## Detailed Changelog

Günther Deschner (1):

- Fix potential segfault in gssi_inquire_context().


Lukas Slebodnik (9):

- BUILD: Fix building rpms
- BUILD: Tests did not work from parallel directory
- BUILD: Change ordering of invoking Makefiles
- Suppress clang warning
- Wrong coversion function was used
- Use defined enum instead of constant
- Fix memory leak
- BUILD: Fix building with automake 1.15
- Fix few build issues


Simo Sorce (24):

- Fix config token parsing.
- Add support for dropping privileges
- Add zero termination when the buffer is a string
- Make name conversion more robust to failure
- Add utility functions to read()/write() safely
- Block parent process until child is initialized.
- Properly cleanup mutex on failure.
- Add cmdline option to override default socket
- Add a test framework for gss-proxy
- Zero out the outputs of display_name
- Install gssproxy mechanism config in mech.d
- Generalize GSS Display Status logger code
- Log why acquiring credentials failed.
- Do not open logfile multiple times
- Prevent a backtrace when a subprocess is not found
- Use different env vars bases for gssapi tests
- Really use gss-proxy in tests
- Fix cast error
- Fix error in compiling without SELinux
- Default to systemd initscript in rpm spec file
- Fix variable replacement in non config files
- Properly handle security contexts on error
- Suppress exported_composite_name for the kernel
- Release version 0.4.0


