
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#include "_hypre_IJ_mv.h"

#ifdef HYPRE_MIXED_PRECISION

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/


/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixAdd_pre( HYPRE_Precision precision, hypre_long_double alpha, HYPRE_IJMatrix matrix_A, hypre_long_double beta, HYPRE_IJMatrix matrix_B, HYPRE_IJMatrix *matrix_C )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJMatrixAdd_flt( alpha, matrix_A, beta, matrix_B, matrix_C );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJMatrixAdd_dbl( alpha, matrix_A, beta, matrix_B, matrix_C );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJMatrixAdd_long_dbl( alpha, matrix_A, beta, matrix_B, matrix_C );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixAddToValues_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, const HYPRE_BigInt *rows, const HYPRE_BigInt *cols, const void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJMatrixAddToValues_flt( matrix, nrows, ncols, rows, cols, values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJMatrixAddToValues_dbl( matrix, nrows, ncols, rows, cols, values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJMatrixAddToValues_long_dbl( matrix, nrows, ncols, rows, cols, values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixAddToValues2_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, const HYPRE_BigInt *rows, const HYPRE_Int *row_indexes, const HYPRE_BigInt *cols, const void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJMatrixAddToValues2_flt( matrix, nrows, ncols, rows, row_indexes, cols, values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJMatrixAddToValues2_dbl( matrix, nrows, ncols, rows, row_indexes, cols, values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJMatrixAddToValues2_long_dbl( matrix, nrows, ncols, rows, row_indexes, cols, values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixAssemble_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJMatrixAssemble_flt( matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJMatrixAssemble_dbl( matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJMatrixAssemble_long_dbl( matrix );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_BigInt ilower, HYPRE_BigInt iupper, HYPRE_BigInt jlower, HYPRE_BigInt jupper, HYPRE_IJMatrix *matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJMatrixCreate_flt( comm, ilower, iupper, jlower, jupper, matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJMatrixCreate_dbl( comm, ilower, iupper, jlower, jupper, matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJMatrixCreate_long_dbl( comm, ilower, iupper, jlower, jupper, matrix );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixDestroy_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJMatrixDestroy_flt( matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJMatrixDestroy_dbl( matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJMatrixDestroy_long_dbl( matrix );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixGetGlobalInfo_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_BigInt *global_num_rows, HYPRE_BigInt *global_num_cols, HYPRE_BigInt *global_num_nonzeros )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJMatrixGetGlobalInfo_flt( matrix, global_num_rows, global_num_cols, global_num_nonzeros );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJMatrixGetGlobalInfo_dbl( matrix, global_num_rows, global_num_cols, global_num_nonzeros );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJMatrixGetGlobalInfo_long_dbl( matrix, global_num_rows, global_num_cols, global_num_nonzeros );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixGetLocalRange_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_BigInt *ilower, HYPRE_BigInt *iupper, HYPRE_BigInt *jlower, HYPRE_BigInt *jupper )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJMatrixGetLocalRange_flt( matrix, ilower, iupper, jlower, jupper );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJMatrixGetLocalRange_dbl( matrix, ilower, iupper, jlower, jupper );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJMatrixGetLocalRange_long_dbl( matrix, ilower, iupper, jlower, jupper );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixGetObject_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, void **object )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJMatrixGetObject_flt( matrix, object );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJMatrixGetObject_dbl( matrix, object );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJMatrixGetObject_long_dbl( matrix, object );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixGetObjectType_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_Int *type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJMatrixGetObjectType_flt( matrix, type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJMatrixGetObjectType_dbl( matrix, type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJMatrixGetObjectType_long_dbl( matrix, type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixGetRowCounts_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_BigInt *rows, HYPRE_Int *ncols )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJMatrixGetRowCounts_flt( matrix, nrows, rows, ncols );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJMatrixGetRowCounts_dbl( matrix, nrows, rows, ncols );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJMatrixGetRowCounts_long_dbl( matrix, nrows, rows, ncols );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixGetValues_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, HYPRE_BigInt *rows, HYPRE_BigInt *cols, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJMatrixGetValues_flt( matrix, nrows, ncols, rows, cols, values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJMatrixGetValues_dbl( matrix, nrows, ncols, rows, cols, values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJMatrixGetValues_long_dbl( matrix, nrows, ncols, rows, cols, values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixGetValues2_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, HYPRE_BigInt *rows, HYPRE_Int *row_indexes, HYPRE_BigInt *cols, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJMatrixGetValues2_flt( matrix, nrows, ncols, rows, row_indexes, cols, values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJMatrixGetValues2_dbl( matrix, nrows, ncols, rows, row_indexes, cols, values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJMatrixGetValues2_long_dbl( matrix, nrows, ncols, rows, row_indexes, cols, values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixGetValuesAndZeroOut_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, HYPRE_BigInt *rows, HYPRE_Int *row_indexes, HYPRE_BigInt *cols, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJMatrixGetValuesAndZeroOut_flt( matrix, nrows, ncols, rows, row_indexes, cols, values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJMatrixGetValuesAndZeroOut_dbl( matrix, nrows, ncols, rows, row_indexes, cols, values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJMatrixGetValuesAndZeroOut_long_dbl( matrix, nrows, ncols, rows, row_indexes, cols, values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixInitialize_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJMatrixInitialize_flt( matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJMatrixInitialize_dbl( matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJMatrixInitialize_long_dbl( matrix );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixInitialize_v2_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_MemoryLocation memory_location )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJMatrixInitialize_v2_flt( matrix, memory_location );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJMatrixInitialize_v2_dbl( matrix, memory_location );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJMatrixInitialize_v2_long_dbl( matrix, memory_location );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixMigrate_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_MemoryLocation memory_location )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJMatrixMigrate_flt( matrix, memory_location );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJMatrixMigrate_dbl( matrix, memory_location );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJMatrixMigrate_long_dbl( matrix, memory_location );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixNorm_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, void *norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJMatrixNorm_flt( matrix, norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJMatrixNorm_dbl( matrix, norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJMatrixNorm_long_dbl( matrix, norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixPartialClone_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix_in, HYPRE_IJMatrix *matrix_out )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJMatrixPartialClone_flt( matrix_in, matrix_out );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJMatrixPartialClone_dbl( matrix_in, matrix_out );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJMatrixPartialClone_long_dbl( matrix_in, matrix_out );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixPrint_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, const char *filename )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJMatrixPrint_flt( matrix, filename );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJMatrixPrint_dbl( matrix, filename );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJMatrixPrint_long_dbl( matrix, filename );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixPrintBinary_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, const char *filename )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJMatrixPrintBinary_flt( matrix, filename );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJMatrixPrintBinary_dbl( matrix, filename );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJMatrixPrintBinary_long_dbl( matrix, filename );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixRead_pre( HYPRE_Precision precision, const char *filename, MPI_Comm comm, HYPRE_Int type, HYPRE_IJMatrix *matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJMatrixRead_flt( filename, comm, type, matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJMatrixRead_dbl( filename, comm, type, matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJMatrixRead_long_dbl( filename, comm, type, matrix );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixReadBinary_pre( HYPRE_Precision precision, const char *filename, MPI_Comm comm, HYPRE_Int type, HYPRE_IJMatrix *matrix_ptr )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJMatrixReadBinary_flt( filename, comm, type, matrix_ptr );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJMatrixReadBinary_dbl( filename, comm, type, matrix_ptr );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJMatrixReadBinary_long_dbl( filename, comm, type, matrix_ptr );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixReadMM_pre( HYPRE_Precision precision, const char *filename, MPI_Comm comm, HYPRE_Int type, HYPRE_IJMatrix *matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJMatrixReadMM_flt( filename, comm, type, matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJMatrixReadMM_dbl( filename, comm, type, matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJMatrixReadMM_long_dbl( filename, comm, type, matrix );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixSetConstantValues_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, hypre_long_double value )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJMatrixSetConstantValues_flt( matrix, value );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJMatrixSetConstantValues_dbl( matrix, value );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJMatrixSetConstantValues_long_dbl( matrix, value );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixSetDiagOffdSizes_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, const HYPRE_Int *diag_sizes, const HYPRE_Int *offdiag_sizes )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJMatrixSetDiagOffdSizes_flt( matrix, diag_sizes, offdiag_sizes );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJMatrixSetDiagOffdSizes_dbl( matrix, diag_sizes, offdiag_sizes );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJMatrixSetDiagOffdSizes_long_dbl( matrix, diag_sizes, offdiag_sizes );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixSetEarlyAssemble_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_Int early_assemble )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJMatrixSetEarlyAssemble_flt( matrix, early_assemble );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJMatrixSetEarlyAssemble_dbl( matrix, early_assemble );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJMatrixSetEarlyAssemble_long_dbl( matrix, early_assemble );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixSetGrowFactor_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, hypre_long_double factor )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJMatrixSetGrowFactor_flt( matrix, factor );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJMatrixSetGrowFactor_dbl( matrix, factor );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJMatrixSetGrowFactor_long_dbl( matrix, factor );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixSetInitAllocation_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_Int factor )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJMatrixSetInitAllocation_flt( matrix, factor );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJMatrixSetInitAllocation_dbl( matrix, factor );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJMatrixSetInitAllocation_long_dbl( matrix, factor );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixSetMaxOffProcElmts_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_Int max_off_proc_elmts )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJMatrixSetMaxOffProcElmts_flt( matrix, max_off_proc_elmts );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJMatrixSetMaxOffProcElmts_dbl( matrix, max_off_proc_elmts );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJMatrixSetMaxOffProcElmts_long_dbl( matrix, max_off_proc_elmts );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixSetOMPFlag_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_Int omp_flag )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJMatrixSetOMPFlag_flt( matrix, omp_flag );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJMatrixSetOMPFlag_dbl( matrix, omp_flag );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJMatrixSetOMPFlag_long_dbl( matrix, omp_flag );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixSetObjectType_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_Int type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJMatrixSetObjectType_flt( matrix, type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJMatrixSetObjectType_dbl( matrix, type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJMatrixSetObjectType_long_dbl( matrix, type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_Int print_level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJMatrixSetPrintLevel_flt( matrix, print_level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJMatrixSetPrintLevel_dbl( matrix, print_level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJMatrixSetPrintLevel_long_dbl( matrix, print_level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixSetRowSizes_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, const HYPRE_Int *sizes )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJMatrixSetRowSizes_flt( matrix, sizes );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJMatrixSetRowSizes_dbl( matrix, sizes );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJMatrixSetRowSizes_long_dbl( matrix, sizes );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixSetValues_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, const HYPRE_BigInt *rows, const HYPRE_BigInt *cols, const void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJMatrixSetValues_flt( matrix, nrows, ncols, rows, cols, values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJMatrixSetValues_dbl( matrix, nrows, ncols, rows, cols, values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJMatrixSetValues_long_dbl( matrix, nrows, ncols, rows, cols, values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixSetValues2_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix, HYPRE_Int nrows, HYPRE_Int *ncols, const HYPRE_BigInt *rows, const HYPRE_Int *row_indexes, const HYPRE_BigInt *cols, const void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJMatrixSetValues2_flt( matrix, nrows, ncols, rows, row_indexes, cols, values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJMatrixSetValues2_dbl( matrix, nrows, ncols, rows, row_indexes, cols, values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJMatrixSetValues2_long_dbl( matrix, nrows, ncols, rows, row_indexes, cols, values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJMatrixTranspose_pre( HYPRE_Precision precision, HYPRE_IJMatrix matrix_A, HYPRE_IJMatrix *matrix_AT )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJMatrixTranspose_flt( matrix_A, matrix_AT );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJMatrixTranspose_dbl( matrix_A, matrix_AT );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJMatrixTranspose_long_dbl( matrix_A, matrix_AT );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorAddToValues_pre( HYPRE_Precision precision, HYPRE_IJVector vector, HYPRE_Int nvalues, const HYPRE_BigInt *indices, const void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJVectorAddToValues_flt( vector, nvalues, indices, values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJVectorAddToValues_dbl( vector, nvalues, indices, values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJVectorAddToValues_long_dbl( vector, nvalues, indices, values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorAssemble_pre( HYPRE_Precision precision, HYPRE_IJVector vector )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJVectorAssemble_flt( vector );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJVectorAssemble_dbl( vector );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJVectorAssemble_long_dbl( vector );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_BigInt jlower, HYPRE_BigInt jupper, HYPRE_IJVector *vector )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJVectorCreate_flt( comm, jlower, jupper, vector );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJVectorCreate_dbl( comm, jlower, jupper, vector );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJVectorCreate_long_dbl( comm, jlower, jupper, vector );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorDestroy_pre( HYPRE_Precision precision, HYPRE_IJVector vector )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJVectorDestroy_flt( vector );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJVectorDestroy_dbl( vector );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJVectorDestroy_long_dbl( vector );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorGetLocalRange_pre( HYPRE_Precision precision, HYPRE_IJVector vector, HYPRE_BigInt *jlower, HYPRE_BigInt *jupper )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJVectorGetLocalRange_flt( vector, jlower, jupper );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJVectorGetLocalRange_dbl( vector, jlower, jupper );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJVectorGetLocalRange_long_dbl( vector, jlower, jupper );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorGetObject_pre( HYPRE_Precision precision, HYPRE_IJVector vector, void **object )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJVectorGetObject_flt( vector, object );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJVectorGetObject_dbl( vector, object );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJVectorGetObject_long_dbl( vector, object );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorGetObjectType_pre( HYPRE_Precision precision, HYPRE_IJVector vector, HYPRE_Int *type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJVectorGetObjectType_flt( vector, type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJVectorGetObjectType_dbl( vector, type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJVectorGetObjectType_long_dbl( vector, type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorGetValues_pre( HYPRE_Precision precision, HYPRE_IJVector vector, HYPRE_Int nvalues, const HYPRE_BigInt *indices, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJVectorGetValues_flt( vector, nvalues, indices, values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJVectorGetValues_dbl( vector, nvalues, indices, values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJVectorGetValues_long_dbl( vector, nvalues, indices, values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorInitialize_pre( HYPRE_Precision precision, HYPRE_IJVector vector )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJVectorInitialize_flt( vector );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJVectorInitialize_dbl( vector );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJVectorInitialize_long_dbl( vector );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorInitializeShell_pre( HYPRE_Precision precision, HYPRE_IJVector vector )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJVectorInitializeShell_flt( vector );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJVectorInitializeShell_dbl( vector );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJVectorInitializeShell_long_dbl( vector );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorInitialize_v2_pre( HYPRE_Precision precision, HYPRE_IJVector vector, HYPRE_MemoryLocation memory_location )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJVectorInitialize_v2_flt( vector, memory_location );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJVectorInitialize_v2_dbl( vector, memory_location );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJVectorInitialize_v2_long_dbl( vector, memory_location );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorInnerProd_pre( HYPRE_Precision precision, HYPRE_IJVector x, HYPRE_IJVector y, void *prod )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJVectorInnerProd_flt( x, y, prod );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJVectorInnerProd_dbl( x, y, prod );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJVectorInnerProd_long_dbl( x, y, prod );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorMigrate_pre( HYPRE_Precision precision, HYPRE_IJVector vector, HYPRE_MemoryLocation memory_location )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJVectorMigrate_flt( vector, memory_location );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJVectorMigrate_dbl( vector, memory_location );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJVectorMigrate_long_dbl( vector, memory_location );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorPrint_pre( HYPRE_Precision precision, HYPRE_IJVector vector, const char *filename )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJVectorPrint_flt( vector, filename );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJVectorPrint_dbl( vector, filename );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJVectorPrint_long_dbl( vector, filename );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorPrintBinary_pre( HYPRE_Precision precision, HYPRE_IJVector vector, const char *filename )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJVectorPrintBinary_flt( vector, filename );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJVectorPrintBinary_dbl( vector, filename );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJVectorPrintBinary_long_dbl( vector, filename );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorRead_pre( HYPRE_Precision precision, const char *filename, MPI_Comm comm, HYPRE_Int type, HYPRE_IJVector *vector )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJVectorRead_flt( filename, comm, type, vector );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJVectorRead_dbl( filename, comm, type, vector );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJVectorRead_long_dbl( filename, comm, type, vector );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorReadBinary_pre( HYPRE_Precision precision, const char *filename, MPI_Comm comm, HYPRE_Int type, HYPRE_IJVector *vector )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJVectorReadBinary_flt( filename, comm, type, vector );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJVectorReadBinary_dbl( filename, comm, type, vector );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJVectorReadBinary_long_dbl( filename, comm, type, vector );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorSetComponent_pre( HYPRE_Precision precision, HYPRE_IJVector vector, HYPRE_Int component )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJVectorSetComponent_flt( vector, component );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJVectorSetComponent_dbl( vector, component );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJVectorSetComponent_long_dbl( vector, component );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorSetConstantValues_pre( HYPRE_Precision precision, HYPRE_IJVector vector, hypre_long_double value )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJVectorSetConstantValues_flt( vector, value );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJVectorSetConstantValues_dbl( vector, value );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJVectorSetConstantValues_long_dbl( vector, value );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorSetData_pre( HYPRE_Precision precision, HYPRE_IJVector vector, void *data )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJVectorSetData_flt( vector, data );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJVectorSetData_dbl( vector, data );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJVectorSetData_long_dbl( vector, data );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorSetMaxOffProcElmts_pre( HYPRE_Precision precision, HYPRE_IJVector vector, HYPRE_Int max_off_proc_elmts )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJVectorSetMaxOffProcElmts_flt( vector, max_off_proc_elmts );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJVectorSetMaxOffProcElmts_dbl( vector, max_off_proc_elmts );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJVectorSetMaxOffProcElmts_long_dbl( vector, max_off_proc_elmts );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorSetNumComponents_pre( HYPRE_Precision precision, HYPRE_IJVector vector, HYPRE_Int num_components )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJVectorSetNumComponents_flt( vector, num_components );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJVectorSetNumComponents_dbl( vector, num_components );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJVectorSetNumComponents_long_dbl( vector, num_components );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorSetObjectType_pre( HYPRE_Precision precision, HYPRE_IJVector vector, HYPRE_Int type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJVectorSetObjectType_flt( vector, type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJVectorSetObjectType_dbl( vector, type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJVectorSetObjectType_long_dbl( vector, type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_IJVector vector, HYPRE_Int print_level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJVectorSetPrintLevel_flt( vector, print_level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJVectorSetPrintLevel_dbl( vector, print_level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJVectorSetPrintLevel_long_dbl( vector, print_level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorSetTags_pre( HYPRE_Precision precision, HYPRE_IJVector vector, HYPRE_Int owns_tags, HYPRE_Int num_tags, HYPRE_Int *tags )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJVectorSetTags_flt( vector, owns_tags, num_tags, tags );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJVectorSetTags_dbl( vector, owns_tags, num_tags, tags );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJVectorSetTags_long_dbl( vector, owns_tags, num_tags, tags );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorSetValues_pre( HYPRE_Precision precision, HYPRE_IJVector vector, HYPRE_Int nvalues, const HYPRE_BigInt *indices, const void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJVectorSetValues_flt( vector, nvalues, indices, values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJVectorSetValues_dbl( vector, nvalues, indices, values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJVectorSetValues_long_dbl( vector, nvalues, indices, values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_IJVectorUpdateValues_pre( HYPRE_Precision precision, HYPRE_IJVector vector, HYPRE_Int nvalues, const HYPRE_BigInt *indices, const void *values, HYPRE_Int action )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_IJVectorUpdateValues_flt( vector, nvalues, indices, values, action );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_IJVectorUpdateValues_dbl( vector, nvalues, indices, values, action );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_IJVectorUpdateValues_long_dbl( vector, nvalues, indices, values, action );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}



#endif

