
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#include "_hypre_sstruct_mv.h"

#ifdef HYPRE_MIXED_PRECISION

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/


/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructAxpy( hypre_long_double alpha, HYPRE_SStructVector x, HYPRE_SStructVector y )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructAxpy_pre( precision, alpha, x, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGraphAddEntries( HYPRE_SStructGraph graph, HYPRE_Int part, HYPRE_Int *index, HYPRE_Int var, HYPRE_Int to_part, HYPRE_Int *to_index, HYPRE_Int to_var )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGraphAddEntries_pre( precision, graph, part, index, var, to_part, to_index, to_var );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGraphAssemble( HYPRE_SStructGraph graph )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGraphAssemble_pre( precision, graph );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGraphCreate( MPI_Comm comm, HYPRE_SStructGrid grid, HYPRE_SStructGraph *graph )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGraphCreate_pre( precision, comm, grid, graph );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGraphDestroy( HYPRE_SStructGraph graph )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGraphDestroy_pre( precision, graph );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGraphPrint( FILE *file, HYPRE_SStructGraph graph )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGraphPrint_pre( precision, file, graph );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGraphRead( FILE *file, HYPRE_SStructGrid grid, HYPRE_SStructStencil **stencils, HYPRE_SStructGraph *graph_ptr )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGraphRead_pre( precision, file, grid, stencils, graph_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGraphSetDomainGrid( HYPRE_SStructGraph graph, HYPRE_SStructGrid domain_grid )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGraphSetDomainGrid_pre( precision, graph, domain_grid );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGraphSetFEM( HYPRE_SStructGraph graph, HYPRE_Int part )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGraphSetFEM_pre( precision, graph, part );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGraphSetFEMSparsity( HYPRE_SStructGraph graph, HYPRE_Int part, HYPRE_Int nsparse, HYPRE_Int *sparsity )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGraphSetFEMSparsity_pre( precision, graph, part, nsparse, sparsity );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGraphSetObjectType( HYPRE_SStructGraph graph, HYPRE_Int type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGraphSetObjectType_pre( precision, graph, type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGraphSetStencil( HYPRE_SStructGraph graph, HYPRE_Int part, HYPRE_Int var, HYPRE_SStructStencil stencil )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGraphSetStencil_pre( precision, graph, part, var, stencil );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGridAddVariables( HYPRE_SStructGrid grid, HYPRE_Int part, HYPRE_Int *index, HYPRE_Int nvars, HYPRE_SStructVariable *vartypes )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGridAddVariables_pre( precision, grid, part, index, nvars, vartypes );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGridAssemble( HYPRE_SStructGrid grid )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGridAssemble_pre( precision, grid );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGridCoarsen( HYPRE_SStructGrid fgrid, HYPRE_Index *strides, HYPRE_SStructGrid *cgrid )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGridCoarsen_pre( precision, fgrid, strides, cgrid );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGridCreate( MPI_Comm comm, HYPRE_Int ndim, HYPRE_Int nparts, HYPRE_SStructGrid *grid )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGridCreate_pre( precision, comm, ndim, nparts, grid );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGridDestroy( HYPRE_SStructGrid grid )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGridDestroy_pre( precision, grid );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGridGetVariableBox( HYPRE_SStructGrid grid, HYPRE_Int part, HYPRE_Int var, HYPRE_Int *cell_ilower, HYPRE_Int *cell_iupper, HYPRE_Int *var_ilower, HYPRE_Int *var_iupper )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGridGetVariableBox_pre( precision, grid, part, var, cell_ilower, cell_iupper, var_ilower, var_iupper );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGridPrintGLVis( HYPRE_SStructGrid grid, const char *meshprefix, void *trans, void *origin )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGridPrintGLVis_pre( precision, grid, meshprefix, trans, origin );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGridProjectBox( HYPRE_SStructGrid grid, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int *origin, HYPRE_Int *stride )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGridProjectBox_pre( precision, grid, ilower, iupper, origin, stride );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGridSetExtents( HYPRE_SStructGrid grid, HYPRE_Int part, HYPRE_Int *ilower, HYPRE_Int *iupper )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGridSetExtents_pre( precision, grid, part, ilower, iupper );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGridSetFEMOrdering( HYPRE_SStructGrid grid, HYPRE_Int part, HYPRE_Int *ordering )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGridSetFEMOrdering_pre( precision, grid, part, ordering );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGridSetNeighborPart( HYPRE_SStructGrid grid, HYPRE_Int part, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int nbor_part, HYPRE_Int *nbor_ilower, HYPRE_Int *nbor_iupper, HYPRE_Int *index_map, HYPRE_Int *index_dir )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGridSetNeighborPart_pre( precision, grid, part, ilower, iupper, nbor_part, nbor_ilower, nbor_iupper, index_map, index_dir );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGridSetNumGhost( HYPRE_SStructGrid grid, HYPRE_Int *num_ghost )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGridSetNumGhost_pre( precision, grid, num_ghost );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGridSetPeriodic( HYPRE_SStructGrid grid, HYPRE_Int part, HYPRE_Int *periodic )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGridSetPeriodic_pre( precision, grid, part, periodic );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGridSetSharedPart( HYPRE_SStructGrid grid, HYPRE_Int part, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int *offset, HYPRE_Int shared_part, HYPRE_Int *shared_ilower, HYPRE_Int *shared_iupper, HYPRE_Int *shared_offset, HYPRE_Int *index_map, HYPRE_Int *index_dir )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGridSetSharedPart_pre( precision, grid, part, ilower, iupper, offset, shared_part, shared_ilower, shared_iupper, shared_offset, index_map, index_dir );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGridSetVariables( HYPRE_SStructGrid grid, HYPRE_Int part, HYPRE_Int nvars, HYPRE_SStructVariable *vartypes )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGridSetVariables_pre( precision, grid, part, nvars, vartypes );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructInnerProd( HYPRE_SStructVector x, HYPRE_SStructVector y, void *result )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructInnerProd_pre( precision, x, y, result );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixAddFEMBoxValues( HYPRE_SStructMatrix matrix, HYPRE_Int part, HYPRE_Int *ilower, HYPRE_Int *iupper, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructMatrixAddFEMBoxValues_pre( precision, matrix, part, ilower, iupper, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixAddFEMValues( HYPRE_SStructMatrix matrix, HYPRE_Int part, HYPRE_Int *index, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructMatrixAddFEMValues_pre( precision, matrix, part, index, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixAddToBoxValues( HYPRE_SStructMatrix matrix, HYPRE_Int part, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructMatrixAddToBoxValues_pre( precision, matrix, part, ilower, iupper, var, nentries, entries, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixAddToBoxValues2( HYPRE_SStructMatrix matrix, HYPRE_Int part, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, HYPRE_Int *vilower, HYPRE_Int *viupper, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructMatrixAddToBoxValues2_pre( precision, matrix, part, ilower, iupper, var, nentries, entries, vilower, viupper, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixAddToValues( HYPRE_SStructMatrix matrix, HYPRE_Int part, HYPRE_Int *index, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructMatrixAddToValues_pre( precision, matrix, part, index, var, nentries, entries, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixAssemble( HYPRE_SStructMatrix matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructMatrixAssemble_pre( precision, matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixCreate( MPI_Comm comm, HYPRE_SStructGraph graph, HYPRE_SStructMatrix *matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructMatrixCreate_pre( precision, comm, graph, matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixDestroy( HYPRE_SStructMatrix matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructMatrixDestroy_pre( precision, matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixGetBoxValues( HYPRE_SStructMatrix matrix, HYPRE_Int part, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructMatrixGetBoxValues_pre( precision, matrix, part, ilower, iupper, var, nentries, entries, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixGetBoxValues2( HYPRE_SStructMatrix matrix, HYPRE_Int part, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, HYPRE_Int *vilower, HYPRE_Int *viupper, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructMatrixGetBoxValues2_pre( precision, matrix, part, ilower, iupper, var, nentries, entries, vilower, viupper, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixGetFEMValues( HYPRE_SStructMatrix matrix, HYPRE_Int part, HYPRE_Int *index, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructMatrixGetFEMValues_pre( precision, matrix, part, index, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixGetGrid( HYPRE_SStructMatrix matrix, HYPRE_SStructGrid *grid )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructMatrixGetGrid_pre( precision, matrix, grid );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixGetObject( HYPRE_SStructMatrix matrix, void **object )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructMatrixGetObject_pre( precision, matrix, object );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixGetValues( HYPRE_SStructMatrix matrix, HYPRE_Int part, HYPRE_Int *index, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructMatrixGetValues_pre( precision, matrix, part, index, var, nentries, entries, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixInitialize( HYPRE_SStructMatrix matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructMatrixInitialize_pre( precision, matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixMatmat( HYPRE_SStructMatrix A, HYPRE_SStructMatrix B, HYPRE_SStructMatrix *C )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructMatrixMatmat_pre( precision, A, B, C );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixMatvec( hypre_long_double alpha, HYPRE_SStructMatrix A, HYPRE_SStructVector x, hypre_long_double beta, HYPRE_SStructVector y )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructMatrixMatvec_pre( precision, alpha, A, x, beta, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixPrint( const char *filename, HYPRE_SStructMatrix matrix, HYPRE_Int all )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructMatrixPrint_pre( precision, filename, matrix, all );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixRead( MPI_Comm comm, const char *filename, HYPRE_SStructMatrix *matrix_ptr )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructMatrixRead_pre( precision, comm, filename, matrix_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixSetBoxValues( HYPRE_SStructMatrix matrix, HYPRE_Int part, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructMatrixSetBoxValues_pre( precision, matrix, part, ilower, iupper, var, nentries, entries, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixSetBoxValues2( HYPRE_SStructMatrix matrix, HYPRE_Int part, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, HYPRE_Int *vilower, HYPRE_Int *viupper, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructMatrixSetBoxValues2_pre( precision, matrix, part, ilower, iupper, var, nentries, entries, vilower, viupper, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixSetConstantEntries( HYPRE_SStructMatrix matrix, HYPRE_Int part, HYPRE_Int var, HYPRE_Int to_var, HYPRE_Int nentries, HYPRE_Int *centries )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructMatrixSetConstantEntries_pre( precision, matrix, part, var, to_var, nentries, centries );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixSetDomainStride( HYPRE_SStructMatrix matrix, HYPRE_Int part, HYPRE_Int *dom_stride )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructMatrixSetDomainStride_pre( precision, matrix, part, dom_stride );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixSetEarlyAssemble( HYPRE_SStructMatrix matrix, HYPRE_Int early_assemble )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructMatrixSetEarlyAssemble_pre( precision, matrix, early_assemble );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixSetNSSymmetric( HYPRE_SStructMatrix matrix, HYPRE_Int symmetric )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructMatrixSetNSSymmetric_pre( precision, matrix, symmetric );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixSetObjectType( HYPRE_SStructMatrix matrix, HYPRE_Int type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructMatrixSetObjectType_pre( precision, matrix, type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixSetRangeStride( HYPRE_SStructMatrix matrix, HYPRE_Int part, HYPRE_Int *ran_stride )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructMatrixSetRangeStride_pre( precision, matrix, part, ran_stride );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixSetSymmetric( HYPRE_SStructMatrix matrix, HYPRE_Int part, HYPRE_Int var, HYPRE_Int to_var, HYPRE_Int symmetric )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructMatrixSetSymmetric_pre( precision, matrix, part, var, to_var, symmetric );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixSetValues( HYPRE_SStructMatrix matrix, HYPRE_Int part, HYPRE_Int *index, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructMatrixSetValues_pre( precision, matrix, part, index, var, nentries, entries, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixToIJMatrix( HYPRE_SStructMatrix matrix, HYPRE_Int fill_diagonal, HYPRE_IJMatrix *ijmatrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructMatrixToIJMatrix_pre( precision, matrix, fill_diagonal, ijmatrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructStencilCreate( HYPRE_Int ndim, HYPRE_Int size, HYPRE_SStructStencil *stencil )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructStencilCreate_pre( precision, ndim, size, stencil );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructStencilDestroy( HYPRE_SStructStencil stencil )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructStencilDestroy_pre( precision, stencil );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructStencilPrint( FILE *file, HYPRE_SStructStencil stencil )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructStencilPrint_pre( precision, file, stencil );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructStencilRead( FILE *file, HYPRE_SStructStencil *stencil_ptr )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructStencilRead_pre( precision, file, stencil_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructStencilSetEntry( HYPRE_SStructStencil stencil, HYPRE_Int entry, HYPRE_Int *offset, HYPRE_Int var )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructStencilSetEntry_pre( precision, stencil, entry, offset, var );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorAddFEMBoxValues( HYPRE_SStructVector vector, HYPRE_Int part, HYPRE_Int *ilower, HYPRE_Int *iupper, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructVectorAddFEMBoxValues_pre( precision, vector, part, ilower, iupper, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorAddFEMValues( HYPRE_SStructVector vector, HYPRE_Int part, HYPRE_Int *index, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructVectorAddFEMValues_pre( precision, vector, part, index, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorAddToBoxValues( HYPRE_SStructVector vector, HYPRE_Int part, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int var, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructVectorAddToBoxValues_pre( precision, vector, part, ilower, iupper, var, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorAddToBoxValues2( HYPRE_SStructVector vector, HYPRE_Int part, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int var, HYPRE_Int *vilower, HYPRE_Int *viupper, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructVectorAddToBoxValues2_pre( precision, vector, part, ilower, iupper, var, vilower, viupper, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorAddToValues( HYPRE_SStructVector vector, HYPRE_Int part, HYPRE_Int *index, HYPRE_Int var, void *value )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructVectorAddToValues_pre( precision, vector, part, index, var, value );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorAssemble( HYPRE_SStructVector vector )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructVectorAssemble_pre( precision, vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorAxpy( hypre_long_double alpha, HYPRE_SStructVector x, HYPRE_SStructVector y )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructVectorAxpy_pre( precision, alpha, x, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorCopy( HYPRE_SStructVector x, HYPRE_SStructVector y )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructVectorCopy_pre( precision, x, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorCreate( MPI_Comm comm, HYPRE_SStructGrid grid, HYPRE_SStructVector *vector )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructVectorCreate_pre( precision, comm, grid, vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorDestroy( HYPRE_SStructVector vector )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructVectorDestroy_pre( precision, vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorGather( HYPRE_SStructVector vector )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructVectorGather_pre( precision, vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorGetBoxValues( HYPRE_SStructVector vector, HYPRE_Int part, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int var, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructVectorGetBoxValues_pre( precision, vector, part, ilower, iupper, var, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorGetBoxValues2( HYPRE_SStructVector vector, HYPRE_Int part, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int var, HYPRE_Int *vilower, HYPRE_Int *viupper, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructVectorGetBoxValues2_pre( precision, vector, part, ilower, iupper, var, vilower, viupper, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorGetFEMValues( HYPRE_SStructVector vector, HYPRE_Int part, HYPRE_Int *index, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructVectorGetFEMValues_pre( precision, vector, part, index, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorGetObject( HYPRE_SStructVector vector, void **object )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructVectorGetObject_pre( precision, vector, object );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorGetValues( HYPRE_SStructVector vector, HYPRE_Int part, HYPRE_Int *index, HYPRE_Int var, void *value )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructVectorGetValues_pre( precision, vector, part, index, var, value );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorInitialize( HYPRE_SStructVector vector )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructVectorInitialize_pre( precision, vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorInnerProd( HYPRE_SStructVector x, HYPRE_SStructVector y, void *result )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructVectorInnerProd_pre( precision, x, y, result );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorPrint( const char *filename, HYPRE_SStructVector vector, HYPRE_Int all )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructVectorPrint_pre( precision, filename, vector, all );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorPrintGLVis( HYPRE_SStructVector vector, const char *fileprefix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructVectorPrintGLVis_pre( precision, vector, fileprefix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorRead( MPI_Comm comm, const char *filename, HYPRE_SStructVector *vector_ptr )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructVectorRead_pre( precision, comm, filename, vector_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorScale( hypre_long_double alpha, HYPRE_SStructVector y )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructVectorScale_pre( precision, alpha, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorSetBoxValues( HYPRE_SStructVector vector, HYPRE_Int part, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int var, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructVectorSetBoxValues_pre( precision, vector, part, ilower, iupper, var, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorSetBoxValues2( HYPRE_SStructVector vector, HYPRE_Int part, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int var, HYPRE_Int *vilower, HYPRE_Int *viupper, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructVectorSetBoxValues2_pre( precision, vector, part, ilower, iupper, var, vilower, viupper, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorSetConstantValues( HYPRE_SStructVector vector, hypre_long_double value )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructVectorSetConstantValues_pre( precision, vector, value );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorSetObjectType( HYPRE_SStructVector vector, HYPRE_Int type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructVectorSetObjectType_pre( precision, vector, type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorSetRandomValues( HYPRE_SStructVector vector, HYPRE_Int seed )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructVectorSetRandomValues_pre( precision, vector, seed );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorSetValues( HYPRE_SStructVector vector, HYPRE_Int part, HYPRE_Int *index, HYPRE_Int var, void *value )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructVectorSetValues_pre( precision, vector, part, index, var, value );
}



#endif

